/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.TrainingMaterialDownloads;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingConfigService;
import com.ovopark.training.service.TrainingMaterialNewService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.TrainingQuestionService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.TrainingMaterialCommentVo;
import com.ovopark.training.vo.TrainingMaterialDownloadsVo;
import com.ovopark.training.vo.TrainingMaterialPowerVo;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import com.ovopark.training.vo.TrainingMaterialVersionVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.VideoCompressionVo;
import com.ovopark.training.vo.VideoDataVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/material"})
public class TrainingMaterialController {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialController.class);
    @Autowired
    private TrainingMaterialService materialService;
    @Autowired
    private TrainingQuestionService trainingQuestionService;
    @Autowired
    private TrainingCommonService commonService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingConfigService trainingConfigService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private TrainingMaterialNewService trainingMaterialNewService;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;

    @RequestMapping(value={"/handleOldQuestion"})
    @ResponseBody
    public String handleOldQuestion(String enterpriseIds) {
        try {
            List<Integer> enterpriseIdList = new ArrayList<Integer>();
            if (!StringUtils.isEmpty((Object)enterpriseIds)) {
                enterpriseIdList = Arrays.stream(enterpriseIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
            }
            Users user = Authenticator.getInstance().getCurrentUser();
            this.materialService.handleOldQuestion(enterpriseIdList, user);
        }
        catch (Exception e) {
            log.error("\u5237\u9898\u5e93\u8001\u6570\u636e\u5230\u9ed8\u8ba4\u5206\u7c7b\u5931\u8d25", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getMaterialByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialByPage(Page<TrainingMaterialVo> page, String materialId, Integer materialTypeId, String materialName, String creaters, String startTime, String endTime, Integer isUsing, Integer isCommodity, Integer isChild, Integer fileType, Integer isShow) {
        List<Integer> materialIds;
        List<Integer> creater;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            creater = new ArrayList<Integer>();
            if (creaters != null) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            materialIds = null;
            if (materialId != null) {
                String[] materialIdStr = materialId.split(",");
                List<String> materialIdS = Arrays.asList(materialIdStr);
                materialIds = materialIdS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
        } else {
            return "INVALID_TOKEN";
        }
        page = this.materialService.getMaterialByPage(page, user, materialIds, materialTypeId, materialName, creater, startTime, endTime, isUsing, isCommodity, isChild, fileType, isShow);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getMaterialList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialList(String materialId, Integer materialTypeId, String materialName, String creaters, String startTime, String endTime, Integer isUsing, Integer isCommodity) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            List<Integer> creater = new ArrayList<Integer>();
            if (creaters != null) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            List materialIds = null;
            if (materialId != null) {
                String[] materialIdStr = materialId.split(",");
                List<String> materialIdS = Arrays.asList(materialIdStr);
                materialIds = materialIdS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            List<TrainingMaterialVo> list = this.materialService.getMaterialList(user, materialIds, materialTypeId, materialName, creater, startTime, endTime, isUsing, isCommodity);
            return JsonResult.success(list);
        }
        return "INVALID_TOKEN";
    }

    @Deprecated
    @RequestMapping(value={"/insertMaterial"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertMaterial(@RequestBody List<TrainingMaterialVo> material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.materialService.insertMaterial(material, user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateMaterialConfig"})
    @ResponseBody
    public String updateMaterialConfig(@RequestBody List<TrainingMaterialVo> material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.materialService.updateMaterialConfig(material, user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateMaterialSize"})
    @ResponseBody
    public String updateMaterialSize(@RequestBody VideoCompressionVo vo) {
        log.info("\u89c6\u9891\u538b\u7f29\u56de\u8c03\u53c2\u6570", (Object)vo);
        if (!ObjectUtils.isEmpty((Object)vo.getData())) {
            VideoDataVo data = vo.getData();
            TrainingMaterial material = new TrainingMaterial();
            String str = data.getUuid();
            if (!StringUtils.isEmpty((Object)str)) {
                String[] mater = str.split("_");
                Integer materialId = Integer.valueOf(mater[0]);
                material.setId(materialId);
                material.setIsUsing(Integer.valueOf(1));
                material.setSize(data.getSize());
                material.setMaterialPath(data.getPath());
                this.materialService.updateMaterialSize(material);
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/delMaterial"})
    @ResponseBody
    public String delMaterial(HttpServletRequest req, @RequestBody List<TrainingMaterial> material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.materialService.delMaterial(material, user, req);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getInsertPower"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getInsertPower(@RequestBody TrainingMaterialType materialType) {
        return JsonResult.success((Object)"1");
    }

    @RequestMapping(value={"/getManagerPower"})
    @ResponseBody
    public String getManagerPower() {
        String isShow = "0";
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            boolean global = this.materialPermissionFacade.validGlobal(user, 3);
            if (global) {
                isShow = "1";
            }
        } else {
            return "INVALID_TOKEN";
        }
        return JsonResult.success((Object)isShow);
    }

    @RequestMapping(value={"/getMaterialTypeByName"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialTypeByName(Page<TrainingMaterialTypeVo> page, TrainingMaterialTypeVo materialType) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (materialType.getModuleType().compareTo(6) != 0) {
                materialType.setEnterpriseId(user.getGroupId());
            }
            page = this.materialService.getMaterialTypeByPage(page, materialType, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/moveMaterialType"})
    @ResponseBody
    public String moveMaterialType(@RequestParam(value="currentId") Integer currentId, @RequestParam(value="targetId") Integer targetId, @RequestParam(value="isFirst") Integer isFirst) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getId())) {
            return JsonResult.invalidAccessToken();
        }
        return this.materialService.moveMaterialType(currentId, targetId, isFirst, user);
    }

    @RequestMapping(value={"/getLastLevel"})
    @ResponseBody
    public String getLastLevel(@RequestParam(value="id") Integer id) {
        return JsonResult.success((Object)this.materialService.getLastLevel(id));
    }

    @RequestMapping(value={"/getMaterialTypeNew"})
    @ResponseBody
    public String getMaterialTypeNew(TrainingMaterialTypeVo materialType) {
        List<Object> materialTypeList = new ArrayList();
        Users user = Authenticator.getInstance().getCurrentUser();
        if (materialType.getModuleType().compareTo(6) != 0) {
            materialType.setEnterpriseId(user.getGroupId());
        }
        materialTypeList = this.materialService.getMaterialTypeNew(materialType, user);
        return JsonResult.success(materialTypeList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/insertMaterialTypeMain"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String insertMaterialTypeMain(TrainingMaterialType materialType) {
        TrainingMaterialTypeVo materialTypeVo = new TrainingMaterialTypeVo();
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) return "INVALID_TOKEN";
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (materialType == null || materialType.getMaterialTypeName().trim().length() > 30) return JsonResult.error((String)this.messageSource.getMessage("training.material.type.over", null, locale), null);
        materialType.setEnterpriseId(user.getGroupId());
        materialType.setCreater(user.getId());
        materialType.setUpdater(user.getId());
        String idPath = this.materialTypeService.buildIdPath(materialType);
        materialType.setIdPath(idPath);
        materialType.setOptionExtend(Integer.valueOf(materialType.getOptionExtend() == null ? 0 : materialType.getOptionExtend()));
        materialType.setOptionCover(Integer.valueOf(materialType.getOptionCover() == null ? 0 : materialType.getOptionCover()));
        this.materialTypeService.processCoverExtend(materialType);
        Map<String, Object> map = this.materialService.insertMaterialType(materialType);
        String isNum = map.get("isNum").toString();
        materialType = (TrainingMaterialType)map.get("materialType");
        if (materialType != null) {
            materialTypeVo.setIsPower(Integer.valueOf(1));
            materialTypeVo.setId(materialType.getId());
            materialTypeVo.setMaterialTypeLevel(materialType.getMaterialTypeLevel());
            materialTypeVo.setMaterialTypeName(materialType.getMaterialTypeName());
            materialTypeVo.setModuleType(materialType.getModuleType());
            materialTypeVo.setSort(materialType.getSort());
            materialTypeVo.setEnterpriseId(materialType.getEnterpriseId());
            materialTypeVo.setCreater(materialType.getCreater());
            materialTypeVo.setCreateTime(materialType.getCreateTime());
            materialTypeVo.setSourceId(materialType.getSourceId());
            materialTypeVo.setOriginId(materialType.getOriginId());
            materialTypeVo.setTotalCount(Long.valueOf(!ObjectUtils.isEmpty((Object)map.get("total")) ? Long.valueOf(map.get("total").toString()) - 1L : 1L));
        }
        if (!"0".equals(isNum)) return JsonResult.success((Object)materialTypeVo);
        return JsonResult.error((String)this.messageSource.getMessage("training.material.same.type", null, locale), null);
    }

    @RequestMapping(value={"/updateMaterialType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateMaterialType(TrainingMaterialType materialType) {
        block5: {
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                    if (materialType != null && materialType.getMaterialTypeName().trim().length() <= 30) {
                        materialType.setEnterpriseId(user.getGroupId());
                        materialType.setUpdater(user.getId());
                        materialType.setUpdateTime(new Date());
                        String num = this.materialService.updateMaterialType(materialType);
                        if ("0".equals(num)) {
                            return JsonResult.error((String)this.messageSource.getMessage("training.material.same.type", null, locale), null);
                        }
                        break block5;
                    }
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.type.over", null, locale), null);
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/delMaterialType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String delMaterialType(HttpServletRequest req, TrainingMaterialType materialType) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (materialType != null) {
                    materialType.setEnterpriseId(user.getGroupId());
                    LogPojo pojo = new LogPojo();
                    pojo.setUserId(user.getId());
                    pojo.setCreateTime(new Date());
                    pojo.setRemoteIp(req.getRemoteAddr());
                    pojo.setEnterpriseId(user.getGroupId());
                    pojo.setUserName(user.getUserName());
                    if (materialType.getModuleType() == 1) {
                        pojo.setOperation("material_classification_delete");
                        pojo.setI18nKey("operation.material_classification_delete.description");
                    } else if (materialType.getModuleType() == 2) {
                        pojo.setOperation("paper_classification_delete");
                        pojo.setI18nKey("operation.paper_classification_delete.description");
                    } else if (materialType.getModuleType() == 3) {
                        pojo.setOperation("exam_classification_delete");
                        pojo.setI18nKey("operation.exam_classification_delete.description");
                    } else if (materialType.getModuleType() == 4) {
                        pojo.setOperation("study_program_classification_delete");
                        pojo.setI18nKey("operation.study_program_classification_delete.description");
                    } else if (materialType.getModuleType() == 5) {
                        pojo.setOperation("course_classification_delete");
                        pojo.setI18nKey("operation.course_classification_delete.description");
                    } else if (materialType.getModuleType() == 7) {
                        pojo.setOperation("question_classification_delete");
                        pojo.setI18nKey("operation.question_classification_delete.description");
                    }
                    pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                    return this.materialService.delMaterialType(materialType, pojo);
                }
                return "EMPTY_COMMENTER";
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/updateMaterialSort"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateMaterialSort(Integer id, Integer materialTypeLevel, Integer moduleType2, Integer move, Integer sort) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (id == null) {
                    return "EMPTY_COMMENTER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.materialService.updateMaterialSort(id, materialTypeLevel, moduleType2, sort, move, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @PostMapping(value={"/updateMaterialSortByDrag"})
    @ResponseBody
    public String updateMaterialSortByDrag(@RequestBody TrainingMaterialTypeVo trainingMaterialTypeVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialService.updateMaterialSortByDrag(user, trainingMaterialTypeVo);
    }

    @RequestMapping(value={"/selectMaterialPower"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectMaterialPower(@RequestBody TrainingMaterialPowerVo power) {
        List<TrainingMaterialPowerVo> list = null;
        Integer materialTypeId = null;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (power != null) {
            materialTypeId = power.getMaterialTypeId();
        }
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        list = this.materialService.selectMaterialPower(materialTypeId, user);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectMaterialByPower"})
    @ResponseBody
    public String selectMaterialByPower(Integer id) {
        List<TrainingMaterialVo> list = null;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            list = this.materialService.selectMaterialByPower(id, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectMaterialByPowerByPage"})
    @ResponseBody
    public String selectMaterialByPowerByPage(Page<TrainingMaterialVo> page, Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.materialService.selectMaterialByPowerByPage(page, id, user);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectMaterialComment"})
    @ResponseBody
    public String selectMaterialComment(@RequestBody TrainingMaterialComment trainingMaterialComment) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingMaterialCommentVo list = this.materialService.selectMaterialComment(trainingMaterialComment.getMaterialId(), user);
            return JsonResult.success((Object)list);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateMaterialComment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateMaterialComment(@RequestBody TrainingMaterialComment trainingMaterialComment) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        trainingMaterialComment.setUserId(user.getId());
        trainingMaterialComment.setEnterpriseId(user.getGroupId());
        trainingMaterialComment.setUpdateTime(new Date());
        trainingMaterialComment.setCreateTime(new Date());
        this.materialService.updateMaterialComment(trainingMaterialComment);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getMaterialTypeModuleByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialTypeModuleByPage(Page<TrainingMaterialTypeVo> page, TrainingMaterialTypeVo materialType) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (materialType.getModuleType().compareTo(6) != 0) {
                    materialType.setEnterpriseId(user.getGroupId());
                }
            } else {
                return "INVALID_TOKEN";
            }
            page = this.materialService.getMaterialTypeByPage(page, materialType, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getMaterialModuleType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialModuleType(TrainingMaterialTypeVo materialType) {
        List<TrainingMaterialTypeVo> materialTypeList = null;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            materialType.setEnterpriseId(user.getGroupId());
            materialTypeList = this.materialService.getMaterialType(materialType, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(materialTypeList);
    }

    @RequestMapping(value={"/getMaterialById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialById(Integer id) {
        return JsonResult.success((Object)this.materialService.getMaterialById(id));
    }

    @RequestMapping(value={"/selectMaterialStatusById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectMaterialStatusById(Integer id, Integer learnType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingMaterial material = this.materialService.getMaterialById(id);
        String backNum = this.getMaterialStatus(id, learnType, material, user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", backNum);
        map.put("isDownload", ObjectUtils.isEmpty((Object)material) ? 0 : this.materialPermissionFacade.getIsDownload(material, ContextUtil.getUser()));
        map.put("isScreen", ObjectUtils.isEmpty((Object)material) ? 0 : this.trainingConfigService.selectIsScreenByEnterpriseId(material.getEnterpriseId()));
        return JSONObject.toJSONString((Object)new JsonResult("ok", map, Boolean.valueOf(false)), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    private String getMaterialStatus(Integer id, Integer learnType, TrainingMaterial material, Users user) {
        String backNum = "1";
        if (ObjectUtils.isEmpty((Object)material)) {
            return "2";
        }
        if (!StringUtils.isEmpty((Object)material.getIsDel()) && material.getIsDel() == 1) {
            backNum = "2";
        } else if (!StringUtils.isEmpty((Object)material.getIsUsing()) && material.getIsUsing() == 0) {
            backNum = "3";
        }
        if (material.getEnterpriseId() != null && user.getGroupId() != null && !material.getEnterpriseId().equals(user.getGroupId())) {
            backNum = "4";
        }
        if (learnType != null && learnType == 0) {
            boolean valid;
            if (!StringUtils.isEmpty((Object)material.getIsShow()) && material.getIsShow() == 0) {
                backNum = "3";
            }
            if (!(valid = this.materialPermissionFacade.validMaterial(id, user, 1))) {
                backNum = "4";
            }
        }
        return backNum;
    }

    @RequestMapping(value={"/selectUsingMaterial"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUsingMaterial(Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success(this.materialService.selectUsingMaterial(materialId, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectUsingMaterialList"})
    @ResponseBody
    public String selectUsingMaterialList(@RequestBody List<Integer> materialList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success(this.materialService.selectUsingMaterialList(materialList, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getUsingMaterialList"})
    @ResponseBody
    public String getUsingMaterialList(@RequestBody TrainingMaterialVo trainingMaterialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success(this.materialService.getUsingMaterialList(trainingMaterialVo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAllSearch"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAllSearch(Integer enterpriseId, String title) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.materialService.selectAllSearch(enterpriseId, title, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAllSearchByTrainingByPage"})
    @ResponseBody
    public String selectAllSearchByTrainingByPage(Page<TrainingsVo> page, Integer enterpriseId, String title) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.materialService.selectAllSearchByTrainingByPage(page, enterpriseId, title, user));
    }

    @RequestMapping(value={"/selectAllSearchByMaterialByPage"})
    @ResponseBody
    public String selectAllSearchByMaterialByPage(Page<TrainingMaterial> page, Integer enterpriseId, String title) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.materialService.selectAllSearchByMaterialByPage(page, enterpriseId, title, user));
    }

    @RequestMapping(value={"/saveMaterialName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveMaterialName(@RequestBody TrainingMaterial trainingMaterial) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.materialService.saveMaterialName(trainingMaterial, user);
        }
        catch (Exception e) {
            log.error("saveMaterialName", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveGroupCount"})
    @ResponseBody
    public String saveGroupCount(String beginDate, Integer dayUserIds, Integer dayGroupIds) {
        this.commonService.postData(beginDate, dayUserIds, dayGroupIds);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveMaterialCompression"})
    @ResponseBody
    public String saveMaterialCompression(@RequestBody TrainingMaterial material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.materialService.saveMaterialCompression(material, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateMaterialPictureShow"})
    @ResponseBody
    public String updateMaterialPictureShow(@RequestBody List<TrainingMaterial> materials) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.materialService.updateMaterialPictureShow(materials, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectMaterialDetail"})
    @ResponseBody
    public String selectMaterialDetail(@RequestBody TrainingMaterialVo materialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.materialService.selectMaterialDetail(materialVo, user));
    }

    @RequestMapping(value={"/updateChangeMaterialVersion"})
    @ResponseBody
    public String updateChangeMaterialVersion(@RequestBody TrainingMaterialVo materialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialService.updateChangeMaterialVersion(materialVo, user);
    }

    @RequestMapping(value={"/selectMaterialVersionByPage"})
    @ResponseBody
    public String selectMaterialVersionByPage(Page<TrainingMaterialVersionVo> page, Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.materialService.selectMaterialVersionByPage(page, materialId, user));
    }

    @RequestMapping(value={"/selectAllLevelMaterialType"})
    @ResponseBody
    public String selectAllLevelMaterialType(@RequestBody TrainingMaterialTypeVo materialType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (materialType.getModuleType().compareTo(6) != 0) {
            materialType.setEnterpriseId(user.getGroupId());
        }
        return JsonResult.success(this.materialService.selectAllLevelMaterialType(materialType, user));
    }

    @RequestMapping(value={"/saveMaterialDownloads"})
    @ResponseBody
    public String saveMaterialDownloads(@RequestBody TrainingMaterialDownloads trainingMaterialDownloads) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.materialService.saveMaterialDownloads(trainingMaterialDownloads, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getMaterialDownloadsByPage"})
    @ResponseBody
    public String getMaterialDownloadsByPage(Page<TrainingMaterialDownloadsVo> page, Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.materialService.getMaterialDownloadsByPage(page, materialId, user);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getMaterialBasicInformation"})
    @ResponseBody
    public String getMaterialBasicInformation(@RequestBody TrainingMaterialVo trainingMaterialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.materialService.getMaterialBasicInformation(trainingMaterialVo));
    }

    @RequestMapping(value={"/getMaterialText"})
    @ResponseBody
    public String getMaterialText(@RequestBody TrainingMaterialVo trainingMaterialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.materialService.getMaterialText(trainingMaterialVo));
    }

    @RequestMapping(value={"/getMaterialCollection"})
    @ResponseBody
    public String getMaterialCollection(@RequestBody TrainingMaterialVo trainingMaterialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.materialService.getMaterialCollection(trainingMaterialVo, user));
    }
}

