/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.DeptStudyMaterialOverviewReq;
import com.ovopark.training.service.TrainingMaterialNewService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingMaterialVo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/materialNew"})
public class TrainingMaterialNewController {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialNewController.class);
    @Autowired
    private TrainingMaterialNewService trainingMaterialNewService;

    @RequestMapping(value={"/insertMaterial"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertMaterial(@RequestBody List<TrainingMaterialVo> material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingMaterialNewService.insertMaterial(material, user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateMaterial"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateMaterial(@RequestBody List<TrainingMaterialVo> material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingMaterialNewService.updateMaterial(material, user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateCover"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateCover(@RequestBody List<TrainingMaterial> materialList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return this.trainingMaterialNewService.updateCover(materialList, user.getId());
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateChangeMaterialVersionV2"})
    @ResponseBody
    public String updateChangeMaterialVersionV2(@RequestBody TrainingMaterialVo materialVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingMaterialNewService.updateChangeMaterialVersionV2(materialVo, user);
    }

    @RequestMapping(value={"/getStudyInfo"})
    @ResponseBody
    public String getStudyInfo(Integer materialId) {
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingMaterialNewService.getStudyInfo(user.getGroupId(), user.getId(), materialId, startTime, endTime);
    }

    @PostMapping(value={"/getCompleteStudyUseTimeOverview"})
    @ResponseBody
    public String getCompleteStudyUseTimeOverview(@RequestBody DeptStudyMaterialOverviewReq req) {
        if (req.getMaterialId() == null) {
            return JsonResult.error();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingMaterialNewService.getCompleteStudyUseTimeOverview(user.getGroupId(), user.getId(), req.getMaterialId());
    }

    @PostMapping(value={"/getDeptStudyOverview"})
    @ResponseBody
    public String getDeptStudyOverview(@RequestBody DeptStudyMaterialOverviewReq req) {
        if (req.getMaterialId() == null) {
            return JsonResult.error();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingMaterialNewService.getDeptStudyOverview(req, user);
    }
}

