/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingMessageService;
import com.ovopark.training.vo.TrainingMessageVo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/message"})
public class TrainingMessageController {
    private static final Logger log = LoggerFactory.getLogger(TrainingMessageController.class);
    @Resource
    private TrainingMessageService trainingMessageService;

    @RequestMapping(value={"/saveTrainingMaterialMessage"})
    @ResponseBody
    public String saveTrainingMaterialMessage(@RequestBody TrainingMessageVo trainingMessageVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingMessageService.saveTrainingMaterialMessage(trainingMessageVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingMessageByMaterial"})
    @ResponseBody
    public String getTrainingMessageByMaterial(@RequestBody TrainingMessageVo trainingMessageVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingMessageService.getTrainingMessageByMaterial(trainingMessageVo, user));
    }

    @RequestMapping(value={"/saveTrainingTrainMessage"})
    @ResponseBody
    public String saveTrainingTrainMessage(@RequestBody TrainingMessageVo trainingMessageVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingMessageService.saveTrainingTrainMessage(trainingMessageVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingMessageByTrain"})
    @ResponseBody
    public String getTrainingMessageByTrain(@RequestBody TrainingMessageVo trainingMessageVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingMessageService.getTrainingMessageByTrain(trainingMessageVo, user));
    }
}

