/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.DetailAnalysisVo;
import com.ovopark.training.vo.ExaminerAnalysisReq;
import com.ovopark.training.vo.ExaminerAnalysisVo;
import com.ovopark.training.vo.OperateCheckVo;
import com.ovopark.training.vo.StudentOperateDetailVo;
import com.ovopark.training.vo.StudentOperateVo;
import com.ovopark.training.vo.TraineeAnalysisReq;
import com.ovopark.training.vo.TraineeAnalysisVo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/operate"})
public class TrainingOperateController {
    private static final Logger log = LoggerFactory.getLogger(TrainingOperateController.class);
    @Autowired
    private TrainingOperateService trainingOperateService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/saveOperateCheck"})
    @ResponseBody
    public String saveOperateCheck(@RequestBody OperateCheckVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        vo.setEnterpriseId(user.getGroupId());
        vo.setUserId(user.getId());
        vo.setUserName(user.getShowName());
        return this.trainingOperateService.saveOperateCheck(vo);
    }

    @RequestMapping(value={"/vaildOperateCheck"})
    @ResponseBody
    public String vaildOperateCheck(Integer id, Integer jobId, String name, Integer source) {
        if (StringUtils.isEmpty((Object)name)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.vaildOperateCheck(user.getGroupId(), id, jobId, name, source);
    }

    @RequestMapping(value={"/deleteOperateCheck"})
    @ResponseBody
    public String deleteOperateCheck(HttpServletRequest req, Integer operateCheckId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("practical_assessment_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.practical_assessment_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingOperateService.deleteOperateCheck(operateCheckId, pojo);
    }

    @RequestMapping(value={"/operateCheckPublish"})
    @ResponseBody
    public String operateCheckPublish(Integer operateCheckId, Integer isPublic) {
        if (operateCheckId == null || isPublic == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.operateCheckPublish(operateCheckId, isPublic);
    }

    @RequestMapping(value={"/operateCheckClose"})
    @ResponseBody
    public String operateCheckClose(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.operateCheckClose(operateCheckId);
    }

    @RequestMapping(value={"/getOperateCheckById"})
    @ResponseBody
    public String getOperateCheckById(Integer operateCheckId) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getOperateCheckById(operateCheckId);
    }

    @RequestMapping(value={"/getOperateCheckByPage"})
    @ResponseBody
    public String getOperateCheckByPage(Page<OperateCheckVo> page, String checkName, Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getOperateCheckByPage(page, user.getGroupId(), checkName, status);
    }

    @RequestMapping(value={"/getTraineeAnalysis"})
    @ResponseBody
    public String getTraineeAnalysis(@RequestBody TraineeAnalysisReq req) {
        if (req.getOperateCheckId() == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        TraineeAnalysisVo vo = this.trainingOperateService.getTraineeAnalysis(req, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/getTraineeAnalysisDetail"})
    @ResponseBody
    public String getTraineeAnalysisDetail(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getTraineeAnalysisDetail(operateCheckId, userId);
    }

    @RequestMapping(value={"/downTraineeAnalysis"})
    @ResponseBody
    public String downTraineeAnalysis(@RequestBody TraineeAnalysisReq req, HttpServletResponse resp) {
        if (req.getOperateCheckId() == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingOperateService.downTraineeAnalysis(user, req, resp);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getExaminerAnalysis"})
    @ResponseBody
    public String getExaminerAnalysis(@RequestBody ExaminerAnalysisReq req) {
        if (req.getOperateCheckId() == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        ExaminerAnalysisVo vo = this.trainingOperateService.getExaminerAnalysis(req, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/getExaminerAnalysisDetail"})
    @ResponseBody
    public String getExaminerAnalysisDetail(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getExaminerAnalysisDetail(operateCheckId, userId);
    }

    @RequestMapping(value={"/downExaminerAnalysis"})
    @ResponseBody
    public String downExaminerAnalysis(@RequestBody ExaminerAnalysisReq req, HttpServletResponse resp) {
        if (req.getOperateCheckId() == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingOperateService.downExaminerAnalysis(user, req, resp);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getDetailAnalysis"})
    @ResponseBody
    public String getDetailAnalysis(Integer operateCheckId, String detailName) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        List<DetailAnalysisVo> list = this.trainingOperateService.getDetailAnalysis(operateCheckId, detailName);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/downDetailAnalysis"})
    @ResponseBody
    public String downDetailAnalysis(Integer operateCheckId, String detailName, HttpServletResponse resp) {
        if (operateCheckId == null) {
            return "INVALID_PARAMETER";
        }
        this.trainingOperateService.downDetailAnalysis(operateCheckId, detailName, resp);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getOperateDetail"})
    @ResponseBody
    public String getOperateDetail(Integer userOperateId) {
        if (userOperateId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getOperateDetail(userOperateId);
    }

    @RequestMapping(value={"/getStudentOperate"})
    @ResponseBody
    public String getStudentOperate(Integer userId, String startDate, String endDate, String checkName, Integer status) {
        Date startTime = null;
        if (!StringUtils.isEmpty((Object)startDate)) {
            startTime = DateUtils.getStartTimeOfDay(startDate, "yyyy-MM-dd");
        }
        Date endTime = null;
        if (!StringUtils.isEmpty((Object)endDate)) {
            endTime = DateUtils.getEndTimeOfDay(endDate, "yyyy-MM-dd");
        }
        StudentOperateVo result = this.trainingOperateService.getStudentOperate(startTime, endTime, checkName, status, userId);
        return JsonResult.success((Object)result);
    }

    @RequestMapping(value={"/getStudentOperateList"})
    @ResponseBody
    public String getStudentOperateList(String checkName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        StudentOperateVo result = this.trainingOperateService.getStudentOperateList(checkName, user);
        return JsonResult.success((Object)result);
    }

    @RequestMapping(value={"/exportStudentOperate"})
    @ResponseBody
    public void exportStudentOperate(HttpServletResponse response, Integer userId, String startDate, String endDate, String checkName, Integer status) {
        Date startTime = null;
        if (!StringUtils.isEmpty((Object)startDate)) {
            startTime = DateUtils.getStartTimeOfDay(startDate, "yyyy-MM-dd");
        }
        Date endTime = null;
        if (!StringUtils.isEmpty((Object)endDate)) {
            endTime = DateUtils.getEndTimeOfDay(endDate, "yyyy-MM-dd");
        }
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
        String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.operate.record", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell10 = row1.createCell(0);
        cell10.setCellValue(this.messageSource.getMessage("training.operate.name.detail", null, locale));
        Cell cell11 = row1.createCell(1);
        cell11.setCellValue(this.messageSource.getMessage("training.operate.start.time", null, locale));
        Cell cell12 = row1.createCell(2);
        cell12.setCellValue(this.messageSource.getMessage("training.operate.last.time", null, locale));
        Cell cell13 = row1.createCell(3);
        cell13.setCellValue(this.messageSource.getMessage("training.operate.duration", null, locale));
        Cell cell14 = row1.createCell(4);
        cell14.setCellValue(this.messageSource.getMessage("training.operate.schedule", null, locale));
        Cell cell15 = row1.createCell(5);
        cell15.setCellValue(passStatusName);
        int i = 1;
        StudentOperateVo result = this.trainingOperateService.getStudentOperate(startTime, endTime, checkName, status, userId);
        if (!CollectionUtils.isEmpty((Collection)result.getDataList())) {
            for (StudentOperateDetailVo vo : result.getDataList()) {
                Row row = sheet.createRow(i++);
                row.createCell(0).setCellValue(vo.getCheckName());
                if (vo.getStartOperateTime() != null) {
                    row.createCell(1).setCellValue(DateUtils.format(vo.getStartOperateTime(), "yyyy-MM-dd HH:mm"));
                }
                if (vo.getLastOperateTime() != null) {
                    row.createCell(2).setCellValue(DateUtils.format(vo.getLastOperateTime(), "yyyy-MM-dd HH:mm"));
                }
                row.createCell(3).setCellValue(vo.getCheckDuration() + this.messageSource.getMessage("training.operate.minutes", null, locale));
                StringBuffer cellx4Str = new StringBuffer();
                if (vo.getTimeStatus().equals(1)) {
                    cellx4Str.append(going + "  ");
                } else if (vo.getTimeStatus().equals(2)) {
                    cellx4Str.append(completed + "  ");
                }
                row.createCell(4).setCellValue(cellx4Str.toString() + vo.getUserCheckNumber() + "/" + vo.getCheckNumber());
                if (vo.getStatus().equals(2)) {
                    row.createCell(5).setCellValue(passName);
                    continue;
                }
                if (vo.getStatus().equals(3)) {
                    row.createCell(5).setCellValue(unPassName);
                    continue;
                }
                row.createCell(5).setCellValue(going);
            }
        }
        try {
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            String fileName = result.getUserName() + this.messageSource.getMessage("training.operate.record", null, locale) + "_" + DateUtils.format(new Date(), "yyyyMMdd");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xls");
            ServletOutputStream output = response.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/getStudentOperateDetail"})
    @ResponseBody
    public String getStudentOperateDetail(Integer operateCheckId, Integer userId) {
        if (operateCheckId == null || userId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getStudentOperateDetail(operateCheckId, userId);
    }

    @RequestMapping(value={"/exportOperatePdf"})
    @ResponseBody
    public void exportOperatePdf(@RequestParam(value="userOperateId") Integer userOperateId, HttpServletResponse response) {
        this.trainingOperateService.convertToPdf(userOperateId, response);
    }
}

