/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ovopark.api.GoldApi;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Role;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperRandom;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.util.AliyunPropUtil;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.OssHelper;
import com.ovopark.training.util.StorageModule;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.PaperAnalyseSearchVo;
import com.ovopark.training.vo.PaperUserDetailSearchVo;
import com.ovopark.training.vo.TagVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.UserExamSearchVo;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/paperConfig"})
public class TrainingPaperConfigController {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperConfigController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingPaperService trainingPaperService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Resource
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private GoldApi goldApi;
    @Autowired
    private TrainingPaperRemoteService paperRemoteService;
    @Value(value="${training.webview.url}")
    private String trainingPaperUrl;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;

    @RequestMapping(value={"/addPaperScreenNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addPaperScreenNum(Integer userPaperId) {
        if (userPaperId == null) {
            return JsonResult.paramError();
        }
        return this.paperService.addPaperScreenNum(userPaperId);
    }

    @RequestMapping(value={"/getPaperDetailByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperDetailByPage(Page<TrainingPaperVo> page, String paperName, Integer navId, Integer enterpriseId, Integer isTraining, Integer isExam) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getPaperDetailByPage(page, user.getId(), enterpriseId, paperName, navId, isTraining, isExam));
    }

    @RequestMapping(value={"/deleteTrainingPaperByPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingPaperByPaperId(Integer paperId) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        if (paperId != null) {
            this.paperService.deleteTrainingPaper(paperId);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveTrainingPaper"})
    @ResponseBody
    public String saveTrainingPaper(@RequestBody TrainingPapersVo paper) {
        int i;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (paper.getEnterpriseId() == null && user.getGroupId() != null) {
            paper.setEnterpriseId(user.getGroupId());
        }
        paper.setTitle(paper.getPaperName());
        if (paper.getNavId() != null) {
            paper.setTrainingNavId(paper.getNavId());
        }
        if (paper.getShowOptions() == null) {
            paper.setShowOptions(Integer.valueOf(1));
        }
        if (paper.getPaperType() != null && paper.getPaperType() == 2) {
            paper.setPaperRandoms(JSONArray.parseArray((String)paper.getTrainingPaperRandoms(), TrainingPaperRandom.class));
        }
        if (!(StringUtils.isEmpty((Object)paper.getWhoCanSeeIds()) && StringUtils.isEmpty((Object)paper.getRoles()) && StringUtils.isEmpty((Object)paper.getOrganizes()) && StringUtils.isEmpty((Object)paper.getTags()))) {
            paper.setLookLevel(Integer.valueOf(1));
        } else {
            paper.setLookLevel(null);
        }
        if (!StringUtils.isEmpty((Object)paper.getRoles())) {
            ArrayList<Role> roleList = new ArrayList<Role>();
            String[] roleStrs = paper.getRoles().split(",");
            for (i = 0; i < roleStrs.length; ++i) {
                Role role = new Role();
                role.setId(Integer.valueOf(Integer.parseInt(roleStrs[i])));
                roleList.add(role);
            }
            paper.setRoleList(roleList);
        }
        if (!StringUtils.isEmpty((Object)paper.getTags())) {
            ArrayList<TagVo> tagList = new ArrayList<TagVo>();
            String[] tagStrs = paper.getTags().split(",");
            for (i = 0; i < tagStrs.length; ++i) {
                TagVo tag = new TagVo();
                tag.setId(Integer.valueOf(Integer.parseInt(tagStrs[i])));
                tagList.add(tag);
            }
            paper.setTagList(tagList);
        }
        if (!StringUtils.isEmpty((Object)paper.getOrganizes())) {
            ArrayList<OrgVo> organizeList = new ArrayList<OrgVo>();
            String[] organizeStrs = paper.getOrganizes().split(",");
            for (i = 0; i < organizeStrs.length; ++i) {
                OrgVo org = new OrgVo();
                org.setId(organizeStrs[i]);
                organizeList.add(org);
            }
            paper.setOrganizeList(organizeList);
        }
        Integer paperId = this.paperService.saveTrainingPaper(paper.getEnterpriseId(), paper, paper.getWhoCanSeeIds(), user.getId(), paper.getRoles(), paper.getTags(), paper.getOrganizes(), paper.getQuestionClasses(), paper.getIsAllAnswer(), paper.getIsAutoRead(), paper.getIsGapAutoRead());
        this.paperService.saveTrainingExaminer(paperId, paper.getEnterpriseId(), paper.getUserIds());
        this.paperService.saveTrainingPaperUser(paper.getEnterpriseId(), paperId, paper.getWhoCanSeeIds(), user.getId(), paper.getRoles(), paper.getTags(), paper.getOrganizes());
        return JsonResult.success((Object)paperId);
    }

    @RequestMapping(value={"/randomPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String randomPaper(@RequestBody TrainingPaperVo paper) {
        if (paper.getPaperId() == null) {
            return JsonResult.paramError();
        }
        if (paper.getEnterpriseId() == null) {
            Users user = Authenticator.getInstance().getCurrentUser();
            paper.setEnterpriseId(user.getGroupId());
        }
        return this.paperService.randomPaper(paper, paper.getQuestionClass());
    }

    @RequestMapping(value={"/getUserPaperById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperById(Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPaperVo trainingPaperVo = this.paperService.getUserPaperById(paperId, user.getId());
        Integer status = 0;
        if (trainingPaperVo == null) {
            status = 1;
        }
        return JsonResult.success((Object)status);
    }

    @RequestMapping(value={"/getQrCode"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQrCode(String url, Integer enterpriseId, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user.getGroupId() != null) {
            enterpriseId = user.getGroupId();
        }
        String ossUrl = "";
        if (paperId != null) {
            try {
                String content = this.trainingPaperUrl + "?enterpriseId=" + enterpriseId + "&paperId=" + paperId;
                File tempFile = null;
                tempFile = File.createTempFile("tempFile", ".png");
                int width = 300;
                int height = 300;
                String format = "png";
                HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
                hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
                hints.put(EncodeHintType.MARGIN, 1);
                BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
                Path path = FileSystems.getDefault().getPath(tempFile.getAbsolutePath(), new String[0]);
                MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)format, (Path)path);
                String accessUrl = AliyunPropUtil.readStringValue("oss.accessUrl");
                ossUrl = OssHelper.uploadFile(tempFile, StorageModule.TRAINING);
                tempFile.delete();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                e.printStackTrace();
            }
        }
        return JsonResult.success((Object)("http://ovopark.oss-cn-hangzhou.aliyuncs.com/" + ossUrl));
    }

    @RequestMapping(value={"/getUserPaperIsLevel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperIsLevel(Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Integer isLevel = this.paperService.getUserPaperByIsLevel(paperId, user.getId(), user.getGroupId());
        TrainingPaper trainingPaper = this.paperService.getTrainingPaper(paperId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (trainingPaper != null) {
            map.put("isDel", 0);
        } else {
            map.put("isDel", 1);
        }
        if (trainingPaper != null && trainingPaper.getStartTime() != null && trainingPaper.getEndTime() != null && (new Date().getTime() < trainingPaper.getStartTime().getTime() || new Date().getTime() > trainingPaper.getEndTime().getTime())) {
            map.put("isOverdue", 1);
        } else {
            map.put("isOverdue", 0);
        }
        map.put("isLevel", isLevel);
        if (trainingPaper != null && trainingPaper.getRepetitionNum() != null) {
            map.put("repetitionNum", trainingPaper.getRepetitionNum());
        } else {
            map.put("repetitionNum", 1);
        }
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/selectPapers"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectPapers(Page<TrainingPapersVo> page, String name, String paperState, Integer typeId, Integer projectShow, Integer isTraining, Integer isPaperState, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (enterpriseId != null) {
                user.setGroupId(enterpriseId);
            }
            return JsonResult.success(this.trainingPaperService.getPapers(page, name, paperState, user, typeId, projectShow, isTraining, isPaperState));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectProjectByPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectProjectByPaper(Integer paperId) {
        try {
            List<TrainingsVo> list = this.trainingPaperService.selectProjectByPaper(paperId);
            return JsonResult.success(list);
        }
        catch (Exception e) {
            log.error("selectProjectByPaper: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/validDeletePaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String validDeletePaper(Integer paperId) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperService.validDeletePaper(user.getGroupId(), paperId);
    }

    @RequestMapping(value={"/deletePaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deletePaper(HttpServletRequest req, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("exam_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.exam_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingPaperService.deletePaper(paperId, pojo);
    }

    @RequestMapping(value={"/updatePaperState"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updatePaperState(Integer paperId, Integer paperState) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingPaperService.updatePaperState(paperId, paperState, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/showPaperDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String showPaperDetail(Integer paperId) {
        return JsonResult.success((Object)this.trainingPaperService.showPaperDetail(paperId));
    }

    @RequestMapping(value={"/selectPapersVoList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectPapersVoList(@RequestBody TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (user.getGroupId() == null) {
                return JsonResult.success((Object)Lists.newArrayList());
            }
            List<TrainingPapersVo> list = this.trainingPaperService.selectPapersVoList(papersVo, user);
            return JsonResult.success(list);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectPapersVo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectPapersVo(@RequestBody TrainingPapersVo papersVo) {
        TrainingPapersVo vo = this.trainingPaperService.selectPapersVo(papersVo);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectPaperQuestions"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectPaperQuestions(@RequestBody TrainingUserPaperVo userPaperVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (ObjectUtils.isEmpty((Object)userPaperVo) || StringUtils.isEmpty((Object)userPaperVo.getSourceType()) || StringUtils.isEmpty((Object)userPaperVo.getSourceProjectId()) || userPaperVo.getSourceProjectId() == 0) {
            return JsonResult.paramError();
        }
        if (!ObjectUtils.isEmpty((Object)userPaperVo) && userPaperVo.getUserId() == null) {
            userPaperVo.setUserId(user.getId());
        }
        TrainingPapersVo vo = this.trainingPaperService.selectPaperQuestions(userPaperVo);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/saveHalfQuestions"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveHalfQuestions(@RequestBody List<TrainingUserQuestionVo> userQuestionVoList) {
        try {
            this.trainingPaperService.saveHalfQuestions(userQuestionVoList);
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error("saveHalfQuestions: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveUserQuestions"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveUserQuestions(@RequestBody List<TrainingUserQuestionVo> userQuestionVoList) {
        if (CollectionUtils.isEmpty(userQuestionVoList) || ObjectUtils.isEmpty((Object)userQuestionVoList.get(0))) {
            log.error("\u63d0\u4ea4 \u8bb0\u5f55\u4e3a\u7a7a ", (Object)("userQuestionVoList = " + userQuestionVoList));
            return JsonResult.error((String)"\u63d0\u4ea4 \u8bb0\u5f55\u4e3a\u7a7a", (Object)"userQuestionVoList is null");
        }
        final TrainingUserPaper userPaper = this.trainingPaperService.saveUserQuestions(userQuestionVoList);
        if (ObjectUtils.isEmpty((Object)userPaper)) {
            log.error("\u8003\u8bd5\u8bb0\u5f55\u4e3a\u7a7a ", (Object)("userQuestionVoList = " + userQuestionVoList));
            return JsonResult.error((String)"\u8003\u8bd5\u8bb0\u5f55\u4e3a\u7a7a", (Object)"userPaper is null");
        }
        final TrainingUserPaper finalUserPaper = userPaper;
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                if (!StringUtils.isEmpty((Object)finalUserPaper.getSourceType())) {
                    if (finalUserPaper.getSourceType() == 3) {
                        try {
                            TrainingPaperConfigController.this.appTrainingLearnProjectService.updateExamTaskStatus(finalUserPaper.getId());
                        }
                        catch (Exception e) {
                            log.error("\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                        }
                    } else if (finalUserPaper.getSourceType() == 4) {
                        try {
                            TrainingPaperConfigController.this.jobCertificationService.updatePaperStatus(finalUserPaper.getId());
                        }
                        catch (Exception e) {
                            log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                        }
                    } else if (finalUserPaper.getSourceType() == 5) {
                        try {
                            TrainingPaperConfigController.this.trainingCourseService.saveCourseTaskEnd(finalUserPaper.getId(), 2, null, null, null);
                        }
                        catch (Exception e) {
                            log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                        }
                    } else if (finalUserPaper.getSourceType() == 1) {
                        try {
                            TrainingPaperConfigController.this.paperRemoteService.updateStudyStatus(finalUserPaper.getId());
                        }
                        catch (Exception e) {
                            log.error("\u8bfe\u7a0b\u8003\u8bd5src\u903b\u8f91", (Throwable)e);
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)finalUserPaper.getIsReview()) && finalUserPaper.getIsReview() == 1) {
                    TrainingPaperConfigController.this.trainingPaperService.savePaperReviewer(finalUserPaper);
                }
                if (!StringUtils.isEmpty((Object)finalUserPaper.getUserId())) {
                    try {
                        TrainingPaperConfigController.this.jPushService.deleteMessages(finalUserPaper.getTrainingPaperId(), "TYPE_PAPER_SYSTEM", finalUserPaper.getUserId(), null, 1);
                    }
                    catch (Exception e) {
                        log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
                    }
                    try {
                        if (finalUserPaper.getPaperStatus() != null && finalUserPaper.getTrainingPaperId() != null && finalUserPaper.getPaperStatus() == 2) {
                            TrainingPaperConfigController.this.goldApi.updateGold(finalUserPaper.getId(), Integer.valueOf(1), finalUserPaper.getUserId(), finalUserPaper.getTrainingPaperId().toString(), finalUserPaper.getScore().toString());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8003\u8bd5\u52a0\u91d1\u5e01\u89c4\u5219 --" + finalUserPaper.getId() + " --" + finalUserPaper.getUserId() + " --" + finalUserPaper.getTrainingPaperId() + " --" + finalUserPaper.getScore(), (Throwable)e);
                    }
                }
                try {
                    TrainingPaperConfigController.this.sendStudyEvent(userPaper, locale);
                }
                catch (Exception e) {
                    log.error("\u5b66\u4e60\u4e8b\u4ef6\u64ad\u62a5", (Throwable)e);
                }
            }
        });
        return JsonResult.success((Object)userPaper.getId());
    }

    public void sendStudyEvent(TrainingUserPaper userPaper, Locale locale) {
        StudyEvent event = new StudyEvent();
        event.setDate(new Date());
        Integer userId = userPaper.getUserId();
        Integer groupId = userPaper.getEnterpriseId();
        event.setShop(this.findShopNameByUserId(userId, groupId));
        String taskStudy = this.messageSource.getMessage("training.job.course.task.study", null, locale);
        event.setEvent(taskStudy);
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId);
        if (!baseResult.getIsError().booleanValue() && Objects.nonNull(baseResult.getData())) {
            event.setCompanyName(((EnterpriseGroupMo)baseResult.getData()).getName());
        } else {
            event.setCompanyName("");
        }
        BaseResult baseResult2 = this.userDepPrivilegeApi.getPrivilegeDepBeanByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData()))) {
            event.setLatitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLatitude());
            event.setLongitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLongitude());
            event.setAddress(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getAddress());
        }
        if (!StringUtils.isEmpty((Object)event.getShop())) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
    }

    private String findShopNameByUserId(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null && Objects.nonNull(base.getData())) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = (String)pojoList.get(0);
        }
        return shopName;
    }

    @RequestMapping(value={"/selectUserPaperResult"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperResult(@RequestBody TrainingUserPaper userPaper) {
        TrainingUserPaperVo vo = this.trainingPaperService.selectUserPaperResult(userPaper);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectUserPaperList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperList(@RequestBody TrainingPapersVo papersVo) {
        TrainingPapersVo vo = this.trainingPaperService.selectUserPaperList(papersVo);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectFinishPaperQuestions"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectFinishPaperQuestions(@RequestBody TrainingUserPaperVo userPaperVo) {
        TrainingPapersVo vo = this.trainingPaperService.selectFinishPaperQuestions(userPaperVo);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/updatePaperProject"})
    @ResponseBody
    public String updatePaperProject(String list, String sql) {
        List<Object> userPaperVoList = new ArrayList();
        if (StringUtils.isEmpty((Object)list)) {
            userPaperVoList = this.trainingService.selectDataBySql(sql);
        } else {
            List<String> strs = Arrays.asList(list.split(","));
            for (String str : strs) {
                TrainingUserPaperVo vo = new TrainingUserPaperVo();
                vo.setId(Integer.valueOf(str));
                userPaperVoList.add(vo);
            }
        }
        final List<Object> finalUserPaperVoList = userPaperVoList;
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                for (TrainingUserPaperVo userPaper : finalUserPaperVoList) {
                    try {
                        TrainingPaperConfigController.this.appTrainingLearnProjectService.updateExamTaskStatus(userPaper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                    try {
                        TrainingPaperConfigController.this.jobCertificationService.updatePaperStatus(userPaper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                    try {
                        TrainingPaperConfigController.this.trainingCourseService.saveCourseTaskEnd(userPaper.getId(), 2, null, null, null);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                    }
                }
            }
        });
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectPaperStatusCount"})
    @ResponseBody
    public String selectPaperStatusCount() {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPapersVo vo = this.trainingPaperService.selectPaperStatusCount(user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectPaperAnalyse"})
    @ResponseBody
    public String selectPaperAnalyse(@RequestBody PaperAnalyseSearchVo paperVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingPaperService.selectPaperAnalyse(paperVo));
    }

    @RequestMapping(value={"/selectPaperAnalyseByExcel"})
    @ResponseBody
    public String selectPaperAnalyseByExcel(HttpServletResponse response, PaperAnalyseSearchVo paperVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        this.trainingPaperService.selectPaperAnalyseByExcel(response, paperVo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectPaperUserDetailByPage"})
    @ResponseBody
    public String selectPaperUserDetail(PaperUserDetailSearchVo searchVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.invalidToken();
        }
        return JsonResult.success(this.trainingPaperService.selectPaperUserDetailByPage(searchVo, user));
    }

    @RequestMapping(value={"/selectPaperUserDetailByStatus"})
    @ResponseBody
    public String selectPaperUserDetailByStatus(PaperUserDetailSearchVo searchVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.invalidToken();
        }
        return JsonResult.success(this.trainingPaperService.selectPaperUserDetailByStatus(searchVo, user));
    }

    @RequestMapping(value={"/selectUserExam"})
    @ResponseBody
    public String selectUserExam(UserExamSearchVo examSearchVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingPaperService.selectUserExamDetail(examSearchVo));
    }

    @RequestMapping(value={"/selectUserExamByExecl"})
    @ResponseBody
    public String selectUserExamByExecl(HttpServletResponse response, PaperUserDetailSearchVo searchVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        this.trainingPaperService.selectUserExamByExecl(response, searchVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectIsPaperPower"})
    @ResponseBody
    public String selectIsPaperPower(TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingPaperService.selectIsPaperPower(papersVo, user));
    }

    @RequestMapping(value={"/save85PaperReviewers"})
    @ResponseBody
    public String save85PaperReviewers(Integer enterpriseId) {
        this.trainingPaperService.save85PaperReviewers(enterpriseId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectPaperIsUserPower"})
    @ResponseBody
    public String selectPaperIsUserPower(@RequestBody TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (ObjectUtils.isEmpty((Object)user) || ObjectUtils.isEmpty((Object)user.getGroupId())) {
            return JsonResult.success((Object)3);
        }
        return JsonResult.success((Object)this.trainingPaperService.selectPaperIsUserPower(papersVo, user));
    }

    @RequestMapping(value={"/saveNewPapersByOld"})
    @ResponseBody
    public String saveNewPapersByOld(@RequestBody List<Integer> paperIdList) {
        this.trainingPaperService.saveNewPapersByOld(paperIdList);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getUserPaperStatus"})
    @ResponseBody
    public String getUserPaperStatus(@RequestBody TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperService.getUserPaperStatus(papersVo, user);
    }
}

