/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingProcureCourseService;
import com.ovopark.training.vo.TrainingProcureCourseVo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/procure"})
public class TrainingProcureCourseController {
    private static final Logger log = LoggerFactory.getLogger(TrainingProcureCourseController.class);
    @Autowired
    private TrainingProcureCourseService trainingProcureCourseService;

    @RequestMapping(value={"/selectTrainingProcureCourseByPage"})
    @ResponseBody
    public String selectTrainingProcureCourseByPage(Page<TrainingProcureCourseVo> page, @RequestParam(value="type", defaultValue="0", required=false) int type, @RequestParam(value="trainingName", defaultValue="", required=false) String trainingName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getId())) {
            return JsonResult.success(this.trainingProcureCourseService.selectTrainingProcureCourseByPage(page, type, trainingName, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/saveTrainingProcureCourse"})
    @ResponseBody
    public String saveTrainingProcureCourse(TrainingProcureCourseVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getId())) {
            return JsonResult.success((Object)this.trainingProcureCourseService.saveTrainingProcureCourse(vo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/addTrainingProcureCourse"})
    @ResponseBody
    public String addTrainingProcureCourse(@RequestParam(name="trainingFeeId") int trainingId, @RequestParam(name="trainingType", required=false, defaultValue="0") int trainingType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getId())) {
            return this.trainingProcureCourseService.addTrainingProcureCourse(trainingId, trainingType, user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/removeTrainingProcureCourse"})
    @ResponseBody
    public String removeTrainingProcureCourse(@RequestBody TrainingProcureCourseVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getId())) {
            return this.trainingProcureCourseService.removeTrainingProcureCourse(vo.getTrainingFeeIdList(), user);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/detachTrainging"})
    @ResponseBody
    public String detachTrainingProcureCourse(@RequestBody TrainingProcureCourseVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getId())) {
            return this.trainingProcureCourseService.detachTrainingProcureCourse(vo.getTrainingIdList(), user);
        }
        return "INVALID_TOKEN";
    }
}

