/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSON;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/questionConfig"})
public class TrainingQuestionConfigController {
    private static final Logger log = LoggerFactory.getLogger(TrainingQuestionConfigController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;

    @RequestMapping(value={"/saveNewQuestionDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveNewQuestionDetail(Integer paperId, @RequestParam(value="file") MultipartFile file, Integer typeId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            if (!file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xls") && !file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                return JsonResult.error((String)"4", (Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            int successNum = 0;
            int errorNum = 0;
            List<List<Object>> excelList0 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
            List<List<Object>> excelList1 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 1);
            List<List<Object>> excelList2 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 2);
            List<List<Object>> excelList3 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 3);
            List<List<Object>> excelList4 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 4);
            if (!(CollectionUtils.isEmpty(excelList0) && CollectionUtils.isEmpty(excelList1) && CollectionUtils.isEmpty(excelList2))) {
                String optionsName2;
                Boolean isVaild;
                TrainingQuestionVo question;
                List<Object> list;
                int i;
                ArrayList<TrainingQuestionVo> questionList = new ArrayList<TrainingQuestionVo>();
                for (i = 1; i < excelList0.size(); ++i) {
                    list = excelList0.get(i);
                    if (!CollectionUtils.isEmpty(list) && list.size() > 3) {
                        if (!(StringUtils.isEmpty((Object)list.get(1)) || StringUtils.isEmpty((Object)list.get(2)) || StringUtils.isEmpty((Object)list.get(0)))) {
                            question = new TrainingQuestionVo();
                            question.setPaperId(paperId);
                            question.setQuestionClass(typeId);
                            question.setEnterpriseId(user.getGroupId());
                            isVaild = false;
                            if (list.get(0).toString().trim().length() > 500) {
                                ++errorNum;
                                continue;
                            }
                            int j = 0;
                            while ((double)j < Double.parseDouble(list.get(2).toString())) {
                                String optionsName1 = list.get(4 + j).toString();
                                if (optionsName1.trim().length() > 150) {
                                    isVaild = true;
                                } else {
                                    int k = j + 1;
                                    while ((double)k < Double.parseDouble(list.get(2).toString())) {
                                        optionsName2 = list.get(4 + k).toString();
                                        if (optionsName1.equals(optionsName2)) {
                                            isVaild = true;
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                            if (isVaild.booleanValue()) {
                                ++errorNum;
                                continue;
                            }
                            if (list.get(1).toString().length() == 1 && (double)(list.get(1).toString().toUpperCase().charAt(0) - 65) - Double.parseDouble(list.get(2).toString()) <= -1.0) {
                                question.setQuestionType(Integer.valueOf(0));
                                question.setQuestionName(list.get(0).toString());
                                if (list.get(3) != null && !StringUtils.isEmpty((Object)list.get(3))) {
                                    question.setRemark(list.get(3).toString());
                                }
                                j = 0;
                                while ((double)j < Double.parseDouble(list.get(2).toString())) {
                                    TrainingOptionsVo options = new TrainingOptionsVo();
                                    options.setOptionsName(list.get(4 + j).toString());
                                    if (list.get(1).toString().trim().toUpperCase().contains(this.userSelect(j))) {
                                        options.setIsAnswer(Integer.valueOf(1));
                                    } else {
                                        options.setIsAnswer(Integer.valueOf(0));
                                    }
                                    question.getOptionsList().add(options);
                                    ++j;
                                }
                                ++successNum;
                                questionList.add(question);
                                continue;
                            }
                            ++errorNum;
                            continue;
                        }
                        ++errorNum;
                        continue;
                    }
                    ++errorNum;
                }
                for (i = 1; i < excelList1.size(); ++i) {
                    list = excelList1.get(i);
                    if (!CollectionUtils.isEmpty(list) && list.size() > 2) {
                        if (!StringUtils.isEmpty((Object)list.get(1)) && !StringUtils.isEmpty((Object)list.get(0))) {
                            question = new TrainingQuestionVo();
                            question.setQuestionClass(typeId);
                            question.setEnterpriseId(user.getGroupId());
                            question.setPaperId(paperId);
                            isVaild = false;
                            if (list.get(0).toString().trim().length() > 500) {
                                ++errorNum;
                                continue;
                            }
                            int j = 0;
                            while ((double)j < Double.parseDouble(list.get(1).toString())) {
                                String optionsName1 = list.get(3 + j).toString();
                                if (optionsName1.trim().length() > 60) {
                                    isVaild = true;
                                } else {
                                    int k = j + 1;
                                    while ((double)k < Double.parseDouble(list.get(1).toString())) {
                                        optionsName2 = list.get(3 + k).toString();
                                        if (optionsName1.equals(optionsName2)) {
                                            isVaild = true;
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                            if (isVaild.booleanValue()) {
                                ++errorNum;
                                continue;
                            }
                            Boolean isTrue = true;
                            if (isTrue.booleanValue()) {
                                question.setQuestionType(Integer.valueOf(2));
                                question.setQuestionName(list.get(0).toString());
                                if (list.get(2) != null && !StringUtils.isEmpty((Object)list.get(2))) {
                                    question.setRemark(list.get(2).toString());
                                }
                                int j2 = 0;
                                while ((double)j2 < Double.parseDouble(list.get(1).toString())) {
                                    TrainingOptionsVo options = new TrainingOptionsVo();
                                    String optionsName = list.get(3 + j2).toString().trim();
                                    options.setOptionsName(optionsName);
                                    options.setIsAnswer(Integer.valueOf(1));
                                    question.getOptionsList().add(options);
                                    ++j2;
                                }
                                ++successNum;
                                questionList.add(question);
                                continue;
                            }
                            ++errorNum;
                            continue;
                        }
                        ++errorNum;
                        continue;
                    }
                    ++errorNum;
                }
                for (i = 1; i < excelList2.size(); ++i) {
                    list = excelList2.get(i);
                    if (!CollectionUtils.isEmpty(list) && list.size() > 0) {
                        if (!StringUtils.isEmpty((Object)list.get(0))) {
                            String optionsName1;
                            question = new TrainingQuestionVo();
                            question.setPaperId(paperId);
                            question.setQuestionClass(typeId);
                            question.setEnterpriseId(user.getGroupId());
                            if (list.get(0).toString().trim().length() > 500) {
                                ++errorNum;
                                continue;
                            }
                            if (list.size() > 2 && !StringUtils.isEmpty((Object)list.get(2)) && (optionsName1 = list.get(2).toString()).trim().length() > 1000) {
                                ++errorNum;
                                continue;
                            }
                            question.setQuestionType(Integer.valueOf(1));
                            question.setQuestionName(list.get(0).toString());
                            if (list.size() > 1 && list.get(1) != null && !StringUtils.isEmpty((Object)list.get(1))) {
                                question.setRemark(list.get(1).toString());
                            }
                            TrainingOptionsVo options = new TrainingOptionsVo();
                            if (list.size() > 2 && !StringUtils.isEmpty((Object)list.get(2))) {
                                options.setOptionsName(list.get(2).toString().trim());
                            }
                            options.setIsAnswer(Integer.valueOf(1));
                            question.getOptionsList().add(options);
                            ++successNum;
                            questionList.add(question);
                            continue;
                        }
                        ++errorNum;
                        continue;
                    }
                    ++errorNum;
                }
                for (i = 1; i < excelList3.size(); ++i) {
                    list = excelList3.get(i);
                    if (!CollectionUtils.isEmpty(list) && list.size() > 3) {
                        if (!(StringUtils.isEmpty((Object)list.get(1)) || StringUtils.isEmpty((Object)list.get(2)) || StringUtils.isEmpty((Object)list.get(0)))) {
                            char[] charArray;
                            question = new TrainingQuestionVo();
                            question.setPaperId(paperId);
                            question.setQuestionClass(typeId);
                            question.setEnterpriseId(user.getGroupId());
                            isVaild = false;
                            if (list.get(0).toString().trim().length() > 500) {
                                ++errorNum;
                                continue;
                            }
                            int j = 0;
                            while ((double)j < Double.parseDouble(list.get(2).toString())) {
                                String optionsName1 = list.get(4 + j).toString();
                                if (optionsName1.trim().length() > 150) {
                                    isVaild = true;
                                } else {
                                    int k = j + 1;
                                    while ((double)k < Double.parseDouble(list.get(2).toString())) {
                                        String optionsName22 = list.get(4 + k).toString();
                                        if (optionsName1.equals(optionsName22)) {
                                            isVaild = true;
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                            for (char c : charArray = list.get(1).toString().trim().toUpperCase().toCharArray()) {
                                if (!((double)(c - 65) - Double.parseDouble(list.get(2).toString()) > -1.0)) continue;
                                isVaild = true;
                            }
                            if (isVaild.booleanValue()) {
                                ++errorNum;
                                continue;
                            }
                            question.setQuestionType(Integer.valueOf(3));
                            question.setQuestionName(list.get(0).toString());
                            if (list.get(3) != null && !StringUtils.isEmpty((Object)list.get(3))) {
                                question.setRemark(list.get(3).toString());
                            }
                            int j3 = 0;
                            while ((double)j3 < Double.parseDouble(list.get(2).toString())) {
                                TrainingOptionsVo options = new TrainingOptionsVo();
                                options.setOptionsName(list.get(4 + j3).toString());
                                if (list.get(1).toString().toUpperCase().contains(this.userSelect(j3))) {
                                    options.setIsAnswer(Integer.valueOf(1));
                                } else {
                                    options.setIsAnswer(Integer.valueOf(0));
                                }
                                question.getOptionsList().add(options);
                                ++j3;
                            }
                            ++successNum;
                            questionList.add(question);
                            continue;
                        }
                        ++errorNum;
                        continue;
                    }
                    ++errorNum;
                }
                for (i = 1; i < excelList4.size(); ++i) {
                    list = excelList4.get(i);
                    if (!CollectionUtils.isEmpty(list) && list.size() > 3) {
                        if (!StringUtils.isEmpty((Object)list.get(1)) && !StringUtils.isEmpty((Object)list.get(0))) {
                            question = new TrainingQuestionVo();
                            question.setQuestionClass(typeId);
                            question.setEnterpriseId(user.getGroupId());
                            question.setPaperId(paperId);
                            if (list.get(0).toString().trim().length() > 500) {
                                ++errorNum;
                                continue;
                            }
                            if (list.get(1).toString().trim().length() == 1 || "AB".contains(list.get(1).toString().toUpperCase())) {
                                question.setQuestionType(Integer.valueOf(4));
                                question.setQuestionName(list.get(0).toString());
                                if (list.get(2) != null && !StringUtils.isEmpty((Object)list.get(2))) {
                                    question.setRemark(list.get(2).toString());
                                }
                                if (list.get(1).toString().trim().toUpperCase().equals("A")) {
                                    question.setIsCorrect(Integer.valueOf(1));
                                } else {
                                    question.setIsCorrect(Integer.valueOf(0));
                                }
                                ++successNum;
                                questionList.add(question);
                                continue;
                            }
                            ++errorNum;
                            continue;
                        }
                        ++errorNum;
                        continue;
                    }
                    ++errorNum;
                }
                this.paperService.saveQuestionDetail(questionList);
                result.put("successNum", successNum);
                result.put("errorNum", errorNum);
            }
            return JsonResult.success(result);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return JsonResult.error(null, (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/saveQuestion"})
    @ResponseBody
    public String saveQuestion(@RequestBody TrainingQuestionVo questionVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (questionVo.getPaperId() == null) {
            return JsonResult.paramError();
        }
        questionVo.setEnterpriseId(user.getGroupId());
        this.paperService.saveQuestion(questionVo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveQuestions"})
    @ResponseBody
    public String saveQuestions(String questionVosStr, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (StringUtils.isEmpty((Object)questionVosStr) || paperId == null) {
            return JsonResult.paramError();
        }
        List questionVos = JSON.parseArray((String)questionVosStr, TrainingQuestionVo.class);
        this.paperService.saveQuestions(questionVos, user.getGroupId(), paperId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteQuestionByQuestionId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteQuestionByQuestionId(String questionIds, Integer paperId) {
        if (StringUtils.isEmpty((Object)questionIds) || paperId == null) {
            return JsonResult.paramError();
        }
        if (this.paperService.getPaperDoCount(paperId) > 0) {
            return "QUESTION_IS_USE";
        }
        this.paperService.deleteTrainingQuestion(questionIds, paperId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveOptions"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveOptions(TrainingOptionsVo options) {
        this.paperService.saveOptions(options);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteOptions"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteOptions(Integer optionsId) {
        this.paperService.deleteOptions(optionsId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getQuestionSize"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionSize(String typeId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            return JsonResult.success(this.paperService.getQuestionCount(user.getGroupId(), typeId));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return JsonResult.error(null, (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/getPaperDoCount"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperDoCount(Integer paperId) {
        return JsonResult.success((Object)this.paperService.getPaperDoCount(paperId));
    }

    private String userSelect(Integer s) {
        String select = "";
        switch (s) {
            case 0: {
                select = "A";
                break;
            }
            case 1: {
                select = "B";
                break;
            }
            case 2: {
                select = "C";
                break;
            }
            case 3: {
                select = "D";
                break;
            }
            case 4: {
                select = "E";
                break;
            }
            case 5: {
                select = "F";
                break;
            }
            case 6: {
                select = "G";
                break;
            }
            case 7: {
                select = "H";
                break;
            }
            case 8: {
                select = "I";
                break;
            }
            case 9: {
                select = "J";
                break;
            }
        }
        return select;
    }
}

