/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.vo.TrainingPaperRankingUserVo;
import com.ovopark.training.vo.TrainingPaperRankingVo;
import com.ovopark.training.vo.TrainingPaperVo;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/ranking"})
public class TrainingRankingController {
    @Autowired
    private TrainingPaperRemoteService paperService;

    @RequestMapping(value={"/getRankPaperIdByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRankPaperIdByPage(Page<TrainingPaperVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getUserPaperByUserIdByPage(page, user.getId()));
    }

    @RequestMapping(value={"/getPaperRankingList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperRankingList(Integer paperId, String startTime, String endTime) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPaperRankingVo vo = this.paperService.getPaperRankingList(user.getGroupId(), user.getId(), paperId);
        vo.setUserName(user.getShowName());
        if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
            for (TrainingPaperRankingUserVo userVo : vo.getUserList()) {
                String imageUrl = ImageUtil.getUserPicByUserId(userVo.getUserId());
                if (StringUtils.isEmpty((Object)imageUrl)) continue;
                userVo.setImageUrl(imageUrl);
            }
        }
        vo.setMyImageUrl(ImageUtil.getUserPicByUserId(user.getId()));
        return JsonResult.success((Object)vo);
    }
}

