/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingTask;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.vo.TrainingTaskVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/trainingTask"})
public class TrainingTaskController {
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingRemoteService trainingRemoteService;

    @RequestMapping(value={"/addTrainingTask"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addTrainingTask(@RequestBody TrainingTask trainingTask) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingRemoteService.addTrainingTask(trainingTask, user.getId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingTask"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingTask(Integer trainingTaskId) {
        this.trainingRemoteService.deleteTrainingTask(trainingTaskId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingTask"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingTask(Page<TrainingTaskVo> page, String name) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingRemoteService.getTrainingTask(page, user.getGroupId(), name, user));
    }
}

