/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.model.GoldModuleEnterpriseDetail;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.pojo.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.GoldService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.UserRemoteService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TheirPapersVo;
import com.ovopark.training.vo.TrainingPaperRankingUserVo;
import com.ovopark.training.vo.TrainingPaperVo;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/webTrainingPaper"})
public class WebTrainingPaperController {
    private static final Logger log = LoggerFactory.getLogger(WebTrainingPaperController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private GoldService goldService;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private UserRemoteService userRemoteService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Resource
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/getWebPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebPaperByPage(Page<TrainingPaperVo> page, String paperName, Integer enterpriseId, Integer status, String order) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Integer userId = user.getId();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        } else {
            userId = null;
        }
        return JsonResult.success(this.paperService.getMarkingPaperByPage(page, paperName, enterpriseId, userId, status, order));
    }

    @RequestMapping(value={"/getWebUserPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebUserPaperByPage(Page<TrainingPaperVo> page, Integer paperId, String userName, Integer enterpriseId, Integer status, String order) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getUserMarkingPaperByPage(page, paperId, userName, enterpriseId, status, order));
    }

    @RequestMapping(value={"/getEssayQuestionByUserPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getEssayQuestionByUserPaperId(Integer userPaperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        BaseResult baseResult = this.redisBaseApi.get("getEssayQuestionByUserPaperId_" + userPaperId);
        Integer userId = null;
        if (baseResult != null && !StringUtils.isEmpty((Object)baseResult.getData())) {
            userId = Integer.valueOf((String)baseResult.getData());
        }
        if (userId != null && userId.intValue() != user.getId().intValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ((UsersPojo)this.userApi.getUserById(userId).getData()).getShowName());
            map.put("code", "QUESTION_IS_USE");
            return JsonResult.success(map);
        }
        if (userId == null) {
            TrainingUserPaper trainingUserPaper = this.paperService.getUserPaper(userPaperId);
            if (trainingUserPaper != null && trainingUserPaper.getPaperStatus() == 2) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", "PAPER_IS_FINISH");
                return JsonResult.success(map);
            }
            this.redisBaseApi.setExpire("getEssayQuestionByUserPaperId_" + userPaperId, user.getId().toString(), Integer.valueOf(3600));
        }
        return JsonResult.success((Object)this.paperService.getEssayQuestionByUserPaperId(userPaperId));
    }

    @RequestMapping(value={"/getUserPaperByOrganizeDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperByOrganizeDetail(Page<TrainingPaperRankingUserVo> page, String treeId, Integer paperId, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getUserPaperByOrganizeDetail(page, treeId, paperId, user, enterpriseId));
    }

    @RequestMapping(value={"/getUserPaperNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperNum(String treeId, Integer paperId, String userName, String startTime, String endTime) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (paperId != null) {
                return JsonResult.success((Object)this.paperService.getUserPaperNum(treeId, paperId, user, userName, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(endTime), null));
            }
            log.error("getUserPaperNum: paperId is null");
            return "INVALID_PARAMETER";
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/theirEssayQuestion"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String theirEssayQuestion(String jsonStr) {
        TrainingPaperVo paper = (TrainingPaperVo)JSONObject.parseObject((String)jsonStr, TrainingPaperVo.class);
        if (paper.getId() == null || StringUtils.isEmpty((Object)paper.getQuestionList())) {
            return JsonResult.paramError();
        }
        this.redisBaseApi.remove("getEssayQuestionByUserPaperId_" + paper.getId());
        Users user = Authenticator.getInstance().getCurrentUser();
        Integer userId = user.getId();
        TheirPapersVo result = this.paperService.theirEssayQuestion(paper, userId);
        try {
            List<GoldModuleEnterpriseDetail> goldModuleEnterpriseDetail = this.goldService.getGoldModuleEnterpriseDetailByEnterpriseId(user.getGroupId(), "TRSINING_PAPER");
            if (!CollectionUtils.isEmpty(goldModuleEnterpriseDetail)) {
                result.setRuleScore(Integer.valueOf(-1));
            }
        }
        catch (Exception e) {
            log.error("\u9605\u5377--\u91d1\u5e01\u5f02\u5e38", (Throwable)e);
        }
        if (!StringUtils.isEmpty((Object)userId)) {
            if (!StringUtils.isEmpty((Object)result.getSourceType())) {
                if (result.getSourceType() == 3) {
                    try {
                        this.appTrainingLearnProjectService.updateExamTaskStatus(paper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u9605\u5377--\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                } else if (result.getSourceType() == 4) {
                    try {
                        this.jobCertificationService.updatePaperStatus(paper.getId());
                    }
                    catch (Exception e) {
                        log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                    }
                } else if (result.getSourceType() == 5) {
                    try {
                        this.trainingCourseService.saveCourseTaskEnd(paper.getId(), 2, null, null, null);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                    }
                }
            } else {
                try {
                    this.appTrainingLearnProjectService.updateExamTaskStatus(paper.getId());
                }
                catch (Exception e) {
                    log.error("\u9605\u5377--\u63d0\u4ea4\u8bd5\u5377\u9879\u76ee\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                }
                try {
                    this.jobCertificationService.updatePaperStatus(paper.getId());
                }
                catch (Exception e) {
                    log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
                }
                try {
                    this.trainingCourseService.saveCourseTaskEnd(paper.getId(), 2, null, null, null);
                }
                catch (Exception e) {
                    log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u7ed3\u675f", (Throwable)e);
                }
            }
        }
        return JsonResult.success((Object)result);
    }

    @RequestMapping(value={"/getQuestionDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionDetail(Integer paperId, String organizeIds, String userName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.paperService.getQuestionDetail(paperId, organizeIds, user, userName));
    }

    @RequestMapping(value={"/getVisitorByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getVisitorByPage(Page<Map<String, Object>> page, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.paperService.getVisitorByPage(page, user.getGroupId(), paperId));
    }

    @RequestMapping(value={"/exportVisitorPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String exportVisitorPaper(HttpServletResponse response, Integer paperId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List<Map<String, Object>> list = this.paperService.exportVisitorPaper(user.getGroupId(), paperId);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String rowNum = this.messageSource.getMessage("training.paper.student.ranking", null, locale);
            String name = "\u6e38\u5ba2\u59d3\u540d";
            String createTime = this.messageSource.getMessage("training.enterprise", null, locale);
            String paperDate = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String score = "\u6210\u7ee9";
            String ranking = this.messageSource.getMessage("training.user.details.paperTime", null, locale);
            String timeDiff = this.messageSource.getMessage("training.paper.exam.time", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.paper.visitor.score", null, locale));
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(rowNum);
            cell = row.createCell(1);
            cell.setCellValue(name);
            cell = row.createCell(2);
            cell.setCellValue(createTime);
            cell = row.createCell(3);
            cell.setCellValue(paperDate);
            cell = row.createCell(4);
            cell.setCellValue(score);
            cell = row.createCell(5);
            cell.setCellValue(ranking);
            cell = row.createCell(6);
            cell.setCellValue(timeDiff);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < list.size(); ++i) {
                int timeDiffs;
                row = sheet.createRow(i + 1);
                Map<String, Object> vo = list.get(i);
                row.createCell(0).setCellValue(vo.get("rowNum") == null ? "" : vo.get("rowNum").toString());
                row.createCell(1).setCellValue(vo.get("loginShowName") == null ? "" : vo.get("loginShowName").toString());
                row.createCell(2).setCellValue(vo.get("loginDepName") == null ? "" : vo.get("loginDepName").toString());
                row.createCell(3).setCellValue(vo.get("loginEmployeeNumber") == null ? "" : vo.get("loginEmployeeNumber").toString());
                row.createCell(4).setCellValue(vo.get("score") == null ? "" : vo.get("score").toString());
                row.createCell(5).setCellValue(vo.get("updateTime") == null ? "" : DateUtils.format(simpleDateFormat.parse(vo.get("updateTime").toString())));
                int n = timeDiffs = vo.get("timeDiff") == null ? 0 : Integer.parseInt(vo.get("timeDiff").toString());
                if (timeDiffs <= 60) {
                    row.createCell(6).setCellValue(timeDiffs + "min");
                    continue;
                }
                row.createCell(6).setCellValue(timeDiffs / 60 + "h" + (timeDiffs % 60 == 0 ? "" : timeDiffs % 60 + "min"));
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException | ParseException e) {
            log.error("\u6e38\u5ba2\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return JsonResult.success();
    }
}

