/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingQuestionService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/webTrainingQuestionBank"})
public class WebTrainingQuestionBankController {
    private static final Logger log = LoggerFactory.getLogger(WebTrainingQuestionBankController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingQuestionService questionService;

    @RequestMapping(value={"/getQuestionBankList"})
    @ResponseBody
    public String getQuestionBankList(Page<TrainingQuestionVo> page, Integer enterpriseId, Integer questionType, String questionName, Integer typeId, Integer isNotType, Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getQuestionBankByPage(page, enterpriseId, questionName, questionType, typeId, isNotType, materialId));
    }

    @RequestMapping(value={"/getQuestionBankListByPage"})
    @ResponseBody
    public String getQuestionBankListByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, String questionType, String questionName, Integer typeId, Integer isNotType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        List questionTypes = null;
        if (!StringUtils.isEmpty((Object)questionType)) {
            String[] questionTypeStr = questionType.split(",");
            List<String> types = Arrays.asList(questionTypeStr);
            questionTypes = types.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        return JsonResult.success(this.paperService.getQuestionBankListByPage(page, enterpriseId, questionName, questionTypes, typeId, isNotType));
    }

    @RequestMapping(value={"/deleteQuestionBankByQuestionId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteQuestionBankByQuestionId(HttpServletRequest req, String questionIds, Integer isAll, Integer typeId, Integer isNotType, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!user.getGroupId().equals(enterpriseId)) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        ArrayList<Integer> questionList = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)questionIds)) {
            String[] ids;
            for (String id : ids = questionIds.split(",")) {
                if (StringUtils.isEmpty((Object)id.trim())) continue;
                questionList.add(Integer.parseInt(id.trim()));
            }
        }
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("question_type_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.question_type_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.paperService.deleteQuestionBank(questionList, isAll, typeId, isNotType, enterpriseId, user, pojo);
    }

    @RequestMapping(value={"/saveQuestionBank"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveQuestionBank(@RequestBody TrainingQuestionVo questionVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            questionVo.setUpdater(user.getId());
            questionVo.setEnterpriseId(user.getGroupId());
            this.paperService.saveQuestionBank(questionVo, user);
            return JsonResult.success();
        }
        catch (Exception e) {
            log.info("saveQuestionBank: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/saveQuestionBankScore"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveQuestionBankScore(String questionVoStr, Integer paperId, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null) {
            enterpriseId = user.getGroupId();
        }
        List vos = JSONArray.parseArray((String)questionVoStr, TrainingQuestionVo.class);
        this.paperService.saveQuestionBankScore(vos, enterpriseId, paperId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveQuestionType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveQuestionType(String questionIds, Integer typeId, Integer isAll, Integer typeIdOld, Integer isNotType, Integer enterpriseId) {
        this.paperService.saveQuestionType(questionIds, typeId, isAll, typeIdOld, isNotType, enterpriseId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveNewQuestionBankDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveNewQuestionBankDetail(@RequestParam(value="file") MultipartFile file, Integer questionClass) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Map<Object, Object> result = new HashMap();
        try {
            if (!file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xls") && !file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                return JsonResult.error((String)"4", (Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            }
            result = this.questionService.saveNewQuestionBankDetail(file, user);
            return JsonResult.success(result);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6a21\u677f\u8bd5\u9898", (Throwable)e);
            return JsonResult.error((String)"\u5bfc\u5165\u95ee\u9898", (Object)e);
        }
    }

    @RequestMapping(value={"/saveBankingQuestion"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveBankingQuestion(String ids, Integer paperId) {
        if (StringUtils.isEmpty((Object)ids) || paperId == null) {
            return JsonResult.paramError();
        }
        for (String id : ids.split(",")) {
            if (this.paperService.selectByPaperIdQuestionId(paperId, Integer.parseInt(id)) != 1) continue;
            return JSONObject.toJSONString((Object)JsonResult.newInstance((String)"NO_DATA", (Object)"\u9898\u76ee\u5df2\u5b58\u5728", (Boolean)true));
        }
        this.paperService.saveBankingQuestion(ids, paperId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/addQuestionType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addQuestionType(String title, Integer id, Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<TrainingQuestionType> questionTypeByTitiles = this.paperService.getQuestionTypeByTitile(title, user.getGroupId());
        if (!(CollectionUtils.isEmpty(questionTypeByTitiles) || id != null && questionTypeByTitiles.size() == 1 && questionTypeByTitiles.get(0).getId().equals(id))) {
            return JsonResult.success((Object)"NAME_EXISTING");
        }
        TrainingQuestionType trainingQuestionType = new TrainingQuestionType();
        trainingQuestionType.setCreater(user.getId());
        trainingQuestionType.setEnterpeiseId(user.getGroupId());
        trainingQuestionType.setTitle(title);
        trainingQuestionType.setId(id);
        trainingQuestionType.setMaterialId(materialId);
        this.paperService.addQuestionType(trainingQuestionType);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getQuestionType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionType(Integer enterpriseId, String typeName, Integer materialId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getQuestionType(enterpriseId, typeName, materialId));
    }

    @RequestMapping(value={"/delQuestionType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String delQuestionType(HttpServletRequest req, Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("question_bank_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.question_bank_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.paperService.delQuestionType(id, pojo);
    }

    @RequestMapping(value={"/getQuestionByType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getQuestionByType(Integer type, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.getQuestionByType(type, enterpriseId));
    }

    @RequestMapping(value={"/saveNewQuestion"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveNewQuestionBankDetail(@RequestParam(value="file") MultipartFile[] files) {
        Users user = Authenticator.getInstance().getCurrentUser();
        String errorQuestion = "";
        String errorOption = "";
        try {
            ArrayList resultList;
            block34: {
                resultList = new ArrayList();
                if (files == null || files.length <= 0) break block34;
                for (int n = 0; n < files.length; ++n) {
                    int successNum;
                    HashMap<String, Integer> result;
                    block35: {
                        MultipartFile file = files[n];
                        if (!file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xls") && !file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                            return JsonResult.error((String)"4", (Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
                        }
                        String fileName = file.getOriginalFilename().substring(0, file.getOriginalFilename().lastIndexOf(".")).trim();
                        List<TrainingQuestionType> questionTypeByTitiles = this.paperService.getQuestionTypeByTitile(fileName, user.getGroupId());
                        TrainingQuestionType trainingQuestionType = new TrainingQuestionType();
                        if (CollectionUtils.isEmpty(questionTypeByTitiles)) {
                            trainingQuestionType.setTitle(fileName);
                            trainingQuestionType.setCreater(user.getId());
                            trainingQuestionType.setEnterpeiseId(user.getGroupId());
                            trainingQuestionType = this.paperService.addQuestionType(trainingQuestionType);
                        } else {
                            trainingQuestionType = questionTypeByTitiles.get(0);
                        }
                        result = new HashMap<String, Integer>();
                        successNum = 0;
                        List<List<Object>> excelList0 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
                        if (CollectionUtils.isEmpty(excelList0)) break block35;
                        TrainingQuestionVo question = new TrainingQuestionVo();
                        ArrayList<TrainingQuestionVo> questionList = new ArrayList<TrainingQuestionVo>();
                        for (int i = 14; i < excelList0.size(); ++i) {
                            block33: {
                                TrainingOptionsVo options;
                                block41: {
                                    List<Object> list;
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        list = excelList0.get(i);
                                                        if (CollectionUtils.isEmpty(list)) continue;
                                                        if (StringUtils.isEmpty((Object)list.get(0)) || !"[SingleChoice]".equals(list.get(0).toString().trim()) && !"[MultipleChoice]".equals(list.get(0).toString().trim()) && !"[FillInBlank]".equals(list.get(0).toString().trim()) && !"[TrueFalse]".equals(list.get(0).toString().trim()) && !"[Essay]".equals(list.get(0).toString().trim())) break block36;
                                                        if (!StringUtils.isEmpty((Object)question.getQuestionName())) {
                                                            questionList.add(question);
                                                            ++successNum;
                                                        }
                                                        String questionType = list.get(0).toString().trim();
                                                        question = new TrainingQuestionVo();
                                                        question.setEnterpriseId(user.getGroupId());
                                                        question.setQuestionClass(trainingQuestionType.getId());
                                                        if (list.size() > 1 && !StringUtils.isEmpty((Object)list.get(1))) {
                                                            question.setQuestionName(list.get(1).toString().trim());
                                                        }
                                                        if ("[SingleChoice]".equals(questionType)) {
                                                            question.setQuestionType(Integer.valueOf(0));
                                                        } else if ("[MultipleChoice]".equals(questionType)) {
                                                            question.setQuestionType(Integer.valueOf(3));
                                                        } else if ("[FillInBlank]".equals(questionType)) {
                                                            question.setQuestionType(Integer.valueOf(2));
                                                        } else if ("[TrueFalse]".equals(questionType)) {
                                                            question.setQuestionType(Integer.valueOf(4));
                                                        } else if ("[Essay]".equals(questionType)) {
                                                            question.setQuestionType(Integer.valueOf(1));
                                                        }
                                                        errorQuestion = question.getQuestionName();
                                                        break block33;
                                                    }
                                                    if (question.getQuestionType() != 4) break block37;
                                                    if (!StringUtils.isEmpty((Object)list.get(5)) && list.get(5).toString().trim().toUpperCase().equals("Y") && !StringUtils.isEmpty((Object)list.get(2))) {
                                                        if ("\u662f".equals(list.get(2).toString().trim())) {
                                                            question.setIsCorrect(Integer.valueOf(1));
                                                        } else {
                                                            question.setIsCorrect(Integer.valueOf(0));
                                                        }
                                                    }
                                                    break block33;
                                                }
                                                if (0 != question.getQuestionType() && 3 != question.getQuestionType()) break block38;
                                                TrainingOptionsVo options2 = new TrainingOptionsVo();
                                                options2.setOptionsName(list.get(2).toString().trim());
                                                if (!StringUtils.isEmpty((Object)list.get(5)) && list.get(5).toString().trim().toUpperCase().equals("Y")) {
                                                    options2.setIsAnswer(Integer.valueOf(1));
                                                } else {
                                                    options2.setIsAnswer(Integer.valueOf(0));
                                                }
                                                errorOption = options2.getOptionsName();
                                                question.getOptionsList().add(options2);
                                                break block33;
                                            }
                                            if (question.getQuestionType() != 2) break block39;
                                            if (list.size() > 5) {
                                                if (!StringUtils.isEmpty((Object)list.get(5))) {
                                                    String[] optionStrs = list.get(5).toString().trim().split(";");
                                                    if (optionStrs != null) {
                                                        for (String optionStr : optionStrs) {
                                                            if ("".equals(optionStr)) continue;
                                                            TrainingOptionsVo options3 = new TrainingOptionsVo();
                                                            options3.setOptionsName(optionStr.trim());
                                                            options3.setIsAnswer(Integer.valueOf(1));
                                                            errorOption = options3.getOptionsName();
                                                            question.getOptionsList().add(options3);
                                                        }
                                                    }
                                                } else {
                                                    TrainingOptionsVo options4 = new TrainingOptionsVo();
                                                    options4.setIsAnswer(Integer.valueOf(1));
                                                    question.getOptionsList().add(options4);
                                                }
                                            } else {
                                                for (int m = list.size() - 1; m >= 0; --m) {
                                                    if (StringUtils.isEmpty((Object)list.get(m))) continue;
                                                    if ("[No Option]".equals(list.get(m).toString().trim())) {
                                                        TrainingOptionsVo options5 = new TrainingOptionsVo();
                                                        options5.setIsAnswer(Integer.valueOf(1));
                                                        question.getOptionsList().add(options5);
                                                        break block33;
                                                    }
                                                    String[] optionStrs = list.get(m).toString().trim().split(";");
                                                    if (optionStrs == null) continue;
                                                    for (String optionStr : optionStrs) {
                                                        if ("".equals(optionStr)) continue;
                                                        TrainingOptionsVo options6 = new TrainingOptionsVo();
                                                        options6.setOptionsName(optionStr.trim());
                                                        options6.setIsAnswer(Integer.valueOf(1));
                                                        errorOption = options6.getOptionsName();
                                                        question.getOptionsList().add(options6);
                                                    }
                                                }
                                            }
                                            break block33;
                                        }
                                        if (question.getQuestionType() != 1) break block33;
                                        options = new TrainingOptionsVo();
                                        if (list.size() <= 5) break block40;
                                        if (StringUtils.isEmpty((Object)list.get(5))) break block41;
                                        options.setOptionsName(list.get(5).toString().trim());
                                        break block41;
                                    }
                                    for (int m = list.size() - 1; m >= 0; --m) {
                                        if (StringUtils.isEmpty((Object)list.get(m))) continue;
                                        if ("[No Option]".equals(list.get(m).toString().trim())) break;
                                        options.setOptionsName(list.get(m).toString().trim());
                                        break;
                                    }
                                }
                                options.setIsAnswer(Integer.valueOf(1));
                                errorOption = options.getOptionsName();
                                question.getOptionsList().add(options);
                            }
                            if (i != excelList0.size() - 1 || StringUtils.isEmpty((Object)question.getQuestionName())) continue;
                            questionList.add(question);
                            ++successNum;
                        }
                        this.paperService.saveQuestionBankDetail(questionList);
                    }
                    result.put("successNum", successNum);
                    resultList.add(result);
                }
            }
            return JsonResult.success(resultList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u516585\u5ea6\u6a21\u677f\u8bd5\u9898:" + errorQuestion + ";" + errorOption, (Object)e.getMessage());
            e.printStackTrace();
            return JsonResult.error((String)(errorQuestion + ";" + errorOption), (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/selectUsingQuestion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUsingQuestion(@RequestBody List<TrainingQuestionVo> questionVos) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.paperService.selectUsingQuestion(questionVos));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("selectUsingQuestion: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectQuestionNewsByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectQuestionNewsByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, Integer questionType, String questionName, Integer typeId, Integer isNotType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.selectQuestionNewsByPage(page, enterpriseId, questionName, questionType, typeId, isNotType));
    }

    @RequestMapping(value={"/selectUsingQuestionType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUsingQuestionType(Integer isAll, Integer isNotType, String questionIds, Integer enterpriseId, Integer typeId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.paperService.selectUsingQuestionType(isAll, isNotType, questionIds, enterpriseId, typeId));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("selectUsingQuestionType: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectUsingQuestionList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUsingQuestionList(Integer isAll, Integer isNotType, String questionIds, Integer enterpriseId, Integer typeId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.paperService.selectUsingQuestionList(isAll, isNotType, questionIds, enterpriseId, typeId));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("selectUsingQuestionType: " + e);
            return JsonResult.error();
        }
    }
}

