/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPaperCompletionRateVo;
import com.ovopark.training.vo.TrainingPaperRankingUserVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/webTrainingUserCenter"})
public class WebTrainingUserCenterController {
    private static final Logger log = LoggerFactory.getLogger(WebTrainingUserCenterController.class);
    @Autowired
    private TrainingPaperRemoteService paperService;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/getWebUserCenterByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebUserCenterByPage(Page<TrainingPaperVo> page, String paperName, Integer enterpriseId, String order, String startDate, String endDate) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        Date sDate = null;
        Date eDate = null;
        if (!StringUtils.isEmpty((Object)startDate)) {
            sDate = DateUtils.parse(startDate + "-00", DateUtils.FORMAT_SHORT);
        }
        if (!StringUtils.isEmpty((Object)endDate)) {
            eDate = DateUtils.getEndTimeOfDay(DateUtils.parse(endDate + "-00", DateUtils.FORMAT_SHORT));
        }
        return JsonResult.success(this.paperService.getWebUserCenterByPage(page, paperName, enterpriseId, order, sDate, eDate));
    }

    @RequestMapping(value={"/getWebUserCenterByPaperIdByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebUserCenterByPaperIdByPage(Page<TrainingPaperVo> page, String userName, Integer paperId, Integer enterpriseId, Integer order, String startTime, String endTime, String organizeIds) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        return JsonResult.success(this.paperService.getWebUserCenterByPaperIdByPage(page, userName, paperId, enterpriseId, order, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), user, organizeIds));
    }

    @RequestMapping(value={"/getWebPageByUserPapeId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebPageByUserPapeId(Integer userPaperId) {
        return JsonResult.success(this.paperService.getErrorQuestionListById(userPaperId, null));
    }

    @RequestMapping(value={"/getPapersByuserId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPapersByuserId(Page<TrainingPaperVo> page, Integer userId, String startTime, String endTime, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.paperService.selectPapersByuserIdByPage(page, userId, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), enterpriseId));
    }

    @RequestMapping(value={"/getWebRankingList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRankingList(Page<TrainingPaperRankingUserVo> page, Integer enterpriseId, String userName, String organizeIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        return JsonResult.success(this.paperService.getWebRankingList(page, enterpriseId, userName, organizeIds, user));
    }

    @RequestMapping(value={"/getUserRankingList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserRankingList(Page<TrainingPaperRankingUserVo> page, Integer enterpriseId, String startDate, String endDate) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        return JsonResult.success(this.paperService.getUserWebRankingList(page, user.getId(), startDate, endDate));
    }

    @RequestMapping(value={"/getRankingListExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRankingListExcel(HttpServletResponse response, Integer enterpriseId, String userName, String organizeIds) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            }
            Page page = new Page();
            page.setPageSize(100000);
            Page<TrainingPaperRankingUserVo> list = this.paperService.getWebRankingList((Page<TrainingPaperRankingUserVo>)page, enterpriseId, userName, organizeIds, user);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String paperRanking = this.messageSource.getMessage("training.ranking.paperRanking", null, locale);
            String ranking = this.messageSource.getMessage("training.ranking.ranking", null, locale);
            String score = this.messageSource.getMessage("training.ranking.score", null, locale);
            String name = this.messageSource.getMessage("training.ranking.name", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(paperRanking);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(ranking);
            cell = row.createCell(1);
            cell.setCellValue(name);
            cell = row.createCell(2);
            cell.setCellValue(score);
            for (int i = 0; i < list.getContent().size(); ++i) {
                row = sheet.createRow(i + 1);
                TrainingPaperRankingUserVo vo = (TrainingPaperRankingUserVo)list.getContent().get(i);
                row.createCell(0).setCellValue((double)(i + 1));
                if (vo.getUserName() != null) {
                    row.createCell(1).setCellValue(vo.getUserName());
                } else if (vo.getLoginShowName() != null) {
                    row.createCell(1).setCellValue(vo.getLoginShowName());
                }
                row.createCell(2).setCellValue(vo.getScore().doubleValue());
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getPapersByuserIdExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPapersByuserIdExcel(HttpServletResponse response, Integer userId, String startTime, String endTime, Integer enterpriseId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            }
            Page page = new Page();
            page.setPageSize(100000);
            Page<TrainingPaperVo> list = this.paperService.selectPapersByuserIdByPage((Page<TrainingPaperVo>)page, userId, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), enterpriseId);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String paperName = this.messageSource.getMessage("training.paper.name", null, locale);
            String createTime = "\u8bd5\u5377\u521b\u5efa\u65f6\u95f4";
            String paperDate = this.messageSource.getMessage("training.paper.join.time", null, locale);
            String score = this.messageSource.getMessage("training.certificate.paper.score", null, locale);
            String ranking = this.messageSource.getMessage("training.paper.ranking", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.user.history.score", null, locale));
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(paperName);
            cell = row.createCell(1);
            cell.setCellValue(createTime);
            cell = row.createCell(2);
            cell.setCellValue(paperDate);
            cell = row.createCell(3);
            cell.setCellValue(score);
            cell = row.createCell(4);
            cell.setCellValue(ranking);
            for (int i = 0; i < list.getContent().size(); ++i) {
                row = sheet.createRow(i + 1);
                TrainingPaperVo vo = (TrainingPaperVo)list.getContent().get(i);
                row.createCell(0).setCellValue(vo.getPaperName() == null ? "" : vo.getPaperName() + "");
                row.createCell(1).setCellValue(vo.getCreateTime() == null ? "" : vo.getCreateTime() + "");
                row.createCell(2).setCellValue(vo.getPaperDate() == null ? "" : vo.getPaperDate() + "");
                row.createCell(3).setCellValue(vo.getScore() == null ? "" : vo.getScore() + "");
                row.createCell(4).setCellValue(vo.getRanking() == null ? "" : vo.getRanking() + "");
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getUserPaperByOrganizeDetailExcel"})
    @ResponseBody
    public String getUserPaperByOrganizeDetailExcel(HttpServletResponse response, String treeId, Integer paperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            List<TrainingPaperRankingUserVo> list = this.paperService.getUserPaperByOrganizeDetailExcel(treeId, paperId, user);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String title = "\u8003\u8bd5\u5b8c\u6210\u60c5\u51b5\u7efc\u5408\u53cd\u6620\u8868";
            String paperName = this.messageSource.getMessage("training.paper.name", null, locale);
            String paperStartTime = "\u8003\u8bd5\u89c4\u5b9a\u5f00\u59cb\u65f6\u95f4";
            String paperEndTime = "\u8003\u8bd5\u89c4\u5b9a\u7ed3\u675f\u65f6\u95f4";
            String userName = "\u767b\u5f55\u8d26\u53f7";
            String showName = this.messageSource.getMessage("training.user.details.name", null, locale);
            String tree = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String dep = "\u6240\u5c5e\u95e8\u5e97";
            String roleName = this.messageSource.getMessage("training.course.analysis.role", null, locale);
            String isFinish = this.messageSource.getMessage("training.paper.is.finish", null, locale);
            String paperTime = this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
            String score = this.messageSource.getMessage("training.paper.exam.score", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.user.history.score", null, locale));
            sheet.setColumnWidth(0, 3000);
            sheet.setColumnWidth(1, 3000);
            sheet.setColumnWidth(2, 3000);
            sheet.setColumnWidth(3, 2000);
            sheet.setColumnWidth(4, 2000);
            sheet.setColumnWidth(5, 8000);
            sheet.setColumnWidth(6, 8000);
            sheet.setColumnWidth(7, 5000);
            CellRangeAddress region0 = new CellRangeAddress(0, 0, 0, 10);
            sheet.addMergedRegion(region0);
            HSSFRow row0 = sheet.createRow(0);
            HSSFCell cell0 = row0.createCell(0);
            row0.setHeight((short)600);
            cell0.setCellValue(title);
            cell0.setCellStyle((CellStyle)titleSty);
            HSSFRow row = sheet.createRow(1);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(paperName);
            cell = row.createCell(1);
            cell.setCellValue(paperStartTime);
            cell = row.createCell(2);
            cell.setCellValue(paperEndTime);
            cell = row.createCell(3);
            cell.setCellValue(userName);
            cell = row.createCell(4);
            cell.setCellValue(showName);
            cell = row.createCell(5);
            cell.setCellValue(tree);
            cell = row.createCell(6);
            cell.setCellValue(dep);
            cell = row.createCell(7);
            cell.setCellValue(roleName);
            cell = row.createCell(8);
            cell.setCellValue(isFinish);
            cell = row.createCell(9);
            cell.setCellValue(paperTime);
            cell = row.createCell(10);
            cell.setCellValue(score);
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 2);
                TrainingPaperRankingUserVo vo = list.get(i);
                row.createCell(0).setCellValue(vo.getPaperName() == null ? "" : vo.getPaperName());
                row.createCell(1).setCellValue(vo.getPaperStartTime() == null ? "" : DateUtils.format(vo.getPaperStartTime()));
                row.createCell(2).setCellValue(vo.getPaperEndTime() == null ? "" : DateUtils.format(vo.getPaperEndTime()));
                row.createCell(3).setCellValue(vo.getUserName());
                row.createCell(4).setCellValue(vo.getShowName());
                row.createCell(5).setCellValue(vo.getTreeStr() == null ? "" : vo.getTreeStr());
                row.createCell(6).setCellValue(vo.getDepName() == null ? "" : vo.getDepName());
                row.createCell(7).setCellValue(vo.getRoleName() == null ? "" : vo.getRoleName());
                String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                row.createCell(8).setCellValue(vo.getIsFinish() == 0 ? unfinish : completed);
                row.createCell(9).setCellValue(vo.getPaperTime() == null ? "" : DateUtils.format(vo.getPaperTime()));
                row.createCell(10).setCellValue(vo.getScore() == null ? "" : vo.getScore().toString());
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getQuestionDetailExcel"})
    @ResponseBody
    public String getQuestionDetailExcel(HttpServletResponse response, Integer paperId, String organizeIds, String userName) {
        try {
            Page page = new Page();
            page.setPageSize(100000);
            Users user = Authenticator.getInstance().getCurrentUser();
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String type = this.messageSource.getMessage("training.user.details.type", null, locale);
            String title = this.messageSource.getMessage("training.user.details.title", null, locale);
            String optionA = this.messageSource.getMessage("training.user.details.option", null, locale) + "A";
            String optionB = this.messageSource.getMessage("training.user.details.option", null, locale) + "B";
            String optionC = this.messageSource.getMessage("training.user.details.option", null, locale) + "C";
            String optionD = this.messageSource.getMessage("training.user.details.option", null, locale) + "D";
            String optionE = this.messageSource.getMessage("training.user.details.option", null, locale) + "E";
            String optionF = this.messageSource.getMessage("training.user.details.option", null, locale) + "F";
            String optionG = this.messageSource.getMessage("training.user.details.option", null, locale) + "G";
            String optionH = this.messageSource.getMessage("training.user.details.option", null, locale) + "H";
            String optionI = this.messageSource.getMessage("training.user.details.option", null, locale) + "I";
            String optionJ = this.messageSource.getMessage("training.user.details.option", null, locale) + "J";
            String questionDistribute = this.messageSource.getMessage("training.user.answer.distribution", null, locale);
            String questionNum = this.messageSource.getMessage("training.user.topic.order", null, locale);
            String checkDistribute = this.messageSource.getMessage("training.user.option.distribution", null, locale);
            String rightNum = this.messageSource.getMessage("training.user.rightNum", null, locale);
            String errNum = this.messageSource.getMessage("training.answer.error.count", null, locale);
            String emptyNum = this.messageSource.getMessage("training.user.no.reply.number", null, locale);
            String right = this.messageSource.getMessage("training.user.right.rate", null, locale);
            String detail = this.messageSource.getMessage("training.user.option.detail", null, locale);
            String rString = this.messageSource.getMessage("training.exam.right", null, locale);
            String err = this.messageSource.getMessage("training.exam.error", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(questionDistribute);
            CellRangeAddress region0 = new CellRangeAddress(0, 0, 0, 16);
            sheet.addMergedRegion(region0);
            CellRangeAddress region01 = new CellRangeAddress(0, 0, 17, 26);
            sheet.addMergedRegion(region01);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont createFont = wb.createFont();
            createFont.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)createFont);
            HSSFCellStyle sty1 = wb.createCellStyle();
            HSSFCellStyle sty2 = wb.createCellStyle();
            HSSFCellStyle sty3 = wb.createCellStyle();
            CellRangeAddress region1 = new CellRangeAddress(1, 2, 0, 0);
            sheet.addMergedRegion(region1);
            CellRangeAddress region2 = new CellRangeAddress(1, 2, 1, 1);
            sheet.addMergedRegion(region2);
            CellRangeAddress region3 = new CellRangeAddress(1, 2, 2, 2);
            sheet.addMergedRegion(region3);
            CellRangeAddress region4 = new CellRangeAddress(1, 2, 3, 3);
            sheet.addMergedRegion(region4);
            CellRangeAddress region5 = new CellRangeAddress(1, 2, 4, 4);
            sheet.addMergedRegion(region5);
            CellRangeAddress region6 = new CellRangeAddress(1, 2, 5, 5);
            sheet.addMergedRegion(region6);
            CellRangeAddress region7 = new CellRangeAddress(1, 2, 6, 6);
            sheet.addMergedRegion(region7);
            CellRangeAddress region8 = new CellRangeAddress(1, 1, 7, 16);
            sheet.addMergedRegion(region8);
            CellRangeAddress region9 = new CellRangeAddress(1, 1, 17, 26);
            sheet.addMergedRegion(region9);
            sheet.setColumnWidth(0, 2500);
            sheet.setColumnWidth(1, 2500);
            sheet.setColumnWidth(2, 12000);
            sheet.setColumnWidth(3, 2500);
            sheet.setColumnWidth(4, 2500);
            sheet.setColumnWidth(5, 2500);
            sheet.setColumnWidth(6, 2500);
            sheet.setColumnWidth(7, 3000);
            sheet.setColumnWidth(8, 3000);
            sheet.setColumnWidth(9, 3000);
            sheet.setColumnWidth(10, 3000);
            sheet.setColumnWidth(11, 3000);
            sheet.setColumnWidth(12, 3000);
            sheet.setColumnWidth(13, 3000);
            sheet.setColumnWidth(14, 3000);
            sheet.setColumnWidth(15, 3000);
            sheet.setColumnWidth(16, 3000);
            sheet.setColumnWidth(17, 3000);
            sheet.setColumnWidth(18, 4000);
            sheet.setColumnWidth(19, 4000);
            sheet.setColumnWidth(20, 4000);
            sheet.setColumnWidth(21, 4000);
            sheet.setColumnWidth(22, 4000);
            sheet.setColumnWidth(23, 4000);
            sheet.setColumnWidth(24, 4000);
            sheet.setColumnWidth(25, 4000);
            sheet.setColumnWidth(26, 4000);
            HSSFRow row = sheet.createRow(0);
            row.setHeight((short)1000);
            HSSFCell cell = row.createCell(0);
            cell.setCellStyle((CellStyle)titleSty);
            cell.setCellValue(questionDistribute);
            HSSFCell cell17 = row.createCell(17);
            cell17.setCellStyle((CellStyle)titleSty);
            HSSFRow row1 = sheet.createRow(1);
            HSSFCell cell1 = row1.createCell(0);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(questionNum);
            cell1 = row1.createCell(1);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(type);
            cell1 = row1.createCell(2);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(title);
            cell1 = row1.createCell(3);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(rightNum);
            cell1 = row1.createCell(4);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(errNum);
            cell1 = row1.createCell(5);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(emptyNum);
            cell1 = row1.createCell(6);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(right);
            cell1 = row1.createCell(7);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(checkDistribute);
            cell1 = row1.createCell(17);
            cell1.setCellStyle((CellStyle)sty1);
            cell1.setCellValue(detail);
            HSSFRow row2 = sheet.createRow(2);
            HSSFCell cell2 = row2.createCell(7);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionA);
            cell2 = row2.createCell(8);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionB);
            cell2 = row2.createCell(9);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionC);
            cell2 = row2.createCell(10);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionD);
            cell2 = row2.createCell(11);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionE);
            cell2 = row2.createCell(12);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionF);
            cell2 = row2.createCell(13);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionG);
            cell2 = row2.createCell(14);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionH);
            cell2 = row2.createCell(15);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionI);
            cell2 = row2.createCell(16);
            cell2.setCellStyle((CellStyle)sty2);
            cell2.setCellValue(optionJ);
            cell2 = row2.createCell(17);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionA);
            cell2 = row2.createCell(18);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionB);
            cell2 = row2.createCell(19);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionC);
            cell2 = row2.createCell(20);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionD);
            cell2 = row2.createCell(21);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionE);
            cell2 = row2.createCell(22);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionF);
            cell2 = row2.createCell(23);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionG);
            cell2 = row2.createCell(24);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionH);
            cell2 = row2.createCell(25);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionI);
            cell2 = row2.createCell(26);
            cell2.setCellStyle((CellStyle)sty3);
            cell2.setCellValue(optionJ);
            HSSFRow row3 = sheet.createRow(3);
            HSSFCellStyle rightSty = wb.createCellStyle();
            HSSFCellStyle optionSty = wb.createCellStyle();
            TrainingPapersVo questionDetail = this.paperService.getQuestionDetail(paperId, organizeIds, user, userName);
            if (questionDetail != null && !CollectionUtils.isEmpty((Collection)questionDetail.getQuestionVos())) {
                TrainingQuestionVo trainingQuestionVo = null;
                for (int i = 0; i < questionDetail.getQuestionVos().size(); ++i) {
                    int j;
                    trainingQuestionVo = (TrainingQuestionVo)questionDetail.getQuestionVos().get(i);
                    if (trainingQuestionVo.getQuestionType() == 1 || trainingQuestionVo.getQuestionType() == 2) {
                        questionDetail.getQuestionVos().remove(i);
                        --i;
                        continue;
                    }
                    Integer totalNumber = trainingQuestionVo.getRightNum() + trainingQuestionVo.getErrNum() + trainingQuestionVo.getEmptyNum();
                    row3 = sheet.createRow(i + 3);
                    row3.createCell(0).setCellValue((double)(i + 1));
                    row3.createCell(1).setCellValue(this.getTypeName(trainingQuestionVo.getQuestionType()));
                    row3.createCell(2).setCellValue(trainingQuestionVo.getQuestionName() == null ? "" : trainingQuestionVo.getQuestionName());
                    row3.createCell(3).setCellValue(trainingQuestionVo.getRightNum() == null ? "" : trainingQuestionVo.getRightNum() + "");
                    row3.createCell(4).setCellValue(trainingQuestionVo.getErrNum() == null ? "" : trainingQuestionVo.getErrNum() + "");
                    row3.createCell(5).setCellValue(trainingQuestionVo.getEmptyNum() == null ? "" : trainingQuestionVo.getEmptyNum() + "");
                    row3.createCell(6).setCellValue(totalNumber > 0 ? "" + String.format("%.1f", (double)trainingQuestionVo.getRightNum().intValue() / (double)totalNumber.intValue() * 100.0) + "%" : "0.00%");
                    if (CollectionUtils.isEmpty((Collection)trainingQuestionVo.getOptionNum())) continue;
                    List optionNum = trainingQuestionVo.getOptionNum();
                    HSSFCell createCell = null;
                    for (j = 0; j < optionNum.size(); ++j) {
                        createCell = row3.createCell(j + 7);
                        if (!CollectionUtils.isEmpty((Collection)trainingQuestionVo.getOptionsList()) && ((TrainingOptionsVo)trainingQuestionVo.getOptionsList().get(j)).getIsAnswer() == 1) {
                            createCell.setCellStyle((CellStyle)rightSty);
                        }
                        if (trainingQuestionVo.getQuestionType() == 4 && trainingQuestionVo.getIsCorrect() == 1 && j == 0) {
                            createCell.setCellStyle((CellStyle)rightSty);
                        } else if (trainingQuestionVo.getQuestionType() == 4 && trainingQuestionVo.getIsCorrect() == 0 && j == 1) {
                            createCell.setCellStyle((CellStyle)rightSty);
                        }
                        createCell.setCellValue(optionNum.get(j) == null ? "" : ((String)optionNum.get(j)).split(" ")[0]);
                    }
                    if (trainingQuestionVo.getQuestionType() == 4) {
                        createCell = row3.createCell(17);
                        if (trainingQuestionVo.getIsCorrect() == 1) {
                            createCell.setCellStyle((CellStyle)optionSty);
                        }
                        createCell.setCellValue(rString);
                        createCell = row3.createCell(18);
                        if (trainingQuestionVo.getIsCorrect() == 0) {
                            createCell.setCellStyle((CellStyle)optionSty);
                        }
                        createCell.setCellValue(err);
                    }
                    for (j = 0; j < trainingQuestionVo.getOptionsList().size(); ++j) {
                        createCell = row3.createCell(j + 17);
                        if (!CollectionUtils.isEmpty((Collection)trainingQuestionVo.getOptionsList()) && ((TrainingOptionsVo)trainingQuestionVo.getOptionsList().get(j)).getIsAnswer() == 1) {
                            createCell.setCellStyle((CellStyle)optionSty);
                        }
                        createCell.setCellValue(((TrainingOptionsVo)trainingQuestionVo.getOptionsList().get(j)).getOptionsName() == null ? "" : ((TrainingOptionsVo)trainingQuestionVo.getOptionsList().get(j)).getOptionsName());
                    }
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getWebPaperByName"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebPaperByName(Page<TrainingPaperVo> page, String paperName, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (enterpriseId == null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        return JsonResult.success(this.paperService.getWebPaperByNameByPage(page, paperName, enterpriseId));
    }

    @RequestMapping(value={"/getWebPaperRankingList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebPaperRankingList(Page<TrainingPaperRankingUserVo> page, Integer paperId, Integer enterpriseId, String startTime, String endTime, String userName, String organizeIds, Integer isFinish, Integer downloadType, Integer taskId) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            } else {
                return JsonResult.success();
            }
        }
        Page<TrainingPaperRankingUserVo> webPaperRankingList = this.paperService.getWebPaperRankingList(page, enterpriseId, paperId, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), userName, organizeIds, user, isFinish, downloadType, taskId);
        return JsonResult.success(webPaperRankingList);
    }

    @RequestMapping(value={"/getUserPaperList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserPaperList(Integer userId, Integer paperId) {
        return JsonResult.success(this.paperService.getWebPaperRankingListByUserId(userId, paperId));
    }

    @RequestMapping(value={"/getAllErrorQuestionListByPaperId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAllErrorQuestionListByPaperId(Integer paperId, Integer status, Integer userPaperId, Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Integer userId = user.getId();
        if (type != null && type == 1) {
            userId = null;
        } else {
            userPaperId = null;
        }
        return JsonResult.success(this.paperService.getAllErrorQuestionListsById(userId, paperId, status, userPaperId));
    }

    @RequestMapping(value={"/getWebPaperRankingListExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebPaperRankingListExcel(Integer paperId, HttpServletResponse response, Integer enterpriseId, String startTime, String endTime, String userName, String organizeIds, Integer isFinish, Integer downloadType, Integer taskId) {
        try {
            if (paperId == null) {
                return JsonResult.paramError();
            }
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            }
            if (downloadType == null) {
                downloadType = 0;
            }
            Page page = new Page();
            page.setPageSize(100000);
            Page<TrainingPaperRankingUserVo> list = this.paperService.getWebPaperRankingList((Page<TrainingPaperRankingUserVo>)page, enterpriseId, paperId, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), userName, organizeIds, user, isFinish, downloadType, taskId);
            Map<Integer, List<TrainingPaperRankingUserVo>> maps = this.paperService.getAllWebPaperRankingList(paperId);
            TrainingPaper trainingPaper = this.paperService.getTrainingPaper(paperId);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String paperRanking = this.messageSource.getMessage("training.ranking.paperRanking", null, locale);
            String ranking = this.messageSource.getMessage("training.paper.student.ranking", null, locale);
            String score = this.messageSource.getMessage("training.ranking.score", null, locale);
            String name = this.messageSource.getMessage("training.ranking.name", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String paperCount = "\u8003\u6b21";
            String depName = this.messageSource.getMessage("training.course.organize", null, locale);
            String shopName = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
            String paperTime = this.messageSource.getMessage("training.user.details.paperTime", null, locale);
            String time = "";
            if (!StringUtils.isEmpty((Object)startTime) && !StringUtils.isEmpty((Object)endTime)) {
                time = startTime + " \u2014\u2014 " + endTime;
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(paperRanking);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region0 = new CellRangeAddress(0, 0, 0, 6);
            sheet.addMergedRegion(region0);
            HSSFRow row0 = sheet.createRow(0);
            row0.setHeight((short)600);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, "          " + (ObjectUtils.isEmpty((Object)trainingPaper) ? "" : trainingPaper.getTitle()));
            CellRangeAddress region1 = new CellRangeAddress(1, 1, 0, 6);
            sheet.addMergedRegion(region1);
            HSSFRow row1 = sheet.createRow(1);
            row1.setHeight((short)400);
            String createTime = this.messageSource.getMessage("training.user.fraction.createTime", null, locale);
            ExcelUtil.initCell(row1.createCell(0), (CellStyle)titleSty, createTime + ": " + (ObjectUtils.isEmpty((Object)trainingPaper) ? "" : DateUtils.format(trainingPaper.getCreateTime())));
            CellRangeAddress region2 = new CellRangeAddress(2, 2, 0, 6);
            sheet.addMergedRegion(region2);
            HSSFRow row2 = sheet.createRow(2);
            row2.setHeight((short)400);
            TrainingPaperCompletionRateVo userPaperNum = this.paperService.getUserPaperNum(organizeIds, paperId, user, userName, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), taskId);
            ExcelUtil.initCell(row2.createCell(0), (CellStyle)titleSty, "          " + this.messageSource.getMessage("training.paper.people.count", new Object[]{userPaperNum.getTotalNum(), userPaperNum.getFinishNum(), userPaperNum.getAvgScore()}, locale));
            HSSFRow row = sheet.createRow(3);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(ranking);
            cell = row.createCell(1);
            cell.setCellValue(name);
            cell = row.createCell(2);
            cell.setCellValue(employeeNumber);
            cell = row.createCell(3);
            cell.setCellValue(depName);
            cell = row.createCell(4);
            cell.setCellValue(shopName);
            cell = row.createCell(5);
            cell.setCellValue(score);
            cell = row.createCell(6);
            cell.setCellValue(paperCount);
            cell = row.createCell(7);
            cell.setCellValue(paperTime);
            int paperCounts = 1;
            HSSFCellStyle newTitleSty = wb.createCellStyle();
            HSSFFont font1 = wb.createFont();
            font1.setFontHeightInPoints((short)12);
            newTitleSty.setFont((Font)font1);
            for (int i = 0; i < list.getContent().size(); ++i) {
                List<TrainingPaperRankingUserVo> webPaperRankingListByUserId;
                row = sheet.createRow(i + 3 + paperCounts);
                TrainingPaperRankingUserVo vo = (TrainingPaperRankingUserVo)list.getContent().get(i);
                row.createCell(0).setCellValue(vo.getRanking() != null ? vo.getRanking() + "" : "");
                if (vo.getUserName() != null) {
                    row.createCell(1).setCellValue(vo.getUserName());
                } else {
                    row.createCell(1).setCellValue(vo.getLoginShowName());
                }
                row.createCell(2).setCellValue(vo.getEmployeeNumber() != null ? vo.getEmployeeNumber() : "");
                row.createCell(3).setCellValue(vo.getDepName() != null ? vo.getDepName() : "");
                row.createCell(4).setCellValue(vo.getShopName() != null ? vo.getShopName() : "");
                row.createCell(5).setCellValue(vo.getScore() != null ? vo.getScore() + "" : "");
                row.createCell(6).setCellValue(vo.getPaperCount() != null ? vo.getPaperCount() + "" : "0");
                row.createCell(7).setCellValue(DateUtils.format(vo.getPaperStartTime()));
                if (downloadType == 1 || vo.getPaperCount() == null || vo.getPaperCount() <= 1 || CollectionUtils.isEmpty(webPaperRankingListByUserId = maps.get(vo.getUserId()))) continue;
                webPaperRankingListByUserId.remove(webPaperRankingListByUserId.size() - 1);
                for (int j = 0; j < webPaperRankingListByUserId.size(); ++j) {
                    HSSFRow countRow = sheet.createRow(i + paperCounts + j + 1 + 3);
                    countRow.setRowStyle((CellStyle)newTitleSty);
                    TrainingPaperRankingUserVo trainingPaperRankingUserVo = webPaperRankingListByUserId.get(j);
                    if (vo.getUserName() != null) {
                        countRow.createCell(1).setCellValue(trainingPaperRankingUserVo.getUserName());
                    } else {
                        countRow.createCell(1).setCellValue(trainingPaperRankingUserVo.getLoginShowName());
                    }
                    countRow.createCell(2).setCellValue(vo.getEmployeeNumber() != null ? vo.getEmployeeNumber() : "");
                    countRow.createCell(3).setCellValue(vo.getDepName() != null ? vo.getDepName() : "");
                    countRow.createCell(4).setCellValue(vo.getShopName() != null ? vo.getShopName() : "");
                    countRow.createCell(5).setCellValue(trainingPaperRankingUserVo.getScore() != null ? trainingPaperRankingUserVo.getScore() + "" : "");
                    countRow.createCell(6).setCellValue((double)(vo.getPaperCount() - j - 1));
                    countRow.createCell(7).setCellValue("\u6ce8\u610f\uff1a\u8be5\u6210\u7ee9\u4e0d\u8ba1\u5165\u540d\u6b21\uff01");
                }
                paperCounts += webPaperRankingListByUserId.size();
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getUsersByScore"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUsersByScore(Page<TrainingPaperRankingUserVo> page, Integer paperId, double min, double max, String startTime, String endTime, String userName, String organizeIds) {
        if (paperId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        HashMap<String, Object> result = new HashMap<String, Object>();
        page = this.paperService.getUserPaperByScore(page, paperId, min, max, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), organizeIds, userName, user);
        String str = String.format("%.1f", (double)page.getPageCount().longValue() / (double)page.getId().intValue() * 100.0);
        double c = Double.parseDouble(str);
        result.put("data", page);
        result.put("scoreProportion", c);
        return JsonResult.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/getSorceExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getSorceExcel(HttpServletResponse response, Integer paperId, Integer min, Integer max, String startTime, String endTime, String userName, String organizeIds) {
        try {
            ServletOutputStream os = null;
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                os = response.getOutputStream();
                Page page = new Page();
                page.setPageSize(100000);
                if (paperId == null) {
                    String string = JsonResult.paramError();
                    return string;
                }
                Page pages = new Page();
                pages.setPageSize(100000);
                Page<TrainingPaperRankingUserVo> list = this.paperService.getUserPaperByScore((Page<TrainingPaperRankingUserVo>)page, paperId, min.intValue(), max.intValue(), StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), organizeIds, userName, user);
                List paperRankingUserVos = list.getContent();
                String str = null;
                if (list.getPageCount() > 0L && list.getId() > 0) {
                    str = String.format("%.1f", (double)list.getPageCount().longValue() / (double)list.getId().intValue() * 100.0);
                }
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFSheet excelSheet = workbook.createSheet("\u5206\u6570\u5360\u6bd4\u7edf\u8ba1");
                excelSheet.setDefaultColumnWidth(15);
                ExcelUtil.setDataCellStyles(workbook, excelSheet);
                excelSheet.setColumnHidden(40, true);
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String showName = this.messageSource.getMessage("training.user.fraction.userName", null, locale);
                String createTime = this.messageSource.getMessage("training.user.fraction.createTime", null, locale);
                String score = this.messageSource.getMessage("training.user.fraction.score", null, locale);
                String fractionScreening = this.messageSource.getMessage("training.user.fraction.fractionScreening", null, locale);
                String points = this.messageSource.getMessage("training.user.fraction.points", null, locale);
                String fractionProportion = this.messageSource.getMessage("training.user.fraction.fractionProportion", null, locale);
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String depName = this.messageSource.getMessage("training.course.organize", null, locale);
                String shopName = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
                String[] titles = new String[]{showName, employeeNumber, depName, shopName, createTime, score};
                HSSFRow row = excelSheet.createRow(2);
                CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
                for (int i = 0; i < titles.length; ++i) {
                    row.setHeight((short)450);
                    ExcelUtil.initCell(row.createCell(i), style, titles[i]);
                }
                HSSFCellStyle titleSty = workbook.createCellStyle();
                HSSFFont font = workbook.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 5);
                excelSheet.addMergedRegion(region1);
                HSSFRow row0 = excelSheet.createRow(0);
                row0.setHeight((short)1000);
                ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, "      " + fractionScreening);
                StringBuffer sb = new StringBuffer();
                sb.append(min).append(" - ").append(max).append(points + ", " + fractionProportion + " :").append(StringUtils.isEmpty((Object)str) ? "0.0" : str).append("%");
                HSSFCellStyle newTitleSty = workbook.createCellStyle();
                HSSFFont newfont = workbook.createFont();
                newfont.setFontHeightInPoints((short)12);
                newTitleSty.setFont((Font)newfont);
                CellRangeAddress region2 = new CellRangeAddress(1, 1, 0, 5);
                excelSheet.addMergedRegion(region2);
                HSSFRow rowTemplate = excelSheet.createRow(1);
                rowTemplate.setHeight((short)600);
                ExcelUtil.initCell(rowTemplate.createCell(0), (CellStyle)newTitleSty, sb.toString());
                for (int i = 0; i < paperRankingUserVos.size(); ++i) {
                    TrainingPaperRankingUserVo vo = (TrainingPaperRankingUserVo)list.getContent().get(i);
                    HSSFRow row1 = excelSheet.createRow(i + 3);
                    row1.createCell(0).setCellValue(vo.getUserName());
                    row1.createCell(1).setCellValue(vo.getEmployeeNumber() != null ? vo.getEmployeeNumber() : "");
                    row1.createCell(2).setCellValue(vo.getDepName() != null ? vo.getDepName() : "");
                    row1.createCell(3).setCellValue(vo.getShopName() != null ? vo.getShopName() : "");
                    row1.createCell(4).setCellValue(DateUtils.format(vo.getCreateTime(), DateUtils.FORMAT_SHORT));
                    String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                    row1.createCell(5).setCellValue(vo.getScore() != null ? vo.getScore() + "" : unfinish);
                    row1.setHeight((short)400);
                    HSSFCellStyle dataSty = workbook.createCellStyle();
                    HSSFFont datafont = workbook.createFont();
                    datafont.setFontHeightInPoints((short)12);
                    dataSty.setFont((Font)datafont);
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
                ServletOutputStream out = response.getOutputStream();
                workbook.write((OutputStream)out);
                out.flush();
                out.close();
                workbook.close();
                return JsonResult.success();
            }
            catch (FileNotFoundException e) {
                log.error("", (Throwable)e);
                return JsonResult.success();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                return JsonResult.success();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
        return JsonResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getUsersPaperDetailExcel"})
    @ResponseBody
    public String getUsersPaperDetailExcel(HttpServletResponse response, String userPaperIds, String paperName, Integer paperId, String organizeIds, String startTime, String endTime, String userName) {
        try {
            ServletOutputStream os = null;
            try {
                int i;
                Users user = Authenticator.getInstance().getCurrentUser();
                os = response.getOutputStream();
                Page page = new Page();
                page.setPageSize(100000);
                Page pages = new Page();
                pages.setPageSize(100000);
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                Map<String, List<TrainingQuestionVo>> map = this.paperService.getErrorQuestionListByIdExcel(userPaperIds, null, locale, paperId, user, organizeIds, StringUtils.isEmpty((Object)startTime) ? null : DateUtils.parse(startTime), StringUtils.isEmpty((Object)endTime) ? null : DateUtils.parse(endTime), userName);
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFSheet excelSheet = workbook.createSheet("\u8bd5\u5377\u8be6\u60c5\u5bfc\u51fa");
                excelSheet.setDefaultColumnWidth(15);
                ExcelUtil.setDataCellStyles(workbook, excelSheet);
                excelSheet.setColumnHidden(40, true);
                String type = this.messageSource.getMessage("training.user.details.type", null, locale);
                String title = this.messageSource.getMessage("training.user.details.title", null, locale);
                String answer = this.messageSource.getMessage("training.user.details.answer", null, locale);
                String userAnswer1 = this.messageSource.getMessage("training.user.details.userAnswer", null, locale);
                String optionA = this.messageSource.getMessage("training.user.details.option", null, locale) + "A";
                String optionB = this.messageSource.getMessage("training.user.details.option", null, locale) + "B";
                String optionC = this.messageSource.getMessage("training.user.details.option", null, locale) + "C";
                String optionD = this.messageSource.getMessage("training.user.details.option", null, locale) + "D";
                String optionE = this.messageSource.getMessage("training.user.details.option", null, locale) + "E";
                String optionF = this.messageSource.getMessage("training.user.details.option", null, locale) + "F";
                String paperNameLocal = this.messageSource.getMessage("training.user.details.paperName", null, locale);
                String singleChoiceQuestion = this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale);
                String fillBlankQuestion = this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale);
                String essayQuestion = this.messageSource.getMessage("training.user.details.essayQuestion", null, locale);
                String trueOrFalseQuestions = this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale);
                String multipleChoiceQuestion = this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale);
                String score = this.messageSource.getMessage("training.ranking.score", null, locale);
                String invalidOption = this.messageSource.getMessage("training.user.details.invalid.option", null, locale);
                String[] titles = new String[]{type, title, answer, userAnswer1, optionA, optionB, optionC, optionD, optionE, optionF, score, invalidOption};
                HSSFRow row = excelSheet.createRow(1);
                CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
                for (i = 0; i < titles.length; ++i) {
                    row.setHeight((short)600);
                    ExcelUtil.initCell(row.createCell(i), style, titles[i]);
                }
                for (i = 0; i < titles.length; ++i) {
                    if (i == 1 || i >= 3) {
                        excelSheet.setColumnWidth(i, 8000);
                        continue;
                    }
                    excelSheet.setColumnWidth(i, 3000);
                }
                HSSFCellStyle titleSty = workbook.createCellStyle();
                HSSFFont font = workbook.createFont();
                font.setFontHeightInPoints((short)18);
                titleSty.setFont((Font)font);
                CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 9);
                excelSheet.addMergedRegion(region1);
                HSSFRow row0 = excelSheet.createRow(0);
                row0.setHeight((short)1300);
                ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, paperNameLocal + "\uff1a" + paperName);
                HSSFCellStyle titleSty1 = workbook.createCellStyle();
                HSSFFont font1 = workbook.createFont();
                font1.setFontHeightInPoints((short)12);
                titleSty1.setFont((Font)font1);
                HSSFCellStyle titleSty2 = workbook.createCellStyle();
                HSSFFont font2 = workbook.createFont();
                font2.setFontHeightInPoints((short)10);
                titleSty2.setFont((Font)font2);
                HSSFCellStyle titleSty3 = workbook.createCellStyle();
                HSSFFont font3 = workbook.createFont();
                font3.setFontHeightInPoints((short)10);
                titleSty3.setFont((Font)font3);
                Integer rowIndex = 2;
                if (!map.isEmpty()) {
                    for (Map.Entry<String, List<TrainingQuestionVo>> entry : map.entrySet()) {
                        String userNameNew = entry.getKey();
                        HSSFRow row1 = excelSheet.createRow(rowIndex.intValue());
                        row1.setHeight((short)800);
                        CellRangeAddress region = new CellRangeAddress(rowIndex.intValue(), rowIndex.intValue(), 0, 9);
                        excelSheet.addMergedRegion(region);
                        ExcelUtil.initCell(row1.createCell(0), (CellStyle)titleSty1, userNameNew.split(",")[0] + "         " + userNameNew.split(",")[1] + "         " + userNameNew.split(",")[2] + "         " + userNameNew.split(",")[3] + "         " + userNameNew.split(",")[4]);
                        rowIndex = rowIndex + 1;
                        for (TrainingQuestionVo trainingQuestionVo : entry.getValue()) {
                            int i2;
                            Object userAnswerSB;
                            int i3;
                            HSSFRow rowX = excelSheet.createRow(rowIndex.intValue());
                            rowX.setHeight((short)500);
                            List trainingOptionsVos = trainingQuestionVo.getOptionsList();
                            String isCorrect = "";
                            String userAnswer = "";
                            Cell cell0 = rowX.createCell(0);
                            Cell cell1 = rowX.createCell(1);
                            Cell cell2 = rowX.createCell(2);
                            Cell cell3 = rowX.createCell(3);
                            if (trainingQuestionVo.getQuestionType() == 0) {
                                cell0.setCellValue(singleChoiceQuestion);
                                cell0.setCellStyle((CellStyle)titleSty2);
                                for (i3 = 0; i3 < trainingOptionsVos.size(); ++i3) {
                                    if (((TrainingOptionsVo)trainingOptionsVos.get(i3)).getIsSelect() != null && ((TrainingOptionsVo)trainingOptionsVos.get(i3)).getIsSelect() == 1) {
                                        userAnswer = this.userSelect(i3);
                                    }
                                    if (((TrainingOptionsVo)trainingOptionsVos.get(i3)).getIsAnswer() == null || ((TrainingOptionsVo)trainingOptionsVos.get(i3)).getIsAnswer() != 1) continue;
                                    isCorrect = this.userSelect(i3);
                                }
                            } else if (trainingQuestionVo.getQuestionType() == 1) {
                                cell0.setCellValue(essayQuestion);
                                cell0.setCellStyle((CellStyle)titleSty2);
                                if (!CollectionUtils.isEmpty((Collection)trainingOptionsVos) && ((TrainingOptionsVo)trainingOptionsVos.get(0)).getAnswer() != null) {
                                    userAnswer = ((TrainingOptionsVo)trainingOptionsVos.get(0)).getAnswer();
                                }
                                if (!CollectionUtils.isEmpty((Collection)trainingQuestionVo.getUserQuestionPictureList())) {
                                    List picList = trainingQuestionVo.getUserQuestionPictureList();
                                    for (TrainingUserQuestionPicture pic : picList) {
                                        userAnswer = userAnswer + " \n " + pic.getPicturePath();
                                    }
                                }
                                isCorrect = "A";
                            } else if (trainingQuestionVo.getQuestionType() == 2) {
                                cell0.setCellValue(fillBlankQuestion);
                                cell0.setCellStyle((CellStyle)titleSty2);
                                StringBuffer sb = new StringBuffer();
                                userAnswerSB = new StringBuffer();
                                for (i2 = 0; i2 < trainingOptionsVos.size(); ++i2) {
                                    if (((TrainingOptionsVo)trainingOptionsVos.get(i2)).getAnswer() != null) {
                                        ((StringBuffer)userAnswerSB).append(((TrainingOptionsVo)trainingOptionsVos.get(i2)).getAnswer()).append("\uff0c");
                                    } else {
                                        ((StringBuffer)userAnswerSB).append("\uff0c");
                                    }
                                    sb.append(this.userSelect(i2));
                                }
                                if (((StringBuffer)userAnswerSB).length() > 0) {
                                    userAnswerSB = ((StringBuffer)userAnswerSB).deleteCharAt(((StringBuffer)userAnswerSB).length() - 1);
                                }
                                userAnswer = ((StringBuffer)userAnswerSB).toString();
                                isCorrect = sb.toString();
                            } else if (trainingQuestionVo.getQuestionType() == 3) {
                                cell0.setCellValue(multipleChoiceQuestion);
                                cell0.setCellStyle((CellStyle)titleSty2);
                                StringBuffer isCorrectSB = new StringBuffer();
                                userAnswerSB = new StringBuffer();
                                for (i2 = 0; i2 < trainingOptionsVos.size(); ++i2) {
                                    if (((TrainingOptionsVo)trainingOptionsVos.get(i2)).getIsSelect() != null && ((TrainingOptionsVo)trainingOptionsVos.get(i2)).getIsSelect() == 1) {
                                        ((StringBuffer)userAnswerSB).append(this.userSelect(i2));
                                    }
                                    if (((TrainingOptionsVo)trainingOptionsVos.get(i2)).getIsAnswer() == null || ((TrainingOptionsVo)trainingOptionsVos.get(i2)).getIsAnswer() != 1) continue;
                                    isCorrectSB.append(this.userSelect(i2));
                                }
                                isCorrect = isCorrectSB.toString();
                                userAnswer = ((StringBuffer)userAnswerSB).toString();
                            } else if (trainingQuestionVo.getQuestionType() == 4) {
                                cell0.setCellValue(trueOrFalseQuestions);
                                cell0.setCellStyle((CellStyle)titleSty2);
                                if (!CollectionUtils.isEmpty((Collection)trainingQuestionVo.getOptionsList())) {
                                    List optionsVos = trainingQuestionVo.getOptionsList();
                                    for (TrainingOptionsVo optionVo : optionsVos) {
                                        if (!StringUtils.isEmpty((Object)optionVo.getIsAnswer()) && optionVo.getIsAnswer() == 1) {
                                            isCorrect = !StringUtils.isEmpty((Object)optionVo.getOptionsName()) && optionVo.getOptionsName().equals("1") ? this.messageSource.getMessage("training.exam.right", null, locale) : this.messageSource.getMessage("training.exam.error", null, locale);
                                        }
                                        if (StringUtils.isEmpty((Object)optionVo.getIsSelect()) || optionVo.getIsSelect() != 1) continue;
                                        if (!StringUtils.isEmpty((Object)optionVo.getOptionsName()) && optionVo.getOptionsName().equals("1")) {
                                            userAnswer = this.messageSource.getMessage("training.exam.right", null, locale);
                                            continue;
                                        }
                                        userAnswer = this.messageSource.getMessage("training.exam.error", null, locale);
                                    }
                                }
                            }
                            cell1.setCellValue(trainingQuestionVo.getQuestionName());
                            cell1.setCellStyle((CellStyle)titleSty2);
                            cell2.setCellValue(isCorrect);
                            cell2.setCellStyle((CellStyle)titleSty2);
                            cell3.setCellValue(userAnswer);
                            if (trainingQuestionVo.getIsCorrect() == 0) {
                                cell3.setCellStyle((CellStyle)titleSty3);
                            } else {
                                cell3.setCellStyle((CellStyle)titleSty2);
                            }
                            if (!CollectionUtils.isEmpty((Collection)trainingOptionsVos) && trainingQuestionVo.getQuestionType() != 4) {
                                for (i3 = 4; i3 < trainingOptionsVos.size() + 4; ++i3) {
                                    Cell cell = rowX.createCell(i3);
                                    cell.setCellValue(((TrainingOptionsVo)trainingOptionsVos.get(i3 - 4)).getOptionsName());
                                    cell.setCellStyle((CellStyle)titleSty2);
                                }
                            }
                            Cell cell10 = rowX.createCell(10);
                            cell10.setCellValue(trainingQuestionVo.getScore().doubleValue());
                            Cell cell11 = rowX.createCell(11);
                            cell11.setCellValue(trainingQuestionVo.getOtherAnswer());
                            rowIndex = rowIndex + 1;
                        }
                    }
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
                ServletOutputStream out = response.getOutputStream();
                workbook.write((OutputStream)out);
                out.flush();
                out.close();
                workbook.close();
            }
            catch (FileNotFoundException e) {
                log.error("", (Throwable)e);
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        log.error("", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
        return JsonResult.success();
    }

    private String userSelect(Integer s) {
        String select = "";
        switch (s) {
            case 0: {
                select = "A";
                break;
            }
            case 1: {
                select = "B";
                break;
            }
            case 2: {
                select = "C";
                break;
            }
            case 3: {
                select = "D";
                break;
            }
            case 4: {
                select = "E";
                break;
            }
            case 5: {
                select = "F";
                break;
            }
        }
        return select;
    }

    private String getTypeName(int s) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String select = "";
        switch (s) {
            case 0: {
                select = this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale);
                break;
            }
            case 1: {
                select = this.messageSource.getMessage("training.user.details.essayQuestion", null, locale);
                break;
            }
            case 2: {
                select = this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale);
                break;
            }
            case 3: {
                select = this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale);
                break;
            }
            case 4: {
                select = this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale);
                break;
            }
        }
        return select;
    }
}

