/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.delegate;

import com.alibaba.fastjson.JSON;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.training.constants.ExportConst;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.feign.ExportParam;
import com.ovopark.training.feign.TrainingExportApi;
import com.ovopark.training.util.DownloadUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportDelegate {
    private static final Logger log = LoggerFactory.getLogger(ExportDelegate.class);
    @Resource(name="oldCommon")
    private Executor exportExecutor;
    @Autowired
    private TrainingExportApi trainingExportApi;

    public ExportTaskPojo createConstTask(String path, String fileName, Object params, ExportConst.ClazzType clazzType, Supplier<Collection<?>> supplier) {
        ExportTaskPojo task = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)params));
        this.exportExecutor.execute(() -> {
            Collection objects = (Collection)supplier.get();
            if (objects == null) {
                DownloadUtils.errorExportTask(task);
                log.error("\u5bfc\u51fa\u5931\u8d25, supplier\u8fd4\u56denull");
                return;
            }
            ExportParam exportParam = new ExportParam();
            exportParam.setExportType(ExportConst.Type.ConstClazz);
            exportParam.setExportClazz(clazzType);
            exportParam.setPath(path);
            exportParam.setContentType(fileName.substring(fileName.lastIndexOf(".") + 1));
            exportParam.setCollectionJson(JSON.toJSONString((Object)objects));
            exportParam.setTask(task);
            Result<Void> result = this.trainingExportApi.export(exportParam);
            log.info("\u5bfc\u51fa\u7ed3\u679c param:{}, result:{}", (Object)exportParam, result);
        });
        return task;
    }

    public ExportTaskPojo createDynamicTask(String path, String fileName, Object params, List<List<String>> head, Supplier<List<List<Object>>> supplier) {
        ExportTaskPojo task = DownloadUtils.saveExportTask(fileName, JSON.toJSONString((Object)params));
        this.exportExecutor.execute(() -> {
            List lists = (List)supplier.get();
            if (lists == null) {
                DownloadUtils.errorExportTask(task);
                log.error("\u5bfc\u51fa\u5931\u8d25, supplier\u8fd4\u56denull");
                return;
            }
            ExportParam exportParam = new ExportParam();
            exportParam.setExportType(ExportConst.Type.DynamicHead);
            exportParam.setPath(path);
            exportParam.setContentType(fileName.substring(fileName.lastIndexOf(".") + 1));
            exportParam.setHead(head);
            exportParam.setItems(lists);
            exportParam.setTask(task);
            Result<Void> result = this.trainingExportApi.export(exportParam);
            log.info("\u5bfc\u51fa\u7ed3\u679c param:{}, result:{}", (Object)exportParam, result);
        });
        return task;
    }
}

