/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.delegate;

import com.google.common.collect.Lists;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.PrivilegeApi;
import com.ovopark.privilege.pojo.UsersPojo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class UserOrganizeDelegate {
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private PrivilegeApi privilegeApi;

    public BaseResult<List<Integer>> getUserOrganizeByTagAndOrgIds(@RequestBody UsersOrgIdsAndTagsPojo var1) {
        return this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(var1);
    }

    public List<SimplePojo> getUserListByUserOrganize(@RequestParam Integer groupId, @RequestParam Integer userId) {
        BaseResult baseResult = this.userOrganizeApi.getUserListByUserOrganize(groupId, userId);
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            return (List)baseResult.getData();
        }
        return Lists.newArrayList();
    }

    public List<Map<String, Object>> getUserOrganizeByUserId(@RequestBody List<Integer> userIds, @RequestParam Integer groupId) {
        BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByUserId(userIds, groupId);
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            return (List)baseResult.getData();
        }
        return Lists.newArrayList();
    }

    public Map<String, List<UserAndParentNameMo>> getUserByOrganizeIdMap(@RequestBody List<String> organizeIds, @RequestParam Integer groupId, @RequestParam Integer isFrozenNum, @RequestParam Integer isDelete) {
        if (CollectionUtils.isEmpty(organizeIds)) {
            return new HashMap<String, List<UserAndParentNameMo>>();
        }
        organizeIds = organizeIds.stream().distinct().collect(Collectors.toList());
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setOrganizeIds(organizeIds);
        mo.setIsFrozenNum(isFrozenNum);
        mo.setIsDelete(isDelete);
        BaseResult userMapByOrganizeIdsOrDepId = this.userOrganizeApi.getUserMapByOrganizeIdsOrDepId(mo);
        if (!userMapByOrganizeIdsOrDepId.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)userMapByOrganizeIdsOrDepId.getData()))) {
            return (Map)userMapByOrganizeIdsOrDepId.getData();
        }
        return new HashMap<String, List<UserAndParentNameMo>>();
    }

    public List<UsersPojo> getCoursePrivilegesUserList(@RequestParam Integer groupId, @RequestParam String privileges) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("privileges", privileges);
        com.ovopark.privilege.response.BaseResult baseResult = this.privilegeApi.hasCoursePrivilegesUserList(map);
        if (!baseResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            return (List)baseResult.getData();
        }
        return Lists.newArrayList();
    }
}

