/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.event;

import com.ovopark.training.event.EventService;
import com.ovopark.training.event.model.MaterialTypePermissionChange;
import com.ovopark.training.event.model.MaterialTypeStatCountByMoveEvent;
import com.ovopark.training.event.model.MaterialTypeStatCountEvent;
import com.ovopark.training.event.model.ResourceDeleteEvent;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventHelper {
    private static final Logger log = LoggerFactory.getLogger(EventHelper.class);
    @Autowired
    private EventService eventService;
    private static EventService sEventService;

    public static EventService get() {
        return sEventService;
    }

    @PostConstruct
    public void init() {
        sEventService = this.eventService;
    }

    public static void publishEvent(Object event) {
        sEventService.publishEvent(event);
        log.info("publishEvent: {}", event);
    }

    public static void sendMaterialTypeStatCountEvent(Object source, Integer ... materialTypeIdList) {
        List<Integer> list = Arrays.asList(materialTypeIdList);
        MaterialTypeStatCountEvent e = new MaterialTypeStatCountEvent(source, list);
        sEventService.publishEvent((Object)e);
    }

    public static void sendMaterialTypeStatCountByMoveEvent(Object source, List<Integer> list) {
        MaterialTypeStatCountByMoveEvent e = new MaterialTypeStatCountByMoveEvent(source, list);
        sEventService.publishEvent((Object)e);
    }

    public static void sendMaterialTypePermissionChange(Object source, List<Integer> materialTypeIdList) {
        MaterialTypePermissionChange e = new MaterialTypePermissionChange(source, materialTypeIdList);
        sEventService.publishEvent((Object)e);
    }

    public static void sendResourceDelete(Object source, List<Integer> resourceIdList) {
        ResourceDeleteEvent e = new ResourceDeleteEvent(source, resourceIdList);
        sEventService.publishEvent((Object)e);
    }
}

