/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.event.listener;

import com.ovopark.training.event.model.MaterialTypePermissionChange;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MaterialTypePermissionChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MaterialTypePermissionChangeListener.class);
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;

    @Async(value="oldCommon")
    @EventListener
    public void onMaterialTypePermissionChange(MaterialTypePermissionChange event) {
        log.info("onMaterialTypePermissionChange: {}", (Object)event);
        List<Integer> materialTypeIdList = event.getMaterialTypeIdList();
        this.resourceSinglePermissionService.onMaterialTypeListPermissionChange(materialTypeIdList);
    }
}

