/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.intercept;

import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SqlPrintInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlPrintInterceptor.class);
    @Value(value="${ovopark.sql.slow-time-millis:300}")
    private long slowSqlTimeMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        long startTime = System.currentTimeMillis();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long cost = endTime - startTime;
            if (cost > this.slowSqlTimeMillis) {
                log.warn("slow sql " + sql + "\nsql cost" + cost + "ms");
            } else {
                log.info("sql " + sql + "\nsql cost" + cost + "ms");
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

