/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.enterprise;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCommentMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialCommentMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingComment;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.enterprise.CommentService;
import com.ovopark.training.vo.TrainingCommentVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CommentServiceImpl
implements CommentService {
    @Autowired
    private TrainingMaterialCommentMapper trainingMaterialCommentMapper;
    @Autowired
    private TrainingCommentMapper trainingCommentMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingResourceMapper trainingResourceMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;

    @Override
    public void saveMaterialComment(TrainingMaterialComment trainingMaterialComment, Users user) {
        Date now = new Date();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getUserId, (Object)user.getId())).eq(TrainingMaterialComment::getMaterialId, (Object)trainingMaterialComment.getId())).eq(TrainingMaterialComment::getType, (Object)trainingMaterialComment.getType())).orderByAsc(TrainingMaterialComment::getId)).last(" limit 1 ");
        TrainingMaterialComment materialComment = (TrainingMaterialComment)this.trainingMaterialCommentMapper.selectOne((Wrapper)wrapper1);
        if (ObjectUtils.isEmpty((Object)materialComment)) {
            trainingMaterialComment.setMaterialId(trainingMaterialComment.getId());
            trainingMaterialComment.setId(null);
            trainingMaterialComment.setUserId(user.getId());
            trainingMaterialComment.setCreateTime(now);
            trainingMaterialComment.setUpdateTime(now);
            trainingMaterialComment.setEnterpriseId(user.getGroupId());
            this.trainingMaterialCommentMapper.insert(trainingMaterialComment);
            if (trainingMaterialComment.getIsLike() != null) {
                this.saveLikeCount(trainingMaterialComment);
            }
        } else {
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialComment::getId, (Object)materialComment.getId())).set(trainingMaterialComment.getIsCollect() != null, TrainingMaterialComment::getIsCollect, (Object)trainingMaterialComment.getIsCollect()).set(trainingMaterialComment.getIsLike() != null, TrainingMaterialComment::getIsLike, (Object)trainingMaterialComment.getIsLike()).set(TrainingMaterialComment::getUpdateTime, (Object)now);
            this.trainingMaterialCommentMapper.update(null, (Wrapper)wrapper2);
            if (trainingMaterialComment.getIsLike() != null) {
                trainingMaterialComment.setId(materialComment.getId());
                trainingMaterialComment.setMaterialId(materialComment.getMaterialId());
                this.saveLikeCount(trainingMaterialComment);
            }
        }
    }

    private void saveLikeCount(TrainingMaterialComment trainingMaterialComment) {
        if (trainingMaterialComment.getType() == 1) {
            TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(trainingMaterialComment.getMaterialId());
            if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                return;
            }
            Integer likeCount = trainingMaterial.getLikeCount();
            likeCount = trainingMaterialComment.getIsLike().compareTo(1) >= 0 ? likeCount + 1 : (likeCount > 0 ? likeCount - 1 : 0);
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(TrainingMaterial::getId, (Object)trainingMaterial.getId())).set(TrainingMaterial::getLikeCount, (Object)likeCount);
            this.trainingMaterialMapper.update(null, (Wrapper)wrapper1);
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingResource::getObjectId, (Object)trainingMaterial.getId())).eq(TrainingResource::getFileType, (Object)trainingMaterial.getFileType())).set(TrainingResource::getLikeCount, (Object)likeCount);
            this.trainingResourceMapper.update(null, (Wrapper)wrapper2);
        } else if (trainingMaterialComment.getType() == 2) {
            Training training = (Training)this.trainingMapper.selectById(trainingMaterialComment.getMaterialId());
            if (ObjectUtils.isEmpty((Object)training)) {
                return;
            }
            Integer likeCount = training.getLikeCount();
            likeCount = trainingMaterialComment.getIsLike().compareTo(1) >= 0 ? likeCount + 1 : (likeCount > 0 ? likeCount - 1 : 0);
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(Training::getId, (Object)training.getId())).set(Training::getLikeCount, (Object)likeCount);
            this.trainingMapper.update(null, (Wrapper)wrapper1);
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingResource::getObjectId, (Object)training.getId())).eq(TrainingResource::getFileType, (Object)8)).set(TrainingResource::getLikeCount, (Object)likeCount);
            this.trainingResourceMapper.update(null, (Wrapper)wrapper2);
        }
    }

    @Override
    public Page<TrainingCommentVo> getCommentByPage(Page<TrainingCommentVo> page, Integer id, Integer commentType) {
        List<TrainingCommentVo> trainingCommentVos = this.trainingCommentMapper.getTrainingCommentByPage(page, id, commentType);
        if (CollectionUtils.isEmpty(trainingCommentVos)) {
            return page;
        }
        List trainingCommentIdList = trainingCommentVos.stream().map(TrainingComment::getId).collect(Collectors.toList());
        List<Integer> userIdList = trainingCommentVos.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingComment::getTrainingId, (Object)id)).eq(TrainingComment::getCommentType, (Object)commentType)).in(TrainingComment::getCommentId, trainingCommentIdList)).eq(TrainingComment::getIsDel, (Object)0);
        List trainingCommentList = this.trainingCommentMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> trainingCommentMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingCommentList)) {
            List userIds = trainingCommentList.stream().map(TrainingComment::getUserId).distinct().collect(Collectors.toList());
            userIdList.addAll(userIds);
            trainingCommentMap = trainingCommentList.stream().collect(Collectors.groupingBy(TrainingComment::getReplyId));
        }
        Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
        Map<Integer, List<TrainingMaterialComment>> starMap = this.getStars(id, commentType, userIdList);
        for (TrainingCommentVo trainingCommentVo : trainingCommentVos) {
            List<TrainingMaterialComment> startList;
            this.getNextCommentList(trainingCommentVo, trainingCommentMap, usersPojoMap);
            UsersPojo usersPojo = usersPojoMap.get(trainingCommentVo.getUserId());
            if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                trainingCommentVo.setUserName(usersPojo.getShowName());
                trainingCommentVo.setUserImageUrl(usersPojo.getThumbUrl());
            }
            if (CollectionUtils.isEmpty(startList = starMap.get(trainingCommentVo.getUserId()))) continue;
            trainingCommentVo.setStars(startList.get(0).getStars());
        }
        page.setContent(trainingCommentVos);
        return page;
    }

    private Map<Integer, List<TrainingMaterialComment>> getStars(Integer id, Integer commentType, List<Integer> userIdList) {
        Map<Object, Object> starMap = Maps.newHashMap();
        if (commentType == 1 || commentType == 4) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialComment::getMaterialId, (Object)id)).in(TrainingMaterialComment::getUserId, userIdList)).eq(TrainingMaterialComment::getType, (Object)(commentType == 1 ? 2 : 1))).orderByAsc(TrainingMaterialComment::getId);
            List materialCommentList = this.trainingMaterialCommentMapper.selectList((Wrapper)wrapper2);
            if (CollectionUtils.isEmpty((Collection)materialCommentList)) {
                return starMap;
            }
            starMap = materialCommentList.stream().collect(Collectors.groupingBy(TrainingMaterialComment::getUserId));
        }
        return starMap;
    }

    private void getNextCommentList(TrainingCommentVo trainingCommentVo, Map<Integer, List<TrainingComment>> trainingCommentMap, Map<Integer, UsersPojo> usersPojoMap) {
        List<TrainingComment> trainingComments = trainingCommentMap.get(trainingCommentVo.getId());
        if (!CollectionUtils.isEmpty(trainingComments)) {
            ArrayList trainingCommentVoList = Lists.newArrayList();
            for (TrainingComment trainingComment : trainingComments) {
                TrainingCommentVo commentVo = new TrainingCommentVo();
                BeanUtils.copyProperties((Object)trainingComment, (Object)commentVo);
                this.getNextCommentList(commentVo, trainingCommentMap, usersPojoMap);
                UsersPojo usersPojo = usersPojoMap.get(commentVo.getUserId());
                if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                    commentVo.setUserName(usersPojo.getShowName());
                    commentVo.setUserImageUrl(usersPojo.getThumbUrl());
                }
                trainingCommentVoList.add(commentVo);
            }
            trainingCommentVo.setCommentList((List)trainingCommentVoList);
        }
    }

    @Override
    public Integer getUserCommentStars(Integer id, Integer type, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getMaterialId, (Object)id)).eq(TrainingMaterialComment::getUserId, (Object)user.getId())).eq(TrainingMaterialComment::getType, (Object)type)).orderByDesc(TrainingMaterialComment::getId)).last(" limit 1 ");
        TrainingMaterialComment materialComment = (TrainingMaterialComment)this.trainingMaterialCommentMapper.selectOne((Wrapper)wrapper1);
        if (ObjectUtils.isEmpty((Object)materialComment)) {
            return 0;
        }
        return materialComment.getStars();
    }

    @Override
    public void saveComment(TrainingCommentVo trainingCommentVo, Users user) {
        Date now = new Date();
        this.saveStars(trainingCommentVo, user, now);
        if (StringUtils.isEmpty((Object)trainingCommentVo.getContent())) {
            return;
        }
        TrainingComment comment = new TrainingComment();
        comment.setContent(trainingCommentVo.getContent());
        comment.setTrainingId(trainingCommentVo.getId());
        comment.setId(null);
        comment.setUserId(user.getId());
        comment.setCommentType(trainingCommentVo.getCommentType());
        comment.setReplyId(trainingCommentVo.getReplyId());
        comment.setCreateTime(now);
        comment.setCommentId(trainingCommentVo.getCommentId());
        this.trainingCommentMapper.insert(comment);
    }

    private void saveStars(TrainingCommentVo trainingCommentVo, Users user, Date now) {
        if (trainingCommentVo.getStars() != null && (trainingCommentVo.getCommentType() == 1 || trainingCommentVo.getCommentType() == 4)) {
            LambdaUpdateWrapper wrapper2;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getMaterialId, (Object)trainingCommentVo.getId())).eq(TrainingMaterialComment::getUserId, (Object)user.getId())).eq(TrainingMaterialComment::getType, (Object)(trainingCommentVo.getCommentType() == 1 ? 2 : 1))).orderByAsc(TrainingMaterialComment::getId)).last(" limit 1 ");
            TrainingMaterialComment materialComment = (TrainingMaterialComment)this.trainingMaterialCommentMapper.selectOne((Wrapper)wrapper1);
            if (ObjectUtils.isEmpty((Object)materialComment)) {
                TrainingMaterialComment trainingMaterialComment = this.getTrainingMaterialComment(trainingCommentVo, user, now);
                this.trainingMaterialCommentMapper.insert(trainingMaterialComment);
            } else {
                wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialComment::getId, (Object)materialComment.getId())).set(TrainingMaterialComment::getStars, (Object)trainingCommentVo.getStars())).set(TrainingMaterialComment::getUpdateTime, (Object)now);
                this.trainingMaterialCommentMapper.update(null, (Wrapper)wrapper2);
            }
            wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialComment::getMaterialId, (Object)trainingCommentVo.getId())).eq(TrainingMaterialComment::getType, (Object)(trainingCommentVo.getCommentType() == 1 ? 2 : 1))).gt(TrainingMaterialComment::getStars, (Object)0);
            List list = this.trainingMaterialCommentMapper.selectList((Wrapper)wrapper2);
            OptionalDouble average = list.stream().mapToInt(TrainingMaterialComment::getStars).average();
            if (trainingCommentVo.getCommentType() == 1) {
                Training training = (Training)this.trainingMapper.selectById(trainingCommentVo.getId());
                training.setScore(new BigDecimal(average.getAsDouble()));
                this.trainingMapper.updateById(training);
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.eq(TrainingResource::getFileType, (Object)8);
                wrapper3.eq(TrainingResource::getObjectId, (Object)trainingCommentVo.getId());
                TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)wrapper3);
                if (resource != null) {
                    resource.setScore(new BigDecimal(average.getAsDouble()));
                }
                this.trainingResourceMapper.updateById(resource);
            } else {
                TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(trainingCommentVo.getId());
                material.setScore(new BigDecimal(average.getAsDouble()));
                this.trainingMaterialMapper.updateById(material);
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                wrapper3.ne(TrainingResource::getFileType, (Object)8);
                wrapper3.eq(TrainingResource::getObjectId, (Object)trainingCommentVo.getId());
                TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)wrapper3);
                if (resource != null) {
                    resource.setScore(new BigDecimal(average.getAsDouble()));
                }
                this.trainingResourceMapper.updateById(resource);
            }
        }
    }

    private TrainingMaterialComment getTrainingMaterialComment(TrainingCommentVo trainingCommentVo, Users user, Date now) {
        TrainingMaterialComment trainingMaterialComment = new TrainingMaterialComment();
        trainingMaterialComment.setStars(trainingCommentVo.getStars());
        trainingMaterialComment.setMaterialId(trainingCommentVo.getId());
        trainingMaterialComment.setId(null);
        trainingMaterialComment.setType(Integer.valueOf(trainingCommentVo.getCommentType() == 1 ? 2 : 1));
        trainingMaterialComment.setUserId(user.getId());
        trainingMaterialComment.setCreateTime(now);
        trainingMaterialComment.setUpdateTime(now);
        trainingMaterialComment.setEnterpriseId(user.getGroupId());
        return trainingMaterialComment;
    }

    @Override
    public void deleteComment(Integer id, Users user) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            wrapper.eq(TrainingComment::getUserId, (Object)user.getId());
        }
        ((LambdaUpdateWrapper)wrapper.eq(TrainingComment::getId, (Object)id)).set(TrainingComment::getIsDel, (Object)1);
        this.trainingCommentMapper.update(null, (Wrapper)wrapper);
    }
}

