/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.enterprise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.mapper.TrainingTypeBannerMapper;
import com.ovopark.training.mapper.enterprise.EnterpriseConfigMapper;
import com.ovopark.training.mapper.recommend.RecommendMapper;
import com.ovopark.training.mapper.recommend.RecommendTrainMapper;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingTypeBanner;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.RecommendTrainBo;
import com.ovopark.training.model.domain.EnterpriseConfigDo;
import com.ovopark.training.model.domain.RecommendDo;
import com.ovopark.training.model.domain.RecommendTrainDo;
import com.ovopark.training.model.view.RecommendTrainVo;
import com.ovopark.training.service.enterprise.RecommendService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.vo.TrainingResourceVo;
import com.ovopark.training.vo.TrainingTypeBannerVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class RecommendServiceImpl
implements RecommendService {
    @Autowired
    private RecommendMapper recommendMapper;
    @Autowired
    private RecommendTrainMapper recommendTrainMapper;
    @Autowired
    private TrainingResourceMapper trainingResourceMapper;
    @Autowired
    private TrainingTypeBannerMapper trainingTypeBannerMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private EnterpriseConfigMapper enterpriseConfigMapper;

    @Override
    public RecommendTrainVo getRecommend(Users users) {
        RecommendTrainVo recommendTrainVo = this.getRecommendConfig(users);
        RecommendDo recommend = recommendTrainVo.getRecommend();
        if (ObjectUtils.isEmpty((Object)recommend)) {
            Date now = new Date();
            recommend = new RecommendDo();
            recommend.setEnterpriseId(users.getGroupId());
            recommend.setConfig(2);
            recommend.setCreater(users.getId());
            recommend.setCreateTime(now);
            recommend.setUpdateTime(now);
            recommend.setUpdater(users.getId());
            this.recommendMapper.insert(recommend);
            recommendTrainVo.setRecommend(recommend);
            return recommendTrainVo;
        }
        if (recommend.getConfig() == 2) {
            List<RecommendTrainBo> recommendTrainBoList = this.recommendTrainMapper.selectRecommendTrainList(users.getGroupId());
            if (!CollectionUtils.isEmpty(recommendTrainBoList)) {
                recommendTrainVo.setIsExistRecommend(true);
            }
            recommendTrainVo.setRecommendTrainBoList(recommendTrainBoList);
            return recommendTrainVo;
        }
        recommendTrainVo.setIsExistRecommend(true);
        return recommendTrainVo;
    }

    private RecommendTrainVo getRecommendConfig(Users users) {
        RecommendTrainVo recommendTrainVo = new RecommendTrainVo();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(EnterpriseConfigDo::getEnterpriseId, (Object)users.getGroupId())).eq(EnterpriseConfigDo::getConfigKey, (Object)"TYPE_STYLE");
        EnterpriseConfigDo enterpriseConfigDo = (EnterpriseConfigDo)this.enterpriseConfigMapper.selectOne((Wrapper)wrapper);
        if (ObjectUtils.isEmpty((Object)enterpriseConfigDo)) {
            recommendTrainVo.setTypeStyle("1");
        } else {
            recommendTrainVo.setTypeStyle(enterpriseConfigDo.getConfigValue());
        }
        recommendTrainVo.setIsExistRecommend(false);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(RecommendDo::getEnterpriseId, (Object)users.getGroupId())).orderByDesc(RecommendDo::getUpdateTime);
        List recommendList = this.recommendMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)recommendList)) {
            RecommendDo recommend = (RecommendDo)recommendList.get(0);
            recommendTrainVo.setRecommend(recommend);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingTypeBanner::getEnterpriseId, (Object)users.getGroupId())).isNull(TrainingTypeBanner::getMaterialTypeId);
        List trainingTypeBanners = this.trainingTypeBannerMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingTypeBanners)) {
            recommendTrainVo.setIsExistRecommend(true);
        }
        return recommendTrainVo;
    }

    @Override
    public void saveRecommend(RecommendTrainVo recommendTrainVo, Users users) {
        RecommendDo recommend = recommendTrainVo.getRecommend();
        Date now = new Date();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(RecommendDo::getEnterpriseId, (Object)users.getGroupId())).orderByDesc(RecommendDo::getUpdateTime);
        List recommendList = this.recommendMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)recommendList)) {
            recommend.setEnterpriseId(users.getGroupId());
            recommend.setCreater(users.getId());
            recommend.setCreateTime(now);
            recommend.setUpdateTime(now);
            recommend.setUpdater(users.getId());
            this.recommendMapper.insert(recommend);
        } else {
            RecommendDo recommendDo = (RecommendDo)recommendList.get(0);
            recommendDo.setConfig(recommend.getConfig());
            recommendDo.setRule(recommend.getRule());
            recommendDo.setCount(recommend.getCount());
            recommendDo.setUpdateTime(now);
            recommendDo.setUpdater(users.getId());
            this.recommendMapper.updateById(recommendDo);
        }
        if (recommend.getConfig() == 2) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(RecommendTrainDo::getEnterpriseId, (Object)users.getGroupId());
            this.recommendTrainMapper.delete((Wrapper)wrapper);
            List<RecommendTrainBo> recommendTrainBoList = recommendTrainVo.getRecommendTrainBoList();
            if (!CollectionUtils.isEmpty(recommendTrainBoList)) {
                ArrayList recommendTrainList = Lists.newArrayList();
                for (RecommendTrainBo recommendTrainBo : recommendTrainBoList) {
                    RecommendTrainDo recommendTrain = new RecommendTrainDo();
                    recommendTrain.setEnterpriseId(users.getGroupId());
                    recommendTrain.setSort(recommendTrainBo.getSort());
                    recommendTrain.setResourceId(recommendTrainBo.getResourceId());
                    recommendTrain.setCreater(users.getId());
                    recommendTrain.setCreateTime(now);
                    recommendTrain.setUpdater(users.getId());
                    recommendTrain.setUpdateTime(now);
                    recommendTrainList.add(recommendTrain);
                }
                this.recommendTrainMapper.insertList(recommendTrainList);
            }
        }
    }

    @Override
    public RecommendTrainVo getRecommendTrains(Users users) {
        RecommendTrainVo recommendTrainVo = this.getRecommendConfig(users);
        RecommendDo recommend = recommendTrainVo.getRecommend();
        if (ObjectUtils.isEmpty((Object)recommend)) {
            return recommendTrainVo;
        }
        List<Object> trainingResourceList = Lists.newArrayList();
        if (recommend.getConfig() == 1) {
            LambdaQueryWrapper wrapper2;
            Integer count = recommend.getCount() == null ? 10 : recommend.getCount();
            if (recommend.getRule() == null || recommend.getRule() == 1) {
                recommendTrainVo.setIsExistRecommend(true);
                wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingResource::getEnterpriseId, (Object)users.getGroupId())).eq(TrainingResource::getIsUsing, (Object)1)).eq(TrainingResource::getIsShow, (Object)1)).eq(TrainingResource::getIsDel, (Object)0)).orderByDesc(TrainingResource::getId)).last("limit " + count);
                trainingResourceList = this.trainingResourceMapper.selectList((Wrapper)wrapper2);
            } else if (recommend.getRule() == 2) {
                recommendTrainVo.setIsExistRecommend(true);
                wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingResource::getEnterpriseId, (Object)users.getGroupId())).eq(TrainingResource::getIsUsing, (Object)1)).eq(TrainingResource::getIsShow, (Object)1)).eq(TrainingResource::getIsDel, (Object)0)).orderByDesc(TrainingResource::getViewCount)).orderByDesc(TrainingResource::getId)).last("limit " + count);
                trainingResourceList = this.trainingResourceMapper.selectList((Wrapper)wrapper2);
            }
        } else if (recommend.getConfig() == 2) {
            trainingResourceList = this.trainingResourceMapper.selectListByRecommend(users.getGroupId());
        }
        List<Object> trainingResourceVoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)trainingResourceList)) {
            recommendTrainVo.setIsExistRecommend(true);
            for (TrainingResource trainingResource : trainingResourceList) {
                TrainingResourceVo trainingResourceVo = this.getTrainingResourceVo(trainingResource);
                trainingResourceVoList.add(trainingResourceVo);
            }
            trainingResourceVoList = this.resourceService.getResourceListData((List<TrainingResourceVo>)trainingResourceVoList, users);
        }
        recommendTrainVo.setTrainingResourceVoList((List<TrainingResourceVo>)trainingResourceVoList);
        return recommendTrainVo;
    }

    private TrainingResourceVo getTrainingResourceVo(TrainingResource trainingResource) {
        TrainingResourceVo trainingResourceVo = new TrainingResourceVo();
        trainingResourceVo.setId(trainingResource.getId());
        trainingResourceVo.setShowName(trainingResource.getShowName());
        trainingResourceVo.setCoverUrl(trainingResource.getCoverUrl());
        trainingResourceVo.setCoverType(trainingResource.getCoverType());
        trainingResourceVo.setObjectId(trainingResource.getObjectId());
        trainingResourceVo.setFileType(trainingResource.getFileType());
        trainingResourceVo.setTypeId(trainingResource.getTypeId());
        trainingResourceVo.setPath(trainingResource.getPath());
        trainingResourceVo.setIsShow(trainingResource.getIsShow());
        trainingResourceVo.setIsUsing(trainingResource.getIsUsing());
        trainingResourceVo.setIsDel(trainingResource.getIsDel());
        trainingResourceVo.setViewCount(trainingResource.getViewCount());
        return trainingResourceVo;
    }

    @Override
    public String addTypeBanner(TrainingTypeBannerVo banner) {
        if (banner.getId() == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingTypeBanner::getEnterpriseId, (Object)banner.getEnterpriseId());
            wrapper.eq(TrainingTypeBanner::getMaterialTypeId, (Object)banner.getMaterialTypeId());
            wrapper.orderByDesc(TrainingTypeBanner::getSort);
            List list = this.trainingTypeBannerMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list) && list.size() >= 5) {
                return JsonResult.error(null, (Object)"\u6700\u591a\u6dfb\u52a05\u4e2a\u63a8\u5e7f\u56fe");
            }
            if (banner.getSort() == null) {
                if (CollectionUtils.isEmpty((Collection)list)) {
                    banner.setSort(Integer.valueOf(1));
                } else {
                    banner.setSort(Integer.valueOf(((TrainingTypeBanner)list.get(0)).getSort() + 1));
                }
            }
            this.trainingTypeBannerMapper.insert(banner);
        } else {
            this.trainingTypeBannerMapper.updateById(banner);
        }
        return JsonResult.success();
    }

    @Override
    public String getTypeBannerList(Integer enterpriseId, Integer materialTypeId) {
        ArrayList<TrainingTypeBannerVo> result = new ArrayList<TrainingTypeBannerVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTypeBanner::getEnterpriseId, (Object)enterpriseId);
        if (materialTypeId != null) {
            wrapper.eq(TrainingTypeBanner::getMaterialTypeId, (Object)materialTypeId);
        } else {
            wrapper.isNull(TrainingTypeBanner::getMaterialTypeId);
        }
        wrapper.orderByAsc(TrainingTypeBanner::getSort);
        List list = this.trainingTypeBannerMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.success();
        }
        for (TrainingTypeBanner trainingTypeBanner : list) {
            TrainingTypeBannerVo vo = new TrainingTypeBannerVo();
            vo.setId(trainingTypeBanner.getId());
            vo.setPicUrl(trainingTypeBanner.getPicUrl());
            vo.setName(trainingTypeBanner.getName());
            vo.setJumpType(trainingTypeBanner.getJumpType());
            vo.setSort(trainingTypeBanner.getSort());
            if (trainingTypeBanner.getJumpType() == 2) {
                TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectById(Integer.valueOf(Integer.parseInt(trainingTypeBanner.getJumpDetail())));
                if (ObjectUtils.isEmpty((Object)resource)) continue;
                vo.setShowName(resource.getShowName());
                vo.setJumpDetail(JSONObject.toJSONString((Object)resource));
            } else {
                vo.setJumpDetail(trainingTypeBanner.getJumpDetail());
            }
            result.add(vo);
        }
        return JsonResult.success(result);
    }

    @Override
    public String deleteTypeBannerById(Integer enterpriseId, Integer id) {
        TrainingTypeBanner banner = (TrainingTypeBanner)this.trainingTypeBannerMapper.selectById(id);
        if (banner.getEnterpriseId().intValue() != enterpriseId.intValue()) {
            return JsonResult.error(null, (Object)"\u975e\u6cd5\u64cd\u4f5c");
        }
        this.trainingTypeBannerMapper.deleteById(id);
        return JsonResult.success();
    }

    @Override
    public String addTypeBannerList(Integer enterpriseId, Integer userId, List<TrainingTypeBannerVo> banner) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingTypeBanner::getEnterpriseId, (Object)enterpriseId);
        if (CollectionUtils.isEmpty(banner) || banner.get(0).getMaterialTypeId() == null) {
            wrapper.isNull(TrainingTypeBanner::getMaterialTypeId);
        } else {
            wrapper.eq(TrainingTypeBanner::getMaterialTypeId, (Object)banner.get(0).getMaterialTypeId());
        }
        this.trainingTypeBannerMapper.delete((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty(banner)) {
            for (TrainingTypeBannerVo vo : banner) {
                if (vo.getName() == null) continue;
                vo.setCreater(userId);
                vo.setCreateTime(new Date());
                vo.setUpdateTime(new Date());
                vo.setEnterpriseId(enterpriseId);
                this.trainingTypeBannerMapper.insert(vo);
            }
        }
        return JsonResult.success();
    }
}

