/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.examChannel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.training.mapper.TrainingExamOptionsMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamOptions;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.request.ItemAnalysisRequest;
import com.ovopark.training.request.PaperManagementRequest;
import com.ovopark.training.service.examChannel.ExamChannel;
import com.ovopark.training.service.examChannel.ExamUtil;
import com.ovopark.training.vo.ItemOptionsVo;
import com.ovopark.training.vo.PaperManagementItemAnalysisVo;
import com.ovopark.training.vo.PaperManagementItemDetailVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class ExamChannelFixed
implements ExamChannel {
    private static final Logger log = LoggerFactory.getLogger(ExamChannelFixed.class);
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingExamQuestionMapper trainingExamQuestionMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private TrainingQuestionTypeMapper trainingQuestionTypeMapper;
    @Autowired
    private ExamUtil examUtil;
    @Autowired
    private TrainingExamOptionsMapper examOptionsMapper;

    @Override
    public List<PaperManagementItemAnalysisVo> getItemAnalysisList(ItemAnalysisRequest request, List<Integer> userPaperIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(!CollectionUtils.isEmpty(userPaperIdList), TrainingUserQuestion::getUserPaperId, userPaperIdList);
        queryWrapper.like(Objects.nonNull(request.getQuestionName()), TrainingUserQuestion::getName, (Object)request.getQuestionName());
        queryWrapper.eq(Objects.nonNull(request.getQuestionType()), TrainingUserQuestion::getQuestionType, (Object)request.getQuestionType());
        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)queryWrapper);
        Map<Integer, List<TrainingUserQuestion>> userQuestionMap = trainingUserQuestionList.stream().collect(Collectors.groupingBy(TrainingUserQuestion::getQuestionId));
        List examQuestionIdList = trainingUserQuestionList.stream().map(TrainingUserQuestion::getQuestionId).distinct().collect(Collectors.toList());
        List trainingExamQuestions = this.trainingExamQuestionMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TrainingExamQuestion::getId, examQuestionIdList));
        Map<Integer, Integer> questionIdMap = trainingExamQuestions.stream().collect(Collectors.toMap(TrainingExamQuestion::getId, TrainingExamQuestion::getQuestionId));
        List questionIdList = trainingExamQuestions.stream().map(TrainingExamQuestion::getQuestionId).collect(Collectors.toList());
        List trainingQuestions = this.trainingQuestionMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TrainingQuestion::getId, questionIdList));
        Map<Integer, TrainingQuestion> trainingQuestionMap = trainingQuestions.stream().collect(Collectors.toMap(TrainingQuestion::getId, value -> value));
        List questionTypeIdList = trainingQuestions.stream().map(TrainingQuestion::getQuestionType).collect(Collectors.toList());
        List trainingQuestionTypes = this.trainingQuestionTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TrainingQuestionType::getId, questionTypeIdList));
        Map<Integer, String> questionBankMap = trainingQuestionTypes.stream().collect(Collectors.toMap(TrainingQuestionType::getId, TrainingQuestionType::getTitle));
        List<PaperManagementItemAnalysisVo> res = new ArrayList<PaperManagementItemAnalysisVo>();
        for (Integer examQuestionId : examQuestionIdList) {
            PaperManagementItemAnalysisVo vo = new PaperManagementItemAnalysisVo();
            List<TrainingUserQuestion> userQuestionList = userQuestionMap.get(examQuestionId);
            List analyseCount = userQuestionList.stream().filter(e -> e.getIsEmpty() == 0).collect(Collectors.toList());
            List analyseRight = userQuestionList.stream().filter(e -> e.getIsCorrect() == 1).collect(Collectors.toList());
            vo.setExamQuestionId(examQuestionId);
            vo.setAnswerUser(Integer.valueOf(analyseCount.size()));
            vo.setAnswerRightUser(Integer.valueOf(analyseRight.size()));
            vo.setAnswerRightRate(ExamUtil.divideIntegers(analyseRight.size(), analyseCount.size()));
            vo.setQuestionType(this.examUtil.getTypeDesc(userQuestionList.get(0).getQuestionType(), request.getLocale()));
            if (questionIdMap.containsKey(examQuestionId)) {
                Integer questionId = questionIdMap.get(examQuestionId);
                vo.setQuestionId(questionId);
                if (trainingQuestionMap.containsKey(questionId)) {
                    TrainingQuestion trainingQuestion = trainingQuestionMap.get(questionId);
                    vo.setQuestionName(trainingQuestion.getName());
                    Integer questionBankId = trainingQuestion.getQuestionType();
                    if (!ObjectUtils.isEmpty((Object)questionBankId) && questionBankMap.containsKey(questionBankId)) {
                        vo.setQuestionBank(questionBankMap.get(questionBankId));
                    }
                }
            }
            res.add(vo);
        }
        res = ExamUtil.sortItemAnalysisVoList(res, request.getSortOrder());
        return res;
    }

    @Override
    public PaperManagementItemDetailVo getItemDetail(PaperManagementRequest request, TrainingExam trainingExam, List<Integer> userPaperIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(!CollectionUtils.isEmpty(userPaperIdList), TrainingUserQuestion::getUserPaperId, userPaperIdList);
        queryWrapper.eq(TrainingUserQuestion::getQuestionId, (Object)request.getExamQuestionId());
        List userQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)queryWrapper);
        TrainingExamQuestion examQuestion = (TrainingExamQuestion)this.trainingExamQuestionMapper.selectOne((Wrapper)new LambdaQueryWrapper().in(TrainingExamQuestion::getId, new Object[]{request.getExamQuestionId()}));
        PaperManagementItemDetailVo vo = new PaperManagementItemDetailVo();
        vo.setContent(examQuestion.getContent());
        vo.setQuestionType(examQuestion.getQuestionType());
        vo.setPicturePath(examQuestion.getPicturePath());
        vo.setRemark(examQuestion.getRemark());
        List analyseCount = userQuestionList.stream().filter(e -> e.getIsEmpty() == 0).collect(Collectors.toList());
        List analyseRight = userQuestionList.stream().filter(e -> e.getIsEmpty() == 0 && e.getIsCorrect() == 1).collect(Collectors.toList());
        vo.setAnswerRightRate(ExamUtil.divideIntegers(analyseRight.size(), analyseCount.size()));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingExamOptions::getExamQuestionId, (Object)request.getExamQuestionId());
        List optionsList = this.examOptionsMapper.selectList((Wrapper)wrapper);
        ArrayList itemOptionList = new ArrayList();
        optionsList.forEach(option -> {
            ItemOptionsVo itemOptions = new ItemOptionsVo();
            itemOptions.setContent(option.getContent());
            itemOptions.setPicturePath(option.getPicturePath());
            itemOptions.setIsAnswer(option.getIsAnswer());
            if (examQuestion.getQuestionType().equals(0) || examQuestion.getQuestionType().equals(3) || examQuestion.getQuestionType().equals(4)) {
                int selectNum = 0;
                for (TrainingUserQuestion userQuestion : analyseCount) {
                    List optionsVoList = JSONObject.parseArray((String)userQuestion.getOptionsData(), TrainingOptionsVo.class);
                    Optional<TrainingOptionsVo> first = optionsVoList.stream().filter(e -> option.getId().equals(e.getId())).findFirst();
                    if (!first.isPresent() || first.get().getIsSelect() == null || first.get().getIsSelect() != 1) continue;
                    ++selectNum;
                }
                itemOptions.setSelectRate(ExamUtil.divideIntegers(selectNum, analyseCount.size()));
            }
            itemOptionList.add(itemOptions);
        });
        vo.setItemOptionList(itemOptionList);
        return vo;
    }
}

