/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.examChannel;

import com.ovopark.training.enums.QuestionType;
import com.ovopark.training.vo.PaperManagementItemAnalysisVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class ExamUtil {
    @Autowired
    private MessageSource messageSource;

    public static BigDecimal divideIntegers(Integer numerator, Integer denominator) {
        if (denominator == 0) {
            return null;
        }
        BigDecimal bdNumerator = new BigDecimal(numerator);
        BigDecimal bdDenominator = new BigDecimal(denominator);
        int scale = 2;
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        return bdNumerator.multiply(new BigDecimal(100)).divide(bdDenominator, scale, roundingMode);
    }

    public static List<PaperManagementItemAnalysisVo> sortItemAnalysisVoList(List<PaperManagementItemAnalysisVo> list, String sortOrder) {
        Comparator<PaperManagementItemAnalysisVo> comparator = Comparator.comparing(PaperManagementItemAnalysisVo::getAnswerRightRate, Comparator.nullsLast(Comparator.naturalOrder()));
        if ("desc".equalsIgnoreCase(sortOrder)) {
            comparator = comparator.reversed();
        }
        return list.stream().sorted(comparator).collect(Collectors.toList());
    }

    public String getTypeDesc(Integer questionType, Locale locale) {
        String typeName = "";
        if (questionType.intValue() == QuestionType.DANXUAN.getCode()) {
            typeName = this.messageSource.getMessage("training.user.details.singleChoiceQuestion", null, locale);
        } else if (questionType.intValue() == QuestionType.DUOXUAN.getCode()) {
            typeName = this.messageSource.getMessage("training.user.details.multipleChoiceQuestion", null, locale);
        } else if (questionType.intValue() == QuestionType.PANDUAN.getCode()) {
            typeName = this.messageSource.getMessage("training.user.details.trueOrFalseQuestions", null, locale);
        } else if (questionType.intValue() == QuestionType.TINKONG.getCode()) {
            typeName = this.messageSource.getMessage("training.user.details.fillBlankQuestion", null, locale);
        } else if (questionType.intValue() == QuestionType.WENDA.getCode()) {
            typeName = this.messageSource.getMessage("training.user.details.essayQuestion", null, locale);
        }
        return typeName;
    }
}

