/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.dto.DeptCourseSummarizeDto;
import com.ovopark.training.dto.DeptDimensionDto;
import com.ovopark.training.dto.DeptExamSummarizeDto;
import com.ovopark.training.dto.DeptStudySummarizeDto;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCourseMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeJobMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeLearnMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeCourse;
import com.ovopark.training.model.TrainingUserViewTimeJob;
import com.ovopark.training.model.TrainingUserViewTimeLearn;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.DeptQueryBaseRequest;
import com.ovopark.training.service.IDimensionSummarizeService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.BeanSwitchUtils;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.DistinctUtils;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DimensionSummarizeServiceImpl
implements IDimensionSummarizeService {
    private static final Logger log = LoggerFactory.getLogger(DimensionSummarizeServiceImpl.class);
    @Resource
    private UserApi userApi;
    @Resource
    private DepartmentApi departmentApi;
    @Resource
    private OrganizeApi organizeApi;
    @Resource
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private TrainingCommonService commonService;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Resource
    private TrainingCourseMapper trainingCourseMapper;
    @Resource
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Resource
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Resource
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Resource
    private TrainingMaterialMapper materialMapper;
    @Resource
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Resource
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Resource
    private TrainingUserViewTimeJobMapper trainingUserViewTimeJobMapper;
    @Resource
    private TrainingUserViewTimeLearnMapper trainingUserViewTimeLearnMapper;
    @Resource
    private TrainingUserViewTimeCourseMapper trainingUserViewTimeCourseMapper;
    @Resource
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Resource
    private TrainingPaperMapper trainingPaperMapper;
    @Resource
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Resource
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Resource
    private TrainingExamMapper trainingExamMapper;

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptStudySummarizeDto>> queryMaterialDimensionSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchableUserIds, Integer summarizeType) {
        List trainingUserViewTimeMaterials;
        HashSet needQueryUserIds = new HashSet();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll(v));
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        List list = trainingUserViewTimeMaterials = CollectionUtils.isEmpty(needQueryUserIds) ? Collections.emptyList() : this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).eq(TrainingUserViewTime::getLearnType, (Object)0)).isNull(TrainingUserViewTime::getTaskId)).isNull(TrainingUserViewTime::getAttachId)).isNull(TrainingUserViewTime::getTrainingId)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime}));
        if (null == trainingUserViewTimeMaterials || trainingUserViewTimeMaterials.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList deptStudySummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptStudySummarizeDto deptStudySummarizeDto = new DeptStudySummarizeDto();
            deptStudySummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchableUserIds);
            LocalDateTime beginTime = 0 == summarizeType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == summarizeType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            List materialList = trainingUserViewTimeMaterials.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList());
            List materialStudyUserIds = materialList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            deptStudySummarizeDto.setSelfStudyUserIds(materialStudyUserIds);
            Integer selfStudyTime = materialList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptStudySummarizeDto.setSelfStudyTime(selfStudyTime);
            deptStudySummarizeDto.setCalDay(dept.getCalDay());
            deptStudySummarizeDtos.add(deptStudySummarizeDto);
        });
        return CompletableFuture.completedFuture(deptStudySummarizeDtos);
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptStudySummarizeDto>> queryNewCourseDimensionSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchableUserIds, Integer summarizeType) {
        HashSet<Integer> needQueryUserIds = new HashSet<Integer>();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll((Collection<Integer>)v));
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        ArrayList trainingUserViewTimeTrainings = CollectionUtils.isEmpty(needQueryUserIds) ? new ArrayList() : this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).eq(TrainingUserViewTime::getLearnType, (Object)1)).isNull(TrainingUserViewTime::getTaskId)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime}));
        List<TrainingUserViewTimeCourse> examCourseList = this.queryStudyTrainingCourseRecords(needQueryUserIds, Collections.singletonList(1), earliestTime, latestTime);
        List examTrainings = BeanSwitchUtils.bo2do4List(examCourseList, TrainingUserViewTimeTraining.class);
        trainingUserViewTimeTrainings.addAll(examTrainings);
        if (null == trainingUserViewTimeTrainings || trainingUserViewTimeTrainings.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList deptStudySummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptStudySummarizeDto deptStudySummarizeDto = new DeptStudySummarizeDto();
            deptStudySummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchableUserIds);
            LocalDateTime beginTime = 0 == summarizeType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == summarizeType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            List trainingList = trainingUserViewTimeTrainings.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList());
            List trainingStudyUserIds = trainingList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            deptStudySummarizeDto.setSelfStudyUserIds(trainingStudyUserIds);
            Integer selfStudyTime = trainingList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptStudySummarizeDto.setSelfStudyTime(selfStudyTime);
            deptStudySummarizeDto.setCalDay(dept.getCalDay());
            deptStudySummarizeDtos.add(deptStudySummarizeDto);
        });
        return CompletableFuture.completedFuture(deptStudySummarizeDtos);
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptStudySummarizeDto>> queryStudyProjectDimensionSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchableUserIds, Integer summarizeType) {
        HashSet<Integer> needQueryUserIds = new HashSet<Integer>();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll((Collection<Integer>)v));
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        ArrayList trainingUserViewTimeJobs = CollectionUtils.isEmpty(needQueryUserIds) ? new ArrayList() : this.trainingUserViewTimeJobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).eq(TrainingUserViewTime::getLearnType, (Object)2)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime}));
        List<TrainingUserViewTimeCourse> examCourseList = this.queryStudyTrainingCourseRecords(needQueryUserIds, Collections.singletonList(3), earliestTime, latestTime);
        List examTrainingJobs = BeanSwitchUtils.bo2do4List(examCourseList, TrainingUserViewTimeJob.class);
        trainingUserViewTimeJobs.addAll(examTrainingJobs);
        if (null == trainingUserViewTimeJobs || trainingUserViewTimeJobs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList deptStudySummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptStudySummarizeDto deptStudySummarizeDto = new DeptStudySummarizeDto();
            deptStudySummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchableUserIds);
            LocalDateTime beginTime = 0 == summarizeType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == summarizeType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            List jobLists = trainingUserViewTimeJobs.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList());
            List jobStudyUserIds = jobLists.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            deptStudySummarizeDto.setTaskStudyUserIds(jobStudyUserIds);
            Integer selfStudyTime = jobLists.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptStudySummarizeDto.setTaskStudyTime(selfStudyTime);
            deptStudySummarizeDto.setCalDay(dept.getCalDay());
            deptStudySummarizeDtos.add(deptStudySummarizeDto);
        });
        return CompletableFuture.completedFuture(deptStudySummarizeDtos);
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptStudySummarizeDto>> queryTrainPlanDimensionSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchableUserIds, Integer summarizeType) {
        HashSet<Integer> needQueryUserIds = new HashSet<Integer>();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll((Collection<Integer>)v));
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        ArrayList<TrainingUserViewTimeCourse> trainingUserViewTimeCourses = CollectionUtils.isEmpty(needQueryUserIds) ? new ArrayList<TrainingUserViewTimeCourse>() : this.trainingUserViewTimeCourseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).eq(TrainingUserViewTime::getLearnType, (Object)4)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime}));
        List<TrainingUserViewTimeCourse> examCourseList = this.queryStudyTrainingCourseRecords(needQueryUserIds, Collections.singletonList(5), earliestTime, latestTime);
        trainingUserViewTimeCourses.addAll(examCourseList);
        if (null == trainingUserViewTimeCourses || trainingUserViewTimeCourses.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList deptStudySummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptStudySummarizeDto deptStudySummarizeDto = new DeptStudySummarizeDto();
            deptStudySummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchableUserIds);
            LocalDateTime beginTime = 0 == summarizeType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == summarizeType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            List learnList = trainingUserViewTimeCourses.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList());
            List courseStudyUserIds = learnList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            deptStudySummarizeDto.setTaskStudyUserIds(courseStudyUserIds);
            Integer selfStudyTime = learnList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptStudySummarizeDto.setTaskStudyTime(selfStudyTime);
            deptStudySummarizeDto.setCalDay(dept.getCalDay());
            deptStudySummarizeDtos.add(deptStudySummarizeDto);
        });
        return CompletableFuture.completedFuture(deptStudySummarizeDtos);
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptStudySummarizeDto>> queryPostMapDimensionSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchableUserIds, Integer summarizeType) {
        HashSet<Integer> needQueryUserIds = new HashSet<Integer>();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll((Collection<Integer>)v));
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        List trainingUserViewTimeLearns = CollectionUtils.isEmpty(needQueryUserIds) ? Collections.emptyList() : this.trainingUserViewTimeLearnMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).eq(TrainingUserViewTime::getLearnType, (Object)3)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime}));
        List<TrainingUserViewTimeCourse> examCourseList = this.queryStudyTrainingCourseRecords(needQueryUserIds, Collections.singletonList(4), earliestTime, latestTime);
        List examLearns = BeanSwitchUtils.bo2do4List(examCourseList, TrainingUserViewTimeLearn.class);
        trainingUserViewTimeLearns.addAll(examLearns);
        if (null == trainingUserViewTimeLearns || trainingUserViewTimeLearns.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList deptStudySummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptStudySummarizeDto deptStudySummarizeDto = new DeptStudySummarizeDto();
            deptStudySummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchableUserIds);
            LocalDateTime beginTime = 0 == summarizeType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == summarizeType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            List learnList = trainingUserViewTimeLearns.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList());
            List learnStudyUserIds = learnList.stream().map(TrainingUserViewTime::getUserId).distinct().collect(Collectors.toList());
            deptStudySummarizeDto.setTaskStudyUserIds(learnStudyUserIds);
            Integer selfStudyTime = learnList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptStudySummarizeDto.setTaskStudyTime(selfStudyTime);
            deptStudySummarizeDto.setCalDay(dept.getCalDay());
            deptStudySummarizeDtos.add(deptStudySummarizeDto);
        });
        return CompletableFuture.completedFuture(deptStudySummarizeDtos);
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptCourseSummarizeDto>> queryTrainingCourseSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchUserIds, Integer countType, Users user) {
        HashSet<Integer> needQueryUserIds = new HashSet<Integer>();
        deptNameAndUserIds.forEach((k, v) -> needQueryUserIds.addAll((Collection<Integer>)v));
        needQueryUserIds.retainAll(watchUserIds);
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        List userViewTimes = CollectionUtils.isEmpty(needQueryUserIds) ? Collections.emptyList() : this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserViewTime::getUserId, needQueryUserIds)).isNotNull(TrainingUserViewTime::getTrainingId)).eq(TrainingUserViewTime::getLearnType, (Object)1)).between(TrainingUserViewTime::getCreateTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingUserViewTime::getTrainingId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getUserId, TrainingUserViewTime::getCreateTime, TrainingUserViewTime::getTaskId}));
        List<Integer> trainingIds = userViewTimes.stream().map(TrainingUserViewTime::getTrainingId).distinct().collect(Collectors.toList());
        Map<Integer, Set<Integer>> trainAndFinishStudyUserIds = this.queryFinishCourseUserIds(needQueryUserIds, trainingIds, user);
        ArrayList deptCourseSummarizeDtos = new ArrayList();
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptCourseSummarizeDto deptCourseSummarizeDto = new DeptCourseSummarizeDto();
            deptCourseSummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setIsLeaf(dept.getIsLeaf()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchUserIds);
            deptCourseSummarizeDto.setEnableUserNum(Integer.valueOf(deptUserList.size()));
            deptCourseSummarizeDto.setEnableUserIdList(deptUserList);
            deptCourseSummarizeDto.setDeptUserNum(Integer.valueOf(deptUserList.size()));
            LocalDateTime beginTime = 0 == countType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == countType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            deptCourseSummarizeDto.setCalDay(dept.getCalDay());
            List learnList = Optional.ofNullable(userViewTimes.stream().filter(x -> deptUserList.contains(x.getUserId()) && beginTime.isBefore(DateUtils.dateToLocalDateTime(x.getCreateTime())) && endTime.isAfter(DateUtils.dateToLocalDateTime(x.getCreateTime()))).collect(Collectors.toList())).orElse(Collections.emptyList());
            int studyCourseNum = (int)learnList.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
            deptCourseSummarizeDto.setTotalStudyDistinctUserNum(Integer.valueOf(studyCourseNum));
            deptCourseSummarizeDto.setStudyRatio(deptUserList.isEmpty() ? BigDecimal.ZERO : new BigDecimal(studyCourseNum).divide(new BigDecimal(deptUserList.size()), 2, RoundingMode.HALF_UP));
            int studyCourseUserTimes = (int)learnList.stream().filter(DistinctUtils.distinctByKey(x -> x.getUserId() + "_" + x.getTrainingId())).count();
            deptCourseSummarizeDto.setTotalStudyCourseUserNum(Integer.valueOf(studyCourseUserTimes));
            ArrayList finishUserIds = new ArrayList();
            learnList.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getTrainingId)).forEach(x -> {
                if (trainAndFinishStudyUserIds.containsKey(x.getTrainingId())) {
                    ArrayList trainUserIds = new ArrayList((Collection)trainAndFinishStudyUserIds.get(x.getTrainingId()));
                    trainUserIds.retainAll(deptUserList);
                    finishUserIds.addAll(trainUserIds);
                }
            });
            deptCourseSummarizeDto.setTotalFinishStudyUserNum(Integer.valueOf(finishUserIds.size()));
            deptCourseSummarizeDto.setFinishRatio(studyCourseUserTimes == 0 ? BigDecimal.ZERO : new BigDecimal(deptCourseSummarizeDto.getTotalFinishStudyUserNum()).divide(new BigDecimal(studyCourseUserTimes), 2, RoundingMode.HALF_UP));
            List selfStudyLists = learnList.stream().filter(x -> null == x.getTaskId()).collect(Collectors.toList());
            deptCourseSummarizeDto.setSelfStudyCourseUserNum(Integer.valueOf((int)selfStudyLists.stream().filter(DistinctUtils.distinctByKey(x -> x.getUserId() + "_" + x.getTrainingId())).count()));
            deptCourseSummarizeDto.setSelfStudyDistinctUserNum(Integer.valueOf(selfStudyLists.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).collect(Collectors.toList()).size()));
            deptCourseSummarizeDto.setSelfStudyCourseRatio(deptUserList.isEmpty() ? BigDecimal.ZERO : new BigDecimal(deptCourseSummarizeDto.getSelfStudyDistinctUserNum()).divide(new BigDecimal(deptUserList.size()), 2, RoundingMode.HALF_UP));
            ArrayList selfCompleteUserIds = new ArrayList();
            selfStudyLists.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getTrainingId)).forEach(x -> {
                if (trainAndFinishStudyUserIds.containsKey(x.getTrainingId())) {
                    ArrayList trainUserIds = new ArrayList((Collection)trainAndFinishStudyUserIds.get(x.getTrainingId()));
                    trainUserIds.retainAll(deptUserList);
                    selfCompleteUserIds.addAll(trainUserIds);
                }
            });
            deptCourseSummarizeDto.setSelfFinishedStudyUserNum(Integer.valueOf(selfCompleteUserIds.size()));
            deptCourseSummarizeDto.setSelfFinishedStudyRatio(selfStudyLists.isEmpty() ? BigDecimal.ZERO : new BigDecimal(deptCourseSummarizeDto.getSelfFinishedStudyUserNum()).divide(new BigDecimal(selfStudyLists.size()), 2, RoundingMode.HALF_UP));
            int seconds = learnList.stream().mapToInt(TrainingUserViewTime::getViewTime).sum();
            deptCourseSummarizeDto.setPreStudyCourseTimeStr(DateUtils.getUseTimeFormal(studyCourseNum == 0 ? 0 : seconds / studyCourseNum));
            deptCourseSummarizeDto.setPreSelfStudyCourseTimeStr(DateUtils.getUseTimeFormal(selfStudyLists.size() == 0 ? 0 : seconds / selfStudyLists.size()));
            deptCourseSummarizeDtos.add(deptCourseSummarizeDto);
        });
        return CompletableFuture.completedFuture(deptCourseSummarizeDtos);
    }

    @Override
    public Map<Integer, Set<Integer>> queryFinishCourseUserIds(Set<Integer> needQueryUserIds, List<Integer> trainingIds, Users user) {
        if (trainingIds == null || trainingIds.isEmpty()) {
            return new HashMap<Integer, Set<Integer>>();
        }
        HashMap<Integer, Set<Integer>> trainIdAndFinishCourseUserIdMap = new HashMap<Integer, Set<Integer>>();
        HashMap<Integer, List<TrainingUserViewTimeVo>> viewMap = new HashMap();
        List<TrainingUserViewTimeVo> trainingViewList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByTraining(trainingIds, user.getGroupId());
        if (!CollectionUtils.isEmpty(trainingViewList)) {
            viewMap = trainingViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getTrainingId));
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.in(TrainingChapterAttach::getTrainingId, trainingIds)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        HashMap<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = new HashMap();
        Map<Integer, Object> materialMap = new HashMap<Integer, TrainingMaterial>();
        Map<Integer, List<TrainingUserViewTimeVo>> viewMaterialMap = new HashMap<Integer, List<TrainingUserViewTimeVo>>();
        Map<Integer, List<TrainingUserPaper>> userPaperMap = new HashMap<Integer, List<TrainingUserPaper>>();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            List paperIdList;
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List<Integer> materialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List mateList = this.materialMapper.selectBatchIds(materialIdList);
                materialMap = mateList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                List<TrainingUserViewTimeVo> materialViewList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByMaterials(materialIdList, user.getGroupId());
                if (!CollectionUtils.isEmpty(materialViewList)) {
                    viewMaterialMap = materialViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                }
            }
            if (!CollectionUtils.isEmpty(paperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
        }
        for (Integer trainId : trainingIds) {
            HashSet<Integer> finishUserId = new HashSet<Integer>();
            for (Integer userId : needQueryUserIds) {
                Map<String, Object> map = this.commonService.selectIsFinishTraining(trainId, userId, viewMap, viewMaterialMap, trainingChapterAttachMap, materialMap, userPaperMap);
                String status = map.get("status").toString();
                if (!status.equals("2")) continue;
                finishUserId.add(userId);
            }
            trainIdAndFinishCourseUserIdMap.put(trainId, finishUserId);
        }
        return trainIdAndFinishCourseUserIdMap;
    }

    @Override
    public Map<Integer, Set<Integer>> queryNewFinishCourseUserIds(Set<Integer> needQueryUserIds, List<Integer> trainingIds, Users user) {
        if (trainingIds == null || trainingIds.isEmpty()) {
            return new HashMap<Integer, Set<Integer>>();
        }
        HashMap<Integer, Set<Integer>> trainIdAndFinishCourseUserIdMap = new HashMap<Integer, Set<Integer>>();
        HashMap<Integer, List<TrainingUserViewTimeVo>> viewMap = new HashMap();
        List<TrainingUserViewTimeVo> trainingViewList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByTraining(trainingIds, user.getGroupId());
        if (!CollectionUtils.isEmpty(trainingViewList)) {
            viewMap = trainingViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getTrainingId));
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.in(TrainingChapterAttach::getTrainingId, trainingIds)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        HashMap<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = new HashMap();
        Map<Integer, Object> materialMap = new HashMap<Integer, TrainingMaterial>();
        Map<Integer, List<TrainingUserViewTimeVo>> viewMaterialMap = new HashMap<Integer, List<TrainingUserViewTimeVo>>();
        Map<Integer, List<TrainingUserPaper>> userPaperMap = new HashMap<Integer, List<TrainingUserPaper>>();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            List paperIdList;
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List materialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List mateList = this.materialMapper.selectBatchIds(materialIdList);
                materialMap = mateList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                List trainMaterialViewList = Optional.ofNullable(this.trainingUserViewTimeTrainingMapper.selectViewTimeByTraining(trainingIds, user.getGroupId())).orElse(new ArrayList());
                List materialViewList = BeanSwitchUtils.do2bo4List(trainMaterialViewList.stream().filter(x -> !Objects.isNull(x.getMaterialId())).collect(Collectors.toList()), TrainingUserViewTimeVo.class);
                if (!CollectionUtils.isEmpty((Collection)materialViewList)) {
                    viewMaterialMap = materialViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                }
            }
            if (!CollectionUtils.isEmpty(paperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
        }
        for (Integer trainId : trainingIds) {
            HashSet<Integer> finishUserId = new HashSet<Integer>();
            for (Integer userId : needQueryUserIds) {
                Map<String, Object> map = this.commonService.selectIsFinishTraining(trainId, userId, viewMap, viewMaterialMap, trainingChapterAttachMap, materialMap, userPaperMap);
                String status = map.get("status").toString();
                if (!status.equals("2")) continue;
                finishUserId.add(userId);
            }
            trainIdAndFinishCourseUserIdMap.put(trainId, finishUserId);
        }
        return trainIdAndFinishCourseUserIdMap;
    }

    @Override
    @Async(value="queryDataThreadPool")
    public CompletableFuture<List<DeptExamSummarizeDto>> queryExamSummarize(LinkedList<DeptDimensionDto> deptDimensionDtos, Map<String, List<Integer>> deptNameAndUserIds, List<Integer> watchUserIds, Integer countType, Users user) {
        LocalDateTime earliestTime = deptDimensionDtos.stream().min(Comparator.comparing(DeptDimensionDto::getBeginTime)).get().getBeginTime().atStartOfDay();
        LocalDateTime latestTime = deptDimensionDtos.stream().max(Comparator.comparing(DeptDimensionDto::getEndTime)).get().getEndTime().atTime(LocalTime.MAX);
        List<TrainingPaper> trainingPapers = Optional.ofNullable(this.trainingPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingPaper::getEnterpriseId, (Object)user.getGroupId())).isNotNull(TrainingPaper::getStartTime)).ne(TrainingPaper::getPaperState, (Object)BigDecimal.ZERO.intValue())).between(TrainingPaper::getStartTime, (Object)earliestTime, (Object)latestTime)).select(new SFunction[]{TrainingPaper::getId, TrainingPaper::getLookLevel, TrainingPaper::getStartTime, TrainingPaper::getEndTime, TrainingPaper::getPaperState, TrainingPaper::getScoreSelect, TrainingPaper::getPassLine, TrainingPaper::getProjectShow}))).orElse(Collections.emptyList());
        HashMap<Integer, List<Integer>> roleIdAndUserIdMap = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, List<Integer>> tagIdAndUserIdMap = new HashMap<Integer, List<Integer>>();
        HashMap<String, List<Integer>> organizeIdAndUserIdMap = new HashMap<String, List<Integer>>();
        HashMap<Integer, Set<Integer>> paperIdAndRelatedUsersMap = new HashMap<Integer, Set<Integer>>();
        HashSet<Integer> selectAllUserIds = new HashSet<Integer>();
        List<TrainingPaperUser> trainingPaperUserList = this.handleValues(trainingPapers, selectAllUserIds, roleIdAndUserIdMap, tagIdAndUserIdMap, organizeIdAndUserIdMap, paperIdAndRelatedUsersMap, user);
        ArrayList deptExamSummarizeDtoList = new ArrayList();
        List executeExamUserList = CollectionUtils.isEmpty(trainingPapers) ? Collections.emptyList() : Optional.ofNullable(this.trainingUserPaperMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TrainingUserPaper::getTrainingPaperId, (Collection)trainingPapers.stream().map(TrainingPaper::getId).collect(Collectors.toList())))).orElse(Collections.emptyList());
        deptDimensionDtos.forEach(dept -> {
            List deptUserListOriginal = Optional.ofNullable(deptNameAndUserIds.get(dept.getDeptName())).orElse(Collections.emptyList());
            ArrayList deptUserList = new ArrayList(deptUserListOriginal);
            DeptExamSummarizeDto deptExamSummarizeDto = new DeptExamSummarizeDto();
            deptExamSummarizeDto.setDeptName(dept.getDeptName()).setDeptId(dept.getDeptId()).setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptUserList.retainAll(watchUserIds);
            deptExamSummarizeDto.setDeptUserNum(Integer.valueOf(deptUserList.size()));
            deptExamSummarizeDto.setEnableUserIdList(deptUserList);
            ArrayList canWatchExamIds = new ArrayList();
            paperIdAndRelatedUsersMap.forEach((k, v) -> {
                ArrayList relateUserIds = new ArrayList(v);
                relateUserIds.retainAll(deptUserList);
                if (!CollectionUtils.isEmpty(relateUserIds)) {
                    canWatchExamIds.add(k);
                }
            });
            LocalDateTime beginTime = 0 == countType ? dept.getBeginTime().atTime(LocalTime.MIN) : dept.getCalDay().atTime(LocalTime.MIN);
            LocalDateTime endTime = 0 == countType ? dept.getEndTime().atTime(LocalTime.MAX) : dept.getCalDay().atTime(LocalTime.MAX);
            deptExamSummarizeDto.setCalDay(dept.getCalDay());
            List<TrainingPaper> rangeExamNums = CollectionUtils.isEmpty(canWatchExamIds) ? Collections.emptyList() : Optional.ofNullable(trainingPapers.stream().filter(x -> canWatchExamIds.contains(x.getId()) || null == x.getLookLevel()).filter(x -> beginTime.compareTo(DateUtils.dateToLocalDateTime(x.getStartTime())) <= 0 && endTime.compareTo(DateUtils.dateToLocalDateTime(x.getStartTime())) >= 0).collect(Collectors.toList())).orElse(Collections.emptyList());
            deptExamSummarizeDto.setExamCoverSession(Integer.valueOf(rangeExamNums.size()));
            List rageExamsIds = rangeExamNums.stream().map(TrainingPaper::getId).collect(Collectors.toList());
            List trainingPaperUsers = Optional.ofNullable(trainingPaperUserList.stream().filter(x -> rageExamsIds.contains(x.getPaperId())).collect(Collectors.toList())).orElse(Collections.emptyList());
            ArrayList examCoverPersonTimes = new ArrayList();
            rangeExamNums.forEach(x -> {
                HashSet<Integer> singleExamUsers = new HashSet<Integer>();
                if (Objects.isNull(x.getLookLevel())) {
                    if (CollectionUtils.isEmpty((Collection)selectAllUserIds)) {
                        List<Integer> allUserIds = this.queryAllUserIds(user);
                        singleExamUsers.addAll(this.handlePaperSelctAllUsers((TrainingPaper)x, user, allUserIds));
                    } else {
                        singleExamUsers.addAll(this.handlePaperSelctAllUsers((TrainingPaper)x, user, (List<Integer>)new ArrayList<Integer>(selectAllUserIds)));
                    }
                }
                trainingPaperUsers.forEach(pageUser -> {
                    List userIds;
                    if (!Objects.equals(pageUser.getPaperId(), x.getId())) {
                        return;
                    }
                    if (Objects.nonNull(pageUser.getUserId()) && deptUserList.contains(pageUser.getUserId())) {
                        singleExamUsers.add(pageUser.getUserId());
                    }
                    if (Objects.nonNull(pageUser.getRoleId())) {
                        userIds = roleIdAndUserIdMap.getOrDefault(pageUser.getRoleId(), Collections.emptyList());
                        userIds.retainAll(deptUserList);
                        singleExamUsers.addAll(userIds);
                    }
                    if (Objects.nonNull(pageUser.getTagId())) {
                        userIds = tagIdAndUserIdMap.getOrDefault(pageUser.getRoleId(), Collections.emptyList());
                        userIds.retainAll(deptUserList);
                        singleExamUsers.addAll(tagIdAndUserIdMap.getOrDefault(pageUser.getTagId(), Collections.emptyList()));
                    }
                    if (Objects.nonNull(pageUser.getOrganizeId())) {
                        userIds = organizeIdAndUserIdMap.getOrDefault(pageUser.getRoleId(), Collections.emptyList());
                        userIds.retainAll(deptUserList);
                        singleExamUsers.addAll(organizeIdAndUserIdMap.getOrDefault(pageUser.getOrganizeId(), Collections.emptyList()));
                    }
                });
                examCoverPersonTimes.addAll(singleExamUsers);
            });
            deptExamSummarizeDto.setExamCoverPersonTimes(Integer.valueOf(examCoverPersonTimes.size()));
            deptExamSummarizeDto.setExamCoverUserNum(Integer.valueOf((int)examCoverPersonTimes.stream().distinct().count()));
            List trainingUserPapers = Optional.ofNullable(executeExamUserList.stream().filter(x -> rageExamsIds.contains(x.getTrainingPaperId())).filter(x -> deptUserList.contains(x.getUserId())).collect(Collectors.toList())).orElse(new ArrayList());
            deptExamSummarizeDto.setExamJoinPersonTimes(Integer.valueOf((int)trainingUserPapers.stream().filter(DistinctUtils.distinctByKey(x -> x.getUserId() + "_" + x.getTrainingPaperId())).count()));
            deptExamSummarizeDto.setExamJoinUserNum(Integer.valueOf((int)trainingUserPapers.stream().filter(DistinctUtils.distinctByKey(TrainingUserPaper::getUserId)).count()));
            List<Integer> examIdAndPassUserId = this.calculateExamPassInfo(trainingUserPapers, rangeExamNums);
            deptExamSummarizeDto.setExamPassPersonTimes(Integer.valueOf(examIdAndPassUserId.size()));
            deptExamSummarizeDto.setExamPassUserNum(Integer.valueOf((int)examIdAndPassUserId.stream().distinct().count()));
            deptExamSummarizeDto.setPassRatio(examCoverPersonTimes.isEmpty() ? BigDecimal.ZERO : new BigDecimal(examIdAndPassUserId.size()).divide(new BigDecimal(examCoverPersonTimes.size()), 2, RoundingMode.HALF_UP));
            deptExamSummarizeDtoList.add(deptExamSummarizeDto);
        });
        return CompletableFuture.completedFuture(deptExamSummarizeDtoList);
    }

    @Override
    public BaseResult<Map<String, List<Integer>>> queryDeptAndUserCount(DeptQueryBaseRequest request, Users user) {
        UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
        usersOrgIdsAndTagsPojo.setGroupId(user.getGroupId());
        usersOrgIdsAndTagsPojo.setLevel(Integer.valueOf(StringUtils.isEmpty((Object)request.getOrganizeLevel()) ? 1 : request.getOrganizeLevel()));
        usersOrgIdsAndTagsPojo.setShowIdAndName(Boolean.TRUE);
        if (StringUtils.isEmpty((Object)request.getParentId()) && !CollectionUtils.isEmpty((Collection)request.getOrganizeIdList())) {
            BaseResult baseResult;
            ArrayList<Integer> orIds = new ArrayList<Integer>();
            ArrayList<String> depS = new ArrayList<String>();
            for (String or : request.getOrganizeIdList()) {
                String[] str = or.split("_");
                if (str.length <= 1) continue;
                if ("O".equals(str[0])) {
                    Integer orId = Integer.valueOf(str[1]);
                    orIds.add(orId);
                    continue;
                }
                depS.add(or);
            }
            if (!CollectionUtils.isEmpty(depS) && (baseResult = this.departmentApi.changOrganizeIdsSdk(user.getGroupId(), depS)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                orIds.addAll((Collection)baseResult.getData());
            }
            usersOrgIdsAndTagsPojo.setOrganizeId(orIds);
            Integer organizeLevel = null;
            BaseResult base = this.organizeApi.getOrganizeById((Integer)orIds.get(0));
            if (base != null && !StringUtils.isEmpty((Object)base.getData()) && !StringUtils.isEmpty((Object)((OrganizePojo)base.getData()).getOrgCode())) {
                organizeLevel = ((OrganizePojo)base.getData()).getOrgCode().length() / 4;
            }
            usersOrgIdsAndTagsPojo.setLevel(organizeLevel);
        }
        usersOrgIdsAndTagsPojo.setParentId(StringUtils.isEmpty((Object)request.getParentId()) ? null : Integer.valueOf(request.getParentId().substring(2)));
        return this.userOrganizeApi.getUserByLevel(usersOrgIdsAndTagsPojo);
    }

    private List<Integer> calculateExamPassInfo(List<TrainingUserPaper> trainingUserPapers, List<TrainingPaper> rangeExamNums) {
        Map<Integer, List<TrainingUserPaper>> trainingIdAndPaperMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
        List examIds = rangeExamNums.stream().map(TrainingPaper::getExamId).distinct().collect(Collectors.toList());
        List examList = new ArrayList();
        if (!examIds.isEmpty()) {
            examList = this.trainingExamMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TrainingExam::getId, examIds));
        }
        ArrayList<Integer> passUserIds = new ArrayList<Integer>();
        for (TrainingPaper trainingPaper : rangeExamNums) {
            Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingIdAndPaperMap.getOrDefault(trainingPaper.getId(), Collections.emptyList()).stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            List userStudyList = trainingIdAndPaperMap.getOrDefault(trainingPaper.getId(), Collections.emptyList()).stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
            ArrayList<Integer> userStarting = new ArrayList<Integer>();
            ArrayList<Integer> userWaitList = new ArrayList<Integer>();
            ArrayList<Integer> userFinishList = new ArrayList<Integer>();
            Iterator iterator = userStudyList.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                List trainingPaperList = trainingUserPaperMap.get(userId).stream().filter(DistinctUtils.distinctByKey(x -> x.getTrainingPaperId() + "_" + x.getUserId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(trainingPaperList)) continue;
                TrainingUserPaper temp = (TrainingUserPaper)trainingPaperList.get(0);
                for (TrainingUserPaper userPaper : trainingPaperList) {
                    if (userPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (temp.getPaperStatus() != 1 && !userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                        temp = userPaper;
                        continue;
                    }
                    if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                    temp = userPaper;
                }
                if (!StringUtils.isEmpty((Object)temp.getUpdateTime()) && temp.getPaperStatus() == 0) {
                    userStarting.add(userId);
                    continue;
                }
                if (!StringUtils.isEmpty((Object)temp.getSubmitTime()) && temp.getPaperStatus() == 1) {
                    userWaitList.add(userId);
                    continue;
                }
                userFinishList.add(userId);
            }
            int passLine = trainingPaper.getPassLine();
            Iterator iterator2 = userFinishList.iterator();
            while (iterator2.hasNext()) {
                BigDecimal score;
                int status;
                List list;
                BigDecimal score2;
                BigDecimal org_score;
                int userId = (Integer)iterator2.next();
                Optional<TrainingExam> trainingExam = examList.stream().filter(x -> x.getId().equals(trainingPaper.getExamId())).findFirst();
                BigDecimal bigDecimal = org_score = !trainingExam.isPresent() ? new BigDecimal(100) : trainingExam.get().getScore();
                List<TrainingUserPaper> trainingPaperList = trainingUserPaperMap.get(userId);
                List userPaperList = trainingPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getId).reversed()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userPaperList)) continue;
                TrainingUserPaper temp = trainingPaperList.get(0);
                for (TrainingUserPaper userPaper : trainingPaperList) {
                    if (userPaper.getPaperStatus() == 1) continue;
                    if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                        if (temp.getPaperStatus() != 1 && !userPaper.getCreateTime().after(temp.getCreateTime())) continue;
                        temp = userPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() == 0) {
                        if (temp.getPaperStatus() != 1 && userPaper.getScore().intValue() <= temp.getScore().intValue()) continue;
                        temp = userPaper;
                        continue;
                    }
                    if (trainingPaper.getScoreSelect() != 2 || temp.getPaperStatus() != 1 && !userPaper.getCreateTime().before(temp.getCreateTime())) continue;
                    temp = userPaper;
                }
                if (Objects.isNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() == 1) {
                    if (temp.getPaperStatus() == 1 || temp.getPaperStatus() == 0) {
                        score2 = new BigDecimal(0);
                        int status2 = this.isPass(org_score, score2, passLine);
                        if (3 != status2) continue;
                        passUserIds.add(userId);
                        continue;
                    }
                    score2 = temp.getScore();
                    int status3 = this.isPass(org_score, score2, passLine);
                    if (3 != status3) continue;
                    passUserIds.add(userId);
                    continue;
                }
                if (Objects.nonNull(trainingPaper.getScoreSelect()) && trainingPaper.getScoreSelect() == 2) {
                    score2 = temp.getScore();
                    int status4 = this.isPass(org_score, score2, passLine);
                    if (3 != status4) continue;
                    passUserIds.add(userId);
                    continue;
                }
                if (!Objects.nonNull(trainingPaper.getScoreSelect()) || trainingPaper.getScoreSelect() != 0 || CollectionUtils.isEmpty(list = userPaperList.stream().filter(e -> e.getPaperStatus() == 2).sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList())) || 3 != (status = this.isPass(org_score, score = temp.getScore(), passLine))) continue;
                passUserIds.add(userId);
            }
        }
        return passUserIds;
    }

    private int isPass(BigDecimal org_score, BigDecimal score, int passLine) {
        BigDecimal percent = new BigDecimal(passLine).divide(new BigDecimal(100));
        BigDecimal result = org_score.multiply(percent);
        if (score.compareTo(result) >= 0) {
            return 3;
        }
        return 4;
    }

    private List<TrainingPaperUser> handleValues(List<TrainingPaper> trainingPapers, Set<Integer> selectAllUserIds, Map<Integer, List<Integer>> roleIdAndUserIdMap, Map<Integer, List<Integer>> tagIdAndUserIdMap, Map<String, List<Integer>> organizeIdAndUserIdMap, Map<Integer, Set<Integer>> paperIdAndUserIdMap, Users user) {
        if (CollectionUtils.isEmpty(trainingPapers)) {
            return new ArrayList<TrainingPaperUser>(0);
        }
        List<TrainingPaper> trainingPaperWithAuths = Optional.ofNullable(trainingPapers.stream().filter(x -> !Objects.equals(4, x.getProjectShow())).filter(x -> !Objects.isNull(x.getLookLevel())).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<TrainingPaperUser> trainingPaperUserList = this.querySimpleExamUserIds(trainingPaperWithAuths);
        List<TrainingPaper> courseCopyPaperList = Optional.ofNullable(trainingPapers.stream().filter(x -> Objects.equals(4, x.getProjectShow())).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<TrainingPaperUser> coursePaperUserList = this.queryCourseUserIds(trainingPapers, selectAllUserIds, courseCopyPaperList, user);
        trainingPaperUserList.addAll(coursePaperUserList);
        for (TrainingPaperUser paperUser : trainingPaperUserList) {
            Set paperUserIds = paperIdAndUserIdMap.getOrDefault(paperUser.getPaperId(), new HashSet());
            if (Objects.nonNull(paperUser.getUserId())) {
                paperUserIds.add(paperUser.getUserId());
            }
            if (Objects.nonNull(paperUser.getRoleId()) && !roleIdAndUserIdMap.containsKey(paperUser.getRoleId())) {
                List<Integer> roleUserIds = this.userUtilService.selectUsersByRoles(Collections.singletonList(paperUser.getRoleId()), user.getGroupId());
                roleIdAndUserIdMap.put(paperUser.getRoleId(), roleUserIds);
                paperUserIds.addAll(roleUserIds);
            }
            if (Objects.nonNull(paperUser.getTagId()) && !tagIdAndUserIdMap.containsKey(paperUser.getTagId())) {
                List<Integer> tagUserIds = this.userUtilService.selectUserIdsByTagIds(Collections.singletonList(paperUser.getTagId()), user.getGroupId(), user.getId());
                tagIdAndUserIdMap.put(paperUser.getTagId(), tagUserIds);
                paperUserIds.addAll(tagUserIds);
            }
            if (Objects.nonNull(paperUser.getOrganizeId()) && !organizeIdAndUserIdMap.containsKey(paperUser.getOrganizeId())) {
                List<Integer> organizeUserIds = this.userUtilService.selectUserIdsByOrganizeIds(Collections.singletonList(paperUser.getOrganizeId()), user.getGroupId());
                organizeIdAndUserIdMap.put(paperUser.getOrganizeId(), organizeUserIds);
                paperUserIds.addAll(organizeUserIds);
            }
            paperIdAndUserIdMap.putIfAbsent(paperUser.getPaperId(), paperUserIds);
        }
        List projectPapers = Optional.ofNullable(trainingPaperWithAuths.stream().filter(x -> Objects.equals(1, x.getProjectShow())).collect(Collectors.toList())).orElse(new ArrayList());
        this.handleProjectPaperUsers(projectPapers, paperIdAndUserIdMap);
        return trainingPaperUserList;
    }

    private void handleProjectPaperUsers(List<TrainingPaper> projectPapers, Map<Integer, Set<Integer>> paperIdAndUserIdMap) {
        if (null == projectPapers || projectPapers.isEmpty()) {
            return;
        }
        List paperIds = projectPapers.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        List trainingTaskSchedules = Optional.ofNullable(this.trainingTaskScheduleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingTaskSchedule::getPaperId, paperIds)).select(new SFunction[]{TrainingTaskSchedule::getPaperId, TrainingTaskSchedule::getPaperIdOld}))).orElse(new ArrayList(0));
        if (trainingTaskSchedules.isEmpty()) {
            return;
        }
        Map<Integer, Integer> paperIdAndSourceIdMap = trainingTaskSchedules.stream().collect(Collectors.toMap(TrainingTaskSchedule::getPaperId, TrainingTaskSchedule::getPaperIdOld));
        paperIdAndSourceIdMap.forEach((k, v) -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)paperIdAndUserIdMap.get(k))) && !CollectionUtils.isEmpty((Collection)((Collection)paperIdAndUserIdMap.get(v)))) {
                paperIdAndUserIdMap.put((Integer)k, (Set<Integer>)paperIdAndUserIdMap.get(v));
            }
        });
    }

    private List<TrainingPaperUser> queryCourseUserIds(List<TrainingPaper> trainingPapers, Set<Integer> selectUserIds, List<TrainingPaper> courseCopyPaperList, Users users) {
        if (CollectionUtils.isEmpty(courseCopyPaperList)) {
            return Collections.emptyList();
        }
        List courseCopyExamIds = courseCopyPaperList.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        List courseStageTasks = this.trainingCourseStageTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingCourseStageTask::getTaskType, (Object)2)).in(TrainingCourseStageTask::getPaperId, courseCopyExamIds)).select(new SFunction[]{TrainingCourseStageTask::getCourseId, TrainingCourseStageTask::getPaperId}));
        Map<Integer, Integer> paperAndCoursMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getPaperId, TrainingCourseStageTask::getCourseId));
        List courseIds = courseStageTasks.stream().map(TrainingCourseStageTask::getCourseId).collect(Collectors.toList());
        List trainingCourseList = this.trainingCourseMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingCourse::getId, courseIds)).select(new SFunction[]{TrainingCourse::getId, TrainingCourse::getAppointType}));
        Map courseIdAndAppointType = trainingCourseList.stream().collect(Collectors.toMap(TrainingCourse::getId, Function.identity()));
        List trainingCourseUsers = Optional.ofNullable(this.trainingCourseUserMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingCourseUser::getCourseType, (Object)1)).in(TrainingCourseUser::getCourseId, courseIds)).select(new SFunction[]{TrainingCourseUser::getCourseId, TrainingCourseUser::getUserId, TrainingCourseUser::getRoleId, TrainingCourseUser::getTagId, TrainingCourseUser::getOrganizeId}))).orElse(new ArrayList());
        Map<Integer, List<TrainingCourseUser>> courseIdAndRelateUsers = trainingCourseUsers.stream().collect(Collectors.groupingBy(TrainingCourseUser::getCourseId));
        ArrayList<TrainingPaperUser> trainingPaperUsers = new ArrayList<TrainingPaperUser>();
        for (TrainingPaper x : courseCopyPaperList) {
            Integer courseId = paperAndCoursMap.get(x.getId());
            if (courseId == null) continue;
            TrainingCourse trainingCourse = (TrainingCourse)courseIdAndAppointType.get(courseId);
            if (trainingCourse.getAppointType() == 0) {
                trainingPapers.stream().filter(paper -> paper.getId().equals(x.getId())).forEach(paper -> paper.setLookLevel(null));
                if (!CollectionUtils.isEmpty(selectUserIds)) continue;
                selectUserIds = new HashSet<Integer>(this.queryAllUserIds(users));
                continue;
            }
            trainingPapers.stream().filter(paper -> paper.getId().equals(x.getId())).forEach(paper -> paper.setLookLevel(Integer.valueOf(1)));
            List<TrainingCourseUser> list = courseIdAndRelateUsers.get(courseId);
            list.stream().forEach(courseUser -> {
                TrainingPaperUser trainingPaperUser = new TrainingPaperUser();
                trainingPaperUser.setPaperId(x.getId());
                trainingPaperUser.setUserId(courseUser.getUserId());
                trainingPaperUser.setRoleId(courseUser.getRoleId());
                trainingPaperUser.setTagId(courseUser.getTagId());
                trainingPaperUser.setOrganizeId(courseUser.getOrganizeId());
                trainingPaperUsers.add(trainingPaperUser);
            });
        }
        return trainingPaperUsers;
    }

    private List<TrainingPaperUser> querySimpleExamUserIds(List<TrainingPaper> trainingPaperWithAuths) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingPaperUser::getPaperId, (Collection)trainingPaperWithAuths.stream().map(TrainingPaper::getId).collect(Collectors.toList()));
        return CollectionUtils.isEmpty(trainingPaperWithAuths) ? new ArrayList() : this.trainingPaperUserMapper.selectList((Wrapper)queryWrapper);
    }

    private List<Integer> queryAllUserIds(Users users) {
        ArrayList<Integer> userIds = new ArrayList();
        BaseResult simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(users.getGroupId(), null, null);
        userIds = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
        return userIds;
    }

    private List<Integer> handlePaperSelctAllUsers(TrainingPaper trainingPaper, Users users, List<Integer> userIds) {
        List<Integer> limitUsers;
        if (trainingPaper.getEndTime() != null && trainingPaper.getPaperState() != null && trainingPaper.getPaperState() == 3 && !CollectionUtils.isEmpty(limitUsers = this.userUtilService.selectOverGroupTime(users.getGroupId(), trainingPaper.getEndTime()))) {
            userIds.removeAll(limitUsers);
        }
        return userIds;
    }

    private List<TrainingUserViewTimeCourse> queryStudyTrainingCourseRecords(Set<Integer> userIds, List<Integer> types, LocalDateTime beginTime, LocalDateTime endTime) {
        List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingUserPaper::getUserId, userIds)).in(TrainingUserPaper::getSourceType, types)).between(TrainingUserPaper::getCreateTime, (Object)beginTime, (Object)endTime)).select(new SFunction[]{TrainingUserPaper::getTrainingPaperId, TrainingUserPaper::getUserId, TrainingUserPaper::getCreateTime, TrainingUserPaper::getSubmitTime}));
        if (null == trainingUserPaperList || trainingUserPaperList.isEmpty()) {
            return new ArrayList<TrainingUserViewTimeCourse>(0);
        }
        ArrayList<TrainingUserViewTimeCourse> coursesTimeList = new ArrayList<TrainingUserViewTimeCourse>();
        trainingUserPaperList.stream().filter(x -> null != x.getCreateTime() && null != x.getSubmitTime()).forEach(x -> {
            TrainingUserViewTimeCourse trainingUserViewTimeCourse = new TrainingUserViewTimeCourse();
            trainingUserViewTimeCourse.setCreateTime(x.getCreateTime());
            trainingUserViewTimeCourse.setViewTime(Integer.valueOf((int)Math.abs(Duration.between(x.getCreateTime().toInstant(), x.getSubmitTime().toInstant()).getSeconds())));
            trainingUserViewTimeCourse.setUserId(x.getUserId());
            coursesTimeList.add(trainingUserViewTimeCourse);
        });
        return coursesTimeList;
    }
}

