/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.pojo.BaseResult;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.DynamicTask;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.service.DynamicTaskService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.util.DateUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DynamicTaskServiceImpl
implements CommandLineRunner,
DynamicTaskService {
    private static final Logger log = LoggerFactory.getLogger(DynamicTaskServiceImpl.class);
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private MessageSource messageSource;
    public Map<Integer, ScheduledFuture<?>> taskMap = new ConcurrentHashMap();
    public List<Integer> taskList = new CopyOnWriteArrayList<Integer>();
    public Map<Integer, String> dataList = new HashMap<Integer, String>();
    public List<TrainingLearnShift> taskList2 = new CopyOnWriteArrayList<TrainingLearnShift>();
    private final ThreadPoolTaskScheduler syncScheduler;

    private String getRandomString() {
        return UUID.randomUUID().toString();
    }

    public DynamicTaskServiceImpl(ThreadPoolTaskScheduler syncScheduler) {
        this.syncScheduler = syncScheduler;
    }

    public List<Integer> getTaskList() {
        return this.taskList;
    }

    public List<TrainingLearnShift> getTaskList2() {
        return this.taskList2;
    }

    @Override
    public boolean add(DynamicTask task) {
        if (null != this.taskMap.get(task.getName())) {
            this.stop(task.getName());
        }
        Date startTime = task.getStartTime();
        ScheduledFuture schedule = this.syncScheduler.schedule(this.getRunnable(task), startTime);
        this.taskMap.put(task.getId(), schedule);
        this.taskList.add(task.getId());
        return true;
    }

    @Override
    public boolean addTask(List<TrainingLearnShift> list) {
        for (TrainingLearnShift shift : list) {
            String shiftName;
            BaseResult result = this.redisBaseApi.get(String.valueOf(shift.getId()));
            String flag = "";
            if (!result.getIsError().booleanValue()) {
                flag = (String)result.getData();
            }
            if (!StringUtils.isEmpty((Object)flag) && !flag.equals("0")) continue;
            String string = shiftName = StringUtils.isEmpty((Object)shift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", shift.getShiftName(), shift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", shift.getShiftName(), shift.getGroupName(), shift.getSupplemenName());
            if (null != this.taskMap.get(shift.getId())) {
                this.stop(shift.getId());
            }
            Date startTime = shift.getStartTime();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shift.getId());
            List learnUserList = this.trainingLearnUserMapper.selectList((Wrapper)queryWrapper);
            List userIdList = learnUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
            ScheduledFuture schedule = this.syncScheduler.schedule(this.getRunnable(shift.getId()), startTime);
            this.taskMap.put(shift.getId(), schedule);
            this.taskList2.add(shift);
        }
        return true;
    }

    public Runnable getRunnable(TrainingLearnShift shift, List<Integer> userIdList, String shiftName) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String learnShiftName = this.messageSource.getMessage("training.learn.project.shift.name", null, locale);
        String dutTime = shift.getIsNotimeLimit() == 1 ? MessageFormat.format(this.messageSource.getMessage("training.learn.schedule.content.one", null, locale), DateUtils.format(shift.getStartTime(), "yyyy-MM-dd HH:mm")) : MessageFormat.format(this.messageSource.getMessage("training.learn.schedule.content.two", null, locale), DateUtils.format(shift.getStartTime(), "yyyy-MM-dd HH:mm"), DateUtils.format(shift.getEndTime(), "yyyy-MM-dd HH:mm"));
        return () -> {
            TaskMessageBody body = new TaskMessageBody();
            body.setType(115);
            HashMap msg = Maps.newHashMap();
            msg.put("projectId", shift.getProjectId());
            msg.put("shiftId", shift.getId());
            msg.put("title", learnShiftName);
            body.setTaskJson(JSONObject.toJSONString((Object)msg));
            Iterator iterator = userIdList.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                this.jPushService.sendWebSocket(learnShiftName, MessageFormat.format(this.messageSource.getMessage("training.learn.schedule.inline", null, locale), shiftName), userId, shift.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_SHIFT_TYPE", JSONObject.toJSONString((Object)msg), Objects.isNull(shift.getEndTime()) ? null : shift.getEndTime(), 1, 1, "training.learn.schedule.inline", shiftName);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_SHIFT_TYPE", userId, learnShiftName, dutTime, body);
            }
        };
    }

    public Runnable getRunnable(int shiftId) {
        TrainingLearnShift shift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(Integer.valueOf(shiftId));
        if (Objects.nonNull(shift) && shift.getStatus() != 0) {
            String one = "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5b66\u4e60\u9879\u76ee,\u8bf7\u5c3d\u5feb\u5b8c\u6210~ \u6709\u6548\u671f:{0} \u81f3 \u4e0d\u9650\u65f6";
            String two = "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5b66\u4e60\u9879\u76ee,\u8bf7\u5c3d\u5feb\u5b8c\u6210~ \u6709\u6548\u671f:{0} \u81f3 {1}";
            String titleName = "\u5b66\u4e60\u9879\u76ee\u73ed\u6b21";
            String inlineName = "\u5b66\u4e60\u9879\u76ee\u300a{0}\u300b\u4e0a\u7ebf,\u8bf7\u5c3d\u5feb\u5b8c\u6210\u5b66\u4e60";
            String shiftName = StringUtils.isEmpty((Object)shift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", shift.getShiftName(), shift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", shift.getShiftName(), shift.getGroupName(), shift.getSupplemenName());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TrainingLearnUser::getShiftId, (Object)shift.getId());
            queryWrapper.eq(TrainingLearnUser::getIsDelete, (Object)0);
            List learnUserList = this.trainingLearnUserMapper.selectList((Wrapper)queryWrapper);
            List userIdList = learnUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
            String dutTime = Objects.nonNull(shift.getIsOnlineNow()) && shift.getIsNotimeLimit() == 1 ? MessageFormat.format(one, DateUtils.format(shift.getStartTime(), "yyyy-MM-dd HH:mm")) : MessageFormat.format(two, DateUtils.format(shift.getStartTime(), "yyyy-MM-dd HH:mm"), DateUtils.format(shift.getEndTime(), "yyyy-MM-dd HH:mm"));
            return () -> {
                BaseResult result = this.redisBaseApi.get(String.valueOf(shift.getId()));
                String flag = "";
                if (!result.getIsError().booleanValue()) {
                    flag = (String)result.getData();
                }
                if (StringUtils.isEmpty((Object)flag) || flag.equals("0")) {
                    log.info(shiftId + "------->" + flag);
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(115);
                    HashMap msg = Maps.newHashMap();
                    msg.put("projectId", shift.getProjectId());
                    msg.put("shiftId", shift.getId());
                    msg.put("title", titleName);
                    body.setTaskJson(JSONObject.toJSONString((Object)msg));
                    this.jPushService.sendWebSocketAll(titleName, MessageFormat.format(inlineName, shiftName), userIdList, shift.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_SHIFT_TYPE", JSONObject.toJSONString((Object)msg), Objects.isNull(shift.getEndTime()) ? null : shift.getEndTime(), 1, 1, "training.learn.schedule.inline", shiftName);
                    if (Objects.nonNull(shift.getIsSendMessage()) && shift.getIsSendMessage() == 1) {
                        this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_SHIFT_TYPE", userIdList, shiftName, dutTime, body);
                    }
                    this.redisBaseApi.set(String.valueOf(shiftId), "1");
                }
            };
        }
        return () -> {};
    }

    public Runnable getRunnable(DynamicTask task) {
        return () -> {
            log.info("---\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1\u8fd0\u884c---");
            try {
                log.info("\u6b64\u65f6\u65f6\u95f4==>" + new Date());
                log.info("task\u4e2d\u8bbe\u5b9a\u7684\u65f6\u95f4==>" + task);
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            log.info("---end--------");
        };
    }

    @Override
    public boolean stop(String name) {
        if (null == this.taskMap.get(name)) {
            return false;
        }
        ScheduledFuture<?> scheduledFuture = this.taskMap.get(name);
        scheduledFuture.cancel(true);
        this.taskMap.remove(name);
        this.taskList.remove(name);
        return true;
    }

    @Override
    public List<Integer> selectDynamicTask() {
        return this.taskList;
    }

    @Override
    public List<TrainingLearnShift> selectDynamicTask2() {
        return this.taskList2;
    }

    @Override
    public boolean stop(int shiftId) {
        if (null == this.taskMap.get(shiftId)) {
            return false;
        }
        ScheduledFuture<?> scheduledFuture = this.taskMap.get(shiftId);
        scheduledFuture.cancel(true);
        this.redisBaseApi.set(String.valueOf(shiftId), "0");
        this.taskMap.remove(shiftId);
        this.taskList2.remove(this.trainingLearnShiftMapper.selectById(Integer.valueOf(shiftId)));
        return true;
    }

    public void run(String ... args) throws Exception {
        log.info("\u52a0\u8f7d\u9700\u8981\u63a8\u9001\u6d88\u606f\u7684\u5b66\u4e60\u9879\u76ee\u73ed\u6b21");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingLearnShift::getStatus, (Object)1);
        queryWrapper.eq(TrainingLearnShift::getIsOnlineNow, (Object)0);
        queryWrapper.eq(TrainingLearnShift::getIsSendMessage, (Object)1);
        List list = this.trainingLearnShiftMapper.selectList((Wrapper)queryWrapper);
        this.addTask(list);
    }
}

