/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.organize.common.model.mo.MessageBatchMo;
import com.ovopark.organize.common.model.mo.MessageMo;
import com.ovopark.organize.sdk.api.MessageApi;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.HttpUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JPushServiceImpl
implements JPushService {
    private static final Logger log = LoggerFactory.getLogger(JPushServiceImpl.class);
    @Autowired
    private MessageApi messageApi;
    @Autowired
    private MessageHubV2Api messageHubV2Api;
    @Value(value="${jpush.apnsProduction}")
    private String apnsProductionStr;
    @Value(value="${websocket.url}")
    private String webSocketServerUrl;

    @Override
    public void pushNotification(Integer messageType, String objectType, Integer userId, String title, String message, TaskMessageBody body) {
        if (userId != null) {
            MessageBody messageBody = new MessageBody();
            BeanUtils.copyProperties((Object)body, (Object)messageBody);
            MessageRequest messageRequest = ((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)SubsBuilders.jg((String)objectType).from("ovopark-training")).toUserIdList(Collections.singletonList(userId))).title(new ParamContext().plainText(title)).content(new ParamContext().plainText(message)).group(UUID.randomUUID().toString())).tagList(Arrays.asList("ovopark-attendance", "jiguang"))).messageBody(messageBody).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(message))).mcDescription(JSONObject.toJSONString((Object)body))).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).mcHidden(true)).build();
            BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
            log.info("pushNotification:{} pushReq:{} userId:{} message:{}", new Object[]{JSON.toJSONString((Object)baseResult), JSON.toJSONString((Object)messageRequest), userId, message});
        }
    }

    @Override
    public void pushNotificationAll(Integer messageType, String objectType, List<Integer> userIds, String title, String message, TaskMessageBody body) {
        if (!CollectionUtil.isEmpty(userIds)) {
            MessageBody messageBody = new MessageBody();
            BeanUtils.copyProperties((Object)body, (Object)messageBody);
            MessageRequest messageRequest = ((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)((SubsBuilders.JGBuilder)SubsBuilders.jg((String)objectType).from("ovopark-training")).toUserIdList(userIds)).title(new ParamContext().plainText(title)).content(new ParamContext().plainText(message)).group(UUID.randomUUID().toString())).tagList(Arrays.asList("ovopark-attendance", "jiguang"))).messageBody(messageBody).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(message))).mcDescription(JSONObject.toJSONString((Object)body))).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).mcHidden(true)).build();
            BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
            log.info("pushNotificationAll:{} pushReq:{} message:{}", new Object[]{JSON.toJSONString((Object)baseResult), JSON.toJSONString((Object)messageRequest), message});
        }
    }

    @Override
    public void sendWebSocket(String title, String content, Integer userId, Integer enterpriseId, Integer objectId, String objectType, String taskJson, Date endTime, Integer isExecutor, Integer isTodoMessage, String i18nKey, String i18nParam) {
        if (isTodoMessage == 0) {
            MessageRequest thirdMessageRequest;
            BaseResult thirdBaseResult;
            MessageRequest messageRequest = ((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)SubsBuilders.wbs((String)objectType).from("ovopark-training")).toUserIdList(Collections.singletonList(userId))).content(new ParamContext().plainText(content)).locale(Locale.CHINA)).group(UUID.randomUUID().toString())).tagList(Arrays.asList("ovopark-training", "websocket"))).client(new String[]{"web", "iOS", "Android"}).messageType(objectType).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(JSON.toJSONString((Object)content)))).mcDescription(taskJson)).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).build();
            BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
            log.info("saveMessages websocketReq:{} userId:{} message:{} response:{} ", new Object[]{JSON.toJSONString((Object)messageRequest), userId, content, JSON.toJSONString((Object)baseResult)});
            String id = UUID.randomUUID().toString();
            ThirdMessage thirdMessage = new ThirdMessage();
            thirdMessage.setEnterpriseId(enterpriseId);
            thirdMessage.setDescription(content);
            thirdMessage.setObjectId(objectId);
            thirdMessage.setCategory("TYPE_TRAINING");
            thirdMessage.setObjectType(objectType);
            thirdMessage.setTitleName(title);
            if ("TYPE_TRAINING_NEW_SYSTEM".equals(objectType)) {
                JSONObject taskJsonObj = JSON.parseObject((String)taskJson);
                String path = taskJsonObj.getString("path");
                String[] pathSplit = path.split("/");
                thirdMessage.setPictureUrl(path);
                thirdMessage.setPictureName(pathSplit[pathSplit.length - 1]);
                taskJsonObj.remove((Object)"path");
                taskJsonObj.remove((Object)"pushTitle");
                taskJsonObj.remove((Object)"pushMessage");
                thirdMessage.setDescription(content);
                thirdMessage.setDetails(JSON.toJSONString((Object)taskJsonObj));
            }
            if (!(thirdBaseResult = this.messageHubV2Api.send(thirdMessageRequest = ((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)SubsBuilders.third((String)objectType).from("ovopark-training")).toUserIdList(Collections.singletonList(userId))).locale(Locale.CHINA)).group(id)).tagList(Arrays.asList("ovopark-training", "third"))).thirdMessage(thirdMessage).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(content))).mcDescription(content)).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).mcHidden(true)).build())).getIsError().booleanValue()) {
                log.info("message trace id:{} thirdReq{} " + (String)thirdBaseResult.getData(), (Object)JSON.toJSONString((Object)thirdMessageRequest));
            } else {
                log.info("messageerror trace id:{} thirdReq{} " + (String)thirdBaseResult.getData(), (Object)JSON.toJSONString((Object)thirdMessageRequest));
            }
        } else {
            Date now = new Date();
            String nowStr = DateUtils.format(now);
            MessageMo msg = new MessageMo();
            msg.setContent(content);
            msg.setCreateTime(nowStr);
            msg.setEnterpriseId(enterpriseId);
            msg.setTargetUserId(userId);
            msg.setCategory("TYPE_TRAINING");
            msg.setObjectType(objectType);
            msg.setDescription(taskJson);
            msg.setDetails(taskJson);
            msg.setEndTime(endTime);
            msg.setStatus(Integer.valueOf(0));
            msg.setOptionState(Integer.valueOf(0));
            msg.setObjectId(objectId);
            msg.setIsExecutor(isExecutor);
            msg.setIsTodoMessage(isTodoMessage);
            msg.setI18nKey(i18nKey);
            msg.setI18nParam(i18nParam);
            if ("TYPE_TRAINING_NEW_SYSTEM".equals(objectType)) {
                JSONObject taskJsonObj = JSON.parseObject((String)taskJson);
                String path = taskJsonObj.getString("path");
                String[] pathSplit = path.split("/");
                msg.setPictureUrl(path);
                msg.setPictureName(pathSplit[pathSplit.length - 1]);
                taskJsonObj.remove((Object)"path");
                taskJsonObj.remove((Object)"pushTitle");
                taskJsonObj.remove((Object)"pushMessage");
                msg.setDescription(JSON.toJSONString((Object)taskJsonObj));
                msg.setDetails(JSON.toJSONString((Object)taskJsonObj));
            }
            com.ovopark.organize.common.base.BaseResult baseResult = this.messageApi.saveMessages(msg);
            log.info("\u63a8\u9001sendWebSocket\uff1a" + (baseResult != null ? JSON.toJSONString((Object)baseResult) : "") + ", userId:" + userId + ", message:" + content);
        }
    }

    @Override
    public void sendWebSocketAll(String title, String content, List<Integer> userIds, Integer enterpriseId, Integer objectId, String objectType, String taskJson, Date endTime, Integer isExecutor, Integer isTodoMessage, String i18nKey, String i18nParam) {
        if (isTodoMessage == 0) {
            MessageRequest thirdMessageRequest;
            BaseResult thirdBaseResult;
            MessageRequest messageRequest = ((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)SubsBuilders.wbs((String)objectType).from("ovopark-training")).toUserIdList(userIds)).content(new ParamContext().plainText(content)).locale(Locale.CHINA)).group(UUID.randomUUID().toString())).tagList(Arrays.asList("ovopark-training", "websocket"))).client(new String[]{"web", "iOS", "Android"}).messageType(objectType).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(JSON.toJSONString((Object)content)))).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).mcDescription(taskJson)).build();
            BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
            log.info("saveMessages websocketReq:{} userId:{} message:{} response:{} ", new Object[]{JSON.toJSONString((Object)messageRequest), userIds, content, JSON.toJSONString((Object)baseResult)});
            String id = UUID.randomUUID().toString();
            ThirdMessage thirdMessage = new ThirdMessage();
            thirdMessage.setEnterpriseId(enterpriseId);
            thirdMessage.setDescription(content);
            thirdMessage.setObjectId(objectId);
            thirdMessage.setCategory("TYPE_TRAINING");
            thirdMessage.setObjectType(objectType);
            thirdMessage.setTitleName(title);
            if ("TYPE_TRAINING_NEW_SYSTEM".equals(objectType)) {
                JSONObject taskJsonObj = JSON.parseObject((String)taskJson);
                String path = taskJsonObj.getString("path");
                String[] pathSplit = path.split("/");
                thirdMessage.setPictureUrl(path);
                thirdMessage.setPictureName(pathSplit[pathSplit.length - 1]);
                taskJsonObj.remove((Object)"path");
                taskJsonObj.remove((Object)"pushTitle");
                taskJsonObj.remove((Object)"pushMessage");
                thirdMessage.setDescription(content);
                thirdMessage.setDetails(JSON.toJSONString((Object)taskJsonObj));
            }
            if (!(thirdBaseResult = this.messageHubV2Api.send(thirdMessageRequest = ((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)SubsBuilders.third((String)objectType).from("ovopark-training")).toUserIdList(userIds)).locale(Locale.CHINA)).group(id)).tagList(Arrays.asList("ovopark-training", "third"))).thirdMessage(thirdMessage).mcTitle(new ParamContext().plainText(title))).mcContent(new ParamContext().plainText(content))).mcDescription(content)).mcCategory("TYPE_TRAINING")).mcObjectType(objectType)).mcHidden(true)).build())).getIsError().booleanValue()) {
                log.info("message trace id:{} thirdReq:{} " + (String)thirdBaseResult.getData(), (Object)JSON.toJSONString((Object)thirdMessageRequest));
            } else {
                log.info("messageerror trace id:{} thirdReq{} " + (String)thirdBaseResult.getData(), (Object)JSON.toJSONString((Object)thirdMessageRequest));
            }
        } else {
            Users users = Authenticator.getInstance().getCurrentUser();
            Date now = new Date();
            String nowStr = DateUtils.format(now);
            ArrayList<MessageMo> list = new ArrayList<MessageMo>();
            MessageBatchMo batchMo = new MessageBatchMo();
            MessageMo messageMo = new MessageMo();
            messageMo.setCategory("TYPE_TRAINING");
            messageMo.setEnterpriseId(enterpriseId);
            messageMo.setIsExecutor(isExecutor);
            messageMo.setIsTodoMessage(isTodoMessage);
            messageMo.setObjectId(objectId);
            messageMo.setObjectType(objectType);
            messageMo.setCreateTime(DateUtils.getDateStr(new Date(), DateUtils.FORMAT_LONG));
            messageMo.setOptionState(Integer.valueOf(0));
            messageMo.setSendWeChat(Boolean.valueOf(false));
            messageMo.setStatus(Integer.valueOf(0));
            messageMo.setwStatus(Integer.valueOf(0));
            messageMo.setI18nKey(i18nKey);
            messageMo.setI18nParam(i18nParam);
            MessageMo saveMo = new MessageMo();
            saveMo.setCategory("TYPE_TRAINING");
            saveMo.setContent(content);
            saveMo.setCreateTime(nowStr);
            saveMo.setDetails(taskJson);
            saveMo.setDescription(taskJson);
            saveMo.setEnterpriseId(enterpriseId);
            saveMo.setIsExecutor(isExecutor);
            saveMo.setEndTime(endTime);
            saveMo.setIsTodoMessage(isTodoMessage);
            saveMo.setObjectId(objectId);
            saveMo.setObjectType(objectType);
            saveMo.setOptionState(Integer.valueOf(0));
            saveMo.setSendWeChat(Boolean.valueOf(false));
            if (Objects.nonNull(users)) {
                saveMo.setSrcUserId(users.getId());
            } else {
                saveMo.setSrcUserId(null);
            }
            saveMo.setIsDeal(Integer.valueOf(0));
            saveMo.setStatus(Integer.valueOf(0));
            saveMo.setwStatus(Integer.valueOf(0));
            saveMo.setI18nKey(i18nKey);
            saveMo.setI18nParam(i18nParam);
            batchMo.setMessageMo(messageMo);
            batchMo.setSaveMo(saveMo);
            batchMo.setSingleAdd(Boolean.valueOf(true));
            batchMo.setUserIds(userIds);
            com.ovopark.organize.common.base.BaseResult baseResult = this.messageApi.saveBatchMessages(batchMo);
            log.info("sendWebSocketAll:{} message:{}", (Object)JSON.toJSONString((Object)baseResult), (Object)content);
            MessageMo msg = null;
            for (Integer userId : userIds) {
                msg = new MessageMo();
                msg.setContent(content);
                msg.setCreateTime(nowStr);
                msg.setEnterpriseId(enterpriseId);
                msg.setCategory("TYPE_TRAINING");
                msg.setObjectType(objectType);
                msg.setDescription(taskJson);
                msg.setDetails(taskJson);
                msg.setEndTime(endTime);
                msg.setStatus(Integer.valueOf(0));
                msg.setOptionState(Integer.valueOf(0));
                msg.setObjectId(objectId);
                msg.setIsExecutor(isExecutor);
                msg.setIsTodoMessage(isTodoMessage);
                msg.setTargetUserId(userId);
                msg.setIsDeal(Integer.valueOf(0));
                msg.setI18nKey(i18nKey);
                msg.setI18nParam(i18nParam);
                list.add(msg);
            }
            this.messageApi.saveBatch(list);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("clients", "Android,iOS");
            map.put("messageType", "1000");
            for (MessageMo mo : list) {
                map.put("userId", mo.getTargetUserId() + "");
                map.put("message", JSONObject.toJSONString((Object)mo));
                HttpUtils.sendJsonToOtherServerDefault(this.webSocketServerUrl + "/websocket/sendMessageToUser", map);
            }
        }
    }

    @Override
    public void deleteMessages(Integer objectId, String objectType, Integer userId, Integer subId, Integer isTodoMessage) {
        log.info("\u5220\u9664\u5f85\u529e\uff1a" + objectId + " , " + objectType + " , " + userId);
        this.messageApi.deleteMessagesByObject(objectType, objectId, userId, subId, isTodoMessage).getData();
    }

    @Override
    public void updateMessagesByObjectType(Integer objectId, String objectType, Integer userId, Integer subId, Integer isTodoMessage, String endTime) {
        this.messageApi.updateMessagesByObjectType(objectType, objectId, userId, subId, isTodoMessage, null, null, endTime);
    }
}

