/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Maps;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DataStatisticMo;
import com.ovopark.organize.common.model.mo.DataStatisticModule;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DataStatisticApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingExistEnterpriseMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobShiftTaskMapper;
import com.ovopark.training.mapper.TrainingJobStageMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnShiftRecordMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeDayMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingWorkMapper;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingCertificate;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingExistEnterprise;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStage;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobStudentAnalyse;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnShiftRecord;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeDay;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.ScheduleService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.TrainingWorkReviewerService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TitleVo;
import com.ovopark.training.vo.TrainingCourseMobile;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingLearnShiftRecordVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.utils.DateUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private TrainingCertificateMapper certificateMapper;
    @Autowired
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Autowired
    private DataStatisticApi dataStatisticApi;
    @Autowired
    private TrainingUserViewTimeMapper userViewTimeMapper;
    @Autowired
    private TrainingExistEnterpriseMapper existEnterpriseMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingJobUserMapper trainingJobUserMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingJobStudentAnalyseMapper trainingJobStudentAnalyseMapper;
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private TrainingLearnShiftMapper learnShiftMapper;
    @Autowired
    private TrainingPaperRemoteService trainingPaperRemoteService;
    @Autowired
    private TrainingPaperService trainingPaperService;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingJobStageTaskMapper jobStageTaskMapper;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private TrainingJobUserTaskMapper jobUserTaskMapper;
    @Autowired
    private TrainingJobStageMapper jobStageMapper;
    @Autowired
    private TrainingJobShiftTaskMapper jobShiftTaskMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private TrainingCourseMapper courseMapper;
    @Autowired
    private TrainingCourseUserMapper courseUserMapper;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private TrainingCourseService courseService;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingPaperMapper paperMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private com.ovopark.privilege.api.UserApi priUserApi;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingWorkReviewerService trainingWorkReviewerService;
    @Autowired
    private TrainingWorkMapper trainingWorkMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private TrainingCourseUserTaskMapper trainingCourseUserTaskMapper;
    @Autowired
    private TrainingLearnShiftRecordMapper trainingLearnShiftRecordMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingUserViewTimeDayMapper trainingUserViewTimeDayMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;

    @Override
    public void updateCertificateDetailEnd() {
        Date now = new Date();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingCertificateDetail::getStatus, (Object)1)).eq(TrainingCertificateDetail::getIsAlways, (Object)0)).isNotNull(TrainingCertificateDetail::getEndTime)).le(TrainingCertificateDetail::getEndTime, (Object)now);
        List certificateDetails = this.certificateDetailMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)certificateDetails)) {
            List certificateIdList = certificateDetails.stream().map(TrainingCertificateDetail::getCertificateId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List trainingCertificateList = this.certificateMapper.selectBatchIds(certificateIdList);
            Map trainingCertificateMap = trainingCertificateList.stream().collect(Collectors.toMap(TrainingCertificate::getId, Function.identity()));
            for (int i = 0; i < certificateDetails.size(); ++i) {
                TrainingCertificateDetail certificateDetail = (TrainingCertificateDetail)certificateDetails.get(i);
                if (certificateDetail.getEndTime() == null || now.compareTo(certificateDetail.getEndTime()) < 0) continue;
                certificateDetail.setStatus(Integer.valueOf(2));
                this.certificateDetailMapper.updateById(certificateDetail);
                TrainingCertificate certificate = (TrainingCertificate)trainingCertificateMap.get(certificateDetail.getCertificateId());
                certificate.setEffectNum(Integer.valueOf(certificate.getEffectNum() - 1));
                this.certificateMapper.updateById(certificate);
            }
        }
    }

    @Override
    public void countGroupPeopleSchedule() {
        try {
            List<TrainingUserViewTimeVo> dayData = this.userViewTimeMapper.selectTrainingDayGroup();
            if (!CollectionUtils.isEmpty(dayData)) {
                List dayUserIds = dayData.stream().map(TrainingUserViewTime::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<Integer> dayGroupIds = dayData.stream().map(TrainingUserViewTime::getEnterpriseId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                List allData = this.existEnterpriseMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)allData)) {
                    List oldUserIds = allData.stream().map(TrainingExistEnterprise::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(dayUserIds) && !CollectionUtils.isEmpty(oldUserIds)) {
                        dayUserIds.removeAll(oldUserIds);
                    }
                    ArrayList<TrainingExistEnterprise> existList = new ArrayList<TrainingExistEnterprise>();
                    if (!CollectionUtils.isEmpty(dayUserIds)) {
                        for (Integer userId : dayUserIds) {
                            TrainingExistEnterprise existEnterprise = new TrainingExistEnterprise();
                            existEnterprise.setUserId(userId);
                            existEnterprise.setCreateTime(new Date());
                            existList.add(existEnterprise);
                        }
                    }
                    List oldGroupIds = allData.stream().map(TrainingExistEnterprise::getEnterpriseId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(dayGroupIds) && !CollectionUtils.isEmpty(oldGroupIds)) {
                        dayGroupIds.removeAll(oldGroupIds);
                    }
                    if (!CollectionUtils.isEmpty(dayGroupIds)) {
                        List<TrainingUserViewTimeVo> limitData = this.userViewTimeMapper.selectTrainingLimitGroup(dayGroupIds);
                        dayGroupIds = limitData.stream().map(TrainingUserViewTime::getEnterpriseId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    }
                    if (!CollectionUtils.isEmpty(dayGroupIds)) {
                        for (Integer groupId : dayGroupIds) {
                            TrainingExistEnterprise existEnterprise = new TrainingExistEnterprise();
                            existEnterprise.setEnterpriseId(groupId);
                            existEnterprise.setCreateTime(new Date());
                            existList.add(existEnterprise);
                        }
                    }
                    if (!CollectionUtils.isEmpty(existList)) {
                        this.existEnterpriseMapper.insertList(existList);
                    }
                    DataStatisticMo mo = new DataStatisticMo();
                    mo.setModule(DataStatisticModule.TRAINING);
                    mo.setDate(LocalDate.now());
                    mo.setNewUserCount(Integer.valueOf(CollectionUtils.isEmpty(dayUserIds) ? 0 : dayUserIds.size()));
                    mo.setNewEnterpriseCount(Integer.valueOf(CollectionUtils.isEmpty(dayGroupIds) ? 0 : dayGroupIds.size()));
                    BaseResult result = this.dataStatisticApi.postData(mo);
                    if (result.getIsError().booleanValue()) {
                        log.error("\u5b9a\u65f6\u7edf\u8ba1\u6628\u5929\u65b0\u589e\u4f01\u4e1a\u5b66\u5458", (Object)(result.getCode() + result.getMessage()));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u7edf\u8ba1\u6628\u5929\u65b0\u589e\u4f01\u4e1a\u5b66\u5458", (Throwable)e);
        }
    }

    @Override
    public void jobCertificationApproveRemind() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingJobCertification::getExamineType, (Object)2);
        queryWrapper.eq(TrainingJobCertification::getStatus, (Object)1);
        queryWrapper.eq(TrainingJobCertification::getIsRemind, (Object)1);
        List jobCertificationList = this.trainingJobCertificationMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)jobCertificationList)) {
            List jobCertificationIdList = jobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
            queryWrapper2.in(TrainingJobUser::getJobId, jobCertificationIdList);
            queryWrapper2.eq(TrainingJobUser::getJobType, (Object)2);
            List trainingJobUsers = this.trainingJobUserMapper.selectList((Wrapper)queryWrapper2);
            Map<Integer, List<TrainingJobUser>> map = trainingJobUsers.stream().collect(Collectors.groupingBy(TrainingJobUser::getUserId));
            if (!CollectionUtils.isEmpty((Collection)trainingJobUsers)) {
                String warn = "\u5c97\u4f4d\u8ba4\u8bc1\u5ba1\u6279\u63d0\u9192";
                String warnDetail = "\u60a8\u5f53\u524d\u6709{0}\u4e2a\u5c97\u4f4d\u8ba4\u8bc1\u5f85\u5ba1\u6279\uff0c\u8bf7\u81f3web\u7aef<\u57f9\u8bad-\u4eba\u624d\u57f9\u517b-\u5c97\u4f4d\u8ba4\u8bc1-\u5b66\u5458\u5206\u6790-\u5f85\u5ba1\u6279>\u4e2d\u53ca\u65f6\u5ba1\u6279~";
                for (Map.Entry<Integer, List<TrainingJobUser>> entry : map.entrySet()) {
                    int userId = entry.getKey();
                    List jobIdList = entry.getValue().stream().map(TrainingJobUser::getJobId).collect(Collectors.toList());
                    LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
                    queryWrapper3.in(TrainingJobStudentAnalyse::getJobId, jobIdList);
                    queryWrapper3.eq(TrainingJobStudentAnalyse::getPassStatus, (Object)1);
                    List trainingJobStudentAnalyseList = this.trainingJobStudentAnalyseMapper.selectList((Wrapper)queryWrapper3);
                    if (CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) continue;
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(126);
                    HashMap msg = Maps.newHashMap();
                    msg.put("title", warn);
                    body.setTaskJson(JSONObject.toJSONString((Object)msg));
                    this.jPushService.sendWebSocket(warn, MessageFormat.format(warnDetail, trainingJobStudentAnalyseList.size()), userId, entry.getValue().get(0).getEnterpriseId(), (Integer)jobIdList.get(0), "TYPE_CERTIFICATION_OBJ_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.job.mark.warn.detail", trainingJobStudentAnalyseList.size() + "");
                    this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_CERTIFICATION_OBJ_TYPE", userId, warn, MessageFormat.format(warnDetail, trainingJobStudentAnalyseList.size()), body);
                }
            }
        }
    }

    @Override
    public void learnShiftStatusNotify() {
        try {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnShift::getStatus, (Object)1)).isNotNull(TrainingLearnShift::getStartTime)).le(TrainingLearnShift::getStartTime, (Object)new Date());
            List shiftList = this.learnShiftMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)shiftList)) {
                List shiftIds;
                List projectIds = shiftList.stream().filter(it -> it.getProjectId() != null).map(it -> it.getProjectId()).distinct().collect(Collectors.toList());
                HashMap projectMap = new HashMap();
                if (!CollectionUtils.isEmpty(projectIds)) {
                    List trainingLearnProjects = this.trainingLearnProjectMapper.selectBatchIds(projectIds);
                    projectMap.putAll(trainingLearnProjects.stream().collect(Collectors.toMap(TrainingLearnProject::getId, Function.identity())));
                }
                if (!CollectionUtils.isEmpty(shiftIds = shiftList.stream().filter(it -> {
                    TrainingLearnProject project;
                    return it.getProjectId() == null || (project = (TrainingLearnProject)projectMap.get(it.getProjectId())) == null || project.getStatus() == null || project.getStatus() != 2;
                }).map(TrainingLearnShift::getId).distinct().collect(Collectors.toList()))) {
                    TrainingLearnShift shift = new TrainingLearnShift();
                    shift.setStatus(Integer.valueOf(2));
                    LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                    wrapper2.in(TrainingLearnShift::getId, shiftIds);
                    this.learnShiftMapper.update(shift, (Wrapper)wrapper2);
                    TrainingLearnUser learnUser = new TrainingLearnUser();
                    learnUser.setLearnStatus(Integer.valueOf(1));
                    LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)wrapper3.eq(TrainingLearnUser::getIsDelete, (Object)0)).in(TrainingLearnUser::getShiftId, shiftIds);
                    this.trainingLearnUserMapper.update(learnUser, (Wrapper)wrapper3);
                }
            }
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingLearnShift::getStatus, Arrays.asList(1, 2))).isNotNull(TrainingLearnShift::getJobShiftId)).isNotNull(TrainingLearnShift::getEndTime)).le(TrainingLearnShift::getEndTime, (Object)new Date());
            List trainingLearnShiftList = this.learnShiftMapper.selectList((Wrapper)wrapper4);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnShiftList)) {
                List learnShiftIds = trainingLearnShiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
                LambdaUpdateWrapper wrapper5 = new LambdaUpdateWrapper();
                wrapper5.in(TrainingLearnShift::getId, learnShiftIds);
                TrainingLearnShift shifts = new TrainingLearnShift();
                shifts.setStatus(Integer.valueOf(3));
                this.learnShiftMapper.update(shifts, (Wrapper)wrapper5);
            }
        }
        catch (Exception e) {
            log.error("LearnShiftStatusNotify ", (Throwable)e);
        }
    }

    @Override
    public void paperStatusSchedule() {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.le(TrainingPaper::getEndTime, (Object)new Date())).eq(TrainingPaper::getPaperState, (Object)2);
        List paperList = this.trainingPaperMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)paperList)) {
            try {
                for (TrainingPaper paper : paperList) {
                    this.jPushService.deleteMessages(paper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1);
                    if (paper.getLookLevel() == null || paper.getLookLevel() != 1) continue;
                    this.trainingPaperService.updateUsersByClose(paper.getId(), paper.getCreater(), paper.getEnterpriseId());
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        try {
            this.trainingPaperRemoteService.updatePaperState();
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u66f4\u65b0\u8003\u8bd5\u72b6\u6001", (Throwable)e);
        }
    }

    @Override
    public void pushManagerByOrganize() {
        log.info("PushManagerByOrganize start");
        try {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getIsCall, (Object)1)).eq(TrainingJobCertification::getStatus, (Object)1);
            List jobCertificationList = this.trainingJobCertificationMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)jobCertificationList)) {
                List jobCertificationIdList = jobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingJobStageTask::getTaskType, (Object)3)).in(TrainingJobStageTask::getJobId, jobCertificationIdList);
                List jobStageTaskList = this.jobStageTaskMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)jobStageTaskList)) {
                    List jobStageList;
                    Map<Integer, List> jobStageTaskMap = jobStageTaskList.stream().collect(Collectors.toMap(TrainingJobStageTask::getJobId, e -> new ArrayList<TrainingJobStageTask>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                    List jobStageTaskIdList = jobStageTaskList.stream().map(TrainingJobStageTask::getId).collect(Collectors.toList());
                    List jobStageIdList = jobStageTaskList.stream().map(TrainingJobStageTask::getStageId).distinct().collect(Collectors.toList());
                    Map<Object, Object> jobStageMap = new HashMap();
                    if (!CollectionUtils.isEmpty(jobStageIdList) && !CollectionUtils.isEmpty((Collection)(jobStageList = this.jobStageMapper.selectBatchIds(jobStageIdList)))) {
                        jobStageMap = jobStageList.stream().collect(Collectors.toMap(TrainingJobStage::getId, Function.identity()));
                    }
                    LambdaQueryWrapper wrappers1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrappers1.in(TrainingJobUserTask::getStageTaskId, jobStageTaskIdList)).in(TrainingJobUserTask::getTaskStatus, Arrays.asList("0", "1", "2", "4"));
                    List jobUserTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrappers1);
                    Map<Object, Object> jobUserTaskMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)jobUserTaskList)) {
                        jobUserTaskMap = jobUserTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getStageTaskId, e -> new ArrayList<TrainingJobUserTask>(Arrays.asList(e)), (oldList, newList) -> {
                            oldList.addAll(newList);
                            return oldList;
                        }));
                    }
                    for (final TrainingJobCertification jobCertification : jobCertificationList) {
                        List<Integer> jobUserList = this.jobCertificationService.selectJobUserListByJobId(jobCertification.getId());
                        final int joinNumber = jobCertification.getJoinNumber();
                        List jobStageTasks = jobStageTaskMap.get(jobCertification.getId());
                        if (CollectionUtils.isEmpty((Collection)jobStageTasks)) continue;
                        for (final TrainingJobStageTask jobStageTask : jobStageTasks) {
                            ArrayList<Integer> waitList = new ArrayList<Integer>(jobUserList);
                            List jobUserTasks = (List)jobUserTaskMap.get(jobStageTask.getId());
                            List jobUser1 = null;
                            if (!CollectionUtils.isEmpty((Collection)jobUserTasks)) {
                                jobUser1 = jobUserTasks.stream().map(TrainingJobUserTask::getUserId).distinct().collect(Collectors.toList());
                            }
                            if (CollectionUtils.isEmpty(waitList)) continue;
                            if (!CollectionUtils.isEmpty(jobUser1)) {
                                waitList.removeAll(jobUser1);
                            }
                            TrainingJobStage jobStage = (TrainingJobStage)jobStageMap.get(jobStageTask.getStageId());
                            List<TrainingJobStageTaskVo> jobLessList = this.jobShiftTaskMapper.selectJobLessSort(jobCertification.getId(), jobStage.getStageSort(), jobStageTask.getTaskSort());
                            if (!CollectionUtils.isEmpty(jobLessList) && !CollectionUtils.isEmpty(waitList)) {
                                List jobTaskIdList = jobLessList.stream().map(TrainingJobStageTask::getId).collect(Collectors.toList());
                                ArrayList<Integer> waitsList = new ArrayList<Integer>(waitList);
                                for (int i = 0; i < waitsList.size(); ++i) {
                                    LambdaQueryWrapper jobUserTaskWrapper = new LambdaQueryWrapper();
                                    ((LambdaQueryWrapper)((LambdaQueryWrapper)jobUserTaskWrapper.eq(TrainingJobUserTask::getTaskStatus, (Object)4)).eq(TrainingJobUserTask::getUserId, waitsList.get(i))).in(TrainingJobUserTask::getStageTaskId, jobTaskIdList);
                                    List list = this.jobUserTaskMapper.selectList((Wrapper)jobUserTaskWrapper);
                                    if (!CollectionUtils.isEmpty((Collection)list)) {
                                        if (list.size() >= jobTaskIdList.size()) continue;
                                        waitList.remove(waitsList.get(i));
                                        continue;
                                    }
                                    waitList.remove(waitsList.get(i));
                                }
                            }
                            if (CollectionUtils.isEmpty(waitList) || waitList.size() < joinNumber || org.springframework.util.StringUtils.isEmpty((Object)jobStageTask.getCreater())) continue;
                            final TrainingJobStageTaskVo jobStageTaskVo = new TrainingJobStageTaskVo();
                            BeanUtils.copyProperties((Object)jobStageTask, (Object)jobStageTaskVo);
                            jobStageTaskVo.setTitle("\u7ec4\u7ec7\u7ebf\u4e0b\u73ed\u63d0\u9192");
                            jobStageTaskVo.setPostId(jobCertification.getPostId());
                            jobStageTaskVo.setName(jobCertification.getCertificationName());
                            CommonUtil.handleTask(new Runnable(){

                                @Override
                                public void run() {
                                    TaskMessageBody body = new TaskMessageBody();
                                    body.setType(84);
                                    body.setTaskJson(JSONObject.toJSONString((Object)jobStageTaskVo));
                                    String text = "\u60a8\u8d1f\u8d23\u7684\u300a" + jobCertification.getCertificationName() + "\u300b\u8ba4\u8bc1\u4e2d\uff0c\u5df2\u6709" + joinNumber + "\u4eba\u5f85\u7ec4\u7ec7\u53c2\u52a0\u300a" + jobStageTask.getTaskName() + "\u300b\uff0c\u8bf7\u4e8eweb\u7aef\u53ca\u65f6\u5b89\u6392\u7ebf\u4e0b\u73ed~";
                                    try {
                                        ScheduleServiceImpl.this.jPushService.sendWebSocket("\u7ec4\u7ec7\u7ebf\u4e0b\u73ed\u63d0\u9192", text, jobStageTask.getCreater(), jobCertification.getEnterpriseId(), jobStageTaskVo.getId(), "TYPE_OFFLINETASK_SYSTEM", JSONObject.toJSONString((Object)jobStageTaskVo), null, 1, 1, "training.job.shift.push.data", jobCertification.getCertificationName() + "," + joinNumber + "," + jobStageTask.getTaskName());
                                        ScheduleServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OFFLINETASK_SYSTEM", jobStageTask.getCreater(), "\u7ec4\u7ec7\u7ebf\u4e0b\u73ed\u63d0\u9192", text, body);
                                        log.info("--\u63a8\u9001\u4eba--" + jobStageTask.getCreater());
                                    }
                                    catch (Exception e) {
                                        log.error("\u5c97\u4f4d\u8ba4\u8bc1\u4e2d\u5f85\u7ec4\u7ec7\u4eba\u6570\u5b9a\u65f6\u63a8\u9001:", (Object)e.getMessage());
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error("PushManagerByOrganize: " + com.ovopark.training.util.DateUtils.format(new Date()), (Throwable)e2);
        }
        log.info("PushManagerByOrganize end");
    }

    @Override
    public void trainingCourseStatusStart() {
        List courseList = new ArrayList();
        try {
            TrainingCourse course = new TrainingCourse();
            course.setStatus(Integer.valueOf(2));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingCourse::getStatus, (Object)1)).isNotNull(TrainingCourse::getStartTime)).le(TrainingCourse::getStartTime, (Object)new Date());
            courseList = this.courseMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty(courseList)) {
                List courseIdList = courseList.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.in(TrainingCourse::getId, courseIdList);
                this.courseMapper.update(course, (Wrapper)wrapper1);
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingCourse::getStatus, (Object)2)).isNotNull(TrainingCourse::getEndTime)).le(TrainingCourse::getEndTime, (Object)new Date());
            List courses = this.courseMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)courses)) {
                List courseIdList = courses.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
                course.setStatus(Integer.valueOf(3));
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingCourse::getId, courseIdList);
                this.courseMapper.update(course, (Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty(courseIdList)) {
                    for (TrainingCourse trainingCourse : courses) {
                        this.courseService.updateRoleUsersByClose(trainingCourse.getId(), null, trainingCourse.getEnterpriseId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("trainingCourseStatusStart", (Throwable)e);
        }
        try {
            if (!CollectionUtils.isEmpty(courseList)) {
                List courseIds = courseList.stream().map(TrainingCourse::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseType, (Object)1)).in(TrainingCourseUser::getCourseId, courseIds);
                List courseUserList = this.courseUserMapper.selectList((Wrapper)wrapper1);
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                    map = courseUserList.stream().collect(Collectors.groupingBy(TrainingCourseUser::getCourseId));
                }
                for (final TrainingCourse course : courseList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)course.getIsPush()) || course.getIsPush() != 1) continue;
                    List<Object> userIds = new ArrayList();
                    if (!org.springframework.util.StringUtils.isEmpty(map) && course.getAppointType() == 1) {
                        List courseUsers = (List)map.get(course.getId());
                        if (!CollectionUtils.isEmpty((Collection)courseUsers)) {
                            String roleIdStr;
                            com.ovopark.privilege.response.BaseResult baseResult;
                            List userIds1 = courseUsers.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            List roleIds = courseUsers.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            List tagIds = courseUsers.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            List orgIds = courseUsers.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(userIds1)) {
                                userIds.addAll(userIds1);
                            }
                            if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), course.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                                List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                                userIds.addAll(pojo);
                            }
                            if (!CollectionUtils.isEmpty(tagIds)) {
                                DepAndTagsPojo pojo = new DepAndTagsPojo();
                                pojo.setGroupId(course.getEnterpriseId());
                                pojo.setTagIds(tagIds);
                                pojo.setUserId(course.getCreater());
                                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                                    for (Map tagMap : (List)tagResult.getData()) {
                                        Integer id = (Integer)tagMap.get("id");
                                        userIds.add(id);
                                    }
                                }
                            }
                            if (!CollectionUtils.isEmpty(orgIds)) {
                                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                                mo.setGroupId(course.getEnterpriseId());
                                mo.setOrganizeIds(orgIds);
                                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                                    userIds.addAll(users);
                                }
                            }
                        }
                    } else {
                        BaseResult base = this.userApi.getSimpleUserByKeyWord(course.getEnterpriseId(), null, null);
                        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                            userIds = ((List)base.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                        }
                    }
                    if (CollectionUtils.isEmpty(userIds)) continue;
                    final ArrayList finalUserIds = userIds;
                    final SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            TrainingCourseMobile push = new TrainingCourseMobile();
                            BeanUtils.copyProperties((Object)course, (Object)push);
                            try {
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(98);
                                body.setTaskJson(JSONObject.toJSONString((Object)push));
                                ScheduleServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SYSTEM", finalUserIds, course.getCourseName(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u57f9\u8bad\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f\uff1a" + format1.format(course.getStartTime()) + " \u81f3 " + format1.format(course.getEndTime()), body);
                            }
                            catch (Exception e) {
                                log.error("\u63a8\u9001\u57f9\u8bad\u8ba1\u5212", (Throwable)e);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            log.error("pushCourseTask", (Throwable)e);
        }
    }

    @Override
    public void sendTrainingNotify() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, -5);
        String zName = " \u81f3 ";
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingPaper::getIsTraining, (Object)0);
        wrapper.between(TrainingPaper::getStartTime, (Object)newDate, (Object)now);
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(1);
        stateList.add(2);
        wrapper.in(TrainingPaper::getPaperState, stateList);
        wrapper.isNull(TrainingPaper::getProjectShow);
        List list = this.paperMapper.selectList((Wrapper)wrapper);
        for (TrainingPaper trainingPaper : list) {
            if (!trainingPaper.getIsRemindExaming().equals(1)) continue;
            List<Object> allUsers = new ArrayList();
            if (trainingPaper.getLookLevel() == null) {
                BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingPaper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List list2 = (List)baseResult.getData();
                    allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                }
            } else {
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaper.getId());
                List list3 = this.trainingPaperUserMapper.selectList((Wrapper)userWrapper);
                List userIds1 = list3.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List roleIds = list3.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List tagIds = list3.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List orgIds = list3.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds1)) {
                    allUsers.addAll(userIds1);
                }
                if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingPaper.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(trainingPaper.getEnterpriseId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(trainingPaper.getUpdater());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add(id);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingPaper.getEnterpriseId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
            }
            for (Integer n : allUsers) {
                TitleVo paperVo = new TitleVo();
                paperVo.setTitle(trainingPaper.getTitle());
                paperVo.setExamId(trainingPaper.getExamId());
                paperVo.setId(trainingPaper.getId());
                paperVo.setPaperId(trainingPaper.getId());
                paperVo.setEnterpriseId(trainingPaper.getEnterpriseId());
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    if (trainingPaper.getEndTime() != null) {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), "\u8003\u8bd5\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f" + format.format(trainingPaper.getStartTime()) + zName + format.format(trainingPaper.getEndTime()), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.exam.started", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), "\u8003\u8bd5\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f" + format.format(trainingPaper.getStartTime()) + zName + format.format(trainingPaper.getEndTime()), body);
                    } else {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), "\u8003\u8bd5\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f" + format.format(trainingPaper.getStartTime()) + zName + " \u4e0d\u9650\u65f6", n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.exam.started", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), "\u8003\u8bd5\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f" + format.format(trainingPaper.getStartTime()) + zName + " \u4e0d\u9650\u65f6", body);
                    }
                    log.info("sendTrainingNotify:paperId=" + paperVo.getId() + ",userId=" + n);
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendTrainingRemindExampre() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, 5);
        String one = "\u8003\u8bd5{0}\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u53ca\u65f6\u53c2\u52a0~{1}\u6709\u6548\u671f\uff1a{2} \u81f3 {3}";
        String two = "\u8003\u8bd5{0}\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u53ca\u65f6\u53c2\u52a0~{1}\u6709\u6548\u671f\uff1a{2} \u81f3 \u4e0d\u9650\u65f6";
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingPaper::getIsTraining, (Object)0);
        wrapper.eq(TrainingPaper::getIsRemindExampre, (Object)1);
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(1);
        stateList.add(2);
        wrapper.in(TrainingPaper::getPaperState, stateList);
        wrapper.isNull(TrainingPaper::getProjectShow);
        List list = this.paperMapper.selectList((Wrapper)wrapper);
        for (TrainingPaper trainingPaper : list) {
            if (trainingPaper.getStartTime() == null || trainingPaper.getRemindExampreHour() == null || !now.before(com.ovopark.training.util.DateUtils.addHour(trainingPaper.getStartTime(), -trainingPaper.getRemindExampreHour().intValue())) || !newDate.after(com.ovopark.training.util.DateUtils.addHour(trainingPaper.getStartTime(), -trainingPaper.getRemindExampreHour().intValue()))) continue;
            List<Object> allUsers = new ArrayList();
            if (trainingPaper.getLookLevel() == null) {
                BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingPaper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List list2 = (List)baseResult.getData();
                    allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                }
            } else {
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaper.getId());
                List list3 = this.trainingPaperUserMapper.selectList((Wrapper)userWrapper);
                List userIds1 = list3.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List roleIds = list3.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List tagIds = list3.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List orgIds = list3.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds1)) {
                    allUsers.addAll(userIds1);
                }
                if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingPaper.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(trainingPaper.getEnterpriseId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(trainingPaper.getUpdater());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add(id);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingPaper.getEnterpriseId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
            }
            for (Integer n : allUsers) {
                TitleVo paperVo = new TitleVo();
                paperVo.setTitle(trainingPaper.getTitle());
                paperVo.setExamId(trainingPaper.getExamId());
                paperVo.setId(trainingPaper.getId());
                paperVo.setPaperId(trainingPaper.getId());
                paperVo.setEnterpriseId(trainingPaper.getEnterpriseId());
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    if (trainingPaper.getEndTime() != null) {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), MessageFormat.format(one, trainingPaper.getRemindExampreHour(), "\n", format.format(trainingPaper.getStartTime()), format.format(trainingPaper.getEndTime())), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.schedule.content.one", trainingPaper.getRemindExampreHour() + ",\n" + "," + format.format(trainingPaper.getStartTime()) + "," + format.format(trainingPaper.getEndTime()));
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), MessageFormat.format(one, trainingPaper.getRemindExampreHour(), "\n", format.format(trainingPaper.getStartTime()), format.format(trainingPaper.getEndTime())), body);
                    } else {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), MessageFormat.format(two, trainingPaper.getRemindExampreHour(), "\n", format.format(trainingPaper.getStartTime())), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.schedule.content.two", trainingPaper.getRemindExampreHour() + ",\n" + "," + format.format(trainingPaper.getStartTime()));
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), MessageFormat.format(two, trainingPaper.getRemindExampreHour(), "\n", format.format(trainingPaper.getStartTime())), body);
                    }
                    log.info("sendTrainingRemindExampre:paperId=" + paperVo.getId() + ",userId=" + n);
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendTrainingRemindUnexamDays() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingPaper::getIsTraining, (Object)0);
        wrapper.isNotNull(TrainingPaper::getEndTime);
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(1);
        stateList.add(2);
        wrapper.in(TrainingPaper::getPaperState, stateList);
        wrapper.isNull(TrainingPaper::getProjectShow);
        List list = this.paperMapper.selectList((Wrapper)wrapper);
        String zName = " \u81f3 ";
        for (TrainingPaper trainingPaper : list) {
            if (!trainingPaper.getIsRemindUnexamDays().equals(1)) continue;
            List<Object> allUsers = new ArrayList();
            if (trainingPaper.getLookLevel() == null) {
                BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingPaper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List list2 = (List)baseResult.getData();
                    allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                }
            } else {
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaper.getId());
                List list3 = this.trainingPaperUserMapper.selectList((Wrapper)userWrapper);
                List userIds1 = list3.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List roleIds = list3.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List tagIds = list3.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List orgIds = list3.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds1)) {
                    allUsers.addAll(userIds1);
                }
                if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingPaper.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(trainingPaper.getEnterpriseId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(trainingPaper.getUpdater());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add(id);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingPaper.getEnterpriseId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
            }
            if (CollectionUtils.isEmpty(allUsers)) continue;
            allUsers = allUsers.stream().distinct().collect(Collectors.toList());
            for (Integer n : allUsers) {
                LambdaQueryWrapper upWrapper = new LambdaQueryWrapper();
                upWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)trainingPaper.getId());
                upWrapper.eq(TrainingUserPaper::getUserId, (Object)n);
                List upList = this.trainingUserPaperMapper.selectList((Wrapper)upWrapper);
                if (!CollectionUtils.isEmpty((Collection)upList)) continue;
                TitleVo paperVo = new TitleVo();
                paperVo.setTitle(trainingPaper.getTitle());
                paperVo.setExamId(trainingPaper.getExamId());
                paperVo.setId(trainingPaper.getId());
                paperVo.setPaperId(trainingPaper.getId());
                paperVo.setEnterpriseId(trainingPaper.getEnterpriseId());
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    if (trainingPaper.getEndTime() != null) {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), "\u60a8\u8fd8\u6ca1\u6709\u8003\u8bd5\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingPaper.getStartTime()) + zName + format.format(trainingPaper.getEndTime()), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.exam.content.one", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), "\u60a8\u8fd8\u6ca1\u6709\u8003\u8bd5\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingPaper.getStartTime()) + zName + format.format(trainingPaper.getEndTime()), body);
                    } else {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), "\u60a8\u8fd8\u6ca1\u6709\u8003\u8bd5\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingPaper.getStartTime()) + zName + " \u4e0d\u9650\u65f6", n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, "training.paper.exam.content.one", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), "\u60a8\u8fd8\u6ca1\u6709\u8003\u8bd5\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingPaper.getStartTime()) + zName + " \u4e0d\u9650\u65f6", body);
                    }
                    log.info("sendTrainingRemindUnexamDays:paperId=" + paperVo.getId() + ",userId=" + n);
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendTrainingUnexam() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, 5);
        String three = "\u8003\u8bd5{0}\u5c0f\u65f6\u540e\u622a\u6b62\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\uff01{1}\u6709\u6548\u671f\uff1a{2} \u81f3 {3}";
        String four = "\u8003\u8bd5{0}\u5c0f\u65f6\u540e\u622a\u6b62\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\uff01{1}\u6709\u6548\u671f\uff1a{2} \u81f3 \u4e0d\u9650\u65f6";
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingPaper::getIsTraining, (Object)0);
        wrapper.eq(TrainingPaper::getIsRemindExampre, (Object)1);
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(1);
        stateList.add(2);
        wrapper.in(TrainingPaper::getPaperState, stateList);
        wrapper.isNull(TrainingPaper::getProjectShow);
        List list = this.paperMapper.selectList((Wrapper)wrapper);
        for (TrainingPaper trainingPaper : list) {
            if (trainingPaper.getEndTime() == null || trainingPaper.getRemindUnexamHour() == null || !now.before(com.ovopark.training.util.DateUtils.addHour(trainingPaper.getEndTime(), -trainingPaper.getRemindUnexamHour().intValue())) || !newDate.after(com.ovopark.training.util.DateUtils.addHour(trainingPaper.getEndTime(), -trainingPaper.getRemindUnexamHour().intValue()))) continue;
            List<Object> allUsers = new ArrayList();
            if (trainingPaper.getLookLevel() == null) {
                BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingPaper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List list2 = (List)baseResult.getData();
                    allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                }
            } else {
                String roleIdStr;
                com.ovopark.privilege.response.BaseResult baseResult;
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingPaperUser::getPaperId, (Object)trainingPaper.getId());
                List list3 = this.trainingPaperUserMapper.selectList((Wrapper)userWrapper);
                List userIds1 = list3.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List roleIds = list3.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List tagIds = list3.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List orgIds = list3.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userIds1)) {
                    allUsers.addAll(userIds1);
                }
                if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingPaper.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(trainingPaper.getEnterpriseId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(trainingPaper.getUpdater());
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add(id);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(trainingPaper.getEnterpriseId());
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
            }
            for (Integer n : allUsers) {
                LambdaQueryWrapper upWrapper = new LambdaQueryWrapper();
                upWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)trainingPaper.getId());
                upWrapper.eq(TrainingUserPaper::getUserId, (Object)n);
                List upList = this.trainingUserPaperMapper.selectList((Wrapper)upWrapper);
                if (!CollectionUtils.isEmpty((Collection)upList)) continue;
                TitleVo paperVo = new TitleVo();
                paperVo.setTitle(trainingPaper.getTitle());
                paperVo.setExamId(trainingPaper.getExamId());
                paperVo.setId(trainingPaper.getId());
                paperVo.setPaperId(trainingPaper.getId());
                paperVo.setEnterpriseId(trainingPaper.getEnterpriseId());
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    if (trainingPaper.getEndTime() != null) {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), MessageFormat.format(three, trainingPaper.getRemindUnexamHour(), "\n", format.format(trainingPaper.getStartTime()), format.format(trainingPaper.getEndTime())), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, null, null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), MessageFormat.format(three, trainingPaper.getRemindUnexamHour(), "\n", format.format(trainingPaper.getStartTime()), format.format(trainingPaper.getEndTime())), body);
                    } else {
                        this.jPushService.sendWebSocket(trainingPaper.getTitle(), MessageFormat.format(four, trainingPaper.getRemindUnexamHour(), "\n", format.format(trainingPaper.getStartTime())), n, trainingPaper.getEnterpriseId(), trainingPaper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paperVo), trainingPaper.getEndTime(), 1, 0, null, null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", n, trainingPaper.getTitle(), MessageFormat.format(four, trainingPaper.getRemindUnexamHour(), "\n", format.format(trainingPaper.getStartTime())), body);
                    }
                    log.info("sendTrainingUnexam:paperId=" + paperVo.getId() + ",userId=" + n);
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void updateUserView() {
        Date startTime = com.ovopark.training.util.DateUtils.getStartTimeOfDay(com.ovopark.training.util.DateUtils.addDay(new Date(), -1));
        Date endTime = com.ovopark.training.util.DateUtils.getEndTimeOfDay(com.ovopark.training.util.DateUtils.addDay(new Date(), -1));
        this.trainingPaperRemoteService.updateUserView(startTime, endTime);
    }

    @Override
    public void workNotify() {
        try {
            this.trainingWorkReviewerService.workNotify();
        }
        catch (Exception e) {
            log.error("workNotify", (Throwable)e);
        }
    }

    @Override
    public void updateWorkStatus() {
        Date now = new Date();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWork::getStatus, (Object)1)).isNotNull(TrainingWork::getStartTime)).le(TrainingWork::getStartTime, (Object)now)).ge(TrainingWork::getEndTime, (Object)now);
        List trainingWorks = this.trainingWorkMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingWorks)) {
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingWork::getStatus, (Object)1)).isNotNull(TrainingWork::getStartTime)).le(TrainingWork::getStartTime, (Object)now)).ge(TrainingWork::getEndTime, (Object)now);
            wrapper2.set(TrainingWork::getStatus, (Object)2);
            this.trainingWorkMapper.update(null, (Wrapper)wrapper2);
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper3.isNotNull(TrainingWork::getEndTime)).le(TrainingWork::getEndTime, (Object)now);
        List trainingWorkList = this.trainingWorkMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)trainingWorkList)) {
            LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper4.isNotNull(TrainingWork::getEndTime)).lt(TrainingWork::getEndTime, (Object)now);
            wrapper4.set(TrainingWork::getStatus, (Object)3);
            this.trainingWorkMapper.update(null, (Wrapper)wrapper4);
        }
    }

    @Override
    public void sendTrainingRemindCoursepre() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, 5);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getIsRemindCoursepre, (Object)1);
        wrapper.eq(TrainingCourse::getStatus, (Object)2);
        List list = this.trainingCourseMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingCourse trainingCourse : list) {
                List<Object> allUsers = new ArrayList();
                if (trainingCourse.getStartTime() == null || trainingCourse.getRemindCoursepreHour() == null || !now.before(com.ovopark.training.util.DateUtils.addHour(trainingCourse.getStartTime(), -trainingCourse.getRemindCoursepreHour().intValue())) || !newDate.after(com.ovopark.training.util.DateUtils.addHour(trainingCourse.getStartTime(), -trainingCourse.getRemindCoursepreHour().intValue()))) continue;
                if (trainingCourse.getAppointType().equals(0)) {
                    BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingCourse.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List list2 = (List)baseResult.getData();
                        allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else if (trainingCourse.getAppointType().equals(1)) {
                    String roleIdStr;
                    com.ovopark.privilege.response.BaseResult baseResult;
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourse.getId());
                    userWrapper.eq(TrainingCourseUser::getCourseType, (Object)1);
                    List list3 = this.trainingCourseUserMapper.selectList((Wrapper)userWrapper);
                    List userIds1 = list3.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List roleIds = list3.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List tagIds = list3.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List orgIds = list3.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds1)) {
                        allUsers.addAll(userIds1);
                    }
                    if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingCourse.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        allUsers.addAll(pojo);
                    }
                    if (!CollectionUtils.isEmpty(tagIds)) {
                        DepAndTagsPojo pojo = new DepAndTagsPojo();
                        pojo.setGroupId(trainingCourse.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(trainingCourse.getCreater());
                        BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allUsers.add(id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingCourse.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allUsers.addAll(users);
                        }
                    }
                }
                for (Integer n : allUsers) {
                    TitleVo paperVo = new TitleVo();
                    paperVo.setTitle(trainingCourse.getCourseName());
                    paperVo.setId(trainingCourse.getId());
                    paperVo.setEnterpriseId(trainingCourse.getEnterpriseId());
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(145);
                    body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        this.jPushService.sendWebSocket(trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1" + trainingCourse.getRemindCoursepreHour() + "\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u53ca\u65f6\u53c2\u52a0~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), n, trainingCourse.getEnterpriseId(), trainingCourse.getId(), "TYPE_COURSE_SCH_OBJ_TYPE", JSONObject.toJSONString((Object)paperVo), trainingCourse.getEndTime(), 1, 0, null, null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SCH_OBJ_TYPE", n, trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1" + trainingCourse.getRemindCoursepreHour() + "\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u53ca\u65f6\u53c2\u52a0~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), body);
                        log.info("sendTrainingRemindCoursepre=" + paperVo.getId() + ",userId=" + n);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u4efb\u52a1\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void sendTrainingRemindCourseing() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, -5);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getIsRemindCourseing, (Object)1);
        wrapper.eq(TrainingCourse::getStatus, (Object)2);
        wrapper.between(TrainingCourse::getStartTime, (Object)newDate, (Object)now);
        List list = this.trainingCourseMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingCourse trainingCourse : list) {
                List<Object> allUsers = new ArrayList();
                if (trainingCourse.getAppointType().equals(0)) {
                    BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingCourse.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List list2 = (List)baseResult.getData();
                        allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else if (trainingCourse.getAppointType().equals(1)) {
                    String roleIdStr;
                    com.ovopark.privilege.response.BaseResult baseResult;
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourse.getId());
                    userWrapper.eq(TrainingCourseUser::getCourseType, (Object)1);
                    List list3 = this.trainingCourseUserMapper.selectList((Wrapper)userWrapper);
                    List userIds1 = list3.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List roleIds = list3.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List tagIds = list3.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List orgIds = list3.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds1)) {
                        allUsers.addAll(userIds1);
                    }
                    if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingCourse.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        allUsers.addAll(pojo);
                    }
                    if (!CollectionUtils.isEmpty(tagIds)) {
                        DepAndTagsPojo pojo = new DepAndTagsPojo();
                        pojo.setGroupId(trainingCourse.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(trainingCourse.getCreater());
                        BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allUsers.add(id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingCourse.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allUsers.addAll(users);
                        }
                    }
                }
                for (Integer n : allUsers) {
                    TitleVo paperVo = new TitleVo();
                    paperVo.setTitle(trainingCourse.getCourseName());
                    paperVo.setId(trainingCourse.getId());
                    paperVo.setEnterpriseId(trainingCourse.getEnterpriseId());
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(145);
                    body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        this.jPushService.sendWebSocket(trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), n, trainingCourse.getEnterpriseId(), trainingCourse.getId(), "TYPE_COURSE_SCH_OBJ_TYPE", JSONObject.toJSONString((Object)paperVo), trainingCourse.getEndTime(), 1, 0, "training.course.task.started", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SCH_OBJ_TYPE", n, trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1\u5df2\u5f00\u59cb\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), body);
                        log.info("sendTrainingRemindCourseing=" + paperVo.getId() + ",userId=" + n);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u4efb\u52a1\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void sendTrainingRemindUnfinishDays() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getIsRemindUnfinishDays, (Object)1);
        wrapper.eq(TrainingCourse::getStatus, (Object)2);
        List list = this.trainingCourseMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingCourse trainingCourse : list) {
                List<Object> allUsers = new ArrayList();
                ArrayList<Integer> inUsers = new ArrayList<Integer>();
                if (trainingCourse.getAppointType().equals(0)) {
                    BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingCourse.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List usersPojoList = (List)baseResult.getData();
                        allUsers = usersPojoList.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else if (trainingCourse.getAppointType().equals(1)) {
                    String roleIdStr;
                    com.ovopark.privilege.response.BaseResult baseResult;
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourse.getId());
                    userWrapper.eq(TrainingCourseUser::getCourseType, (Object)1);
                    List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)userWrapper);
                    List list2 = courseUserList.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List orgIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(list2)) {
                        allUsers.addAll(list2);
                    }
                    if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingCourse.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        allUsers.addAll(pojo);
                    }
                    if (!CollectionUtils.isEmpty(tagIds)) {
                        DepAndTagsPojo pojo = new DepAndTagsPojo();
                        pojo.setGroupId(trainingCourse.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(trainingCourse.getCreater());
                        BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allUsers.add(id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingCourse.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allUsers.addAll(users);
                        }
                    }
                }
                List<Integer> userIdList = this.trainingCourseUserTaskMapper.selectUserIdByCourseIdAndStatus(trainingCourse.getId());
                if (!CollectionUtils.isEmpty(userIdList)) {
                    inUsers.addAll(userIdList);
                }
                allUsers.removeAll(inUsers);
                for (Integer n : allUsers) {
                    TitleVo paperVo = new TitleVo();
                    paperVo.setTitle(trainingCourse.getCourseName());
                    paperVo.setId(trainingCourse.getId());
                    paperVo.setEnterpriseId(trainingCourse.getEnterpriseId());
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(145);
                    body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        this.jPushService.sendWebSocket(trainingCourse.getCourseName(), "\u60a8\u8fd8\u6ca1\u6709\u5b8c\u6210\u5b66\u4e60\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), n, trainingCourse.getEnterpriseId(), trainingCourse.getId(), "TYPE_COURSE_SCH_OBJ_TYPE", JSONObject.toJSONString((Object)paperVo), trainingCourse.getEndTime(), 1, 0, "training.course.unfinish.detail", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SCH_OBJ_TYPE", n, trainingCourse.getCourseName(), "\u60a8\u8fd8\u6ca1\u6709\u5b8c\u6210\u5b66\u4e60\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u54e6~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), body);
                        log.info("sendTrainingRemindUnfinishDays=" + paperVo.getId() + ",userId=" + n);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u4efb\u52a1\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void sendTrainingRemindUnfinish() {
        Date now = new Date();
        Date newDate = com.ovopark.training.util.DateUtils.addMinute(now, 5);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getIsRemindUnfinish, (Object)1);
        wrapper.eq(TrainingCourse::getStatus, (Object)2);
        List list = this.trainingCourseMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingCourse trainingCourse : list) {
                List<Object> allUsers = new ArrayList();
                if (trainingCourse.getEndTime() == null || trainingCourse.getRemindUnfinishHour() == null || !now.before(com.ovopark.training.util.DateUtils.addHour(trainingCourse.getEndTime(), -trainingCourse.getRemindUnfinishHour().intValue())) || !newDate.after(com.ovopark.training.util.DateUtils.addHour(trainingCourse.getEndTime(), -trainingCourse.getRemindUnfinishHour().intValue()))) continue;
                if (trainingCourse.getAppointType().equals(0)) {
                    BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, trainingCourse.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List list2 = (List)baseResult.getData();
                        allUsers = list2.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else if (trainingCourse.getAppointType().equals(1)) {
                    String roleIdStr;
                    com.ovopark.privilege.response.BaseResult baseResult;
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourse.getId());
                    userWrapper.eq(TrainingCourseUser::getCourseType, (Object)1);
                    List list3 = this.trainingCourseUserMapper.selectList((Wrapper)userWrapper);
                    List userIds1 = list3.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List roleIds = list3.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List tagIds = list3.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List orgIds = list3.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds1)) {
                        allUsers.addAll(userIds1);
                    }
                    if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), trainingCourse.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                        allUsers.addAll(pojo);
                    }
                    if (!CollectionUtils.isEmpty(tagIds)) {
                        DepAndTagsPojo pojo = new DepAndTagsPojo();
                        pojo.setGroupId(trainingCourse.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setUserId(trainingCourse.getCreater());
                        BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allUsers.add(id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(trainingCourse.getEnterpriseId());
                        mo.setOrganizeIds(orgIds);
                        BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allUsers.addAll(users);
                        }
                    }
                }
                for (Integer n : allUsers) {
                    TitleVo paperVo = new TitleVo();
                    paperVo.setTitle(trainingCourse.getCourseName());
                    paperVo.setId(trainingCourse.getId());
                    paperVo.setEnterpriseId(trainingCourse.getEnterpriseId());
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(145);
                    body.setTaskJson(JSONObject.toJSONString((Object)paperVo));
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        this.jPushService.sendWebSocket(trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1" + trainingCourse.getRemindCoursepreHour() + "\u5c0f\u65f6\u540e\u622a\u6b62\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), n, trainingCourse.getEnterpriseId(), trainingCourse.getId(), "TYPE_COURSE_SCH_OBJ_TYPE", JSONObject.toJSONString((Object)paperVo), trainingCourse.getEndTime(), 1, 0, null, null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SCH_OBJ_TYPE", n, trainingCourse.getCourseName(), "\u57f9\u8bad\u4efb\u52a1" + trainingCourse.getRemindCoursepreHour() + "\u5c0f\u65f6\u540e\u622a\u6b62\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210~\n\u6709\u6548\u671f\uff1a" + format.format(trainingCourse.getStartTime()) + " \u81f3 " + format.format(trainingCourse.getEndTime()), body);
                        log.info("sendTrainingRemindCoursepre=" + paperVo.getId() + ",userId=" + n);
                    }
                    catch (Exception e) {
                        log.error("\u57f9\u8bad\u4efb\u52a1\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void sendTrainingLearnProjectShiftReviewer() {
        List<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = this.trainingLearnShiftRecordMapper.selectTrainingLearnProjectShiftReviewer();
        if (!CollectionUtils.isEmpty(trainingLearnShiftRecordVoList)) {
            Map<Integer, List<TrainingLearnShiftRecordVo>> recordMap = trainingLearnShiftRecordVoList.stream().collect(Collectors.groupingBy(TrainingLearnShiftRecord::getReviewer));
            TaskMessageBody body = null;
            String closeDetail = "\u60a8\u5f53\u524d\u6709{0}\u4e2a\u7ed3\u73ed\u7533\u8bf7\u5f85\u5ba1\u6279\uff0c\u8bf7\u81f3web\u7aef<\u57f9\u8bad-\u6279\u9605\u7ba1\u7406-\u7ed3\u73ed\u5ba1\u6279>\u4e2d\u53ca\u65f6\u5ba1\u6279";
            String title = "\u7ed3\u73ed\u5ba1\u6279\u63d0\u9192";
            for (Integer reviewer : recordMap.keySet()) {
                List<TrainingLearnShiftRecordVo> recordVoList = recordMap.get(reviewer);
                if (CollectionUtils.isEmpty(recordVoList)) continue;
                TrainingLearnShiftRecordVo recordVo = recordVoList.get(0);
                String text = MessageFormat.format(closeDetail, recordVoList.size());
                body = new TaskMessageBody();
                body.setType(147);
                body.setTaskJson(JSONObject.toJSONString((Object)recordVo));
                recordVo.setTitle(title);
                this.jPushService.sendWebSocket(title, text, recordVo.getReviewer(), recordVo.getEnterpriseId(), recordVo.getId(), "TYPE_SHIFT_REVIEWER", JSONObject.toJSONString((Object)recordVo), null, 0, 0, "training.job.class.close.detail", recordVoList.size() + "");
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_SHIFT_REVIEWER", recordVo.getReviewer(), title, text, body);
            }
        }
    }

    @Override
    public void sendMarkPaperReviewer() {
        List<TrainingUserPaperVo> trainingUserPaperVoList = this.trainingUserPaperMapper.selectMarkPaperByUserId();
        if (!CollectionUtils.isEmpty(trainingUserPaperVoList)) {
            String text = "";
            TaskMessageBody body = null;
            for (TrainingUserPaperVo trainingUserPaperVo : trainingUserPaperVoList) {
                body = new TaskMessageBody();
                body.setType(136);
                trainingUserPaperVo.setTitle("\u9605\u5377\u63d0\u9192");
                body.setTaskJson(JSONObject.toJSONString((Object)trainingUserPaperVo));
                text = MessageFormat.format("\u60a8\u5f53\u524d\u6709{0}\u4e2a\u8003\u5377\u5f85\u6279\u9605\uff0c\u70b9\u51fb\u53bb\u6279\u9605", trainingUserPaperVo.getPaperNum());
                this.jPushService.sendWebSocket("\u9605\u5377\u63d0\u9192", text, trainingUserPaperVo.getUserId(), trainingUserPaperVo.getEnterpriseId(), trainingUserPaperVo.getUserId(), "TYPE_TRAINING_PAPER_REVIEWER", JSONObject.toJSONString((Object)trainingUserPaperVo), null, 0, 0, "training.paper.mark.review", trainingUserPaperVo.getPaperNum().toString());
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PAPER_REVIEWER", trainingUserPaperVo.getUserId(), "\u9605\u5377\u63d0\u9192", text, body);
            }
        }
    }

    @Override
    public void addUserViewTimeDay(Date start, Date end) {
        com.ovopark.pojo.BaseResult result = this.redisBaseApi.get("addUserViewTimeDay");
        if (result != null && !result.getIsError().booleanValue() && DateUtils.format((Date)start, (String)"yyyyMMdd").equals(result.getData())) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ge(TrainingUserViewTimeDay::getCreateTime, (Object)start);
        wrapper.lt(TrainingUserViewTimeDay::getCreateTime, (Object)end);
        this.trainingUserViewTimeDayMapper.delete((Wrapper)wrapper);
        for (int i = 0; i < com.ovopark.training.util.DateUtils.daysBetween(start, end); ++i) {
            Date dayEnd;
            Date dayStart = com.ovopark.training.util.DateUtils.getStartTimeOfDay(com.ovopark.training.util.DateUtils.addDay(start, i));
            List<TrainingUserViewTimeDay> dayList = this.userViewTimeMapper.getDayViewTime(dayStart, dayEnd = com.ovopark.training.util.DateUtils.getEndTimeOfDay(com.ovopark.training.util.DateUtils.addDay(start, i)));
            if (CollectionUtils.isEmpty(dayList)) continue;
            for (TrainingUserViewTimeDay day : dayList) {
                this.trainingUserViewTimeDayMapper.insert(day);
            }
        }
        this.redisBaseApi.setExpire("addUserViewTimeDay", DateUtils.format((Date)start, (String)"yyyyMMdd"), Integer.valueOf(86400));
    }
}

