/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.PrivilegeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingActivityAttachMapper;
import com.ovopark.training.mapper.TrainingActivityIntroMapper;
import com.ovopark.training.mapper.TrainingActivityMapper;
import com.ovopark.training.mapper.TrainingActivityTrainingMapper;
import com.ovopark.training.mapper.TrainingActivityUserMapper;
import com.ovopark.training.mapper.TrainingActivityUserRangeMapper;
import com.ovopark.training.mapper.TrainingActivityUserTrainingMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingActivity;
import com.ovopark.training.model.TrainingActivityAttach;
import com.ovopark.training.model.TrainingActivityIntro;
import com.ovopark.training.model.TrainingActivityTraining;
import com.ovopark.training.model.TrainingActivityUser;
import com.ovopark.training.model.TrainingActivityUserRange;
import com.ovopark.training.model.TrainingActivityUserTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingActivityService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingActivityTrainingVo;
import com.ovopark.training.vo.TrainingActivityUserRangeVo;
import com.ovopark.training.vo.TrainingActivityUserVo;
import com.ovopark.training.vo.TrainingActivityVo;
import com.ovopark.training.vo.TrainingVo;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingActivityServiceImpl
implements TrainingActivityService {
    private static final Logger log = LoggerFactory.getLogger(TrainingActivityServiceImpl.class);
    @Autowired
    private TrainingActivityMapper trainingActivityMapper;
    @Autowired
    private TrainingActivityAttachMapper trainingActivityAttachMapper;
    @Autowired
    private TrainingActivityUserMapper trainingActivityUserMapper;
    @Autowired
    private TrainingActivityUserRangeMapper trainingActivityUserRangeMapper;
    @Autowired
    private TrainingActivityTrainingMapper trainingActivityTrainingMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingActivityUserTrainingMapper trainingActivityUserTrainingMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private TrainingActivityIntroMapper trainingActivityIntroMapper;
    @Autowired
    private com.ovopark.privilege.api.UserApi priUserApi;
    @Autowired
    private PrivilegeApi privilegeApi;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private LogApi logApi;
    @Autowired
    private MessageSource messageSource;

    @Override
    public String addOrUpdateActivity(final TrainingActivityVo vo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivity::getEnterpriseId, (Object)vo.getEnterpriseId());
        wrapper.eq(TrainingActivity::getActivityName, (Object)vo.getActivityName());
        List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
        if (vo.getId() == null) {
            if (!CollectionUtils.isEmpty((Collection)list) && ((TrainingActivity)list.get(0)).getActivityName().equals(vo.getActivityName())) {
                return JsonResult.error((String)"DUPLICATE", (Object)"\u540d\u79f0\u91cd\u590d");
            }
            final TrainingActivity activity = new TrainingActivity();
            BeanUtils.copyProperties((Object)vo, (Object)activity);
            this.trainingActivityMapper.insert(activity);
            if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getActivityIntro())) {
                TrainingActivityIntro intro = new TrainingActivityIntro();
                intro.setActivityId(activity.getId());
                intro.setActivityIntro(vo.getActivityIntro());
                this.trainingActivityIntroMapper.insert(intro);
            }
            if (!CollectionUtils.isEmpty((Collection)vo.getAttachList())) {
                for (int i = 0; i < vo.getAttachList().size(); ++i) {
                    TrainingActivityAttach attach = (TrainingActivityAttach)vo.getAttachList().get(i);
                    attach.setCreateTime(new Date());
                    attach.setEnterpriseId(activity.getEnterpriseId());
                    attach.setActivityId(activity.getId());
                    this.trainingActivityAttachMapper.insert(attach);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
                for (int i = 0; i < vo.getUserList().size(); ++i) {
                    TrainingActivityUserRangeVo userVo = (TrainingActivityUserRangeVo)vo.getUserList().get(i);
                    TrainingActivityUserRange user = new TrainingActivityUserRange();
                    BeanUtils.copyProperties((Object)userVo, (Object)user);
                    user.setEnterpriseId(activity.getEnterpriseId());
                    user.setActivityId(activity.getId());
                    this.trainingActivityUserRangeMapper.insert(user);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)vo.getTrainingList())) {
                for (int i = 0; i < vo.getTrainingList().size(); ++i) {
                    TrainingActivityTrainingVo trainingVo = (TrainingActivityTrainingVo)vo.getTrainingList().get(i);
                    TrainingActivityTraining training = new TrainingActivityTraining();
                    BeanUtils.copyProperties((Object)trainingVo, (Object)training);
                    training.setCreateTime(new Date());
                    training.setEnterpriseId(activity.getEnterpriseId());
                    training.setActivityId(activity.getId());
                    this.trainingActivityTrainingMapper.insert(training);
                }
            }
            if (vo.getActivityStatus() != 1) {
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TrainingActivityServiceImpl.this.sendActivityMessage(activity.getId(), null, activity.getCreator(), activity.getActivityName() + "\u6d3b\u52a8\u5df2\u53d1\u5e03\uff0c\u70b9\u51fb\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5\uff01", 132, "TYPE_ACTIVITY_ADD");
                        }
                        catch (Exception e) {
                            log.error("\u65b0\u589e\u6d3b\u52a8", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            if (!CollectionUtils.isEmpty((Collection)list) && ((TrainingActivity)list.get(0)).getActivityName().equals(vo.getActivityName()) && ((TrainingActivity)list.get(0)).getId().intValue() != vo.getId().intValue()) {
                return JsonResult.error((String)"DUPLICATE", (Object)"\u540d\u79f0\u91cd\u590d");
            }
            final TrainingActivity oldActivity = (TrainingActivity)this.trainingActivityMapper.selectById(vo.getId());
            if (oldActivity.getActivityStatus().equals(1) && !vo.getActivityStatus().equals(1)) {
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TrainingActivityServiceImpl.this.sendActivityMessage(oldActivity.getId(), null, oldActivity.getCreator(), vo.getActivityName() + "\u6d3b\u52a8\u5df2\u53d1\u5e03\uff0c\u70b9\u51fb\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5\uff01", 132, "TYPE_ACTIVITY_ADD");
                        }
                        catch (Exception e) {
                            log.error("\u65b0\u589e\u6d3b\u52a8", (Throwable)e);
                        }
                    }
                });
            }
            TrainingActivity activity = new TrainingActivity();
            BeanUtils.copyProperties((Object)vo, (Object)activity);
            activity.setId(oldActivity.getId());
            activity.setCreateTime(oldActivity.getCreateTime());
            this.trainingActivityMapper.updateById(activity);
            LambdaQueryWrapper introWrapper = new LambdaQueryWrapper();
            introWrapper.eq(TrainingActivityIntro::getActivityId, (Object)activity.getId());
            this.trainingActivityIntroMapper.delete((Wrapper)introWrapper);
            if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getActivityIntro())) {
                TrainingActivityIntro intro = new TrainingActivityIntro();
                intro.setActivityId(activity.getId());
                intro.setActivityIntro(vo.getActivityIntro());
                this.trainingActivityIntroMapper.insert(intro);
            }
            LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
            attachWrapper.eq(TrainingActivityAttach::getActivityId, (Object)activity.getId());
            this.trainingActivityAttachMapper.delete((Wrapper)attachWrapper);
            if (!CollectionUtils.isEmpty((Collection)vo.getAttachList())) {
                for (int i = 0; i < vo.getAttachList().size(); ++i) {
                    TrainingActivityAttach attach = (TrainingActivityAttach)vo.getAttachList().get(i);
                    attach.setCreateTime(new Date());
                    attach.setEnterpriseId(activity.getEnterpriseId());
                    attach.setActivityId(activity.getId());
                    this.trainingActivityAttachMapper.insert(attach);
                }
            }
            LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
            userWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)activity.getId());
            this.trainingActivityUserRangeMapper.delete((Wrapper)userWrapper);
            if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
                for (int i = 0; i < vo.getUserList().size(); ++i) {
                    TrainingActivityUserRangeVo userVo = (TrainingActivityUserRangeVo)vo.getUserList().get(i);
                    TrainingActivityUserRange user = new TrainingActivityUserRange();
                    BeanUtils.copyProperties((Object)userVo, (Object)user);
                    user.setEnterpriseId(activity.getEnterpriseId());
                    user.setActivityId(activity.getId());
                    this.trainingActivityUserRangeMapper.insert(user);
                }
            }
            LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
            trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)activity.getId());
            this.trainingActivityTrainingMapper.delete((Wrapper)trainingWrapper);
            if (!CollectionUtils.isEmpty((Collection)vo.getTrainingList())) {
                for (int i = 0; i < vo.getTrainingList().size(); ++i) {
                    TrainingActivityTrainingVo trainingVo = (TrainingActivityTrainingVo)vo.getTrainingList().get(i);
                    TrainingActivityTraining training = new TrainingActivityTraining();
                    BeanUtils.copyProperties((Object)trainingVo, (Object)training);
                    training.setCreateTime(new Date());
                    training.setEnterpriseId(activity.getEnterpriseId());
                    training.setActivityId(activity.getId());
                    this.trainingActivityTrainingMapper.insert(training);
                }
            }
        }
        return JsonResult.success();
    }

    @Override
    public String getActivityById(Integer activityId, Integer userId, Integer enterpriseId) {
        com.ovopark.organize.common.base.BaseResult creatorResult;
        TrainingActivityVo result = new TrainingActivityVo();
        TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
        if (activity == null) {
            result.setIsDel(Integer.valueOf(1));
            return JsonResult.success((Object)result);
        }
        if (enterpriseId.intValue() != activity.getEnterpriseId().intValue()) {
            result.setActivityNoEnterprise(Integer.valueOf(1));
            return JsonResult.success((Object)result);
        }
        BaseResult priResult = this.privilegeApi.hasPrivileges(userId, enterpriseId, "ACTIVITY_CENTER_APP");
        if (!priResult.getIsError().booleanValue() && !((Boolean)priResult.getData()).booleanValue()) {
            result.setActivityNoRole(Integer.valueOf(1));
            return JsonResult.success((Object)result);
        }
        BeanUtils.copyProperties((Object)activity, (Object)result);
        LambdaQueryWrapper introWrapper = new LambdaQueryWrapper();
        introWrapper.eq(TrainingActivityIntro::getActivityId, (Object)activityId);
        TrainingActivityIntro intro = (TrainingActivityIntro)this.trainingActivityIntroMapper.selectOne((Wrapper)introWrapper);
        if (intro != null) {
            result.setActivityIntro(intro.getActivityIntro());
        }
        if (!(creatorResult = this.userApi.getUserById(activity.getCreator())).getIsError().booleanValue() && creatorResult.getData() != null) {
            result.setCreatorShowName(((com.ovopark.organize.common.model.pojo.UsersPojo)creatorResult.getData()).getShowName());
            result.setCreatorThumbUrl(((com.ovopark.organize.common.model.pojo.UsersPojo)creatorResult.getData()).getThumbUrl());
        }
        LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
        attachWrapper.eq(TrainingActivityAttach::getActivityId, (Object)activity.getId());
        List attachList = this.trainingActivityAttachMapper.selectList((Wrapper)attachWrapper);
        result.setAttachList(attachList);
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)activity.getId());
        List userList = this.trainingActivityUserRangeMapper.selectList((Wrapper)userWrapper);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            ArrayList<Object> userVoList = new ArrayList<Object>();
            for (TrainingActivityUserRange trainingActivityUserRange : userList) {
                com.ovopark.organize.common.base.BaseResult tagResult;
                BaseResult roleResult;
                com.ovopark.organize.common.base.BaseResult userResult;
                TrainingActivityUserRangeVo userVo = new TrainingActivityUserRangeVo();
                BeanUtils.copyProperties((Object)trainingActivityUserRange, (Object)userVo);
                if (trainingActivityUserRange.getUserId() != null && !(userResult = this.userApi.getUserById(trainingActivityUserRange.getUserId())).getIsError().booleanValue() && userResult.getData() != null) {
                    userVo.setName(((com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData()).getShowName());
                }
                if (trainingActivityUserRange.getOrganizeId() != null) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(activity.getEnterpriseId());
                    ArrayList<String> orgIds = new ArrayList<String>();
                    orgIds.add(trainingActivityUserRange.getOrganizeId());
                    mo.setOrganizeIds(orgIds);
                    com.ovopark.organize.common.base.BaseResult userResult2 = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult2.getData()))) {
                        userVo.setName(((UserAndParentNameMo)((List)userResult2.getData()).get(0)).getOrganizeName());
                    }
                }
                if (trainingActivityUserRange.getRoleId() != null && !(roleResult = this.roleApi.getRolePojoById(trainingActivityUserRange.getRoleId())).getIsError().booleanValue() && roleResult.getData() != null) {
                    userVo.setName(((RolePojo)roleResult.getData()).getRoleName());
                }
                if (trainingActivityUserRange.getTagId() != null && !(tagResult = this.tagApi.getUsersTagById(trainingActivityUserRange.getTagId())).getIsError().booleanValue() && tagResult.getData() != null) {
                    userVo.setName(((UserTagMo)tagResult.getData()).getTagName());
                }
                userVoList.add(userVo);
            }
            result.setUserList(userVoList);
        }
        LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
        trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)activity.getId());
        List trainingList = this.trainingActivityTrainingMapper.selectList((Wrapper)trainingWrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingList)) {
            ArrayList<TrainingActivityTrainingVo> trainingVoList = new ArrayList<TrainingActivityTrainingVo>();
            for (TrainingActivityTraining trainingActivityTraining : trainingList) {
                TrainingActivityTrainingVo trainingVo = new TrainingActivityTrainingVo();
                BeanUtils.copyProperties((Object)trainingActivityTraining, (Object)trainingVo);
                Training training = (Training)this.trainingMapper.selectById(trainingActivityTraining.getTrainingId());
                if (training != null) {
                    trainingVo.setTrainingName(training.getTitle());
                }
                trainingVoList.add(trainingVo);
            }
            result.setTrainingList(trainingVoList);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            result.setApplyUserNum(list.size());
        }
        if (result.getActivityStatus() != 1) {
            if (result.getActivityStartTime().after(new Date())) {
                result.setActivityStatus(Integer.valueOf(2));
            } else if (result.getActivityEndTime().before(new Date())) {
                result.setActivityStatus(Integer.valueOf(4));
            } else {
                result.setActivityStatus(Integer.valueOf(3));
            }
        }
        if (result.getSignStartTime() != null && result.getSignEndTime() != null) {
            if (result.getSignStartTime().after(new Date())) {
                result.setApplyStatus(Integer.valueOf(0));
            } else if (result.getSignEndTime().before(new Date())) {
                result.setApplyStatus(Integer.valueOf(2));
            }
        }
        if (activity.getActivityRange().equals(1)) {
            String roleIdStr;
            BaseResult baseResult;
            ArrayList<Object> userIdList = new ArrayList<Object>();
            LambdaQueryWrapper rangeWrapper = new LambdaQueryWrapper();
            rangeWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)activityId);
            List rangeList = this.trainingActivityUserRangeMapper.selectList((Wrapper)rangeWrapper);
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            ArrayList<Integer> roleIds = new ArrayList<Integer>();
            ArrayList<String> orgIds = new ArrayList<String>();
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (TrainingActivityUserRange userRange : rangeList) {
                if (userRange.getUserId() != null) {
                    userIds.add(userRange.getUserId());
                    continue;
                }
                if (userRange.getRoleId() != null) {
                    roleIds.add(userRange.getRoleId());
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)userRange.getOrganizeId())) {
                    orgIds.add(userRange.getOrganizeId());
                    continue;
                }
                if (userRange.getTagId() == null) continue;
                tagIds.add(userRange.getTagId());
            }
            if (!CollectionUtils.isEmpty(userIds)) {
                userIdList.addAll(userIds);
            }
            if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), activity.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                List pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                userIdList.addAll(pojo);
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(activity.getEnterpriseId());
                mo.setOrganizeIds(orgIds);
                com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    userIdList.addAll(users);
                }
            }
            if (!CollectionUtils.isEmpty(tagIds)) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(activity.getEnterpriseId());
                pojo.setTagIds(tagIds);
                pojo.setUserId(userId);
                com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        userIdList.add(id);
                    }
                }
            }
            if (!userIdList.contains(userId)) {
                result.setApplyStatus(Integer.valueOf(1));
            }
        }
        LambdaQueryWrapper uWrapper = new LambdaQueryWrapper();
        uWrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        uWrapper.eq(TrainingActivityUser::getUserId, (Object)userId);
        List myUserList = this.trainingActivityUserMapper.selectList((Wrapper)uWrapper);
        if (!CollectionUtils.isEmpty((Collection)myUserList)) {
            result.setApplyStatus(Integer.valueOf(3));
            result.setApplyTime(((TrainingActivityUser)myUserList.get(0)).getCreateTime());
        }
        return JsonResult.success((Object)result);
    }

    @Override
    public String getActivityByPage(Integer enterpriseId, Page<TrainingActivityVo> page, String activityName, Integer activityStatus, String activityStartTime, String activityEndTime) {
        List<TrainingActivityVo> activityList = this.trainingActivityMapper.selectByPage(page, enterpriseId, activityName, activityStatus, activityStartTime, activityEndTime);
        if (!CollectionUtils.isEmpty(activityList)) {
            for (TrainingActivityVo vo : activityList) {
                com.ovopark.organize.common.base.BaseResult userResult;
                LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
                attachWrapper.eq(TrainingActivityAttach::getActivityId, (Object)vo.getId());
                List attachList = this.trainingActivityAttachMapper.selectList((Wrapper)attachWrapper);
                vo.setAttachList(attachList);
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)vo.getId());
                List userList = this.trainingActivityUserRangeMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    ArrayList<TrainingActivityUserRangeVo> userVoList = new ArrayList<TrainingActivityUserRangeVo>();
                    for (TrainingActivityUserRange user : userList) {
                        TrainingActivityUserRangeVo userVo = new TrainingActivityUserRangeVo();
                        BeanUtils.copyProperties((Object)user, (Object)userVo);
                        userVoList.add(userVo);
                    }
                    vo.setUserList(userVoList);
                }
                LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
                trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)vo.getId());
                List trainingList = this.trainingActivityTrainingMapper.selectList((Wrapper)trainingWrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingList)) {
                    ArrayList<TrainingActivityTrainingVo> trainingVoList = new ArrayList<TrainingActivityTrainingVo>();
                    for (TrainingActivityTraining training : trainingList) {
                        TrainingActivityTrainingVo trainingVo = new TrainingActivityTrainingVo();
                        BeanUtils.copyProperties((Object)training, (Object)trainingVo);
                        trainingVoList.add(trainingVo);
                    }
                    vo.setTrainingList(trainingVoList);
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingActivityUser::getActivityId, (Object)vo.getId());
                List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    vo.setApplyUserNum(list.size());
                }
                if (!(userResult = this.userApi.getUserById(vo.getCreator())).getIsError().booleanValue() && userResult.getData() != null) {
                    vo.setCreatorShowName(((com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData()).getShowName());
                    vo.setCreatorThumbUrl(((com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData()).getThumbUrl());
                }
                if (vo.getActivityStatus() != null && vo.getActivityStatus() == 1) {
                    vo.setActivityStatus(vo.getActivityStatus());
                    continue;
                }
                if (vo.getActivityStartTime().after(new Date())) {
                    vo.setActivityStatus(Integer.valueOf(2));
                    continue;
                }
                if (vo.getActivityEndTime().before(new Date())) {
                    vo.setActivityStatus(Integer.valueOf(4));
                    continue;
                }
                vo.setActivityStatus(Integer.valueOf(3));
            }
        }
        page.setContent(activityList);
        return JsonResult.success(page);
    }

    @Override
    public String deleteActivityById(String activityIds, LogPojo pojo) {
        String[] activityIdStrs = activityIds.split(",");
        for (int i = 0; i < activityIdStrs.length; ++i) {
            TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(Integer.valueOf(Integer.parseInt(activityIdStrs[i])));
            if (!pojo.getEnterpriseId().equals(activity.getEnterpriseId())) {
                return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
            }
            LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
            attachWrapper.eq(TrainingActivityAttach::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityAttachMapper.delete((Wrapper)attachWrapper);
            LambdaQueryWrapper introWrapper = new LambdaQueryWrapper();
            introWrapper.eq(TrainingActivityIntro::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityIntroMapper.delete((Wrapper)introWrapper);
            LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
            trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityTrainingMapper.delete((Wrapper)trainingWrapper);
            LambdaQueryWrapper activityUserWrapper = new LambdaQueryWrapper();
            activityUserWrapper.eq(TrainingActivityUser::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityUserMapper.delete((Wrapper)activityUserWrapper);
            LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
            userWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityUserRangeMapper.delete((Wrapper)userWrapper);
            LambdaQueryWrapper userTrainingWrapper = new LambdaQueryWrapper();
            userTrainingWrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)Integer.parseInt(activityIdStrs[i]));
            this.trainingActivityUserTrainingMapper.delete((Wrapper)userTrainingWrapper);
            this.trainingActivityMapper.deleteById(Integer.valueOf(Integer.parseInt(activityIdStrs[i])));
            pojo.setI18nParam(activity.getActivityName());
            this.logApi.save(pojo);
        }
        return JsonResult.success();
    }

    @Override
    public String recommendActivityById(Integer activityId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
        if (activity.getIsRecommend() == 0) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingActivity::getEnterpriseId, (Object)activity.getEnterpriseId());
            wrapper.eq(TrainingActivity::getIsRecommend, (Object)1);
            List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list) && list.size() > 4) {
                return JsonResult.error(null, (Object)this.messageSource.getMessage("training.activity.over.limit", null, locale));
            }
            activity.setIsRecommend(Integer.valueOf(1));
            this.trainingActivityMapper.updateById(activity);
        } else {
            activity.setIsRecommend(Integer.valueOf(0));
            this.trainingActivityMapper.updateById(activity);
        }
        return JsonResult.success();
    }

    @Override
    public String getActivityBanner(Integer enterpriseId) {
        ArrayList<TrainingActivityVo> result = new ArrayList<TrainingActivityVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivity::getEnterpriseId, (Object)enterpriseId);
        wrapper.eq(TrainingActivity::getIsRecommend, (Object)1);
        wrapper.orderByDesc(TrainingActivity::getCreateTime);
        List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingActivity activity : list) {
                TrainingActivityVo vo = new TrainingActivityVo();
                BeanUtils.copyProperties((Object)activity, (Object)vo);
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getActivityList(Integer groupId) {
        ArrayList<TrainingActivityVo> result = new ArrayList<TrainingActivityVo>();
        LambdaQueryWrapper ingWrapper = new LambdaQueryWrapper();
        ingWrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        ingWrapper.eq(TrainingActivity::getEnterpriseId, (Object)groupId);
        ingWrapper.lt(TrainingActivity::getActivityStartTime, (Object)new Date());
        ingWrapper.gt(TrainingActivity::getActivityEndTime, (Object)new Date());
        ingWrapper.orderByAsc(TrainingActivity::getActivityEndTime);
        List ingList = this.trainingActivityMapper.selectList((Wrapper)ingWrapper);
        if (!CollectionUtils.isEmpty((Collection)ingList)) {
            for (TrainingActivity activity : ingList) {
                TrainingActivityVo vo = new TrainingActivityVo();
                BeanUtils.copyProperties((Object)activity, (Object)vo);
                vo.setActivityStatus(Integer.valueOf(3));
                result.add(vo);
            }
        }
        LambdaQueryWrapper unStartWrapper = new LambdaQueryWrapper();
        unStartWrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        unStartWrapper.eq(TrainingActivity::getEnterpriseId, (Object)groupId);
        unStartWrapper.gt(TrainingActivity::getActivityStartTime, (Object)new Date());
        unStartWrapper.orderByAsc(TrainingActivity::getActivityEndTime);
        List unStartList = this.trainingActivityMapper.selectList((Wrapper)unStartWrapper);
        if (!CollectionUtils.isEmpty((Collection)unStartList)) {
            for (TrainingActivity activity : unStartList) {
                TrainingActivityVo vo = new TrainingActivityVo();
                BeanUtils.copyProperties((Object)activity, (Object)vo);
                vo.setActivityStatus(Integer.valueOf(2));
                result.add(vo);
            }
        }
        LambdaQueryWrapper endWrapper = new LambdaQueryWrapper();
        endWrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        endWrapper.eq(TrainingActivity::getEnterpriseId, (Object)groupId);
        endWrapper.lt(TrainingActivity::getActivityEndTime, (Object)new Date());
        endWrapper.orderByAsc(TrainingActivity::getActivityEndTime);
        List endList = this.trainingActivityMapper.selectList((Wrapper)endWrapper);
        if (!CollectionUtils.isEmpty((Collection)endList)) {
            for (TrainingActivity activity : endList) {
                TrainingActivityVo vo = new TrainingActivityVo();
                BeanUtils.copyProperties((Object)activity, (Object)vo);
                vo.setActivityStatus(Integer.valueOf(4));
                result.add(vo);
            }
        }
        if (!CollectionUtils.isEmpty(result)) {
            for (TrainingActivityVo activityVo : result) {
                com.ovopark.organize.common.base.BaseResult userResult;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingActivityUser::getActivityId, (Object)activityVo.getId());
                List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    activityVo.setApplyUserNum(list.size());
                }
                if ((userResult = this.userApi.getUserById(activityVo.getCreator())).getIsError().booleanValue() || userResult.getData() == null) continue;
                activityVo.setCreatorShowName(((com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData()).getShowName());
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String applyActivity(Integer activityId, Integer userId) {
        TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
        if (activity.getActivityRange() == 1) {
            String roleIdStr;
            BaseResult baseResult;
            ArrayList<Object> userIdList = new ArrayList<Object>();
            LambdaQueryWrapper rangeWrapper = new LambdaQueryWrapper();
            rangeWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)activityId);
            List list = this.trainingActivityUserRangeMapper.selectList((Wrapper)rangeWrapper);
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            ArrayList<Integer> roleIds = new ArrayList<Integer>();
            ArrayList<String> orgIds = new ArrayList<String>();
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (TrainingActivityUserRange userRange : list) {
                if (userRange.getUserId() != null) {
                    userIds.add(userRange.getUserId());
                    continue;
                }
                if (userRange.getRoleId() != null) {
                    roleIds.add(userRange.getRoleId());
                    continue;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)userRange.getOrganizeId())) {
                    orgIds.add(userRange.getOrganizeId());
                    continue;
                }
                if (userRange.getTagId() == null) continue;
                tagIds.add(userRange.getTagId());
            }
            if (!CollectionUtils.isEmpty(userIds)) {
                userIdList.addAll(userIds);
            }
            if (!CollectionUtils.isEmpty(roleIds) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), activity.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                List pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                userIdList.addAll(pojo);
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(activity.getEnterpriseId());
                mo.setOrganizeIds(orgIds);
                com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    userIdList.addAll(users);
                }
            }
            if (!CollectionUtils.isEmpty(tagIds)) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(activity.getEnterpriseId());
                pojo.setTagIds(tagIds);
                pojo.setUserId(userId);
                com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        userIdList.add(id);
                    }
                }
            }
            if (!userIdList.contains(userId)) {
                return JsonResult.error(null, (Object)"\u8d85\u51fa\u6d3b\u52a8\u8303\u56f4");
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        wrapper.eq(TrainingActivityUser::getUserId, (Object)userId);
        List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            TrainingActivityUser user = new TrainingActivityUser();
            user.setActivityId(activityId);
            user.setUserId(userId);
            user.setCreateTime(new Date());
            this.trainingActivityUserMapper.insert(user);
        }
        return JsonResult.success();
    }

    @Override
    public String getActivityUserListByPage(Page<TrainingActivityUserVo> page, Integer activityId) {
        ArrayList<TrainingActivityUserVo> result = new ArrayList<TrainingActivityUserVo>();
        List<TrainingActivityUser> list = this.trainingActivityUserMapper.selectByPage(page, activityId, null, null);
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                TrainingActivityUser activityUser = list.get(i);
                com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserById(activityUser.getUserId());
                if (userResult.getIsError().booleanValue() || userResult.getData() == null) continue;
                com.ovopark.organize.common.model.pojo.UsersPojo usersPojo = (com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData();
                TrainingActivityUserVo vo = new TrainingActivityUserVo();
                vo.setShowName(usersPojo.getShowName());
                vo.setThumbUrl(usersPojo.getThumbUrl());
                vo.setCreateTime(activityUser.getCreateTime());
                result.add(vo);
            }
            page.setContent(result);
        }
        return JsonResult.success(page);
    }

    @Override
    public String getMyActivityList(Integer groupId, Integer userId, Integer isSend) {
        List list;
        ArrayList<TrainingActivityVo> result = new ArrayList<TrainingActivityVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivityUser::getUserId, (Object)userId);
        if (isSend != null) {
            if (isSend == 0) {
                wrapper.isNull(TrainingActivityUser::getSendTime);
            } else if (isSend == 1) {
                wrapper.isNotNull(TrainingActivityUser::getSendTime);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper)))) {
            List activityIdList = list.stream().map(TrainingActivityUser::getActivityId).collect(Collectors.toList());
            LambdaQueryWrapper activityWrapper = new LambdaQueryWrapper();
            activityWrapper.in(TrainingActivity::getId, activityIdList);
            List activityList = this.trainingActivityMapper.selectList((Wrapper)activityWrapper);
            if (!CollectionUtils.isEmpty((Collection)activityList)) {
                for (TrainingActivity activity : activityList) {
                    TrainingActivityVo vo = new TrainingActivityVo();
                    BeanUtils.copyProperties((Object)activity, (Object)vo);
                    LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                    userWrapper.eq(TrainingActivityUser::getActivityId, (Object)activity.getId());
                    List userList = this.trainingActivityUserMapper.selectList((Wrapper)userWrapper);
                    if (!CollectionUtils.isEmpty((Collection)userList)) {
                        vo.setApplyUserNum(userList.size());
                    }
                    if (vo.getActivityStatus() != 1) {
                        if (vo.getActivityStartTime().after(new Date())) {
                            vo.setActivityStatus(Integer.valueOf(2));
                        } else if (vo.getActivityEndTime().before(new Date())) {
                            vo.setActivityStatus(Integer.valueOf(4));
                        } else {
                            vo.setActivityStatus(Integer.valueOf(3));
                        }
                    }
                    LambdaQueryWrapper myWrapper = new LambdaQueryWrapper();
                    myWrapper.eq(TrainingActivityUser::getActivityId, (Object)activity.getId());
                    myWrapper.eq(TrainingActivityUser::getUserId, (Object)userId);
                    List myList = this.trainingActivityUserMapper.selectList((Wrapper)myWrapper);
                    if (!CollectionUtils.isEmpty((Collection)myList)) {
                        vo.setApplyTime(((TrainingActivityUser)myList.get(0)).getCreateTime());
                    }
                    result.add(vo);
                }
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getUserListByPage(Users users, Page<TrainingActivityUserVo> page, String userName, Integer activityId, Integer applyMode) {
        Map<String, Object> userMap;
        ArrayList<TrainingActivityUserVo> result = new ArrayList<TrainingActivityUserVo>();
        List<Integer> userIds = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && CollectionUtils.isEmpty(userIds = (List)(userMap = this.userUtilService.getCheckParameters(userName, null, null, users)).get("userList"))) {
            return JsonResult.success(page);
        }
        List<TrainingActivityUser> list = this.trainingActivityUserMapper.selectByPage(page, activityId, applyMode, userIds);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> userIdList = list.stream().map(TrainingActivityUser::getUserId).collect(Collectors.toList());
            Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                parameter.put("groupId", users.getGroupId());
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, users.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, users.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, users.getGroupId());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, users.getGroupId());
            for (TrainingActivityUser user : list) {
                List<String> userStr;
                com.ovopark.organize.common.model.pojo.UsersPojo pojo;
                com.ovopark.organize.common.base.BaseResult userResult;
                TrainingActivityUserVo vo = new TrainingActivityUserVo();
                BeanUtils.copyProperties((Object)user, (Object)vo);
                if (vo.getSendTime() != null) {
                    vo.setIsSend(1);
                }
                if (!(userResult = this.userApi.getUserById(user.getUserId())).getIsError().booleanValue() && userResult.getData() != null) {
                    com.ovopark.organize.common.model.pojo.UsersPojo usersPojo = (com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData();
                    vo.setShowName(usersPojo.getShowName());
                    vo.setThumbUrl(usersPojo.getThumbUrl());
                }
                LambdaQueryWrapper userTrainingWrapper = new LambdaQueryWrapper();
                userTrainingWrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)user.getActivityId());
                userTrainingWrapper.eq(TrainingActivityUserTraining::getUserId, (Object)user.getUserId());
                List userTrainingList = this.trainingActivityUserTrainingMapper.selectList((Wrapper)userTrainingWrapper);
                if (!CollectionUtils.isEmpty((Collection)userTrainingList)) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < userTrainingList.size(); ++i) {
                        TrainingActivityUserTraining userTraining = (TrainingActivityUserTraining)userTrainingList.get(i);
                        Training training = (Training)this.trainingMapper.selectById(userTraining.getTrainingId());
                        if (i != userTrainingList.size() - 1) {
                            sb.append(training.getTitle() + ",");
                            continue;
                        }
                        sb.append(training.getTitle());
                    }
                    vo.setSendDetail(sb.toString());
                }
                vo.setEmployeeNumber((pojo = usersMap.get(user.getUserId())) == null ? "" : pojo.getEmployeeNumber());
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    vo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                    vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    vo.setParentName(parentMap.get(vo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    vo.setParentUserId(parentIdMap.get(vo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(userStr = userOrganizeMap.get(vo.getUserId()))) {
                    vo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                result.add(vo);
            }
            page.setContent(result);
        }
        return JsonResult.success(page);
    }

    @Override
    public List<TrainingActivityUserVo> getTrainingActivityUserVoList(Users users, String userName, Integer activityId, Integer applyMode) {
        Map<String, Object> userMap;
        ArrayList<TrainingActivityUserVo> result = new ArrayList<TrainingActivityUserVo>();
        List userIds = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && CollectionUtils.isEmpty(userIds = (List)(userMap = this.userUtilService.getCheckParameters(userName, null, null, users)).get("userList"))) {
            return null;
        }
        LambdaQueryWrapper activityUserWrapper = new LambdaQueryWrapper();
        activityUserWrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        activityUserWrapper.eq(applyMode != null, TrainingActivityUser::getApplyMode, (Object)applyMode);
        activityUserWrapper.in(!CollectionUtils.isEmpty(userIds), TrainingActivityUser::getUserId, userIds);
        List list = this.trainingActivityUserMapper.selectList((Wrapper)activityUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<Integer> userIdList = list.stream().map(TrainingActivityUser::getUserId).collect(Collectors.toList());
            Map<Integer, com.ovopark.organize.common.model.pojo.UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                parameter.put("groupId", users.getGroupId());
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, users.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, users.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, users.getGroupId());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, users.getGroupId());
            for (TrainingActivityUser user : list) {
                List<String> userStr;
                com.ovopark.organize.common.model.pojo.UsersPojo pojo;
                com.ovopark.organize.common.base.BaseResult userResult;
                TrainingActivityUserVo vo = new TrainingActivityUserVo();
                BeanUtils.copyProperties((Object)user, (Object)vo);
                if (vo.getSendTime() != null) {
                    vo.setIsSend(1);
                }
                if (!(userResult = this.userApi.getUserById(user.getUserId())).getIsError().booleanValue() && userResult.getData() != null) {
                    com.ovopark.organize.common.model.pojo.UsersPojo usersPojo = (com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData();
                    vo.setShowName(usersPojo.getShowName());
                    vo.setUserName(usersPojo.getUserName());
                    vo.setThumbUrl(usersPojo.getThumbUrl());
                }
                LambdaQueryWrapper userTrainingWrapper = new LambdaQueryWrapper();
                userTrainingWrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)user.getActivityId());
                userTrainingWrapper.eq(TrainingActivityUserTraining::getUserId, (Object)user.getUserId());
                List userTrainingList = this.trainingActivityUserTrainingMapper.selectList((Wrapper)userTrainingWrapper);
                if (!CollectionUtils.isEmpty((Collection)userTrainingList)) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < userTrainingList.size(); ++i) {
                        TrainingActivityUserTraining userTraining = (TrainingActivityUserTraining)userTrainingList.get(i);
                        Training training = (Training)this.trainingMapper.selectById(userTraining.getTrainingId());
                        if (i != userTrainingList.size() - 1) {
                            sb.append(training.getTitle() + ",");
                            continue;
                        }
                        sb.append(training.getTitle());
                    }
                    vo.setSendDetail(sb.toString());
                }
                vo.setEmployeeNumber((pojo = usersMap.get(user.getUserId())) == null ? "" : pojo.getEmployeeNumber());
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    vo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                    vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    vo.setParentName(parentMap.get(vo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    vo.setParentUserId(parentIdMap.get(vo.getUserId()));
                }
                if (!CollectionUtils.isEmpty(userStr = userOrganizeMap.get(vo.getUserId()))) {
                    vo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public String deleteActivityUserById(Integer activityUserId) {
        this.trainingActivityUserMapper.deleteById(activityUserId);
        return JsonResult.success();
    }

    @Override
    public String addActivityUser(Integer activityId, String userIds) {
        String[] userIdStrs = userIds.split(",");
        for (int i = 0; i < userIdStrs.length; ++i) {
            TrainingActivityUser user;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
            wrapper.eq(TrainingActivityUser::getUserId, (Object)Integer.parseInt(userIdStrs[i]));
            List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) continue;
            TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
            if (activity.getActivityEndTime().before(new Date()) && activity.getSendMode().equals(0)) {
                user = new TrainingActivityUser();
                user.setCreateTime(new Date());
                user.setActivityId(activityId);
                user.setUserId(Integer.valueOf(Integer.parseInt(userIdStrs[i])));
                user.setApplyMode(Integer.valueOf(1));
                user.setSendTime(new Date());
                this.trainingActivityUserMapper.insert(user);
                LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
                trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)activityId);
                List trainingList = this.trainingActivityTrainingMapper.selectList((Wrapper)trainingWrapper);
                if (CollectionUtils.isEmpty((Collection)trainingList)) continue;
                for (int j = 0; j < trainingList.size(); ++j) {
                    TrainingActivityUserTraining userTraining = new TrainingActivityUserTraining();
                    userTraining.setCreateTime(new Date());
                    userTraining.setActivityId(activityId);
                    userTraining.setUserId(user.getUserId());
                    userTraining.setTrainingId(((TrainingActivityTraining)trainingList.get(j)).getTrainingId());
                    this.trainingActivityUserTrainingMapper.insert(userTraining);
                }
                continue;
            }
            user = new TrainingActivityUser();
            user.setCreateTime(new Date());
            user.setActivityId(activityId);
            user.setUserId(Integer.valueOf(Integer.parseInt(userIdStrs[i])));
            user.setApplyMode(Integer.valueOf(1));
            this.trainingActivityUserMapper.insert(user);
        }
        return JsonResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downUserAnalysis(HttpServletResponse resp, Users users, String userName, Integer activityId, Integer applyMode) {
        List userIds = new ArrayList();
        Map<String, Object> userMap = this.userUtilService.getCheckParameters(userName, null, null, users);
        userIds = (List)userMap.get("userList");
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.student.execl", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell0 = row1.createCell(0);
        cell0.setCellValue(this.messageSource.getMessage("training.operate.registration.time", null, locale));
        Cell cell1 = row1.createCell(1);
        cell1.setCellValue(this.messageSource.getMessage("training.course.analysis.username", null, locale));
        Cell cell2 = row1.createCell(2);
        cell2.setCellValue(this.messageSource.getMessage("training.operate.registration.method", null, locale));
        Cell cell3 = row1.createCell(3);
        cell3.setCellValue(this.messageSource.getMessage("training.operate.send.status", null, locale));
        Cell cell4 = row1.createCell(4);
        cell4.setCellValue(this.messageSource.getMessage("training.operate.send.time", null, locale));
        Cell cell5 = row1.createCell(5);
        cell5.setCellValue(this.messageSource.getMessage("training.operate.send.award", null, locale));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        if (applyMode != null) {
            wrapper.eq(TrainingActivityUser::getApplyMode, (Object)applyMode);
        }
        if (!CollectionUtils.isEmpty(userIds)) {
            wrapper.in(TrainingActivityUser::getUserId, userIds);
        }
        wrapper.orderByDesc(TrainingActivityUser::getId);
        List list = this.trainingActivityUserMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (int i = 0; i < list.size(); ++i) {
                TrainingActivityUser user = (TrainingActivityUser)list.get(i);
                Row row = sheet.createRow(i + 1);
                Cell c0 = row.createCell(0);
                c0.setCellValue(DateUtils.format(user.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
                com.ovopark.organize.common.base.BaseResult userResult = this.userApi.getUserById(user.getUserId());
                if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                    Cell c1 = row.createCell(1);
                    c1.setCellValue(((com.ovopark.organize.common.model.pojo.UsersPojo)userResult.getData()).getShowName());
                }
                Cell c2 = row.createCell(2);
                if (user.getApplyMode() != null) {
                    if (user.getApplyMode() == 0) {
                        c2.setCellValue(this.messageSource.getMessage("training.activity.independent.registration", null, locale));
                    } else if (user.getApplyMode() == 1) {
                        c2.setCellValue(this.messageSource.getMessage("training.operate.manual.add", null, locale));
                    }
                }
                Cell c3 = row.createCell(3);
                if (user.getSendTime() == null) {
                    c3.setCellValue(this.messageSource.getMessage("training.operate.un.grant", null, locale));
                } else {
                    c3.setCellValue(this.messageSource.getMessage("training.operate.has.grant", null, locale));
                }
                Cell c4 = row.createCell(4);
                if (user.getSendTime() != null) {
                    c4.setCellValue(DateUtils.format(user.getSendTime(), "yyyy-MM-dd HH:mm:ss"));
                }
                LambdaQueryWrapper userTrainingWrapper = new LambdaQueryWrapper();
                userTrainingWrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)user.getActivityId());
                userTrainingWrapper.eq(TrainingActivityUserTraining::getUserId, (Object)user.getUserId());
                List userTrainingList = this.trainingActivityUserTrainingMapper.selectList((Wrapper)userTrainingWrapper);
                if (CollectionUtils.isEmpty((Collection)userTrainingList)) continue;
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < userTrainingList.size(); ++j) {
                    TrainingActivityUserTraining userTraining = (TrainingActivityUserTraining)userTrainingList.get(j);
                    Training training = (Training)this.trainingMapper.selectById(userTraining.getTrainingId());
                    if (j != userTrainingList.size() - 1) {
                        sb.append(training.getTitle() + ",");
                        continue;
                    }
                    sb.append(training.getTitle());
                }
                Cell c5 = row.createCell(5);
                c5.setCellValue(sb.toString());
            }
        }
        try {
            resp.setContentType("application/vnd.ms-excel; charset=utf-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.operate.applicant.list", null, locale) + ".xls");
            ServletOutputStream output = resp.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String manualSend(Integer activityId, String trainingIds) {
        TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
        activity.setIsSend(Integer.valueOf(1));
        this.trainingActivityMapper.updateById(activity);
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(TrainingActivityUser::getActivityId, (Object)activityId);
        List userList = this.trainingActivityUserMapper.selectList((Wrapper)userWrapper);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            String[] trainingIdStr = trainingIds.split(",");
            for (TrainingActivityUser user : userList) {
                if (user.getSendTime() == null) {
                    for (int i = 0; i < trainingIdStr.length; ++i) {
                        TrainingActivityUserTraining userTraining = new TrainingActivityUserTraining();
                        userTraining.setCreateTime(new Date());
                        userTraining.setActivityId(activityId);
                        userTraining.setUserId(user.getUserId());
                        userTraining.setTrainingId(Integer.valueOf(Integer.parseInt(trainingIdStr[i])));
                        this.trainingActivityUserTrainingMapper.insert(userTraining);
                    }
                }
                user.setSendTime(new Date());
                this.trainingActivityUserMapper.updateById(user);
            }
        }
        return JsonResult.success();
    }

    @Override
    public String getActivityRewards(Integer activityId, Integer userId) {
        if (userId == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)activityId);
            List list = this.trainingActivityUserTrainingMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                userId = ((TrainingActivityUserTraining)list.get(0)).getUserId();
            }
        }
        ArrayList<TrainingVo> result = new ArrayList<TrainingVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivityUserTraining::getActivityId, (Object)activityId);
        wrapper.eq(TrainingActivityUserTraining::getUserId, (Object)userId);
        List list = this.trainingActivityUserTrainingMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List trainingIdList = list.stream().map(TrainingActivityUserTraining::getTrainingId).collect(Collectors.toList());
            LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)trainingWrapper.in(Training::getId, trainingIdList)).eq(Training::getIsDel, (Object)0);
            List trainingList = this.trainingMapper.selectList((Wrapper)trainingWrapper);
            for (int i = 0; i < trainingList.size(); ++i) {
                Training training = (Training)trainingList.get(i);
                TrainingVo vo = new TrainingVo();
                vo.setId(training.getId());
                vo.setPath(training.getPath());
                vo.setTitle(training.getTitle());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getAttachById(Integer attachId) {
        TrainingActivityAttach attach = (TrainingActivityAttach)this.trainingActivityAttachMapper.selectById(attachId);
        return JsonResult.success((Object)attach);
    }

    @Override
    public String activityFinish() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingActivity::getIsSend, (Object)0);
        wrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        wrapper.eq(TrainingActivity::getSendMode, (Object)0);
        wrapper.lt(TrainingActivity::getActivityEndTime, (Object)new Date());
        List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TrainingActivity activity : list) {
                activity.setIsSend(Integer.valueOf(1));
                this.trainingActivityMapper.updateById(activity);
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingActivityUser::getActivityId, (Object)activity.getId());
                List userList = this.trainingActivityUserMapper.selectList((Wrapper)userWrapper);
                if (CollectionUtils.isEmpty((Collection)userList) || activity.getSendMode() != 0) continue;
                List<Integer> userIdList = userList.stream().map(TrainingActivityUser::getUserId).collect(Collectors.toList());
                LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
                trainingWrapper.eq(TrainingActivityTraining::getActivityId, (Object)activity.getId());
                List trainingList = this.trainingActivityTrainingMapper.selectList((Wrapper)trainingWrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingList)) {
                    List trainingIdList = trainingList.stream().map(TrainingActivityTraining::getTrainingId).collect(Collectors.toList());
                    for (TrainingActivityUser user : userList) {
                        for (int i = 0; i < trainingIdList.size(); ++i) {
                            TrainingActivityUserTraining userTraining = new TrainingActivityUserTraining();
                            userTraining.setCreateTime(new Date());
                            userTraining.setActivityId(activity.getId());
                            userTraining.setUserId(user.getUserId());
                            userTraining.setTrainingId((Integer)trainingIdList.get(i));
                            this.trainingActivityUserTrainingMapper.insert(userTraining);
                        }
                        user.setSendTime(new Date());
                        this.trainingActivityUserMapper.updateById(user);
                    }
                }
                this.sendActivityMessage(activity.getId(), userIdList, activity.getCreator(), activity.getActivityName() + "\u6d3b\u52a8\u5956\u52b1\u5df2\u53d1\u653e\uff0c\u8bf7\u5728\u6211\u53c2\u4e0e\u7684\u6d3b\u52a8\u4e2d\u67e5\u770b\u5956\u52b1\uff01", 135, "TYPE_ACTIVITY_FINISH");
            }
        }
        return JsonResult.success();
    }

    public void sendActivityMessage(Integer activityId, List<Integer> myUserIdList, Integer userId, String content, Integer messageType, String websocketType) {
        TrainingActivity activity = (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
        List<Object> userIdList = new ArrayList();
        if (CollectionUtils.isEmpty(myUserIdList)) {
            if (activity.getActivityRange() == 1) {
                String roleIdStr;
                BaseResult baseResult;
                LambdaQueryWrapper rangeWrapper = new LambdaQueryWrapper();
                rangeWrapper.eq(TrainingActivityUserRange::getActivityId, (Object)activityId);
                List list = this.trainingActivityUserRangeMapper.selectList((Wrapper)rangeWrapper);
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<String> orgIds = new ArrayList<String>();
                ArrayList<Integer> tagIds = new ArrayList<Integer>();
                for (TrainingActivityUserRange userRange : list) {
                    if (userRange.getUserId() != null) {
                        userIds.add(userRange.getUserId());
                        continue;
                    }
                    if (userRange.getRoleId() != null) {
                        arrayList.add(userRange.getRoleId());
                        continue;
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userRange.getOrganizeId())) {
                        orgIds.add(userRange.getOrganizeId());
                        continue;
                    }
                    if (userRange.getTagId() == null) continue;
                    tagIds.add(userRange.getTagId());
                }
                if (!CollectionUtils.isEmpty(userIds)) {
                    userIdList.addAll(userIds);
                }
                if (!CollectionUtils.isEmpty(arrayList) && (baseResult = this.priUserApi.getUserByRoleIds(roleIdStr = StringUtils.join(arrayList, (String)","), activity.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                    userIdList.addAll(pojo);
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(activity.getEnterpriseId());
                    mo.setOrganizeIds(orgIds);
                    com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        userIdList.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(tagIds)) {
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(activity.getEnterpriseId());
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(userId);
                    com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            userIdList.add(id);
                        }
                    }
                }
            } else {
                List userList = (List)this.userApi.getSimpleUserByKeyWord(activity.getEnterpriseId(), null, null).getData();
                userIdList = userList.stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
        } else {
            userIdList = myUserIdList;
        }
        if (!CollectionUtils.isEmpty(userIdList)) {
            TrainingActivityVo vo = new TrainingActivityVo();
            BeanUtils.copyProperties((Object)activity, (Object)vo);
            TaskMessageBody body = new TaskMessageBody();
            body.setType(messageType.intValue());
            body.setTaskJson(JSONObject.toJSONString((Object)vo));
            vo.setTitle("\u6d3b\u52a8\u63d0\u9192");
            for (Integer n : userIdList) {
                this.jPushService.sendWebSocket("\u6d3b\u52a8\u63d0\u9192", content, n, activity.getEnterpriseId(), activity.getId(), websocketType, JSONObject.toJSONString((Object)vo), activity.getActivityEndTime(), 1, 0, null, null);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, websocketType, n, "\u6d3b\u52a8\u63d0\u9192", content, body);
            }
        }
    }

    @Override
    public String activityApply() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        wrapper.between(TrainingActivity::getSignStartTime, (Object)DateUtils.addMinute(new Date(), 55), (Object)DateUtils.addMinute(new Date(), 60));
        final List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            final String pushContent = "\u5012\u8ba1\u65f6\u4e00\u5c0f\u65f6\uff0c{0}\u6d3b\u52a8\u5373\u5c06\u5f00\u542f\u62a5\u540d\uff0c\u8d76\u5feb\u884c\u52a8\u5427\uff01";
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (TrainingActivity activity : list) {
                            TrainingActivityServiceImpl.this.sendActivityMessage(activity.getId(), null, activity.getCreator(), MessageFormat.format(pushContent, activity.getActivityName()), 133, "TYPE_ACTIVITY_APPLY");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u65b0\u589e\u6d3b\u52a8\u5012\u8ba1\u65f6", (Throwable)e);
                    }
                }
            });
        }
        return JsonResult.success();
    }

    @Override
    public String activityApplyFinish() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(TrainingActivity::getActivityStatus, (Object)1);
        wrapper.between(TrainingActivity::getSignEndTime, (Object)DateUtils.addMinute(new Date(), 55), (Object)DateUtils.addMinute(new Date(), 60));
        final List list = this.trainingActivityMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (TrainingActivity activity : list) {
                            TrainingActivityServiceImpl.this.sendActivityMessage(activity.getId(), null, activity.getCreator(), "\u5012\u8ba1\u65f6\u4e00\u5c0f\u65f6\uff0c" + activity.getActivityName() + "\u6d3b\u52a8\u5373\u5c06\u622a\u6b62\u62a5\u540d\uff0c\u8d76\u5feb\u884c\u52a8\u5427\uff01", 134, "TYPE_ACTIVITY_APPLY_FINISH");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u6d3b\u52a8\u5373\u5c06\u622a\u6b62\u62a5\u540d", (Throwable)e);
                    }
                }
            });
        }
        return JsonResult.success();
    }
}

