/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Maps;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingCertificateTitleMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseUserAnalyseMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingCertificate;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingCertificateTitle;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseUserAnalyse;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCertificateService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.util.WaterMarkUtil;
import com.ovopark.training.vo.OpenCertificate;
import com.ovopark.training.vo.OpenUserCourse;
import com.ovopark.training.vo.TrainingCertificateDetailVo;
import com.ovopark.training.vo.TrainingCertificateVo;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingCertificateServiceImpl
implements TrainingCertificateService {
    private static final Logger log = LoggerFactory.getLogger(TrainingCertificateServiceImpl.class);
    @Autowired
    private TrainingCertificateMapper certificateMapper;
    @Autowired
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Autowired
    private TrainingCertificateTitleMapper certificateTitleMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingCourseUserTaskMapper courseUserTaskMapper;
    @Autowired
    private JPushService jPushService;
    @Value(value="${linuxDown.url}")
    private String linuxDownUrl;
    @Value(value="${ossUp.url}")
    private String ossUpUrl;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCourseUserAnalyseMapper trainingCourseUserAnalyseMapper;
    @Autowired
    private LogApi logApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private MessageSource messageSource;

    @Override
    public void insertCertificate(TrainingCertificateVo certificateVo) {
        this.certificateMapper.insert(certificateVo);
        List certificateTitles = certificateVo.getCertificateTitles();
        if (certificateTitles != null && certificateTitles.size() > 0) {
            certificateTitles.forEach(e -> {
                e.setCertificateId(certificateVo.getId());
                e.setCreater(certificateVo.getCreater());
                e.setCreateTime(new Date());
            });
            this.certificateTitleMapper.insertBatch(certificateTitles);
        }
    }

    @Override
    public void updateCertificate(TrainingCertificateVo certificateVo) {
        List certificateTitles = certificateVo.getCertificateTitles();
        if (certificateTitles != null && certificateTitles.size() > 0) {
            certificateTitles.forEach(e -> this.certificateTitleMapper.updateById(e));
        }
        this.certificateMapper.updateById(certificateVo);
    }

    @Override
    public String deleteCertificate(Integer id, LogPojo pojo) {
        TrainingCertificate tc = (TrainingCertificate)this.certificateMapper.selectById(id);
        if (!pojo.getEnterpriseId().equals(tc.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.certificateMapper.deleteById(id);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(TrainingCertificateTitle::getCertificateId, (Object)id);
        this.certificateTitleMapper.delete((Wrapper)wrapper);
        LambdaUpdateWrapper wrappers = new LambdaUpdateWrapper();
        wrappers.eq(TrainingCertificateDetail::getCertificateId, (Object)id);
        this.certificateDetailMapper.delete((Wrapper)wrappers);
        pojo.setI18nParam(tc.getCertificateName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public Page<TrainingCertificateVo> selectCertificateByPage(Page<TrainingCertificateVo> page, TrainingCertificate certificate) {
        List<TrainingCertificateVo> list = this.certificateMapper.selectCertificateByPage(page, certificate.getEnterpriseId(), certificate.getStatus(), certificate.getCertificateName());
        list.stream().forEach(e -> {
            UsersPojo pojo;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingCertificateTitle::getCertificateId, (Object)e.getId());
            e.setCertificateTitles(this.certificateTitleMapper.selectList((Wrapper)wrapper));
            List lists = this.certificateDetailMapper.selectDetailNum(e.getId());
            int totalNum = 0;
            int effectNum = 0;
            if (list != null) {
                for (int i = 0; i < lists.size(); ++i) {
                    Map cer = (Map)lists.get(i);
                    int num = Integer.parseInt(cer.get("num").toString());
                    totalNum += num;
                    if (!"1".equals(cer.get("status").toString())) continue;
                    effectNum = num;
                }
            }
            String name = "";
            if (e.getCreater() != null && !ObjectUtils.isEmpty((Object)(pojo = this.userUtilService.selectUser(e.getCreater())))) {
                name = pojo.getShowName();
            }
            e.setCreateName(name);
            e.setEffectNum(Integer.valueOf(effectNum));
            e.setLastNum(Integer.valueOf(totalNum));
        });
        page.setContent(list);
        return page;
    }

    @Override
    public Page<TrainingCertificateDetailVo> getCertificateDetailByPage(Page<TrainingCertificateDetailVo> page, Integer enterpriseId, List<Integer> userIds, String userName, Integer status, Integer certificateId) {
        List<Object> list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingCertificateDetail::getEnterpriseId, (Object)enterpriseId);
        queryWrapper.eq(TrainingCertificateDetail::getCertificateId, (Object)certificateId);
        queryWrapper.eq(Objects.nonNull(status), TrainingCertificateDetail::getStatus, (Object)status);
        queryWrapper.in(!CollectionUtils.isEmpty(userIds), TrainingCertificateDetail::getUserId, userIds);
        queryWrapper.orderByAsc(TrainingCertificateDetail::getId);
        List trainingCertificateDetails = this.certificateDetailMapper.selectList((Wrapper)queryWrapper);
        List<Integer> userIdList = trainingCertificateDetails.stream().map(TrainingCertificateDetail::getUserId).collect(Collectors.toList());
        List<Integer> createIdList = trainingCertificateDetails.stream().map(TrainingCertificateDetail::getCreater).collect(Collectors.toList());
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdList);
        Map<Integer, UsersPojo> createrMap = this.userUtilService.selectUserMap(createIdList);
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIdList)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIdList, (String)","));
            parameter.put("groupId", enterpriseId);
            BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, enterpriseId);
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, enterpriseId);
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, enterpriseId);
        for (TrainingCertificateDetail detail : trainingCertificateDetails) {
            TrainingCertificateDetailVo vo = new TrainingCertificateDetailVo();
            BeanUtils.copyProperties((Object)detail, (Object)vo);
            UsersPojo usersPojo1 = userMap.get(detail.getUserId());
            UsersPojo usersPojo2 = createrMap.get(detail.getCreater());
            vo.setUserName(usersPojo1.getShowName());
            vo.setEmployeeNumber(usersPojo1.getEmployeeNumber());
            vo.setCreateName(usersPojo2.getShowName());
            if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                StringBuilder role = new StringBuilder();
                for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                    role.append(rolePojo.getRoleName()).append(";\n");
                }
                vo.setRole(role.substring(0, role.length() - 1));
            }
            if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
            }
            if (!CollectionUtils.isEmpty(parentMap)) {
                vo.setParentName(parentMap.get(vo.getUserId()));
            }
            if (!CollectionUtils.isEmpty(parentIdMap)) {
                vo.setParentUserId(parentIdMap.get(vo.getUserId()));
            }
            list.add(vo);
        }
        if (Objects.nonNull(userName)) {
            list = list.stream().filter(e -> e.getUserName().contains(userName)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(list)) {
            TrainingCertificate trainingCertificate = (TrainingCertificate)this.certificateMapper.selectById(certificateId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingCertificateTitle::getCertificateId, (Object)certificateId);
            List titles = this.certificateTitleMapper.selectList((Wrapper)wrapper);
            List userIdsList = list.stream().map(TrainingCertificateDetail::getUserId).distinct().collect(Collectors.toList());
            Map userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(enterpriseId, userIdsList, null).getData();
            list.forEach(e -> {
                List userStr = (List)userOrganizeMap.get(e.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userStr)) {
                    e.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                e.setTrainingCertificate(trainingCertificate);
                e.setTitles(titles);
            });
        }
        page = ListUtil.myPage(list, page.getPageNumber(), page.getPageSize());
        return page;
    }

    @Override
    public List<TrainingCertificateDetailVo> getCertificateDetailList(Integer enterpriseId, List<Integer> userIds, String userName, Integer status, Integer certificateId) {
        List<Object> list = new ArrayList<TrainingCertificateDetailVo>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingCertificateDetail::getEnterpriseId, (Object)enterpriseId);
        queryWrapper.eq(TrainingCertificateDetail::getCertificateId, (Object)certificateId);
        queryWrapper.eq(Objects.nonNull(status), TrainingCertificateDetail::getStatus, (Object)status);
        queryWrapper.in(!CollectionUtils.isEmpty(userIds), TrainingCertificateDetail::getUserId, userIds);
        queryWrapper.orderByAsc(TrainingCertificateDetail::getId);
        List trainingCertificateDetails = this.certificateDetailMapper.selectList((Wrapper)queryWrapper);
        List<Integer> userIdList = trainingCertificateDetails.stream().map(TrainingCertificateDetail::getUserId).collect(Collectors.toList());
        List<Integer> createIdList = trainingCertificateDetails.stream().map(TrainingCertificateDetail::getCreater).collect(Collectors.toList());
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdList);
        Map<Integer, UsersPojo> createrMap = this.userUtilService.selectUserMap(createIdList);
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIdList)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(userIdList, (String)","));
            parameter.put("groupId", enterpriseId);
            BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, enterpriseId);
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, enterpriseId);
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, enterpriseId);
        for (TrainingCertificateDetail detail : trainingCertificateDetails) {
            TrainingCertificateDetailVo vo = new TrainingCertificateDetailVo();
            BeanUtils.copyProperties((Object)detail, (Object)vo);
            UsersPojo usersPojo1 = userMap.get(detail.getUserId());
            UsersPojo usersPojo2 = createrMap.get(detail.getCreater());
            vo.setUserName(usersPojo1.getShowName());
            vo.setEmployeeNumber(usersPojo1.getEmployeeNumber());
            vo.setCreateName(usersPojo2.getShowName());
            if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                StringBuilder role = new StringBuilder();
                for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                    role.append(rolePojo.getRoleName()).append(";\n");
                }
                vo.setRole(role.substring(0, role.length() - 2));
            }
            if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
                vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
            }
            if (!CollectionUtils.isEmpty(parentMap)) {
                vo.setParentName(parentMap.get(vo.getUserId()));
            }
            if (!CollectionUtils.isEmpty(parentIdMap)) {
                vo.setParentUserId(parentIdMap.get(vo.getUserId()));
            }
            list.add(vo);
        }
        if (Objects.nonNull(userName)) {
            list = list.stream().filter(e -> e.getUserName().contains(userName)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(list)) {
            TrainingCertificate trainingCertificate = (TrainingCertificate)this.certificateMapper.selectById(certificateId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingCertificateTitle::getCertificateId, (Object)certificateId);
            List titles = this.certificateTitleMapper.selectList((Wrapper)wrapper);
            List userIdsList = list.stream().map(TrainingCertificateDetail::getUserId).distinct().collect(Collectors.toList());
            Map userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(enterpriseId, userIdsList, null).getData();
            list.forEach(e -> {
                List userStr = (List)userOrganizeMap.get(e.getUserId());
                if (!CollectionUtils.isEmpty((Collection)userStr)) {
                    e.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                e.setTrainingCertificate(trainingCertificate);
                e.setTitles(titles);
            });
        }
        return list;
    }

    @Override
    public Map selectDetailNum(Integer certificateId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("effectNum", 0);
        map.put("loseNum", 0);
        map.put("backNum", 0);
        int totalNum = 0;
        List list = this.certificateDetailMapper.selectDetailNum(certificateId);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map cer = (Map)list.get(i);
                int num = Integer.parseInt(cer.get("num").toString());
                totalNum += num;
                if ("1".equals(cer.get("status").toString())) {
                    map.put("effectNum", num);
                    continue;
                }
                if ("2".equals(cer.get("status").toString())) {
                    map.put("loseNum", num);
                    continue;
                }
                if (!"3".equals(cer.get("status").toString())) continue;
                map.put("backNum", num);
            }
        }
        map.put("totalNum", totalNum);
        return map;
    }

    @Override
    public List<TrainingCertificateDetailVo> insertCertificateDetail(List<TrainingCertificateDetailVo> certificateDetailVos, Users user) {
        final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        final ArrayList<TrainingCertificateDetailVo> certificateList = new ArrayList<TrainingCertificateDetailVo>();
        if (!CollectionUtils.isEmpty(certificateDetailVos)) {
            List certificateIdList = certificateDetailVos.stream().map(TrainingCertificateDetail::getCertificateId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List trainingCertificateList = this.certificateMapper.selectBatchIds(certificateIdList);
            Map trainingCertificateMap = trainingCertificateList.stream().collect(Collectors.toMap(TrainingCertificate::getId, Function.identity()));
            for (TrainingCertificateDetailVo certificateDetail : certificateDetailVos) {
                TrainingCertificate trainingCertificate;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(TrainingCertificateDetail::getCertificateId, (Object)certificateDetail.getCertificateId())).eq(TrainingCertificateDetail::getUserId, (Object)certificateDetail.getUserId());
                List details = this.certificateDetailMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)details) || ObjectUtils.isEmpty((Object)(trainingCertificate = (TrainingCertificate)trainingCertificateMap.get(certificateDetail.getCertificateId())))) continue;
                Integer isAlways = trainingCertificate.getIsAlways();
                if (isAlways == 0 && trainingCertificate.getValidity() != null) {
                    int time = trainingCertificate.getValidity();
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(new Date());
                    ca.add(2, time);
                    certificateDetail.setEndTime(ca.getTime());
                }
                certificateDetail.setIsAlways(isAlways);
                certificateDetail.setValidity(trainingCertificate.getValidity());
                String fixed = trainingCertificate.getFixedId();
                int random = trainingCertificate.getRandomNum();
                int lastNum = trainingCertificate.getLastNum() + 1;
                int effectNum = trainingCertificate.getEffectNum() + 1;
                String str = StringsUtils.getRandomNumber(random);
                LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                wrappers.eq(TrainingCertificateDetail::getCertificateId, (Object)certificateDetail.getCertificateId());
                List cDetails = this.certificateDetailMapper.selectList((Wrapper)wrappers);
                for (int s = 0; s < cDetails.size(); ++s) {
                    TrainingCertificateDetail cDetail = (TrainingCertificateDetail)cDetails.get(s);
                    String cStr = cDetail.getCertificateNumber().substring(cDetail.getCertificateNumber().length() - random);
                    if (!str.equals(cStr)) continue;
                    s = 0;
                    str = StringsUtils.getRandomNumber(random);
                }
                certificateDetail.setCertificateNumber(fixed + str);
                TrainingCertificate certificate = new TrainingCertificate();
                certificate.setId(trainingCertificate.getId());
                certificate.setLastNum(Integer.valueOf(lastNum));
                certificate.setEffectNum(Integer.valueOf(effectNum));
                this.certificateMapper.updateById(certificate);
                certificateDetail.setEnterpriseId(user.getGroupId());
                certificateDetail.setCreater(user.getId());
                certificateDetail.setCreateTime(new Date());
                this.certificateDetailMapper.insert(certificateDetail);
                certificateList.add(certificateDetail);
            }
            if (!CollectionUtils.isEmpty(certificateList)) {
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (TrainingCertificateDetailVo certificate : certificateList) {
                                if (certificate.getUrl() != null) {
                                    certificate.setUrl(certificate.getUrl().split("?")[0]);
                                }
                                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                                HashMap<String, Object> map1 = new HashMap<String, Object>();
                                map1.put("markContentColor", Color.BLACK);
                                map1.put("font", new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 30));
                                map1.put("waterMarkContent", certificate.getUserName());
                                map1.put("width", 0.4);
                                map1.put("length", 0.35);
                                map1.put("middle", 1);
                                list.add(map1);
                                HashMap<String, Object> map2 = new HashMap<String, Object>();
                                map2.put("markContentColor", Color.BLACK);
                                map2.put("font", new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
                                map2.put("waterMarkContent", formatter.format(new Date()));
                                map2.put("width", 0.11);
                                map2.put("length", 0.91);
                                list.add(map2);
                                HashMap<String, Object> map3 = new HashMap<String, Object>();
                                map3.put("markContentColor", Color.BLACK);
                                map3.put("font", new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
                                map3.put("waterMarkContent", certificate.getCertificateNumber());
                                map3.put("width", 0.74);
                                map3.put("length", 0.91);
                                list.add(map3);
                                String url = WaterMarkUtil.addWaterMark(certificate.getUrl(), TrainingCertificateServiceImpl.this.linuxDownUrl + certificate.getCertificateNumber() + ".png", TrainingCertificateServiceImpl.this.ossUpUrl, list);
                                TrainingCertificateDetail certificateDetailNew = new TrainingCertificateDetail();
                                certificateDetailNew.setId(certificate.getId());
                                certificateDetailNew.setUrl(url);
                                TrainingCertificateServiceImpl.this.certificateDetailMapper.updateById(certificateDetailNew);
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(124);
                                TrainingCertificate trainingCertificate = (TrainingCertificate)TrainingCertificateServiceImpl.this.certificateMapper.selectById(certificate.getCertificateId());
                                HashMap msg = Maps.newHashMap();
                                String title = "\u83b7\u5f97\u8bc1\u4e66\u63d0\u9192";
                                msg.put("projectId", certificate.getId());
                                msg.put("title", title);
                                msg.put("url", url);
                                body.setTaskJson(JSONObject.toJSONString((Object)msg));
                                String pushContent = "\u606d\u559c\u4f60\u83b7\u5f97\u4e86\u300a{0}\u300b\u8bc1\u4e66\uff0c\u70b9\u51fb\u67e5\u770b~";
                                TrainingCertificateServiceImpl.this.jPushService.sendWebSocket(title, MessageFormat.format(pushContent, trainingCertificate.getCertificateName()), certificate.getUserId(), certificate.getEnterpriseId(), certificate.getId(), "TYPE_CERTIFICATE_AWARD_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.certificate.push.content", trainingCertificate.getCertificateName());
                                TrainingCertificateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_CERTIFICATE_AWARD_TYPE", certificate.getUserId(), title, MessageFormat.format(pushContent, trainingCertificate.getCertificateName()), body);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u52a0\u6c34\u5370\uff1a" + e);
                        }
                    }
                });
            }
        }
        return certificateList;
    }

    @Override
    public void updateCertificateDetail(List<TrainingCertificateDetailVo> certificateDetailVos) {
        for (TrainingCertificateDetail trainingCertificateDetail : certificateDetailVos) {
            this.certificateDetailMapper.updateById(trainingCertificateDetail);
        }
    }

    @Override
    public void updateDetailBack(TrainingCertificateDetailVo certificateDetailVo) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        certificateDetailVo.setStatus(Integer.valueOf(3));
        this.certificateDetailMapper.updateById(certificateDetailVo);
        TrainingCertificate certificate = (TrainingCertificate)this.certificateMapper.selectById(certificateDetailVo.getCertificateId());
        certificate.setEffectNum(Integer.valueOf(certificate.getEffectNum() - 1));
        this.certificateMapper.updateById(certificate);
        TrainingCertificateDetail trainingCertificateDetail = (TrainingCertificateDetail)this.certificateDetailMapper.selectById(certificateDetailVo.getId());
        TaskMessageBody body = new TaskMessageBody();
        body.setType(125);
        HashMap msg = Maps.newHashMap();
        msg.put("projectId", certificateDetailVo.getCertificateId());
        msg.put("title", this.messageSource.getMessage("training.certificate.back.remind", null, locale));
        msg.put("url", trainingCertificateDetail.getUrl());
        body.setTaskJson(JSONObject.toJSONString((Object)msg));
        this.jPushService.sendWebSocket(this.messageSource.getMessage("training.certificate.back.remind", null, locale), MessageFormat.format(this.messageSource.getMessage("training.job.certificate.back.remind", null, locale), certificate.getCertificateName()), trainingCertificateDetail.getUserId(), trainingCertificateDetail.getEnterpriseId(), trainingCertificateDetail.getCertificateId(), "TYPE_CERTIFICATE_RECOVERY_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.job.certificate.back.remind", certificate.getCertificateName());
        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_CERTIFICATE_RECOVERY_TYPE", trainingCertificateDetail.getUserId(), this.messageSource.getMessage("training.certificate.back.remind", null, locale), MessageFormat.format(this.messageSource.getMessage("training.job.certificate.back.remind", null, locale), certificate.getCertificateName()), body);
    }

    @Override
    public void updateDetailReissue(TrainingCertificateDetailVo certificateDetailVo) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        certificateDetailVo.setStatus(Integer.valueOf(1));
        certificateDetailVo.setIsShow(Integer.valueOf(1));
        this.certificateDetailMapper.updateById(certificateDetailVo);
        TrainingCertificate certificate = (TrainingCertificate)this.certificateMapper.selectById(certificateDetailVo.getCertificateId());
        certificate.setEffectNum(Integer.valueOf(certificate.getEffectNum() + 1));
        this.certificateMapper.updateById(certificate);
        TrainingCertificateDetail trainingCertificateDetail = (TrainingCertificateDetail)this.certificateDetailMapper.selectById(certificateDetailVo.getId());
        TaskMessageBody body = new TaskMessageBody();
        body.setType(124);
        HashMap msg = Maps.newHashMap();
        msg.put("projectId", certificateDetailVo.getCertificateId());
        msg.put("title", this.messageSource.getMessage("training.job.certificate.remind", null, locale));
        msg.put("url", trainingCertificateDetail.getUrl());
        body.setTaskJson(JSONObject.toJSONString((Object)msg));
        this.jPushService.sendWebSocket(this.messageSource.getMessage("training.job.certificate.remind", null, locale), MessageFormat.format(this.messageSource.getMessage("training.certificate.push.content", null, locale), certificate.getCertificateName()), trainingCertificateDetail.getUserId(), trainingCertificateDetail.getEnterpriseId(), trainingCertificateDetail.getCertificateId(), "TYPE_CERTIFICATE_AWARD_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.certificate.push.content", certificate.getCertificateName());
        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_CERTIFICATE_AWARD_TYPE", trainingCertificateDetail.getUserId(), this.messageSource.getMessage("training.job.certificate.remind", null, locale), MessageFormat.format(this.messageSource.getMessage("training.learn.pass.cert", null, locale), certificate.getCertificateName()), body);
    }

    @Override
    public Page<TrainingCertificateDetailVo> selectMyAppCertificateByPage(Page<TrainingCertificateDetailVo> page, Users user) {
        List<TrainingCertificateDetailVo> detailVoList = this.certificateDetailMapper.selectMyAppCertificateByPage(page, user.getId());
        page.setContent(detailVoList);
        return page;
    }

    @Override
    public void updateAppDetailShow(TrainingCertificateDetail certificateDetail) {
        certificateDetail.setIsShow(Integer.valueOf(0));
        this.certificateDetailMapper.updateById(certificateDetail);
    }

    @Override
    public String getOpenCertificateList(Integer enterpriseId, Date startDate, Date endDate) {
        List list;
        ArrayList<OpenCertificate> result = new ArrayList<OpenCertificate>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCertificate::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.ge(TrainingCertificate::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.le(TrainingCertificate::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.certificateMapper.selectList((Wrapper)wrapper)))) {
            for (TrainingCertificate certificate : list) {
                OpenCertificate vo = new OpenCertificate();
                vo.setCertificateId(certificate.getId());
                vo.setCertificateName(certificate.getCertificateName());
                vo.setIsAlways(certificate.getIsAlways());
                vo.setValidity(certificate.getValidity());
                vo.setStatus(certificate.getStatus());
                vo.setCreator(certificate.getCreater());
                vo.setCreateTime(certificate.getCreateTime());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getOpenUserCourseList(Integer enterpriseId, Date startDate, Date endDate) {
        List courseList;
        ArrayList<OpenUserCourse> result = new ArrayList<OpenUserCourse>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.gt(TrainingCourse::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.lt(TrainingCourse::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(courseList = this.trainingCourseMapper.selectList((Wrapper)wrapper)))) {
            LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
            userWrapper.in(TrainingCourseUserAnalyse::getCourseId, (Collection)courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()));
            List userList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)userWrapper);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                for (TrainingCourseUserAnalyse user : userList) {
                    OpenUserCourse vo = new OpenUserCourse();
                    vo.setAnalyseId(user.getId());
                    vo.setUserId(user.getUserId());
                    vo.setCourseId(user.getCourseId());
                    LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                    taskWrapper.eq(TrainingCourseUserTask::getEnterpriseId, (Object)enterpriseId);
                    taskWrapper.eq(TrainingCourseUserTask::getUserId, (Object)user.getUserId());
                    taskWrapper.eq(TrainingCourseUserTask::getCourseId, (Object)user.getCourseId());
                    ArrayList<Integer> statusList = new ArrayList<Integer>();
                    statusList.add(3);
                    statusList.add(4);
                    taskWrapper.in(TrainingCourseUserTask::getTaskStatus, statusList);
                    List taskList = this.courseUserTaskMapper.selectList((Wrapper)taskWrapper);
                    if (!CollectionUtils.isEmpty((Collection)taskList)) {
                        vo.setTaskNum(taskList.size());
                        for (TrainingCourseUserTask userCourse : taskList) {
                            if (vo.getStartTime() == null || vo.getStartTime().after(userCourse.getStartTime())) {
                                vo.setStartTime(userCourse.getStartTime());
                            }
                            if (vo.getEndTime() != null && !vo.getEndTime().before(userCourse.getEndTime())) continue;
                            vo.setEndTime(userCourse.getEndTime());
                        }
                        vo.setPassStatus(user.getPassStatus());
                        vo.setCertificateId(user.getCertificateId());
                    }
                    result.add(vo);
                }
                return JsonResult.success(result);
            }
        }
        return JsonResult.success();
    }
}

