/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingPaperUserTurnsMapper;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingPaperUserTurns;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingCourseStatisticalService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.OpenCourse;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingCourseVo;
import com.ovopark.training.vo.UserOrganizeAndDepVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingCourseStatisticalServiceImpl
implements TrainingCourseStatisticalService {
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingCourseUserTaskMapper trainingCourseUserTaskMapper;
    @Autowired
    private TrainingPaperUserTurnsMapper trainingPaperUserTurnsMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi useApi;
    @Autowired
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Autowired
    private TagApi tagApi;

    @Override
    public Page<TrainingCourseVo> courseStatisticalByPage(Page<TrainingCourseVo> page, Users user, Integer status, Integer userStatus, String courseName, String startTime, String endTime) {
        List<TrainingCourse> trainingCourses = this.getTrainingCourses(user, courseName, startTime, endTime, status);
        if (CollectionUtils.isEmpty(trainingCourses)) {
            return null;
        }
        List<Integer> currentUserPrivilegeUserIds = this.userUtilService.getUserIdsMapByPrivilegeUserId(user.getGroupId(), user.getId(), userStatus, null, null);
        if (CollectionUtils.isEmpty(currentUserPrivilegeUserIds)) {
            return null;
        }
        Map<Integer, List<TrainingCourseUser>> courseUserMap = this.getCourseAppointUserMap(trainingCourses);
        HashMap<Integer, List<String>> courseOrganizeIdsMap = new HashMap<Integer, List<String>>();
        HashMap<Integer, List<Integer>> courseRoleIdsMap = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, List<Integer>> courseUserIdsMap = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, List<Integer>> courseTagIdsMap = new HashMap<Integer, List<Integer>>();
        ArrayList<String> allAppointOrganizeIds = new ArrayList<String>();
        ArrayList<Integer> allAppointRoleIds = new ArrayList<Integer>();
        ArrayList<Integer> allAppointTagIds = new ArrayList<Integer>();
        TrainingCourseStatisticalServiceImpl.getCourseAppointObjectIds(courseUserMap, courseUserIdsMap, courseRoleIdsMap, allAppointRoleIds, courseTagIdsMap, allAppointTagIds, courseOrganizeIdsMap, allAppointOrganizeIds);
        List<Integer> allEnterpriseUserIds = userStatus != null && userStatus.equals(1) ? this.userUtilService.getResignUserByGroupId(user.getGroupId()) : this.userUtilService.getUserListByGroupId(user.getGroupId());
        Map<Integer, List<Integer>> roleAndUserIdSMap = this.userUtilService.selectUserByRoleIdMap(allAppointRoleIds, user.getGroupId());
        Map<Integer, List<Integer>> tagAndUserIdSMap = this.userUtilService.selectUserByTagIdMap(allAppointTagIds, user.getGroupId(), user.getId());
        Map<String, List<Integer>> organizeAndUserIdSMap = this.userUtilService.selectUserByOrganizeIdMap(allAppointOrganizeIds, user.getGroupId());
        ArrayList<TrainingCourse> courses = new ArrayList<TrainingCourse>();
        HashMap<Integer, List<Integer>> coursePrivilegeUserIdsMap = new HashMap<Integer, List<Integer>>();
        for (TrainingCourse course : trainingCourses) {
            List<Integer> coursePrivilegeUserIds = new ArrayList<Integer>(currentUserPrivilegeUserIds);
            if (course.getAppointType().equals(1)) {
                List<Integer> courseAllUserIds = TrainingCourseStatisticalServiceImpl.getAppointTypeUserIds(course, courseUserIdsMap, allEnterpriseUserIds, courseRoleIdsMap, roleAndUserIdSMap, courseTagIdsMap, tagAndUserIdSMap, courseOrganizeIdsMap, organizeAndUserIdSMap, coursePrivilegeUserIds);
                coursePrivilegeUserIds.retainAll(courseAllUserIds);
            }
            if (CollectionUtils.isEmpty(coursePrivilegeUserIds)) continue;
            coursePrivilegeUserIds = coursePrivilegeUserIds.stream().distinct().collect(Collectors.toList());
            coursePrivilegeUserIdsMap.put(course.getId(), coursePrivilegeUserIds);
            courses.add(course);
        }
        page.setTotalCount(Long.valueOf(courses.size()));
        if (page.getTotalCount().intValue() == 0) {
            return page;
        }
        int start = (page.getPageNumber() - 1) * page.getPageSize();
        int end = Math.min(start + page.getPageSize(), Math.min(page.getTotalCount().intValue(), courses.size()));
        List results = courses.subList(start, end);
        List<Integer> courseIds = results.stream().map(it -> it.getId()).collect(Collectors.toList());
        Map<Integer, List<TrainingCourseUserTask>> resultCourseUserTasksMap = this.getCourseUserTasksMap(user, courseIds, currentUserPrivilegeUserIds);
        Map<Integer, List<TrainingCourseStageTask>> trainingCourseStageTaskMap = this.getCourseStageTaskMap(courseIds);
        Map<Integer, List<TrainingPaperUserTurns>> turnMap = this.getCourseTurnsMap(courseIds);
        ArrayList<TrainingCourseVo> resultVos = new ArrayList<TrainingCourseVo>();
        for (TrainingCourse result : results) {
            TrainingCourseVo resultVo = new TrainingCourseVo();
            BeanUtils.copyProperties((Object)result, (Object)resultVo);
            resultVos.add(resultVo);
            List userIds = (List)coursePrivilegeUserIdsMap.get(resultVo.getId());
            resultVo.setAllCount(Integer.valueOf(userIds.size()));
            Map<Object, Object> trainingCourseUserTaskMap = new HashMap();
            List<TrainingCourseUserTask> trainingCourseUserTasks = resultCourseUserTasksMap.get(resultVo.getId());
            if (!CollectionUtils.isEmpty(trainingCourseUserTasks)) {
                trainingCourseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            }
            HashMap<Integer, List<TrainingPaperUserTurns>> trainingPaperUserTurnsMap = new HashMap();
            List<TrainingPaperUserTurns> trainingPaperUserTurnsList = turnMap.get(resultVo.getId());
            if (!CollectionUtils.isEmpty(trainingPaperUserTurnsList)) {
                trainingPaperUserTurnsMap = trainingPaperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
            }
            HashMap<Integer, TrainingCourseStageTask> courseStageTaskMap = new HashMap();
            List<TrainingCourseStageTask> trainingCourseStageTasks = trainingCourseStageTaskMap.get(resultVo.getId());
            if (!CollectionUtils.isEmpty(trainingCourseStageTasks)) {
                courseStageTaskMap = trainingCourseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
            }
            Integer passUserNum = 0;
            for (Integer userId : userIds) {
                List trainingCourseUserTaskVos = (List)trainingCourseUserTaskMap.get(userId);
                if (CollectionUtils.isEmpty((Collection)trainingCourseUserTaskVos)) continue;
                TrainingCourseStatisticalServiceImpl.turnsUserTaskFilter(userId, trainingPaperUserTurnsMap, trainingCourseUserTaskVos, courseStageTaskMap);
                if (CollectionUtils.isEmpty((Collection)trainingCourseUserTaskVos)) continue;
                int userTaskSize = trainingCourseUserTaskVos.size();
                if (CollectionUtils.isEmpty(trainingCourseStageTasks) || userTaskSize < trainingCourseStageTasks.size()) continue;
                Integer userTaskPassNum = 0;
                Integer userTaskUnPassNum = 0;
                for (TrainingCourseUserTask taskVo : trainingCourseUserTaskVos) {
                    Integer n;
                    Integer n2;
                    if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4) {
                        n2 = userTaskPassNum;
                        n = userTaskPassNum = Integer.valueOf(userTaskPassNum + 1);
                        continue;
                    }
                    if (taskVo.getTaskStatus() != 5) continue;
                    n2 = userTaskUnPassNum;
                    n = userTaskUnPassNum = Integer.valueOf(userTaskUnPassNum + 1);
                }
                if (userTaskPassNum != userTaskSize) continue;
                Integer n = passUserNum;
                Integer n3 = passUserNum = Integer.valueOf(passUserNum + 1);
            }
            resultVo.setFinishNum(passUserNum);
            BigDecimal finishRate = new BigDecimal(passUserNum).divide(new BigDecimal(resultVo.getAllCount()), 4, 4);
            resultVo.setFinishRate(finishRate);
        }
        page.setContent(resultVos);
        return page;
    }

    private static void turnsUserTaskFilter(Integer userId, Map<Integer, List<TrainingPaperUserTurns>> trainingPaperUserTurnsMap, List<TrainingCourseUserTask> trainingCourseUserTaskVos, Map<Integer, TrainingCourseStageTask> courseStageTaskMap) {
        List<TrainingPaperUserTurns> trainingPaperUserTurns = trainingPaperUserTurnsMap.get(userId);
        if (!CollectionUtils.isEmpty(trainingPaperUserTurns)) {
            Map<Integer, List<TrainingPaperUserTurns>> userTurnsMap = trainingPaperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
            ArrayList<TrainingCourseUserTask> removeList = new ArrayList<TrainingCourseUserTask>();
            for (TrainingCourseUserTask trainingCourseUserTask : trainingCourseUserTaskVos) {
                List<TrainingPaperUserTurns> turnsList;
                TrainingCourseStageTask courseStageTask = courseStageTaskMap.get(trainingCourseUserTask.getTaskId());
                if (ObjectUtils.isEmpty((Object)courseStageTask) || CollectionUtils.isEmpty(turnsList = userTurnsMap.get(courseStageTask.getStageId())) || trainingCourseUserTask.getTurns().compareTo(turnsList.get(0).getTurns()) == 0) continue;
                removeList.add(trainingCourseUserTask);
            }
            if (!CollectionUtils.isEmpty(removeList)) {
                trainingCourseUserTaskVos.removeAll(removeList);
            }
        }
    }

    private Map<Integer, List<TrainingPaperUserTurns>> getCourseTurnsMap(List<Integer> courseIds) {
        Map<Integer, List<TrainingPaperUserTurns>> turnMap = new HashMap<Integer, List<TrainingPaperUserTurns>>();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingPaperUserTurns::getProjectId, courseIds)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
        List paperUserTurns = this.trainingPaperUserTurnsMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
            turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getProjectId));
        }
        return turnMap;
    }

    private Map<Integer, List<TrainingCourseStageTask>> getCourseStageTaskMap(List<Integer> courseIds) {
        Map<Integer, List<TrainingCourseStageTask>> trainingCourseStageTaskMap = new HashMap<Integer, List<TrainingCourseStageTask>>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.in(TrainingCourseStageTask::getCourseId, courseIds);
        List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList)) {
            trainingCourseStageTaskMap = trainingCourseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
        }
        return trainingCourseStageTaskMap;
    }

    private Map<Integer, List<TrainingCourseUserTask>> getCourseUserTasksMap(Users user, List<Integer> courseIds, List<Integer> currentUserPrivilegeUserIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourseUserTask::getEnterpriseId, (Object)user.getGroupId());
        wrapper.in(TrainingCourseUserTask::getCourseId, courseIds);
        wrapper.in(TrainingCourseUserTask::getUserId, currentUserPrivilegeUserIds);
        List trainingCourseUserTasks = this.trainingCourseUserTaskMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
            return new HashMap<Integer, List<TrainingCourseUserTask>>();
        }
        Map<Integer, List<TrainingCourseUserTask>> resultCourseUserTasksMap = trainingCourseUserTasks.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
        return resultCourseUserTasksMap;
    }

    private static List<Integer> getAppointTypeUserIds(TrainingCourse course, Map<Integer, List<Integer>> courseUserIdsMap, List<Integer> allEnterpriseUserIds, Map<Integer, List<Integer>> courseRoleIdsMap, Map<Integer, List<Integer>> roleAndUserIdSMap, Map<Integer, List<Integer>> courseTagIdsMap, Map<Integer, List<Integer>> tagAndUserIdSMap, Map<Integer, List<String>> courseOrganizeIdsMap, Map<String, List<Integer>> organizeAndUserIdSMap, List<Integer> coursePrivilegeUserIds) {
        List<String> organizeIds;
        List<Integer> tagIds;
        List<Integer> roleIds;
        ArrayList<Integer> courseAllUserIds = new ArrayList<Integer>();
        List<Integer> userIds = courseUserIdsMap.get(course.getId());
        if (!CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(allEnterpriseUserIds);
            courseAllUserIds.addAll(userIds);
        }
        if (!CollectionUtils.isEmpty(roleIds = courseRoleIdsMap.get(course.getId()))) {
            courseAllUserIds.addAll(roleIds.stream().map(roleId -> (List)roleAndUserIdSMap.get(roleId)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(tagIds = courseTagIdsMap.get(course.getId()))) {
            courseAllUserIds.addAll(tagIds.stream().map(tagId -> (List)tagAndUserIdSMap.get(tagId)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(organizeIds = courseOrganizeIdsMap.get(course.getId()))) {
            courseAllUserIds.addAll(organizeIds.stream().map(organizeId -> (List)organizeAndUserIdSMap.get(organizeId)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return courseAllUserIds;
    }

    private static void getCourseAppointObjectIds(Map<Integer, List<TrainingCourseUser>> courseUserMap, Map<Integer, List<Integer>> courseUserIdsMap, Map<Integer, List<Integer>> courseRoleIdsMap, List<Integer> allAppointRoleIds, Map<Integer, List<Integer>> courseTagIdsMap, List<Integer> allAppointTagIds, Map<Integer, List<String>> courseOrganizeIdsMap, List<String> allAppointOrganizeIds) {
        courseUserMap.forEach((k, v) -> {
            ArrayList<String> organizeIds = null;
            ArrayList<Integer> userIds = null;
            ArrayList<Integer> roleIds = null;
            ArrayList<Integer> tagIds = null;
            for (TrainingCourseUser trainingCourseUser : v) {
                if (trainingCourseUser.getUserId() != null) {
                    if (userIds == null) {
                        userIds = new ArrayList<Integer>();
                    }
                    userIds.add(trainingCourseUser.getUserId());
                    continue;
                }
                if (trainingCourseUser.getRoleId() != null) {
                    if (roleIds == null) {
                        roleIds = new ArrayList<Integer>();
                    }
                    roleIds.add(trainingCourseUser.getRoleId());
                    continue;
                }
                if (trainingCourseUser.getOrganizeId() != null) {
                    if (organizeIds == null) {
                        organizeIds = new ArrayList<String>();
                    }
                    organizeIds.add(trainingCourseUser.getOrganizeId());
                    continue;
                }
                if (trainingCourseUser.getTagId() == null) continue;
                if (tagIds == null) {
                    tagIds = new ArrayList<Integer>();
                }
                tagIds.add(trainingCourseUser.getTagId());
            }
            if (userIds != null) {
                courseUserIdsMap.put((Integer)k, (List<Integer>)userIds);
            }
            if (roleIds != null) {
                courseRoleIdsMap.put((Integer)k, (List<Integer>)roleIds);
                allAppointRoleIds.addAll(roleIds);
            }
            if (tagIds != null) {
                courseTagIdsMap.put((Integer)k, (List<Integer>)tagIds);
                allAppointTagIds.addAll(tagIds);
            }
            if (organizeIds != null) {
                courseOrganizeIdsMap.put((Integer)k, (List<String>)organizeIds);
                allAppointOrganizeIds.addAll(organizeIds);
            }
        });
    }

    private Map<Integer, List<TrainingCourseUser>> getCourseAppointUserMap(List<TrainingCourse> trainingCourses) {
        List appointTypeCourseIds = trainingCourses.stream().filter(it -> it.getAppointType().equals(1)).map(TrainingCourse::getId).collect(Collectors.toList());
        Map<Integer, List<TrainingCourseUser>> courseUserMap = new HashMap<Integer, List<TrainingCourseUser>>();
        if (!CollectionUtils.isEmpty(appointTypeCourseIds)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.in(TrainingCourseUser::getCourseId, appointTypeCourseIds)).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                courseUserMap = courseUserList.stream().collect(Collectors.groupingBy(TrainingCourseUser::getCourseId));
            }
        }
        return courseUserMap;
    }

    private List<TrainingCourse> getTrainingCourses(Users user, String courseName, String startTime, String endTime, Integer status) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingCourse::getEnterpriseId, (Object)user.getGroupId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)startTime)) {
            queryWrapper.ge(TrainingCourse::getEndTime, (Object)startTime);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)endTime)) {
            queryWrapper.le(TrainingCourse::getStartTime, (Object)endTime);
        }
        if (status != null) {
            queryWrapper.eq(TrainingCourse::getStatus, (Object)status);
        } else {
            queryWrapper.ne(TrainingCourse::getStatus, (Object)0);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)courseName)) {
            queryWrapper.like(TrainingCourse::getCourseName, (Object)courseName);
        }
        queryWrapper.orderByDesc(TrainingCourse::getEndTime);
        List trainingCourses = this.trainingCourseMapper.selectList((Wrapper)queryWrapper);
        return trainingCourses;
    }

    @Override
    public TrainingCourseVo detail(Users user, Integer courseId, String roleIds, String organizeIds, Integer userStatus) {
        TrainingCourse course = (TrainingCourse)this.trainingCourseMapper.selectById(courseId);
        if (course == null) {
            return null;
        }
        List<Integer> roleIdList = null;
        List<String> organizeIdList = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)roleIds)) {
            roleIdList = Arrays.asList(roleIds.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)organizeIds)) {
            organizeIdList = Arrays.asList(organizeIds.split(",")).stream().collect(Collectors.toList());
        }
        List<Integer> currentUserPrivilegeUserIds = this.userUtilService.getUserIdsMapByPrivilegeUserId(user.getGroupId(), user.getId(), userStatus, roleIdList, organizeIdList);
        TrainingCourseVo courseVo = new TrainingCourseVo();
        BeanUtils.copyProperties((Object)course, (Object)courseVo);
        HashMap userTaskMap = new HashMap();
        ArrayList<TrainingCourseUserTaskVo> learningUserTaskVos = new ArrayList<TrainingCourseUserTaskVo>();
        ArrayList<TrainingCourseUserTaskVo> finishedUserTaskVos = new ArrayList<TrainingCourseUserTaskVo>();
        ArrayList unLearnUsers = new ArrayList();
        userTaskMap.put("learning", learningUserTaskVos);
        userTaskMap.put("finished", finishedUserTaskVos);
        userTaskMap.put("unLearn", unLearnUsers);
        courseVo.setUserTaskMap(userTaskMap);
        if (CollectionUtils.isEmpty(currentUserPrivilegeUserIds)) {
            return courseVo;
        }
        List<Integer> coursePrivilegeUserIds = new ArrayList<Integer>(currentUserPrivilegeUserIds);
        if (course.getAppointType().equals(1)) {
            List<Integer> courseAllUserIds = this.getCourseAllUserIds(user, courseId, userStatus);
            coursePrivilegeUserIds.retainAll(courseAllUserIds);
            if (!CollectionUtils.isEmpty(coursePrivilegeUserIds)) {
                coursePrivilegeUserIds = coursePrivilegeUserIds.stream().distinct().collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty(coursePrivilegeUserIds)) {
            return courseVo;
        }
        Map<Integer, List<TrainingCourseUserTask>> trainingCourseUserTaskMap = this.getTrainingCourseUserTaskMap(user, courseId, coursePrivilegeUserIds);
        Map<Integer, TrainingCourseStageTask> courseStageTaskMap = this.getTrainingCourseStageTaskMap(user, courseId, coursePrivilegeUserIds);
        Map<Integer, List<TrainingPaperUserTurns>> trainingPaperUserTurnsMap = this.getUserTurnsMap(courseId);
        Map<Integer, UserOrganizeAndDepVo> userOrganizeAndDepVoMap = this.userUtilService.getUserOrganizeAndDepVoMap(user.getGroupId(), coursePrivilegeUserIds);
        ArrayList<Integer> learningUserIds = new ArrayList<Integer>();
        ArrayList<Integer> finishedUserIds = new ArrayList<Integer>();
        int userTaskSize = !CollectionUtils.isEmpty(courseStageTaskMap) ? courseStageTaskMap.size() : 0;
        for (Integer userId : coursePrivilegeUserIds) {
            List<TrainingCourseUserTask> trainingCourseUserTaskVos = trainingCourseUserTaskMap.get(userId);
            if (CollectionUtils.isEmpty(trainingCourseUserTaskVos)) continue;
            TrainingCourseStatisticalServiceImpl.turnsUserTaskFilter(userId, trainingPaperUserTurnsMap, trainingCourseUserTaskVos, courseStageTaskMap);
            if (CollectionUtils.isEmpty(trainingCourseUserTaskVos)) continue;
            Integer userTaskPassNum = 0;
            Integer userTaskUnPassNum = 0;
            for (TrainingCourseUserTask taskVo : trainingCourseUserTaskVos) {
                Integer n;
                Integer n2;
                if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4) {
                    n2 = userTaskPassNum;
                    n = userTaskPassNum = Integer.valueOf(userTaskPassNum + 1);
                    continue;
                }
                if (taskVo.getTaskStatus() != 5) continue;
                n2 = userTaskUnPassNum;
                n = userTaskUnPassNum = Integer.valueOf(userTaskUnPassNum + 1);
            }
            TrainingCourseUserTaskVo userTaskVo = new TrainingCourseUserTaskVo();
            userTaskVo.setUserId(userId);
            UserOrganizeAndDepVo userOrganizeAndDepVo = userOrganizeAndDepVoMap.get(userId);
            userTaskVo.setUserName(userOrganizeAndDepVo.getUserName());
            userTaskVo.setThumbUrl(userOrganizeAndDepVo.getThumbUrl());
            userTaskVo.setOrganizeName(userOrganizeAndDepVo.getOrganizeName());
            userTaskVo.setTaskNum(Integer.valueOf(userTaskSize));
            userTaskVo.setFinishNum(userTaskPassNum);
            userTaskVo.setLearnRate(new BigDecimal(userTaskPassNum).divide(new BigDecimal(userTaskSize), 4, 4));
            if (userTaskPassNum + userTaskUnPassNum == userTaskSize) {
                if (userTaskPassNum == userTaskSize) {
                    finishedUserIds.add(userId);
                    trainingCourseUserTaskVos.stream().filter(it -> it.getEndTime() != null).map(it -> it.getEndTime()).max(Date::compareTo).ifPresent(endTime -> userTaskVo.setEndTime(endTime));
                    finishedUserTaskVos.add(userTaskVo);
                    continue;
                }
                learningUserIds.add(userId);
                learningUserTaskVos.add(userTaskVo);
                continue;
            }
            learningUserIds.add(userId);
            learningUserTaskVos.add(userTaskVo);
        }
        List unLearnUserIds = TrainingCourseStatisticalServiceImpl.differenceList(coursePrivilegeUserIds, finishedUserIds);
        unLearnUserIds = TrainingCourseStatisticalServiceImpl.differenceList(unLearnUserIds, learningUserIds);
        Integer unLearnSize = 0;
        if (!CollectionUtils.isEmpty((Collection)unLearnUserIds)) {
            unLearnSize = unLearnUserIds.size();
            unLearnUsers.addAll(unLearnUserIds.stream().map(it -> {
                TrainingCourseUserTaskVo userTaskVo = new TrainingCourseUserTaskVo();
                UserOrganizeAndDepVo userOrganizeAndDepVo = (UserOrganizeAndDepVo)userOrganizeAndDepVoMap.get(it);
                userTaskVo.setUserId(it);
                userTaskVo.setUserName(userOrganizeAndDepVo.getUserName());
                userTaskVo.setThumbUrl(userOrganizeAndDepVo.getThumbUrl());
                userTaskVo.setOrganizeName(userOrganizeAndDepVo.getOrganizeName());
                return userTaskVo;
            }).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(finishedUserTaskVos)) {
            finishedUserTaskVos.stream().sorted(Comparator.comparing(TrainingCourseUserTaskVo::getEndTime)).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(learningUserTaskVos)) {
            learningUserTaskVos.stream().sorted(Comparator.comparing(TrainingCourseUserTaskVo::getLearnRate)).collect(Collectors.toList());
        }
        courseVo.setAllCount(Integer.valueOf(coursePrivilegeUserIds.size()));
        courseVo.setNotCount(unLearnSize);
        courseVo.setGoingCount(Integer.valueOf(learningUserIds.size()));
        courseVo.setFinishNum(Integer.valueOf(finishedUserIds.size()));
        BigDecimal finishRate = courseVo.getFinishNum() <= 0 ? BigDecimal.ZERO : new BigDecimal(courseVo.getFinishNum()).divide(new BigDecimal(courseVo.getAllCount()), 4, 4);
        courseVo.setFinishRate(finishRate);
        BigDecimal unLearnRate = courseVo.getNotCount() <= 0 ? BigDecimal.ZERO : new BigDecimal(courseVo.getNotCount()).divide(new BigDecimal(courseVo.getAllCount()), 4, 4);
        courseVo.setUnLearnRate(unLearnRate);
        BigDecimal learnRate = courseVo.getGoingCount() <= 0 ? BigDecimal.ZERO : new BigDecimal(courseVo.getGoingCount()).divide(new BigDecimal(courseVo.getAllCount()), 4, 4);
        courseVo.setLearningRate(learnRate);
        return courseVo;
    }

    private Map<Integer, List<TrainingPaperUserTurns>> getUserTurnsMap(Integer courseId) {
        Map<Integer, List<TrainingPaperUserTurns>> trainingPaperUserTurnsMap = new HashMap<Integer, List<TrainingPaperUserTurns>>();
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingPaperUserTurns::getProjectId, (Object)courseId)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
        List trainingPaperUserTurnsList = this.trainingPaperUserTurnsMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingPaperUserTurnsList)) {
            trainingPaperUserTurnsMap = trainingPaperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
        }
        return trainingPaperUserTurnsMap;
    }

    private Map<Integer, TrainingCourseStageTask> getTrainingCourseStageTaskMap(Users user, Integer courseId, List<Integer> coursePrivilegeUserIds) {
        Map<Integer, Object> courseStageTaskMap = new HashMap<Integer, TrainingCourseStageTask>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)courseId);
        List trainingCourseStageTasks = this.trainingCourseStageTaskMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTasks)) {
            courseStageTaskMap = trainingCourseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
        }
        return courseStageTaskMap;
    }

    private Map<Integer, List<TrainingCourseUserTask>> getTrainingCourseUserTaskMap(Users user, Integer courseId, List<Integer> coursePrivilegeUserIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourseUserTask::getEnterpriseId, (Object)user.getGroupId());
        wrapper.eq(TrainingCourseUserTask::getCourseId, (Object)courseId);
        wrapper.in(TrainingCourseUserTask::getUserId, coursePrivilegeUserIds);
        List trainingCourseUserTasks = this.trainingCourseUserTaskMapper.selectList((Wrapper)wrapper);
        Map<Integer, List<TrainingCourseUserTask>> trainingCourseUserTaskMap = new HashMap<Integer, List<TrainingCourseUserTask>>();
        if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTasks)) {
            trainingCourseUserTaskMap = trainingCourseUserTasks.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
        }
        return trainingCourseUserTaskMap;
    }

    private List<Integer> getCourseAllUserIds(Users user, Integer courseId, Integer userStatus) {
        LambdaQueryWrapper trainingCourseUserQueryWrapper = new LambdaQueryWrapper();
        trainingCourseUserQueryWrapper.eq(TrainingCourseUser::getCourseId, (Object)courseId);
        trainingCourseUserQueryWrapper.eq(TrainingCourseUser::getCourseType, (Object)1);
        List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)trainingCourseUserQueryWrapper);
        ArrayList<String> organizeIdList = null;
        ArrayList<Integer> userIdList = null;
        ArrayList<Integer> roleIdList = null;
        ArrayList<Integer> tagIdList = null;
        for (TrainingCourseUser trainingCourseUser : courseUserList) {
            if (trainingCourseUser.getUserId() != null) {
                if (userIdList == null) {
                    userIdList = new ArrayList<Integer>();
                }
                userIdList.add(trainingCourseUser.getUserId());
                continue;
            }
            if (trainingCourseUser.getRoleId() != null) {
                if (roleIdList == null) {
                    roleIdList = new ArrayList<Integer>();
                }
                roleIdList.add(trainingCourseUser.getRoleId());
                continue;
            }
            if (trainingCourseUser.getOrganizeId() != null) {
                if (organizeIdList == null) {
                    organizeIdList = new ArrayList<String>();
                }
                organizeIdList.add(trainingCourseUser.getOrganizeId());
                continue;
            }
            if (trainingCourseUser.getTagId() == null) continue;
            if (tagIdList == null) {
                tagIdList = new ArrayList<Integer>();
            }
            tagIdList.add(trainingCourseUser.getTagId());
        }
        List<Integer> allEnterpriseUserIds = userStatus != null && userStatus.equals(1) ? this.userUtilService.getResignUserByGroupId(user.getGroupId()) : this.userUtilService.getUserListByGroupId(user.getGroupId());
        List<Integer> roleAndUserIds = this.userUtilService.selectUsersByRoles(roleIdList, user.getGroupId());
        List<Integer> tagAndUserIds = this.userUtilService.selectUserIdsByTagIds(tagIdList, user.getGroupId(), user.getId());
        List<Integer> organizeAndUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdList, user.getGroupId());
        ArrayList<Integer> courseAllUserIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(userIdList)) {
            userIdList.retainAll(allEnterpriseUserIds);
            courseAllUserIds.addAll(userIdList);
        }
        if (!CollectionUtils.isEmpty(roleAndUserIds)) {
            courseAllUserIds.addAll(roleAndUserIds);
        }
        if (!CollectionUtils.isEmpty(tagAndUserIds)) {
            courseAllUserIds.addAll(tagAndUserIds);
        }
        if (!CollectionUtils.isEmpty(organizeAndUserIds)) {
            courseAllUserIds.addAll(organizeAndUserIds);
        }
        return courseAllUserIds;
    }

    private List<Integer> getCurrentUserPrivilegeUserIds(Users user, String roleIds, String organizeIds) {
        List<Integer> currentUserPrivilegeUserIds = this.userUtilService.selectChildUserList(null, user, Boolean.FALSE);
        if (!org.springframework.util.StringUtils.isEmpty((Object)roleIds)) {
            List<Integer> roleIdsList = Arrays.asList(roleIds.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList());
            List<Integer> roleUserIds = this.userUtilService.selectUsersByRoles(roleIdsList, user.getGroupId());
            currentUserPrivilegeUserIds.retainAll(roleUserIds);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)organizeIds)) {
            List<String> organizeIdsList = Arrays.asList(organizeIds.split(","));
            List<Integer> organizeUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdsList, user.getGroupId());
            currentUserPrivilegeUserIds.retainAll(organizeUserIds);
        }
        return currentUserPrivilegeUserIds;
    }

    private static List differenceList(List obejctList, List compareList) {
        ArrayList differenceList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)obejctList)) {
            differenceList.addAll(obejctList);
            if (!CollectionUtils.isEmpty((Collection)compareList)) {
                differenceList.removeAll(compareList);
            }
        }
        return differenceList;
    }

    @Override
    public String getOpenCourseList(Integer enterpriseId, Date startDate, Date endDate) {
        List list;
        ArrayList<OpenCourse> result = new ArrayList<OpenCourse>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.gt(TrainingCourse::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.lt(TrainingCourse::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.trainingCourseMapper.selectList((Wrapper)wrapper)))) {
            for (TrainingCourse course : list) {
                com.ovopark.organize.common.base.BaseResult simplePojoBaseResult;
                OpenCourse vo = new OpenCourse();
                vo.setCourseId(course.getId());
                vo.setCourseName(course.getCourseName());
                vo.setStartTime(course.getStartTime());
                vo.setEndTime(course.getEndTime());
                vo.setDescription(course.getDescription());
                LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                taskWrapper.eq(TrainingCourseStageTask::getCourseId, (Object)course.getId());
                List taskList = this.courseStageTaskMapper.selectList((Wrapper)taskWrapper);
                if (!CollectionUtils.isEmpty((Collection)taskList)) {
                    vo.setStageTaskNum(taskList.size());
                }
                vo.setStatus(course.getStatus());
                vo.setCreator(course.getCreater());
                vo.setCreateTime(course.getCreateTime());
                List<Object> appointNumsList = new ArrayList();
                if (!(course.getStatus() == 3 && course.getAppointType() == 1 || (simplePojoBaseResult = this.userApi.getSimpleUserByKeyWord(course.getEnterpriseId(), null, null)) == null || CollectionUtils.isEmpty((Collection)((Collection)simplePojoBaseResult.getData())))) {
                    appointNumsList = ((List)simplePojoBaseResult.getData()).stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(appointNumsList)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    com.ovopark.organize.common.base.BaseResult base = this.userApi.getUserGtCreateTime(course.getEnterpriseId(), format.format(course.getEndTime()));
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        List userRemoveList = (List)base.getData();
                        appointNumsList.removeAll(userRemoveList);
                    }
                }
                List<Object> allIds = new ArrayList();
                if (!org.springframework.util.StringUtils.isEmpty((Object)course.getAppointType()) && course.getAppointType() == 1) {
                    List tagIds;
                    List organizeIds;
                    DepAndTagsPojo pojo;
                    String roleIdStr;
                    BaseResult baseResult;
                    List roleIds;
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getCourseId, (Object)course.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
                    List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper1);
                    List userIds = courseUserList.stream().map(TrainingCourseUser::getUserId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(userIds)) {
                        allIds.addAll(userIds);
                    }
                    if (!CollectionUtils.isEmpty(roleIds = courseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && (baseResult = this.useApi.getUserByRoleIds(roleIdStr = StringUtils.join(roleIds, (String)","), course.getEnterpriseId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        pojo = ((List)baseResult.getData()).stream().map(UsersPojo::getId).distinct().collect(Collectors.toList());
                        allIds.addAll((Collection<Object>)pojo);
                    }
                    if (!CollectionUtils.isEmpty(organizeIds = courseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        UsersAndOrgsMo mo = new UsersAndOrgsMo();
                        mo.setGroupId(course.getEnterpriseId());
                        mo.setOrganizeIds(organizeIds);
                        com.ovopark.organize.common.base.BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                        if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                            List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                            allIds.addAll(users);
                        }
                    }
                    if (!CollectionUtils.isEmpty(tagIds = courseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        pojo = new DepAndTagsPojo();
                        pojo.setGroupId(course.getEnterpriseId());
                        pojo.setTagIds(tagIds);
                        pojo.setAllSuperDate(Boolean.valueOf(true));
                        com.ovopark.organize.common.base.BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                        if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                            for (Map map : (List)tagResult.getData()) {
                                Integer id = (Integer)map.get("id");
                                allIds.add(id);
                            }
                        }
                    }
                    allIds = allIds.stream().distinct().collect(Collectors.toList());
                    if (course.getStatus() != 3) {
                        allIds.retainAll(appointNumsList);
                    }
                } else {
                    allIds = appointNumsList;
                }
                vo.setNeedUserList(allIds);
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }
}

