/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExamOptionsMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingExamTypeMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingOptionsMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperRandomMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamOptions;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingExamType;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingOptions;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperRandom;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingExamService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingExamQuestionVo;
import com.ovopark.training.vo.TrainingExamVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingExamServiceImpl
implements TrainingExamService {
    private static final Logger log = LoggerFactory.getLogger(TrainingExamServiceImpl.class);
    @Autowired
    private TrainingExamMapper examMapper;
    @Autowired
    private TrainingExamTypeMapper examTypeMapper;
    @Autowired
    private TrainingExamQuestionMapper examQuestionMapper;
    @Autowired
    private TrainingExamOptionsMapper examOptionsMapper;
    @Autowired
    private TrainingQuestionMapper questionMapper;
    @Autowired
    private TrainingQuestionTypeMapper questionTypeMapper;
    @Autowired
    private TrainingOptionsMapper optionsMapper;
    @Autowired
    private TrainingPaperMapper paperMapper;
    @Autowired
    private TrainingPaperRandomMapper randomMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LogApi logApi;

    @Override
    public Page<TrainingExamVo> selectExamByPage(Page<TrainingExamVo> page, Integer enterpriseId, Integer examTypeId, String name, List<Integer> creaters, String startTime, String endTime, Integer status) {
        List<TrainingExamVo> list = this.examMapper.selectExamByPage(page, enterpriseId, examTypeId, name, creaters, startTime, endTime, status);
        list.forEach(e -> {
            UsersPojo usersPojo2;
            UsersPojo usersPojo1;
            if (e.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo1 = this.userUtilService.selectUser(e.getCreater())))) {
                e.setCreateName(usersPojo1.getShowName());
            }
            if (e.getArchiverId() != null && !ObjectUtils.isEmpty((Object)(usersPojo2 = this.userUtilService.selectUser(e.getArchiverId())))) {
                e.setArchiver(usersPojo2.getShowName());
            }
        });
        page.setContent(list);
        return page;
    }

    @Override
    public Integer insertExam(TrainingExamVo trainingExam) {
        List typeIds;
        Integer examClass = trainingExam.getExamClass();
        if (examClass == 2 && (typeIds = trainingExam.getTypeIds()) != null && typeIds.size() > 0) {
            String trainingQuestion = String.join((CharSequence)",", typeIds.stream().map(String::valueOf).collect(Collectors.toList()));
            trainingExam.setTrainingQuestion(trainingQuestion);
        }
        if (trainingExam.getId() == null) {
            trainingExam.setExamVersion(Integer.valueOf(1));
            this.examMapper.insert(trainingExam);
        } else {
            this.examMapper.updateById(trainingExam);
            if (examClass == 1) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingExamQuestion::getExamId, (Object)trainingExam.getId());
                List quesList = this.examQuestionMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)quesList)) {
                    List collect = quesList.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
                    LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                    wrappers.in(TrainingExamOptions::getExamQuestionId, collect);
                    List opList = this.examOptionsMapper.selectList((Wrapper)wrappers);
                    if (!CollectionUtils.isEmpty((Collection)opList)) {
                        List collects = opList.stream().map(TrainingExamOptions::getId).collect(Collectors.toList());
                        this.examOptionsMapper.deleteBatchIds(collects);
                    }
                    this.examQuestionMapper.deleteBatchIds(collect);
                }
            } else {
                LambdaUpdateWrapper wrapperUp = new LambdaUpdateWrapper();
                wrapperUp.eq(TrainingPaperRandom::getExamId, (Object)trainingExam.getId());
                this.randomMapper.delete((Wrapper)wrapperUp);
            }
        }
        List questionList = trainingExam.getQuestionList();
        ArrayList<TrainingExamQuestion> examQuestionList = new ArrayList<TrainingExamQuestion>();
        if (!CollectionUtils.isEmpty((Collection)questionList)) {
            if (examClass == 1) {
                for (int i = 0; i < questionList.size(); ++i) {
                    TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(((TrainingQuestionVo)questionList.get(i)).getId());
                    TrainingExamQuestion examQuestion = new TrainingExamQuestion();
                    examQuestion.setExamId(trainingExam.getId());
                    examQuestion.setQuestionId(trainingQuestion.getId());
                    examQuestion.setContent(trainingQuestion.getName());
                    examQuestion.setQuestionType(trainingQuestion.getQuestionType());
                    examQuestion.setScore(new BigDecimal(((TrainingQuestionVo)questionList.get(i)).getScore()));
                    examQuestion.setEnterpriseId(trainingExam.getEnterpriseId());
                    examQuestion.setCreater(trainingExam.getCreater());
                    examQuestion.setCreateTime(new Date());
                    examQuestion.setPicturePath(trainingQuestion.getPicturePath());
                    examQuestion.setRemark(trainingQuestion.getRemark());
                    examQuestion.setIsUpload(trainingQuestion.getIsUpload());
                    examQuestionList.add(examQuestion);
                }
                this.examQuestionMapper.insertList(examQuestionList);
                ArrayList<TrainingExamOptions> optionsList = new ArrayList<TrainingExamOptions>();
                for (TrainingExamQuestion examQuestion : examQuestionList) {
                    if (examQuestion.getQuestionType() == 4) {
                        TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(examQuestion.getQuestionId());
                        TrainingExamOptions examOptions = new TrainingExamOptions();
                        examOptions.setExamQuestionId(examQuestion.getId());
                        examOptions.setContent(trainingQuestion.getIsCorrect().toString());
                        examOptions.setIsAnswer(Integer.valueOf(1));
                        examOptions.setCreateTime(new Date());
                        examOptions.setCreater(trainingExam.getCreater());
                        optionsList.add(examOptions);
                        continue;
                    }
                    List<TrainingOptionsVo> opList = this.optionsMapper.selectVoByQuestionId(examQuestion.getQuestionId());
                    if (CollectionUtils.isEmpty(opList)) continue;
                    for (TrainingOptionsVo optionsVo : opList) {
                        TrainingExamOptions examOptions = new TrainingExamOptions();
                        examOptions.setExamQuestionId(examQuestion.getId());
                        examOptions.setContent(optionsVo.getOptionsName());
                        examOptions.setIsAnswer(optionsVo.getIsAnswer());
                        examOptions.setCreateTime(new Date());
                        examOptions.setCreater(trainingExam.getCreater());
                        examOptions.setPicturePath(optionsVo.getPicturePath());
                        optionsList.add(examOptions);
                    }
                }
                if (!CollectionUtils.isEmpty(optionsList)) {
                    this.examOptionsMapper.insertList(optionsList);
                }
            } else {
                List typeIds2 = trainingExam.getTypeIds();
                for (int j = 0; j < questionList.size(); ++j) {
                    TrainingPaperRandom random = new TrainingPaperRandom();
                    random.setExamId(trainingExam.getId());
                    random.setQuestionType(((TrainingQuestionVo)questionList.get(j)).getQuestionType());
                    random.setQuestionTypeNum(Integer.valueOf(((TrainingQuestionVo)questionList.get(j)).getQuestionSize()));
                    random.setQuestionScore(new BigDecimal(Double.toString(((TrainingQuestionVo)questionList.get(j)).getScore())));
                    this.randomMapper.insert(random);
                }
            }
        }
        return trainingExam.getId();
    }

    @Override
    public void updateExam(TrainingExamVo trainingExam) {
        this.examMapper.updateById(trainingExam);
    }

    @Override
    public List<TrainingQuestionVo> selectRandomQuestion(TrainingExamVo trainingExam) {
        ArrayList<TrainingQuestionVo> questionListVo = new ArrayList<TrainingQuestionVo>();
        List questionList = trainingExam.getQuestionList();
        List typeIds = trainingExam.getTypeIds();
        for (int j = 0; j < questionList.size(); ++j) {
            List<TrainingQuestion> qList = this.questionMapper.selectRandByQuestionTypes(((TrainingQuestionVo)questionList.get(j)).getQuestionType(), trainingExam.getEnterpriseId(), ((TrainingQuestionVo)questionList.get(j)).getQuestionSize(), typeIds);
            for (int m = 0; m < qList.size(); ++m) {
                TrainingQuestion trainingQuestion = qList.get(m);
                TrainingQuestionVo trainingQuestionVo = new TrainingQuestionVo();
                trainingQuestionVo.setId(trainingQuestion.getId());
                trainingQuestionVo.setQuestionName(trainingQuestion.getName());
                trainingQuestionVo.setQuestionType(trainingQuestion.getQuestionType());
                trainingQuestionVo.setPicturePath(trainingQuestion.getPicturePath());
                trainingQuestionVo.setScore(((TrainingQuestionVo)questionList.get(j)).getScore());
                trainingQuestionVo.setIsCorrect(trainingQuestion.getIsCorrect());
                trainingQuestionVo.setEnterpriseId(trainingExam.getEnterpriseId());
                questionListVo.add(trainingQuestionVo);
            }
        }
        for (TrainingQuestionVo trainingQuestionVo : questionListVo) {
            List<TrainingOptionsVo> opList = this.optionsMapper.selectVoByQuestionId(trainingQuestionVo.getId());
            trainingQuestionVo.setOptionsList(opList);
        }
        return questionListVo;
    }

    @Override
    public Map selectPaperExam(Integer examId) {
        HashMap<String, Serializable> paper = new HashMap<String, Serializable>();
        LambdaQueryWrapper wrap = new LambdaQueryWrapper();
        wrap.eq(TrainingPaper::getExamId, (Object)examId);
        List papersList = this.paperMapper.selectList((Wrapper)wrap);
        if (!CollectionUtils.isEmpty((Collection)papersList)) {
            BaseResult base;
            List userIds = papersList.stream().map(TrainingPaper::getCreater).distinct().collect(Collectors.toList());
            Map<Object, Object> userMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getSimpleUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                userMap = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            }
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
            String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
            String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
            String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
            String going = this.messageSource.getMessage("training.job.status.going", null, locale);
            String closed = this.messageSource.getMessage("training.job.status.closed", null, locale);
            String end = this.messageSource.getMessage("training.job.status.end", null, locale);
            String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
            ArrayList paperList = new ArrayList();
            for (TrainingPaper trainingPaper : papersList) {
                HashMap<String, Object> paperMap = new HashMap<String, Object>();
                paperMap.put("id", trainingPaper.getId());
                paperMap.put("creater", trainingPaper.getCreater());
                paperMap.put("createrName", userMap.get(trainingPaper.getCreater()) == null ? "" : ((SimplePojo)userMap.get(trainingPaper.getCreater())).getName());
                paperMap.put("creatTime", trainingPaper.getCreateTime());
                paperMap.put("taskName", "-");
                if (trainingPaper.getPaperState() != null) {
                    if (trainingPaper.getPaperState().equals(0)) {
                        paperMap.put("status", draft);
                    } else if (trainingPaper.getPaperState().equals(1)) {
                        paperMap.put("status", this.messageSource.getMessage("training.paper.exam.wait", null, locale));
                    } else if (trainingPaper.getPaperState().equals(2)) {
                        paperMap.put("status", this.messageSource.getMessage("training.paper.exam.starting", null, locale));
                    } else if (trainingPaper.getPaperState().equals(3)) {
                        paperMap.put("status", end);
                    }
                }
                paperMap.put("title", trainingPaper.getTitle());
                paperMap.put("examId", trainingPaper.getExamId());
                paperList.add(paperMap);
                LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
                attachWrapper.eq(TrainingChapterAttach::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                ((LambdaQueryWrapper)attachWrapper.eq(TrainingChapterAttach::getPaperId, (Object)trainingPaper.getId())).eq(TrainingChapterAttach::getIsDel, (Object)0);
                List list = this.trainingChapterAttachMapper.selectList((Wrapper)attachWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    for (TrainingChapterAttach trainingChapterAttach : list) {
                        TrainingChapter chapter = (TrainingChapter)this.trainingChapterMapper.selectById(trainingChapterAttach.getChapterId());
                        if (chapter == null) continue;
                        Training training = (Training)this.trainingMapper.selectById(chapter.getTrainingId());
                        if (training != null) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("id", trainingPaper.getId());
                            map.put("creater", trainingPaper.getCreater());
                            map.put("createrName", userMap.get(trainingPaper.getCreater()) == null ? "" : ((SimplePojo)userMap.get(trainingPaper.getCreater())).getName());
                            map.put("creatTime", trainingPaper.getCreateTime());
                            map.put("taskName", "[" + trainName + "]" + training.getTitle());
                            if (training.getStatus() != null) {
                                if (training.getStatus().equals(0)) {
                                    map.put("status", draft);
                                } else if (training.getStatus().equals(1)) {
                                    map.put("status", this.messageSource.getMessage("training.paper.deactivate", null, locale));
                                } else if (training.getStatus().equals(2)) {
                                    map.put("status", this.messageSource.getMessage("training.paper.activate", null, locale));
                                }
                            }
                            map.put("title", trainingPaper.getTitle());
                            map.put("examId", trainingPaper.getExamId());
                            paperList.add(map);
                            continue;
                        }
                        this.trainingChapterMapper.deleteById((Serializable)chapter);
                        this.trainingChapterAttachMapper.delete((Wrapper)attachWrapper);
                    }
                }
                LambdaQueryWrapper courseTaskWrapper = new LambdaQueryWrapper();
                courseTaskWrapper.eq(TrainingCourseStageTask::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                courseTaskWrapper.eq(TrainingCourseStageTask::getPaperId, (Object)trainingPaper.getId());
                List courseTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)courseTaskWrapper);
                if (!CollectionUtils.isEmpty((Collection)courseTaskList)) {
                    for (TrainingCourseStageTask trainingCourseStageTask : courseTaskList) {
                        TrainingCourse course = (TrainingCourse)this.trainingCourseMapper.selectById(trainingCourseStageTask.getCourseId());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", trainingPaper.getId());
                        map.put("creater", trainingPaper.getCreater());
                        map.put("createrName", userMap.get(trainingPaper.getCreater()) == null ? "" : ((SimplePojo)userMap.get(trainingPaper.getCreater())).getName());
                        map.put("creatTime", trainingPaper.getCreateTime());
                        map.put("taskName", "[" + courseName + "]" + course.getCourseName());
                        if (course.getStatus() != null) {
                            if (course.getStatus().equals(0)) {
                                map.put("status", draft);
                            } else if (course.getStatus().equals(1)) {
                                map.put("status", unStart);
                            } else if (course.getStatus().equals(2)) {
                                map.put("status", going);
                            } else if (course.getStatus().equals(3)) {
                                map.put("status", ended);
                            }
                        }
                        map.put("title", trainingPaper.getTitle());
                        map.put("examId", trainingPaper.getExamId());
                        paperList.add(map);
                    }
                }
                LambdaQueryWrapper taskScheduleWrapper = new LambdaQueryWrapper();
                taskScheduleWrapper.eq(TrainingTaskSchedule::getPaperIdOld, (Object)trainingPaper.getId());
                List taskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)taskScheduleWrapper);
                if (!CollectionUtils.isEmpty((Collection)taskScheduleList)) {
                    for (TrainingTaskSchedule trainingTaskSchedule : taskScheduleList) {
                        TrainingLearnProject project = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingTaskSchedule.getProjectId());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", trainingPaper.getId());
                        map.put("creater", trainingPaper.getCreater());
                        map.put("createrName", userMap.get(trainingPaper.getCreater()) == null ? "" : ((SimplePojo)userMap.get(trainingPaper.getCreater())).getName());
                        map.put("creatTime", trainingPaper.getCreateTime());
                        map.put("taskName", "[" + learnName + "]" + project.getProjectName());
                        if (project.getProjectName() != null) {
                            if (project.getStatus().equals(0)) {
                                map.put("status", draft);
                            } else if (project.getStatus().equals(1)) {
                                map.put("status", going);
                            } else if (project.getStatus().equals(2)) {
                                map.put("status", closed);
                            }
                        }
                        map.put("title", trainingPaper.getTitle());
                        map.put("examId", trainingPaper.getExamId());
                        paperList.add(map);
                    }
                }
                LambdaQueryWrapper jobTaskWrapper = new LambdaQueryWrapper();
                jobTaskWrapper.eq(TrainingJobStageTask::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                jobTaskWrapper.eq(TrainingJobStageTask::getPaperId, (Object)trainingPaper.getId());
                List jobTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)jobTaskWrapper);
                if (CollectionUtils.isEmpty((Collection)jobTaskList)) continue;
                for (TrainingJobStageTask trainingJobStageTask : jobTaskList) {
                    TrainingJobCertification job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(trainingJobStageTask.getJobId());
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", trainingPaper.getId());
                    map.put("creater", trainingPaper.getCreater());
                    map.put("createrName", userMap.get(trainingPaper.getCreater()) == null ? "" : ((SimplePojo)userMap.get(trainingPaper.getCreater())).getName());
                    map.put("creatTime", trainingPaper.getCreateTime());
                    map.put("taskName", "[" + jobName + "]" + job.getCertificationName());
                    if (job.getStatus() != null) {
                        if (job.getStatus().equals(0)) {
                            map.put("status", draft);
                        } else if (job.getStatus().equals(1)) {
                            map.put("status", this.messageSource.getMessage("training.paper.activate", null, locale));
                        } else if (job.getStatus().equals(2)) {
                            map.put("status", this.messageSource.getMessage("training.paper.deactivate", null, locale));
                        }
                    }
                    map.put("title", trainingPaper.getTitle());
                    map.put("examId", trainingPaper.getExamId());
                    paperList.add(map);
                }
            }
            if (CollectionUtils.isEmpty(paperList)) {
                paper.put("isDelete", Integer.valueOf(1));
            } else {
                paper.put("isDelete", Integer.valueOf(0));
            }
            paper.put("paperList", paperList);
        } else {
            paper.put("isDelete", Integer.valueOf(1));
        }
        return paper;
    }

    @Override
    public String deleteExam(Integer examId, LogPojo pojo) {
        TrainingExam exam = (TrainingExam)this.examMapper.selectById(examId);
        if (!pojo.getEnterpriseId().equals(exam.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        if (!ObjectUtils.isEmpty((Object)exam)) {
            if (exam.getExamClass() == 1) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingExamQuestion::getExamId, (Object)examId);
                List quesList = this.examQuestionMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)quesList)) {
                    List questionIds = quesList.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
                    LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                    wrappers.in(TrainingExamOptions::getExamQuestionId, questionIds);
                    List opList = this.examOptionsMapper.selectList((Wrapper)wrappers);
                    if (!CollectionUtils.isEmpty((Collection)opList)) {
                        List optionIds = opList.stream().map(TrainingExamOptions::getId).collect(Collectors.toList());
                        this.examOptionsMapper.deleteBatchIds(optionIds);
                    }
                    this.examQuestionMapper.deleteBatchIds(questionIds);
                }
            } else {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(TrainingPaperRandom::getExamId, (Object)examId);
                this.randomMapper.delete((Wrapper)wrapper);
            }
        }
        this.examMapper.deleteById(examId);
        pojo.setI18nParam(exam.getName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public List<Map> selectQuestionTypeId(Integer enterpriseId, List<Integer> typeIds, String title, Integer materialId) {
        List<Map> typeList = this.examMapper.selectQuestionTypeId(enterpriseId, typeIds, title, materialId);
        return typeList;
    }

    @Override
    public List<Map> selectQuestionType(Integer enterpriseId, List<Integer> typeIds) {
        List<Map> typeList = this.examMapper.selectQuestionType(enterpriseId, typeIds);
        return typeList;
    }

    @Override
    public List<TrainingExamQuestionVo> selectExamQuestion(Integer examId) {
        ArrayList<TrainingExamQuestionVo> questionVoList;
        block9: {
            TrainingExam exam;
            block10: {
                exam = (TrainingExam)this.examMapper.selectById(examId);
                questionVoList = new ArrayList<TrainingExamQuestionVo>();
                if (ObjectUtils.isEmpty((Object)exam)) break block9;
                if (exam.getExamClass() != 1) break block10;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingExamQuestion::getExamId, (Object)examId);
                wrapper.orderByAsc(TrainingExamQuestion::getQuestionType);
                List examQuestionList = this.examQuestionMapper.selectList((Wrapper)wrapper);
                for (TrainingExamQuestion examQuestion : examQuestionList) {
                    TrainingExamQuestionVo vo = new TrainingExamQuestionVo();
                    BeanUtils.copyProperties((Object)examQuestion, (Object)vo);
                    LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                    wrappers.eq(TrainingExamOptions::getExamQuestionId, (Object)vo.getId());
                    List optionsList = this.examOptionsMapper.selectList((Wrapper)wrappers);
                    if (examQuestion.getQuestionType() == 4 && !CollectionUtils.isEmpty((Collection)optionsList)) {
                        TrainingExamOptions options = (TrainingExamOptions)optionsList.get(0);
                        options.setIsAnswer(Integer.valueOf(options.getContent()));
                    }
                    vo.setOptionsList(optionsList);
                    questionVoList.add(vo);
                }
                break block9;
            }
            List<Integer> typeIds = new ArrayList<Integer>();
            if (exam.getTrainingQuestion() != null) {
                String[] typeStr = exam.getTrainingQuestion().split(",");
                typeIds = Arrays.asList(typeStr).stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            List<TrainingOptionsVo> trainingOptionsVos = this.optionsMapper.selectQuestionByTypeId(exam.getEnterpriseId(), typeIds);
            Map<Integer, List> trainingOptionsVoMap = trainingOptionsVos.stream().collect(Collectors.toMap(TrainingOptionsVo::getQuestionId, e -> new ArrayList<TrainingOptionsVo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingPaperRandom::getExamId, (Object)examId);
            List randomList = this.randomMapper.selectList((Wrapper)wrapper);
            if (randomList == null || randomList.size() <= 0) break block9;
            for (int i = 0; i < randomList.size(); ++i) {
                List<TrainingQuestion> qList = this.questionMapper.selectRandByQuestionTypes(((TrainingPaperRandom)randomList.get(i)).getQuestionType(), exam.getEnterpriseId(), ((TrainingPaperRandom)randomList.get(i)).getQuestionTypeNum(), typeIds);
                if (qList == null || qList.size() <= 0) continue;
                for (int j = 0; j < qList.size(); ++j) {
                    TrainingQuestion trainingQuestion = qList.get(j);
                    TrainingExamQuestionVo vo = new TrainingExamQuestionVo();
                    vo.setId(trainingQuestion.getId());
                    vo.setExamId(examId);
                    vo.setQuestionId(trainingQuestion.getId());
                    vo.setQuestionType(trainingQuestion.getQuestionType());
                    vo.setContent(trainingQuestion.getName());
                    vo.setScore(((TrainingPaperRandom)randomList.get(i)).getQuestionScore());
                    vo.setEnterpriseId(trainingQuestion.getEnterpriseId());
                    vo.setPicturePath(trainingQuestion.getPicturePath());
                    ArrayList<TrainingExamOptions> optionsList = new ArrayList<TrainingExamOptions>();
                    if (trainingQuestion.getQuestionType() == 4) {
                        TrainingExamOptions examOption = new TrainingExamOptions();
                        examOption.setContent(trainingQuestion.getIsCorrect().toString());
                        examOption.setExamQuestionId(trainingQuestion.getId());
                        examOption.setIsAnswer(trainingQuestion.getIsCorrect());
                        optionsList.add(examOption);
                    } else {
                        List opList = trainingOptionsVoMap.get(trainingQuestion.getId());
                        if (opList != null && opList.size() > 0) {
                            for (TrainingOptionsVo option : opList) {
                                TrainingExamOptions examOption = new TrainingExamOptions();
                                examOption.setContent(option.getOptionsName());
                                examOption.setId(option.getId());
                                examOption.setIsAnswer(option.getIsAnswer());
                                examOption.setExamQuestionId(option.getQuestionId());
                                examOption.setPicturePath(option.getPicturePath());
                                optionsList.add(examOption);
                            }
                        }
                    }
                    vo.setOptionsList(optionsList);
                    questionVoList.add(vo);
                }
            }
        }
        return questionVoList;
    }

    @Override
    public List<Map> selectRandomType(Users user, Integer examId) {
        TrainingExam exam = (TrainingExam)this.examMapper.selectById(examId);
        List<Map> typeList = new ArrayList<Map>();
        if (!StringUtils.isEmpty((Object)exam.getTrainingQuestion())) {
            List<String> exams = Arrays.asList(exam.getTrainingQuestion().split(","));
            List<Integer> typeIds = exams.stream().map(Integer::parseInt).collect(Collectors.toList());
            typeList = this.examMapper.selectQuestionTypeId(user.getGroupId(), typeIds, null, null);
            for (int i = 0; i < typeList.size(); ++i) {
                Map map = typeList.get(i);
                Integer typeId = Integer.parseInt(map.get("typeId").toString());
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(typeId);
                List<Map> questionTypeList = this.examMapper.selectQuestionType(user.getGroupId(), list);
                map.put("questionTypeList", questionTypeList);
            }
        }
        return typeList;
    }

    @Override
    public Page<TrainingQuestionVo> selectQuestionListByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, List<Integer> typeId, String questionName, List<Integer> questionType, Integer isNotType) {
        List<TrainingQuestionVo> questionList = this.examMapper.selectQuestionListByPage(page, enterpriseId, typeId, questionName, questionType, isNotType);
        if (!CollectionUtils.isEmpty(questionList)) {
            List<Integer> questionIdList = questionList.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            Map<Object, Object> optionsMap = new HashMap();
            if (!CollectionUtils.isEmpty(questionIdList)) {
                List<TrainingOptionsVo> optionsList = this.optionsMapper.selectOptionsByQuestionId(questionIdList);
                optionsMap = optionsList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
            for (TrainingQuestionVo questionVo : questionList) {
                questionVo.setOptionsList((List)optionsMap.get(questionVo.getId()));
            }
            page.setContent(questionList);
        }
        return page;
    }

    @Override
    public List<TrainingQuestionVo> selectQuestionById(List<TrainingQuestionVo> questionVo) {
        List<Integer> ids = questionVo.stream().map(TrainingQuestion::getId).collect(Collectors.toList());
        List<TrainingQuestionVo> questionVos = this.examMapper.selectQuestionById(ids);
        if (!CollectionUtils.isEmpty(questionVos)) {
            for (TrainingQuestionVo question : questionVos) {
                question.setOptionsList(this.optionsMapper.selectVoByQuestionId(question.getId()));
            }
        }
        return questionVos;
    }

    @Override
    public List<TrainingExamType> selectExamType(TrainingExamType examType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingExamType::getEnterpriseId, (Object)examType.getEnterpriseId());
        return this.examTypeMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public Map insertExamType(TrainingExamType examType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String isNum = "1";
        List<TrainingExamType> typeList = this.examTypeMapper.selectExamTypeBySameName(examType);
        if (CollectionUtils.isEmpty(typeList)) {
            this.examTypeMapper.insert(examType);
            map.put("examType", examType);
        } else {
            isNum = "0";
        }
        map.put("isNum", isNum);
        return map;
    }

    @Override
    public void deleteExamType(Integer id) {
        this.examTypeMapper.deleteById(id);
    }

    @Override
    public Map<Integer, List<TrainingQuestionVo>> selectQuestionsByExecl(List<Integer> questionIds, Integer typeId, Integer isAll, Integer isNotType, Integer enterpriseId) {
        Map<Integer, List<TrainingQuestionVo>> map = new HashMap<Integer, List<TrainingQuestionVo>>();
        List<Object> questionList = new ArrayList();
        if (isAll != null && isAll == 1) {
            LambdaQueryWrapper wrapper1;
            if (isNotType != null) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.isNull(TrainingQuestion::getTypeId)).isNull(TrainingQuestion::getIsDelete);
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                questionList = this.questionMapper.selectList((Wrapper)wrapper1);
            } else if (typeId != null) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingQuestion::getTypeId, (Object)typeId)).isNull(TrainingQuestion::getIsDelete);
                questionList = this.questionMapper.selectList((Wrapper)wrapper1);
            } else {
                wrapper1 = new LambdaUpdateWrapper();
                wrapper1.isNull(TrainingQuestion::getIsDelete);
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                questionList = this.questionMapper.selectList((Wrapper)wrapper1);
            }
        } else {
            questionList = this.questionMapper.selectByQuestionId(questionIds);
        }
        if (!CollectionUtils.isEmpty(questionList)) {
            List<Integer> questionIdsList = questionList.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            List<TrainingOptionsVo> optionsList = this.optionsMapper.selectOptionsByQuestionId(questionIdsList);
            Map<Object, Object> optionsMap = new HashMap();
            if (!CollectionUtils.isEmpty(optionsList)) {
                optionsMap = optionsList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
            List typeIdList = questionList.stream().map(TrainingQuestion::getTypeId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            Map<Object, Object> typeMap = new HashMap();
            if (!CollectionUtils.isEmpty(typeIdList)) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.in(TrainingQuestionType::getId, typeIdList);
                List typeList = this.questionTypeMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)typeList)) {
                    typeMap = typeList.stream().collect(Collectors.toMap(TrainingQuestionType::getId, Function.identity()));
                }
            }
            ArrayList<TrainingQuestionVo> voList = new ArrayList<TrainingQuestionVo>();
            for (TrainingQuestion trainingQuestion : questionList) {
                TrainingQuestionVo questionVo = new TrainingQuestionVo();
                BeanUtils.copyProperties((Object)trainingQuestion, (Object)questionVo);
                questionVo.setOptionsList((List)optionsMap.get(questionVo.getId()));
                questionVo.setTypeName(StringUtils.isEmpty((Object)typeMap.get(questionVo.getTypeId())) ? null : ((TrainingQuestionType)typeMap.get(questionVo.getTypeId())).getTitle());
                voList.add(questionVo);
            }
            if (!CollectionUtils.isEmpty(voList)) {
                map = voList.stream().collect(Collectors.groupingBy(TrainingQuestion::getQuestionType));
            }
        }
        return map;
    }

    @Override
    public Integer updateCopyExam(Integer examId, Integer userId) {
        Integer id = examId;
        TrainingExam exam = (TrainingExam)this.examMapper.selectById(examId);
        if (!StringUtils.isEmpty((Object)exam) && exam.getExamClass() == 1) {
            exam.setId(null);
            exam.setOriginExamId(examId);
            exam.setCreateTime(new Date());
            exam.setCreater(userId);
            exam.setExamVersion(Integer.valueOf(2));
            this.examMapper.insert(exam);
            id = exam.getId();
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingExamQuestion::getExamId, (Object)examId);
            List questionList = this.examQuestionMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)questionList)) {
                List examQuestionIdList = questionList.stream().map(TrainingExamQuestion::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingExamOptions::getExamQuestionId, examQuestionIdList);
                List examOptionsList = this.examOptionsMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> optionMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)examOptionsList)) {
                    optionMap = examOptionsList.stream().collect(Collectors.groupingBy(TrainingExamOptions::getExamQuestionId));
                }
                ArrayList<TrainingExamOptions> examOptions = new ArrayList<TrainingExamOptions>();
                for (TrainingExamQuestion question : questionList) {
                    List options = (List)optionMap.get(question.getId());
                    question.setId(null);
                    question.setExamId(id);
                    question.setCreateTime(new Date());
                    question.setCreater(userId);
                    this.examQuestionMapper.insert(question);
                    if (CollectionUtils.isEmpty((Collection)options)) continue;
                    for (TrainingExamOptions option : options) {
                        option.setId(null);
                        option.setExamQuestionId(question.getId());
                        option.setCreateTime(new Date());
                        option.setCreater(userId);
                        examOptions.add(option);
                    }
                }
                if (!CollectionUtils.isEmpty(examOptions)) {
                    this.examOptionsMapper.insertList(examOptions);
                }
            }
        }
        return id;
    }

    @Override
    public Page<TrainingPapersVo> selectExamPaperByPage(Page<TrainingPapersVo> page, Integer questionId, String paperName, Users user) {
        List<TrainingExamVo> examList;
        List<Integer> examIds;
        List<Object> papersVoList = new ArrayList();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
        String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
        String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
        String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
        String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
        String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String closed = this.messageSource.getMessage("training.job.status.closed", null, locale);
        String end = this.messageSource.getMessage("training.job.status.end", null, locale);
        String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingExamQuestion::getQuestionId, (Object)questionId);
        List examQuestionList = this.examQuestionMapper.selectList((Wrapper)wrapper1);
        if (!(CollectionUtils.isEmpty((Collection)examQuestionList) || CollectionUtils.isEmpty(examIds = examQuestionList.stream().map(TrainingExamQuestion::getExamId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty(examList = this.examMapper.selectNotVersionList(examIds)))) {
            List<Integer> paperIdList;
            List examIdList = examList.stream().map(TrainingExam::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingPaper::getExamId, examIdList)).in(TrainingPaper::getPaperState, Arrays.asList(0, 1, 2))).like(TrainingPaper::getTitle, (Object)paperName);
            List paperList = this.paperMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)paperList) && !CollectionUtils.isEmpty(papersVoList = this.paperMapper.selectExamPaperByPage(page, paperIdList = paperList.stream().map(TrainingPaper::getId).collect(Collectors.toList())))) {
                List<Integer> createrIds = papersVoList.stream().map(TrainingPaper::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> map = this.userUtilService.selectUserMap(createrIds);
                Iterator<Object> iterator = papersVoList.iterator();
                while (iterator.hasNext()) {
                    TrainingPapersVo vo;
                    UsersPojo pojo = map.get((vo = (TrainingPapersVo)iterator.next()).getCreater());
                    vo.setCreateName(pojo != null ? pojo.getShowName() : "");
                    String statusName = "";
                    String projectName = "";
                    if (vo.getSourceType() == 1) {
                        projectName = "[" + trainName + "]" + vo.getProjectName();
                        statusName = vo.getStatus() == 0 ? draft : (vo.getStatus() == 1 ? this.messageSource.getMessage("training.paper.deactivate", null, locale) : this.messageSource.getMessage("training.paper.activate", null, locale));
                    } else if (vo.getSourceType() == 2) {
                        projectName = "-";
                        statusName = vo.getStatus() == 0 ? draft : (vo.getStatus() == 1 ? this.messageSource.getMessage("training.paper.exam.wait", null, locale) : (vo.getStatus() == 2 ? this.messageSource.getMessage("training.paper.exam.starting", null, locale) : end));
                    } else if (vo.getSourceType() == 3) {
                        projectName = "[" + learnName + "]" + vo.getProjectName();
                        statusName = vo.getStatus() == 0 ? draft : (vo.getStatus() == 1 ? going : closed);
                    } else if (vo.getSourceType() == 4) {
                        projectName = "[" + jobName + "]" + vo.getProjectName();
                        statusName = vo.getStatus() == 0 ? draft : (vo.getStatus() == 1 ? this.messageSource.getMessage("training.paper.activate", null, locale) : this.messageSource.getMessage("training.paper.deactivate", null, locale));
                    } else if (vo.getSourceType() == 5) {
                        projectName = "[" + courseName + "]" + vo.getProjectName();
                        statusName = vo.getStatus() == 0 ? draft : (vo.getStatus() == 1 ? unStart : (vo.getStatus() == 2 ? going : ended));
                    }
                    vo.setStatusName(statusName);
                    vo.setProjectName(projectName);
                }
            }
        }
        page.setContent(papersVoList);
        return page;
    }

    @Override
    public void updateExamQuestion(List<TrainingExamQuestionVo> examQuestionVoList, Users user) {
        if (!CollectionUtils.isEmpty(examQuestionVoList)) {
            Integer isPush = examQuestionVoList.get(0).getIsPush() != null ? examQuestionVoList.get(0).getIsPush() : 0;
            ArrayList<TrainingExamQuestionVo> examIdList = new ArrayList<TrainingExamQuestionVo>();
            List questionIds = examQuestionVoList.stream().map(TrainingExamQuestion::getQuestionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List examIds = examQuestionVoList.stream().map(TrainingExamQuestion::getExamId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List questionList = this.questionMapper.selectBatchIds(questionIds);
            Map<Object, Object> questionMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)questionList)) {
                questionMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingOptions::getTrainingQuestionId, questionIds);
            List optionsList = this.optionsMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> optionMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)optionsList)) {
                optionMap = optionsList.stream().collect(Collectors.groupingBy(TrainingOptions::getTrainingQuestionId));
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.in(TrainingExamQuestion::getExamId, examIds)).in(TrainingExamQuestion::getQuestionId, questionIds);
            List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> examQueationMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)examQuestions)) {
                examQueationMap = examQuestions.stream().collect(Collectors.groupingBy(TrainingExamQuestion::getExamId));
            }
            ArrayList<TrainingExamOptions> examOptionsList = new ArrayList<TrainingExamOptions>();
            for (TrainingExamQuestionVo vo : examQuestionVoList) {
                List trainingExamQuestions = (List)examQueationMap.get(vo.getExamId());
                if (CollectionUtils.isEmpty((Collection)trainingExamQuestions)) continue;
                for (TrainingExamQuestion trainingExamQuestion : trainingExamQuestions) {
                    if (StringUtils.isEmpty((Object)trainingExamQuestion.getQuestionId()) || !trainingExamQuestion.getQuestionId().equals(vo.getQuestionId())) continue;
                    TrainingQuestion trainingQuestion = (TrainingQuestion)questionMap.get(trainingExamQuestion.getQuestionId());
                    trainingExamQuestion.setContent(trainingQuestion.getName());
                    trainingExamQuestion.setPicturePath(trainingQuestion.getPicturePath());
                    trainingExamQuestion.setRemark(trainingQuestion.getRemark());
                    trainingExamQuestion.setIsUpload(trainingQuestion.getIsUpload());
                    this.examQuestionMapper.updateById(trainingExamQuestion);
                    TrainingExamQuestionVo dataVo = new TrainingExamQuestionVo();
                    dataVo.setQuestionId(trainingExamQuestion.getQuestionId());
                    dataVo.setContent(trainingQuestion.getName());
                    dataVo.setExamId(vo.getExamId());
                    examIdList.add(dataVo);
                    LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
                    wrapper4.eq(TrainingExamOptions::getExamQuestionId, (Object)trainingExamQuestion.getId());
                    this.examOptionsMapper.delete((Wrapper)wrapper4);
                    if (trainingExamQuestion.getQuestionType() == 4) {
                        TrainingExamOptions examOptions = new TrainingExamOptions();
                        examOptions.setExamQuestionId(trainingExamQuestion.getId());
                        examOptions.setContent(trainingQuestion.getIsCorrect().toString());
                        examOptions.setIsAnswer(Integer.valueOf(1));
                        examOptions.setCreateTime(new Date());
                        examOptions.setCreater(user.getCreater());
                        examOptionsList.add(examOptions);
                        continue;
                    }
                    List trainingOptionsList = (List)optionMap.get(trainingExamQuestion.getQuestionId());
                    if (CollectionUtils.isEmpty((Collection)trainingOptionsList)) continue;
                    for (TrainingOptions trainingOptions : trainingOptionsList) {
                        TrainingExamOptions examOptions = new TrainingExamOptions();
                        examOptions.setExamQuestionId(trainingExamQuestion.getId());
                        examOptions.setContent(trainingOptions.getName());
                        examOptions.setIsAnswer(trainingOptions.getIsAnswer());
                        examOptions.setCreateTime(new Date());
                        examOptions.setCreater(user.getId());
                        examOptions.setPicturePath(trainingOptions.getPicturePath());
                        examOptionsList.add(examOptions);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(examOptionsList)) {
                this.examOptionsMapper.insertList(examOptionsList);
            }
            if (isPush == null || isPush == 1) {
                // empty if block
            }
        }
    }

    public void sendUpdatePaperQuestion(List<TrainingExamQuestionVo> examIdList, Users user) {
        if (!CollectionUtils.isEmpty(examIdList)) {
            // empty if block
        }
    }
}

