/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingFeeChapterAttachMapper;
import com.ovopark.training.mapper.TrainingFeeChapterMapper;
import com.ovopark.training.mapper.TrainingFeeMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingProcureCourseMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingFee;
import com.ovopark.training.model.TrainingFeeChapter;
import com.ovopark.training.model.TrainingFeeChapterAttach;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingProcureCourse;
import com.ovopark.training.service.TrainingFeeDetailService;
import com.ovopark.training.vo.AppFeeVo;
import com.ovopark.training.vo.TrainingFeeChapterAttachVo;
import com.ovopark.training.vo.TrainingFeeChapterVo;
import com.ovopark.training.vo.TrainingFeeVo;
import com.ovopark.training.vo.TypeFreeListVo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingFeeDetailServiceImpl
implements TrainingFeeDetailService {
    private static final Logger log = LoggerFactory.getLogger(TrainingFeeDetailServiceImpl.class);
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Autowired
    private TrainingFeeMapper trainingFeeMapper;
    @Autowired
    private TrainingFeeChapterMapper trainingFeeChapterMapper;
    @Autowired
    private TrainingFeeChapterAttachMapper trainingFeeChapterAttachMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingProcureCourseMapper trainingProcureCourseMapper;
    @Autowired
    private MessageSource messageSource;

    @Override
    public String getTypeFreeList() {
        ArrayList<TypeFreeListVo> resultList = new ArrayList<TypeFreeListVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingMaterialType::getModuleType, (Object)6);
        wrapper.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
        wrapper.orderByDesc(TrainingMaterialType::getSort);
        List typeList = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)typeList)) {
            for (TrainingMaterialType materialType : typeList) {
                TypeFreeListVo result = new TypeFreeListVo();
                result.setMaterialTypeId(materialType.getId());
                result.setMaterialTypeName(materialType.getMaterialTypeName());
                List<Integer> idList = new ArrayList<Integer>();
                LambdaQueryWrapper typeWrapper = new LambdaQueryWrapper();
                typeWrapper.eq(TrainingMaterialType::getOriginId, (Object)materialType.getId());
                List materTypeList = this.trainingMaterialTypeMapper.selectList((Wrapper)typeWrapper);
                if (!CollectionUtils.isEmpty((Collection)materTypeList)) {
                    idList = materTypeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
                }
                idList.add(materialType.getId());
                LambdaQueryWrapper feeWrapper = new LambdaQueryWrapper();
                feeWrapper.in(TrainingFee::getTrainingType, idList);
                feeWrapper.eq(TrainingFee::getIsDelete, (Object)0);
                feeWrapper.eq(TrainingFee::getStatus, (Object)2);
                feeWrapper.orderByDesc(TrainingFee::getStartTime);
                feeWrapper.last(" limit 4");
                List feeList = this.trainingFeeMapper.selectList((Wrapper)feeWrapper);
                ArrayList<AppFeeVo> feeVoList = new ArrayList<AppFeeVo>();
                if (!CollectionUtils.isEmpty((Collection)feeList)) {
                    for (TrainingFee fee : feeList) {
                        AppFeeVo vo = new AppFeeVo();
                        BeanUtils.copyProperties((Object)fee, (Object)vo);
                        feeVoList.add(vo);
                    }
                }
                result.setFeeList(feeVoList);
                resultList.add(result);
            }
        }
        return JsonResult.success(resultList);
    }

    @Override
    public String getFreeByPage(Page<AppFeeVo> page, Integer materialTypeId) {
        List<Integer> idList = new ArrayList<Integer>();
        if (materialTypeId != null) {
            TrainingMaterialType materialType = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(materialTypeId);
            if (materialType.getMaterialTypeLevel().equals(1)) {
                LambdaQueryWrapper typeWrapper = new LambdaQueryWrapper();
                typeWrapper.eq(TrainingMaterialType::getOriginId, (Object)materialType.getId());
                List typeList = this.trainingMaterialTypeMapper.selectList((Wrapper)typeWrapper);
                if (!CollectionUtils.isEmpty((Collection)typeList)) {
                    idList = typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
                }
                idList.add(materialType.getId());
            } else if (materialType.getMaterialTypeLevel().equals(2)) {
                LambdaQueryWrapper type2Wrapper = new LambdaQueryWrapper();
                type2Wrapper.eq(TrainingMaterialType::getSourceId, (Object)materialType.getId());
                List type2List = this.trainingMaterialTypeMapper.selectList((Wrapper)type2Wrapper);
                if (!CollectionUtils.isEmpty((Collection)type2List)) {
                    for (TrainingMaterialType type2 : type2List) {
                        LambdaQueryWrapper type3Wrapper = new LambdaQueryWrapper();
                        type3Wrapper.eq(TrainingMaterialType::getSourceId, (Object)type2.getId());
                        List type3List = this.trainingMaterialTypeMapper.selectList((Wrapper)type3Wrapper);
                        if (CollectionUtils.isEmpty((Collection)type3List)) continue;
                        for (TrainingMaterialType type3 : type3List) {
                            LambdaQueryWrapper type4Wrapper = new LambdaQueryWrapper();
                            type4Wrapper.eq(TrainingMaterialType::getSourceId, (Object)type3.getId());
                            List type4List = this.trainingMaterialTypeMapper.selectList((Wrapper)type4Wrapper);
                            if (CollectionUtils.isEmpty((Collection)type4List)) continue;
                            for (TrainingMaterialType type4 : type4List) {
                                LambdaQueryWrapper type5Wrapper = new LambdaQueryWrapper();
                                type5Wrapper.eq(TrainingMaterialType::getSourceId, (Object)type4.getId());
                                List type5List = this.trainingMaterialTypeMapper.selectList((Wrapper)type5Wrapper);
                                if (CollectionUtils.isEmpty((Collection)type5List)) continue;
                                idList.addAll(type5List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                            }
                            idList.addAll(type4List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                        }
                        idList.addAll(type3List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                    }
                    idList.addAll(type2List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                }
                idList.add(materialType.getId());
            }
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingMaterialType::getModuleType, (Object)6);
            List typeList = this.trainingMaterialTypeMapper.selectList((Wrapper)wrapper);
            idList = typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
        }
        List<AppFeeVo> feeList = this.trainingFeeMapper.getFreeByPage(page, idList);
        page.setContent(feeList);
        return JsonResult.success(page);
    }

    @Override
    public String getFeeDetailById(Integer enterpriseId, Integer feeId) {
        TrainingFeeVo trainingFeeVo = new TrainingFeeVo();
        TrainingFee trainingFee = (TrainingFee)this.trainingFeeMapper.selectById(feeId);
        if (!StringUtils.isEmpty((Object)trainingFee)) {
            BeanUtils.copyProperties((Object)trainingFee, (Object)trainingFeeVo);
            LambdaQueryWrapper courseWrapper = new LambdaQueryWrapper();
            courseWrapper.eq(TrainingProcureCourse::getTrainingFeeId, (Object)feeId);
            courseWrapper.eq(TrainingProcureCourse::getGroupId, (Object)enterpriseId);
            courseWrapper.eq(TrainingProcureCourse::getIsStorage, (Object)0);
            List courseList = this.trainingProcureCourseMapper.selectList((Wrapper)courseWrapper);
            if (!CollectionUtils.isEmpty((Collection)courseList)) {
                trainingFeeVo.setIsJoin(Integer.valueOf(1));
            } else {
                trainingFeeVo.setIsJoin(Integer.valueOf(0));
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingFeeChapter::getTrainingId, (Object)trainingFeeVo.getId())).orderByAsc(TrainingFeeChapter::getChapterSort);
            List trainingFeeChapterList = this.trainingFeeChapterMapper.selectList((Wrapper)wrapper1);
            ArrayList<TrainingFeeChapterVo> trainingFeeChapterVos = new ArrayList<TrainingFeeChapterVo>();
            if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterList)) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingFeeChapterAttach::getTrainingId, (Object)trainingFeeVo.getId())).orderByAsc(TrainingFeeChapterAttach::getAttachSort);
                List trainingFeeChapterAttacheList = this.trainingFeeChapterAttachMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> attachMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttacheList)) {
                    attachMap = trainingFeeChapterAttacheList.stream().collect(Collectors.toMap(TrainingFeeChapterAttach::getChapterId, e -> new ArrayList<TrainingFeeChapterAttach>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                for (int i = 0; i < trainingFeeChapterList.size(); ++i) {
                    TrainingFeeChapter trainingFeeChapter = (TrainingFeeChapter)trainingFeeChapterList.get(i);
                    TrainingFeeChapterVo trainingFeeChapterVo = new TrainingFeeChapterVo();
                    BeanUtils.copyProperties((Object)trainingFeeChapter, (Object)trainingFeeChapterVo);
                    if (StringUtils.isEmpty((Object)trainingFeeChapterVo.getName())) {
                        int nameIndex = i + 1;
                        trainingFeeChapterVo.setName(MessageFormat.format(this.messageSource.getMessage("training.learn.chapter.sort", null, locale), nameIndex));
                    }
                    List trainingFeeChapterAttachList = (List)attachMap.get(trainingFeeChapter.getId());
                    ArrayList<TrainingFeeChapterAttachVo> trainingFeeChapterAttachVoList = new ArrayList<TrainingFeeChapterAttachVo>();
                    if (!CollectionUtils.isEmpty((Collection)trainingFeeChapterAttachList)) {
                        for (TrainingFeeChapterAttach trainingFeeChapterAttach : trainingFeeChapterAttachList) {
                            TrainingFeeChapterAttachVo trainingFeeChapterAttachVo = new TrainingFeeChapterAttachVo();
                            BeanUtils.copyProperties((Object)trainingFeeChapterAttach, (Object)trainingFeeChapterAttachVo);
                            trainingFeeChapterAttachVoList.add(trainingFeeChapterAttachVo);
                        }
                    }
                    trainingFeeChapterVo.setTrainingFeeChapterAttachVoList(trainingFeeChapterAttachVoList);
                    trainingFeeChapterVos.add(trainingFeeChapterVo);
                }
            }
            trainingFeeVo.setTrainingFeeChapterVoList(trainingFeeChapterVos);
        }
        return JsonResult.success((Object)trainingFeeVo);
    }

    @Override
    public String getFeeChapterAttachUrl(Integer feeId, Integer enterpriseId, Integer feeChapterAttachId) {
        TrainingFeeChapterAttach chapterAttach = (TrainingFeeChapterAttach)this.trainingFeeChapterAttachMapper.selectById(feeChapterAttachId);
        if (chapterAttach != null && chapterAttach.getIsView().equals(1)) {
            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(chapterAttach.getMaterialId());
            return JsonResult.success((Object)material);
        }
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LambdaQueryWrapper courseWrapper = new LambdaQueryWrapper();
        courseWrapper.eq(TrainingProcureCourse::getTrainingFeeId, (Object)feeId);
        courseWrapper.eq(TrainingProcureCourse::getGroupId, (Object)enterpriseId);
        courseWrapper.eq(TrainingProcureCourse::getIsStorage, (Object)0);
        List courseList = this.trainingProcureCourseMapper.selectList((Wrapper)courseWrapper);
        if (!CollectionUtils.isEmpty((Collection)courseList)) {
            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(chapterAttach.getMaterialId());
            return JsonResult.success((Object)material);
        }
        return JsonResult.error(null, (Object)this.messageSource.getMessage("training.learn.permission.no", null, locale));
    }
}

