/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Sets;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserIdAndDepIdMo;
import com.ovopark.organize.common.model.pojo.OrganizeUserPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDutiesApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.OperateCheckUserMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserAnalyseMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingPaperUserTurnsMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.mapper.UserOperateMapper;
import com.ovopark.training.model.OperateCheck;
import com.ovopark.training.model.OperateCheckUser;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUserAnalyse;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingPaperUserTurns;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.UserOperate;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.UsersDutiesPojo;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingHomePageService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.vo.HomeStudyInfo;
import com.ovopark.training.vo.MemberRankingVo;
import com.ovopark.training.vo.PaperHomeDataInfo;
import com.ovopark.training.vo.PlanHomeDataInfo;
import com.ovopark.training.vo.ProjectHomeDataInfo;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingHomeDataInfo;
import com.ovopark.training.vo.TrainingHomePageVo;
import com.ovopark.training.vo.TrainingJobCertificationVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import com.ovopark.training.vo.TrainingRankingVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingHomePageServiceImpl
implements TrainingHomePageService {
    private static final Logger log = LoggerFactory.getLogger(TrainingHomePageServiceImpl.class);
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Autowired
    private OperateCheckUserMapper operateCheckUserMapper;
    @Autowired
    private TrainingCourseUserAnalyseMapper trainingCourseUserAnalyseMapper;
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private TrainingCourseUserTaskMapper trainingCourseUserTaskMapper;
    @Autowired
    private UserOperateMapper userOperateMapper;
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingPaperUserTurnsMapper trainingPaperUserTurnsMapper;
    @Autowired
    private UserDutiesApi userDutiesApi;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;

    @Override
    public TrainingHomePageVo selectTrainingHomeTotalData(TrainingHomePageVo trainingHomePageVo, Users user) {
        TrainingHomePageVo homePageVo = new TrainingHomePageVo();
        Date startTime = trainingHomePageVo.getStartTime();
        Date endTime = trainingHomePageVo.getEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(5, -1);
        Date endLastTime = calendar.getTime();
        int dayDiff = (int)Math.ceil((endTime.getTime() - startTime.getTime()) / 86400000L) + 1;
        calendar.add(5, 1 - dayDiff);
        Date startLastTime = calendar.getTime();
        homePageVo.setDays(Integer.valueOf(dayDiff));
        Integer learnerNum = 0;
        Integer learnerNum1 = 0;
        Integer studySelfNum = 0;
        Integer studySelfNum1 = 0;
        Integer learnTime = 0;
        Integer learnTime1 = 0;
        Integer studySelfTime = 0;
        Integer studySelfTime1 = 0;
        Map<String, Object> trainingUserViewTimeVoMap = new HashMap<String, Integer>();
        UserIdAndDepIdMo userIdAndDepIdMo = new UserIdAndDepIdMo();
        userIdAndDepIdMo.setUserId(user.getId());
        userIdAndDepIdMo.setGroupId(user.getGroupId());
        userIdAndDepIdMo.setDepId(trainingHomePageVo.getDepId());
        userIdAndDepIdMo.setFrozen(Boolean.valueOf(false));
        BaseResult baseResult = this.userApi.getUserByDepId(userIdAndDepIdMo);
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())) && !baseResult.getIsError().booleanValue()) {
            List<TrainingUserViewTimeVo> trainingUserViewTimeVoList;
            TrainingUserViewTimeVo trainingUserViewTimeVo4;
            TrainingUserViewTimeVo trainingUserViewTimeVo3;
            TrainingUserViewTimeVo trainingUserViewTimeVo2;
            List<Integer> userIds = ((List)baseResult.getData()).stream().map(OrganizeUserPojo::getId).collect(Collectors.toList());
            TrainingUserViewTimeVo trainingUserViewTimeVo1 = this.trainingUserViewTimeMapper.selectViewTimeByUsers(user.getGroupId(), startTime, endTime, userIds, 1);
            if (!ObjectUtils.isEmpty((Object)trainingUserViewTimeVo1)) {
                learnerNum = trainingUserViewTimeVo1.getUserNumber();
                learnTime = trainingUserViewTimeVo1.getViewTimes();
            }
            if (!ObjectUtils.isEmpty((Object)(trainingUserViewTimeVo2 = this.trainingUserViewTimeMapper.selectViewTimeByUsers(user.getGroupId(), startLastTime, endLastTime, userIds, 1)))) {
                learnerNum1 = trainingUserViewTimeVo2.getUserNumber();
                learnTime1 = trainingUserViewTimeVo2.getViewTimes();
            }
            if (!ObjectUtils.isEmpty((Object)(trainingUserViewTimeVo3 = this.trainingUserViewTimeMapper.selectViewTimeByUsers(user.getGroupId(), startTime, endTime, userIds, null)))) {
                studySelfNum = trainingUserViewTimeVo3.getUserNumber();
                studySelfTime = trainingUserViewTimeVo3.getViewTimes();
            }
            if (!ObjectUtils.isEmpty((Object)(trainingUserViewTimeVo4 = this.trainingUserViewTimeMapper.selectViewTimeByUsers(user.getGroupId(), startLastTime, endLastTime, userIds, null)))) {
                studySelfNum1 = trainingUserViewTimeVo4.getUserNumber();
                studySelfTime1 = trainingUserViewTimeVo4.getViewTimes();
            }
            if (!CollectionUtils.isEmpty(trainingUserViewTimeVoList = this.trainingUserViewTimeMapper.selectViewTimeByDates(user.getGroupId(), startTime, endTime, userIds))) {
                trainingUserViewTimeVoMap = trainingUserViewTimeVoList.stream().collect(Collectors.toMap(TrainingUserViewTimeVo::getDayDate, TrainingUserViewTimeVo::getViewTimes));
            }
        }
        homePageVo.setLearnerNum(learnerNum);
        homePageVo.setLearnerNumRate(learnerNum1 == 0 || learnerNum.compareTo(learnerNum1) == 0 ? null : new BigDecimal(learnerNum - learnerNum1).divide(new BigDecimal(learnerNum1), 4, 4));
        homePageVo.setStudySelfNum(studySelfNum);
        homePageVo.setStudySelfNumRate(studySelfNum1 == 0 || studySelfNum.compareTo(studySelfNum1) == 0 ? null : new BigDecimal(studySelfNum - studySelfNum1).divide(new BigDecimal(studySelfNum1), 4, 4));
        homePageVo.setLearnTime(learnTime);
        homePageVo.setLearnTimeRate(learnTime1 == 0 || learnTime.compareTo(learnTime1) == 0 ? null : new BigDecimal(learnTime - learnTime1).divide(new BigDecimal(learnTime1), 4, 4));
        homePageVo.setStudySelfTime(studySelfTime);
        homePageVo.setStudySelfTimeRate(studySelfTime1 == 0 || studySelfTime.compareTo(studySelfTime1) == 0 ? null : new BigDecimal(studySelfTime - studySelfTime1).divide(new BigDecimal(studySelfTime1), 4, 4));
        Integer perLearnTime = learnerNum != 0 ? Math.round(learnTime / learnerNum) : 0;
        homePageVo.setPerLearnTime(perLearnTime);
        Integer perLearnTime1 = learnerNum1 != 0 ? Math.round(learnTime1 / learnerNum1) : 0;
        homePageVo.setPerLearnTimeRate(perLearnTime1 == 0 || perLearnTime.compareTo(perLearnTime1) == 0 ? null : new BigDecimal(perLearnTime - perLearnTime1).divide(new BigDecimal(perLearnTime1), 4, 4));
        while (!startTime.after(endTime)) {
            String day = DateUtil.format((Date)startTime, (String)"yyyy-MM-dd");
            if (ObjectUtils.isEmpty(trainingUserViewTimeVoMap.get(day))) {
                trainingUserViewTimeVoMap.put(day, 0);
            }
            calendar.setTime(startTime);
            calendar.add(5, 1);
            startTime = calendar.getTime();
        }
        homePageVo.setDayViewTimes(new TreeMap(trainingUserViewTimeVoMap));
        return homePageVo;
    }

    @Override
    public TrainingHomePageVo selectTrainingHomePaper(TrainingHomePageVo trainingHomePageVo, Users user) {
        BigDecimal passRate1;
        TrainingHomePageVo homePageVo = new TrainingHomePageVo();
        Date startTime = trainingHomePageVo.getStartTime();
        Date endTime = trainingHomePageVo.getEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(5, -1);
        Date endLastTime = calendar.getTime();
        int dayDiff = (int)Math.ceil((endTime.getTime() - startTime.getTime()) / 86400000L) + 1;
        calendar.add(5, 1 - dayDiff);
        Date startLastTime = calendar.getTime();
        Integer paperUserNum = 0;
        Integer passNum = 0;
        Integer paperUserNum1 = 0;
        Integer passNum1 = 0;
        UserIdAndDepIdMo userIdAndDepIdMo = new UserIdAndDepIdMo();
        userIdAndDepIdMo.setUserId(user.getId());
        userIdAndDepIdMo.setGroupId(user.getGroupId());
        userIdAndDepIdMo.setDepId(trainingHomePageVo.getDepId());
        userIdAndDepIdMo.setFrozen(Boolean.valueOf(false));
        BaseResult baseResult = this.userApi.getUserByDepId(userIdAndDepIdMo);
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())) && !baseResult.getIsError().booleanValue()) {
            List<Integer> userIds = ((List)baseResult.getData()).stream().map(OrganizeUserPojo::getId).collect(Collectors.toList());
            List<TrainingUserPaperVo> trainingUserPaperVoList = this.trainingUserPaperMapper.selectPaperCountByUserPaperId(user.getGroupId(), userIds, startTime, endTime);
            Map<String, Object> map = this.selectPaperNum(trainingUserPaperVoList, userIds);
            paperUserNum = (Integer)map.get("paperUserNum");
            passNum = (Integer)map.get("passNum");
            List<TrainingUserPaperVo> trainingUserPaperVoList1 = this.trainingUserPaperMapper.selectPaperCountByUserPaperId(user.getGroupId(), userIds, startLastTime, endLastTime);
            Map<String, Object> map1 = this.selectPaperNum(trainingUserPaperVoList1, userIds);
            paperUserNum1 = (Integer)map1.get("paperUserNum");
            passNum1 = (Integer)map1.get("passNum");
        }
        homePageVo.setPaperUserNum(paperUserNum);
        homePageVo.setPassNum(passNum);
        BigDecimal passRate = paperUserNum == 0 ? null : new BigDecimal(passNum).divide(new BigDecimal(paperUserNum), 4, 4);
        homePageVo.setPassRate(passRate);
        homePageVo.setPaperUserNumRate(paperUserNum1 == 0 || paperUserNum.compareTo(paperUserNum1) == 0 ? null : new BigDecimal(paperUserNum - paperUserNum1).divide(new BigDecimal(paperUserNum1), 4, 4));
        homePageVo.setPassNumRate(passNum1 == 0 || passNum.compareTo(passNum1) == 0 ? null : new BigDecimal(passNum - passNum1).divide(new BigDecimal(passNum1), 4, 4));
        BigDecimal bigDecimal = passRate1 = paperUserNum1 == 0 ? null : new BigDecimal(passNum1).divide(new BigDecimal(paperUserNum1), 4, 4);
        if (passRate == null) {
            passRate = BigDecimal.ZERO;
        }
        homePageVo.setPassRateRate(passRate1 == null || passRate1.compareTo(BigDecimal.ZERO) == 0 || passRate.compareTo(passRate1) == 0 ? null : passRate.subtract(passRate1).divide(passRate1, 4, 4));
        BaseResult result = this.departmentApi.getDepIdsByEnterpriseId(user.getGroupId());
        ArrayList<Integer> depIdList = new ArrayList();
        if (result != null && !CollectionUtils.isEmpty((Collection)((Collection)result.getData())) && !result.getIsError().booleanValue()) {
            depIdList = (List)result.getData();
        }
        homePageVo.setDepNum(Integer.valueOf(depIdList.size()));
        Integer rinkingNum = 0;
        if (paperUserNum.compareTo(0) > 0) {
            rinkingNum = this.selectPaperNumRinking(depIdList, user, startTime, endTime, trainingHomePageVo.getDepId());
        }
        homePageVo.setDepRinking(rinkingNum == 0 ? null : rinkingNum);
        Integer rinkingNum1 = 0;
        if (paperUserNum1.compareTo(0) > 0) {
            rinkingNum1 = this.selectPaperNumRinking(depIdList, user, startLastTime, endLastTime, trainingHomePageVo.getDepId());
        }
        Integer depRinkingRate = null;
        if (rinkingNum.compareTo(rinkingNum1) != 0 && (rinkingNum != 0 || rinkingNum1 != 0)) {
            depRinkingRate = rinkingNum > 0 && rinkingNum1 == 0 ? Integer.valueOf(depIdList.size() - rinkingNum) : (rinkingNum1 > 0 && rinkingNum == 0 ? Integer.valueOf(rinkingNum1 - depIdList.size()) : Integer.valueOf(rinkingNum1 - rinkingNum));
        }
        homePageVo.setDepRinkingRate(depRinkingRate);
        return homePageVo;
    }

    public Map<String, Object> selectPaperNum(List<TrainingUserPaperVo> trainingUserPaperVoList, List<Integer> userIds) {
        Map<Object, Object> trainingUserPaperVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(trainingUserPaperVoList)) {
            trainingUserPaperVoMap = trainingUserPaperVoList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer paperUserNum = 0;
        Integer passNum = 0;
        if (!CollectionUtils.isEmpty(userIds)) {
            for (Integer userId : userIds) {
                Map<Integer, List<TrainingUserPaperVo>> userPaperMap;
                List trainingUserPaperVos = (List)trainingUserPaperVoMap.get(userId);
                if (CollectionUtils.isEmpty((Collection)trainingUserPaperVos) || ObjectUtils.isEmpty(userPaperMap = trainingUserPaperVos.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore, Comparator.nullsFirst(BigDecimal::compareTo))).collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId)))) continue;
                for (Integer trainingPaperId : userPaperMap.keySet()) {
                    Integer n = paperUserNum;
                    Integer n2 = paperUserNum = Integer.valueOf(paperUserNum + 1);
                    List<TrainingUserPaperVo> userPaperList = userPaperMap.get(trainingPaperId);
                    if (CollectionUtils.isEmpty(userPaperList)) continue;
                    TrainingUserPaperVo vo = null;
                    if (userPaperList.get(0).getScoreSelect() == 0) {
                        vo = (TrainingUserPaperVo)userPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore).reversed()).collect(Collectors.toList()).get(0);
                    } else if (userPaperList.get(0).getScoreSelect() == 1) {
                        vo = (TrainingUserPaperVo)userPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getSubmitTime).reversed()).collect(Collectors.toList()).get(0);
                    } else if (userPaperList.get(0).getScoreSelect() == 2) {
                        vo = (TrainingUserPaperVo)userPaperList.stream().sorted(Comparator.comparing(TrainingUserPaper::getSubmitTime)).collect(Collectors.toList()).get(0);
                    }
                    if (ObjectUtils.isEmpty((Object)vo) || vo.getScore().compareTo(vo.getPassLineScore()) < 0) continue;
                    Integer n3 = passNum;
                    Integer n4 = passNum = Integer.valueOf(passNum + 1);
                }
            }
        }
        map.put("paperUserNum", paperUserNum);
        map.put("passNum", passNum);
        return map;
    }

    public Integer selectPaperNumRinking(List<Integer> depIdList, Users user, Date startTime, Date endTime, Integer dep) {
        List<Object> rinkingNumList = new ArrayList();
        BigDecimal rate = BigDecimal.ZERO;
        List<TrainingUserPaperVo> trainingUserPaperVoList = this.trainingUserPaperMapper.selectPaperCountByUserPaperId(user.getGroupId(), null, startTime, endTime);
        UsersOrgIdsAndTagsPojo pojo = new UsersOrgIdsAndTagsPojo();
        pojo.setGroupId(user.getGroupId());
        pojo.setDepartmentIds(depIdList);
        pojo.setShowId(Integer.valueOf(1));
        pojo.setFrozen(Boolean.valueOf(false));
        BaseResult depBaseResult = this.userOrganizeApi.getDepUserByGroupId(pojo);
        Map depMap = new HashMap();
        if (depBaseResult != null && !ObjectUtils.isEmpty((Object)depBaseResult.getData()) && !depBaseResult.getIsError().booleanValue()) {
            depMap = (Map)depBaseResult.getData();
        }
        for (Integer depId : depIdList) {
            BigDecimal passRate;
            List list = (List)depMap.get(depId + "");
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            Map<String, Object> map = this.selectPaperNum(trainingUserPaperVoList, list);
            Integer paperUserNum = (Integer)map.get("paperUserNum");
            Integer passNum = (Integer)map.get("passNum");
            BigDecimal bigDecimal = passRate = paperUserNum == 0 ? null : new BigDecimal(passNum).divide(new BigDecimal(paperUserNum), 4, 4);
            if (dep.compareTo(depId) == 0) {
                rate = passRate;
            }
            if (passRate == null) continue;
            rinkingNumList.add(passRate);
        }
        Integer rinkingNum = 0;
        if (!CollectionUtils.isEmpty(rinkingNumList)) {
            if (rate != null) {
                rinkingNumList = rinkingNumList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                for (BigDecimal bigDecimal : rinkingNumList) {
                    Integer n = rinkingNum;
                    Integer n2 = rinkingNum = Integer.valueOf(rinkingNum + 1);
                    if (rate.compareTo(bigDecimal) != 0) continue;
                    break;
                }
            } else {
                rinkingNum = rinkingNumList.size() + 1;
            }
        }
        return rinkingNum;
    }

    @Override
    public TrainingHomePageVo selectTrainingHomeCourse(TrainingHomePageVo trainingHomePageVo, Users user) {
        BigDecimal passRate1;
        BigDecimal finishRate1;
        TrainingHomePageVo homePageVo = new TrainingHomePageVo();
        Date startTime = trainingHomePageVo.getStartTime();
        Date endTime = trainingHomePageVo.getEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(5, -1);
        Date endLastTime = calendar.getTime();
        int dayDiff = (int)Math.ceil((endTime.getTime() - startTime.getTime()) / 86400000L) + 1;
        calendar.add(5, 1 - dayDiff);
        Date startLastTime = calendar.getTime();
        Integer learnNum = 0;
        Integer finishNum = 0;
        Integer passNum = 0;
        Integer learnNum1 = 0;
        Integer finishNum1 = 0;
        Integer passNum1 = 0;
        ArrayList<Integer> userIds = new ArrayList();
        UserIdAndDepIdMo userIdAndDepIdMo = new UserIdAndDepIdMo();
        userIdAndDepIdMo.setUserId(user.getId());
        userIdAndDepIdMo.setGroupId(user.getGroupId());
        userIdAndDepIdMo.setDepId(trainingHomePageVo.getDepId());
        userIdAndDepIdMo.setFrozen(Boolean.valueOf(false));
        BaseResult baseResult = this.userApi.getUserByDepId(userIdAndDepIdMo);
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData())) && !baseResult.getIsError().booleanValue()) {
            userIds = ((List)baseResult.getData()).stream().map(OrganizeUserPojo::getId).collect(Collectors.toList());
            Map<String, Object> map = this.selectCourseNum(user.getGroupId(), userIds, startTime, endTime);
            learnNum = (Integer)map.get("learnNum");
            finishNum = (Integer)map.get("finishNum");
            passNum = (Integer)map.get("passNum");
            Map<String, Object> map1 = this.selectCourseNum(user.getGroupId(), userIds, startLastTime, endLastTime);
            learnNum1 = (Integer)map1.get("learnNum");
            finishNum1 = (Integer)map1.get("finishNum");
            passNum1 = (Integer)map1.get("passNum");
        }
        homePageVo.setLearnerNum(learnNum);
        homePageVo.setFinishNum(finishNum);
        homePageVo.setPassNum(passNum);
        BigDecimal finishRate = learnNum == 0 ? null : new BigDecimal(finishNum).divide(new BigDecimal(learnNum), 4, 4);
        BigDecimal passRate = learnNum == 0 ? null : new BigDecimal(passNum).divide(new BigDecimal(learnNum), 4, 4);
        homePageVo.setFinishRate(finishRate);
        homePageVo.setPassRate(passRate);
        homePageVo.setLearnerNumRate(learnNum1 == 0 || learnNum.compareTo(learnNum1) == 0 ? null : new BigDecimal(learnNum - learnNum1).divide(new BigDecimal(learnNum1), 4, 4));
        homePageVo.setFinishNumRate(finishNum1 == 0 || finishNum.compareTo(finishNum1) == 0 ? null : new BigDecimal(finishNum - finishNum1).divide(new BigDecimal(finishNum1), 4, 4));
        homePageVo.setPassNumRate(passNum1 == 0 || passNum.compareTo(passNum1) == 0 ? null : new BigDecimal(passNum - passNum1).divide(new BigDecimal(passNum1), 4, 4));
        BigDecimal bigDecimal = finishRate1 = learnNum1 == 0 ? null : new BigDecimal(finishNum1).divide(new BigDecimal(learnNum1), 4, 4);
        if (finishRate == null) {
            finishRate = BigDecimal.ZERO;
        }
        homePageVo.setFinishRateRate(finishRate1 == null || finishRate1.compareTo(BigDecimal.ZERO) == 0 || finishRate.compareTo(finishRate1) == 0 ? null : finishRate.subtract(finishRate1).divide(finishRate1, 4, 4));
        BigDecimal bigDecimal2 = passRate1 = learnNum1 == 0 ? null : new BigDecimal(passNum1).divide(new BigDecimal(learnNum1), 4, 4);
        if (passRate == null) {
            passRate = BigDecimal.ZERO;
        }
        homePageVo.setPassRateRate(passRate1 == null || passRate1.compareTo(BigDecimal.ZERO) == 0 || passRate.compareTo(passRate1) == 0 ? null : passRate.subtract(passRate1).divide(passRate1, 4, 4));
        BaseResult result = this.departmentApi.getDepIdsByEnterpriseId(user.getGroupId());
        ArrayList<Integer> depIdList = new ArrayList();
        if (result != null && !CollectionUtils.isEmpty((Collection)((Collection)result.getData())) && !result.getIsError().booleanValue()) {
            depIdList = (List)result.getData();
        }
        homePageVo.setDepNum(Integer.valueOf(depIdList.size()));
        Integer finishRinkingNum = 0;
        Integer passRinkingNum = 0;
        if (learnNum > 0 && finishNum > 0) {
            Map<String, Object> maps = this.selectCourseNumRinkingNew(depIdList, user, startTime, endTime, trainingHomePageVo.getDepId());
            finishRinkingNum = (Integer)maps.get("finishRinkingNum");
            passRinkingNum = (Integer)maps.get("passRinkingNum");
        }
        Integer finishRinkingNum1 = 0;
        Integer passRinkingNum1 = 0;
        if (learnNum1.compareTo(0) > 0) {
            Map<String, Object> maps1 = this.selectCourseNumRinkingNew(depIdList, user, startLastTime, endLastTime, trainingHomePageVo.getDepId());
            finishRinkingNum1 = (Integer)maps1.get("finishRinkingNum");
            passRinkingNum1 = (Integer)maps1.get("passRinkingNum");
        }
        homePageVo.setFinishRateRinking(finishRinkingNum == 0 ? null : finishRinkingNum);
        Integer finishRateRinkingRate = null;
        if (finishRinkingNum.compareTo(finishRinkingNum1) != 0 && (finishRinkingNum != 0 || finishRinkingNum1 != 0)) {
            finishRateRinkingRate = finishRinkingNum > 0 && finishRinkingNum1 == 0 ? Integer.valueOf(depIdList.size() - finishRinkingNum) : (finishRinkingNum1 > 0 && finishRinkingNum == 0 ? Integer.valueOf(finishRinkingNum1 - depIdList.size()) : Integer.valueOf(finishRinkingNum1 - finishRinkingNum));
        }
        homePageVo.setFinishRateRinkingRate(finishRateRinkingRate);
        homePageVo.setPassRateRinking(passRinkingNum == 0 ? null : passRinkingNum);
        Integer passRateRinkingRate = null;
        if (passRinkingNum.compareTo(passRinkingNum1) != 0 && (passRinkingNum != 0 || passRinkingNum1 != 0)) {
            passRateRinkingRate = passRinkingNum > 0 && passRinkingNum1 == 0 ? Integer.valueOf(depIdList.size() - passRinkingNum) : (passRinkingNum1 > 0 && passRinkingNum == 0 ? Integer.valueOf(passRinkingNum1 - depIdList.size()) : Integer.valueOf(passRinkingNum1 - passRinkingNum));
        }
        homePageVo.setPassRateRinkingRate(passRateRinkingRate);
        return homePageVo;
    }

    public Map<String, Object> selectCourseNum(Integer enterpriseId, List<Integer> userIds, Date startTime, Date endTime) {
        List<UserOperate> trainingUserOperateList;
        Object trainingPaperUserTurnsMap;
        Object trainingPaperUserTurnsList;
        List<TrainingCourseUserTaskVo> trainingCourseUserTaskVoList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer learnNum = 0;
        Integer finishNum = 0;
        Integer passNum = 0;
        List<TrainingLearnUserVo> trainingLearnUserVoList = this.trainingLearnUserMapper.selectLearnCountByUser(enterpriseId, userIds, startTime, endTime);
        if (!CollectionUtils.isEmpty(trainingLearnUserVoList)) {
            for (TrainingLearnUserVo trainingLearnUserVo : trainingLearnUserVoList) {
                Integer n = learnNum;
                Integer n2 = learnNum = Integer.valueOf(learnNum + 1);
                if (trainingLearnUserVo.getLearnStatus() == null || trainingLearnUserVo.getLearnStatus() != 3) continue;
                n = finishNum;
                n2 = finishNum = Integer.valueOf(finishNum + 1);
                if (trainingLearnUserVo.getPassStatus() == null || trainingLearnUserVo.getPassStatus() != 1) continue;
                n = passNum;
                n2 = passNum = Integer.valueOf(passNum + 1);
            }
        }
        if (!CollectionUtils.isEmpty(trainingCourseUserTaskVoList = this.trainingCourseUserTaskMapper.selectCourseCountByUser(enterpriseId, userIds, startTime, endTime))) {
            Map<Integer, List<TrainingCourseUserTaskVo>> trainingCourseUserTaskMap = trainingCourseUserTaskVoList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            List courseIdList = trainingCourseUserTaskVoList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingCourseStageTask::getCourseId, courseIdList);
            List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList)) {
                Map<Integer, List<TrainingCourseStageTask>> trainingCourseStageTaskMap = trainingCourseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingPaperUserTurns::getProjectId, courseIdList)).eq(TrainingPaperUserTurns::getUserId, userIds)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurns = this.trainingPaperUserTurnsMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> turnMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                    turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
                }
                for (Integer userId : userIds) {
                    List<TrainingCourseUserTaskVo> trainingCourseUserTaskVos = trainingCourseUserTaskMap.get(userId);
                    if (CollectionUtils.isEmpty(trainingCourseUserTaskVos)) continue;
                    Map<Integer, List<TrainingCourseUserTaskVo>> courseUserMap = trainingCourseUserTaskVos.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                    trainingPaperUserTurnsList = (List)turnMap.get(userId);
                    trainingPaperUserTurnsMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)trainingPaperUserTurnsList)) {
                        trainingPaperUserTurnsMap = trainingPaperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getProjectId));
                    }
                    for (Integer courseId : courseUserMap.keySet()) {
                        Object trainingCourseStageTasks;
                        Object userTurnsMap;
                        List<TrainingCourseUserTaskVo> courseUserTaskVos = courseUserMap.get(courseId);
                        List trainingPaperUserTurns = (List)trainingPaperUserTurnsMap.get(courseId);
                        if (!CollectionUtils.isEmpty((Collection)trainingPaperUserTurns)) {
                            userTurnsMap = trainingPaperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                            trainingCourseStageTasks = trainingCourseStageTaskMap.get(courseId);
                            Map<Object, Object> taskMap = new HashMap();
                            if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTasks)) {
                                taskMap = trainingCourseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                            }
                            if (!CollectionUtils.isEmpty(courseUserTaskVos)) {
                                ArrayList<TrainingCourseUserTaskVo> removeList = new ArrayList<TrainingCourseUserTaskVo>();
                                for (TrainingCourseUserTaskVo trainingCourseUserTaskVo : courseUserTaskVos) {
                                    List turnsList;
                                    TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(trainingCourseUserTaskVo.getTaskId());
                                    if (ObjectUtils.isEmpty((Object)task) || CollectionUtils.isEmpty((Collection)(turnsList = (List)userTurnsMap.get(task.getStageId()))) || trainingCourseUserTaskVo.getTurns().compareTo(((TrainingPaperUserTurns)turnsList.get(0)).getTurns()) == 0) continue;
                                    removeList.add(trainingCourseUserTaskVo);
                                }
                                if (!CollectionUtils.isEmpty(removeList)) {
                                    courseUserTaskVos.removeAll(removeList);
                                }
                            }
                        }
                        if (CollectionUtils.isEmpty(courseUserTaskVos)) continue;
                        userTurnsMap = learnNum;
                        learnNum = learnNum + 1;
                        trainingCourseStageTasks = learnNum;
                        if (CollectionUtils.isEmpty((Collection)trainingCourseStageTaskMap.get(courseId)) || courseUserTaskVos.size() < trainingCourseStageTaskMap.get(courseId).size()) continue;
                        Integer num1 = 0;
                        Integer num2 = 0;
                        for (TrainingCourseUserTaskVo taskVo : courseUserTaskVos) {
                            Integer n;
                            Object object;
                            if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4) {
                                object = num1;
                                n = num1 = Integer.valueOf(num1 + 1);
                                continue;
                            }
                            if (taskVo.getTaskStatus() != 5) continue;
                            object = num2;
                            n = num2 = Integer.valueOf(num2 + 1);
                        }
                        if (num1 + num2 != courseUserTaskVos.size()) continue;
                        Object object = finishNum;
                        Integer n = finishNum = Integer.valueOf(finishNum + 1);
                        if (num1.intValue() != courseUserTaskVos.size()) continue;
                        object = passNum;
                        n = passNum = Integer.valueOf(passNum + 1);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(trainingUserOperateList = this.userOperateMapper.selectOperateCountByUser(enterpriseId, userIds, startTime, endTime))) {
            List operateCheckIds = trainingUserOperateList.stream().map(UserOperate::getOperateCheckId).distinct().collect(Collectors.toList());
            List operateCheckList = this.operateCheckMapper.selectBatchIds(operateCheckIds);
            Map operateCheckMap = operateCheckList.stream().collect(Collectors.toMap(OperateCheck::getId, Function.identity()));
            Map<Integer, List<UserOperate>> trainingUserOperateMap = trainingUserOperateList.stream().collect(Collectors.groupingBy(UserOperate::getUserId));
            for (Integer userId : userIds) {
                List<UserOperate> userOperateList = trainingUserOperateMap.get(userId);
                if (CollectionUtils.isEmpty(userOperateList)) continue;
                Map<Integer, List<UserOperate>> operateUserMap = userOperateList.stream().collect(Collectors.groupingBy(UserOperate::getOperateCheckId));
                for (Integer operateCheckId : operateUserMap.keySet()) {
                    Integer n;
                    Integer n3;
                    List<UserOperate> userOperates = operateUserMap.get(operateCheckId);
                    if (CollectionUtils.isEmpty(userOperates)) continue;
                    trainingPaperUserTurnsList = learnNum;
                    learnNum = learnNum + 1;
                    trainingPaperUserTurnsMap = learnNum;
                    Integer num1 = 0;
                    Integer num2 = 0;
                    for (UserOperate userOperate : userOperates) {
                        if (userOperate.getStatus() == null || userOperate.getStatus() < 2) continue;
                        n3 = num1;
                        Integer n4 = num1 = Integer.valueOf(num1 + 1);
                        if (userOperate.getIsPass() == null || userOperate.getIsPass() != 1) continue;
                        num2 = 1;
                    }
                    OperateCheck operateCheck = (OperateCheck)operateCheckMap.get(operateCheckId);
                    if (!ObjectUtils.isEmpty((Object)operateCheck) && (operateCheck.getCheckType() == 0 && num1.compareTo(operateCheck.getCheckNumber()) >= 0 || operateCheck.getCheckType() != 0 && num1.compareTo(0) > 0)) {
                        n = finishNum;
                        n3 = finishNum = Integer.valueOf(finishNum + 1);
                    }
                    if (!ObjectUtils.isEmpty((Object)operateCheck) && "1".equals(operateCheck.getCheckScoreChoice())) {
                        num2 = 0;
                        if (userOperates.get(0).getIsPass() != null && userOperates.get(0).getIsPass() == 1) {
                            num2 = 1;
                        }
                    }
                    if (num2 != 1) continue;
                    n = passNum;
                    n3 = passNum = Integer.valueOf(passNum + 1);
                }
            }
        }
        map.put("learnNum", learnNum);
        map.put("finishNum", finishNum);
        map.put("passNum", passNum);
        return map;
    }

    public Map<String, Object> selectCourseNumRinking(List<Integer> depIdList, Users user, Date startTime, Date endTime, Integer dep) {
        Integer n;
        Integer n2;
        HashMap<String, Object> maps = new HashMap<String, Object>();
        List<Object> finishList = new ArrayList();
        List<Object> passList = new ArrayList();
        BigDecimal rate1 = BigDecimal.ZERO;
        BigDecimal rate2 = BigDecimal.ZERO;
        UsersOrgIdsAndTagsPojo pojo = new UsersOrgIdsAndTagsPojo();
        pojo.setGroupId(user.getGroupId());
        pojo.setDepartmentIds(depIdList);
        pojo.setShowId(Integer.valueOf(1));
        pojo.setFrozen(Boolean.valueOf(false));
        BaseResult depBaseResult = this.userOrganizeApi.getDepUserByGroupId(pojo);
        Map depMap = new HashMap();
        if (depBaseResult != null && !ObjectUtils.isEmpty((Object)depBaseResult.getData()) && !depBaseResult.getIsError().booleanValue()) {
            depMap = (Map)depBaseResult.getData();
        }
        for (Integer depId : depIdList) {
            BigDecimal passRate;
            List userIds = (List)depMap.get(depId + "");
            if (CollectionUtils.isEmpty((Collection)userIds)) continue;
            Map<String, Object> map = this.selectCourseNum(user.getGroupId(), userIds, startTime, endTime);
            Integer learnNum = (Integer)map.get("learnNum");
            Integer finishNum = (Integer)map.get("finishNum");
            if (learnNum == 0 || finishNum == 0) continue;
            Integer passNum = (Integer)map.get("passNum");
            BigDecimal finishRate = learnNum == 0 ? null : new BigDecimal(finishNum).divide(new BigDecimal(learnNum), 4, 4);
            BigDecimal bigDecimal = passRate = learnNum == 0 ? null : new BigDecimal(passNum).divide(new BigDecimal(learnNum), 4, 4);
            if (dep.compareTo(depId) == 0) {
                rate1 = finishRate;
                rate2 = passRate;
            }
            if (finishRate != null) {
                finishList.add(finishRate);
            }
            if (passRate == null) continue;
            passList.add(passRate);
        }
        Integer finishRinkingNum = 0;
        Integer passRinkingNum = 0;
        if (!CollectionUtils.isEmpty(finishList)) {
            if (rate1 != null) {
                finishList = finishList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                for (BigDecimal bigDecimal : finishList) {
                    n2 = finishRinkingNum;
                    n = finishRinkingNum = Integer.valueOf(finishRinkingNum + 1);
                    if (rate1.compareTo(bigDecimal) != 0) continue;
                    break;
                }
            } else {
                finishRinkingNum = finishList.size() + 1;
            }
        }
        if (!CollectionUtils.isEmpty(passList)) {
            if (rate1 != null) {
                passList = passList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                for (BigDecimal bigDecimal : passList) {
                    n2 = passRinkingNum;
                    n = passRinkingNum = Integer.valueOf(passRinkingNum + 1);
                    if (rate2.compareTo(bigDecimal) != 0) continue;
                    break;
                }
            } else {
                passRinkingNum = passList.size() + 1;
            }
        }
        maps.put("finishRinkingNum", finishRinkingNum);
        maps.put("passRinkingNum", passRinkingNum);
        return maps;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> selectCourseNumRinkingNew(List<Integer> depIdList, Users user, Date startTime, Date endTime, Integer dep) {
        Integer n;
        Integer n2;
        HashMap<String, Object> maps = new HashMap<String, Object>();
        List<Object> finishList = new ArrayList();
        List<Object> passList = new ArrayList();
        BigDecimal rate1 = BigDecimal.ZERO;
        BigDecimal rate2 = BigDecimal.ZERO;
        UsersOrgIdsAndTagsPojo pojo = new UsersOrgIdsAndTagsPojo();
        pojo.setGroupId(user.getGroupId());
        pojo.setDepartmentIds(depIdList);
        pojo.setShowId(Integer.valueOf(1));
        pojo.setFrozen(Boolean.valueOf(false));
        BaseResult depBaseResult = this.userOrganizeApi.getDepUserByGroupId(pojo);
        Map depMap = new HashMap();
        if (depBaseResult != null && !ObjectUtils.isEmpty((Object)depBaseResult.getData()) && !depBaseResult.getIsError().booleanValue()) {
            depMap = (Map)depBaseResult.getData();
        }
        List<TrainingLearnUserVo> trainingLearnUserVoList = this.trainingLearnUserMapper.selectLearnCountByUser(user.getGroupId(), null, startTime, endTime);
        Map<Object, Object> trainingLearnUserVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(trainingLearnUserVoList)) {
            trainingLearnUserVoMap = trainingLearnUserVoList.stream().collect(Collectors.groupingBy(TrainingLearnUser::getUserId));
        }
        List<TrainingCourseUserTaskVo> trainingCourseUserTaskVoList = this.trainingCourseUserTaskMapper.selectCourseCountByUser(user.getGroupId(), null, startTime, endTime);
        Map<Object, Object> trainingCourseUserTaskMap = new HashMap();
        Map<Object, Object> trainingCourseStageTaskMap = new HashMap();
        Map<Object, Object> turnMap = new HashMap();
        if (!CollectionUtils.isEmpty(trainingCourseUserTaskVoList)) {
            trainingCourseUserTaskMap = trainingCourseUserTaskVoList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
            List courseIdList = trainingCourseUserTaskVoList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingCourseStageTask::getCourseId, courseIdList);
            List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList)) {
                trainingCourseStageTaskMap = trainingCourseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingPaperUserTurns::getProjectId, courseIdList)).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                List paperUserTurns = this.trainingPaperUserTurnsMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                    turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getUserId));
                }
            }
        }
        List<UserOperate> trainingUserOperateList = this.userOperateMapper.selectOperateCountByUser(user.getGroupId(), null, startTime, endTime);
        Map<Object, Object> trainingUserOperateMap = new HashMap();
        Map<Object, Object> operateCheckMap = new HashMap();
        if (!CollectionUtils.isEmpty(trainingUserOperateList)) {
            List operateCheckIds = trainingUserOperateList.stream().map(UserOperate::getOperateCheckId).distinct().collect(Collectors.toList());
            List operateCheckList = this.operateCheckMapper.selectBatchIds(operateCheckIds);
            operateCheckMap = operateCheckList.stream().collect(Collectors.toMap(OperateCheck::getId, Function.identity()));
            trainingUserOperateMap = trainingUserOperateList.stream().collect(Collectors.groupingBy(UserOperate::getUserId));
        }
        for (Integer depId : depIdList) {
            BigDecimal passRate;
            void var26_26;
            List userIds = (List)depMap.get(depId + "");
            if (CollectionUtils.isEmpty((Collection)userIds)) continue;
            Integer n3 = 0;
            Integer finishNum = 0;
            Integer passNum = 0;
            for (Integer userId : userIds) {
                List userOperateList;
                Integer n4;
                Object object;
                Object trainingPaperUserTurns;
                List<TrainingCourseUserTaskVo> courseUserTaskVos;
                List trainingCourseUserTaskVos;
                List learnUserVoList = (List)trainingLearnUserVoMap.get(userId);
                if (!CollectionUtils.isEmpty((Collection)learnUserVoList)) {
                    for (TrainingLearnUserVo trainingLearnUserVo : learnUserVoList) {
                        Integer n5 = var26_26;
                        Integer n6 = var26_26.intValue() + 1;
                        Object object2 = n6;
                        if (trainingLearnUserVo.getLearnStatus() == null || trainingLearnUserVo.getLearnStatus() != 3) continue;
                        n5 = finishNum;
                        finishNum = finishNum + 1;
                        object2 = finishNum;
                        if (trainingLearnUserVo.getPassStatus() == null || trainingLearnUserVo.getPassStatus() != 1) continue;
                        n5 = passNum;
                        passNum = passNum + 1;
                        object2 = passNum;
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(trainingCourseUserTaskVos = (List)trainingCourseUserTaskMap.get(userId)))) {
                    Map<Integer, List<TrainingCourseUserTaskVo>> courseUserMap = trainingCourseUserTaskVos.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                    List trainingPaperUserTurnsList = (List)turnMap.get(userId);
                    Map<Object, Object> trainingPaperUserTurnsMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)trainingPaperUserTurnsList)) {
                        trainingPaperUserTurnsMap = trainingPaperUserTurnsList.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getProjectId));
                    }
                    for (Integer courseId : courseUserMap.keySet()) {
                        Object trainingCourseStageTasks;
                        Map<Integer, List<TrainingPaperUserTurns>> userTurnsMap;
                        courseUserTaskVos = courseUserMap.get(courseId);
                        trainingPaperUserTurns = (List)trainingPaperUserTurnsMap.get(courseId);
                        if (!CollectionUtils.isEmpty((Collection)trainingPaperUserTurns)) {
                            userTurnsMap = trainingPaperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                            trainingCourseStageTasks = (List)trainingCourseStageTaskMap.get(courseId);
                            Map<Object, Object> taskMap = new HashMap();
                            if (!CollectionUtils.isEmpty((Collection)trainingCourseStageTasks)) {
                                taskMap = trainingCourseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                            }
                            if (!CollectionUtils.isEmpty(courseUserTaskVos)) {
                                ArrayList<TrainingCourseUserTaskVo> removeList = new ArrayList<TrainingCourseUserTaskVo>();
                                for (TrainingCourseUserTaskVo trainingCourseUserTaskVo : courseUserTaskVos) {
                                    List<TrainingPaperUserTurns> turnsList;
                                    TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(trainingCourseUserTaskVo.getTaskId());
                                    if (ObjectUtils.isEmpty((Object)task) || CollectionUtils.isEmpty(turnsList = userTurnsMap.get(task.getStageId())) || trainingCourseUserTaskVo.getTurns().compareTo(turnsList.get(0).getTurns()) == 0) continue;
                                    removeList.add(trainingCourseUserTaskVo);
                                }
                                if (!CollectionUtils.isEmpty(removeList)) {
                                    courseUserTaskVos.removeAll(removeList);
                                }
                            }
                        }
                        if (CollectionUtils.isEmpty(courseUserTaskVos)) continue;
                        userTurnsMap = var26_26;
                        Integer n7 = var26_26.intValue() + 1;
                        trainingCourseStageTasks = n7;
                        if (CollectionUtils.isEmpty((Collection)((Collection)trainingCourseStageTaskMap.get(courseId))) || courseUserTaskVos.size() < ((List)trainingCourseStageTaskMap.get(courseId)).size()) continue;
                        Object num1 = 0;
                        Integer num2 = 0;
                        for (TrainingCourseUserTaskVo taskVo : courseUserTaskVos) {
                            Integer n8;
                            Object object3;
                            if (taskVo.getTaskStatus() == 3 || taskVo.getTaskStatus() == 4) {
                                object3 = num1;
                                num1 = (Integer)num1 + 1;
                                n8 = num1;
                                continue;
                            }
                            if (taskVo.getTaskStatus() != 5) continue;
                            object3 = num2;
                            n8 = num2 = Integer.valueOf(num2 + 1);
                        }
                        if ((Integer)num1 + num2 != courseUserTaskVos.size()) continue;
                        object = finishNum;
                        n4 = finishNum = Integer.valueOf(finishNum + 1);
                        if (((Integer)num1).intValue() != courseUserTaskVos.size()) continue;
                        object = passNum;
                        n4 = passNum = Integer.valueOf(passNum + 1);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(userOperateList = (List)trainingUserOperateMap.get(userId)))) continue;
                Map<Integer, List<UserOperate>> operateUserMap = userOperateList.stream().collect(Collectors.groupingBy(UserOperate::getOperateCheckId));
                for (Integer operateCheckId : operateUserMap.keySet()) {
                    Integer n9;
                    List<UserOperate> userOperates = operateUserMap.get(operateCheckId);
                    if (CollectionUtils.isEmpty(userOperates)) continue;
                    courseUserTaskVos = var26_26;
                    Integer n10 = var26_26.intValue() + 1;
                    trainingPaperUserTurns = n10;
                    Integer num1 = 0;
                    Integer num2 = 0;
                    for (UserOperate userOperate : userOperates) {
                        if (userOperate.getStatus() == null || userOperate.getStatus() < 2) continue;
                        object = num1;
                        n4 = num1 = Integer.valueOf(num1 + 1);
                        if (userOperate.getIsPass() == null || userOperate.getIsPass() != 1) continue;
                        num2 = 1;
                    }
                    OperateCheck operateCheck = (OperateCheck)operateCheckMap.get(operateCheckId);
                    if (!ObjectUtils.isEmpty((Object)operateCheck) && (operateCheck.getCheckType() == 0 && num1.compareTo(operateCheck.getCheckNumber()) >= 0 || operateCheck.getCheckType() != 0 && num1.compareTo(0) > 0)) {
                        n9 = finishNum;
                        finishNum = finishNum + 1;
                        object = finishNum;
                    }
                    if (!ObjectUtils.isEmpty((Object)operateCheck) && "1".equals(operateCheck.getCheckScoreChoice())) {
                        num2 = 0;
                        if (userOperates.get(0).getIsPass() != null && userOperates.get(0).getIsPass() == 1) {
                            num2 = 1;
                        }
                    }
                    if (num2 != 1) continue;
                    n9 = passNum;
                    passNum = passNum + 1;
                    object = passNum;
                }
            }
            if (var26_26.intValue() == 0 || finishNum == 0) continue;
            BigDecimal finishRate = var26_26.intValue() == 0 ? null : new BigDecimal(finishNum).divide(new BigDecimal(var26_26.intValue()), 4, 4);
            BigDecimal bigDecimal = passRate = var26_26.intValue() == 0 ? null : new BigDecimal(passNum).divide(new BigDecimal(var26_26.intValue()), 4, 4);
            if (dep.compareTo(depId) == 0) {
                rate1 = finishRate;
                rate2 = passRate;
            }
            if (finishRate != null) {
                finishList.add(finishRate);
            }
            if (passRate == null) continue;
            passList.add(passRate);
        }
        Integer finishRinkingNum = 0;
        Integer passRinkingNum = 0;
        if (!CollectionUtils.isEmpty(finishList)) {
            if (rate1 != null) {
                finishList = finishList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                for (BigDecimal bigDecimal : finishList) {
                    n2 = finishRinkingNum;
                    n = finishRinkingNum = Integer.valueOf(finishRinkingNum + 1);
                    if (rate1.compareTo(bigDecimal) != 0) continue;
                    break;
                }
            } else {
                finishRinkingNum = finishList.size() + 1;
            }
        }
        if (!CollectionUtils.isEmpty(passList)) {
            if (rate1 != null) {
                passList = passList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                for (BigDecimal bigDecimal : passList) {
                    n2 = passRinkingNum;
                    n = passRinkingNum = Integer.valueOf(passRinkingNum + 1);
                    if (rate2.compareTo(bigDecimal) != 0) continue;
                    break;
                }
            } else {
                passRinkingNum = passList.size() + 1;
            }
        }
        maps.put("finishRinkingNum", finishRinkingNum);
        maps.put("passRinkingNum", passRinkingNum);
        return maps;
    }

    @Override
    public List<TrainingHomePageVo> selectTrainingHomeJob(TrainingHomePageVo trainingHomePageVo, Users user) {
        ArrayList<TrainingHomePageVo> trainingHomePageVoList = new ArrayList<TrainingHomePageVo>();
        ArrayList<Integer> userIdList = new ArrayList();
        UserIdAndDepIdMo mo = new UserIdAndDepIdMo();
        mo.setUserId(user.getId());
        mo.setGroupId(user.getGroupId());
        mo.setDepId(trainingHomePageVo.getDepId());
        BaseResult base = this.userApi.getUserByDepId(mo);
        if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData())) && !base.getIsError().booleanValue()) {
            List<Integer> taskIdList;
            List<TrainingJobStageTaskVo> trainingJobStageTaskVoList;
            List<TrainingUserViewTimeVo> userViewTimeVoList;
            userIdList = ((List)base.getData()).stream().map(OrganizeUserPojo::getId).collect(Collectors.toList());
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
            if (!(CollectionUtils.isEmpty(userIdList) || CollectionUtils.isEmpty(userViewTimeVoList = this.trainingUserViewTimeMapper.selectLastJobByUserTime(userIdList)) || CollectionUtils.isEmpty(trainingJobStageTaskVoList = this.trainingJobStageTaskMapper.selectJobMapByTaskId(taskIdList = userViewTimeVoList.stream().map(TrainingUserViewTime::getTaskId).distinct().collect(Collectors.toList()))))) {
                Map data;
                List usersDutiesPojoList;
                Map<Object, Object> dutiesMap = new HashMap();
                BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(userIdList, user.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
                if (userByDutiesIdOrUserId != null && !ObjectUtils.isEmpty((Object)userByDutiesIdOrUserId.getData()) && !CollectionUtils.isEmpty((Collection)(usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString((data = (Map)userByDutiesIdOrUserId.getData()).get("date")), UsersDutiesPojo.class)))) {
                    dutiesMap = usersDutiesPojoList.stream().collect(Collectors.toMap(UsersDutiesPojo::getId, Function.identity()));
                }
                List jobIdList = null;
                Map<Object, Object> trainingJobCertificationVoMap = new HashMap();
                Map<Object, Object> mapMap = new HashMap();
                List<Integer> mapIdList = trainingJobStageTaskVoList.stream().map(TrainingJobStageTaskVo::getMapId).distinct().collect(Collectors.toList());
                List<TrainingJobCertificationVo> trainingJobCertificationVoList = this.trainingJobCertificationMapper.selectMaxLastSortMapJob(user.getGroupId(), null, mapIdList);
                if (!CollectionUtils.isEmpty(trainingJobCertificationVoList)) {
                    trainingJobCertificationVoMap = trainingJobCertificationVoList.stream().collect(Collectors.groupingBy(TrainingJobCertification::getPostId));
                    mapMap = trainingJobCertificationVoList.stream().collect(Collectors.groupingBy(TrainingJobCertificationVo::getMapId));
                    jobIdList = trainingJobCertificationVoList.stream().map(TrainingJobCertification::getId).distinct().collect(Collectors.toList());
                }
                Map taskIdMap = trainingJobStageTaskVoList.stream().collect(Collectors.toMap(TrainingJobStageTask::getId, Function.identity()));
                Map<Object, Object> trainingJobStageTaskMap = new HashMap();
                Map<Object, Object> trainingJobUserTaskMap = new HashMap();
                if (!CollectionUtils.isEmpty(jobIdList)) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    wrapper1.in(TrainingJobStageTask::getJobId, jobIdList);
                    List trainingJobStageTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)trainingJobStageTaskList)) {
                        trainingJobStageTaskMap = trainingJobStageTaskList.stream().collect(Collectors.groupingBy(TrainingJobStageTask::getJobId));
                    }
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingJobUserTask::getJobId, jobIdList)).in(TrainingJobUserTask::getUserId, userIdList)).eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                    List trainingJobUserTaskList = this.trainingJobUserTaskMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                        trainingJobUserTaskMap = trainingJobUserTaskList.stream().collect(Collectors.groupingBy(TrainingJobUserTask::getUserId));
                    }
                }
                TrainingHomePageVo trainingHomePage = null;
                for (TrainingUserViewTimeVo trainingUserViewTimeVo : userViewTimeVoList) {
                    TrainingJobStageTaskVo trainingJobStageTaskVo = (TrainingJobStageTaskVo)taskIdMap.get(trainingUserViewTimeVo.getTaskId());
                    trainingHomePage = new TrainingHomePageVo();
                    trainingHomePage.setUserId(trainingUserViewTimeVo.getUserId());
                    UsersPojo pojo = usersPojoMap.get(trainingUserViewTimeVo.getUserId());
                    trainingHomePage.setShowName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                    trainingHomePage.setThumbUrl(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getThumbUrl());
                    if (ObjectUtils.isEmpty((Object)trainingJobStageTaskVo)) continue;
                    trainingHomePage.setMapId(trainingJobStageTaskVo.getMapId());
                    trainingHomePage.setMapName(trainingJobStageTaskVo.getMapName());
                    trainingHomePage.setJobId(trainingJobStageTaskVo.getJobId());
                    Integer lastSort = trainingJobStageTaskVo.getSort();
                    UsersDutiesPojo usersDutiesPojo = (UsersDutiesPojo)dutiesMap.get(trainingUserViewTimeVo.getUserId());
                    if (!ObjectUtils.isEmpty((Object)usersDutiesPojo)) {
                        Integer postId = usersDutiesPojo.getDutiesId();
                        List trainingJobCertificationVos = (List)trainingJobCertificationVoMap.get(postId);
                        TrainingJobCertificationVo trainingJobCertificationVo = null;
                        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationVos)) {
                            for (TrainingJobCertificationVo jobCertificationVo : trainingJobCertificationVos) {
                                if (jobCertificationVo.getMapId().compareTo(trainingJobStageTaskVo.getMapId()) != 0) continue;
                                trainingJobCertificationVo = jobCertificationVo;
                            }
                        }
                        if (!ObjectUtils.isEmpty(trainingJobCertificationVo)) {
                            lastSort = trainingJobCertificationVo.getLastSort() == null ? trainingJobCertificationVo.getSort() : trainingJobCertificationVo.getLastSort();
                        }
                    }
                    List jobStageTaskList = (List)trainingJobStageTaskMap.get(trainingJobStageTaskVo.getJobId());
                    List jobUserTaskList = (List)trainingJobUserTaskMap.get(trainingUserViewTimeVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)jobUserTaskList)) {
                        jobUserTaskList = jobUserTaskList.stream().filter(e -> e.getJobId().compareTo(trainingJobStageTaskVo.getJobId()) == 0).collect(Collectors.toList());
                    }
                    Integer taskNum = 0;
                    Integer finishNum = 0;
                    if (!CollectionUtils.isEmpty((Collection)jobStageTaskList)) {
                        taskNum = jobStageTaskList.size();
                    }
                    if (!CollectionUtils.isEmpty(jobUserTaskList)) {
                        finishNum = jobUserTaskList.size();
                    }
                    if (finishNum.compareTo(taskNum) >= 0 && lastSort > trainingJobStageTaskVo.getSort()) {
                        List taskList;
                        Integer jobId = null;
                        List jobCertificationVos = (List)mapMap.get(trainingJobStageTaskVo.getMapId());
                        for (TrainingJobCertificationVo vo : jobCertificationVos) {
                            if (vo.getSort() != trainingJobStageTaskVo.getSort() + 1) continue;
                            jobId = vo.getId();
                        }
                        if (jobId != null && !CollectionUtils.isEmpty((Collection)(taskList = (List)trainingJobStageTaskMap.get(jobId)))) {
                            taskNum = taskList.size();
                            finishNum = 0;
                            trainingHomePage.setJobId(jobId);
                        }
                    }
                    trainingHomePage.setTaskNum(taskNum);
                    trainingHomePage.setFinishNum(finishNum);
                    trainingHomePageVoList.add(trainingHomePage);
                }
            }
        }
        return trainingHomePageVoList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getStudyInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        List<Integer> roleUserId;
        HomeStudyInfo info;
        block8: {
            info = new HomeStudyInfo();
            roleUserId = new ArrayList<Integer>();
            Boolean isSuper = this.commonRemoteService.isSuper(userId);
            if (!isSuper.booleanValue()) {
                BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
                if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    roleUserId = (List)userResult.getData();
                    break block8;
                } else {
                    info.setStudyRate("-");
                    info.setStudyTime("0m");
                    return JsonResult.success((Object)info);
                }
            }
            BaseResult result = this.userApi.getSimpleUserByKeyWord(enterpriseId, null, null);
            if (result != null && !CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                roleUserId = ((List)result.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
            }
        }
        int userNum = this.trainingUserViewTimeMapper.groupByUserNum(enterpriseId, roleUserId, startTime, endTime);
        info.setStudyNum(userNum);
        info.setStudyRate(userNum * 100 / roleUserId.size() + "%");
        Integer sunTime = this.trainingUserViewTimeMapper.getSumViewTime(enterpriseId, roleUserId, startTime, endTime);
        if (sunTime == null) {
            sunTime = 0;
        }
        int sumViewTime = 0;
        sumViewTime = userNum == 0 ? 0 : sunTime / userNum;
        if (sumViewTime == 0) {
            info.setStudyTime("0m");
            return JsonResult.success((Object)info);
        }
        if (sumViewTime < 60) {
            info.setStudyTime("<1m");
            return JsonResult.success((Object)info);
        }
        if (sumViewTime < 3600) {
            int remainingSeconds = sumViewTime % 3600;
            int minutes = remainingSeconds / 60;
            info.setStudyTime(minutes + "m");
            return JsonResult.success((Object)info);
        }
        int hours = sumViewTime / 3600;
        int remainingSeconds = sumViewTime % 3600;
        int minutes = remainingSeconds / 60;
        info.setStudyTime(hours + "h" + minutes + "m");
        return JsonResult.success((Object)info);
    }

    @Override
    public String getProjectDataInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        ProjectHomeDataInfo info = new ProjectHomeDataInfo();
        List<Integer> roleUserId = new ArrayList<Integer>();
        Boolean isSuper = this.commonRemoteService.isSuper(userId);
        if (!isSuper.booleanValue()) {
            BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
            if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                roleUserId = (List)userResult.getData();
            } else {
                return JsonResult.success((Object)info);
            }
        }
        int projectNum = this.trainingLearnUserMapper.groupByShiftNum(enterpriseId, roleUserId, startTime, endTime);
        int projectCoverNum = this.trainingLearnUserMapper.groupByUserNum(enterpriseId, roleUserId, startTime, endTime);
        int projectFinishNum = this.trainingLearnUserMapper.groupByFinishUserNum(enterpriseId, roleUserId, startTime, endTime);
        info.setProjectNum(projectNum);
        info.setProjectCoverNum(projectCoverNum);
        info.setProjectFinishNum(projectFinishNum);
        return JsonResult.success((Object)info);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getPlanDataInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        PlanHomeDataInfo info = new PlanHomeDataInfo();
        LambdaQueryWrapper courseWrapper = new LambdaQueryWrapper();
        courseWrapper.eq(TrainingCourse::getEnterpriseId, (Object)enterpriseId);
        courseWrapper.between(TrainingCourse::getCreateTime, (Object)startTime, (Object)endTime);
        courseWrapper.ne(TrainingCourse::getStatus, (Object)0);
        List courseList = this.trainingCourseMapper.selectList((Wrapper)courseWrapper);
        if (CollectionUtils.isEmpty((Collection)courseList)) {
            info.setPlanNum(0);
            info.setPlanCoverNum(0);
            info.setPlanFinishNum(0);
            return JsonResult.success((Object)info);
        }
        Boolean isSuper = this.commonRemoteService.isSuper(userId);
        if (!isSuper.booleanValue()) {
            BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
            if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                List roleUserId = (List)userResult.getData();
                int planNum = this.trainingCourseUserTaskMapper.groupByCourseNum(courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()), roleUserId);
                info.setPlanNum(planNum);
                int planCoverNum = this.trainingCourseUserTaskMapper.groupByUserNum(courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()), roleUserId);
                info.setPlanCoverNum(planCoverNum);
                LambdaQueryWrapper analyseWrapper = new LambdaQueryWrapper();
                analyseWrapper.in(TrainingCourseUserAnalyse::getCourseId, (Collection)courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()));
                analyseWrapper.eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
                analyseWrapper.in(TrainingCourseUserAnalyse::getUserId, (Collection)roleUserId);
                List planFinishList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)analyseWrapper);
                if (CollectionUtils.isEmpty((Collection)planFinishList)) {
                    info.setPlanFinishNum(0);
                    return JsonResult.success((Object)info);
                }
                info.setPlanFinishNum(planFinishList.size());
                return JsonResult.success((Object)info);
            }
            info.setPlanNum(0);
            info.setPlanCoverNum(0);
            info.setPlanFinishNum(0);
            return JsonResult.success((Object)info);
        }
        info.setPlanNum(courseList.size());
        int planCoverNum = this.trainingCourseUserTaskMapper.groupByUserNum(courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()), null);
        info.setPlanCoverNum(planCoverNum);
        LambdaQueryWrapper analyseWrapper = new LambdaQueryWrapper();
        analyseWrapper.in(TrainingCourseUserAnalyse::getCourseId, (Collection)courseList.stream().map(TrainingCourse::getId).collect(Collectors.toList()));
        analyseWrapper.eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
        List planFinishList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)analyseWrapper);
        if (CollectionUtils.isEmpty((Collection)planFinishList)) {
            info.setPlanFinishNum(0);
            return JsonResult.success((Object)info);
        }
        info.setPlanFinishNum(planFinishList.size());
        return JsonResult.success((Object)info);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getTrainingDataInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        Iterator iterator;
        Users users;
        int trainingNum;
        List roleUserId;
        List trainingList;
        TrainingHomeDataInfo info;
        block14: {
            Boolean isSuper;
            info = new TrainingHomeDataInfo();
            LambdaQueryWrapper trainingWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)trainingWrapper.eq(Training::getEnterpriseId, (Object)enterpriseId)).eq(Training::getIsDel, (Object)0);
            trainingWrapper.between(Training::getStartTime, (Object)startTime, (Object)endTime);
            trainingWrapper.eq(Training::getStatus, (Object)2);
            trainingList = this.trainingMapper.selectList((Wrapper)trainingWrapper);
            if (CollectionUtils.isEmpty((Collection)trainingList)) {
                info.setTrainingNum(0);
            }
            if (!(isSuper = this.commonRemoteService.isSuper(userId)).booleanValue()) {
                BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
                if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    roleUserId = (List)userResult.getData();
                    trainingNum = 0;
                    users = new Users();
                    users.setId(userId);
                    users.setGroupId(enterpriseId);
                    iterator = trainingList.iterator();
                    break block14;
                } else {
                    info.setTrainingNum(0);
                    info.setTrainingUserNum(0);
                    info.setTrainingStudyTime("0m");
                    return JsonResult.success((Object)info);
                }
            }
            info.setTrainingNum(trainingList.size());
            LambdaQueryWrapper timeWrapper = new LambdaQueryWrapper();
            timeWrapper.in(TrainingUserViewTime::getEnterpriseId, new Object[]{enterpriseId});
            timeWrapper.between(TrainingUserViewTime::getCreateTime, (Object)startTime, (Object)endTime);
            List timeList = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)timeWrapper);
            if (CollectionUtils.isEmpty((Collection)timeList)) {
                info.setTrainingUserNum(0);
                info.setTrainingStudyTime("0m");
                return JsonResult.success((Object)info);
            }
            Set userNum = timeList.stream().map(TrainingUserViewTime::getUserId).collect(Collectors.toSet());
            info.setTrainingUserNum(userNum.size());
            Integer sumViewTime = timeList.stream().map(e -> e.getViewTime()).reduce(Integer::sum).get() / userNum.size();
            if (sumViewTime == 0) {
                info.setTrainingStudyTime("0m");
                return JsonResult.success((Object)info);
            }
            if (sumViewTime < 60) {
                info.setTrainingStudyTime("<1m");
                return JsonResult.success((Object)info);
            }
            if (sumViewTime < 3600) {
                int remainingSeconds = sumViewTime % 3600;
                int minutes = remainingSeconds / 60;
                info.setTrainingStudyTime(minutes + "m");
                return JsonResult.success((Object)info);
            }
            int hours = sumViewTime / 3600;
            int remainingSeconds = sumViewTime % 3600;
            int minutes = remainingSeconds / 60;
            info.setTrainingStudyTime(hours + "h" + minutes + "m");
            return JsonResult.success((Object)info);
        }
        while (iterator.hasNext()) {
            Training training = (Training)iterator.next();
            boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(users, training.getId());
            if (trainContainsAll) {
                ++trainingNum;
                continue;
            }
            List<Integer> trainingIdList = trainingList.stream().map(Training::getId).collect(Collectors.toList());
            Map<Integer, List<Integer>> trainingUserMap = this.materialPermissionFacade.getUserIdMapByTrainIdList(trainingIdList, users);
            HashSet trainingUserList = Sets.newHashSet((Iterable)trainingUserMap.get(training.getId()));
            boolean isTrue = roleUserId.stream().anyMatch(trainingUserList::contains);
            if (!isTrue) continue;
            ++trainingNum;
        }
        info.setTrainingNum(trainingNum);
        LambdaQueryWrapper timeWrapper = new LambdaQueryWrapper();
        timeWrapper.between(TrainingUserViewTime::getCreateTime, (Object)startTime, (Object)endTime);
        timeWrapper.in(TrainingUserViewTime::getUserId, (Collection)roleUserId);
        List timeList = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)timeWrapper);
        if (CollectionUtils.isEmpty((Collection)timeList)) {
            info.setTrainingUserNum(0);
            info.setTrainingStudyTime("0m");
            return JsonResult.success((Object)info);
        }
        Set userNum = timeList.stream().map(TrainingUserViewTime::getUserId).collect(Collectors.toSet());
        info.setTrainingUserNum(userNum.size());
        Integer sumViewTime = timeList.stream().map(e -> e.getViewTime()).reduce(Integer::sum).get() / userNum.size();
        if (sumViewTime == 0) {
            info.setTrainingStudyTime("0m");
            return JsonResult.success((Object)info);
        }
        if (sumViewTime < 60) {
            info.setTrainingStudyTime("<1m");
            return JsonResult.success((Object)info);
        }
        if (sumViewTime < 3600) {
            int remainingSeconds = sumViewTime % 3600;
            int minutes = remainingSeconds / 60;
            info.setTrainingStudyTime(minutes + "m");
            return JsonResult.success((Object)info);
        }
        int hours = sumViewTime / 3600;
        int remainingSeconds = sumViewTime % 3600;
        int minutes = remainingSeconds / 60;
        info.setTrainingStudyTime(hours + "h" + minutes + "m");
        return JsonResult.success((Object)info);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getPaperDataInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        Object userWrapper;
        Iterator iterator;
        int paperNum;
        List roleUserId;
        List paperList;
        PaperHomeDataInfo info;
        block19: {
            info = new PaperHomeDataInfo();
            LambdaQueryWrapper paperWrapper = new LambdaQueryWrapper();
            paperWrapper.eq(TrainingPaper::getEnterpriseId, (Object)enterpriseId);
            paperWrapper.between(TrainingPaper::getCreateTime, (Object)startTime, (Object)endTime);
            paperWrapper.eq(TrainingPaper::getIsTraining, (Object)0);
            paperWrapper.isNull(TrainingPaper::getProjectShow);
            paperWrapper.ne(TrainingPaper::getPaperState, (Object)0);
            paperList = this.trainingPaperMapper.selectList((Wrapper)paperWrapper);
            if (CollectionUtils.isEmpty((Collection)paperList)) {
                info.setPaperNum(0);
                info.setPaperUserNum(0);
                info.setPaperPassRate("-");
                return JsonResult.success((Object)info);
            }
            Boolean isSuper = this.commonRemoteService.isSuper(userId);
            if (!isSuper.booleanValue()) {
                BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
                if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    roleUserId = (List)userResult.getData();
                    paperNum = 0;
                    iterator = paperList.iterator();
                    break block19;
                } else {
                    info.setPaperNum(0);
                    info.setPaperUserNum(0);
                    info.setPaperPassRate("-");
                    return JsonResult.success((Object)info);
                }
            }
            info.setPaperNum(paperList.size());
            LambdaQueryWrapper userpaperWrapper = new LambdaQueryWrapper();
            userpaperWrapper.in(TrainingUserPaper::getTrainingPaperId, (Collection)paperList.stream().map(TrainingPaper::getId).collect(Collectors.toList()));
            userpaperWrapper.eq(TrainingUserPaper::getSourceType, (Object)2);
            List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)userpaperWrapper);
            if (CollectionUtils.isEmpty((Collection)userPaperList)) {
                info.setPaperUserNum(0);
                info.setPaperPassRate("-");
                return JsonResult.success((Object)info);
            }
            info.setPaperUserNum(userPaperList.size());
            int passNum = 0;
            Iterator iterator2 = paperList.iterator();
            while (true) {
                TrainingExam exam;
                if (!iterator2.hasNext()) {
                    info.setPaperPassRate(new BigDecimal(passNum * 100).divide(new BigDecimal(userPaperList.size()), 2, 4) + "%");
                    return JsonResult.success((Object)info);
                }
                TrainingPaper paper = (TrainingPaper)iterator2.next();
                int passScore = 60;
                if (paper.getExamId() != null && !ObjectUtils.isEmpty((Object)(exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId())))) {
                    passScore = exam.getScore().intValue() * paper.getPassLine() / 100;
                }
                LambdaQueryWrapper passWrapper = new LambdaQueryWrapper();
                passWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
                passWrapper.gt(TrainingUserPaper::getScore, (Object)passScore);
                passWrapper.eq(TrainingUserPaper::getSourceType, (Object)2);
                List passList = this.trainingUserPaperMapper.selectList((Wrapper)passWrapper);
                passNum += passList.size();
            }
        }
        while (iterator.hasNext()) {
            TrainingPaper paper = (TrainingPaper)iterator.next();
            HashSet<Object> myUserIds = new HashSet<Object>();
            if (paper.getLookLevel() != null && paper.getLookLevel() == 1) {
                boolean isTrue;
                List<Integer> orgUserIds;
                List<Integer> tagUserIds;
                List<Integer> roleUserIds;
                userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(TrainingPaperUser::getEnterpriseId, (Object)enterpriseId);
                userWrapper.eq(TrainingPaperUser::getPaperId, (Object)paper.getId());
                List list = this.trainingPaperUserMapper.selectList((Wrapper)userWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                List<Integer> roleIdList = list.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<String> organizeIdList = list.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<Integer> tagIdList = list.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List whoCanSeeList = list.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                myUserIds.addAll(whoCanSeeList);
                if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(roleUserIds = this.userUtilService.selectUsersByRoles(roleIdList, enterpriseId))) {
                    myUserIds.addAll(roleUserIds);
                }
                if (!CollectionUtils.isEmpty(tagIdList) && !CollectionUtils.isEmpty(tagUserIds = this.userUtilService.selectUserIdsByTagIds(tagIdList, enterpriseId, userId))) {
                    myUserIds.addAll(tagUserIds);
                }
                if (!CollectionUtils.isEmpty(organizeIdList) && !CollectionUtils.isEmpty(orgUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdList, enterpriseId))) {
                    myUserIds.addAll(orgUserIds);
                }
                if (!(isTrue = roleUserId.stream().anyMatch(myUserIds::contains))) continue;
                ++paperNum;
                continue;
            }
            ++paperNum;
        }
        info.setPaperNum(paperNum);
        LambdaQueryWrapper userpaperWrapper = new LambdaQueryWrapper();
        userpaperWrapper.in(TrainingUserPaper::getTrainingPaperId, (Collection)paperList.stream().map(TrainingPaper::getId).collect(Collectors.toList()));
        userpaperWrapper.in(TrainingUserPaper::getUserId, (Collection)roleUserId);
        userpaperWrapper.eq(TrainingUserPaper::getSourceType, (Object)2);
        List userPaperList = this.trainingUserPaperMapper.selectList((Wrapper)userpaperWrapper);
        if (CollectionUtils.isEmpty((Collection)userPaperList)) {
            info.setPaperUserNum(0);
            info.setPaperPassRate("-");
            return JsonResult.success((Object)info);
        }
        info.setPaperUserNum(userPaperList.stream().map(TrainingUserPaper::getTrainingPaperId).collect(Collectors.toSet()).size());
        int passNum = 0;
        userWrapper = paperList.iterator();
        while (true) {
            if (!userWrapper.hasNext()) {
                info.setPaperPassRate(new BigDecimal(passNum * 100).divide(new BigDecimal(userPaperList.size()), 2, 4) + "%");
                return JsonResult.success((Object)info);
            }
            TrainingPaper paper = (TrainingPaper)userWrapper.next();
            int passScore = 0;
            if (paper.getExamId() != null) {
                TrainingExam exam = (TrainingExam)this.trainingExamMapper.selectById(paper.getExamId());
                if (exam != null) {
                    passScore = exam.getScore().intValue() * paper.getPassLine() / 100;
                }
            } else {
                passScore = 60;
            }
            LambdaQueryWrapper passWrapper = new LambdaQueryWrapper();
            passWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
            passWrapper.gt(TrainingUserPaper::getScore, (Object)passScore);
            passWrapper.eq(TrainingUserPaper::getSourceType, (Object)2);
            passWrapper.in(TrainingUserPaper::getUserId, (Collection)roleUserId);
            List passList = this.trainingUserPaperMapper.selectList((Wrapper)passWrapper);
            passNum += passList.size();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getOperateDataInfo(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        PaperHomeDataInfo info = new PaperHomeDataInfo();
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(OperateCheck::getEnterpriseId, (Object)enterpriseId);
        checkWrapper.between(OperateCheck::getCreateTime, (Object)startTime, (Object)endTime);
        checkWrapper.ne(OperateCheck::getStatus, (Object)0);
        List paperList = this.operateCheckMapper.selectList((Wrapper)checkWrapper);
        if (CollectionUtils.isEmpty((Collection)paperList)) {
            info.setPaperNum(0);
            return JsonResult.success((Object)info);
        }
        Boolean isSuper = this.commonRemoteService.isSuper(userId);
        if (!isSuper.booleanValue()) {
            BaseResult userResult = this.userApi.getUserPrivilegedUsers(userId, enterpriseId);
            if (userResult != null && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                List roleUserId = (List)userResult.getData();
                LambdaQueryWrapper userpaperWrapper = new LambdaQueryWrapper();
                userpaperWrapper.in(UserOperate::getOperateCheckId, (Collection)paperList.stream().map(OperateCheck::getId).collect(Collectors.toList()));
                userpaperWrapper.in(UserOperate::getUserId, (Collection)roleUserId);
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(2);
                statusList.add(3);
                userpaperWrapper.in(UserOperate::getStatus, statusList);
                List userPaperList = this.userOperateMapper.selectList((Wrapper)userpaperWrapper);
                if (CollectionUtils.isEmpty((Collection)userPaperList)) {
                    info.setPaperNum(0);
                    info.setPaperUserNum(0);
                    info.setPaperPassRate("-");
                    return JsonResult.success((Object)info);
                }
                if (!CollectionUtils.isEmpty((Collection)paperList)) {
                    LambdaQueryWrapper checkUserWrapper = new LambdaQueryWrapper();
                    checkUserWrapper.in(OperateCheckUser::getOperateCheckId, (Collection)paperList.stream().map(OperateCheck::getId).collect(Collectors.toSet()));
                    checkUserWrapper.in(OperateCheckUser::getUserId, (Collection)roleUserId);
                    List checkUserList = this.operateCheckUserMapper.selectList((Wrapper)checkUserWrapper);
                    if (!CollectionUtils.isEmpty((Collection)checkUserList)) {
                        info.setPaperNum(checkUserList.stream().map(OperateCheckUser::getOperateCheckId).collect(Collectors.toSet()).size());
                    }
                }
                info.setPaperUserNum(userPaperList.stream().map(UserOperate::getUserId).collect(Collectors.toSet()).size());
                int passNum = 0;
                LambdaQueryWrapper passUserWrapper = new LambdaQueryWrapper();
                passUserWrapper.in(UserOperate::getOperateCheckId, (Collection)paperList.stream().map(OperateCheck::getId).collect(Collectors.toList()));
                passUserWrapper.in(UserOperate::getUserId, (Collection)roleUserId);
                statusList.add(2);
                statusList.add(3);
                passUserWrapper.eq(UserOperate::getIsPass, (Object)1);
                userpaperWrapper.in(UserOperate::getUserId, (Collection)roleUserId);
                List passUserList = this.userOperateMapper.selectList((Wrapper)passUserWrapper);
                if (!CollectionUtils.isEmpty((Collection)passUserList)) {
                    passNum = passUserList.size();
                }
                info.setPaperPassRate(new BigDecimal(passNum * 100).divide(new BigDecimal(userPaperList.size()), 2, 4) + "%");
                return JsonResult.success((Object)info);
            }
            info.setPaperNum(0);
            info.setPaperUserNum(0);
            info.setPaperPassRate("-");
            return JsonResult.success((Object)info);
        }
        info.setPaperNum(paperList.size());
        LambdaQueryWrapper userpaperWrapper = new LambdaQueryWrapper();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(2);
        statusList.add(3);
        userpaperWrapper.in(UserOperate::getStatus, statusList);
        userpaperWrapper.in(UserOperate::getOperateCheckId, (Collection)paperList.stream().map(OperateCheck::getId).collect(Collectors.toList()));
        List userPaperList = this.userOperateMapper.selectList((Wrapper)userpaperWrapper);
        if (CollectionUtils.isEmpty((Collection)userPaperList)) {
            info.setPaperUserNum(0);
            info.setPaperPassRate("-");
            return JsonResult.success((Object)info);
        }
        info.setPaperUserNum(userPaperList.stream().map(UserOperate::getUserId).collect(Collectors.toSet()).size());
        int passNum = 0;
        LambdaQueryWrapper passUserWrapper = new LambdaQueryWrapper();
        passUserWrapper.in(UserOperate::getOperateCheckId, (Collection)paperList.stream().map(OperateCheck::getId).collect(Collectors.toList()));
        userpaperWrapper.in(UserOperate::getStatus, statusList);
        passUserWrapper.eq(UserOperate::getIsPass, (Object)1);
        List passUserList = this.userOperateMapper.selectList((Wrapper)passUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)passUserList)) {
            passNum = passUserList.size();
        }
        info.setPaperPassRate(new BigDecimal(passNum * 100).divide(new BigDecimal(userPaperList.size()), 2, 4) + "%");
        return JsonResult.success((Object)info);
    }

    @Override
    public String getTrainingRanking(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        List<TrainingRankingVo> info = this.trainingUserViewTimeTrainingMapper.getTrainingRanking(enterpriseId, startTime, endTime);
        if (!CollectionUtils.isEmpty(info)) {
            for (TrainingRankingVo vo : info) {
                Integer studyNum = this.trainingUserViewTimeTrainingMapper.getTrainingRankingUser(vo.getTrainingId(), enterpriseId, startTime, endTime);
                if (studyNum == null) {
                    vo.setStudyNum(0);
                    continue;
                }
                vo.setStudyNum(studyNum.intValue());
            }
        }
        return JsonResult.success(info);
    }

    @Override
    public String getMemberRanking(Integer enterpriseId, Integer userId, Date startTime, Date endTime) {
        List<MemberRankingVo> info = this.trainingUserViewTimeMaterialMapper.getMemberRanking(enterpriseId, startTime, endTime);
        if (!CollectionUtils.isEmpty(info)) {
            for (MemberRankingVo vo : info) {
                BaseResult userResult = this.userApi.getUserById(vo.getUserId());
                if (!userResult.getIsError().booleanValue()) {
                    UsersPojo pojo = (UsersPojo)userResult.getData();
                    vo.setShowName(pojo.getShowName());
                    vo.setStaffImageUrl(pojo.getThumbUrl());
                    ArrayList<Integer> viewerIdList = new ArrayList<Integer>();
                    viewerIdList.add(vo.getUserId());
                    Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(viewerIdList, enterpriseId);
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    vo.setOrganizeName(CollectionUtils.isEmpty(userStr) ? "" : String.join((CharSequence)";\n", userStr));
                }
                if (vo.getViewTime() == 0) {
                    vo.setStudyTime("0m");
                    continue;
                }
                if (vo.getViewTime() < 60) {
                    vo.setStudyTime("<1m");
                    continue;
                }
                if (vo.getViewTime() < 3600) {
                    int remainingSeconds = vo.getViewTime() % 3600;
                    int minutes = remainingSeconds / 60;
                    vo.setStudyTime(minutes + "m");
                    continue;
                }
                int hours = vo.getViewTime() / 3600;
                int remainingSeconds = vo.getViewTime() % 3600;
                int minutes = remainingSeconds / 60;
                vo.setStudyTime(hours + "h" + minutes + "m");
            }
        }
        return JsonResult.success(info);
    }
}

