/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Throwables;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DutiesIdsMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobExamineMapper;
import com.ovopark.training.mapper.TrainingJobMapAndCertificationMapper;
import com.ovopark.training.mapper.TrainingJobMapMapper;
import com.ovopark.training.mapper.TrainingJobShiftTaskMapper;
import com.ovopark.training.mapper.TrainingJobStageMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeJobMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.UserOperateMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobExamine;
import com.ovopark.training.model.TrainingJobMap;
import com.ovopark.training.model.TrainingJobMapAndCertification;
import com.ovopark.training.model.TrainingJobShiftTask;
import com.ovopark.training.model.TrainingJobStage;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobStudentAnalyse;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.UserOperate;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingJobExcelService;
import com.ovopark.training.service.TrainingJobMapService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.vo.TrainingJobCertificationVo;
import com.ovopark.training.vo.TrainingJobMapAndCertificationVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingJobStudentAnalyseVo;
import com.ovopark.training.vo.TrainingJobUserTaskVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TrainingJobExcelServiceImpl
implements TrainingJobExcelService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobExcelServiceImpl.class);
    @Autowired
    private TrainingJobUserTaskMapper jobUserTaskMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private TrainingJobMapService jobMapService;
    @Resource
    private TrainingJobCertificationMapper jobCertificationMapper;
    @Resource
    private TrainingJobMapMapper jobMapMapper;
    @Resource
    private TrainingJobStageMapper jobStageMapper;
    @Resource
    private TrainingJobStageTaskMapper jobStageTaskMapper;
    @Resource
    private TrainingJobUserMapper jobUserMapper;
    @Autowired
    private TrainingJobMapAndCertificationMapper jobMapAndCertificationMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingJobShiftTaskMapper jobShiftTaskMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private TrainingJobStudentAnalyseMapper jobStudentAnalyseMapper;
    @Autowired
    private TrainingJobExamineMapper jobExamineMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private UserOperateMapper trainingUserOperateMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserViewTimeJobMapper trainingUserViewTimeJobMapper;
    @Autowired
    private RoleApi roleApi;

    @Override
    public Page<TrainingJobStudentAnalyseVo> selectJobStudentDetailByPage(TrainingJobStudentAnalyseVo jobUserTaskVo, Users user) {
        Page<TrainingJobStudentAnalyseVo> page = new Page<TrainingJobStudentAnalyseVo>();
        page.setPageNumber(jobUserTaskVo.getPageNumber().intValue());
        page.setPageSize(jobUserTaskVo.getPageSize().intValue());
        page.setTotalCount(Long.valueOf(0L));
        try {
            List<Integer> userList = new ArrayList<Integer>();
            Map<String, Object> userMap = this.userUtilService.getCheckParameters(jobUserTaskVo.getUserName(), jobUserTaskVo.getDutiesId(), jobUserTaskVo.getOrganizeIds(), user);
            if (userMap.get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
                return page;
            }
            List<Object> jobList = this.selectJobByPara(jobUserTaskVo, user, userList);
            if (!CollectionUtils.isEmpty(jobList)) {
                userList = jobList.stream().map(TrainingJobStudentAnalyse::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<Integer> jobIds = jobList.stream().map(TrainingJobStudentAnalyse::getJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<TrainingJobStudentAnalyseVo> list = this.jobUserTaskMapper.selectJobStudentDetail(userList, jobIds, user.getGroupId(), null);
                jobList = this.selectJobByStatus(list, jobList, jobUserTaskVo.getLearnStatus());
                jobList = jobUserTaskVo.getGroupType() == 1 ? jobList.stream().sorted(Comparator.comparing(TrainingJobStudentAnalyse::getUserId).thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapId, Comparator.nullsFirst(Integer::compareTo)).reversed()).thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapSort, Comparator.nullsFirst(Integer::compareTo)))).collect(Collectors.toList()) : jobList.stream().sorted(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapId, Comparator.nullsFirst(Integer::compareTo)).reversed().thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapSort, Comparator.nullsFirst(Integer::compareTo))).thenComparing(Comparator.comparing(TrainingJobStudentAnalyse::getUserId))).collect(Collectors.toList());
                page = ListUtil.myPage(jobList, jobUserTaskVo.getPageNumber(), jobUserTaskVo.getPageSize());
                List pageList = page.getContent();
                List<Integer> userIdList = pageList.stream().map(TrainingJobStudentAnalyse::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, user.getGroupId());
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                    parameter.put("groupId", user.getGroupId());
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, user.getGroupId());
                Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, user.getGroupId());
                Iterator iterator = pageList.iterator();
                while (iterator.hasNext()) {
                    TrainingJobStudentAnalyseVo vo;
                    UsersPojo pojo = usersMap.get((vo = (TrainingJobStudentAnalyseVo)iterator.next()).getUserId());
                    vo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                    vo.setUserName(pojo == null ? "" : pojo.getShowName());
                    UserDutiesMo mo = dutiesMap.get(vo.getUserId());
                    vo.setDutiesName(mo == null ? "" : mo.getDutieName());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty(userStr)) {
                        vo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                        StringBuilder role = new StringBuilder();
                        for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                            role.append(rolePojo.getRoleName()).append(";\n");
                        }
                        vo.setRole(role.substring(0, role.length() - 2));
                    }
                    if (!CollectionUtils.isEmpty(parentMap)) {
                        vo.setParentName(parentMap.get(vo.getUserId()));
                    }
                    if (CollectionUtils.isEmpty(parentIdMap)) continue;
                    vo.setParentUserId(parentIdMap.get(vo.getUserId()));
                }
                page.setContent(pageList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return page;
    }

    @Override
    public List<TrainingJobStudentAnalyseVo> getJobStudentList(List<Integer> userIds, Users user, List<Integer> passStatus) {
        List<TrainingJobStudentAnalyseVo> jobList = Collections.emptyList();
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start("\u6839\u636e\u8ba4\u8bc1\u83b7\u53d6\u5b66\u5458\uff0c\u540c\u65f6\u5254\u9664\u4e0d\u7b26\u4eba\u5458");
            jobList = this.selectJobByPara(new TrainingJobStudentAnalyseVo(), user, userIds);
            stopWatch.stop();
            log.info("\u6839\u636e\u8ba4\u8bc1\u83b7\u53d6\u5b66\u5458\uff0c\u540c\u65f6\u5254\u9664\u4e0d\u7b26\u4eba\u5458\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
            if (!CollectionUtils.isEmpty(jobList)) {
                userIds = jobList.stream().map(TrainingJobStudentAnalyse::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<Integer> jobIds = jobList.stream().map(TrainingJobStudentAnalyse::getJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                stopWatch = new StopWatch();
                stopWatch.start("\u67e5\u8be2\u6709\u52a0\u5165\u8ba4\u8bc1\u7684\u8bb0\u5f55");
                List<TrainingJobStudentAnalyseVo> jobStudentList = this.jobUserTaskMapper.selectJobStudentDetail(userIds, jobIds, user.getGroupId(), null);
                stopWatch.stop();
                log.info("\u67e5\u8be2\u6709\u52a0\u5165\u8ba4\u8bc1\u7684\u8bb0\u5f55\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
                stopWatch = new StopWatch();
                stopWatch.start("\u67e5\u8be2\u5b66\u4e60\u72b6\u6001\u67e5\u8be2");
                jobList = this.getJobByStatus(jobStudentList, jobList, null, passStatus);
                stopWatch.stop();
                log.info("\u67e5\u8be2\u5b66\u4e60\u72b6\u6001\u67e5\u8be2\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
            }
        }
        catch (Exception e) {
            log.error("\u8ba4\u8bc1\u72b6\u6001\u67e5\u8be2 exception:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return jobList;
    }

    public List<TrainingJobStudentAnalyseVo> selectJobByPara(TrainingJobStudentAnalyseVo jobUserTaskVo, Users user, List<Integer> userList) {
        ArrayList<TrainingJobStudentAnalyseVo> list = new ArrayList<TrainingJobStudentAnalyseVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingJobCertification::getEnterpriseId, (Object)user.getGroupId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)jobUserTaskVo.getJobStatus()), TrainingJobCertification::getStatus, (Object)jobUserTaskVo.getJobStatus())).like(!org.springframework.util.StringUtils.isEmpty((Object)jobUserTaskVo.getCertificationName()), TrainingJobCertification::getCertificationName, (Object)jobUserTaskVo.getCertificationName());
        List jobList = this.jobCertificationMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)jobList)) {
            List<Integer> jobIdList = jobList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            List<TrainingJobStudentAnalyseVo> jobs = this.jobUserTaskMapper.selectJobNews(jobIdList, user.getGroupId());
            Map map = jobs.stream().collect(Collectors.toMap(TrainingJobStudentAnalyse::getJobId, Function.identity()));
            userList = !CollectionUtils.isEmpty(userList) ? this.userUtilService.selectChildUserList(userList, user, true) : this.userUtilService.selectChildUserList(null, user, false);
            Map<Integer, List<Integer>> jobUserMap = this.selectJobUserListByJobList(jobIdList);
            for (TrainingJobCertification job : jobList) {
                List<Integer> userIdList = jobUserMap.get(job.getId());
                if (!CollectionUtils.isEmpty(userList)) {
                    userIdList.retainAll(userList);
                }
                TrainingJobStudentAnalyseVo jobVo = (TrainingJobStudentAnalyseVo)map.get(job.getId());
                if (CollectionUtils.isEmpty(userIdList)) continue;
                for (Integer userId : userIdList) {
                    TrainingJobStudentAnalyseVo vo = new TrainingJobStudentAnalyseVo();
                    BeanUtils.copyProperties((Object)jobVo, (Object)vo);
                    vo.setLearnStatus(Integer.valueOf(1));
                    vo.setFinishTask(Integer.valueOf(0));
                    vo.setUserId(userId);
                    list.add(vo);
                }
            }
        }
        return list;
    }

    public Map<Integer, List<Integer>> selectJobUserListByJobList(List<Integer> jobIdList) {
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
        LambdaQueryWrapper jobMapWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)jobMapWrapper.in(TrainingJobMapAndCertification::getCertificationId, jobIdList)).orderByDesc(TrainingJobMapAndCertification::getId);
        List jobMapAndCertificationList = this.jobMapAndCertificationMapper.selectList((Wrapper)jobMapWrapper);
        Map<Object, Object> andMap = new HashMap();
        Map<Object, Object> mapMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)jobMapAndCertificationList)) {
            andMap = jobMapAndCertificationList.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getCertificationId, e -> new ArrayList<TrainingJobMapAndCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List mapIds = jobMapAndCertificationList.stream().map(TrainingJobMapAndCertification::getMapId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingJobMapAndCertification::getMapId, mapIds);
            List jobMaps = this.jobMapAndCertificationMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)jobMaps)) {
                mapMap = jobMaps.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getMapId, e -> new ArrayList<TrainingJobMapAndCertification>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        List<Object> jobIds = new ArrayList();
        HashMap<Integer, List<Object>> remainMap = new HashMap<Integer, List<Object>>();
        for (Integer jobId : jobIdList) {
            List jobMaps;
            TrainingJobMapAndCertification jobMapAndCertification;
            List andLlist = (List)andMap.get(jobId);
            List<Object> idList = new ArrayList<Integer>();
            idList.add(jobId);
            if (!(CollectionUtils.isEmpty((Collection)andLlist) || org.springframework.util.StringUtils.isEmpty((Object)(jobMapAndCertification = (TrainingJobMapAndCertification)andLlist.get(0))) || org.springframework.util.StringUtils.isEmpty((Object)jobMapAndCertification.getSort()) || CollectionUtils.isEmpty((Collection)(jobMaps = (List)mapMap.get(jobMapAndCertification.getMapId()))))) {
                for (TrainingJobMapAndCertification vo : jobMaps) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getSort())) continue;
                    if (vo.getSort() >= jobMapAndCertification.getSort()) {
                        idList.add(vo.getCertificationId());
                        continue;
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getLastSort()) || vo.getSort() > jobMapAndCertification.getSort() || vo.getLastSort() < jobMapAndCertification.getSort()) continue;
                    idList.add(vo.getCertificationId());
                }
            }
            idList = idList.stream().distinct().collect(Collectors.toList());
            remainMap.put(jobId, idList);
            jobIds.addAll(idList);
        }
        jobIds = jobIds.stream().distinct().collect(Collectors.toList());
        List jobCertificationList = this.jobCertificationMapper.selectBatchIds(jobIds);
        ArrayList jobUserList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)jobCertificationList)) {
            List userList;
            Integer enterpriseId = ((TrainingJobCertification)jobCertificationList.get(0)).getEnterpriseId();
            List postIdList = jobCertificationList.stream().map(TrainingJobCertification::getPostId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map jobCMap = jobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getId, Function.identity()));
            DutiesIdsMo mo = new DutiesIdsMo();
            mo.setGroupId(enterpriseId);
            mo.setDutieId(postIdList);
            BaseResult userListData = this.userApi.getSimpleUserByDutiesIds(mo);
            Map<Object, Object> pojoMap = new HashMap();
            if (userListData != null && !CollectionUtils.isEmpty((Collection)(userList = (List)userListData.getData()))) {
                pojoMap = userList.stream().collect(Collectors.toMap(UserDutiesMo::getDutieId, e -> new ArrayList<UserDutiesMo>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            for (Integer jobId : jobIdList) {
                ArrayList jobUsers = new ArrayList();
                List jobIdLists = (List)remainMap.get(jobId);
                for (Integer jobCId : jobIdLists) {
                    List moList;
                    TrainingJobCertification jobCertification = (TrainingJobCertification)jobCMap.get(jobCId);
                    if (org.springframework.util.StringUtils.isEmpty((Object)jobCertification) || CollectionUtils.isEmpty((Collection)(moList = (List)pojoMap.get(jobCertification.getPostId())))) continue;
                    jobUsers.addAll(moList.stream().map(UserDutiesMo::getUserId).collect(Collectors.toList()));
                }
                map.put(jobId, jobUsers);
            }
        }
        return map;
    }

    public List<TrainingJobStudentAnalyseVo> selectJobByStatus(List<TrainingJobStudentAnalyseVo> list, List<TrainingJobStudentAnalyseVo> jobList, Integer learnStatus) {
        if (!CollectionUtils.isEmpty(list)) {
            Map<Integer, List> jobMap = list.stream().collect(Collectors.toMap(TrainingJobStudentAnalyse::getJobId, e -> new ArrayList<TrainingJobStudentAnalyseVo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            ArrayList<TrainingJobStudentAnalyseVo> delList = new ArrayList<TrainingJobStudentAnalyseVo>();
            for (TrainingJobStudentAnalyseVo vo : jobList) {
                List stuVoList = jobMap.get(vo.getJobId());
                if (!CollectionUtils.isEmpty((Collection)stuVoList)) {
                    for (TrainingJobStudentAnalyseVo stu : stuVoList) {
                        if (!vo.getUserId().equals(stu.getUserId())) continue;
                        vo.setLearnStatus(stu.getLearnStatus());
                        vo.setPassStatus(stu.getPassStatus());
                        vo.setCreateTime(stu.getCreateTime());
                        vo.setId(stu.getId());
                        vo.setFinishTask(stu.getFinishTask());
                        vo.setXsScore(stu.getXsScore());
                        vo.setXxScore(stu.getXxScore());
                        vo.setStartTime(stu.getStartTime());
                        vo.setEndTime(stu.getEndTime());
                    }
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)learnStatus) || vo.getLearnStatus().equals(learnStatus)) continue;
                delList.add(vo);
            }
            if (!CollectionUtils.isEmpty(delList)) {
                jobList.removeAll(delList);
            }
        } else if (!org.springframework.util.StringUtils.isEmpty((Object)learnStatus) && learnStatus != 1) {
            jobList = new ArrayList<TrainingJobStudentAnalyseVo>();
        }
        if (!CollectionUtils.isEmpty(jobList)) {
            List jobIds = jobList.stream().map(TrainingJobStudentAnalyse::getJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(TrainingJobMapAndCertification::getCertificationId, jobIds)).orderByDesc(TrainingJobMapAndCertification::getId);
            List maps = this.jobMapAndCertificationMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                Map<Integer, List> andMap = maps.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getCertificationId, e -> new ArrayList<TrainingJobMapAndCertification>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
                for (TrainingJobStudentAnalyseVo vo : jobList) {
                    List andList = andMap.get(vo.getJobId());
                    if (CollectionUtils.isEmpty((Collection)andList)) continue;
                    TrainingJobMapAndCertification and = (TrainingJobMapAndCertification)andList.get(0);
                    vo.setMapId(and.getMapId());
                    vo.setMapSort(and.getSort());
                }
            }
        }
        return jobList;
    }

    private List<TrainingJobStudentAnalyseVo> getJobByStatus(List<TrainingJobStudentAnalyseVo> trainingJobStudentAnalyses, List<TrainingJobStudentAnalyseVo> jobList, Integer learnStatus, List<Integer> passStatus) {
        if (!CollectionUtils.isEmpty(trainingJobStudentAnalyses)) {
            Map<Integer, List<TrainingJobStudentAnalyseVo>> jobIdStudentAnalyseMap = trainingJobStudentAnalyses.stream().collect(Collectors.groupingBy(TrainingJobStudentAnalyse::getJobId));
            ArrayList delList = new ArrayList();
            jobList.stream().forEach(item -> {
                List studentAnalyses = (List)jobIdStudentAnalyseMap.get(item.getJobId());
                Map<Object, Object> userIdAnasMap = Collections.emptyMap();
                if (!CollectionUtils.isEmpty((Collection)studentAnalyses)) {
                    userIdAnasMap = studentAnalyses.stream().collect(Collectors.toMap(studentAnalyse -> studentAnalyse.getUserId(), studentAnalyse -> studentAnalyse, (item1, item2) -> item2));
                }
                if (!ObjectUtils.isEmpty(userIdAnasMap.get(item.getUserId()))) {
                    TrainingJobStudentAnalyseVo trainingJobStudentAnalyse = (TrainingJobStudentAnalyseVo)userIdAnasMap.get(item.getUserId());
                    item.setLearnStatus(trainingJobStudentAnalyse.getLearnStatus());
                    item.setPassStatus(trainingJobStudentAnalyse.getPassStatus());
                    item.setCreateTime(trainingJobStudentAnalyse.getCreateTime());
                    item.setId(trainingJobStudentAnalyse.getId());
                    item.setFinishTask(trainingJobStudentAnalyse.getFinishTask());
                    item.setXsScore(trainingJobStudentAnalyse.getXsScore());
                    item.setXxScore(trainingJobStudentAnalyse.getXxScore());
                    item.setStartTime(trainingJobStudentAnalyse.getStartTime());
                    item.setEndTime(trainingJobStudentAnalyse.getEndTime());
                }
            });
            if (!org.springframework.util.StringUtils.isEmpty((Object)learnStatus)) {
                jobList = jobList.stream().filter(item -> Objects.equals(item.getLearnTask(), learnStatus)).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(passStatus)) {
                jobList = jobList.stream().filter(item -> ObjectUtils.isEmpty((Object)item.getPassStatus()) || passStatus.contains(item.getPassStatus())).collect(Collectors.toList());
            }
        }
        return jobList;
    }

    public List<TrainingJobStudentAnalyseVo> delJobUserListByJobId(List<TrainingJobStudentAnalyseVo> list) {
        Map<Integer, List> jobMap = list.stream().collect(Collectors.toMap(TrainingJobStudentAnalyse::getJobId, e -> new ArrayList<TrainingJobStudentAnalyseVo>(Arrays.asList(e)), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        ArrayList<TrainingJobStudentAnalyseVo> delList = new ArrayList<TrainingJobStudentAnalyseVo>();
        for (Integer jobId : jobMap.keySet()) {
            List<Integer> userIdList = this.jobCertificationService.selectJobUserListByJobId(jobId);
            for (TrainingJobStudentAnalyseVo stu : jobMap.get(jobId)) {
                if (userIdList.contains(stu.getUserId())) continue;
                delList.add(stu);
            }
        }
        if (!CollectionUtils.isEmpty(delList)) {
            list.removeAll(delList);
        }
        return list;
    }

    @Override
    public List<TrainingJobStudentAnalyseVo> selectJobStudentDetail(TrainingJobStudentAnalyseVo jobUserTaskVo, Users user) {
        List<Object> jobList = new ArrayList<TrainingJobStudentAnalyseVo>();
        try {
            List<Integer> userList = new ArrayList<Integer>();
            Map<String, Object> userMap = this.userUtilService.getCheckParameters(jobUserTaskVo.getUserName(), jobUserTaskVo.getDutiesId(), jobUserTaskVo.getOrganizeIds(), user);
            if (userMap.get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
                return jobList;
            }
            jobList = this.selectJobByPara(jobUserTaskVo, user, userList);
            if (!CollectionUtils.isEmpty(jobList)) {
                userList = jobList.stream().map(TrainingJobStudentAnalyse::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<Integer> jobIds = jobList.stream().map(TrainingJobStudentAnalyse::getJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<TrainingJobStudentAnalyseVo> list = this.jobUserTaskMapper.selectJobStudentDetail(userList, jobIds, user.getGroupId(), null);
                jobList = this.selectJobByStatus(list, jobList, jobUserTaskVo.getLearnStatus());
                jobList = jobUserTaskVo.getGroupType() == 1 ? jobList.stream().sorted(Comparator.comparing(TrainingJobStudentAnalyse::getUserId).thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapId, Comparator.nullsFirst(Integer::compareTo)).reversed()).thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapSort, Comparator.nullsFirst(Integer::compareTo)))).collect(Collectors.toList()) : jobList.stream().sorted(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapId, Comparator.nullsFirst(Integer::compareTo)).reversed().thenComparing(Comparator.comparing(TrainingJobStudentAnalyseVo::getMapSort, Comparator.nullsFirst(Integer::compareTo))).thenComparing(Comparator.comparing(TrainingJobStudentAnalyse::getUserId))).collect(Collectors.toList());
                List<Integer> userIdList = jobList.stream().map(TrainingJobStudentAnalyse::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, user.getGroupId());
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                    parameter.put("groupId", user.getGroupId());
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, user.getGroupId());
                Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, user.getGroupId());
                Iterator<Object> iterator = jobList.iterator();
                while (iterator.hasNext()) {
                    TrainingJobStudentAnalyseVo vo;
                    UsersPojo pojo = usersMap.get((vo = (TrainingJobStudentAnalyseVo)iterator.next()).getUserId());
                    vo.setEmployeeNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                    vo.setUserName(pojo == null ? "" : pojo.getShowName());
                    vo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                    UserDutiesMo mo = dutiesMap.get(vo.getUserId());
                    vo.setDutiesName(mo == null ? "" : mo.getDutieName());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty(userStr)) {
                        vo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                        StringBuilder role = new StringBuilder();
                        for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                            role.append(rolePojo.getRoleName()).append(";\n");
                        }
                        vo.setRole(role.substring(0, role.length() - 2));
                    }
                    if (!CollectionUtils.isEmpty(parentMap)) {
                        vo.setParentName(parentMap.get(vo.getUserId()));
                    }
                    if (CollectionUtils.isEmpty(parentIdMap)) continue;
                    vo.setParentUserId(parentIdMap.get(vo.getUserId()));
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return jobList;
    }

    @Override
    public List selectJobList(Integer type, Users user) {
        ArrayList list;
        block9: {
            HashMap<String, Object> map;
            block10: {
                block8: {
                    list = new ArrayList();
                    map = null;
                    if (type != 1) break block8;
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper.eq(TrainingJobMap::getState, (Object)2)).eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingJobMap::getEnterpriseId, (Object)user.getGroupId());
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId())) {
                        wrapper.isNull(TrainingJobMap::getEnterpriseId);
                    }
                    wrapper.orderByDesc(TrainingJobMap::getId);
                    List voList = this.jobMapMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtils.isEmpty((Collection)voList)) break block9;
                    for (TrainingJobMap vo : voList) {
                        map = new HashMap<String, Object>();
                        map.put("id", vo.getId());
                        map.put("name", vo.getMapName());
                        list.add(map);
                    }
                    break block9;
                }
                if (type != 2) break block10;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(TrainingJobCertification::getStatus, (Object)1)).eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingJobCertification::getEnterpriseId, (Object)user.getGroupId());
                if (org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId())) {
                    wrapper.isNull(TrainingJobCertification::getEnterpriseId);
                }
                wrapper.orderByDesc(TrainingJobCertification::getId);
                List voList = this.jobCertificationMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)voList)) break block9;
                for (TrainingJobCertification vo : voList) {
                    map = new HashMap();
                    map.put("id", vo.getId());
                    map.put("name", vo.getCertificationName());
                    list.add(map);
                }
                break block9;
            }
            if (type == 3) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(TrainingJobStageTask::getTaskType, (Object)3)).eq(!org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId()), TrainingJobStageTask::getEnterpriseId, (Object)user.getGroupId());
                if (org.springframework.util.StringUtils.isEmpty((Object)user.getGroupId())) {
                    wrapper.isNull(TrainingJobStageTask::getEnterpriseId);
                }
                wrapper.orderByDesc(TrainingJobStageTask::getId);
                List voList = this.jobStageTaskMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)voList)) {
                    for (TrainingJobStageTask vo : voList) {
                        map = new HashMap();
                        map.put("id", vo.getId());
                        map.put("name", vo.getTaskName());
                        list.add(map);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public Page<TrainingJobStageTaskVo> selectJobOrganizeStudentByPage(Page<TrainingJobStageTaskVo> page, Users user, Integer mapId, Integer certificationId, Integer taskId) {
        List<TrainingJobStageTaskVo> list = this.jobStageTaskMapper.selectJobOrganizeStudentByPage(page, user.getGroupId(), mapId, certificationId, taskId);
        if (!CollectionUtils.isEmpty(list)) {
            List taskIdList = list.stream().map(TrainingJobStageTask::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobUserTask::getTaskType, (Object)3)).in(TrainingJobUserTask::getStageTaskId, taskIdList)).isNotNull(TrainingJobUserTask::getShiftTaskId);
            List userTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> map = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                map = userTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getStageTaskId, e -> new ArrayList<TrainingJobUserTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Boolean isSuper = this.commonRemoteService.isSuper(user.getId());
            List<Integer> jobIdList = list.stream().map(TrainingJobStageTask::getJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, List<Integer>> jobUserMap = this.selectJobUserListByJobList(jobIdList);
            List<Integer> allUserList = this.userUtilService.selectChildUserList(null, user, false);
            List<TrainingJobStageTaskVo> jobSortList = this.jobShiftTaskMapper.selectJobTaskSort(jobIdList);
            Map<Integer, List> jobSortMap = jobSortList.stream().collect(Collectors.toMap(TrainingJobStageTask::getJobId, e -> new ArrayList<TrainingJobStageTaskVo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            for (TrainingJobStageTaskVo vo : list) {
                List<Integer> userList = jobUserMap.get(vo.getJobId());
                if (!CollectionUtils.isEmpty(userList) && !CollectionUtils.isEmpty(allUserList)) {
                    userList.retainAll(allUserList);
                } else {
                    userList = new ArrayList<Integer>();
                }
                if (!CollectionUtils.isEmpty(userList)) {
                    List userTasks;
                    ArrayList<TrainingJobStageTaskVo> jobLessList = new ArrayList<TrainingJobStageTaskVo>();
                    List jobAllList = jobSortMap.get(vo.getJobId());
                    if (!CollectionUtils.isEmpty((Collection)jobAllList)) {
                        for (TrainingJobStageTaskVo taskVo : jobAllList) {
                            if (taskVo.getStageSort() >= vo.getStageSort() && (taskVo.getStageSort() != vo.getStageSort() || taskVo.getTaskSort() >= vo.getTaskSort())) continue;
                            jobLessList.add(taskVo);
                        }
                    }
                    List<TrainingJobStudentAnalyseVo> tasks = this.jobUserTaskMapper.selectJobTaskLessSort(vo.getJobId(), vo.getStageSort(), vo.getTaskSort());
                    if (!CollectionUtils.isEmpty(jobLessList)) {
                        if (!CollectionUtils.isEmpty(tasks)) {
                            ArrayList<Integer> finishUserList = new ArrayList<Integer>();
                            for (TrainingJobStudentAnalyseVo vos : tasks) {
                                if (jobLessList.size() > vos.getFinishTask()) continue;
                                finishUserList.add(vos.getUserId());
                            }
                            userList.retainAll(finishUserList);
                        } else {
                            userList = new ArrayList<Integer>();
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(userTasks = (List)map.get(vo.getId())))) {
                        List userIds = userTasks.stream().map(TrainingJobUserTask::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        userList.removeAll(userIds);
                    }
                }
                vo.setOrganizeNum(Integer.valueOf(CollectionUtils.isEmpty(userList) ? 0 : userList.size()));
                Integer isOrganizePower = 1;
                if (!isSuper.booleanValue()) {
                    isOrganizePower = this.isOrganizePower(vo.getJobId(), user);
                }
                vo.setIsOrganizePower(isOrganizePower);
            }
        }
        page.setContent(list);
        return page;
    }

    public Integer isOrganizePower(Integer jobId, Users user) {
        Integer ispower = 0;
        List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobUser::getJobId, (Object)jobId)).eq(TrainingJobUser::getJobType, (Object)8)).in(TrainingJobUser::getUserId, roleList);
        List jobUserList1 = this.jobUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)jobUserList1)) {
            ispower = 1;
        } else {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingJobUser::getJobId, (Object)jobId)).in(TrainingJobUser::getJobType, Arrays.asList(1, 7))).eq(TrainingJobUser::getUserId, (Object)user.getId());
            List jobUserList2 = this.jobUserMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)jobUserList2)) {
                ispower = 1;
            }
        }
        return ispower;
    }

    @Override
    public Page<TrainingJobUserTaskVo> selectOrganizeStudentByPage(Page<TrainingJobUserTaskVo> page, Users user, Integer jobId, String userName, Integer id) {
        List<Integer> userList = this.jobCertificationService.selectJobUserListByJobId(jobId);
        if (!CollectionUtils.isEmpty(userList = this.userUtilService.selectChildUserList(userList, user, true)) && !org.springframework.util.StringUtils.isEmpty((Object)userName)) {
            Map<String, Object> userMap = this.userUtilService.getCheckParameters(userName, null, null, user);
            List userIds = (List)userMap.get("userList");
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                return page;
            }
            userList.retainAll(userIds);
        }
        if (!CollectionUtils.isEmpty(userList)) {
            TrainingJobStageTask stageTask = (TrainingJobStageTask)this.jobStageTaskMapper.selectById(id);
            TrainingJobStage jobStage = (TrainingJobStage)this.jobStageMapper.selectById(stageTask.getStageId());
            List<TrainingJobStageTaskVo> jobLessList = this.jobShiftTaskMapper.selectJobLessSort(jobId, jobStage.getStageSort(), stageTask.getTaskSort());
            List<TrainingJobStudentAnalyseVo> tasks = this.jobUserTaskMapper.selectJobTaskLessSort(jobId, jobStage.getStageSort(), stageTask.getTaskSort());
            if (!CollectionUtils.isEmpty(jobLessList)) {
                if (!CollectionUtils.isEmpty(tasks)) {
                    ArrayList<Integer> finishUserList = new ArrayList<Integer>();
                    for (TrainingJobStudentAnalyseVo vos : tasks) {
                        if (jobLessList.size() > vos.getFinishTask()) continue;
                        finishUserList.add(vos.getUserId());
                    }
                    userList.retainAll(finishUserList);
                } else {
                    userList = new ArrayList<Integer>();
                }
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingJobUserTask::getTaskType, (Object)3)).eq(TrainingJobUserTask::getJobId, (Object)jobId);
            List userTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                List userIds = userTaskList.stream().map(TrainingJobUserTask::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                userList.removeAll(userIds);
            }
        }
        if (!CollectionUtils.isEmpty(userList)) {
            ArrayList<TrainingJobUserTaskVo> voList = new ArrayList<TrainingJobUserTaskVo>();
            for (Integer userId : userList) {
                TrainingJobUserTaskVo vo = new TrainingJobUserTaskVo();
                vo.setUserId(userId);
                voList.add(vo);
            }
            if (!CollectionUtils.isEmpty((Collection)(page = ListUtil.myPage(voList, page.getPageNumber(), page.getPageSize())).getContent())) {
                List lists = page.getContent();
                List<Integer> userIds = lists.stream().map(TrainingJobUserTask::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIds)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(userIds, (String)","));
                    parameter.put("groupId", user.getGroupId());
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
                Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
                Iterator iterator = lists.iterator();
                while (iterator.hasNext()) {
                    TrainingJobUserTaskVo vo;
                    vo.setUserName(usersMap.get((vo = (TrainingJobUserTaskVo)iterator.next()).getUserId()) == null ? "" : usersMap.get(vo.getUserId()).getShowName());
                    vo.setEmployeeNumber(usersMap.get(vo.getUserId()) == null ? "" : usersMap.get(vo.getUserId()).getEmployeeNumber());
                    vo.setDutiesName(dutiesMap.get(vo.getUserId()) == null ? "" : dutiesMap.get(vo.getUserId()).getDutieName());
                    List<String> userStr = userOrganizeMap.get(vo.getUserId());
                    if (!CollectionUtils.isEmpty(userStr)) {
                        vo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(vo.getUserId())))) {
                        StringBuilder role = new StringBuilder();
                        for (RolePojo rolePojo : (List)userRoleMap.get(vo.getUserId())) {
                            role.append(rolePojo.getRoleName()).append(";\n");
                        }
                        vo.setRole(role.substring(0, role.length() - 2));
                    }
                    if (!CollectionUtils.isEmpty(parentMap)) {
                        vo.setParentName(parentMap.get(vo.getUserId()));
                    }
                    if (CollectionUtils.isEmpty(parentIdMap)) continue;
                    vo.setParentUserId(parentIdMap.get(vo.getUserId()));
                }
                page.setContent(lists);
            }
        }
        return page;
    }

    @Override
    public List<Map> importJobMainData(MultipartFile file, Integer enterpriseId) throws Exception {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        ArrayList<Map> errorList = new ArrayList<Map>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getEnterpriseId, (Object)enterpriseId)).eq(TrainingJobCertification::getStatus, (Object)1)).isNotNull(TrainingJobCertification::getCertificationName)).orderByDesc(TrainingJobCertification::getId);
        List trainingJobCertificationList = this.jobCertificationMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> jobNameMap = new HashMap();
        Map<Object, Object> analyseMap = new HashMap();
        Map<Object, Object> jobMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationList)) {
            List<TrainingJobMapAndCertificationVo> jobMapNameList;
            jobNameMap = trainingJobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getCertificationName, e -> new ArrayList<TrainingJobCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List<Integer> jobIdList = trainingJobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.in(TrainingJobStudentAnalyse::getJobId, jobIdList)).isNotNull(TrainingJobStudentAnalyse::getUserId);
            List trainingJobStudentAnalyseList = this.jobStudentAnalyseMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) {
                analyseMap = trainingJobStudentAnalyseList.stream().collect(Collectors.toMap(TrainingJobStudentAnalyse::getUserId, e -> new ArrayList<TrainingJobStudentAnalyse>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            if (!CollectionUtils.isEmpty(jobMapNameList = this.jobMapMapper.selectMapNameByCertification(jobIdList))) {
                jobMap = jobMapNameList.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getCertificationId, e -> new ArrayList<TrainingJobMapAndCertificationVo>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map<Object, Object> userMap = new HashMap();
        Map<Object, Object> userNameMap = new HashMap();
        BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, enterpriseId, null, null, null, Integer.valueOf(0));
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            List usersPojoList = (List)baseResult.getData();
            userMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getEmployeeNumber, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            userNameMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getShowName, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        List<List<Object>> excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
        LocalDateTime date = LocalDateTime.now();
        ArrayList<TrainingJobStudentAnalyse> analyseList = new ArrayList<TrainingJobStudentAnalyse>();
        ArrayList<TrainingJobExamine> jobExamineList = new ArrayList<TrainingJobExamine>();
        for (int i = 2; i < excelList.size(); ++i) {
            List<Object> list = excelList.get(i);
            HashMap<String, Object> vo = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(list) && list.size() >= 5) {
                if (!ObjectUtils.isEmpty((Object)list.get(0)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0).toString().trim())) {
                    List trainingJobCertifications = (List)jobNameMap.get(list.get(0).toString().trim());
                    if (!CollectionUtils.isEmpty((Collection)trainingJobCertifications)) {
                        TrainingJobCertification jobCertification = (TrainingJobCertification)trainingJobCertifications.get(0);
                        Integer jobId = jobCertification.getId();
                        if (!ObjectUtils.isEmpty((Object)list.get(2)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(2).toString().trim())) {
                            List usersPojos = (List)userMap.get(list.get(2).toString().trim());
                            if (!CollectionUtils.isEmpty((Collection)usersPojos)) {
                                Integer userId = ((UsersPojo)usersPojos.get(0)).getId();
                                LocalDateTime createTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(4)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(4).toString().trim())) {
                                    String dateStr = list.get(4).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 17:00:00";
                                    }
                                    createTime = DateUtils.parseLocalDateTime(dateStr);
                                }
                                Integer isHave = 0;
                                List jobStudentAnalyseList = (List)analyseMap.get(userId);
                                if (!CollectionUtils.isEmpty((Collection)jobStudentAnalyseList)) {
                                    for (TrainingJobStudentAnalyse analyse : jobStudentAnalyseList) {
                                        if (ObjectUtils.isEmpty((Object)analyse) || analyse.getJobId().compareTo(jobId) != 0) continue;
                                        isHave = 1;
                                        if (analyse.getLearnStatus().compareTo(3) == 0 && analyse.getPassStatus().compareTo(3) == 0) break;
                                        analyse.setLearnStatus(Integer.valueOf(3));
                                        analyse.setPassStatus(Integer.valueOf(3));
                                        this.jobStudentAnalyseMapper.updateById(analyse);
                                        break;
                                    }
                                }
                                if (isHave == 0) {
                                    TrainingJobStudentAnalyse analyse = new TrainingJobStudentAnalyse();
                                    analyse.setJobId(jobId);
                                    analyse.setUserId(userId);
                                    analyse.setLearnStatus(Integer.valueOf(3));
                                    analyse.setPassStatus(Integer.valueOf(3));
                                    analyse.setCreateTime(createTime);
                                    analyseList.add(analyse);
                                }
                                if (!ObjectUtils.isEmpty((Object)list.get(3)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(3).toString().trim())) {
                                    List usersPojoList = (List)userNameMap.get(list.get(3).toString().trim());
                                    if (!CollectionUtils.isEmpty((Collection)usersPojoList)) {
                                        Integer userNameId = ((UsersPojo)usersPojoList.get(0)).getId();
                                        TrainingJobExamine jobExamine = new TrainingJobExamine();
                                        jobExamine.setJobId(jobId);
                                        jobExamine.setUserId(userId);
                                        jobExamine.setPassStatus(Integer.valueOf(1));
                                        jobExamine.setIsAuto(Integer.valueOf(1));
                                        jobExamine.setCreater(userNameId);
                                        jobExamine.setCreateTime(createTime);
                                        jobExamine.setEnterpriseId(enterpriseId);
                                        jobExamineList.add(jobExamine);
                                    } else {
                                        vo.put("rowNum", i + 1);
                                        vo.put("remark", this.messageSource.getMessage("training.job.approve.match.no.name", null, locale));
                                        errorList.add(vo);
                                    }
                                } else {
                                    vo.put("rowNum", i + 1);
                                    vo.put("remark", this.messageSource.getMessage("training.job.people.match.no.name", null, locale));
                                    errorList.add(vo);
                                }
                                List jobMaps = (List)jobMap.get(jobCertification.getId());
                                if (!CollectionUtils.isEmpty((Collection)jobMaps)) {
                                    TrainingJobMapAndCertificationVo trainingJobMapAndCertificationVo = (TrainingJobMapAndCertificationVo)jobMaps.get(0);
                                    log.info("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7\uff0c\u63a8\u9001 " + userId + " " + ((UsersPojo)usersPojos.get(0)).getShowName() + " \u5c97\u4f4d " + jobCertification.getPostName());
                                    this.jobMapService.push85Certification(enterpriseId, userId, jobCertification.getPostName(), trainingJobMapAndCertificationVo.getMapName(), "1", Date.from(createTime.atZone(ZoneId.systemDefault()).toInstant()));
                                    continue;
                                }
                                vo.put("rowNum", i + 1);
                                vo.put("remark", this.messageSource.getMessage("training.job.map.match.no.name", null, locale));
                                errorList.add(vo);
                                continue;
                            }
                            vo.put("rowNum", i + 1);
                            vo.put("remark", this.messageSource.getMessage("training.job.user.match.no.name", null, locale));
                            errorList.add(vo);
                            continue;
                        }
                        vo.put("rowNum", i + 1);
                        vo.put("remark", this.messageSource.getMessage("training.job.number.match.no.name", null, locale));
                        errorList.add(vo);
                        continue;
                    }
                    vo.put("rowNum", i + 1);
                    vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                    errorList.add(vo);
                    continue;
                }
                vo.put("rowNum", i + 1);
                vo.put("remark", this.messageSource.getMessage("training.job.certificate.match.no.name", null, locale));
                errorList.add(vo);
                continue;
            }
            vo.put("rowNum", i + 1);
            vo.put("remark", this.messageSource.getMessage("training.job.record.abnormal", null, locale));
            errorList.add(vo);
        }
        if (!CollectionUtils.isEmpty(analyseList)) {
            this.jobStudentAnalyseMapper.insertList(analyseList);
        }
        if (!CollectionUtils.isEmpty(jobExamineList)) {
            this.jobExamineMapper.insertList(jobExamineList);
        }
        return errorList;
    }

    @Override
    public List<Map> importJobMaterialData(MultipartFile file, Integer enterpriseId) throws Exception {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        ArrayList<Map> errorList = new ArrayList<Map>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getEnterpriseId, (Object)enterpriseId)).eq(TrainingJobCertification::getStatus, (Object)1)).isNotNull(TrainingJobCertification::getCertificationName)).orderByDesc(TrainingJobCertification::getId);
        List trainingJobCertificationList = this.jobCertificationMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> jobNameMap = new HashMap();
        Map<Object, Object> stageTaskMap = new HashMap();
        Map<Object, Object> userTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationList)) {
            jobNameMap = trainingJobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getCertificationName, e -> new ArrayList<TrainingJobCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List jobIdList = trainingJobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingJobStageTask::getJobId, jobIdList)).eq(TrainingJobStageTask::getTaskType, (Object)5)).isNotNull(TrainingJobStageTask::getTaskName);
            List trainingJobStudentAnalyseList = this.jobStageTaskMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) {
                stageTaskMap = trainingJobStudentAnalyseList.stream().collect(Collectors.toMap(TrainingJobStageTask::getJobId, e -> new ArrayList<TrainingJobStageTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingJobUserTask::getJobId, jobIdList);
            List trainingJobUserTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                userTaskMap = trainingJobUserTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getUserId, e -> new ArrayList<TrainingJobUserTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map<Object, Object> userMap = new HashMap();
        BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, enterpriseId, null, null, null, Integer.valueOf(0));
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            List usersPojoList = (List)baseResult.getData();
            userMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getEmployeeNumber, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        List<List<Object>> excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 1);
        Date date = new Date();
        ArrayList<TrainingJobUserTask> jobUserTaskList = new ArrayList<TrainingJobUserTask>();
        for (int i = 3; i < excelList.size(); ++i) {
            List<Object> list = excelList.get(i);
            HashMap<String, Object> vo = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(list) && list.size() >= 6) {
                if (!ObjectUtils.isEmpty((Object)list.get(0)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0).toString().trim())) {
                    List trainingJobCertifications = (List)jobNameMap.get(list.get(0).toString().trim());
                    if (!CollectionUtils.isEmpty((Collection)trainingJobCertifications)) {
                        Integer jobId = ((TrainingJobCertification)trainingJobCertifications.get(0)).getId();
                        if (!ObjectUtils.isEmpty((Object)list.get(3)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(3).toString().trim())) {
                            List usersPojos = (List)userMap.get(list.get(3).toString().trim());
                            if (!CollectionUtils.isEmpty((Collection)usersPojos)) {
                                List jobStageTaskList;
                                Integer userId = ((UsersPojo)usersPojos.get(0)).getId();
                                Date startTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(4)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(4).toString().trim())) {
                                    String dateStr = list.get(4).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 09:00:00";
                                    }
                                    startTime = DateUtils.parse(dateStr);
                                }
                                Date endTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(5)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(5).toString().trim())) {
                                    String dateStr = list.get(5).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 17:00:00";
                                    }
                                    endTime = DateUtils.parse(dateStr);
                                }
                                Integer stageTaskId = null;
                                if (!(ObjectUtils.isEmpty((Object)list.get(1)) || org.springframework.util.StringUtils.isEmpty((Object)list.get(1).toString().trim()) || CollectionUtils.isEmpty((Collection)(jobStageTaskList = (List)stageTaskMap.get(jobId))))) {
                                    for (TrainingJobStageTask jobStageTask : jobStageTaskList) {
                                        if (ObjectUtils.isEmpty((Object)jobStageTask) || !jobStageTask.getTaskName().equals(list.get(1).toString().trim())) continue;
                                        stageTaskId = jobStageTask.getId();
                                        break;
                                    }
                                }
                                if (stageTaskId == null) {
                                    vo.put("rowNum", i + 1);
                                    vo.put("remark", this.messageSource.getMessage("training.job.material.match.no.name", null, locale));
                                    errorList.add(vo);
                                    continue;
                                }
                                Integer isHave = 0;
                                List trainingJobUserTaskList = (List)userTaskMap.get(userId);
                                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                                    TrainingJobStageTask jobStageTask;
                                    jobStageTask = trainingJobUserTaskList.iterator();
                                    while (jobStageTask.hasNext()) {
                                        TrainingJobUserTask trainingJobUserTask = (TrainingJobUserTask)jobStageTask.next();
                                        if (ObjectUtils.isEmpty((Object)trainingJobUserTask) || stageTaskId.compareTo(trainingJobUserTask.getStageTaskId()) != 0) continue;
                                        if (trainingJobUserTask.getTaskStatus() == null || trainingJobUserTask.getTaskStatus() != 4) {
                                            trainingJobUserTask.setTaskStatus(Integer.valueOf(4));
                                        }
                                        if (trainingJobUserTask.getStartTime() == null) {
                                            trainingJobUserTask.setStartTime(startTime);
                                        }
                                        if (trainingJobUserTask.getEndTime() == null) {
                                            trainingJobUserTask.setEndTime(endTime);
                                        }
                                        if (trainingJobUserTask.getUseTime() == null) {
                                            trainingJobUserTask.setUseTime(Integer.valueOf(60));
                                        }
                                        trainingJobUserTask.setEnterpriseId(enterpriseId);
                                        this.jobUserTaskMapper.updateById(trainingJobUserTask);
                                        isHave = 1;
                                        break;
                                    }
                                }
                                if (isHave != 0) continue;
                                TrainingJobUserTask jobUserTask = new TrainingJobUserTask();
                                jobUserTask.setJobId(jobId);
                                jobUserTask.setStageTaskId(stageTaskId);
                                jobUserTask.setUserId(userId);
                                jobUserTask.setTaskType(Integer.valueOf(5));
                                jobUserTask.setTaskStatus(Integer.valueOf(4));
                                jobUserTask.setStartTime(startTime);
                                jobUserTask.setEndTime(endTime);
                                jobUserTask.setUseTime(Integer.valueOf(60));
                                jobUserTask.setEnterpriseId(enterpriseId);
                                jobUserTask.setCreateTime(startTime);
                                jobUserTaskList.add(jobUserTask);
                                continue;
                            }
                            vo.put("rowNum", i + 1);
                            vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                            errorList.add(vo);
                            continue;
                        }
                        vo.put("rowNum", i + 1);
                        vo.put("remark", this.messageSource.getMessage("training.job.number.match.no.name", null, locale));
                        errorList.add(vo);
                        continue;
                    }
                    vo.put("rowNum", i + 1);
                    vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                    errorList.add(vo);
                    continue;
                }
                vo.put("rowNum", i + 1);
                vo.put("remark", this.messageSource.getMessage("training.job.certificate.match.no.name", null, locale));
                errorList.add(vo);
                continue;
            }
            vo.put("rowNum", i + 1);
            vo.put("remark", this.messageSource.getMessage("training.job.record.abnormal", null, locale));
            errorList.add(vo);
        }
        if (!CollectionUtils.isEmpty(jobUserTaskList)) {
            this.jobUserTaskMapper.insertList(jobUserTaskList);
        }
        return errorList;
    }

    @Override
    public List<Map> importJobPaperData(MultipartFile file, Integer enterpriseId) throws Exception {
        ArrayList<Map> errorList = new ArrayList<Map>();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getEnterpriseId, (Object)enterpriseId)).eq(TrainingJobCertification::getStatus, (Object)1)).isNotNull(TrainingJobCertification::getCertificationName)).orderByDesc(TrainingJobCertification::getId);
        List trainingJobCertificationList = this.jobCertificationMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> jobNameMap = new HashMap();
        Map<Object, Object> stageTaskMap = new HashMap();
        Map<Object, Object> userTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationList)) {
            jobNameMap = trainingJobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getCertificationName, e -> new ArrayList<TrainingJobCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List jobIdList = trainingJobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingJobStageTask::getJobId, jobIdList)).eq(TrainingJobStageTask::getTaskType, (Object)2)).isNotNull(TrainingJobStageTask::getTaskName);
            List trainingJobStudentAnalyseList = this.jobStageTaskMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) {
                stageTaskMap = trainingJobStudentAnalyseList.stream().collect(Collectors.toMap(TrainingJobStageTask::getJobId, e -> new ArrayList<TrainingJobStageTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingJobUserTask::getJobId, jobIdList);
            List trainingJobUserTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                userTaskMap = trainingJobUserTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getUserId, e -> new ArrayList<TrainingJobUserTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map<Object, Object> userMap = new HashMap();
        BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, enterpriseId, null, null, null, Integer.valueOf(0));
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            List usersPojoList = (List)baseResult.getData();
            userMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getEmployeeNumber, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        List<List<Object>> excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 2);
        Date date = new Date();
        BigDecimal scores = new BigDecimal(100);
        ArrayList<TrainingJobUserTask> jobUserTaskList = new ArrayList<TrainingJobUserTask>();
        for (int i = 3; i < excelList.size(); ++i) {
            List<Object> list = excelList.get(i);
            HashMap<String, Object> vo = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(list) && list.size() >= 7) {
                if (!ObjectUtils.isEmpty((Object)list.get(0)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0).toString().trim())) {
                    List trainingJobCertifications = (List)jobNameMap.get(list.get(0).toString().trim());
                    if (!CollectionUtils.isEmpty((Collection)trainingJobCertifications)) {
                        Integer jobId = ((TrainingJobCertification)trainingJobCertifications.get(0)).getId();
                        if (!ObjectUtils.isEmpty((Object)list.get(3)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(3).toString().trim())) {
                            List usersPojos = (List)userMap.get(list.get(3).toString().trim());
                            if (!CollectionUtils.isEmpty((Collection)usersPojos)) {
                                List jobStageTaskList;
                                Integer userId = ((UsersPojo)usersPojos.get(0)).getId();
                                Date startTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(4)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(4).toString().trim())) {
                                    String dateStr = list.get(4).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 09:00:00";
                                    }
                                    startTime = DateUtils.parse(dateStr);
                                }
                                Date endTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(5)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(5).toString().trim())) {
                                    String dateStr = list.get(5).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 17:00:00";
                                    }
                                    endTime = DateUtils.parse(dateStr);
                                }
                                BigDecimal score = scores;
                                if (!ObjectUtils.isEmpty((Object)list.get(6)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(6).toString().trim())) {
                                    score = new BigDecimal(list.get(6).toString().trim());
                                }
                                Integer stageTaskId = null;
                                if (!(ObjectUtils.isEmpty((Object)list.get(1)) || org.springframework.util.StringUtils.isEmpty((Object)list.get(1).toString().trim()) || CollectionUtils.isEmpty((Collection)(jobStageTaskList = (List)stageTaskMap.get(jobId))))) {
                                    for (TrainingJobStageTask jobStageTask : jobStageTaskList) {
                                        if (ObjectUtils.isEmpty((Object)jobStageTask) || !jobStageTask.getTaskName().equals(list.get(1).toString().trim())) continue;
                                        stageTaskId = jobStageTask.getId();
                                        break;
                                    }
                                }
                                if (stageTaskId == null) {
                                    vo.put("rowNum", i + 1);
                                    vo.put("remark", this.messageSource.getMessage("training.job.paper.match.no.name", null, locale));
                                    errorList.add(vo);
                                    continue;
                                }
                                Integer isHave = 0;
                                List trainingJobUserTaskList = (List)userTaskMap.get(userId);
                                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                                    TrainingJobStageTask jobStageTask;
                                    jobStageTask = trainingJobUserTaskList.iterator();
                                    while (jobStageTask.hasNext()) {
                                        TrainingJobUserTask trainingJobUserTask = (TrainingJobUserTask)jobStageTask.next();
                                        if (ObjectUtils.isEmpty((Object)trainingJobUserTask) || stageTaskId.compareTo(trainingJobUserTask.getStageTaskId()) != 0) continue;
                                        if (trainingJobUserTask.getTaskStatus() == null || trainingJobUserTask.getTaskStatus() != 4) {
                                            trainingJobUserTask.setTaskStatus(Integer.valueOf(4));
                                        }
                                        if (trainingJobUserTask.getStartTime() == null) {
                                            trainingJobUserTask.setStartTime(startTime);
                                        }
                                        if (trainingJobUserTask.getEndTime() == null) {
                                            trainingJobUserTask.setEndTime(endTime);
                                        }
                                        if (trainingJobUserTask.getScore() == null) {
                                            trainingJobUserTask.setScore(score);
                                        }
                                        trainingJobUserTask.setEnterpriseId(enterpriseId);
                                        this.jobUserTaskMapper.updateById(trainingJobUserTask);
                                        isHave = 1;
                                        break;
                                    }
                                }
                                if (isHave != 0) continue;
                                TrainingJobUserTask jobUserTask = new TrainingJobUserTask();
                                jobUserTask.setJobId(jobId);
                                jobUserTask.setStageTaskId(stageTaskId);
                                jobUserTask.setUserId(userId);
                                jobUserTask.setTaskType(Integer.valueOf(2));
                                jobUserTask.setTaskStatus(Integer.valueOf(4));
                                jobUserTask.setStartTime(startTime);
                                jobUserTask.setEndTime(endTime);
                                jobUserTask.setScore(score);
                                jobUserTask.setEnterpriseId(enterpriseId);
                                jobUserTask.setCreateTime(startTime);
                                jobUserTaskList.add(jobUserTask);
                                continue;
                            }
                            vo.put("rowNum", i + 1);
                            vo.put("remark", this.messageSource.getMessage("training.job.user.match.no.name", null, locale));
                            errorList.add(vo);
                            continue;
                        }
                        vo.put("rowNum", i + 1);
                        vo.put("remark", this.messageSource.getMessage("training.job.number.match.no.name", null, locale));
                        errorList.add(vo);
                        continue;
                    }
                    vo.put("rowNum", i + 1);
                    vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                    errorList.add(vo);
                    continue;
                }
                vo.put("rowNum", i + 1);
                vo.put("remark", this.messageSource.getMessage("training.job.certificate.match.no.name", null, locale));
                errorList.add(vo);
                continue;
            }
            vo.put("rowNum", i + 1);
            vo.put("remark", this.messageSource.getMessage("training.job.record.abnormal", null, locale));
            errorList.add(vo);
        }
        if (!CollectionUtils.isEmpty(jobUserTaskList)) {
            this.jobUserTaskMapper.insertList(jobUserTaskList);
        }
        return errorList;
    }

    @Override
    public List<Map> importJobShiftData(MultipartFile file, Integer enterpriseId) throws Exception {
        ArrayList<Map> errorList = new ArrayList<Map>();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getEnterpriseId, (Object)enterpriseId)).eq(TrainingJobCertification::getStatus, (Object)1)).isNotNull(TrainingJobCertification::getCertificationName)).orderByDesc(TrainingJobCertification::getId);
        List trainingJobCertificationList = this.jobCertificationMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> jobNameMap = new HashMap();
        Map<Object, Object> stageTaskMap = new HashMap();
        Map<Object, Object> userTaskMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationList)) {
            jobNameMap = trainingJobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getCertificationName, e -> new ArrayList<TrainingJobCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List jobIdList = trainingJobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingJobStageTask::getJobId, jobIdList)).eq(TrainingJobStageTask::getTaskType, (Object)3)).isNotNull(TrainingJobStageTask::getTaskName);
            List trainingJobStudentAnalyseList = this.jobStageTaskMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) {
                stageTaskMap = trainingJobStudentAnalyseList.stream().collect(Collectors.toMap(TrainingJobStageTask::getJobId, e -> new ArrayList<TrainingJobStageTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingJobUserTask::getJobId, jobIdList);
            List trainingJobUserTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                userTaskMap = trainingJobUserTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getUserId, e -> new ArrayList<TrainingJobUserTask>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map<Object, Object> userMap = new HashMap();
        BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, enterpriseId, null, null, null, Integer.valueOf(0));
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            List usersPojoList = (List)baseResult.getData();
            userMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getEmployeeNumber, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        List<List<Object>> excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 3);
        Date date = new Date();
        BigDecimal hours = new BigDecimal(8);
        BigDecimal scores = new BigDecimal(100);
        ArrayList<TrainingJobUserTask> jobUserTaskList = new ArrayList<TrainingJobUserTask>();
        for (int i = 3; i < excelList.size(); ++i) {
            List<Object> list = excelList.get(i);
            HashMap<String, Object> vo = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(list) && list.size() >= 6) {
                if (!ObjectUtils.isEmpty((Object)list.get(0)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0).toString().trim())) {
                    List trainingJobCertifications = (List)jobNameMap.get(list.get(0).toString().trim());
                    if (!CollectionUtils.isEmpty((Collection)trainingJobCertifications)) {
                        Integer jobId = ((TrainingJobCertification)trainingJobCertifications.get(0)).getId();
                        if (!ObjectUtils.isEmpty((Object)list.get(7)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(7).toString().trim())) {
                            List usersPojos = (List)userMap.get(list.get(7).toString().trim());
                            if (!CollectionUtils.isEmpty((Collection)usersPojos)) {
                                List jobStageTaskList;
                                Integer userId = ((UsersPojo)usersPojos.get(0)).getId();
                                Date startTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(8)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(8).toString().trim())) {
                                    String dateStr = list.get(8).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 09:00:00";
                                    }
                                    startTime = DateUtils.parse(dateStr);
                                }
                                Date endTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(9)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(9).toString().trim())) {
                                    String dateStr = list.get(9).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 17:00:00";
                                    }
                                    endTime = DateUtils.parse(dateStr);
                                }
                                BigDecimal hour = hours;
                                if (!ObjectUtils.isEmpty((Object)list.get(10)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(10).toString().trim())) {
                                    hour = new BigDecimal(list.get(10).toString().trim());
                                }
                                BigDecimal score = scores;
                                if (!ObjectUtils.isEmpty((Object)list.get(12)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(12).toString().trim())) {
                                    score = new BigDecimal(list.get(12).toString().trim());
                                }
                                Integer stageTaskId = null;
                                if (!(ObjectUtils.isEmpty((Object)list.get(1)) || org.springframework.util.StringUtils.isEmpty((Object)list.get(1).toString().trim()) || CollectionUtils.isEmpty((Collection)(jobStageTaskList = (List)stageTaskMap.get(jobId))))) {
                                    for (TrainingJobStageTask jobStageTask : jobStageTaskList) {
                                        if (ObjectUtils.isEmpty((Object)jobStageTask) || !jobStageTask.getTaskName().equals(list.get(1).toString().trim())) continue;
                                        stageTaskId = jobStageTask.getId();
                                        break;
                                    }
                                }
                                if (stageTaskId == null) {
                                    vo.put("rowNum", i + 1);
                                    vo.put("remark", this.messageSource.getMessage("training.job.offline.match.no.name", null, locale));
                                    errorList.add(vo);
                                    continue;
                                }
                                Integer isHave = 0;
                                List trainingJobUserTaskList = (List)userTaskMap.get(userId);
                                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                                    TrainingJobStageTask jobStageTask;
                                    jobStageTask = trainingJobUserTaskList.iterator();
                                    while (jobStageTask.hasNext()) {
                                        TrainingJobUserTask trainingJobUserTask = (TrainingJobUserTask)jobStageTask.next();
                                        if (ObjectUtils.isEmpty((Object)trainingJobUserTask) || stageTaskId.compareTo(trainingJobUserTask.getStageTaskId()) != 0) continue;
                                        if (trainingJobUserTask.getTaskStatus() == null || trainingJobUserTask.getTaskStatus() != 4) {
                                            trainingJobUserTask.setTaskStatus(Integer.valueOf(4));
                                        }
                                        if (trainingJobUserTask.getStartTime() == null) {
                                            trainingJobUserTask.setStartTime(startTime);
                                        }
                                        if (trainingJobUserTask.getEndTime() == null) {
                                            trainingJobUserTask.setEndTime(endTime);
                                        }
                                        if (trainingJobUserTask.getUseTime() == null) {
                                            trainingJobUserTask.setUseTime(Integer.valueOf(hour.multiply(new BigDecimal(3600)).intValue()));
                                        }
                                        if (trainingJobUserTask.getScore() == null) {
                                            trainingJobUserTask.setScore(score);
                                        }
                                        trainingJobUserTask.setEnterpriseId(enterpriseId);
                                        this.jobUserTaskMapper.updateById(trainingJobUserTask);
                                        isHave = 1;
                                        break;
                                    }
                                }
                                if (isHave != 0) continue;
                                TrainingJobUserTask jobUserTask = new TrainingJobUserTask();
                                jobUserTask.setJobId(jobId);
                                jobUserTask.setStageTaskId(stageTaskId);
                                jobUserTask.setUserId(userId);
                                jobUserTask.setTaskType(Integer.valueOf(3));
                                jobUserTask.setTaskStatus(Integer.valueOf(4));
                                jobUserTask.setStartTime(startTime);
                                jobUserTask.setEndTime(endTime);
                                jobUserTask.setUseTime(Integer.valueOf(hour.multiply(new BigDecimal(3600)).intValue()));
                                jobUserTask.setScore(score);
                                jobUserTask.setEnterpriseId(enterpriseId);
                                jobUserTask.setCreateTime(startTime);
                                jobUserTaskList.add(jobUserTask);
                                continue;
                            }
                            vo.put("rowNum", i + 1);
                            vo.put("remark", this.messageSource.getMessage("training.job.user.match.no.name", null, locale));
                            errorList.add(vo);
                            continue;
                        }
                        vo.put("rowNum", i + 1);
                        vo.put("remark", this.messageSource.getMessage("training.job.number.match.no.name", null, locale));
                        errorList.add(vo);
                        continue;
                    }
                    vo.put("rowNum", i + 1);
                    vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                    errorList.add(vo);
                    continue;
                }
                vo.put("rowNum", i + 1);
                vo.put("remark", this.messageSource.getMessage("training.job.certificate.match.no.name", null, locale));
                errorList.add(vo);
                continue;
            }
            vo.put("rowNum", i + 1);
            vo.put("remark", this.messageSource.getMessage("training.job.record.abnormal", null, locale));
            errorList.add(vo);
        }
        if (!CollectionUtils.isEmpty(jobUserTaskList)) {
            this.jobUserTaskMapper.insertList(jobUserTaskList);
        }
        return errorList;
    }

    @Override
    public List<Map> importJobDataPush(MultipartFile file, Integer enterpriseId) throws Exception {
        ArrayList<Map> errorList = new ArrayList<Map>();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobCertification::getEnterpriseId, (Object)enterpriseId)).eq(TrainingJobCertification::getStatus, (Object)1)).isNotNull(TrainingJobCertification::getCertificationName)).orderByDesc(TrainingJobCertification::getId);
        List trainingJobCertificationList = this.jobCertificationMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> jobNameMap = new HashMap();
        Map<Object, Object> jobMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobCertificationList)) {
            jobNameMap = trainingJobCertificationList.stream().collect(Collectors.toMap(TrainingJobCertification::getCertificationName, e -> new ArrayList<TrainingJobCertification>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            List<Integer> jobIdList = trainingJobCertificationList.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
            List<TrainingJobMapAndCertificationVo> jobMapNameList = this.jobMapMapper.selectMapNameByCertification(jobIdList);
            if (!CollectionUtils.isEmpty(jobMapNameList)) {
                jobMap = jobMapNameList.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getCertificationId, e -> new ArrayList<TrainingJobMapAndCertificationVo>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
        }
        Map<Object, Object> userMap = new HashMap();
        BaseResult baseResult = this.userApi.getUserByGroupIdAndKey(null, enterpriseId, null, null, null, Integer.valueOf(0));
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            List usersPojoList = (List)baseResult.getData();
            userMap = usersPojoList.stream().collect(Collectors.toMap(UsersPojo::getEmployeeNumber, e -> new ArrayList<UsersPojo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        List<List<Object>> excelList = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
        Date date = new Date();
        for (int i = 2; i < excelList.size(); ++i) {
            List<Object> list = excelList.get(i);
            HashMap<String, Object> vo = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(list) && list.size() >= 5) {
                if (!ObjectUtils.isEmpty((Object)list.get(0)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0).toString().trim())) {
                    List trainingJobCertifications = (List)jobNameMap.get(list.get(0).toString().trim());
                    if (!CollectionUtils.isEmpty((Collection)trainingJobCertifications)) {
                        TrainingJobCertification jobCertification = (TrainingJobCertification)trainingJobCertifications.get(0);
                        List jobMaps = (List)jobMap.get(jobCertification.getId());
                        if (!ObjectUtils.isEmpty((Object)list.get(2)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(2).toString().trim())) {
                            List usersPojos = (List)userMap.get(list.get(2).toString().trim());
                            if (!CollectionUtils.isEmpty((Collection)usersPojos)) {
                                Integer userId = ((UsersPojo)usersPojos.get(0)).getId();
                                Date createTime = date;
                                if (!ObjectUtils.isEmpty((Object)list.get(4)) && !org.springframework.util.StringUtils.isEmpty((Object)list.get(4).toString().trim())) {
                                    String dateStr = list.get(4).toString().trim();
                                    if (dateStr.length() < 12) {
                                        dateStr = dateStr + " 17:00:00";
                                    }
                                    createTime = DateUtils.parse(dateStr);
                                }
                                if (!CollectionUtils.isEmpty((Collection)jobMaps)) {
                                    TrainingJobMapAndCertificationVo trainingJobMapAndCertificationVo = (TrainingJobMapAndCertificationVo)jobMaps.get(0);
                                    log.info("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7\uff0c\u63a8\u9001" + userId + "\u5c97\u4f4d" + jobCertification.getPostName());
                                    this.jobMapService.push85Certification(enterpriseId, userId, jobCertification.getPostName(), trainingJobMapAndCertificationVo.getMapName(), "1", createTime);
                                    continue;
                                }
                                vo.put("rowNum", i + 1);
                                vo.put("remark", this.messageSource.getMessage("training.job.map.match.no.name", null, locale));
                                errorList.add(vo);
                                continue;
                            }
                            vo.put("rowNum", i + 1);
                            vo.put("remark", this.messageSource.getMessage("training.job.user.match.no.name", null, locale));
                            errorList.add(vo);
                            continue;
                        }
                        vo.put("rowNum", i + 1);
                        vo.put("remark", this.messageSource.getMessage("training.job.number.match.no.name", null, locale));
                        errorList.add(vo);
                        continue;
                    }
                    vo.put("rowNum", i + 1);
                    vo.put("remark", this.messageSource.getMessage("training.job.cert.match.no.name", null, locale));
                    errorList.add(vo);
                    continue;
                }
                vo.put("rowNum", i + 1);
                vo.put("remark", this.messageSource.getMessage("training.job.certificate.match.no.name", null, locale));
                errorList.add(vo);
                continue;
            }
            vo.put("rowNum", i + 1);
            vo.put("remark", this.messageSource.getMessage("training.job.record.abnormal", null, locale));
            errorList.add(vo);
        }
        return errorList;
    }

    @Override
    public Page<TrainingJobCertificationVo> selectJobByPage(Page<TrainingJobCertificationVo> page, String certificationName, Users user) {
        page.setContent(this.jobCertificationMapper.selectJobByPage(page, certificationName, user.getGroupId()));
        return page;
    }

    @Override
    public Page<TrainingJobStudentAnalyseVo> selectUserJobDetailByPage(TrainingJobStudentAnalyseVo jobUserTaskVo, Users user) {
        Page<TrainingJobStudentAnalyseVo> page = new Page<TrainingJobStudentAnalyseVo>();
        page.setPageNumber(jobUserTaskVo.getPageNumber().intValue());
        page.setPageSize(jobUserTaskVo.getPageSize().intValue());
        List<TrainingJobStudentAnalyseVo> trainingJobStudentAnalyseVoList = this.selectUserJobDetailByExcel(jobUserTaskVo, user);
        if (!CollectionUtils.isEmpty(trainingJobStudentAnalyseVoList)) {
            page = ListUtil.myPage(trainingJobStudentAnalyseVoList, page.getPageNumber(), page.getPageSize());
        }
        return page;
    }

    private Map<Integer, List<TrainingJobShiftTask>> getJobOfflineShift(List<TrainingJobStageTask> trainingJobStageTaskList) {
        Map<Integer, List<TrainingJobShiftTask>> trainingJobShiftTaskMap = new HashMap<Integer, List<TrainingJobShiftTask>>();
        List taskIdList = trainingJobStageTaskList.stream().filter(e -> e.getTaskType() == 3).map(TrainingJobStageTask::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(taskIdList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingJobShiftTask::getTaskId, taskIdList);
            List trainingJobShiftTaskList = this.jobShiftTaskMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingJobShiftTaskList)) {
                trainingJobShiftTaskMap = trainingJobShiftTaskList.stream().collect(Collectors.groupingBy(TrainingJobShiftTask::getTaskId));
            }
        }
        return trainingJobShiftTaskMap;
    }

    @Override
    public List<TrainingJobStudentAnalyseVo> selectUserJobDetailByExcel(TrainingJobStudentAnalyseVo jobUserTaskVo, Users user) {
        Map<Integer, List<Integer>> jobUserMap;
        List<Integer> userIds;
        ArrayList<TrainingJobStudentAnalyseVo> trainingJobStudentAnalyseVoList = new ArrayList<TrainingJobStudentAnalyseVo>();
        List<Integer> userIdList = new ArrayList();
        Map<String, Object> userMap = this.userUtilService.getCheckParameters(jobUserTaskVo.getUserName(), jobUserTaskVo.getDutiesId(), jobUserTaskVo.getOrganizeIds(), user);
        if (userMap.get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userIdList = (List)userMap.get("userList"))) {
            return trainingJobStudentAnalyseVoList;
        }
        TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.jobCertificationMapper.selectById(jobUserTaskVo.getJobId());
        if (!ObjectUtils.isEmpty((Object)trainingJobCertification) && !CollectionUtils.isEmpty(userIds = (jobUserMap = this.selectJobUserListByJobList(Arrays.asList(trainingJobCertification.getId()))).get(trainingJobCertification.getId()))) {
            if (!CollectionUtils.isEmpty(userIdList)) {
                userIdList.retainAll(userIds);
            } else {
                userIdList.addAll(userIds);
            }
            if (jobUserTaskVo.getLearnStatus() != null) {
                LambdaQueryWrapper wrapper0 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper0.eq(TrainingJobStudentAnalyse::getJobId, (Object)trainingJobCertification.getId())).eq(TrainingJobStudentAnalyse::getLearnStatus, (Object)jobUserTaskVo.getLearnStatus());
                List trainingJobStudentAnalyseList = this.jobStudentAnalyseMapper.selectList((Wrapper)wrapper0);
                if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList)) {
                    List userList = trainingJobStudentAnalyseList.stream().map(TrainingJobStudentAnalyse::getUserId).distinct().collect(Collectors.toList());
                    userIdList.retainAll(userList);
                } else {
                    return trainingJobStudentAnalyseVoList;
                }
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                List trainingUserPaperList;
                List trainingMaterialList;
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIdList, user.getGroupId());
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                    parameter.put("groupId", user.getGroupId());
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, user.getGroupId());
                Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, user.getGroupId());
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobStageTask::getJobId, (Object)trainingJobCertification.getId())).orderByAsc(TrainingJobStageTask::getStageId)).orderByAsc(TrainingJobStageTask::getTaskSort);
                List trainingJobStageTaskList = this.jobStageTaskMapper.selectList((Wrapper)wrapper1);
                List materialIdList = trainingJobStageTaskList.stream().map(TrainingJobStageTask::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> trainingMaterialMap = new HashMap();
                if (!CollectionUtils.isEmpty(materialIdList) && !CollectionUtils.isEmpty((Collection)(trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIdList)))) {
                    trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                }
                List trainingIdList = trainingJobStageTaskList.stream().map(TrainingJobStageTask::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, List<TrainingJobShiftTask>> trainingJobShiftTaskMap = this.getJobOfflineShift(trainingJobStageTaskList);
                HashMap<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = new HashMap();
                HashMap<Integer, TrainingMaterial> materialMap = new HashMap();
                Map<Object, Object> viewMaterialMap = new HashMap();
                HashMap<Integer, List<TrainingUserViewTimeVo>> viewJobMap = new HashMap();
                Map<Object, Object> userPapersMap = new HashMap();
                if (!CollectionUtils.isEmpty(trainingIdList)) {
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper2.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
                    List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                        List trainingPaperIdList;
                        List trainingMaterialList2;
                        trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                        List<Integer> trainingMaterialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(trainingMaterialIdList) && !CollectionUtils.isEmpty((Collection)(trainingMaterialList2 = this.trainingMaterialMapper.selectBatchIds(trainingMaterialIdList)))) {
                            List<TrainingUserViewTimeVo> jobViewList;
                            materialMap = trainingMaterialList2.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                            List<TrainingUserViewTimeVo> trainingViewList = this.trainingUserViewTimeMaterialMapper.selectViewTimesByUserMaterial(userIdList, trainingMaterialIdList);
                            if (!CollectionUtils.isEmpty(trainingViewList)) {
                                viewMaterialMap = trainingViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                            }
                            if (!CollectionUtils.isEmpty(jobViewList = this.trainingUserViewTimeJobMapper.selectViewTimesByUserMaterial(userIdList, trainingMaterialIdList))) {
                                viewJobMap = jobViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                            }
                        }
                        if (!CollectionUtils.isEmpty(trainingPaperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, trainingPaperIdList)).in(TrainingUserPaper::getUserId, userIdList)).eq(TrainingUserPaper::getSourceType, (Object)4)).eq(TrainingUserPaper::getSourceProjectId, (Object)jobUserTaskVo.getJobId())).isNotNull(TrainingUserPaper::getSubmitTime);
                            trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
                            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                                userPapersMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                            }
                        }
                    }
                }
                List<Integer> paperIdList = trainingJobStageTaskList.stream().map(TrainingJobStageTask::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> papersVoMap = new HashMap();
                Map<Object, Object> trainingUserPaperMap = new HashMap();
                if (!CollectionUtils.isEmpty(paperIdList)) {
                    List<TrainingPapersVo> trainingPapersVoList = this.trainingPaperMapper.selectPaperScores(paperIdList);
                    if (!CollectionUtils.isEmpty(trainingPapersVoList)) {
                        papersVoMap = trainingPapersVoList.stream().collect(Collectors.toMap(TrainingPaper::getId, Function.identity()));
                    }
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).in(TrainingUserPaper::getUserId, userIdList)).eq(TrainingUserPaper::getSourceType, (Object)4)).eq(TrainingUserPaper::getSourceProjectId, (Object)jobUserTaskVo.getJobId())).isNotNull(TrainingUserPaper::getSubmitTime);
                    trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper3);
                    if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                        trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                    }
                }
                List operateCheckIdList = trainingJobStageTaskList.stream().map(TrainingJobStageTask::getOperateCheckId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> trainingUserOperateMap = new HashMap();
                if (!CollectionUtils.isEmpty(operateCheckIdList)) {
                    LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(UserOperate::getOperateCheckId, operateCheckIdList)).in(UserOperate::getUserId, userIdList)).in(UserOperate::getStatus, Arrays.asList(2, 3));
                    List userOperateList = this.trainingUserOperateMapper.selectList((Wrapper)wrapper4);
                    if (!CollectionUtils.isEmpty((Collection)userOperateList)) {
                        trainingUserOperateMap = userOperateList.stream().collect(Collectors.groupingBy(UserOperate::getUserId));
                    }
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingJobUserTask::getJobId, (Object)trainingJobCertification.getId())).in(TrainingJobUserTask::getUserId, userIdList);
                List trainingJobUserTaskList = this.jobUserTaskMapper.selectList((Wrapper)wrapper2);
                Map<Object, Object> trainingJobUserTaskMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
                    trainingJobUserTaskMap = trainingJobUserTaskList.stream().collect(Collectors.groupingBy(TrainingJobUserTask::getUserId));
                }
                TrainingJobStudentAnalyseVo trainingJobStudentAnalyseVo = null;
                for (Integer userId : userIdList) {
                    UsersPojo usersPojo = usersMap.get(userId);
                    String departName = "";
                    List<String> organizeList = userOrganizeMap.get(userId);
                    if (!CollectionUtils.isEmpty(organizeList)) {
                        departName = String.join((CharSequence)";\n", organizeList);
                    }
                    UserDutiesMo userDutiesMo = dutiesMap.get(userId);
                    List trainingJobUserTasks = (List)trainingJobUserTaskMap.get(userId);
                    Map<Object, Object> jobUserTaskMap = new HashMap();
                    BigDecimal finishNum = BigDecimal.ZERO;
                    if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks)) {
                        jobUserTaskMap = trainingJobUserTasks.stream().collect(Collectors.groupingBy(TrainingJobUserTask::getStageTaskId));
                        List trainingJobUserTaskFinishs = trainingJobUserTasks.stream().filter(e -> e.getTaskStatus() == 4).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(trainingJobUserTaskFinishs)) {
                            finishNum = new BigDecimal(trainingJobUserTaskFinishs.size());
                        }
                    }
                    List trainingUserPaperList2 = (List)trainingUserPaperMap.get(userId);
                    Map<Object, Object> userPaperMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList2)) {
                        userPaperMap = trainingUserPaperList2.stream().filter(e -> e.getSourceTaskId() != null).collect(Collectors.groupingBy(TrainingUserPaper::getSourceTaskId));
                    }
                    List trainingUserOperateList = (List)trainingUserOperateMap.get(userId);
                    Map<Object, Object> userOperateMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)trainingUserOperateList)) {
                        userOperateMap = trainingUserOperateList.stream().collect(Collectors.groupingBy(UserOperate::getOperateCheckId));
                    }
                    for (TrainingJobStageTask trainingJobStageTask : trainingJobStageTaskList) {
                        List jobUserTaskList;
                        trainingJobStudentAnalyseVo = new TrainingJobStudentAnalyseVo();
                        trainingJobStudentAnalyseVo.setJobRate(finishNum.divide(new BigDecimal(trainingJobStageTaskList.size()), 4, 4));
                        trainingJobStudentAnalyseVo.setCertificationName(trainingJobCertification.getCertificationName());
                        trainingJobStudentAnalyseVo.setUserId(userId);
                        trainingJobStudentAnalyseVo.setUserName(ObjectUtils.isEmpty((Object)usersPojo) ? "" : usersPojo.getShowName());
                        trainingJobStudentAnalyseVo.setUserAccount(ObjectUtils.isEmpty((Object)usersPojo) ? "" : usersPojo.getUserName());
                        trainingJobStudentAnalyseVo.setEmployeeNumber(ObjectUtils.isEmpty((Object)usersPojo) ? "" : usersPojo.getEmployeeNumber());
                        if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(userId)))) {
                            StringBuilder role = new StringBuilder();
                            for (RolePojo rolePojo : (List)userRoleMap.get(userId)) {
                                role.append(rolePojo.getRoleName()).append(";\n");
                            }
                            trainingJobStudentAnalyseVo.setRole(role.substring(0, role.length() - 2));
                        }
                        trainingJobStudentAnalyseVo.setOrganizeName(departName);
                        trainingJobStudentAnalyseVo.setDutiesName(ObjectUtils.isEmpty((Object)userDutiesMo) ? "" : userDutiesMo.getDutieName());
                        if (!CollectionUtils.isEmpty(parentMap)) {
                            trainingJobStudentAnalyseVo.setParentName(parentMap.get(trainingJobStudentAnalyseVo.getUserId()));
                        }
                        if (!CollectionUtils.isEmpty(parentIdMap)) {
                            trainingJobStudentAnalyseVo.setParentUserId(parentIdMap.get(trainingJobStudentAnalyseVo.getUserId()));
                        }
                        if (!CollectionUtils.isEmpty((Collection)(jobUserTaskList = (List)jobUserTaskMap.get(trainingJobStageTask.getId())))) {
                            TrainingJobUserTask trainingJobUserTask = (TrainingJobUserTask)jobUserTaskList.get(0);
                            if (trainingJobStageTask.getTaskType() == 1 || trainingJobStageTask.getTaskType() == 5) {
                                BigDecimal taskRate = BigDecimal.ZERO;
                                if (trainingJobUserTask.getTaskStatus() == 4) {
                                    taskRate = BigDecimal.ONE;
                                } else if (trainingJobUserTask.getTaskStatus() != 0) {
                                    if (trainingJobStageTask.getTaskType() == 5) {
                                        TrainingMaterial trainingMaterial = (TrainingMaterial)trainingMaterialMap.get(trainingJobStageTask.getMaterialId());
                                        if (!ObjectUtils.isEmpty((Object)trainingMaterial)) {
                                            BigDecimal finishTime = new BigDecimal("30");
                                            finishTime = !org.springframework.util.StringUtils.isEmpty((Object)trainingMaterial.getIsVideo()) && trainingMaterial.getIsVideo() == 1 ? new BigDecimal(trainingMaterial.getDuration()).multiply(trainingMaterial.getFinishRate()).divide(new BigDecimal("100"), 0, 1) : new BigDecimal(trainingMaterial.getFinishTime());
                                            taskRate = finishTime.compareTo(new BigDecimal(trainingJobUserTask.getUseTime())) <= 0 ? BigDecimal.ONE : new BigDecimal(trainingJobUserTask.getUseTime()).divide(finishTime, 4, 4);
                                        }
                                    } else {
                                        List trainingUserPapers = (List)userPapersMap.get(userId);
                                        HashMap<Integer, List<TrainingUserPaper>> trainingUserPapersMap = new HashMap();
                                        if (!CollectionUtils.isEmpty((Collection)trainingUserPapers)) {
                                            trainingUserPapersMap = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                                        }
                                        Map<String, Object> map = this.trainingCommonService.selectTrainingRate(trainingJobStageTask.getTrainingId(), userId, trainingJobStageTask.getIsSync() != null && trainingJobStageTask.getIsSync() == 1 ? viewMaterialMap : viewJobMap, trainingChapterAttachMap, materialMap, trainingUserPapersMap);
                                        taskRate = new BigDecimal(map.get("studyRate").toString()).divide(new BigDecimal("100"), 4, 4);
                                    }
                                }
                                trainingJobStudentAnalyseVo.setTaskRate(taskRate.setScale(4, 4));
                            }
                            if (trainingJobUserTask.getTaskStatus() == 4) {
                                trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(3));
                                trainingJobStudentAnalyseVo.setPassStatus(Integer.valueOf(3));
                                trainingJobStudentAnalyseVo.setScore(trainingJobUserTask.getScore());
                            } else if (trainingJobUserTask.getTaskStatus() == 3) {
                                trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(3));
                                trainingJobStudentAnalyseVo.setPassStatus(Integer.valueOf(2));
                                trainingJobStudentAnalyseVo.setScore(trainingJobUserTask.getScore());
                            } else if (trainingJobUserTask.getTaskStatus() == 2) {
                                trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(4));
                            } else if (trainingJobUserTask.getTaskStatus() == 1) {
                                trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(2));
                            } else {
                                trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(1));
                            }
                            if (trainingJobStageTask.getTaskType() == 5 || trainingJobStageTask.getTaskType() == 1) {
                                trainingJobStudentAnalyseVo.setPassStatus(null);
                            }
                            trainingJobStudentAnalyseVo.setTaskStartTime(trainingJobUserTask.getStartTime());
                            trainingJobStudentAnalyseVo.setTaskEndTime(trainingJobUserTask.getEndTime());
                            if (trainingJobUserTask.getUseTime() != null) {
                                trainingJobStudentAnalyseVo.setUseTime(DateUtils.getUseTimeFormal(trainingJobUserTask.getUseTime()));
                                if (trainingJobStageTask.getTaskType() == 3 && trainingJobUserTask.getStartTime() != null && trainingJobUserTask.getEndTime() != null) {
                                    trainingJobStudentAnalyseVo.setUseTime(DateUtils.getUseTimeFormal((int)(trainingJobUserTask.getEndTime().getTime() - trainingJobUserTask.getStartTime().getTime()) / 1000));
                                }
                            }
                        } else {
                            trainingJobStudentAnalyseVo.setLearnStatus(Integer.valueOf(1));
                        }
                        trainingJobStudentAnalyseVo.setTaskName(trainingJobStageTask.getTaskName());
                        trainingJobStudentAnalyseVo.setTaskType(trainingJobStageTask.getTaskType());
                        if (trainingJobStageTask.getTaskType() == 3) {
                            List<TrainingJobShiftTask> trainingJobShiftTaskList = trainingJobShiftTaskMap.get(trainingJobStageTask.getId());
                            if (!CollectionUtils.isEmpty(trainingJobShiftTaskList) && !ObjectUtils.isEmpty((Object)trainingJobShiftTaskList.get(0))) {
                                TrainingJobShiftTask trainingJobShiftTask = trainingJobShiftTaskList.get(0);
                                trainingJobStudentAnalyseVo.setStartTime(trainingJobShiftTask.getStartTime());
                                trainingJobStudentAnalyseVo.setEndTime(trainingJobShiftTask.getEndTime());
                                if (trainingJobShiftTask.getStartTime() != null && trainingJobShiftTask.getEndTime() != null) {
                                    trainingJobStudentAnalyseVo.setTaskTime(DateUtils.getUseTimeFormal((int)(trainingJobShiftTask.getEndTime().getTime() - trainingJobShiftTask.getStartTime().getTime()) / 1000));
                                }
                                trainingJobStudentAnalyseVo.setTotalScore(trainingJobShiftTask.getFullScore());
                                trainingJobStudentAnalyseVo.setPassScore(trainingJobShiftTask.getQualifiedScore());
                            } else {
                                trainingJobStudentAnalyseVo.setStartTime(trainingJobStageTask.getStartTime());
                                trainingJobStudentAnalyseVo.setEndTime(trainingJobStageTask.getEndTime());
                                if (trainingJobStageTask.getStartTime() != null && trainingJobStageTask.getEndTime() != null) {
                                    trainingJobStudentAnalyseVo.setTaskTime(DateUtils.getUseTimeFormal((int)(trainingJobStageTask.getEndTime().getTime() - trainingJobStageTask.getStartTime().getTime()) / 1000));
                                }
                                trainingJobStudentAnalyseVo.setTotalScore(trainingJobStageTask.getFullScore());
                                trainingJobStudentAnalyseVo.setPassScore(trainingJobStageTask.getQualifiedScore());
                            }
                        } else if (trainingJobStageTask.getTaskType() == 2 && trainingJobStageTask.getPaperId() != null) {
                            List trainingUserPapers;
                            TrainingPapersVo trainingPapersVo = (TrainingPapersVo)papersVoMap.get(trainingJobStageTask.getPaperId());
                            if (!ObjectUtils.isEmpty((Object)trainingPapersVo)) {
                                trainingJobStudentAnalyseVo.setTotalScore(trainingPapersVo.getScore());
                                trainingJobStudentAnalyseVo.setPassScore(trainingPapersVo.getScore().multiply(new BigDecimal(trainingPapersVo.getPassLine())).divide(new BigDecimal("100"), 2, 4));
                            }
                            trainingJobStudentAnalyseVo.setUseCount(CollectionUtils.isEmpty((Collection)(trainingUserPapers = (List)userPaperMap.get(trainingJobStageTask.getId()))) ? null : Integer.valueOf(trainingUserPapers.size()));
                        } else if (trainingJobStageTask.getTaskType() == 4 && trainingJobStageTask.getOperateCheckId() != null) {
                            List userOperateList = (List)userOperateMap.get(trainingJobStageTask.getOperateCheckId());
                            trainingJobStudentAnalyseVo.setUseCount(CollectionUtils.isEmpty((Collection)userOperateList) ? null : Integer.valueOf(userOperateList.size()));
                        }
                        trainingJobStudentAnalyseVoList.add(trainingJobStudentAnalyseVo);
                    }
                }
            }
        }
        return trainingJobStudentAnalyseVoList;
    }

    @Override
    public List<TrainingJobStudentAnalyseVo> selectUserJobsDetailByExcel(TrainingJobStudentAnalyseVo jobUserTaskVo) {
        Users user = new Users();
        user.setId(jobUserTaskVo.getUserId());
        user.setGroupId(jobUserTaskVo.getEnterpriseId());
        List jobIds = jobUserTaskVo.getJobIdList();
        ArrayList<TrainingJobStudentAnalyseVo> list = new ArrayList<TrainingJobStudentAnalyseVo>();
        if (!CollectionUtils.isEmpty((Collection)jobIds)) {
            for (Integer jobId : jobIds) {
                jobUserTaskVo.setJobId(jobId);
                List<TrainingJobStudentAnalyseVo> trainingJobStudentAnalyseVoList = this.selectUserJobDetailByExcel(jobUserTaskVo, user);
                list.addAll(trainingJobStudentAnalyseVoList);
            }
        }
        return list;
    }
}

