/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDutiesApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.pojo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enums.ProjectTaskSelfStatusEnum;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAppShowMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingAttachUserMapper;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterAttachUserMapper;
import com.ovopark.training.mapper.TrainingChapterVideoMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobMapAndCertificationMapper;
import com.ovopark.training.mapper.TrainingJobMapMapper;
import com.ovopark.training.mapper.TrainingJobShiftTaskMapper;
import com.ovopark.training.mapper.TrainingJobStageMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserTurnsMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingAppShow;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingAttachUser;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingChapterAttachUser;
import com.ovopark.training.model.TrainingChapterVideo;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobMap;
import com.ovopark.training.model.TrainingJobMapAndCertification;
import com.ovopark.training.model.TrainingJobShiftTask;
import com.ovopark.training.model.TrainingJobStage;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobStudentAnalyse;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUserTurns;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.UsersDutiesPojo;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingJobMapService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.Arith;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.AppTrainingShiftNumVo;
import com.ovopark.training.vo.AppTrainingTaskNumVo;
import com.ovopark.training.vo.Param85Post;
import com.ovopark.training.vo.TrainingAttachVo;
import com.ovopark.training.vo.TrainingJobCertificationVo;
import com.ovopark.training.vo.TrainingJobMapAndCertificationVo;
import com.ovopark.training.vo.TrainingJobMapVo;
import com.ovopark.training.vo.TrainingJobShiftTaskVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingJobStageVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserTaskVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingVo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingJobMapServiceImpl
implements TrainingJobMapService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobMapServiceImpl.class);
    @Resource
    private TrainingJobMapMapper trainingJobMapMapper;
    @Resource
    private TrainingJobMapAndCertificationMapper trainingJobMapAndCertificationMapper;
    @Resource
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Resource
    private CommonRemoteService commonRemoteService;
    @Resource
    private UserApi userApi;
    @Resource
    private TrainingJobStudentAnalyseMapper studentAnalyseMapper;
    @Resource
    private UserDutiesApi userDutiesApi;
    @Autowired
    private TrainingJobCertificationMapper jobCertificationMapper;
    @Autowired
    private TrainingJobStageMapper jobStageMapper;
    @Autowired
    private TrainingJobStageTaskMapper jobStageTaskMapper;
    @Resource
    private TrainingAttachMapper trainingAttachMapper;
    @Resource
    private TrainingAttachUserMapper trainingAttachUserMapper;
    @Resource
    private TrainingChapterAttachUserMapper trainingChapterAttachUserMapper;
    @Resource
    private TrainingVideoMapper trainingVideoMapper;
    @Resource
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Resource
    private TrainingChapterVideoMapper trainingChapterVideoMapper;
    @Resource
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Resource
    private TrainingMapper trainingMapper;
    @Resource
    private TrainingAndMaterialMapper trainingAndMaterialMapper;
    @Resource
    private TrainingPaperMapper trainingPaperMapper;
    @Resource
    private TrainingCertificateDetailMapper trainingCertificateDetailMapper;
    @Resource
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Resource
    private TrainingJobShiftTaskMapper jobShiftTaskMapper;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Resource
    private TrainingLearnTaskUserMapper trainingLearnTaskUserMapper;
    @Resource
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Resource
    private TrainingJobUserMapper jobUserMapper;
    @Resource
    private TrainingLecturerMapper lecturerMapper;
    @Resource
    private TrainingJobUserTaskMapper jobUserTaskMapper;
    @Resource
    private TrainingUserPaperMapper userPaperMapper;
    @Resource
    private TrainingAppShowMapper appShowMapper;
    @Autowired
    private LogApi logApi;
    @Resource
    private TrainingCourseMapper courseMapper;
    @Resource
    private TrainingCourseUserTaskMapper courseUserTaskMapper;
    @Resource
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Value(value="${85.url}")
    private String post85Url;
    @Resource
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private TrainingMaterialMapper trainingMaterialMapper;
    @Resource
    private TrainingUserViewTimeMapper userViewTimeMapper;
    @Autowired
    private TrainingCommonService commonService;
    @Autowired
    private TrainingPaperUserTurnsMapper paperUserTurnsMapper;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private MessageSource messageSource;
    @Resource
    private TrainingJobCertificationService trainingJobCertificationService;

    @Override
    public void saveTrainingMap(TrainingJobMapVo trainingJobMap, Users user) {
        Date now = new Date();
        if (trainingJobMap.getId() == null) {
            trainingJobMap.setCreateTime(now);
            trainingJobMap.setCreatorId(user.getId());
            trainingJobMap.setEnterpriseId(user.getGroupId());
            trainingJobMap.setUpdateTime(now);
            trainingJobMap.setUpdater(user.getId());
            this.trainingJobMapMapper.insert(trainingJobMap);
        } else {
            trainingJobMap.setUpdateTime(now);
            trainingJobMap.setUpdater(user.getId());
            this.trainingJobMapMapper.updateById(trainingJobMap);
        }
        if (!CollectionUtils.isEmpty((Collection)trainingJobMap.getTrainingJobCertifications())) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(TrainingJobMapAndCertification::getMapId, (Object)trainingJobMap.getId());
            this.trainingJobMapAndCertificationMapper.delete((Wrapper)wrapper);
            TrainingJobMapAndCertification trainingJobMapAndCertification = new TrainingJobMapAndCertification();
            trainingJobMapAndCertification.setEnterpriseId(user.getGroupId());
            trainingJobMapAndCertification.setMapId(trainingJobMap.getId());
            List voList = trainingJobMap.getTrainingJobCertifications();
            Integer i = 1;
            for (TrainingJobCertificationVo vo : voList) {
                trainingJobMapAndCertification.setCertificationId(vo.getId());
                trainingJobMapAndCertification.setSort(i);
                trainingJobMapAndCertification.setLastSort(vo.getLastSort());
                this.trainingJobMapAndCertificationMapper.insert(trainingJobMapAndCertification);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    @Override
    public boolean mapNameIsUse(TrainingJobMapVo trainingJobMap, Users user) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.ne(trainingJobMap.getId() != null, TrainingJobMap::getId, (Object)trainingJobMap.getId())).eq(TrainingJobMap::getMapName, (Object)trainingJobMap.getMapName())).eq(TrainingJobMap::getEnterpriseId, (Object)user.getGroupId())).ne(TrainingJobMap::getState, (Object)0);
        return !CollectionUtils.isEmpty((Collection)this.trainingJobMapMapper.selectList((Wrapper)wrapper));
    }

    @Override
    public IPage<TrainingJobMapVo> getTrainingMaps(IPage<TrainingJobMapVo> trainingJobMapVos, String name, Integer state, Users user) {
        List trainingJobMapVoList;
        List userIds;
        BaseResult usersPogo;
        IPage<TrainingJobMapVo> trainingJobMaps = this.trainingJobMapMapper.selectMapPage(trainingJobMapVos, user.getGroupId(), this.commonRemoteService.isSuper(user.getId()) != false ? null : user.getId(), name, state);
        if (!CollectionUtils.isEmpty((Collection)trainingJobMaps.getRecords()) && !CollectionUtils.isEmpty((Collection)((Collection)(usersPogo = this.userApi.getUserByIdList(userIds = (trainingJobMapVoList = trainingJobMaps.getRecords()).stream().map(TrainingJobMap::getCreatorId).collect(Collectors.toList()))).getData()))) {
            Map usersPojoMap = ((List)usersPogo.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
            for (TrainingJobMapVo trainingJobMapVo : trainingJobMaps.getRecords()) {
                trainingJobMapVo.setPeopleNumber(this.getUsersByMapId(trainingJobMapVo.getId()));
                trainingJobMapVo.setUserName(usersPojoMap.get(trainingJobMapVo.getCreatorId()) == null ? null : ((UsersPojo)usersPojoMap.get(trainingJobMapVo.getCreatorId())).getShowName());
            }
        }
        return trainingJobMaps;
    }

    @Override
    public String updateTrainingState(Integer id, Integer state, LogPojo pojo) {
        TrainingJobMap trainingJobMap = (TrainingJobMap)this.trainingJobMapMapper.selectById(id);
        if (!pojo.getEnterpriseId().equals(trainingJobMap.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        trainingJobMap.setState(state);
        this.trainingJobMapMapper.updateById(trainingJobMap);
        if (state == 0) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(TrainingJobMapAndCertification::getMapId, (Object)trainingJobMap.getId());
            this.trainingJobMapAndCertificationMapper.delete((Wrapper)wrapper);
        }
        pojo.setI18nParam(trainingJobMap.getMapName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public TrainingJobMapVo getTrainingMapDetail(Integer id) {
        TrainingJobMap trainingJobMap = (TrainingJobMap)this.trainingJobMapMapper.selectById(id);
        TrainingJobMapVo trainingJobMapVo = new TrainingJobMapVo();
        BeanUtils.copyProperties((Object)trainingJobMap, (Object)trainingJobMapVo);
        BaseResult usersPojoBaseResult = this.userApi.getUserById(trainingJobMap.getCreatorId());
        trainingJobMapVo.setCreator(usersPojoBaseResult.getData() != null ? ((UsersPojo)usersPojoBaseResult.getData()).getShowName() : null);
        List<TrainingJobCertification> trainingJobCertifications = this.trainingJobMapMapper.selectCertificationsByMapId(id);
        ArrayList<TrainingJobCertificationVo> voList = new ArrayList<TrainingJobCertificationVo>();
        if (!CollectionUtils.isEmpty(trainingJobCertifications)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingJobMapAndCertification::getMapId, (Object)id)).orderByAsc(TrainingJobMapAndCertification::getSort);
            List mapList = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)wrapper1);
            Map cerMap = mapList.stream().collect(Collectors.toMap(TrainingJobMapAndCertification::getCertificationId, Function.identity()));
            for (TrainingJobCertification cer : trainingJobCertifications) {
                TrainingJobMapAndCertification mapAnd = (TrainingJobMapAndCertification)cerMap.get(cer.getId());
                TrainingJobCertificationVo vo = new TrainingJobCertificationVo();
                BeanUtils.copyProperties((Object)cer, (Object)vo);
                vo.setLastSort(mapAnd.getLastSort());
                voList.add(vo);
            }
        }
        trainingJobMapVo.setTrainingJobCertifications(voList);
        trainingJobMapVo.setJobNumber(Integer.valueOf(CollectionUtils.isEmpty(trainingJobCertifications) ? 0 : trainingJobCertifications.size()));
        trainingJobMapVo.setPeopleNumber(this.getUsersByMapId(id));
        return trainingJobMapVo;
    }

    @Override
    public List<TrainingJobCertificationVo> getTrainingMapCertification(Integer id) {
        List<TrainingJobCertification> trainingJobCertifications = this.trainingJobMapMapper.selectCertificationsByMapId(id);
        if (!CollectionUtils.isEmpty(trainingJobCertifications)) {
            ArrayList<TrainingJobCertificationVo> trainingJobCertificationVos = new ArrayList<TrainingJobCertificationVo>();
            for (TrainingJobCertification trainingJobCertification : trainingJobCertifications) {
                TrainingJobCertificationVo trainingJobCertificationVo = new TrainingJobCertificationVo();
                BeanUtils.copyProperties((Object)trainingJobCertification, (Object)trainingJobCertificationVo);
                List<Integer> userIds = this.trainingJobCertificationService.selectJobUserListByJobId(trainingJobCertification.getId());
                int readyNum = 0;
                if (!CollectionUtils.isEmpty(userIds)) {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobStudentAnalyse::getJobId, (Object)trainingJobCertification.getId())).in(TrainingJobStudentAnalyse::getUserId, userIds)).eq(TrainingJobStudentAnalyse::getPassStatus, (Object)3);
                    List students = this.studentAnalyseMapper.selectList((Wrapper)wrapper1);
                    if (!CollectionUtils.isEmpty((Collection)students)) {
                        readyNum = students.size();
                    }
                }
                trainingJobCertificationVo.setReadyNum(Integer.valueOf(readyNum));
                trainingJobCertificationVo.setGoNum(Integer.valueOf(CollectionUtils.isEmpty(userIds) ? 0 : userIds.size() - readyNum));
                trainingJobCertificationVos.add(trainingJobCertificationVo);
            }
            return trainingJobCertificationVos;
        }
        return null;
    }

    @Override
    public List<TrainingJobMapVo> getMapsByUser(Users users) {
        Map data;
        List usersDutiesPojoList;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        userIds.add(users.getId());
        BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(userIds, users.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
        if (!(userByDutiesIdOrUserId == null || ObjectUtils.isEmpty((Object)userByDutiesIdOrUserId.getData()) || StringUtils.isEmpty(((Map)userByDutiesIdOrUserId.getData()).get("date")) || CollectionUtils.isEmpty((Collection)(usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString((data = (Map)userByDutiesIdOrUserId.getData()).get("date")), UsersDutiesPojo.class))))) {
            List ids = usersDutiesPojoList.stream().map(UsersDutiesPojo::getDutiesId).collect(Collectors.toList());
            List<TrainingJobMapVo> trainingJobMapVoList = this.trainingJobMapMapper.selectMapsByCertificationIds(ids);
            if (!CollectionUtils.isEmpty(trainingJobMapVoList)) {
                for (TrainingJobMapVo trainingJobMapVo : trainingJobMapVoList) {
                    trainingJobMapVo.setPeopleNumber(this.getUsersByMapId(trainingJobMapVo.getId()));
                    trainingJobMapVo.setFinishNumber(Integer.valueOf(0));
                    List<TrainingJobCertification> trainingJobCertifications = this.trainingJobMapMapper.selectCertificationsByMapId(trainingJobMapVo.getId());
                    if (CollectionUtils.isEmpty(trainingJobCertifications)) continue;
                    List certificationIds = trainingJobCertifications.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingJobStudentAnalyse::getJobId, certificationIds)).eq(TrainingJobStudentAnalyse::getUserId, (Object)users.getId())).ge(TrainingJobStudentAnalyse::getPassStatus, (Object)3);
                    List students1 = this.studentAnalyseMapper.selectList((Wrapper)wrapper1);
                    trainingJobMapVo.setFinishNumber(Integer.valueOf(CollectionUtils.isEmpty((Collection)students1) ? 0 : students1.size()));
                }
            }
            return trainingJobMapVoList;
        }
        return null;
    }

    @Override
    public TrainingJobMapVo selectMapsByMapId(TrainingJobMapVo trainingJobMapVo, Users users) {
        if (!ObjectUtils.isEmpty((Object)trainingJobMapVo) && trainingJobMapVo.getId() != null) {
            TrainingJobMap trainingJobMap = (TrainingJobMap)this.trainingJobMapMapper.selectById(trainingJobMapVo.getId());
            Integer userId = trainingJobMapVo.getUserId();
            BeanUtils.copyProperties((Object)trainingJobMap, (Object)trainingJobMapVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingJobMapAndCertification::getMapId, (Object)trainingJobMap.getId());
            List trainingJobMapAndCertificationList = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingJobMapAndCertificationList)) {
                trainingJobMapVo.setJobNumber(Integer.valueOf(trainingJobMapAndCertificationList.size()));
            }
            trainingJobMapVo.setPeopleNumber(this.getUsersByMapId(trainingJobMapVo.getId()));
            trainingJobMapVo.setFinishNumber(Integer.valueOf(0));
            List<TrainingJobCertification> trainingJobCertifications = this.trainingJobMapMapper.selectCertificationsByMapId(trainingJobMapVo.getId());
            if (!CollectionUtils.isEmpty(trainingJobCertifications)) {
                List certificationIds = trainingJobCertifications.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingJobStudentAnalyse::getJobId, certificationIds)).eq(TrainingJobStudentAnalyse::getUserId, (Object)userId)).ge(TrainingJobStudentAnalyse::getPassStatus, (Object)3);
                List students1 = this.studentAnalyseMapper.selectList((Wrapper)wrapper2);
                trainingJobMapVo.setFinishNumber(Integer.valueOf(CollectionUtils.isEmpty((Collection)students1) ? 0 : students1.size()));
            }
        }
        return trainingJobMapVo;
    }

    @Override
    public Integer getUsersByMapId(Integer mapId) {
        int count = 0;
        List<Integer> ids = this.trainingJobMapMapper.selectCertificationIdsByMap(mapId);
        if (!CollectionUtils.isEmpty(ids)) {
            List<Object> userIds = new ArrayList();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingJobCertification::getId, ids);
            List certificationList = this.trainingJobCertificationMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)certificationList)) {
                for (TrainingJobCertification cer : certificationList) {
                    List userList;
                    BaseResult userListData = this.userApi.getSimpleUserByKeyWord(cer.getEnterpriseId(), null, cer.getPostId());
                    if (userListData == null || CollectionUtils.isEmpty((Collection)(userList = (List)userListData.getData()))) continue;
                    List jobUser = userList.stream().map(SimplePojo::getId).distinct().collect(Collectors.toList());
                    userIds.addAll(jobUser);
                }
            }
            count = CollectionUtils.isEmpty(userIds = userIds.stream().distinct().collect(Collectors.toList())) ? 0 : userIds.size();
        }
        return count;
    }

    @Override
    public List<TrainingJobCertificationVo> getUserCertificationByMapId(Integer mapId, Integer userId, Users users) {
        List<TrainingJobCertification> trainingJobCertifications;
        TrainingJobMap trainingJobMap = (TrainingJobMap)this.trainingJobMapMapper.selectById(mapId);
        if (ObjectUtils.isEmpty((Object)trainingJobMap)) {
            return null;
        }
        Integer isThrough = trainingJobMap.getIsThrough();
        if (userId != null) {
            users.setId(userId);
        }
        TrainingJobCertification userTrainingJobCertification = this.getJobByUserIdMapId(users, mapId);
        Integer lastSort = 0;
        if (!ObjectUtils.isEmpty((Object)userTrainingJobCertification)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobMapAndCertification::getMapId, (Object)mapId)).eq(TrainingJobMapAndCertification::getCertificationId, (Object)userTrainingJobCertification.getId())).last(" limit 1 ");
            TrainingJobMapAndCertification jobMap = (TrainingJobMapAndCertification)this.trainingJobMapAndCertificationMapper.selectOne((Wrapper)wrapper1);
            if (!ObjectUtils.isEmpty((Object)jobMap)) {
                Integer n = lastSort = !StringUtils.isEmpty((Object)jobMap.getLastSort()) ? jobMap.getLastSort() : jobMap.getSort();
            }
        }
        if (CollectionUtils.isEmpty(trainingJobCertifications = this.trainingJobMapMapper.selectCertificationsByMapId(mapId))) {
            return null;
        }
        List jobCertificationIds = trainingJobCertifications.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.in(TrainingJobStudentAnalyse::getJobId, jobCertificationIds)).eq(TrainingJobStudentAnalyse::getUserId, (Object)users.getId());
        List studentList = this.studentAnalyseMapper.selectList((Wrapper)wrapper1);
        Map<Object, Object> analyseMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)studentList)) {
            analyseMap = studentList.stream().collect(Collectors.groupingBy(TrainingJobStudentAnalyse::getJobId));
        }
        ArrayList<TrainingJobCertificationVo> trainingJobCertificationVos = new ArrayList<TrainingJobCertificationVo>();
        int i = 1;
        int sort = 1;
        boolean isLock = false;
        int isPost = 0;
        int locked = 0;
        Integer passStatused = 0;
        for (TrainingJobCertification trainingJobCertification : trainingJobCertifications) {
            TrainingJobCertificationVo trainingJobCertificationVo = new TrainingJobCertificationVo();
            BeanUtils.copyProperties((Object)trainingJobCertification, (Object)trainingJobCertificationVo);
            Integer passStatus = 0;
            List students = (List)analyseMap.get(trainingJobCertification.getId());
            if (!CollectionUtils.isEmpty((Collection)students)) {
                TrainingJobStudentAnalyse studentAnalyse = (TrainingJobStudentAnalyse)students.get(0);
                passStatus = studentAnalyse.getPassStatus();
            }
            if (i == 1) {
                if (passStatus == 0) {
                    trainingJobCertificationVo.setPassStatus(Integer.valueOf(3));
                    isLock = true;
                } else if (passStatus > 0 && passStatus < 3) {
                    trainingJobCertificationVo.setPassStatus(Integer.valueOf(1));
                    isLock = true;
                } else {
                    trainingJobCertificationVo.setPassStatus(Integer.valueOf(2));
                }
            } else if (passStatus > 0 && passStatus < 3) {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(1));
                isLock = true;
            } else if (passStatus == 3) {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(2));
            } else {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(0));
            }
            if (isThrough != null && isThrough == 1 && i > 1 && passStatused != 3) {
                locked = 1;
            }
            passStatused = passStatus;
            trainingJobCertificationVo.setIsLock(Integer.valueOf(locked));
            if (trainingJobCertificationVo.getPassStatus() == 0 && !isLock && lastSort >= i) {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(1));
                isLock = true;
            }
            trainingJobCertificationVo.setSort(Integer.valueOf(sort));
            ++sort;
            if (trainingJobCertificationVo.getPassStatus() == 0 && lastSort >= i) {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(3));
            }
            if (userTrainingJobCertification != null && userTrainingJobCertification.getId().equals(trainingJobCertification.getId())) {
                ++isPost;
            } else if (isPost == 1) {
                ++isPost;
            } else if (isPost == 2 && lastSort < i) {
                trainingJobCertificationVo.setPassStatus(Integer.valueOf(0));
            }
            trainingJobCertificationVos.add(trainingJobCertificationVo);
            ++i;
        }
        return trainingJobCertificationVos;
    }

    @Override
    public TrainingJobCertificationVo selectJobStagesById(Integer id, Users users, String versions) {
        int passStatus;
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!StringUtils.isEmpty((Object)clientInfo)) {
            if (!StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        TrainingJobCertificationVo jobVo = new TrainingJobCertificationVo();
        TrainingJobCertification jobs = (TrainingJobCertification)this.jobCertificationMapper.selectById(id);
        BeanUtils.copyProperties((Object)jobs, (Object)jobVo);
        int taskCount = 0;
        List<Integer> userIds = this.trainingJobCertificationService.selectJobUserListByJobId(id);
        jobVo.setGoNum(Integer.valueOf(CollectionUtils.isEmpty(userIds) ? 0 : userIds.size()));
        LambdaQueryWrapper stageWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)stageWrapper.eq(TrainingJobStage::getJobId, (Object)id)).orderByAsc(TrainingJobStage::getStageSort);
        List stageList = this.jobStageMapper.selectList((Wrapper)stageWrapper);
        LambdaQueryWrapper userTaskWrapperAll = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userTaskWrapperAll.eq(TrainingJobUserTask::getUserId, (Object)users.getId())).eq(TrainingJobUserTask::getJobId, (Object)id)).eq(TrainingJobUserTask::getTaskStatus, (Object)4);
        List userTaskListAll = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapperAll);
        Integer finishCount = CollectionUtils.isEmpty((Collection)userTaskListAll) ? 0 : userTaskListAll.size();
        List<Object> taskIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)userTaskListAll)) {
            taskIds = userTaskListAll.stream().map(TrainingJobUserTask::getStageTaskId).collect(Collectors.toList());
        }
        ArrayList<TrainingJobStageVo> stageVoList = new ArrayList<TrainingJobStageVo>();
        int lockStatus = 0;
        int jobStageStatus = 2;
        int stageLock = 0;
        if (!CollectionUtils.isEmpty((Collection)stageList)) {
            List stageIdList = stageList.stream().map(TrainingJobStage::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)taskWrapper.in(TrainingJobStageTask::getStageId, stageIdList)).orderByAsc(TrainingJobStageTask::getTaskSort);
            List allTaskList = this.jobStageTaskMapper.selectList((Wrapper)taskWrapper);
            Map<Object, Object> tasksMap = new HashMap();
            Map<Object, Object> trainingJobUserTaskMap = new HashMap();
            Map<Object, Object> trainingMap = new HashMap();
            Map<Object, Object> trainingChapterAttachMap = new HashMap();
            Map<Object, Object> trainingMaterialMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)allTaskList)) {
                List materialList;
                List materials;
                if (!("h5".equalsIgnoreCase(clientName) || version.compareTo("4.48.01") >= 0 || CollectionUtils.isEmpty(materials = allTaskList.stream().map(TrainingJobStageTask::getMaterialId).filter(Objects::nonNull).collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(materialList = this.trainingMaterialMapper.selectBatchIds(materials))))) {
                    Map materMap = materialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    ArrayList<TrainingJobStageTask> delList = new ArrayList<TrainingJobStageTask>();
                    for (TrainingJobStageTask task : allTaskList) {
                        TrainingMaterial material;
                        if (StringUtils.isEmpty((Object)task.getMaterialId()) || StringUtils.isEmpty((Object)(material = (TrainingMaterial)materMap.get(task.getMaterialId())).getIsCommodity()) || material.getIsCommodity() != 1) continue;
                        delList.add(task);
                    }
                    if (!CollectionUtils.isEmpty(delList)) {
                        allTaskList.removeAll(delList);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)allTaskList)) {
                    List trainingMaterialList;
                    List materialIds;
                    List trainingIdList;
                    tasksMap = allTaskList.stream().collect(Collectors.toMap(TrainingJobStageTask::getStageId, e -> new ArrayList<TrainingJobStageTask>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                    List trainingJobStageTaskIds = allTaskList.stream().map(TrainingJobStageTask::getId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(trainingJobStageTaskIds)) {
                        LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)users.getId())).in(TrainingJobUserTask::getStageTaskId, trainingJobStageTaskIds)).orderByDesc(TrainingJobUserTask::getId);
                        List userTaskList = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper);
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            trainingJobUserTaskMap = userTaskList.stream().collect(Collectors.toMap(TrainingJobUserTask::getStageTaskId, e -> new ArrayList<TrainingJobUserTask>(Collections.singletonList(e)), (oldList, newList) -> {
                                oldList.addAll(newList);
                                return oldList;
                            }));
                        }
                    }
                    if (!CollectionUtils.isEmpty(trainingIdList = allTaskList.stream().map(TrainingJobStageTask::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        List trainings;
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0);
                        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                        }
                        if (!CollectionUtils.isEmpty((Collection)(trainings = this.trainingMapper.selectBatchIds(trainingIdList)))) {
                            trainingMap = trainings.stream().collect(Collectors.toMap(Training::getId, Function.identity()));
                        }
                    }
                    if (!CollectionUtils.isEmpty(materialIds = allTaskList.stream().map(TrainingJobStageTask::getMaterialId).filter(Objects::nonNull).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds)))) {
                        trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    }
                }
            }
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
            String going = this.messageSource.getMessage("training.job.status.going", null, locale);
            String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
            for (TrainingJobStage stage : stageList) {
                TrainingJobStageVo stageVo = new TrainingJobStageVo();
                BeanUtils.copyProperties((Object)stage, (Object)stageVo);
                if (StringUtils.isEmpty((Object)stageVo.getStageName())) {
                    stageVo.setStageName(this.messageSource.getMessage("training.job.task.stage", null, locale) + stageVo.getStageSort());
                }
                List taskList = (List)tasksMap.get(stage.getId());
                List<TrainingJobUserTask> userTaskLists = this.trainingJobMapMapper.selectUserTaskByStageId(stage.getId(), users.getId());
                if (jobStageStatus < 2) {
                    stageLock = 1;
                }
                if (CollectionUtils.isEmpty(userTaskLists) || userTaskLists.size() < taskList.size()) {
                    jobStageStatus = 1;
                }
                ArrayList<TrainingJobStageTaskVo> taskVoList = new ArrayList<TrainingJobStageTaskVo>();
                if (!CollectionUtils.isEmpty((Collection)taskList)) {
                    for (TrainingJobStageTask task : taskList) {
                        TrainingMaterial material;
                        if (task.getTaskType() == 5 && StringUtils.isEmpty((Object)versions)) continue;
                        TrainingJobStageTaskVo taskVo = new TrainingJobStageTaskVo();
                        BeanUtils.copyProperties((Object)task, (Object)taskVo);
                        if (StringUtils.isEmpty((Object)taskVo.getIsSync())) {
                            taskVo.setIsSync(Integer.valueOf(0));
                        }
                        List userTaskList = (List)trainingJobUserTaskMap.get(task.getId());
                        taskVo.setTaskStatus(Integer.valueOf(0));
                        if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                            Integer taskStatus = ((TrainingJobUserTask)userTaskList.get(0)).getTaskStatus();
                            for (TrainingJobUserTask jobUserTask : userTaskList) {
                                if (jobUserTask.getTaskStatus() != 4) continue;
                                taskStatus = 4;
                            }
                            taskVo.setTaskStatus(taskStatus);
                            TrainingJobShiftTask jobShiftTask = (TrainingJobShiftTask)this.jobShiftTaskMapper.selectById(((TrainingJobUserTask)userTaskList.get(0)).getShiftTaskId());
                            if (!ObjectUtils.isEmpty((Object)jobShiftTask)) {
                                taskVo.setTaskName(jobShiftTask.getTaskName() + (jobShiftTask.getTaskOrganize() == null ? "" : "-" + jobShiftTask.getTaskOrganize()) + (jobShiftTask.getAddContent() == null ? "" : "-" + jobShiftTask.getAddContent()));
                                taskVo.setTaskOrganize(jobShiftTask.getTaskOrganize());
                                taskVo.setAddContent(jobShiftTask.getAddContent());
                                taskVo.setTaskPlace(jobShiftTask.getTaskPlace());
                                taskVo.setStartTime(jobShiftTask.getStartTime());
                                taskVo.setEndTime(jobShiftTask.getEndTime());
                                if (Objects.isNull(jobShiftTask.getStartTime())) {
                                    taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                                    taskVo.setTaskSelfStatusStr(going);
                                } else if (jobShiftTask.getStartTime().after(new Date())) {
                                    taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                                    taskVo.setTaskSelfStatusStr(unStart);
                                } else if (!Objects.isNull(jobShiftTask.getEndTime()) && jobShiftTask.getEndTime().before(new Date())) {
                                    taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                                    taskVo.setTaskSelfStatusStr(ended);
                                } else {
                                    taskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                                    taskVo.setTaskSelfStatusStr(going);
                                }
                            }
                            LambdaQueryWrapper userTaskWrapper1 = new LambdaQueryWrapper();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userTaskWrapper1.eq(TrainingJobUserTask::getUserId, (Object)users.getId())).eq(TrainingJobUserTask::getJobId, (Object)task.getJobId())).eq(TrainingJobUserTask::getTaskType, (Object)3)).ne(TrainingJobUserTask::getId, (Object)((TrainingJobUserTask)userTaskList.get(0)).getId());
                            List userTaskList1 = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper1);
                            if (!CollectionUtils.isEmpty((Collection)userTaskList1)) {
                                taskVo.setIsTaskExist(Integer.valueOf(1));
                            } else {
                                taskVo.setIsTaskExist(Integer.valueOf(0));
                            }
                            if (((TrainingJobUserTask)userTaskList.get(0)).getTaskType() == 3) {
                                LambdaQueryWrapper taskUserWrapper = new LambdaQueryWrapper();
                                ((LambdaQueryWrapper)((LambdaQueryWrapper)taskUserWrapper.eq(TrainingLearnTaskUser::getJobUserTaskId, (Object)((TrainingJobUserTask)userTaskList.get(0)).getId())).orderByDesc(TrainingLearnTaskUser::getId)).last(" limit 1");
                                TrainingLearnTaskUser learnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)taskUserWrapper);
                                if (learnTaskUser != null) {
                                    taskVo.setTaskScheduleId(learnTaskUser.getProjectTaskScheduleId());
                                }
                            }
                        }
                        if (taskVo.getTrainingId() != null) {
                            Training training = (Training)trainingMap.get(taskVo.getTrainingId());
                            taskVo.setTraining(training);
                            if (!StringUtils.isEmpty((Object)training.getProjectShow()) && training.getProjectShow() < 5) {
                                TrainingAttachVo trainingAttachVo = this.getTrainingProgress(users.getId(), training);
                                taskVo.setTrainingProgress(trainingAttachVo.getProgress());
                                taskVo.setTrainingAttachCount(trainingAttachVo.getAttachCount());
                            } else {
                                List attachList = (List)trainingChapterAttachMap.get(training.getId());
                                taskVo.setTrainingAttachCount(Integer.valueOf(!CollectionUtils.isEmpty((Collection)attachList) ? attachList.size() : 0));
                                Integer learnType = 3;
                                List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(taskVo.getTrainingId(), learnType, taskVo.getId(), users.getId(), 1, taskVo.getIsSync());
                                if (!CollectionUtils.isEmpty(timeList)) {
                                    BigDecimal readRate = BigDecimal.ZERO;
                                    for (int m = 0; m < timeList.size(); ++m) {
                                        TrainingUserViewTimeVo map = timeList.get(m);
                                        readRate = readRate.add(map.getReadRate());
                                    }
                                    taskVo.setTrainingProgress(Integer.valueOf(readRate.divide(new BigDecimal("" + timeList.size()), 2, 1).multiply(new BigDecimal("100")).intValue()));
                                } else {
                                    taskVo.setTrainingProgress(Integer.valueOf(0));
                                }
                            }
                        }
                        if (taskVo.getOperateCheckId() != null) {
                            taskVo.setScore(CollectionUtils.isEmpty((Collection)userTaskList) ? null : ((TrainingJobUserTask)userTaskList.get(0)).getScore());
                        }
                        if (taskVo.getPaperId() != null) {
                            TrainingPaper trainingPaper = (TrainingPaper)this.trainingPaperMapper.selectById(taskVo.getPaperId());
                            taskVo.setPaperTime(Integer.valueOf(trainingPaper.getPaperTime() / 60));
                            taskVo.setPaperCount(trainingPaper.getRepetitionNum());
                            taskVo.setScore(CollectionUtils.isEmpty((Collection)userTaskList) ? null : ((TrainingJobUserTask)userTaskList.get(0)).getScore());
                        }
                        if (taskVo.getMaterialId() != null && (material = (TrainingMaterial)trainingMaterialMap.get(taskVo.getMaterialId())) != null) {
                            taskVo.setMaterial(material);
                            BigDecimal finishTime = new BigDecimal("30");
                            if (material.getIsVideo() == 1) {
                                finishTime = new BigDecimal(material.getDuration());
                                if (!StringUtils.isEmpty((Object)material.getFinishRate())) {
                                    finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal("100"), 0, 1);
                                }
                            } else if (material.getFinishTime() != null) {
                                finishTime = new BigDecimal(material.getFinishTime());
                            }
                            TrainingUserViewTimeVo userViewTimes = null;
                            userViewTimes = task.getIsSync() != null && task.getIsSync() == 1 ? this.userViewTimeMapper.selectMaterialViewTime(users.getId(), null, 0, material.getId(), null) : this.userViewTimeMapper.selectMaterialViewTime(users.getId(), task.getId(), 3, material.getId(), null);
                            if (Objects.nonNull(userViewTimes)) {
                                BigDecimal viewTime = new BigDecimal(userViewTimes.getViewTimes().toString());
                                BigDecimal rate = BigDecimal.ONE;
                                if (finishTime.compareTo(BigDecimal.ZERO) > 0) {
                                    rate = viewTime.divide(finishTime, 2, 1);
                                }
                                taskVo.setTrainingProgress(Integer.valueOf(viewTime.compareTo(finishTime) >= 0 ? 100 : rate.multiply(new BigDecimal("100")).intValue()));
                                taskVo.setNeedReadTimes(Integer.valueOf(viewTime.compareTo(finishTime) >= 0 ? 0 : finishTime.subtract(viewTime).intValue()));
                            } else {
                                taskVo.setTaskStatus(Integer.valueOf(1));
                                taskVo.setTrainingProgress(Integer.valueOf(0));
                            }
                        }
                        if (taskVo.getTaskStatus() == 0) {
                            taskVo.setTrainingProgress(Integer.valueOf(0));
                        }
                        if (stage.getIsThrough() != null && stage.getIsThrough() == 1) {
                            taskVo.setIsLock(this.getTaskStatus(taskCount, lockStatus, stage, CollectionUtils.isEmpty((Collection)userTaskList) ? null : (TrainingJobUserTask)userTaskList.get(0)));
                        } else if (jobVo.getIsStage() == 1) {
                            taskVo.setIsLock(Integer.valueOf(stageLock));
                        } else {
                            taskVo.setIsLock(Integer.valueOf(0));
                        }
                        if (taskVo.getIsLock() == 1) {
                            taskVo.setTrainingProgress(Integer.valueOf(0));
                            taskVo.setScore(null);
                            taskVo.setTaskStatus(Integer.valueOf(0));
                            if (taskIds.contains(task.getId())) {
                                Integer n = finishCount;
                                finishCount = finishCount - 1;
                                Integer n2 = finishCount;
                            }
                        }
                        taskVoList.add(taskVo);
                        lockStatus = taskVo.getTaskStatus();
                        ++taskCount;
                    }
                }
                stageVo.setJobStageTaskList(taskVoList);
                stageVoList.add(stageVo);
            }
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingJobStudentAnalyse::getJobId, (Object)id)).eq(TrainingJobStudentAnalyse::getUserId, (Object)users.getId());
        List students = this.studentAnalyseMapper.selectList((Wrapper)wrapper1);
        int n = passStatus = CollectionUtils.isEmpty((Collection)students) ? 0 : ((TrainingJobStudentAnalyse)students.get(0)).getPassStatus();
        if (!CollectionUtils.isEmpty((Collection)students) && passStatus >= 3) {
            TrainingCertificateDetail trainingCertificate = (TrainingCertificateDetail)this.trainingCertificateDetailMapper.selectById(((TrainingJobStudentAnalyse)students.get(0)).getCertificateId());
            jobVo.setUserCertificatePath(trainingCertificate != null ? trainingCertificate.getUrl() : null);
        }
        if (passStatus == 0) {
            jobVo.setPassStatus(null);
        } else if (passStatus >= 3) {
            jobVo.setPassStatus(Integer.valueOf(2));
        } else if (passStatus == 1) {
            jobVo.setPassStatus(Integer.valueOf(3));
        } else {
            jobVo.setPassStatus(Integer.valueOf(1));
        }
        jobVo.setFinishCount(finishCount);
        jobVo.setJobStageList(stageVoList);
        jobVo.setTaskCount(Integer.valueOf(taskCount));
        return jobVo;
    }

    private Integer getTaskStatus(Integer taskCount, Integer locakStatus, TrainingJobStage trainingJobStage, TrainingJobUserTask trainingJobUserTask) {
        Integer isLock = 0;
        if (taskCount == 0) {
            return isLock;
        }
        if (trainingJobStage.getIsThrough() != null && trainingJobStage.getIsThrough() == 1) {
            isLock = locakStatus < 4 ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return isLock;
    }

    private TrainingAttachVo getTrainingProgress(Integer userId, Training training) {
        TrainingAttachVo trainingAttachVo = new TrainingAttachVo();
        Integer progress = 0;
        if (training != null) {
            if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                TrainingChapterAttachUser attachUser;
                List<TrainingChapterAttach> attachList = this.trainingChapterAttachMapper.selectAllByTrainingId(training.getId());
                List<TrainingChapterVideo> videoList = this.trainingChapterVideoMapper.selectAllByTrainingId(training.getId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty(attachList) && org.apache.commons.collections.CollectionUtils.isEmpty(videoList)) {
                    return trainingAttachVo;
                }
                Integer count = attachList.size() + videoList.size();
                trainingAttachVo.setAttachCount(count);
                List<TrainingChapterAttachUser> chapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(null, userId, training.getId(), null, null);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(chapterAttachUsers)) {
                    return trainingAttachVo;
                }
                Map<String, TrainingChapterAttachUser> attachUserMap = chapterAttachUsers.stream().collect(Collectors.toMap(a -> MessageFormat.format("{0}:{1}", a.getAttachId(), a.getIsVideo()), a -> a, (x, y) -> x));
                Double percent = 0.0;
                Integer useTime = 0;
                Integer finishNum = 0;
                for (TrainingChapterAttach chapterAttach : attachList) {
                    attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", chapterAttach.getId(), 0));
                    if (!Objects.nonNull(attachUser) || attachUser.getIsFinish() != 1) continue;
                    Integer n = finishNum;
                    Integer n2 = finishNum = Integer.valueOf(finishNum + 1);
                    percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                }
                for (TrainingChapterVideo chapterVideo : videoList) {
                    attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", chapterVideo.getId(), 1));
                    if (!Objects.nonNull(attachUser)) continue;
                    Integer videoSize = StringUtils.isEmpty((Object)attachUser.getVideoSize()) ? 0 : attachUser.getVideoSize();
                    Integer playSize = StringUtils.isEmpty((Object)attachUser.getPlaySize()) ? 0 : attachUser.getPlaySize();
                    useTime = useTime + playSize;
                    if (playSize >= videoSize) {
                        Integer n = finishNum;
                        Integer n3 = finishNum = Integer.valueOf(finishNum + 1);
                        percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                        continue;
                    }
                    percent = Arith.add(percent, Arith.div(Arith.div(playSize.intValue(), videoSize.intValue(), 4), count.intValue(), 4));
                }
                if (finishNum == count) {
                    percent = 1.0;
                }
                progress = (int)Math.floor(Arith.mul(percent, 100.0));
            } else {
                Integer playSize;
                Integer videoSize;
                TrainingAttachUser attachUser;
                List<TrainingAttach> attachList = this.trainingAttachMapper.selectByTrainingId(training.getId());
                List<TrainingVideo> videoList = this.trainingVideoMapper.selectByTrainingId(training.getId());
                if (org.apache.commons.collections.CollectionUtils.isEmpty(attachList) && org.apache.commons.collections.CollectionUtils.isEmpty(videoList)) {
                    return trainingAttachVo;
                }
                Integer count = attachList.size() + videoList.size();
                trainingAttachVo.setAttachCount(count);
                List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, training.getId(), null, null);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(trainingAttachUsers)) {
                    return trainingAttachVo;
                }
                Map<String, TrainingAttachUser> attachUserMap = trainingAttachUsers.stream().collect(Collectors.toMap(a -> MessageFormat.format("{0}:{1}", a.getAttachId(), a.getIsVideo()), a -> a, (x, y) -> x));
                Double percent = 0.0;
                Integer useTime = 0;
                Integer finishNum = 0;
                for (TrainingAttach attach : attachList) {
                    attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", attach.getId(), 0));
                    if (!Objects.nonNull(attachUser) || attachUser.getIsFinish() != 1) continue;
                    videoSize = finishNum;
                    playSize = finishNum = Integer.valueOf(finishNum + 1);
                    percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                }
                for (TrainingVideo video : videoList) {
                    attachUser = attachUserMap.get(MessageFormat.format("{0}:{1}", video.getId(), 1));
                    if (!Objects.nonNull(attachUser)) continue;
                    videoSize = StringUtils.isEmpty((Object)attachUser.getVideoSize()) ? 0 : attachUser.getVideoSize();
                    playSize = StringUtils.isEmpty((Object)attachUser.getPlaySize()) ? 0 : attachUser.getPlaySize();
                    useTime = useTime + playSize;
                    if (playSize >= videoSize) {
                        Integer n = finishNum;
                        Integer n4 = finishNum = Integer.valueOf(finishNum + 1);
                        percent = Arith.add(percent, Arith.div(1.0, count.intValue(), 4));
                        continue;
                    }
                    percent = Arith.add(percent, Arith.div(Arith.div(playSize.intValue(), videoSize.intValue(), 4), count.intValue(), 4));
                }
                if (finishNum == count) {
                    percent = 1.0;
                }
                progress = (int)Math.floor(Arith.mul(percent, 100.0));
            }
        }
        trainingAttachVo.setProgress(progress);
        return trainingAttachVo;
    }

    @Override
    public List<TrainingJobShiftTaskVo> getUserTask(Integer id, Users users) {
        List<TrainingJobShiftTaskVo> jobShiftTaskVoList = this.trainingJobMapMapper.selectTaskVosByJobId(users.getId(), id);
        for (TrainingJobShiftTaskVo jobShiftTaskVo : jobShiftTaskVoList) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingJobUser::getJobType, (Object)6)).eq(TrainingJobUser::getJobId, (Object)jobShiftTaskVo.getId());
            List jobUserList = this.jobUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)jobUserList)) {
                ArrayList<TrainingLecturer> lecturerList = new ArrayList<TrainingLecturer>();
                for (TrainingJobUser jobUser : jobUserList) {
                    TrainingLecturer lecturer = (TrainingLecturer)this.lecturerMapper.selectById(jobUser.getLecturerId());
                    lecturerList.add(lecturer);
                }
                jobShiftTaskVo.setLecturerList(lecturerList);
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingJobUserTask::getShiftTaskId, (Object)jobShiftTaskVo.getId())).eq(TrainingJobUserTask::getUserId, (Object)users.getId())).eq(TrainingJobUserTask::getTaskType, (Object)3)).orderByDesc(TrainingJobUserTask::getId)).last(" limit 1");
            TrainingJobUserTask jobUserTask = (TrainingJobUserTask)this.jobUserTaskMapper.selectOne((Wrapper)wrapper2);
            if (jobUserTask != null) {
                LambdaQueryWrapper taskUserWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)taskUserWrapper.eq(TrainingLearnTaskUser::getJobUserTaskId, (Object)jobUserTask.getId())).orderByDesc(TrainingLearnTaskUser::getId)).last(" limit 1");
                TrainingLearnTaskUser learnTaskUser = (TrainingLearnTaskUser)this.trainingLearnTaskUserMapper.selectOne((Wrapper)taskUserWrapper);
                if (learnTaskUser != null) {
                    jobShiftTaskVo.setTaskScheduleId(learnTaskUser.getProjectTaskScheduleId());
                }
            }
            if (Objects.isNull(jobShiftTaskVo.getStartTime())) {
                jobShiftTaskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
                continue;
            }
            if (jobShiftTaskVo.getStartTime().after(new Date())) {
                jobShiftTaskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DEFAULT.getKey());
                continue;
            }
            if (!Objects.isNull(jobShiftTaskVo.getEndTime()) && jobShiftTaskVo.getEndTime().before(new Date())) {
                jobShiftTaskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.ENDED.getKey());
                continue;
            }
            jobShiftTaskVo.setTaskSelfStatus(ProjectTaskSelfStatusEnum.DOING.getKey());
        }
        return jobShiftTaskVoList;
    }

    @Override
    public TrainingJobCertification getJobByUserIdMapId(Users users, Integer mapId) {
        List ids;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        userIds.add(users.getId());
        BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(userIds, users.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
        Map data = (Map)userByDutiesIdOrUserId.getData();
        List usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data.get("date")), UsersDutiesPojo.class);
        if (!CollectionUtils.isEmpty((Collection)usersDutiesPojoList) && !CollectionUtils.isEmpty(ids = usersDutiesPojoList.stream().map(UsersDutiesPojo::getDutiesId).collect(Collectors.toList())) && mapId != null) {
            List<TrainingJobCertification> trainingJobCertifications = this.trainingJobMapMapper.getJobByUserIdMapId(ids, mapId);
            return CollectionUtils.isEmpty(trainingJobCertifications) ? null : trainingJobCertifications.get(0);
        }
        return null;
    }

    @Override
    public void saveAppProjectShow(TrainingAppShow appShow, Users users) {
        this.appShowMapper.insert(appShow);
    }

    @Override
    public TrainingUserTaskVo getUserAllTask(Page<TrainingJobStageTaskVo> page, Users user, Integer taskType, Integer moduleType2, Integer version) {
        TrainingUserTaskVo trainingUserTaskVo = new TrainingUserTaskVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Date now = new Date();
        if (moduleType2 == null || moduleType2 == 1) {
            List usersDutiesPojoList;
            ArrayList<TrainingJobCertificationVo> trainingJobCertificationVoList = new ArrayList<TrainingJobCertificationVo>();
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            userIds.add(user.getId());
            BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(userIds, user.getGroupId(), null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
            Map data = (Map)userByDutiesIdOrUserId.getData();
            if (!(StringUtils.isEmpty((Object)data) || StringUtils.isEmpty(data.get("date")) || CollectionUtils.isEmpty((Collection)(usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data.get("date")), UsersDutiesPojo.class))))) {
                List ids = usersDutiesPojoList.stream().map(UsersDutiesPojo::getDutiesId).collect(Collectors.toList());
                List<TrainingJobMapVo> trainingJobMapVoList = this.trainingJobMapMapper.selectMapsByCertificationIds(ids);
                block0: for (TrainingJobMapVo trainingJobMapVo : trainingJobMapVoList) {
                    List<TrainingJobCertificationVo> trainingJobCertificationVos = this.getUserCertificationByMapId(trainingJobMapVo.getId(), null, user);
                    if (CollectionUtils.isEmpty(trainingJobCertificationVos)) continue;
                    List certificationIds = trainingJobCertificationVos.stream().map(TrainingJobCertification::getId).collect(Collectors.toList());
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingJobStudentAnalyse::getJobId, certificationIds)).eq(TrainingJobStudentAnalyse::getUserId, (Object)user.getId())).ge(TrainingJobStudentAnalyse::getPassStatus, (Object)3);
                    List students1 = this.studentAnalyseMapper.selectList((Wrapper)wrapper1);
                    trainingJobMapVo.setFinishNumber(Integer.valueOf(CollectionUtils.isEmpty((Collection)students1) ? 0 : students1.size()));
                    int m = -1;
                    for (int i = 0; i < trainingJobCertificationVos.size(); ++i) {
                        trainingJobCertificationVos.get(i).setMapId(trainingJobMapVo.getId());
                        trainingJobCertificationVos.get(i).setMapName(trainingJobMapVo.getMapName());
                        trainingJobCertificationVos.get(i).setJobNumber(trainingJobMapVo.getJobNumber());
                        trainingJobCertificationVos.get(i).setFinishNumber(trainingJobMapVo.getFinishNumber());
                        if (trainingJobCertificationVos.size() == 1 && trainingJobCertificationVos.get(0).getPassStatus() < 2) {
                            trainingJobCertificationVos.get(0).setUpperMapName(this.messageSource.getMessage("training.job.map.initial", null, locale));
                            trainingJobCertificationVoList.add(trainingJobCertificationVos.get(0));
                            continue block0;
                        }
                        if (trainingJobCertificationVos.get(i).getPassStatus() == 1) {
                            if (i == 0) {
                                trainingJobCertificationVos.get(0).setUpperMapName(this.messageSource.getMessage("training.job.map.initial", null, locale));
                                trainingJobCertificationVoList.add(trainingJobCertificationVos.get(0));
                                continue block0;
                            }
                            trainingJobCertificationVos.get(i).setUpperMapName(trainingJobCertificationVos.get(i - 1).getPostName());
                            trainingJobCertificationVoList.add(trainingJobCertificationVos.get(i));
                            continue block0;
                        }
                        if (trainingJobCertificationVos.get(i).getPassStatus() == 3 && m == -1) {
                            m = i;
                        }
                        if (trainingJobCertificationVos.size() - 1 != i || i < 1) continue;
                        if (m > -1) {
                            if (m == 0) {
                                trainingJobCertificationVos.get(0).setUpperMapName(this.messageSource.getMessage("training.job.map.initial", null, locale));
                                trainingJobCertificationVoList.add(trainingJobCertificationVos.get(0));
                                continue;
                            }
                            trainingJobCertificationVos.get(m).setUpperMapName(trainingJobCertificationVos.get(m - 1).getPostName());
                            trainingJobCertificationVoList.add(trainingJobCertificationVos.get(m));
                            continue;
                        }
                        if (trainingJobCertificationVos.get(i).getPassStatus() != 1) continue;
                        trainingJobCertificationVos.get(i).setUpperMapName(trainingJobCertificationVos.get(i - 1).getPostName());
                        trainingJobCertificationVoList.add(trainingJobCertificationVos.get(i));
                    }
                }
                if (!CollectionUtils.isEmpty(trainingJobCertificationVoList)) {
                    for (TrainingJobCertificationVo trainingJobCertificationVo : trainingJobCertificationVoList) {
                        trainingJobCertificationVo.setPeopleNumber(this.getUsersByMapId(trainingJobCertificationVo.getMapId()));
                        LambdaQueryWrapper userTaskWrapperAll = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)userTaskWrapperAll.eq(TrainingJobUserTask::getUserId, (Object)user.getId())).eq(TrainingJobUserTask::getJobId, (Object)trainingJobCertificationVo.getId())).eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                        List userTaskListAll = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapperAll);
                        trainingJobCertificationVo.setFinishCount(Integer.valueOf(CollectionUtils.isEmpty((Collection)userTaskListAll) ? 0 : userTaskListAll.size()));
                        LambdaQueryWrapper taskLambdaQueryWrapper = new LambdaQueryWrapper();
                        taskLambdaQueryWrapper.eq(TrainingJobStageTask::getJobId, (Object)trainingJobCertificationVo.getId());
                        List trainingJobStageTasks = this.trainingJobStageTaskMapper.selectList((Wrapper)taskLambdaQueryWrapper);
                        trainingJobCertificationVo.setTaskCount(Integer.valueOf(CollectionUtils.isEmpty((Collection)trainingJobStageTasks) ? 0 : trainingJobStageTasks.size()));
                    }
                    trainingUserTaskVo.setTrainingJobCertificationVos(trainingJobCertificationVoList);
                }
            }
            trainingUserTaskVo.setHaveMap(!CollectionUtils.isEmpty(trainingJobCertificationVoList));
        }
        if (moduleType2 == null || moduleType2 == 2) {
            List<Integer> trainingIds = this.getTrainingFinishByUserId(user.getId(), user.getGroupId());
            ArrayList ids = new ArrayList();
            List<TrainingJobStageTaskVo> trainingJobStageTaskVos = null;
            ArrayList<Integer> courseIds = new ArrayList<Integer>();
            Map<Object, Object> userTaskMap = new HashMap();
            Map<Object, Object> stageTaskMap = new HashMap();
            if (taskType == null || taskType == 4) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(!StringUtils.isEmpty((Object)user.getGroupId()), TrainingCourseStageTask::getEnterpriseId, (Object)user.getGroupId());
                List courseStageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper2);
                stageTaskMap = courseStageTaskList.stream().collect(Collectors.groupingBy(TrainingCourseStageTask::getCourseId));
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).isNotNull(TrainingCourseUserTask::getCourseId);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    LambdaQueryWrapper wrapperU = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperU.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).orderByDesc(TrainingPaperUserTurns::getTurns);
                    List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapperU);
                    Map<Object, Object> turnMap = new HashMap();
                    if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                        turnMap = paperUserTurns.stream().collect(Collectors.groupingBy(TrainingPaperUserTurns::getStageId));
                    }
                    List courseIdsList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                    LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                    wrapper3.in(TrainingCourseStageTask::getCourseId, courseIdsList);
                    List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper3);
                    Map taskMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                    ArrayList<Object> delList = new ArrayList<Object>();
                    for (Object courseUserTask : userTaskList) {
                        TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(courseUserTask.getTaskId());
                        List userTurnsList = (List)turnMap.get(task.getStageId());
                        if (CollectionUtils.isEmpty((Collection)userTurnsList) || ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns().intValue() == courseUserTask.getTurns().intValue()) continue;
                        delList.add(courseUserTask);
                    }
                    if (!CollectionUtils.isEmpty(delList)) {
                        userTaskList.removeAll(delList);
                    }
                    List courseIdList = userTaskList.stream().map(TrainingCourseUserTask::getCourseId).distinct().collect(Collectors.toList());
                    userTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getCourseId));
                    for (Integer courseId : courseIdList) {
                        List taskIds;
                        List taskList = (List)userTaskMap.get(courseId);
                        if (CollectionUtils.isEmpty((Collection)taskList) || CollectionUtils.isEmpty(taskIds = taskList.stream().map(TrainingCourseUserTask::getTaskId).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)((Collection)stageTaskMap.get(courseId))) || taskIds.size() < ((List)stageTaskMap.get(courseId)).size()) continue;
                        courseIds.add(courseId);
                    }
                }
            }
            List<Integer> roleIds = this.userUtilService.selectUserRoleList(user);
            List<Integer> tagIds = null;
            ArrayList<String> orgIds = null;
            BaseResult tagResult = this.tagApi.getUsersTagByUserId(user.getId());
            if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                tagIds = ((List)tagResult.getData()).stream().map(UserTagMo::getId).distinct().collect(Collectors.toList());
            }
            UsersAndOrgsMo mo = new UsersAndOrgsMo();
            mo.setGroupId(user.getGroupId());
            mo.setUserId(user.getId());
            mo.setRetainAll(Boolean.valueOf(false));
            mo.setShowAllPath(Boolean.valueOf(true));
            BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
            if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                orgIds = new ArrayList<String>();
                Map map = (Map)orgResult.getData();
                if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                    List list = (List)map.get("O_");
                    for (Integer id : list) {
                        orgIds.add("O_" + id);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                    List list = (List)map.get("S_");
                    for (Integer id : list) {
                        orgIds.add("S_" + id);
                    }
                }
            }
            if (taskType == null) {
                trainingJobStageTaskVos = version != null && version > 43101 ? this.trainingJobMapMapper.getMyAllTaskByUserIdVersionByPage(page, user.getId(), user.getGroupId(), trainingIds, courseIds, roleIds, tagIds, orgIds, user.getCreateTime()) : this.trainingJobMapMapper.getMyAllTaskByUserIdByPage(page, user.getId(), user.getGroupId(), trainingIds, courseIds, roleIds, tagIds, orgIds);
            } else if (taskType != 1) {
                if (taskType == 2) {
                    trainingJobStageTaskVos = this.trainingJobMapMapper.getMyAllPaperByUserIdByPage(page, user.getId(), user.getGroupId(), roleIds, tagIds, orgIds, user.getCreateTime());
                } else if (taskType == 3) {
                    trainingJobStageTaskVos = this.trainingJobMapMapper.getMyAllProjectByUserIdByPage(page, user.getId(), user.getGroupId());
                } else if (taskType == 4 && version != null && version > 43101) {
                    trainingJobStageTaskVos = this.trainingJobMapMapper.getMyAllCourseByUserIdByPage(page, user.getId(), user.getGroupId(), courseIds, roleIds, tagIds, orgIds, user.getCreateTime());
                }
            }
            if (!CollectionUtils.isEmpty(trainingJobStageTaskVos)) {
                Set<Integer> shiftIds = trainingJobStageTaskVos.stream().map(TrainingJobStageTaskVo::getShiftId).collect(Collectors.toSet());
                List<AppTrainingShiftNumVo> numList = this.trainingLearnUserMapper.summaryUserNum(shiftIds);
                Map<Integer, Integer> numMap = numList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a.getUserNum(), (x, y) -> x));
                List<AppTrainingTaskNumVo> taskNumList = this.trainingLearnTaskUserMapper.summaryFinishNum(shiftIds, user.getId());
                Map<Integer, AppTrainingTaskNumVo> taskNumMap = taskNumList.stream().collect(Collectors.toMap(a -> a.getShiftId(), a -> a, (x, y) -> x));
                for (TrainingJobStageTaskVo trainingJobStageTaskVo : trainingJobStageTaskVos) {
                    if (trainingJobStageTaskVo.getTaskType() == 1) {
                        Training training = (Training)this.trainingMapper.selectById(trainingJobStageTaskVo.getId());
                        TrainingAttachVo trainingAttachVo = this.getTrainingProgress(user.getId(), training);
                        trainingJobStageTaskVo.setTrainingProgress(trainingAttachVo.getProgress());
                        trainingJobStageTaskVo.setTrainingAttachCount(trainingAttachVo.getAttachCount());
                        trainingJobStageTaskVo.setTraining(training);
                        continue;
                    }
                    if (trainingJobStageTaskVo.getTaskType() == 2) {
                        if (!StringUtils.isEmpty((Object)trainingJobStageTaskVo.getTaskStatus()) && trainingJobStageTaskVo.getTaskStatus() == 3) {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(2));
                        } else if (trainingJobStageTaskVo.getStartTime() != null && trainingJobStageTaskVo.getStartTime().getTime() > now.getTime()) {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(0));
                        } else if (trainingJobStageTaskVo.getEndTime() != null && trainingJobStageTaskVo.getEndTime().getTime() < now.getTime()) {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(2));
                        } else {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(1));
                        }
                        trainingJobStageTaskVo.setPaperTime(Integer.valueOf(trainingJobStageTaskVo.getPaperTime() != null ? trainingJobStageTaskVo.getPaperTime() / 60 : 0));
                        continue;
                    }
                    if (trainingJobStageTaskVo.getTaskType() == 4) {
                        if (!StringUtils.isEmpty((Object)trainingJobStageTaskVo.getTaskStatus())) {
                            if (trainingJobStageTaskVo.getTaskStatus() == 3) {
                                trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(2));
                            } else if (trainingJobStageTaskVo.getTaskStatus() == 2) {
                                trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(1));
                            } else if (trainingJobStageTaskVo.getTaskStatus() == 1) {
                                trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(0));
                            }
                        } else if (!StringUtils.isEmpty((Object)trainingJobStageTaskVo.getStartTime()) && trainingJobStageTaskVo.getStartTime().getTime() > now.getTime()) {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(0));
                        } else if (!StringUtils.isEmpty((Object)trainingJobStageTaskVo.getEndTime()) && trainingJobStageTaskVo.getEndTime().getTime() < now.getTime()) {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(2));
                        } else {
                            trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(1));
                        }
                        trainingJobStageTaskVo.setTotalNum(Integer.valueOf(StringUtils.isEmpty((Object)stageTaskMap.get(trainingJobStageTaskVo.getId())) ? 0 : ((List)stageTaskMap.get(trainingJobStageTaskVo.getId())).size()));
                        List taskList = (List)userTaskMap.get(trainingJobStageTaskVo.getId());
                        Integer finishNum = 0;
                        if (!CollectionUtils.isEmpty((Collection)taskList)) {
                            List taskIds = taskList.stream().map(TrainingCourseUserTask::getTaskId).distinct().collect(Collectors.toList());
                            finishNum = taskIds.size();
                        }
                        trainingJobStageTaskVo.setFinishNum(finishNum);
                        continue;
                    }
                    if (trainingJobStageTaskVo.getTaskType() != 5) continue;
                    if (Objects.nonNull(numMap)) {
                        Integer userNum = numMap.get(trainingJobStageTaskVo.getShiftId());
                        trainingJobStageTaskVo.setUserNum(userNum);
                    } else {
                        trainingJobStageTaskVo.setUserNum(Integer.valueOf(0));
                    }
                    AppTrainingTaskNumVo taskNumVo = taskNumMap.get(trainingJobStageTaskVo.getShiftId());
                    if (Objects.nonNull(taskNumVo)) {
                        trainingJobStageTaskVo.setTotalNum(taskNumVo.getTotalNum());
                        trainingJobStageTaskVo.setFinishNum(taskNumVo.getFinishNum());
                    } else {
                        trainingJobStageTaskVo.setTotalNum(Integer.valueOf(0));
                        trainingJobStageTaskVo.setFinishNum(Integer.valueOf(0));
                    }
                    if (trainingJobStageTaskVo.getEndTime() != null && trainingJobStageTaskVo.getEndTime().getTime() < now.getTime()) {
                        trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(2));
                        continue;
                    }
                    trainingJobStageTaskVo.setTaskStatus(Integer.valueOf(1));
                }
                page.setContent(trainingJobStageTaskVos);
                trainingUserTaskVo.setTrainingJobStageTaskVos(page);
            }
            if (taskType != null) {
                List<Object> taskVos = new ArrayList();
                taskVos = version != null && version > 43101 ? this.trainingJobMapMapper.getMyAllTaskByUserIdVersionByPage(page, user.getId(), user.getGroupId(), trainingIds, courseIds, roleIds, tagIds, orgIds, user.getCreateTime()) : this.trainingJobMapMapper.getMyAllTaskByUserIdByPage(page, user.getId(), user.getGroupId(), trainingIds, courseIds, roleIds, tagIds, orgIds);
            }
            trainingUserTaskVo.setHaveTask(page.getTotalCount() > 0L);
        }
        return trainingUserTaskVo;
    }

    public List<Integer> getTrainingFinishByUserId(Integer userId, Integer enterpriseId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Training> trainings = this.trainingMapper.selectByUserId(enterpriseId, userId);
        List<TrainingAttachVo> trainingAttachVos = this.trainingAttachUserMapper.selectUserTrainingFinish(userId);
        List<TrainingAttachVo> trainingAttachVos2 = this.trainingChapterAttachUserMapper.selectUserTrainingFinish(userId);
        Map<Integer, Integer> attachMap = trainingAttachVos.stream().collect(Collectors.toMap(TrainingAttach::getTrainingId, TrainingAttachVo::getFinishNumber));
        Map<Integer, Integer> attachChapterMap = trainingAttachVos2.stream().collect(Collectors.toMap(TrainingAttach::getTrainingId, TrainingAttachVo::getFinishNumber));
        if (!CollectionUtils.isEmpty(trainings)) {
            for (Training training : trainings) {
                int sttachSize;
                TrainingVo target = new TrainingVo();
                BeanUtils.copyProperties((Object)training, (Object)target);
                if (target.getIsChapter() != null && target.getIsChapter() == 1) {
                    if (attachChapterMap.get(target.getId()) == null || (sttachSize = this.getTrainingAttachSize(target.getId())) <= 0 || attachChapterMap.get(target.getId()) * 100 / sttachSize != 100) continue;
                    ids.add(training.getId());
                    continue;
                }
                if (attachMap.get(target.getId()) == null || (sttachSize = this.getTrainingOldAttachSize(target.getId())) <= 0 || attachMap.get(target.getId()) * 100 / sttachSize != 100) continue;
                ids.add(training.getId());
            }
        }
        return ids;
    }

    public Integer selectTrainingIsFinish(Integer userId, Integer trainingId) {
        Integer isFinish = 0;
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (!ObjectUtils.isEmpty((Object)training)) {
            if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                List<TrainingChapterAttachUser> trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(1, userId, trainingId, null, null);
                int attachSize = this.getTrainingAttachSize(trainingId);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers) && trainingChapterAttachUsers.size() >= attachSize) {
                    isFinish = 1;
                }
            } else {
                List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(1, userId, trainingId, null, null);
                int attachSize = this.getTrainingOldAttachSize(trainingId);
                if (!CollectionUtils.isEmpty(trainingAttachUsers) && trainingAttachUsers.size() >= attachSize) {
                    isFinish = 1;
                }
            }
        }
        return isFinish;
    }

    private int getTrainingAttachSize(Integer trainingId) {
        List<TrainingChapterAttach> trainingChapterAttachs = this.trainingChapterAttachMapper.selectAllByTrainingId(trainingId);
        List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectAllByTrainingId(trainingId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        return attachSize + videoSize;
    }

    private int getTrainingOldAttachSize(Integer trainingId) {
        List<TrainingAttach> trainingChapterAttachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
        List<TrainingVideo> trainingChapterVideos = this.trainingVideoMapper.selectByTrainingId(trainingId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        return attachSize + videoSize;
    }

    @Override
    public void push85Certification(Integer enterpriseId, Integer userId, String postName, String mapName, String isPass, Date passTime) {
        JSONObject jsonObject;
        String token = this.get85Token();
        String url = this.post85Url + "/ws/GetFunc/SyncDatas";
        HttpRequest httpRequest = HttpUtil.createPost((String)url);
        Param85Post.HEAD head = new Param85Post.HEAD();
        head.setACCESSTOKEN(token);
        head.setID("HRcoffee1");
        head.setKEYCOL("");
        head.setLSH("");
        head.setKEYVALUE("");
        Param85Post param = new Param85Post();
        Param85Post.BODY body = new Param85Post.BODY();
        body.setTABLENAME("A8KH");
        Param85Post.BODY.DATA data = new Param85Post.BODY.DATA();
        BaseResult baseResult = this.userOrganizeApi.getTrilateralDepIdByUserId(userId, enterpriseId);
        String shopNames = "";
        if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            shopNames = ((List)baseResult.getData()).stream().map(SimplePojo::getName).collect(Collectors.joining(","));
        }
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        userIds.add(userId);
        BaseResult baseResult1 = this.userApi.getTrilateralIdByIdList(userIds);
        String userId85 = null;
        if (baseResult1 == null || CollectionUtils.isEmpty((Collection)((Collection)baseResult1.getData())) || ((SimplePojo)((List)baseResult1.getData()).get(0)).getName() == null) {
            return;
        }
        userId85 = ((SimplePojo)((List)baseResult1.getData()).get(0)).getName();
        List<Param85Post.BODY.COLS> maps = this.putMaps(userId85, postName, mapName, isPass, passTime, shopNames);
        data.setDATA(maps);
        ArrayList<Param85Post.BODY.DATA> datas = new ArrayList<Param85Post.BODY.DATA>();
        datas.add(data);
        body.setDATAS(datas);
        param.setBODY(body);
        param.setHEAD(head);
        httpRequest.body(JSONArray.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}).toUpperCase());
        log.info("push85Certification_param+++++++++++++" + JSONArray.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}).toUpperCase());
        HttpResponse httpResponse = httpRequest.execute();
        String bodyStr = httpResponse.body();
        log.info("push85Certification_bodyStr========" + bodyStr);
        if (StringUtils.isEmpty((Object)bodyStr) || "1".equals((jsonObject = JSONObject.parseObject((String)bodyStr)).get((Object)"CODE"))) {
            // empty if block
        }
    }

    private List<Param85Post.BODY.COLS> putMaps(String userId, String postName, String mapName, String isPass, Date passTime, String shopNames) {
        Param85Post.BODY.COLS col = new Param85Post.BODY.COLS();
        ArrayList<Param85Post.BODY.COLS> cols = new ArrayList<Param85Post.BODY.COLS>();
        col.setCOLNAME("A0188");
        col.setCOLVALUE(userId);
        Param85Post.BODY.COLS CREATIONTIME = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS SIGNED = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS A8KH005 = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS A8KH006 = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS A8KH007 = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS A8KH008 = new Param85Post.BODY.COLS();
        Param85Post.BODY.COLS A8KH009 = new Param85Post.BODY.COLS();
        CREATIONTIME.setCOLNAME("CREATIONTIME");
        CREATIONTIME.setCOLVALUE(DateUtils.format(passTime, DateUtils.FORMAT_SHORT));
        SIGNED.setCOLNAME("SIGNED");
        SIGNED.setCOLVALUE("2");
        A8KH005.setCOLNAME("A8KH005");
        A8KH005.setCOLVALUE(shopNames);
        A8KH006.setCOLNAME("A8KH006");
        A8KH006.setCOLVALUE(postName);
        A8KH007.setCOLNAME("A8KH007");
        A8KH007.setCOLVALUE(mapName);
        A8KH008.setCOLNAME("A8KH008");
        A8KH008.setCOLVALUE(isPass);
        A8KH009.setCOLNAME("A8KH009");
        A8KH009.setCOLVALUE(DateUtils.format(passTime, DateUtils.FORMAT_SHORT));
        cols.add(col);
        cols.add(CREATIONTIME);
        cols.add(SIGNED);
        cols.add(A8KH005);
        cols.add(A8KH006);
        cols.add(A8KH007);
        cols.add(A8KH008);
        cols.add(A8KH009);
        return cols;
    }

    private String get85Token() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", "HRcoffee1");
        params.put("ATOKEN", "SFJjb2ZmZWVUaGlyZDE=");
        String url = this.post85Url + "/ws/HXR/GetAccessTokenByID";
        String postResult = HttpUtil.post((String)url, (String)JSON.toJSONString(params), (int)3000);
        JSONObject jsonObject = JSONObject.parseObject((String)postResult);
        log.info("get85Token=====" + jsonObject.toJSONString());
        if (jsonObject != null && "1".equals(jsonObject.get((Object)"CODE"))) {
            return jsonObject.get((Object)"CONTENT").toString();
        }
        return null;
    }

    @Override
    public TrainingUserPaperVo selectPaperCountById(Integer id, Integer sourceType, Integer sourceProjectId, Integer sourceTaskId, Integer sourceShiftId, Users user) {
        Integer paperCount = 1;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getUserId, (Object)user.getId())).eq(TrainingUserPaper::getTrainingPaperId, (Object)id)).isNotNull(TrainingUserPaper::getSubmitTime)).eq(!StringUtils.isEmpty((Object)sourceType), TrainingUserPaper::getSourceType, (Object)sourceType)).eq(!StringUtils.isEmpty((Object)sourceProjectId), TrainingUserPaper::getSourceProjectId, (Object)sourceProjectId)).eq(!StringUtils.isEmpty((Object)sourceTaskId), TrainingUserPaper::getSourceTaskId, (Object)sourceTaskId)).eq(!StringUtils.isEmpty((Object)sourceShiftId), TrainingUserPaper::getSourceShiftId, (Object)sourceShiftId)).orderByDesc(TrainingUserPaper::getId)).last(" limit 1");
        TrainingUserPaper userPapers = (TrainingUserPaper)this.userPaperMapper.selectOne((Wrapper)wrapper);
        if (StringUtils.isEmpty((Object)userPapers)) {
            paperCount = 0;
        }
        TrainingUserPaperVo userPaper = new TrainingUserPaperVo();
        userPaper.setPaperCount(paperCount);
        TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(id);
        if (!ObjectUtils.isEmpty((Object)paper)) {
            userPaper.setExamId(paper.getExamId());
        }
        return userPaper;
    }

    @Override
    public List<TrainingJobMapAndCertificationVo> selectLastCertificationList(TrainingJobMapAndCertification job, Users user) {
        ArrayList<TrainingJobMapAndCertificationVo> vo = new ArrayList<TrainingJobMapAndCertificationVo>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingJobMapAndCertification::getMapId, (Object)job.getMapId())).orderByAsc(TrainingJobMapAndCertification::getSort);
        List mapList = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)mapList)) {
            List certificationIds = mapList.stream().map(TrainingJobMapAndCertification::getCertificationId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingJobCertification::getId, certificationIds);
            List cerList = this.jobCertificationMapper.selectList((Wrapper)wrapper2);
            Map cerMap = cerList.stream().collect(Collectors.toMap(TrainingJobCertification::getId, Function.identity()));
            for (TrainingJobMapAndCertification certification : mapList) {
                TrainingJobMapAndCertificationVo certificationVo = new TrainingJobMapAndCertificationVo();
                BeanUtils.copyProperties((Object)certification, (Object)certificationVo);
                TrainingJobCertification cer = (TrainingJobCertification)cerMap.get(certification.getCertificationId());
                certificationVo.setCertificationName(cer.getCertificationName());
                vo.add(certificationVo);
            }
        }
        return vo;
    }

    @Override
    public Map selectIsFinishProject(Integer taskType, Integer id, Users user) {
        HashMap<String, Object> retuenMap = new HashMap<String, Object>();
        Integer isFinish = 0;
        String projectName = "";
        try {
            if (taskType != null && taskType == 1) {
                Training training = (Training)this.trainingMapper.selectById(id);
                if (!StringUtils.isEmpty((Object)training)) {
                    if (training.getProjectShow() != null) {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        wrapper1.eq(TrainingAndMaterial::getTrainingId, (Object)id);
                        List andMaterialList = this.trainingAndMaterialMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)andMaterialList)) {
                            List<Integer> materialIds = andMaterialList.stream().map(TrainingAndMaterial::getMaterialId).distinct().collect(Collectors.toList());
                            List materialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
                            List<TrainingUserViewTimeVo> userViewTimeVoList = this.commonService.selectViewTimeByMaterial(1, user.getId(), materialIds, Arrays.asList(id), null, null);
                            if (!CollectionUtils.isEmpty(userViewTimeVoList)) {
                                TrainingMaterial material;
                                TrainingUserViewTimeVo vo;
                                Map userViewMap = userViewTimeVoList.stream().collect(Collectors.toMap(TrainingUserViewTime::getMaterialId, Function.identity()));
                                Integer finishNum = 0;
                                Iterator iterator = materialList.iterator();
                                while (iterator.hasNext() && !StringUtils.isEmpty((Object)(vo = (TrainingUserViewTimeVo)userViewMap.get((material = (TrainingMaterial)iterator.next()).getId())))) {
                                    BigDecimal viewTimes = new BigDecimal(vo.getViewTimes());
                                    BigDecimal finishTime = new BigDecimal(0);
                                    if (material.getIsVideo() == 1) {
                                        finishTime = new BigDecimal(material.getDuration());
                                        if (!StringUtils.isEmpty((Object)material.getFinishRate())) {
                                            finishTime = finishTime.multiply(material.getFinishRate()).multiply(new BigDecimal(0.01));
                                        }
                                    } else if (material.getFinishTime() != null) {
                                        finishTime = new BigDecimal(material.getFinishTime());
                                    }
                                    if (viewTimes.compareTo(finishTime) < 0) break;
                                    Integer n = finishNum;
                                    Integer n2 = finishNum = Integer.valueOf(finishNum + 1);
                                }
                                if (finishNum.intValue() == materialList.size()) {
                                    isFinish = 1;
                                    projectName = training.getTitle();
                                }
                            }
                        }
                    } else {
                        isFinish = this.selectTrainingIsFinish(user.getId(), id);
                        if (isFinish == 1) {
                            projectName = training.getTitle();
                        }
                    }
                }
            } else if (taskType != null && taskType == 2) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)id)).eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getPaperStatus, Arrays.asList(1, 2));
                List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    isFinish = 1;
                    projectName = ((TrainingUserPaper)userPaperList.get(0)).getTitle();
                }
            } else if (taskType != null && taskType == 3) {
                TrainingLearnUser learnUser;
                TrainingLearnShift learnShift;
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnUser::getUserId, (Object)user.getId())).eq(TrainingLearnUser::getShiftId, (Object)id)).eq(TrainingLearnUser::getIsDelete, (Object)0)).eq(TrainingLearnUser::getLearnStatus, (Object)3);
                List learnUserList = this.trainingLearnUserMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)learnUserList) && !StringUtils.isEmpty((Object)(learnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById((learnUser = (TrainingLearnUser)learnUserList.get(0)).getShiftId())))) {
                    isFinish = 1;
                    projectName = learnShift.getShiftName() + (learnShift.getGroupName() != null ? "-" + learnShift.getGroupName() : "") + (learnShift.getSupplemenName() != null ? "-" + learnShift.getSupplemenName() : "");
                }
            } else if (taskType != null && taskType == 4) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(TrainingCourseStageTask::getCourseId, (Object)id);
                List stageTaskList = this.courseStageTaskMapper.selectList((Wrapper)wrapper1);
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getUserId, (Object)user.getId())).in(TrainingCourseUserTask::getTaskStatus, Arrays.asList(3, 4))).eq(TrainingCourseUserTask::getCourseId, (Object)id);
                List userTaskList = this.courseUserTaskMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                    List taskIds = userTaskList.stream().map(TrainingCourseUserTask::getTaskId).distinct().collect(Collectors.toList());
                    if (stageTaskList.size() <= taskIds.size()) {
                        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingPaperUserTurns::getUserId, (Object)user.getId())).eq(TrainingPaperUserTurns::getTurnType, (Object)4)).eq(TrainingPaperUserTurns::getProjectId, (Object)id)).orderByDesc(TrainingPaperUserTurns::getTurns);
                        List paperUserTurns = this.paperUserTurnsMapper.selectList((Wrapper)wrapper3);
                        if (!CollectionUtils.isEmpty((Collection)paperUserTurns)) {
                            Map<Integer, List> turnMap = paperUserTurns.stream().collect(Collectors.toMap(TrainingPaperUserTurns::getStageId, e -> new ArrayList<TrainingPaperUserTurns>(Arrays.asList(e)), (oldList, newList) -> {
                                oldList.addAll(newList);
                                return oldList;
                            }));
                            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                            wrapper4.eq(TrainingCourseStageTask::getCourseId, (Object)id);
                            List courseStageTasks = this.courseStageTaskMapper.selectList((Wrapper)wrapper4);
                            Map taskMap = courseStageTasks.stream().collect(Collectors.toMap(TrainingCourseStageTask::getId, Function.identity()));
                            ArrayList<TrainingCourseUserTask> delList = new ArrayList<TrainingCourseUserTask>();
                            for (TrainingCourseUserTask courseUserTask : userTaskList) {
                                TrainingCourseStageTask task = (TrainingCourseStageTask)taskMap.get(courseUserTask.getTaskId());
                                List userTurnsList = turnMap.get(task.getStageId());
                                if (CollectionUtils.isEmpty((Collection)userTurnsList) || ((TrainingPaperUserTurns)userTurnsList.get(0)).getTurns().intValue() == courseUserTask.getTurns().intValue()) continue;
                                delList.add(courseUserTask);
                            }
                            if (!CollectionUtils.isEmpty(delList)) {
                                userTaskList.removeAll(delList);
                            }
                            if (!CollectionUtils.isEmpty((Collection)userTaskList)) {
                                List taskIdss = userTaskList.stream().map(TrainingCourseUserTask::getTaskId).distinct().collect(Collectors.toList());
                                if (stageTaskList.size() <= taskIdss.size()) {
                                    isFinish = 1;
                                }
                            }
                        } else {
                            isFinish = 1;
                        }
                        if (isFinish == 1) {
                            TrainingCourse course = (TrainingCourse)this.courseMapper.selectById(id);
                            projectName = course.getCourseName();
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error("", (Throwable)e2);
        }
        retuenMap.put("isFinish", isFinish);
        retuenMap.put("projectName", projectName);
        return retuenMap;
    }
}

