/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.service.TrainingJobOperateService;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.vo.JobOperateVo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingJobOperateServiceImpl
implements TrainingJobOperateService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobOperateServiceImpl.class);
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingOperateService trainingOperateService;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;

    @Override
    public String getOperateCheckByPage(Page<JobOperateVo> page, Integer enterpriseId, Integer jobId, Integer stageId, String checkName) {
        List<JobOperateVo> voList = this.operateCheckMapper.getOperateCheckByPage(page, enterpriseId, checkName);
        LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
        taskWrapper.eq(TrainingJobStageTask::getJobId, (Object)jobId);
        taskWrapper.eq(TrainingJobStageTask::getStageId, (Object)stageId);
        taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
        List list = this.trainingJobStageTaskMapper.selectList((Wrapper)taskWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List canSelectIdList = list.stream().map(TrainingJobStageTask::getOperateCheckIdOld).collect(Collectors.toList());
            List selectIdList = list.stream().map(TrainingJobStageTask::getOperateCheckId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(canSelectIdList)) {
                for (JobOperateVo vo : voList) {
                    TrainingJobCertification job;
                    if (vo.getSource() != null && vo.getSource().equals(1) && !ObjectUtils.isEmpty((Object)(job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(vo.getBusinessKey())))) {
                        vo.setSourceName(job.getCertificationName());
                    }
                    if (canSelectIdList.contains(vo.getId())) {
                        vo.setIsSelect(1);
                        vo.setCanSelect(1);
                    }
                    if (!selectIdList.contains(vo.getId())) continue;
                    vo.setIsSelect(1);
                }
            }
        }
        page.setContent(voList);
        return JsonResult.success(page);
    }
}

