/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.ovopark.api.GoldApi;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDutiesApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.exception.CommonException;
import com.ovopark.training.exception.ResultCode;
import com.ovopark.training.exception.SysErrorException;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingGoldLogMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobExamineMapper;
import com.ovopark.training.mapper.TrainingJobMapAndCertificationMapper;
import com.ovopark.training.mapper.TrainingJobMapMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobStudentLogMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.StudentCountNumber;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobExamine;
import com.ovopark.training.model.TrainingJobMap;
import com.ovopark.training.model.TrainingJobMapAndCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobStudentAnalyse;
import com.ovopark.training.model.TrainingJobStudentLog;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.UsersDutiesPojo;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingJobParticipantsManagementService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.impl.TrainingJobMapServiceImpl;
import com.ovopark.training.util.ConstantsUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.ThreadPoolUtil;
import com.ovopark.training.vo.TrainingGoldLog;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrainingJobParticipantsManagementServiceImpl
extends ServiceImpl<TrainingJobStudentAnalyseMapper, TrainingJobStudentAnalyse>
implements TrainingJobParticipantsManagementService {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobParticipantsManagementServiceImpl.class);
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingJobExamineMapper trainingJobExamineMapper;
    @Autowired
    private TrainingJobStudentAnalyseMapper tJStudentAnalyseMapper;
    @Autowired
    private TrainingJobStudentLogMapper tJPStudentLogMapper;
    @Autowired
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingJobMapAndCertificationMapper trainingJobMapAndCertificationMapper;
    @Autowired
    private TrainingCertificateDetailMapper trainingCertificateDetailMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private UserDutiesApi userDutiesApi;
    @Autowired
    private TrainingLearnTaskUserMapper learnTaskUserMapper;
    @Autowired
    private TrainingLearnShiftMapper learnShiftMapper;
    @Autowired
    private TrainingTaskScheduleMapper scheduleMapper;
    @Autowired
    private TrainingJobMapServiceImpl jobMapServiceImpl;
    @Autowired
    private TrainingJobMapMapper trainingJobMapMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingGoldLogMapper trainingGoldLogMapper;
    @Autowired
    private TrainingJobCertificationMapper jobCertificationMapper;
    @Autowired
    private GoldApi goldApi;
    @Value(value="${85.enterpriseId}")
    private String enterpriseId85;
    @Autowired
    private MessageSource messageSource;

    @Override
    public Page<UsersDutiesPojo> studentAnalyse(Integer groupId, Integer jobId, List<String> deptId, String jobOrName, Integer learnStatus, Integer passStatus, Integer isFrozen, Integer pageNumber, Integer pageSize) {
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        if (currentUser == null || currentUser.getId() == null) {
            throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
        }
        List<Integer> userIdList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
        if (CollectionUtils.isEmpty(userIdList)) {
            Page usersDutiesPojoPage = new Page();
            usersDutiesPojoPage.setPageNumber(pageNumber.intValue());
            usersDutiesPojoPage.setPageSize(pageSize.intValue());
            return usersDutiesPojoPage;
        }
        userIdList = this.userUtilService.selectJobChildUserList(userIdList, jobId, currentUser, true);
        HashSet<Object> zllUserSet = new HashSet<Object>();
        HashSet<Integer> lastUserSet = new HashSet<Integer>();
        List deptIddata = new ArrayList();
        Set<Object> jobOrNamedata = new HashSet();
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(deptId)) {
                com.ovopark.organize.common.base.BaseResult userOrganizeByTypeIds = this.userOrganizeApi.getUserOrganizeByTypeIds(groupId, currentUser.getId(), deptId);
                if (userOrganizeByTypeIds.getIsError().booleanValue()) {
                    throw new CommonException("userOrganizeApi.getUserOrganizeByTypeIds\u8c03\u7528\u5931\u8d25");
                }
                deptIddata = (List)userOrganizeByTypeIds.getData();
            }
            if (jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, jobOrName, null);
                if (simpleUserByKeyWord.getIsError().booleanValue()) {
                    throw new CommonException("userApi.getSimpleUserByKeyWord\u8c03\u7528\u5931\u8d25");
                }
                List data = (List)simpleUserByKeyWord.getData();
                if (!CollectionUtils.isEmpty((Collection)data)) {
                    jobOrNamedata = data.stream().map(O -> O.getId()).collect(Collectors.toSet());
                }
            }
            if (!CollectionUtils.isEmpty(deptId) && jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                if (!CollectionUtils.isEmpty(jobOrNamedata) && !CollectionUtils.isEmpty(deptIddata)) {
                    List finalDeptIddata = deptIddata;
                    Set collect = jobOrNamedata.stream().filter(item -> finalDeptIddata.contains(item)).collect(Collectors.toSet());
                    zllUserSet.addAll(collect);
                }
            } else {
                zllUserSet.addAll(jobOrNamedata);
                zllUserSet.addAll(deptIddata);
            }
            if (!CollectionUtils.isEmpty(zllUserSet) && !CollectionUtils.isEmpty(userIdList)) {
                zllUserSet.retainAll(userIdList);
                lastUserSet = zllUserSet;
            }
        } else {
            lastUserSet.addAll(userIdList);
        }
        LambdaQueryWrapper mapAndCertificationWrapper = new LambdaQueryWrapper();
        mapAndCertificationWrapper.eq(TrainingJobMapAndCertification::getCertificationId, (Object)jobId);
        TrainingJobMapAndCertification mapAndCertification = (TrainingJobMapAndCertification)this.trainingJobMapAndCertificationMapper.selectOne((Wrapper)mapAndCertificationWrapper);
        Integer nowJobId = jobId;
        boolean B = false;
        if (mapAndCertification != null) {
            LambdaQueryWrapper mapAndCertificationWrapper2 = new LambdaQueryWrapper();
            mapAndCertificationWrapper2.eq(TrainingJobMapAndCertification::getMapId, (Object)mapAndCertification.getMapId());
            mapAndCertificationWrapper2.le(TrainingJobMapAndCertification::getSort, (Object)(mapAndCertification.getSort() - 1));
            mapAndCertificationWrapper2.orderByAsc(TrainingJobMapAndCertification::getSort);
            List trainingJobMapAndCertifications = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)mapAndCertificationWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobMapAndCertifications)) {
                nowJobId = ((TrainingJobMapAndCertification)trainingJobMapAndCertifications.get(0)).getCertificationId();
                B = true;
            }
        }
        LambdaQueryWrapper studentAnalysewapper = new LambdaQueryWrapper();
        Set<Object> studentAnalysesSet = new HashSet();
        List<TrainingJobStudentAnalyse> trainingJobStudentAnalyses = new ArrayList();
        if (!CollectionUtils.isEmpty(lastUserSet)) {
            studentAnalysewapper.in(TrainingJobStudentAnalyse::getUserId, lastUserSet);
            studentAnalysewapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
            trainingJobStudentAnalyses = this.tJStudentAnalyseMapper.selectList((Wrapper)studentAnalysewapper);
            studentAnalysesSet = trainingJobStudentAnalyses.stream().map(O -> O.getUserId()).collect(Collectors.toSet());
        }
        userIdList.removeAll(studentAnalysesSet);
        HashSet<Object> collect0 = new HashSet<Integer>(userIdList);
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(zllUserSet)) {
                zllUserSet.retainAll(userIdList);
                collect0 = zllUserSet;
            } else {
                collect0 = new HashSet();
            }
        }
        if (!CollectionUtils.isEmpty(collect0)) {
            for (Integer n : collect0) {
                TrainingJobStudentAnalyse sa = new TrainingJobStudentAnalyse();
                sa.setUserId(n);
                sa.setPassStatus(Integer.valueOf(0));
                sa.setLearnStatus(Integer.valueOf(1));
                trainingJobStudentAnalyses.add(sa);
            }
        }
        Set<Object> myLastset = new HashSet();
        if (!(CollectionUtils.isEmpty(trainingJobStudentAnalyses) || learnStatus == null && passStatus == null)) {
            for (TrainingJobStudentAnalyse trainingJobStudentAnalysis : trainingJobStudentAnalyses) {
                boolean f = true;
                if (learnStatus != null && trainingJobStudentAnalysis.getLearnStatus() != learnStatus) {
                    f = false;
                }
                if (passStatus != null && trainingJobStudentAnalysis.getPassStatus() != passStatus) {
                    f = false;
                }
                if (!f) continue;
                myLastset.add(trainingJobStudentAnalysis.getUserId());
            }
        } else {
            Set set = trainingJobStudentAnalyses.stream().map(O -> O.getUserId()).collect(Collectors.toSet());
            myLastset = set;
        }
        if (!CollectionUtils.isEmpty(myLastset)) {
            com.ovopark.organize.common.base.BaseResult baseResult = this.userDutiesApi.getUserByDutiesIdOrUserId(new ArrayList(myLastset), groupId, null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), isFrozen);
            if (baseResult.getIsError().booleanValue()) {
                throw new CommonException("userDutiesApi.getUserByDutiesIdOrUserId\u8c03\u7528\u5931\u8d25");
            }
            Map data = (Map)baseResult.getData();
            List usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data.get("date")), UsersDutiesPojo.class);
            Page usersDutiesPojoPage = ListUtil.myPage(usersDutiesPojoList, pageNumber, pageSize);
            List<Integer> userIds = usersDutiesPojoPage.getContent().stream().map(UsersDutiesPojo::getId).collect(Collectors.toList());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIds, (String)","));
                parameter.put("groupId", groupId);
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, groupId);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, groupId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, groupId);
            LambdaQueryWrapper stageTaskWrapper = new LambdaQueryWrapper();
            stageTaskWrapper.eq(TrainingJobStageTask::getJobId, (Object)jobId);
            Integer totalNumber = this.trainingJobStageTaskMapper.selectCount((Wrapper)stageTaskWrapper);
            TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(jobId);
            Integer examineType = trainingJobCertification.getExamineType();
            for (UsersDutiesPojo usersDutiesPojo : usersDutiesPojoPage.getContent()) {
                usersDutiesPojo.setExamineType(examineType);
                LambdaQueryWrapper userTaskWrapper0 = new LambdaQueryWrapper();
                userTaskWrapper0.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                userTaskWrapper0.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                userTaskWrapper0.isNotNull(TrainingJobUserTask::getStartTime);
                userTaskWrapper0.orderByAsc(TrainingJobUserTask::getStartTime);
                List trainingJobUserTasks = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper0);
                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks) && ((TrainingJobUserTask)trainingJobUserTasks.get(0)).getStartTime() != null) {
                    usersDutiesPojo.setStartTime(((TrainingJobUserTask)trainingJobUserTasks.get(0)).getStartTime());
                } else {
                    usersDutiesPojo.setStartTime(null);
                }
                LambdaQueryWrapper studentAnalyseWrapper3 = new LambdaQueryWrapper();
                studentAnalyseWrapper3.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
                studentAnalyseWrapper3.eq(TrainingJobStudentAnalyse::getUserId, (Object)usersDutiesPojo.getId());
                studentAnalyseWrapper3.last(" limit 1 ");
                TrainingJobStudentAnalyse trainingJobStudentAnalyse1 = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper3);
                if (trainingJobStudentAnalyse1 != null && trainingJobStudentAnalyse1.getPassStatus() == 3) {
                    LambdaQueryWrapper userTaskWrapper3 = new LambdaQueryWrapper();
                    userTaskWrapper3.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                    userTaskWrapper3.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                    userTaskWrapper3.isNotNull(TrainingJobUserTask::getEndTime);
                    userTaskWrapper3.orderByDesc(TrainingJobUserTask::getEndTime);
                    List trainingJobUserTasks2 = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper3);
                    if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks2) && ((TrainingJobUserTask)trainingJobUserTasks2.get(0)).getEndTime() != null) {
                        usersDutiesPojo.setEndTime(((TrainingJobUserTask)trainingJobUserTasks2.get(0)).getEndTime());
                    }
                } else {
                    usersDutiesPojo.setEndTime(null);
                }
                LambdaQueryWrapper studentAnalyseWrapper2 = new LambdaQueryWrapper();
                studentAnalyseWrapper2.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
                studentAnalyseWrapper2.eq(TrainingJobStudentAnalyse::getUserId, (Object)usersDutiesPojo.getId());
                ((LambdaQueryWrapper)studentAnalyseWrapper2.orderByDesc(TrainingJobStudentAnalyse::getId)).last(" limit 1 ");
                TrainingJobStudentAnalyse trainingJobStudentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper2);
                if (trainingJobStudentAnalyse != null) {
                    usersDutiesPojo.setPassStatus(trainingJobStudentAnalyse.getPassStatus());
                    if (trainingJobStudentAnalyse.getCertificateId() != null) {
                        TrainingCertificateDetail trainingCertificateDetail = (TrainingCertificateDetail)this.trainingCertificateDetailMapper.selectById(trainingJobStudentAnalyse.getCertificateId());
                        usersDutiesPojo.setUrl(trainingCertificateDetail.getUrl());
                    }
                    usersDutiesPojo.setPassStatus(trainingJobStudentAnalyse.getPassStatus());
                    usersDutiesPojo.setState(trainingJobStudentAnalyse.getLearnStatus());
                } else {
                    usersDutiesPojo.setState(Integer.valueOf(1));
                }
                LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                userTaskWrapper.eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                Integer completeNumber = this.trainingJobUserTaskMapper.selectCount((Wrapper)userTaskWrapper);
                usersDutiesPojo.setCompleteNumber(completeNumber);
                usersDutiesPojo.setTotalNumber(totalNumber);
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(usersDutiesPojo.getId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(usersDutiesPojo.getId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    usersDutiesPojo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(usersDutiesPojo.getId()) != null) {
                    usersDutiesPojo.setPost(dutiesMap.get(usersDutiesPojo.getId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    usersDutiesPojo.setParentName(parentMap.get(usersDutiesPojo.getId()));
                }
                if (CollectionUtils.isEmpty(parentIdMap)) continue;
                usersDutiesPojo.setParentUserId(parentIdMap.get(usersDutiesPojo.getId()));
            }
            return usersDutiesPojoPage;
        }
        Page page = new Page();
        page.setPageNumber(pageNumber.intValue());
        page.setPageSize(pageSize.intValue());
        return page;
    }

    @Override
    public List<UsersDutiesPojo> getStudentAnalyseList(Integer groupId, Integer jobId, String deptIdStr, String jobOrName, Integer learnStatus, Integer passStatus, Integer isFrozen, Users user) {
        List<Object> deptId = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)deptIdStr)) {
            deptId = Arrays.asList(deptIdStr.split(","));
        }
        if (user == null || user.getId() == null) {
            throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
        }
        List<Integer> userIdList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
        if (CollectionUtils.isEmpty(userIdList)) {
            return null;
        }
        userIdList = this.userUtilService.selectJobChildUserList(userIdList, jobId, user, true);
        HashSet<Object> zllUserSet = new HashSet<Object>();
        HashSet<Integer> lastUserSet = new HashSet<Integer>();
        List deptIddata = new ArrayList();
        Set<Object> jobOrNamedata = new HashSet();
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(deptId)) {
                com.ovopark.organize.common.base.BaseResult userOrganizeByTypeIds = this.userOrganizeApi.getUserOrganizeByTypeIds(groupId, user.getId(), deptId);
                if (userOrganizeByTypeIds.getIsError().booleanValue()) {
                    throw new CommonException("userOrganizeApi.getUserOrganizeByTypeIds\u8c03\u7528\u5931\u8d25");
                }
                deptIddata = (List)userOrganizeByTypeIds.getData();
            }
            if (jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, jobOrName, null);
                if (simpleUserByKeyWord.getIsError().booleanValue()) {
                    throw new CommonException("userApi.getSimpleUserByKeyWord\u8c03\u7528\u5931\u8d25");
                }
                List data = (List)simpleUserByKeyWord.getData();
                if (!CollectionUtils.isEmpty((Collection)data)) {
                    jobOrNamedata = data.stream().map(SimplePojo::getId).collect(Collectors.toSet());
                }
            }
            if (!CollectionUtils.isEmpty(deptId) && jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                if (!CollectionUtils.isEmpty(jobOrNamedata) && !CollectionUtils.isEmpty(deptIddata)) {
                    List finalDeptIddata = deptIddata;
                    Set collect = jobOrNamedata.stream().filter(item -> finalDeptIddata.contains(item)).collect(Collectors.toSet());
                    zllUserSet.addAll(collect);
                }
            } else {
                zllUserSet.addAll(jobOrNamedata);
                zllUserSet.addAll(deptIddata);
            }
            if (!CollectionUtils.isEmpty(zllUserSet) && !CollectionUtils.isEmpty(userIdList)) {
                zllUserSet.retainAll(userIdList);
                lastUserSet = zllUserSet;
            }
        } else {
            lastUserSet.addAll(userIdList);
        }
        LambdaQueryWrapper mapAndCertificationWrapper = new LambdaQueryWrapper();
        mapAndCertificationWrapper.eq(TrainingJobMapAndCertification::getCertificationId, (Object)jobId);
        TrainingJobMapAndCertification mapAndCertification = (TrainingJobMapAndCertification)this.trainingJobMapAndCertificationMapper.selectOne((Wrapper)mapAndCertificationWrapper);
        Integer nowJobId = jobId;
        boolean B = false;
        if (mapAndCertification != null) {
            LambdaQueryWrapper mapAndCertificationWrapper2 = new LambdaQueryWrapper();
            mapAndCertificationWrapper2.eq(TrainingJobMapAndCertification::getMapId, (Object)mapAndCertification.getMapId());
            mapAndCertificationWrapper2.le(TrainingJobMapAndCertification::getSort, (Object)(mapAndCertification.getSort() - 1));
            mapAndCertificationWrapper2.orderByAsc(TrainingJobMapAndCertification::getSort);
            List trainingJobMapAndCertifications = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)mapAndCertificationWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobMapAndCertifications)) {
                nowJobId = ((TrainingJobMapAndCertification)trainingJobMapAndCertifications.get(0)).getCertificationId();
                B = true;
            }
        }
        LambdaQueryWrapper studentAnalysewapper = new LambdaQueryWrapper();
        Set<Object> studentAnalysesSet = new HashSet();
        List<TrainingJobStudentAnalyse> trainingJobStudentAnalyses = new ArrayList();
        if (!CollectionUtils.isEmpty(lastUserSet)) {
            studentAnalysewapper.in(TrainingJobStudentAnalyse::getUserId, lastUserSet);
            studentAnalysewapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
            trainingJobStudentAnalyses = this.tJStudentAnalyseMapper.selectList((Wrapper)studentAnalysewapper);
            studentAnalysesSet = trainingJobStudentAnalyses.stream().map(O -> O.getUserId()).collect(Collectors.toSet());
        }
        userIdList.removeAll(studentAnalysesSet);
        HashSet<Object> collect0 = new HashSet<Integer>(userIdList);
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(zllUserSet)) {
                zllUserSet.retainAll(userIdList);
                collect0 = zllUserSet;
            } else {
                collect0 = new HashSet();
            }
        }
        if (!CollectionUtils.isEmpty(collect0)) {
            for (Integer n : collect0) {
                TrainingJobStudentAnalyse sa = new TrainingJobStudentAnalyse();
                sa.setUserId(n);
                sa.setPassStatus(Integer.valueOf(0));
                sa.setLearnStatus(Integer.valueOf(1));
                trainingJobStudentAnalyses.add(sa);
            }
        }
        Set<Object> myLastset = new HashSet();
        if (!(CollectionUtils.isEmpty(trainingJobStudentAnalyses) || learnStatus == null && passStatus == null)) {
            for (TrainingJobStudentAnalyse trainingJobStudentAnalysis : trainingJobStudentAnalyses) {
                boolean f = true;
                if (learnStatus != null && trainingJobStudentAnalysis.getLearnStatus() != learnStatus) {
                    f = false;
                }
                if (passStatus != null && trainingJobStudentAnalysis.getPassStatus() != passStatus) {
                    f = false;
                }
                if (!f) continue;
                myLastset.add(trainingJobStudentAnalysis.getUserId());
            }
        } else {
            myLastset = trainingJobStudentAnalyses.stream().map(TrainingJobStudentAnalyse::getUserId).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty(myLastset)) {
            com.ovopark.organize.common.base.BaseResult baseResult = this.userDutiesApi.getUserByDutiesIdOrUserId(new ArrayList(myLastset), groupId, null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), isFrozen);
            if (baseResult.getIsError().booleanValue()) {
                throw new CommonException("userDutiesApi.getUserByDutiesIdOrUserId\u8c03\u7528\u5931\u8d25");
            }
            Map data = (Map)baseResult.getData();
            List usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data.get("date")), UsersDutiesPojo.class);
            List<Integer> userIds = usersDutiesPojoList.stream().map(UsersDutiesPojo::getId).collect(Collectors.toList());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIds, (String)","));
                parameter.put("groupId", groupId);
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, groupId);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, groupId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, groupId);
            LambdaQueryWrapper stageTaskWrapper = new LambdaQueryWrapper();
            stageTaskWrapper.eq(TrainingJobStageTask::getJobId, (Object)jobId);
            Integer totalNumber = this.trainingJobStageTaskMapper.selectCount((Wrapper)stageTaskWrapper);
            TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(jobId);
            Integer examineType = trainingJobCertification.getExamineType();
            for (UsersDutiesPojo usersDutiesPojo : usersDutiesPojoList) {
                usersDutiesPojo.setExamineType(examineType);
                LambdaQueryWrapper userTaskWrapper0 = new LambdaQueryWrapper();
                userTaskWrapper0.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                userTaskWrapper0.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                userTaskWrapper0.isNotNull(TrainingJobUserTask::getStartTime);
                userTaskWrapper0.orderByAsc(TrainingJobUserTask::getStartTime);
                List trainingJobUserTasks = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper0);
                if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks) && ((TrainingJobUserTask)trainingJobUserTasks.get(0)).getStartTime() != null) {
                    usersDutiesPojo.setStartTime(((TrainingJobUserTask)trainingJobUserTasks.get(0)).getStartTime());
                } else {
                    usersDutiesPojo.setStartTime(null);
                }
                LambdaQueryWrapper studentAnalyseWrapper3 = new LambdaQueryWrapper();
                studentAnalyseWrapper3.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
                studentAnalyseWrapper3.eq(TrainingJobStudentAnalyse::getUserId, (Object)usersDutiesPojo.getId());
                studentAnalyseWrapper3.last(" limit 1 ");
                TrainingJobStudentAnalyse trainingJobStudentAnalyse1 = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper3);
                if (trainingJobStudentAnalyse1 != null && trainingJobStudentAnalyse1.getPassStatus() == 3) {
                    LambdaQueryWrapper userTaskWrapper3 = new LambdaQueryWrapper();
                    userTaskWrapper3.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                    userTaskWrapper3.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                    userTaskWrapper3.isNotNull(TrainingJobUserTask::getEndTime);
                    userTaskWrapper3.orderByDesc(TrainingJobUserTask::getEndTime);
                    List trainingJobUserTasks2 = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper3);
                    if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks2) && ((TrainingJobUserTask)trainingJobUserTasks2.get(0)).getEndTime() != null) {
                        usersDutiesPojo.setEndTime(((TrainingJobUserTask)trainingJobUserTasks2.get(0)).getEndTime());
                    }
                } else {
                    usersDutiesPojo.setEndTime(null);
                }
                LambdaQueryWrapper studentAnalyseWrapper2 = new LambdaQueryWrapper();
                studentAnalyseWrapper2.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
                studentAnalyseWrapper2.eq(TrainingJobStudentAnalyse::getUserId, (Object)usersDutiesPojo.getId());
                ((LambdaQueryWrapper)studentAnalyseWrapper2.orderByDesc(TrainingJobStudentAnalyse::getId)).last(" limit 1 ");
                TrainingJobStudentAnalyse trainingJobStudentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper2);
                if (trainingJobStudentAnalyse != null) {
                    usersDutiesPojo.setPassStatus(trainingJobStudentAnalyse.getPassStatus());
                    if (trainingJobStudentAnalyse.getCertificateId() != null) {
                        TrainingCertificateDetail trainingCertificateDetail = (TrainingCertificateDetail)this.trainingCertificateDetailMapper.selectById(trainingJobStudentAnalyse.getCertificateId());
                        usersDutiesPojo.setUrl(trainingCertificateDetail.getUrl());
                    }
                    usersDutiesPojo.setPassStatus(trainingJobStudentAnalyse.getPassStatus());
                    usersDutiesPojo.setState(trainingJobStudentAnalyse.getLearnStatus());
                } else {
                    usersDutiesPojo.setState(Integer.valueOf(1));
                }
                LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                userTaskWrapper.eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                Integer completeNumber = this.trainingJobUserTaskMapper.selectCount((Wrapper)userTaskWrapper);
                usersDutiesPojo.setCompleteNumber(completeNumber);
                usersDutiesPojo.setTotalNumber(totalNumber);
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(usersDutiesPojo.getId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(usersDutiesPojo.getId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    usersDutiesPojo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(usersDutiesPojo.getId()) != null) {
                    usersDutiesPojo.setPost(dutiesMap.get(usersDutiesPojo.getId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    usersDutiesPojo.setParentName(parentMap.get(usersDutiesPojo.getId()));
                }
                if (CollectionUtils.isEmpty(parentIdMap)) continue;
                usersDutiesPojo.setParentUserId(parentIdMap.get(usersDutiesPojo.getId()));
            }
            return usersDutiesPojoList;
        }
        return null;
    }

    @Override
    public Page<UsersDutiesPojo> queryStudent(Integer groupId, Integer jobId, Integer shiftTaskId, List<String> deptId, Integer state, String jobOrName, Integer pageNumber, Integer pageSize) {
        Object data;
        Set TJUserTaskSet;
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        if (currentUser == null || currentUser.getId() == null) {
            throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
        }
        LambdaQueryWrapper tJUserTaskWrapper = new LambdaQueryWrapper();
        tJUserTaskWrapper.eq(TrainingJobUserTask::getShiftTaskId, (Object)shiftTaskId);
        tJUserTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)3);
        tJUserTaskWrapper.select(new SFunction[]{TrainingJobUserTask::getUserId});
        Set lastPMUserSet = TJUserTaskSet = this.trainingJobUserTaskMapper.selectList((Wrapper)tJUserTaskWrapper).stream().map(O -> O.getUserId()).collect(Collectors.toSet());
        HashSet zllUserSet = new HashSet();
        if (!(CollectionUtils.isEmpty(deptId) && (jobOrName == null || org.springframework.util.StringUtils.isEmpty((Object)jobOrName)) || CollectionUtils.isEmpty(TJUserTaskSet) || TJUserTaskSet.size() <= 0)) {
            if (!CollectionUtils.isEmpty(deptId)) {
                com.ovopark.organize.common.base.BaseResult userOrganizeByTypeIds = this.userOrganizeApi.getUserOrganizeByTypeIds(groupId, currentUser.getId(), deptId);
                if (userOrganizeByTypeIds.getIsError().booleanValue()) {
                    throw new CommonException("userOrganizeApi.getUserOrganizeByTypeIds\u8c03\u7528\u5931\u8d25");
                }
                data = (List)userOrganizeByTypeIds.getData();
                if (!CollectionUtils.isEmpty((Collection)data)) {
                    zllUserSet.addAll(data);
                }
            }
            if (jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName)) {
                Set collect;
                com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, jobOrName, null);
                if (simpleUserByKeyWord.getIsError().booleanValue()) {
                    throw new CommonException("userApi.getSimpleUserByKeyWord\u8c03\u7528\u5931\u8d25");
                }
                data = (List)simpleUserByKeyWord.getData();
                if (!CollectionUtils.isEmpty((Collection)data) && !CollectionUtils.isEmpty(collect = data.stream().map(O -> O.getId()).collect(Collectors.toSet()))) {
                    zllUserSet.addAll(collect);
                }
            }
            lastPMUserSet = !CollectionUtils.isEmpty(zllUserSet) && !CollectionUtils.isEmpty(TJUserTaskSet) ? TJUserTaskSet.stream().filter(item -> zllUserSet.contains(item)).collect(Collectors.toSet()) : new HashSet();
        }
        if (!CollectionUtils.isEmpty(lastPMUserSet) && lastPMUserSet.size() > 0) {
            com.ovopark.organize.common.base.BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(new ArrayList(lastPMUserSet), groupId, null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
            if (userByDutiesIdOrUserId.getIsError().booleanValue()) {
                throw new CommonException("userDutiesApi.getUserByDutiesIdOrUserId\u8c03\u7528\u5931\u8d25");
            }
            data = (Map)userByDutiesIdOrUserId.getData();
            List usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data.get("date")), UsersDutiesPojo.class);
            List<Integer> userIdList = usersDutiesPojoList.stream().map(UsersDutiesPojo::getId).collect(Collectors.toList());
            usersDutiesPojoList.forEach(user -> user.setOrganizeName(user.getOrganizeName().replaceAll(",", ";\n")));
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(userIdList, (String)","));
                parameter.put("groupId", groupId);
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIdList, groupId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIdList, groupId);
            List<UsersDutiesPojo> lastUsersDutiesPojoList = new ArrayList();
            LambdaQueryWrapper stageTaskWrapper = new LambdaQueryWrapper();
            stageTaskWrapper.eq(TrainingJobStageTask::getJobId, (Object)jobId);
            Integer totalNumber = this.trainingJobStageTaskMapper.selectCount((Wrapper)stageTaskWrapper);
            for (UsersDutiesPojo usersDutiesPojo : usersDutiesPojoList) {
                LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)jobId);
                userTaskWrapper.eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)usersDutiesPojo.getId());
                Integer completeNumber = this.trainingJobUserTaskMapper.selectCount((Wrapper)userTaskWrapper);
                usersDutiesPojo.setCompleteNumber(completeNumber);
                usersDutiesPojo.setTotalNumber(totalNumber);
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId)).eq(TrainingJobStudentAnalyse::getUserId, (Object)usersDutiesPojo.getId())).orderByDesc(TrainingJobStudentAnalyse::getId)).last(" limit 1 ");
                TrainingJobStudentAnalyse trainingJobStudentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)wrapper1);
                if (trainingJobStudentAnalyse != null) {
                    usersDutiesPojo.setState(trainingJobStudentAnalyse.getLearnStatus());
                } else {
                    usersDutiesPojo.setState(Integer.valueOf(1));
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(usersDutiesPojo.getId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(usersDutiesPojo.getId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    usersDutiesPojo.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    usersDutiesPojo.setParentName(parentMap.get(usersDutiesPojo.getId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    usersDutiesPojo.setParentUserId(parentIdMap.get(usersDutiesPojo.getId()));
                }
                if (state == -1 || usersDutiesPojo.getState() != state) continue;
                lastUsersDutiesPojoList.add(usersDutiesPojo);
            }
            if (state == -1) {
                lastUsersDutiesPojoList = usersDutiesPojoList;
            }
            Page usersDutiesPojoPage = ListUtil.myPage(lastUsersDutiesPojoList, pageNumber, pageSize);
            return usersDutiesPojoPage;
        }
        Page usersDutiesPojoPage = new Page();
        return usersDutiesPojoPage;
    }

    @Override
    public Page<UsersDutiesPojo> candidateComponents(Integer jobId, Integer dutiesId, String jobOrName, Integer groupId, Integer pageNumber, Integer pageSize) {
        Page usersDutiesPojoPage = new Page();
        usersDutiesPojoPage.setPageNumber(pageNumber.intValue());
        usersDutiesPojoPage.setPageSize(pageSize.intValue());
        List<Integer> yijieboUserIdList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        yijieboUserIdList = this.userUtilService.selectJobChildUserList(yijieboUserIdList, jobId, currentUser, true);
        Set collect = yijieboUserIdList.stream().collect(Collectors.toSet());
        if (!org.springframework.util.StringUtils.isEmpty((Object)jobOrName)) {
            List<Object> userIdList = new ArrayList();
            com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, jobOrName, null);
            if (simpleUserByKeyWord.getIsError().booleanValue()) {
                throw new CommonException("userApi.getSimpleUserByKeyWord\u8c03\u7528\u5931\u8d25");
            }
            List data = (List)simpleUserByKeyWord.getData();
            if (!CollectionUtils.isEmpty((Collection)data)) {
                userIdList = data.stream().map(O -> O.getId()).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(userIdList)) {
                return usersDutiesPojoPage;
            }
            if (!CollectionUtils.isEmpty(yijieboUserIdList) && !CollectionUtils.isEmpty(userIdList)) {
                List<Object> finalUserIdList = userIdList;
                collect = yijieboUserIdList.stream().filter(item -> finalUserIdList.contains(item)).collect(Collectors.toSet());
            }
        }
        if (!CollectionUtils.isEmpty(collect) && collect.size() > 0) {
            com.ovopark.organize.common.base.BaseResult userByDutiesIdOrUserId = this.userDutiesApi.getUserByDutiesIdOrUserId(new ArrayList(collect), groupId, null, null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null);
            if (userByDutiesIdOrUserId.getIsError().booleanValue()) {
                throw new CommonException("userDutiesApi.getUserByDutiesIdOrUserId\u8c03\u7528\u5931\u8d25");
            }
            Map data1 = (Map)userByDutiesIdOrUserId.getData();
            List usersDutiesPojoList = JSON.parseArray((String)JSON.toJSONString(data1.get("date")), UsersDutiesPojo.class);
            usersDutiesPojoPage = ListUtil.myPage(usersDutiesPojoList, pageNumber, pageSize);
            return usersDutiesPojoPage;
        }
        return usersDutiesPojoPage;
    }

    @Override
    public Integer removeStudent(Integer jobId, Integer shiftTaskId, List<Integer> studentList) {
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        LambdaQueryWrapper userTaskWrapper0 = new LambdaQueryWrapper();
        userTaskWrapper0.eq(TrainingJobUserTask::getJobId, (Object)jobId);
        userTaskWrapper0.eq(TrainingJobUserTask::getShiftTaskId, (Object)shiftTaskId);
        userTaskWrapper0.eq(TrainingJobUserTask::getTaskType, (Object)3);
        Integer count = this.trainingJobUserTaskMapper.selectCount((Wrapper)userTaskWrapper0);
        if (count.intValue() == studentList.size()) {
            return 1;
        }
        LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
        userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)jobId);
        userTaskWrapper.eq(TrainingJobUserTask::getShiftTaskId, (Object)shiftTaskId);
        userTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)3);
        userTaskWrapper.in(TrainingJobUserTask::getUserId, studentList);
        List trainingJobUserTasks = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper);
        this.trainingJobUserTaskMapper.delete((Wrapper)userTaskWrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingJobUserTasks)) {
            ThreadPoolUtil.getInstance().execute(() -> {
                try {
                    for (TrainingJobUserTask trainingJobUserTask : trainingJobUserTasks) {
                        LambdaQueryWrapper studentAnalyseWrapper;
                        com.ovopark.organize.common.base.BaseResult userById = this.userApi.getUserById(trainingJobUserTask.getUserId());
                        if (userById.getIsError().booleanValue()) {
                            throw new CommonException("userApi.getUserById\u8c03\u7528\u5931\u8d25");
                        }
                        String showName = ((UsersPojo)userById.getData()).getShowName();
                        TrainingJobStudentLog studentLog = new TrainingJobStudentLog();
                        studentLog.setJobNumber(trainingJobUserTask.getUserId());
                        studentLog.setName(showName);
                        studentLog.setAction(this.messageSource.getMessage("training.job.user.remove", null, Authenticator.getInstance().getCurrentClient().getLocale()));
                        studentLog.setOperator(currentUser.getShowName());
                        studentLog.setCreateTime(LocalDateTime.now());
                        studentLog.setShiftTaskId(shiftTaskId);
                        this.tJPStudentLogMapper.insert(studentLog);
                        LambdaQueryWrapper stageTaskWrapper = new LambdaQueryWrapper();
                        stageTaskWrapper.eq(TrainingJobStageTask::getJobId, (Object)trainingJobUserTask.getJobId());
                        Integer x = this.trainingJobStageTaskMapper.selectCount((Wrapper)stageTaskWrapper);
                        if (x == 0) {
                            throw new CommonException("Bug -> StageTask\u6570\u636e\u7ef4\u62a4\u5f02\u5e38");
                        }
                        if (x == 1) {
                            studentAnalyseWrapper = new LambdaQueryWrapper();
                            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)trainingJobUserTask.getJobId());
                            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getUserId, (Object)trainingJobUserTask.getUserId());
                            this.tJStudentAnalyseMapper.delete((Wrapper)studentAnalyseWrapper);
                        } else if (x > 1) {
                            studentAnalyseWrapper = new LambdaQueryWrapper();
                            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)trainingJobUserTask.getJobId());
                            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getUserId, (Object)trainingJobUserTask.getUserId());
                            TrainingJobStudentAnalyse studentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper);
                            if (studentAnalyse == null) {
                                throw new CommonException("Bug -> studentAnalyse\u6570\u636e\u7ef4\u62a4\u5f02\u5e38");
                            }
                            LambdaQueryWrapper userTaskWrapper2 = new LambdaQueryWrapper();
                            userTaskWrapper2.eq(TrainingJobUserTask::getJobId, (Object)trainingJobUserTask.getJobId());
                            userTaskWrapper2.eq(TrainingJobUserTask::getUserId, (Object)trainingJobUserTask.getUserId());
                            userTaskWrapper2.eq(TrainingJobUserTask::getTaskStatus, (Object)4);
                            Integer y = this.trainingJobUserTaskMapper.selectCount((Wrapper)userTaskWrapper2);
                            if (y == 0) {
                                studentAnalyse.setLearnStatus(Integer.valueOf(1));
                            } else if (y > 0) {
                                if (y < x) {
                                    studentAnalyse.setLearnStatus(Integer.valueOf(2));
                                }
                                if (y == x) {
                                    studentAnalyse.setLearnStatus(Integer.valueOf(3));
                                    studentAnalyse.setPassStatus(Integer.valueOf(1));
                                }
                            }
                            this.tJStudentAnalyseMapper.updateById(studentAnalyse);
                        }
                        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                        wrapper1.eq(TrainingLearnTaskUser::getJobUserTaskId, (Object)trainingJobUserTask.getId());
                        this.learnTaskUserMapper.delete((Wrapper)wrapper1);
                    }
                }
                catch (Exception e) {
                    throw new CommonException("{}", e);
                }
            });
        }
        return 0;
    }

    @Override
    public void addStudent(Integer groupId, Integer jobId, Integer stageTaskId, Integer shiftTaskId, List<Integer> studentList) {
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        if (currentUser == null || currentUser.getShowName() == null) {
            throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
        }
        LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
        userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)jobId);
        userTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)3);
        userTaskWrapper.eq(TrainingJobUserTask::getShiftTaskId, (Object)shiftTaskId);
        List containsset = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper).stream().map(O -> O.getUserId()).collect(Collectors.toList());
        List<Integer> afterfilter = studentList;
        if (!CollectionUtils.isEmpty(containsset) && !CollectionUtils.isEmpty(studentList)) {
            afterfilter = studentList.stream().filter(item -> !containsset.contains(item)).collect(Collectors.toList());
        }
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        for (Integer userId : afterfilter) {
            TrainingJobUserTask userTask = new TrainingJobUserTask();
            userTask.setJobId(jobId);
            userTask.setStageTaskId(stageTaskId);
            userTask.setTaskType(Integer.valueOf(3));
            userTask.setShiftTaskId(shiftTaskId);
            userTask.setUserId(userId);
            userTask.setTaskStatus(Integer.valueOf(0));
            userTask.setEnterpriseId(groupId);
            userTask.setCreaterId(currentUser.getId());
            userTask.setCreateTime(new Date());
            this.trainingJobUserTaskMapper.insert(userTask);
            com.ovopark.organize.common.base.BaseResult userById = this.userApi.getUserById(userId);
            if (userById.getIsError().booleanValue()) {
                throw new CommonException("userApi.getUserById\u8c03\u7528\u5931\u8d25");
            }
            TrainingJobStudentLog studentLog = new TrainingJobStudentLog();
            studentLog.setJobNumber(userId);
            studentLog.setName(((UsersPojo)userById.getData()).getShowName());
            studentLog.setAction(this.messageSource.getMessage("training.job.user.increase", null, locale));
            studentLog.setOperator(currentUser.getShowName());
            studentLog.setCreateTime(LocalDateTime.now());
            studentLog.setShiftTaskId(shiftTaskId);
            this.tJPStudentLogMapper.insert(studentLog);
            LambdaQueryWrapper studentAnalyseWrapper = new LambdaQueryWrapper();
            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getUserId, (Object)userId);
            Integer count = this.tJStudentAnalyseMapper.selectCount((Wrapper)studentAnalyseWrapper);
            if (count == null || count == 0) {
                TrainingJobStudentAnalyse studentAnalyse = new TrainingJobStudentAnalyse();
                studentAnalyse.setJobId(jobId);
                studentAnalyse.setUserId(userId);
                studentAnalyse.setCreateTime(LocalDateTime.now());
                studentAnalyse.setLearnStatus(Integer.valueOf(1));
                studentAnalyse.setPassStatus(Integer.valueOf(0));
                this.tJStudentAnalyseMapper.insert(studentAnalyse);
            }
            try {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLearnShift::getJobShiftId, (Object)shiftTaskId)).orderByDesc(TrainingLearnShift::getId)).last(" limit 1");
                TrainingLearnShift learnShift = (TrainingLearnShift)this.learnShiftMapper.selectOne((Wrapper)wrapper1);
                if (learnShift == null) continue;
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingTaskSchedule::getShiftId, (Object)learnShift.getId())).orderByDesc(TrainingTaskSchedule::getId)).last(" limit 1");
                TrainingTaskSchedule schedule = (TrainingTaskSchedule)this.scheduleMapper.selectOne((Wrapper)wrapper2);
                if (schedule == null) continue;
                TrainingLearnTaskUser learnTaskUser = new TrainingLearnTaskUser();
                learnTaskUser.setShiftId(learnShift.getId());
                learnTaskUser.setTaskStatus(Integer.valueOf(0));
                learnTaskUser.setProjectTaskScheduleId(schedule.getId());
                learnTaskUser.setUserId(userId);
                learnTaskUser.setJobUserTaskId(userTask.getId());
                learnTaskUser.setEnterpriseId(groupId);
                learnTaskUser.setCreateTime(new Date());
                this.learnTaskUserMapper.insert(learnTaskUser);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6dfb\u52a0\u5b66\u4e60\u9879\u76ee\u7684\u7ebf\u4e0b\u5b66\u5458", (Throwable)e);
            }
        }
    }

    @Override
    public List<SimplePojo> getUpOneLevelByJobId(Integer jobId, Integer groupId) {
        TrainingJobCertification trainingJobCertification;
        LambdaQueryWrapper mapAndCertificationWrapper = new LambdaQueryWrapper();
        mapAndCertificationWrapper.eq(TrainingJobMapAndCertification::getCertificationId, (Object)jobId);
        TrainingJobMapAndCertification mapAndCertification = (TrainingJobMapAndCertification)this.trainingJobMapAndCertificationMapper.selectOne((Wrapper)mapAndCertificationWrapper);
        Integer nowJobId = jobId;
        if (mapAndCertification != null) {
            LambdaQueryWrapper mapAndCertificationWrapper2 = new LambdaQueryWrapper();
            mapAndCertificationWrapper2.eq(TrainingJobMapAndCertification::getMapId, (Object)mapAndCertification.getMapId());
            mapAndCertificationWrapper2.le(TrainingJobMapAndCertification::getSort, (Object)(mapAndCertification.getSort() - 1));
            mapAndCertificationWrapper2.orderByAsc(TrainingJobMapAndCertification::getSort);
            List trainingJobMapAndCertifications = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)mapAndCertificationWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobMapAndCertifications)) {
                nowJobId = ((TrainingJobMapAndCertification)trainingJobMapAndCertifications.get(0)).getCertificationId();
            }
        }
        if ((trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(nowJobId)) != null) {
            com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, null, trainingJobCertification.getPostId());
            if (simpleUserByKeyWord.getIsError().booleanValue()) {
                throw new CommonException("userApi.getSimpleUserByKeyWord");
            }
            List data = (List)simpleUserByKeyWord.getData();
            return data;
        }
        return null;
    }

    @Override
    public StudentCountNumber countStudentAnalyse(Integer groupId, Integer jobId, List<String> deptId, String jobOrName) {
        Users currentUser = Authenticator.getInstance().getCurrentUser();
        if (currentUser == null || currentUser.getId() == null) {
            throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
        }
        List<Integer> userIdList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
        if (CollectionUtils.isEmpty(userIdList)) {
            StudentCountNumber studentCountNumber = new StudentCountNumber();
            return studentCountNumber;
        }
        userIdList = this.userUtilService.selectJobChildUserList(userIdList, jobId, currentUser, true);
        HashSet<Object> zllUserSet = new HashSet<Object>();
        HashSet<Integer> lastUserSet = new HashSet<Integer>();
        List deptIddata = new ArrayList();
        Set<Object> jobOrNamedata = new HashSet();
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(deptId)) {
                com.ovopark.organize.common.base.BaseResult userOrganizeByTypeIds = this.userOrganizeApi.getUserOrganizeByTypeIds(groupId, currentUser.getId(), deptId);
                if (userOrganizeByTypeIds.getIsError().booleanValue()) {
                    throw new CommonException("userOrganizeApi.getUserOrganizeByTypeIds\u8c03\u7528\u5931\u8d25");
                }
                deptIddata = (List)userOrganizeByTypeIds.getData();
            }
            if (jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                com.ovopark.organize.common.base.BaseResult simpleUserByKeyWord = this.userApi.getSimpleUserByKeyWord(groupId, jobOrName, null);
                if (simpleUserByKeyWord.getIsError().booleanValue()) {
                    throw new CommonException("userApi.getSimpleUserByKeyWord\u8c03\u7528\u5931\u8d25");
                }
                List data = (List)simpleUserByKeyWord.getData();
                if (!CollectionUtils.isEmpty((Collection)data)) {
                    jobOrNamedata = data.stream().map(O -> O.getId()).collect(Collectors.toSet());
                }
            }
            if (!CollectionUtils.isEmpty(deptId) && jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
                if (!CollectionUtils.isEmpty(jobOrNamedata) && !CollectionUtils.isEmpty(deptIddata)) {
                    List finalDeptIddata = deptIddata;
                    Set collect = jobOrNamedata.stream().filter(item -> finalDeptIddata.contains(item)).collect(Collectors.toSet());
                    zllUserSet.addAll(collect);
                }
            } else {
                zllUserSet.addAll(jobOrNamedata);
                zllUserSet.addAll(deptIddata);
            }
            if (!CollectionUtils.isEmpty(zllUserSet) && !CollectionUtils.isEmpty(userIdList)) {
                zllUserSet.retainAll(userIdList);
                lastUserSet = zllUserSet;
            }
        } else {
            lastUserSet.addAll(userIdList);
        }
        LambdaQueryWrapper mapAndCertificationWrapper = new LambdaQueryWrapper();
        mapAndCertificationWrapper.eq(TrainingJobMapAndCertification::getCertificationId, (Object)jobId);
        TrainingJobMapAndCertification mapAndCertification = (TrainingJobMapAndCertification)this.trainingJobMapAndCertificationMapper.selectOne((Wrapper)mapAndCertificationWrapper);
        Integer nowJobId = jobId;
        boolean B = false;
        if (mapAndCertification != null) {
            LambdaQueryWrapper mapAndCertificationWrapper2 = new LambdaQueryWrapper();
            mapAndCertificationWrapper2.eq(TrainingJobMapAndCertification::getMapId, (Object)mapAndCertification.getMapId());
            mapAndCertificationWrapper2.le(TrainingJobMapAndCertification::getSort, (Object)(mapAndCertification.getSort() - 1));
            mapAndCertificationWrapper2.orderByAsc(TrainingJobMapAndCertification::getSort);
            List trainingJobMapAndCertifications = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)mapAndCertificationWrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainingJobMapAndCertifications)) {
                nowJobId = ((TrainingJobMapAndCertification)trainingJobMapAndCertifications.get(0)).getCertificationId();
                B = true;
            }
        }
        LambdaQueryWrapper studentAnalysewapper = new LambdaQueryWrapper();
        Set<Object> studentAnalysesSet = new HashSet();
        List<TrainingJobStudentAnalyse> trainingJobStudentAnalyses = new ArrayList();
        if (!CollectionUtils.isEmpty(lastUserSet)) {
            studentAnalysewapper.in(TrainingJobStudentAnalyse::getUserId, lastUserSet);
            studentAnalysewapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
            trainingJobStudentAnalyses = this.tJStudentAnalyseMapper.selectList((Wrapper)studentAnalysewapper);
            studentAnalysesSet = trainingJobStudentAnalyses.stream().map(O -> O.getUserId()).collect(Collectors.toSet());
        }
        userIdList.removeAll(studentAnalysesSet);
        HashSet<Object> collect0 = new HashSet<Integer>(userIdList);
        if (!CollectionUtils.isEmpty(deptId) || jobOrName != null && !org.springframework.util.StringUtils.isEmpty((Object)jobOrName.trim())) {
            if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(zllUserSet)) {
                zllUserSet.retainAll(userIdList);
                collect0 = zllUserSet;
            } else {
                collect0 = new HashSet();
            }
        }
        if (!CollectionUtils.isEmpty(collect0)) {
            for (Integer userId : collect0) {
                TrainingJobStudentAnalyse sa = new TrainingJobStudentAnalyse();
                sa.setUserId(userId);
                sa.setPassStatus(Integer.valueOf(0));
                sa.setLearnStatus(Integer.valueOf(1));
                trainingJobStudentAnalyses.add(sa);
            }
        }
        StudentCountNumber studentCountNumber = new StudentCountNumber();
        long notPass = trainingJobStudentAnalyses.stream().filter(item -> item.getPassStatus() == 2).count();
        studentCountNumber.setNotPass(notPass);
        long pass = trainingJobStudentAnalyses.stream().filter(item -> item.getPassStatus() == 3).count();
        studentCountNumber.setPass(pass);
        long approvalPending = trainingJobStudentAnalyses.stream().filter(item -> item.getPassStatus() == 1).count();
        studentCountNumber.setApprovalPending(approvalPending);
        long completed = trainingJobStudentAnalyses.stream().filter(item -> item.getLearnStatus() == 3).count();
        studentCountNumber.setCompleted(completed);
        long underway = trainingJobStudentAnalyses.stream().filter(item -> item.getLearnStatus() == 2).count();
        studentCountNumber.setUnderway(underway);
        long notStart = trainingJobStudentAnalyses.stream().filter(item -> item.getLearnStatus() == 1).count();
        studentCountNumber.setNotStart(notStart);
        studentCountNumber.setAll(notStart + underway + completed);
        return studentCountNumber;
    }

    @Override
    public List<TrainingJobExamine> studentApproval(Integer jobId, Integer stageTaskId, Integer shiftTaskId, Integer userId) {
        LambdaQueryWrapper jobExamineWrapper = new LambdaQueryWrapper();
        jobExamineWrapper.eq(TrainingJobExamine::getJobId, (Object)jobId);
        jobExamineWrapper.eq(TrainingJobExamine::getUserId, (Object)userId);
        jobExamineWrapper.orderByAsc(TrainingJobExamine::getCreateTime);
        List trainingJobExamines = this.trainingJobExamineMapper.selectList((Wrapper)jobExamineWrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingJobExamines)) {
            Set createrSet = trainingJobExamines.stream().map(TrainingJobExamine::getCreater).collect(Collectors.toSet());
            com.ovopark.organize.common.base.BaseResult userByIdList = this.userApi.getUserByIdList(new ArrayList(createrSet));
            if (userByIdList.getIsError().booleanValue()) {
                throw new CommonException("userApi.getUserByIdList\u8c03\u7528\u5931\u8d25");
            }
            HashMap map = new HashMap();
            ((List)userByIdList.getData()).forEach(usersPojo -> map.put(usersPojo.getId(), usersPojo.getShowName()));
            trainingJobExamines.forEach(examine -> {
                if (examine.getCreater() != null && map.get(examine.getCreater()) != null) {
                    examine.setCreaterName((String)map.get(examine.getCreater()));
                } else {
                    examine.setCreaterName("--");
                }
            });
        }
        return trainingJobExamines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void studentApprovalProcess(Integer jobId, Integer stageTaskId, Integer shiftTaskId, Integer userId, Integer passStatus, String remark) {
        block10: {
            TrainingJobCertification trainingJobCertification;
            Locale locale;
            block8: {
                HashMap msg;
                TaskMessageBody body;
                block7: {
                    Users currentUser = Authenticator.getInstance().getCurrentUser();
                    if (currentUser == null || currentUser.getGroupId() == null || currentUser.getId() == null) {
                        throw new SysErrorException(ResultCode.TOKEN_ERROR, new Object[0]);
                    }
                    locale = Authenticator.getInstance().getCurrentClient().getLocale();
                    TrainingJobExamine trainingJobExamine = new TrainingJobExamine();
                    trainingJobExamine.setJobId(jobId);
                    trainingJobExamine.setUserId(userId);
                    trainingJobExamine.setPassStatus(passStatus);
                    trainingJobExamine.setRemark(remark);
                    trainingJobExamine.setIsAuto(Integer.valueOf(1));
                    trainingJobExamine.setEnterpriseId(currentUser.getGroupId());
                    trainingJobExamine.setCreater(currentUser.getId());
                    trainingJobExamine.setCreateTime(LocalDateTime.now());
                    this.trainingJobExamineMapper.insert(trainingJobExamine);
                    trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(jobId);
                    if (passStatus != 1) break block8;
                    Integer integer = this.trainingJobCertificationService.saveCertificateDetail(trainingJobCertification.getCertificateId(), trainingJobCertification.getCertificatePath(), userId, trainingJobCertification.getCreater(), 4, trainingJobCertification.getCertificationName());
                    LambdaQueryWrapper studentAnalyseWrapper = new LambdaQueryWrapper();
                    studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
                    studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getUserId, (Object)userId);
                    TrainingJobStudentAnalyse trainingJobStudentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper);
                    trainingJobStudentAnalyse.setCertificateId(integer);
                    trainingJobStudentAnalyse.setPassStatus(Integer.valueOf(3));
                    this.tJStudentAnalyseMapper.updateById(trainingJobStudentAnalyse);
                    try {
                        TrainingJobMapAndCertification jobMapAndCertification1;
                        TrainingJobMap jobMap;
                        if (trainingJobCertification.getEnterpriseId() == null || !this.enterpriseId85.equals(trainingJobCertification.getEnterpriseId().toString())) break block7;
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper1.eq(TrainingJobMapAndCertification::getCertificationId, (Object)jobId)).orderByDesc(TrainingJobMapAndCertification::getId);
                        List jobMapAndCertificationList = this.trainingJobMapAndCertificationMapper.selectList((Wrapper)wrapper1);
                        if (CollectionUtils.isEmpty((Collection)jobMapAndCertificationList) || (jobMap = (TrainingJobMap)this.trainingJobMapMapper.selectById((jobMapAndCertification1 = (TrainingJobMapAndCertification)jobMapAndCertificationList.get(0)).getMapId())) == null) break block7;
                        this.jobMapServiceImpl.push85Certification(trainingJobCertification.getEnterpriseId(), userId, trainingJobCertification.getPostName(), jobMap.getMapName(), "1", new Date());
                    }
                    catch (Exception e) {
                        try {
                            log.error("\u4eba\u5de5\u5ba1\u6279\u901a\u8fc7\uff0c\u63a8\u9001" + userId + "\u5c97\u4f4d" + trainingJobCertification.getPostName(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            TaskMessageBody body2 = new TaskMessageBody();
                            HashMap msg2 = Maps.newHashMap();
                            body2.setType(127);
                            msg2.put("projectId", trainingJobCertification.getId());
                            msg2.put("title", this.messageSource.getMessage("training.course.task.approve.pass", null, locale));
                            body2.setTaskJson(JSONObject.toJSONString((Object)msg2));
                            this.jPushService.sendWebSocket(this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), userId, trainingJobCertification.getEnterpriseId(), trainingJobCertification.getId(), "TYPE_APPROVAL_OBJ_TYPE", JSONObject.toJSONString((Object)msg2), null, 1, 0, "training.course.pass", null);
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_APPROVAL_OBJ_TYPE", userId, this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), body2);
                            throw throwable;
                        }
                        body = new TaskMessageBody();
                        msg = Maps.newHashMap();
                        body.setType(127);
                        msg.put("projectId", trainingJobCertification.getId());
                        msg.put("title", this.messageSource.getMessage("training.course.task.approve.pass", null, locale));
                        body.setTaskJson(JSONObject.toJSONString((Object)msg));
                        this.jPushService.sendWebSocket(this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), userId, trainingJobCertification.getEnterpriseId(), trainingJobCertification.getId(), "TYPE_APPROVAL_OBJ_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.course.pass", null);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_APPROVAL_OBJ_TYPE", userId, this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), body);
                    }
                }
                body = new TaskMessageBody();
                msg = Maps.newHashMap();
                body.setType(127);
                msg.put("projectId", trainingJobCertification.getId());
                msg.put("title", this.messageSource.getMessage("training.course.task.approve.pass", null, locale));
                body.setTaskJson(JSONObject.toJSONString((Object)msg));
                this.jPushService.sendWebSocket(this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), userId, trainingJobCertification.getEnterpriseId(), trainingJobCertification.getId(), "TYPE_APPROVAL_OBJ_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.course.pass", null);
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_APPROVAL_OBJ_TYPE", userId, this.messageSource.getMessage("training.course.task.approve.pass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.course.pass", null, locale), trainingJobCertification.getCertificationName()), body);
                TrainingJobCertification jobCertification = (TrainingJobCertification)this.jobCertificationMapper.selectById(jobId);
                LambdaQueryWrapper trainingGoldLogLambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)trainingGoldLogLambdaQueryWrapper.eq(TrainingGoldLog::getProjectId, (Object)jobCertification.getId())).eq(TrainingGoldLog::getUserId, (Object)userId)).eq(TrainingGoldLog::getType, (Object)ConstantsUtil.TrainingGoldLogTypeCode.JOB_CERTIFICATION);
                List goldLogList = this.trainingGoldLogMapper.selectList((Wrapper)trainingGoldLogLambdaQueryWrapper);
                if (jobCertification.getAwardGold() != 0 && CollectionUtils.isEmpty((Collection)goldLogList)) {
                    TrainingGoldLog trainingGoldLog = new TrainingGoldLog();
                    UsersPojo usersPojo = (UsersPojo)this.userApi.getUserById(userId).getData();
                    trainingGoldLog.setUserId(userId);
                    trainingGoldLog.setUserName(usersPojo.getUserName());
                    trainingGoldLog.setType(ConstantsUtil.TrainingGoldLogTypeCode.JOB_CERTIFICATION);
                    trainingGoldLog.setProjectId(jobCertification.getId());
                    trainingGoldLog.setDescription("\u5c97\u4f4d\u8ba4\u8bc1\u901a\u8fc7-" + jobCertification.getCertificationName());
                    trainingGoldLog.setGoldNum(jobCertification.getAwardGold());
                    trainingGoldLog.setResult(Integer.valueOf(1));
                    trainingGoldLog.setCreateTime(new Date());
                    com.ovopark.pojo.BaseResult goldBase = this.goldApi.addUserGoldWithTypeId(jobCertification.getEnterpriseId(), jobCertification.getAwardGold(), "\u5c97\u4f4d\u8ba4\u8bc1\u901a\u8fc7-" + jobCertification.getCertificationName() + "\uff0c\u91d1\u5e01+" + jobCertification.getAwardGold(), userId.toString(), Integer.valueOf(8), jobCertification.getId());
                    if (goldBase.getIsError().booleanValue()) {
                        trainingGoldLog.setResult(Integer.valueOf(0));
                    }
                    this.trainingGoldLogMapper.insert(trainingGoldLog);
                }
                break block10;
            }
            LambdaQueryWrapper studentAnalyseWrapper = new LambdaQueryWrapper();
            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getJobId, (Object)jobId);
            studentAnalyseWrapper.eq(TrainingJobStudentAnalyse::getUserId, (Object)userId);
            TrainingJobStudentAnalyse trainingJobStudentAnalyse = (TrainingJobStudentAnalyse)this.tJStudentAnalyseMapper.selectOne((Wrapper)studentAnalyseWrapper);
            trainingJobStudentAnalyse.setPassStatus(Integer.valueOf(2));
            trainingJobStudentAnalyse.setCertificateId(null);
            this.tJStudentAnalyseMapper.updateById(trainingJobStudentAnalyse);
            TaskMessageBody body = new TaskMessageBody();
            HashMap msg = Maps.newHashMap();
            msg.put("projectId", trainingJobCertification.getId());
            body.setType(127);
            msg.put("title", this.messageSource.getMessage("training.course.task.approve.unpass", null, locale));
            body.setTaskJson(JSONObject.toJSONString((Object)msg));
            this.jPushService.sendWebSocket(this.messageSource.getMessage("training.course.task.approve.unpass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.job.unpass", null, locale), trainingJobCertification.getCertificationName()), userId, trainingJobCertification.getEnterpriseId(), trainingJobCertification.getId(), "TYPE_APPROVAL_OBJ_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.job.unpass", trainingJobCertification.getCertificationName());
            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_APPROVAL_OBJ_TYPE", userId, this.messageSource.getMessage("training.course.task.approve.unpass", null, locale), MessageFormat.format(this.messageSource.getMessage("training.job.unpass", null, locale), trainingJobCertification.getCertificationName()), body);
        }
    }
}

