/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.mapper.TrainingLearnExamineMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingLearnExamine;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingLearnExamineService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingLearnExamineVo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingLearnExamineServiceImpl
implements TrainingLearnExamineService {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnExamineServiceImpl.class);
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private TrainingLearnExamineMapper trainingLearnExamineMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private JPushService jPushService;
    @Resource
    private TrainingLearnShiftMapper shiftMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private MessageSource messageSource;

    @Override
    public Integer saveTrainingLearnExamine(TrainingLearnExamineVo trainingLearnExamineVo) {
        Date now = new Date();
        trainingLearnExamineVo.setCreateTime(now);
        Integer examineId = 0;
        try {
            if (trainingLearnExamineVo.getId() == null) {
                examineId = this.trainingLearnExamineMapper.insert(trainingLearnExamineVo);
                if (trainingLearnExamineVo != null) {
                    TrainingLearnProject trainingLearnProject;
                    TrainingLearnUser trainingLearnUser = (TrainingLearnUser)this.trainingLearnUserMapper.selectById(trainingLearnExamineVo.getLearnUserId());
                    if (trainingLearnExamineVo.getPassStatus() != trainingLearnUser.getPassStatus()) {
                        trainingLearnUser.setPassStatus(trainingLearnExamineVo.getPassStatus());
                        this.trainingLearnUserMapper.updateById(trainingLearnUser);
                    }
                    if (!StringUtils.isEmpty((Object)(trainingLearnProject = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingLearnExamineVo.getProjectId())).getIsGet()) && trainingLearnProject.getIsGet() == 1 && !StringUtils.isEmpty((Object)trainingLearnProject.getCertificateId())) {
                        Integer certificateDetailId = this.jobCertificationService.saveCertificateDetail(trainingLearnProject.getCertificateId(), trainingLearnProject.getCertificatePath(), trainingLearnExamineVo.getUserId(), trainingLearnProject.getCreater(), 3, trainingLearnProject.getCertificateName());
                        trainingLearnUser.setCertificateId(certificateDetailId);
                        this.trainingLearnUserMapper.updateById(trainingLearnUser);
                    }
                    TrainingLearnShift shift = (TrainingLearnShift)this.shiftMapper.selectById(trainingLearnUser.getShiftId());
                    Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                    String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
                    TaskMessageBody body = new TaskMessageBody();
                    body.setType(95);
                    HashMap msg = Maps.newHashMap();
                    String shiftName = StringUtils.isEmpty((Object)shift.getSupplemenName()) ? MessageFormat.format("{0}-{1}", shift.getShiftName(), shift.getGroupName()) : MessageFormat.format("{0}-{1}-{2}", shift.getShiftName(), shift.getGroupName(), shift.getSupplemenName());
                    msg.put("projectId", shift.getProjectId());
                    msg.put("shiftId", shift.getId());
                    msg.put("title", learnName);
                    body.setTaskJson(JSONObject.toJSONString((Object)msg));
                    if (trainingLearnExamineVo.getPassStatus() == 1) {
                        String title;
                        String string = title = Objects.nonNull(trainingLearnProject) ? trainingLearnProject.getCertificateName() : "";
                        if (StringUtils.isEmpty((Object)title)) {
                            this.jPushService.sendWebSocket(learnName, this.messageSource.getMessage("training.learn.pass.exam", new Object[]{shiftName}, locale), trainingLearnExamineVo.getUserId(), trainingLearnProject.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam", shiftName);
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", trainingLearnExamineVo.getUserId(), learnName, this.messageSource.getMessage("training.learn.pass.exam", new Object[]{shiftName}, locale), body);
                        } else {
                            this.jPushService.sendWebSocket(learnName, this.messageSource.getMessage("training.learn.pass.exam.cert", new Object[]{shiftName, title}, locale), trainingLearnExamineVo.getUserId(), trainingLearnProject.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.learn.pass.exam.cert", shiftName + "," + title);
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", trainingLearnExamineVo.getUserId(), learnName, this.messageSource.getMessage("training.learn.pass.exam.cert", new Object[]{shiftName, title}, locale), body);
                        }
                    } else {
                        this.jPushService.sendWebSocket(learnName, this.messageSource.getMessage("training.course.unpass", new Object[]{shiftName}, locale), trainingLearnExamineVo.getUserId(), trainingLearnProject.getEnterpriseId(), shift.getId(), "TYPE_TRAINING_PASS_TYPE", JSONObject.toJSONString((Object)msg), null, 1, 0, "training.course.unpass", shiftName);
                        this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAINING_PASS_TYPE", trainingLearnExamineVo.getUserId(), learnName, this.messageSource.getMessage("training.course.unpass", new Object[]{shiftName}, locale), body);
                    }
                }
            }
        }
        catch (BeansException e) {
            log.error("", (Throwable)e);
        }
        return examineId;
    }

    @Override
    public void deleteLearnExamine(Integer examineId) {
    }

    @Override
    public List<TrainingLearnExamineVo> selectTrainingLearnExamine(Integer learnUserId) {
        List<TrainingLearnExamineVo> trainingLearnExamineVo = this.trainingLearnExamineMapper.selectTrainingLearnExamine(learnUserId);
        if (!CollectionUtils.isEmpty(trainingLearnExamineVo)) {
            List<Integer> userIds = trainingLearnExamineVo.stream().map(TrainingLearnExamine::getExecutorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIds);
            for (TrainingLearnExamineVo vo : trainingLearnExamineVo) {
                UsersPojo usersPojo = usersPojoMap.get(vo.getExecutorId());
                if (ObjectUtils.isEmpty((Object)usersPojo)) continue;
                vo.setExecutorName(usersPojo.getShowName());
            }
        }
        return trainingLearnExamineVo;
    }
}

