/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UsersSimpleMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.common.model.pojo.UsersRelationPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.mapper.TrainingLecturerLevelMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.UserOrganizeMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingLecturerLevel;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingLecturerService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLecturerLevelVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingLecturerServiceImpl
implements TrainingLecturerService {
    @Resource
    private TrainingLecturerMapper trainingLecturerMapper;
    @Resource
    private TrainingLecturerLevelMapper trainingLecturerLevelMapper;
    @Resource
    private UserOrganizeMapper userOrganizeMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private UserApi userApi;
    @Autowired
    private LogApi logApi;
    @Autowired
    private MessageSource messageSource;

    @Override
    public void saveTrainingLecturerLevel(TrainingLecturerLevel trainingLecturerLevel, Users user) {
        if (trainingLecturerLevel.getId() == null) {
            trainingLecturerLevel.setCreateId(user.getId());
            trainingLecturerLevel.setCreateTime(new Date());
            trainingLecturerLevel.setEnterpriseId(user.getGroupId());
            this.trainingLecturerLevelMapper.insert(trainingLecturerLevel);
        } else {
            trainingLecturerLevel.setCreateId(user.getId());
            trainingLecturerLevel.setUpdateTime(new Date());
            this.trainingLecturerLevelMapper.updateById(trainingLecturerLevel);
        }
    }

    @Override
    public String deleteTrainingLecturerLevel(Integer id, LogPojo pojo) {
        TrainingLecturerLevel level = (TrainingLecturerLevel)this.trainingLecturerLevelMapper.selectById(id);
        if (!pojo.getEnterpriseId().equals(level.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.trainingLecturerLevelMapper.deleteById(id);
        pojo.setI18nParam(level.getLevelName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public IPage<TrainingLecturerLevelVo> getTrainingLecturerLevel(IPage<TrainingLecturerLevelVo> trainingLecturerLevelIPage, Users user) {
        if (CollectionUtils.isEmpty((Collection)(trainingLecturerLevelIPage = this.trainingLecturerMapper.selectLecturerLevelPage(trainingLecturerLevelIPage, user.getGroupId())).getRecords())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.isNull(TrainingLecturerLevel::getEnterpriseId);
            List trainingLecturerLevels = this.trainingLecturerLevelMapper.selectList((Wrapper)lambdaQueryWrapper);
            trainingLecturerLevels.stream().forEach(e -> {
                e.setId(null);
                e.setCreateId(Integer.valueOf(1));
                e.setCreateTime(new Date());
                e.setEnterpriseId(user.getGroupId());
                this.trainingLecturerLevelMapper.insert(e);
            });
            ModelMapper modelMapper = new ModelMapper();
            List trainingLecturerLevelVos = (List)modelMapper.map((Object)trainingLecturerLevels, new TypeToken<List<TrainingLecturerLevelVo>>(){}.getType());
            trainingLecturerLevelIPage.setRecords(trainingLecturerLevelVos);
        } else {
            List list = trainingLecturerLevelIPage.getRecords();
            for (TrainingLecturerLevelVo vo : list) {
                vo.setCreateName(this.userUtilService.selectUser(vo.getCreateId()).getShowName());
            }
        }
        return trainingLecturerLevelIPage;
    }

    @Override
    public List<TrainingLecturerLevel> getTrainingLecturerLevelAll(Users user, Integer lecturerType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(TrainingLecturerLevel::getEnterpriseId, (Object)user.getGroupId())).eq(lecturerType != null, TrainingLecturerLevel::getLecturerType, (Object)lecturerType);
        return this.trainingLecturerLevelMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void saveTrainingLecturer(TrainingLecturer trainingLecturer, Users user) {
        if (trainingLecturer.getId() == null) {
            trainingLecturer.setCreateId(user.getId());
            trainingLecturer.setCreateTime(new Date());
            trainingLecturer.setEnterpriseId(user.getGroupId());
            trainingLecturer.setStatus(Integer.valueOf(1));
            this.trainingLecturerMapper.insert(trainingLecturer);
        } else {
            trainingLecturer.setUpdateTime(new Date());
            this.trainingLecturerMapper.updateById(trainingLecturer);
        }
    }

    @Override
    public void saveTrainingLecturerList(List<TrainingLecturer> list, Users user) {
        if (!CollectionUtils.isEmpty(list)) {
            for (TrainingLecturer trainingLecturer : list) {
                trainingLecturer.setCreateId(user.getId());
                trainingLecturer.setCreateTime(new Date());
                trainingLecturer.setEnterpriseId(user.getGroupId());
                trainingLecturer.setStatus(Integer.valueOf(1));
            }
            this.trainingLecturerMapper.insertList(list);
        }
    }

    @Override
    public String deleteTrainingLecturer(Integer id, LogPojo pojo) {
        TrainingLecturer lecturer = (TrainingLecturer)this.trainingLecturerMapper.selectById(id);
        if (!pojo.getEnterpriseId().equals(lecturer.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.trainingLecturerMapper.deleteById(id);
        pojo.setI18nParam(lecturer.getLecturerName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public IPage<TrainingLecturerVo> getTrainingLecturers(IPage<TrainingLecturer> trainingLecturerIPage, Users user, String name, Integer lecturerType, Integer levelId, Integer status) {
        IPage<TrainingLecturerVo> lecturerIPage = new IPage<TrainingLecturerVo>();
        lecturerIPage = name != null && !"".equals(name) ? this.trainingLecturerMapper.selectLecturersPage(trainingLecturerIPage, user.getGroupId(), null, lecturerType, levelId, status, name) : this.trainingLecturerMapper.selectLecturersPage(trainingLecturerIPage, user.getGroupId(), null, lecturerType, levelId, status, null);
        if (!CollectionUtils.isEmpty((Collection)lecturerIPage.getRecords())) {
            List userIdList = new ArrayList();
            List userIdList1 = lecturerIPage.getRecords().stream().map(TrainingLecturer::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List userIdList2 = lecturerIPage.getRecords().stream().map(TrainingLecturer::getCreateId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIdList1)) {
                userIdList.addAll(userIdList1);
            }
            if (!CollectionUtils.isEmpty(userIdList2)) {
                userIdList.addAll(userIdList2);
            }
            Map<Object, Object> userMap = new HashMap();
            Map userOrganizeMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList)) {
                BaseResult base = this.userApi.getUserByIdList(userIdList = userIdList.stream().distinct().collect(Collectors.toList()));
                if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    userMap = ((List)base.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
                }
                userOrganizeMap = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(user.getGroupId(), userIdList, null).getData();
            }
            for (TrainingLecturerVo e : lecturerIPage.getRecords()) {
                if (e.getUserId() != null) {
                    UsersPojo pojo1 = (UsersPojo)userMap.get(e.getUserId());
                    UsersPojo pojo2 = (UsersPojo)userMap.get(e.getCreateId());
                    e.setUserName(ObjectUtils.isEmpty((Object)pojo1) ? "" : pojo1.getShowName());
                    e.setCreateName(ObjectUtils.isEmpty((Object)pojo2) ? "" : pojo2.getShowName());
                    e.setThumbUrl(ObjectUtils.isEmpty((Object)pojo1) ? "" : pojo1.getThumbUrl());
                    List userStr = (List)userOrganizeMap.get(e.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)userStr)) {
                        e.setOrganizeName((String)userStr.get(0));
                    }
                }
                if (e.getLecturerType() == 1) {
                    e.setUserName(e.getLecturerName());
                }
                Integer trainCount = this.trainingLecturerMapper.selectTrainingCount(e.getId());
                Integer trainDuration = this.trainingLecturerMapper.selectTrainingDuration(e.getId());
                String durationFormal = "00:00:00";
                if (trainDuration != null) {
                    durationFormal = DateUtils.getUseTimeFormal(trainDuration);
                }
                e.setTrainingCount(trainCount);
                e.setDurationFormal(durationFormal);
                List<TrainingLearnShiftVo> learnShiftVoList = this.trainingLecturerMapper.selectShiftBylecturer(e.getId());
                Integer shiftCount = 0;
                String shiftFormal = "00:00:00";
                if (!CollectionUtils.isEmpty(learnShiftVoList)) {
                    shiftCount = learnShiftVoList.size();
                    long totalTime = 0L;
                    for (TrainingLearnShiftVo learnShiftVo : learnShiftVoList) {
                        if (learnShiftVo.getStartTime() == null || learnShiftVo.getEndTime() == null) continue;
                        totalTime += (learnShiftVo.getEndTime().getTime() - learnShiftVo.getStartTime().getTime()) / 1000L;
                    }
                    shiftFormal = DateUtils.getUseTimeFormal(new Long(totalTime).intValue());
                }
                e.setShiftCount(shiftCount);
                e.setShiftFormal(shiftFormal);
            }
        }
        return lecturerIPage;
    }

    @Override
    public List<TrainingLecturerVo> getTrainingLecturer(Users user, String name, Integer lecturerType, Integer levelId, Integer status) {
        List<Object> lecturerList = Lists.newArrayList();
        if (!StringUtils.isEmpty((Object)name)) {
            Map<String, Object> userMap = this.userUtilService.getCheckParameters(name, null, null, user);
            List userIdList = (List)userMap.get("userList");
            lecturerList = this.trainingLecturerMapper.selectLecturersPage(user.getGroupId(), userIdList, lecturerType, levelId, status, name);
        } else {
            lecturerList = this.trainingLecturerMapper.selectLecturersPage(user.getGroupId(), null, lecturerType, levelId, status, null);
        }
        List<Integer> userIds = lecturerList.stream().map(TrainingLecturer::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Integer> createIds = lecturerList.stream().map(TrainingLecturer::getCreateId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(userIds);
        Map<Integer, UsersPojo> createMap = this.userUtilService.selectUserMap(createIds);
        Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
        if (!CollectionUtils.isEmpty(lecturerList)) {
            lecturerList.forEach(e -> {
                UsersPojo userPojo;
                if (e.getUserId() != null && !ObjectUtils.isEmpty((Object)(userPojo = (UsersPojo)pojoMap.get(e.getUserId())))) {
                    e.setUserName(userPojo.getShowName());
                    e.setThumbUrl(userPojo.getThumbUrl());
                    UsersPojo createPojo = (UsersPojo)createMap.get(e.getCreateId());
                    e.setCreateName(ObjectUtils.isEmpty((Object)createPojo) ? "" : createPojo.getShowName());
                    List userStr = (List)userOrganizeMap.get(e.getUserId());
                    e.setOrganizeName(CollectionUtils.isEmpty((Collection)userStr) ? "" : (String)userStr.get(0));
                }
                if (e.getLecturerType() == 1) {
                    e.setUserName(e.getLecturerName());
                }
            });
        }
        return lecturerList;
    }

    @Override
    public void updateTrainingLecturerStatus(Integer id, Integer status) {
        TrainingLecturer trainingLecturer = (TrainingLecturer)this.trainingLecturerMapper.selectById(id);
        trainingLecturer.setStatus(status);
        this.trainingLecturerMapper.updateById(trainingLecturer);
    }

    @Override
    public boolean nameIsUse(TrainingLecturerLevel trainingLecturerLevel, TrainingLecturer trainingLecturer, Integer enterpriseId) {
        List trainingLecturerLevels;
        LambdaQueryWrapper lambdaQueryWrapper;
        if (!StringUtils.isEmpty((Object)trainingLecturerLevel)) {
            lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(TrainingLecturerLevel::getEnterpriseId, (Object)enterpriseId)).eq(TrainingLecturerLevel::getLecturerType, (Object)trainingLecturerLevel.getLecturerType())).eq(TrainingLecturerLevel::getLevelName, (Object)trainingLecturerLevel.getLevelName())).ne(trainingLecturerLevel.getId() != null, TrainingLecturerLevel::getId, (Object)trainingLecturerLevel.getId());
            trainingLecturerLevels = this.trainingLecturerLevelMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingLecturerLevels)) {
                return true;
            }
        }
        if (trainingLecturer != null) {
            lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(TrainingLecturer::getEnterpriseId, (Object)enterpriseId)).ne(trainingLecturer.getId() != null, TrainingLecturer::getId, (Object)trainingLecturer.getId());
            if (trainingLecturer.getLecturerType() == 0) {
                lambdaQueryWrapper.eq(TrainingLecturer::getUserId, (Object)trainingLecturer.getUserId());
            } else if (trainingLecturer.getLecturerType() == 1) {
                lambdaQueryWrapper.eq(TrainingLecturer::getLecturerName, (Object)trainingLecturer.getLecturerName());
            }
            trainingLecturerLevels = this.trainingLecturerMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingLecturerLevels)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IPage<TrainingLearnShiftVo> selectLecturerDetailByPage(IPage<TrainingLearnShiftVo> page, Integer id) {
        if (!CollectionUtils.isEmpty((Collection)(page = this.trainingLecturerMapper.selectLecturerDetailPage(page, id)).getRecords())) {
            page.getRecords().stream().forEach(e -> {
                if (e.getTrainingType() == 1) {
                    e.setFinishCount(Integer.valueOf(0));
                } else {
                    e.setFinishCount(Integer.valueOf(0));
                }
            });
        }
        return page;
    }

    @Override
    public Map selectMatchLecturer(List<TrainingLecturerVo> usersMoList, Integer enterpriseId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        HashMap maps = new HashMap();
        if (!CollectionUtils.isEmpty(usersMoList)) {
            Map<Object, Object> map1 = new HashMap();
            Map<Object, Object> map2 = new HashMap();
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingLecturer::getEnterpriseId, (Object)enterpriseId)).eq(TrainingLecturer::getLecturerType, (Object)0);
            List lecturerList1 = this.trainingLecturerMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)lecturerList1)) {
                map1 = lecturerList1.stream().collect(Collectors.toMap(TrainingLecturer::getUserId, e -> new ArrayList<TrainingLecturer>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingLecturer::getEnterpriseId, (Object)enterpriseId)).eq(TrainingLecturer::getLecturerType, (Object)1);
            List lecturerList2 = this.trainingLecturerMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)lecturerList2)) {
                map2 = lecturerList2.stream().collect(Collectors.toMap(TrainingLecturer::getLecturerName, e -> new ArrayList<TrainingLecturer>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            ArrayList<Integer> userIds = new ArrayList<Integer>();
            ArrayList<String> userNames = new ArrayList<String>();
            ArrayList<TrainingLecturerVo> successList = new ArrayList<TrainingLecturerVo>();
            ArrayList<TrainingLecturerVo> failList = new ArrayList<TrainingLecturerVo>();
            for (int i = 0; i < usersMoList.size(); ++i) {
                String reason = "";
                Integer isAlready = 1;
                TrainingLecturerVo lecturerVo = usersMoList.get(i);
                if (StringUtils.isEmpty((Object)lecturerVo.getLecturerType())) {
                    reason = reason + this.messageSource.getMessage("training.lecturer.type", null, locale) + this.messageSource.getMessage("training.question.not.null", null, locale) + ";";
                    isAlready = 0;
                }
                if (StringUtils.isEmpty((Object)lecturerVo.getUserName()) && StringUtils.isEmpty((Object)lecturerVo.getEmployeeNumber())) {
                    reason = reason + this.messageSource.getMessage("training.learn.user.exist.no", null, locale);
                    isAlready = 0;
                } else if (!StringUtils.isEmpty((Object)lecturerVo.getLecturerType())) {
                    if (lecturerVo.getLecturerType() == 0) {
                        UsersSimpleMo mo = new UsersSimpleMo();
                        mo.setGroupId(enterpriseId);
                        mo.setEmployeeNumber(lecturerVo.getEmployeeNumber());
                        mo.setUserName(lecturerVo.getUserName());
                        mo.setShowFrozen(Integer.valueOf(0));
                        BaseResult base = this.userApi.getUserByGroupIdAndKeyOrIds(mo);
                        if (StringUtils.isEmpty((Object)base) || CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                            reason = !StringUtils.isEmpty((Object)lecturerVo.getUserName()) && !StringUtils.isEmpty((Object)lecturerVo.getEmployeeNumber()) ? reason + this.messageSource.getMessage("training.learn.name.number.conflict", null, locale) : reason + this.messageSource.getMessage("training.learn.user.exist.no", null, locale);
                            isAlready = 0;
                        } else {
                            lecturerVo.setUserId(((UsersRelationPojo)((List)base.getData()).get(0)).getId());
                            lecturerVo.setLecturerName(((UsersRelationPojo)((List)base.getData()).get(0)).getShowName());
                        }
                    } else if (lecturerVo.getLecturerType() == 1) {
                        if (StringUtils.isEmpty((Object)lecturerVo.getUserName())) {
                            reason = reason + this.messageSource.getMessage("training.learn.user.exist.no", null, locale);
                            isAlready = 0;
                        } else {
                            lecturerVo.setLecturerName(lecturerVo.getUserName());
                        }
                    }
                }
                if (StringUtils.isEmpty((Object)lecturerVo.getLevelName())) {
                    reason = reason + this.messageSource.getMessage("training.operate.lecturer.must", null, locale);
                    isAlready = 0;
                } else {
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingLecturerLevel::getEnterpriseId, (Object)enterpriseId)).eq(TrainingLecturerLevel::getLevelName, (Object)lecturerVo.getLevelName())).eq(!StringUtils.isEmpty((Object)lecturerVo.getLecturerType()), TrainingLecturerLevel::getLecturerType, (Object)lecturerVo.getLecturerType());
                    List levels = this.trainingLecturerLevelMapper.selectList((Wrapper)wrapper1);
                    if (CollectionUtils.isEmpty((Collection)levels)) {
                        reason = reason + this.messageSource.getMessage("training.operate.lecturer.absent", null, locale);
                        isAlready = 0;
                    } else {
                        lecturerVo.setLevelId(((TrainingLecturerLevel)levels.get(0)).getId());
                    }
                }
                if (isAlready == 1) {
                    List lists;
                    if (lecturerVo.getLecturerType() == 0) {
                        lists = (List)map1.get(lecturerVo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)lists)) {
                            reason = reason + this.messageSource.getMessage("training.operate.lecturer.exist", null, locale);
                            isAlready = 0;
                        }
                    } else {
                        lists = (List)map2.get(lecturerVo.getLecturerName());
                        if (!CollectionUtils.isEmpty((Collection)lists)) {
                            reason = reason + this.messageSource.getMessage("training.operate.lecturer.exist", null, locale);
                            isAlready = 0;
                        }
                    }
                }
                lecturerVo.setReason(reason);
                lecturerVo.setIsAlready(isAlready);
                if (isAlready == 1) {
                    if (lecturerVo.getLecturerType() == 0) {
                        if (!CollectionUtils.isEmpty(userIds) && userIds.contains(lecturerVo.getUserId())) {
                            reason = reason + this.messageSource.getMessage("training.operate.lecturer.exist", null, locale);
                            isAlready = 0;
                            lecturerVo.setReason(reason);
                            lecturerVo.setIsAlready(isAlready);
                            failList.add(lecturerVo);
                            continue;
                        }
                        userIds.add(lecturerVo.getUserId());
                        successList.add(lecturerVo);
                        continue;
                    }
                    if (!CollectionUtils.isEmpty(userNames) && userNames.contains(lecturerVo.getUserName())) {
                        reason = reason + this.messageSource.getMessage("training.operate.lecturer.exist", null, locale);
                        isAlready = 0;
                        lecturerVo.setReason(reason);
                        lecturerVo.setIsAlready(isAlready);
                        failList.add(lecturerVo);
                        continue;
                    }
                    userNames.add(lecturerVo.getUserName());
                    successList.add(lecturerVo);
                    continue;
                }
                failList.add(lecturerVo);
            }
            maps.put("successList", successList);
            maps.put("failList", failList);
        }
        return maps;
    }
}

