/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMaterialAttachMapper;
import com.ovopark.training.mapper.TrainingMaterialLecturerMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialTextMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingMaterialVersionMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialAttach;
import com.ovopark.training.model.TrainingMaterialLecturer;
import com.ovopark.training.model.TrainingMaterialText;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingMaterialVersion;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.ResourceUpdateBo;
import com.ovopark.training.model.view.ResourcesVo;
import com.ovopark.training.request.DeptStudyMaterialOverviewReq;
import com.ovopark.training.response.DeptFinishLessonOverviewResponse;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.IDimensionSummarizeService;
import com.ovopark.training.service.TrainingMaterialNewService;
import com.ovopark.training.service.TrainingMaterialProductService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.DistinctUtils;
import com.ovopark.training.vo.MaterialStudyInfo;
import com.ovopark.training.vo.TrainingLecturerVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingMaterialNewServiceImpl
implements TrainingMaterialNewService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialNewServiceImpl.class);
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingMaterialService trainingMaterialService;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMaterialLecturerMapper materialLecturerMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingMaterialTextMapper trainingMaterialTextMapper;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;
    @Autowired
    private TrainingMaterialAttachMapper trainingMaterialAttachMapper;
    @Autowired
    private TrainingMaterialVersionMapper trainingMaterialVersionMapper;
    @Autowired
    private TrainingMaterialProductService trainingMaterialProductService;
    @Value(value="${training.material.text.picture}")
    private String picture;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingProjectTaskMapper trainingProjectTaskMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private TrainingLecturerMapper trainingLecturerMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private IDimensionSummarizeService dimensionSummarizeService;

    @Override
    public String insertMaterial(List<TrainingMaterialVo> materialList, final Users user) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Date now = new Date();
        final ArrayList<TrainingMaterial> materials = new ArrayList<TrainingMaterial>();
        String isNum = "0";
        if (!CollectionUtils.isEmpty(materialList)) {
            ArrayList<TrainingMaterialLecturer> materialLecturerList = new ArrayList<TrainingMaterialLecturer>();
            List<Integer> typeIdList = materialList.stream().map(TrainingMaterial::getMaterialTypeId).collect(Collectors.toList());
            Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, typeIdList);
            for (TrainingMaterialVo trainingMaterialVo : materialList) {
                if (validMaterialTypeIdSet.contains(trainingMaterialVo.getMaterialTypeId())) {
                    this.saveInsertMaterialContent(trainingMaterialVo, materialLecturerList, materials, user, now);
                    continue;
                }
                isNum = "1";
            }
            if (!CollectionUtils.isEmpty(materialLecturerList)) {
                this.materialLecturerMapper.insertList(materialLecturerList);
            }
            if (!CollectionUtils.isEmpty(materials)) {
                for (TrainingMaterial trainingMaterial : materials) {
                    if (trainingMaterial.getFileType() != null && trainingMaterial.getFileType() == 6) {
                        this.saveMaterialText((TrainingMaterialVo)trainingMaterial);
                    }
                    if (trainingMaterial.getMaterialTypeId() == null) continue;
                    TrainingMaterialType type = new TrainingMaterialType();
                    type.setId(trainingMaterial.getMaterialTypeId());
                    type.setUpdateTime(now);
                    type.setUpdater(user.getId());
                    this.materialTypeMapper.updateById(type);
                }
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (TrainingMaterial material : materials) {
                                TrainingMaterialNewServiceImpl.this.trainingMaterialService.saveMaterialCompression(material, user);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u89c6\u9891\u538b\u7f29:", (Throwable)e);
                        }
                    }
                });
            }
        }
        if ("1".equals(isNum)) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.power.data", null, locale), null);
        }
        return JsonResult.success(materials);
    }

    private void saveInsertMaterialContent(TrainingMaterialVo material, List<TrainingMaterialLecturer> materialLecturerList, List<TrainingMaterial> materials, Users user, Date now) {
        List<TrainingMaterialLecturer> trainingMaterialLecturerList;
        List attachList;
        material.setShowName(material.getMaterialName());
        if (material.getFileType() == 6) {
            material.setMaterialPath(this.picture);
        }
        material.setMaterialStatus(Integer.valueOf(StringUtils.isEmpty((Object)material.getMaterialStatus()) ? 1 : material.getMaterialStatus()));
        material.setIsUsing(Integer.valueOf(StringUtils.isEmpty((Object)material.getIsUsing()) ? 1 : material.getIsUsing()));
        material.setDuration(Integer.valueOf(StringUtils.isEmpty((Object)material.getDuration()) ? 0 : material.getDuration()));
        material.setEnterpriseId(user.getGroupId());
        material.setCreater(user.getId());
        material.setCreateTime(now);
        material.setUpdater(user.getId());
        material.setUpdateTime(now);
        material.setOldPath(material.getMaterialPath());
        material.setVersion(Integer.valueOf(1));
        material = this.buildDefaultMaterial(material);
        this.materialMapper.insert(material);
        TrainingResource trainingResource = new TrainingResource();
        trainingResource.setObjectId(material.getId());
        this.saveResourceContent(trainingResource, material);
        this.resourceService.addResource(trainingResource, user);
        materials.add((TrainingMaterial)material);
        if (material.getFileType() != null && material.getFileType() == 7) {
            this.trainingMaterialProductService.saveProductPicture(material, user);
            this.trainingMaterialProductService.saveProductParameter(material, user);
        }
        if (!CollectionUtils.isEmpty((Collection)(attachList = material.getTrainingMaterialAttachList()))) {
            for (TrainingMaterialAttach attachVo : attachList) {
                attachVo.setMaterialId(material.getId());
                attachVo.setEnterpriseId(user.getGroupId());
                attachVo.setCreateTime(now);
                this.trainingMaterialAttachMapper.insert(attachVo);
            }
        }
        if (!CollectionUtils.isEmpty(trainingMaterialLecturerList = this.getMaterialLecturerList(material, user))) {
            materialLecturerList.addAll(trainingMaterialLecturerList);
        }
    }

    private void saveResourceContent(TrainingResource trainingResource, TrainingMaterialVo material) {
        trainingResource.setShowName(material.getMaterialName());
        trainingResource.setFileType(material.getFileType());
        trainingResource.setPath(material.getMaterialPath());
        trainingResource.setTypeId(material.getMaterialTypeId());
        trainingResource.setCoverType(material.getCoverType());
        trainingResource.setCoverUrl(material.getCoverUrl());
        trainingResource.setIsShow(material.getIsShow());
        trainingResource.setReadType(material.getReadType());
        trainingResource.setShareable(material.getShareable());
        trainingResource.setIsVisitorShare(Integer.valueOf(1));
        trainingResource.setIsDownload(material.getIsDownload());
        trainingResource.setDownloadType(material.getDownloadType());
        trainingResource.setVersion(material.getVersion());
        trainingResource.setIsComment(material.getIsComment());
        trainingResource.setIntroduction(material.getIntroduction());
        trainingResource.setReadSingleGroup(material.getReadSingleGroup());
        trainingResource.setDownloadSingleGroup(material.getDownloadSingleGroup());
    }

    private TrainingMaterialVo buildDefaultMaterial(TrainingMaterialVo material) {
        material.setReadType(Integer.valueOf(material.getReadType() == null ? 0 : material.getReadType()));
        material.setDownloadType(Integer.valueOf(material.getDownloadType() == null ? 0 : material.getDownloadType()));
        material.setShareable(Integer.valueOf(material.getShareable() == null ? 1 : material.getShareable()));
        return material;
    }

    private void saveMaterialText(TrainingMaterialVo trainingMaterialVo) {
        if (!StringUtils.isEmpty((Object)trainingMaterialVo.getContent())) {
            TrainingMaterialText trainingMaterialText = new TrainingMaterialText();
            trainingMaterialText.setMaterialId(trainingMaterialVo.getId());
            trainingMaterialText.setContent(trainingMaterialVo.getContent());
            trainingMaterialText.setCreater(trainingMaterialVo.getUpdater());
            trainingMaterialText.setCreateTime(trainingMaterialVo.getUpdateTime());
            trainingMaterialText.setEnterpriseId(trainingMaterialVo.getEnterpriseId());
            this.trainingMaterialTextMapper.insert(trainingMaterialText);
        }
    }

    private List<TrainingMaterialLecturer> getMaterialLecturerList(TrainingMaterialVo material, Users user) {
        ArrayList materialLecturerList = Lists.newArrayList();
        List lecturerVoList = material.getLecturerVoList();
        if (!CollectionUtils.isEmpty((Collection)lecturerVoList)) {
            for (TrainingLecturerVo lecturerVo : lecturerVoList) {
                TrainingMaterialLecturer materialLecturer = new TrainingMaterialLecturer();
                materialLecturer.setType(Integer.valueOf(1));
                materialLecturer.setMaterialId(material.getId());
                materialLecturer.setLecturerId(lecturerVo.getId());
                materialLecturer.setEnterpriseId(user.getGroupId());
                materialLecturer.setCreaterId(user.getId());
                materialLecturer.setCreateTime(new Date());
                materialLecturerList.add(materialLecturer);
            }
        }
        return materialLecturerList;
    }

    @Override
    public String updateCover(List<TrainingMaterial> materialList, Integer userId) {
        if (!CollectionUtils.isEmpty(materialList)) {
            for (TrainingMaterial material : materialList) {
                TrainingMaterial tm = (TrainingMaterial)this.materialMapper.selectById(material.getId());
                tm.setCoverType(material.getCoverType());
                tm.setCoverUrl(material.getCoverUrl());
                tm.setUpdater(userId);
                tm.setUpdateTime(new Date());
                this.materialMapper.updateById(tm);
            }
            ResourcesVo resourcesVo = new ResourcesVo();
            resourcesVo.setObjectIdList(materialList.stream().map(TrainingMaterial::getId).collect(Collectors.toList()));
            ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
            resourceUpdateBo.setType(1);
            resourceUpdateBo.setCoverType(materialList.get(0).getCoverType());
            resourceUpdateBo.setCoverUrl(materialList.get(0).getCoverUrl());
            resourcesVo.setResourceUpdateBo(resourceUpdateBo);
            Users user = new Users();
            user.setId(userId);
            this.resourceService.saveBatchResourceNoPermission(resourcesVo, user);
        }
        return JsonResult.success();
    }

    @Override
    public String updateMaterial(List<TrainingMaterialVo> materials, Users user) {
        Date now = new Date();
        String isNum = "0";
        if (CollectionUtils.isEmpty(materials)) {
            return JsonResult.error();
        }
        ArrayList materialVoList = Lists.newArrayList();
        ArrayList trainingMaterials = Lists.newArrayList();
        ArrayList trainingMaterialIdList = Lists.newArrayList();
        List<Integer> typeIdList = materials.stream().map(TrainingMaterial::getMaterialTypeId).distinct().collect(Collectors.toList());
        Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, typeIdList);
        ArrayList materialLecturerList = Lists.newArrayList();
        List materialIds = materials.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
        List trainingMaterialList = this.materialMapper.selectBatchIds(materialIds);
        Map<Object, Object> materialMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        for (TrainingMaterialVo materialVo : materials) {
            if (validMaterialTypeIdSet.contains(materialVo.getMaterialTypeId())) {
                TrainingMaterial trainingMaterial = (TrainingMaterial)materialMap.get(materialVo.getId());
                if (!(ObjectUtils.isEmpty((Object)trainingMaterial) || StringUtils.isEmpty((Object)trainingMaterial.getMaterialName()) || trainingMaterial.getMaterialName().equals(materialVo.getMaterialName()))) {
                    TrainingMaterial material = new TrainingMaterial();
                    material.setId(trainingMaterial.getId());
                    material.setMaterialName(materialVo.getMaterialName());
                    material.setMaterialPath(materialVo.getMaterialPath());
                    trainingMaterials.add(material);
                }
                this.saveUpdateMaterialContent(trainingMaterial, materialVo, materialLecturerList, materialVoList, user, now, trainingMaterialIdList);
                continue;
            }
            isNum = "1";
        }
        if (!CollectionUtils.isEmpty((Collection)materialVoList)) {
            for (TrainingMaterialVo material : materialVoList) {
                if (material.getMaterialTypeId() == null) continue;
                TrainingMaterialType type = new TrainingMaterialType();
                type.setId(material.getMaterialTypeId());
                type.setUpdateTime(now);
                type.setUpdater(user.getId());
                this.materialTypeMapper.updateById(type);
            }
            List trainingMaterialIds = materialVoList.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.in(TrainingMaterialLecturer::getMaterialId, trainingMaterialIds)).eq(TrainingMaterialLecturer::getType, (Object)1)).eq(!StringUtils.isEmpty((Object)user.getGroupId()), TrainingMaterialLecturer::getEnterpriseId, (Object)user.getGroupId());
            this.materialLecturerMapper.delete((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)materialLecturerList)) {
                this.materialLecturerMapper.insertList(materialLecturerList);
            }
        }
        this.executeThreads(trainingMaterialIdList, trainingMaterials, user);
        if ("1".equals(isNum)) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.update", null, locale), null);
        }
        return JsonResult.success();
    }

    private void executeThreads(final List<Integer> trainingMaterialIdList, final List<TrainingMaterial> trainingMaterials, final Users user) {
        if (!CollectionUtils.isEmpty(trainingMaterialIdList)) {
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        List trainingMaterialLists = TrainingMaterialNewServiceImpl.this.materialMapper.selectBatchIds(trainingMaterialIdList);
                        if (!CollectionUtils.isEmpty((Collection)trainingMaterialLists)) {
                            for (TrainingMaterial material : trainingMaterialLists) {
                                TrainingMaterialNewServiceImpl.this.trainingMaterialService.saveMaterialCompression(material, user);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("\u89c6\u9891\u538b\u7f29:", (Throwable)e);
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(trainingMaterials)) {
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (TrainingMaterial material : trainingMaterials) {
                            TrainingMaterialNewServiceImpl.this.saveTaskNameByMaterialNames(material);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u6240\u6709\u5f15\u7528\u7d20\u6750\u7684\u4efb\u52a1\u540d\u79f0:", (Throwable)e);
                    }
                }
            });
        }
    }

    private void saveUpdateMaterialContent(TrainingMaterial material, TrainingMaterialVo materialVo, List<TrainingMaterialLecturer> materialLecturerList, List<TrainingMaterialVo> materials, Users user, Date now, List<Integer> trainingMaterialIdList) {
        List lecturerVoList;
        if (!(ObjectUtils.isEmpty((Object)material) || StringUtils.isEmpty((Object)material.getMaterialPath()) || StringUtils.isEmpty((Object)materialVo.getMaterialPath()) || material.getMaterialPath().equals(materialVo.getMaterialPath()))) {
            TrainingMaterialVersion materialVersion = new TrainingMaterialVersion();
            BeanUtils.copyProperties((Object)material, (Object)materialVersion);
            materialVersion.setId(null);
            materialVersion.setMaterialId(material.getId());
            materialVersion.setCreateTime(now);
            this.trainingMaterialVersionMapper.insert(materialVersion);
            materialVo.setVersion(Integer.valueOf(material.getVersion() + 1));
            trainingMaterialIdList.add(materialVo.getId());
        }
        if (!StringUtils.isEmpty((Object)materialVo.getMaterialName())) {
            materialVo.setShowName(materialVo.getMaterialName());
        }
        materialVo.setUpdater(user.getId());
        materialVo.setUpdateTime(now);
        materialVo.setEnterpriseId(user.getGroupId());
        this.materialMapper.updateById(materialVo);
        TrainingResource resource = this.resourceService.getResource(materialVo.getId(), materialVo.getFileType());
        TrainingResource trainingResource = new TrainingResource();
        trainingResource.setId(resource.getId());
        this.saveResourceContent(trainingResource, materialVo);
        this.resourceService.updateResource(trainingResource, user);
        materials.add(materialVo);
        LambdaUpdateWrapper attachWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)attachWrapper.eq(TrainingMaterialAttach::getMaterialId, (Object)materialVo.getId())).eq(TrainingMaterialAttach::getType, (Object)1)).set(TrainingMaterialAttach::getIsDel, (Object)1);
        this.trainingMaterialAttachMapper.update(null, (Wrapper)attachWrapper);
        List attachList = materialVo.getTrainingMaterialAttachList();
        if (!CollectionUtils.isEmpty((Collection)attachList)) {
            for (TrainingMaterialAttach atta : attachList) {
                atta.setId(null);
                atta.setMaterialId(materialVo.getId());
                atta.setEnterpriseId(user.getGroupId());
                atta.setCreateTime(now);
                this.trainingMaterialAttachMapper.insert(atta);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(lecturerVoList = materialVo.getLecturerVoList()))) {
            for (TrainingLecturerVo lecturerVo : lecturerVoList) {
                TrainingMaterialLecturer materialLecturer = new TrainingMaterialLecturer();
                materialLecturer.setType(Integer.valueOf(1));
                materialLecturer.setMaterialId(materialVo.getId());
                materialLecturer.setLecturerId(lecturerVo.getId());
                materialLecturer.setEnterpriseId(user.getGroupId());
                materialLecturer.setCreaterId(user.getId());
                materialLecturer.setCreateTime(now);
                materialLecturerList.add(materialLecturer);
            }
        }
        if (materialVo.getFileType() != null && materialVo.getFileType() == 7) {
            this.trainingMaterialProductService.saveProductPicture(materialVo, user);
            this.trainingMaterialProductService.saveProductParameter(materialVo, user);
        }
        if (material.getFileType() != null && material.getFileType() == 6) {
            this.saveUpdateMaterialText(materialVo);
        }
        this.materialSinglePermissionService.updateMaterial(material, materialVo);
    }

    private void saveUpdateMaterialText(TrainingMaterialVo trainingMaterialVo) {
        if (!StringUtils.isEmpty((Object)trainingMaterialVo.getContent())) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper.eq(TrainingMaterialText::getMaterialId, (Object)trainingMaterialVo.getId())).set(TrainingMaterialText::getContent, (Object)trainingMaterialVo.getContent());
            this.trainingMaterialTextMapper.update(null, (Wrapper)wrapper);
        }
    }

    private void saveTaskNameByMaterialNames(TrainingMaterial trainingMaterial) {
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.eq(TrainingChapterAttach::getMaterialId, (Object)trainingMaterial.getId())).set(TrainingChapterAttach::getFileName, (Object)trainingMaterial.getMaterialName())).set(!StringUtils.isEmpty((Object)trainingMaterial.getMaterialPath()), TrainingChapterAttach::getUrl, (Object)trainingMaterial.getMaterialPath());
        this.trainingChapterAttachMapper.update(null, (Wrapper)wrapper1);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingTaskSchedule::getMaterialId, (Object)trainingMaterial.getId());
        List trainingTaskSchedules = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingTaskSchedules)) {
            List taskIds = trainingTaskSchedules.stream().map(TrainingTaskSchedule::getTaskId).distinct().collect(Collectors.toList());
            LambdaUpdateWrapper wrapper5 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper5.in(TrainingProjectTask::getId, taskIds)).set(TrainingProjectTask::getTaskName, (Object)trainingMaterial.getMaterialName());
            this.trainingProjectTaskMapper.update(null, (Wrapper)wrapper5);
            LambdaUpdateWrapper wrapper6 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper6.eq(TrainingTaskSchedule::getMaterialId, (Object)trainingMaterial.getId())).set(TrainingTaskSchedule::getTaskName, (Object)trainingMaterial.getMaterialName());
            this.trainingTaskScheduleMapper.update(null, (Wrapper)wrapper6);
        }
        LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper3.eq(TrainingJobStageTask::getMaterialId, (Object)trainingMaterial.getId())).set(TrainingJobStageTask::getTaskName, (Object)trainingMaterial.getMaterialName());
        this.trainingJobStageTaskMapper.update(null, (Wrapper)wrapper3);
        LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper4.eq(TrainingCourseStageTask::getMaterialId, (Object)trainingMaterial.getId())).set(TrainingCourseStageTask::getTaskName, (Object)trainingMaterial.getMaterialName());
        this.trainingCourseStageTaskMapper.update(null, (Wrapper)wrapper4);
    }

    @Override
    public String updateChangeMaterialVersionV2(TrainingMaterialVo materialVo, Users user) {
        List<Integer> materialTypeIds;
        Set<Integer> validMaterialTypeIdSet;
        TrainingMaterial materialOld = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
        if (!(ObjectUtils.isEmpty((Object)materialOld) || materialOld.getMaterialTypeId() == null || (validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, materialTypeIds = Arrays.asList(materialOld.getMaterialTypeId(), materialVo.getMaterialTypeId()))).contains(materialOld.getMaterialTypeId()) && validMaterialTypeIdSet.contains(materialVo.getMaterialTypeId()))) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.update", null, locale), null);
        }
        Date now = new Date();
        if (!ObjectUtils.isEmpty((Object)materialOld)) {
            ArrayList materialVoList = Lists.newArrayList();
            ArrayList materialLecturerList = Lists.newArrayList();
            ArrayList trainingMaterialIdList = Lists.newArrayList();
            this.saveUpdateMaterialContent(materialOld, materialVo, materialLecturerList, materialVoList, user, now, trainingMaterialIdList);
            if (!CollectionUtils.isEmpty((Collection)materialVoList)) {
                for (TrainingMaterialVo material : materialVoList) {
                    if (material.getMaterialTypeId() == null) continue;
                    TrainingMaterialType type = new TrainingMaterialType();
                    type.setId(material.getMaterialTypeId());
                    type.setUpdateTime(now);
                    type.setUpdater(user.getId());
                    this.materialTypeMapper.updateById(type);
                }
                List trainingMaterialIds = materialVoList.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.in(TrainingMaterialLecturer::getMaterialId, trainingMaterialIds)).eq(TrainingMaterialLecturer::getType, (Object)1)).eq(!StringUtils.isEmpty((Object)user.getGroupId()), TrainingMaterialLecturer::getEnterpriseId, (Object)user.getGroupId());
                this.materialLecturerMapper.delete((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)materialLecturerList)) {
                    this.materialLecturerMapper.insertList(materialLecturerList);
                }
            }
        }
        return JsonResult.success();
    }

    @Override
    public List<Integer> getUserIdListByMaterial(Integer materialId, Users user) {
        List<UnitDO> unitDOList;
        List<Object> userIdList = Lists.newArrayList();
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(materialId);
        if (!ObjectUtils.isEmpty((Object)trainingMaterial) && !CollectionUtils.isEmpty(unitDOList = this.materialSinglePermissionService.getUnitListByMaterialAndPermissionType(trainingMaterial.getId(), 1))) {
            List<String> userIds = unitDOList.stream().filter(e -> e.getBizType() == 1).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> roleIdList = unitDOList.stream().filter(e -> e.getBizType() == 3).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> tagIdList = unitDOList.stream().filter(e -> e.getBizType() == 2).map(UnitDO::getBizId).collect(Collectors.toList());
            List<String> organizeIdList = unitDOList.stream().filter(e -> e.getBizType() == 4).map(UnitDO::getBizId).collect(Collectors.toList());
            userIdList = this.userUtilService.getAllUserId(userIds, roleIdList, tagIdList, organizeIdList, user.getGroupId(), user.getId());
        }
        return userIdList;
    }

    @Override
    public String getLecturerNames(Integer trainingId) {
        List lecturerIds;
        List trainingLecturerList;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingMaterialLecturer::getMaterialId, (Object)trainingId)).eq(TrainingMaterialLecturer::getType, (Object)2)).orderByAsc(TrainingMaterialLecturer::getId);
        List trainingMaterialLecturerList = this.materialLecturerMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialLecturerList) && !CollectionUtils.isEmpty((Collection)(trainingLecturerList = this.trainingLecturerMapper.selectBatchIds(lecturerIds = trainingMaterialLecturerList.stream().map(TrainingMaterialLecturer::getLecturerId).distinct().collect(Collectors.toList()))))) {
            List lecturerNames = trainingLecturerList.stream().map(TrainingLecturer::getLecturerName).collect(Collectors.toList());
            return String.join((CharSequence)",", lecturerNames);
        }
        return null;
    }

    @Override
    public String getStudyInfo(Integer groupId, Integer userId, Integer materialId, Date startTime, Date endTime) {
        MaterialStudyInfo info = new MaterialStudyInfo();
        LocalDateTime latestSevenDaysBegin = LocalDate.now().atStartOfDay().minusDays(6L);
        List trainingUserViewTimeMaterials = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getMaterialId, (Object)materialId)).eq(TrainingUserViewTime::getEnterpriseId, (Object)groupId)).select(new SFunction[]{TrainingUserViewTime::getUserId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getCreateTime, TrainingUserViewTimeMaterial::getUpdateTime, TrainingUserViewTimeMaterial::getFinishTime}));
        int userNum = (int)trainingUserViewTimeMaterials.stream().filter(x -> DateUtils.dateToLocalDateTime(x.getUpdateTime()).isBefore(LocalDateTime.now()) && DateUtils.dateToLocalDateTime(x.getUpdateTime()).isAfter(latestSevenDaysBegin)).filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
        info.setWeekStudyNum(userNum);
        int totalUserNum = (int)trainingUserViewTimeMaterials.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
        info.setTotalStudyNum(totalUserNum);
        int finishUserNum = (int)trainingUserViewTimeMaterials.stream().filter(x -> null != x.getFinishTime()).filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
        info.setFinishStudyNum(finishUserNum);
        return JsonResult.success((Object)info);
    }

    @Override
    public String getCompleteStudyUseTimeOverview(Integer groupId, Integer userId, Integer materialId) {
        LinkedHashMap<String, Integer> overviewMap = this.createInitMap();
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(materialId);
        if (trainingMaterial == null) {
            return JsonResult.success(overviewMap);
        }
        List trainingUserViewTimeMaterials = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getMaterialId, (Object)materialId)).eq(TrainingUserViewTime::getEnterpriseId, (Object)groupId)).isNotNull(TrainingUserViewTimeMaterial::getFinishTime)).select(new SFunction[]{TrainingUserViewTime::getUserId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getCreateTime, TrainingUserViewTimeMaterial::getUpdateTime, TrainingUserViewTimeMaterial::getFinishTime}));
        if (null == trainingUserViewTimeMaterials || trainingUserViewTimeMaterials.isEmpty()) {
            return JsonResult.success(overviewMap);
        }
        Map<Integer, List<TrainingUserViewTimeMaterial>> userIdAndMaterialListMap = trainingUserViewTimeMaterials.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
        for (Map.Entry<Integer, List<TrainingUserViewTimeMaterial>> map : userIdAndMaterialListMap.entrySet()) {
            Integer alreadyNum;
            Date minCreateTime = map.getValue().stream().min(Comparator.comparing(TrainingUserViewTime::getCreateTime)).get().getCreateTime();
            Optional<TrainingUserViewTimeMaterial> maxCreateTimePresent = map.getValue().stream().filter(x -> !Objects.isNull(x.getFinishTime())).max(Comparator.comparing(TrainingUserViewTimeMaterial::getFinishTime));
            if (!maxCreateTimePresent.isPresent()) continue;
            Date maxCreateTime = maxCreateTimePresent.get().getFinishTime();
            BigDecimal days = DateUtils.countExactDays(minCreateTime, maxCreateTime);
            if (days.compareTo(new BigDecimal(1)) <= 0) {
                alreadyNum = overviewMap.get("1\u5929\u5185");
                overviewMap.put("1\u5929\u5185", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(7)) <= 0) {
                alreadyNum = overviewMap.get("2-7\u5929");
                overviewMap.put("2-7\u5929", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(30)) <= 0) {
                alreadyNum = overviewMap.get("8-30\u5929");
                overviewMap.put("8-30\u5929", alreadyNum + 1);
                continue;
            }
            if (days.compareTo(new BigDecimal(90)) <= 0) {
                alreadyNum = overviewMap.get("31-90\u5929");
                overviewMap.put("31-90\u5929", alreadyNum + 1);
                continue;
            }
            alreadyNum = overviewMap.get("90\u5929\u4ee5\u4e0a");
            overviewMap.put("90\u5929\u4ee5\u4e0a", alreadyNum + 1);
        }
        return JsonResult.success(overviewMap);
    }

    @Override
    public String getDeptStudyOverview(DeptStudyMaterialOverviewReq req, Users user) {
        DeptFinishLessonOverviewResponse response = new DeptFinishLessonOverviewResponse();
        List roleUserId = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)req.getOrganizeIdList())) {
            List organizeIds = req.getOrganizeIdList().stream().map(x -> Integer.valueOf(x.substring(2, x.length()))).collect(Collectors.toList());
            UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
            usersOrgIdsAndTagsPojo.setGroupId(user.getGroupId());
            usersOrgIdsAndTagsPojo.setOrganizeId(organizeIds);
            usersOrgIdsAndTagsPojo.setDepartmentIds(null);
            BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(usersOrgIdsAndTagsPojo);
            roleUserId = (List)baseResult.getData();
            if (CollectionUtils.isEmpty(roleUserId)) {
                return JsonResult.success((Object)response);
            }
        } else {
            return JsonResult.success((Object)response);
        }
        List trainingUserViewTimeMaterials = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrainingUserViewTime::getMaterialId, (Object)req.getMaterialId())).eq(TrainingUserViewTime::getEnterpriseId, (Object)user.getGroupId())).in(TrainingUserViewTime::getUserId, roleUserId)).select(new SFunction[]{TrainingUserViewTime::getUserId, TrainingUserViewTime::getViewTime, TrainingUserViewTime::getCreateTime, TrainingUserViewTimeMaterial::getUpdateTime, TrainingUserViewTimeMaterial::getFinishTime}));
        if (null == trainingUserViewTimeMaterials || trainingUserViewTimeMaterials.isEmpty()) {
            return JsonResult.success((Object)response);
        }
        int userNum = (int)trainingUserViewTimeMaterials.stream().filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
        response.setStudyUserNum(Integer.valueOf(userNum));
        int finishUserNum = (int)trainingUserViewTimeMaterials.stream().filter(x -> null != x.getFinishTime()).filter(DistinctUtils.distinctByKey(TrainingUserViewTime::getUserId)).count();
        response.setFinishStudyUserNum(Integer.valueOf(finishUserNum));
        return JsonResult.success((Object)response);
    }

    private LinkedHashMap<String, Integer> createInitMap() {
        LinkedHashMap<String, Integer> overViewMap = new LinkedHashMap<String, Integer>();
        overViewMap.put("1\u5929\u5185", 0);
        overViewMap.put("2-7\u5929", 0);
        overViewMap.put("8-30\u5929", 0);
        overViewMap.put("31-90\u5929", 0);
        overViewMap.put("90\u5929\u4ee5\u4e0a", 0);
        return overViewMap;
    }
}

