/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ovopark.api.CheckItemMaterialApi;
import com.ovopark.check.Vo.MeterialDbviewVO;
import com.ovopark.check.Vo.MeterialPojo;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersOrgIdsAndTagsPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.constants.ExportConst;
import com.ovopark.training.constants.PermissionConst;
import com.ovopark.training.delegate.DelegateHelper;
import com.ovopark.training.delegate.ExportDelegate;
import com.ovopark.training.domain.MaterialPermissionDO;
import com.ovopark.training.dto.AIResponse;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.event.EventHelper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingFeeMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLecturerLevelMapper;
import com.ovopark.training.mapper.TrainingLecturerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialAttachMapper;
import com.ovopark.training.mapper.TrainingMaterialCommentMapper;
import com.ovopark.training.mapper.TrainingMaterialDownloadsMapper;
import com.ovopark.training.mapper.TrainingMaterialLecturerMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialParameterMapper;
import com.ovopark.training.mapper.TrainingMaterialPowerMapper;
import com.ovopark.training.mapper.TrainingMaterialPowerUserMapper;
import com.ovopark.training.mapper.TrainingMaterialProductPictureMapper;
import com.ovopark.training.mapper.TrainingMaterialTextMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingMaterialVersionMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserLookMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCourseMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeJobMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeLearnMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.mapper.permission.MaterialPermissionMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAndMaterial;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingFee;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingLecturerLevel;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialAttach;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.TrainingMaterialDownloads;
import com.ovopark.training.model.TrainingMaterialLecturer;
import com.ovopark.training.model.TrainingMaterialParameter;
import com.ovopark.training.model.TrainingMaterialPower;
import com.ovopark.training.model.TrainingMaterialPowerUser;
import com.ovopark.training.model.TrainingMaterialProductPicture;
import com.ovopark.training.model.TrainingMaterialText;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingMaterialVersion;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserLook;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.ResourceUpdateBo;
import com.ovopark.training.model.view.ResourcesVo;
import com.ovopark.training.param.material.MaterialBatchUpdateFinishRateParam;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.param.material.MaterialBatchUpdateShareableParam;
import com.ovopark.training.param.material.MaterialBatchUpdateTypeParam;
import com.ovopark.training.param.material.MaterialCopyUpdateParam;
import com.ovopark.training.param.material.MaterialQueryParam;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.DcStorageUrlUtils;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.util.ImmUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.util.VideoCompressionsUtil;
import com.ovopark.training.vo.MaterialStudyVo;
import com.ovopark.training.vo.OpenUserViewTime;
import com.ovopark.training.vo.SelectTrainingAttachVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import com.ovopark.training.vo.TrainingMaterialCommentVo;
import com.ovopark.training.vo.TrainingMaterialDownloadsVo;
import com.ovopark.training.vo.TrainingMaterialPowerVo;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import com.ovopark.training.vo.TrainingMaterialVersionVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@RefreshScope
@Service
public class TrainingMaterialServiceImpl
implements TrainingMaterialService {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialServiceImpl.class);
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMaterialTypeMapper materialTypeMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private TrainingMaterialPowerMapper materialPowerMapper;
    @Autowired
    private TrainingMaterialCommentMapper materialCommentMapper;
    @Autowired
    private TrainingMaterialVersionMapper trainingMaterialVersionMapper;
    @Autowired
    private TrainingMaterialDownloadsMapper trainingMaterialDownloadsMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private TrainingMaterialPowerUserMapper materialPowerUserMapper;
    @Autowired
    private TrainingMaterialLecturerMapper materialLecturerMapper;
    @Autowired
    private TrainingUserViewTimeMapper userViewTimeMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private CheckItemMaterialApi checkApi;
    @Autowired
    private TrainingLecturerMapper lecturerMapper;
    @Autowired
    private TrainingLecturerLevelMapper trainingLecturerLevelMapper;
    @Autowired
    private TrainingJobStageTaskMapper jobStageTaskMapper;
    @Autowired
    private TrainingUserLookMapper userLookMapper;
    @Autowired
    private TrainingChapterAttachMapper chapterAttachMapper;
    @Autowired
    private TrainingAttachMapper attachMapper;
    @Autowired
    private TrainingVideoMapper videoMapper;
    @Autowired
    private TrainingTaskScheduleMapper taskScheduleMapper;
    @Autowired
    private TrainingProjectTaskMapper projectTaskMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private TrainingCourseStageTaskMapper courseStageTaskMapper;
    @Autowired
    private TrainingAttachMapper trainingAttachMapper;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingFeeMapper trainingFeeMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingMaterialLecturerMapper trainingMaterialLecturerMapper;
    @Autowired
    private TrainingMaterialProductPictureMapper materialProductPictureMapper;
    @Value(value="${training.video.videoCompressionUrl}")
    private String videoCompressionUrl;
    @Value(value="${training.video.token}")
    private String token;
    @Value(value="${training.video.callbackUrl}")
    private String callbackUrl;
    @Value(value="${training.video.readPath}")
    private String readPath;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingUserViewTimeLearnMapper trainingUserViewTimeLearnMapper;
    @Autowired
    private TrainingUserViewTimeJobMapper trainingUserViewTimeJobMapper;
    @Autowired
    private TrainingUserViewTimeCourseMapper trainingUserViewTimeCourseMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LogApi logApi;
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Autowired
    private TrainingQuestionTypeMapper trainingQuestionTypeMapper;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Autowired
    private TrainingMaterialDownloadsMapper TrainingMaterialDownloadsMapper;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;
    @Autowired
    private TrainingMaterialAttachMapper trainingMaterialAttachMapper;
    @Autowired
    private TrainingMaterialTextMapper trainingMaterialTextMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private TrainingMaterialParameterMapper trainingMaterialParameterMapper;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private TrainingResourceMapper trainingResourceMapper;
    @Autowired
    private MaterialPermissionMapper materialPermissionMapper;
    @Autowired
    private RoleApi roleApi;
    @Value(value="${training.ai.url}")
    private String trainingAiUrl;
    @Resource(name="oldCommon")
    private Executor exportExecutor;
    @Value(value="${training.stat.show-un-study-enterprise-id:0}")
    private Set<Integer> showUnStudyEnterpriseIdSet;

    @Override
    public void handleOldQuestion(List<Integer> enterpriseIds, Users user) {
        if (CollectionUtils.isEmpty(enterpriseIds)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.select(new SFunction[]{TrainingQuestionType::getEnterpeiseId});
            wrapper.isNotNull(TrainingQuestionType::getEnterpeiseId);
            enterpriseIds = this.trainingQuestionTypeMapper.selectList((Wrapper)wrapper).stream().map(TrainingQuestionType::getEnterpeiseId).distinct().collect(Collectors.toList());
        }
        for (Integer enterpriseId : enterpriseIds) {
            TrainingMaterialType trainingMaterialType = new TrainingMaterialType();
            trainingMaterialType.setMaterialTypeName("\u9ed8\u8ba4\u5206\u7c7b");
            trainingMaterialType.setMaterialTypeLevel(Integer.valueOf(1));
            trainingMaterialType.setEnterpriseId(enterpriseId);
            trainingMaterialType.setCreater(user.getId());
            trainingMaterialType.setCreateTime(new Date());
            trainingMaterialType.setSort(Integer.valueOf(1));
            trainingMaterialType.setModuleType(Integer.valueOf(7));
            this.trainingMaterialTypeMapper.insert(trainingMaterialType);
            this.trainingQuestionTypeMapper.updateMaterialType(trainingMaterialType.getId(), enterpriseId, user.getId(), DateUtils.format(new Date(), "yyyy-MM-dd"));
        }
    }

    @Override
    public Page<TrainingMaterialVo> getMaterialByPage(Page<TrainingMaterialVo> page, Users user, List<Integer> materialId, Integer materialTypeId, String materialName, List<Integer> creaters, String startTime, String endTime, Integer isUsing, Integer isCommodity, Integer isChild, Integer fileType, Integer isShow) {
        List<Integer> materialTypeIds;
        Map<String, Object> userMap;
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialName) && (userMap = this.userUtilService.getCheckParameters(materialName, null, null, user)).get("isEffect").toString().equals("1")) {
            List userList = (List)userMap.get("userList");
            creaters.addAll(userList);
            creaters = creaters.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(materialTypeIds = this.getHasPermissionTypeIdList(materialTypeId, user, isChild))) {
            return page;
        }
        List<TrainingMaterialVo> list = this.materialMapper.selectMaterialByPage(page, user.getGroupId(), materialId, materialTypeIds, materialName, creaters, startTime, endTime, null, null, isUsing, fileType, isShow);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> trainingMaterialTypeIds = list.stream().map(TrainingMaterial::getMaterialTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Set<Integer> hasManageMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, trainingMaterialTypeIds);
            Set<Integer> hasDownloadMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 4, trainingMaterialTypeIds);
            List<Integer> createrList = list.stream().map(TrainingMaterial::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(createrList);
            List<Integer> materialIdList = list.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            List<TrainingMaterialVo> usingTrainList = this.materialMapper.selectUsingMaterialCount(materialIdList, user.getGroupId());
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty(usingTrainList)) {
                materialMap = usingTrainList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
            Map<Object, Object> dbviewMap = new HashMap();
            try {
                MeterialPojo meterialPojo = new MeterialPojo();
                meterialPojo.setIds(materialIdList);
                meterialPojo.setType(Integer.valueOf(2));
                com.ovopark.pojo.BaseResult dbshopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
                if (dbshopViewBase != null && !CollectionUtils.isEmpty((Collection)((Collection)dbshopViewBase.getData()))) {
                    dbviewMap = ((List)dbshopViewBase.getData()).stream().collect(Collectors.groupingBy(MeterialDbviewVO::getMaterialId));
                }
            }
            catch (Exception e) {
                log.error("\u7d20\u6750\u8c03\u5de1\u5e97\u5f02\u5e38", (Throwable)e);
            }
            Map<Integer, String> materialTypeMap = this.selectMaterialTypeMap(1, user);
            for (TrainingMaterialVo view : list) {
                UsersPojo pojo = pojoMap.get(view.getCreater());
                if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                    view.setCreateName(pojo.getShowName());
                }
                if (view.getMaterialTypeId() != null && hasManageMaterialTypeIdSet.contains(view.getMaterialTypeId())) {
                    view.setIsPower(Integer.valueOf(1));
                }
                if (view.getMaterialTypeId() != null && hasDownloadMaterialTypeIdSet.contains(view.getMaterialTypeId())) {
                    view.setIsDownload(Integer.valueOf(1));
                }
                int isUsingList = 0;
                TrainingMaterialVo materialCount = (TrainingMaterialVo)materialMap.get(view.getId());
                if (!ObjectUtils.isEmpty((Object)materialCount) && materialCount.getRowNum() != null && materialCount.getRowNum().compareTo(0) > 0) {
                    isUsingList = 1;
                } else {
                    List dbviewList = (List)dbviewMap.get(view.getId());
                    if (!CollectionUtils.isEmpty((Collection)dbviewList)) {
                        isUsingList = 1;
                    }
                }
                view.setIsUsingList(Integer.valueOf(isUsingList));
                view.setIsNew(DateUtils.getDifferenceTime(view.getCreateTime()));
                view.setMaterialTypePathName(materialTypeMap.get(view.getMaterialTypeId()));
            }
            page.setContent(list);
        }
        return page;
    }

    @Override
    public String getMaterialByPageV2(MaterialQueryParam param, Users user) {
        log.info("getMaterialByPageV2 param:{}", (Object)param);
        String materialName = param.getMaterialName();
        Integer materialTypeId = param.getMaterialTypeId();
        Integer isChild = param.getIsChild();
        List<Object> creaters = Lists.newArrayList();
        Page page = new Page();
        page.setPageSize(param.getPageSize().intValue());
        page.setPageNumber(param.getPageNumber().intValue());
        Integer fileType = param.getFileType();
        Integer isShow = param.getIsShow();
        Integer isUsing = param.getIsUsing();
        Date startTime = param.getStartTime();
        Date endTime = param.getEndTime();
        Date startTimeUp = param.getStartTimeUp();
        Date endTimeUp = param.getEndTimeUp();
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialName)) {
            List<Integer> userList = this.userUtilService.getFuzzyUserList(materialName, user);
            creaters.addAll(userList);
            creaters = creaters.stream().distinct().collect(Collectors.toList());
        }
        int moduleType2 = 1;
        boolean coverChild = isChild == null || isChild == 1;
        List<Integer> materialTypeIds = this.materialTypeService.getMaterialTypeByPermissionAndTypeIdList(user, param.getPermissionType(), moduleType2, materialTypeId, coverChild);
        if (CollectionUtils.isEmpty(materialTypeIds)) {
            return JsonResult.success((Object)page);
        }
        List<TrainingMaterialVo> list = this.materialMapper.selectMaterialV2ByPage((Page<TrainingMaterialVo>)page, user.getGroupId(), null, materialTypeIds, materialName, creaters, DateUtils.getBeginOfDay(startTime), DateUtils.getEndOfDay(endTime), DateUtils.getBeginOfDay(startTimeUp), DateUtils.getEndOfDay(endTimeUp), isUsing, fileType, isShow, param.getOrderByColumn(), param.getOrderType());
        if (CollectionUtils.isEmpty(list)) {
            return JsonResult.success((Object)page);
        }
        HashSet createrSet = Sets.newHashSet();
        ArrayList materialIdList = Lists.newArrayList();
        HashSet materialTypeIdSet = Sets.newHashSet();
        for (TrainingMaterialVo view : list) {
            Integer creater = view.getCreater();
            if (creater != null) {
                createrSet.add(creater);
            }
            materialIdList.add(view.getId());
            materialTypeIdSet.add(view.getMaterialTypeId());
        }
        Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(Lists.newArrayList((Iterable)createrSet));
        List<TrainingMaterialVo> usingTrainList = this.materialMapper.selectUsingMaterialCount(materialIdList, user.getGroupId());
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(usingTrainList)) {
            materialMap = usingTrainList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        Map<Object, Object> dbviewMap = new HashMap();
        try {
            MeterialPojo meterialPojo = new MeterialPojo();
            meterialPojo.setIds((List)materialIdList);
            meterialPojo.setType(Integer.valueOf(2));
            com.ovopark.pojo.BaseResult dbshopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
            if (dbshopViewBase != null && !CollectionUtils.isEmpty((Collection)((Collection)dbshopViewBase.getData()))) {
                dbviewMap = ((List)dbshopViewBase.getData()).stream().collect(Collectors.groupingBy(MeterialDbviewVO::getMaterialId));
            }
        }
        catch (Exception e) {
            log.error("\u7d20\u6750\u8c03\u5de1\u5e97\u5f02\u5e38", (Throwable)e);
        }
        Map<Integer, String> materialTypeMap = this.materialTypeService.getWholePathMap(materialTypeIdSet, null);
        for (TrainingMaterialVo view : list) {
            UsersPojo pojo = pojoMap.get(view.getCreater());
            if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                view.setCreateName(pojo.getShowName());
            }
            view.setIsPower(Integer.valueOf(1));
            int isUsingList = 0;
            TrainingMaterialVo materialCount = (TrainingMaterialVo)materialMap.get(view.getId());
            if (!ObjectUtils.isEmpty((Object)materialCount) && materialCount.getRowNum() != null && materialCount.getRowNum().compareTo(0) > 0) {
                isUsingList = 1;
            } else {
                List dbviewList = (List)dbviewMap.get(view.getId());
                if (!CollectionUtils.isEmpty((Collection)dbviewList)) {
                    isUsingList = 1;
                }
            }
            view.setIsUsingList(Integer.valueOf(isUsingList));
            view.setIsNew(DateUtils.getDifferenceTime(view.getCreateTime()));
            view.setMaterialTypePathName(materialTypeMap.get(view.getMaterialTypeId()));
            view.setCoverUrl(DcStorageUrlUtils.urlConvert(view.getCoverUrl()));
            view.setMaterialPath(DcStorageUrlUtils.urlConvert(view.getMaterialPath()));
        }
        page.setContent(list);
        return JsonResult.success((Object)page);
    }

    private List<Integer> getHasPermissionTypeIdList(Integer materialTypeId, Users user, Integer isChild) {
        boolean coverChild = isChild == null || isChild == 1;
        int permission = 1;
        int moduleType2 = 1;
        return this.materialTypeService.getMaterialTypeByPermissionAndTypeIdList(user, permission, moduleType2, materialTypeId, coverChild);
    }

    @Override
    public Map<Integer, String> selectMaterialTypeMap(Integer moduleType2, Users user) {
        HashMap<Integer, String> typeNameMap = new HashMap<Integer, String>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId())).eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).orderByAsc(TrainingMaterialType::getMaterialTypeLevel);
        List typeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)typeList)) {
            Map<Integer, List<TrainingMaterialType>> levelTypeMap = typeList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getMaterialTypeLevel));
            for (int i = 1; i < 6; ++i) {
                List<TrainingMaterialType> levelList = levelTypeMap.get(i);
                if (CollectionUtils.isEmpty(levelList)) continue;
                for (TrainingMaterialType type : levelList) {
                    String sourceName = org.springframework.util.StringUtils.isEmpty((Object)type.getSourceId()) || org.springframework.util.StringUtils.isEmpty(typeNameMap.get(type.getSourceId())) ? "" : (String)typeNameMap.get(type.getSourceId());
                    typeNameMap.put(type.getId(), sourceName + (org.springframework.util.StringUtils.isEmpty((Object)sourceName) ? "" : "/") + type.getMaterialTypeName());
                }
            }
        }
        return typeNameMap;
    }

    @Override
    public String insertMaterial(List<TrainingMaterialVo> materialList, final Users user) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Date now = new Date();
        String errorStr = "";
        final ArrayList<TrainingMaterial> materials = new ArrayList<TrainingMaterial>();
        int isPush = 0;
        try {
            String isNum = "0";
            if (!CollectionUtils.isEmpty(materialList)) {
                isPush = org.springframework.util.StringUtils.isEmpty((Object)materialList.get(0).getIsPush()) ? 0 : materialList.get(0).getIsPush();
                List lecturerVoList = materialList.get(0).getLecturerVoList();
                List<Integer> typeIdList = materialList.stream().map(TrainingMaterial::getMaterialTypeId).collect(Collectors.toList());
                Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, typeIdList);
                for (TrainingMaterial trainingMaterial : materialList) {
                    if (validMaterialTypeIdSet.contains(trainingMaterial.getMaterialTypeId())) {
                        errorStr = trainingMaterial.getMaterialName();
                        trainingMaterial.setMaterialStatus(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)trainingMaterial.getMaterialStatus()) ? 1 : trainingMaterial.getMaterialStatus()));
                        trainingMaterial.setIsUsing(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)trainingMaterial.getIsUsing()) ? 1 : trainingMaterial.getIsUsing()));
                        trainingMaterial.setDuration(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)trainingMaterial.getDuration()) ? 0 : trainingMaterial.getDuration()));
                        trainingMaterial.setEnterpriseId(user.getGroupId());
                        trainingMaterial.setCreater(user.getId());
                        trainingMaterial.setCreateTime(now);
                        trainingMaterial.setUpdater(user.getId());
                        trainingMaterial.setUpdateTime(now);
                        trainingMaterial.setOldPath(trainingMaterial.getMaterialPath());
                        trainingMaterial.setVersion(Integer.valueOf(1));
                        TrainingMaterial trainingMaterial2 = this.buildDefaultMaterial(trainingMaterial);
                        materials.add(trainingMaterial2);
                        continue;
                    }
                    isNum = "1";
                }
                if (!CollectionUtils.isEmpty(materials)) {
                    this.materialMapper.insertList(materials);
                    for (TrainingMaterial trainingMaterial : materials) {
                        this.materialSinglePermissionService.insertMaterial((TrainingMaterialVo)trainingMaterial);
                    }
                    if (!CollectionUtils.isEmpty((Collection)lecturerVoList)) {
                        ArrayList<TrainingMaterialLecturer> materialLecturerList = new ArrayList<TrainingMaterialLecturer>();
                        for (TrainingMaterial material : materials) {
                            for (TrainingLecturerVo lecturerVo : lecturerVoList) {
                                TrainingMaterialLecturer materialLecturer = new TrainingMaterialLecturer();
                                materialLecturer.setType(Integer.valueOf(1));
                                materialLecturer.setMaterialId(material.getId());
                                materialLecturer.setLecturerId(lecturerVo.getId());
                                materialLecturer.setEnterpriseId(user.getGroupId());
                                materialLecturer.setCreaterId(user.getId());
                                materialLecturer.setCreateTime(now);
                                materialLecturerList.add(materialLecturer);
                            }
                        }
                        this.materialLecturerMapper.insertList(materialLecturerList);
                    }
                    if (((TrainingMaterial)materials.get(0)).getMaterialTypeId() != null) {
                        TrainingMaterialType type = new TrainingMaterialType();
                        type.setId(((TrainingMaterial)materials.get(0)).getMaterialTypeId());
                        type.setUpdateTime(now);
                        type.setUpdater(user.getId());
                        this.materialTypeMapper.updateById(type);
                    }
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (TrainingMaterial material : materials) {
                                    TrainingMaterialServiceImpl.this.saveMaterialCompression(material, user);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u89c6\u9891\u538b\u7f29:", (Throwable)e);
                            }
                        }
                    });
                }
            }
            if ("1".equals(isNum)) {
                return JsonResult.error((String)this.messageSource.getMessage("training.material.power.data", null, locale), null);
            }
            if (!CollectionUtils.isEmpty(materials) && isPush == 1) {
                CommonUtil.handleTask(new Runnable(){

                    @Override
                    public void run() {
                        Integer materialTypeId = ((TrainingMaterial)materials.get(0)).getMaterialTypeId();
                        List<Integer> pushUserList = TrainingMaterialServiceImpl.this.getMaterialTypePowerOwner(materialTypeId, user);
                        if (!CollectionUtils.isEmpty(pushUserList)) {
                            try {
                                List unique = materials.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TrainingMaterial>(Comparator.comparing(TrainingMaterial::getId))), ArrayList::new));
                                String materialTitle = TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.title", null, locale);
                                for (TrainingMaterial material : unique) {
                                    TrainingMaterialVo materialvo = new TrainingMaterialVo();
                                    BeanUtils.copyProperties((Object)material, (Object)materialvo);
                                    materialvo.setTitle(materialTitle);
                                    String text = TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.new", new Object[]{materialvo.getMaterialName()}, locale);
                                    TaskMessageBody body = new TaskMessageBody();
                                    body.setType(85);
                                    body.setTaskJson(JSONObject.toJSONString((Object)materialvo));
                                    TrainingMaterialServiceImpl.this.jPushService.sendWebSocketAll(materialTitle, text, pushUserList, user.getGroupId(), materialvo.getId(), "TYPE_MATERIAL_SYSTEM", JSONObject.toJSONString((Object)materialvo), null, 0, 0, "training.material.new", materialvo.getMaterialName());
                                    TrainingMaterialServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_MATERIAL_SYSTEM", pushUserList, materialTitle, text, body);
                                    log.info("--\u63a8\u9001\u4eba--" + pushUserList);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u7d20\u6750\u63a8\u9001:", (Throwable)e);
                            }
                        }
                    }
                });
            }
            return JsonResult.success(materials);
        }
        catch (Exception e) {
            log.error("\u7d20\u6750\u5bfc\u5165:" + errorStr, (Throwable)e);
            return JsonResult.error((String)errorStr, (Object)e.getMessage());
        }
    }

    private TrainingMaterial buildDefaultMaterial(TrainingMaterial material) {
        material.setReadType(Integer.valueOf(material.getReadType() == null ? 1 : material.getReadType()));
        material.setDownloadType(Integer.valueOf(material.getDownloadType() == null ? 1 : material.getDownloadType()));
        material.setShareable(Integer.valueOf(material.getShareable() == null ? 1 : material.getShareable()));
        return material;
    }

    @Override
    public List<Integer> getMaterialTypePowerOwner(Integer materialTypeId, Users user) {
        return this.materialTypePermissionService.getMaterialTypePowerOwner(materialTypeId, user);
    }

    @Override
    public String updateMaterialConfig(List<TrainingMaterialVo> trainingMaterialVoList, Users user) {
        Date now = new Date();
        ArrayList objectIdList = Lists.newArrayList();
        for (TrainingMaterial trainingMaterial : trainingMaterialVoList) {
            trainingMaterial.setUpdater(user.getId());
            trainingMaterial.setUpdateTime(now);
            this.materialMapper.updateById(trainingMaterial);
            objectIdList.add(trainingMaterial.getId());
        }
        ResourcesVo resourcesVo = new ResourcesVo();
        resourcesVo.setObjectIdList(objectIdList);
        ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
        resourceUpdateBo.setType(1);
        resourceUpdateBo.setIsShow(trainingMaterialVoList.get(0).getIsShow());
        resourceUpdateBo.setIsUsing(trainingMaterialVoList.get(0).getIsUsing());
        resourcesVo.setResourceUpdateBo(resourceUpdateBo);
        this.resourceService.saveBatchResourceNoPermission(resourcesVo, user);
        return JsonResult.success();
    }

    @Override
    public void updateMaterialSize(TrainingMaterial material) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TrainingMaterial::getId, (Object)material.getId())).set(TrainingMaterial::getSize, (Object)material.getSize())).set(TrainingMaterial::getMaterialPath, (Object)material.getMaterialPath())).set(TrainingMaterial::getIsUsing, (Object)material.getIsUsing())).set(TrainingMaterial::getUpdateTime, (Object)new Date());
        this.materialMapper.update(null, (Wrapper)wrapper);
        ResourcesVo resourcesVo = new ResourcesVo();
        resourcesVo.setObjectIdList(Collections.singletonList(material.getId()));
        ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
        resourceUpdateBo.setType(1);
        resourceUpdateBo.setPath(material.getMaterialPath());
        resourceUpdateBo.setIsUsing(material.getIsUsing());
        resourcesVo.setResourceUpdateBo(resourceUpdateBo);
        this.resourceService.saveBatchResourceNoPermission(resourcesVo, null);
    }

    @Override
    public String delMaterial(List<TrainingMaterial> materialList, Users user, HttpServletRequest req) {
        String isNum = "0";
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (materialList != null) {
            List materialIds = materialList.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            materialList = this.materialMapper.selectBatchIds(materialIds);
            List<Integer> typeIdList = materialList.stream().map(TrainingMaterial::getMaterialTypeId).collect(Collectors.toList());
            Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, typeIdList);
            ArrayList<Integer> materialIdList = new ArrayList<Integer>();
            for (Object material : materialList) {
                if (validMaterialTypeIdSet.contains(material.getMaterialTypeId())) {
                    materialIdList.add(material.getId());
                    continue;
                }
                isNum = "1";
            }
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List mList = this.materialMapper.selectBatchIds(materialIdList);
                for (TrainingMaterial material : mList) {
                    if (user.getGroupId() == null || material.getEnterpriseId().equals(user.getGroupId())) continue;
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.delete", null, locale), null);
                }
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.in(TrainingMaterial::getId, materialIdList)).set(TrainingMaterial::getIsDel, (Object)1)).set(TrainingMaterial::getUpdater, (Object)user.getId())).set(TrainingMaterial::getUpdateTime, (Object)new Date());
                this.materialMapper.update(null, (Wrapper)wrapper1);
                ResourcesVo resourcesVo = new ResourcesVo();
                resourcesVo.setObjectIdList(materialIdList);
                ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
                resourceUpdateBo.setType(1);
                resourceUpdateBo.setIsDel(1);
                resourcesVo.setResourceUpdateBo(resourceUpdateBo);
                this.resourceService.saveBatchResourceNoPermission(resourcesVo, user);
                EventHelper.sendMaterialTypeStatCountEvent(this, typeIdList.toArray(new Integer[0]));
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingAndMaterial::getMaterialId, materialIdList);
                this.andMaterialMapper.delete((Wrapper)wrapper2);
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("material_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.material_delete.description");
                List list = mList.stream().map(TrainingMaterial::getMaterialName).collect(Collectors.toList());
                String materialName = String.join((CharSequence)";", list);
                pojo.setI18nParam(materialName);
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                this.logApi.save(pojo);
            }
        }
        if ("1".equals(isNum)) {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.delete", null, locale), null);
        }
        return JsonResult.success();
    }

    @Override
    public Map<String, Object> insertMaterialType(TrainingMaterialType materialType) {
        Date now = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String isNum = "1";
        List<TrainingMaterialType> typeList = this.materialTypeMapper.getMaterialTypeBySameName(materialType);
        if (CollectionUtils.isEmpty(typeList)) {
            Integer sort;
            if (materialType.getMaterialTypeLevel() == 1 && materialType.getSourceId() != null) {
                materialType.setSourceId(null);
                log.error("\u5206\u7c7b\u4f20\u9519:{}", (Object)materialType);
            }
            materialType.setCreateTime(now);
            materialType.setUpdateTime(now);
            Integer n = sort = this.getModuleTypeLastSort(materialType.getModuleType(), materialType.getMaterialTypeLevel(), materialType.getEnterpriseId());
            Integer n2 = sort = Integer.valueOf(sort + 1);
            materialType.setSort(sort);
            this.materialTypeMapper.insert(materialType);
            map.put("materialType", materialType);
            if (materialType.getModuleType().compareTo(1) == 0) {
                this.materialTypePermissionService.onMaterialTypeCreate(materialType);
            }
            if (materialType.getMaterialTypeLevel() != null && materialType.getMaterialTypeLevel() == 1) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)materialType.getModuleType())).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
                if (materialType.getEnterpriseId() != null) {
                    wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)materialType.getEnterpriseId());
                } else {
                    wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
                }
                List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
                map.put("total", trainingMaterialTypeList.size());
            }
        } else {
            isNum = "0";
        }
        map.put("isNum", isNum);
        return map;
    }

    @Override
    public String updateMaterialType(TrainingMaterialType materialType) {
        List<TrainingMaterialType> typeList = this.materialTypeMapper.getMaterialTypeBySameName(materialType);
        if (CollectionUtils.isEmpty(typeList)) {
            this.materialTypeMapper.updateById(materialType);
            return "1";
        }
        Set idSet = typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toSet());
        if (!idSet.contains(materialType.getId())) {
            return "0";
        }
        this.materialTypeMapper.updateById(materialType);
        return "1";
    }

    private List<Integer> getMaterialTypeIdList(Integer typeId, Integer enterpriseId, Integer moduleType2) {
        Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeMap = this.getChildTypeList(enterpriseId, moduleType2);
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        typeIds.add(typeId);
        return this.fillChildTypeId(typeIds, trainingMaterialTypeMap, typeId);
    }

    private List<Integer> getNewMaterialTypeIdList(Integer typeId, Integer enterpriseId, Integer moduleType2, Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeMap) {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        typeIds.add(typeId);
        return this.fillChildTypeId(typeIds, trainingMaterialTypeMap, typeId);
    }

    private List<Integer> fillChildTypeId(List<Integer> typeIds, Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeMap, Integer typeId) {
        List<TrainingMaterialType> list = trainingMaterialTypeMap.get(typeId);
        if (CollectionUtils.isEmpty(list)) {
            return typeIds;
        }
        for (TrainingMaterialType trainingMaterialType : list) {
            typeIds.add(trainingMaterialType.getId());
            this.fillChildTypeId(typeIds, trainingMaterialTypeMap, trainingMaterialType.getId());
        }
        return typeIds;
    }

    private List<Integer> getParentMaterialTypeIdList(Integer typeId, Integer enterpriseId, Integer moduleType2) {
        Map<Integer, TrainingMaterialType> trainingMaterialTypeMap = this.getParentTypeList(enterpriseId, moduleType2);
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        TrainingMaterialType materialType2 = trainingMaterialTypeMap.get(typeId);
        if (!ObjectUtils.isEmpty((Object)materialType2) && materialType2.getSourceId() != null) {
            typeIds.add(materialType2.getSourceId());
            TrainingMaterialType materialType3 = trainingMaterialTypeMap.get(materialType2.getSourceId());
            if (!ObjectUtils.isEmpty((Object)materialType3) && materialType3.getSourceId() != null) {
                typeIds.add(materialType3.getSourceId());
                TrainingMaterialType materialType4 = trainingMaterialTypeMap.get(materialType3.getSourceId());
                if (!ObjectUtils.isEmpty((Object)materialType4) && materialType4.getSourceId() != null) {
                    typeIds.add(materialType4.getSourceId());
                    TrainingMaterialType materialType5 = trainingMaterialTypeMap.get(materialType4.getSourceId());
                    if (!ObjectUtils.isEmpty((Object)materialType5) && materialType5.getSourceId() != null) {
                        typeIds.add(materialType5.getSourceId());
                    }
                }
            }
        }
        return typeIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String delMaterialType(TrainingMaterialType materialType, LogPojo pojo) {
        TrainingMaterialType myType = (TrainingMaterialType)this.materialTypeMapper.selectById(materialType.getId());
        if (pojo.getEnterpriseId() != null && myType.getEnterpriseId() != null && !pojo.getEnterpriseId().equals(myType.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        List<Integer> typeIds = this.getMaterialTypeIdList(myType.getId(), myType.getEnterpriseId(), myType.getModuleType());
        if (!CollectionUtils.isEmpty(typeIds)) {
            if (myType.getModuleType() == 1) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.in(TrainingMaterial::getMaterialTypeId, typeIds)).eq(TrainingMaterial::getIsDel, (Object)0);
                List trainingMaterialList = this.materialMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
                    return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                }
                LambdaQueryWrapper w = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)w.in(Training::getTrainingType, typeIds)).eq(Training::getProjectShow, (Object)5)).eq(Training::getIsDel, (Object)0);
                List trainingList = this.trainingMapper.selectList((Wrapper)w);
                if (!CollectionUtils.isEmpty((Collection)trainingList)) {
                    return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                }
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 2) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.in(TrainingExam::getTypeId, typeIds)).and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(TrainingExam::getExamVersion, (Object)1)).or()).isNull(TrainingExam::getExamVersion);
                });
                List trainingExamList = this.trainingExamMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingExamList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 3) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(TrainingPaper::getTypeId, typeIds);
                List trainingPaperlList = this.trainingPaperMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingPaperlList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 4) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(TrainingLearnProject::getProjectType, typeIds);
                List trainingLearnProjectList = this.trainingLearnProjectMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingLearnProjectList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 5) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(Training::getTrainingType, typeIds)).eq(Training::getProjectShow, (Object)5)).eq(Training::getIsDel, (Object)0);
                List trainingList = this.trainingMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 6) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.in(TrainingFee::getTrainingType, typeIds)).eq(TrainingFee::getIsDelete, (Object)0);
                List trainingFeeList = this.trainingFeeMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingFeeList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            } else if (myType.getModuleType() == 7) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(TrainingQuestionType::getMaterialId, typeIds);
                List trainingQuestionTypeList = this.trainingQuestionTypeMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingQuestionTypeList)) return JsonResult.error((String)"EXIST_DATA", (Object)"\u5b58\u5728\u6570\u636e");
                this.materialTypeMapper.deleteBatchIds(typeIds);
            }
        }
        if (!CollectionUtils.isEmpty(typeIds)) {
            this.materialTypePermissionService.onTypeDelete(typeIds);
        }
        pojo.setI18nParam("(L" + myType.getMaterialTypeLevel() + ")" + myType.getMaterialTypeName());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public Page<TrainingMaterialTypeVo> getMaterialTypeByPage(Page<TrainingMaterialTypeVo> page, TrainingMaterialTypeVo materialType, Users user) {
        this.saveMaterialTypeFee(materialType, user);
        List<Object> list = new ArrayList<TrainingMaterialTypeVo>();
        if (materialType.getModuleType().compareTo(1) == 0) {
            boolean global = this.materialPermissionFacade.validGlobal(user, 1);
            if (!global) {
                List<TrainingMaterialTypeVo> materialTypeList = this.getMaterialTypeListByUserPower(user, materialType.getShowOrder());
                list.addAll(materialTypeList);
                page = ListUtil.myPage(list, page.getPageNumber(), page.getPageSize());
                list = page.getContent();
            } else {
                list = this.materialTypeMapper.getMaterialTypeByPage((Page<TrainingMaterialTypeVo>)page, user.getGroupId(), materialType.getId(), materialType.getMaterialTypeLevel(), materialType.getMaterialTypeName(), materialType.getSourceId(), materialType.getOriginId(), materialType.getModuleType(), materialType.getShowOrder());
            }
            Set<Integer> manageTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 3);
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                TrainingMaterialTypeVo trainingMaterialTypeVo;
                trainingMaterialTypeVo.setIsPower(Integer.valueOf(manageTypeIdSet.contains((trainingMaterialTypeVo = (TrainingMaterialTypeVo)iterator.next()).getId()) ? 1 : 0));
            }
        } else {
            list = materialType.getModuleType().compareTo(5) == 0 ? this.materialTypeMapper.getMaterialTrainingTypeByPage((Page<TrainingMaterialTypeVo>)page, user.getGroupId(), materialType.getId(), materialType.getMaterialTypeLevel(), materialType.getMaterialTypeName(), materialType.getSourceId(), materialType.getOriginId(), materialType.getModuleType(), materialType.getShowOrder()) : this.materialTypeMapper.getMaterialTypeByPage((Page<TrainingMaterialTypeVo>)page, user.getGroupId(), materialType.getId(), materialType.getMaterialTypeLevel(), materialType.getMaterialTypeName(), materialType.getSourceId(), materialType.getOriginId(), materialType.getModuleType(), materialType.getShowOrder());
        }
        if (!CollectionUtils.isEmpty(list)) {
            Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeMap = this.getChildTypeList(user.getGroupId(), materialType.getModuleType());
            for (TrainingMaterialTypeVo trainingMaterialTypeVo : list) {
                List<Integer> trainingMaterialTypeIdList = this.getNewMaterialTypeIdList(trainingMaterialTypeVo.getId(), user.getGroupId(), materialType.getModuleType(), trainingMaterialTypeMap);
                trainingMaterialTypeIdList.remove(trainingMaterialTypeVo.getId());
                if (!CollectionUtils.isEmpty(trainingMaterialTypeIdList)) {
                    trainingMaterialTypeVo.setIsChildren(Integer.valueOf(1));
                    Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, trainingMaterialTypeIdList);
                    if (!CollectionUtils.isEmpty(validMaterialTypeIdSet)) continue;
                    trainingMaterialTypeVo.setIsChildren(Integer.valueOf(0));
                    continue;
                }
                trainingMaterialTypeVo.setIsChildren(Integer.valueOf(0));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public Map<Integer, List<TrainingMaterialType>> getChildTypeList(Integer enterpriseId, Integer moduleType2) {
        Map<Integer, List<TrainingMaterialType>> map = new HashMap<Integer, List<TrainingMaterialType>>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (enterpriseId != null) {
            wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        } else {
            wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).isNotNull(TrainingMaterialType::getSourceId)).orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
        List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
            map = trainingMaterialTypeList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getSourceId));
        }
        return map;
    }

    @Override
    public Map<Integer, TrainingMaterialType> getParentTypeList(Integer enterpriseId, Integer moduleType2) {
        Map<Integer, Object> map = new HashMap<Integer, TrainingMaterialType>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (enterpriseId != null) {
            wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        } else {
            wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
        List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
            map = trainingMaterialTypeList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, Function.identity()));
        }
        return map;
    }

    public List<TrainingMaterialTypeVo> getMaterialTypeListByUserPower(Users user, Integer showOrder) {
        ArrayList<TrainingMaterialTypeVo> materialTypeList = new ArrayList<TrainingMaterialTypeVo>();
        Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (user.getGroupId() != null) {
            wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId());
        } else {
            wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
        }
        ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1)).eq(TrainingMaterialType::getModuleType, (Object)1);
        if (showOrder != null) {
            ((LambdaQueryWrapper)wrapper1.orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
        } else {
            ((LambdaQueryWrapper)wrapper1.orderByDesc(TrainingMaterialType::getSort)).orderByDesc(TrainingMaterialType::getId);
        }
        List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        Map<Integer, List<TrainingMaterialType>> childMap = this.getChildTypeList(user.getGroupId(), 1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
            for (TrainingMaterialType trainingMaterialType1 : trainingMaterialTypeList) {
                if (validMaterialTypeIdSet.contains(trainingMaterialType1.getId())) {
                    TrainingMaterialTypeVo trainingMaterialTypeVo = new TrainingMaterialTypeVo();
                    BeanUtils.copyProperties((Object)trainingMaterialType1, (Object)trainingMaterialTypeVo);
                    materialTypeList.add(trainingMaterialTypeVo);
                    continue;
                }
                materialTypeList.addAll(this.getTypeListByUserPower(trainingMaterialType1.getId(), validMaterialTypeIdSet, childMap));
            }
        }
        return materialTypeList;
    }

    private List<TrainingMaterialTypeVo> getTypeListByUserPower(Integer materialTypeId, Collection<Integer> materialTypeIdList, Map<Integer, List<TrainingMaterialType>> childMap) {
        ArrayList<TrainingMaterialTypeVo> materialTypeList = new ArrayList<TrainingMaterialTypeVo>();
        List<TrainingMaterialType> trainingMaterialTypes = childMap.get(materialTypeId);
        if (!CollectionUtils.isEmpty(trainingMaterialTypes)) {
            for (TrainingMaterialType trainingMaterialType : trainingMaterialTypes) {
                if (materialTypeIdList.contains(trainingMaterialType.getId())) {
                    TrainingMaterialTypeVo trainingMaterialTypeVo = new TrainingMaterialTypeVo();
                    BeanUtils.copyProperties((Object)trainingMaterialType, (Object)trainingMaterialTypeVo);
                    materialTypeList.add(trainingMaterialTypeVo);
                    continue;
                }
                materialTypeList.addAll(this.getTypeListByUserPower(trainingMaterialType.getId(), materialTypeIdList, childMap));
            }
        }
        return materialTypeList;
    }

    private Integer getModuleTypeLastSort(Integer moduleType2, Integer materialTypeLevel, Integer enterpriseId) {
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper3.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)materialTypeLevel);
        if (enterpriseId != null) {
            wrapper3.eq(TrainingMaterialType::getEnterpriseId, (Object)enterpriseId);
        } else {
            wrapper3.isNull(TrainingMaterialType::getEnterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.orderByDesc(TrainingMaterialType::getSort)).orderByDesc(TrainingMaterialType::getId)).last(" limit 1 ");
        TrainingMaterialType trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectOne((Wrapper)wrapper3);
        Integer sort = 0;
        if (!ObjectUtils.isEmpty((Object)trainingMaterialType)) {
            sort = trainingMaterialType.getSort();
        }
        return sort;
    }

    private void saveMaterialTypeFee(TrainingMaterialTypeVo materialType, Users user) {
        if (materialType.getModuleType().compareTo(6) == 0) {
            BaseResult baseList;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingMaterialType::getModuleType, (Object)6)).eq(TrainingMaterialType::getIsTrade, (Object)1)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1)).isNull(TrainingMaterialType::getEnterpriseId);
            List trainingMaterialTypes = this.materialTypeMapper.selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)trainingMaterialTypes)) {
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                TrainingMaterialType trainingMaterialType = new TrainingMaterialType();
                trainingMaterialType.setIsTrade(Integer.valueOf(1));
                trainingMaterialType.setModuleType(Integer.valueOf(6));
                String nameIndustry = this.messageSource.getMessage("training.material.type.name.industry", null, locale);
                trainingMaterialType.setMaterialTypeName(nameIndustry);
                trainingMaterialType.setMaterialTypeLevel(Integer.valueOf(1));
                trainingMaterialType.setSort(Integer.valueOf(1));
                trainingMaterialType.setCreater(user.getId());
                trainingMaterialType.setCreateTime(new Date());
                trainingMaterialType.setUpdater(user.getId());
                trainingMaterialType.setUpdateTime(new Date());
                this.materialTypeMapper.insert(trainingMaterialType);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)(baseList = this.enterpriseGroupsApi.getAllCategories())) && !CollectionUtils.isEmpty((Collection)((Collection)baseList.getData()))) {
                Integer sort;
                List pojoList = (List)baseList.getData();
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)6)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)2)).isNotNull(TrainingMaterialType::getCategoryId);
                List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
                Map<Object, Object> materialTypeMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
                    materialTypeMap = trainingMaterialTypeList.stream().collect(Collectors.toMap(TrainingMaterialType::getCategoryId, Function.identity()));
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialType::getModuleType, (Object)6)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1)).eq(TrainingMaterialType::getIsTrade, (Object)1)).orderByDesc(TrainingMaterialType::getId)).last(" limit 1 ");
                TrainingMaterialType materialTypeMark = (TrainingMaterialType)this.materialTypeMapper.selectOne((Wrapper)wrapper2);
                Integer n = sort = this.getModuleTypeLastSort(6, 2, null);
                sort = sort + 1;
                Integer n2 = sort;
                ArrayList<TrainingMaterialType> typeAddList = new ArrayList<TrainingMaterialType>();
                for (SimplePojo pojo : pojoList) {
                    TrainingMaterialType trainingMaterialType = (TrainingMaterialType)materialTypeMap.get(pojo.getId());
                    if (org.springframework.util.StringUtils.isEmpty((Object)trainingMaterialType)) {
                        trainingMaterialType = new TrainingMaterialType();
                        trainingMaterialType.setMaterialTypeName(pojo.getName());
                        trainingMaterialType.setMaterialTypeLevel(Integer.valueOf(2));
                        trainingMaterialType.setSourceId(materialTypeMark.getId());
                        trainingMaterialType.setOriginId(materialTypeMark.getId());
                        trainingMaterialType.setCreater(user.getId());
                        trainingMaterialType.setCreateTime(new Date());
                        trainingMaterialType.setUpdater(user.getId());
                        trainingMaterialType.setUpdateTime(new Date());
                        trainingMaterialType.setModuleType(Integer.valueOf(6));
                        trainingMaterialType.setCategoryId(pojo.getId());
                        trainingMaterialType.setSort(sort);
                        Integer n3 = sort;
                        Integer n4 = sort = Integer.valueOf(sort + 1);
                        typeAddList.add(trainingMaterialType);
                        continue;
                    }
                    if (pojo.getName().equals(trainingMaterialType.getMaterialTypeName())) continue;
                    trainingMaterialType.setMaterialTypeName(pojo.getName());
                    this.materialTypeMapper.updateById(trainingMaterialType);
                }
                if (!CollectionUtils.isEmpty(typeAddList)) {
                    this.materialTypeMapper.insertList(typeAddList);
                }
            }
        }
    }

    @Override
    public List<TrainingMaterialTypeVo> getMaterialType(TrainingMaterialTypeVo materialType, Users user) {
        List<Object> list = new ArrayList();
        if (materialType.getModuleType().compareTo(1) == 0) {
            list = this.materialTypeMapper.getMaterialType(materialType);
            Boolean is = true;
            boolean global = this.materialPermissionFacade.validGlobal(user, 1);
            if (!global) {
                is = false;
                list = new ArrayList();
                List<TrainingMaterialTypeVo> list2 = this.getPartPowerMaterialType(materialType, user);
                list.addAll(list2);
            }
            if (!CollectionUtils.isEmpty(list)) {
                int n;
                boolean bl = false;
                if (global) {
                    n = 1;
                }
                List<Integer> typeIdList = list.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
                Set<Integer> validMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, typeIdList);
                Map<Integer, Integer> materialCountMap = null;
                if (is.booleanValue()) {
                    Iterator materialCountList = this.materialMapper.getMaterialNumber(user.getGroupId(), materialType.getIsUsing());
                    materialCountMap = materialCountList.stream().collect(Collectors.toMap(TrainingMaterialType::getId, TrainingMaterialTypeVo::getMaterialCount));
                }
                for (TrainingMaterialTypeVo trainingMaterialTypeVo : list) {
                    trainingMaterialTypeVo.setIsPower(Integer.valueOf(n));
                    if (n == 0) {
                        trainingMaterialTypeVo.setIsPower(Integer.valueOf(validMaterialTypeIdSet.contains(trainingMaterialTypeVo.getId()) ? 1 : 0));
                    }
                    if (!is.booleanValue()) continue;
                    trainingMaterialTypeVo.setMaterialCount(Integer.valueOf(org.springframework.util.StringUtils.isEmpty((Object)materialCountMap.get(trainingMaterialTypeVo.getId())) ? 0 : materialCountMap.get(trainingMaterialTypeVo.getId())));
                }
            }
        } else {
            list = this.materialTypeMapper.getMaterialType(materialType);
        }
        if (materialType.getNeedFilter() != null && materialType.getNeedFilter().equals(1)) {
            LambdaQueryWrapper wrapper;
            List<Object> idList;
            ArrayList<TrainingMaterialTypeVo> newList = new ArrayList<TrainingMaterialTypeVo>();
            if (materialType.getMaterialTypeLevel().equals(2)) {
                for (TrainingMaterialTypeVo trainingMaterialTypeVo : list) {
                    idList = new ArrayList<Integer>();
                    LambdaQueryWrapper type2Wrapper = new LambdaQueryWrapper();
                    type2Wrapper.eq(TrainingMaterialType::getSourceId, (Object)materialType.getId());
                    List type2List = this.materialTypeMapper.selectList((Wrapper)type2Wrapper);
                    if (!CollectionUtils.isEmpty((Collection)type2List)) {
                        for (TrainingMaterialType trainingMaterialType : type2List) {
                            LambdaQueryWrapper type3Wrapper = new LambdaQueryWrapper();
                            type3Wrapper.eq(TrainingMaterialType::getSourceId, (Object)trainingMaterialType.getId());
                            List type3List = this.materialTypeMapper.selectList((Wrapper)type3Wrapper);
                            if (CollectionUtils.isEmpty((Collection)type3List)) continue;
                            for (TrainingMaterialType type3 : type3List) {
                                LambdaQueryWrapper type4Wrapper = new LambdaQueryWrapper();
                                type4Wrapper.eq(TrainingMaterialType::getSourceId, (Object)type3.getId());
                                List type4List = this.materialTypeMapper.selectList((Wrapper)type4Wrapper);
                                if (CollectionUtils.isEmpty((Collection)type4List)) continue;
                                for (TrainingMaterialType type4 : type4List) {
                                    LambdaQueryWrapper type5Wrapper = new LambdaQueryWrapper();
                                    type5Wrapper.eq(TrainingMaterialType::getSourceId, (Object)type4.getId());
                                    List type5List = this.materialTypeMapper.selectList((Wrapper)type5Wrapper);
                                    if (CollectionUtils.isEmpty((Collection)type5List)) continue;
                                    idList.addAll(type5List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                                }
                                idList.addAll(type4List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                            }
                            idList.addAll(type3List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                        }
                        idList.addAll(type2List.stream().map(TrainingMaterialType::getId).collect(Collectors.toList()));
                    }
                    idList.add(trainingMaterialTypeVo.getId());
                    wrapper = new LambdaQueryWrapper();
                    wrapper.in(TrainingFee::getTrainingType, idList);
                    wrapper.eq(TrainingFee::getStatus, (Object)2);
                    List list3 = this.trainingFeeMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtils.isEmpty((Collection)list3)) continue;
                    newList.add(trainingMaterialTypeVo);
                }
            } else if (materialType.getMaterialTypeLevel().equals(1)) {
                for (TrainingMaterialTypeVo trainingMaterialTypeVo : list) {
                    idList = new ArrayList();
                    LambdaQueryWrapper typeWrapper = new LambdaQueryWrapper();
                    typeWrapper.eq(TrainingMaterialType::getOriginId, (Object)trainingMaterialTypeVo.getId());
                    List typeList = this.materialTypeMapper.selectList((Wrapper)typeWrapper);
                    if (!CollectionUtils.isEmpty((Collection)typeList)) {
                        idList = typeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
                    }
                    idList.add(trainingMaterialTypeVo.getId());
                    wrapper = new LambdaQueryWrapper();
                    wrapper.in(TrainingFee::getTrainingType, idList);
                    wrapper.eq(TrainingFee::getStatus, (Object)2);
                    List list4 = this.trainingFeeMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtils.isEmpty((Collection)list4)) continue;
                    newList.add(trainingMaterialTypeVo);
                }
            }
            return newList;
        }
        return list;
    }

    @Override
    public List<TrainingMaterialTypeVo> getMaterialTypeNew(TrainingMaterialTypeVo materialType, Users user) {
        List<Object> list = new ArrayList();
        if (materialType.getModuleType().compareTo(1) == 0) {
            list = this.materialTypeMapper.getMaterialType(materialType);
            boolean global = this.materialPermissionFacade.validGlobal(user, 1);
            if (!global) {
                list = new ArrayList();
                List<TrainingMaterialTypeVo> materialTypeVoList = this.getPartPowerMaterialType(materialType, user);
                list.addAll(materialTypeVoList);
            }
            if (!CollectionUtils.isEmpty(list)) {
                List<Integer> materialTypeIdList = list.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
                int num = 0;
                Set<Integer> validManageSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, materialTypeIdList);
                if (global) {
                    num = 1;
                }
                for (TrainingMaterialTypeVo trainingMaterialTypeVo : list) {
                    trainingMaterialTypeVo.setIsPower(Integer.valueOf(num));
                    if (num != 0) continue;
                    trainingMaterialTypeVo.setIsPower(Integer.valueOf(validManageSet.contains(trainingMaterialTypeVo.getId()) ? 1 : 0));
                }
            }
        } else {
            list = this.materialTypeMapper.getMaterialType(materialType);
        }
        return list;
    }

    private List<TrainingMaterialTypeVo> getPartPowerMaterialType(TrainingMaterialTypeVo materialType, Users user) {
        ArrayList<TrainingMaterialTypeVo> list = new ArrayList<TrainingMaterialTypeVo>();
        Set<Integer> materialTypeIds = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
        if (!CollectionUtils.isEmpty(materialTypeIds)) {
            List<Object> materialTypeList = new ArrayList();
            Map<Integer, List<TrainingMaterialType>> childMap = this.getChildTypeList(user.getGroupId(), 1);
            materialTypeList = materialType.getSourceId() == null ? this.getMaterialTypeListByUserPower(user, materialType.getShowOrder()) : this.getTypeListByUserPower(materialType.getSourceId(), materialTypeIds, childMap);
            List<TrainingMaterialTypeVo> trainingMaterialTypeVos = this.materialTypeMapper.selectMaterialCountByType(user.getGroupId(), materialType.getIsUsing());
            Map<Integer, Integer> materialCountMap = trainingMaterialTypeVos.stream().collect(Collectors.toMap(TrainingMaterialType::getId, TrainingMaterialTypeVo::getMaterialCount));
            if (!CollectionUtils.isEmpty(materialTypeList)) {
                for (TrainingMaterialTypeVo trainingMaterialTypeVo : materialTypeList) {
                    List<Integer> trainingMaterialTypeIdList = this.getNewMaterialTypeIdList(trainingMaterialTypeVo.getId(), user.getGroupId(), 1, childMap);
                    trainingMaterialTypeIdList.remove(trainingMaterialTypeVo.getId());
                    if (!CollectionUtils.isEmpty(trainingMaterialTypeIdList)) {
                        trainingMaterialTypeIdList.retainAll(materialTypeIds);
                        if (CollectionUtils.isEmpty(trainingMaterialTypeIdList)) {
                            trainingMaterialTypeVo.setIsChildren(Integer.valueOf(0));
                        } else {
                            trainingMaterialTypeVo.setIsChildren(Integer.valueOf(1));
                        }
                    } else {
                        trainingMaterialTypeVo.setIsChildren(Integer.valueOf(0));
                    }
                    trainingMaterialTypeIdList.add(trainingMaterialTypeVo.getId());
                    Integer materialCount = 0;
                    for (Integer trainingMaterialTypeId : trainingMaterialTypeIdList) {
                        Integer counts = materialCountMap.get(trainingMaterialTypeId);
                        materialCount = materialCount + (counts != null ? counts : 0);
                    }
                    trainingMaterialTypeVo.setMaterialCount(materialCount);
                    list.add(trainingMaterialTypeVo);
                }
            }
        }
        return list;
    }

    @Override
    public void updateMaterialSort(Integer id, Integer materialTypeLevel, Integer moduleType2, Integer sort, Integer move, Users user) {
        TrainingMaterialType type = (TrainingMaterialType)this.materialTypeMapper.selectById(id);
        TrainingMaterialType level = this.materialTypeMapper.selectMaterialTypeBySort(user.getGroupId(), materialTypeLevel, moduleType2, type.getSort(), move, type.getOriginId());
        if (level != null) {
            TrainingMaterialType materialType = new TrainingMaterialType();
            materialType.setId(id);
            materialType.setSort(level.getSort());
            this.materialTypeMapper.updateById(materialType);
            level.setSort(type.getSort());
            this.materialTypeMapper.updateById(level);
        }
    }

    @Override
    public List<TrainingMaterialPowerVo> selectMaterialPower(Integer materialTypeId, Users users) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingMaterialPower::getEnterpriseId, (Object)users.getGroupId());
        if (materialTypeId == null) {
            wrapper.eq(TrainingMaterialPower::getIsAll, (Object)1);
        } else {
            wrapper.eq(TrainingMaterialPower::getMaterialTypeId, (Object)materialTypeId);
        }
        List list = this.materialPowerMapper.selectList((Wrapper)wrapper);
        ArrayList<TrainingMaterialPowerVo> powerList = new ArrayList<TrainingMaterialPowerVo>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            TrainingMaterialType trainingMaterialType;
            List<Integer> materialTypeIdList;
            List trainingMaterialPowerIdList = list.stream().map(TrainingMaterialPower::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingMaterialPowerUser::getPowerId, trainingMaterialPowerIdList);
            List trainingMaterialPowerUserList = this.materialPowerUserMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> trainingMaterialPowerUserMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialPowerUserList)) {
                trainingMaterialPowerUserMap = trainingMaterialPowerUserList.stream().collect(Collectors.groupingBy(TrainingMaterialPowerUser::getPowerId));
            }
            Integer isUpdate = 1;
            if (materialTypeId != null && !CollectionUtils.isEmpty(materialTypeIdList = this.getParentMaterialTypeIdList(materialTypeId, (trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectById(materialTypeId)).getEnterpriseId(), trainingMaterialType.getModuleType()))) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.in(TrainingMaterialPower::getMaterialTypeId, materialTypeIdList)).eq(TrainingMaterialPower::getIsCover, (Object)1);
                List materialPowerUserList = this.materialPowerMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)materialPowerUserList)) {
                    isUpdate = 0;
                }
            }
            for (TrainingMaterialPower power : list) {
                TrainingMaterialPowerVo powerVo = new TrainingMaterialPowerVo();
                BeanUtils.copyProperties((Object)power, (Object)powerVo);
                if (materialTypeId != null && powerVo.getIsExtends() != null && powerVo.getIsExtends() == 1 && isUpdate == 1) {
                    isUpdate = 2;
                }
                powerVo.setIsUpdte(isUpdate);
                List materialPowerUsers = (List)trainingMaterialPowerUserMap.get(powerVo.getId());
                if (!CollectionUtils.isEmpty((Collection)materialPowerUsers)) {
                    ArrayList userList = new ArrayList();
                    for (TrainingMaterialPowerUser trainingMaterialPowerUser : materialPowerUsers) {
                        UsersPojo pojo;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String userId = trainingMaterialPowerUser.getUserId();
                        map.put("userId", userId);
                        map.put("type", trainingMaterialPowerUser.getType());
                        String userName = "";
                        if (trainingMaterialPowerUser.getType() == 1) {
                            pojo = this.userUtilService.selectUser(Integer.valueOf(userId));
                            if (!ObjectUtils.isEmpty((Object)pojo)) {
                                userName = pojo.getShowName();
                            }
                        } else if (trainingMaterialPowerUser.getType() == 2) {
                            pojo = this.userUtilService.selectRole(Integer.valueOf(userId));
                            if (!ObjectUtils.isEmpty((Object)pojo)) {
                                userName = pojo.getRoleName();
                            }
                        } else if (trainingMaterialPowerUser.getType() == 3) {
                            pojo = this.userUtilService.selectTag(Integer.valueOf(userId));
                            if (!ObjectUtils.isEmpty((Object)pojo)) {
                                userName = pojo.getTagName();
                            }
                        } else if (trainingMaterialPowerUser.getType() == 4 && !ObjectUtils.isEmpty((Object)(pojo = this.userUtilService.selectOrg(userId)))) {
                            userName = pojo.getName();
                        }
                        map.put("userName", userName);
                        userList.add(map);
                    }
                    powerVo.setUserLists(userList);
                }
                powerList.add(powerVo);
            }
        }
        return powerList;
    }

    @Override
    public List<TrainingMaterialVo> selectMaterialByPower(Integer id, Users user) {
        List<TrainingMaterialVo> materialVoList = this.materialMapper.selectOnlyType(id, user.getGroupId(), null);
        List<Object> materialVoList1 = new ArrayList();
        if (id != null) {
            materialVoList1 = this.materialMapper.selectTypeAndMaterial(id, user.getGroupId(), null, null);
        }
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue()) {
            Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
            if (!CollectionUtils.isEmpty(validMaterialTypeIdSet)) {
                if (!CollectionUtils.isEmpty(materialVoList)) {
                    ArrayList<TrainingMaterialVo> materialVoList2 = new ArrayList<TrainingMaterialVo>();
                    for (TrainingMaterialVo trainingMaterialVo : materialVoList) {
                        if (validMaterialTypeIdSet.contains(trainingMaterialVo.getId())) continue;
                        materialVoList2.add(trainingMaterialVo);
                    }
                    materialVoList.removeAll(materialVoList2);
                }
            } else {
                materialVoList = new ArrayList<TrainingMaterialVo>();
            }
        }
        if (materialVoList != null) {
            materialVoList.addAll(materialVoList1);
        } else {
            materialVoList = new ArrayList<TrainingMaterialVo>(materialVoList1);
        }
        return materialVoList;
    }

    @Override
    public Page<TrainingMaterialVo> selectMaterialByPowerByPage(Page<TrainingMaterialVo> page, Integer id, Users user) {
        List<Object> materialVoList = null;
        boolean global = this.materialPermissionFacade.validGlobal(user, 1);
        if (!global) {
            Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
            if (!CollectionUtils.isEmpty(validMaterialTypeIdSet)) {
                if (id == null) {
                    List<TrainingMaterialTypeVo> materialTypeList = this.getMaterialTypeListByUserPower(user, 1);
                    Page<TrainingMaterialTypeVo> typePage = ListUtil.myPage(materialTypeList, page.getPageNumber(), page.getPageSize());
                    List materialTypes = typePage.getContent();
                    materialVoList = new ArrayList<TrainingMaterialVo>();
                    if (!CollectionUtils.isEmpty((Collection)materialTypes)) {
                        for (TrainingMaterialTypeVo vo : materialTypes) {
                            TrainingMaterialVo materialVo = this.getTrainingMaterialVo(vo);
                            materialVoList.add(materialVo);
                        }
                    }
                } else if (validMaterialTypeIdSet.contains(id)) {
                    Map<Integer, List<TrainingMaterialType>> childMap = this.getChildTypeList(user.getGroupId(), 1);
                    List<TrainingMaterialTypeVo> materialTypeList = this.getTypeListByUserPower(id, validMaterialTypeIdSet, childMap);
                    ArrayList<TrainingMaterialVo> trainingMaterialVoList = new ArrayList<TrainingMaterialVo>();
                    if (!CollectionUtils.isEmpty(materialTypeList)) {
                        for (TrainingMaterialTypeVo vo : materialTypeList) {
                            TrainingMaterialVo materialVo = this.getTrainingMaterialVo(vo);
                            trainingMaterialVoList.add(materialVo);
                        }
                    }
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterial::getMaterialTypeId, (Object)id)).eq(TrainingMaterial::getIsDel, (Object)0)).eq(TrainingMaterial::getIsShow, (Object)1)).eq(TrainingMaterial::getIsUsing, (Object)1)).orderByDesc(TrainingMaterial::getUpdateTime);
                    List trainingMaterialList = this.materialMapper.selectList((Wrapper)wrapper1);
                    trainingMaterialVoList.addAll(this.getTrainingMaterialVoList(trainingMaterialList));
                    page = ListUtil.myPage(trainingMaterialVoList, page.getPageNumber(), page.getPageSize());
                    materialVoList = page.getContent();
                }
            }
        } else {
            materialVoList = id == null ? this.materialMapper.selectOnlyTypeByPage((Page<TrainingMaterialVo>)page, null, user.getGroupId()) : this.materialMapper.selectTypeAndMaterialByPage((Page<TrainingMaterialVo>)page, id, null, user.getGroupId());
        }
        page.setContent(materialVoList);
        return page;
    }

    private TrainingMaterialVo getTrainingMaterialVo(TrainingMaterialTypeVo vo) {
        TrainingMaterialVo materialVo = new TrainingMaterialVo();
        materialVo.setId(vo.getId());
        materialVo.setMaterialName(vo.getMaterialTypeName());
        materialVo.setCreater(vo.getCreater());
        materialVo.setCreateTime(vo.getCreateTime());
        materialVo.setUpdateTime(vo.getUpdateTime());
        materialVo.setSize(Integer.valueOf(0));
        materialVo.setIsCommodity(Integer.valueOf(0));
        return materialVo;
    }

    private List<TrainingMaterialVo> getTrainingMaterialVoList(List<TrainingMaterial> trainingMaterialList) {
        ArrayList<TrainingMaterialVo> materialVoList = new ArrayList<TrainingMaterialVo>();
        if (!CollectionUtils.isEmpty(trainingMaterialList)) {
            for (TrainingMaterial trainingMaterial : trainingMaterialList) {
                TrainingMaterialVo materialVo = new TrainingMaterialVo();
                materialVo.setId(trainingMaterial.getId());
                materialVo.setFileType(trainingMaterial.getFileType());
                materialVo.setMaterialName(trainingMaterial.getMaterialName());
                materialVo.setMaterialPath(trainingMaterial.getMaterialPath());
                materialVo.setMaterialTypeId(trainingMaterial.getMaterialTypeId());
                materialVo.setCreater(trainingMaterial.getCreater());
                materialVo.setCreateTime(trainingMaterial.getCreateTime());
                materialVo.setUpdater(trainingMaterial.getUpdater());
                materialVo.setUpdateTime(trainingMaterial.getUpdateTime());
                materialVo.setSize(trainingMaterial.getSize());
                materialVo.setIsCommodity(trainingMaterial.getIsCommodity());
                materialVoList.add(materialVo);
            }
        }
        return materialVoList;
    }

    @Override
    public TrainingMaterialCommentVo selectMaterialComment(Integer materialId, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getMaterialId, (Object)materialId)).eq(TrainingMaterialComment::getUserId, (Object)user.getId())).eq(TrainingMaterialComment::getType, (Object)1);
        List commentList = this.materialCommentMapper.selectList((Wrapper)wrapper1);
        TrainingMaterialCommentVo comment = new TrainingMaterialCommentVo();
        comment.setMaterialId(materialId);
        comment.setUserId(user.getId());
        comment.setStars(Integer.valueOf(0));
        comment.setIsLike(Integer.valueOf(0));
        if (!CollectionUtils.isEmpty((Collection)commentList)) {
            TrainingMaterialComment commentMap = (TrainingMaterialComment)commentList.get(0);
            comment.setId(commentMap.getId());
            comment.setStars(commentMap.getStars());
            comment.setIsLike(commentMap.getIsLike());
        }
        comment.setLikes(Integer.valueOf(0));
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialComment::getMaterialId, (Object)materialId)).eq(TrainingMaterialComment::getIsLike, (Object)1)).eq(TrainingMaterialComment::getType, (Object)1);
        List likeList = this.materialCommentMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)likeList)) {
            comment.setLikes(Integer.valueOf(likeList.size()));
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper3.eq(TrainingMaterialLecturer::getMaterialId, (Object)materialId)).eq(TrainingMaterialLecturer::getType, (Object)1);
        List list1 = this.materialLecturerMapper.selectList((Wrapper)wrapper3);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            List lecturerIdList = list1.stream().map(TrainingMaterialLecturer::getLecturerId).distinct().collect(Collectors.toList());
            List lecList = this.lecturerMapper.selectBatchIds(lecturerIdList);
            comment.setLecturerVoList(lecList);
        }
        return comment;
    }

    @Override
    public void updateMaterialComment(TrainingMaterialComment trainingMaterialComment) {
        if (trainingMaterialComment.getId() == null) {
            this.materialCommentMapper.insert(trainingMaterialComment);
        } else {
            this.materialCommentMapper.updateById(trainingMaterialComment);
        }
    }

    @Override
    public TrainingMaterial getMaterialById(Integer id) {
        return (TrainingMaterial)this.materialMapper.selectById(id);
    }

    @Override
    public List<TrainingMaterialVo> selectUsingMaterial(Integer materialId, Users user) {
        List userIdList;
        BaseResult simplePojoBaseList;
        List dbviewVOList;
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List<Integer> materialIdList = Collections.singletonList(materialId);
        List<TrainingMaterialVo> usingTrainList = this.materialMapper.selectUsingMaterial(materialIdList, user.getGroupId());
        MeterialPojo meterialPojo = new MeterialPojo();
        meterialPojo.setIds(materialIdList);
        meterialPojo.setType(Integer.valueOf(2));
        com.ovopark.pojo.BaseResult dbshopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
        if (dbshopViewBase != null && !CollectionUtils.isEmpty((Collection)(dbviewVOList = (List)dbshopViewBase.getData()))) {
            for (MeterialDbviewVO vo : dbviewVOList) {
                TrainingMaterialVo materialVo = new TrainingMaterialVo();
                String moduleName = this.messageSource.getMessage("training.material.module.name", null, locale);
                materialVo.setModulName(moduleName);
                materialVo.setTaskName(vo.getDbviewshopName());
                materialVo.setId(vo.getMaterialId());
                materialVo.setCreater(vo.getCreater());
                usingTrainList.add(materialVo);
            }
        }
        if (!CollectionUtils.isEmpty(usingTrainList) && (simplePojoBaseList = this.userApi.getSimpleUserByIdList(userIdList = usingTrainList.stream().map(TrainingMaterial::getCreater).distinct().collect(Collectors.toList()))) != null) {
            String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
            String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
            Map simplePojoMap = ((List)simplePojoBaseList.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            for (TrainingMaterialVo vo : usingTrainList) {
                SimplePojo pojo = (SimplePojo)simplePojoMap.get(vo.getCreater());
                if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                    vo.setCreateName(pojo.getName());
                }
                if ("train".equals(vo.getModulName())) {
                    vo.setModulName(trainName);
                    continue;
                }
                if ("job".equals(vo.getModulName())) {
                    vo.setModulName(jobName);
                    continue;
                }
                if ("learn".equals(vo.getModulName())) {
                    vo.setModulName(learnName);
                    continue;
                }
                if (!"course".equals(vo.getModulName())) continue;
                vo.setModulName(courseName);
            }
        }
        return usingTrainList;
    }

    @Override
    public List<TrainingMaterialVo> selectUsingMaterialList(List<Integer> materialList, Users user) {
        List dbviewVOList;
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List<Object> usingTrainList = new ArrayList();
        usingTrainList = this.materialMapper.selectUsingMaterial(materialList, user.getGroupId());
        MeterialPojo meterialPojo = new MeterialPojo();
        meterialPojo.setIds(materialList);
        meterialPojo.setType(Integer.valueOf(2));
        com.ovopark.pojo.BaseResult dbshopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
        if (dbshopViewBase != null && !CollectionUtils.isEmpty((Collection)(dbviewVOList = (List)dbshopViewBase.getData()))) {
            for (Object vo : dbviewVOList) {
                TrainingMaterialVo materialVo = new TrainingMaterialVo();
                String moduleName = this.messageSource.getMessage("training.material.module.name", null, locale);
                materialVo.setModulName(moduleName);
                materialVo.setMaterialName(vo.getMaterialName());
                materialVo.setId(vo.getMaterialId());
                materialVo.setCreater(vo.getCreater());
                usingTrainList.add(materialVo);
            }
        }
        if (!CollectionUtils.isEmpty(usingTrainList)) {
            Map<Integer, List<TrainingMaterialVo>> map = usingTrainList.stream().collect(Collectors.groupingBy(TrainingMaterial::getId));
            List materialIdList = usingTrainList.stream().map(TrainingMaterial::getId).distinct().collect(Collectors.toList());
            usingTrainList = new ArrayList();
            for (Integer materialId : materialIdList) {
                TrainingMaterialVo vo = map.get(materialId).get(0);
                usingTrainList.add(vo);
            }
            List userIdList = usingTrainList.stream().map(TrainingMaterial::getCreater).distinct().collect(Collectors.toList());
            BaseResult simplePojoBaseList = this.userApi.getSimpleUserByIdList(userIdList);
            if (simplePojoBaseList != null) {
                String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
                String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
                String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
                String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
                Map simplePojoMap = ((List)simplePojoBaseList.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
                for (TrainingMaterialVo trainingMaterialVo : usingTrainList) {
                    SimplePojo pojo = (SimplePojo)simplePojoMap.get(trainingMaterialVo.getCreater());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                        trainingMaterialVo.setCreateName(pojo.getName());
                    }
                    if ("train".equals(trainingMaterialVo.getModulName())) {
                        trainingMaterialVo.setModulName(trainName);
                        continue;
                    }
                    if ("job".equals(trainingMaterialVo.getModulName())) {
                        trainingMaterialVo.setModulName(jobName);
                        continue;
                    }
                    if ("learn".equals(trainingMaterialVo.getModulName())) {
                        trainingMaterialVo.setModulName(learnName);
                        continue;
                    }
                    if (!"course".equals(trainingMaterialVo.getModulName())) continue;
                    trainingMaterialVo.setModulName(courseName);
                }
            }
        }
        return usingTrainList;
    }

    @Override
    public List<TrainingMaterialVo> getUsingMaterialList(TrainingMaterialVo trainingMaterialVo, Users user) {
        List<TrainingMaterialVo> trainingMaterialVoList;
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List<Integer> materialIdList = Collections.singletonList(trainingMaterialVo.getId());
        List<Object> usingTrainList = Lists.newArrayList();
        if ((trainingMaterialVo.getModuleType() == null || trainingMaterialVo.getModuleType().equals(1)) && !CollectionUtils.isEmpty(trainingMaterialVoList = this.materialMapper.selectUsingMaterialByTrain(materialIdList, user.getGroupId()))) {
            String trainName = this.messageSource.getMessage("training.job.train.name", null, locale);
            for (TrainingMaterialVo trainingMaterialVo2 : trainingMaterialVoList) {
                trainingMaterialVo2.setModulName(trainName);
                usingTrainList.add(trainingMaterialVo2);
            }
        }
        if ((trainingMaterialVo.getModuleType() == null || trainingMaterialVo.getModuleType().equals(2)) && !CollectionUtils.isEmpty(trainingMaterialVoList = this.materialMapper.selectUsingMaterialByLearn(materialIdList, user.getGroupId()))) {
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            for (TrainingMaterialVo trainingMaterialVo3 : trainingMaterialVoList) {
                trainingMaterialVo3.setModulName(learnName);
                usingTrainList.add(trainingMaterialVo3);
            }
        }
        if ((trainingMaterialVo.getModuleType() == null || trainingMaterialVo.getModuleType().equals(3)) && !CollectionUtils.isEmpty(trainingMaterialVoList = this.materialMapper.selectUsingMaterialByJob(materialIdList, user.getGroupId()))) {
            String jobName = this.messageSource.getMessage("training.job.job.name", null, locale);
            for (TrainingMaterialVo trainingMaterialVo4 : trainingMaterialVoList) {
                trainingMaterialVo4.setModulName(jobName);
                usingTrainList.add(trainingMaterialVo4);
            }
        }
        if ((trainingMaterialVo.getModuleType() == null || trainingMaterialVo.getModuleType().equals(4)) && !CollectionUtils.isEmpty(trainingMaterialVoList = this.materialMapper.selectUsingMaterialByCourse(materialIdList, user.getGroupId()))) {
            String courseName = this.messageSource.getMessage("training.job.course.name", null, locale);
            for (TrainingMaterialVo trainingMaterialVo5 : trainingMaterialVoList) {
                trainingMaterialVo5.setModulName(courseName);
                usingTrainList.add(trainingMaterialVo5);
            }
        }
        if (trainingMaterialVo.getModuleType() == null || trainingMaterialVo.getModuleType().equals(5)) {
            MeterialPojo meterialPojo = new MeterialPojo();
            meterialPojo.setIds(materialIdList);
            meterialPojo.setType(Integer.valueOf(2));
            com.ovopark.pojo.BaseResult shopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
            if (shopViewBase != null && !CollectionUtils.isEmpty((Collection)((Collection)shopViewBase.getData()))) {
                String moduleName = this.messageSource.getMessage("training.material.module.name", null, locale);
                List list = (List)shopViewBase.getData();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    for (MeterialDbviewVO vo : list) {
                        TrainingMaterialVo materialVo = new TrainingMaterialVo();
                        materialVo.setModulName(moduleName);
                        materialVo.setMaterialName(vo.getMaterialName());
                        materialVo.setTaskName(vo.getDbviewshopName());
                        materialVo.setId(vo.getMaterialId());
                        materialVo.setCreater(vo.getCreater());
                        materialVo.setCreateTime(vo.getCreateTime());
                        usingTrainList.add(materialVo);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)usingTrainList)) {
            usingTrainList = usingTrainList.stream().sorted(Comparator.comparing(TrainingMaterial::getCreateTime).reversed()).collect(Collectors.toList());
            List<Integer> userIdList = usingTrainList.stream().map(TrainingMaterial::getCreater).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdList);
            for (TrainingMaterialVo trainingMaterialVo6 : usingTrainList) {
                UsersPojo pojo = userMap.get(trainingMaterialVo6.getCreater());
                if (ObjectUtils.isEmpty((Object)pojo)) continue;
                trainingMaterialVo6.setCreateName(pojo.getShowName());
            }
        }
        return usingTrainList;
    }

    @Override
    public Map selectAllSearch(Integer enterpriseId, String title, Users user) {
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        HashMap map = new HashMap();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), Training::getEnterpriseId, (Object)enterpriseId);
        ((LambdaQueryWrapper)wrapper1.eq(Training::getStatus, (Object)2)).eq(Training::getIsDel, (Object)0);
        wrapper1.and(wq -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(Training::getProjectShow, (Object)5)).or()).isNull(Training::getProjectShow);
        });
        wrapper1.last(" and upper(title) like upper('%" + title + "%' )" + "ORDER BY id DESC");
        List trainingList = this.trainingMapper.selectList((Wrapper)wrapper1);
        List<Integer> trainingIdSearch = trainingList.stream().map(Training::getId).distinct().collect(Collectors.toList());
        ArrayList<TrainingsVo> trainingVoList = new ArrayList<TrainingsVo>();
        Map<Object, Object> searchTrainingChapterHashMap = new HashMap();
        if (!org.springframework.util.StringUtils.isEmpty((Object)title)) {
            LambdaQueryWrapper trainingChapterLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingChapterLambdaQueryWrapper.select(new SFunction[]{TrainingChapter::getTrainingId, TrainingChapter::getName});
            ((LambdaQueryWrapper)trainingChapterLambdaQueryWrapper.isNotNull(TrainingChapter::getTrainingId)).eq(TrainingChapter::getIsDel, (Object)0);
            trainingChapterLambdaQueryWrapper.last(" and upper(name) like upper('%" + title + "%' )");
            List trainingChapterList = this.trainingChapterMapper.selectList((Wrapper)trainingChapterLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingChapterList)) {
                searchTrainingChapterHashMap = trainingChapterList.stream().collect(Collectors.groupingBy(TrainingChapter::getTrainingId));
            }
        }
        Map<Object, Object> searchTrainingChapterAttachHashMap = new HashMap();
        Map<Object, Object> searchTrainingAttachHashMap = new HashMap();
        if (!org.springframework.util.StringUtils.isEmpty((Object)title)) {
            List<SelectTrainingAttachVo> selectTrainingAttachVoList = this.trainingMapper.selectTrainingAttach(title);
            if (!CollectionUtils.isEmpty(selectTrainingAttachVoList)) {
                searchTrainingChapterAttachHashMap = selectTrainingAttachVoList.stream().collect(Collectors.toMap(SelectTrainingAttachVo::getTrainingId, e -> new ArrayList<String>(Arrays.asList(e.getFileName())), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper trainingAttachWrapper = new LambdaQueryWrapper();
            trainingAttachWrapper.select(new SFunction[]{TrainingAttach::getName, TrainingAttach::getTrainingId});
            trainingAttachWrapper.last(" where upper(name) like upper('%" + title + "%' )");
            List trainingAttachList = this.trainingAttachMapper.selectList((Wrapper)trainingAttachWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingAttachList)) {
                searchTrainingAttachHashMap = trainingAttachList.stream().collect(Collectors.groupingBy(TrainingAttach::getTrainingId));
            }
        }
        Set trainingIdSet = searchTrainingChapterAttachHashMap.keySet();
        Set trainingIdSet2 = searchTrainingChapterHashMap.keySet();
        Set trainingIdSet3 = searchTrainingAttachHashMap.keySet();
        HashSet trainingIdSet4 = new HashSet(trainingIdSet);
        trainingIdSet4.addAll(trainingIdSet2);
        trainingIdSet4.addAll(trainingIdSet3);
        if (!trainingIdSet4.isEmpty()) {
            LambdaQueryWrapper trainingLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingLambdaQueryWrapper.in(Training::getId, trainingIdSet4);
            trainingLambdaQueryWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), Training::getEnterpriseId, (Object)enterpriseId);
            ((LambdaQueryWrapper)trainingLambdaQueryWrapper.eq(Training::getStatus, (Object)2)).eq(Training::getIsDel, (Object)0);
            trainingLambdaQueryWrapper.and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(Training::getProjectShow, (Object)5)).or()).isNull(Training::getProjectShow);
            });
            List trainingList2 = this.trainingMapper.selectList((Wrapper)trainingLambdaQueryWrapper);
            if (!Objects.isNull(trainingList2) && !trainingList2.isEmpty()) {
                trainingList.addAll(trainingList2);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(trainingList = (List)trainingList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Training>(Comparator.comparing(Training::getId))), ArrayList::new))))) {
            List trainingIds = trainingList.stream().map(Training::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper5.in(TrainingAndMaterial::getTrainingId, (Collection)trainingIds)).isNotNull(TrainingAndMaterial::getMaterialId);
            List andMaterialList = this.andMaterialMapper.selectList((Wrapper)wrapper5);
            Map<Object, Object> map1 = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)andMaterialList)) {
                map1 = andMaterialList.stream().collect(Collectors.groupingBy(TrainingAndMaterial::getTrainingId));
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingUserLook::getTrainingId, (Collection)trainingIds);
            List userLookList = this.userLookMapper.selectList((Wrapper)wrapper3);
            boolean global = this.materialPermissionFacade.validGlobal(user, 1);
            Set<Object> validResourceIdSet = Collections.emptySet();
            Map<Object, Object> trainIdResourceIdMap = Collections.emptyMap();
            if (!global) {
                List<Integer> resourceIdList = this.resourceService.getIdListByTrainIdList(trainingIdSearch);
                validResourceIdSet = this.materialPermissionFacade.getValidResourceIdSet(user, 1, resourceIdList);
                trainIdResourceIdMap = this.resourceService.getTrainIdResourceIdMap(trainingIdSearch);
            }
            for (Training training : trainingList) {
                Integer resourceId;
                if (!global && !validResourceIdSet.contains(resourceId = (Integer)trainIdResourceIdMap.get(training.getId()))) continue;
                TrainingsVo vo = new TrainingsVo();
                BeanUtils.copyProperties((Object)training, (Object)vo);
                vo.setTrainingNameSearch(Boolean.valueOf(trainingIdSearch.contains(training.getId())));
                if (searchTrainingChapterHashMap.containsKey(training.getId())) {
                    vo.setTrainingChapterSearch(((List)searchTrainingChapterHashMap.get(training.getId())).stream().map(TrainingChapter::getName).collect(Collectors.toList()));
                } else {
                    vo.setTrainingChapterSearch(new ArrayList());
                }
                if (searchTrainingChapterAttachHashMap.containsKey(training.getId()) || searchTrainingAttachHashMap.containsKey(training.getId())) {
                    ArrayList list = new ArrayList();
                    if (searchTrainingChapterAttachHashMap.containsKey(training.getId())) {
                        list.addAll((Collection)searchTrainingChapterAttachHashMap.get(training.getId()));
                    }
                    if (searchTrainingAttachHashMap.containsKey(training.getId())) {
                        list.addAll(((List)searchTrainingAttachHashMap.get(training.getId())).stream().map(TrainingAttach::getName).collect(Collectors.toList()));
                    }
                    vo.setTrainingChapterAttachSearch(list);
                } else {
                    vo.setTrainingChapterAttachSearch(new ArrayList());
                }
                List andMaterials = (List)map1.get(vo.getId());
                vo.setMaterialCount(Integer.valueOf(CollectionUtils.isEmpty((Collection)andMaterials) ? 0 : andMaterials.size()));
                vo.setStudyCount(vo.getViewCount());
                trainingVoList.add(vo);
            }
        }
        if (!CollectionUtils.isEmpty(trainingVoList)) {
            for (Training training : trainingList) {
                if (org.springframework.util.StringUtils.isEmpty((Object)training.getPath()) || training.getPath().startsWith("http")) continue;
                training.setPath(ImageUtil.makePicUrlNew(training.getPath()));
            }
        }
        map.put("trainingList", trainingVoList);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), TrainingMaterial::getEnterpriseId, (Object)enterpriseId)).like(TrainingMaterial::getMaterialName, (Object)title);
        if (!"h5".equalsIgnoreCase(clientName) && version.compareTo("4.48.01") < 0) {
            wrapper2.ne(TrainingMaterial::getIsCommodity, (Object)1);
        }
        wrapper2.eq(TrainingMaterial::getIsDel, (Object)0);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterial::getIsUsing, (Object)1)).eq(TrainingMaterial::getIsShow, (Object)1)).orderByDesc(TrainingMaterial::getId);
        ArrayList materialList = this.materialMapper.selectList((Wrapper)wrapper2);
        if (!this.commonRemoteService.isSuper(user.getId()).booleanValue() && !CollectionUtils.isEmpty((Collection)materialList)) {
            Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
            if (!CollectionUtils.isEmpty(validMaterialTypeIdSet)) {
                ArrayList<TrainingMaterial> delMaterialList = new ArrayList<TrainingMaterial>();
                for (TrainingMaterial trainingMaterial : materialList) {
                    if (validMaterialTypeIdSet.contains(trainingMaterial.getMaterialTypeId())) continue;
                    delMaterialList.add(trainingMaterial);
                }
                materialList.retainAll(delMaterialList);
            } else {
                materialList = new ArrayList();
            }
        }
        map.put("materialList", materialList);
        return map;
    }

    @Override
    public Page<TrainingsVo> selectAllSearchByTrainingByPage(Page<TrainingsVo> page, Integer enterpriseId, String title, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), Training::getEnterpriseId, (Object)enterpriseId);
        ((LambdaQueryWrapper)wrapper1.eq(Training::getStatus, (Object)2)).eq(Training::getIsDel, (Object)0);
        wrapper1.and(wq -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(Training::getProjectShow, (Object)5)).or()).isNull(Training::getProjectShow);
        });
        wrapper1.last(" and upper(title) like upper('%" + title + "%' )" + "ORDER BY id DESC");
        List trainingList = this.trainingMapper.selectList((Wrapper)wrapper1);
        List<Integer> trainingIdSearch = trainingList.stream().map(Training::getId).distinct().collect(Collectors.toList());
        Map<Object, Object> searchTrainingChapterHashMap = new HashMap();
        if (!org.springframework.util.StringUtils.isEmpty((Object)title)) {
            LambdaQueryWrapper trainingChapterLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingChapterLambdaQueryWrapper.select(new SFunction[]{TrainingChapter::getTrainingId, TrainingChapter::getName});
            ((LambdaQueryWrapper)trainingChapterLambdaQueryWrapper.isNotNull(TrainingChapter::getTrainingId)).eq(TrainingChapter::getIsDel, (Object)0);
            trainingChapterLambdaQueryWrapper.last(" and upper(name) like upper('%" + title + "%' )");
            List trainingChapterList = this.trainingChapterMapper.selectList((Wrapper)trainingChapterLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingChapterList)) {
                searchTrainingChapterHashMap = trainingChapterList.stream().collect(Collectors.groupingBy(TrainingChapter::getTrainingId));
            }
        }
        Map<Object, Object> searchTrainingChapterAttachHashMap = new HashMap();
        Map<Object, Object> searchTrainingAttachHashMap = new HashMap();
        if (!org.springframework.util.StringUtils.isEmpty((Object)title)) {
            List<SelectTrainingAttachVo> selectTrainingAttachVoList = this.trainingMapper.selectTrainingAttach(title);
            if (!CollectionUtils.isEmpty(selectTrainingAttachVoList)) {
                searchTrainingChapterAttachHashMap = selectTrainingAttachVoList.stream().collect(Collectors.toMap(SelectTrainingAttachVo::getTrainingId, e -> new ArrayList<String>(Arrays.asList(e.getFileName())), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            LambdaQueryWrapper trainingAttachWrapper = new LambdaQueryWrapper();
            trainingAttachWrapper.select(new SFunction[]{TrainingAttach::getName, TrainingAttach::getTrainingId});
            trainingAttachWrapper.last(" where upper(name) like upper('%" + title + "%' )");
            List trainingAttachList = this.trainingAttachMapper.selectList((Wrapper)trainingAttachWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingAttachList)) {
                searchTrainingAttachHashMap = trainingAttachList.stream().collect(Collectors.groupingBy(TrainingAttach::getTrainingId));
            }
        }
        Set trainingIdSet = searchTrainingChapterAttachHashMap.keySet();
        Set trainingIdSet2 = searchTrainingChapterHashMap.keySet();
        Set trainingIdSet3 = searchTrainingAttachHashMap.keySet();
        HashSet trainingIdSet4 = new HashSet(trainingIdSet);
        trainingIdSet4.addAll(trainingIdSet2);
        trainingIdSet4.addAll(trainingIdSet3);
        if (!trainingIdSet4.isEmpty()) {
            LambdaQueryWrapper trainingLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingLambdaQueryWrapper.in(Training::getId, trainingIdSet4);
            trainingLambdaQueryWrapper.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), Training::getEnterpriseId, (Object)enterpriseId);
            ((LambdaQueryWrapper)trainingLambdaQueryWrapper.eq(Training::getStatus, (Object)2)).eq(Training::getIsDel, (Object)0);
            trainingLambdaQueryWrapper.and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.eq(Training::getProjectShow, (Object)5)).or()).isNull(Training::getProjectShow);
            });
            List trainingList2 = this.trainingMapper.selectList((Wrapper)trainingLambdaQueryWrapper);
            if (!Objects.isNull(trainingList2) && !trainingList2.isEmpty()) {
                trainingList.addAll(trainingList2);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(trainingList = (List)trainingList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Training>(Comparator.comparing(Training::getId))), ArrayList::new))))) {
            List<TrainingsVo> trainingVoList = new ArrayList();
            boolean global = this.materialPermissionFacade.validGlobal(user, 1);
            Set<Object> validResourceIdSet = Collections.emptySet();
            Map<Object, Object> trainIdResourceIdMap = Collections.emptyMap();
            if (!global) {
                List<Integer> resourceIdList = this.resourceService.getIdListByTrainIdList(trainingIdSearch);
                validResourceIdSet = this.materialPermissionFacade.getValidResourceIdSet(user, 1, resourceIdList);
                trainIdResourceIdMap = this.resourceService.getTrainIdResourceIdMap(trainingIdSearch);
            }
            for (Training training : trainingList) {
                Integer resourceId;
                if (!global && !validResourceIdSet.contains(resourceId = (Integer)trainIdResourceIdMap.get(training.getId()))) continue;
                TrainingsVo vo = new TrainingsVo();
                BeanUtils.copyProperties((Object)training, (Object)vo);
                trainingVoList.add(vo);
            }
            if (!CollectionUtils.isEmpty(trainingVoList = (page = ListUtil.myPage(trainingVoList, page.getPageNumber(), page.getPageSize())).getContent())) {
                List trainingIds = trainingVoList.stream().map(Training::getId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper5 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper5.in(TrainingAndMaterial::getTrainingId, trainingIds)).isNotNull(TrainingAndMaterial::getMaterialId);
                List andMaterialList = this.andMaterialMapper.selectList((Wrapper)wrapper5);
                Map<Object, Object> map1 = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)andMaterialList)) {
                    map1 = andMaterialList.stream().collect(Collectors.groupingBy(TrainingAndMaterial::getTrainingId));
                }
                for (TrainingsVo vo : trainingVoList) {
                    if (trainingIdSearch.contains(vo.getId())) {
                        vo.setTrainingNameSearch(Boolean.valueOf(true));
                    } else {
                        vo.setTrainingNameSearch(Boolean.valueOf(false));
                    }
                    if (searchTrainingChapterHashMap.containsKey(vo.getId())) {
                        vo.setTrainingChapterSearch(((List)searchTrainingChapterHashMap.get(vo.getId())).stream().map(TrainingChapter::getName).collect(Collectors.toList()));
                    } else {
                        vo.setTrainingChapterSearch(new ArrayList());
                    }
                    if (searchTrainingChapterAttachHashMap.containsKey(vo.getId()) || searchTrainingAttachHashMap.containsKey(vo.getId())) {
                        ArrayList list = new ArrayList();
                        if (searchTrainingChapterAttachHashMap.containsKey(vo.getId())) {
                            list.addAll((Collection)searchTrainingChapterAttachHashMap.get(vo.getId()));
                        }
                        if (searchTrainingAttachHashMap.containsKey(vo.getId())) {
                            list.addAll(((List)searchTrainingAttachHashMap.get(vo.getId())).stream().map(TrainingAttach::getName).collect(Collectors.toList()));
                        }
                        vo.setTrainingChapterAttachSearch(list);
                    } else {
                        vo.setTrainingChapterAttachSearch(new ArrayList());
                    }
                    List andMaterials = (List)map1.get(vo.getId());
                    vo.setMaterialCount(Integer.valueOf(CollectionUtils.isEmpty((Collection)andMaterials) ? 0 : andMaterials.size()));
                    vo.setStudyCount(vo.getViewCount());
                }
                page.setContent(trainingVoList);
            }
        }
        return page;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Page<TrainingMaterial> selectAllSearchByMaterialByPage(Page<TrainingMaterial> page, Integer enterpriseId, String title, Users user) {
        void var5_8;
        ArrayList arrayList = new ArrayList();
        boolean global = this.materialPermissionFacade.validGlobal(user, 1);
        if (!global) {
            Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, 1);
            if (CollectionUtils.isEmpty(validMaterialTypeIdSet)) return page;
            List<TrainingMaterial> list = this.materialMapper.selectMaterialsByPage(page, enterpriseId, Lists.newArrayList(validMaterialTypeIdSet), title);
        } else {
            List<TrainingMaterial> list = this.materialMapper.selectMaterialsByPage(page, enterpriseId, null, title);
        }
        page.setContent((List)var5_8);
        return page;
    }

    @Override
    public void saveMaterialName(TrainingMaterial material, Users user) {
        material.setUpdater(user.getId());
        material.setUpdateTime(new Date());
        this.materialMapper.updateById(material);
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper1.eq(TrainingChapterAttach::getMaterialId, (Object)material.getId())).eq(TrainingChapterAttach::getIsDel, (Object)0);
        TrainingChapterAttach chapterAttach = new TrainingChapterAttach();
        chapterAttach.setFileName(material.getMaterialName());
        this.chapterAttachMapper.update(chapterAttach, (Wrapper)wrapper1);
        LambdaUpdateWrapper wrapper6 = new LambdaUpdateWrapper();
        wrapper6.eq(TrainingAttach::getMaterialId, (Object)material.getId());
        TrainingAttach attach = new TrainingAttach();
        attach.setName(material.getMaterialName());
        this.attachMapper.update(attach, (Wrapper)wrapper6);
        LambdaUpdateWrapper wrapper7 = new LambdaUpdateWrapper();
        wrapper7.eq(TrainingVideo::getMaterialId, (Object)material.getId());
        TrainingVideo video = new TrainingVideo();
        video.setFileName(material.getMaterialName());
        this.videoMapper.update(video, (Wrapper)wrapper7);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingTaskSchedule::getMaterialId, (Object)material.getId());
        List scheduleList = this.taskScheduleMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
            LambdaUpdateWrapper wrapper8 = new LambdaUpdateWrapper();
            wrapper8.eq(TrainingTaskSchedule::getMaterialId, (Object)material.getId());
            TrainingTaskSchedule schedule = new TrainingTaskSchedule();
            schedule.setTaskName(material.getMaterialName());
            this.taskScheduleMapper.update(schedule, (Wrapper)wrapper8);
            List scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getTaskId).distinct().collect(Collectors.toList());
            LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
            wrapper3.in(TrainingProjectTask::getId, scheduleIds);
            TrainingProjectTask projectTask = new TrainingProjectTask();
            projectTask.setTaskName(material.getMaterialName());
            this.projectTaskMapper.update(projectTask, (Wrapper)wrapper3);
        }
        LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper4.eq(TrainingJobStageTask::getMaterialId, (Object)material.getId())).eq(TrainingJobStageTask::getTaskType, (Object)5);
        TrainingJobStageTask jobStageTask = new TrainingJobStageTask();
        jobStageTask.setTaskName(material.getMaterialName());
        this.jobStageTaskMapper.update(jobStageTask, (Wrapper)wrapper4);
        LambdaUpdateWrapper wrapper5 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper5.eq(TrainingCourseStageTask::getMaterialId, (Object)material.getId())).eq(TrainingCourseStageTask::getTaskType, (Object)5);
        TrainingCourseStageTask courseStageTask = new TrainingCourseStageTask();
        courseStageTask.setTaskName(material.getMaterialName());
        this.courseStageTaskMapper.update(courseStageTask, (Wrapper)wrapper5);
    }

    @Override
    public void saveMaterialCompression(TrainingMaterial material, Users user) {
        if (!ObjectUtils.isEmpty((Object)(material = (TrainingMaterial)this.materialMapper.selectById(material.getId()))) && !org.springframework.util.StringUtils.isEmpty((Object)material.getMaterialPath()) && !org.springframework.util.StringUtils.isEmpty((Object)material.getIsVideo()) && material.getIsVideo() == 1 && !org.springframework.util.StringUtils.isEmpty((Object)material.getSize()) && (!org.springframework.util.StringUtils.isEmpty((Object)material.getDuration()) && material.getDuration().compareTo(0) > 0 && new BigDecimal(material.getSize()).divide(new BigDecimal(material.getDuration()), 0, 4).compareTo(new BigDecimal(393216)) >= 0 || org.springframework.util.StringUtils.isEmpty((Object)material.getDuration()) && material.getSize().compareTo(0x1400000) >= 0 || material.getIsFormat() != null && material.getIsFormat() == 0)) {
            VideoCompressionsUtil.videoCompression(material.getMaterialPath(), material.getId(), this.videoCompressionUrl, this.token, material.getMaterialName(), this.callbackUrl, user.getGroupId());
        }
    }

    @Override
    public String updateMaterialSortByDrag(Users user, TrainingMaterialTypeVo trainingMaterialTypeVo) {
        List trainingMaterialTypeIds;
        Date now = new Date();
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeVo.getTrainingMaterialTypeList()) && !CollectionUtils.isEmpty(trainingMaterialTypeIds = trainingMaterialTypeVo.getTrainingMaterialTypeList().stream().map(TrainingMaterialType::getId).filter(Objects::nonNull).collect(Collectors.toList()))) {
            Integer showOrder = trainingMaterialTypeVo.getShowOrder() != null ? trainingMaterialTypeVo.getShowOrder() : 1;
            Integer materialTypeLevel = trainingMaterialTypeVo.getMaterialTypeLevel();
            Integer moduleType2 = trainingMaterialTypeVo.getModuleType();
            Integer sourceId = trainingMaterialTypeVo.getSourceId();
            Integer handleTypeId = (Integer)trainingMaterialTypeIds.get(0);
            TrainingMaterialType handleType = (TrainingMaterialType)this.materialTypeMapper.selectById(handleTypeId);
            materialTypeLevel = handleType.getMaterialTypeLevel();
            if (trainingMaterialTypeIds.size() > 1) {
                Integer moveType = trainingMaterialTypeVo.getMoveType() != null ? trainingMaterialTypeVo.getMoveType() : 1;
                Integer sort1 = handleType.getSort();
                TrainingMaterialType trainingMaterialType2 = (TrainingMaterialType)this.materialTypeMapper.selectById((Serializable)trainingMaterialTypeIds.get(1));
                if (!trainingMaterialType2.getMaterialTypeLevel().equals(materialTypeLevel)) {
                    return JsonResult.error((String)"\u65e0\u6cd5\u8de8\u7236\u7ea7\u5206\u7c7b\u79fb\u52a8\u987a\u5e8f", null);
                }
                Integer sort2 = trainingMaterialType2.getSort();
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.set(TrainingMaterialType::getSort, (Object)sort2)).set(TrainingMaterialType::getUpdater, (Object)user.getId())).set(TrainingMaterialType::getUpdateTime, (Object)now);
                wrapper1.eq(TrainingMaterialType::getId, (Object)handleType.getId());
                this.materialTypeMapper.update(null, (Wrapper)wrapper1);
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper2.set(TrainingMaterialType::getUpdater, (Object)user.getId())).set(TrainingMaterialType::getUpdateTime, (Object)now);
                if (moveType == 1) {
                    if (showOrder == 1) {
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort + 1")).le(TrainingMaterialType::getSort, (Object)sort1)).ge(TrainingMaterialType::getSort, (Object)sort2);
                    } else {
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort - 1")).le(TrainingMaterialType::getSort, (Object)sort2)).ge(TrainingMaterialType::getSort, (Object)sort1);
                    }
                } else if (showOrder == 1) {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort - 1")).ge(TrainingMaterialType::getSort, (Object)sort1)).le(TrainingMaterialType::getSort, (Object)sort2);
                } else {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort + 1")).ge(TrainingMaterialType::getSort, (Object)sort2)).le(TrainingMaterialType::getSort, (Object)sort1);
                }
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)materialTypeLevel)).ne(TrainingMaterialType::getId, (Object)handleType.getId())).eq(sourceId != null, TrainingMaterialType::getSourceId, (Object)sourceId);
                if (user.getGroupId() != null) {
                    wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId());
                } else if (handleType.getEnterpriseId() != null) {
                    wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)handleType.getEnterpriseId());
                } else {
                    wrapper2.isNull(TrainingMaterialType::getEnterpriseId);
                }
                this.materialTypeMapper.update(null, (Wrapper)wrapper2);
            } else {
                Integer isTop = trainingMaterialTypeVo.getIsTop();
                Integer moveType = trainingMaterialTypeVo.getMoveType();
                Integer sort1 = handleType.getSort();
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)materialTypeLevel)).eq(sourceId != null, TrainingMaterialType::getSourceId, (Object)sourceId);
                if (user.getGroupId() != null) {
                    wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId());
                } else {
                    wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
                }
                if (isTop != null && isTop == 1 || isTop == null && moveType != null && moveType == 2) {
                    if (showOrder == 1) {
                        if (isTop == null && moveType != null) {
                            ((LambdaQueryWrapper)wrapper1.ne(TrainingMaterialType::getId, (Object)handleType.getId())).ge(TrainingMaterialType::getSort, (Object)sort1);
                        }
                        ((LambdaQueryWrapper)wrapper1.orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
                    } else {
                        if (isTop == null && moveType != null) {
                            ((LambdaQueryWrapper)wrapper1.ne(TrainingMaterialType::getId, (Object)handleType.getId())).le(TrainingMaterialType::getSort, (Object)sort1);
                        }
                        ((LambdaQueryWrapper)wrapper1.orderByDesc(TrainingMaterialType::getSort)).orderByDesc(TrainingMaterialType::getId);
                    }
                } else if (showOrder == 1) {
                    if (isTop == null && moveType != null) {
                        ((LambdaQueryWrapper)wrapper1.ne(TrainingMaterialType::getId, (Object)handleType.getId())).le(TrainingMaterialType::getSort, (Object)sort1);
                    }
                    ((LambdaQueryWrapper)wrapper1.orderByDesc(TrainingMaterialType::getSort)).orderByDesc(TrainingMaterialType::getId);
                } else {
                    if (isTop == null && moveType != null) {
                        ((LambdaQueryWrapper)wrapper1.ne(TrainingMaterialType::getId, (Object)handleType.getId())).ge(TrainingMaterialType::getSort, (Object)sort1);
                    }
                    ((LambdaQueryWrapper)wrapper1.orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
                }
                List trainingMaterialTypes = this.materialTypeMapper.selectList((Wrapper)wrapper1);
                TrainingMaterialType trainingMaterialType2 = (TrainingMaterialType)trainingMaterialTypes.get(0);
                Integer sort2 = trainingMaterialType2.getSort();
                LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper3.set(TrainingMaterialType::getSort, (Object)sort2)).set(TrainingMaterialType::getUpdater, (Object)user.getId())).set(TrainingMaterialType::getUpdateTime, (Object)now);
                wrapper3.eq(TrainingMaterialType::getId, (Object)handleType.getId());
                this.materialTypeMapper.update(null, (Wrapper)wrapper3);
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper2.set(TrainingMaterialType::getUpdater, (Object)user.getId())).set(TrainingMaterialType::getUpdateTime, (Object)now);
                if (isTop != null && isTop == 1 || isTop == null && moveType != null && moveType == 1) {
                    if (showOrder == 1) {
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort + 1")).le(TrainingMaterialType::getSort, (Object)sort1)).ge(TrainingMaterialType::getSort, (Object)sort2);
                    } else {
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort - 1")).le(TrainingMaterialType::getSort, (Object)sort2)).ge(TrainingMaterialType::getSort, (Object)sort1);
                    }
                } else if (showOrder == 1) {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort - 1")).ge(TrainingMaterialType::getSort, (Object)sort1)).le(TrainingMaterialType::getSort, (Object)sort2);
                } else {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.setSql(" sort = sort + 1")).ge(TrainingMaterialType::getSort, (Object)sort2)).le(TrainingMaterialType::getSort, (Object)sort1);
                }
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialType::getModuleType, (Object)moduleType2)).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)materialTypeLevel)).ne(TrainingMaterialType::getId, (Object)handleType.getId())).eq(sourceId != null, TrainingMaterialType::getSourceId, (Object)sourceId);
                if (user.getGroupId() != null) {
                    wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId());
                } else if (handleType.getEnterpriseId() != null) {
                    wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)handleType.getEnterpriseId());
                } else {
                    wrapper2.isNull(TrainingMaterialType::getEnterpriseId);
                }
                this.materialTypeMapper.update(null, (Wrapper)wrapper2);
            }
        }
        return JsonResult.success();
    }

    @Override
    public void updateMaterialPictureShow(List<TrainingMaterial> materials, Users user) {
        if (!CollectionUtils.isEmpty(materials)) {
            List materialIds = materials.stream().map(TrainingMaterial::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.in(TrainingMaterialProductPicture::getMaterialId, materialIds)).eq(TrainingMaterialProductPicture::getPictureType, (Object)1);
            List pictureList = this.materialProductPictureMapper.selectList((Wrapper)wrapper1);
            materialIds = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)pictureList)) {
                materialIds = pictureList.stream().map(TrainingMaterialProductPicture::getMaterialId).distinct().collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(materialIds)) {
                Date now = new Date();
                for (TrainingMaterial material : materials) {
                    if (!materialIds.contains(material.getId())) continue;
                    material.setUpdateTime(now);
                    material.setUpdater(user.getId());
                    this.materialMapper.updateById(material);
                }
            }
        }
    }

    @Override
    public TrainingMaterialVo selectMaterialDetail(TrainingMaterialVo materialVo, Users user) {
        TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
        if (!ObjectUtils.isEmpty((Object)material)) {
            TrainingMaterialType trainingMaterialType;
            BeanUtils.copyProperties((Object)material, (Object)materialVo);
            if (material.getMaterialTypeId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterialType = (TrainingMaterialType)this.materialTypeMapper.selectById(material.getMaterialTypeId())))) {
                materialVo.setMaterialTypeName(trainingMaterialType.getMaterialTypeName());
                materialVo.setMaterialTypeLevel(trainingMaterialType.getMaterialTypeLevel());
                materialVo.setSourceId(trainingMaterialType.getSourceId());
                materialVo.setOriginId(trainingMaterialType.getOriginId());
            }
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialLecturer::getMaterialId, (Object)materialVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)1);
            List trainingMaterialLecturerList = this.materialLecturerMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialLecturerList)) {
                List lecturerIdList = trainingMaterialLecturerList.stream().map(TrainingMaterialLecturer::getLecturerId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List lecturerList = this.lecturerMapper.selectBatchIds(lecturerIdList);
                ArrayList<TrainingLecturerVo> lecturerVoList = new ArrayList<TrainingLecturerVo>();
                if (!CollectionUtils.isEmpty((Collection)lecturerList)) {
                    for (TrainingLecturer trainingLecturer : lecturerList) {
                        TrainingLecturerVo trainingLecturerVo = new TrainingLecturerVo();
                        BeanUtils.copyProperties((Object)trainingLecturer, (Object)trainingLecturerVo);
                        lecturerVoList.add(trainingLecturerVo);
                    }
                }
                materialVo.setLecturerVoList(lecturerVoList);
            }
        }
        return materialVo;
    }

    @Override
    public String updateChangeMaterialVersion(final TrainingMaterialVo materialVo, final Users user) {
        boolean valid = this.materialPermissionFacade.validMaterialTypeId(user, 3, materialVo.getMaterialTypeId());
        final TrainingMaterial materialOld = (TrainingMaterial)this.materialMapper.selectById(materialVo.getId());
        if (!ObjectUtils.isEmpty((Object)materialOld) && materialOld.getMaterialTypeId() != null && !valid) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power.update", null, locale), null);
        }
        Date now = new Date();
        if (!ObjectUtils.isEmpty((Object)materialOld)) {
            List lecturerVoList;
            if (!(org.springframework.util.StringUtils.isEmpty((Object)materialOld.getMaterialPath()) || org.springframework.util.StringUtils.isEmpty((Object)materialVo.getMaterialPath()) || materialOld.getMaterialPath().equals(materialVo.getMaterialPath()))) {
                TrainingMaterialVersion materialVersion = new TrainingMaterialVersion();
                BeanUtils.copyProperties((Object)materialOld, (Object)materialVersion);
                materialVersion.setId(null);
                materialVersion.setMaterialId(materialVo.getId());
                materialVersion.setCreater(user.getId());
                materialVersion.setCreateTime(now);
                this.trainingMaterialVersionMapper.insert(materialVersion);
            }
            final TrainingMaterial material = new TrainingMaterial();
            BeanUtils.copyProperties((Object)materialOld, (Object)material);
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getMaterialName())) {
                material.setMaterialName(materialVo.getMaterialName());
            }
            material.setMaterialTypeId(materialVo.getMaterialTypeId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getIsVideo())) {
                material.setIsVideo(materialVo.getIsVideo());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getSize())) {
                material.setSize(materialVo.getSize());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getDuration())) {
                material.setDuration(materialVo.getDuration());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getIsDownload())) {
                material.setIsDownload(materialVo.getIsDownload());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFinishTime())) {
                material.setFinishTime(materialVo.getFinishTime());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFinishRate())) {
                material.setFinishRate(materialVo.getFinishRate());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getIsFormat())) {
                material.setIsFormat(materialVo.getIsFormat());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)materialVo.getFileType())) {
                material.setFileType(materialVo.getFileType());
            }
            if (materialVo.getReadType() != null) {
                material.setReadType(materialVo.getReadType());
            }
            if (materialVo.getDownloadType() != null) {
                material.setDownloadType(materialVo.getDownloadType());
            }
            material.setUpdater(user.getId());
            material.setUpdateTime(now);
            material.setMaterialPath(materialVo.getMaterialPath());
            material.setOldPath(materialVo.getMaterialPath());
            if (!(org.springframework.util.StringUtils.isEmpty((Object)materialOld.getMaterialPath()) || org.springframework.util.StringUtils.isEmpty((Object)materialVo.getMaterialPath()) || materialOld.getMaterialPath().equals(materialVo.getMaterialPath()))) {
                material.setVersion(Integer.valueOf(materialOld.getVersion() + 1));
            }
            this.materialMapper.updateById(material);
            this.materialSinglePermissionService.updateMaterial(materialOld, materialVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialLecturer::getMaterialId, (Object)materialVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)1);
            List trainingMaterialLecturerList = this.materialLecturerMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialLecturerList)) {
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper2.eq(TrainingMaterialLecturer::getMaterialId, (Object)materialVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)1);
                this.materialLecturerMapper.delete((Wrapper)wrapper2);
            }
            if (!CollectionUtils.isEmpty((Collection)(lecturerVoList = materialVo.getLecturerVoList()))) {
                ArrayList<TrainingMaterialLecturer> materialLecturerList = new ArrayList<TrainingMaterialLecturer>();
                for (TrainingLecturerVo lecturerVo : lecturerVoList) {
                    TrainingMaterialLecturer materialLecturer = new TrainingMaterialLecturer();
                    materialLecturer.setType(Integer.valueOf(1));
                    materialLecturer.setMaterialId(materialVo.getId());
                    materialLecturer.setLecturerId(lecturerVo.getId());
                    materialLecturer.setEnterpriseId(user.getGroupId());
                    materialLecturer.setCreaterId(user.getId());
                    materialLecturer.setCreateTime(now);
                    materialLecturerList.add(materialLecturer);
                }
                this.materialLecturerMapper.insertList(materialLecturerList);
            }
            if (!ObjectUtils.isEmpty((Object)materialVo) && materialVo.getMaterialTypeId() != null) {
                TrainingMaterialType type = new TrainingMaterialType();
                type.setId(materialVo.getMaterialTypeId());
                type.setUpdateTime(now);
                type.setUpdater(user.getId());
                this.materialTypeMapper.updateById(type);
            }
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!(org.springframework.util.StringUtils.isEmpty((Object)materialOld.getMaterialPath()) || org.springframework.util.StringUtils.isEmpty((Object)materialVo.getMaterialPath()) || materialOld.getMaterialPath().equals(materialVo.getMaterialPath()))) {
                            TrainingMaterialServiceImpl.this.saveMaterialCompression(material, user);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u89c6\u9891\u538b\u7f29:", (Object)e.getMessage());
                    }
                    try {
                        Integer materialTypeId;
                        List<Integer> pushUserList;
                        Integer isPush = org.springframework.util.StringUtils.isEmpty((Object)materialVo.getIsPush()) ? 0 : materialVo.getIsPush();
                        if (!ObjectUtils.isEmpty((Object)material) && isPush == 1 && !CollectionUtils.isEmpty(pushUserList = TrainingMaterialServiceImpl.this.getMaterialTypePowerOwner(materialTypeId = material.getMaterialTypeId(), user))) {
                            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                            TrainingMaterialVo materialVo2 = new TrainingMaterialVo();
                            materialVo2.setId(material.getId());
                            materialVo2.setMaterialName(material.getMaterialName());
                            materialVo2.setIsVideo(material.getIsVideo());
                            materialVo2.setEnterpriseId(material.getEnterpriseId());
                            materialVo2.setCreateTime(material.getCreateTime());
                            materialVo2.setIsCommodity(material.getIsCommodity());
                            materialVo2.setMaterialPath(material.getMaterialPath());
                            materialVo2.setMaterialStatus(material.getMaterialStatus());
                            materialVo2.setTitle(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.title", null, locale));
                            String text = TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.update.content", new Object[]{materialVo2.getMaterialName()}, locale);
                            TaskMessageBody body = new TaskMessageBody();
                            body.setType(85);
                            body.setTaskJson(JSONObject.toJSONString((Object)materialVo2));
                            TrainingMaterialServiceImpl.this.jPushService.sendWebSocketAll(TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.title", null, locale), text, pushUserList, user.getGroupId(), materialVo2.getId(), "TYPE_MATERIAL_SYSTEM", JSONObject.toJSONString((Object)materialVo2), null, 0, 0, "training.material.update.content", materialVo2.getMaterialName());
                            TrainingMaterialServiceImpl.this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_MATERIAL_SYSTEM", pushUserList, TrainingMaterialServiceImpl.this.messageSource.getMessage("training.material.title", null, locale), text, body);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u7d20\u6750\u63a8\u9001:", (Object)e.getMessage());
                    }
                }
            });
        }
        return JsonResult.success();
    }

    @Override
    public Page<TrainingMaterialVersionVo> selectMaterialVersionByPage(Page<TrainingMaterialVersionVo> page, Integer materialId, Users user) {
        List<TrainingMaterialVersionVo> list = this.trainingMaterialVersionMapper.selectMaterialVersionByPage(page, materialId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> creaters = list.stream().map(TrainingMaterialVersion::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creaters);
            for (TrainingMaterialVersionVo vo : list) {
                UsersPojo pojo = pojoMap.get(vo.getCreater());
                if (ObjectUtils.isEmpty((Object)pojo)) continue;
                vo.setCreateName(pojo.getShowName());
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public String moveMaterialType(Integer currentId, Integer targetId, Integer isFirst, Users user) {
        List materialTypeList = this.materialTypeMapper.selectList((Wrapper)new QueryWrapper());
        TrainingMaterialType materialType1 = (TrainingMaterialType)this.materialTypeMapper.selectById(currentId);
        Integer preExtendPass = materialType1.getExtendPass();
        int sourceLevel = materialType1.getMaterialTypeLevel();
        Integer preSourceId = materialType1.getSourceId();
        TrainingMaterialType targetSourceType = (TrainingMaterialType)this.materialTypeMapper.selectById(targetId);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        boolean flag = false;
        flag = this.commonRemoteService.isSuper(user.getId()) != false || materialType1.getModuleType() != 1 ? true : this.materialPermissionFacade.validMaterialTypeId(user, 3, targetId);
        if (flag) {
            int materialTypeLevel2 = 0;
            List trainingMaterialTypeList = new ArrayList();
            if (Objects.nonNull(targetSourceType)) {
                materialTypeLevel2 = targetSourceType.getMaterialTypeLevel();
                String materialName1 = materialType1.getMaterialTypeName();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(TrainingMaterialType::getSourceId, (Object)targetId)).orderByDesc(TrainingMaterialType::getSort);
                trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)queryWrapper);
                List materialName2List = trainingMaterialTypeList.stream().map(TrainingMaterialType::getMaterialTypeName).collect(Collectors.toList());
                if (materialName2List.contains(materialName1)) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.level.same.name", null, locale), null);
                }
            } else {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(TrainingMaterialType::getModuleType, (Object)materialType1.getModuleType())).eq(TrainingMaterialType::getMaterialTypeLevel, (Object)1);
                if (materialType1.getEnterpriseId() != null) {
                    queryWrapper.eq(TrainingMaterialType::getEnterpriseId, (Object)materialType1.getEnterpriseId());
                } else {
                    queryWrapper.isNull(TrainingMaterialType::getEnterpriseId);
                }
                queryWrapper.orderByDesc(TrainingMaterialType::getSort);
                trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)queryWrapper);
                List materialName2List = trainingMaterialTypeList.stream().map(TrainingMaterialType::getMaterialTypeName).collect(Collectors.toList());
                if (materialName2List.contains(materialType1.getMaterialTypeName())) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.level.same.name", null, locale), null);
                }
            }
            if (isFirst == 0) {
                Integer parentId2;
                Integer parentId1 = preSourceId;
                if (parentId1 == null) {
                    parentId1 = 0;
                }
                if ((parentId2 = targetSourceType.getId()) == null) {
                    parentId2 = 0;
                }
                if (parentId1.compareTo(parentId2) == 0) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.parent", null, locale), null);
                }
                int currentLastLevel = this.getLastLevel(currentId);
                if (currentLastLevel - sourceLevel + 1 + materialTypeLevel2 > 5) {
                    return JsonResult.error((String)this.messageSource.getMessage("training.material.level.limit", null, locale), null);
                }
                materialType1.setSourceId(targetSourceType.getId());
                materialType1.setOriginId(targetSourceType.getOriginId());
                if (!CollectionUtils.isEmpty(trainingMaterialTypeList)) {
                    materialType1.setSort(Integer.valueOf(((TrainingMaterialType)trainingMaterialTypeList.get(0)).getSort() + 1));
                } else {
                    materialType1.setSort(Integer.valueOf(1));
                }
                materialType1.setSourceId(targetSourceType.getId());
                if (targetSourceType.getMaterialTypeLevel() == 1) {
                    materialType1.setOriginId(targetSourceType.getId());
                } else {
                    materialType1.setOriginId(targetSourceType.getOriginId());
                }
                materialType1.setMaterialTypeLevel(Integer.valueOf(targetSourceType.getMaterialTypeLevel() + 1));
                materialType1.setIdPath(this.materialTypeService.buildIdPath(materialType1));
                this.materialTypeMapper.updateById(materialType1);
                int targetLevel = targetSourceType.getMaterialTypeLevel() + 1;
                int move = targetLevel - sourceLevel;
                this.updateMaterialTypeLevel(materialTypeList, currentId, targetSourceType, move);
            } else {
                Integer sort = 1;
                if (!CollectionUtils.isEmpty(trainingMaterialTypeList)) {
                    sort = ((TrainingMaterialType)trainingMaterialTypeList.get(0)).getSort() + 1;
                }
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.setSql(" source_id = null");
                updateWrapper.setSql(" origin_id = null");
                updateWrapper.setSql(" id_path = ''");
                updateWrapper.setSql(" material_type_level = 1");
                updateWrapper.setSql(" sort = " + sort);
                updateWrapper.eq(TrainingMaterialType::getId, (Object)materialType1.getId());
                this.materialTypeMapper.update(null, (Wrapper)updateWrapper);
                materialType1.setSourceId(null);
                materialType1.setOriginId(null);
                materialType1.setIdPath("");
                materialType1.setMaterialTypeLevel(Integer.valueOf(1));
                materialType1.setOptionExtend(Integer.valueOf(0));
                this.updateMaterialTypeLevel(materialTypeList, currentId, materialType1, 1 - sourceLevel);
            }
            this.materialTypeService.resetIdPathBySource(materialType1.getId());
            this.materialTypeService.processCoverExtend(materialType1);
            this.materialTypeService.updateExtendAndCoverAll(materialType1);
            Integer sourceId = materialType1.getSourceId();
            if (sourceId != null && materialType1.getExtend() == 1) {
                this.materialTypePermissionService.overridePermissionForExtend(sourceId, materialType1.getId());
            }
        } else {
            return JsonResult.error((String)this.messageSource.getMessage("training.material.not.power", null, locale), null);
        }
        this.materialTypeService.processChildExtendAndPermission(materialType1, preExtendPass);
        ArrayList statCountList = Lists.newArrayList();
        if (preSourceId != null) {
            statCountList.add(preSourceId);
        }
        if (targetSourceType != null) {
            statCountList.add(targetSourceType.getId());
        }
        EventHelper.sendMaterialTypeStatCountByMoveEvent(this, statCountList);
        return JsonResult.success();
    }

    private List<Integer> fillUpTypeId(List<Integer> typeIds, Map<Integer, TrainingMaterialType> trainingMaterialTypeMap, Integer typeId) {
        TrainingMaterialType trainingMaterialType = trainingMaterialTypeMap.get(typeId);
        if (ObjectUtils.isEmpty((Object)trainingMaterialType)) {
            return typeIds;
        }
        typeIds.add(trainingMaterialType.getId());
        if (trainingMaterialType.getSourceId() == null) {
            return typeIds;
        }
        this.fillUpTypeId(typeIds, trainingMaterialTypeMap, trainingMaterialType.getSourceId());
        return typeIds;
    }

    public void updateMaterialTypeLevel(List<TrainingMaterialType> materialTypeList, int currentId, TrainingMaterialType materialType2, int move) {
        List<TrainingMaterialType> children = this.getChildPerms(materialTypeList, currentId);
        ArrayList<TrainingMaterialType> list = new ArrayList<TrainingMaterialType>();
        this.traverse(children, list);
        for (TrainingMaterialType type : list) {
            if (materialType2.getMaterialTypeLevel() == 1) {
                type.setOriginId(materialType2.getId());
            } else {
                type.setOriginId(materialType2.getOriginId());
            }
            type.setMaterialTypeLevel(Integer.valueOf(type.getMaterialTypeLevel() + move));
            type.setIdPath(this.materialTypeService.buildIdPath(type));
            this.materialTypeMapper.updateById(type);
        }
    }

    @Override
    public int getLastLevel(int id) {
        TrainingMaterialType materialType = (TrainingMaterialType)this.materialTypeMapper.selectById(Integer.valueOf(id));
        List materialTypeList = this.materialTypeMapper.selectList((Wrapper)new QueryWrapper());
        List<TrainingMaterialType> children = this.getChildPerms(materialTypeList, materialType.getId());
        if (CollectionUtils.isEmpty(children)) {
            return materialType.getMaterialTypeLevel();
        }
        ArrayList<TrainingMaterialType> list = new ArrayList<TrainingMaterialType>();
        this.traverse(children, list);
        return ((TrainingMaterialType)list.stream().sorted(Comparator.comparingInt(TrainingMaterialType::getMaterialTypeLevel).reversed()).collect(Collectors.toList()).get(0)).getMaterialTypeLevel();
    }

    public void traverse(List<TrainingMaterialType> typeList, List<TrainingMaterialType> list) {
        list.addAll(typeList);
        for (TrainingMaterialType type : typeList) {
            List children = type.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            this.traverse(children, list);
        }
    }

    public List<TrainingMaterialType> getChildPerms(List<TrainingMaterialType> list, int id) {
        ArrayList<TrainingMaterialType> returnList = new ArrayList<TrainingMaterialType>();
        for (TrainingMaterialType materialType : list) {
            if (materialType.getMaterialTypeLevel() == 1) continue;
            Integer sourceId = materialType.getSourceId();
            if (Objects.isNull(sourceId)) {
                sourceId = 0;
            }
            if (sourceId != id) continue;
            this.recursionFn(list, materialType);
            returnList.add(materialType);
        }
        return returnList;
    }

    private void recursionFn(List<TrainingMaterialType> list, TrainingMaterialType materialType) {
        List<TrainingMaterialType> childList = this.getChildList(list, materialType);
        materialType.setChildren(childList);
        for (TrainingMaterialType type : childList) {
            if (!this.hasChild(list, type)) continue;
            this.recursionFn(list, type);
        }
    }

    private List<TrainingMaterialType> getChildList(List<TrainingMaterialType> list, TrainingMaterialType materialType) {
        ArrayList<TrainingMaterialType> materialTypeList = new ArrayList<TrainingMaterialType>();
        for (TrainingMaterialType type : list) {
            if (type.getMaterialTypeLevel() == 1) continue;
            Integer sourceId = type.getSourceId();
            if (Objects.isNull(sourceId)) {
                sourceId = 0;
            }
            if (!sourceId.equals(materialType.getId())) continue;
            materialTypeList.add(type);
        }
        return materialTypeList;
    }

    private boolean hasChild(List<TrainingMaterialType> list, TrainingMaterialType type) {
        return this.getChildList(list, type).size() > 0;
    }

    @Override
    public List<TrainingMaterialVo> getMaterialList(Users user, List<Integer> materialId, Integer materialTypeId, String materialName, List<Integer> creaters, String startTime, String endTime, Integer isUsing, Integer isCommodity) {
        List<Integer> materialTypeIds;
        Map<String, Object> userMap;
        List<TrainingMaterialVo> list = new ArrayList<TrainingMaterialVo>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialName) && (userMap = this.userUtilService.getCheckParameters(materialName, null, null, user)).get("isEffect").toString().equals("1")) {
            List userList = (List)userMap.get("userList");
            creaters.addAll(userList);
            creaters = creaters.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(materialTypeIds = this.getHasPermissionTypeIdList(materialTypeId, user, 1))) {
            return list;
        }
        list = this.materialMapper.selectMaterial(user.getGroupId(), materialId, materialTypeIds, materialName, creaters, startTime, endTime, isUsing, isCommodity);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> trainingMaterialTypeIds = list.stream().map(TrainingMaterial::getMaterialTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Set<Integer> hasManageMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 3, trainingMaterialTypeIds);
            Set<Integer> hasDownloadMaterialTypeIdSet = this.materialPermissionFacade.getValidMaterialTypeIdSet(user, 4, trainingMaterialTypeIds);
            List<Integer> createrIds = list.stream().map(TrainingMaterial::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(createrIds);
            List<Integer> materialIdList = list.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            List<TrainingMaterialVo> usingTrainList = this.materialMapper.selectUsingMaterialCount(materialIdList, user.getGroupId());
            Map<Object, Object> materialMap = new HashMap();
            if (!CollectionUtils.isEmpty(usingTrainList)) {
                materialMap = usingTrainList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            }
            Map<Object, Object> dbviewMap = new HashMap();
            try {
                MeterialPojo meterialPojo = new MeterialPojo();
                meterialPojo.setIds(materialIdList);
                meterialPojo.setType(Integer.valueOf(2));
                com.ovopark.pojo.BaseResult dbshopViewBase = this.checkApi.getRelateDbshopView(meterialPojo);
                if (dbshopViewBase != null && !CollectionUtils.isEmpty((Collection)((Collection)dbshopViewBase.getData())) && ((List)dbshopViewBase.getData()).size() > 0) {
                    dbviewMap = ((List)dbshopViewBase.getData()).stream().collect(Collectors.groupingBy(MeterialDbviewVO::getMaterialId));
                }
            }
            catch (Exception e) {
                log.error("\u7d20\u6750\u8c03\u5de1\u5e97\u5f02\u5e38", (Throwable)e);
            }
            for (TrainingMaterialVo view : list) {
                UsersPojo pojo = pojoMap.get(view.getCreater());
                if (!org.springframework.util.StringUtils.isEmpty((Object)pojo)) {
                    view.setCreateName(pojo.getShowName());
                }
                if (view.getMaterialTypeId() != null && hasManageMaterialTypeIdSet.contains(view.getMaterialTypeId())) {
                    view.setIsPower(Integer.valueOf(1));
                }
                if (view.getMaterialTypeId() != null && hasDownloadMaterialTypeIdSet.contains(view.getMaterialTypeId())) {
                    view.setIsDownload(Integer.valueOf(1));
                }
                int isUsingList = 0;
                TrainingMaterialVo materialCount = (TrainingMaterialVo)materialMap.get(view.getId());
                if (!ObjectUtils.isEmpty((Object)materialCount) && materialCount.getRowNum() != null && materialCount.getRowNum() > 0) {
                    isUsingList = 1;
                } else {
                    List dbviewList = (List)dbviewMap.get(view.getId());
                    if (!CollectionUtils.isEmpty((Collection)dbviewList)) {
                        isUsingList = 1;
                    }
                }
                view.setIsUsingList(Integer.valueOf(isUsingList));
            }
        }
        return list;
    }

    @Override
    public List<TrainingMaterialTypeVo> selectAllLevelMaterialType(TrainingMaterialTypeVo materialType, Users user) {
        ArrayList<TrainingMaterialTypeVo> trainingMaterialTypeVoList = new ArrayList<TrainingMaterialTypeVo>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingMaterialType::getModuleType, (Object)materialType.getModuleType());
        if (materialType.getEnterpriseId() != null) {
            wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)materialType.getEnterpriseId());
        } else {
            wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(TrainingMaterialType::getIsTrade)).like(!org.springframework.util.StringUtils.isEmpty((Object)materialType.getMaterialTypeName()), TrainingMaterialType::getMaterialTypeName, (Object)materialType.getMaterialTypeName())).orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
        List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
            return trainingMaterialTypeVoList;
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialType.getMaterialTypeName())) {
            List materialTypeIds;
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(TrainingMaterialType::getModuleType, (Object)materialType.getModuleType());
            if (materialType.getEnterpriseId() != null) {
                wrapper2.eq(TrainingMaterialType::getEnterpriseId, (Object)materialType.getEnterpriseId());
            } else {
                wrapper2.isNull(TrainingMaterialType::getEnterpriseId);
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.isNull(TrainingMaterialType::getIsTrade)).isNotNull(TrainingMaterialType::getSourceId)).orderByAsc(TrainingMaterialType::getSort)).orderByAsc(TrainingMaterialType::getId);
            List trainingMaterialTypes = this.materialTypeMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> trainingMaterialTypeMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypes)) {
                trainingMaterialTypeMap = trainingMaterialTypes.stream().collect(Collectors.toMap(TrainingMaterialType::getId, Function.identity()));
            }
            if (!CollectionUtils.isEmpty(materialTypeIds = trainingMaterialTypeList.stream().map(TrainingMaterialType::getSourceId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                ArrayList typeIdList1 = new ArrayList(materialTypeIds);
                ArrayList<Integer> typeIdList2 = null;
                for (int i = 4; i > 0; --i) {
                    typeIdList2 = new ArrayList<Integer>();
                    for (Integer materialTypeId : materialTypeIds) {
                        TrainingMaterialType trainingMaterialType = (TrainingMaterialType)trainingMaterialTypeMap.get(materialTypeId);
                        if (ObjectUtils.isEmpty((Object)trainingMaterialType) || trainingMaterialType.getSourceId() == null) continue;
                        typeIdList2.add(trainingMaterialType.getSourceId());
                    }
                    if (CollectionUtils.isEmpty(typeIdList2)) break;
                    typeIdList1.addAll(typeIdList2);
                    materialTypeIds = new ArrayList();
                    materialTypeIds.addAll(typeIdList2);
                }
                if (!CollectionUtils.isEmpty(typeIdList1)) {
                    List trainingMaterialTypeList1 = this.materialTypeMapper.selectBatchIds(typeIdList1);
                    trainingMaterialTypeList.addAll(trainingMaterialTypeList1);
                    trainingMaterialTypeList = trainingMaterialTypeList.stream().distinct().sorted(Comparator.comparingInt(TrainingMaterialType::getSort).thenComparingInt(TrainingMaterialType::getId)).collect(Collectors.toList());
                }
            }
        }
        Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeLevelMap = trainingMaterialTypeList.stream().collect(Collectors.groupingBy(TrainingMaterialType::getMaterialTypeLevel));
        Map<Integer, List<TrainingMaterialType>> trainingMaterialTypeSourceMap = trainingMaterialTypeList.stream().filter(e -> e.getSourceId() != null).collect(Collectors.groupingBy(TrainingMaterialType::getSourceId));
        List<TrainingMaterialType> rootMaterialTypeList = trainingMaterialTypeLevelMap.get(1);
        return this.buildNestMaterialTypeVOList(trainingMaterialTypeSourceMap, rootMaterialTypeList);
    }

    private List<TrainingMaterialTypeVo> buildNestMaterialTypeVOList(Map<Integer, List<TrainingMaterialType>> materialTypeSourceMap, List<TrainingMaterialType> list) {
        ArrayList voList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return voList;
        }
        for (TrainingMaterialType materialType : list) {
            TrainingMaterialTypeVo vo = new TrainingMaterialTypeVo();
            BeanUtils.copyProperties((Object)materialType, (Object)vo);
            voList.add(vo);
            List<TrainingMaterialType> childTypeList = materialTypeSourceMap.get(vo.getId());
            vo.setMaterialTypeVoList(this.buildNestMaterialTypeVOList(materialTypeSourceMap, childTypeList));
        }
        return voList;
    }

    @Override
    public TrainingMaterialType getMaterialTypeById(Integer materialTypeId) {
        return (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(materialTypeId);
    }

    private List<Integer> deleteTypeIdList(List<Integer> materialTypeIds, List<Integer> examTypeIds, List<Integer> paperTypeIds, List<Integer> learnTypeIds, List<Integer> trainTypeIds, List<Integer> feeTypeIds, List<Integer> questionTypeIds) {
        List typeIdList;
        LambdaQueryWrapper wrapper;
        ArrayList<Integer> deleteIds = new ArrayList<Integer>();
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(materialTypeIds)) {
            deleteIds.addAll(materialTypeIds);
            wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(TrainingMaterial::getMaterialTypeId, materialTypeIds)).eq(TrainingMaterial::getIsDel, (Object)0);
            List trainingMaterialList = this.materialMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
                typeIdList = trainingMaterialList.stream().map(TrainingMaterial::getMaterialTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                materialTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                materialTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(materialTypeIds);
        }
        if (!CollectionUtils.isEmpty(examTypeIds)) {
            deleteIds.addAll(examTypeIds);
            wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingExam::getExamTypeId, examTypeIds);
            List trainingExamList = this.trainingExamMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingExamList)) {
                typeIdList = trainingExamList.stream().map(TrainingExam::getExamTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                examTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                examTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(examTypeIds);
        }
        if (!CollectionUtils.isEmpty(paperTypeIds)) {
            deleteIds.addAll(paperTypeIds);
            wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingPaper::getTypeId, paperTypeIds);
            List trainingPaperList = this.trainingPaperMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingPaperList)) {
                typeIdList = trainingPaperList.stream().map(TrainingPaper::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                paperTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                paperTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(paperTypeIds);
        }
        if (!CollectionUtils.isEmpty(learnTypeIds)) {
            deleteIds.addAll(learnTypeIds);
            wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingLearnProject::getProjectType, learnTypeIds);
            List trainingLearnList = this.trainingLearnProjectMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingLearnList)) {
                typeIdList = trainingLearnList.stream().map(TrainingLearnProject::getProjectType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                learnTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                learnTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(learnTypeIds);
        }
        if (!CollectionUtils.isEmpty(trainTypeIds)) {
            deleteIds.addAll(trainTypeIds);
            wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(Training::getTrainingType, trainTypeIds)).eq(Training::getIsDel, (Object)0);
            List trainingList = this.trainingMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingList)) {
                typeIdList = trainingList.stream().map(Training::getTrainingType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                trainTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                trainTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(trainTypeIds);
        }
        if (!CollectionUtils.isEmpty(feeTypeIds)) {
            deleteIds.addAll(feeTypeIds);
            wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(TrainingFee::getTrainingType, feeTypeIds)).eq(TrainingFee::getIsDelete, (Object)0);
            List trainingFeeList = this.trainingFeeMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingFeeList)) {
                typeIdList = trainingFeeList.stream().map(TrainingFee::getTrainingType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                feeTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                feeTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(feeTypeIds);
        }
        if (!CollectionUtils.isEmpty(questionTypeIds)) {
            deleteIds.addAll(questionTypeIds);
            wrapper = new LambdaQueryWrapper();
            wrapper.in(TrainingQuestionType::getMaterialId, questionTypeIds);
            List trainingQuestionTypeList = this.trainingQuestionTypeMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingQuestionTypeList)) {
                typeIdList = trainingQuestionTypeList.stream().map(TrainingQuestionType::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                questionTypeIds.retainAll(typeIdList);
                deleteIds.removeAll(typeIdList);
            } else {
                questionTypeIds = new ArrayList<Integer>();
            }
            typeIds.addAll(questionTypeIds);
        }
        if (!CollectionUtils.isEmpty(deleteIds)) {
            this.materialTypeMapper.deleteBatchIds(deleteIds);
        }
        return typeIds;
    }

    @Override
    public String getOpenUserViewTimeList(Integer enterpriseId, Date startDate, Date endDate) {
        List materialList;
        ArrayList<OpenUserViewTime> result = new ArrayList<OpenUserViewTime>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserViewTime::getEnterpriseId, (Object)enterpriseId);
        if (startDate != null) {
            wrapper.ge(TrainingUserViewTime::getCreateTime, (Object)startDate);
        }
        if (endDate != null) {
            wrapper.le(TrainingUserViewTime::getCreateTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(materialList = this.userViewTimeMapper.selectList((Wrapper)wrapper)))) {
            for (TrainingUserViewTime viewTime : materialList) {
                OpenUserViewTime vo = new OpenUserViewTime();
                vo.setUserId(viewTime.getUserId());
                vo.setMaterialId(viewTime.getMaterialId());
                vo.setViewTime(viewTime.getViewTime());
                vo.setCreateTime(viewTime.getCreateTime());
                vo.setAttachId(viewTime.getAttachId());
                vo.setTrainingId(viewTime.getTrainingId());
                vo.setTaskId(viewTime.getTaskId());
                vo.setLearnType(viewTime.getLearnType());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public void saveMaterialDownloads(TrainingMaterialDownloads trainingMaterialDownloads, Users user) {
        if (!ObjectUtils.isEmpty((Object)trainingMaterialDownloads) && trainingMaterialDownloads.getMaterialId() != null) {
            trainingMaterialDownloads.setUserId(user.getId());
            trainingMaterialDownloads.setEnterpriseId(user.getGroupId());
            trainingMaterialDownloads.setCreater(user.getId());
            trainingMaterialDownloads.setCreateTime(new Date());
            this.TrainingMaterialDownloadsMapper.insert(trainingMaterialDownloads);
            TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(trainingMaterialDownloads.getMaterialId());
            if (!ObjectUtils.isEmpty((Object)trainingMaterial)) {
                trainingMaterial.setDownloads(Integer.valueOf(trainingMaterial.getDownloads() + 1));
                this.materialMapper.updateById(trainingMaterial);
                TrainingResource trainingResource = this.resourceService.getByMaterialId(trainingMaterial.getId());
                if (!ObjectUtils.isEmpty((Object)trainingResource)) {
                    this.trainingResourceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TrainingResource::getId, (Object)trainingResource.getId())).set(TrainingResource::getDownloads, (Object)trainingMaterial.getDownloads()));
                }
            }
        }
    }

    @Override
    public Page<TrainingMaterialDownloadsVo> getMaterialDownloadsByPage(Page<TrainingMaterialDownloadsVo> page, Integer materialId, Users user) {
        List<TrainingMaterialDownloadsVo> trainingMaterialDownloadsVoList = this.TrainingMaterialDownloadsMapper.selectMaterialDownloadsByPage(page, materialId, user.getGroupId());
        if (!CollectionUtils.isEmpty(trainingMaterialDownloadsVoList)) {
            List<Integer> userIdList = trainingMaterialDownloadsVoList.stream().map(TrainingMaterialDownloads::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdList);
            for (TrainingMaterialDownloadsVo vo : trainingMaterialDownloadsVoList) {
                UsersPojo usersPojo = userMap.get(vo.getUserId());
                if (ObjectUtils.isEmpty((Object)usersPojo)) continue;
                vo.setUserName(usersPojo.getUserName());
                vo.setShowName(usersPojo.getShowName());
            }
            page.setContent(trainingMaterialDownloadsVoList);
        }
        return page;
    }

    @Override
    public List<TrainingMaterialDownloadsVo> getMaterialDownloads(Integer materialId, Users user) {
        List<TrainingMaterialDownloadsVo> trainingMaterialDownloadsVoList = this.TrainingMaterialDownloadsMapper.selectMaterialDownloads(materialId, user.getGroupId());
        if (!CollectionUtils.isEmpty(trainingMaterialDownloadsVoList)) {
            List<Integer> userIdList = trainingMaterialDownloadsVoList.stream().map(TrainingMaterialDownloads::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdList);
            for (TrainingMaterialDownloadsVo vo : trainingMaterialDownloadsVoList) {
                UsersPojo usersPojo = userMap.get(vo.getUserId());
                if (ObjectUtils.isEmpty((Object)usersPojo)) continue;
                vo.setUserName(usersPojo.getUserName());
                vo.setShowName(usersPojo.getShowName());
            }
        }
        return trainingMaterialDownloadsVoList;
    }

    @Override
    public TrainingMaterialVo getMaterialBasicInformation(TrainingMaterialVo trainingMaterialVo) {
        UsersPojo usersPojo;
        Integer id = trainingMaterialVo.getId();
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(id);
        if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
            return trainingMaterialVo;
        }
        BeanUtils.copyProperties((Object)trainingMaterial, (Object)trainingMaterialVo);
        if (trainingMaterialVo.getMaterialTypeId() != null) {
            trainingMaterialVo.setMaterialTypeName(this.materialTypeService.getWholePathById(trainingMaterialVo.getMaterialTypeId()));
        }
        if (trainingMaterialVo.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo = this.userUtilService.selectUser(trainingMaterialVo.getCreater())))) {
            trainingMaterialVo.setCreateName(usersPojo.getShowName());
            trainingMaterialVo.setCreateUrl(usersPojo.getThumbUrl());
        }
        this.getLecturersAndMaterialAttach(trainingMaterialVo);
        if (trainingMaterialVo.getFileType() != null && trainingMaterialVo.getFileType() == 6) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialText::getMaterialId, (Object)id)).orderByDesc(TrainingMaterialText::getId)).last(" limit 1 ");
            TrainingMaterialText trainingMaterialText = (TrainingMaterialText)this.trainingMaterialTextMapper.selectOne((Wrapper)wrapper1);
            if (!ObjectUtils.isEmpty((Object)trainingMaterialText)) {
                trainingMaterialVo.setContent(trainingMaterialText.getContent());
            }
        } else if (trainingMaterialVo.getFileType() != null && trainingMaterialVo.getFileType() == 7) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(TrainingMaterialProductPicture::getMaterialId, (Object)trainingMaterialVo.getId())).orderByAsc(TrainingMaterialProductPicture::getSort);
            List pictureList = this.materialProductPictureMapper.selectList((Wrapper)wrapper);
            ArrayList<TrainingMaterialProductPicture> mainProductPictureList = new ArrayList<TrainingMaterialProductPicture>();
            ArrayList<TrainingMaterialProductPicture> productPictureList = new ArrayList<TrainingMaterialProductPicture>();
            if (!CollectionUtils.isEmpty((Collection)pictureList)) {
                for (TrainingMaterialProductPicture picture : pictureList) {
                    if (picture.getPictureType() == 1) {
                        mainProductPictureList.add(picture);
                        continue;
                    }
                    if (picture.getPictureType() != 2) continue;
                    productPictureList.add(picture);
                }
            }
            trainingMaterialVo.setProductMainPictureList(mainProductPictureList);
            trainingMaterialVo.setProductPictureList(productPictureList);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialParameter::getMaterialId, (Object)trainingMaterialVo.getId())).orderByAsc(TrainingMaterialParameter::getSort);
            List parameterList = this.trainingMaterialParameterMapper.selectList((Wrapper)wrapper1);
            trainingMaterialVo.setParameterList(parameterList);
        }
        List<UnitShowVo> readShowList = this.materialSinglePermissionService.getSingleUnitShowListByMaterial(id, 1);
        trainingMaterialVo.setReadSingleUnitShowList(readShowList);
        List<UnitShowVo> downloadShowList = this.materialSinglePermissionService.getSingleUnitShowListByMaterial(id, 4);
        trainingMaterialVo.setDownloadSingleUnitShowList(downloadShowList);
        return trainingMaterialVo;
    }

    private void getLecturersAndMaterialAttach(TrainingMaterialVo trainingMaterialVo) {
        List trainingLecturerIds;
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialLecturer::getMaterialId, (Object)trainingMaterialVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)1);
        List trainingMaterialLecturers = this.materialLecturerMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialLecturers) && !CollectionUtils.isEmpty(trainingLecturerIds = trainingMaterialLecturers.stream().map(TrainingMaterialLecturer::getLecturerId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            ArrayList trainingLecturerVoList = Lists.newArrayList();
            List trainingLecturerList = this.lecturerMapper.selectBatchIds(trainingLecturerIds);
            if (!CollectionUtils.isEmpty((Collection)trainingLecturerList)) {
                List levelIdList = trainingLecturerList.stream().map(TrainingLecturer::getLevelId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List trainingLecturerLevelList = this.trainingLecturerLevelMapper.selectBatchIds(levelIdList);
                Map lecturerLevelMap = trainingLecturerLevelList.stream().collect(Collectors.toMap(TrainingLecturerLevel::getId, Function.identity()));
                for (TrainingLecturer trainingLecturer : trainingLecturerList) {
                    TrainingLecturerVo trainingLecturerVo = new TrainingLecturerVo();
                    BeanUtils.copyProperties((Object)trainingLecturer, (Object)trainingLecturerVo);
                    TrainingLecturerLevel trainingLecturerLevel = (TrainingLecturerLevel)lecturerLevelMap.get(trainingLecturerVo.getLevelId());
                    if (!ObjectUtils.isEmpty((Object)trainingLecturerLevel)) {
                        trainingLecturerVo.setLevelName(trainingLecturerLevel.getLevelName());
                    }
                    trainingLecturerVoList.add(trainingLecturerVo);
                }
            }
            trainingMaterialVo.setLecturerVoList((List)trainingLecturerVoList);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialAttach::getMaterialId, (Object)trainingMaterialVo.getId())).eq(TrainingMaterialAttach::getType, (Object)1)).eq(TrainingMaterialAttach::getIsDel, (Object)0);
        List trainingMaterialAttachs = this.trainingMaterialAttachMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialAttachs)) {
            trainingMaterialVo.setTrainingMaterialAttachList(trainingMaterialAttachs);
        }
    }

    private List<TrainingMaterialTypeVo> getTypesByMaterials(TrainingMaterialTypeVo materialTypeVo, List<Integer> trainingMaterialTypeIds, Map<Integer, List<TrainingMaterialType>> childMap) {
        ArrayList trainingMaterialTypeVos = Lists.newArrayList();
        List<TrainingMaterialType> trainingMaterialTypes = childMap.get(materialTypeVo.getId());
        if (!CollectionUtils.isEmpty(trainingMaterialTypes)) {
            for (TrainingMaterialType materialType : trainingMaterialTypes) {
                TrainingMaterialTypeVo trainingMaterialTypeVo = new TrainingMaterialTypeVo();
                BeanUtils.copyProperties((Object)materialType, (Object)trainingMaterialTypeVo);
                List<TrainingMaterialTypeVo> nextLevelTypeVoList = this.getTypesByMaterials(trainingMaterialTypeVo, trainingMaterialTypeIds, childMap);
                if (trainingMaterialTypeIds.contains(trainingMaterialTypeVo.getId())) {
                    if (!CollectionUtils.isEmpty(nextLevelTypeVoList)) {
                        trainingMaterialTypeVo.setMaterialTypeVoList(nextLevelTypeVoList);
                    }
                    trainingMaterialTypeVos.add(trainingMaterialTypeVo);
                    continue;
                }
                if (CollectionUtils.isEmpty(nextLevelTypeVoList)) continue;
                trainingMaterialTypeVos.addAll(nextLevelTypeVoList);
            }
        }
        return trainingMaterialTypeVos;
    }

    private List<Integer> getTypeIdListByMaterial(Users user) {
        List<Object> typeIds = Lists.newArrayList();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (user.getGroupId() != null) {
            wrapper1.eq(TrainingMaterial::getEnterpriseId, (Object)user.getGroupId());
        } else {
            wrapper1.isNull(TrainingMaterial::getEnterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterial::getIsUsing, (Object)1)).eq(TrainingMaterial::getIsShow, (Object)1)).eq(TrainingMaterial::getIsDel, (Object)0);
        List trainingMaterialList = this.materialMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialList)) {
            typeIds = trainingMaterialList.stream().map(TrainingMaterial::getMaterialTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return typeIds;
    }

    private List<Integer> getAllTypeIdList(Users user, Integer moduleType2) {
        List<Object> typeIds = Lists.newArrayList();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (user.getGroupId() != null) {
            wrapper1.eq(TrainingMaterialType::getEnterpriseId, (Object)user.getGroupId());
        } else {
            wrapper1.isNull(TrainingMaterialType::getEnterpriseId);
        }
        wrapper1.eq(TrainingMaterialType::getModuleType, (Object)moduleType2);
        List trainingMaterialTypeList = this.materialTypeMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialTypeList)) {
            typeIds = trainingMaterialTypeList.stream().map(TrainingMaterialType::getId).collect(Collectors.toList());
        }
        return typeIds;
    }

    @Override
    public Page<TrainingMaterialVo> getAppTrainingMaterialByPage(Page<TrainingMaterialVo> page, Users user, String title, Integer materialTypeId, Integer orderBy) {
        List<Long> unitIdList;
        List<Integer> materialTypeIds;
        if (materialTypeId == null) {
            materialTypeIds = null;
        } else {
            materialTypeIds = this.materialTypeService.getChildTypeIdListNest(materialTypeId);
            materialTypeIds.add(materialTypeId);
        }
        boolean global = this.materialPermissionFacade.validGlobal(user, 1);
        if (global) {
            unitIdList = null;
        } else {
            unitIdList = this.unitService.getIdListByUserId(user.getId());
            if (CollectionUtils.isEmpty(unitIdList)) {
                return page;
            }
        }
        List permissionList = PermissionConst.getListByPermissionType((int)1);
        List<TrainingMaterialVo> list = null;
        if (orderBy == null || orderBy == 1) {
            list = this.materialMapper.selectAppTrainingMaterialByPage(page, user.getGroupId(), title, materialTypeIds, unitIdList, permissionList, 1);
        } else if (orderBy == 2) {
            list = this.materialMapper.selectAppTrainingMaterialReadByPage(page, user.getGroupId(), title, materialTypeIds, unitIdList, permissionList, 2);
        }
        if (!CollectionUtils.isEmpty(list)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserViewTime::getUserId, (Object)user.getId())).orderByDesc(TrainingUserViewTime::getId)).last(" limit 1 ");
            TrainingUserViewTime trainingUserViewTime = (TrainingUserViewTime)this.trainingUserViewTimeMapper.selectOne((Wrapper)wrapper1);
            Integer trainingMaterialId = null;
            if (!ObjectUtils.isEmpty((Object)trainingUserViewTime)) {
                trainingMaterialId = trainingUserViewTime.getMaterialId();
            }
            List<Integer> trainingMaterialIdList = list.stream().map(TrainingMaterial::getId).collect(Collectors.toList());
            Map<Integer, BigDecimal> rateMap = this.trainingCommonService.getMaterialsRate(trainingMaterialIdList, user);
            Map<Integer, Integer> countMap = this.trainingCommonService.getMaterialStudyCount(trainingMaterialIdList, user);
            for (TrainingMaterialVo trainingMaterialVo : list) {
                if (trainingMaterialId != null && trainingMaterialId.equals(trainingMaterialVo.getId())) {
                    trainingMaterialVo.setIsLastView(Integer.valueOf(1));
                } else {
                    trainingMaterialVo.setIsLastView(Integer.valueOf(0));
                }
                trainingMaterialVo.setReadRate(rateMap.get(trainingMaterialVo.getId()));
                trainingMaterialVo.setStudyCount(countMap.get(trainingMaterialVo.getId()));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public TrainingMaterialVo getMaterialText(TrainingMaterialVo trainingMaterialVo) {
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(trainingMaterialVo.getId());
        if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
            return trainingMaterialVo;
        }
        BeanUtils.copyProperties((Object)trainingMaterial, (Object)trainingMaterialVo);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialText::getMaterialId, (Object)trainingMaterialVo.getId())).orderByDesc(TrainingMaterialText::getId)).last(" limit 1");
        TrainingMaterialText trainingMaterialText = (TrainingMaterialText)this.trainingMaterialTextMapper.selectOne((Wrapper)wrapper1);
        if (!ObjectUtils.isEmpty((Object)trainingMaterialText)) {
            trainingMaterialVo.setContent(trainingMaterialText.getContent());
        }
        return trainingMaterialVo;
    }

    @Override
    public Result<Void> batchUpdatePermission(MaterialBatchUpdatePermissionParam param, Users user) {
        ResourceUpdateBo resourceUpdateBo = new ResourceUpdateBo();
        resourceUpdateBo.setType(1);
        List materialIdList = param.getMaterialIdList();
        Integer singleType = param.getSingleType();
        Integer permissionType = param.getPermissionType();
        if (permissionType == 1) {
            this.materialMapper.batchUpdateReadType(materialIdList, singleType, user.getId());
            resourceUpdateBo.setReadType(singleType);
        } else if (permissionType == 4) {
            this.materialMapper.batchUpdateDownloadType(materialIdList, param.getIsDownload(), singleType, user.getId());
            resourceUpdateBo.setIsDownload(param.getIsDownload());
            resourceUpdateBo.setDownloadType(singleType);
        } else {
            return ResultUtils.fail();
        }
        resourceUpdateBo.setType(1);
        ResourcesVo resourcesVo = new ResourcesVo();
        resourcesVo.setObjectIdList(materialIdList);
        resourcesVo.setResourceUpdateBo(resourceUpdateBo);
        this.resourceService.saveBatchResourceInPermission(resourcesVo, user);
        this.materialSinglePermissionService.batchUpdate(param);
        return ResultUtils.success();
    }

    @Override
    public Result<Void> batchUpdateShareable(MaterialBatchUpdateShareableParam param, Users user) {
        List materialIdList = param.getMaterialIdList();
        int shareable = param.getShareable();
        int res = this.materialMapper.batchUpdateShareable(materialIdList, shareable, user.getId());
        List<Integer> resourceIdList = this.resourceService.getIdListByMaterialIdList(materialIdList);
        this.resourceService.batchUpdateShareable(resourceIdList, shareable, user);
        return ResultUtils.success();
    }

    @Override
    public TrainingMaterialVo getMaterialCollection(TrainingMaterialVo trainingMaterialVo, Users user) {
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(trainingMaterialVo.getId());
        if (!ObjectUtils.isEmpty((Object)trainingMaterial)) {
            UsersPojo usersPojo;
            BeanUtils.copyProperties((Object)trainingMaterial, (Object)trainingMaterialVo);
            if (trainingMaterial.getCreater() != null && !ObjectUtils.isEmpty((Object)(usersPojo = this.userUtilService.selectUser(trainingMaterial.getCreater())))) {
                trainingMaterialVo.setCreateName(usersPojo.getShowName());
                trainingMaterialVo.setCreateUrl(usersPojo.getThumbUrl());
            }
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingMaterialComment::getMaterialId, (Object)trainingMaterialVo.getId())).eq(TrainingMaterialComment::getUserId, (Object)user.getId())).eq(TrainingMaterialComment::getType, (Object)1);
        List commentList = this.materialCommentMapper.selectList((Wrapper)wrapper1);
        trainingMaterialVo.setIsCollect(Integer.valueOf(0));
        trainingMaterialVo.setIsLike(Integer.valueOf(0));
        if (!CollectionUtils.isEmpty((Collection)commentList)) {
            TrainingMaterialComment materialComment = (TrainingMaterialComment)commentList.get(0);
            trainingMaterialVo.setMaterialCommentId(materialComment.getId());
            trainingMaterialVo.setIsCollect(materialComment.getIsCollect());
            trainingMaterialVo.setIsLike(materialComment.getIsLike());
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingMaterialLecturer::getMaterialId, (Object)trainingMaterialVo.getId())).eq(TrainingMaterialLecturer::getType, (Object)1);
        List trainingMaterialLecturerList = this.materialLecturerMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)trainingMaterialLecturerList)) {
            List<Integer> lecturerIdList = trainingMaterialLecturerList.stream().map(TrainingMaterialLecturer::getLecturerId).distinct().collect(Collectors.toList());
            trainingMaterialVo.setLecturerVoList(this.getLecturerList(lecturerIdList));
        }
        return trainingMaterialVo;
    }

    private List<TrainingLecturerVo> getLecturerList(List<Integer> lecturerIdList) {
        List lecturerList = this.lecturerMapper.selectBatchIds(lecturerIdList);
        ArrayList lecturerVoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)lecturerList)) {
            List<Integer> userIdList = lecturerList.stream().map(TrainingLecturer::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(userIdList);
            List levelIdList = lecturerList.stream().map(TrainingLecturer::getLevelId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> lecturerLevelMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(levelIdList)) {
                List trainingLecturerLevelList = this.trainingLecturerLevelMapper.selectBatchIds(levelIdList);
                lecturerLevelMap = trainingLecturerLevelList.stream().collect(Collectors.toMap(TrainingLecturerLevel::getId, Function.identity()));
            }
            for (TrainingLecturer trainingLecturer : lecturerList) {
                TrainingLecturerLevel trainingLecturerLevel;
                UsersPojo pojo;
                TrainingLecturerVo trainingLecturerVo = new TrainingLecturerVo();
                BeanUtils.copyProperties((Object)trainingLecturer, (Object)trainingLecturerVo);
                if (trainingLecturerVo.getLecturerType() == 0 && trainingLecturerVo.getUserId() != null && !ObjectUtils.isEmpty((Object)(pojo = pojoMap.get(trainingLecturerVo.getUserId())))) {
                    trainingLecturerVo.setLecturerName(pojo.getShowName());
                    trainingLecturerVo.setUserImg(pojo.getThumbUrl());
                }
                if (!ObjectUtils.isEmpty((Object)(trainingLecturerLevel = (TrainingLecturerLevel)lecturerLevelMap.get(trainingLecturerVo.getLevelId())))) {
                    trainingLecturerVo.setLevelName(trainingLecturerLevel.getLevelName());
                }
                lecturerVoList.add(trainingLecturerVo);
            }
        }
        return lecturerVoList;
    }

    @Override
    public Result<Void> batchUpdateFinishRate(MaterialBatchUpdateFinishRateParam param, Users user) {
        this.materialMapper.batchUpdateFinishRate(param.getMaterialIdList(), param.getFinishRate(), user.getId());
        return ResultUtils.success();
    }

    @Override
    public Result<Void> batchUpdateTypeId(MaterialBatchUpdateTypeParam param, Users user) {
        List materialIdList = param.getMaterialIdList();
        if (CollectionUtils.isEmpty((Collection)materialIdList)) {
            return ResultUtils.success();
        }
        Integer materialId = (Integer)materialIdList.get(0);
        TrainingMaterial material = this.getMaterialById(materialId);
        this.materialMapper.updateTypeByIdList(materialIdList, param.getTypeId(), user.getId());
        List<Integer> resourceIdList = this.resourceService.getIdListByMaterialIdList(materialIdList);
        Result<Void> voidResult = this.resourceService.batchUpdateTypeId(resourceIdList, param.getTypeId(), user.getId());
        EventHelper.sendMaterialTypeStatCountEvent(this, param.getTypeId(), material.getMaterialTypeId());
        return voidResult;
    }

    @Override
    public Result<Void> copyMaterial(MaterialCopyUpdateParam param, Users user) {
        TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(param.getMaterialId());
        if (material == null) {
            return ResultUtils.fail((String)"\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        List typeIdList = param.getTypeIdList();
        if (CollectionUtils.isEmpty((Collection)typeIdList)) {
            return ResultUtils.fail((String)"\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper materWrapper = new LambdaQueryWrapper();
        materWrapper.in(TrainingMaterial::getMaterialTypeId, (Collection)param.getTypeIdList());
        materWrapper.eq(TrainingMaterial::getFileType, (Object)material.getFileType());
        materWrapper.eq(TrainingMaterial::getMaterialName, (Object)material.getMaterialName());
        materWrapper.eq(TrainingMaterial::getIsDel, (Object)0);
        List existList = this.materialMapper.selectList((Wrapper)materWrapper);
        if (!CollectionUtils.isEmpty((Collection)existList)) {
            return ResultUtils.fail((String)"\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8bfe\u4ef6");
        }
        for (Integer typeId : typeIdList) {
            TrainingMaterial newMaterial = new TrainingMaterial();
            BeanUtils.copyProperties((Object)material, (Object)newMaterial);
            newMaterial.setId(null);
            newMaterial.setCreater(user.getId());
            newMaterial.setCreateTime(new Date());
            newMaterial.setUpdater(user.getId());
            newMaterial.setUpdateTime(new Date());
            newMaterial.setMaterialTypeId(typeId);
            this.materialMapper.insert(newMaterial);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingResource::getObjectId, (Object)material.getId());
            TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)wrapper);
            TrainingResource newResource = new TrainingResource();
            BeanUtils.copyProperties((Object)resource, (Object)newResource);
            newResource.setId(null);
            newResource.setObjectId(newMaterial.getId());
            newResource.setCreater(user.getId());
            newResource.setCreateTime(new Date());
            newResource.setUpdater(user.getId());
            newResource.setUpdateTime(new Date());
            newResource.setDownloads(Integer.valueOf(0));
            newResource.setViewCount(Integer.valueOf(0));
            newResource.setLikeCount(Integer.valueOf(0));
            newResource.setScore(new BigDecimal(0));
            newResource.setTypeId(typeId);
            this.trainingResourceMapper.insert(newResource);
            LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
            attaWrapper.eq(TrainingMaterialAttach::getMaterialId, (Object)param.getMaterialId());
            List attachList = this.trainingMaterialAttachMapper.selectList((Wrapper)attaWrapper);
            if (!CollectionUtils.isEmpty((Collection)attachList)) {
                for (TrainingMaterialAttach attach : attachList) {
                    TrainingMaterialAttach newAttach = new TrainingMaterialAttach();
                    BeanUtils.copyProperties((Object)attach, (Object)newAttach);
                    newAttach.setId(null);
                    newAttach.setMaterialId(newMaterial.getId());
                    newAttach.setCreateTime(new Date());
                    this.trainingMaterialAttachMapper.insert(newAttach);
                }
            }
            LambdaQueryWrapper lectWrapper = new LambdaQueryWrapper();
            lectWrapper.eq(TrainingMaterialLecturer::getMaterialId, (Object)param.getMaterialId());
            List list = this.trainingMaterialLecturerMapper.selectList((Wrapper)lectWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (TrainingMaterialLecturer lect : list) {
                    TrainingMaterialLecturer newLect = new TrainingMaterialLecturer();
                    BeanUtils.copyProperties((Object)lect, (Object)newLect);
                    newLect.setId(null);
                    newLect.setMaterialId(newMaterial.getId());
                    newLect.setCreaterId(user.getId());
                    newLect.setCreateTime(new Date());
                    this.trainingMaterialLecturerMapper.insert(newLect);
                }
            }
            LambdaQueryWrapper paramWrapper = new LambdaQueryWrapper();
            paramWrapper.eq(TrainingMaterialParameter::getMaterialId, (Object)param.getMaterialId());
            List paramList = this.trainingMaterialParameterMapper.selectList((Wrapper)paramWrapper);
            if (!CollectionUtils.isEmpty((Collection)paramList)) {
                for (TrainingMaterialParameter param1 : paramList) {
                    TrainingMaterialParameter newParam = new TrainingMaterialParameter();
                    BeanUtils.copyProperties((Object)param1, (Object)newParam);
                    newParam.setId(null);
                    newParam.setMaterialId(newMaterial.getId());
                    newParam.setCreateTime(new Date());
                    this.trainingMaterialParameterMapper.insert(newParam);
                }
            }
            LambdaQueryWrapper perWrapper = new LambdaQueryWrapper();
            perWrapper.eq(MaterialPermissionDO::getResourceId, (Object)resource.getId());
            List perList = this.materialPermissionMapper.selectList((Wrapper)perWrapper);
            if (!CollectionUtils.isEmpty((Collection)perList)) {
                for (MaterialPermissionDO per : perList) {
                    MaterialPermissionDO newPer = new MaterialPermissionDO();
                    BeanUtils.copyProperties((Object)per, (Object)newPer);
                    newPer.setId(null);
                    newPer.setResourceId(newResource.getId());
                    this.materialPermissionMapper.insert(newPer);
                }
            }
            LambdaQueryWrapper textWrapper = new LambdaQueryWrapper();
            textWrapper.eq(TrainingMaterialText::getMaterialId, (Object)param.getMaterialId());
            List textList = this.trainingMaterialTextMapper.selectList((Wrapper)textWrapper);
            if (!CollectionUtils.isEmpty((Collection)textList)) {
                for (TrainingMaterialText text : textList) {
                    TrainingMaterialText newText = new TrainingMaterialText();
                    BeanUtils.copyProperties((Object)text, (Object)newText);
                    newText.setId(null);
                    newText.setMaterialId(newMaterial.getId());
                    newText.setCreateTime(new Date());
                    newText.setCreater(user.getId());
                    this.trainingMaterialTextMapper.insert(newText);
                }
            }
            LambdaQueryWrapper picWrapper = new LambdaQueryWrapper();
            picWrapper.eq(TrainingMaterialProductPicture::getMaterialId, (Object)param.getMaterialId());
            List picList = this.materialProductPictureMapper.selectList((Wrapper)picWrapper);
            if (CollectionUtils.isEmpty((Collection)picList)) continue;
            for (TrainingMaterialProductPicture pic : picList) {
                TrainingMaterialProductPicture newPic = new TrainingMaterialProductPicture();
                BeanUtils.copyProperties((Object)pic, (Object)newPic);
                newPic.setId(null);
                newPic.setMaterialId(newMaterial.getId());
                newPic.setCreateTime(new Date());
                newPic.setCreater(user.getId());
                this.materialProductPictureMapper.insert(newPic);
            }
        }
        return ResultUtils.success();
    }

    @Override
    public Result<Page<MaterialStudyVo>> getMaterialStudyByPage(Page<MaterialStudyVo> page, Integer enterpriseId, Integer materialId, Integer status, String showName, Integer roleId, String organizeIds, String depIds, boolean forTrain, Integer trainingId) {
        Map<Integer, UserDutiesMo> dutiesMap;
        ArrayList<MaterialStudyVo> result = new ArrayList<MaterialStudyVo>();
        TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialId);
        if (material == null) {
            return ResultUtils.fail((String)"\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        int finiashTime = 0;
        finiashTime = material.getIsVideo() == 0 ? material.getFinishTime().intValue() : material.getDuration().intValue();
        List<Integer> userIdList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)organizeIds) || !org.springframework.util.StringUtils.isEmpty((Object)depIds)) {
            UsersOrgIdsAndTagsPojo usersOrgIdsAndTagsPojo = new UsersOrgIdsAndTagsPojo();
            usersOrgIdsAndTagsPojo.setGroupId(enterpriseId);
            usersOrgIdsAndTagsPojo.setOrganizeId(org.springframework.util.StringUtils.isEmpty((Object)organizeIds) ? null : StringsUtils.StringToList(organizeIds, ","));
            usersOrgIdsAndTagsPojo.setDepartmentIds(org.springframework.util.StringUtils.isEmpty((Object)depIds) ? null : StringsUtils.StringToList(depIds, ","));
            BaseResult baseResult = this.userOrganizeApi.getUserOrganizeByTagAndOrgIds(usersOrgIdsAndTagsPojo);
            userIdList = (List)baseResult.getData();
            if (CollectionUtils.isEmpty(userIdList)) {
                return ResultUtils.success(page);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)showName)) {
            Users users = new Users();
            users.setGroupId(enterpriseId);
            Map<String, Object> userMap = this.userUtilService.getCheckParameters(showName, null, null, users);
            List userIds = new ArrayList();
            if (userMap.get("isEffect").toString().equals("1")) {
                userIds = (List)userMap.get("userList");
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                userIdList.retainAll(userIds);
            } else {
                userIdList.addAll(userIds);
            }
            if (CollectionUtils.isEmpty(userIdList)) {
                return ResultUtils.success(page);
            }
        }
        if (roleId != null) {
            ArrayList<Integer> roleList = new ArrayList<Integer>();
            roleList.add(roleId);
            List<Integer> userList = this.userUtilService.selectUsersByRoles(roleList, enterpriseId);
            if (!CollectionUtils.isEmpty(userIdList)) {
                userIdList.retainAll(userList);
            } else {
                userIdList.addAll(userList);
            }
            if (CollectionUtils.isEmpty(userIdList)) {
                return ResultUtils.success(page);
            }
        }
        if (status != null && status == 0) {
            List totalUserIdList = this.getMaterialUnStudyUserIdList(materialId, enterpriseId, userIdList);
            Page<Integer> newPage = ListUtil.myPage(totalUserIdList, page.getPageNumber(), page.getPageSize());
            page.setPageCount(newPage.getPageCount());
            page.setTotalCount(newPage.getTotalCount());
            totalUserIdList = newPage.getContent();
            if (!CollectionUtils.isEmpty((Collection)totalUserIdList)) {
                dutiesMap = this.userUtilService.selectDutiesMap(totalUserIdList, enterpriseId);
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)totalUserIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join((Collection)totalUserIdList, (String)","));
                    parameter.put("groupId", enterpriseId);
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(totalUserIdList, enterpriseId);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(totalUserIdList);
                for (Integer userId : totalUserIdList) {
                    List<String> userStr;
                    MaterialStudyVo vo = new MaterialStudyVo();
                    if (!CollectionUtils.isEmpty(usersPojoMap) && usersPojoMap.get(userId) != null) {
                        UsersPojo pojo = usersPojoMap.get(userId);
                        vo.setShowName(pojo.getShowName());
                        vo.setJobNumber(pojo.getEmployeeNumber());
                        vo.setUserId(userId);
                    }
                    if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(userId) != null) {
                        vo.setPost(dutiesMap.get(userId).getDutieName());
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(userId)))) {
                        StringBuilder role = new StringBuilder();
                        for (RolePojo rolePojo : (List)userRoleMap.get(userId)) {
                            role.append(rolePojo.getRoleName()).append(";\n");
                        }
                        vo.setRoleName(role.substring(0, role.length() - 2));
                    }
                    vo.setOrganizeName(CollectionUtils.isEmpty(userStr = userOrganizeMap.get(userId)) ? "" : String.join((CharSequence)";\n", userStr));
                    vo.setStartStudyTime("--");
                    vo.setFinishStudyTime("--");
                    vo.setTotalStudyTime("--");
                    vo.setFinishDay("--");
                    vo.setStatus(Integer.valueOf(0));
                    vo.setStudyRate("--");
                    result.add(vo);
                }
            }
        } else {
            ArrayList<Integer> viewerIdList = new ArrayList();
            List<TrainingUserViewTimeMaterial> list = forTrain ? this.trainingUserViewTimeTrainingMapper.getMaterialStudyByPage(page, enterpriseId, materialId, userIdList, status, finiashTime, trainingId) : this.trainingUserViewTimeMaterialMapper.getMaterialStudyByPage(page, enterpriseId, materialId, userIdList, status, finiashTime);
            if (!CollectionUtils.isEmpty(list)) {
                viewerIdList = list.stream().map(TrainingUserViewTime::getUserId).collect(Collectors.toList());
                dutiesMap = this.userUtilService.selectDutiesMap(viewerIdList, enterpriseId);
                Map userRoleMap = new HashMap();
                if (!CollectionUtils.isEmpty(viewerIdList)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(viewerIdList, (String)","));
                    parameter.put("groupId", enterpriseId);
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(viewerIdList, enterpriseId);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(viewerIdList);
                for (TrainingUserViewTimeMaterial viewTime : list) {
                    List<String> userStr;
                    MaterialStudyVo vo = new MaterialStudyVo();
                    vo.setStatus(status);
                    vo.setStartStudyTime(DateUtils.format(viewTime.getCreateTime(), "yyyy-MM-dd HH:mm"));
                    BigDecimal totalStudyTime = new BigDecimal(viewTime.getViewTime().doubleValue());
                    vo.setTotalStudyTime(totalStudyTime.divide(new BigDecimal(3600), 2, 0).toString() + "h");
                    if (!CollectionUtils.isEmpty(usersPojoMap) && usersPojoMap.get(viewTime.getUserId()) != null) {
                        UsersPojo pojo = usersPojoMap.get(viewTime.getUserId());
                        vo.setShowName(pojo.getShowName());
                        vo.setJobNumber(pojo.getEmployeeNumber());
                        vo.setUserId(viewTime.getUserId());
                    }
                    if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(viewTime.getUserId()) != null) {
                        vo.setPost(dutiesMap.get(viewTime.getUserId()).getDutieName());
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(viewTime.getUserId())))) {
                        StringBuilder role = new StringBuilder();
                        for (RolePojo rolePojo : (List)userRoleMap.get(viewTime.getUserId())) {
                            role.append(rolePojo.getRoleName()).append(";\n");
                        }
                        vo.setRoleName(role.substring(0, role.length() - 2));
                    }
                    vo.setOrganizeName(CollectionUtils.isEmpty(userStr = userOrganizeMap.get(viewTime.getUserId())) ? "" : String.join((CharSequence)";\n", userStr));
                    if (viewTime.getFinishTime() != null) {
                        vo.setFinishStudyTime(DateUtils.format(viewTime.getFinishTime(), "yyyy-MM-dd HH:mm"));
                        vo.setFinishDay(DateUtils.countDays(DateUtils.getStartTimeOfDay(viewTime.getCreateTime()), DateUtils.getStartTimeOfDay(viewTime.getFinishTime())) + 1 + "\u5929");
                        vo.setStatus(Integer.valueOf(2));
                        if (viewTime.getTaskId() == null) {
                            vo.setFinishWay("\u81ea\u5b66");
                        } else {
                            vo.setFinishWay("\u57f9\u8bad");
                        }
                    } else {
                        vo.setFinishStudyTime("--");
                        vo.setFinishDay("--");
                        vo.setFinishWay("--");
                        vo.setStatus(Integer.valueOf(1));
                    }
                    BigDecimal rate = this.materialService.getMaterialFinishRate(material, viewTime.getViewTime());
                    vo.setStudyRate(rate.multiply(new BigDecimal(100)).setScale(0, 1).intValue() + "%");
                    result.add(vo);
                }
            }
        }
        page.setContent(result);
        return ResultUtils.success(page);
    }

    @Override
    public Result<ExportTaskPojo> exportMaterialStudyByPage(Page<MaterialStudyVo> page, Integer groupId, Integer materialId, Integer status, String showName, Integer roleId, String organizeIds, String depIds, boolean forTrain, Integer trainId, boolean all) {
        if (all) {
            page.setPageSize(5000);
            page.setPageNumber(1);
        }
        HashMap params = Maps.newHashMap();
        params.put("page", page);
        params.put("groupId", groupId);
        params.put("materialId", materialId);
        params.put("status", status);
        params.put("showName", showName);
        params.put("roleId", roleId);
        params.put("organizeIds", organizeIds);
        params.put("depIds", depIds);
        params.put("forTrain", forTrain);
        params.put("trainId", trainId);
        params.put("all", all);
        String fileName = "\u5b66\u5458\u8bfe\u4ef6\u5b66\u4e60\u6570\u636e\u5bfc\u51fa.xlsx";
        String path = System.currentTimeMillis() + "/" + fileName;
        ExportDelegate exportDelegate = DelegateHelper.getExportDelegate();
        ExportTaskPojo e = exportDelegate.createConstTask(path, fileName, JSON.toJSONString((Object)params), ExportConst.ClazzType.UpdateStudyStatus, () -> {
            log.info("\u5f00\u59cb\u5bfc\u51fa\u7d20\u6750\u5b66\u4e60\u8bb0\u5f55");
            Result<Page<MaterialStudyVo>> result = this.getMaterialStudyByPage(page, groupId, materialId, status, showName, roleId, organizeIds, depIds, forTrain, trainId);
            Page data = (Page)result.getData();
            if (!result.isSuccess()) {
                return null;
            }
            List content = data.getContent();
            if (all && this.showUnStudyEnterpriseIdSet.contains(groupId)) {
                Result<Page<MaterialStudyVo>> unStudyResult = this.getMaterialStudyByPage(page, groupId, materialId, 0, showName, roleId, organizeIds, depIds, forTrain, trainId);
                Page unStudyData = (Page)result.getData();
                if (!unStudyResult.isSuccess()) {
                    return null;
                }
                content.addAll(unStudyData.getContent());
            }
            log.info("\u5bfc\u51fa\u7d20\u6750\u5b66\u4e60\u8bb0\u5f55\uff0c\u5171{}\u6761", (Object)content.size());
            return content;
        });
        return ResultUtils.success((Object)e);
    }

    private List<Integer> getMaterialUnStudyUserIdList(Integer materialId, Integer enterpriseId, List<Integer> userIdList) {
        List<Object> viewerIdList = new ArrayList();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserViewTime::getMaterialId, (Object)materialId);
        wrapper.groupBy(TrainingUserViewTime::getUserId);
        List list = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            viewerIdList = list.stream().map(TrainingUserViewTime::getUserId).collect(Collectors.toList());
        }
        List<Integer> totalUserIdList = this.resourceSinglePermissionService.getUserIdByMaterialId(materialId, enterpriseId);
        if (!CollectionUtils.isEmpty(viewerIdList)) {
            totalUserIdList.removeAll(viewerIdList);
        }
        if (!CollectionUtils.isEmpty(userIdList)) {
            totalUserIdList.retainAll(userIdList);
        }
        return totalUserIdList;
    }

    @Override
    public Result<List<String>> getStringByMaterialId(Integer materialId, String text) {
        TrainingMaterial material;
        if (materialId != null && (material = (TrainingMaterial)this.materialMapper.selectById(materialId)).getFileType().equals(1)) {
            String materialStr = ImmUtil.getStringByOssUrl(material.getMaterialPath());
            text = text + "," + materialStr;
        }
        String postResult = HttpUtil.post((String)(this.trainingAiUrl + "/api/ovopark/training/ai/document/summarize"), (String)("{\"text\": \"" + text + "\"}"));
        AIResponse response = (AIResponse)JSONObject.parseObject((String)postResult, AIResponse.class);
        return ResultUtils.success((Object)response.getData());
    }
}

