/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPCellEvent;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ovopark.api.RedisBaseApi;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.bo.UserBo;
import com.ovopark.training.mapper.OperateCheckExaminerMapper;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.OperateCheckTemplateDetailDataMapper;
import com.ovopark.training.mapper.OperateCheckTemplateDetailMapper;
import com.ovopark.training.mapper.OperateCheckTemplateMapper;
import com.ovopark.training.mapper.OperateCheckUserMapper;
import com.ovopark.training.mapper.OperateTemplateCategoryMapper;
import com.ovopark.training.mapper.OperateTemplateDetailDataMapper;
import com.ovopark.training.mapper.OperateTemplateDetailMapper;
import com.ovopark.training.mapper.OperateTemplateMapper;
import com.ovopark.training.mapper.TrainingCheckDimensionMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobUserMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingMaterialParameterMapper;
import com.ovopark.training.mapper.TrainingMaterialProductPictureMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.UserOperateAttaMapper;
import com.ovopark.training.mapper.UserOperateDetailDataMapper;
import com.ovopark.training.mapper.UserOperateDetailDataScanMapper;
import com.ovopark.training.mapper.UserOperateDetailMapper;
import com.ovopark.training.mapper.UserOperateMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.OperateCheck;
import com.ovopark.training.model.OperateCheckExaminer;
import com.ovopark.training.model.OperateCheckTemplate;
import com.ovopark.training.model.OperateCheckTemplateDetail;
import com.ovopark.training.model.OperateCheckTemplateDetailData;
import com.ovopark.training.model.OperateCheckUser;
import com.ovopark.training.model.OperateTemplate;
import com.ovopark.training.model.OperateTemplateCategory;
import com.ovopark.training.model.OperateTemplateDetail;
import com.ovopark.training.model.OperateTemplateDetailData;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingCheckDimension;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobUser;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingMaterialParameter;
import com.ovopark.training.model.TrainingMaterialProductPicture;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.UserOperate;
import com.ovopark.training.model.UserOperateAtta;
import com.ovopark.training.model.UserOperateDetail;
import com.ovopark.training.model.UserOperateDetailData;
import com.ovopark.training.model.UserOperateDetailDataScan;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.TextPDFUtil;
import com.ovopark.training.vo.DetailAnalysisDataVo;
import com.ovopark.training.vo.DetailAnalysisVo;
import com.ovopark.training.vo.ExaminerAnalysisDetailUserVo;
import com.ovopark.training.vo.ExaminerAnalysisDetailVo;
import com.ovopark.training.vo.ExaminerAnalysisReq;
import com.ovopark.training.vo.ExaminerAnalysisUserVo;
import com.ovopark.training.vo.ExaminerAnalysisVo;
import com.ovopark.training.vo.HandPapersVo;
import com.ovopark.training.vo.OperateCheckUserVo;
import com.ovopark.training.vo.OperateCheckVo;
import com.ovopark.training.vo.OperateDetailVo;
import com.ovopark.training.vo.OperateRankingVo;
import com.ovopark.training.vo.OperateTemplateCategoryVo;
import com.ovopark.training.vo.OperateTemplateDetailDataVo;
import com.ovopark.training.vo.OperateTemplateDetailVo;
import com.ovopark.training.vo.OperateTemplateVo;
import com.ovopark.training.vo.StudentOperateDetailListVo;
import com.ovopark.training.vo.StudentOperateDetailVo;
import com.ovopark.training.vo.StudentOperateVo;
import com.ovopark.training.vo.TraineeAnalysisDetailVo;
import com.ovopark.training.vo.TraineeAnalysisReq;
import com.ovopark.training.vo.TraineeAnalysisUserVo;
import com.ovopark.training.vo.TraineeAnalysisVo;
import com.ovopark.training.vo.UserOperateCatagoryVo;
import com.ovopark.training.vo.UserOperateDetailDataVo;
import com.ovopark.training.vo.UserOperateDetailVo;
import com.ovopark.training.vo.UserOperateVo;
import com.ovopark.training.vo.VerifyQuestionsReq;
import com.ovopark.training.vo.ViewExamineeVo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingOperateServiceImpl
implements TrainingOperateService {
    private static final Logger log = LoggerFactory.getLogger(TrainingOperateServiceImpl.class);
    @Autowired
    private TrainingCheckDimensionMapper trainingCheckDimensionMapper;
    @Autowired
    private OperateTemplateMapper operateTemplateMapper;
    @Autowired
    private OperateTemplateCategoryMapper operateTemplateCategoryMapper;
    @Autowired
    private OperateTemplateDetailMapper operateTemplateDetailMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private OperateTemplateDetailDataMapper operateTemplateDetailDataMapper;
    @Autowired
    private OperateCheckUserMapper operateCheckUserMapper;
    @Autowired
    private OperateCheckExaminerMapper operateCheckExaminerMapper;
    @Autowired
    private OperateCheckTemplateMapper operateCheckTemplateMapper;
    @Autowired
    private OperateCheckTemplateDetailMapper operateCheckTemplateDetailMapper;
    @Autowired
    private OperateCheckTemplateDetailDataMapper operateCheckTemplateDetailDataMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOperateMapper userOperateMapper;
    @Autowired
    private UserOperateDetailMapper userOperateDetailMapper;
    @Autowired
    private UserOperateDetailDataMapper userOperateDetailDataMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private UserOperateDetailDataScanMapper userOperateDetailDataScanMapper;
    @Autowired
    private RedisBaseApi redisBaseApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private UserOperateAttaMapper userOperateAttaMapper;
    @Autowired
    private TrainingMaterialProductPictureMapper trainingMaterialProductPictureMapper;
    @Autowired
    private TrainingMaterialParameterMapper trainingMaterialParameterMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingJobUserMapper trainingJobUserMapper;
    @Autowired
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LogApi logApi;

    @Override
    public String getCheckDimensionList(Integer groupId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCheckDimension::getEnterpriseId, (Object)groupId);
        wrapper.orderByAsc(TrainingCheckDimension::getSort);
        ArrayList<TrainingCheckDimension> list = this.trainingCheckDimensionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            TrainingCheckDimension cd = new TrainingCheckDimension();
            cd.setCreateTime(new Date());
            cd.setEnterpriseId(groupId);
            cd.setName(this.messageSource.getMessage("training.operate.take", null, locale));
            cd.setIsSystem(Integer.valueOf(1));
            cd.setSort(Integer.valueOf(1));
            this.trainingCheckDimensionMapper.insert(cd);
            list = new ArrayList<TrainingCheckDimension>();
            list.add(cd);
            TrainingCheckDimension cd1 = new TrainingCheckDimension();
            cd1.setCreateTime(new Date());
            cd1.setEnterpriseId(groupId);
            cd1.setName(this.messageSource.getMessage("training.operate.points", null, locale));
            cd1.setIsSystem(Integer.valueOf(0));
            cd1.setSort(Integer.valueOf(2));
            this.trainingCheckDimensionMapper.insert(cd1);
            list.add(cd1);
        }
        return JsonResult.success((Object)list);
    }

    @Override
    public void saveCheckDimensionOrder(List<TrainingCheckDimension> order) {
        int num = 1;
        for (TrainingCheckDimension label : order) {
            label.setSort(Integer.valueOf(num));
            this.trainingCheckDimensionMapper.updateById(label);
            ++num;
        }
    }

    @Override
    public String vaildCheckDimension(Integer groupId, String name) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCheckDimension::getEnterpriseId, (Object)groupId);
        wrapper.eq(TrainingCheckDimension::getName, (Object)name);
        List list = this.trainingCheckDimensionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @Override
    public String saveOperateTemplate(OperateTemplateVo vo) {
        if (vo.getId() == null) {
            OperateTemplate template = new OperateTemplate();
            template.setCreateTime(new Date());
            template.setEnterpriseId(vo.getEnterpriseId());
            template.setTemplateName(vo.getTemplateName());
            template.setIsEnable(vo.getIsEnable());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OperateTemplate::getEnterpriseId, (Object)vo.getEnterpriseId());
            wrapper.orderByDesc(OperateTemplate::getSort);
            List tempList = this.operateTemplateMapper.selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)tempList)) {
                template.setSort(Integer.valueOf(1));
            } else {
                template.setSort(Integer.valueOf(((OperateTemplate)tempList.get(0)).getSort() + 1));
            }
            this.operateTemplateMapper.insertSelective(template);
            List categoryList = vo.getCategoryList();
            if (!CollectionUtils.isEmpty((Collection)categoryList)) {
                int sort = 0;
                for (OperateTemplateCategoryVo categoryVo : categoryList) {
                    LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
                    categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)template.getId());
                    categoryWrapper.eq(OperateTemplateCategory::getCategoryName, (Object)categoryVo.getCategoryName());
                    List existList = this.operateTemplateCategoryMapper.selectList((Wrapper)categoryWrapper);
                    if (!CollectionUtils.isEmpty((Collection)existList)) {
                        return JsonResult.error(null, (Object)"EXIST_DATA");
                    }
                    OperateTemplateCategory category = new OperateTemplateCategory();
                    category.setCreateTime(new Date());
                    category.setOperateTemplateId(template.getId());
                    category.setCategoryName(categoryVo.getCategoryName());
                    category.setSort(Integer.valueOf(sort));
                    this.operateTemplateCategoryMapper.insertSelective(category);
                    if (CollectionUtils.isEmpty((Collection)categoryVo.getDetailList())) continue;
                    for (int i = 0; i < categoryVo.getDetailList().size(); ++i) {
                        ++sort;
                        OperateTemplateDetailVo detailVo = (OperateTemplateDetailVo)categoryVo.getDetailList().get(i);
                        OperateTemplateDetail detail = new OperateTemplateDetail();
                        detail.setCreateTime(new Date());
                        detail.setOperateTemplateId(template.getId());
                        detail.setOperateCategoryId(category.getId());
                        detail.setBusinessId(detailVo.getBusinessId());
                        detail.setDetailType(detailVo.getDetailType());
                        if (detailVo.getDetailType().equals(1)) {
                            TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(detailVo.getBusinessId());
                            detail.setDetailName(question.getName());
                        }
                        if (detailVo.getDetailType().equals(2)) {
                            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(detailVo.getBusinessId());
                            detail.setBarCode(material.getBarCode());
                            detail.setDetailName(material.getMaterialName());
                            detail.setDetailUrl(material.getMaterialPath());
                        }
                        detail.setScore(detailVo.getScore());
                        detail.setIsRedline(detailVo.getIsRedline());
                        detail.setSort(Integer.valueOf(sort));
                        this.operateTemplateDetailMapper.insert(detail);
                        if (!detailVo.getDetailType().equals(2)) continue;
                        float total = 0.0f;
                        List dataList = detailVo.getDataList();
                        for (int j = 0; j < dataList.size(); ++j) {
                            OperateTemplateDetailDataVo dataVo = (OperateTemplateDetailDataVo)dataList.get(j);
                            OperateTemplateDetailData data = new OperateTemplateDetailData();
                            TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(detailVo.getBusinessId());
                            if (material != null && material.getIsPictureShow() != null && material.getIsPictureShow().equals(1)) {
                                LambdaQueryWrapper pictureWrapper = new LambdaQueryWrapper();
                                pictureWrapper.eq(TrainingMaterialProductPicture::getEnterpriseId, (Object)vo.getEnterpriseId());
                                pictureWrapper.eq(TrainingMaterialProductPicture::getMaterialId, (Object)detailVo.getBusinessId());
                                List pictureList = this.trainingMaterialProductPictureMapper.selectList((Wrapper)pictureWrapper);
                                if (!CollectionUtils.isEmpty((Collection)pictureList)) {
                                    detail.setDetailUrl(JSONObject.toJSONString((Object)pictureList));
                                }
                            }
                            LambdaQueryWrapper parameterWrapper = new LambdaQueryWrapper();
                            parameterWrapper.eq(TrainingMaterialParameter::getEnterpriseId, (Object)vo.getEnterpriseId());
                            parameterWrapper.eq(TrainingMaterialParameter::getMaterialId, (Object)detailVo.getBusinessId());
                            parameterWrapper.eq(TrainingMaterialParameter::getIsShow, (Object)1);
                            List paramList = this.trainingMaterialParameterMapper.selectList((Wrapper)parameterWrapper);
                            if (!CollectionUtils.isEmpty((Collection)paramList)) {
                                detail.setDetailParameter(JSONObject.toJSONString((Object)paramList));
                            }
                            data.setOperateTemplateId(template.getId());
                            data.setOperateTemplateDetailId(detail.getId());
                            data.setDataName(dataVo.getDataName());
                            data.setScore(dataVo.getScore());
                            data.setIsRedline(dataVo.getIsRedline());
                            this.operateTemplateDetailDataMapper.insert(data);
                            total += dataVo.getScore().floatValue();
                        }
                        detail.setScore(Float.valueOf(total));
                        this.operateTemplateDetailMapper.updateById(detail);
                    }
                }
            }
        } else {
            OperateTemplate template = (OperateTemplate)this.operateTemplateMapper.selectById(vo.getId());
            if (template != null) {
                template.setTemplateName(vo.getTemplateName());
                template.setIsEnable(vo.getIsEnable());
                this.operateTemplateMapper.updateById(template);
                LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
                categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)template.getId());
                this.operateTemplateCategoryMapper.delete((Wrapper)categoryWrapper);
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(OperateTemplateDetail::getOperateTemplateId, (Object)template.getId());
                this.operateTemplateDetailMapper.delete((Wrapper)detailWrapper);
                LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                detailDataWrapper.eq(OperateTemplateDetailData::getOperateTemplateId, (Object)template.getId());
                this.operateTemplateDetailDataMapper.delete((Wrapper)detailDataWrapper);
                List categoryList = vo.getCategoryList();
                if (!CollectionUtils.isEmpty((Collection)categoryList)) {
                    int sort = 0;
                    for (OperateTemplateCategoryVo categoryVo : categoryList) {
                        categoryWrapper = new LambdaQueryWrapper();
                        categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)template.getId());
                        categoryWrapper.eq(OperateTemplateCategory::getCategoryName, (Object)categoryVo.getCategoryName());
                        List existList = this.operateTemplateCategoryMapper.selectList((Wrapper)categoryWrapper);
                        if (!CollectionUtils.isEmpty((Collection)existList)) {
                            return JsonResult.error(null, (Object)"EXIST_DATA");
                        }
                        OperateTemplateCategory category = new OperateTemplateCategory();
                        category.setId(categoryVo.getId());
                        category.setCreateTime(new Date());
                        category.setOperateTemplateId(template.getId());
                        category.setCategoryName(categoryVo.getCategoryName());
                        category.setSort(Integer.valueOf(sort));
                        this.operateTemplateCategoryMapper.insertSelective(category);
                        if (CollectionUtils.isEmpty((Collection)categoryVo.getDetailList())) continue;
                        int detailSort = categoryVo.getDetailList().size();
                        for (OperateTemplateDetailVo detailVo : categoryVo.getDetailList()) {
                            ++sort;
                            OperateTemplateDetail detail = new OperateTemplateDetail();
                            detail.setId(detailVo.getId());
                            detail.setCreateTime(new Date());
                            detail.setOperateTemplateId(template.getId());
                            detail.setOperateCategoryId(category.getId());
                            detail.setBusinessId(detailVo.getBusinessId());
                            detail.setDetailType(detailVo.getDetailType());
                            if (detailVo.getDetailType().equals(1)) {
                                TrainingQuestion question = (TrainingQuestion)this.trainingQuestionMapper.selectById(detailVo.getBusinessId());
                                detail.setDetailName(question.getName());
                            }
                            if (detailVo.getDetailType().equals(2)) {
                                TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(detailVo.getBusinessId());
                                detail.setBarCode(material.getBarCode());
                                detail.setDetailName(material.getMaterialName());
                            }
                            detail.setScore(detailVo.getScore());
                            detail.setIsRedline(detailVo.getIsRedline());
                            detail.setSort(Integer.valueOf(detailSort - 1));
                            this.operateTemplateDetailMapper.insert(detail);
                            if (!detailVo.getDetailType().equals(2)) continue;
                            float total = 0.0f;
                            List dataList = detailVo.getDataList();
                            for (int j = 0; j < dataList.size(); ++j) {
                                OperateTemplateDetailDataVo dataVo = (OperateTemplateDetailDataVo)dataList.get(j);
                                OperateTemplateDetailData data = new OperateTemplateDetailData();
                                TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(detailVo.getBusinessId());
                                if (material != null && material.getIsPictureShow() != null && material.getIsPictureShow().equals(1)) {
                                    LambdaQueryWrapper pictureWrapper = new LambdaQueryWrapper();
                                    pictureWrapper.eq(TrainingMaterialProductPicture::getEnterpriseId, (Object)vo.getEnterpriseId());
                                    pictureWrapper.eq(TrainingMaterialProductPicture::getMaterialId, (Object)detailVo.getBusinessId());
                                    List pictureList = this.trainingMaterialProductPictureMapper.selectList((Wrapper)pictureWrapper);
                                    if (!CollectionUtils.isEmpty((Collection)pictureList)) {
                                        detail.setDetailUrl(JSONObject.toJSONString((Object)pictureList));
                                    }
                                }
                                LambdaQueryWrapper parameterWrapper = new LambdaQueryWrapper();
                                parameterWrapper.eq(TrainingMaterialParameter::getEnterpriseId, (Object)vo.getEnterpriseId());
                                parameterWrapper.eq(TrainingMaterialParameter::getMaterialId, (Object)detailVo.getBusinessId());
                                parameterWrapper.eq(TrainingMaterialParameter::getIsShow, (Object)1);
                                List paramList = this.trainingMaterialParameterMapper.selectList((Wrapper)parameterWrapper);
                                if (!CollectionUtils.isEmpty((Collection)paramList)) {
                                    detail.setDetailParameter(JSONObject.toJSONString((Object)paramList));
                                }
                                data.setOperateTemplateId(template.getId());
                                data.setOperateTemplateDetailId(detail.getId());
                                data.setDataName(dataVo.getDataName());
                                data.setScore(dataVo.getScore());
                                data.setIsRedline(dataVo.getIsRedline());
                                this.operateTemplateDetailDataMapper.insert(data);
                                total += dataVo.getScore().floatValue();
                            }
                            detail.setScore(Float.valueOf(total));
                            this.operateTemplateDetailMapper.updateById(detail);
                        }
                    }
                }
            } else {
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                JsonResult.error(null, (Object)("operateTemplateId" + this.messageSource.getMessage("training.operate.not.exist", null, locale)));
            }
        }
        return JsonResult.success();
    }

    @Override
    public void deleteOperateTemplateById(Integer operateTemplateId) {
        LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
        categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)operateTemplateId);
        List categoryList = this.operateTemplateCategoryMapper.selectList((Wrapper)categoryWrapper);
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            for (OperateTemplateCategory category : categoryList) {
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(OperateTemplateDetail::getOperateTemplateId, (Object)operateTemplateId);
                detailWrapper.eq(OperateTemplateDetail::getOperateCategoryId, (Object)category.getId());
                this.operateTemplateDetailMapper.delete((Wrapper)detailWrapper);
                LambdaQueryWrapper dataWrapper = new LambdaQueryWrapper();
                dataWrapper.eq(OperateTemplateDetailData::getOperateTemplateId, (Object)operateTemplateId);
                this.operateTemplateDetailDataMapper.delete((Wrapper)dataWrapper);
            }
            this.operateTemplateCategoryMapper.delete((Wrapper)categoryWrapper);
        }
        this.operateTemplateMapper.deleteById(operateTemplateId);
    }

    @Override
    public String getOperateTemplateByPage(Page<OperateTemplateVo> page, Integer groupId, String templateName, Integer isEnable) {
        List<OperateTemplateVo> templateList = this.operateTemplateMapper.selectVoByPage(page, groupId, templateName, isEnable);
        for (OperateTemplateVo operateTemplateVo : templateList) {
            LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
            categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)operateTemplateVo.getId());
            List categoryList = this.operateTemplateCategoryMapper.selectList((Wrapper)categoryWrapper);
            if (!CollectionUtils.isEmpty((Collection)categoryList)) {
                operateTemplateVo.setCategoryNum(categoryList.size());
            }
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.eq(OperateTemplateDetail::getOperateTemplateId, (Object)operateTemplateVo.getId());
            List detailList = this.operateTemplateDetailMapper.selectList((Wrapper)detailWrapper);
            if (!CollectionUtils.isEmpty((Collection)detailList)) {
                operateTemplateVo.setQuestionNum(detailList.size());
            }
            detailWrapper.eq(OperateTemplateDetail::getDetailType, (Object)2);
            List materilList = this.operateTemplateDetailMapper.selectList((Wrapper)detailWrapper);
            if (CollectionUtils.isEmpty((Collection)materilList)) {
                operateTemplateVo.setHasMaterial(Integer.valueOf(0));
                continue;
            }
            operateTemplateVo.setHasMaterial(Integer.valueOf(1));
        }
        page.setContent(templateList);
        return JsonResult.success(page);
    }

    @Override
    public String operateTemplateIsEnable(String operateTemplateIds, Integer isEnable) {
        String[] idsStr = operateTemplateIds.split(",");
        for (int i = 0; i < idsStr.length; ++i) {
            if (org.springframework.util.StringUtils.isEmpty((Object)idsStr[i])) continue;
            OperateTemplate template = (OperateTemplate)this.operateTemplateMapper.selectById(Integer.valueOf(Integer.parseInt(idsStr[i])));
            template.setIsEnable(isEnable);
            this.operateTemplateMapper.updateById(template);
        }
        return JsonResult.success();
    }

    @Override
    public String saveCheckDimension(Integer groupId, List<TrainingCheckDimension> list) {
        LambdaQueryWrapper dimensionWrapper = new LambdaQueryWrapper();
        dimensionWrapper.eq(TrainingCheckDimension::getEnterpriseId, (Object)groupId);
        this.trainingCheckDimensionMapper.delete((Wrapper)dimensionWrapper);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        for (int i = 0; i < list.size(); ++i) {
            TrainingCheckDimension cd = list.get(i);
            cd.setCreateTime(new Date());
            cd.setEnterpriseId(groupId);
            if (cd.getName().equals(take)) {
                cd.setIsSystem(Integer.valueOf(1));
            } else {
                cd.setIsSystem(Integer.valueOf(0));
            }
            cd.setSort(Integer.valueOf(i + 1));
            this.trainingCheckDimensionMapper.insert(cd);
        }
        return JsonResult.success();
    }

    @Override
    public String getOperateTemplateById(Integer operateTemplateId) {
        OperateTemplateVo vo = new OperateTemplateVo();
        OperateTemplate template = (OperateTemplate)this.operateTemplateMapper.selectById(operateTemplateId);
        BeanUtils.copyProperties((Object)template, (Object)vo);
        ArrayList<OperateTemplateCategoryVo> categoryVoList = new ArrayList<OperateTemplateCategoryVo>();
        LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
        categoryWrapper.eq(OperateTemplateCategory::getOperateTemplateId, (Object)operateTemplateId);
        categoryWrapper.orderByAsc(OperateTemplateCategory::getSort);
        List categoryList = this.operateTemplateCategoryMapper.selectList((Wrapper)categoryWrapper);
        for (OperateTemplateCategory category : categoryList) {
            OperateTemplateCategoryVo categoryVo = new OperateTemplateCategoryVo();
            BeanUtils.copyProperties((Object)category, (Object)categoryVo);
            ArrayList<OperateTemplateDetailVo> detailVoList = new ArrayList<OperateTemplateDetailVo>();
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.eq(OperateTemplateDetail::getOperateTemplateId, (Object)operateTemplateId);
            detailWrapper.eq(OperateTemplateDetail::getOperateCategoryId, (Object)category.getId());
            detailWrapper.orderByAsc(OperateTemplateDetail::getSort);
            List detailList = this.operateTemplateDetailMapper.selectList((Wrapper)detailWrapper);
            for (OperateTemplateDetail detail : detailList) {
                OperateTemplateDetailVo detailVo = new OperateTemplateDetailVo();
                BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                if (detail.getDetailType().equals(2)) {
                    LambdaQueryWrapper dataWrapper = new LambdaQueryWrapper();
                    dataWrapper.eq(OperateTemplateDetailData::getOperateTemplateId, (Object)detail.getOperateTemplateId());
                    dataWrapper.eq(OperateTemplateDetailData::getOperateTemplateDetailId, (Object)detail.getId());
                    List dataList = this.operateTemplateDetailDataMapper.selectList((Wrapper)dataWrapper);
                    ArrayList<OperateTemplateDetailDataVo> dataVoList = new ArrayList<OperateTemplateDetailDataVo>();
                    for (OperateTemplateDetailData data : dataList) {
                        OperateTemplateDetailDataVo dataVo = new OperateTemplateDetailDataVo();
                        BeanUtils.copyProperties((Object)data, (Object)dataVo);
                        dataVoList.add(dataVo);
                    }
                    detailVo.setDataList(dataVoList);
                }
                detailVoList.add(detailVo);
            }
            categoryVo.setDetailList(detailVoList);
            categoryVoList.add(categoryVo);
        }
        vo.setCategoryList(categoryVoList);
        return JsonResult.success((Object)vo);
    }

    @Override
    public String saveOperateCheck(final OperateCheckVo vo) {
        OperateCheck check = new OperateCheck();
        Integer isAdd = 0;
        if (vo.getId() == null) {
            BeanUtils.copyProperties((Object)vo, (Object)check);
            check.setCreateTime(new Date());
            this.operateCheckMapper.insert(check);
            vo.setId(check.getId());
            isAdd = 1;
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OperateCheckExaminer::getEnterpriseId, (Object)vo.getEnterpriseId());
            wrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)vo.getId());
            this.operateCheckExaminerMapper.delete((Wrapper)wrapper);
            check = (OperateCheck)this.operateCheckMapper.selectById(vo.getId());
            BeanUtils.copyProperties((Object)vo, (Object)check);
            this.operateCheckMapper.updateById(check);
            LambdaQueryWrapper checkTemplateWrapper = new LambdaQueryWrapper();
            checkTemplateWrapper.eq(OperateCheckTemplate::getEnterpriseId, (Object)check.getEnterpriseId());
            checkTemplateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)check.getId());
            this.operateCheckTemplateMapper.delete((Wrapper)checkTemplateWrapper);
            if (check.getSource() != null) {
                check.setStatus(Integer.valueOf(2));
                this.operateCheckMapper.updateById(check);
                if (check.getSource() == 1) {
                    LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                    taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
                    taskWrapper.eq(TrainingJobStageTask::getOperateCheckId, (Object)check.getId());
                    List list = this.trainingJobStageTaskMapper.selectList((Wrapper)taskWrapper);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        for (TrainingJobStageTask trainingJobStageTask : list) {
                            trainingJobStageTask.setTaskName(check.getCheckName());
                            this.trainingJobStageTaskMapper.updateById(trainingJobStageTask);
                        }
                    }
                }
            }
        }
        final List list = vo.getCheckExaminerList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (OperateCheckUserVo users : list) {
                if (users.getId() == null) continue;
                OperateCheckExaminer examiner = new OperateCheckExaminer();
                examiner.setEnterpriseId(vo.getEnterpriseId());
                examiner.setOperateCheckId(vo.getId());
                examiner.setUserId(users.getId());
                this.operateCheckExaminerMapper.insert(examiner);
            }
        }
        if (vo.getOperateTemplateId() != null) {
            OperateTemplate template = (OperateTemplate)this.operateTemplateMapper.selectById(vo.getOperateTemplateId());
            OperateCheckTemplate checkTemplate = new OperateCheckTemplate();
            checkTemplate.setCreateTime(template.getCreateTime());
            checkTemplate.setEnterpriseId(template.getEnterpriseId());
            checkTemplate.setOperateCheckId(vo.getId());
            checkTemplate.setTemplateName(template.getTemplateName());
            this.operateCheckTemplateMapper.insert(checkTemplate);
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.eq(OperateTemplateDetail::getOperateTemplateId, (Object)template.getId());
            List detailList = this.operateTemplateDetailMapper.selectList((Wrapper)detailWrapper);
            Float totalScore = Float.valueOf(0.0f);
            for (OperateTemplateDetail detail : detailList) {
                totalScore = Float.valueOf(totalScore.floatValue() + detail.getScore().floatValue());
                OperateCheckTemplateDetail checkDetail = new OperateCheckTemplateDetail();
                checkDetail.setOperateCheckTemplateId(checkTemplate.getId());
                OperateTemplateCategory category = (OperateTemplateCategory)this.operateTemplateCategoryMapper.selectById(detail.getOperateCategoryId());
                if (category != null) {
                    checkDetail.setCategoryName(category.getCategoryName());
                }
                checkDetail.setDetailName(detail.getDetailName());
                checkDetail.setBarCode(detail.getBarCode());
                checkDetail.setDetailUrl(detail.getDetailUrl());
                checkDetail.setDetailParameter(detail.getDetailParameter());
                checkDetail.setDetailType(detail.getDetailType());
                checkDetail.setScore(detail.getScore());
                checkDetail.setIsRedline(detail.getIsRedline());
                checkDetail.setSort(detail.getSort());
                this.operateCheckTemplateDetailMapper.insert(checkDetail);
                LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                detailDataWrapper.eq(OperateTemplateDetailData::getOperateTemplateId, (Object)detail.getOperateTemplateId());
                detailDataWrapper.eq(OperateTemplateDetailData::getOperateTemplateDetailId, (Object)detail.getId());
                List detailDataList = this.operateTemplateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                if (CollectionUtils.isEmpty((Collection)detailDataList)) continue;
                for (OperateTemplateDetailData detailData : detailDataList) {
                    OperateCheckTemplateDetailData checkDetailData = new OperateCheckTemplateDetailData();
                    checkDetailData.setOperateCheckTemplateId(checkTemplate.getId());
                    checkDetailData.setOperateCheckTemplateDetailId(checkDetail.getId());
                    checkDetailData.setDataName(detailData.getDataName());
                    checkDetailData.setScore(detailData.getScore());
                    checkDetailData.setIsRedline(detailData.getIsRedline());
                    this.operateCheckTemplateDetailDataMapper.insert(checkDetailData);
                }
            }
            checkTemplate.setTotalScore(totalScore);
            checkTemplate.setPassScore(Float.valueOf(new BigDecimal(totalScore.floatValue() * (float)vo.getPassLine().intValue() / 100.0f).setScale(4, 1).floatValue()));
            this.operateCheckTemplateMapper.updateById(checkTemplate);
        }
        if (vo.getStatus() != 0) {
            List userList;
            LambdaQueryWrapper userWrapper;
            vo.setCheckName(check.getCheckName());
            vo.setCheckNumber(check.getCheckNumber());
            final OperateCheckVo checkVo = new OperateCheckVo();
            checkVo.setId(vo.getId());
            final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            final String zName = this.messageSource.getMessage("training.paper.expire.to", null, locale);
            final String operateName = this.messageSource.getMessage("training.operate.name", null, locale);
            if (isAdd == 1) {
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(106);
                                body.setTaskJson(JSONObject.toJSONString((Object)vo));
                                checkVo.setTitle(operateName);
                                for (OperateCheckUserVo userVo : list) {
                                    try {
                                        TrainingOperateServiceImpl.this.jPushService.sendWebSocket(operateName, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.one", new Object[]{vo.getCheckName(), vo.getCheckNumber()}, locale), userVo.getId(), vo.getEnterpriseId(), vo.getId(), "TYPE_OPEADD_EXAMINER_TYPE", JSONObject.toJSONString((Object)checkVo), vo.getEndTime(), 1, 1, "training.operate.need.check.one", vo.getCheckName() + "," + vo.getCheckNumber());
                                        if (vo.getIsSendMessage() == null || vo.getIsSendMessage() != 1) continue;
                                        TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEADD_EXAMINER_TYPE", userVo.getId(), operateName, MessageFormat.format(TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.two", null, locale), vo.getCheckName(), vo.getCheckNumber()) + "\n" + TrainingOperateServiceImpl.this.messageSource.getMessage("training.certificate.validity", null, locale) + ":" + DateUtils.format(vo.getStartTime(), "yyyy-MM-dd HH:mm") + zName + DateUtils.format(vo.getEndTime(), "yyyy-MM-dd HH:mm"), body);
                                    }
                                    catch (Exception e) {
                                        log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                            }
                        }
                    });
                }
                userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)vo.getId());
                userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(107);
                                body.setTaskJson(JSONObject.toJSONString((Object)vo));
                                checkVo.setTitle(operateName);
                                for (OperateCheckUser userVo : userList) {
                                    try {
                                        TrainingOperateServiceImpl.this.jPushService.sendWebSocket(operateName, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.three", new Object[]{vo.getCheckName(), vo.getCheckNumber()}, locale), userVo.getUserId(), vo.getEnterpriseId(), vo.getId(), "TYPE_OPEADD_USER_TYPE", JSONObject.toJSONString((Object)checkVo), vo.getEndTime(), 1, 1, "training.operate.need.check.three", vo.getCheckName() + "," + vo.getCheckNumber());
                                        if (vo.getIsSendMessage() == null || vo.getIsSendMessage() != 1) continue;
                                        TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEADD_USER_TYPE", userVo.getUserId(), operateName, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.four", new Object[]{vo.getCheckName(), vo.getCheckNumber()}, locale) + "\n" + TrainingOperateServiceImpl.this.messageSource.getMessage("training.certificate.validity", null, locale) + ":" + DateUtils.format(vo.getStartTime(), "yyyy-MM-dd HH:mm") + zName + DateUtils.format(vo.getEndTime(), "yyyy-MM-dd HH:mm"), body);
                                    }
                                    catch (Exception e) {
                                        log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                            }
                        }
                    });
                }
            } else {
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String testChange = TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.test.change", null, locale);
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(108);
                                body.setTaskJson(JSONObject.toJSONString((Object)vo));
                                checkVo.setTitle(testChange);
                                for (OperateCheckUserVo userVo : list) {
                                    try {
                                        TrainingOperateServiceImpl.this.jPushService.sendWebSocket(testChange, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.update.data", new Object[]{vo.getCheckName()}, locale), userVo.getId(), vo.getEnterpriseId(), userVo.getUserId(), "TYPE_OPEUP_EXAMINER_TYPE", JSONObject.toJSONString((Object)checkVo), vo.getEndTime(), 0, 0, "training.operate.update.data", vo.getCheckName());
                                        if (vo.getIsSendMessage() == null || vo.getIsSendMessage() != 1) continue;
                                        TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEUP_EXAMINER_TYPE", userVo.getId(), testChange, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.update.data", new Object[]{vo.getCheckName()}, locale), body);
                                    }
                                    catch (Exception e) {
                                        log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                            }
                        }
                    });
                }
                userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)vo.getId());
                userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    CommonUtil.handleTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String testChange = TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.test.change", null, locale);
                                TaskMessageBody body = new TaskMessageBody();
                                body.setType(109);
                                body.setTaskJson(JSONObject.toJSONString((Object)vo));
                                checkVo.setTitle(testChange);
                                for (OperateCheckUser userVo : userList) {
                                    try {
                                        TrainingOperateServiceImpl.this.jPushService.sendWebSocket(testChange, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.update.data", new Object[]{vo.getCheckName()}, locale), userVo.getUserId(), vo.getEnterpriseId(), userVo.getUserId(), "TYPE_OPEUP_USER_TYPE", JSONObject.toJSONString((Object)checkVo), vo.getEndTime(), 0, 0, "training.operate.update.data", vo.getCheckName());
                                        if (vo.getIsSendMessage() == null || vo.getIsSendMessage() != 1) continue;
                                        TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEUP_USER_TYPE", userVo.getUserId(), testChange, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.update.data", new Object[]{vo.getCheckName()}, locale), body);
                                    }
                                    catch (Exception e) {
                                        log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5b9e\u64cd\u63a8\u9001", (Throwable)e);
                            }
                        }
                    });
                }
            }
        }
        return JsonResult.success((Object)check);
    }

    @Override
    public String getOperateCheckByPage(Page<OperateCheckVo> page, Integer groupId, String checkName, Integer status) {
        List<OperateCheckVo> checkList = this.operateCheckMapper.selectVoByPage(page, groupId, checkName, status);
        if (!CollectionUtils.isEmpty(checkList)) {
            for (OperateCheckVo operateCheckVo : checkList) {
                TrainingJobCertification job;
                if (operateCheckVo.getSource() != null && operateCheckVo.getSource().equals(1) && !ObjectUtils.isEmpty((Object)(job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(operateCheckVo.getBusinessKey())))) {
                    operateCheckVo.setSourceName(job.getCertificationName());
                }
                LambdaQueryWrapper templateWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)templateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckVo.getId())).orderByDesc(OperateCheckTemplate::getId);
                List checkTemplateList = this.operateCheckTemplateMapper.selectList((Wrapper)templateWrapper);
                if (!CollectionUtils.isEmpty((Collection)checkTemplateList)) {
                    OperateCheckTemplate checkTemplate = (OperateCheckTemplate)checkTemplateList.get(0);
                    LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                    detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
                    List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
                    operateCheckVo.setDetailNum(detailList.size());
                }
                if (operateCheckVo.getSource() != null) {
                    operateCheckVo.setStatus(Integer.valueOf(2));
                } else if (status == null) {
                    if (!operateCheckVo.getStatus().equals(0) && !operateCheckVo.getStatus().equals(3) && operateCheckVo.getStartTime() != null && operateCheckVo.getEndTime() != null && operateCheckVo.getStartTime().before(new Date()) && operateCheckVo.getEndTime().after(new Date())) {
                        operateCheckVo.setStatus(Integer.valueOf(2));
                    } else if (operateCheckVo.getEndTime() != null && operateCheckVo.getEndTime().before(new Date())) {
                        operateCheckVo.setStatus(Integer.valueOf(3));
                    }
                } else {
                    operateCheckVo.setStatus(status);
                }
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(OperateCheckUser::getEnterpriseId, (Object)operateCheckVo.getEnterpriseId());
                userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckVo.getId());
                List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
                if (CollectionUtils.isEmpty((Collection)userList)) continue;
                operateCheckVo.setCheckUserNum(userList.size());
                int checkUserFinishNum = 0;
                for (OperateCheckUser user : userList) {
                    LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                    operateWrapper.eq(UserOperate::getEnterpriseId, (Object)user.getEnterpriseId());
                    operateWrapper.eq(UserOperate::getUserId, (Object)user.getUserId());
                    operateWrapper.eq(UserOperate::getOperateCheckId, (Object)user.getOperateCheckId());
                    operateWrapper.eq(UserOperate::getStatus, (Object)3);
                    List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                    if (operateCheckVo.getCheckType().equals(0) ? CollectionUtils.isEmpty((Collection)operateList) || operateList.size() < operateCheckVo.getCheckNumber() : CollectionUtils.isEmpty((Collection)operateList)) continue;
                    ++checkUserFinishNum;
                }
                operateCheckVo.setCheckUserFinishNum(checkUserFinishNum);
            }
        }
        page.setContent(checkList);
        return JsonResult.success(page);
    }

    @Override
    public String getMyCheck(Integer groupId, Integer userId, Integer status) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        ArrayList<OperateCheckVo> checkVoList = new ArrayList<OperateCheckVo>();
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getEnterpriseId, (Object)groupId);
        examinerWrapper.eq(OperateCheckExaminer::getUserId, (Object)userId);
        if (status != null && status == 5) {
            examinerWrapper.isNotNull(OperateCheckExaminer::getUncheckDescribe);
        } else {
            examinerWrapper.isNull(OperateCheckExaminer::getUncheckDescribe);
        }
        List examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
        List<Integer> checkIdList = examinerList.stream().map(OperateCheckExaminer::getOperateCheckId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkIdList)) {
            List<OperateCheckVo> checkList = this.operateCheckMapper.selectListByStatus(checkIdList, status);
            block0: for (int i = 0; i < checkList.size(); ++i) {
                List operateList;
                LambdaQueryWrapper operateWrapper;
                TrainingJobCertification job;
                OperateCheckVo vo = checkList.get(i);
                if (vo.getSource() != null && vo.getSource().equals(1) && !ObjectUtils.isEmpty((Object)(job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(vo.getBusinessKey())))) {
                    vo.setSourceName(job.getCertificationName());
                }
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)vo.getId());
                userWrapper.eq(OperateCheckUser::getExaminerId, (Object)userId);
                List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
                if (CollectionUtils.isEmpty((Collection)userList)) {
                    String assessor = this.messageSource.getMessage("training.operate.assessor", null, locale);
                    vo.setListDescription(assessor);
                } else {
                    vo.setCheckUserNum(userList.size());
                    StringBuffer listDescription = new StringBuffer();
                    if (vo.getCheckType().equals(0)) {
                        listDescription.append(this.messageSource.getMessage("training.operate.need.person", new Object[]{userList.size(), vo.getCheckNumber()}, locale));
                    } else {
                        listDescription.append(this.messageSource.getMessage("training.operate.max.person", new Object[]{userList.size(), vo.getCheckNumber()}, locale));
                    }
                    vo.setListDescription(listDescription.toString());
                }
                int checkNum = 0;
                int checkTotalNum = 0;
                int checkUserFinishNum = 0;
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    for (OperateCheckUser user : userList) {
                        operateWrapper = new LambdaQueryWrapper();
                        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)user.getEnterpriseId());
                        operateWrapper.eq(UserOperate::getUserId, (Object)user.getUserId());
                        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)user.getOperateCheckId());
                        operateWrapper.eq(UserOperate::getStatus, (Object)3);
                        operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                        checkNum += operateList.size();
                        if (vo.getCheckType().equals(0) ? CollectionUtils.isEmpty((Collection)operateList) || operateList.size() < vo.getCheckNumber() : CollectionUtils.isEmpty((Collection)operateList)) continue;
                        ++checkUserFinishNum;
                    }
                    vo.setCheckUserFinishNum(checkUserFinishNum);
                    checkTotalNum = vo.getCheckType() == 1 ? userList.size() : userList.size() * vo.getCheckNumber();
                }
                vo.setCheckNum(checkNum);
                vo.setCheckTotalNum(checkTotalNum);
                if (vo.getStartTime() != null && vo.getStartTime().after(new Date()) && checkNum == 0) {
                    vo.setTimeStatus("0");
                } else if (vo.getEndTime() != null && vo.getEndTime().before(new Date()) || checkNum >= checkTotalNum) {
                    vo.setTimeStatus("2");
                } else {
                    vo.setTimeStatus("1");
                }
                if (status != null && status == 2) {
                    LambdaQueryWrapper statusWrapper = new LambdaQueryWrapper();
                    statusWrapper.eq(UserOperate::getEnterpriseId, (Object)vo.getEnterpriseId());
                    statusWrapper.eq(UserOperate::getOperateCheckId, (Object)vo.getId());
                    ArrayList<Integer> statusList = new ArrayList<Integer>();
                    statusList.add(1);
                    statusList.add(2);
                    statusList.add(3);
                    statusWrapper.in(UserOperate::getStatus, statusList);
                    List ingOperate = this.userOperateMapper.selectList((Wrapper)statusWrapper);
                    if (!CollectionUtils.isEmpty((Collection)ingOperate)) {
                        vo.setIngStatus(1);
                    }
                    if (checkUserFinishNum > 0 && checkUserFinishNum == userList.size()) continue;
                    vo.setStatus(Integer.valueOf(2));
                    checkVoList.add(vo);
                    continue;
                }
                if (status != null && status == 3) {
                    vo.setStatus(Integer.valueOf(3));
                    if (checkUserFinishNum <= 0 || checkUserFinishNum != userList.size()) continue;
                    checkVoList.add(vo);
                    continue;
                }
                if (status != null && status == 4) {
                    if (!CollectionUtils.isEmpty((Collection)userList)) {
                        for (OperateCheckUser user : userList) {
                            operateWrapper = new LambdaQueryWrapper();
                            operateWrapper.eq(UserOperate::getEnterpriseId, (Object)user.getEnterpriseId());
                            operateWrapper.eq(UserOperate::getUserId, (Object)user.getUserId());
                            operateWrapper.eq(UserOperate::getOperateCheckId, (Object)user.getOperateCheckId());
                            operateWrapper.eq(UserOperate::getStatus, (Object)3);
                            operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                            if (vo.getCheckType().equals(0)) {
                                if (CollectionUtils.isEmpty((Collection)operateList)) {
                                    checkVoList.add(vo);
                                    continue block0;
                                }
                                if (operateList.size() >= vo.getCheckNumber()) continue;
                                checkVoList.add(vo);
                                continue block0;
                            }
                            if (!CollectionUtils.isEmpty((Collection)operateList)) continue;
                            checkVoList.add(vo);
                            continue block0;
                        }
                        continue;
                    }
                    checkVoList.add(vo);
                    continue;
                }
                checkVoList.add(vo);
            }
            return JsonResult.success(checkVoList);
        }
        return JsonResult.success();
    }

    @Override
    public String getOperateCheckById(Integer operateCheckId) {
        List userIds;
        BaseResult userResult;
        OperateCheckVo vo = new OperateCheckVo();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        BeanUtils.copyProperties((Object)check, (Object)vo);
        if (check.getSource() != null && check.getSource().equals(1)) {
            TrainingJobCertification job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(check.getBusinessKey());
            vo.setSourceName(job.getCertificationName());
            vo.setJobStatus(job.getStatus());
        }
        if (check.getSource() != null || check.getStatus() != 3 && check.getStartTime() != null && check.getEndTime() != null && check.getStartTime().before(new Date()) && check.getEndTime().after(new Date())) {
            vo.setStatus(Integer.valueOf(2));
        } else if (vo.getEndTime() != null && vo.getEndTime().before(new Date())) {
            vo.setStatus(Integer.valueOf(3));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
        OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
        if (checkTemplate != null) {
            vo.setOperateTemplateName(checkTemplate.getTemplateName());
        }
        ArrayList<OperateCheckUserVo> checkExaminerList = new ArrayList<OperateCheckUserVo>();
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)operateCheckId);
        List examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
        if (!CollectionUtils.isEmpty((Collection)examinerList) && !(userResult = this.userApi.getUserByIdList(userIds = examinerList.stream().map(OperateCheckExaminer::getUserId).collect(Collectors.toList()))).getIsError().booleanValue()) {
            for (UsersPojo userPojo : (List)userResult.getData()) {
                OperateCheckUserVo user = new OperateCheckUserVo();
                user.setUserId(userPojo.getId());
                user.setShowName(userPojo.getShowName());
                user.setUserName(userPojo.getUserName());
                user.setThumbUrl(userPojo.getThumbUrl());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(userPojo.getId());
                    user.setOrganizes(list.get(0));
                }
                checkExaminerList.add(user);
            }
        }
        vo.setCheckExaminerList(checkExaminerList);
        return JsonResult.success((Object)vo);
    }

    @Override
    public String deleteCheckUser(Integer operateCheckId, final String showName, String userIds) {
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (check == null) {
            return "INVALID_PARAMETER";
        }
        if (check.getEndTime() != null && check.getEndTime().before(new Date())) {
            return "EXIST_DATA";
        }
        final String[] userIdsStr = userIds.split(",");
        for (int i = 0; i < userIdsStr.length; ++i) {
            LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
            operateWrapper.eq(UserOperate::getUserId, (Object)userIdsStr[i]);
            operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operateCheckId);
            List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
            if (CollectionUtils.isEmpty((Collection)operateList)) continue;
            return "EXIST_DATA";
        }
        if (check.getSource() != null && check.getSource() == 1) {
            LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
            taskWrapper.eq(TrainingJobStageTask::getJobId, (Object)check.getBusinessKey());
            taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
            taskWrapper.eq(TrainingJobStageTask::getOperateCheckId, (Object)check.getId());
            TrainingJobStageTask task = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectOne((Wrapper)taskWrapper);
            if (task != null) {
                LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)check.getBusinessKey());
                userTaskWrapper.eq(TrainingJobUserTask::getStageTaskId, (Object)task.getId());
                userTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)4);
                userTaskWrapper.in(TrainingJobUserTask::getUserId, Arrays.asList(userIdsStr));
                this.trainingJobUserTaskMapper.delete((Wrapper)userTaskWrapper);
            }
        }
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        List<String> userIdList = Arrays.asList(userIdsStr);
        checkWrapper.in(OperateCheckUser::getUserId, userIdList);
        this.operateCheckUserMapper.delete((Wrapper)checkWrapper);
        String testChange = this.messageSource.getMessage("training.operate.test.change", null, locale);
        final OperateCheckVo vo = new OperateCheckVo();
        vo.setTitle(testChange);
        vo.setId(check.getId());
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    String out = TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.out", new Object[]{showName}, locale);
                    String training = TrainingOperateServiceImpl.this.messageSource.getMessage("training", null, locale);
                    for (int i = 0; i < userIdsStr.length; ++i) {
                        Integer userId = Integer.parseInt(userIdsStr[i]);
                        TaskMessageBody body = new TaskMessageBody();
                        body.setType(110);
                        body.setTaskJson(JSONObject.toJSONString((Object)check));
                        try {
                            TrainingOperateServiceImpl.this.jPushService.sendWebSocket(check.getCheckName(), out, userId, check.getEnterpriseId(), check.getId(), "TYPE_OPEDEL_TYPE", JSONObject.toJSONString((Object)vo), check.getEndTime(), 1, 0, "training.operate.out", showName);
                            TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEDEL_TYPE", userId, training, out, body);
                            TrainingOperateServiceImpl.this.jPushService.deleteMessages(check.getId(), "TYPE_OPEADD_USER_TYPE", userId, null, 1);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        });
        return JsonResult.success();
    }

    @Override
    public String addCheckUser(Integer operateCheckId, Integer userId, String userIds) {
        final OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (check == null) {
            return "INVALID_PARAMETER";
        }
        final String[] userIdsStr = userIds.split(",");
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        final String zName = this.messageSource.getMessage("training.paper.expire.to", null, locale);
        final String operateName = this.messageSource.getMessage("training.operate.name", null, locale);
        if (check.getSource() != null && check.getSource().equals(1)) {
            List<Integer> validUserIds = this.trainingJobCertificationService.selectJobUserListByJobId(check.getBusinessKey());
            StringBuffer nameBuffer = new StringBuffer();
            for (int i = 0; i < userIdsStr.length; ++i) {
                BaseResult userResult;
                String userIdStr = userIdsStr[i];
                if (validUserIds.contains(Integer.parseInt(userIdStr)) || (userResult = this.userApi.getUserById(Integer.valueOf(Integer.parseInt(userIdStr)))).getIsError().booleanValue() || userResult.getData() == null) continue;
                nameBuffer.append(((UsersPojo)userResult.getData()).getShowName() + ",");
            }
            if (nameBuffer.length() > 0) {
                return JsonResult.error((String)"CHECK_USER_ERR", (Object)nameBuffer.substring(0, nameBuffer.length() - 1));
            }
        }
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        List<String> userIdList = Arrays.asList(userIdsStr);
        checkWrapper.in(OperateCheckUser::getUserId, userIdList);
        List list = this.operateCheckUserMapper.selectList((Wrapper)checkWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return "EXIST_DATA";
        }
        for (int i = 0; i < userIdsStr.length; ++i) {
            OperateCheckUser user = new OperateCheckUser();
            user.setEnterpriseId(check.getEnterpriseId());
            user.setOperateCheckId(operateCheckId);
            user.setUserId(Integer.valueOf(Integer.parseInt(userIdsStr[i])));
            user.setExaminerId(userId);
            this.operateCheckUserMapper.insert(user);
        }
        final String testChange = this.messageSource.getMessage("training.operate.test.change", null, locale);
        final OperateCheckVo vo = new OperateCheckVo();
        vo.setTitle(testChange);
        vo.setId(check.getId());
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < userIdsStr.length; ++i) {
                        Integer userId = Integer.parseInt(userIdsStr[i]);
                        TaskMessageBody body = new TaskMessageBody();
                        body.setType(107);
                        body.setTaskJson(JSONObject.toJSONString((Object)check));
                        try {
                            TrainingOperateServiceImpl.this.jPushService.sendWebSocket(testChange, TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.three", new Object[]{check.getCheckName(), check.getCheckNumber()}, locale), userId, check.getEnterpriseId(), check.getId(), "TYPE_OPEADD_USER_TYPE", JSONObject.toJSONString((Object)vo), check.getEndTime(), 1, 1, "training.operate.need.check.three", check.getCheckName() + "," + check.getCheckNumber());
                            TrainingOperateServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_OPEADD_USER_TYPE", userId, operateName, MessageFormat.format(TrainingOperateServiceImpl.this.messageSource.getMessage("training.operate.need.check.four", new Object[]{check.getCheckName(), check.getCheckNumber()}, locale), vo.getCheckName(), vo.getCheckNumber()) + "\n" + TrainingOperateServiceImpl.this.messageSource.getMessage("training.certificate.validity", null, locale) + ":" + DateUtils.format(check.getStartTime(), "yyyy-MM-dd HH:mm") + zName + DateUtils.format(check.getEndTime(), "yyyy-MM-dd HH:mm"), body);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u8003\u8bd5\u5b9a\u65f6\u63a8\u9001", (Throwable)e);
                }
            }
        });
        return JsonResult.success();
    }

    @Override
    public String getCheckMe(Integer groupId, Integer userId, Integer status) {
        ArrayList<OperateCheckVo> checkVoList = new ArrayList<OperateCheckVo>();
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getEnterpriseId, (Object)groupId);
        userWrapper.eq(OperateCheckUser::getUserId, (Object)userId);
        List examinerList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        List<Integer> checkIdList = examinerList.stream().map(OperateCheckUser::getOperateCheckId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkIdList)) {
            List<OperateCheckVo> checkList = this.operateCheckMapper.selectListByStatus(checkIdList, status);
            for (OperateCheckVo vo : checkList) {
                OperateCheckExaminer examiner;
                TrainingJobCertification job;
                if (vo.getSource() != null && vo.getSource().equals(1) && !ObjectUtils.isEmpty((Object)(job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(vo.getBusinessKey())))) {
                    vo.setSourceName(job.getCertificationName());
                }
                LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
                examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)vo.getId());
                examinerWrapper.eq(OperateCheckExaminer::getUserId, (Object)userId);
                List examList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
                if (!CollectionUtils.isEmpty((Collection)examList) && !org.springframework.util.StringUtils.isEmpty((Object)(examiner = (OperateCheckExaminer)examList.get(0)).getUncheckDescribe())) {
                    vo.setUncheckDescribe(examiner.getUncheckDescribe());
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)vo.getId());
                OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
                vo.setTotalScore(checkTemplate.getTotalScore().floatValue());
                vo.setPassScore(checkTemplate.getPassScore().floatValue());
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
                List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
                vo.setDetailNum(detailList.size());
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)vo.getEnterpriseId());
                operateWrapper.eq(UserOperate::getUserId, (Object)userId);
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)vo.getId());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(2);
                statusList.add(3);
                operateWrapper.in(UserOperate::getStatus, statusList);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (vo.getCheckType() == 1) {
                    vo.setCheckTotalNum(1);
                } else {
                    vo.setCheckTotalNum(vo.getCheckNumber().intValue());
                }
                if (!CollectionUtils.isEmpty((Collection)operateList)) {
                    vo.setCheckNum(operateList.size());
                }
                if (status != null && status == 2) {
                    LambdaQueryWrapper statusWrapper = new LambdaQueryWrapper();
                    statusWrapper.eq(UserOperate::getEnterpriseId, (Object)vo.getEnterpriseId());
                    statusWrapper.eq(UserOperate::getUserId, (Object)userId);
                    statusWrapper.eq(UserOperate::getOperateCheckId, (Object)vo.getId());
                    statusWrapper.eq(UserOperate::getStatus, (Object)1);
                    List ingOperate = this.userOperateMapper.selectList((Wrapper)statusWrapper);
                    if (!CollectionUtils.isEmpty((Collection)ingOperate)) {
                        vo.setIngStatus(1);
                    }
                    if (vo.getCheckType().equals(0) ? !CollectionUtils.isEmpty((Collection)operateList) && operateList.size() >= vo.getCheckNumber() : !CollectionUtils.isEmpty((Collection)operateList)) continue;
                    vo.setStatus(Integer.valueOf(2));
                    checkVoList.add(vo);
                    continue;
                }
                if (status != null && status == 3) {
                    if (vo.getCheckScoreChoice().equals("0")) {
                        if (CollectionUtils.isEmpty((Collection)operateList) || operateList.size() < vo.getCheckNumber()) continue;
                        vo.setTotalScore(0.0f);
                        for (UserOperate userOperate : operateList) {
                            if (userOperate.getScore() == null || !(vo.getTotalScore() <= userOperate.getScore().floatValue())) continue;
                            vo.setTotalScore(userOperate.getScore().floatValue());
                            vo.setIsPass(userOperate.getIsPass());
                        }
                        vo.setStatus(Integer.valueOf(3));
                        checkVoList.add(vo);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)operateList)) continue;
                    for (int i = operateList.size() - 1; i >= 0; --i) {
                        UserOperate operate = (UserOperate)operateList.get(i);
                        if (operate.getIsPass() == null) continue;
                        vo.setIsPass(operate.getIsPass());
                        break;
                    }
                    checkVoList.add(vo);
                    continue;
                }
                if (status != null && status == 4) {
                    if (vo.getCheckType().equals(0)) {
                        if (CollectionUtils.isEmpty((Collection)operateList)) {
                            checkVoList.add(vo);
                            continue;
                        }
                        if (operateList.size() >= vo.getCheckNumber()) continue;
                        checkVoList.add(vo);
                        continue;
                    }
                    if (!vo.getCheckType().equals(1) || !CollectionUtils.isEmpty((Collection)operateList)) continue;
                    checkVoList.add(vo);
                    continue;
                }
                checkVoList.add(vo);
            }
            return JsonResult.success(checkVoList);
        }
        return JsonResult.success();
    }

    @Override
    public String addUncheckDescribe(Integer userId, Integer operateCheckId, String uncheckDescribe) {
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)operateCheckId);
        examinerWrapper.eq(OperateCheckExaminer::getUserId, (Object)userId);
        List examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
        if (!CollectionUtils.isEmpty((Collection)examinerList)) {
            OperateCheckExaminer examiner = (OperateCheckExaminer)examinerList.get(0);
            examiner.setUncheckDescribe(uncheckDescribe);
            this.operateCheckExaminerMapper.updateById(examiner);
        }
        return JsonResult.success();
    }

    @Override
    public String joinCheck(Integer groupId, Integer userId, Integer operateCheckId) {
        UserOperateVo result = new UserOperateVo();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        BaseResult myUserResult = this.userApi.getUserById(userId);
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            result.setUserId(userPojo.getId());
            result.setShowName(userPojo.getShowName());
            result.setUserName(userPojo.getUserName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                result.setOrganizes(list.get(0));
            }
        }
        Integer userOperateId = null;
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        operateWrapper.eq(UserOperate::getStatus, (Object)1);
        List list = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.error(null, (Object)this.messageSource.getMessage("training.operate.not.exam", null, locale));
        }
        userOperateId = ((UserOperate)list.get(0)).getId();
        result.setRemainingTime(((UserOperate)list.get(0)).getRemainingTime());
        com.ovopark.pojo.BaseResult examinerResult = this.redisBaseApi.get("checkIngExaminer" + userOperateId);
        if (!examinerResult.getIsError().booleanValue() && org.springframework.util.StringUtils.isEmpty((Object)examinerResult.getData())) {
            return JsonResult.error(null, (Object)this.messageSource.getMessage("training.operate.not.enter", null, locale));
        }
        result.setId(userOperateId);
        result.setCheckDuration(check.getCheckDuration());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(Integer.valueOf(detailList.size()));
        ArrayList<UserOperateCatagoryVo> catagoryList = new ArrayList<UserOperateCatagoryVo>();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        List<String> catagoryNameList = this.userOperateDetailMapper.groupByCatagory(userOperateId);
        for (String catagoryName : catagoryNameList) {
            LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
            categoryWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
            categoryWrapper.eq(UserOperateDetail::getCategoryName, (Object)catagoryName);
            List catagoryDetailList = this.userOperateDetailMapper.selectList((Wrapper)categoryWrapper);
            UserOperateCatagoryVo catagoryVo = new UserOperateCatagoryVo();
            catagoryVo.setCatagoryName(catagoryName);
            ArrayList<UserOperateDetailVo> detailVoList = new ArrayList<UserOperateDetailVo>();
            for (UserOperateDetail detail : catagoryDetailList) {
                UserOperateDetailVo detailVo = new UserOperateDetailVo();
                BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailParameter())) {
                    detailVo.setPatameterList(JSONObject.parseArray((String)detail.getDetailParameter(), TrainingMaterialParameter.class));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailUrl())) {
                    detailVo.setUrlList(JSONObject.parseArray((String)detail.getDetailUrl(), TrainingMaterialProductPicture.class));
                }
                if (detail.getDetailType().equals(2)) {
                    ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
                    LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperateId);
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
                    List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    for (UserOperateDetailData detailData : detailDataList) {
                        UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                        BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                        if (take.equals(detailData.getDataName())) {
                            detailDataVo.setIsNeedScan(1);
                        }
                        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
                        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
                        List attaList = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                        if (!CollectionUtils.isEmpty((Collection)attaList)) {
                            detailDataVo.setAttaList(attaList);
                        }
                        detailDataVoList.add(detailDataVo);
                    }
                    detailVo.setDetailDataList(detailDataVoList);
                }
                LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
                attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detail.getId());
                List attaList = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                if (!CollectionUtils.isEmpty((Collection)attaList)) {
                    detailVo.setAttaList(attaList);
                }
                detailVoList.add(detailVo);
            }
            catagoryVo.setDetailList(detailVoList);
            catagoryList.add(catagoryVo);
        }
        result.setCatagoryList(catagoryList);
        return JsonResult.success((Object)result);
    }

    private void saveJobUserTask(OperateCheck check, Integer userId) {
        if (check.getSource() != null && check.getSource() == 1) {
            LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
            taskWrapper.eq(TrainingJobStageTask::getJobId, (Object)check.getBusinessKey());
            taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
            taskWrapper.eq(TrainingJobStageTask::getOperateCheckId, (Object)check.getId());
            TrainingJobStageTask task = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectOne((Wrapper)taskWrapper);
            if (!ObjectUtils.isEmpty((Object)task)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingJobUserTask::getUserId, (Object)userId)).eq(TrainingJobUserTask::getJobId, (Object)check.getBusinessKey())).eq(TrainingJobUserTask::getStageTaskId, (Object)task.getId());
                List trainingJobUserTasks = this.trainingJobUserTaskMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)trainingJobUserTasks)) {
                    TrainingJobUserTask userTask = new TrainingJobUserTask();
                    userTask.setJobId(check.getBusinessKey());
                    userTask.setStageTaskId(task.getId());
                    userTask.setTaskType(Integer.valueOf(4));
                    userTask.setUserId(userId);
                    userTask.setTaskStatus(Integer.valueOf(1));
                    userTask.setStartTime(new Date());
                    userTask.setCreateTime(new Date());
                    userTask.setCreaterId(userId);
                    userTask.setEnterpriseId(check.getEnterpriseId());
                    this.trainingJobUserTaskMapper.insert(userTask);
                }
            }
        }
    }

    @Override
    public String answerQuestions(Integer userOperateDetailDataId, String answer, String remainingTime, Integer isRight) {
        UserOperateDetailData detailData = (UserOperateDetailData)this.userOperateDetailDataMapper.selectById(userOperateDetailDataId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)answer)) {
            detailData.setAnswer(answer);
            detailData.setIsRight(null);
            detailData.setScore(null);
        }
        detailData.setIsRight(isRight);
        if (isRight != null) {
            if (isRight.equals(1)) {
                detailData.setScore(detailData.getTotalScore());
            } else {
                detailData.setScore(Float.valueOf(0.0f));
            }
        }
        this.userOperateDetailDataMapper.updateById(detailData);
        if (userOperateDetailDataId != null) {
            UserOperateDetailDataScan scan = new UserOperateDetailDataScan();
            scan.setCreateTime(new Date());
            scan.setUserOperateId(detailData.getUserOperateId());
            scan.setUserOperateDetailDataId(userOperateDetailDataId);
            scan.setDetailName(detailData.getDataName());
            scan.setAnswer(answer);
            scan.setIsRight(isRight);
            this.userOperateDetailDataScanMapper.insert(scan);
        }
        UserOperate operate = (UserOperate)this.userOperateMapper.selectById(detailData.getUserOperateId());
        operate.setRemainingTime(remainingTime);
        if (operate.getStatus().equals(0)) {
            operate.setStatus(Integer.valueOf(1));
        }
        this.userOperateMapper.updateById(operate);
        return JsonResult.success();
    }

    @Override
    public String examinerHandPapers(Integer userOperateId, String examinerRemark, String remainingTime) {
        OperateCheck check;
        Integer hasRedline = 0;
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        Float totalScore = Float.valueOf(0.0f);
        Float unUseScore = Float.valueOf(0.0f);
        Integer hasDetailData = 0;
        for (UserOperateDetail userOperateDetail : detailList) {
            if (userOperateDetail.getDetailType().equals(2)) {
                hasDetailData = 1;
            }
            if (userOperateDetail.getIsRight() != null && userOperateDetail.getIsRight().equals(-1)) {
                unUseScore = Float.valueOf(unUseScore.floatValue() + userOperateDetail.getTotalScore().floatValue());
            }
            if (userOperateDetail.getScore() == null) continue;
            totalScore = Float.valueOf(totalScore.floatValue() + userOperateDetail.getScore().floatValue());
            if (userOperateDetail.getIsRedline() == null || !userOperateDetail.getIsRedline().equals(1) || userOperateDetail.getIsRight() == null || userOperateDetail.getIsRight() != 0) continue;
            hasRedline = 1;
        }
        UserOperate operate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        if (operate.getStatus() != 2 && hasDetailData == 1) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            return JsonResult.error((String)"CHECK_UNFINISHED", (Object)this.messageSource.getMessage("training.operate.after.paper", null, locale));
        }
        operate.setStatus(Integer.valueOf(3));
        LambdaQueryWrapper templateWrapper = new LambdaQueryWrapper();
        templateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operate.getOperateCheckId());
        OperateCheckTemplate template = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)templateWrapper);
        if (operate.getFinishTime() == null) {
            operate.setFinishTime(new Date());
        }
        operate.setExaminerRemark(examinerRemark);
        operate.setRemainingTime(remainingTime);
        this.userOperateMapper.updateById(operate);
        if (hasRedline == 0) {
            check = (OperateCheck)this.operateCheckMapper.selectById(template.getOperateCheckId());
            if (totalScore.floatValue() >= template.getPassScore().floatValue() - unUseScore.floatValue() * (float)check.getPassLine().intValue() / 100.0f) {
                operate.setIsPass(Integer.valueOf(1));
            } else {
                operate.setIsPass(Integer.valueOf(0));
            }
        } else {
            operate.setIsPass(Integer.valueOf(0));
        }
        if (hasRedline == 1) {
            operate.setScore(Float.valueOf(0.0f));
        } else {
            operate.setScore(totalScore);
        }
        this.userOperateMapper.updateById(operate);
        check = (OperateCheck)this.operateCheckMapper.selectById(operate.getOperateCheckId());
        if (check.getSource() != null && check.getSource() == 1) {
            this.updateJobUserTask(operate, check, template);
        }
        return JsonResult.success();
    }

    private void updateJobUserTask(UserOperate operate, OperateCheck check, OperateCheckTemplate template) {
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getUserId, (Object)operate.getUserId());
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.in(UserOperate::getStatus, Arrays.asList(2, 3));
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
        taskWrapper.eq(TrainingJobStageTask::getJobId, (Object)check.getBusinessKey());
        taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
        taskWrapper.eq(TrainingJobStageTask::getOperateCheckId, (Object)operate.getOperateCheckId());
        TrainingJobStageTask task = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectOne((Wrapper)taskWrapper);
        if (!ObjectUtils.isEmpty((Object)task)) {
            LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
            userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)check.getBusinessKey());
            userTaskWrapper.eq(TrainingJobUserTask::getStageTaskId, (Object)task.getId());
            userTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)4);
            userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)operate.getUserId());
            List userTaskList = this.trainingJobUserTaskMapper.selectList((Wrapper)userTaskWrapper);
            if (!CollectionUtils.isEmpty((Collection)userTaskList) && !CollectionUtils.isEmpty((Collection)operateList)) {
                UserOperate maxOperate;
                UserOperate userOperate2;
                Integer taskStatus = 4;
                BigDecimal score = BigDecimal.ZERO;
                int totalUseTime = 0;
                for (UserOperate userOperate2 : operateList) {
                    if (userOperate2.getRemainingTime() == null) continue;
                    totalUseTime += Integer.parseInt(userOperate2.getRemainingTime()) / 1000;
                }
                int useTime = check.getCheckDuration() * 60 - totalUseTime / operateList.size();
                if (check.getCheckType().equals(1)) {
                    if (check.getCheckScoreChoice().equals("0")) {
                        maxOperate = operateList.stream().filter(e -> e.getScore() != null).max(Comparator.comparing(UserOperate::getScore)).orElse(null);
                        if (!ObjectUtils.isEmpty((Object)maxOperate) && maxOperate.getScore() != null) {
                            score = new BigDecimal(maxOperate.getScore().floatValue());
                            if (template.getPassScore().floatValue() > maxOperate.getScore().floatValue()) {
                                taskStatus = 3;
                            }
                        } else {
                            taskStatus = 1;
                        }
                    } else {
                        userOperate2 = (UserOperate)operateList.get(operateList.size() - 1);
                        if (!ObjectUtils.isEmpty((Object)userOperate2) && userOperate2.getScore() != null) {
                            score = new BigDecimal(userOperate2.getScore().floatValue());
                            if (template.getPassScore().floatValue() > userOperate2.getScore().floatValue()) {
                                taskStatus = 3;
                            }
                        } else {
                            taskStatus = 1;
                        }
                    }
                } else if (operateList.size() >= check.getCheckNumber()) {
                    if (check.getCheckScoreChoice().equals("0")) {
                        maxOperate = operateList.stream().filter(e -> e.getScore() != null).max(Comparator.comparing(UserOperate::getScore)).orElse(null);
                        if (!ObjectUtils.isEmpty((Object)maxOperate) && maxOperate.getScore() != null) {
                            score = new BigDecimal(maxOperate.getScore().floatValue());
                            if (template.getPassScore().floatValue() > maxOperate.getScore().floatValue()) {
                                taskStatus = 3;
                            }
                        } else {
                            taskStatus = 1;
                        }
                    } else {
                        userOperate2 = (UserOperate)operateList.get(operateList.size() - 1);
                        if (!ObjectUtils.isEmpty((Object)userOperate2) && userOperate2.getScore() != null) {
                            score = new BigDecimal(userOperate2.getScore().floatValue());
                            if (template.getPassScore().floatValue() > userOperate2.getScore().floatValue()) {
                                taskStatus = 3;
                            }
                        } else {
                            taskStatus = 1;
                        }
                    }
                }
                for (TrainingJobUserTask userTask : userTaskList) {
                    userTask.setTaskStatus(taskStatus);
                    userTask.setUseTime(Integer.valueOf(useTime));
                    if (taskStatus != 1) {
                        userTask.setScore(score);
                        if (userTask.getEndTime() == null) {
                            userTask.setEndTime(new Date());
                        }
                    }
                    this.trainingJobUserTaskMapper.updateById(userTask);
                    this.trainingJobCertificationService.getIsFinishAllTask(userTask.getJobId(), userTask.getUserId());
                }
            }
        }
    }

    @Override
    public String verifyQuestions(VerifyQuestionsReq req) {
        List list;
        LambdaQueryWrapper detailDataWrapper;
        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
        if (req.getUserOperateDetailId() != null) {
            attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
            attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)req.getUserOperateDetailId());
        } else if (req.getUserOperateDetailDataId() != null) {
            attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
            attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)req.getUserOperateDetailDataId());
        }
        this.userOperateAttaMapper.delete((Wrapper)attaWrapper);
        if (req.getUserOperateDetailId() != null) {
            UserOperate operate;
            UserOperateDetail detail = (UserOperateDetail)this.userOperateDetailMapper.selectById(req.getUserOperateDetailId());
            detail.setScore(req.getScore());
            detail.setIsRight(req.getIsRight());
            detail.setComment(req.getComment());
            this.userOperateDetailMapper.updateById(detail);
            if (req.getIsRight() != null) {
                UserOperateDetailData detailData;
                Iterator iterator;
                Object detailDatalist;
                if (req.getIsRight() == -1) {
                    detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)req.getUserOperateDetailId());
                    detailDatalist = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    if (!CollectionUtils.isEmpty((Collection)detailDatalist)) {
                        iterator = detailDatalist.iterator();
                        while (iterator.hasNext()) {
                            detailData = (UserOperateDetailData)iterator.next();
                            detailData.setIsRight(Integer.valueOf(-1));
                            this.userOperateDetailDataMapper.updateById(detailData);
                        }
                    }
                } else if (req.getIsRight() == -2) {
                    detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)req.getUserOperateDetailId());
                    detailDatalist = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    if (!CollectionUtils.isEmpty((Collection)detailDatalist)) {
                        iterator = detailDatalist.iterator();
                        while (iterator.hasNext()) {
                            detailData = (UserOperateDetailData)iterator.next();
                            detailData.setIsRight(null);
                            this.userOperateDetailDataMapper.updateById(detailData);
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)req.getAttaList())) {
                list = req.getAttaList();
                for (UserOperateAtta atta : list) {
                    atta.setCreateTime(new Date());
                    atta.setDetailType(Integer.valueOf(1));
                    atta.setBusinessKey(req.getUserOperateDetailId());
                    this.userOperateAttaMapper.insert(atta);
                }
            }
            if ((operate = (UserOperate)this.userOperateMapper.selectById(detail.getUserOperateId())).getStatus().equals(0)) {
                operate.setStatus(Integer.valueOf(1));
            }
            this.userOperateMapper.updateById(operate);
        }
        if (req.getUserOperateDetailDataId() != null) {
            UserOperateDetailData detailData = (UserOperateDetailData)this.userOperateDetailDataMapper.selectById(req.getUserOperateDetailDataId());
            detailData.setScore(req.getScore());
            if (req.getIsRight() == -2) {
                detailData.setIsRight(null);
            } else {
                detailData.setIsRight(req.getIsRight());
            }
            detailData.setComment(req.getComment());
            this.userOperateDetailDataMapper.updateById(detailData);
            if (!CollectionUtils.isEmpty((Collection)req.getAttaList())) {
                list = req.getAttaList();
                for (UserOperateAtta atta : list) {
                    atta.setCreateTime(new Date());
                    atta.setDetailType(Integer.valueOf(2));
                    atta.setBusinessKey(req.getUserOperateDetailDataId());
                    this.userOperateAttaMapper.insert(atta);
                }
            }
            detailDataWrapper = new LambdaQueryWrapper();
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)detailData.getUserOperateId());
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detailData.getUserOperateDetailId());
            List list2 = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
            Integer hasRedline = 0;
            Float totalScore = Float.valueOf(0.0f);
            for (UserOperateDetailData data : list2) {
                if (data.getScore() != null) {
                    totalScore = Float.valueOf(totalScore.floatValue() + data.getScore().floatValue());
                }
                if (data.getIsRedline() == null || !data.getIsRedline().equals(1) || data.getIsRight() == null || data.getIsRight() != 0) continue;
                hasRedline = 1;
            }
            UserOperateDetail detail = (UserOperateDetail)this.userOperateDetailMapper.selectById(detailData.getUserOperateDetailId());
            detail.setScore(totalScore);
            if (hasRedline == 1) {
                detail.setIsRedline(Integer.valueOf(1));
                detail.setIsRight(Integer.valueOf(0));
            }
            this.userOperateDetailMapper.updateById(detail);
            UserOperate operate = (UserOperate)this.userOperateMapper.selectById(detail.getUserOperateId());
            this.userOperateMapper.updateById(operate);
        }
        return JsonResult.success();
    }

    @Override
    public String getMyCheckDetail(Integer operateCheckId, Integer userId) {
        BaseResult myUserResult;
        OperateCheckExaminer examiner;
        OperateCheckVo result = new OperateCheckVo();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (ObjectUtils.isEmpty((Object)check)) {
            return JsonResult.success((Object)result);
        }
        BeanUtils.copyProperties((Object)check, (Object)result);
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)operateCheckId);
        examinerWrapper.eq(OperateCheckExaminer::getUserId, (Object)userId);
        List examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
        if (!CollectionUtils.isEmpty((Collection)examinerList) && !org.springframework.util.StringUtils.isEmpty((Object)(examiner = (OperateCheckExaminer)examinerList.get(0)).getUncheckDescribe())) {
            result.setUncheckDescribe(examiner.getUncheckDescribe());
        }
        if (check.getSource() != null && check.getSource().equals(1)) {
            TrainingJobCertification job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(check.getBusinessKey());
            result.setSourceName(job.getCertificationName());
        }
        if (!(myUserResult = this.userApi.getUserById(userId)).getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            OperateCheckUserVo user = new OperateCheckUserVo();
            result.setUserId(userPojo.getId());
            user.setShowName(userPojo.getShowName());
            user.setUserName(userPojo.getUserName());
            user.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                user.setOrganizes(list.get(0));
            }
        }
        if (check.getStartTime() != null && check.getStartTime().after(new Date())) {
            result.setTimeStatus("0");
        } else if (check.getEndTime() != null && check.getEndTime().before(new Date())) {
            result.setTimeStatus("2");
        } else {
            result.setTimeStatus("1");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
        OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
        result.setTotalScore(checkTemplate.getTotalScore().floatValue());
        result.setPassScore(checkTemplate.getPassScore().floatValue());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
        List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(detailList.size());
        ArrayList<OperateCheckUserVo> checkExaminerList = new ArrayList<OperateCheckUserVo>();
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        userWrapper.eq(OperateCheckUser::getExaminerId, (Object)userId);
        List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        List userIds = userList.stream().map(OperateCheckUser::getUserId).collect(Collectors.toList());
        BaseResult userResult = this.userApi.getUserByIdList(userIds);
        if (!userResult.getIsError().booleanValue()) {
            for (UsersPojo userPojo : (List)userResult.getData()) {
                OperateCheckUserVo user = new OperateCheckUserVo();
                user.setUserId(userPojo.getId());
                user.setShowName(userPojo.getShowName());
                user.setUserName(userPojo.getUserName());
                user.setThumbUrl(userPojo.getThumbUrl());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(userPojo.getId());
                    user.setOrganizes(list.get(0));
                }
                if (check.getCheckType().equals(1)) {
                    user.setCheckNumber(Integer.valueOf(1));
                } else {
                    user.setCheckNumber(check.getCheckNumber());
                }
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getUserId, (Object)userPojo.getUserId());
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
                operateWrapper.eq(UserOperate::getStatus, (Object)3);
                operateWrapper.orderByAsc(UserOperate::getCreateTime);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (!CollectionUtils.isEmpty((Collection)operateList)) {
                    user.setUserCheckNumber(operateList.size());
                    if (check.getCheckScoreChoice().equals("0")) {
                        for (UserOperate userOperate : operateList) {
                            if (userOperate.getScore() == null || !(user.getScore() <= userOperate.getScore().floatValue())) continue;
                            user.setScore(userOperate.getScore().floatValue());
                            user.setIsPass(userOperate.getIsPass());
                        }
                    } else if (check.getCheckScoreChoice().equals("1")) {
                        for (int i = operateList.size() - 1; i >= 0; --i) {
                            UserOperate operate = (UserOperate)operateList.get(i);
                            if (operate.getScore() == null || operate.getIsPass() == null) continue;
                            user.setScore(operate.getScore().floatValue());
                            user.setIsPass(operate.getIsPass());
                            break;
                        }
                    }
                    if (check.getCheckType().equals(0)) {
                        if (operateList.size() >= check.getCheckNumber()) {
                            user.setFinishTime(((UserOperate)operateList.get(check.getCheckNumber() - 1)).getCreateTime());
                        }
                    } else if (check.getCheckType().equals(1)) {
                        user.setFinishTime(((UserOperate)operateList.get(0)).getCreateTime());
                    }
                }
                checkExaminerList.add(user);
            }
        }
        result.setCheckExaminerList(checkExaminerList);
        return JsonResult.success((Object)result);
    }

    @Override
    public String getCheckMeDetail(Integer operateCheckId, Integer userId) {
        List userList;
        OperateCheckVo result = new OperateCheckVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (ObjectUtils.isEmpty((Object)check)) {
            return JsonResult.success((Object)result);
        }
        BeanUtils.copyProperties((Object)check, (Object)result);
        if (check.getSource() != null && check.getSource().equals(1)) {
            List<Integer> validUserIds = this.trainingJobCertificationService.selectJobUserListByJobId(check.getBusinessKey());
            if (!validUserIds.contains(userId)) {
                LambdaQueryWrapper checkUserWrapper = new LambdaQueryWrapper();
                checkUserWrapper.eq(OperateCheckUser::getEnterpriseId, (Object)check.getEnterpriseId());
                checkUserWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
                checkUserWrapper.eq(OperateCheckUser::getUserId, (Object)userId);
                this.operateCheckUserMapper.delete((Wrapper)checkUserWrapper);
                LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
                taskWrapper.eq(TrainingJobStageTask::getJobId, (Object)check.getBusinessKey());
                taskWrapper.eq(TrainingJobStageTask::getTaskType, (Object)4);
                taskWrapper.eq(TrainingJobStageTask::getOperateCheckId, (Object)check.getId());
                TrainingJobStageTask task = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectOne((Wrapper)taskWrapper);
                if (task != null) {
                    LambdaQueryWrapper userTaskWrapper = new LambdaQueryWrapper();
                    userTaskWrapper.eq(TrainingJobUserTask::getJobId, (Object)check.getBusinessKey());
                    userTaskWrapper.eq(TrainingJobUserTask::getStageTaskId, (Object)task.getId());
                    userTaskWrapper.eq(TrainingJobUserTask::getTaskType, (Object)4);
                    userTaskWrapper.eq(TrainingJobUserTask::getUserId, (Object)userId);
                    this.trainingJobUserTaskMapper.delete((Wrapper)userTaskWrapper);
                }
                return JsonResult.error((String)"CHECK_UPDATE_ERR", (Object)this.messageSource.getMessage("training.operate.change.content", null, locale));
            }
            TrainingJobCertification job = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(check.getBusinessKey());
            result.setSourceName(job.getCertificationName());
            LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
            examinerWrapper.eq(OperateCheckExaminer::getEnterpriseId, (Object)check.getEnterpriseId());
            examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)check.getId());
            List list = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
            if (CollectionUtils.isEmpty((Collection)list)) {
                result.setListDescription(this.messageSource.getMessage("training.operate.manage.content", null, locale));
                ArrayList<UserBo> userBoList = new ArrayList<UserBo>();
                LambdaQueryWrapper jobUserWrapper = new LambdaQueryWrapper();
                jobUserWrapper.eq(TrainingJobUser::getJobId, (Object)check.getBusinessKey());
                jobUserWrapper.eq(TrainingJobUser::getJobType, (Object)1);
                List jobUserList = this.trainingJobUserMapper.selectList((Wrapper)jobUserWrapper);
                if (!CollectionUtils.isEmpty((Collection)jobUserList)) {
                    for (TrainingJobUser jobUser : jobUserList) {
                        BaseResult userResult = this.userApi.getUserById(jobUser.getUserId());
                        if (userResult.getIsError().booleanValue() || userResult.getData() == null) continue;
                        UserBo userBo = new UserBo();
                        BeanUtils.copyProperties((Object)userResult.getData(), (Object)userBo);
                        userBoList.add(userBo);
                    }
                    result.setListDescriptionUserList(userBoList);
                }
            }
            LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
            userWrapper.eq(OperateCheckUser::getEnterpriseId, (Object)check.getEnterpriseId());
            userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)check.getId());
            userWrapper.eq(OperateCheckUser::getUserId, (Object)userId);
            List userlist = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
            if (CollectionUtils.isEmpty((Collection)userlist)) {
                LambdaQueryWrapper checkUserWrapper = new LambdaQueryWrapper();
                checkUserWrapper.eq(OperateCheckExaminer::getEnterpriseId, (Object)check.getEnterpriseId());
                checkUserWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)check.getId());
                List checkUserlist = this.operateCheckExaminerMapper.selectList((Wrapper)checkUserWrapper);
                if (!CollectionUtils.isEmpty((Collection)checkUserlist)) {
                    result.setListDescription(this.messageSource.getMessage("training.operate.start.join.content", null, locale));
                    ArrayList<UserBo> userBoList = new ArrayList<UserBo>();
                    for (OperateCheckExaminer jobUser : checkUserlist) {
                        BaseResult userResult = this.userApi.getUserById(jobUser.getUserId());
                        if (!userResult.getIsError().booleanValue() && userResult.getData() != null) {
                            UserBo userBo = new UserBo();
                            BeanUtils.copyProperties((Object)userResult.getData(), (Object)userBo);
                            userBoList.add(userBo);
                        }
                        result.setListDescriptionUserList(userBoList);
                    }
                }
            }
        }
        if (check.getStartTime() != null) {
            if (check.getStartTime().after(new Date())) {
                result.setTimeStatus("0");
            } else if (check.getEndTime().before(new Date())) {
                result.setTimeStatus("2");
            } else {
                result.setTimeStatus("1");
            }
        } else {
            result.setTimeStatus("1");
        }
        OperateCheckUserVo user = new OperateCheckUserVo();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
        OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
        if (ObjectUtils.isEmpty((Object)checkTemplate)) {
            return JsonResult.success((Object)result);
        }
        result.setTotalScore(checkTemplate.getTotalScore().floatValue());
        result.setPassScore(checkTemplate.getPassScore().floatValue());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
        List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(detailList.size());
        LambdaQueryWrapper checkUserWrapper = new LambdaQueryWrapper();
        checkUserWrapper.eq(OperateCheckUser::getEnterpriseId, (Object)check.getEnterpriseId());
        checkUserWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)check.getId());
        List checklist = this.operateCheckUserMapper.selectList((Wrapper)checkUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)checklist) && (userList = checklist.stream().map(OperateCheckUser::getUserId).collect(Collectors.toList())).contains(userId)) {
            BaseResult userResult = this.userApi.getUserById(userId);
            if (!userResult.getIsError().booleanValue()) {
                UsersPojo userPojo = (UsersPojo)userResult.getData();
                user.setUserId(userPojo.getId());
                user.setShowName(userPojo.getShowName());
                user.setUserName(userPojo.getUserName());
                user.setThumbUrl(userPojo.getThumbUrl());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(userPojo.getId());
                    user.setOrganizes(list.get(0));
                }
                if (check.getCheckType().equals(1)) {
                    user.setCheckNumber(Integer.valueOf(1));
                } else {
                    user.setCheckNumber(check.getCheckNumber());
                }
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getUserId, (Object)userId);
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operateCheckId);
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(2);
                statusList.add(3);
                operateWrapper.in(UserOperate::getStatus, statusList);
                operateWrapper.orderByAsc(UserOperate::getCreateTime);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (!CollectionUtils.isEmpty((Collection)operateList)) {
                    user.setUserCheckNumber(operateList.size());
                    if (check.getCheckScoreChoice().equals("0")) {
                        for (UserOperate userOperate : operateList) {
                            if (userOperate.getScore() == null || !(user.getScore() <= userOperate.getScore().floatValue())) continue;
                            user.setScore(userOperate.getScore().floatValue());
                            user.setIsPass(userOperate.getIsPass());
                        }
                    } else if (check.getCheckScoreChoice().equals("1")) {
                        for (int i = operateList.size() - 1; i >= 0; --i) {
                            UserOperate operate = (UserOperate)operateList.get(i);
                            if (operate.getScore() == null || operate.getIsPass() == null) continue;
                            user.setScore(operate.getScore().floatValue());
                            user.setIsPass(operate.getIsPass());
                            break;
                        }
                    }
                    user.setOperateList(operateList);
                }
            }
            result.setCheckUserInfo(user);
        }
        return JsonResult.success((Object)result);
    }

    @Override
    public String viewExaminee(Integer operateCheckId, Integer userId) {
        ViewExamineeVo result = new ViewExamineeVo();
        BaseResult userResult = this.userApi.getUserById(userId);
        if (!userResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)userResult.getData();
            result.setUserId(userPojo.getId());
            result.setShowName(userPojo.getShowName());
            result.setUserName(userPojo.getUserName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                result.setOrganizes(list.get(0));
            }
        }
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        result.setCheckNumber(check.getCheckNumber());
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)operateList)) {
            result.setUserCheckNumber(operateList.size());
            if (check.getCheckScoreChoice().equals("0")) {
                for (UserOperate userOperate : operateList) {
                    if (userOperate.getScore() == null || !(result.getScore() < userOperate.getScore().floatValue())) continue;
                    result.setScore(userOperate.getScore().floatValue());
                    result.setIsPass(userOperate.getIsPass());
                }
            } else if (check.getCheckScoreChoice().equals("1")) {
                for (int i = operateList.size() - 1; i >= 0; --i) {
                    UserOperate operate = (UserOperate)operateList.get(i);
                    if (operate.getScore() == null || operate.getIsPass() == null) continue;
                    result.setScore(operate.getScore().floatValue());
                    result.setIsPass(operate.getIsPass());
                    break;
                }
            }
        }
        result.setOperateList(operateList);
        return JsonResult.success((Object)result);
    }

    @Override
    public String examinerJoinCheck(Integer operateCheckId, Integer userId) {
        List list;
        UserOperateVo result = new UserOperateVo();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        BaseResult myUserResult = this.userApi.getUserById(userId);
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            result.setUserId(userPojo.getId());
            result.setShowName(userPojo.getShowName());
            result.setUserName(userPojo.getUserName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                list = organizeMap.get(userPojo.getId());
                result.setOrganizes(list.get(0));
            }
        }
        Integer userOperateId = null;
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(0);
        statusList.add(1);
        statusList.add(2);
        operateWrapper.in(UserOperate::getStatus, statusList);
        list = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.success();
        }
        userOperateId = ((UserOperate)list.get(0)).getId();
        result.setRemainingTime(((UserOperate)list.get(0)).getRemainingTime());
        result.setStatus(((UserOperate)list.get(0)).getStatus());
        result.setExaminerRemark(((UserOperate)list.get(0)).getExaminerRemark());
        result.setId(userOperateId);
        result.setCheckDuration(check.getCheckDuration());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(Integer.valueOf(detailList.size()));
        ArrayList<UserOperateCatagoryVo> catagoryList = new ArrayList<UserOperateCatagoryVo>();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        List<String> catagoryNameList = this.userOperateDetailMapper.groupByCatagory(userOperateId);
        for (String catagoryName : catagoryNameList) {
            LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
            categoryWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
            categoryWrapper.eq(UserOperateDetail::getCategoryName, (Object)catagoryName);
            List catagoryDetailList = this.userOperateDetailMapper.selectList((Wrapper)categoryWrapper);
            UserOperateCatagoryVo catagoryVo = new UserOperateCatagoryVo();
            catagoryVo.setCatagoryName(catagoryName);
            ArrayList<UserOperateDetailVo> detailVoList = new ArrayList<UserOperateDetailVo>();
            for (UserOperateDetail detail : catagoryDetailList) {
                UserOperateDetailVo detailVo = new UserOperateDetailVo();
                BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailParameter())) {
                    detailVo.setPatameterList(JSONObject.parseArray((String)detail.getDetailParameter(), TrainingMaterialParameter.class));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailUrl())) {
                    detailVo.setUrlList(JSONObject.parseArray((String)detail.getDetailUrl(), TrainingMaterialProductPicture.class));
                }
                if (detail.getDetailType().equals(2)) {
                    ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
                    LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperateId);
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
                    List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    for (UserOperateDetailData detailData : detailDataList) {
                        UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                        BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                        if (take.equals(detailData.getDataName())) {
                            detailDataVo.setIsNeedScan(1);
                        }
                        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
                        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
                        List attaList = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                        if (!CollectionUtils.isEmpty((Collection)attaList)) {
                            detailDataVo.setAttaList(attaList);
                        }
                        detailDataVoList.add(detailDataVo);
                    }
                    detailVo.setDetailDataList(detailDataVoList);
                }
                LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
                attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detail.getId());
                List attaList = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                if (!CollectionUtils.isEmpty((Collection)attaList)) {
                    detailVo.setAttaList(attaList);
                }
                detailVoList.add(detailVo);
            }
            catagoryVo.setDetailList(detailVoList);
            catagoryList.add(catagoryVo);
        }
        result.setCatagoryList(catagoryList);
        return JsonResult.success((Object)result);
    }

    @Override
    public String examinerStartOperate(Integer operateCheckId, Integer userId) {
        List list;
        UserOperateVo result = new UserOperateVo();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        BaseResult myUserResult = this.userApi.getUserById(userId);
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            result.setUserId(userPojo.getId());
            result.setShowName(userPojo.getShowName());
            result.setUserName(userPojo.getUserName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                list = organizeMap.get(userPojo.getId());
                result.setOrganizes((String)list.get(0));
            }
        }
        Integer userOperateId = null;
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(0);
        statusList.add(1);
        operateWrapper.in(UserOperate::getStatus, statusList);
        list = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            userOperateId = ((UserOperate)list.get(0)).getId();
        }
        if (userOperateId == null) {
            LambdaQueryWrapper checkOperateWrapper = new LambdaQueryWrapper();
            checkOperateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
            checkOperateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
            checkOperateWrapper.eq(UserOperate::getUserId, (Object)userId);
            List checkList = this.userOperateMapper.selectList((Wrapper)checkOperateWrapper);
            if (check.getCheckType() == 2 && !CollectionUtils.isEmpty((Collection)checkList) && checkList.size() >= check.getCheckNumber()) {
                return JsonResult.error(null, (Object)this.messageSource.getMessage("training.operate.count.out", null, locale));
            }
            UserOperate operate = new UserOperate();
            operate.setCreateTime(new Date());
            operate.setEnterpriseId(check.getEnterpriseId());
            operate.setUserId(userId);
            operate.setOperateCheckId(check.getId());
            operate.setCheckName(check.getCheckName());
            operate.setStatus(Integer.valueOf(1));
            operate.setRemainingTime(check.getCheckDuration() * 60 * 1000 + "");
            this.userOperateMapper.insert(operate);
            userOperateId = operate.getId();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
            OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
            if (checkTemplate != null) {
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
                List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
                if (!CollectionUtils.isEmpty((Collection)detailList)) {
                    for (OperateCheckTemplateDetail templateDetail : detailList) {
                        UserOperateDetail operateDetail = new UserOperateDetail();
                        operateDetail.setUserOperateId(operate.getId());
                        operateDetail.setCategoryName(templateDetail.getCategoryName());
                        operateDetail.setBarCode(templateDetail.getBarCode());
                        operateDetail.setDetailName(templateDetail.getDetailName());
                        operateDetail.setDetailUrl(templateDetail.getDetailUrl());
                        operateDetail.setDetailParameter(templateDetail.getDetailParameter());
                        operateDetail.setDetailType(templateDetail.getDetailType());
                        operateDetail.setIsRedline(templateDetail.getIsRedline());
                        operateDetail.setTotalScore(templateDetail.getScore());
                        operateDetail.setSort(templateDetail.getSort());
                        this.userOperateDetailMapper.insert(operateDetail);
                        if (!templateDetail.getDetailType().equals(2)) continue;
                        LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                        detailDataWrapper.eq(OperateCheckTemplateDetailData::getOperateCheckTemplateId, (Object)templateDetail.getOperateCheckTemplateId());
                        detailDataWrapper.eq(OperateCheckTemplateDetailData::getOperateCheckTemplateDetailId, (Object)templateDetail.getId());
                        List detailDataList = this.operateCheckTemplateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                        Float totalScore = Float.valueOf(0.0f);
                        for (OperateCheckTemplateDetailData detailData : detailDataList) {
                            UserOperateDetailData operateDetailData = new UserOperateDetailData();
                            operateDetailData.setUserOperateId(operate.getId());
                            operateDetailData.setUserOperateDetailId(operateDetail.getId());
                            operateDetailData.setDataName(detailData.getDataName());
                            operateDetailData.setIsRedline(detailData.getIsRedline());
                            operateDetailData.setTotalScore(detailData.getScore());
                            this.userOperateDetailDataMapper.insert(operateDetailData);
                            totalScore = Float.valueOf(totalScore.floatValue() + detailData.getScore().floatValue());
                        }
                        operateDetail.setTotalScore(totalScore);
                        this.userOperateDetailMapper.updateById(operateDetail);
                    }
                }
            }
            result.setRemainingTime(operate.getRemainingTime());
            result.setStatus(operate.getStatus());
        } else {
            result.setRemainingTime(((UserOperate)list.get(0)).getRemainingTime());
            result.setStatus(((UserOperate)list.get(0)).getStatus());
        }
        result.setId(userOperateId);
        result.setCheckDuration(check.getCheckDuration());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(Integer.valueOf(detailList.size()));
        ArrayList<UserOperateCatagoryVo> catagoryList = new ArrayList<UserOperateCatagoryVo>();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        List<String> catagoryNameList = this.userOperateDetailMapper.groupByCatagory(userOperateId);
        if (!CollectionUtils.isEmpty(catagoryNameList)) {
            for (String catagoryName : catagoryNameList) {
                LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
                categoryWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
                categoryWrapper.eq(UserOperateDetail::getCategoryName, (Object)catagoryName);
                List catagoryDetailList = this.userOperateDetailMapper.selectList((Wrapper)categoryWrapper);
                UserOperateCatagoryVo catagoryVo = new UserOperateCatagoryVo();
                catagoryVo.setCatagoryName(catagoryName);
                ArrayList<UserOperateDetailVo> detailVoList = new ArrayList<UserOperateDetailVo>();
                for (UserOperateDetail detail : catagoryDetailList) {
                    UserOperateDetailVo detailVo = new UserOperateDetailVo();
                    BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailParameter())) {
                        detailVo.setPatameterList(JSONObject.parseArray((String)detail.getDetailParameter(), TrainingMaterialParameter.class));
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailUrl())) {
                        detailVo.setUrlList(JSONObject.parseArray((String)detail.getDetailUrl(), TrainingMaterialProductPicture.class));
                    }
                    if (detail.getDetailType().equals(2)) {
                        ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
                        LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                        detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperateId);
                        detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
                        List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                        for (UserOperateDetailData detailData : detailDataList) {
                            UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                            BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                            if (take.equals(detailData.getDataName())) {
                                detailDataVo.setIsNeedScan(1);
                            }
                            detailDataVoList.add(detailDataVo);
                        }
                        detailVo.setDetailDataList(detailDataVoList);
                    }
                    detailVoList.add(detailVo);
                }
                catagoryVo.setDetailList(detailVoList);
                catagoryList.add(catagoryVo);
            }
        }
        result.setCatagoryList(catagoryList);
        this.saveJobUserTask(check, userId);
        return JsonResult.success((Object)result);
    }

    @Override
    public String handPapers(Integer userOperateId, String remainingTime) {
        UserOperate operate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        if (operate == null) {
            return JsonResult.error(null, (Object)"INVALID_PARAMETER");
        }
        if (!operate.getStatus().equals(3)) {
            operate.setStatus(Integer.valueOf(2));
        }
        operate.setRemainingTime(remainingTime);
        operate.setFinishTime(new Date());
        this.userOperateMapper.updateById(operate);
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        for (UserOperateDetail userOperateDetail : detailList) {
            LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)userOperateDetail.getId());
            List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
            if (!CollectionUtils.isEmpty((Collection)detailDataList)) {
                for (UserOperateDetailData detailData : detailDataList) {
                    if (detailData.getIsRight() != null || detailData.getScore() != null) continue;
                    detailData.setIsRight(Integer.valueOf(0));
                    detailData.setScore(Float.valueOf(0.0f));
                    this.userOperateDetailDataMapper.updateById(detailData);
                }
            }
            if (userOperateDetail.getIsRight() != null || userOperateDetail.getScore() != null) continue;
            userOperateDetail.setIsRight(Integer.valueOf(0));
            userOperateDetail.setScore(Float.valueOf(0.0f));
            this.userOperateDetailMapper.updateById(userOperateDetail);
        }
        this.sendStudyEvent(operate);
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operate.getOperateCheckId());
        if (check.getSource() != null && check.getSource() == 1) {
            LambdaQueryWrapper templateWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)templateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operate.getOperateCheckId())).last(" limit 1 ");
            OperateCheckTemplate template = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)templateWrapper);
            this.updateJobUserTask(operate, check, template);
        }
        return JsonResult.success();
    }

    public void sendStudyEvent(UserOperate operate) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        StudyEvent event = new StudyEvent();
        event.setDate(new Date());
        Integer userId = operate.getUserId();
        Integer groupId = operate.getEnterpriseId();
        event.setShop(this.findShopNameByUserId(userId, groupId));
        String taskStudy = this.messageSource.getMessage("training.job.course.task.study", null, locale);
        event.setEvent(taskStudy);
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId);
        if (!baseResult.getIsError().booleanValue() && Objects.nonNull(baseResult.getData())) {
            event.setCompanyName(((EnterpriseGroupMo)baseResult.getData()).getName());
        } else {
            event.setCompanyName("");
        }
        BaseResult baseResult2 = this.userDepPrivilegeApi.getPrivilegeDepBeanByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData()))) {
            event.setLatitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLatitude());
            event.setLongitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLongitude());
            event.setAddress(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getAddress());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)event.getShop())) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
    }

    private String findShopNameByUserId(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null && Objects.nonNull(base.getData())) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = (String)pojoList.get(0);
        }
        return shopName;
    }

    @Override
    public String hasOperate(Integer groupId, Integer userId, Integer operateCheckId) {
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(1);
        statusList.add(2);
        operateWrapper.in(UserOperate::getStatus, statusList);
        List list = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return JsonResult.success((Object)false);
        }
        if (((UserOperate)list.get(0)).getStatus().equals(1)) {
            return JsonResult.success((Object)true);
        }
        return JsonResult.success((Object)false);
    }

    @Override
    public String getOperateDetailById(Integer userOperateId) {
        UserOperateVo result = new UserOperateVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        UserOperate operate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        if (ObjectUtils.isEmpty((Object)operate)) {
            return "INVALID_PARAMETER";
        }
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operate.getOperateCheckId());
        BaseResult myUserResult = this.userApi.getUserById(operate.getUserId());
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            result.setUserId(userPojo.getId());
            result.setShowName(userPojo.getShowName());
            result.setUserName(userPojo.getUserName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                result.setOrganizes(list.get(0));
            }
        }
        result.setExaminerRemark(operate.getExaminerRemark());
        result.setRemainingTime(operate.getRemainingTime());
        result.setStatus(operate.getStatus());
        result.setId(userOperateId);
        result.setCheckDuration(check.getCheckDuration());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
        List detailList = this.userOperateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(Integer.valueOf(detailList.size()));
        ArrayList<UserOperateCatagoryVo> catagoryList = new ArrayList<UserOperateCatagoryVo>();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        List<String> catagoryNameList = this.userOperateDetailMapper.groupByCatagory(userOperateId);
        for (String catagoryName : catagoryNameList) {
            LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
            categoryWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
            categoryWrapper.eq(UserOperateDetail::getCategoryName, (Object)catagoryName);
            List catagoryDetailList = this.userOperateDetailMapper.selectList((Wrapper)categoryWrapper);
            UserOperateCatagoryVo catagoryVo = new UserOperateCatagoryVo();
            catagoryVo.setCatagoryName(catagoryName);
            ArrayList<UserOperateDetailVo> detailVoList = new ArrayList<UserOperateDetailVo>();
            for (UserOperateDetail detail : catagoryDetailList) {
                UserOperateDetailVo detailVo = new UserOperateDetailVo();
                BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailParameter())) {
                    detailVo.setPatameterList(JSONObject.parseArray((String)detail.getDetailParameter(), TrainingMaterialParameter.class));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailUrl())) {
                    detailVo.setUrlList(JSONObject.parseArray((String)detail.getDetailUrl(), TrainingMaterialProductPicture.class));
                }
                if (detail.getDetailType().equals(2)) {
                    ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
                    LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperateId);
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
                    List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    for (UserOperateDetailData detailData : detailDataList) {
                        UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                        BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                        if (take.equals(detailData.getDataName())) {
                            detailDataVo.setIsNeedScan(1);
                        }
                        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
                        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
                        List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            detailDataVo.setAttaList(list);
                        }
                        detailDataVoList.add(detailDataVo);
                    }
                    detailVo.setDetailDataList(detailDataVoList);
                }
                LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
                attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detail.getId());
                List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    detailVo.setAttaList(list);
                }
                detailVoList.add(detailVo);
            }
            catagoryVo.setDetailList(detailVoList);
            catagoryList.add(catagoryVo);
        }
        result.setCatagoryList(catagoryList);
        return JsonResult.success((Object)result);
    }

    @Override
    public String getUserOperateDetailById(Integer userOperateDetailId) {
        UserOperateDetailVo detailVo = new UserOperateDetailVo();
        UserOperateDetail detail = (UserOperateDetail)this.userOperateDetailMapper.selectById(userOperateDetailId);
        BeanUtils.copyProperties((Object)detail, (Object)detailVo);
        if (detail.getDetailType().equals(2)) {
            ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
            LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)detail.getUserOperateId());
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
            List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
            for (UserOperateDetailData detailData : detailDataList) {
                UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
                attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
                List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    detailDataVo.setAttaList(list);
                }
                detailDataVoList.add(detailDataVo);
            }
            detailVo.setDetailDataList(detailDataVoList);
        }
        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)userOperateDetailId);
        List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            detailVo.setAttaList(list);
        }
        return JsonResult.success((Object)detailVo);
    }

    @Override
    public String getScanList(Integer userOperateDetailDataId) {
        LambdaQueryWrapper scanWrapper = new LambdaQueryWrapper();
        scanWrapper.eq(UserOperateDetailDataScan::getUserOperateDetailDataId, (Object)userOperateDetailDataId);
        scanWrapper.orderByDesc(UserOperateDetailDataScan::getCreateTime);
        List list = this.userOperateDetailDataScanMapper.selectList((Wrapper)scanWrapper);
        return JsonResult.success((Object)list);
    }

    @Override
    public String handPapersDetail(Integer userId, Integer userOperateId) {
        HandPapersVo result = new HandPapersVo();
        UserOperate operate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        result.setStatus(operate.getStatus());
        if (operate.getStatus().equals(3)) {
            LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
            operateWrapper.eq(UserOperate::getUserId, (Object)operate.getUserId());
            operateWrapper.eq(UserOperate::getEnterpriseId, (Object)operate.getEnterpriseId());
            operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operate.getOperateCheckId());
            operateWrapper.ne(UserOperate::getStatus, (Object)0);
            operateWrapper.orderByAsc(UserOperate::getCreateTime);
            List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
            if (!CollectionUtils.isEmpty((Collection)operateList)) {
                result.setUserCheckNumber(operateList.size());
                OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operate.getOperateCheckId());
                if (check.getCheckType().equals(1)) {
                    result.setCheckNumber(Integer.valueOf(1));
                } else {
                    result.setCheckNumber(check.getCheckNumber());
                }
                result.setCheckScoreChoice(check.getCheckScoreChoice());
                result.setScore(operate.getScore().floatValue());
                if (check.getCheckScoreChoice().equals("0")) {
                    for (UserOperate userOperate : operateList) {
                        if (userOperate.getScore() == null || !(result.getChoiceScore() < userOperate.getScore().floatValue())) continue;
                        result.setChoiceScore(userOperate.getScore().floatValue());
                        result.setIsPass(userOperate.getIsPass());
                        result.setCheckIsPass(userOperate.getIsPass());
                    }
                } else if (check.getCheckScoreChoice().equals("1")) {
                    result.setChoiceScore(((UserOperate)operateList.get(operateList.size() - 1)).getScore().floatValue());
                    result.setIsPass(((UserOperate)operateList.get(operateList.size() - 1)).getIsPass());
                    for (UserOperate userOperate : operateList) {
                        if (userOperate.getScore() == null || !(result.getChoiceScore() < userOperate.getScore().floatValue())) continue;
                        result.setCheckIsPass(userOperate.getIsPass());
                    }
                }
                OperateRankingVo vo = this.getOperateRanking(userId, operate.getOperateCheckId());
                result.setRankingNumerator(vo.getMyRanking());
                result.setRankingDenominator(vo.getCheckTotalNum());
            }
        }
        return JsonResult.success((Object)result);
    }

    @Override
    public String getUserOperateDetailDataById(Integer userOperateDetailDataId) {
        UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        UserOperateDetailData detailData = (UserOperateDetailData)this.userOperateDetailDataMapper.selectById(userOperateDetailDataId);
        BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
        if (take.equals(detailData.getDataName())) {
            detailDataVo.setIsNeedScan(1);
        }
        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
        List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            detailDataVo.setAttaList(list);
        }
        return JsonResult.success((Object)detailDataVo);
    }

    @Override
    public String vaildOperateTemplate(Integer groupId, Integer id, String name) {
        List list;
        LambdaQueryWrapper templateWrapper = new LambdaQueryWrapper();
        templateWrapper.eq(OperateTemplate::getEnterpriseId, (Object)groupId);
        templateWrapper.eq(OperateTemplate::getTemplateName, (Object)name);
        if (id != null) {
            templateWrapper.ne(OperateTemplate::getId, (Object)id);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.operateTemplateMapper.selectList((Wrapper)templateWrapper)))) {
            return JsonResult.error(null, (Object)"EXIST_DATA");
        }
        return JsonResult.success();
    }

    @Override
    public String deleteOperateTemplate(String operateTemplateIds, LogPojo pojo) {
        String[] idsStr = operateTemplateIds.split(",");
        StringBuffer templateNames = new StringBuffer();
        for (int i = 0; i < idsStr.length; ++i) {
            if (org.springframework.util.StringUtils.isEmpty((Object)idsStr[i])) continue;
            OperateTemplate template = (OperateTemplate)this.operateTemplateMapper.selectById(Integer.valueOf(Integer.parseInt(idsStr[i])));
            if (!pojo.getEnterpriseId().equals(template.getEnterpriseId())) {
                return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
            }
            this.deleteOperateTemplateById(Integer.parseInt(idsStr[i]));
            templateNames.append(";" + template.getTemplateName());
        }
        pojo.setI18nParam(templateNames.substring(1));
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public String vaildDeleteOperate(Integer operateTemplateId) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(OperateCheck::getOperateTemplateId, (Object)operateTemplateId);
        checkWrapper.orderByDesc(OperateCheck::getCreateTime);
        List list = this.operateCheckMapper.selectList((Wrapper)checkWrapper);
        for (OperateCheck operateCheck : list) {
            if (!operateCheck.getStatus().equals(0) && !operateCheck.getStatus().equals(3) && operateCheck.getStartTime() != null && operateCheck.getEndTime() != null && operateCheck.getStartTime().before(new Date()) && operateCheck.getEndTime().after(new Date())) {
                operateCheck.setStatus(Integer.valueOf(2));
                continue;
            }
            if (operateCheck.getEndTime() == null || !operateCheck.getEndTime().before(new Date())) continue;
            operateCheck.setStatus(Integer.valueOf(3));
        }
        return JsonResult.success((Object)list);
    }

    @Override
    public String vaildBatchDeleteOperate(String operateTemplateIds) {
        String[] idsStr = operateTemplateIds.split(",");
        List<String> idList = Arrays.asList(idsStr);
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.in(OperateCheck::getOperateTemplateId, idList);
        List list = this.operateCheckMapper.selectList((Wrapper)checkWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List templateIdList = list.stream().map(OperateCheck::getOperateTemplateId).collect(Collectors.toList());
            List templateList = this.operateTemplateMapper.selectBatchIds(templateIdList);
            return JsonResult.success((Object)templateList);
        }
        return JsonResult.success();
    }

    @Override
    public String operateCheckPublish(Integer operateCheckId, Integer isPublic) {
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (check != null) {
            check.setStatus(isPublic);
        }
        this.operateCheckMapper.updateById(check);
        return JsonResult.success();
    }

    @Override
    public String operateCheckClose(Integer operateCheckId) {
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (check != null) {
            check.setStatus(Integer.valueOf(3));
        }
        check.setEndTime(new Date());
        check.setIsClose(Integer.valueOf(1));
        this.operateCheckMapper.updateById(check);
        this.jPushService.updateMessagesByObjectType(check.getId(), "TYPE_OPEADD_USER_TYPE", null, null, 1, DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.jPushService.updateMessagesByObjectType(check.getId(), "TYPE_OPEADD_EXAMINER_TYPE", null, null, 1, DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        return JsonResult.success();
    }

    @Override
    public OperateRankingVo getOperateRanking(Integer userId, Integer operateCheckId) {
        OperateRankingVo result = new OperateRankingVo();
        ArrayList<OperateRankingVo> rankingList = new ArrayList<OperateRankingVo>();
        ArrayList<OperateRankingVo> ingList = new ArrayList<OperateRankingVo>();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            result.setTotalUserNum(Integer.valueOf(userList.size()));
            for (OperateCheckUser user : userList) {
                OperateRankingVo vo = new OperateRankingVo();
                BaseResult myUserResult = this.userApi.getUserById(user.getUserId());
                if (!myUserResult.getIsError().booleanValue()) {
                    UsersPojo userPojo = (UsersPojo)myUserResult.getData();
                    vo.setUserId(userPojo.getId());
                    vo.setShowName(userPojo.getShowName());
                    vo.setUserName(userPojo.getUserName());
                    vo.setThumbUrl(userPojo.getThumbUrl());
                    ArrayList<Integer> userIdList = new ArrayList<Integer>();
                    userIdList.add(userPojo.getId());
                    Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                    if (!CollectionUtils.isEmpty(organizeMap)) {
                        List<String> list = organizeMap.get(userPojo.getId());
                        vo.setOrganizes(list.get(0));
                    }
                }
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)user.getEnterpriseId());
                operateWrapper.eq(UserOperate::getUserId, (Object)user.getUserId());
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)user.getOperateCheckId());
                operateWrapper.eq(UserOperate::getStatus, (Object)3);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (check.getCheckType().equals(0)) {
                    if (CollectionUtils.isEmpty((Collection)operateList)) {
                        vo.setCheckTotalNum(check.getCheckNumber());
                        vo.setCheckNum(Integer.valueOf(0));
                        ingList.add(vo);
                        continue;
                    }
                    if (operateList.size() < check.getCheckNumber()) {
                        vo.setCheckTotalNum(check.getCheckNumber());
                        vo.setCheckNum(Integer.valueOf(operateList.size()));
                        ingList.add(vo);
                        continue;
                    }
                } else if (CollectionUtils.isEmpty((Collection)operateList)) {
                    vo.setCheckTotalNum(Integer.valueOf(1));
                    vo.setCheckNum(Integer.valueOf(0));
                    ingList.add(vo);
                    continue;
                }
                if (check.getCheckScoreChoice().equals("0")) {
                    for (UserOperate userOperate : operateList) {
                        if (userOperate.getScore() == null || !(vo.getScore().floatValue() <= userOperate.getScore().floatValue())) continue;
                        vo.setScore(userOperate.getScore());
                    }
                } else if (check.getCheckScoreChoice().equals("1")) {
                    for (int i = operateList.size() - 1; i >= 0; --i) {
                        UserOperate operate = (UserOperate)operateList.get(i);
                        if (operate.getScore() == null) continue;
                        vo.setScore(operate.getScore());
                        break;
                    }
                }
                rankingList.add(vo);
            }
            Collections.sort(rankingList, new Comparator<OperateRankingVo>(){

                @Override
                public int compare(OperateRankingVo o1, OperateRankingVo o2) {
                    return o2.getScore().compareTo(o1.getScore());
                }
            });
            if (!CollectionUtils.isEmpty(rankingList)) {
                for (int i = 0; i < rankingList.size(); ++i) {
                    OperateRankingVo vo = (OperateRankingVo)rankingList.get(i);
                    vo.setMyRanking(Integer.valueOf(i + 1));
                    if (!vo.getUserId().equals(userId)) continue;
                    result.setMyRanking(vo.getMyRanking());
                    result.setCheckNum(vo.getCheckNum());
                    result.setCheckTotalNum(vo.getCheckTotalNum());
                    result.setUserId(vo.getUserId());
                    result.setShowName(vo.getShowName());
                    result.setUserName(vo.getUserName());
                    result.setThumbUrl(vo.getThumbUrl());
                    result.setOrganizes(vo.getOrganizes());
                    result.setScore(vo.getScore());
                }
            }
            if (!CollectionUtils.isEmpty(ingList)) {
                for (OperateRankingVo vo : ingList) {
                    if (!vo.getUserId().equals(userId)) continue;
                    result.setCheckNum(vo.getCheckNum());
                    result.setCheckTotalNum(vo.getCheckTotalNum());
                    result.setUserId(vo.getUserId());
                    result.setShowName(vo.getShowName());
                    result.setUserName(vo.getUserName());
                    result.setThumbUrl(vo.getThumbUrl());
                    result.setOrganizes(vo.getOrganizes());
                    result.setScore(vo.getScore());
                }
            }
            result.setRankingList(rankingList);
            result.setIngList(ingList);
            return result;
        }
        return result;
    }

    @Override
    public String deleteOperateCheck(Integer operateCheckId, LogPojo pojo) {
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        if (pojo != null && !pojo.getEnterpriseId().equals(check.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operateCheckId);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)operateList)) {
            for (UserOperate userOperate : operateList) {
                LambdaQueryWrapper detailDataScanWrapper = new LambdaQueryWrapper();
                detailDataScanWrapper.eq(UserOperateDetailDataScan::getUserOperateId, (Object)userOperate.getId());
                this.userOperateDetailDataScanMapper.delete((Wrapper)detailDataScanWrapper);
                LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperate.getId());
                this.userOperateDetailDataMapper.delete((Wrapper)detailDataWrapper);
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperate.getId());
                this.userOperateDetailMapper.delete((Wrapper)detailWrapper);
                this.userOperateMapper.deleteById(userOperate.getId());
                if (pojo == null) continue;
                pojo.setI18nParam(userOperate.getCheckName());
                this.logApi.save(pojo);
            }
        }
        LambdaQueryWrapper checkTemplateWrapper = new LambdaQueryWrapper();
        checkTemplateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
        List checkTemplateList = this.operateCheckTemplateMapper.selectList((Wrapper)checkTemplateWrapper);
        if (!CollectionUtils.isEmpty((Collection)checkTemplateList)) {
            for (OperateCheckTemplate operateCheckTemplate : checkTemplateList) {
                LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                detailDataWrapper.eq(OperateCheckTemplateDetailData::getOperateCheckTemplateId, (Object)operateCheckTemplate.getId());
                this.operateCheckTemplateDetailDataMapper.delete((Wrapper)detailDataWrapper);
                LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
                detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)operateCheckTemplate.getId());
                this.operateCheckTemplateDetailMapper.delete((Wrapper)detailWrapper);
                this.operateCheckTemplateMapper.deleteById(operateCheckTemplate.getId());
            }
        }
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)operateCheckId);
        List examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper);
        for (OperateCheckExaminer examiner : examinerList) {
            this.jPushService.deleteMessages(operateCheckId, "TYPE_OPEADD_EXAMINER_TYPE", examiner.getUserId(), null, 1);
        }
        this.operateCheckExaminerMapper.delete((Wrapper)examinerWrapper);
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        List list = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        for (OperateCheckUser user : list) {
            this.jPushService.deleteMessages(operateCheckId, "TYPE_OPEADD_USER_TYPE", user.getUserId(), null, 1);
        }
        this.operateCheckUserMapper.delete((Wrapper)userWrapper);
        this.operateCheckMapper.deleteById(operateCheckId);
        return JsonResult.success();
    }

    @Override
    public String vaildOperateCheck(Integer groupId, Integer id, Integer jobId, String name, Integer source) {
        List list;
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(OperateCheck::getEnterpriseId, (Object)groupId);
        checkWrapper.eq(OperateCheck::getCheckName, (Object)name);
        if (jobId != null) {
            checkWrapper.eq(OperateCheck::getBusinessKey, (Object)jobId);
        }
        if (source != null) {
            checkWrapper.eq(OperateCheck::getSource, (Object)source);
        }
        if (id != null) {
            checkWrapper.ne(OperateCheck::getId, (Object)id);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.operateCheckMapper.selectList((Wrapper)checkWrapper)))) {
            return JsonResult.error(null, (Object)"EXIST_DATA");
        }
        return JsonResult.success();
    }

    @Override
    public String checkIngExaminer(Integer userId, Integer userOperateId) {
        this.redisBaseApi.setExpire("checkIngExaminer" + userOperateId, userId + "", Integer.valueOf(30));
        com.ovopark.pojo.BaseResult result = this.redisBaseApi.get("checkIngUser" + userOperateId);
        if (!result.getIsError().booleanValue()) {
            return JsonResult.success((Object)result.getData());
        }
        return JsonResult.error(null, (Object)result.getMessage());
    }

    @Override
    public String checkIngUser(Integer userId, Integer userOperateId) {
        this.redisBaseApi.setExpire("checkIngUser" + userOperateId, userId + "", Integer.valueOf(30));
        com.ovopark.pojo.BaseResult result = this.redisBaseApi.get("checkIngExaminer" + userOperateId);
        if (!result.getIsError().booleanValue()) {
            return JsonResult.success((Object)result.getData());
        }
        return JsonResult.error(null, (Object)result.getMessage());
    }

    @Override
    public TraineeAnalysisVo getTraineeAnalysis(TraineeAnalysisReq req, Users users) {
        Map<String, Object> userMap;
        TraineeAnalysisVo result = new TraineeAnalysisVo();
        ArrayList<TraineeAnalysisUserVo> userVoList = new ArrayList<TraineeAnalysisUserVo>();
        List idList = new ArrayList();
        if ((!org.springframework.util.StringUtils.isEmpty((Object)req.getKeyWord()) || !org.springframework.util.StringUtils.isEmpty((Object)req.getOrganizeIds())) && (userMap = this.userUtilService.getCheckParameters(req.getKeyWord(), null, req.getOrganizeIds(), users)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(idList = (List)userMap.get("userList"))) {
            return result;
        }
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(req.getOperateCheckId());
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)req.getOperateCheckId());
        if (!CollectionUtils.isEmpty(idList)) {
            userWrapper.in(OperateCheckUser::getUserId, idList);
        }
        List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        List userIds = userList.stream().map(OperateCheckUser::getUserId).collect(Collectors.toList());
        BaseResult userResult = this.userApi.getUserByIdList(userIds);
        List<Integer> allUserId = ((List)userResult.getData()).stream().map(UsersPojo::getUserId).collect(Collectors.toList());
        Map userRoleMap = new HashMap();
        if (!CollectionUtils.isEmpty(allUserId)) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("userIds", StringUtils.join(allUserId, (String)","));
            parameter.put("groupId", users.getGroupId());
            com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
            if (base != null) {
                userRoleMap = (Map)base.getData();
            }
        }
        Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allUserId, users.getGroupId());
        Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allUserId, users.getGroupId());
        Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allUserId, users.getGroupId());
        if (!userResult.getIsError().booleanValue()) {
            int finishNum = 0;
            int passNum = 0;
            for (UsersPojo userPojo : (List)userResult.getData()) {
                TraineeAnalysisUserVo user = new TraineeAnalysisUserVo();
                user.setUserId(userPojo.getId());
                user.setEmployeeNumber(userPojo.getEmployeeNumber());
                user.setShowName(userPojo.getShowName());
                user.setUserName(userPojo.getUserName());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    user.setOrganizes(String.join((CharSequence)";\n", (Iterable<? extends CharSequence>)organizeMap.get(userPojo.getId())));
                }
                if (check.getCheckType().equals(0)) {
                    user.setCheckTotalNum(check.getCheckNumber().intValue());
                } else if (check.getCheckType().equals(1)) {
                    user.setCheckTotalNum(1);
                }
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getUserId, (Object)userPojo.getUserId());
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)req.getOperateCheckId());
                operateWrapper.eq(UserOperate::getStatus, (Object)3);
                operateWrapper.orderByAsc(UserOperate::getCreateTime);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (!CollectionUtils.isEmpty((Collection)operateList)) {
                    user.setCheckNum(operateList.size());
                    if (check.getCheckScoreChoice().equals("0")) {
                        for (UserOperate userOperate : operateList) {
                            if (userOperate.getScore() == null || !(user.getScore().floatValue() <= userOperate.getScore().floatValue())) continue;
                            user.setScore(userOperate.getScore());
                            user.setIsPass(userOperate.getIsPass());
                        }
                    } else if (check.getCheckScoreChoice().equals("1")) {
                        for (int i = operateList.size() - 1; i >= 0; --i) {
                            UserOperate operate = (UserOperate)operateList.get(i);
                            if (operate.getScore() == null || operate.getIsPass() == null) continue;
                            user.setScore(operate.getScore());
                            user.setIsPass(operate.getIsPass());
                            break;
                        }
                    }
                    if (user.getCheckNum() == 0) {
                        user.setStatus(Integer.valueOf(1));
                    } else if (user.getCheckNum() < user.getCheckTotalNum()) {
                        user.setStatus(Integer.valueOf(2));
                        user.setStartTime(((UserOperate)operateList.get(0)).getCreateTime());
                    } else {
                        user.setStartTime(((UserOperate)operateList.get(0)).getCreateTime());
                        user.setStatus(Integer.valueOf(3));
                        ++finishNum;
                        if (user.getIsPass() != null && user.getIsPass() == 1) {
                            ++passNum;
                        }
                        if (check.getCheckType().equals(0)) {
                            if (operateList.size() >= check.getCheckNumber()) {
                                user.setFinishTime(((UserOperate)operateList.get(check.getCheckNumber() - 1)).getFinishTime());
                            }
                        } else if (check.getCheckType().equals(1)) {
                            user.setFinishTime(((UserOperate)operateList.get(0)).getFinishTime());
                        }
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(user.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(user.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    user.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(user.getUserId()) != null) {
                    user.setPost(dutiesMap.get(user.getUserId()).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    user.setParentName(parentMap.get(user.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    user.setParentUserId(parentIdMap.get(user.getUserId()));
                }
                userVoList.add(user);
            }
            if (((List)userResult.getData()).size() > 0) {
                result.setFinishRate(Float.valueOf(new BigDecimal(finishNum * 100).divide(new BigDecimal(((List)userResult.getData()).size()), 1, 5).floatValue()));
            }
            if (finishNum > 0) {
                result.setPassRate(Float.valueOf(new BigDecimal(passNum * 100).divide(new BigDecimal(finishNum), 1, 5).floatValue()));
            }
        }
        result.setUserList(userVoList);
        return result;
    }

    @Override
    public ExaminerAnalysisVo getExaminerAnalysis(ExaminerAnalysisReq req, Users users) {
        List examinerList;
        List examinerIds;
        BaseResult examinerResult;
        Map<String, Object> userMap;
        ExaminerAnalysisVo result = new ExaminerAnalysisVo();
        ArrayList<ExaminerAnalysisUserVo> userVoList = new ArrayList<ExaminerAnalysisUserVo>();
        List idList = new ArrayList();
        if ((!org.springframework.util.StringUtils.isEmpty((Object)req.getKeyWord()) || !org.springframework.util.StringUtils.isEmpty((Object)req.getOrganizeIds())) && (userMap = this.userUtilService.getCheckParameters(req.getKeyWord(), null, req.getOrganizeIds(), users)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(idList = (List)userMap.get("userList"))) {
            return result;
        }
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(req.getOperateCheckId());
        LambdaQueryWrapper examinerWrapper = new LambdaQueryWrapper();
        examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)req.getOperateCheckId());
        if (!CollectionUtils.isEmpty(idList)) {
            examinerWrapper.in(OperateCheckExaminer::getUserId, idList);
        }
        if (!(examinerResult = this.userApi.getUserByIdList(examinerIds = (examinerList = this.operateCheckExaminerMapper.selectList((Wrapper)examinerWrapper)).stream().map(OperateCheckExaminer::getUserId).collect(Collectors.toList()))).getIsError().booleanValue()) {
            int checkRateNum = 0;
            int finishRateNum = 0;
            Map userRoleMap = new HashMap();
            Map<Object, Object> dutiesMap = new HashMap();
            Map<Object, Object> parentMap = new HashMap();
            Map<Object, Object> parentIdMap = new HashMap();
            if (CollectionUtils.isEmpty((Collection)((Collection)examinerResult.getData()))) {
                List<Integer> allUserId = ((List)examinerResult.getData()).stream().map(UsersPojo::getId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(allUserId)) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("userIds", StringUtils.join(allUserId, (String)","));
                    parameter.put("groupId", users.getGroupId());
                    com.ovopark.privilege.response.BaseResult base = this.roleApi.getUserRoleList(parameter);
                    if (base != null) {
                        userRoleMap = (Map)base.getData();
                    }
                }
                dutiesMap = this.userUtilService.selectDutiesMap(allUserId, users.getGroupId());
                parentMap = this.userUtilService.selectParentMap(allUserId, users.getGroupId());
                parentIdMap = this.userUtilService.selectParentIdMap(allUserId, users.getGroupId());
            }
            for (UsersPojo examinerPojo : (List)examinerResult.getData()) {
                List userIds;
                BaseResult userResult;
                List userList;
                int checkNum = 0;
                int finishNum = 0;
                ExaminerAnalysisUserVo user = new ExaminerAnalysisUserVo();
                user.setUserId(examinerPojo.getId());
                user.setEmployeeNumber(examinerPojo.getEmployeeNumber());
                user.setShowName(examinerPojo.getShowName());
                user.setUserName(examinerPojo.getUserName());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(examinerPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, examinerPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(examinerPojo.getId());
                    user.setOrganizes(String.join((CharSequence)";\n", list));
                }
                LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
                userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)req.getOperateCheckId());
                userWrapper.eq(OperateCheckUser::getExaminerId, (Object)examinerPojo.getId());
                if (!CollectionUtils.isEmpty(idList)) {
                    userWrapper.in(OperateCheckUser::getUserId, idList);
                }
                if (!CollectionUtils.isEmpty((Collection)(userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper)))) {
                    ++checkRateNum;
                }
                if (!(userResult = this.userApi.getUserByIdList(userIds = userList.stream().map(OperateCheckUser::getUserId).collect(Collectors.toList()))).getIsError().booleanValue()) {
                    for (UsersPojo userPojo : (List)userResult.getData()) {
                        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                        operateWrapper.eq(UserOperate::getUserId, (Object)userPojo.getUserId());
                        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)req.getOperateCheckId());
                        operateWrapper.eq(UserOperate::getStatus, (Object)3);
                        operateWrapper.orderByAsc(UserOperate::getCreateTime);
                        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                        checkNum += operateList.size();
                        if (check.getCheckType().equals(0)) {
                            user.setCheckTotalNum(userList.size() * check.getCheckNumber());
                            if (operateList.size() < check.getCheckNumber()) continue;
                            ++finishNum;
                            continue;
                        }
                        if (!check.getCheckType().equals(1)) continue;
                        user.setCheckTotalNum(userList.size());
                        if (operateList.size() < 1) continue;
                        ++finishNum;
                    }
                }
                user.setCheckNum(checkNum);
                user.setUserNum(finishNum);
                user.setUserTotalNum(userList.size());
                examinerWrapper = new LambdaQueryWrapper();
                examinerWrapper.eq(OperateCheckExaminer::getOperateCheckId, (Object)req.getOperateCheckId());
                examinerWrapper.eq(OperateCheckExaminer::getUserId, (Object)examinerPojo.getUserId());
                OperateCheckExaminer examiner = (OperateCheckExaminer)this.operateCheckExaminerMapper.selectOne((Wrapper)examinerWrapper);
                if (!org.springframework.util.StringUtils.isEmpty((Object)examiner.getUncheckDescribe())) {
                    user.setStatus(Integer.valueOf(0));
                    user.setUncheckDescribe(examiner.getUncheckDescribe());
                    user.setCreateTime(check.getCreateTime());
                } else if (user.getCheckNum() == 0) {
                    user.setStatus(Integer.valueOf(1));
                } else if (user.getUserNum() >= user.getUserTotalNum()) {
                    user.setStatus(Integer.valueOf(3));
                    ++finishRateNum;
                } else {
                    user.setStatus(Integer.valueOf(2));
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(user.getUserId())))) {
                    StringBuilder role = new StringBuilder();
                    for (RolePojo rolePojo : (List)userRoleMap.get(user.getUserId())) {
                        role.append(rolePojo.getRoleName()).append(";\n");
                    }
                    user.setRole(role.substring(0, role.length() - 2));
                }
                if (!CollectionUtils.isEmpty(dutiesMap) && dutiesMap.get(user.getUserId()) != null) {
                    user.setPost(((UserDutiesMo)dutiesMap.get(user.getUserId())).getDutieName());
                }
                if (!CollectionUtils.isEmpty(parentMap)) {
                    user.setParentName((String)parentMap.get(user.getUserId()));
                }
                if (!CollectionUtils.isEmpty(parentIdMap)) {
                    user.setParentUserId((Integer)parentIdMap.get(user.getUserId()));
                    userVoList.add(user);
                }
                if (((List)examinerResult.getData()).size() > 0) {
                    result.setCheckRate(Float.valueOf(new BigDecimal(checkRateNum * 100).divide(new BigDecimal(((List)examinerResult.getData()).size()), 1, 5).floatValue()));
                    result.setFinishRate(Float.valueOf(new BigDecimal(finishRateNum * 100).divide(new BigDecimal(((List)examinerResult.getData()).size()), 1, 5).floatValue()));
                }
                userVoList.add(user);
            }
        }
        result.setUserList(userVoList);
        return result;
    }

    @Override
    public List<DetailAnalysisVo> getDetailAnalysis(Integer operateCheckId, String detailName) {
        ArrayList<DetailAnalysisVo> result = new ArrayList<DetailAnalysisVo>();
        LambdaQueryWrapper templateWrapper = new LambdaQueryWrapper();
        templateWrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)operateCheckId);
        OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)templateWrapper);
        if (checkTemplate != null) {
            List detailList;
            LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
            operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operateCheckId);
            operateWrapper.eq(UserOperate::getStatus, (Object)3);
            List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
            List userOperateIdList = operateList.stream().map(UserOperate::getId).collect(Collectors.toList());
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)detailName)) {
                detailWrapper.like(OperateCheckTemplateDetail::getDetailName, (Object)detailName);
            }
            if (!CollectionUtils.isEmpty((Collection)(detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper)))) {
                for (OperateCheckTemplateDetail detail : detailList) {
                    DetailAnalysisVo detailVo = new DetailAnalysisVo();
                    detailVo.setDetailName(detail.getDetailName());
                    detailVo.setDetailType(detail.getDetailType());
                    detailVo.setCategoryName(detail.getCategoryName());
                    if (detail.getDetailType().equals(2)) {
                        detailVo.setDetailUrl(detail.getDetailUrl());
                        LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                        detailDataWrapper.eq(OperateCheckTemplateDetailData::getOperateCheckTemplateId, (Object)checkTemplate.getId());
                        detailDataWrapper.eq(OperateCheckTemplateDetailData::getOperateCheckTemplateDetailId, (Object)detail.getId());
                        List detailDataList = this.operateCheckTemplateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                        if (!CollectionUtils.isEmpty((Collection)detailDataList)) {
                            ArrayList<DetailAnalysisDataVo> dataList = new ArrayList<DetailAnalysisDataVo>();
                            for (OperateCheckTemplateDetailData detailData : detailDataList) {
                                DetailAnalysisDataVo detailDataVo = new DetailAnalysisDataVo();
                                detailDataVo.setDetailName(detailData.getDataName());
                                if (!CollectionUtils.isEmpty(userOperateIdList)) {
                                    LambdaQueryWrapper operatedetailWrapper = new LambdaQueryWrapper();
                                    operatedetailWrapper.in(UserOperateDetail::getUserOperateId, userOperateIdList);
                                    operatedetailWrapper.eq(UserOperateDetail::getCategoryName, (Object)detail.getCategoryName());
                                    operatedetailWrapper.eq(UserOperateDetail::getDetailName, (Object)detail.getDetailName());
                                    operatedetailWrapper.ne(UserOperateDetail::getIsRight, (Object)-1);
                                    List operateDetailList = this.userOperateDetailMapper.selectList((Wrapper)operatedetailWrapper);
                                    List operateDetailIdList = operateDetailList.stream().map(UserOperateDetail::getId).collect(Collectors.toList());
                                    if (!CollectionUtils.isEmpty(operateDetailIdList)) {
                                        LambdaQueryWrapper operatedetailDataWrapper = new LambdaQueryWrapper();
                                        operatedetailDataWrapper.in(UserOperateDetailData::getUserOperateDetailId, operateDetailIdList);
                                        operatedetailDataWrapper.eq(UserOperateDetailData::getDataName, (Object)detailData.getDataName());
                                        List operateDetailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)operatedetailDataWrapper);
                                        detailDataVo.setCheckNum(operateDetailDataList.size());
                                        operatedetailDataWrapper = new LambdaQueryWrapper();
                                        operatedetailDataWrapper.in(UserOperateDetailData::getUserOperateDetailId, operateDetailIdList);
                                        operatedetailDataWrapper.eq(UserOperateDetailData::getDataName, (Object)detailData.getDataName());
                                        operatedetailDataWrapper.eq(UserOperateDetailData::getIsRight, (Object)1);
                                        List rightOperateDetailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)operatedetailDataWrapper);
                                        detailDataVo.setPassNum(rightOperateDetailDataList.size());
                                    }
                                }
                                if (detailVo.getCheckNum() > 0) {
                                    detailDataVo.setPassRate(Float.valueOf(new BigDecimal(detailDataVo.getPassNum() * 100).divide(new BigDecimal(detailDataVo.getCheckNum())).setScale(5, 1).floatValue()));
                                }
                                dataList.add(detailDataVo);
                            }
                            detailVo.setDataList(dataList);
                        }
                    } else {
                        if (!CollectionUtils.isEmpty(userOperateIdList)) {
                            LambdaQueryWrapper operatedetailWrapper = new LambdaQueryWrapper();
                            operatedetailWrapper.in(UserOperateDetail::getUserOperateId, userOperateIdList);
                            operatedetailWrapper.eq(UserOperateDetail::getCategoryName, (Object)detail.getCategoryName());
                            operatedetailWrapper.eq(UserOperateDetail::getDetailName, (Object)detail.getDetailName());
                            operatedetailWrapper.ne(UserOperateDetail::getIsRight, (Object)-1);
                            List operateDetailList = this.userOperateDetailMapper.selectList((Wrapper)operatedetailWrapper);
                            detailVo.setCheckNum(operateDetailList.size());
                            operatedetailWrapper = new LambdaQueryWrapper();
                            operatedetailWrapper.in(UserOperateDetail::getUserOperateId, userOperateIdList);
                            operatedetailWrapper.eq(UserOperateDetail::getCategoryName, (Object)detail.getCategoryName());
                            operatedetailWrapper.eq(UserOperateDetail::getDetailName, (Object)detail.getDetailName());
                            operatedetailWrapper.eq(UserOperateDetail::getIsRight, (Object)1);
                            List rightOperateDetailList = this.userOperateDetailMapper.selectList((Wrapper)operatedetailWrapper);
                            detailVo.setPassNum(rightOperateDetailList.size());
                        }
                        if (detailVo.getCheckNum() > 0) {
                            detailVo.setPassRate(Float.valueOf(new BigDecimal(detailVo.getPassNum() * 100).divide(new BigDecimal(detailVo.getCheckNum()), 1, 1).floatValue()));
                        }
                    }
                    result.add(detailVo);
                }
            }
        }
        return result;
    }

    @Override
    public String getMyPrivilegeUser(Integer groupId, Integer id) {
        List userIdList;
        BaseResult userResult;
        BaseResult baseResult = this.userOrganizeApi.getUserIdsByPrivilegeUserId(groupId, id);
        if (!(baseResult.getIsError().booleanValue() || (userResult = this.userApi.getUserByIdList(userIdList = (List)baseResult.getData())).getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)userResult.getData())))) {
            ArrayList<Users> userList = new ArrayList<Users>();
            for (UsersPojo userPojo : (List)userResult.getData()) {
                Users user = new Users();
                user.setId(userPojo.getId());
                user.setShowName(userPojo.getShowName());
                user.setGroupId(userPojo.getGroupId());
                userList.add(user);
            }
            return JsonResult.success(userList);
        }
        return JsonResult.success();
    }

    @Override
    public String addExaminerRemark(Integer userOperateId, String examinerRemark) {
        UserOperate userOperate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        if (userOperate != null) {
            userOperate.setExaminerRemark(examinerRemark);
            this.userOperateMapper.updateById(userOperate);
        }
        return JsonResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downTraineeAnalysis(Users users, TraineeAnalysisReq req, HttpServletResponse resp) {
        TraineeAnalysisVo vo = this.getTraineeAnalysis(req, users);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
        String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
        String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
        String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
        String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.student.execl", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell0 = row1.createCell(0);
        cell0.setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
        Cell cell1 = row1.createCell(1);
        cell1.setCellValue(employeeNumber);
        Cell cell2 = row1.createCell(2);
        cell2.setCellValue(department);
        Cell cell3 = row1.createCell(3);
        cell3.setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
        Cell cell4 = row1.createCell(4);
        cell4.setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
        Cell cell5 = row1.createCell(5);
        cell5.setCellValue(this.messageSource.getMessage("training.task.complete.schedule", null, locale));
        Cell cell6 = row1.createCell(6);
        cell6.setCellValue(passStatusName);
        if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
            List list = vo.getUserList();
            for (int i = 0; i < list.size(); ++i) {
                TraineeAnalysisUserVo userVo = (TraineeAnalysisUserVo)list.get(i);
                Row row = sheet.createRow(i + 1);
                Cell c0 = row.createCell(0);
                c0.setCellValue(userVo.getShowName());
                Cell c1 = row.createCell(1);
                c1.setCellValue(userVo.getEmployeeNumber());
                Cell c2 = row.createCell(2);
                c2.setCellValue(userVo.getOrganizes());
                Cell c3 = row.createCell(3);
                c3.setCellValue(DateUtils.format(userVo.getStartTime(), "MM/dd HH:mm"));
                Cell c4 = row.createCell(4);
                c4.setCellValue(DateUtils.format(userVo.getFinishTime(), "MM/dd HH:mm"));
                Cell c5 = row.createCell(5);
                if (userVo.getStatus() != null && userVo.getStatus().equals(2)) {
                    c5.setCellValue(going + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                } else if (userVo.getStatus() != null && userVo.getStatus().equals(3)) {
                    c5.setCellValue(completed + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                } else {
                    c5.setCellValue(unStart + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                }
                if (userVo.getIsPass() == null) continue;
                Cell c6 = row.createCell(6);
                if (userVo.getIsPass().equals(1)) {
                    c6.setCellValue(passName);
                    continue;
                }
                c6.setCellValue(unPassName);
            }
        }
        try {
            resp.setContentType("application/vnd.ms-excel; charset=utf-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.student.execl", null, locale) + ".xls");
            ServletOutputStream output = resp.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downExaminerAnalysis(Users users, ExaminerAnalysisReq req, HttpServletResponse resp) {
        ExaminerAnalysisVo vo = this.getExaminerAnalysis(req, users);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
        String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
        String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
        String going = this.messageSource.getMessage("training.job.status.going", null, locale);
        String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
        String notMark = this.messageSource.getMessage("training.operate.not.mark", null, locale);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.operate.analysis.execl", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell0 = row1.createCell(0);
        String checker = this.messageSource.getMessage("training.operate.checker", null, locale);
        cell0.setCellValue(checker);
        Cell cell1 = row1.createCell(1);
        cell1.setCellValue(employeeNumber);
        Cell cell2 = row1.createCell(2);
        cell2.setCellValue(department);
        Cell cell3 = row1.createCell(3);
        cell3.setCellValue(completed + "/" + this.messageSource.getMessage("training.operate.people.count", null, locale));
        Cell cell4 = row1.createCell(4);
        cell4.setCellValue(this.messageSource.getMessage("training.operate.schedule", null, locale) + "(" + this.messageSource.getMessage("training.operate.order.number", null, locale) + ")");
        if (!CollectionUtils.isEmpty((Collection)vo.getUserList())) {
            List list = vo.getUserList();
            for (int i = 0; i < list.size(); ++i) {
                ExaminerAnalysisUserVo userVo = (ExaminerAnalysisUserVo)list.get(i);
                Row row = sheet.createRow(i + 1);
                Cell c0 = row.createCell(0);
                c0.setCellValue(userVo.getShowName());
                Cell c1 = row.createCell(1);
                c1.setCellValue(userVo.getEmployeeNumber());
                Cell c2 = row.createCell(2);
                c2.setCellValue(userVo.getOrganizes());
                Cell c3 = row.createCell(3);
                if (userVo.getUserTotalNum() > 0) {
                    c3.setCellValue(userVo.getUserNum() + "/" + userVo.getUserTotalNum());
                } else {
                    c3.setCellValue("-");
                }
                Cell c4 = row.createCell(4);
                if (userVo.getStatus().equals(0)) {
                    c4.setCellValue(notMark);
                    continue;
                }
                if (userVo.getStatus().equals(1)) {
                    if (userVo.getUserTotalNum() > 0) {
                        c4.setCellValue(unStart + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                        continue;
                    }
                    c4.setCellValue(unStart + " ");
                    continue;
                }
                if (userVo.getStatus().equals(2)) {
                    c4.setCellValue(going + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
                    continue;
                }
                if (!userVo.getStatus().equals(3)) continue;
                c4.setCellValue(completed + " " + userVo.getCheckNum() + "/" + userVo.getCheckTotalNum());
            }
        }
        try {
            resp.setContentType("application/vnd.ms-excel; charset=utf-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.operate.analysis.execl", null, locale) + ".xls");
            ServletOutputStream output = resp.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downDetailAnalysis(Integer operateCheckId, String detailName, HttpServletResponse resp) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List<DetailAnalysisVo> list = this.getDetailAnalysis(operateCheckId, detailName);
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(this.messageSource.getMessage("training.operate.execl", null, locale));
        Row row1 = sheet.createRow(0);
        Cell cell0 = row1.createCell(0);
        cell0.setCellValue(this.messageSource.getMessage("training.operate.project.content", null, locale));
        Cell cell1 = row1.createCell(1);
        String category = this.messageSource.getMessage("training.operate.category", null, locale);
        cell1.setCellValue(category);
        Cell cell2 = row1.createCell(2);
        cell2.setCellValue(this.messageSource.getMessage("training.operate.count", null, locale));
        Cell cell3 = row1.createCell(3);
        cell3.setCellValue(this.messageSource.getMessage("training.job.status.pass.num", null, locale));
        Cell cell4 = row1.createCell(4);
        cell4.setCellValue(this.messageSource.getMessage("training.job.task.pass.rate", null, locale));
        if (!CollectionUtils.isEmpty(list)) {
            int i = 1;
            for (DetailAnalysisVo userVo : list) {
                Row row = sheet.createRow(i);
                Cell c0 = row.createCell(0);
                c0.setCellValue(userVo.getDetailName());
                Cell c1 = row.createCell(1);
                c1.setCellValue(userVo.getCategoryName());
                if (userVo.getDetailType().equals(1)) {
                    Cell c2 = row.createCell(2);
                    c2.setCellValue((double)userVo.getCheckNum());
                    Cell c3 = row.createCell(3);
                    c3.setCellValue((double)userVo.getPassNum());
                    Cell c4 = row.createCell(4);
                    if (userVo.getCheckNum() > 0) {
                        c4.setCellValue(new BigDecimal(userVo.getPassNum() * 100).divide(new BigDecimal(userVo.getCheckNum()), 1, 5) + "%");
                    } else {
                        c4.setCellValue("0%");
                    }
                }
                ++i;
                if (CollectionUtils.isEmpty((Collection)userVo.getDataList())) continue;
                for (DetailAnalysisDataVo userVo2 : userVo.getDataList()) {
                    Row rrow = sheet.createRow(i);
                    Cell cc0 = rrow.createCell(0);
                    cc0.setCellValue(userVo2.getDetailName());
                    Cell cc2 = rrow.createCell(2);
                    cc2.setCellValue((double)userVo2.getCheckNum());
                    Cell cc3 = rrow.createCell(3);
                    cc3.setCellValue((double)userVo2.getPassNum());
                    Cell cc4 = rrow.createCell(4);
                    if (userVo2.getCheckNum() > 0) {
                        cc4.setCellValue(new BigDecimal(userVo2.getPassNum() * 100).divide(new BigDecimal(userVo2.getCheckNum()), 1, 5) + "%");
                    } else {
                        cc4.setCellValue("0%");
                    }
                    ++i;
                }
            }
        }
        try {
            resp.setContentType("application/vnd.ms-excel; charset=utf-8");
            resp.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.operate.execl", null, locale) + ".xls");
            ServletOutputStream output = resp.getOutputStream();
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getTraineeAnalysisDetail(Integer operateCheckId, Integer userId) {
        ArrayList<TraineeAnalysisDetailVo> result = new ArrayList<TraineeAnalysisDetailVo>();
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)operateCheckId);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(2);
        statusList.add(3);
        operateWrapper.in(UserOperate::getStatus, statusList);
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List list = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
            for (UserOperate userOperate : list) {
                TraineeAnalysisDetailVo vo = new TraineeAnalysisDetailVo();
                vo.setUserOperateId(userOperate.getId());
                vo.setFinishTime(userOperate.getFinishTime());
                vo.setUseTime(Long.valueOf((long)(check.getCheckDuration() * 60000) - Long.parseLong(userOperate.getRemainingTime())));
                vo.setScore(userOperate.getScore());
                vo.setIsPass(userOperate.getIsPass());
                result.add(vo);
            }
        }
        return JsonResult.success(result);
    }

    @Override
    public String getExaminerAnalysisDetail(Integer operateCheckId, Integer userId) {
        ExaminerAnalysisDetailVo result = new ExaminerAnalysisDetailVo();
        int finishNum = 0;
        int passNum = 0;
        ArrayList<ExaminerAnalysisDetailUserVo> userVoList = new ArrayList<ExaminerAnalysisDetailUserVo>();
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)operateCheckId);
        userWrapper.eq(OperateCheckUser::getExaminerId, (Object)userId);
        List userList = this.operateCheckUserMapper.selectList((Wrapper)userWrapper);
        List userIds = userList.stream().map(OperateCheckUser::getUserId).collect(Collectors.toList());
        BaseResult userResult = this.userApi.getUserByIdList(userIds);
        if (!userResult.getIsError().booleanValue()) {
            for (UsersPojo userPojo : (List)userResult.getData()) {
                ExaminerAnalysisDetailUserVo user = new ExaminerAnalysisDetailUserVo();
                user.setShowName(userPojo.getShowName());
                user.setEmployeeNumber(userPojo.getEmployeeNumber());
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(userPojo.getId());
                    user.setOrganizes(list.get(0));
                }
                OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getUserId, (Object)userPojo.getUserId());
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(2);
                statusList.add(3);
                operateWrapper.in(UserOperate::getStatus, statusList);
                operateWrapper.orderByAsc(UserOperate::getCreateTime);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                if (!CollectionUtils.isEmpty((Collection)operateList)) {
                    if (check.getCheckScoreChoice().equals("0")) {
                        for (UserOperate userOperate : operateList) {
                            if (userOperate.getScore() == null || !(user.getScore() <= userOperate.getScore().floatValue())) continue;
                            user.setScore(userOperate.getScore().floatValue());
                            user.setIsPass(userOperate.getIsPass());
                        }
                    } else if (check.getCheckScoreChoice().equals("1")) {
                        for (int i = operateList.size() - 1; i >= 0; --i) {
                            UserOperate operate = (UserOperate)operateList.get(i);
                            if (operate.getScore() == null || operate.getIsPass() == null) continue;
                            user.setScore(operate.getScore().floatValue());
                            user.setIsPass(operate.getIsPass());
                            break;
                        }
                    }
                    if (check.getCheckType().equals(0)) {
                        if (operateList.size() >= check.getCheckNumber()) {
                            ++finishNum;
                        }
                    } else if (check.getCheckType().equals(1)) {
                        ++finishNum;
                    }
                    if (user.getIsPass() != null && user.getIsPass().equals(1)) {
                        ++passNum;
                    }
                    ArrayList<TraineeAnalysisDetailVo> operateVoList = new ArrayList<TraineeAnalysisDetailVo>();
                    for (UserOperate userOperate : operateList) {
                        TraineeAnalysisDetailVo vo = new TraineeAnalysisDetailVo();
                        vo.setUserOperateId(userOperate.getId());
                        vo.setFinishTime(userOperate.getFinishTime());
                        vo.setUseTime(Long.valueOf((long)(check.getCheckDuration() * 60000) - Long.parseLong(userOperate.getRemainingTime())));
                        vo.setScore(userOperate.getScore());
                        vo.setIsPass(userOperate.getIsPass());
                        operateVoList.add(vo);
                    }
                    user.setOperateList(operateVoList);
                }
                userVoList.add(user);
            }
        }
        if (!CollectionUtils.isEmpty(userVoList)) {
            result.setFinishRate(Float.valueOf(new BigDecimal(finishNum * 100).divide(new BigDecimal(userVoList.size()), 1, 5).floatValue()));
            result.setPassRate(Float.valueOf(new BigDecimal(passNum * 100).divide(new BigDecimal(userVoList.size()), 1, 5).floatValue()));
        }
        result.setUserList(userVoList);
        return JsonResult.success((Object)result);
    }

    @Override
    public String getOperateDetail(Integer userOperateId) {
        return JsonResult.success((Object)this.getOperateDetailVo(userOperateId));
    }

    private OperateDetailVo getOperateDetailVo(Integer userOperateId) {
        BaseResult baseResult1;
        OperateDetailVo result = new OperateDetailVo();
        UserOperate userOperate = (UserOperate)this.userOperateMapper.selectById(userOperateId);
        result.setIsPass(userOperate.getIsPass());
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(userOperate.getOperateCheckId());
        BeanUtils.copyProperties((Object)check, (Object)result);
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        BaseResult myUserResult = this.userApi.getUserById(userOperate.getUserId());
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            result.setShowName(userPojo.getShowName());
            result.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                result.setOrganizes(list.get(0));
            }
        }
        if (!(baseResult1 = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(userOperate.getEnterpriseId())).getIsError().booleanValue() && Objects.nonNull(baseResult1.getData())) {
            result.setCompanyName(((EnterpriseGroupMo)baseResult1.getData()).getName());
        } else {
            result.setCompanyName("");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OperateCheckTemplate::getOperateCheckId, (Object)userOperate.getOperateCheckId());
        OperateCheckTemplate checkTemplate = (OperateCheckTemplate)this.operateCheckTemplateMapper.selectOne((Wrapper)wrapper);
        result.setTotalScore(checkTemplate.getTotalScore().floatValue());
        result.setPassScore(checkTemplate.getPassScore().floatValue());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.eq(OperateCheckTemplateDetail::getOperateCheckTemplateId, (Object)checkTemplate.getId());
        List detailList = this.operateCheckTemplateDetailMapper.selectList((Wrapper)detailWrapper);
        result.setDetailNum(detailList.size());
        LambdaQueryWrapper checkUserWrapper = new LambdaQueryWrapper();
        checkUserWrapper.eq(OperateCheckUser::getOperateCheckId, (Object)userOperate.getOperateCheckId());
        checkUserWrapper.eq(OperateCheckUser::getUserId, (Object)userOperate.getUserId());
        OperateCheckUser checkUser = (OperateCheckUser)this.operateCheckUserMapper.selectOne((Wrapper)checkUserWrapper);
        BaseResult examinerUserResult = this.userApi.getUserById(checkUser.getExaminerId());
        if (!examinerUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)examinerUserResult.getData();
            result.setExaminerShowName(userPojo.getShowName());
        }
        ArrayList<UserOperateCatagoryVo> catagoryList = new ArrayList<UserOperateCatagoryVo>();
        String take = this.messageSource.getMessage("training.operate.take", null, locale);
        List<String> catagoryNameList = this.userOperateDetailMapper.groupByCatagory(userOperateId);
        for (String catagoryName : catagoryNameList) {
            LambdaQueryWrapper categoryWrapper = new LambdaQueryWrapper();
            categoryWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperateId);
            categoryWrapper.eq(UserOperateDetail::getCategoryName, (Object)catagoryName);
            List catagoryDetailList = this.userOperateDetailMapper.selectList((Wrapper)categoryWrapper);
            UserOperateCatagoryVo catagoryVo = new UserOperateCatagoryVo();
            catagoryVo.setCatagoryName(catagoryName);
            ArrayList<UserOperateDetailVo> detailVoList = new ArrayList<UserOperateDetailVo>();
            for (UserOperateDetail detail : catagoryDetailList) {
                UserOperateDetailVo detailVo = new UserOperateDetailVo();
                BeanUtils.copyProperties((Object)detail, (Object)detailVo);
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailParameter())) {
                    detailVo.setPatameterList(JSONObject.parseArray((String)detail.getDetailParameter(), TrainingMaterialParameter.class));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)detail.getDetailUrl())) {
                    detailVo.setUrlList(JSONObject.parseArray((String)detail.getDetailUrl(), TrainingMaterialProductPicture.class));
                }
                if (detail.getDetailType().equals(2)) {
                    ArrayList<UserOperateDetailDataVo> detailDataVoList = new ArrayList<UserOperateDetailDataVo>();
                    LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperateId);
                    detailDataWrapper.eq(UserOperateDetailData::getUserOperateDetailId, (Object)detail.getId());
                    List detailDataList = this.userOperateDetailDataMapper.selectList((Wrapper)detailDataWrapper);
                    for (UserOperateDetailData detailData : detailDataList) {
                        UserOperateDetailDataVo detailDataVo = new UserOperateDetailDataVo();
                        BeanUtils.copyProperties((Object)detailData, (Object)detailDataVo);
                        if (take.equals(detailData.getDataName())) {
                            detailDataVo.setIsNeedScan(1);
                        }
                        LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                        attaWrapper.eq(UserOperateAtta::getDetailType, (Object)2);
                        attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detailData.getId());
                        List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            detailDataVo.setAttaList(list);
                        }
                        detailDataVoList.add(detailDataVo);
                    }
                    detailVo.setDetailDataList(detailDataVoList);
                }
                LambdaQueryWrapper attaWrapper = new LambdaQueryWrapper();
                attaWrapper.eq(UserOperateAtta::getDetailType, (Object)1);
                attaWrapper.eq(UserOperateAtta::getBusinessKey, (Object)detail.getId());
                List list = this.userOperateAttaMapper.selectList((Wrapper)attaWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    detailVo.setAttaList(list);
                }
                detailVoList.add(detailVo);
            }
            catagoryVo.setDetailList(detailVoList);
            catagoryList.add(catagoryVo);
        }
        result.setCatagoryList(catagoryList);
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getUserId, (Object)userOperate.getUserId());
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)userOperate.getOperateCheckId());
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(2);
        statusList.add(3);
        operateWrapper.in(UserOperate::getStatus, statusList);
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)operateList)) {
            List idList = operateList.stream().map(UserOperate::getId).collect(Collectors.toList());
            result.setUserOperateIdList(idList);
        }
        if (check.getCheckScoreChoice().equals("0")) {
            for (UserOperate operate : operateList) {
                if (operate.getScore() == null || !(result.getScore() <= operate.getScore().floatValue())) continue;
                result.setScore(operate.getScore().floatValue());
                result.setMyIsPass(operate.getIsPass());
            }
        } else if (check.getCheckScoreChoice().equals("1")) {
            for (int i = operateList.size() - 1; i >= 0; --i) {
                UserOperate operate;
                operate = (UserOperate)operateList.get(i);
                if (operate.getScore() == null || operate.getIsPass() == null) continue;
                result.setMyIsPass(operate.getIsPass());
                break;
            }
        }
        result.setFinishTime(userOperate.getFinishTime());
        result.setUseTime(Long.valueOf((long)(check.getCheckDuration() * 60000) - Long.parseLong(userOperate.getRemainingTime())));
        if (userOperate.getScore() != null) {
            result.setScore(userOperate.getScore().floatValue());
        }
        return result;
    }

    @Override
    public StudentOperateVo getStudentOperate(Date startTime, Date endTime, String checkName, Integer status, Integer userId) {
        BaseResult userResult;
        StudentOperateVo result = new StudentOperateVo();
        if (null != userId && !(userResult = this.userApi.getUserById(userId)).getIsError().booleanValue()) {
            result.setUserName(((UsersPojo)userResult.getData()).getUserName());
        }
        List<Object> list = this.userOperateMapper.getStudentOperateDetail(startTime, endTime, checkName, userId);
        List operateCheckIdList = list.stream().map(StudentOperateDetailVo::getOperateCheckId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            List unPassList;
            List passList;
            Map<Object, Object> checkListById = new HashMap();
            if (!CollectionUtils.isEmpty(operateCheckIdList)) {
                LambdaQueryWrapper operateCheckWrapper = new LambdaQueryWrapper();
                operateCheckWrapper.in(OperateCheck::getId, operateCheckIdList);
                List checkList = this.operateCheckMapper.selectList((Wrapper)operateCheckWrapper);
                checkListById = checkList.stream().collect(Collectors.toMap(OperateCheck::getId, Function.identity()));
            }
            block0: for (StudentOperateDetailVo detail : list) {
                OperateCheck check = (OperateCheck)checkListById.get(detail.getOperateCheckId());
                detail.setCheckDuration(check.getCheckDuration());
                detail.setCheckNumber(check.getCheckNumber());
                LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
                operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
                operateWrapper.eq(UserOperate::getUserId, (Object)userId);
                operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(1);
                statusList.add(2);
                statusList.add(3);
                operateWrapper.in(UserOperate::getStatus, statusList);
                operateWrapper.orderByAsc(UserOperate::getCreateTime);
                List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
                detail.setLastOperateTime(((UserOperate)operateList.get(operateList.size() - 1)).getCreateTime());
                if (check.getCheckType() == 1) {
                    detail.setCheckNumber(Integer.valueOf(1));
                    if (operateList.size() >= 1) {
                        detail.setTimeStatus(Integer.valueOf(2));
                    }
                } else {
                    detail.setCheckNumber(check.getCheckNumber());
                    if (operateList.size() >= check.getCheckNumber()) {
                        detail.setTimeStatus(Integer.valueOf(2));
                    }
                }
                if (check.getCheckType().equals(0)) {
                    if (CollectionUtils.isEmpty((Collection)operateList) || operateList.size() < check.getCheckNumber()) continue;
                    for (UserOperate userOperate : operateList) {
                        if (userOperate.getScore() == null || !(detail.getTotalScore() <= userOperate.getScore().floatValue())) continue;
                        detail.setIsPass(userOperate.getIsPass());
                        detail.setTotalScore(userOperate.getScore().floatValue());
                        if (userOperate.getIsPass().equals(1)) {
                            detail.setStatus(Integer.valueOf(2));
                            continue;
                        }
                        detail.setStatus(Integer.valueOf(3));
                    }
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)operateList)) continue;
                for (int i = operateList.size() - 1; i >= 0; --i) {
                    UserOperate operate = (UserOperate)operateList.get(i);
                    if (operate.getIsPass() == null) continue;
                    detail.setIsPass(operate.getIsPass());
                    if (operate.getIsPass().equals(1)) {
                        detail.setStatus(Integer.valueOf(2));
                        continue block0;
                    }
                    detail.setStatus(Integer.valueOf(3));
                    continue block0;
                }
            }
            result.setTotalData(list.size());
            List ingList = list.stream().filter(s -> s.getStatus().equals(1)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ingList)) {
                result.setIngData(ingList.size());
            }
            if (!CollectionUtils.isEmpty(passList = list.stream().filter(s -> s.getStatus().equals(2)).collect(Collectors.toList()))) {
                result.setPassData(passList.size());
            }
            if (!CollectionUtils.isEmpty(unPassList = list.stream().filter(s -> s.getStatus().equals(3)).collect(Collectors.toList()))) {
                result.setUnPassData(unPassList.size());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                list = list.stream().filter(s -> s.getStatus().equals(status)).collect(Collectors.toList());
            }
            result.setDataList(list);
        }
        return result;
    }

    @Override
    public StudentOperateVo getStudentOperateList(String checkName, Users user) {
        StudentOperateVo result = new StudentOperateVo();
        List<StudentOperateDetailVo> list = this.userOperateMapper.getAllStudentOperateDetail(user.getGroupId(), checkName);
        List operateCheckIdList = list.stream().map(StudentOperateDetailVo::getOperateCheckId).collect(Collectors.toList());
        LambdaQueryWrapper operateCheckWrapper = new LambdaQueryWrapper();
        operateCheckWrapper.in(OperateCheck::getId, operateCheckIdList);
        List checkList = this.operateCheckMapper.selectList((Wrapper)operateCheckWrapper);
        Map checkListById = checkList.stream().collect(Collectors.toMap(OperateCheck::getId, Function.identity()));
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)user.getGroupId());
        List checkIdList = checkList.stream().map(OperateCheck::getId).collect(Collectors.toList());
        operateWrapper.in(UserOperate::getOperateCheckId, checkIdList);
        operateWrapper.in(UserOperate::getStatus, Arrays.asList(1, 2, 3));
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List allOperateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        Map<Integer, List<UserOperate>> operateListByCheckId = allOperateList.stream().collect(Collectors.groupingBy(UserOperate::getOperateCheckId));
        if (!CollectionUtils.isEmpty(list)) {
            List unPassList;
            List passList;
            block0: for (StudentOperateDetailVo detail : list) {
                OperateCheck check = (OperateCheck)checkListById.get(detail.getOperateCheckId());
                detail.setCheckDuration(check.getCheckDuration());
                detail.setCheckNumber(check.getCheckNumber());
                List<UserOperate> operateList = operateListByCheckId.get(check.getId());
                detail.setLastOperateTime(operateList.get(operateList.size() - 1).getCreateTime());
                if (check.getCheckType() == 1) {
                    detail.setCheckNumber(Integer.valueOf(1));
                } else {
                    detail.setCheckNumber(check.getCheckNumber());
                }
                if (check.getCheckType().equals(0)) {
                    if (CollectionUtils.isEmpty(operateList) || operateList.size() < check.getCheckNumber()) continue;
                    for (UserOperate userOperate : operateList) {
                        if (userOperate.getScore() == null || !(detail.getTotalScore() <= userOperate.getScore().floatValue())) continue;
                        detail.setIsPass(userOperate.getIsPass());
                    }
                    continue;
                }
                if (CollectionUtils.isEmpty(operateList)) continue;
                for (int i = operateList.size() - 1; i >= 0; --i) {
                    UserOperate operate = operateList.get(i);
                    if (operate.getIsPass() == null) continue;
                    detail.setIsPass(operate.getIsPass());
                    continue block0;
                }
            }
            result.setTotalData(list.size());
            List ingList = list.stream().filter(s -> s.getStatus().equals(1)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ingList)) {
                result.setIngData(ingList.size());
            }
            if (!CollectionUtils.isEmpty(passList = list.stream().filter(s -> s.getStatus().equals(2)).collect(Collectors.toList()))) {
                result.setPassData(passList.size());
            }
            if (!CollectionUtils.isEmpty(unPassList = list.stream().filter(s -> s.getStatus().equals(3)).collect(Collectors.toList()))) {
                result.setUnPassData(unPassList.size());
            }
            result.setDataList(list);
        }
        return result;
    }

    @Override
    public String getStudentOperateDetail(Integer operateCheckId, Integer userId) {
        ArrayList<StudentOperateDetailListVo> result = new ArrayList<StudentOperateDetailListVo>();
        OperateCheck check = (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)check.getEnterpriseId());
        operateWrapper.eq(UserOperate::getUserId, (Object)userId);
        operateWrapper.eq(UserOperate::getOperateCheckId, (Object)check.getId());
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(2);
        statusList.add(3);
        operateWrapper.in(UserOperate::getStatus, statusList);
        operateWrapper.orderByAsc(UserOperate::getCreateTime);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        for (UserOperate userOperate : operateList) {
            StudentOperateDetailListVo vo = new StudentOperateDetailListVo();
            vo.setFinishTime(userOperate.getFinishTime());
            vo.setUseTime(check.getCheckDuration() * 60000 - Integer.parseInt(userOperate.getRemainingTime()));
            vo.setScore(userOperate.getScore().floatValue());
            if (userOperate.getScore() != null) {
                if ((float)check.getPassLine().intValue() <= userOperate.getScore().floatValue()) {
                    vo.setStatus(2);
                } else {
                    vo.setStatus(3);
                }
            } else {
                vo.setStatus(1);
            }
            result.add(vo);
        }
        return JsonResult.success(result);
    }

    @Override
    public void convertToPdf(Integer userOperateId, HttpServletResponse response) {
        OperateDetailVo result = this.getOperateDetailVo(userOperateId);
        Document document = new Document(PageSize.A4);
        String fileName = "";
        List<String> imageList = Arrays.asList("png", "jpg", "jpeg");
        try {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String operateName = this.messageSource.getMessage("training.operate.name", null, locale);
            String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
            String passName = this.messageSource.getMessage("training.job.status.pass", null, locale);
            String notPassName = this.messageSource.getMessage("training.job.status.not.pass", null, locale);
            String notUse = this.messageSource.getMessage("training.job.status.not.use", null, locale);
            String scoreName = this.messageSource.getMessage("training.paper.score", null, locale);
            String ovopark = this.messageSource.getMessage("training.operate.ovopark", null, locale);
            fileName = result.getCheckName() + "_" + result.getShowName() + "_" + DateUtils.getNowForLong() + ".pdf";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            BaseFont bfchinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            document.open();
            PdfPTable table1 = new PdfPTable(6);
            table1.setWidthPercentage(100.0f);
            PdfPCell cell = new PdfPCell(new Phrase(operateName, new Font(bfchinese, 16.0f, 0, BaseColor.WHITE)));
            cell.setColspan(1);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            cell.setCellEvent(new PdfPCellEvent(){

                public void cellLayout(PdfPCell pdfPCell, Rectangle rect, PdfContentByte[] canvas) {
                    PdfContentByte cb = canvas[2];
                    cb.roundRectangle(4.0f, 2.0f, 8.0f, 1.0f, 4.0f);
                    cb.setLineWidth(1.0f);
                    cb.setCMYKColorStrokeF(0.0f, 0.0f, 0.0f, 1.0f);
                    cb.stroke();
                }
            });
            table1.addCell(cell);
            Paragraph p1 = new Paragraph();
            p1.add((Element)new Phrase(DateUtils.getNow(), new Font(bfchinese, 9.0f, -1, BaseColor.WHITE)));
            p1.add((Element)Chunk.NEWLINE);
            p1.add((Element)new Phrase(result.getCompanyName(), new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            cell = new PdfPCell((Phrase)p1);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setColspan(2);
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
            cell.setColspan(2);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table1.addCell(cell);
            Paragraph p2 = new Paragraph();
            p2.add((Element)new Phrase(ovopark, new Font(bfchinese, 10.0f, -1, BaseColor.WHITE)));
            p2.add((Element)Chunk.NEWLINE);
            p2.add((Element)new Phrase("ovopark", new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            cell = new PdfPCell((Phrase)p2);
            cell.setColspan(1);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table1.addCell(cell);
            PdfPTable table2 = new PdfPTable(6);
            table2.setWidthPercentage(100.0f);
            Paragraph p8 = new Paragraph();
            p8.add((Element)new Phrase(result.getCheckName(), new Font(bfchinese, 14.0f, -1, BaseColor.BLACK)));
            p8.add((Element)Chunk.NEWLINE);
            String thumbUrl = result.getThumbUrl();
            if (!org.springframework.util.StringUtils.isEmpty((Object)thumbUrl)) {
                URL url = new URL(thumbUrl);
                Image image = Image.getInstance((URL)url);
                image.scaleAbsolute(72.0f, 72.0f);
                p8.add((Element)new Chunk(image, 0.0f, 0.0f, true));
            }
            cell = new PdfPCell((Phrase)p8);
            cell.setColspan(1);
            cell.setMinimumHeight(20.0f);
            cell.setRowspan(4);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table2.addCell(cell);
            Paragraph p3 = new Paragraph();
            p3.add((Element)new Phrase(result.getShowName(), new Font(bfchinese, 9.0f, 0, new BaseColor(43, 43, 43))));
            p3.add((Element)Chunk.NEWLINE);
            p3.add((Element)new Phrase(result.getOrganizes(), new Font(bfchinese, 12.0f, 0, new BaseColor(176, 176, 176))));
            cell = new PdfPCell((Phrase)p3);
            cell.setColspan(1);
            cell.setMinimumHeight(20.0f);
            cell.setRowspan(4);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table2.addCell(cell);
            cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
            cell.setColspan(1);
            cell.setRowspan(4);
            cell.disableBorderSide(15);
            table2.addCell(cell);
            Paragraph p6 = new Paragraph();
            p6.add((Element)Chunk.NEWLINE);
            p6.add((Element)new Phrase(statusNames + " ", new Font(bfchinese, 12.0f, 0, new BaseColor(176, 176, 176))));
            p6.add((Element)new Phrase(result.getIsPass() == 0 ? notPassName : passName, new Font(bfchinese, 12.0f, 0, new BaseColor(43, 43, 43))));
            p6.add((Element)Chunk.NEWLINE);
            p6.add((Element)new Phrase(this.messageSource.getMessage("training.course.analysis.endtime", null, locale), new Font(bfchinese, 12.0f, 0, new BaseColor(176, 176, 176))));
            p6.add((Element)new Phrase(DateUtils.format(result.getFinishTime()), new Font(bfchinese, 12.0f, 0, new BaseColor(43, 43, 43))));
            p6.add((Element)Chunk.NEWLINE);
            p6.add((Element)new Phrase(this.messageSource.getMessage("training.operate.usetime", null, locale), new Font(bfchinese, 12.0f, 0, new BaseColor(176, 176, 176))));
            p6.add((Element)new Phrase("" + DateUtils.getUseTimeFormal((int)(result.getUseTime() / 1000L)), new Font(bfchinese, 12.0f, 0, new BaseColor(43, 43, 43))));
            p6.add((Element)Chunk.NEWLINE);
            p6.add((Element)new Phrase(scoreName + " ", new Font(bfchinese, 12.0f, 0, new BaseColor(176, 176, 176))));
            p6.add((Element)new Phrase(this.messageSource.getMessage("training.operate.mark.score", new Object[]{result.getExaminerShowName(), Float.valueOf(result.getScore())}, locale), new Font(bfchinese, 12.0f, 0, new BaseColor(43, 43, 43))));
            cell = new PdfPCell((Phrase)p6);
            cell.setColspan(2);
            cell.setRowspan(4);
            cell.disableBorderSide(15);
            table2.addCell(cell);
            cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
            String name = locale.getCountry();
            if (name != null && name.equals("US")) {
                if (result.getIsPass() == 0) {
                    cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/unqualified.png")));
                } else {
                    cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/qualified.png")));
                }
            } else if (name != null && name.equals("ID")) {
                if (result.getIsPass() == 0) {
                    cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/gagal.png")));
                } else {
                    cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/lulus.png")));
                }
            } else if (result.getIsPass() == 0) {
                cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/unpass.png")));
            } else {
                cell.setImage(Image.getInstance((URL)this.getClass().getResource("/picture/pass.png")));
            }
            cell.setColspan(1);
            cell.setMinimumHeight(20.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table2.addCell(cell);
            PdfPTable table3 = new PdfPTable(2);
            table3.setWidthPercentage(100.0f);
            document.add((Element)table1);
            document.add((Element)table2);
            document.add((Element)table3);
            PdfPTable table6 = null;
            PdfPTable table7 = null;
            PdfPTable table8 = null;
            PdfPTable table10 = null;
            PdfPTable table11 = null;
            List catagoryVoList = result.getCatagoryList();
            if (!CollectionUtils.isEmpty((Collection)catagoryVoList)) {
                for (UserOperateCatagoryVo vo : catagoryVoList) {
                    if (Objects.isNull(vo.getCatagoryName())) continue;
                    PdfPTable table5 = new PdfPTable(6);
                    table5.setWidthPercentage(100.0f);
                    cell = new PdfPCell(new Phrase(vo.getCatagoryName(), TextPDFUtil.getColorFont()));
                    cell.setBackgroundColor(new BaseColor(247, 247, 247));
                    cell.setColspan(6);
                    cell.setMinimumHeight(20.0f);
                    cell.setRowspan(1);
                    cell.setHorizontalAlignment(0);
                    cell.setVerticalAlignment(5);
                    table5.addCell(cell);
                    document.add((Element)table5);
                    table6 = new PdfPTable(6);
                    table6.setWidthPercentage(100.0f);
                    cell = new PdfPCell(new Phrase(this.messageSource.getMessage("training.operate.or.exam", null, locale), new Font(bfchinese, 12.0f, 0, BaseColor.BLACK)));
                    cell.setColspan(3);
                    cell.setBackgroundColor(new BaseColor(247, 247, 247));
                    cell.setMinimumHeight(20.0f);
                    cell.setRowspan(1);
                    cell.setHorizontalAlignment(0);
                    cell.setVerticalAlignment(5);
                    cell.disableBorderSide(10);
                    table6.addCell(cell);
                    cell = new PdfPCell(new Phrase(this.messageSource.getMessage("training.operate.result", null, locale), TextPDFUtil.getColorFont()));
                    cell.setColspan(1);
                    cell.setBackgroundColor(new BaseColor(247, 247, 247));
                    cell.setMinimumHeight(20.0f);
                    cell.setRowspan(2);
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.disableBorderSide(10);
                    table6.addCell(cell);
                    cell = new PdfPCell(new Phrase(this.messageSource.getMessage("training.operate.standard.score", null, locale), TextPDFUtil.getColorFont()));
                    cell.setColspan(1);
                    cell.setBackgroundColor(new BaseColor(247, 247, 247));
                    cell.setMinimumHeight(20.0f);
                    cell.setRowspan(2);
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.disableBorderSide(10);
                    table6.addCell(cell);
                    cell = new PdfPCell(new Phrase(scoreName, TextPDFUtil.getColorFont()));
                    cell.setColspan(1);
                    cell.setBackgroundColor(new BaseColor(247, 247, 247));
                    cell.setMinimumHeight(20.0f);
                    cell.setRowspan(2);
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.disableBorderSide(2);
                    table6.addCell(cell);
                    document.add((Element)table6);
                    List detailVoList = vo.getDetailList();
                    if (CollectionUtils.isEmpty((Collection)detailVoList)) continue;
                    for (int index = 0; index < detailVoList.size(); ++index) {
                        List detailDataVoList;
                        int no = index + 1;
                        UserOperateDetailVo detailVo = (UserOperateDetailVo)detailVoList.get(index);
                        String pass = "";
                        if (Objects.nonNull(detailVo.getIsRight())) {
                            if (detailVo.getIsRight() == 0) {
                                pass = notPassName;
                            } else if (detailVo.getIsRight() == 1) {
                                pass = passName;
                            } else if (detailVo.getIsRight() == -1) {
                                pass = notUse;
                            }
                            table7 = new PdfPTable(6);
                            table7.setWidthPercentage(100.0f);
                            if (Objects.nonNull(detailVo.getComment())) {
                                Paragraph p4 = new Paragraph();
                                p4.add((Element)new Phrase(no + "." + detailVo.getDetailName(), TextPDFUtil.getColorFont()));
                                p4.add((Element)Chunk.NEWLINE);
                                String comment = this.messageSource.getMessage("training.material.comment", null, locale);
                                p4.add((Element)new Phrase((String)comment + ":", TextPDFUtil.getColorFont()));
                                p4.add((Element)Chunk.NEWLINE);
                                p4.add((Element)new Phrase(detailVo.getComment(), TextPDFUtil.getColorFont()));
                                cell = new PdfPCell((Phrase)p4);
                            } else {
                                cell = new PdfPCell(new Phrase(no + "." + detailVo.getDetailName(), TextPDFUtil.getColorFont()));
                            }
                            cell.setColspan(3);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(0);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table7.addCell(cell);
                            table8 = new PdfPTable(6);
                            table8.setWidthPercentage(100.0f);
                            List attaList = detailVo.getAttaList();
                            if (!CollectionUtils.isEmpty((Collection)attaList)) {
                                int i;
                                for (UserOperateAtta atta : attaList) {
                                    if (org.springframework.util.StringUtils.isEmpty((Object)atta.getUrl())) continue;
                                    String[] urls = atta.getUrl().split("\\.");
                                    String last = urls[urls.length - 1];
                                    if (imageList.contains(last)) {
                                        cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                        Image image = Image.getInstance((URL)new URL(atta.getUrl()));
                                        image.setAlignment(0);
                                        image.scaleAbsolute(50.0f, 50.0f);
                                        cell.addElement((Element)image);
                                        cell.setColspan(1);
                                        cell.setMinimumHeight(20.0f);
                                        cell.setRowspan(3);
                                        cell.disableBorderSide(11);
                                        table8.addCell(cell);
                                        continue;
                                    }
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.disableBorderSide(15);
                                    table8.addCell(cell);
                                }
                                for (i = 0; i < 6 - attaList.size() - 3; ++i) {
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.setHorizontalAlignment(1);
                                    cell.setVerticalAlignment(5);
                                    cell.disableBorderSide(13);
                                    table8.addCell(cell);
                                }
                                for (i = 0; i < 3; ++i) {
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.setHorizontalAlignment(1);
                                    cell.setVerticalAlignment(5);
                                    cell.disableBorderSide(3);
                                    table8.addCell(cell);
                                }
                            }
                            if (org.springframework.util.StringUtils.isEmpty((Object)pass)) {
                                cell = new PdfPCell(new Phrase("-", TextPDFUtil.getColorFont(BaseColor.GRAY)));
                            } else if (pass.equals(passName)) {
                                cell = new PdfPCell(new Phrase(pass, TextPDFUtil.getColorFont(BaseColor.GREEN)));
                            } else if (pass.equals(notPassName)) {
                                cell = new PdfPCell(new Phrase(pass, TextPDFUtil.getColorFont(BaseColor.RED)));
                            } else if (pass.equals(notUse)) {
                                cell = new PdfPCell(new Phrase(pass, TextPDFUtil.getColorFont(BaseColor.GRAY)));
                            }
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table7.addCell(cell);
                            cell = new PdfPCell(new Phrase(String.valueOf(detailVo.getTotalScore()), TextPDFUtil.getColorFont()));
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table7.addCell(cell);
                            cell = pass.equals(notUse) ? new PdfPCell(new Phrase("-", TextPDFUtil.getColorFont(BaseColor.GRAY))) : new PdfPCell(new Phrase(String.valueOf(detailVo.getScore()), TextPDFUtil.getColorFont()));
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(2);
                            table7.addCell(cell);
                            document.add((Element)table7);
                            document.add((Element)table8);
                        }
                        if (CollectionUtils.isEmpty((Collection)(detailDataVoList = detailVo.getDetailDataList()))) continue;
                        for (int index2 = 0; index2 < detailDataVoList.size(); ++index2) {
                            int no2 = index2 + 1;
                            UserOperateDetailDataVo detailDataVo = (UserOperateDetailDataVo)detailDataVoList.get(index2);
                            List attas = detailDataVo.getAttaList();
                            table11 = new PdfPTable(6);
                            table11.setWidthPercentage(100.0f);
                            table10 = new PdfPTable(6);
                            table10.setWidthPercentage(100.0f);
                            if (Objects.nonNull(detailDataVo.getComment())) {
                                Paragraph p4 = new Paragraph();
                                p4.add((Element)new Phrase(no + "." + no2 + "." + detailVo.getDetailName() + "-" + detailDataVo.getDataName(), TextPDFUtil.getColorFont()));
                                p4.add((Element)Chunk.NEWLINE);
                                String comment = this.messageSource.getMessage("training.material.comment", null, locale);
                                p4.add((Element)new Phrase(comment + ":", TextPDFUtil.getColorFont()));
                                p4.add((Element)Chunk.NEWLINE);
                                p4.add((Element)new Phrase(detailDataVo.getComment(), TextPDFUtil.getColorFont()));
                                cell = new PdfPCell((Phrase)p4);
                            } else {
                                cell = new PdfPCell(new Phrase(no + "." + no2 + "." + detailVo.getDetailName() + "-" + detailDataVo.getDataName(), TextPDFUtil.getColorFont()));
                            }
                            cell.setColspan(3);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(0);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table11.addCell(cell);
                            if (!CollectionUtils.isEmpty((Collection)attas)) {
                                int i;
                                for (UserOperateAtta atta : attas) {
                                    if (org.springframework.util.StringUtils.isEmpty((Object)atta.getUrl())) continue;
                                    String[] urls = atta.getUrl().split("\\.");
                                    String last = urls[urls.length - 1];
                                    if (imageList.contains(last)) {
                                        cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                        Image image = Image.getInstance((URL)new URL(atta.getUrl()));
                                        image.setAlignment(0);
                                        image.scaleAbsolute(100.0f, 100.0f);
                                        cell.addElement((Element)image);
                                        cell.setColspan(1);
                                        cell.setMinimumHeight(20.0f);
                                        cell.setRowspan(3);
                                        cell.disableBorderSide(11);
                                        table10.addCell(cell);
                                        continue;
                                    }
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.disableBorderSide(15);
                                    table10.addCell(cell);
                                }
                                for (i = 0; i < 6 - attas.size() - 3; ++i) {
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.setHorizontalAlignment(1);
                                    cell.setVerticalAlignment(5);
                                    cell.disableBorderSide(13);
                                    table10.addCell(cell);
                                }
                                for (i = 0; i < 3; ++i) {
                                    cell = new PdfPCell(new Phrase("", TextPDFUtil.getColorFont()));
                                    cell.setColspan(1);
                                    cell.setMinimumHeight(20.0f);
                                    cell.setRowspan(3);
                                    cell.setHorizontalAlignment(1);
                                    cell.setVerticalAlignment(5);
                                    cell.disableBorderSide(1);
                                    table10.addCell(cell);
                                }
                            }
                            String right = "";
                            if (Objects.nonNull(detailDataVo.getIsRight())) {
                                if (detailDataVo.getIsRight() == 0) {
                                    right = notPassName;
                                } else if (detailDataVo.getIsRight() == 1) {
                                    right = passName;
                                } else if (detailDataVo.getIsRight() == -1) {
                                    right = notUse;
                                }
                            }
                            if (right.equals(passName)) {
                                cell = new PdfPCell(new Phrase(right, TextPDFUtil.getColorFont(BaseColor.GREEN)));
                            } else if (right.equals(notPassName)) {
                                cell = new PdfPCell(new Phrase(right, TextPDFUtil.getColorFont(BaseColor.RED)));
                            } else if (right.equals(notUse)) {
                                cell = new PdfPCell(new Phrase(right, TextPDFUtil.getColorFont(BaseColor.GRAY)));
                            }
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table11.addCell(cell);
                            cell = new PdfPCell(new Phrase(String.valueOf(detailDataVo.getTotalScore()), TextPDFUtil.getColorFont()));
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(10);
                            table11.addCell(cell);
                            cell = right.equals(notUse) ? new PdfPCell(new Phrase("-", TextPDFUtil.getColorFont(BaseColor.GRAY))) : new PdfPCell(new Phrase(String.valueOf(detailDataVo.getScore()), TextPDFUtil.getColorFont()));
                            cell.setColspan(1);
                            cell.setMinimumHeight(30.0f);
                            cell.setRowspan(2);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.disableBorderSide(2);
                            table11.addCell(cell);
                            document.add((Element)table11);
                            document.add((Element)table10);
                        }
                    }
                }
            }
            PdfPTable table9 = new PdfPTable(6);
            table9.setWidthPercentage(100.0f);
            Paragraph paragraph = new Paragraph();
            paragraph.add((Element)new Phrase(this.messageSource.getMessage("training.operate.copy.right", null, locale), new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            paragraph.add((Element)new Phrase(" "));
            paragraph.add((Element)new Phrase("@", new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            paragraph.add((Element)new Phrase(" "));
            paragraph.add((Element)new Phrase(ovopark, new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            cell = new PdfPCell((Phrase)paragraph);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setColspan(4);
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table9.addCell(cell);
            Paragraph p5 = new Paragraph();
            p5.add((Element)new Phrase("POWER BY  ", new Font(BaseFont.createFont(), 9.0f, 0, BaseColor.WHITE)));
            p5.add((Element)new Phrase(ovopark, new Font(bfchinese, 10.0f, -1, BaseColor.WHITE)));
            p5.add((Element)Chunk.NEWLINE);
            p5.add((Element)new Phrase("   ", new Font(bfchinese, 10.0f, -1, BaseColor.WHITE)));
            p5.add((Element)new Phrase("ovopark", new Font(bfchinese, 8.0f, -1, BaseColor.WHITE)));
            cell = new PdfPCell((Phrase)p5);
            cell.setBackgroundColor(new BaseColor(24, 107, 255));
            cell.setColspan(2);
            cell.setMinimumHeight(30.0f);
            cell.setRowspan(2);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
            cell.disableBorderSide(15);
            table9.addCell(cell);
            document.add((Element)table9);
            document.addTitle(fileName);
            document.close();
            writer.close();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/pdf");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(baos.toByteArray());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String deleteUserOperateById(Integer groupId, Integer userOperateId) {
        LambdaQueryWrapper operateWrapper = new LambdaQueryWrapper();
        operateWrapper.eq(UserOperate::getId, (Object)userOperateId);
        operateWrapper.eq(UserOperate::getEnterpriseId, (Object)groupId);
        List operateList = this.userOperateMapper.selectList((Wrapper)operateWrapper);
        if (!CollectionUtils.isEmpty((Collection)operateList)) {
            UserOperate userOperate = (UserOperate)operateList.get(0);
            LambdaQueryWrapper detailDataScanWrapper = new LambdaQueryWrapper();
            detailDataScanWrapper.eq(UserOperateDetailDataScan::getUserOperateId, (Object)userOperate.getId());
            this.userOperateDetailDataScanMapper.delete((Wrapper)detailDataScanWrapper);
            LambdaQueryWrapper detailDataWrapper = new LambdaQueryWrapper();
            detailDataWrapper.eq(UserOperateDetailData::getUserOperateId, (Object)userOperate.getId());
            this.userOperateDetailDataMapper.delete((Wrapper)detailDataWrapper);
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.eq(UserOperateDetail::getUserOperateId, (Object)userOperate.getId());
            this.userOperateDetailMapper.delete((Wrapper)detailWrapper);
            this.userOperateMapper.deleteById(userOperate.getId());
        }
        return JsonResult.success();
    }
}

