/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.bo.UserBo;
import com.ovopark.training.example.TrainingPaperQuestionExample;
import com.ovopark.training.example.TrainingUserPaperExample;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingAttachUserMapper;
import com.ovopark.training.mapper.TrainingCertificateDetailMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingChapterUnlockMapper;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExamOptionsMapper;
import com.ovopark.training.mapper.TrainingExamQuestionMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingOperateAttachMapper;
import com.ovopark.training.mapper.TrainingOptionsMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperQuestionMapper;
import com.ovopark.training.mapper.TrainingPaperRandomMapper;
import com.ovopark.training.mapper.TrainingPaperRandomTypeMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingQuestionMapper;
import com.ovopark.training.mapper.TrainingQuestionTypeMapper;
import com.ovopark.training.mapper.TrainingStudyStatusMapper;
import com.ovopark.training.mapper.TrainingTaskUserMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserProgressMapper;
import com.ovopark.training.mapper.TrainingUserQuestionAttaMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserQuestionPictureMapper;
import com.ovopark.training.mapper.TrainingUserViewMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.mapper.TrainingVideoSizeMapper;
import com.ovopark.training.mo.KaFKaWorkCircleArticleAddMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleDelMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleUpdSeeUsersMo;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.DepartmentNew;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.Organize;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingAttachUser;
import com.ovopark.training.model.TrainingCertificateDetail;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingChapterUnlock;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExamOptions;
import com.ovopark.training.model.TrainingExamQuestion;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingNav;
import com.ovopark.training.model.TrainingOperateAttach;
import com.ovopark.training.model.TrainingOptions;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperQuestion;
import com.ovopark.training.model.TrainingPaperRandom;
import com.ovopark.training.model.TrainingPaperRandomType;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingQuestion;
import com.ovopark.training.model.TrainingQuestionType;
import com.ovopark.training.model.TrainingStudyStatus;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserProgress;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserQuestionAtta;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.TrainingUserView;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.TrainingVideoSize;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.DepartmentServiceNew;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.KafkaProducerService;
import com.ovopark.training.service.OrganizeService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingExamService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.OrganizeVo;
import com.ovopark.training.vo.PaperScreenNumVo;
import com.ovopark.training.vo.TheirPapersVo;
import com.ovopark.training.vo.TrainingExamQuestionVo;
import com.ovopark.training.vo.TrainingExamVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.TrainingPaperCompletionRateVo;
import com.ovopark.training.vo.TrainingPaperRankingUserVo;
import com.ovopark.training.vo.TrainingPaperRankingVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingQuestionTypeVo;
import com.ovopark.training.vo.TrainingQuestionVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.UserOrganizeVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrainingPaperRemoteServiceImpl
implements TrainingPaperRemoteService {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperRemoteServiceImpl.class);
    @Autowired
    private TrainingPaperMapper paperMapper;
    @Autowired
    private TrainingQuestionMapper questionMapper;
    @Autowired
    private TrainingOptionsMapper optionsMapper;
    @Autowired
    private TrainingRemoteService trainingService;
    @Autowired
    private TrainingPaperQuestionMapper paperQuestionMapper;
    @Autowired
    private TrainingUserPaperMapper userPaperMapper;
    @Autowired
    private TrainingUserQuestionMapper userQuestionMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingUserProgressMapper trainingUserProgressMapper;
    @Autowired
    private TrainingAttachMapper trainingAttachMapper;
    @Autowired
    private TrainingAttachUserMapper trainingAttachUserMapper;
    @Autowired
    private TrainingVideoMapper trainingVideoMapper;
    @Autowired
    private TrainingVideoSizeMapper trainingVideoSizeMapper;
    @Autowired
    private TrainingQuestionTypeMapper trainingQuestionTypeMapper;
    @Autowired
    private TrainingPaperRandomMapper trainingPaperRandomMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingCertificateMapper trainingCertificateMapper;
    @Autowired
    private KafkaProducerService kafkaProducerService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private DepartmentServiceNew departmentService;
    @Autowired
    private TrainingChapterAttachMapper chapterAttachMapper;
    @Autowired
    private TrainingExamService examService;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterUnlockMapper trainingChapterUnlockMapper;
    @Autowired
    private TrainingPaperRandomTypeMapper trainingPaperRandomTypeMapper;
    @Autowired
    private TrainingTaskUserMapper trainingTaskUserMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private TrainingUserViewTimeMapper viewTimeMapper;
    @Autowired
    private TrainingExamQuestionMapper examQuestionMapper;
    @Autowired
    private TrainingExamOptionsMapper examOptionsMapper;
    @Autowired
    private TrainingExamMapper examMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private TrainingCertificateDetailMapper certificateDetailMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingUserQuestionPictureMapper userQuestionPictureMapper;
    @Autowired
    private TrainingOperateAttachMapper trainingOperateAttachMapper;
    @Autowired
    private TrainingUserQuestionAttaMapper trainingUserQuestionAttaMapper;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private UserUtilService userUtilService;
    @Value(value="${training.enterpriseId}")
    private String trainingEnterpriseId;
    @Autowired
    private TrainingUserViewMapper trainingUserViewMapper;
    @Autowired
    private LogApi logApi;
    @Autowired
    private TagApi tagApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi priUserApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private TrainingStudyStatusMapper trainingStudyStatusMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingCommonService commonService;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingQuestionMapper trainingQuestionMapper;
    @Autowired
    private TrainService trainService;
    private static final List<Integer> ENTERPRISE_IDS = new ArrayList<Integer>();
    @Resource(name="oldCommon")
    private Executor cachedThreadPool;

    @PostConstruct
    public void init() {
        List ids = Arrays.stream(this.trainingEnterpriseId.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        ENTERPRISE_IDS.addAll(ids);
        log.info("group", (Object)JSON.toJSONString(ENTERPRISE_IDS));
    }

    @Override
    public Integer saveTrainingPaper(Integer enterpriseId, final TrainingPapersVo paperVo, String userIds, Integer userId, String roles, String tags, String organizes, String questionClass, Integer isAllAnswer, Integer isAutoRead, Integer isGapAutoRead) {
        Date now = new Date();
        if (paperVo.getId() == null) {
            TrainingPaper paper = new TrainingPaper();
            BeanUtils.copyProperties((Object)paperVo, (Object)paper);
            paper.setCreater(userId);
            paper.setCreateTime(now);
            paper.setUpdater(userId);
            paper.setUpdateTime(now);
            paper.setIsAllAnswer(isAllAnswer);
            paper.setIsAutoRead(isAutoRead);
            paper.setIsGapAutoRead(isGapAutoRead);
            if (paper.getExamId() == null && paper.getPaperState() == null) {
                paper.setPaperState(Integer.valueOf(1));
            }
            if (paper.getPaperState() != null && paper.getPaperState() > 0) {
                if (paperVo.getStartTime() == null) {
                    paper.setPaperState(Integer.valueOf(2));
                } else if (paperVo.getStartTime() != null && paperVo.getStartTime().after(now)) {
                    paper.setPaperState(Integer.valueOf(1));
                } else if (paperVo.getEndTime() != null && paperVo.getEndTime().before(now)) {
                    paper.setPaperState(Integer.valueOf(3));
                } else {
                    paper.setPaperState(Integer.valueOf(2));
                }
            }
            if (paperVo.getTrainingNavId() == null) {
                paper.setTrainingNavId(Integer.valueOf(1000000257));
            }
            if (paper.getPaperState() != null && paper.getPaperState() > 0 && paper.getExamId() != null && (org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperType()) || paper.getPaperType() == 1)) {
                paper.setExamId(this.examService.updateCopyExam(paper.getExamId(), userId));
            }
            if (ObjectUtils.isEmpty((Object)paperVo.getStartTime()) && paper.getPaperState() != null && paper.getPaperState() > 0 && paper.getIsTraining() != null && paper.getIsTraining() != 1 && paper.getExamId() != null) {
                paper.setStartTime(now);
            }
            this.paperMapper.insert(paper);
            if (!CollectionUtils.isEmpty((Collection)paperVo.getPaperRandoms())) {
                for (TrainingPaperRandom trainingPaperRandom : paperVo.getPaperRandoms()) {
                    trainingPaperRandom.setPaperId(paper.getId());
                    this.trainingPaperRandomMapper.insert(trainingPaperRandom);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionClass)) {
                    this.saveQuestionClass(paper.getId(), questionClass);
                }
            }
            if (!(paper.getIsMustLink() == null || paper.getIsMustLink() != 0 || paper.getIsVisitorShare() != null && paper.getIsVisitorShare() != 0 || paper.getIsTraining() == null || paper.getIsTraining() != 0 || paper.getPaperState() == null || paper.getPaperState() != 1 && paper.getPaperState() != 2)) {
                com.ovopark.privilege.response.BaseResult baseResult;
                List<Integer> allUsers = null;
                if (org.springframework.util.StringUtils.isEmpty((Object)userIds) && org.springframework.util.StringUtils.isEmpty((Object)roles) && org.springframework.util.StringUtils.isEmpty((Object)tags) && org.springframework.util.StringUtils.isEmpty((Object)organizes)) {
                    baseResult = this.userApi.getUserByGroupIdAndKey(null, paper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List usersPojoList = (List)baseResult.getData();
                        allUsers = usersPojoList.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else {
                    allUsers = StringsUtils.StringToList(userIds, ",");
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)roles) && (baseResult = this.priUserApi.getUserByRoleIds(roles, enterpriseId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)tags)) {
                    ArrayList<Integer> tagIds = new ArrayList<Integer>();
                    String[] tagStrs = tags.split(",");
                    for (int i = 0; i < tagStrs.length; ++i) {
                        tagIds.add(Integer.parseInt(tagStrs[i]));
                    }
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(enterpriseId);
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(userId);
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add(id);
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)organizes)) {
                    ArrayList<String> orgIds = new ArrayList<String>();
                    String[] organizeStrs = organizes.split(",");
                    for (int i = 0; i < organizeStrs.length; ++i) {
                        orgIds.add(organizeStrs[i]);
                    }
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(enterpriseId);
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(allUsers)) {
                    this.sendPaperMessage(allUsers, paper);
                }
            }
            try {
                if (paper != null) {
                    this.sendAddKaFKaWorkCircleArticleAddMo(paper.getTitle(), "TEXT_PAPER", KaFKaWorkCircleArticleAddMo.circle_training, userId, paper.getEnterpriseId(), "1".equals(paper.getLookLevel() == null ? "0" : paper.getLookLevel().toString()) ? 0 : 1, paper.getId(), StringsUtils.StringToList(userIds, ","));
                }
            }
            catch (Exception e) {
                log.info("saveTrainingPaper================sendAddKaFKaWorkCircleArticleAddMo", (Throwable)e);
            }
            return paper.getId();
        }
        final TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperVo.getId());
        boolean isChange = false;
        if (org.springframework.util.StringUtils.isEmpty((Object)paperVo.getRepetitionNum()) && !org.springframework.util.StringUtils.isEmpty((Object)paper.getRepetitionNum())) {
            isChange = true;
        } else if (org.springframework.util.StringUtils.isEmpty((Object)paper.getRepetitionNum()) && !org.springframework.util.StringUtils.isEmpty((Object)paperVo.getRepetitionNum())) {
            isChange = true;
        } else if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getRepetitionNum()) && !org.springframework.util.StringUtils.isEmpty((Object)paperVo.getRepetitionNum()) && paper.getRepetitionNum().intValue() != paperVo.getRepetitionNum().intValue()) {
            isChange = true;
        }
        paper.setUpdateTime(now);
        paper.setUpdater(userId);
        paper.setScoreSelect(paperVo.getScoreSelect());
        paper.setTitle(paperVo.getTitle());
        paper.setRepetitionNum(paperVo.getRepetitionNum());
        paper.setExamId(paperVo.getExamId());
        paper.setIsAllAnswer(isAllAnswer);
        paper.setIsAutoRead(isAutoRead);
        paper.setIsGapAutoRead(isGapAutoRead);
        paper.setIsRemindExaming(paperVo.getIsRemindExaming());
        paper.setIsRemindExampre(paperVo.getIsRemindExampre());
        paper.setRemindExampreHour(paperVo.getRemindExampreHour());
        paper.setIsRemindUnexamDays(paperVo.getIsRemindUnexamDays());
        paper.setIsRemindUnexam(paperVo.getIsRemindUnexam());
        paper.setRemindUnexamHour(paperVo.getRemindUnexamHour());
        if (!(org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperState()) || org.springframework.util.StringUtils.isEmpty((Object)paperVo.getPaperState()) || paper.getPaperState() != 0 || paperVo.getPaperState() != 1 && paperVo.getPaperState() != 2)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)paperVo.getExamId()) && (org.springframework.util.StringUtils.isEmpty((Object)paper.getPaperType()) || paper.getPaperType() == 1)) {
                paper.setExamId(this.examService.updateCopyExam(paperVo.getExamId(), userId));
            }
            if (paper.getIsMustLink() != 1 && paperVo.getIsTraining() == 0) {
                com.ovopark.privilege.response.BaseResult baseResult;
                Object allUsers = null;
                if (org.springframework.util.StringUtils.isEmpty((Object)userIds) && org.springframework.util.StringUtils.isEmpty((Object)roles) && org.springframework.util.StringUtils.isEmpty((Object)tags) && org.springframework.util.StringUtils.isEmpty((Object)organizes)) {
                    baseResult = this.userApi.getUserByGroupIdAndKey(null, paper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                    if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                        List usersPojoList = (List)baseResult.getData();
                        allUsers = usersPojoList.stream().map(UsersPojo::getId).collect(Collectors.toList());
                    }
                } else {
                    allUsers = StringsUtils.StringToList(userIds, ",");
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)roles) && (baseResult = this.priUserApi.getUserByRoleIds(roles, enterpriseId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                    allUsers.addAll(pojo);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)tags)) {
                    ArrayList<Integer> tagIds = new ArrayList<Integer>();
                    String[] tagStrs = tags.split(",");
                    for (int i = 0; i < tagStrs.length; ++i) {
                        tagIds.add(Integer.parseInt(tagStrs[i]));
                    }
                    DepAndTagsPojo pojo = new DepAndTagsPojo();
                    pojo.setGroupId(enterpriseId);
                    pojo.setTagIds(tagIds);
                    pojo.setUserId(userId);
                    BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                    if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                        for (Map map : (List)tagResult.getData()) {
                            Integer id = (Integer)map.get("id");
                            allUsers.add((Integer)id);
                        }
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)organizes)) {
                    ArrayList<String> orgIds = new ArrayList<String>();
                    String[] organizeStrs = organizes.split(",");
                    for (int i = 0; i < organizeStrs.length; ++i) {
                        orgIds.add(organizeStrs[i]);
                    }
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(enterpriseId);
                    mo.setOrganizeIds(orgIds);
                    BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                    if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                        List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                        allUsers.addAll(users);
                    }
                }
                if (!CollectionUtils.isEmpty(allUsers)) {
                    this.sendPaperMessage((List<Integer>)allUsers, paper);
                }
            }
        }
        paper.setPassLine(paperVo.getPassLine());
        paper.setPaperState(paperVo.getPaperState());
        paper.setTypeId(paperVo.getTypeId());
        if (!org.springframework.util.StringUtils.isEmpty((Object)paperVo.getIsTraining())) {
            paper.setIsTraining(paperVo.getIsTraining());
        }
        paper.setDescription(paperVo.getDescription());
        if (paperVo.getPaperState() == null && paperVo.getStartTime() != null && paperVo.getStartTime().after(now)) {
            paper.setPaperState(Integer.valueOf(1));
        } else if (paperVo.getPaperState() == null) {
            paper.setPaperState(Integer.valueOf(2));
        }
        if (ObjectUtils.isEmpty((Object)paperVo.getStartTime()) && paper.getPaperState() != null && paper.getPaperState() > 0 && paper.getIsTraining() != null && paper.getIsTraining() != 1 && paperVo.getExamId() != null) {
            paper.setStartTime(now);
        }
        if (!ObjectUtils.isEmpty((Object)paperVo.getStartTime())) {
            paper.setStartTime(paperVo.getStartTime());
        }
        if (paperVo.getEndTime() != null) {
            paper.setEndTime(paperVo.getEndTime());
        } else {
            paper.setEndTime(null);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)paperVo.getPicUrl())) {
            paper.setPicUrl(paperVo.getPicUrl());
        }
        if (paperVo.getTrainingNavId() != null) {
            paper.setTrainingNavId(paperVo.getTrainingNavId());
        }
        if (paperVo.getEnterpriseId() != null) {
            paper.setEnterpriseId(paperVo.getEnterpriseId());
        }
        if (paperVo.getPaperTime() != null) {
            paper.setPaperTime(paperVo.getPaperTime());
        }
        if (paperVo.getShowOptions() != null) {
            paper.setShowOptions(paperVo.getShowOptions());
        }
        paper.setIsScreen(paperVo.getIsScreen());
        paper.setScreenNum(paperVo.getScreenNum());
        paper.setPaperType(paperVo.getPaperType());
        paper.setQuestionClass(paperVo.getQuestionClass());
        paper.setLookLevel(paperVo.getLookLevel());
        paper.setIsCommitShow(paperVo.getIsCommitShow());
        paper.setIsEndShow(paperVo.getIsEndShow());
        paper.setIsRankShow(paperVo.getIsRankShow());
        paper.setIsQuestion(paperVo.getIsQuestion());
        paper.setIsOption(paperVo.getIsOption());
        paper.setReviewerType(paperVo.getReviewerType());
        paper.setIsMustLink(paperVo.getIsMustLink());
        paper.setIsVisitorShare(paperVo.getIsVisitorShare());
        this.paperMapper.updateById(paper);
        this.trainingPaperRandomMapper.deleteByPaperId(paper.getId());
        if (!CollectionUtils.isEmpty((Collection)paperVo.getPaperRandoms())) {
            for (TrainingPaperRandom trainingPaperRandom : paperVo.getPaperRandoms()) {
                trainingPaperRandom.setPaperId(paper.getId());
                this.trainingPaperRandomMapper.insert(trainingPaperRandom);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionClass)) {
                this.saveQuestionClass(paper.getId(), questionClass);
            }
        }
        if (isChange) {
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId())).eq(TrainingUserPaper::getEnterpriseId, (Object)paper.getEnterpriseId())).isNotNull(TrainingUserPaper::getUserId)).orderByAsc(TrainingUserPaper::getId);
                        List userPaperList = TrainingPaperRemoteServiceImpl.this.userPaperMapper.selectList((Wrapper)wrapper1);
                        if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                            Map<Integer, List> userPaperListMap = userPaperList.stream().collect(Collectors.toMap(TrainingUserPaper::getUserId, e -> new ArrayList<TrainingUserPaper>(Arrays.asList(e)), (oldList, newList) -> {
                                oldList.addAll(newList);
                                return oldList;
                            }));
                            List userList = userPaperList.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
                            int repetitionNum = org.springframework.util.StringUtils.isEmpty((Object)paperVo.getRepetitionNum()) ? 999 : paperVo.getRepetitionNum();
                            for (Integer usersId : userList) {
                                List userPaperIdList = userPaperListMap.get(usersId);
                                for (int i = 0; i < userPaperIdList.size(); ++i) {
                                    TrainingUserPaper userPaper = (TrainingUserPaper)userPaperIdList.get(i);
                                    if (org.springframework.util.StringUtils.isEmpty((Object)userPaper.getSubmitTime())) {
                                        userPaper.setPaperCount(Integer.valueOf(repetitionNum));
                                    } else {
                                        int counts = repetitionNum - 1 - i;
                                        userPaper.setPaperCount(Integer.valueOf(Math.max(counts, 0)));
                                    }
                                    TrainingPaperRemoteServiceImpl.this.userPaperMapper.updateByPrimaryKeySelective(userPaper);
                                }
                            }
                            TrainingUserPaper userPaperWrapper = new TrainingUserPaper();
                            userPaperWrapper.setPaperCount(Integer.valueOf(repetitionNum - 1));
                            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper2.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId())).eq(TrainingUserPaper::getEnterpriseId, (Object)paper.getEnterpriseId())).isNull(TrainingUserPaper::getUserId);
                            TrainingPaperRemoteServiceImpl.this.userPaperMapper.update(userPaperWrapper, (Wrapper)wrapper2);
                        }
                    }
                    catch (Exception e2) {
                        log.error("\u65b0\u589e\u903b\u8f91\uff0c\u4fee\u6539\u8003\u6b21\u9700\u8981\u540c\u6b65\u4fee\u6539\u7528\u6237\u8003\u8bd5\u8bb0\u5f55\u91cc\u7684\u8003\u6b21", (Throwable)e2);
                    }
                }
            });
        }
        try {
            if (paper != null) {
                this.updateKaFKaWorkCircleArticleMo("TEXT_PAPER", KaFKaWorkCircleArticleAddMo.circle_training, paper.getEnterpriseId(), paper.getId(), "1".equals(paper.getLookLevel() == null ? "0" : paper.getLookLevel().toString()) ? 0 : 1, StringsUtils.StringToList(userIds, ","));
            }
        }
        catch (Exception e) {
            log.error("saveTrainingPaper================updateAddKaFKaWorkCircleArticleAddMo", (Throwable)e);
        }
        return paper.getId();
    }

    public void sendPaperMessage(final List<Integer> allUsers, final TrainingPaper paper) {
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                StringBuffer s = new StringBuffer("\u8003\u8bd5\u65f6\u95f4\uff1a");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                if (Objects.nonNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
                    s.append(df.format(paper.getStartTime()));
                    s.append("\u81f3");
                    s.append(df.format(paper.getEndTime()));
                } else if (Objects.nonNull(paper.getStartTime()) && Objects.isNull(paper.getEndTime())) {
                    s.append(df.format(paper.getStartTime()));
                    s.append("\u5f00\u8003");
                } else if (Objects.isNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
                    s.append(df.format(paper.getEndTime()));
                    s.append("\u622a\u6b62");
                } else {
                    s.append("\u4e0d\u9650");
                }
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                body.setTaskJson(JSONObject.toJSONString((Object)paper));
                for (Integer id : allUsers) {
                    try {
                        TrainingPaperRemoteServiceImpl.this.jPushService.sendWebSocket(paper.getTitle(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u8003\u8bd5\u3010" + paper.getTitle() + "\u3011\uff0c\u70b9\u51fb\u67e5\u770b~", id, paper.getEnterpriseId(), paper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paper), paper.getEndTime(), 1, 1, "training.paper.new.push", paper.getTitle());
                        if (!Objects.nonNull(paper.getIsSendMessage()) || paper.getIsSendMessage() != 1) continue;
                        TrainingPaperRemoteServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", id, paper.getTitle(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u8003\u8bd5\uff0c\u70b9\u51fb\u67e5\u770b~\n" + s, body);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        });
    }

    private void saveQuestionClass(Integer paperId, String questionClass) {
        List<Integer> classIds = StringsUtils.StringToList(questionClass, ",");
        TrainingPaperRandomType trainingPaperRandomType = new TrainingPaperRandomType();
        for (Integer id : classIds) {
            trainingPaperRandomType.setPaperId(paperId);
            trainingPaperRandomType.setTypeId(id);
            this.trainingPaperRandomTypeMapper.insert(trainingPaperRandomType);
        }
    }

    private void sendAddKaFKaWorkCircleArticleAddMo(String title, String childModuleName, Integer circleId, Integer createBy, Integer groupId, Integer publicFlag, Integer sourceId, List<Integer> canSeeUserList) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleAddMo addMo = new KaFKaWorkCircleArticleAddMo();
        addMo.setTitle(title);
        addMo.setChildModuleName(childModuleName);
        addMo.setCircleId(circleId);
        addMo.setCreateAt(DateUtils.format(new Date(), DateUtils.FORMAT_LONG));
        addMo.setCreateBy(createBy);
        addMo.setGroupId(groupId);
        addMo.setPublicFlag(publicFlag);
        addMo.setSourceId(sourceId);
        addMo.setCanSeeUserList(canSeeUserList);
        kaFKaWorkCircleArticleMo.setAddMo(addMo);
        kaFKaWorkCircleArticleMo.setType("ADD");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingPaperRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    private void delKaFKaWorkCircleArticleMo(String childModuleName, Integer circleId, Integer groupId, Integer sourceId) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleDelMo delMo = new KaFKaWorkCircleArticleDelMo();
        delMo.setChildModuleName(childModuleName);
        delMo.setCircleId(circleId);
        delMo.setGroupId(groupId);
        delMo.setSourceId(sourceId);
        kaFKaWorkCircleArticleMo.setDelMo(delMo);
        kaFKaWorkCircleArticleMo.setType("DEL");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingPaperRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    private void updateKaFKaWorkCircleArticleMo(String childModuleName, Integer circleId, Integer groupId, Integer sourceId, Integer publicFlag, List<Integer> canSeeUserList) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleUpdSeeUsersMo updMo = new KaFKaWorkCircleArticleUpdSeeUsersMo();
        updMo.setChildModuleName(childModuleName);
        updMo.setCircleId(circleId);
        updMo.setGroupId(groupId);
        updMo.setSourceId(sourceId);
        updMo.setPublicFlag(publicFlag);
        updMo.setCanSeeUserList(canSeeUserList);
        kaFKaWorkCircleArticleMo.setUpdSeeUsersMo(updMo);
        kaFKaWorkCircleArticleMo.setType("UPD_SEE_USERS");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingPaperRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    @Override
    public Page<TrainingPaperVo> getPaperDetailByPage(Page<TrainingPaperVo> page, Integer userId, Integer enterpriseId, String paperName, Integer navId, Integer isTraining, Integer isExam) {
        List<Object> navList = new ArrayList();
        if (navId == null) {
            navList = this.trainingService.getTrainingNavByGroupId(userId, enterpriseId);
        } else {
            TrainingNav nav = new TrainingNav();
            nav.setId(navId);
            navList.add(nav);
        }
        List<TrainingPaperVo> paperVoList = this.paperMapper.selectVoByNavIdsByPage(page, navList, paperName, userId, enterpriseId, null, 1, isTraining, isExam);
        if (!CollectionUtils.isEmpty(paperVoList)) {
            List paperIdList = paperVoList.stream().map(TrainingPaperVo::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getPaperId, paperIdList)).isNotNull(TrainingChapterAttach::getChapterId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
            List attachList = this.chapterAttachMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> attachMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)attachList)) {
                attachMap = attachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getPaperId));
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingPaperUser::getPaperId, paperIdList);
            List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> paperUserMap = new HashMap();
            Map<Object, Object> userMap = new HashMap();
            Map<Object, Object> userOrganizeMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
                paperUserMap = paperUserList.stream().collect(Collectors.groupingBy(TrainingPaperUser::getPaperId));
                List<Integer> userIdList = paperUserList.stream().map(TrainingPaperUser::getUserId).distinct().collect(Collectors.toList());
                userMap = this.userUtilService.selectUserMap(userIdList);
                userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, enterpriseId);
            }
            String enterpriseName = ((EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(enterpriseId).getData()).getName();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(TrainingExaminer::getTrainingPaperId, paperIdList);
            List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)queryWrapper);
            Map<Object, Object> trainingExaminerMap = new HashMap();
            Map<Object, Object> userMap1 = new HashMap();
            Map<Object, Object> userOrganizeMap1 = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                trainingExaminerMap = trainingExaminerList.stream().collect(Collectors.groupingBy(TrainingExaminer::getTrainingPaperId));
                List<Integer> userIdList = trainingExaminerList.stream().map(TrainingExaminer::getUserId).distinct().collect(Collectors.toList());
                userMap1 = this.userUtilService.selectUserMap(userIdList);
                userOrganizeMap1 = this.userUtilService.selectOrganizeMap(userIdList, enterpriseId);
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            wrapper3.in(TrainingPaperRandom::getPaperId, paperIdList);
            List trainingPaperRandomList = this.trainingPaperRandomMapper.selectList((Wrapper)wrapper3);
            Map<Object, Object> trainingPaperRandomMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)trainingPaperRandomList)) {
                trainingPaperRandomMap = trainingPaperRandomList.stream().collect(Collectors.groupingBy(TrainingPaperRandom::getPaperId));
            }
            for (TrainingPaperVo paperVo : paperVoList) {
                List whoCanSeeList = (List)paperUserMap.get(paperVo.getId());
                if (!CollectionUtils.isEmpty((Collection)whoCanSeeList)) {
                    List userIdList = whoCanSeeList.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
                    ArrayList<UserBo> list = new ArrayList<UserBo>();
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        for (Integer id : userIdList) {
                            List organizeStr;
                            UserBo userBo = new UserBo();
                            UsersPojo usersPojo = (UsersPojo)userMap.get(id);
                            userBo.setId(id);
                            if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                                userBo.setUserName(usersPojo.getUserName());
                                userBo.setShowName(usersPojo.getShowName());
                            }
                            userBo.setOrganizes(CollectionUtils.isEmpty((Collection)(organizeStr = (List)userOrganizeMap.get(id))) ? "" : (String)organizeStr.get(0));
                            list.add(userBo);
                        }
                    }
                    paperVo.setWhoCanSeeList(list);
                }
                paperVo.setEnterpriseName(enterpriseName);
                ArrayList<UserBo> userList = new ArrayList<UserBo>();
                List examinerList = (List)trainingExaminerMap.get(paperVo.getId());
                if (!CollectionUtils.isEmpty((Collection)examinerList)) {
                    List userIdList = examinerList.stream().map(TrainingExaminer::getUserId).collect(Collectors.toList());
                    Iterator iterator = userIdList.iterator();
                    while (iterator.hasNext()) {
                        List organizeStr;
                        int id = (Integer)iterator.next();
                        UserBo userBo = new UserBo();
                        UsersPojo usersPojo = (UsersPojo)userMap1.get(id);
                        userBo.setId(Integer.valueOf(id));
                        if (!ObjectUtils.isEmpty((Object)usersPojo)) {
                            userBo.setShowName(usersPojo.getShowName());
                            userBo.setUserName(usersPojo.getUserName());
                        }
                        userBo.setOrganizes(CollectionUtils.isEmpty((Collection)(organizeStr = (List)userOrganizeMap1.get(id))) ? "" : (String)organizeStr.get(0));
                        userList.add(userBo);
                    }
                    paperVo.setUserList(userList);
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)attachMap.get(paperVo.getId())))) {
                    paperVo.setIsTrainId("1");
                }
                List trainingPaperRandoms = (List)trainingPaperRandomMap.get(paperVo.getId());
                paperVo.setPaperRandoms(trainingPaperRandoms);
            }
        }
        page.setContent(paperVoList);
        return page;
    }

    @Override
    public void deleteTrainingPaper(Integer paperId) {
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
        TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andPaperIdEqualTo(paperId);
        this.paperQuestionMapper.deleteByExample(example);
        this.paperMapper.deleteById(paperId);
        TrainingUserPaperExample trainingUserPaperExample = new TrainingUserPaperExample();
        TrainingUserPaperExample.Criteria createCriteria = trainingUserPaperExample.createCriteria();
        createCriteria.andTrainingPaperIdEqualTo(paperId);
        this.userPaperMapper.deleteByExample(trainingUserPaperExample);
        try {
            this.delKaFKaWorkCircleArticleMo("TEXT_PAPER", KaFKaWorkCircleArticleAddMo.circle_training, trainingPaper.getEnterpriseId(), paperId);
        }
        catch (Exception e) {
            log.info("deleteTrainingPaper", (Throwable)e);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)paperId)) {
            try {
                this.jPushService.deleteMessages(paperId, "TYPE_PAPER_SYSTEM", null, null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteTrainingQuestion(String questionIds, Integer paperId) {
        for (String questionId : questionIds.split(",")) {
            TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
            TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
            criteria.andQuestionIdEqualTo(Integer.valueOf(Integer.parseInt(questionId)));
            criteria.andPaperIdEqualTo(paperId);
            this.paperQuestionMapper.deleteByExample(example);
        }
        this.updatePaperScore(paperId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Page<TrainingPaperVo> getPaperByPage(Page<TrainingPaperVo> page, Integer userId, Integer userEnterpriseId, Integer enterpriseId, Integer navId, Integer status, Integer showOptions) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingPaperUser::getUserId, (Object)userId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper1);
        Page newPage = new Page();
        newPage.setPageNumber(1);
        newPage.setPageSize(1000);
        List<Object> navList = new ArrayList();
        if (navId == null) {
            navList = this.trainingService.getTrainingNavByGroupId(userId, enterpriseId);
        } else {
            TrainingNav nav = new TrainingNav();
            nav.setId(navId);
            navList.add(nav);
        }
        if (CollectionUtils.isEmpty(navList)) {
            enterpriseId = null;
            userEnterpriseId = null;
        }
        if (showOptions == null) {
            showOptions = 1;
        }
        List<Object> paperVoList = new ArrayList();
        if (this.commonRemoteService.isRoot(userId).booleanValue()) {
            if (status == null) {
                paperVoList = this.paperMapper.selectAllByPage((Page<TrainingPaperVo>)newPage, navList, userId, enterpriseId, new Date(), showOptions);
            } else if (status == 1) {
                paperVoList = this.userPaperMapper.selectUnPassByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, enterpriseId, null, showOptions);
            } else if (status == 2) {
                paperVoList = this.userPaperMapper.selectPassByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, enterpriseId, null, showOptions);
            } else if (status == 3) {
                paperVoList = this.userPaperMapper.selectUnTakeTestByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, enterpriseId, null, new Date(), showOptions);
            } else if (status == 4) {
                paperVoList = this.userPaperMapper.selectByStatusByPage((Page<TrainingPaperVo>)newPage, navList, userId, enterpriseId, 2, showOptions);
            } else if (status == 5) {
                paperVoList = this.userPaperMapper.selectByStatusByPage((Page<TrainingPaperVo>)newPage, navList, userId, enterpriseId, 1, showOptions);
            } else if (status == 7) {
                paperVoList = this.userPaperMapper.selectByPaperOverDueByPage((Page<TrainingPaperVo>)newPage, null, enterpriseId, new Date(), userId);
            }
        } else if (status == null) {
            paperVoList = this.paperMapper.selectAllByPage((Page<TrainingPaperVo>)newPage, navList, userId, userEnterpriseId, new Date(), showOptions);
        } else if (status == 1) {
            paperVoList = this.userPaperMapper.selectUnPassByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, userEnterpriseId, paperUserList, showOptions);
        } else if (status == 2) {
            paperVoList = this.userPaperMapper.selectPassByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, userEnterpriseId, paperUserList, showOptions);
        } else if (status == 3) {
            paperVoList = this.userPaperMapper.selectUnTakeTestByPage((Page<TrainingPaperVo>)newPage, navList, null, userId, userEnterpriseId, null, new Date(), showOptions);
        } else if (status == 4) {
            paperVoList = this.userPaperMapper.selectByEndStatusByPage((Page<TrainingPaperVo>)newPage, navList, userId, userEnterpriseId, 2, showOptions);
        } else if (status == 5) {
            paperVoList = this.userPaperMapper.selectByStatusByPage((Page<TrainingPaperVo>)newPage, navList, userId, userEnterpriseId, 1, showOptions);
        } else if (status == 7) {
            paperVoList = this.userPaperMapper.selectByPaperOverDueByPage((Page<TrainingPaperVo>)newPage, null, enterpriseId, new Date(), userId);
        }
        if (!CollectionUtils.isEmpty(paperVoList)) {
            List<Integer> userPaperIds = paperVoList.stream().map(TrainingPaperVo::getUserPaperId).collect(Collectors.toList());
            List paperIds = paperVoList.stream().map(TrainingPaperVo::getId).collect(Collectors.toList());
            HashMap hashMap = new HashMap();
            if (!CollectionUtils.isEmpty(userPaperIds)) {
                List<TrainingUserPaper> userPaperList = this.userPaperMapper.selectByUserPaperIds(userPaperIds);
                Map<Integer, List> map = userPaperList.stream().collect(Collectors.toMap(TrainingUserPaper::getId, e -> new ArrayList<TrainingUserPaper>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            Map<Object, Object> paperMap = new HashMap();
            Map<Object, Object> paperListMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)paperIds)) {
                List<TrainingPaperQuestion> userPaperList = this.paperQuestionMapper.selectByPaperIds(paperIds);
                paperMap = userPaperList.stream().collect(Collectors.toMap(TrainingPaperQuestion::getPaperId, e -> new ArrayList<TrainingPaperQuestion>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(TrainingPaper::getId, (Collection)paperIds);
                List trainingPaperList = this.paperMapper.selectList((Wrapper)lambdaQueryWrapper);
                paperListMap = trainingPaperList.stream().collect(Collectors.toMap(TrainingPaper::getId, e -> new ArrayList<TrainingPaper>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            for (TrainingPaperVo trainingPaperVo : paperVoList) {
                trainingPaperVo.setEnterpriseName(((EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(trainingPaperVo.getEnterpriseId()).getData()).getName());
                if (trainingPaperVo.getUserPaperId() != null) {
                    void var15_17;
                    TrainingUserPaper userPaper = null;
                    List userPaperList = (List)var15_17.get(trainingPaperVo.getUserPaperId());
                    if (userPaperList != null && userPaperList.size() > 0) {
                        userPaper = (TrainingUserPaper)userPaperList.get(0);
                    }
                    if (userPaper == null) continue;
                    trainingPaperVo.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
                    if (0 == userPaper.getPaperStatus()) {
                        if (trainingPaperVo.getEndTime() != null && trainingPaperVo.getEndTime().getTime() < new Date().getTime()) {
                            trainingPaperVo.setUserStatus(Integer.valueOf(7));
                            continue;
                        }
                        trainingPaperVo.setUserStatus(Integer.valueOf(3));
                        continue;
                    }
                    if (userPaper.getScore() != null && userPaper.getScore().intValue() >= 60 && userPaper.getScore().intValue() != 100 && 1 != userPaper.getPaperStatus()) {
                        trainingPaperVo.setUserStatus(Integer.valueOf(2));
                        continue;
                    }
                    if (userPaper.getScore() != null && userPaper.getScore().intValue() == 100 && 1 != userPaper.getPaperStatus()) {
                        trainingPaperVo.setUserStatus(Integer.valueOf(6));
                        continue;
                    }
                    if (userPaper.getScore() != null && userPaper.getScore().intValue() < 60 && 1 != userPaper.getPaperStatus()) {
                        trainingPaperVo.setUserStatus(Integer.valueOf(1));
                        continue;
                    }
                    if (1 != userPaper.getPaperStatus()) continue;
                    trainingPaperVo.setUserStatus(Integer.valueOf(5));
                    continue;
                }
                if (trainingPaperVo.getEndTime() != null && trainingPaperVo.getEndTime().getTime() < new Date().getTime()) {
                    trainingPaperVo.setUserStatus(Integer.valueOf(7));
                } else {
                    trainingPaperVo.setUserStatus(Integer.valueOf(3));
                }
                List list = (List)paperMap.get(trainingPaperVo.getId());
                List lists = (List)paperListMap.get(trainingPaperVo.getId());
                if (!CollectionUtils.isEmpty((Collection)lists) || !CollectionUtils.isEmpty((Collection)list)) continue;
                trainingPaperVo.setHasQuestion(Integer.valueOf(0));
            }
        }
        ArrayList<TrainingPaperVo> newPaperVoList = new ArrayList<TrainingPaperVo>();
        if (!CollectionUtils.isEmpty(paperVoList)) {
            for (TrainingPaperVo trainingPaperVo : paperVoList) {
                if (trainingPaperVo.getEndTime() != null && trainingPaperVo.getUserStatus() == 3) {
                    newPaperVoList.add(trainingPaperVo);
                }
                if (trainingPaperVo.getEndTime() == null && trainingPaperVo.getUserStatus() == 3) {
                    newPaperVoList.add(trainingPaperVo);
                }
                if (trainingPaperVo.getUserStatus() == 2 || trainingPaperVo.getUserStatus() == 6 || trainingPaperVo.getUserStatus() == 1 || trainingPaperVo.getUserStatus() == 5) {
                    newPaperVoList.add(trainingPaperVo);
                }
                if (trainingPaperVo.getUserStatus() == 7) {
                    newPaperVoList.add(trainingPaperVo);
                }
                if (trainingPaperVo.getUserStatus() != null) continue;
                newPaperVoList.add(trainingPaperVo);
            }
        }
        List newPaperVos = new ArrayList();
        if (!CollectionUtils.isEmpty(newPaperVoList)) {
            if (newPaperVoList.size() >= page.getPageNumber() * page.getPageSize()) {
                newPaperVos = newPaperVoList.subList((page.getPageNumber() - 1) * page.getPageSize(), page.getPageNumber() * page.getPageSize());
            } else if ((page.getPageNumber() - 1) * page.getPageSize() < newPaperVoList.size()) {
                newPaperVos = newPaperVoList.subList((page.getPageNumber() - 1) * page.getPageSize(), newPaperVoList.size());
            }
        }
        page.setContent(newPaperVos);
        page.setTotalCount(newPage.getTotalCount());
        return page;
    }

    @Override
    public TrainingPaperVo getQuestionListByPaperId(Integer paperId) {
        List<TrainingQuestionVo> questionVoList;
        TrainingPaperVo result = new TrainingPaperVo();
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        result.setPaperName(paper.getTitle());
        if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPicUrl())) {
            result.setPicUrl(paper.getPicUrl());
        }
        if (!CollectionUtils.isEmpty(questionVoList = this.questionMapper.selectVoByPaperId(paperId, 1))) {
            for (TrainingQuestionVo questionVo : questionVoList) {
                List<TrainingOptionsVo> optionsVoList = this.optionsMapper.selectVoByQuestionId(questionVo.getId());
                if (CollectionUtils.isEmpty(optionsVoList)) continue;
                questionVo.setOptionsList(optionsVoList);
            }
        }
        result.setQuestionList(questionVoList);
        return result;
    }

    @Override
    public List<TrainingPaperVo> getQuestionListByPaperIdByType(Integer paperId) {
        List<TrainingQuestionVo> questionVoList;
        TrainingPaperVo result = new TrainingPaperVo();
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        result.setPaperName(paper.getTitle());
        if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPicUrl())) {
            result.setPicUrl(paper.getPicUrl());
        }
        if (!CollectionUtils.isEmpty(questionVoList = this.questionMapper.selectVoByPaperId(paperId, 1))) {
            for (TrainingQuestionVo questionVo : questionVoList) {
                List<TrainingOptionsVo> optionsVoList = this.optionsMapper.selectVoByQuestionId(questionVo.getId());
                if (CollectionUtils.isEmpty(optionsVoList)) continue;
                questionVo.setOptionsList(optionsVoList);
            }
        }
        return this.getTrainingPaperVoListByType(questionVoList);
    }

    private List<TrainingPaperVo> getTrainingPaperVoListByType(List<TrainingQuestionVo> questionVoList) {
        ArrayList<TrainingPaperVo> resultList = new ArrayList<TrainingPaperVo>();
        ArrayList<TrainingQuestionVo> SINGLE_CHOICE = new ArrayList<TrainingQuestionVo>();
        for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
            if (0 != trainingQuestionVo.getQuestionType()) continue;
            SINGLE_CHOICE.add(trainingQuestionVo);
        }
        if (SINGLE_CHOICE.size() > 0) {
            TrainingPaperVo paperVo = new TrainingPaperVo();
            paperVo.setQuestionList(SINGLE_CHOICE);
            paperVo.setQuestionType(Integer.valueOf(0));
            resultList.add(paperVo);
        }
        ArrayList<TrainingQuestionVo> ESSAY_QUESTION = new ArrayList<TrainingQuestionVo>();
        for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
            if (1 != trainingQuestionVo.getQuestionType()) continue;
            ESSAY_QUESTION.add(trainingQuestionVo);
        }
        if (ESSAY_QUESTION.size() > 0) {
            TrainingPaperVo trainingPaperVo = new TrainingPaperVo();
            trainingPaperVo.setQuestionList(ESSAY_QUESTION);
            trainingPaperVo.setQuestionType(Integer.valueOf(1));
            resultList.add(trainingPaperVo);
        }
        ArrayList<TrainingQuestionVo> arrayList = new ArrayList<TrainingQuestionVo>();
        for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
            if (2 != trainingQuestionVo.getQuestionType()) continue;
            arrayList.add(trainingQuestionVo);
        }
        if (arrayList.size() > 0) {
            TrainingPaperVo trainingPaperVo = new TrainingPaperVo();
            trainingPaperVo.setQuestionList(arrayList);
            trainingPaperVo.setQuestionType(Integer.valueOf(2));
            resultList.add(trainingPaperVo);
        }
        ArrayList<TrainingQuestionVo> arrayList2 = new ArrayList<TrainingQuestionVo>();
        for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
            if (3 != trainingQuestionVo.getQuestionType()) continue;
            arrayList2.add(trainingQuestionVo);
        }
        if (arrayList2.size() > 0) {
            TrainingPaperVo trainingPaperVo = new TrainingPaperVo();
            trainingPaperVo.setQuestionList(arrayList2);
            trainingPaperVo.setQuestionType(Integer.valueOf(3));
            resultList.add(trainingPaperVo);
        }
        ArrayList<TrainingQuestionVo> arrayList3 = new ArrayList<TrainingQuestionVo>();
        for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
            if (4 != trainingQuestionVo.getQuestionType()) continue;
            arrayList3.add(trainingQuestionVo);
        }
        if (arrayList3.size() > 0) {
            TrainingPaperVo trainingPaperVo = new TrainingPaperVo();
            trainingPaperVo.setQuestionList(arrayList3);
            trainingPaperVo.setQuestionType(Integer.valueOf(4));
            resultList.add(trainingPaperVo);
        }
        return resultList;
    }

    @Override
    public TheirPapersVo theirEssayQuestion(TrainingPaperVo paper, Integer userId) {
        TheirPapersVo result = new TheirPapersVo();
        List questionList = paper.getQuestionList();
        double essayQuestionScore = 0.0;
        if (!CollectionUtils.isEmpty((Collection)questionList)) {
            for (TrainingQuestionVo questionVo : questionList) {
                TrainingUserQuestion userQuestion = (TrainingUserQuestion)this.userQuestionMapper.selectById(questionVo.getId());
                if (userQuestion.getOriginScore().doubleValue() == questionVo.getScore().doubleValue()) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getComment())) {
                    userQuestion.setComment(questionVo.getComment());
                }
                userQuestion.setScore(new BigDecimal(questionVo.getScore()));
                this.userQuestionMapper.updateById(userQuestion);
                if (!CollectionUtils.isEmpty((Collection)questionVo.getAttaList())) {
                    for (TrainingUserQuestionAtta attaVo : questionVo.getAttaList()) {
                        attaVo.setCreateTime(new Date());
                        attaVo.setUserQuestionId(userQuestion.getId());
                        this.trainingUserQuestionAttaMapper.insert(attaVo);
                    }
                }
                essayQuestionScore += questionVo.getScore().doubleValue();
            }
        }
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(paper.getId());
        userPaper.setMarkingUserId(userId);
        userPaper.setScore(userPaper.getScore().add(new BigDecimal(essayQuestionScore)));
        userPaper.setPaperStatus(Integer.valueOf(2));
        userPaper.setIsReview(Integer.valueOf(1));
        this.userPaperMapper.updateById(userPaper);
        result.setSourceType(userPaper.getSourceType());
        try {
            List<TrainingChapterUnlock> trainingChapterUnlocks = this.trainingChapterUnlockMapper.selectByPaperIdUnlock(userPaper.getTrainingPaperId(), userPaper.getUserId());
            if (!CollectionUtils.isEmpty(trainingChapterUnlocks)) {
                for (TrainingChapterUnlock trainingChapterUnlock : trainingChapterUnlocks) {
                    this.updateUserChapterPaper(userPaper.getUserId(), trainingChapterUnlock.getTrainingId(), userPaper.getTrainingPaperId(), userPaper.getScore());
                }
            }
        }
        catch (Exception e) {
            log.info("updateUserChapterPaper", (Throwable)e);
        }
        result.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
        if (userPaper.getUserId() != null) {
            UsersPojo usersPojo = this.userUtilService.selectUser(userPaper.getUserId());
            result.setUserName(Objects.nonNull(usersPojo) ? usersPojo.getShowName() : "");
        } else {
            result.setUserName(userPaper.getLoginShowName());
        }
        TrainingUserPaper nextUserPaper = this.userPaperMapper.selectNextUserPaper(userPaper.getTrainingPaperId());
        if (nextUserPaper != null) {
            result.setUserPapgerId(nextUserPaper.getId());
            result.setNextUserId(nextUserPaper.getUserId());
        }
        result.setPaperId(userPaper.getTrainingPaperId());
        return result;
    }

    private void updateUserChapterPaper(Integer userId, Integer trainingId, Integer paperId, BigDecimal bigDecimal) {
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        if (!CollectionUtils.isEmpty(trainingChapters)) {
            block0: for (int i = 0; i < trainingChapters.size(); ++i) {
                if (trainingChapters.get(i).getPaperId() == null || paperId.intValue() != trainingChapters.get(i).getPaperId().intValue() || trainingChapters.get(i).getScore().compareTo(bigDecimal) > 0) continue;
                if (i != trainingChapters.size() - 1) {
                    for (int j = i + 1; j < trainingChapters.size(); ++j) {
                        TrainingChapterUnlock trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(j).getId());
                        if (trainingChapterUnlock != null) continue;
                        trainingChapterUnlock = new TrainingChapterUnlock();
                        trainingChapterUnlock.setUserId(userId);
                        trainingChapterUnlock.setChapterId(trainingChapters.get(j).getId());
                        trainingChapterUnlock.setCreateTime(new Date());
                        if (trainingChapters.get(j).getIsLock() != null && trainingChapters.get(j).getIsLock() == 0) {
                            trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
                        } else {
                            trainingChapterUnlock.setIsUnlock(Integer.valueOf(1));
                        }
                        trainingChapterUnlock.setTrainingId(trainingId);
                        this.trainingChapterUnlockMapper.insert(trainingChapterUnlock);
                        if (trainingChapterUnlock.getIsUnlock() == 1) continue block0;
                    }
                    continue;
                }
                TrainingChapterUnlock trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(i).getId());
                if (trainingChapterUnlock != null) continue;
                trainingChapterUnlock = new TrainingChapterUnlock();
                trainingChapterUnlock.setUserId(userId);
                trainingChapterUnlock.setChapterId(trainingChapters.get(i).getId());
                trainingChapterUnlock.setCreateTime(new Date());
                if (trainingChapters.get(i).getIsLock() != null && trainingChapters.get(i).getIsLock() == 0) {
                    trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
                } else {
                    trainingChapterUnlock.setIsUnlock(Integer.valueOf(1));
                }
                trainingChapterUnlock.setTrainingId(trainingId);
                this.trainingChapterUnlockMapper.insert(trainingChapterUnlock);
            }
        }
    }

    @Override
    public void theirQuestion(TrainingPaperVo paper, Integer userId) {
        TrainingQuestionVo questionVo = (TrainingQuestionVo)paper.getQuestionList().get(0);
        List<TrainingUserQuestion> userQuestions = null;
        userQuestions = userId != null ? this.userQuestionMapper.selectByPaperIdAndQuestionId(userId, paper.getId(), questionVo.getId()) : this.userQuestionMapper.selectByUserPaperIdAndQuestionId(paper.getUserPaperId(), questionVo.getId());
        TrainingUserQuestion userQuestion = new TrainingUserQuestion();
        if (!CollectionUtils.isEmpty(userQuestions)) {
            userQuestion = userQuestions.get(0);
        }
        TrainingUserPaper userPaper = this.userPaperMapper.selectByPrimaryKey(userQuestion.getUserPaperId());
        List<TrainingOptionsVo> optionsList = this.optionsMapper.selectVoByQuestionId(questionVo.getId());
        if (userQuestion.getQuestionType() == 0) {
            List<TrainingOptions> trueOption = this.optionsMapper.selectByQuestionId(questionVo.getId(), 1);
            if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == trueOption.get(0).getId().intValue()) {
                userQuestion.setIsCorrect(Integer.valueOf(1));
                if (userQuestion.getOriginScore() != null) {
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            } else {
                userQuestion.setIsCorrect(Integer.valueOf(0));
            }
            for (TrainingOptionsVo optionVo : optionsList) {
                if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == optionVo.getId().intValue()) {
                    optionVo.setIsSelect(Integer.valueOf(1));
                    continue;
                }
                optionVo.setIsSelect(Integer.valueOf(0));
            }
        } else if (userQuestion.getQuestionType() == 1) {
            for (TrainingOptionsVo optionVo : optionsList) {
                if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) {
                    optionVo.setAnswer(((String)questionVo.getAnswerList().get(0)).trim());
                    userPaper.setPaperStatus(Integer.valueOf(1));
                    userPaper.setIsReview(Integer.valueOf(1));
                }
                optionVo.setAnswer((String)questionVo.getAnswerList().get(0));
            }
        } else if (userQuestion.getQuestionType() == 2) {
            if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) {
                userQuestion.setIsCorrect(Integer.valueOf(0));
            } else {
                int isTrue = 1;
                for (int i = 0; i < optionsList.size(); ++i) {
                    if (!questionVo.getAnswerList().contains(optionsList.get(i).getOptionsName())) {
                        isTrue = 0;
                    }
                    if (questionVo.getAnswerList().size() < i) continue;
                    optionsList.get(i).setAnswer((String)questionVo.getAnswerList().get(i));
                }
                userQuestion.setIsCorrect(Integer.valueOf(isTrue));
                if (isTrue == 1 && userQuestion.getOriginScore() != null) {
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            }
        } else if (userQuestion.getQuestionType() == 3) {
            List<TrainingOptions> trueOption = this.optionsMapper.selectByQuestionId(questionVo.getId(), 1);
            Boolean MULTIPLE_CHOICE = true;
            if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds()) && trueOption.size() == questionVo.getAnswerIds().size()) {
                for (TrainingOptions trainingOptions : trueOption) {
                    if (trainingOptions.getIsAnswer() != 1 || questionVo.getAnswerIds().contains(trainingOptions.getId())) continue;
                    MULTIPLE_CHOICE = false;
                    break;
                }
            } else {
                MULTIPLE_CHOICE = false;
            }
            if (MULTIPLE_CHOICE.booleanValue()) {
                userQuestion.setIsCorrect(Integer.valueOf(1));
                if (userQuestion.getOriginScore() != null) {
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            } else {
                userQuestion.setIsCorrect(Integer.valueOf(0));
            }
            for (TrainingOptionsVo optionVo : optionsList) {
                if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds())) continue;
                if (questionVo.getAnswerIds().contains(optionVo.getId())) {
                    optionVo.setIsSelect(Integer.valueOf(1));
                    continue;
                }
                optionVo.setIsSelect(Integer.valueOf(0));
            }
        } else if (userQuestion.getQuestionType() == 4) {
            TrainingOptionsVo trainingOptionsVo = new TrainingOptionsVo();
            if (questionVo.getIsCorrect() == 1) {
                userQuestion.setIsCorrect(Integer.valueOf(1));
                if (userQuestion.getOriginScore() != null) {
                    userQuestion.setScore(userQuestion.getOriginScore());
                }
            } else {
                userQuestion.setIsCorrect(Integer.valueOf(0));
            }
            optionsList = new ArrayList<TrainingOptionsVo>();
            trainingOptionsVo.setIsSelect(Integer.valueOf(1));
            optionsList.add(trainingOptionsVo);
        }
        if (!CollectionUtils.isEmpty(optionsList)) {
            userQuestion.setOptionsData(JSONArray.toJSONString(optionsList));
        }
        this.userQuestionMapper.updateById(userQuestion);
        Double score = this.userQuestionMapper.selectScoreByUserPaperId(userQuestion.getUserPaperId(), 1);
        userPaper.setScore(new BigDecimal(score));
        this.userPaperMapper.updateById(userPaper);
    }

    @Override
    public TrainingUserPaper theirAllQuestion(List<TrainingPaperVo> papers, Integer userId) {
        List<TrainingUserQuestion> userQuestions = null;
        List<TrainingOptionsVo> trainingOptionsVos = null;
        if (userId != null) {
            userQuestions = this.userQuestionMapper.selectQuestionsByPaperId(userId, papers.get(0).getId());
            trainingOptionsVos = this.optionsMapper.selectVoByPaperId(userId, papers.get(0).getId());
        } else {
            userQuestions = this.userQuestionMapper.selectQuestionsByUserPaperId(papers.get(0).getUserPaperId());
            trainingOptionsVos = this.optionsMapper.selectVoByUserPaperId(papers.get(0).getUserPaperId());
        }
        Map<Integer, List> trainingUserQuestionMap = userQuestions.stream().collect(Collectors.toMap(TrainingUserQuestion::getQuestionId, e -> new ArrayList<TrainingUserQuestion>(Arrays.asList(e)), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        Map<Integer, List> trainingOptionsVoMap = trainingOptionsVos.stream().collect(Collectors.toMap(TrainingOptionsVo::getQuestionId, e -> new ArrayList<TrainingOptionsVo>(Arrays.asList(e)), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(papers.get(0).getUserPaperId());
        for (TrainingPaperVo paper : papers) {
            if (paper.getId() == null || CollectionUtils.isEmpty((Collection)paper.getQuestionList())) continue;
            TrainingQuestionVo questionVo = (TrainingQuestionVo)paper.getQuestionList().get(0);
            TrainingUserQuestion userQuestion = new TrainingUserQuestion();
            userQuestion = (TrainingUserQuestion)trainingUserQuestionMap.get(questionVo.getId()).get(trainingUserQuestionMap.get(questionVo.getId()).size() - 1);
            ArrayList<TrainingOptionsVo> optionsList = trainingOptionsVoMap.get(questionVo.getId());
            if (userQuestion.getQuestionType() == 0) {
                int answerId = -1;
                for (TrainingOptionsVo optionVo : optionsList) {
                    if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == optionVo.getId().intValue()) {
                        optionVo.setIsSelect(Integer.valueOf(1));
                    } else {
                        optionVo.setIsSelect(Integer.valueOf(0));
                    }
                    if (1 != optionVo.getIsAnswer()) continue;
                    answerId = optionVo.getId();
                }
                if (questionVo.getAnswerId() != null && questionVo.getAnswerId() == answerId) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    if (userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
            } else if (userQuestion.getQuestionType() == 1 && !CollectionUtils.isEmpty((Collection)optionsList)) {
                for (TrainingOptionsVo optionVo : optionsList) {
                    if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) {
                        optionVo.setAnswer(((String)questionVo.getAnswerList().get(0)).trim());
                        userPaper.setPaperStatus(Integer.valueOf(1));
                        userPaper.setIsReview(Integer.valueOf(1));
                    }
                    optionVo.setAnswer((String)questionVo.getAnswerList().get(0));
                }
            } else if (userQuestion.getQuestionType() == 2 && !CollectionUtils.isEmpty((Collection)optionsList)) {
                if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                } else if (questionVo.getAnswerList().size() != optionsList.size()) {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                    for (int i = 0; i < optionsList.size(); ++i) {
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                } else {
                    int i;
                    int isTrue = 1;
                    for (i = 0; i < optionsList.size(); ++i) {
                        String optionsName = ((TrainingOptionsVo)optionsList.get(i)).getOptionsName();
                        List<String> optionsLists = StringsUtils.String2List(optionsName, "&");
                        if (org.springframework.util.StringUtils.isEmpty(questionVo.getAnswerList().get(i)) || !optionsLists.contains(((String)questionVo.getAnswerList().get(i)).trim())) {
                            isTrue = 0;
                            break;
                        }
                        if (questionVo.getAnswerList().size() < i) continue;
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                    userQuestion.setIsCorrect(Integer.valueOf(isTrue));
                    if (isTrue == 1 && userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                    for (i = 0; i < optionsList.size(); ++i) {
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                }
            } else if (userQuestion.getQuestionType() == 3) {
                List<TrainingOptions> trueOption = this.optionsMapper.selectByQuestionId(questionVo.getId(), 1);
                Boolean MULTIPLE_CHOICE = true;
                if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds()) && trueOption.size() == questionVo.getAnswerIds().size()) {
                    for (TrainingOptions trainingOptions : trueOption) {
                        if (trainingOptions.getIsAnswer() != 1 || questionVo.getAnswerIds().contains(trainingOptions.getId())) continue;
                        MULTIPLE_CHOICE = false;
                        break;
                    }
                } else {
                    MULTIPLE_CHOICE = false;
                }
                if (MULTIPLE_CHOICE.booleanValue()) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    if (userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
                for (TrainingOptionsVo optionVo : optionsList) {
                    if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds())) continue;
                    if (questionVo.getAnswerIds().contains(optionVo.getId())) {
                        optionVo.setIsSelect(Integer.valueOf(1));
                        continue;
                    }
                    optionVo.setIsSelect(Integer.valueOf(0));
                }
            } else if (userQuestion.getQuestionType() == 4) {
                TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(questionVo.getId());
                if (questionVo.getIsCorrect() != null && trainingQuestion.getIsCorrect() != null && (questionVo.getIsCorrect() == 0 || questionVo.getIsCorrect() == 1) && questionVo.getIsCorrect().intValue() == trainingQuestion.getIsCorrect().intValue()) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    if (userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
                optionsList = new ArrayList<TrainingOptionsVo>();
                TrainingOptionsVo trainingOptionsVo = new TrainingOptionsVo();
                trainingOptionsVo.setIsSelect(Integer.valueOf(1));
                optionsList.add(trainingOptionsVo);
            }
            if (!CollectionUtils.isEmpty((Collection)optionsList)) {
                userQuestion.setOptionsData(JSONArray.toJSONString((Object)optionsList));
            }
            userQuestion.setIsEmpty(questionVo.getIsEmpty());
            this.userQuestionMapper.updateById(userQuestion);
        }
        Double score = this.userQuestionMapper.selectScoreByUserPaperId(userPaper.getId(), 1);
        userPaper.setScore(new BigDecimal(score));
        userPaper.setSubmitTime(new Date());
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(papers.get(0).getId());
        Integer repetitionNum = 999;
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getRepetitionNum())) {
                repetitionNum = trainingPaper.getRepetitionNum();
            }
        } else {
            repetitionNum = 0;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)papers.get(0).getId())).gt(TrainingUserPaper::getPaperStatus, (Object)0);
        List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper);
        repetitionNum = !CollectionUtils.isEmpty((Collection)userPaperList) ? Integer.valueOf(repetitionNum > userPaperList.size() ? repetitionNum - userPaperList.size() - 1 : 0) : Integer.valueOf(repetitionNum > 0 ? repetitionNum - 1 : 0);
        userPaper.setPaperCount(repetitionNum);
        this.userPaperMapper.updateById(userPaper);
        return userPaper;
    }

    @Override
    public TrainingUserPaper theirAllQuestionNew(List<TrainingPaperVo> papers, Integer userId) {
        List<TrainingUserQuestion> userQuestions = null;
        userQuestions = userId != null ? this.userQuestionMapper.selectQuestionsByPaperId(userId, papers.get(0).getId()) : this.userQuestionMapper.selectQuestionsByUserPaperId(papers.get(0).getUserPaperId());
        Map<Integer, List> trainingUserQuestionMap = userQuestions.stream().collect(Collectors.toMap(TrainingUserQuestion::getQuestionId, e -> new ArrayList<TrainingUserQuestion>(Arrays.asList(e)), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        Integer examId = papers.get(0).getExamId();
        TrainingExam trainExam = (TrainingExam)this.examMapper.selectById(examId);
        Map<Object, Object> examOptionsVoMap = new HashMap();
        Map<Object, Object> trainingOptionsVoMap = new HashMap();
        if (trainExam.getExamClass() == 1) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(TrainingExamQuestion::getExamId, (Object)examId);
            List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper1);
            List examQuestionIds = examQuestions.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingExamOptions::getExamQuestionId, examQuestionIds);
            List examOptionsVos = this.examOptionsMapper.selectList((Wrapper)wrapper2);
            examOptionsVoMap = examOptionsVos.stream().collect(Collectors.toMap(TrainingExamOptions::getExamQuestionId, e -> new ArrayList<TrainingExamOptions>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        } else {
            List<TrainingOptionsVo> trainingOptionsVos = null;
            trainingOptionsVos = userId != null ? this.optionsMapper.selectVoByPaperId(userId, papers.get(0).getId()) : this.optionsMapper.selectVoByUserPaperId(papers.get(0).getUserPaperId());
            trainingOptionsVoMap = trainingOptionsVos.stream().collect(Collectors.toMap(TrainingOptionsVo::getQuestionId, e -> new ArrayList<TrainingOptionsVo>(Arrays.asList(e)), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(papers.get(0).getUserPaperId());
        for (TrainingPaperVo paper : papers) {
            if (paper.getId() == null || CollectionUtils.isEmpty((Collection)paper.getQuestionList())) continue;
            TrainingQuestionVo questionVo = (TrainingQuestionVo)paper.getQuestionList().get(0);
            TrainingUserQuestion userQuestion = new TrainingUserQuestion();
            userQuestion = (TrainingUserQuestion)trainingUserQuestionMap.get(questionVo.getId()).get(trainingUserQuestionMap.get(questionVo.getId()).size() - 1);
            List<TrainingOptionsVo> optionsList = new ArrayList();
            if (trainExam.getExamClass() == 1) {
                List examOptionsListVo = (List)examOptionsVoMap.get(questionVo.getId());
                if (!CollectionUtils.isEmpty((Collection)examOptionsListVo)) {
                    for (TrainingExamOptions trainingExamOptions : examOptionsListVo) {
                        TrainingOptionsVo trainingOptionsVo = new TrainingOptionsVo();
                        trainingOptionsVo.setId(trainingExamOptions.getId());
                        trainingOptionsVo.setQuestionId(trainingExamOptions.getExamQuestionId());
                        trainingOptionsVo.setOptionsName(trainingExamOptions.getContent());
                        trainingOptionsVo.setIsAnswer(trainingExamOptions.getIsAnswer());
                        trainingOptionsVo.setPicturePath(trainingExamOptions.getPicturePath());
                        optionsList.add(trainingOptionsVo);
                    }
                }
            } else {
                optionsList = (List)trainingOptionsVoMap.get(questionVo.getId());
            }
            if (userQuestion.getQuestionType() == 0) {
                int answerId = -1;
                for (TrainingOptionsVo trainingOptionsVo : optionsList) {
                    if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == trainingOptionsVo.getId().intValue()) {
                        trainingOptionsVo.setIsSelect(Integer.valueOf(1));
                    } else {
                        trainingOptionsVo.setIsSelect(Integer.valueOf(0));
                    }
                    if (1 != trainingOptionsVo.getIsAnswer()) continue;
                    answerId = trainingOptionsVo.getId();
                }
                if (questionVo.getAnswerId() != null && questionVo.getAnswerId() == answerId) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    if (userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
            } else if (userQuestion.getQuestionType() == 1) {
                if (!CollectionUtils.isEmpty(optionsList)) {
                    for (TrainingOptionsVo optionVo : optionsList) {
                        if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) continue;
                        optionVo.setAnswer(((String)questionVo.getAnswerList().get(0)).trim());
                    }
                }
                userPaper.setPaperStatus(Integer.valueOf(1));
                userPaper.setIsReview(Integer.valueOf(1));
            } else if (userQuestion.getQuestionType() == 2 && !CollectionUtils.isEmpty(optionsList)) {
                if (CollectionUtils.isEmpty((Collection)questionVo.getAnswerList())) {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                } else if (questionVo.getAnswerList().size() != optionsList.size()) {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                    for (int i = 0; i < optionsList.size(); ++i) {
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                } else {
                    int i;
                    int isTrue = 1;
                    for (i = 0; i < optionsList.size(); ++i) {
                        String string = ((TrainingOptionsVo)optionsList.get(i)).getOptionsName();
                        List<String> list = StringsUtils.String2List(string, "&");
                        if (org.springframework.util.StringUtils.isEmpty(questionVo.getAnswerList().get(i)) || !list.contains(((String)questionVo.getAnswerList().get(i)).trim())) {
                            isTrue = 0;
                            break;
                        }
                        if (questionVo.getAnswerList().size() < i) continue;
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                    userQuestion.setIsCorrect(Integer.valueOf(isTrue));
                    if (isTrue == 1 && userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                    for (i = 0; i < optionsList.size(); ++i) {
                        ((TrainingOptionsVo)optionsList.get(i)).setAnswer((String)questionVo.getAnswerList().get(i));
                    }
                }
            } else if (userQuestion.getQuestionType() == 3) {
                ArrayList<TrainingOptionsVo> trueOption = new ArrayList<TrainingOptionsVo>();
                for (TrainingOptionsVo trainingOptionsVo : optionsList) {
                    if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds())) {
                        if (questionVo.getAnswerIds().contains(trainingOptionsVo.getId())) {
                            trainingOptionsVo.setIsSelect(Integer.valueOf(1));
                        } else {
                            trainingOptionsVo.setIsSelect(Integer.valueOf(0));
                        }
                    }
                    if (trainingOptionsVo.getIsAnswer() != 1) continue;
                    trueOption.add(trainingOptionsVo);
                }
                Boolean MULTIPLE_CHOICE = true;
                if (!CollectionUtils.isEmpty((Collection)questionVo.getAnswerIds()) && trueOption.size() == questionVo.getAnswerIds().size()) {
                    for (TrainingOptionsVo trainingOptionsVo : trueOption) {
                        if (questionVo.getAnswerIds().contains(trainingOptionsVo.getId())) continue;
                        MULTIPLE_CHOICE = false;
                        break;
                    }
                } else {
                    MULTIPLE_CHOICE = false;
                }
                if (MULTIPLE_CHOICE.booleanValue()) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    if (userQuestion.getOriginScore() != null) {
                        userQuestion.setScore(userQuestion.getOriginScore());
                    }
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
            } else if (userQuestion.getQuestionType() == 4) {
                TrainingQuestion trainingQuestion;
                if (trainExam.getExamClass() == 1) {
                    if (!CollectionUtils.isEmpty(optionsList)) {
                        trainingQuestion = (TrainingOptionsVo)optionsList.get(0);
                        if (questionVo.getIsCorrect() != null && trainingQuestion.getOptionsName() != null && (questionVo.getIsCorrect() == 0 || questionVo.getIsCorrect() == 1) && questionVo.getIsCorrect() == Integer.parseInt(trainingQuestion.getOptionsName())) {
                            userQuestion.setIsCorrect(Integer.valueOf(1));
                            if (userQuestion.getOriginScore() != null) {
                                userQuestion.setScore(userQuestion.getOriginScore());
                            }
                        } else {
                            userQuestion.setIsCorrect(Integer.valueOf(0));
                        }
                    } else {
                        userQuestion.setIsCorrect(Integer.valueOf(0));
                    }
                } else {
                    trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(questionVo.getId());
                    if (questionVo.getIsCorrect() != null && trainingQuestion.getIsCorrect() != null && (questionVo.getIsCorrect() == 0 || questionVo.getIsCorrect() == 1) && questionVo.getIsCorrect() == trainingQuestion.getIsCorrect()) {
                        userQuestion.setIsCorrect(Integer.valueOf(1));
                        if (userQuestion.getOriginScore() != null) {
                            userQuestion.setScore(userQuestion.getOriginScore());
                        } else {
                            userQuestion.setIsCorrect(Integer.valueOf(0));
                        }
                    }
                }
                optionsList = new ArrayList();
                TrainingOptionsVo trainingOptionsVo = new TrainingOptionsVo();
                trainingOptionsVo.setIsSelect(Integer.valueOf(1));
                optionsList.add(trainingOptionsVo);
            }
            if (!CollectionUtils.isEmpty(optionsList)) {
                userQuestion.setOptionsData(JSONArray.toJSONString(optionsList));
            }
            userQuestion.setIsEmpty(questionVo.getIsEmpty());
            this.userQuestionMapper.updateById(userQuestion);
        }
        Double score = this.userQuestionMapper.selectScoreByUserPaperId(userPaper.getId(), 1);
        userPaper.setScore(new BigDecimal(score));
        userPaper.setSubmitTime(new Date());
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(papers.get(0).getId());
        Integer repetitionNum = 999;
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper)) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getRepetitionNum())) {
                repetitionNum = trainingPaper.getRepetitionNum();
            }
        } else {
            repetitionNum = 0;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)papers.get(0).getId())).gt(TrainingUserPaper::getPaperStatus, (Object)0);
        List userPaperList = this.userPaperMapper.selectList((Wrapper)wrapper);
        repetitionNum = !CollectionUtils.isEmpty((Collection)userPaperList) ? Integer.valueOf(repetitionNum > userPaperList.size() ? repetitionNum - userPaperList.size() - 1 : 0) : Integer.valueOf(repetitionNum > 0 ? repetitionNum - 1 : 0);
        userPaper.setPaperCount(repetitionNum);
        this.userPaperMapper.updateById(userPaper);
        return userPaper;
    }

    @Override
    public TheirPapersVo theirPapers(TrainingPaperVo paperVo, Integer userId) {
        log.info("theirPapers+++++++++++++++++++++userId" + userId);
        if (userId != null) {
            List<TrainingUserPaper> list = this.userPaperMapper.selectByUserIdAndPaperIdById(userId, paperVo.getId());
            TrainingUserPaper userPaper = list.get(0);
            if (list.size() > 1 && list.get(list.size() - 1).getId() > list.get(0).getId()) {
                userPaper = list.get(list.size() - 1);
            }
            log.info("theirPapers+++++++++++++++++++++" + JSON.toJSON(list));
            userPaper.setPaperCount(paperVo.getPaperCount());
            if (1 != userPaper.getPaperStatus()) {
                userPaper.setPaperStatus(Integer.valueOf(2));
                this.userPaperMapper.updateById(userPaper);
            }
            TheirPapersVo result = new TheirPapersVo();
            result.setUserPapgerId(userPaper.getId());
            result.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
            result.setStatus(userPaper.getPaperStatus());
            List<TrainingUserQuestion> questionList = this.userQuestionMapper.selectByUserPaperId(userPaper.getId(), null);
            result.setQuestionList(questionList);
            return result;
        }
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(paperVo.getUserPaperId());
        if (1 != userPaper.getPaperStatus()) {
            userPaper.setPaperStatus(Integer.valueOf(2));
            this.userPaperMapper.updateById(userPaper);
        }
        TheirPapersVo result = new TheirPapersVo();
        result.setUserPapgerId(userPaper.getId());
        result.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
        result.setStatus(userPaper.getPaperStatus());
        List<TrainingUserQuestion> questionList = this.userQuestionMapper.selectByUserPaperId(paperVo.getUserPaperId(), null);
        result.setQuestionList(questionList);
        return result;
    }

    @Override
    public TheirPapersVo getUserPaperDetail(Integer paperId, Integer userId) {
        List<TrainingUserPaper> userPapers = this.userPaperMapper.selectByUserIdAndPaperIdById(userId, paperId);
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        TheirPapersVo result = new TheirPapersVo();
        if (trainingPaper != null) {
            result.setEndTime(trainingPaper.getEndTime());
            result.setStartTime(trainingPaper.getStartTime());
        }
        if (!CollectionUtils.isEmpty(userPapers)) {
            TrainingUserPaper userPaper = userPapers.get(userPapers.size() - 1);
            result.setUserPapgerId(userPaper.getId());
            result.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
            result.setStatus(userPaper.getPaperStatus());
            List<TrainingUserQuestion> questionList = this.userQuestionMapper.selectByUserPaperId(userPaper.getId(), null);
            result.setQuestionList(questionList);
            result.setPaperCount(userPaper.getPaperCount());
        }
        return result;
    }

    @Override
    public TheirPapersVo theirDailyChallenge(TrainingPaperVo paperVo) {
        TheirPapersVo result = new TheirPapersVo();
        result.setScore(Double.valueOf(0.0));
        List questionVoList = paperVo.getQuestionList();
        ArrayList<TrainingUserQuestion> userQuestionList = new ArrayList<TrainingUserQuestion>();
        if (!CollectionUtils.isEmpty((Collection)questionVoList)) {
            for (TrainingQuestionVo questionVo : questionVoList) {
                TrainingQuestion question = (TrainingQuestion)this.questionMapper.selectById(questionVo.getId());
                TrainingUserQuestion userQuestion = new TrainingUserQuestion();
                userQuestion.setName(question.getName());
                if (!org.springframework.util.StringUtils.isEmpty((Object)question.getRemark())) {
                    userQuestion.setRemark(question.getRemark());
                }
                List<TrainingOptions> list = this.optionsMapper.selectByQuestionId(question.getId(), 1);
                if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == list.get(0).getId().intValue()) {
                    userQuestion.setIsCorrect(Integer.valueOf(1));
                    result.setScore(Double.valueOf(result.getScore() + 20.0));
                } else {
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                }
                List<TrainingOptionsVo> optionsList = this.optionsMapper.selectVoByQuestionId(questionVo.getId());
                for (TrainingOptionsVo optionVo : optionsList) {
                    if (questionVo.getAnswerId() != null && questionVo.getAnswerId().intValue() == optionVo.getId().intValue()) {
                        optionVo.setIsSelect(Integer.valueOf(1));
                        continue;
                    }
                    optionVo.setIsSelect(Integer.valueOf(0));
                }
                userQuestion.setOptionsData(JSONArray.toJSONString(optionsList));
                userQuestionList.add(userQuestion);
            }
        }
        result.setQuestionList(userQuestionList);
        return result;
    }

    @Override
    public void saveQuestionBankDetail(List<TrainingQuestionVo> questionVoList) {
        if (!CollectionUtils.isEmpty(questionVoList)) {
            ArrayList<TrainingOptions> list = new ArrayList<TrainingOptions>();
            for (TrainingQuestionVo questionVo : questionVoList) {
                TrainingQuestion question = new TrainingQuestion();
                question.setCreateTime(new Date());
                question.setCreater(questionVo.getCreater());
                question.setUpdateTime(new Date());
                question.setUpdater(questionVo.getUpdater());
                question.setTypeId(questionVo.getQuestionClass());
                question.setName(questionVo.getQuestionName());
                question.setQuestionType(questionVo.getQuestionType());
                question.setEnterpriseId(questionVo.getEnterpriseId());
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getRemark())) {
                    question.setRemark(questionVo.getRemark());
                }
                if (questionVo.getIsCorrect() != null) {
                    question.setIsCorrect(questionVo.getIsCorrect());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getPicturePath())) {
                    question.setPicturePath(questionVo.getPicturePath());
                }
                this.questionMapper.insert(question);
                if (CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) continue;
                List optionsList = questionVo.getOptionsList();
                for (TrainingOptionsVo optionsVo : optionsList) {
                    TrainingOptions options = new TrainingOptions();
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setIsAnswer(optionsVo.getIsAnswer());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(question.getId());
                    options.setPicturePath(optionsVo.getPicturePath());
                    list.add(options);
                }
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.optionsMapper.insertList(list);
            }
        }
    }

    @Override
    public void saveQuestionDetail(List<TrainingQuestionVo> questionVoList) {
        if (!CollectionUtils.isEmpty(questionVoList)) {
            for (TrainingQuestionVo questionVo : questionVoList) {
                TrainingQuestion question = new TrainingQuestion();
                question.setCreateTime(new Date());
                question.setUpdateTime(new Date());
                question.setTypeId(questionVo.getQuestionClass());
                question.setName(questionVo.getQuestionName());
                question.setQuestionType(questionVo.getQuestionType());
                question.setEnterpriseId(questionVo.getEnterpriseId());
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getRemark())) {
                    question.setRemark(questionVo.getRemark());
                }
                if (questionVo.getIsCorrect() != null) {
                    question.setIsCorrect(questionVo.getIsCorrect());
                }
                this.questionMapper.insert(question);
                TrainingPaperQuestion pq = new TrainingPaperQuestion();
                pq.setPaperId(questionVo.getPaperId());
                pq.setQuestionId(question.getId());
                pq.setScore(BigDecimal.valueOf(100.0 / (double)questionVoList.size()).setScale(2, 4));
                this.paperQuestionMapper.insertSelective(pq);
                if (CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) continue;
                List optionsList = questionVo.getOptionsList();
                for (TrainingOptionsVo optionsVo : optionsList) {
                    TrainingOptions options = new TrainingOptions();
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setIsAnswer(optionsVo.getIsAnswer());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(question.getId());
                    this.optionsMapper.insertSelective(options);
                }
            }
            this.updatePaperScore(questionVoList.get(0).getPaperId());
        }
    }

    @Override
    public void saveOptions(TrainingOptionsVo optionsVo) {
        TrainingOptions options = new TrainingOptions();
        options.setCreateTime(new Date());
        options.setUpdateTime(new Date());
        options.setIsAnswer(optionsVo.getIsAnswer());
        options.setName(optionsVo.getOptionsName());
        options.setTrainingQuestionId(optionsVo.getQuestionId());
        this.optionsMapper.insertSelective(options);
    }

    @Override
    public void deleteOptions(Integer optionsId) {
        this.optionsMapper.deleteById(optionsId);
    }

    @Override
    public List<TrainingPaperVo> getRecommendPaperByPage(Integer userId, Integer enterpriseId) {
        List<TrainingNav> navList = this.trainingService.getTrainingNavByGroupId(userId, enterpriseId);
        List<TrainingPaperVo> paperVoList = this.paperMapper.selectTopVoByNavIds(navList, enterpriseId, 4);
        if (!CollectionUtils.isEmpty(paperVoList)) {
            for (TrainingPaperVo paper : paperVoList) {
                List<TrainingUserPaper> paperList = this.userPaperMapper.selectByUserIdAndPaperId(userId, paper.getId());
                if (!CollectionUtils.isEmpty(paperList)) {
                    paper.setStatus(Integer.valueOf(2));
                } else {
                    paper.setStatus(Integer.valueOf(0));
                    List<TrainingPaperQuestion> list = this.paperQuestionMapper.selectByPaperId(paper.getId());
                    if (CollectionUtils.isEmpty(list)) {
                        paper.setHasQuestion(Integer.valueOf(0));
                    }
                }
                paper.setEnterpriseName(((EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(enterpriseId).getData()).getName());
            }
        }
        return paperVoList;
    }

    @Override
    public void saveQuestionBank(TrainingQuestionVo questionVo, Users user) {
        if (questionVo.getId() != null) {
            List<Integer> examIds;
            TrainingQuestion question = (TrainingQuestion)this.questionMapper.selectById(questionVo.getId());
            question.setName(questionVo.getQuestionName());
            question.setTypeId(questionVo.getTypeId());
            question.setIsCorrect(questionVo.getIsCorrect());
            question.setUpdateTime(new Date());
            question.setQuestionType(questionVo.getQuestionType());
            question.setRemark(questionVo.getRemark());
            question.setUpdater(questionVo.getUpdater());
            question.setPicturePath(questionVo.getPicturePath());
            question.setIsUpload(questionVo.getIsUpload());
            this.questionMapper.updateById(question);
            if (questionVo.getQuestionType().equals(5)) {
                HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
                columnMap.put("training_question_id", questionVo.getId());
                this.trainingOperateAttachMapper.deleteByMap(columnMap);
                List attachList = questionVo.getOperateAttachList();
                if (!CollectionUtils.isEmpty((Collection)attachList)) {
                    for (TrainingOperateAttach attach : attachList) {
                        attach.setCreateTime(new Date());
                        attach.setEnterpriseId(questionVo.getEnterpriseId());
                        attach.setTrainingQuestionId(question.getId());
                        this.trainingOperateAttachMapper.insert(attach);
                    }
                }
            }
            this.optionsMapper.deleteByQuestionId(questionVo.getId());
            if (!CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) {
                List optionsList = questionVo.getOptionsList();
                for (int j = 0; j < optionsList.size(); ++j) {
                    TrainingOptionsVo optionsVo = (TrainingOptionsVo)optionsList.get(j);
                    TrainingOptions options = new TrainingOptions();
                    BeanUtils.copyProperties((Object)optionsVo, (Object)options);
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(questionVo.getId());
                    this.optionsMapper.insert(options);
                }
            }
            if (!CollectionUtils.isEmpty(examIds = this.examQuestionMapper.selectExamByQuestion(Arrays.asList(questionVo.getId())))) {
                ArrayList<TrainingExamQuestionVo> examQuestionVoList = new ArrayList<TrainingExamQuestionVo>();
                for (Integer examId : examIds) {
                    TrainingExamQuestionVo vo = new TrainingExamQuestionVo();
                    vo.setExamId(examId);
                    vo.setQuestionId(questionVo.getId());
                    vo.setIsPush(Integer.valueOf(0));
                    examQuestionVoList.add(vo);
                }
                this.examService.updateExamQuestion(examQuestionVoList, user);
            }
        } else {
            List attachList;
            TrainingQuestion question = new TrainingQuestion();
            BeanUtils.copyProperties((Object)questionVo, (Object)question);
            question.setCreateTime(new Date());
            question.setUpdateTime(new Date());
            question.setName(questionVo.getQuestionName().trim());
            question.setCreater(questionVo.getUpdater());
            this.questionMapper.insert(question);
            if (questionVo.getQuestionType().equals(5) && !CollectionUtils.isEmpty((Collection)(attachList = questionVo.getOperateAttachList()))) {
                for (TrainingOperateAttach attach : attachList) {
                    attach.setCreateTime(new Date());
                    attach.setEnterpriseId(questionVo.getEnterpriseId());
                    attach.setTrainingQuestionId(question.getId());
                    this.trainingOperateAttachMapper.insert(attach);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) {
                List optionsList = questionVo.getOptionsList();
                for (int j = 0; j < optionsList.size(); ++j) {
                    TrainingOptionsVo optionsVo = (TrainingOptionsVo)optionsList.get(j);
                    TrainingOptions options = new TrainingOptions();
                    BeanUtils.copyProperties((Object)optionsVo, (Object)options);
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(question.getId());
                    this.optionsMapper.insert(options);
                }
            }
        }
    }

    @Override
    public void saveQuestionBankScore(List<TrainingQuestionVo> questionVos, Integer enterpriseId, Integer paperId) {
        TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
        TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andPaperIdEqualTo(paperId);
        this.paperQuestionMapper.deleteByExample(example);
        for (TrainingQuestionVo questionVo : questionVos) {
            if (questionVo.getId() == null) continue;
            TrainingPaperQuestion pq = new TrainingPaperQuestion();
            pq.setPaperId(paperId);
            pq.setQuestionId(questionVo.getId());
            pq.setScore(BigDecimal.valueOf(questionVo.getScore()));
            this.paperQuestionMapper.insertSelective(pq);
        }
    }

    @Override
    public void saveQuestionType(String questionIds, Integer typeId, Integer isAll, Integer typeIdOld, Integer isNotType, Integer enterpriseId) {
        if (typeId != null) {
            TrainingQuestion question = new TrainingQuestion();
            question.setTypeId(typeId);
            if (isAll == null || isAll == 0) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionIds)) {
                    ArrayList<Integer> questionList = new ArrayList<Integer>();
                    for (String id : questionIds.split(",")) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)id.trim())) continue;
                        questionList.add(Integer.parseInt(id.trim()));
                    }
                    if (!CollectionUtils.isEmpty(questionList)) {
                        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                        wrapper1.in(TrainingQuestion::getId, questionList);
                        this.questionMapper.update(question, (Wrapper)wrapper1);
                    }
                }
            } else if (isNotType != null) {
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                wrapper1.isNull(TrainingQuestion::getTypeId);
                this.questionMapper.update(question, (Wrapper)wrapper1);
            } else if (typeIdOld != null) {
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                wrapper1.eq(TrainingQuestion::getTypeId, (Object)typeIdOld);
                this.questionMapper.update(question, (Wrapper)wrapper1);
            } else {
                LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                this.questionMapper.update(question, (Wrapper)wrapper1);
            }
        }
    }

    @Override
    public void saveQuestion(TrainingQuestionVo questionVo) {
        if (questionVo.getId() != null) {
            TrainingQuestion question = (TrainingQuestion)this.questionMapper.selectById(questionVo.getId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getQuestionName())) {
                question.setName(questionVo.getQuestionName());
            }
            question.setUpdateTime(new Date());
            question.setQuestionType(questionVo.getQuestionType());
            question.setRemark(questionVo.getRemark());
            if (questionVo.getIsCorrect() != null) {
                question.setIsCorrect(questionVo.getIsCorrect());
            }
            this.questionMapper.updateById(question);
            this.optionsMapper.deleteByQuestionId(questionVo.getId());
            if (!CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) {
                List optionsList = questionVo.getOptionsList();
                for (int j = 0; j < optionsList.size(); ++j) {
                    TrainingOptionsVo optionsVo = (TrainingOptionsVo)optionsList.get(j);
                    TrainingOptions options = new TrainingOptions();
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setIsAnswer(optionsVo.getIsAnswer());
                    options.setName(optionsVo.getOptionsName().trim());
                    options.setTrainingQuestionId(questionVo.getId());
                    this.optionsMapper.insertSelective(options);
                }
            }
            this.updatePaperScore(questionVo.getPaperId());
        } else {
            TrainingQuestion question = new TrainingQuestion();
            question.setCreateTime(new Date());
            question.setUpdateTime(new Date());
            question.setName(questionVo.getQuestionName().trim());
            question.setQuestionType(questionVo.getQuestionType());
            question.setEnterpriseId(questionVo.getEnterpriseId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getRemark())) {
                question.setRemark(questionVo.getRemark());
            }
            if (questionVo.getIsCorrect() != null) {
                question.setIsCorrect(questionVo.getIsCorrect());
            }
            this.questionMapper.insert(question);
            TrainingPaperQuestion pq = new TrainingPaperQuestion();
            pq.setPaperId(questionVo.getPaperId());
            pq.setQuestionId(question.getId());
            this.paperQuestionMapper.insertSelective(pq);
            if (!CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) {
                List optionsList = questionVo.getOptionsList();
                for (int j = 0; j < optionsList.size(); ++j) {
                    TrainingOptionsVo optionsVo = (TrainingOptionsVo)optionsList.get(j);
                    TrainingOptions options = new TrainingOptions();
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setIsAnswer(optionsVo.getIsAnswer());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(question.getId());
                    this.optionsMapper.insertSelective(options);
                }
            }
            this.updatePaperScore(questionVo.getPaperId());
        }
    }

    @Override
    public void saveQuestions(List<TrainingQuestionVo> questionVos, Integer enterpriseId, Integer paperId) {
        this.questionMapper.deleteByPaperId(paperId);
        this.paperQuestionMapper.deleteByPaperId(paperId);
        for (TrainingQuestionVo questionVo : questionVos) {
            TrainingQuestion question = new TrainingQuestion();
            question.setCreateTime(new Date());
            question.setUpdateTime(new Date());
            question.setName(questionVo.getQuestionName().trim());
            question.setQuestionType(questionVo.getQuestionType());
            question.setEnterpriseId(questionVo.getEnterpriseId());
            question.setPaperId(paperId);
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getRemark())) {
                question.setRemark(questionVo.getRemark());
            }
            if (questionVo.getIsCorrect() != null) {
                question.setIsCorrect(questionVo.getIsCorrect());
            }
            this.questionMapper.insert(question);
            TrainingPaperQuestion pq = new TrainingPaperQuestion();
            pq.setPaperId(paperId);
            pq.setQuestionId(question.getId());
            this.paperQuestionMapper.insertSelective(pq);
            if (!CollectionUtils.isEmpty((Collection)questionVo.getOptionsList())) {
                List optionsList = questionVo.getOptionsList();
                for (int j = 0; j < optionsList.size(); ++j) {
                    TrainingOptionsVo optionsVo = (TrainingOptionsVo)optionsList.get(j);
                    TrainingOptions options = new TrainingOptions();
                    options.setCreateTime(new Date());
                    options.setUpdateTime(new Date());
                    options.setIsAnswer(optionsVo.getIsAnswer());
                    options.setName(optionsVo.getOptionsName());
                    options.setTrainingQuestionId(question.getId());
                    this.optionsMapper.insertSelective(options);
                }
            }
            this.updatePaperScore(paperId);
        }
    }

    @Override
    public int selectByPaperIdQuestionId(Integer paperId, Integer questionId) {
        int i = 0;
        List<TrainingPaperQuestion> trainingPaperQuestions = this.paperQuestionMapper.selectByPaperIdQuestionId(paperId, questionId);
        if (!CollectionUtils.isEmpty(trainingPaperQuestions)) {
            return 1;
        }
        return i;
    }

    @Override
    public void deleteQuestion(Integer paperId, Integer questionId) {
        TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
        TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
        if (paperId != null) {
            criteria.andPaperIdEqualTo(paperId);
        }
        if (questionId != null) {
            criteria.andQuestionIdEqualTo(questionId);
        }
        this.paperQuestionMapper.deleteByExample(example);
        TrainingQuestion question = (TrainingQuestion)this.questionMapper.selectById(questionId);
        question.setIsDelete(Integer.valueOf(1));
        this.questionMapper.updateById(question);
        this.updatePaperScore(paperId);
    }

    @Override
    public String deleteQuestionBank(List<Integer> questionList, Integer isAll, Integer typeId, Integer isNotType, Integer enterpriseId, Users user, LogPojo pojo) {
        LambdaQueryWrapper wrapper2;
        LambdaUpdateWrapper wrapper1;
        TrainingQuestion question = new TrainingQuestion();
        question.setIsDelete(Integer.valueOf(1));
        question.setUpdateTime(new Date());
        question.setUpdater(user.getId());
        List list = new ArrayList();
        if (isAll != null && isAll == 1) {
            if (isNotType != null) {
                wrapper1 = new LambdaUpdateWrapper();
                wrapper2 = new LambdaQueryWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                    wrapper2.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                    wrapper2.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                ((LambdaUpdateWrapper)wrapper1.isNull(TrainingQuestion::getTypeId)).isNull(TrainingQuestion::getIsDelete);
                this.questionMapper.update(question, (Wrapper)wrapper1);
                ((LambdaQueryWrapper)wrapper2.isNull(TrainingQuestion::getTypeId)).isNull(TrainingQuestion::getIsDelete);
                list = this.trainingQuestionMapper.selectList((Wrapper)wrapper2);
            } else if (typeId != null) {
                wrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper1.eq(TrainingQuestion::getTypeId, (Object)typeId)).isNull(TrainingQuestion::getIsDelete);
                this.questionMapper.update(question, (Wrapper)wrapper1);
                wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(TrainingQuestion::getTypeId, (Object)typeId)).isNull(TrainingQuestion::getIsDelete);
                list = this.trainingQuestionMapper.selectList((Wrapper)wrapper2);
                for (TrainingQuestion tq : list) {
                    if (pojo.getEnterpriseId().equals(tq.getEnterpriseId())) continue;
                    return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
                }
            } else {
                wrapper1 = new LambdaUpdateWrapper();
                wrapper2 = new LambdaQueryWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                    wrapper2.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                    wrapper2.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                wrapper1.isNull(TrainingQuestion::getIsDelete);
                this.questionMapper.update(question, (Wrapper)wrapper1);
                wrapper2.isNull(TrainingQuestion::getIsDelete);
                list = this.trainingQuestionMapper.selectList((Wrapper)wrapper2);
            }
        } else if (!CollectionUtils.isEmpty(questionList)) {
            wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.in(TrainingQuestion::getId, questionList)).isNull(TrainingQuestion::getIsDelete);
            this.questionMapper.update(question, (Wrapper)wrapper1);
            wrapper2 = new LambdaQueryWrapper();
            wrapper2.in(TrainingQuestion::getId, questionList);
            list = this.trainingQuestionMapper.selectList((Wrapper)wrapper2);
        }
        if (!CollectionUtils.isEmpty(list)) {
            List nameList = list.stream().map(TrainingQuestion::getName).collect(Collectors.toList());
            String name = String.join((CharSequence)";", nameList);
            pojo.setI18nParam(name);
            this.logApi.save(pojo);
        }
        return JsonResult.success();
    }

    @Override
    public Page<TrainingPaperVo> getErrorPaperByPage(Page<TrainingPaperVo> page, Integer userId) {
        List<TrainingPaperVo> paperList = this.userPaperMapper.selectByUserIdByPage(page, userId);
        if (!CollectionUtils.isEmpty(paperList)) {
            for (TrainingPaperVo paperVo : paperList) {
                List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(paperVo.getId(), 0);
                paperVo.setErrorNum(userQuestionList.size());
            }
        }
        page.setContent(paperList);
        return page;
    }

    @Override
    public List<TrainingQuestionVo> getErrorQuestionListById(Integer userPaperId, Integer status) {
        ArrayList<TrainingQuestionVo> result = new ArrayList<TrainingQuestionVo>();
        List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(userPaperId, status);
        if (!CollectionUtils.isEmpty(userQuestionList)) {
            Map<Object, Object> picMap = new HashMap();
            ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                if (userQuestion.getQuestionType() != 1) continue;
                userQuestionIdList.add(userQuestion.getId());
            }
            if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                    picMap = userQuestionPictures.stream().collect(Collectors.toMap(TrainingUserQuestionPicture::getUserQuestionId, e -> new ArrayList<TrainingUserQuestionPicture>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                TrainingQuestionVo questionVo = new TrainingQuestionVo();
                questionVo.setId(userQuestion.getId());
                questionVo.setQuestionName(userQuestion.getName());
                questionVo.setQuestionType(userQuestion.getQuestionType());
                if (userQuestion.getIsEmpty() != null && userQuestion.getIsEmpty() == 1) {
                    questionVo.setIsCorrect(Integer.valueOf(2));
                } else {
                    questionVo.setIsCorrect(userQuestion.getIsCorrect());
                }
                questionVo.setScore(Double.valueOf(userQuestion.getScore().doubleValue()));
                questionVo.setOriginScore(Double.valueOf(userQuestion.getOriginScore().doubleValue()));
                if (userQuestion.getQuestionType() == 4) {
                    TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(userQuestion.getPaperId());
                    if (trainingPaper != null) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getExamId())) {
                            TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(userQuestion.getQuestionId());
                            if (trainingQuestion != null) {
                                questionVo.setAnswer(trainingQuestion.getIsCorrect());
                            }
                        } else {
                            TrainingExam trainingExam = (TrainingExam)this.examMapper.selectById(trainingPaper.getExamId());
                            if (trainingExam.getExamClass() == 2) {
                                TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(userQuestion.getQuestionId());
                                if (trainingQuestion != null) {
                                    questionVo.setAnswer(trainingQuestion.getIsCorrect());
                                }
                            } else {
                                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingExamOptions::getExamQuestionId, (Object)userQuestion.getQuestionId())).eq(TrainingExamOptions::getIsAnswer, (Object)1)).last(" limit 1");
                                TrainingExamOptions examOptions = (TrainingExamOptions)this.examOptionsMapper.selectOne((Wrapper)wrapper1);
                                if (!org.springframework.util.StringUtils.isEmpty((Object)examOptions) && !org.springframework.util.StringUtils.isEmpty((Object)examOptions.getContent())) {
                                    questionVo.setAnswer(Integer.valueOf(examOptions.getContent()));
                                }
                            }
                        }
                    }
                } else if (userQuestion.getQuestionType() == 1) {
                    List questionPictureList = (List)picMap.get(userQuestion.getId());
                    questionVo.setUserQuestionPictureList(questionPictureList);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestion.getComment())) {
                        questionVo.setComment(userQuestion.getComment());
                    }
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(TrainingUserQuestionAtta::getUserQuestionId, (Object)userQuestion.getId());
                    List list = this.trainingUserQuestionAttaMapper.selectList((Wrapper)wrapper);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        questionVo.setAttaList(list);
                    }
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestion.getRemark())) {
                    questionVo.setRemark(userQuestion.getRemark());
                }
                List optionsList = JSONObject.parseArray((String)userQuestion.getOptionsData(), TrainingOptionsVo.class);
                this.setRightAnswer(questionVo);
                questionVo.setOptionsList(optionsList);
                result.add(questionVo);
            }
        }
        return result;
    }

    @Override
    public List<TrainingPaperVo> getAllErrorQuestionListsById(Integer userId, Integer paperId, Integer status, Integer userPaperId) {
        List<TrainingPaperVo> trainingPaperVos = this.userPaperMapper.selectAllByPaperIdAndUserId(userId, paperId, userPaperId);
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!CollectionUtils.isEmpty(trainingPaperVos)) {
            for (TrainingPaperVo trainingPaperVo : trainingPaperVos) {
                trainingPaperVo.setEnterpriseName(((EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(trainingPaperVo.getEnterpriseId()).getData()).getName());
                Integer errorCount = 0;
                Integer rightCount = 0;
                Integer enptyCount = 0;
                ArrayList<TrainingQuestionVo> result = new ArrayList<TrainingQuestionVo>();
                List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(trainingPaperVo.getId(), status);
                if (!CollectionUtils.isEmpty(userQuestionList)) {
                    for (TrainingUserQuestion userQuestion : userQuestionList) {
                        Integer n;
                        Integer n2;
                        TrainingPaper trainingPaper;
                        TrainingQuestionVo questionVo = new TrainingQuestionVo();
                        questionVo.setId(userQuestion.getId());
                        questionVo.setQuestionName(userQuestion.getName());
                        questionVo.setQuestionType(userQuestion.getQuestionType());
                        questionVo.setPicturePath(userQuestion.getPicturePath());
                        if (userQuestion.getIsEmpty() != null && userQuestion.getIsCorrect() == 0 && userQuestion.getIsEmpty() == 1) {
                            questionVo.setIsCorrect(Integer.valueOf(2));
                        } else {
                            questionVo.setIsCorrect(userQuestion.getIsCorrect());
                        }
                        questionVo.setScore(Double.valueOf(userQuestion.getScore().doubleValue()));
                        questionVo.setOriginScore(Double.valueOf(userQuestion.getOriginScore().doubleValue()));
                        if (userQuestion.getQuestionType() == 4 && (trainingPaper = (TrainingPaper)this.paperMapper.selectById(userQuestion.getPaperId())) != null) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getExamId())) {
                                TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(userQuestion.getQuestionId());
                                if (trainingQuestion != null) {
                                    questionVo.setAnswer(trainingQuestion.getIsCorrect());
                                }
                            } else {
                                TrainingExam trainingExam = (TrainingExam)this.examMapper.selectById(trainingPaper.getExamId());
                                if (trainingExam.getExamClass() == 2) {
                                    TrainingQuestion trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(userQuestion.getQuestionId());
                                    if (trainingQuestion != null) {
                                        questionVo.setAnswer(trainingQuestion.getIsCorrect());
                                    }
                                } else {
                                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingExamOptions::getExamQuestionId, (Object)userQuestion.getQuestionId())).eq(TrainingExamOptions::getIsAnswer, (Object)1)).last(" limit 1");
                                    TrainingExamOptions examOptions = (TrainingExamOptions)this.examOptionsMapper.selectOne((Wrapper)wrapper1);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)examOptions) && !org.springframework.util.StringUtils.isEmpty((Object)examOptions.getContent())) {
                                        questionVo.setAnswer(Integer.valueOf(examOptions.getContent()));
                                    }
                                }
                            }
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestion.getRemark())) {
                            questionVo.setRemark(userQuestion.getRemark());
                        }
                        List optionsList = JSONObject.parseArray((String)userQuestion.getOptionsData(), TrainingOptionsVo.class);
                        this.setRightAnswer(questionVo);
                        if (userQuestion.getIsCorrect() != null && userQuestion.getIsCorrect() == 1) {
                            n2 = rightCount;
                            n = rightCount = Integer.valueOf(rightCount + 1);
                        } else if (userQuestion.getIsEmpty() != null && userQuestion.getIsEmpty() == 1) {
                            n2 = enptyCount;
                            n = enptyCount = Integer.valueOf(enptyCount + 1);
                        } else {
                            n2 = errorCount;
                            n = errorCount = Integer.valueOf(errorCount + 1);
                        }
                        questionVo.setOptionsList(optionsList);
                        result.add(questionVo);
                    }
                }
                trainingPaperVo.setErrorCount(errorCount);
                trainingPaperVo.setRightCount(rightCount);
                trainingPaperVo.setEnptyCount(enptyCount);
                trainingPaperVo.setQuestionVos(result);
            }
        }
        if (!CollectionUtils.isEmpty(trainingPaperVos)) {
            for (TrainingPaperVo paperVo : trainingPaperVos) {
                List<TrainingPaperQuestion> list;
                TrainingUserPaper userPaperList = this.userPaperMapper.selectByPrimaryKey(paperVo.getId());
                if (userPaperList != null) {
                    Double rate = paper.getPassLine() != null ? (double)paper.getPassLine().intValue() * 0.01 : 0.6;
                    Double score = this.userQuestionMapper.selectOriginScoreByUserPaperId(userPaperList.getId());
                    paperVo.setScore(Double.valueOf(userPaperList.getScore().doubleValue()));
                    if (0 == userPaperList.getPaperStatus()) {
                        if (paperVo.getEndTime() != null && paperVo.getEndTime().getTime() < new Date().getTime()) {
                            paperVo.setUserStatus(Integer.valueOf(7));
                        } else {
                            paperVo.setUserStatus(Integer.valueOf(3));
                        }
                    } else if (userPaperList.getScore() != null && (double)userPaperList.getScore().intValue() >= score * rate && (double)userPaperList.getScore().intValue() != score && 1 != userPaperList.getPaperStatus()) {
                        paperVo.setUserStatus(Integer.valueOf(2));
                    } else if (userPaperList.getScore() != null && (double)userPaperList.getScore().intValue() == score && 1 != userPaperList.getPaperStatus()) {
                        paperVo.setUserStatus(Integer.valueOf(6));
                    } else if (userPaperList.getScore() != null && (double)userPaperList.getScore().intValue() < score * rate && 1 != userPaperList.getPaperStatus()) {
                        paperVo.setUserStatus(Integer.valueOf(1));
                    } else if (1 == userPaperList.getPaperStatus()) {
                        paperVo.setUserStatus(Integer.valueOf(5));
                    }
                    paperVo.setPassScore(Double.valueOf(score * rate));
                    continue;
                }
                if (paperVo.getEndTime() != null && paperVo.getEndTime().getTime() < new Date().getTime()) {
                    paperVo.setUserStatus(Integer.valueOf(7));
                } else {
                    paperVo.setUserStatus(Integer.valueOf(3));
                }
                if (!CollectionUtils.isEmpty(list = this.paperQuestionMapper.selectByPaperId(paperVo.getId()))) continue;
                paperVo.setHasQuestion(Integer.valueOf(0));
            }
        }
        return trainingPaperVos;
    }

    @Override
    public TrainingPaperRankingVo getRankingList(Integer groupId, Integer userId) {
        TrainingPaperRankingVo vo = new TrainingPaperRankingVo();
        Page page = new Page();
        page.setPageSize(10);
        List<TrainingPaperRankingUserVo> userList = this.userPaperMapper.selectRankingUserVoByGroupIdByPage((Page<TrainingPaperRankingUserVo>)page, groupId, null);
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userList.stream().map(TrainingPaperRankingUserVo::getUserId).collect(Collectors.toList()));
        for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : userList) {
            UsersPojo usersPojo = userMap.get(trainingPaperRankingUserVo.getUserId());
            if (ObjectUtils.isEmpty((Object)usersPojo)) continue;
            trainingPaperRankingUserVo.setUserName(usersPojo.getShowName());
            trainingPaperRankingUserVo.setEmployeeNumber(usersPojo.getEmployeeNumber());
        }
        TrainingPaperRankingUserVo myRanking = this.userPaperMapper.selectRankingByUserId(userId, groupId);
        myRanking.setUserName(this.userUtilService.selectUser(userId).getShowName());
        vo.setMyRanking(myRanking.getRanking());
        vo.setMyScore(myRanking.getScore());
        vo.setUserList(userList);
        return vo;
    }

    @Override
    public Page<TrainingPaperRankingUserVo> getWebRankingList(Page<TrainingPaperRankingUserVo> page, Integer enterpriseId, String userName, String organizeIds, Users user) {
        List<Integer> userList = this.organizeService.getUserListNew(user, organizeIds, null, userName, enterpriseId);
        if (!CollectionUtils.isEmpty(userList)) {
            Map<Integer, UsersPojo> usersPojoMap;
            List<Integer> userIds;
            List<TrainingPaperRankingUserVo> list = this.userPaperMapper.selectRankingUserVoByGroupIdByPage(page, enterpriseId, userList);
            ArrayList<UserOrganizeVo> userOrganizeVos = new ArrayList<UserOrganizeVo>();
            List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userList).getData();
            if (!CollectionUtils.isEmpty((Collection)userAndParentNameMos)) {
                userIds = userAndParentNameMos.stream().map(UserAndParentNameMo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                usersPojoMap = this.userUtilService.selectUserMap(userIds);
                for (UserAndParentNameMo mo : userAndParentNameMos) {
                    UserOrganizeVo vo = new UserOrganizeVo();
                    vo.setOrganizeId(mo.getOrganizeId());
                    vo.setOtype(mo.getOtype());
                    vo.setOrganizeName(mo.getOrganizeName());
                    vo.setGroupId(user.getGroupId());
                    UsersPojo usersPojo = usersPojoMap.get(mo.getUserId());
                    vo.setUserName(ObjectUtils.isEmpty((Object)usersPojo) ? "" : usersPojo.getShowName());
                    vo.setUserId(mo.getUserId());
                    userOrganizeVos.add(vo);
                }
            }
            if (!CollectionUtils.isEmpty(list)) {
                userIds = list.stream().map(TrainingPaperRankingUserVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                usersPojoMap = this.userUtilService.selectUserMap(userIds);
                for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : list) {
                    UsersPojo usersPojo = usersPojoMap.get(trainingPaperRankingUserVo.getUserId());
                    trainingPaperRankingUserVo.setUserName(usersPojo.getShowName());
                    trainingPaperRankingUserVo.setEmployeeNumber(usersPojo.getEmployeeNumber());
                    if (trainingPaperRankingUserVo.getScore() != null) {
                        trainingPaperRankingUserVo.setScore(Double.valueOf((double)Math.round(trainingPaperRankingUserVo.getScore() * 10.0) / 10.0));
                    }
                    Page newPage = new Page();
                    newPage.setPageSize(9999);
                    newPage.setPageNumber(1);
                    List<TrainingPaperVo> userNeedPapers = this.userPaperMapper.selectPapersByuserIdByPage((Page<TrainingPaperVo>)newPage, trainingPaperRankingUserVo.getUserId(), null, null, enterpriseId);
                    Integer userPapers = this.userPaperMapper.selectUserAllPaperCount(trainingPaperRankingUserVo.getUserId());
                    trainingPaperRankingUserVo.setAllPaperNum(Integer.valueOf(CollectionUtils.isEmpty(userNeedPapers) ? 0 : userNeedPapers.size()));
                    trainingPaperRankingUserVo.setFinishPaperNum(userPapers);
                    trainingPaperRankingUserVo.setDepName(this.userUtilService.selectUserOrganizeName(enterpriseId, Collections.singletonList(trainingPaperRankingUserVo.getUserId())).get(trainingPaperRankingUserVo.getUserId()));
                    ArrayList<Organize> shops = new ArrayList<Organize>();
                    List organizeIdList = (List)this.userOrganizeApi.getOrganizeIdByUserIdAndGroupId(enterpriseId, trainingPaperRankingUserVo.getUserId()).getData();
                    for (Integer organizeLd : organizeIdList) {
                        Organize organize = new Organize();
                        OrganizePojo organizePojo = (OrganizePojo)this.organizeApi.getOrganizeById(organizeLd).getData();
                        BeanUtils.copyProperties((Object)organizePojo, (Object)organize);
                        shops.add(organize);
                    }
                    if (!CollectionUtils.isEmpty(shops)) {
                        for (int i = 0; i < shops.size(); ++i) {
                            if (ObjectUtils.isEmpty(shops.get(i)) || ((Organize)shops.get(i)).getOtype() == null || ((Organize)shops.get(i)).getOtype() != 0) continue;
                            shops.remove(i);
                            --i;
                        }
                    }
                    trainingPaperRankingUserVo.setShopName(CollectionUtils.isEmpty(shops) ? "" : ((Organize)shops.get(0)).getName());
                    trainingPaperRankingUserVo.setRanking(Integer.valueOf(this.userPaperMapper.selectRankingUserVoByGroupIdRankingNum(enterpriseId, trainingPaperRankingUserVo.getScore()) + 1));
                }
            }
            page.setContent(list);
        }
        return page;
    }

    @Override
    public Page<TrainingPaperRankingUserVo> getUserWebRankingList(Page<TrainingPaperRankingUserVo> page, Integer userId, String startDate, String endDate) {
        List<TrainingPaperRankingUserVo> list = this.userPaperMapper.selectRankingUserVoByUserIdByPage(page, userId, DateUtils.parse(startDate), DateUtils.parse(endDate));
        if (!CollectionUtils.isEmpty(list)) {
            for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : list) {
                if (trainingPaperRankingUserVo.getScore() == null) continue;
                trainingPaperRankingUserVo.setScore(Double.valueOf((double)Math.round(trainingPaperRankingUserVo.getScore() * 10.0) / 10.0));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public Page<TrainingQuestionVo> getErrorQuestionByPage(Page<TrainingQuestionVo> page, Integer userId) {
        List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserIdByPage(page, userId, 0);
        ArrayList<TrainingQuestionVo> result = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty(userQuestionList)) {
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                TrainingQuestionVo questionVo = new TrainingQuestionVo();
                questionVo.setId(userQuestion.getId());
                questionVo.setQuestionName(userQuestion.getName());
                questionVo.setQuestionType(userQuestion.getQuestionType());
                if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestion.getRemark())) {
                    questionVo.setRemark(userQuestion.getRemark());
                }
                List optionsList = JSONObject.parseArray((String)userQuestion.getOptionsData(), TrainingOptionsVo.class);
                questionVo.setOptionsList(optionsList);
                result.add(questionVo);
            }
        }
        page.setContent(result);
        return page;
    }

    @Override
    public Page<TrainingPaperVo> getUserPaperByUserIdByPage(Page<TrainingPaperVo> page, Integer userId) {
        page.setContent(this.paperMapper.selectPaperIdByUserIdByPage(page, userId));
        return page;
    }

    @Override
    public TrainingPaperRankingVo getPaperRankingList(Integer groupId, Integer userId, Integer paperId) {
        TrainingPaperRankingVo vo = new TrainingPaperRankingVo();
        Page page = new Page();
        page.setPageSize(10);
        List<TrainingPaperRankingUserVo> userList = this.userPaperMapper.selectPaperRankingUserVoByGroupIdByPage((Page<TrainingPaperRankingUserVo>)page, groupId, paperId, null, null, null);
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userList.stream().map(TrainingPaperRankingUserVo::getUserId).collect(Collectors.toList()));
        for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : userList) {
            UsersPojo usersPojo = userMap.get(trainingPaperRankingUserVo.getUserId());
            trainingPaperRankingUserVo.setUserName(usersPojo.getShowName());
            trainingPaperRankingUserVo.setEmployeeNumber(usersPojo.getEmployeeNumber());
        }
        TrainingPaperRankingUserVo myRanking = this.userPaperMapper.selectPaperRankingByUserId(userId, groupId, paperId);
        if (myRanking != null) {
            myRanking.setUserName(this.userUtilService.selectUser(userId).getShowName());
            vo.setMyRanking(myRanking.getRanking());
            vo.setMyScore(myRanking.getScore());
        } else {
            vo.setMyRanking(Integer.valueOf(0));
            vo.setMyScore(Double.valueOf(0.0));
        }
        vo.setUserList(userList);
        return vo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Page<TrainingPaperRankingUserVo> getWebPaperRankingList(Page<TrainingPaperRankingUserVo> page, Integer groupId, Integer paperId, Date startTime, Date endTime, String userName, String organizeIds, Users user, Integer isFinish, Integer downloadType, Integer taskId) {
        BaseResult base;
        BaseResult bases;
        List<Integer> taskUserIds = null;
        List<Object> userIds = new ArrayList();
        if (taskId != null) {
            taskUserIds = this.trainingTaskUserMapper.selectUserIdByByTaskId(taskId);
        }
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(user.getGroupId());
        if (organizeIds != null && !"".equals(organizeIds)) {
            List<String> organizeIdList = Arrays.asList(organizeIds.split(","));
            mo.setOrganizeIds(organizeIdList);
        }
        if ((bases = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo)) != null && !CollectionUtils.isEmpty((Collection)((Collection)bases.getData()))) {
            userIds = ((List)bases.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && (base = this.userApi.getSimpleUserByKeyWord(user.getGroupId(), userName, null)) != null) {
            List userIdList = ((List)base.getData()).stream().map(SimplePojo::getId).collect(Collectors.toList());
            userIds.retainAll(userIdList);
        }
        if (!CollectionUtils.isEmpty(taskUserIds) && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(taskUserIds);
        }
        if (!(!CollectionUtils.isEmpty(userIds) || org.springframework.util.StringUtils.isEmpty((Object)organizeIds) && org.springframework.util.StringUtils.isEmpty((Object)userName))) {
            return page;
        }
        Page page999 = new Page();
        page999.setPageSize(9999);
        List<TrainingPaperRankingUserVo> userList = downloadType != null && downloadType == 1 ? this.userPaperMapper.selectByPaperIdScoreByPage((Page<TrainingPaperRankingUserVo>)page999, groupId, paperId, startTime, endTime, userIds) : this.userPaperMapper.selectByPaperIdRankingByPage((Page<TrainingPaperRankingUserVo>)page999, groupId, paperId, startTime, endTime, userIds);
        page999.setPageNumber(1);
        List<Integer> userIdList = this.userPaperMapper.selectUserIdsByPaperIdRankingByPage((Page<TrainingPaperRankingUserVo>)page999, groupId, paperId, null, null, userIds);
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            List newPage;
            List<Object> levelUserIds = new ArrayList<Object>();
            if (trainingPaper != null && trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                levelUserIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
                if (!CollectionUtils.isEmpty(levelUserIds)) {
                    levelUserIds.retainAll(userIds);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        levelUserIds.removeAll(userIdList);
                    }
                }
            } else {
                levelUserIds.addAll(userIds);
                if (!CollectionUtils.isEmpty(userIdList)) {
                    levelUserIds.removeAll(userIdList);
                }
            }
            if (isFinish != null) {
                if (isFinish == 1) {
                    levelUserIds = null;
                } else {
                    userList = new ArrayList<TrainingPaperRankingUserVo>();
                }
            }
            if (!CollectionUtils.isEmpty(levelUserIds) && startTime == null) {
                if (!CollectionUtils.isEmpty(taskUserIds)) {
                    levelUserIds.retainAll(taskUserIds);
                }
                if (!CollectionUtils.isEmpty(levelUserIds)) {
                    Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(levelUserIds);
                    for (Integer n : levelUserIds) {
                        UsersPojo usersPojo = userMap.get(n);
                        if (!Objects.nonNull(usersPojo)) continue;
                        TrainingPaperRankingUserVo tVo = new TrainingPaperRankingUserVo();
                        tVo.setUserName(usersPojo.getShowName());
                        tVo.setUserId(usersPojo.getId());
                        userList.add(tVo);
                    }
                }
            }
            ArrayList<Integer> userIdsList = new ArrayList();
            if (!CollectionUtils.isEmpty(userList)) {
                userIdsList = userList.stream().map(TrainingPaperRankingUserVo::getUserId).distinct().collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)(newPage = (page = ListUtil.myPage(userList, page.getPageNumber(), page.getPageSize())).getContent()))) {
                Double d = ((TrainingPaperRankingUserVo)newPage.get(0)).getScore();
                int ranking = 1;
                if (((TrainingPaperRankingUserVo)newPage.get(0)).getScore() != null) {
                    ranking = this.userPaperMapper.selectByPaperIdRankingDetail(paperId, ((TrainingPaperRankingUserVo)newPage.get(0)).getScore(), userIdsList) + 1;
                }
                List<Integer> userIdLists = newPage.stream().map(TrainingPaperRankingUserVo::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIdLists);
                Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), userIdLists);
                Map<Object, Object> userPaperMap = new HashMap();
                if (!CollectionUtils.isEmpty(userIdLists)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId)).in(TrainingUserPaper::getUserId, userIdLists)).and(wq -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
                    });
                    List userPapers = this.userPaperMapper.selectList((Wrapper)wrapper);
                    if (!CollectionUtils.isEmpty((Collection)userPapers)) {
                        userPaperMap = userPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
                    }
                }
                for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : newPage) {
                    void var23_25;
                    if (trainingPaperRankingUserVo.getUserId() != null) {
                        trainingPaperRankingUserVo.setDepName(userOrganizeMap.get(trainingPaperRankingUserVo.getUserId()));
                        trainingPaperRankingUserVo.setShopName(this.findShopNameByUserId2(trainingPaperRankingUserVo.getUserId(), trainingPaper.getEnterpriseId()));
                        UsersPojo pojo = userMap.get(trainingPaperRankingUserVo.getUserId());
                        trainingPaperRankingUserVo.setUserName(pojo.getShowName());
                        trainingPaperRankingUserVo.setEmployeeNumber(pojo.getEmployeeNumber());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperRankingUserVo.getLoginShowName())) {
                        trainingPaperRankingUserVo.setUserName(trainingPaperRankingUserVo.getLoginShowName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperRankingUserVo.getLoginDepName())) {
                        trainingPaperRankingUserVo.setDepName(trainingPaperRankingUserVo.getLoginDepName());
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperRankingUserVo.getLoginEmployeeNumber())) {
                        trainingPaperRankingUserVo.setEmployeeNumber(trainingPaperRankingUserVo.getLoginEmployeeNumber());
                    }
                    if (trainingPaperRankingUserVo.getScore() != null && var23_25 != null) {
                        if (!trainingPaperRankingUserVo.getScore().equals(var23_25)) {
                            ranking = this.userPaperMapper.selectByPaperIdRankingDetail(paperId, trainingPaperRankingUserVo.getScore(), userIdsList) + 1;
                            Double d2 = trainingPaperRankingUserVo.getScore();
                        }
                        trainingPaperRankingUserVo.setRanking(Integer.valueOf(ranking));
                    }
                    List userPaperList = (List)userPaperMap.get(trainingPaperRankingUserVo.getUserId());
                    int num = 0;
                    if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                        num = userPaperList.size();
                    }
                    trainingPaperRankingUserVo.setPaperCount(Integer.valueOf(num));
                }
            }
            page.setContent(newPage);
        }
        return page;
    }

    @Override
    public List<TrainingPaperRankingUserVo> getWebPaperRankingListByUserId(Integer userId, Integer paperId) {
        List<TrainingPaperRankingUserVo> selectByPaperIdAndUserId = this.userPaperMapper.selectByPaperIdAndUserId(userId, paperId);
        for (TrainingPaperRankingUserVo vo : selectByPaperIdAndUserId) {
            UsersPojo usersPojo = this.userUtilService.selectUser(vo.getUserId());
            vo.setUserName(usersPojo.getShowName());
            vo.setEmployeeNumber(usersPojo.getEmployeeNumber());
        }
        UsersPojo user = (UsersPojo)this.userApi.getUserById(userId).getData();
        if (!CollectionUtils.isEmpty(selectByPaperIdAndUserId)) {
            selectByPaperIdAndUserId.remove(0);
            List<Integer> userIdList = selectByPaperIdAndUserId.stream().map(TrainingPaperRankingUserVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
            Integer num = 0;
            Integer nums = selectByPaperIdAndUserId.size();
            for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : selectByPaperIdAndUserId) {
                List<String> userStr = userOrganizeMap.get(userId);
                trainingPaperRankingUserVo.setDepName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
                trainingPaperRankingUserVo.setPaperCount(Integer.valueOf(nums - num));
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
            }
        }
        return selectByPaperIdAndUserId;
    }

    @Override
    public Map<Integer, List<TrainingPaperRankingUserVo>> getAllWebPaperRankingList(Integer paperId) {
        List<TrainingPaperRankingUserVo> selectByPaperIdAndUserId = this.userPaperMapper.selectByPaperIdAndUserId(null, paperId);
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(selectByPaperIdAndUserId.stream().map(TrainingPaperRankingUserVo::getUserId).collect(Collectors.toList()));
        for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : selectByPaperIdAndUserId) {
            UsersPojo usersPojo = userMap.get(trainingPaperRankingUserVo.getUserId());
            if (ObjectUtils.isEmpty((Object)usersPojo)) continue;
            trainingPaperRankingUserVo.setUserName(usersPojo.getShowName());
            trainingPaperRankingUserVo.setEmployeeNumber(usersPojo.getEmployeeNumber());
        }
        Map<Integer, List<TrainingPaperRankingUserVo>> taskCommentMap = new HashMap<Integer, List<TrainingPaperRankingUserVo>>();
        if (!CollectionUtils.isEmpty(selectByPaperIdAndUserId)) {
            taskCommentMap = selectByPaperIdAndUserId.stream().collect(Collectors.groupingBy(TrainingPaperRankingUserVo::getUserId));
        }
        return taskCommentMap;
    }

    @Override
    public Page<TrainingPaperRankingUserVo> getUserPaperByScore(Page<TrainingPaperRankingUserVo> page, Integer paperId, double min, double max, Date startTime, Date endTime, String organizeIds, String userName, Users user) {
        List<TrainingPaperRankingUserVo> newPage;
        List<Integer> userIds = this.organizeService.getUserListNew(user, organizeIds, null, userName, user.getGroupId());
        if (!(!CollectionUtils.isEmpty(userIds) || org.springframework.util.StringUtils.isEmpty((Object)organizeIds) && org.springframework.util.StringUtils.isEmpty((Object)userName))) {
            return page;
        }
        Page page999 = new Page();
        page999.setPageSize(9999);
        page999.setPageNumber(1);
        List<TrainingPaperRankingUserVo> userList = this.userPaperMapper.selectPaperByUserScoreByPage((Page<TrainingPaperRankingUserVo>)page999, paperId, min, max, startTime, endTime, userIds);
        for (TrainingPaperRankingUserVo vo : userList) {
            UsersPojo usersPojo = this.userUtilService.selectUser(vo.getUserId());
            vo.setUserName(usersPojo.getShowName());
            vo.setEmployeeNumber(usersPojo.getEmployeeNumber());
        }
        int allSize = CollectionUtils.isEmpty(userList) ? 0 : userList.size();
        List<Integer> userIdList = this.userPaperMapper.selectUserIdsByUserScoreByPage((Page<TrainingPaperRankingUserVo>)page999, paperId, 0.0, 100.0, null, null, userIds);
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        List<Object> levelUserIds = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper) && !org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getLookLevel()) && trainingPaper.getLookLevel() == 1) {
            levelUserIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
            if (!CollectionUtils.isEmpty(levelUserIds) && !CollectionUtils.isEmpty(userIdList)) {
                levelUserIds.retainAll(userIds);
                levelUserIds.removeAll(userIdList);
            }
        } else {
            levelUserIds.addAll(userIds);
            if (!CollectionUtils.isEmpty(userIdList)) {
                levelUserIds.removeAll(userIdList);
            }
        }
        if (!CollectionUtils.isEmpty(levelUserIds) && startTime == null) {
            for (Integer n : levelUserIds) {
                UsersPojo usersPojo = this.userUtilService.selectUser(n);
                if (!Objects.nonNull(usersPojo)) continue;
                TrainingPaperRankingUserVo tVo = new TrainingPaperRankingUserVo();
                tVo.setUserName(usersPojo.getShowName());
                tVo.setUserId(usersPojo.getId());
                userList.add(tVo);
            }
        }
        if (!CollectionUtils.isEmpty(newPage = ListUtil.page(userList, page.getPageNumber(), page.getPageSize()))) {
            ArrayList<UserOrganizeVo> arrayList = new ArrayList<UserOrganizeVo>();
            List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
            for (UserAndParentNameMo mo : userAndParentNameMos) {
                UserOrganizeVo vo = new UserOrganizeVo();
                vo.setOrganizeId(mo.getOrganizeId());
                vo.setOtype(mo.getOtype());
                vo.setOrganizeName(mo.getOrganizeName());
                vo.setGroupId(user.getGroupId());
                UsersPojo usersPojo = userMap.get(mo.getUserId());
                vo.setUserName(ObjectUtils.isEmpty((Object)usersPojo) ? "" : usersPojo.getShowName());
                vo.setUserId(mo.getUserId());
                arrayList.add(vo);
            }
            for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : newPage) {
                if (trainingPaperRankingUserVo.getUserId() != null) {
                    Map<Integer, String> organizeNameMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), Collections.singletonList(trainingPaperRankingUserVo.getUserId()));
                    String organizeName = organizeNameMap.get(trainingPaperRankingUserVo.getUserId());
                    trainingPaperRankingUserVo.setDepName(org.springframework.util.StringUtils.isEmpty((Object)organizeName) ? "" : organizeName);
                }
                if (trainingPaperRankingUserVo.getUserId() == null) continue;
                ArrayList<Organize> shops = new ArrayList<Organize>();
                List organizeIdList = (List)this.userOrganizeApi.getOrganizeIdByUserIdAndGroupId(user.getGroupId(), trainingPaperRankingUserVo.getUserId()).getData();
                for (Integer organizeLd : organizeIdList) {
                    Organize organize = new Organize();
                    OrganizePojo organizePojo = (OrganizePojo)this.organizeApi.getOrganizeById(organizeLd).getData();
                    BeanUtils.copyProperties((Object)organizePojo, (Object)organize);
                    shops.add(organize);
                }
                if (!CollectionUtils.isEmpty(shops)) {
                    for (int i = 0; i < shops.size(); ++i) {
                        if (ObjectUtils.isEmpty(shops.get(i)) || ((Organize)shops.get(i)).getOtype() == null || ((Organize)shops.get(i)).getOtype() != 0) continue;
                        shops.remove(i);
                        --i;
                    }
                }
                trainingPaperRankingUserVo.setShopName(CollectionUtils.isEmpty(shops) ? "" : ((Organize)shops.get(0)).getName());
            }
        }
        List<Integer> list = this.userPaperMapper.selectUserIdsByPaperId(paperId);
        list.retainAll(userIds);
        page.setContent(newPage);
        page.setId(Integer.valueOf(list.size()));
        page.setTotalCount(Long.valueOf(userList.size()));
        page.setPageCount(Long.valueOf(allSize));
        return page;
    }

    @Override
    public Page<TrainingPaperVo> getPaperByTrainingIdByPage(Page<TrainingPaperVo> page, Integer userId, Integer trainingId, Integer userEnterpriseId, Integer enterpriseId, Integer showOptions) {
        List<TrainingChapter> trainingChapters;
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        ArrayList<Integer> paperIds = new ArrayList<Integer>();
        if (training.getIsChapter() != null && training.getIsChapter() != 1 && training.getPaperId() != null) {
            if (training.getIsLock() != null && training.getIsLock() == 1) {
                int attachSize = this.getTrainingOldAttachSize(trainingId);
                List<Integer> finishUser = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize, StringsUtils.StringToList(userId + "", ","));
                if (!CollectionUtils.isEmpty((Collection)finishUser)) {
                    paperIds.add(training.getPaperId());
                }
            } else {
                paperIds.add(training.getPaperId());
            }
        } else if (training.getIsChapter() != null && training.getIsChapter() == 1 && !CollectionUtils.isEmpty(trainingChapters = this.getChapterIsUnlock(trainingId, userId))) {
            for (TrainingChapter trainingChapter : trainingChapters) {
                if (trainingChapter.getPaperId() == null) continue;
                paperIds.add(trainingChapter.getPaperId());
            }
        }
        if (!CollectionUtils.isEmpty(paperIds)) {
            Page newPage = new Page();
            newPage.setPageNumber(1);
            newPage.setPageSize(1000);
            List<Object> paperVoList = new ArrayList();
            paperVoList = this.commonRemoteService.isRoot(userId) != false ? this.paperMapper.selectAllByPaperIdsByPage((Page<TrainingPaperVo>)newPage, userId, enterpriseId, new Date(), showOptions, paperIds) : this.paperMapper.selectAllByPaperIdsByPage((Page<TrainingPaperVo>)newPage, userId, userEnterpriseId, new Date(), showOptions, paperIds);
            if (!CollectionUtils.isEmpty(paperVoList)) {
                for (Object paperVo : paperVoList) {
                    List<TrainingPaperQuestion> list;
                    TrainingUserPaper trainingUserPaper = this.userPaperMapper.selectByPrimaryKey(paperVo.getUserPaperId());
                    if (trainingUserPaper != null && paperVo.getUserPaperId() != null) {
                        paperVo.setScore(Double.valueOf(trainingUserPaper.getScore().doubleValue()));
                        if (0 == trainingUserPaper.getPaperStatus()) {
                            if (paperVo.getEndTime() != null && paperVo.getEndTime().getTime() < new Date().getTime()) {
                                paperVo.setUserStatus(Integer.valueOf(7));
                                continue;
                            }
                            paperVo.setUserStatus(Integer.valueOf(3));
                            continue;
                        }
                        if (trainingUserPaper.getScore() != null && trainingUserPaper.getScore().intValue() >= 60 && trainingUserPaper.getScore().intValue() != 100 && 1 != trainingUserPaper.getPaperStatus()) {
                            paperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (trainingUserPaper.getScore() != null && trainingUserPaper.getScore().intValue() == 100 && 1 != trainingUserPaper.getPaperStatus()) {
                            paperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (trainingUserPaper.getScore() != null && trainingUserPaper.getScore().intValue() < 60 && 1 != trainingUserPaper.getPaperStatus()) {
                            paperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (1 != trainingUserPaper.getPaperStatus()) continue;
                        paperVo.setUserStatus(Integer.valueOf(5));
                        continue;
                    }
                    if (paperVo.getEndTime() != null && paperVo.getEndTime().getTime() < new Date().getTime()) {
                        paperVo.setUserStatus(Integer.valueOf(7));
                    } else {
                        paperVo.setUserStatus(Integer.valueOf(3));
                    }
                    if (!CollectionUtils.isEmpty(list = this.paperQuestionMapper.selectByPaperId(paperVo.getId()))) continue;
                    paperVo.setHasQuestion(Integer.valueOf(0));
                }
            }
            ArrayList<TrainingPaperVo> arrayList = new ArrayList<TrainingPaperVo>();
            if (!CollectionUtils.isEmpty(paperVoList)) {
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getEndTime() == null || trainingPaperVo.getUserStatus() != 3) continue;
                    arrayList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getEndTime() != null || trainingPaperVo.getUserStatus() != 3) continue;
                    arrayList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != 2 && trainingPaperVo.getUserStatus() != 6 && trainingPaperVo.getUserStatus() != 4 && trainingPaperVo.getUserStatus() != 5) continue;
                    arrayList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != 7) continue;
                    arrayList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != null) continue;
                    arrayList.add(trainingPaperVo);
                }
            }
            List newPaperVos = new ArrayList();
            if (!CollectionUtils.isEmpty(arrayList)) {
                if (arrayList.size() >= page.getPageNumber() * page.getPageSize()) {
                    newPaperVos = arrayList.subList((page.getPageNumber() - 1) * page.getPageSize(), page.getPageNumber() * page.getPageSize());
                } else if ((page.getPageNumber() - 1) * page.getPageSize() < arrayList.size()) {
                    newPaperVos = arrayList.subList((page.getPageNumber() - 1) * page.getPageSize(), arrayList.size());
                }
            }
            page.setContent(newPaperVos);
            page.setTotalCount(newPage.getTotalCount());
        }
        return page;
    }

    private List<TrainingChapter> getChapterIsUnlock(Integer trainingId, Integer userId) {
        TrainingChapterUnlock trainingChapterUnlock;
        ArrayList<TrainingChapter> newChapter = new ArrayList<TrainingChapter>();
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        for (int i = 0; i < trainingChapters.size() && (trainingChapters.get(i).getIsLock() != 1 || (trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(i).getId())) != null && trainingChapterUnlock.getIsUnlock() != 1); ++i) {
            newChapter.add(trainingChapters.get(i));
        }
        return newChapter;
    }

    @Override
    public TrainingPaperVo getUserPaperById(Integer paperId, Integer userId) {
        List<TrainingUserPaper> paperList = this.userPaperMapper.selectByUserIdAndPaperId(userId, paperId);
        if (!CollectionUtils.isEmpty(paperList)) {
            TrainingPaperVo result = new TrainingPaperVo();
            result.setStatus(Integer.valueOf(2));
            TrainingUserPaper userPaper = paperList.get(0);
            result.setPaperName(userPaper.getTitle());
            List<TrainingQuestionVo> questionList = this.getErrorQuestionListById(userPaper.getId(), null);
            result.setQuestionList(questionList);
            return result;
        }
        return null;
    }

    @Override
    public Integer getUserPaperByIsLevel(Integer paperId, Integer userId, Integer enterpriseId) {
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (paper == null || paper.getEnterpriseId() == null || !paper.getEnterpriseId().equals(enterpriseId)) {
            return 1;
        }
        Integer isLevel = 0;
        if (paper != null && paper.getLookLevel() != null && paper.getLookLevel().equals(1)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingPaperUser::getUserId, (Object)userId)).eq(TrainingPaperUser::getPaperId, (Object)paperId);
            List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper1);
            if (CollectionUtils.isEmpty((Collection)paperUserList)) {
                isLevel = 1;
            }
        }
        return isLevel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TrainingPaperVo getMobileQuestionListByPaperId(Integer paperId, Integer enterpriseId, Integer userId, String loginShowName, String loginDepName, String loginEmployeeNumber) {
        TrainingPaperVo result = new TrainingPaperVo();
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (userId != null) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserPaper::getUserId, (Object)userId)).eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId)).eq(TrainingUserPaper::getPaperStatus, (Object)0);
            List list = this.userPaperMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List userPaperIds = list.stream().map(TrainingUserPaper::getId).distinct().collect(Collectors.toList());
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                wrapper2.in(TrainingUserPaper::getId, userPaperIds);
                this.userPaperMapper.delete((Wrapper)wrapper2);
                LambdaUpdateWrapper wrapper3 = new LambdaUpdateWrapper();
                wrapper3.in(TrainingUserQuestion::getUserPaperId, userPaperIds);
                this.userQuestionMapper.delete((Wrapper)wrapper3);
            }
        }
        Integer userPaperId = null;
        Map<Object, Object> questionMap = new HashMap();
        Map<Object, Object> optionMap = new HashMap();
        if (!org.springframework.util.StringUtils.isEmpty((Object)paper)) {
            if (org.springframework.util.StringUtils.isEmpty((Object)enterpriseId)) {
                enterpriseId = paper.getEnterpriseId();
            }
            TrainingUserPaper userPaper = new TrainingUserPaper();
            userPaper.setCreateTime(new Date());
            userPaper.setTitle(paper.getTitle());
            userPaper.setPaperCreateTime(paper.getCreateTime());
            userPaper.setTrainingPaperId(paper.getId());
            userPaper.setPaperStatus(Integer.valueOf(0));
            userPaper.setScore(BigDecimal.ZERO);
            if (userId == null) {
                userPaper.setUserPaperType(Integer.valueOf(1));
            } else {
                userPaper.setUserId(userId);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPicUrl())) {
                userPaper.setPicUrl(paper.getPicUrl());
            }
            if (enterpriseId != null) {
                userPaper.setEnterpriseId(enterpriseId);
            } else {
                userPaper.setEnterpriseId(paper.getEnterpriseId());
            }
            if (loginShowName != null) {
                userPaper.setLoginShowName(loginShowName);
            }
            if (loginDepName != null) {
                userPaper.setLoginDepName(loginDepName);
            }
            if (loginEmployeeNumber != null) {
                userPaper.setLoginEmployeeNumber(loginEmployeeNumber);
            }
            if (paper.getTrainingNavId() != null) {
                userPaper.setTrainingNavId(paper.getTrainingNavId());
            }
            if (paper.getLookLevel() != null) {
                userPaper.setLookLevel(paper.getLookLevel());
            }
            if (paper.getRepetitionNum() != null) {
                userPaper.setPaperCount(paper.getRepetitionNum());
            } else {
                userPaper.setPaperCount(Integer.valueOf(999));
            }
            this.userPaperMapper.insert(userPaper);
            result.setUserPaperId(userPaper.getId());
            ArrayList<TrainingUserQuestion> trainingUserQuestions = new ArrayList<TrainingUserQuestion>();
            if (paper.getExamId() != null) {
                result.setExamId(paper.getExamId());
                TrainingExam trainExam = (TrainingExam)this.examMapper.selectById(paper.getExamId());
                if (trainExam.getExamClass() == 1) {
                    TrainingOptionsVo optionsVo;
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(TrainingExamQuestion::getExamId, (Object)paper.getExamId());
                    List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper);
                    List list = examQuestions.stream().map(TrainingExamQuestion::getId).collect(Collectors.toList());
                    if (list != null && list.size() > 0) {
                        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                        wrapper1.in(TrainingExamOptions::getExamQuestionId, list);
                        List examOptionsList = this.examOptionsMapper.selectList((Wrapper)wrapper1);
                        ArrayList<TrainingOptionsVo> optionList = new ArrayList<TrainingOptionsVo>();
                        for (TrainingExamOptions examOptions : examOptionsList) {
                            optionsVo = new TrainingOptionsVo();
                            optionsVo.setId(examOptions.getId());
                            optionsVo.setOptionsName(examOptions.getContent());
                            optionsVo.setIsAnswer(examOptions.getIsAnswer());
                            optionsVo.setQuestionId(examOptions.getExamQuestionId());
                            optionsVo.setPicturePath(examOptions.getPicturePath());
                            optionList.add(optionsVo);
                        }
                        optionMap = optionList.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
                    }
                    for (TrainingExamQuestion examQuestion : examQuestions) {
                        TrainingUserQuestion userQuestion = new TrainingUserQuestion();
                        userQuestion.setCreateTime(new Date());
                        userQuestion.setUpdateTime(new Date());
                        userQuestion.setName(examQuestion.getContent());
                        userQuestion.setUserId(userId);
                        userQuestion.setQuestionId(examQuestion.getId());
                        userQuestion.setPaperId(paperId);
                        userQuestion.setUserPaperId(userPaper.getId());
                        userQuestion.setIsCorrect(Integer.valueOf(0));
                        userQuestion.setEnterpriseId(enterpriseId);
                        userQuestion.setQuestionType(examQuestion.getQuestionType());
                        userQuestion.setPicturePath(examQuestion.getPicturePath());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)examQuestion.getRemark())) {
                            userQuestion.setRemark(examQuestion.getRemark());
                        }
                        if (examQuestion.getScore() != null) {
                            userQuestion.setOriginScore(examQuestion.getScore());
                        }
                        userQuestion.setScore(BigDecimal.ZERO);
                        List list2 = (List)optionMap.get(examQuestion.getId());
                        if (!CollectionUtils.isEmpty((Collection)list2)) {
                            userQuestion.setOptionsData(JSONArray.toJSONString((Object)list2));
                        } else {
                            ArrayList options1 = new ArrayList();
                            optionsVo = new TrainingOptionsVo();
                            options1.add(optionsVo);
                            userQuestion.setOptionsData(JSONArray.toJSONString((Object)options1));
                        }
                        trainingUserQuestions.add(userQuestion);
                    }
                } else {
                    List<Integer> questionIds;
                    ArrayList<Integer> trainingQuestionType = new ArrayList();
                    if (trainExam.getTrainingQuestion() != null) {
                        String[] quess = trainExam.getTrainingQuestion().split(",");
                        trainingQuestionType = Arrays.asList(quess).stream().map(Integer::parseInt).collect(Collectors.toList());
                    }
                    LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                    wrapper1.eq(TrainingPaperRandom::getExamId, (Object)trainExam.getId());
                    List list = this.trainingPaperRandomMapper.selectList((Wrapper)wrapper1);
                    ArrayList<TrainingQuestionVo> questionVoList = new ArrayList<TrainingQuestionVo>();
                    if (list != null && list.size() > 0) {
                        for (TrainingPaperRandom trainingPaperRandom : list) {
                            List<TrainingQuestion> list3 = this.questionMapper.selectRandByQuestionTypes(trainingPaperRandom.getQuestionType(), trainExam.getEnterpriseId(), trainingPaperRandom.getQuestionTypeNum(), trainingQuestionType);
                            for (TrainingQuestion trainingQuestion : list3) {
                                TrainingQuestionVo trainingQuestionVo = new TrainingQuestionVo();
                                trainingQuestionVo.setId(trainingQuestion.getId());
                                trainingQuestionVo.setQuestionName(trainingQuestion.getName());
                                trainingQuestionVo.setRemark(trainingQuestion.getRemark());
                                trainingQuestionVo.setQuestionType(trainingQuestion.getQuestionType());
                                trainingQuestionVo.setScore(Double.valueOf(Double.parseDouble(trainingPaperRandom.getQuestionScore() + "")));
                                trainingQuestionVo.setPicturePath(trainingQuestion.getPicturePath());
                                questionVoList.add(trainingQuestionVo);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(questionIds = questionVoList.stream().map(TrainingQuestion::getId).collect(Collectors.toList()))) {
                        Iterator<Object> questionList = this.questionMapper.selectByQuestionId(questionIds);
                        questionMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
                        List<TrainingOptionsVo> list4 = this.optionsMapper.selectOptionsByQuestionId(questionIds);
                        optionMap = list4.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
                    }
                    for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
                        TrainingQuestion question = (TrainingQuestion)questionMap.get(trainingQuestionVo.getId());
                        TrainingUserQuestion userQuestion = new TrainingUserQuestion();
                        userQuestion.setCreateTime(new Date());
                        userQuestion.setUpdateTime(new Date());
                        userQuestion.setName(question.getName());
                        userQuestion.setUserId(userId);
                        userQuestion.setQuestionId(question.getId());
                        userQuestion.setPaperId(paperId);
                        userQuestion.setUserPaperId(userPaper.getId());
                        userQuestion.setIsCorrect(Integer.valueOf(0));
                        userQuestion.setPicturePath(trainingQuestionVo.getPicturePath());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)question.getRemark())) {
                            userQuestion.setRemark(question.getRemark());
                        }
                        userQuestion.setEnterpriseId(enterpriseId);
                        userQuestion.setQuestionType(question.getQuestionType());
                        if (trainingQuestionVo.getScore() != null) {
                            userQuestion.setOriginScore(new BigDecimal(trainingQuestionVo.getScore()));
                        }
                        userQuestion.setScore(new BigDecimal(0));
                        List optionsList = (List)optionMap.get(trainingQuestionVo.getId());
                        if (!CollectionUtils.isEmpty((Collection)optionsList)) {
                            userQuestion.setOptionsData(JSONArray.toJSONString((Object)optionsList));
                        } else {
                            ArrayList<TrainingOptionsVo> options1 = new ArrayList<TrainingOptionsVo>();
                            TrainingOptionsVo optionsVo = new TrainingOptionsVo();
                            options1.add(optionsVo);
                            userQuestion.setOptionsData(JSONArray.toJSONString(options1));
                        }
                        trainingUserQuestions.add(userQuestion);
                    }
                }
            } else {
                List<Integer> questionIds;
                List<Object> questionVoList = new ArrayList();
                if (paper.getPaperType() != null && paper.getPaperType().equals(2)) {
                    List<Object> qList;
                    List<TrainingPaperRandom> trainingPaperRandoms = this.trainingPaperRandomMapper.selectByPaperId(paperId);
                    List<Integer> trainingPaperRandomTypes = this.trainingPaperRandomTypeMapper.selectByPaperId(paperId);
                    for (TrainingPaperRandom trainingPaperRandom : trainingPaperRandoms) {
                        if (trainingPaperRandom.getQuestionTypeNum() == null || trainingPaperRandom.getQuestionScore() == null || trainingPaperRandom.getQuestionTypeNum() == 0 || trainingPaperRandom.getQuestionScore().intValue() == 0) continue;
                        qList = new ArrayList();
                        qList = org.springframework.util.StringUtils.isEmpty((Object)paper.getQuestionClass()) ? this.questionMapper.selectByQuestionTypeSizes(trainingPaperRandom.getQuestionType(), enterpriseId, trainingPaperRandomTypes) : this.questionMapper.selectByQuestionTypeSize(trainingPaperRandom.getQuestionType(), enterpriseId, paper.getQuestionClass());
                        if (!CollectionUtils.isEmpty(qList) && qList.size() >= trainingPaperRandom.getQuestionTypeNum()) continue;
                        return null;
                    }
                    for (TrainingPaperRandom trainingPaperRandom : trainingPaperRandoms) {
                        if (trainingPaperRandom.getQuestionTypeNum() == null) {
                            trainingPaperRandom.setQuestionTypeNum(Integer.valueOf(0));
                        }
                        qList = null;
                        qList = org.springframework.util.StringUtils.isEmpty((Object)paper.getQuestionClass()) ? this.questionMapper.selectRandByQuestionTypes(trainingPaperRandom.getQuestionType(), enterpriseId, trainingPaperRandom.getQuestionTypeNum(), trainingPaperRandomTypes) : this.questionMapper.selectRandByQuestionType(trainingPaperRandom.getQuestionType(), enterpriseId, trainingPaperRandom.getQuestionTypeNum(), paper.getQuestionClass());
                        for (TrainingQuestion trainingQuestion : qList) {
                            TrainingQuestionVo trainingQuestionVo = new TrainingQuestionVo();
                            trainingQuestionVo.setId(trainingQuestion.getId());
                            trainingQuestionVo.setQuestionName(trainingQuestion.getName());
                            trainingQuestionVo.setRemark(trainingQuestion.getRemark());
                            trainingQuestionVo.setQuestionType(trainingQuestion.getQuestionType());
                            trainingQuestionVo.setScore(Double.valueOf(Double.parseDouble(trainingPaperRandom.getQuestionScore() + "")));
                            trainingQuestionVo.setPicturePath(trainingQuestion.getPicturePath());
                            questionVoList.add(trainingQuestionVo);
                        }
                    }
                } else {
                    questionVoList = this.questionMapper.selectVoByPaperId(paperId, 1);
                }
                if (!CollectionUtils.isEmpty(questionIds = questionVoList.stream().map(TrainingQuestion::getId).collect(Collectors.toList()))) {
                    List<TrainingQuestion> questionList = this.questionMapper.selectByQuestionId(questionIds);
                    questionMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getId, Function.identity()));
                    List<TrainingOptionsVo> list = this.optionsMapper.selectOptionsByQuestionId(questionIds);
                    optionMap = list.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
                }
                for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
                    TrainingQuestion question = (TrainingQuestion)questionMap.get(trainingQuestionVo.getId());
                    if (ObjectUtils.isEmpty((Object)question)) continue;
                    TrainingUserQuestion userQuestion = new TrainingUserQuestion();
                    userQuestion.setCreateTime(new Date());
                    userQuestion.setUpdateTime(new Date());
                    userQuestion.setName(question.getName());
                    userQuestion.setUserId(userId);
                    userQuestion.setQuestionId(question.getId());
                    userQuestion.setPaperId(paperId);
                    userQuestion.setUserPaperId(userPaper.getId());
                    userQuestion.setIsCorrect(Integer.valueOf(0));
                    userQuestion.setPicturePath(question.getPicturePath());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)question.getRemark())) {
                        userQuestion.setRemark(question.getRemark());
                    }
                    userQuestion.setEnterpriseId(enterpriseId);
                    userQuestion.setQuestionType(question.getQuestionType());
                    if (trainingQuestionVo.getScore() != null) {
                        userQuestion.setOriginScore(new BigDecimal(trainingQuestionVo.getScore()));
                    }
                    userQuestion.setScore(BigDecimal.ZERO);
                    List optionsList = (List)optionMap.get(trainingQuestionVo.getId());
                    if (!CollectionUtils.isEmpty((Collection)optionsList)) {
                        userQuestion.setOptionsData(JSONArray.toJSONString((Object)optionsList));
                    } else {
                        ArrayList<TrainingOptionsVo> arrayList = new ArrayList<TrainingOptionsVo>();
                        TrainingOptionsVo optionsVo = new TrainingOptionsVo();
                        arrayList.add(optionsVo);
                        userQuestion.setOptionsData(JSONArray.toJSONString(arrayList));
                    }
                    trainingUserQuestions.add(userQuestion);
                }
            }
            if (trainingUserQuestions.size() > 0) {
                this.userQuestionMapper.insertBatch(trainingUserQuestions);
            }
            userPaperId = userPaper.getId();
            result.setPaperName(userPaper.getTitle());
            if (!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getPicUrl())) {
                result.setPicUrl(userPaper.getPicUrl());
            }
        } else {
            result.setIsDel(Integer.valueOf(1));
        }
        List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(userPaperId, null);
        ArrayList<TrainingQuestionVo> questionList = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty(userQuestionList)) {
            for (TrainingUserQuestion questionVo : userQuestionList) {
                void var17_33;
                TrainingQuestionVo question = new TrainingQuestionVo();
                question.setId(questionVo.getQuestionId());
                question.setQuestionName(questionVo.getName());
                question.setQuestionType(questionVo.getQuestionType());
                question.setRemark(questionVo.getRemark());
                question.setPicturePath(questionVo.getPicturePath());
                if (questionVo.getQuestionType() == 4) {
                    if (paper.getExamId() != null) {
                        List list = (List)optionMap.get(questionVo.getId());
                        if (list != null && list.size() > 0 && ((TrainingOptionsVo)list.get(0)).getOptionsName() != null) {
                            question.setIsCorrect(Integer.valueOf(Integer.parseInt(((TrainingOptionsVo)list.get(0)).getOptionsName())));
                        }
                    } else {
                        TrainingQuestion trainingQuestion = (TrainingQuestion)questionMap.get(questionVo.getId());
                        if (!org.springframework.util.StringUtils.isEmpty((Object)trainingQuestion) && trainingQuestion.getIsCorrect() != null) {
                            question.setIsCorrect(trainingQuestion.getIsCorrect());
                        }
                    }
                } else {
                    question.setIsCorrect(questionVo.getIsCorrect());
                }
                List list = JSONArray.parseArray((String)questionVo.getOptionsData(), TrainingOptionsVo.class);
                if (list == null) {
                    ArrayList<TrainingOptionsVo> arrayList = new ArrayList<TrainingOptionsVo>();
                    TrainingOptionsVo optionsVo = new TrainingOptionsVo();
                    arrayList.add(optionsVo);
                }
                question.setOptionsList((List)var17_33);
                questionList.add(question);
            }
        }
        result.setQuestionList(questionList);
        result.setPaperTime(org.springframework.util.StringUtils.isEmpty((Object)paper) ? null : paper.getPaperTime());
        result.setShowOptions(org.springframework.util.StringUtils.isEmpty((Object)paper) ? null : paper.getShowOptions());
        result.setEndTime(org.springframework.util.StringUtils.isEmpty((Object)paper) ? null : paper.getEndTime());
        result.setRepetitionNum(org.springframework.util.StringUtils.isEmpty((Object)paper) ? null : Integer.valueOf(paper.getRepetitionNum() == null ? 999 : paper.getRepetitionNum()));
        return result;
    }

    private TrainingPaperVo random(TrainingPaper paper, Integer paperId, Integer enterpriseId, Integer userId, String loginShowName, String loginDepName, String loginEmployeeNumber) {
        TrainingQuestionVo question;
        TrainingPaperVo result = new TrainingPaperVo();
        Integer userPaperId = null;
        if (paper != null) {
            TrainingUserPaper userPaper = new TrainingUserPaper();
            userPaper.setCreateTime(new Date());
            userPaper.setUpdateTime(new Date());
            userPaper.setTitle(paper.getTitle());
            userPaper.setPaperCreateTime(paper.getCreateTime());
            userPaper.setTrainingPaperId(paper.getId());
            userPaper.setUserId(userId);
            userPaper.setPaperStatus(Integer.valueOf(0));
            userPaper.setScore(new BigDecimal(0));
            if (userId == null) {
                userPaper.setUserPaperType(Integer.valueOf(1));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)paper.getPicUrl())) {
                userPaper.setPicUrl(paper.getPicUrl());
            }
            if (enterpriseId != null) {
                userPaper.setEnterpriseId(enterpriseId);
            } else {
                userPaper.setEnterpriseId(paper.getEnterpriseId());
            }
            if (loginShowName != null) {
                userPaper.setLoginShowName(loginShowName);
            }
            if (loginDepName != null) {
                userPaper.setLoginDepName(loginDepName);
            }
            if (loginEmployeeNumber != null) {
                userPaper.setLoginEmployeeNumber(loginEmployeeNumber);
            }
            if (paper.getTrainingNavId() != null) {
                userPaper.setTrainingNavId(paper.getTrainingNavId());
            }
            if (paper.getLookLevel() != null) {
                userPaper.setLookLevel(paper.getLookLevel());
            }
            this.userPaperMapper.insert(userPaper);
            result.setUserPaperId(userPaper.getId());
            List<TrainingQuestionVo> questionVoList = this.questionMapper.selectVoByPaperId(paperId, 1);
            for (TrainingQuestionVo trainingQuestionVo : questionVoList) {
                question = (TrainingQuestion)this.questionMapper.selectById(trainingQuestionVo.getId());
                TrainingUserQuestion userQuestion = new TrainingUserQuestion();
                userQuestion.setCreateTime(new Date());
                userQuestion.setUpdateTime(new Date());
                userQuestion.setName(question.getName());
                userQuestion.setUserId(userId);
                userQuestion.setQuestionId(question.getId());
                userQuestion.setPaperId(paperId);
                userQuestion.setUserPaperId(userPaper.getId());
                userQuestion.setIsCorrect(Integer.valueOf(0));
                if (!org.springframework.util.StringUtils.isEmpty((Object)question.getRemark())) {
                    userQuestion.setRemark(question.getRemark());
                }
                userQuestion.setEnterpriseId(enterpriseId);
                userQuestion.setQuestionType(question.getQuestionType());
                if (trainingQuestionVo.getScore() != null) {
                    userQuestion.setOriginScore(new BigDecimal(trainingQuestionVo.getScore()));
                }
                userQuestion.setScore(new BigDecimal(0));
                List<TrainingOptionsVo> optionsList = this.optionsMapper.selectVoByQuestionId(trainingQuestionVo.getId());
                userQuestion.setOptionsData(JSONArray.toJSONString(optionsList));
                this.userQuestionMapper.insert(userQuestion);
            }
            userPaperId = userPaper.getId();
            result.setPaperName(userPaper.getTitle());
            if (!org.springframework.util.StringUtils.isEmpty((Object)userPaper.getPicUrl())) {
                result.setPicUrl(userPaper.getPicUrl());
            }
        } else {
            result.setIsDel(Integer.valueOf(1));
        }
        List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(userPaperId, null);
        ArrayList<TrainingQuestionVo> questionList = new ArrayList<TrainingQuestionVo>();
        for (TrainingUserQuestion trainingUserQuestion : userQuestionList) {
            question = new TrainingQuestionVo();
            question.setId(trainingUserQuestion.getQuestionId());
            question.setQuestionName(trainingUserQuestion.getName());
            question.setQuestionType(trainingUserQuestion.getQuestionType());
            question.setRemark(trainingUserQuestion.getRemark());
            question.setIsCorrect(trainingUserQuestion.getIsCorrect());
            question.setOptionsList(JSONArray.parseArray((String)trainingUserQuestion.getOptionsData(), TrainingOptionsVo.class));
            questionList.add(question);
        }
        result.setQuestionList(questionList);
        result.setPaperTime(paper.getPaperTime());
        result.setShowOptions(paper.getShowOptions());
        result.setEndTime(paper.getEndTime());
        return result;
    }

    @Override
    public TrainingPaperVo getDailyChallenge(Integer groupId) {
        TrainingPaperVo paperVo = new TrainingPaperVo();
        List<TrainingQuestionVo> questionList = this.questionMapper.selectRandByEnterpriseId(groupId);
        if (!CollectionUtils.isEmpty(questionList)) {
            for (TrainingQuestionVo questionVo : questionList) {
                questionVo.setOptionsList(this.optionsMapper.selectVoByQuestionId(questionVo.getId()));
            }
        }
        paperVo.setQuestionList(questionList);
        return paperVo;
    }

    @Override
    public void saveTrainingExaminer(Integer paperId, Integer enterpriseId, String userIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(TrainingExaminer::getTrainingPaperId, (Object)paperId);
        this.trainingExaminerMapper.delete((Wrapper)wrapper);
        if (!org.springframework.util.StringUtils.isEmpty((Object)userIds)) {
            String[] userIdStrs = userIds.split(",");
            for (int i = 0; i < userIdStrs.length; ++i) {
                TrainingExaminer trainingExaminer = new TrainingExaminer();
                trainingExaminer.setTrainingPaperId(paperId);
                trainingExaminer.setEnterpriseId(enterpriseId);
                trainingExaminer.setUserId(Integer.valueOf(Integer.parseInt(userIdStrs[i])));
                this.trainingExaminerMapper.insert(trainingExaminer);
            }
        }
    }

    @Override
    public void saveTrainingPaperUser(Integer enterpriseId, Integer paperId, String userIds, Integer userId, String roles, String tags, String organizes) {
        TrainingPaperUser trainingPaperUser;
        int i;
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        wrapper1.eq(TrainingPaperUser::getPaperId, (Object)paperId);
        this.trainingPaperUserMapper.delete((Wrapper)wrapper1);
        if (!org.springframework.util.StringUtils.isEmpty((Object)userIds)) {
            String[] userIdStrs = userIds.split(",");
            for (i = 0; i < userIdStrs.length; ++i) {
                trainingPaperUser = new TrainingPaperUser();
                trainingPaperUser.setPaperId(paperId);
                trainingPaperUser.setUserId(Integer.valueOf(Integer.parseInt(userIdStrs[i])));
                trainingPaperUser.setEnterpriseId(enterpriseId);
                this.trainingPaperUserMapper.insert(trainingPaperUser);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)roles)) {
            String[] roleStrs = roles.split(",");
            for (i = 0; i < roleStrs.length; ++i) {
                trainingPaperUser = new TrainingPaperUser();
                trainingPaperUser.setPaperId(paperId);
                trainingPaperUser.setRoleId(Integer.valueOf(Integer.parseInt(roleStrs[i])));
                trainingPaperUser.setEnterpriseId(enterpriseId);
                this.trainingPaperUserMapper.insert(trainingPaperUser);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)tags)) {
            String[] tagStrs = tags.split(",");
            for (i = 0; i < tagStrs.length; ++i) {
                trainingPaperUser = new TrainingPaperUser();
                trainingPaperUser.setPaperId(paperId);
                trainingPaperUser.setTagId(Integer.valueOf(Integer.parseInt(tagStrs[i])));
                trainingPaperUser.setEnterpriseId(enterpriseId);
                this.trainingPaperUserMapper.insert(trainingPaperUser);
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)organizes)) {
            String[] organizeStrs = organizes.split(",");
            for (i = 0; i < organizeStrs.length; ++i) {
                trainingPaperUser = new TrainingPaperUser();
                trainingPaperUser.setPaperId(paperId);
                trainingPaperUser.setOrganizeId(organizeStrs[i]);
                trainingPaperUser.setEnterpriseId(enterpriseId);
                this.trainingPaperUserMapper.insert(trainingPaperUser);
            }
        }
    }

    @Override
    public Page<TrainingPaperVo> getMarkingPaperByPage(Page<TrainingPaperVo> page, String paperName, Integer enterpriseId, Integer userId, Integer status, String order) {
        List<Integer> userPaperIdList;
        List<Integer> paperIdList = this.trainingExaminerMapper.selectPapaerIdByUserId(userId);
        List<Object> paperList = new ArrayList();
        if (!CollectionUtils.isEmpty(paperIdList) && !CollectionUtils.isEmpty(userPaperIdList = this.userPaperMapper.selectIdGroupByPaperId(paperIdList, status))) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(!org.springframework.util.StringUtils.isEmpty((Object)enterpriseId), TrainingUserQuestion::getEnterpriseId, (Object)enterpriseId)).eq(TrainingUserQuestion::getQuestionType, (Object)1)).in(TrainingUserQuestion::getUserPaperId, userPaperIdList);
            List userQuestionList = this.userQuestionMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)userQuestionList) && !CollectionUtils.isEmpty(userPaperIdList = userQuestionList.stream().map(TrainingUserQuestion::getUserPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                paperList = this.paperMapper.selectVoByStatusByPage(page, paperName, enterpriseId, userPaperIdList, order, null, null);
                if (!(status != null && status != 0 || CollectionUtils.isEmpty(paperList))) {
                    for (TrainingPaperVo trainingPaperVo : paperList) {
                        List<TrainingUserPaper> userPaperList = this.userPaperMapper.selectByPaperStatus(trainingPaperVo.getPaperId(), 1);
                        if (!CollectionUtils.isEmpty(userPaperList)) {
                            trainingPaperVo.setUserStatus(Integer.valueOf(1));
                            continue;
                        }
                        trainingPaperVo.setUserStatus(Integer.valueOf(2));
                    }
                }
            }
        }
        page.setContent(paperList);
        return page;
    }

    @Override
    public Page<TrainingPaperVo> getUserMarkingPaperByPage(Page<TrainingPaperVo> page, Integer paperId, String userName, Integer enterpriseId, Integer status, String order) {
        BaseResult base;
        List<Integer> userIdList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName) && (base = this.userApi.getSimpleUserByKeyWord(enterpriseId, userName, null)) != null) {
            userIdList = ((List)base.getData()).stream().map(SimplePojo::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)userName) || !CollectionUtils.isEmpty(userIdList)) {
            List<TrainingPaperVo> paperList = this.paperMapper.selectVoByUserByPage(page, paperId, userIdList, enterpriseId, status, order);
            if (!CollectionUtils.isEmpty(paperList)) {
                List<Integer> userIds = paperList.stream().map(TrainingPaperVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIds);
                for (TrainingPaperVo paperVo : paperList) {
                    if (paperVo.getMarkingUserId() != null) {
                        paperVo.setUserStatus(Integer.valueOf(2));
                    } else {
                        paperVo.setUserStatus(Integer.valueOf(1));
                    }
                    UsersPojo pojo = usersPojoMap.get(paperVo.getUserId());
                    paperVo.setUserName(ObjectUtils.isEmpty((Object)pojo) ? "" : pojo.getShowName());
                }
            }
            page.setContent(paperList);
        }
        return page;
    }

    @Override
    public TrainingPapersVo getEssayQuestionByUserPaperId(Integer userPaperId) {
        TrainingPaperVo trainingPaperVo;
        UsersPojo usersPojo;
        TrainingPapersVo paperVo = new TrainingPapersVo();
        List<TrainingUserQuestion> questionList = this.userQuestionMapper.selectVoByUserPaperIdAndType(userPaperId, 1);
        if (!CollectionUtils.isEmpty(questionList)) {
            ArrayList<TrainingUserQuestionVo> userQuestionVoList = new ArrayList<TrainingUserQuestionVo>();
            Map<Object, Object> picMap = new HashMap();
            List userQuestionIdList = questionList.stream().map(TrainingUserQuestion::getId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                    picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                }
            }
            for (TrainingUserQuestion userQuestion : questionList) {
                TrainingUserQuestionVo userQuestionVo = new TrainingUserQuestionVo();
                BeanUtils.copyProperties((Object)userQuestion, (Object)userQuestionVo);
                List optionsList = new ArrayList();
                if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestionVo.getOptionsData())) {
                    optionsList = JSONObject.parseArray((String)userQuestionVo.getOptionsData(), TrainingOptionsVo.class);
                }
                userQuestionVo.setOptionsVoList(optionsList);
                userQuestionVo.setOptionsData(null);
                if (userQuestion.getQuestionType() == 1) {
                    List questionPictureList = (List)picMap.get(userQuestion.getId());
                    userQuestionVo.setUserQuestionPictureList(questionPictureList);
                }
                userQuestionVoList.add(userQuestionVo);
            }
            paperVo.setUserQuestionVoList(userQuestionVoList);
        }
        paperVo.setUserName(Objects.isNull(usersPojo = this.userUtilService.selectUser((trainingPaperVo = this.paperMapper.selectVoByPrimaryKey(userPaperId)).getUserId())) ? "" : usersPojo.getShowName());
        paperVo.setLoginShowName(trainingPaperVo.getLoginShowName());
        Double score = this.userQuestionMapper.selectScoreByUserPaperId(userPaperId, null);
        paperVo.setScore(new BigDecimal(score));
        return paperVo;
    }

    @Override
    public Page<TrainingQuestionVo> getQuestionBankByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, String questionName, Integer questionType, Integer questionClass, Integer isNotType, Integer materialId) {
        List<TrainingQuestionVo> questionList;
        if (org.springframework.util.StringUtils.isEmpty((Object)questionName)) {
            questionName = null;
        }
        if (!CollectionUtils.isEmpty(questionList = this.questionMapper.selectVoByPage(page, enterpriseId, questionName, questionType, questionClass, isNotType, materialId))) {
            BaseResult base;
            List userIdList = new ArrayList();
            List userIds = questionList.stream().map(TrainingQuestion::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List userIdss = questionList.stream().map(TrainingQuestion::getUpdater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                userIdList.addAll(userIds);
            }
            if (!CollectionUtils.isEmpty(userIdss)) {
                userIdList.addAll(userIdss);
            }
            Map<Object, Object> userMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList) && (base = this.userApi.getSimpleUserByIdList(userIdList = userIdList.stream().distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                userMap = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            }
            List typeIds = questionList.stream().map(TrainingQuestion::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> typeMap = new HashMap();
            if (!CollectionUtils.isEmpty(typeIds)) {
                List typeList = this.trainingQuestionTypeMapper.selectBatchIds(typeIds);
                typeMap = typeList.stream().collect(Collectors.toMap(TrainingQuestionType::getId, Function.identity()));
            }
            List<Integer> questionIds = questionList.stream().map(TrainingQuestion::getId).collect(Collectors.toList());
            List<TrainingOptionsVo> optionsVos = this.optionsMapper.selectOptionsByQuestionId(questionIds);
            Map<Object, Object> optionsMap = new HashMap();
            if (!CollectionUtils.isEmpty(optionsVos)) {
                optionsMap = optionsVos.stream().collect(Collectors.groupingBy(TrainingOptionsVo::getQuestionId));
            }
            for (TrainingQuestionVo questionVo : questionList) {
                ArrayList optionsVoList;
                if (questionVo.getTypeId() != null && !org.springframework.util.StringUtils.isEmpty((Object)typeMap.get(questionVo.getTypeId()))) {
                    questionVo.setTypeName(((TrainingQuestionType)typeMap.get(questionVo.getTypeId())).getTitle());
                }
                if (!CollectionUtils.isEmpty((Collection)(optionsVoList = (ArrayList)optionsMap.get(questionVo.getId()))) && questionVo.getQuestionType() == 1) {
                    Integer num = 0;
                    for (TrainingOptionsVo vo : optionsVoList) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)vo.getOptionsName())) continue;
                        num = 1;
                    }
                    if (num == 0) {
                        optionsVoList = new ArrayList();
                    }
                }
                questionVo.setOptionsList((List)optionsVoList);
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getCreater())) {
                    questionVo.setCreateName(org.springframework.util.StringUtils.isEmpty((Object)userMap.get(questionVo.getCreater())) ? "" : ((SimplePojo)userMap.get(questionVo.getCreater())).getName());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getUpdater())) {
                    questionVo.setUpdateName(org.springframework.util.StringUtils.isEmpty((Object)userMap.get(questionVo.getUpdater())) ? "" : ((SimplePojo)userMap.get(questionVo.getUpdater())).getName());
                }
                if (questionVo.getQuestionType() != 5) continue;
                LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
                attachWrapper.eq(TrainingOperateAttach::getTrainingQuestionId, (Object)questionVo.getId());
                List list = this.trainingOperateAttachMapper.selectList((Wrapper)attachWrapper);
                questionVo.setOperateAttachList(list);
            }
            page.setContent(questionList);
        }
        return page;
    }

    @Override
    public Page<TrainingQuestionVo> getQuestionBankListByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, String questionName, List<Integer> questionType, Integer questionClass, Integer isNotType) {
        List<TrainingQuestionVo> questionList;
        if (org.springframework.util.StringUtils.isEmpty((Object)questionName)) {
            questionName = null;
        }
        if (!CollectionUtils.isEmpty(questionList = this.questionMapper.selectQuestionVosByPage(page, enterpriseId, questionName, questionType, questionClass, isNotType))) {
            BaseResult base;
            List userIdList = new ArrayList();
            List userIds = questionList.stream().map(TrainingQuestion::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List userIdss = questionList.stream().map(TrainingQuestion::getUpdater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                userIdList.addAll(userIds);
            }
            if (!CollectionUtils.isEmpty(userIdss)) {
                userIdList.addAll(userIdss);
            }
            Map<Object, Object> userMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdList) && (base = this.userApi.getSimpleUserByIdList(userIdList = userIdList.stream().distinct().collect(Collectors.toList()))) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                userMap = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            }
            List typeIds = questionList.stream().map(TrainingQuestion::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> typeMap = new HashMap();
            if (!CollectionUtils.isEmpty(typeIds)) {
                List typeList = this.trainingQuestionTypeMapper.selectBatchIds(typeIds);
                typeMap = typeList.stream().collect(Collectors.toMap(TrainingQuestionType::getId, Function.identity()));
            }
            List<Integer> questionIds = questionList.stream().map(TrainingQuestion::getId).collect(Collectors.toList());
            List<TrainingOptionsVo> optionsVos = this.optionsMapper.selectOptionsByQuestionId(questionIds);
            Map<Object, Object> optionsMap = new HashMap();
            if (!CollectionUtils.isEmpty(optionsVos)) {
                optionsMap = optionsVos.stream().collect(Collectors.toMap(TrainingOptionsVo::getQuestionId, e -> new ArrayList<TrainingOptionsVo>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            for (TrainingQuestionVo questionVo : questionList) {
                ArrayList optionsVoList;
                if (questionVo.getTypeId() != null && !org.springframework.util.StringUtils.isEmpty((Object)typeMap.get(questionVo.getTypeId()))) {
                    questionVo.setTypeName(((TrainingQuestionType)typeMap.get(questionVo.getTypeId())).getTitle());
                }
                if (!CollectionUtils.isEmpty((Collection)(optionsVoList = (ArrayList)optionsMap.get(questionVo.getId()))) && questionVo.getQuestionType() == 1) {
                    Integer num = 0;
                    for (TrainingOptionsVo vo : optionsVoList) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)vo.getOptionsName())) continue;
                        num = 1;
                    }
                    if (num == 0) {
                        optionsVoList = new ArrayList();
                    }
                }
                questionVo.setOptionsList((List)optionsVoList);
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getCreater())) {
                    questionVo.setCreateName(org.springframework.util.StringUtils.isEmpty((Object)userMap.get(questionVo.getCreater())) ? "" : ((SimplePojo)userMap.get(questionVo.getCreater())).getName());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)questionVo.getUpdater())) {
                    questionVo.setUpdateName(org.springframework.util.StringUtils.isEmpty((Object)userMap.get(questionVo.getUpdater())) ? "" : ((SimplePojo)userMap.get(questionVo.getUpdater())).getName());
                }
                if (questionVo.getQuestionType() != 5) continue;
                LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
                attachWrapper.eq(TrainingOperateAttach::getTrainingQuestionId, (Object)questionVo.getId());
                List list = this.trainingOperateAttachMapper.selectList((Wrapper)attachWrapper);
                questionVo.setOperateAttachList(list);
            }
            page.setContent(questionList);
        }
        return page;
    }

    @Override
    public Page<TrainingPaperVo> getWebUserCenterByPage(Page<TrainingPaperVo> page, String paperName, Integer enterpriseId, String order, Date startDate, Date endDate) {
        List<TrainingPaperVo> paperList = this.userPaperMapper.selectUserCenterByPage(page, paperName, enterpriseId, order, startDate, endDate);
        page.setContent(paperList);
        return page;
    }

    @Override
    public Page<TrainingPaperVo> getWebUserCenterByPaperIdByPage(Page<TrainingPaperVo> page, String userName, Integer paperId, Integer enterpriseId, Integer order, Date startTime, Date endTime, Users user, String organizeIds) {
        try {
            List<Integer> userIds = this.organizeService.getUserListNew(user, organizeIds, null, userName, enterpriseId);
            if (!(!CollectionUtils.isEmpty(userIds) || org.springframework.util.StringUtils.isEmpty((Object)organizeIds) && org.springframework.util.StringUtils.isEmpty((Object)userName))) {
                return page;
            }
            Page page999 = new Page();
            page999.setPageSize(9999);
            page999.setPageNumber(1);
            List<TrainingPaperVo> paperList = this.paperMapper.selectUserCenterByPaperIdByPage((Page<TrainingPaperVo>)page999, paperId, userIds, enterpriseId, userName, order, startTime, endTime);
            List<TrainingPaperVo> paperListAll = this.paperMapper.selectUserCenterByPaperIdByPage((Page<TrainingPaperVo>)page999, paperId, userIds, enterpriseId, userName, order, null, null);
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            if (!CollectionUtils.isEmpty(paperListAll)) {
                for (TrainingPaperVo integer : paperListAll) {
                    userIdList.add(integer.getUserId());
                }
            }
            TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
            List<Object> levelUserIds = new ArrayList<Integer>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaper) && !org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getLookLevel()) && trainingPaper.getLookLevel() == 1) {
                levelUserIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
                if (!CollectionUtils.isEmpty(levelUserIds)) {
                    levelUserIds.retainAll(userIds);
                    if (!CollectionUtils.isEmpty(userIdList)) {
                        levelUserIds.removeAll(userIdList);
                    }
                }
            } else {
                levelUserIds.addAll(userIds);
                if (!CollectionUtils.isEmpty(userIdList)) {
                    levelUserIds.removeAll(userIdList);
                }
            }
            if (!CollectionUtils.isEmpty(levelUserIds) && startTime == null) {
                List pojoList = (List)this.userApi.getUserByIdList(levelUserIds).getData();
                for (UsersPojo usersPojo : pojoList) {
                    TrainingPaperVo tVo = new TrainingPaperVo();
                    tVo.setUserName(usersPojo.getShowName());
                    tVo.setUserId(usersPojo.getId());
                    paperList.add(tVo);
                }
            }
            List<TrainingPaperVo> newPage = ListUtil.page(paperList, page.getPageNumber(), page.getPageSize());
            ArrayList<UserOrganizeVo> userOrganizeVos = new ArrayList<UserOrganizeVo>();
            List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
            for (UserAndParentNameMo mo : userAndParentNameMos) {
                UserOrganizeVo vo = new UserOrganizeVo();
                vo.setOrganizeId(mo.getOrganizeId());
                vo.setOtype(mo.getOtype());
                vo.setOrganizeName(mo.getOrganizeName());
                vo.setGroupId(user.getGroupId());
                UsersPojo usersPojo = userMap.get(mo.getUserId());
                vo.setUserName(usersPojo.getShowName());
                vo.setUserId(mo.getUserId());
                userOrganizeVos.add(vo);
            }
            List<Integer> userIdLists = newPage.stream().map(TrainingPaperVo::getUserId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> trainingVoMap = this.userUtilService.selectUserMap(userIdLists);
            Map<Object, Object> userPaperMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIdLists)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId)).in(TrainingUserPaper::getUserId, userIdLists)).and(wq -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
                });
                List userPapers = this.userPaperMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)userPapers)) {
                    userPaperMap = userPapers.stream().collect(Collectors.toMap(TrainingUserPaper::getUserId, e -> new ArrayList<TrainingUserPaper>(Collections.singletonList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
            for (TrainingPaperVo trainingPaperVo : newPage) {
                trainingPaperVo.setDepName(this.userUtilService.selectUserOrganizeName(trainingPaper.getEnterpriseId(), Collections.singletonList(trainingPaperVo.getUserId())).get(trainingPaperVo.getUserId()));
                if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperVo.getUserId())) {
                    trainingPaperVo.setUserName(trainingVoMap.get(trainingPaperVo.getUserId()).getShowName());
                    trainingPaperVo.setEmployeeNumber(trainingVoMap.get(trainingPaperVo.getUserId()).getEmployeeNumber());
                }
                List userPaperList = (List)userPaperMap.get(trainingPaperVo.getUserId());
                int num = 0;
                if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                    num = userPaperList.size();
                }
                trainingPaperVo.setPaperCount(Integer.valueOf(num));
                if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperVo.getLoginShowName())) {
                    trainingPaperVo.setUserName(trainingPaperVo.getLoginShowName());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)trainingPaperVo.getLoginDepName())) {
                    trainingPaperVo.setDepName(trainingPaperVo.getLoginDepName());
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)trainingPaperVo.getLoginEmployeeNumber())) continue;
                trainingPaperVo.setEmployeeNumber(trainingPaperVo.getLoginEmployeeNumber());
            }
            page.setContent(newPage);
            page.setTotalCount(Long.valueOf(paperList.size()));
            return page;
        }
        catch (Exception e2) {
            log.error("", (Throwable)e2);
            return page;
        }
    }

    private void updatePaperScore(Integer paperId) {
        List<TrainingPaperQuestion> list = this.paperQuestionMapper.selectByPaperId(paperId);
        if (!CollectionUtils.isEmpty(list)) {
            for (TrainingPaperQuestion trainingPaperQuestion : list) {
                trainingPaperQuestion.setScore(new BigDecimal(100.0 / (double)list.size()).setScale(2, 4));
                this.paperQuestionMapper.updateByPrimaryKey(trainingPaperQuestion);
            }
        }
    }

    @Override
    public Page<TrainingPaperVo> getWebPaperByNameByPage(Page<TrainingPaperVo> page, String paperName, Integer groupId) {
        page.setContent(this.paperMapper.selectVoLikeNameByPage(page, paperName, groupId));
        return page;
    }

    @Override
    public void saveBankingQuestion(String ids, Integer paperId) {
        String[] questionIds = ids.split(",");
        for (int i = 0; i < questionIds.length; ++i) {
            TrainingPaperQuestion tpq = new TrainingPaperQuestion();
            tpq.setPaperId(paperId);
            tpq.setQuestionId(Integer.valueOf(Integer.parseInt(questionIds[i])));
            this.paperQuestionMapper.insertSelective(tpq);
        }
        this.updatePaperScore(paperId);
    }

    @Override
    public String randomPaper(TrainingPaperVo paperVo, Integer typeId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List questionList = paperVo.getQuestionList();
        for (TrainingQuestionVo questionVo : questionList) {
            List<TrainingQuestion> qList = this.questionMapper.selectByQuestionTypeSize(questionVo.getQuestionType(), paperVo.getEnterpriseId(), typeId);
            if ((questionVo.getQuestionSize() <= 0 || !CollectionUtils.isEmpty(qList)) && qList.size() >= questionVo.getQuestionSize()) continue;
            return JsonResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25!", (Object)this.messageSource.getMessage("training.question.type.not.content", null, locale));
        }
        TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
        TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andPaperIdEqualTo(paperVo.getPaperId());
        this.paperQuestionMapper.deleteByExample(example);
        for (TrainingQuestionVo questionVo : questionList) {
            List<TrainingQuestion> qList = this.questionMapper.selectRandByQuestionType(questionVo.getQuestionType(), paperVo.getEnterpriseId(), questionVo.getQuestionSize(), typeId);
            for (TrainingQuestion question : qList) {
                TrainingPaperQuestion pq = new TrainingPaperQuestion();
                pq.setPaperId(paperVo.getPaperId());
                pq.setQuestionId(question.getId());
                pq.setScore(new BigDecimal(questionVo.getScore()));
                this.paperQuestionMapper.insertSelective(pq);
            }
        }
        return JsonResult.success();
    }

    public String randomPaperByUser(TrainingPaperVo paperVo, Integer typeId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        List questionList = paperVo.getQuestionList();
        for (TrainingQuestionVo questionVo : questionList) {
            List<TrainingQuestion> qList = this.questionMapper.selectByQuestionTypeSize(questionVo.getQuestionType(), paperVo.getEnterpriseId(), typeId);
            if (!CollectionUtils.isEmpty(qList) && qList.size() >= questionVo.getQuestionSize()) continue;
            return JsonResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25!", (Object)this.messageSource.getMessage("training.question.type.not.content", null, locale));
        }
        TrainingPaperQuestionExample example = new TrainingPaperQuestionExample();
        TrainingPaperQuestionExample.Criteria criteria = example.createCriteria();
        criteria.andPaperIdEqualTo(paperVo.getPaperId());
        this.paperQuestionMapper.deleteByExample(example);
        for (TrainingQuestionVo questionVo : questionList) {
            List<TrainingQuestion> qList = this.questionMapper.selectRandByQuestionType(questionVo.getQuestionType(), paperVo.getEnterpriseId(), questionVo.getQuestionSize(), typeId);
            for (TrainingQuestion question : qList) {
                TrainingPaperQuestion pq = new TrainingPaperQuestion();
                pq.setPaperId(paperVo.getPaperId());
                pq.setQuestionId(question.getId());
                pq.setScore(new BigDecimal(questionVo.getScore()));
                this.paperQuestionMapper.insertSelective(pq);
            }
        }
        return JsonResult.success();
    }

    @Override
    public List<TrainingQuestionVo> getQuestionCount(Integer enterpriseId, String typeIds) {
        ArrayList<TrainingQuestionVo> trainingQuestionVos = new ArrayList<TrainingQuestionVo>();
        TrainingQuestionVo trainingQuestionVo = new TrainingQuestionVo();
        trainingQuestionVo.setQuestionType(Integer.valueOf(0));
        trainingQuestionVo.setQuestionSize(this.questionMapper.selectByQuestionTypeSizes(0, enterpriseId, StringsUtils.StringToList(typeIds, ",")).size());
        TrainingQuestionVo trainingQuestionVo1 = new TrainingQuestionVo();
        trainingQuestionVo1.setQuestionType(Integer.valueOf(1));
        trainingQuestionVo1.setQuestionSize(this.questionMapper.selectByQuestionTypeSizes(1, enterpriseId, StringsUtils.StringToList(typeIds, ",")).size());
        TrainingQuestionVo trainingQuestionVo2 = new TrainingQuestionVo();
        trainingQuestionVo2.setQuestionType(Integer.valueOf(2));
        trainingQuestionVo2.setQuestionSize(this.questionMapper.selectByQuestionTypeSizes(2, enterpriseId, StringsUtils.StringToList(typeIds, ",")).size());
        TrainingQuestionVo trainingQuestionVo3 = new TrainingQuestionVo();
        trainingQuestionVo3.setQuestionType(Integer.valueOf(3));
        trainingQuestionVo3.setQuestionSize(this.questionMapper.selectByQuestionTypeSizes(3, enterpriseId, StringsUtils.StringToList(typeIds, ",")).size());
        TrainingQuestionVo trainingQuestionVo4 = new TrainingQuestionVo();
        trainingQuestionVo4.setQuestionType(Integer.valueOf(4));
        trainingQuestionVo4.setQuestionSize(this.questionMapper.selectByQuestionTypeSizes(4, enterpriseId, StringsUtils.StringToList(typeIds, ",")).size());
        trainingQuestionVos.add(trainingQuestionVo);
        trainingQuestionVos.add(trainingQuestionVo1);
        trainingQuestionVos.add(trainingQuestionVo2);
        trainingQuestionVos.add(trainingQuestionVo3);
        trainingQuestionVos.add(trainingQuestionVo4);
        return trainingQuestionVos;
    }

    @Override
    public void updateProgress(Integer videoSize, Integer id, Integer trainingId, Integer userId) {
        UsersPojo users = this.userUtilService.selectUser(userId);
        TrainingUserProgress trainingUserProgress = this.trainingUserProgressMapper.selectByUserIdTrainingId(trainingId, userId);
        TrainingVideoSize trainingVideoSizes = this.trainingVideoSizeMapper.selectByUserId(userId);
        if (videoSize != null) {
            if (trainingVideoSizes != null) {
                Integer videoSizes = 0;
                if (trainingVideoSizes.getVideoTime() != null) {
                    videoSizes = trainingVideoSizes.getVideoTime();
                }
                trainingVideoSizes.setVideoTime(Integer.valueOf(videoSizes + videoSize));
                this.trainingVideoSizeMapper.updateByPrimaryKey(trainingVideoSizes);
            } else {
                trainingVideoSizes = new TrainingVideoSize();
                trainingVideoSizes.setEnterpriseId(users.getGroupId());
                trainingVideoSizes.setUserId(userId);
                trainingVideoSizes.setVideoTime(videoSize);
                this.trainingVideoSizeMapper.insert(trainingVideoSizes);
            }
        }
        if (trainingUserProgress == null) {
            Integer trainingAttachCount = 0;
            Integer trainingCount = 0;
            Integer trainingVideoSize = 0;
            List<TrainingAttach> trainingAttach = this.trainingAttachMapper.selectByTrainingId(trainingId);
            List<TrainingVideo> trainingVideo = this.trainingVideoMapper.selectByTrainingId(trainingId);
            StringBuffer sb = new StringBuffer();
            if (trainingAttach != null) {
                trainingAttachCount = trainingAttach.size();
                if (trainingAttach.size() > 0) {
                    for (TrainingAttach trainingAttach2 : trainingAttach) {
                        sb.append(trainingAttach2.getId()).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
            if (trainingVideo != null) {
                trainingCount = trainingAttachCount + trainingVideo.size();
                if (trainingVideo.size() > 0) {
                    for (TrainingVideo trainingVideo2 : trainingVideo) {
                        if (trainingVideo2.getDuration() == null) continue;
                        trainingVideoSize = trainingVideoSize + trainingVideo2.getDuration();
                    }
                }
            }
            trainingUserProgress = new TrainingUserProgress();
            trainingUserProgress.setCreateTime(new Date());
            trainingUserProgress.setEnterpriseId(users.getGroupId());
            trainingUserProgress.setTrainingAttachCount(trainingAttachCount);
            trainingUserProgress.setTrainingCount(trainingCount);
            trainingUserProgress.setTrainingId(trainingId);
            if (videoSize == null) {
                trainingUserProgress.setTrainingUserVideoSize(Integer.valueOf(0));
            } else {
                trainingUserProgress.setTrainingUserVideoSize(videoSize);
            }
            trainingUserProgress.setUserId(userId);
            trainingUserProgress.setTrainingVideoSize(trainingVideoSize);
            if (sb.length() > 0) {
                trainingUserProgress.setTrainingAttachIds(sb.toString());
            }
            Integer videoCount = trainingCount - trainingAttachCount;
            if (videoSize == null) {
                Integer n = (int)(1.0 / (double)trainingCount.intValue() * 100.0);
                trainingUserProgress.setTrainingProgress(n);
                String ids = trainingUserProgress.getTrainingAttachIds();
                if (!org.springframework.util.StringUtils.isEmpty((Object)ids)) {
                    String[] idss = ids.split(",");
                    String idsss = "";
                    if (idss[0].equals(id.toString())) {
                        if (idss.length > 1) {
                            idsss = ids.replace(idss[0] + ",", "");
                        } else if (idss.length == 1) {
                            idsss = null;
                        }
                    } else {
                        idsss = idss[idss.length - 1].equals(id.toString()) ? ids.replace("," + idss[idss.length - 1], "") : ids.replace("," + id + ",", ",");
                    }
                    trainingUserProgress.setTrainingAttachIds(idsss);
                }
            } else if (videoCount > 0 && trainingVideoSize > 0) {
                if (videoSize > trainingVideoSize) {
                    videoSize = trainingVideoSize;
                }
                Integer n = (int)((double)videoCount.intValue() / (double)trainingCount.intValue() * ((double)videoSize.intValue() / (double)trainingVideoSize.intValue()) * 100.0);
                trainingUserProgress.setTrainingProgress(n);
            } else {
                trainingUserProgress.setTrainingProgress(Integer.valueOf(0));
            }
            trainingUserProgress.setUpdateTime(new Date());
            this.trainingUserProgressMapper.insert(trainingUserProgress);
        } else if (videoSize != null) {
            Integer size = trainingUserProgress.getTrainingUserVideoSize() + videoSize;
            if (trainingUserProgress.getTrainingUserVideoSize() + videoSize > trainingUserProgress.getTrainingVideoSize()) {
                size = trainingUserProgress.getTrainingVideoSize();
            }
            trainingUserProgress.setTrainingUserVideoSize(size);
            trainingUserProgress.setUpdateTime(new Date());
            Integer videoCount = trainingUserProgress.getTrainingCount() - trainingUserProgress.getTrainingAttachCount();
            if (videoCount > 0) {
                Integer progress = 0;
                if (trainingUserProgress.getTrainingAttachCount() > 0) {
                    int trainingAttachIds = 0;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingUserProgress.getTrainingAttachIds())) {
                        trainingAttachIds = trainingUserProgress.getTrainingAttachIds().split(",").length;
                    }
                    progress = (int)(((double)videoCount.intValue() / (double)trainingUserProgress.getTrainingCount().intValue() * ((double)trainingUserProgress.getTrainingUserVideoSize().intValue() / (double)trainingUserProgress.getTrainingVideoSize().intValue()) + (double)(trainingUserProgress.getTrainingAttachCount() - trainingAttachIds) / (double)trainingUserProgress.getTrainingCount().intValue()) * 100.0);
                } else {
                    progress = (int)((double)videoCount.intValue() / (double)trainingUserProgress.getTrainingCount().intValue() * ((double)trainingUserProgress.getTrainingUserVideoSize().intValue() / (double)trainingUserProgress.getTrainingVideoSize().intValue()) * 100.0);
                }
                trainingUserProgress.setTrainingProgress(progress);
            }
            trainingUserProgress.setUpdateTime(new Date());
            this.trainingUserProgressMapper.updateByPrimaryKey(trainingUserProgress);
        } else {
            trainingUserProgress.setUpdateTime(new Date());
            String ids = trainingUserProgress.getTrainingAttachIds();
            if (!org.springframework.util.StringUtils.isEmpty((Object)trainingUserProgress.getTrainingAttachIds())) {
                String[] idss = ids.split(",");
                String idsss = "";
                Integer idsLenth = 0;
                if (ids.length() > 2 && idss.length > 1) {
                    idsss = idss[0].equals(id.toString()) ? ids.replace(idss[0] + ",", "") : (idss[idss.length - 1].equals(id.toString()) ? ids.replace("," + idss[idss.length - 1], "") : ids.replace("," + id + ",", ","));
                    idsLenth = idsss.split(",").length;
                } else if (ids.length() > 0 && idss.length == 1) {
                    if (idss[0].equals(id.toString())) {
                        idsss = null;
                        idsLenth = 0;
                    } else {
                        idsss = ids;
                        idsLenth = idss.length;
                    }
                }
                trainingUserProgress.setTrainingAttachIds(idsss);
                Integer videoCount = trainingUserProgress.getTrainingCount() - trainingUserProgress.getTrainingAttachCount();
                Integer progress = 0;
                progress = trainingUserProgress.getTrainingUserVideoSize() != null && trainingUserProgress.getTrainingUserVideoSize() > 0 ? Integer.valueOf((int)(((double)videoCount.intValue() / (double)trainingUserProgress.getTrainingCount().intValue() * ((double)trainingUserProgress.getTrainingUserVideoSize().intValue() / (double)trainingUserProgress.getTrainingVideoSize().intValue()) + (double)(trainingUserProgress.getTrainingAttachCount() - idsLenth) / (double)trainingUserProgress.getTrainingCount().intValue()) * 100.0)) : Integer.valueOf((int)((double)(trainingUserProgress.getTrainingAttachCount() - idsLenth) / (double)trainingUserProgress.getTrainingCount().intValue() * 100.0));
                trainingUserProgress.setTrainingProgress(progress);
                this.trainingUserProgressMapper.updateByPrimaryKey(trainingUserProgress);
            }
        }
    }

    @Override
    public TrainingUserProgress getUserProgressNew(Integer userId, Integer trainingId) {
        TrainingUserProgress trainingUserProgress = new TrainingUserProgress();
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)training)) {
            List<TrainingAttach> trainingChapterAttachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
            List<TrainingVideo> trainingChapterVideos = this.trainingVideoMapper.selectByTrainingId(trainingId);
            int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
            int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
            int allSize = attachSize + videoSize;
            int videoAllSize = 0;
            if (videoSize > 0) {
                for (TrainingVideo trainingVideo : trainingChapterVideos) {
                    Integer duration = 0;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)trainingVideo) && !org.springframework.util.StringUtils.isEmpty((Object)trainingVideo.getDuration())) {
                        duration = trainingVideo.getDuration();
                    }
                    videoAllSize += duration.intValue();
                }
            }
            trainingUserProgress.setIsPaper(Integer.valueOf(training.getPaperId() == null ? 0 : 1));
            trainingUserProgress.setTrainingProgress(Integer.valueOf(0));
            List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, trainingId, null, null);
            if (allSize == 0 || CollectionUtils.isEmpty(trainingAttachUsers)) {
                return trainingUserProgress;
            }
            int finishAttach = 0;
            int finishVideo = 0;
            for (TrainingAttachUser trainingAttachUser : trainingAttachUsers) {
                if (trainingAttachUser != null && trainingAttachUser.getIsVideo() == 1 && trainingAttachUser.getPlaySize() != null) {
                    finishVideo += trainingAttachUser.getPlaySize().intValue();
                    continue;
                }
                if (trainingAttachUser == null || trainingAttachUser.getIsVideo() != 0) continue;
                ++finishAttach;
            }
            int userProgress = 0;
            if (videoSize > 0) {
                int progre = videoAllSize > 0 && finishVideo < videoAllSize ? videoSize * finishVideo * 100 / videoAllSize / allSize : videoSize * 100 / allSize;
                userProgress = finishAttach * 100 / allSize + progre;
            } else {
                userProgress = finishAttach * 100 / allSize;
            }
            trainingUserProgress.setTrainingProgress(Integer.valueOf(userProgress == 99 ? 100 : userProgress));
        }
        return trainingUserProgress;
    }

    @Override
    public TrainingUserViewTimeVo getVideoTotalTime(Integer userId, Integer enterpriseId) {
        TrainingUserViewTimeVo userViewTimeVo = new TrainingUserViewTimeVo();
        if (enterpriseId != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingUserView::getEnterpriseId, (Object)enterpriseId);
            wrapper.orderByDesc(TrainingUserView::getViewTimes);
            List userViewList = this.trainingUserViewMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)userViewList)) {
                for (int i = 0; i < userViewList.size(); ++i) {
                    if (!((TrainingUserView)userViewList.get(i)).getUserId().equals(userId)) continue;
                    TrainingUserView userView = (TrainingUserView)userViewList.get(i);
                    userViewTimeVo.setUserId(userId);
                    userViewTimeVo.setViewTimes(userView.getViewTimes());
                    userViewTimeVo.setRanking(Integer.valueOf(i + 1));
                    break;
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)userViewTimeVo) && !org.springframework.util.StringUtils.isEmpty((Object)userViewTimeVo.getViewTimes())) {
                userViewTimeVo.setReadHour(new BigDecimal(userViewTimeVo.getViewTimes()).divide(new BigDecimal("3600"), 2, 4));
            }
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingCertificateDetail::getUserId, (Object)userId)).eq(TrainingCertificateDetail::getIsShow, (Object)1);
        List list = this.certificateDetailMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            userViewTimeVo.setCertificateCount(Integer.valueOf(list.size()));
        } else {
            userViewTimeVo.setCertificateCount(Integer.valueOf(0));
        }
        return userViewTimeVo;
    }

    @Override
    public TrainingUserProgress getTotalVideoTime(Integer trainingId) {
        Integer trainingAttachCount = 0;
        Integer trainingCount = 0;
        Integer trainingVideoSize = 0;
        List<TrainingAttach> trainingAttach = this.trainingAttachMapper.selectByTrainingId(trainingId);
        List<TrainingVideo> trainingVideo = this.trainingVideoMapper.selectByTrainingId(trainingId);
        StringBuffer sb = new StringBuffer();
        if (trainingAttach != null) {
            trainingAttachCount = trainingAttach.size();
            if (trainingAttach.size() > 0) {
                for (TrainingAttach trainingAttach2 : trainingAttach) {
                    sb.append(trainingAttach2.getId()).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        if (trainingVideo != null) {
            trainingCount = trainingAttachCount + trainingVideo.size();
            if (trainingVideo.size() > 0) {
                for (TrainingVideo trainingVideo2 : trainingVideo) {
                    if (trainingVideo2.getDuration() == null) continue;
                    trainingVideoSize = trainingVideoSize + trainingVideo2.getDuration();
                }
            }
        }
        TrainingUserProgress trainingUserProgress = new TrainingUserProgress();
        trainingUserProgress.setCreateTime(new Date());
        trainingUserProgress.setTrainingAttachCount(trainingAttachCount);
        trainingUserProgress.setTrainingCount(trainingCount);
        trainingUserProgress.setTrainingId(trainingId);
        trainingUserProgress.setTrainingUserVideoSize(Integer.valueOf(0));
        trainingUserProgress.setTrainingVideoSize(trainingVideoSize);
        trainingUserProgress.setTrainingProgress(Integer.valueOf(0));
        if (sb.length() > 0) {
            trainingUserProgress.setTrainingAttachIds(sb.toString());
        }
        return trainingUserProgress;
    }

    @Override
    public TrainingPaperVo getMobileQuestionListIsPass(Integer paperId, Integer groupId, Integer userId) {
        TrainingPaperVo result = new TrainingPaperVo();
        List<TrainingUserPaper> list = this.userPaperMapper.selectByUserIdAndPaperId(userId, paperId);
        Integer userPaperId = null;
        if (!CollectionUtils.isEmpty(list)) {
            userPaperId = list.get(0).getId();
        }
        List<TrainingUserQuestion> userQuestionList = this.userQuestionMapper.selectByUserPaperId(userPaperId, null);
        ArrayList<TrainingQuestionVo> questionList = new ArrayList<TrainingQuestionVo>();
        for (TrainingUserQuestion questionVo : userQuestionList) {
            TrainingQuestion trainingQuestion;
            TrainingQuestionVo question = new TrainingQuestionVo();
            question.setId(questionVo.getQuestionId());
            question.setQuestionName(questionVo.getName());
            question.setQuestionType(questionVo.getQuestionType());
            question.setRemark(questionVo.getRemark());
            if (questionVo.getIsEmpty() != null && questionVo.getIsEmpty() == 1) {
                question.setIsCorrect(Integer.valueOf(2));
            } else {
                question.setIsCorrect(questionVo.getIsCorrect());
            }
            question.setScore(Double.valueOf(questionVo.getScore().doubleValue()));
            question.setOriginScore(Double.valueOf(questionVo.getOriginScore().doubleValue()));
            if (questionVo.getQuestionType() == 4 && (trainingQuestion = (TrainingQuestion)this.questionMapper.selectById(questionVo.getQuestionId())) != null) {
                question.setAnswer(trainingQuestion.getIsCorrect());
            }
            this.setRightAnswer(question);
            question.setOptionsList(JSONArray.parseArray((String)questionVo.getOptionsData(), TrainingOptionsVo.class));
            questionList.add(question);
        }
        result.setQuestionList(questionList);
        return result;
    }

    private void setRightAnswer(TrainingQuestionVo question) {
        if (question.getIsCorrect() != null && question.getAnswer() != null) {
            if (question.getIsCorrect() == 1) {
                if (question.getAnswer() == 0) {
                    question.setRightAnswer(Integer.valueOf(1));
                } else {
                    question.setRightAnswer(Integer.valueOf(0));
                }
            } else if (question.getAnswer() == 0) {
                question.setRightAnswer(Integer.valueOf(0));
            } else {
                question.setRightAnswer(Integer.valueOf(1));
            }
        }
    }

    @Override
    public TrainingPaper getTrainingPaper(Integer paperId) {
        return (TrainingPaper)this.paperMapper.selectById(paperId);
    }

    @Override
    public TrainingQuestionType addQuestionType(TrainingQuestionType trainingQuestionType) {
        if (trainingQuestionType.getId() != null) {
            this.trainingQuestionTypeMapper.updateByPrimaryKey(trainingQuestionType);
        } else {
            trainingQuestionType.setCreateTime(new Date());
            this.trainingQuestionTypeMapper.insert(trainingQuestionType);
        }
        return trainingQuestionType;
    }

    @Override
    public List<TrainingQuestionTypeVo> getQuestionType(Integer enterpriseId, String typeName, Integer materialId) {
        BaseResult base;
        List userIds;
        List<TrainingQuestionTypeVo> list = this.trainingQuestionTypeMapper.selectByEnterpriseId(enterpriseId, typeName, materialId);
        if (!(CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(userIds = list.stream().map(TrainingQuestionType::getCreater).distinct().collect(Collectors.toList())) || (base = this.userApi.getSimpleUserByIdList(userIds)) == null || CollectionUtils.isEmpty((Collection)((Collection)base.getData())))) {
            Map map = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
            Iterator<TrainingQuestionTypeVo> iterator = list.iterator();
            while (iterator.hasNext()) {
                TrainingQuestionTypeVo vo;
                SimplePojo pojo = (SimplePojo)map.get((vo = iterator.next()).getCreater());
                vo.setCreateName(org.springframework.util.StringUtils.isEmpty((Object)pojo) ? "" : pojo.getName());
            }
        }
        return list;
    }

    @Override
    public String delQuestionType(Integer id, LogPojo pojo) {
        TrainingQuestionType questionType = (TrainingQuestionType)this.trainingQuestionTypeMapper.selectById(id);
        if (ObjectUtils.isEmpty((Object)questionType) || questionType.getEnterpeiseId() == null) {
            return JsonResult.error();
        }
        if (!pojo.getEnterpriseId().equals(questionType.getEnterpeiseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.trainingQuestionTypeMapper.deleteByPrimaryKey(id);
        pojo.setI18nParam(questionType.getTitle());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public List<TrainingQuestion> getQuestionByType(Integer type, Integer enterpriseId) {
        return this.questionMapper.selectByQuestionType(type, enterpriseId);
    }

    @Override
    public List<TrainingQuestionType> getQuestionTypeByTitile(String title, Integer enterpriseId) {
        return this.trainingQuestionTypeMapper.selectByTitle(title, enterpriseId);
    }

    @Override
    public Page<TrainingPaperVo> selectPapersByuserIdByPage(Page<TrainingPaperVo> page, Integer userId, Date startTime, Date endTime, Integer enterpriseId) {
        List<TrainingPaperVo> trainingPaperVo = this.userPaperMapper.selectPapersByuserIdByPage(page, userId, startTime, endTime, enterpriseId);
        if (!CollectionUtils.isEmpty(trainingPaperVo)) {
            for (TrainingPaperVo trainingPaperVo2 : trainingPaperVo) {
                if (trainingPaperVo2.getId() == null) continue;
                trainingPaperVo2.setRanking(Integer.valueOf(this.userPaperMapper.selectByPaperIdRankingDetail(trainingPaperVo2.getPaperId(), trainingPaperVo2.getScore(), null) + 1));
            }
        }
        page.setContent(trainingPaperVo);
        return page;
    }

    @Override
    public Map<String, List<TrainingQuestionVo>> getErrorQuestionListByIdExcel(String userPaperIds, Integer status, Locale locale, Integer paperId, Users users, String organizeIds, Date startTime, Date endTime, String userName) {
        LinkedHashMap<String, List<TrainingQuestionVo>> map = new LinkedHashMap<String, List<TrainingQuestionVo>>();
        ArrayList<Integer> userPaperIdList = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userPaperIds)) {
            for (String userPaperId : userPaperIds.split(",")) {
                userPaperIdList.add(Integer.parseInt(userPaperId));
            }
        } else if (!org.springframework.util.StringUtils.isEmpty((Object)paperId)) {
            Page page = new Page();
            page.setPageSize(10000);
            page.setPageNumber(1);
            Page<TrainingPaperVo> paperPage = this.getWebUserCenterByPaperIdByPage((Page<TrainingPaperVo>)page, userName, paperId, null, null, startTime, endTime, users, organizeIds);
            if (!CollectionUtils.isEmpty((Collection)paperPage.getContent())) {
                for (TrainingPaperVo trainingUserPaper : paperPage.getContent()) {
                    if (trainingUserPaper.getScore() == null) continue;
                    userPaperIdList.add(trainingUserPaper.getId());
                }
            }
        }
        List trainingUserPaperList = new ArrayList();
        Map<Object, Object> pojoMap = new HashMap();
        ArrayList<Integer> userIds = new ArrayList();
        if (!CollectionUtils.isEmpty(userPaperIdList)) {
            trainingUserPaperList = this.userPaperMapper.selectBatchIds(userPaperIdList);
            userIds = trainingUserPaperList.stream().map(TrainingUserPaper::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pojoMap = this.userUtilService.selectUserMap(userIds);
        }
        ArrayList<UserOrganizeVo> userOrganizeVos = new ArrayList<UserOrganizeVo>();
        List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(users.getGroupId(), userIds).getData();
        Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
        for (UserAndParentNameMo mo : userAndParentNameMos) {
            UserOrganizeVo vo = new UserOrganizeVo();
            vo.setOrganizeId(mo.getOrganizeId());
            vo.setOtype(mo.getOtype());
            vo.setOrganizeName(mo.getOrganizeName());
            vo.setGroupId(users.getGroupId());
            UsersPojo usersPojo = userMap.get(mo.getUserId());
            vo.setUserName(usersPojo.getShowName());
            vo.setUserId(mo.getUserId());
            userOrganizeVos.add(vo);
        }
        List<TrainingUserQuestion> trainingUserQuestions = this.userQuestionMapper.selectAllByPaperId(paperId);
        Map<Object, Object> picMap = new HashMap();
        ArrayList<Integer> userQuestionIdList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(trainingUserQuestions)) {
            for (TrainingUserQuestion userQuestion : trainingUserQuestions) {
                if (userQuestion.getQuestionType() != 1) continue;
                userQuestionIdList.add(userQuestion.getId());
            }
            if (!CollectionUtils.isEmpty(userQuestionIdList)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                    picMap = userQuestionPictures.stream().collect(Collectors.toMap(TrainingUserQuestionPicture::getUserQuestionId, e -> new ArrayList<TrainingUserQuestionPicture>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                }
            }
        }
        String scoreLocal = this.messageSource.getMessage("training.ranking.score", null, locale);
        String name = this.messageSource.getMessage("training.ranking.name", null, locale);
        String Department = this.messageSource.getMessage("Department", null, locale);
        String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
        String paperTime = this.messageSource.getMessage("training.user.details.paperTime", null, locale);
        for (TrainingUserPaper trainingUserPaper : trainingUserPaperList) {
            ArrayList<TrainingQuestionVo> result = new ArrayList<TrainingQuestionVo>();
            ArrayList<TrainingUserQuestion> userQuestionList = new ArrayList<TrainingUserQuestion>();
            for (TrainingUserQuestion TrainingUserQuestion2 : trainingUserQuestions) {
                if (TrainingUserQuestion2.getUserPaperId().intValue() != trainingUserPaper.getId().intValue() || status != null && TrainingUserQuestion2.getIsCorrect().intValue() != status.intValue()) continue;
                userQuestionList.add(TrainingUserQuestion2);
            }
            String userNameNew = "\t";
            String depName = "   ";
            String userEmployeeNumber = "   ";
            if (!CollectionUtils.isEmpty(userQuestionList)) {
                UsersPojo pojo;
                for (TrainingUserQuestion userQuestion : userQuestionList) {
                    TrainingQuestionVo questionVo = new TrainingQuestionVo();
                    questionVo.setId(userQuestion.getId());
                    questionVo.setQuestionName(userQuestion.getName());
                    questionVo.setQuestionType(userQuestion.getQuestionType());
                    questionVo.setIsCorrect(userQuestion.getIsCorrect());
                    questionVo.setScore(Double.valueOf(userQuestion.getScore().doubleValue()));
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userQuestion.getRemark())) {
                        questionVo.setRemark(userQuestion.getRemark());
                    }
                    List optionsList = JSONObject.parseArray((String)userQuestion.getOptionsData(), TrainingOptionsVo.class);
                    questionVo.setOptionsList(optionsList);
                    questionVo.setUserQuestionPictureList((List)picMap.get(userQuestion.getId()));
                    result.add(questionVo);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)trainingUserPaper) && !org.springframework.util.StringUtils.isEmpty((Object)trainingUserPaper.getLoginShowName())) {
                    userNameNew = trainingUserPaper.getLoginShowName();
                    if (trainingUserPaper.getLoginDepName() != null) {
                        depName = trainingUserPaper.getLoginDepName();
                    }
                    if (trainingUserPaper.getLoginEmployeeNumber() != null) {
                        userEmployeeNumber = trainingUserPaper.getLoginEmployeeNumber();
                    }
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)trainingUserPaper.getUserId()) && !org.springframework.util.StringUtils.isEmpty((Object)(pojo = (UsersPojo)pojoMap.get(trainingUserPaper.getUserId())))) {
                    userNameNew = pojo.getShowName();
                    userEmployeeNumber = pojo.getEmployeeNumber();
                    depName = this.userUtilService.selectUserOrganizeName(trainingUserPaper.getEnterpriseId(), Collections.singletonList(trainingUserPaper.getUserId())).get(trainingUserPaper.getUserId());
                }
            }
            map.put(name + "\uff1a" + userNameNew + "," + scoreLocal + "\uff1a" + trainingUserPaper.getScore() + "," + Department + ": " + depName + "," + employeeNumber + ": " + userEmployeeNumber + "," + paperTime + ": " + DateUtils.format(trainingUserPaper.getUpdateTime(), DateUtils.FORMAT_LONG), result);
        }
        return map;
    }

    @Override
    public TrainingPaperCompletionRateVo getUserPaperNum(String treeId, Integer paperId, Users user, String userName, Date startTime, Date endTime, Integer taskId) {
        TrainingPaperCompletionRateVo paperCompletionRateVo = new TrainingPaperCompletionRateVo();
        String depName = "";
        List<Integer> userIds = this.organizeService.getUserListNew(user, treeId, null, userName, user.getGroupId());
        List<Integer> taskUserIds = null;
        if (taskId != null) {
            taskUserIds = this.trainingTaskUserMapper.selectUserIdByByTaskId(taskId);
        }
        if (!CollectionUtils.isEmpty(taskUserIds)) {
            userIds.retainAll(taskUserIds);
        }
        int needPaper = 0;
        int isPaper = 0;
        double avgScore = 0.0;
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!(ObjectUtils.isEmpty((Object)paper) || org.springframework.util.StringUtils.isEmpty((Object)paper.getLookLevel()) || paper.getLookLevel() != 1 || CollectionUtils.isEmpty(userIds))) {
            List<Integer> whoCanSeeList = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
            userIds.retainAll(whoCanSeeList);
        }
        if (CollectionUtils.isEmpty(userIds)) {
            paperCompletionRateVo.setAvgScore(Integer.valueOf(0));
            paperCompletionRateVo.setDepName(depName);
            paperCompletionRateVo.setFinishNum(Integer.valueOf(0));
            paperCompletionRateVo.setTotalNum(Integer.valueOf(0));
            return paperCompletionRateVo;
        }
        needPaper = userIds.size();
        Map<Object, Object> trainingUserPaperMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIds)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(paperId != null, TrainingUserPaper::getTrainingPaperId, (Object)paperId)).in(TrainingUserPaper::getUserId, userIds)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.isNull(TrainingUserPaper::getSourceType)).or()).eq(TrainingUserPaper::getSourceType, (Object)2);
            })).eq(TrainingUserPaper::getPaperStatus, (Object)2)).orderByDesc(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.userPaperMapper.selectList((Wrapper)queryWrapper);
            trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
        }
        for (int userId : userIds) {
            List trainingUserPapers = (List)trainingUserPaperMap.get(userId);
            if (CollectionUtils.isEmpty((Collection)trainingUserPapers)) continue;
            ++isPaper;
            TrainingUserPaper trainingUserPaper = !ObjectUtils.isEmpty((Object)paper) && (ObjectUtils.isEmpty((Object)paper.getScoreSelect()) || !ObjectUtils.isEmpty((Object)paper.getScoreSelect()) && paper.getScoreSelect().equals(0)) ? (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore, Comparator.nullsFirst(BigDecimal::compareTo)).reversed()).collect(Collectors.toList()).get(0) : (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getUpdateTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList()).get(0);
            avgScore += trainingUserPaper.getScore().doubleValue();
        }
        paperCompletionRateVo.setAvgScore(Integer.valueOf(isPaper > 0 ? (int)(avgScore / (double)isPaper) : 0));
        paperCompletionRateVo.setDepName(depName);
        paperCompletionRateVo.setFinishNum(Integer.valueOf(isPaper));
        paperCompletionRateVo.setTotalNum(Integer.valueOf(needPaper));
        return paperCompletionRateVo;
    }

    @Override
    public Page<TrainingPaperRankingUserVo> getUserPaperByOrganizeDetail(Page<TrainingPaperRankingUserVo> page, String treeId, Integer paperId, Users user, Integer enterpriseId) {
        List<Integer> userIdsByTreeId = this.organizeService.getUserListNew(user, treeId, null, null, enterpriseId);
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (paper != null && paper.getLookLevel() != null && paper.getLookLevel() == 1) {
            List<Integer> userIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
            userIdsByTreeId.retainAll(userIds);
        }
        ArrayList<TrainingPaperRankingUserVo> trainingPaperRankingUserVos = new ArrayList<TrainingPaperRankingUserVo>();
        Map<Object, Object> trainingUserPaperMap = new HashMap();
        if (!CollectionUtils.isEmpty(userIdsByTreeId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(paperId != null, TrainingUserPaper::getTrainingPaperId, (Object)paperId)).in(TrainingUserPaper::getUserId, userIdsByTreeId)).eq(TrainingUserPaper::getSourceType, (Object)2)).eq(TrainingUserPaper::getPaperStatus, (Object)2)).orderByDesc(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.userPaperMapper.selectList((Wrapper)queryWrapper);
            trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdsByTreeId);
            for (int userId : userIdsByTreeId) {
                UsersPojo usersPojo;
                TrainingPaperRankingUserVo vo = new TrainingPaperRankingUserVo();
                List trainingUserPapers = (List)trainingUserPaperMap.get(userId);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPapers)) {
                    TrainingUserPaper trainingUserPaper = Objects.isNull(paper.getScoreSelect()) || Objects.nonNull(paper.getScoreSelect()) && paper.getScoreSelect().equals(0) ? (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore, Comparator.nullsFirst(BigDecimal::compareTo)).reversed()).collect(Collectors.toList()).get(0) : (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getUpdateTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList()).get(0);
                    vo.setId(trainingUserPaper.getId());
                    vo.setScore(Double.valueOf(trainingUserPaper.getScore().doubleValue()));
                    vo.setPaperTime(trainingUserPaper.getUpdateTime());
                }
                if (Objects.nonNull(usersPojo = usersPojoMap.get(userId))) {
                    vo.setUserName(usersPojo.getShowName());
                    vo.setEmployeeNumber(usersPojo.getEmployeeNumber());
                } else {
                    vo.setUserName("");
                    vo.setEmployeeNumber("");
                }
                trainingPaperRankingUserVos.add(vo);
            }
        }
        page = ListUtil.myPage(trainingPaperRankingUserVos, page.getPageNumber(), page.getPageSize());
        return page;
    }

    @Override
    public Integer getQuestionDoCount(Integer questionId) {
        return this.userPaperMapper.getQuestionDoCount(questionId);
    }

    @Override
    public Integer getPaperDoCount(Integer paperId) {
        return this.userPaperMapper.getPaperDoCount(paperId);
    }

    @Override
    public Page<Map<String, Object>> getVisitorByPage(Page<Map<String, Object>> page, Integer enterpriseId, Integer paperId) {
        List<Map<String, Object>> userPapers = this.userPaperMapper.selectByVisitorNewByPage(page, enterpriseId, paperId);
        page.setContent(userPapers);
        return page;
    }

    @Override
    public List<Map<String, Object>> exportVisitorPaper(Integer enterpriseId, Integer paperId) {
        Page page = new Page();
        page.setPageSize(9999);
        page.setPageNumber(1);
        return this.userPaperMapper.selectByVisitorNewByPage((Page<Map<String, Object>>)page, enterpriseId, paperId);
    }

    @Override
    public List<TrainingPaperRankingUserVo> getUserPaperByOrganizeDetailExcel(String treeId, Integer paperId, Users user) {
        Users users = Authenticator.getInstance().getCurrentUser();
        ArrayList<TrainingPaperRankingUserVo> result = new ArrayList<TrainingPaperRankingUserVo>();
        if (org.springframework.util.StringUtils.isEmpty((Object)treeId)) {
            return result;
        }
        List<Integer> userIdsByTreeId = this.organizeService.getUserListNew(user, treeId, null, null, user.getGroupId());
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (paper != null && paper.getLookLevel() != null && paper.getLookLevel() == 1) {
            List<Integer> userIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
            userIdsByTreeId.retainAll(userIds);
        }
        ArrayList<TrainingPaperRankingUserVo> trainingPaperRankingUserVos = new ArrayList<TrainingPaperRankingUserVo>();
        if (!CollectionUtils.isEmpty(userIdsByTreeId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(paperId != null, TrainingUserPaper::getTrainingPaperId, (Object)paperId)).in(TrainingUserPaper::getUserId, userIdsByTreeId)).eq(TrainingUserPaper::getSourceType, (Object)2)).eq(TrainingUserPaper::getPaperStatus, (Object)2)).orderByDesc(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.userPaperMapper.selectList((Wrapper)queryWrapper);
            Map<Integer, List<TrainingUserPaper>> trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdsByTreeId);
            for (int userId : userIdsByTreeId) {
                UsersPojo usersPojo;
                TrainingPaperRankingUserVo vo = new TrainingPaperRankingUserVo();
                List<TrainingUserPaper> trainingUserPapers = trainingUserPaperMap.get(userId);
                if (!CollectionUtils.isEmpty(trainingUserPapers)) {
                    TrainingUserPaper trainingUserPaper = Objects.isNull(paper.getScoreSelect()) || Objects.nonNull(paper.getScoreSelect()) && paper.getScoreSelect().equals(0) ? (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getScore, Comparator.nullsFirst(BigDecimal::compareTo)).reversed()).collect(Collectors.toList()).get(0) : (TrainingUserPaper)trainingUserPapers.stream().sorted(Comparator.comparing(TrainingUserPaper::getUpdateTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList()).get(0);
                    vo.setId(trainingUserPaper.getId());
                    vo.setScore(Double.valueOf(trainingUserPaper.getScore().doubleValue()));
                    vo.setPaperTime(trainingUserPaper.getUpdateTime());
                }
                if (Objects.nonNull(usersPojo = usersPojoMap.get(userId))) {
                    vo.setUserName(usersPojo.getShowName());
                    vo.setEmployeeNumber(usersPojo.getEmployeeNumber());
                } else {
                    vo.setUserName("");
                    vo.setEmployeeNumber("");
                }
                trainingPaperRankingUserVos.add(vo);
            }
        }
        BaseResult departmentsResult = this.departmentApi.getDepListByEnterpriseId(paper.getEnterpriseId());
        List departmentsList = (List)departmentsResult.getData();
        Map<Integer, List> departmentsMap = departmentsList.stream().collect(Collectors.toMap(DepartmentPojo::getOrganizeId, e -> new ArrayList<DepartmentPojo>(Collections.singletonList(e)), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        if (!CollectionUtils.isEmpty(userIdsByTreeId)) {
            Map<Integer, List<RolePojo>> roleMap = this.userUtilService.selectRolesByUsers(userIdsByTreeId, paper.getEnterpriseId());
            Map<Integer, String> userOrganizeMap = this.userUtilService.selectUserOrganizeName(user.getGroupId(), userIdsByTreeId);
            ArrayList<OrganizeVo> organizeVoList = new ArrayList<OrganizeVo>();
            List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(paper.getEnterpriseId(), userIdsByTreeId).getData();
            Map<Object, Object> organizeVoMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)userAndParentNameMos)) {
                for (UserAndParentNameMo mo : userAndParentNameMos) {
                    OrganizeVo vo = new OrganizeVo();
                    vo.setId(mo.getOrganizeId());
                    vo.setOtype(mo.getOtype());
                    vo.setName(mo.getOrganizeName());
                    vo.setGroupId(paper.getEnterpriseId());
                    vo.setUserId(mo.getUserId());
                    organizeVoList.add(vo);
                }
                organizeVoMap = organizeVoList.stream().collect(Collectors.toMap(OrganizeVo::getUserId, e -> new ArrayList<OrganizeVo>(Collections.singletonList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            for (TrainingPaperRankingUserVo trainingPaperRankingUserVo : trainingPaperRankingUserVos) {
                if (paper != null) {
                    trainingPaperRankingUserVo.setPaperStartTime(paper.getStartTime());
                    trainingPaperRankingUserVo.setPaperEndTime(paper.getEndTime());
                    trainingPaperRankingUserVo.setPaperName(paper.getTitle());
                }
                if (trainingPaperRankingUserVo.getId() != null) {
                    trainingPaperRankingUserVo.setIsFinish(Integer.valueOf(1));
                }
                List<RolePojo> roles = roleMap.get(trainingPaperRankingUserVo.getUserId());
                StringBuilder userRoles = new StringBuilder();
                if (!CollectionUtils.isEmpty(roles)) {
                    for (RolePojo role : roles) {
                        userRoles.append(role.getRoleName()).append(",");
                    }
                    userRoles.substring(0, userRoles.length() - 1);
                }
                trainingPaperRankingUserVo.setRoleName(userRoles.toString());
                if (trainingPaperRankingUserVo.getUserId() != null) {
                    trainingPaperRankingUserVo.setTreeStr(userOrganizeMap.get(trainingPaperRankingUserVo.getUserId()));
                    List selectByUserId = (List)organizeVoMap.get(trainingPaperRankingUserVo.getUserId());
                    if (!CollectionUtils.isEmpty((Collection)selectByUserId)) {
                        for (Organize organize : selectByUserId) {
                            if (organize.getOtype() == null || organize.getOtype() != 1) continue;
                            List departments = departmentsMap.get(organize.getId());
                            trainingPaperRankingUserVo.setDepName(CollectionUtils.isEmpty((Collection)departments) ? "" : ((DepartmentPojo)departments.get(0)).getName());
                        }
                    }
                }
                result.add(trainingPaperRankingUserVo);
            }
        }
        return result;
    }

    private List<Integer> getUserIdsByTreeId(String treeId) {
        DepartmentNew dep;
        List<Integer> userIds = new ArrayList<Integer>();
        if (treeId.contains("O_")) {
            Integer orgId = Integer.valueOf(treeId.split("_")[1]);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(orgId);
            userIds = this.organizeService.findUserIdsByOrganize(ids);
        } else if (treeId.contains("D_") && (dep = this.departmentService.findById(Integer.valueOf(treeId.split("_")[1]))) != null && dep.getOrganizeId() != null) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(dep.getOrganizeId());
            userIds = this.organizeService.findUserIdsByOrganize(ids);
        }
        return userIds;
    }

    @Override
    public TrainingPapersVo getQuestionDetail(Integer paperId, String organizeIds, Users user, String userName) {
        List<Integer> organizeUserIds = this.organizeService.getUserListNew(user, organizeIds, null, userName, user.getGroupId());
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (ObjectUtils.isEmpty((Object)trainingPaper)) {
            return new TrainingPapersVo();
        }
        List<TrainingUserQuestion> trainingUserQuestions = this.userQuestionMapper.selectAllUserQuestion(paperId, organizeUserIds);
        List<Object> trainingQuestionVos = new ArrayList();
        trainingQuestionVos = org.springframework.util.StringUtils.isEmpty((Object)trainingPaper.getExamId()) ? this.questionMapper.selectVoByPaperId(paperId, 1) : this.questionMapper.selectNewVoByPaperId(trainingPaper.getExamId());
        int needPaper = 0;
        int isPaper = 0;
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            if (trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                List<Integer> userIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperId);
                if (!CollectionUtils.isEmpty(userIds) && !CollectionUtils.isEmpty(organizeUserIds)) {
                    userIds.retainAll(organizeUserIds);
                    needPaper = userIds.size();
                }
            } else if (!CollectionUtils.isEmpty(organizeUserIds)) {
                needPaper = organizeUserIds.size();
            }
        }
        TrainingPapersVo paperVo = new TrainingPapersVo();
        ArrayList<TrainingQuestionVo> questionVo = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty(trainingQuestionVos) && !CollectionUtils.isEmpty(trainingUserQuestions)) {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String person = this.messageSource.getMessage("training.paper.person", null, locale);
            isPaper = trainingUserQuestions.size() / trainingQuestionVos.size();
            for (TrainingQuestionVo trainingQuestionVo : trainingQuestionVos) {
                int rightNum = 0;
                int errNum = 0;
                int emptyNum = 0;
                double d = 0.0;
                ArrayList<Integer> optionNum = new ArrayList<Integer>();
                List<TrainingOptionsVo> trainingOptionsVos = this.optionsMapper.selectVoByQuestionId(trainingQuestionVo.getId());
                if (trainingQuestionVo.getQuestionType() == 0 || trainingQuestionVo.getQuestionType() == 3) {
                    for (TrainingOptionsVo trainingOptionsVo : trainingOptionsVos) {
                        optionNum.add(0);
                    }
                } else if (trainingQuestionVo.getQuestionType() == 4) {
                    optionNum.add(0);
                    optionNum.add(0);
                }
                for (TrainingUserQuestion trainingUserQuestion : trainingUserQuestions) {
                    if (!trainingUserQuestion.getQuestionId().equals(trainingQuestionVo.getId())) continue;
                    if (trainingUserQuestion.getIsCorrect() == 1) {
                        ++rightNum;
                    } else if (trainingUserQuestion.getIsEmpty() == 1) {
                        ++emptyNum;
                    } else {
                        ++errNum;
                    }
                    d += trainingUserQuestion.getScore().doubleValue();
                    if (trainingUserQuestion.getIsEmpty() != 0) continue;
                    this.getOptionNum(trainingQuestionVo, trainingUserQuestion, optionNum);
                }
                int allNum = 0;
                for (Integer integer : optionNum) {
                    allNum += integer.intValue();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Integer integer : optionNum) {
                    if (rightNum + emptyNum + errNum == 0) {
                        arrayList.add("0.0%");
                        continue;
                    }
                    arrayList.add("" + String.format("%.1f", (double)integer.intValue() / (double)(rightNum + emptyNum + errNum) * 100.0) + "%   (" + integer + person + ")");
                }
                trainingQuestionVo.setRightNum(Integer.valueOf(rightNum));
                trainingQuestionVo.setErrNum(Integer.valueOf(errNum));
                trainingQuestionVo.setEmptyNum(Integer.valueOf(emptyNum));
                if (rightNum + errNum + emptyNum > 0) {
                    trainingQuestionVo.setAvgScore(Double.valueOf((double)Math.round(d / (double)(rightNum + errNum + emptyNum) * 10.0) / 10.0));
                }
                trainingQuestionVo.setOptionsList(this.optionsMapper.selectVoByQuestionId(trainingQuestionVo.getId()));
                trainingQuestionVo.setOptionNum(arrayList);
                trainingQuestionVo.setOriginScore(trainingQuestionVo.getScore());
                questionVo.add(trainingQuestionVo);
            }
        }
        paperVo.setQuestionVos(questionVo);
        paperVo.setNeedPaper(Integer.valueOf(needPaper));
        paperVo.setIsPaper(Integer.valueOf(isPaper));
        return paperVo;
    }

    private void getOptionNum(TrainingQuestionVo trainingUserQuestion, TrainingUserQuestion trainingQuestionVo, List<Integer> checkOption) {
        if (trainingQuestionVo.getQuestionType() == 0) {
            List trueOption = JSON.parseArray((String)trainingQuestionVo.getOptionsData(), TrainingOptionsVo.class);
            for (int i = 0; i < trueOption.size(); ++i) {
                if (((TrainingOptionsVo)trueOption.get(i)).getIsSelect() != 1) continue;
                Integer num = checkOption.get(i);
                checkOption.set(i, num + 1);
            }
        } else if (trainingQuestionVo.getQuestionType() == 3) {
            List trueOption = JSON.parseArray((String)trainingQuestionVo.getOptionsData(), TrainingOptionsVo.class);
            for (int i = 0; i < trueOption.size(); ++i) {
                if (((TrainingOptionsVo)trueOption.get(i)).getIsSelect() != 1) continue;
                Integer num = checkOption.get(i);
                checkOption.set(i, num + 1);
            }
        } else if (trainingQuestionVo.getQuestionType() == 4) {
            if (trainingQuestionVo.getIsCorrect() == 1) {
                if (trainingUserQuestion.getIsCorrect() == 1) {
                    Integer num = checkOption.get(0);
                    checkOption.set(0, num + 1);
                } else {
                    Integer num = checkOption.get(1);
                    checkOption.set(1, num + 1);
                }
            } else if (trainingUserQuestion.getIsCorrect() == 1) {
                Integer num = checkOption.get(1);
                checkOption.set(1, num + 1);
            } else {
                Integer num = checkOption.get(0);
                checkOption.set(0, num + 1);
            }
        }
    }

    private String userSelect(Integer s) {
        String select = "";
        switch (s) {
            case 0: {
                select = "A";
                break;
            }
            case 1: {
                select = "B";
                break;
            }
            case 2: {
                select = "C";
                break;
            }
            case 3: {
                select = "D";
                break;
            }
            case 4: {
                select = "E";
                break;
            }
            case 5: {
                select = "F";
                break;
            }
        }
        return select;
    }

    public String findDepNameByUserIdNew(Integer userId, List<UserOrganizeVo> userOrganizeVos) {
        StringBuilder organizeName = new StringBuilder();
        if (!CollectionUtils.isEmpty(userOrganizeVos)) {
            for (UserOrganizeVo userOrganizeVo : userOrganizeVos) {
                if (userOrganizeVo.getUserId() == null || userOrganizeVo.getOtype() == null || userId.intValue() != userOrganizeVo.getUserId().intValue() || userOrganizeVo.getOtype() != 0) continue;
                organizeName.append(userOrganizeVo.getOrganizeName()).append(" ");
            }
        }
        return organizeName.toString();
    }

    public String findDepNameByUserIdNew2(Integer userId, List<UserOrganizeVo> userOrganizeVos) {
        StringBuilder organizeName = new StringBuilder();
        if (!CollectionUtils.isEmpty(userOrganizeVos)) {
            for (UserOrganizeVo userOrganizeVo : userOrganizeVos) {
                if (userOrganizeVo.getUserId() == null || userOrganizeVo.getOtype() == null || userId.intValue() != userOrganizeVo.getUserId().intValue() || userOrganizeVo.getOtype() != 0) continue;
                organizeName.append(userOrganizeVo.getOrganizeName()).append(" ");
            }
        }
        return organizeName.toString();
    }

    public String findShopNameByUserId(Integer userId, List<UserOrganizeVo> userOrganizeVos) {
        ArrayList<UserOrganizeVo> shops = new ArrayList<UserOrganizeVo>();
        if (!CollectionUtils.isEmpty(userOrganizeVos)) {
            for (UserOrganizeVo userOrganizeVo : userOrganizeVos) {
                if (!userId.equals(userOrganizeVo.getUserId())) continue;
                shops.add(userOrganizeVo);
            }
        }
        if (!CollectionUtils.isEmpty(shops)) {
            for (int i = 0; i < shops.size(); ++i) {
                if (ObjectUtils.isEmpty(shops.get(i)) || ((UserOrganizeVo)shops.get(i)).getOtype() == null || ((UserOrganizeVo)shops.get(i)).getOtype() != 0) continue;
                shops.remove(i);
                --i;
            }
        }
        return CollectionUtils.isEmpty(shops) ? "" : ((UserOrganizeVo)shops.get(0)).getOrganizeName();
    }

    public String findShopNameByUserId2(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = StringUtils.join(pojoList, (String)",");
        }
        return shopName;
    }

    @Override
    public void saveStartTimeByPaperId(Integer userPaperId) {
        TrainingUserPaper userPaper = new TrainingUserPaper();
        userPaper.setId(userPaperId);
        userPaper.setUpdateTime(new Date());
        this.userPaperMapper.updateByPrimaryKeySelective(userPaper);
        if (!org.springframework.util.StringUtils.isEmpty((Object)userPaperId)) {
            try {
                this.trainingCourseService.saveCourseTaskStart(userPaperId, 2, null, null, null);
            }
            catch (Exception e) {
                log.error("\u57f9\u8bad\u8ba1\u5212\u8003\u8bd5\u5f00\u59cb", (Throwable)e);
            }
        }
    }

    private int getTrainingOldAttachSize(Integer trainingId) {
        List<TrainingAttach> trainingChapterAttachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
        List<TrainingVideo> trainingChapterVideos = this.trainingVideoMapper.selectByTrainingId(trainingId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        return attachSize + videoSize;
    }

    @Override
    public void updatePaperState() {
        this.paperMapper.updateStateByNowEnd();
        this.paperMapper.updateStateByNowStart();
    }

    @Override
    public TrainingUserPaper getUserPaper(Integer userPaper) {
        return (TrainingUserPaper)this.userPaperMapper.selectById(userPaper);
    }

    @Override
    public List<TrainingExamVo> selectUsingQuestion(List<TrainingQuestionVo> questionVos) {
        ArrayList<TrainingExamVo> examVos = new ArrayList<TrainingExamVo>();
        if (!CollectionUtils.isEmpty(questionVos)) {
            List<Integer> questionIds = questionVos.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            List<TrainingQuestion> questionList = this.questionMapper.selectByQuestionId(questionIds);
            if (!CollectionUtils.isEmpty(questionList)) {
                List<TrainingExamVo> examList;
                List<Integer> examIdList;
                List queationTypeIds = questionList.stream().map(TrainingQuestion::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(queationTypeIds)) {
                    for (Integer typeId : queationTypeIds) {
                        List<TrainingExamVo> examList2 = this.examMapper.selectExamByType(typeId);
                        if (CollectionUtils.isEmpty(examList2)) continue;
                        examVos.addAll(examList2);
                    }
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingExamQuestion::getQuestionId, questionIds);
                List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper2);
                if (!(CollectionUtils.isEmpty((Collection)examQuestions) || CollectionUtils.isEmpty(examIdList = examQuestions.stream().map(TrainingExamQuestion::getExamId).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty(examList = this.examMapper.selectExamByIds(examIdList)))) {
                    examVos.addAll(examList);
                }
            }
            if (!CollectionUtils.isEmpty(examVos)) {
                BaseResult base;
                List userIds = examVos.stream().map(TrainingExam::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getSimpleUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    map = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
                }
                for (TrainingExamVo vo : examVos) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getCreater())) continue;
                    vo.setCreateName(org.springframework.util.StringUtils.isEmpty(map.get(vo.getCreater())) ? "" : ((SimplePojo)map.get(vo.getCreater())).getName());
                }
            }
        }
        return examVos;
    }

    @Override
    public Page<TrainingQuestionVo> selectQuestionNewsByPage(Page<TrainingQuestionVo> page, Integer enterpriseId, String questionName, Integer questionType, Integer typeId, Integer isNotType) {
        List<TrainingQuestionVo> questionVoList = this.questionMapper.selectVoByPage(page, enterpriseId, questionName, questionType, typeId, isNotType, null);
        if (!CollectionUtils.isEmpty(questionVoList)) {
            List questionIds = questionVoList.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.in(TrainingExamQuestion::getQuestionId, questionIds);
            List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper1);
            Map<Object, Object> map = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)examQuestions)) {
                map = examQuestions.stream().collect(Collectors.toMap(TrainingExamQuestion::getQuestionId, e -> new ArrayList<TrainingExamQuestion>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
            }
            for (TrainingQuestionVo questionVo : questionVoList) {
                List examQuestionList = (List)map.get(questionVo.getId());
                ArrayList<Integer> questionIdList = new ArrayList<Integer>();
                questionIdList.add(questionVo.getId());
                List examIds = null;
                if (!CollectionUtils.isEmpty((Collection)examQuestionList)) {
                    List examQuestionIds = examQuestionList.stream().map(TrainingExamQuestion::getId).distinct().collect(Collectors.toList());
                    questionIdList.addAll(examQuestionIds);
                    examIds = examQuestionList.stream().map(TrainingExamQuestion::getExamId).distinct().collect(Collectors.toList());
                }
                TrainingQuestionVo vo = this.userQuestionMapper.selectCountByQuestion(questionIdList, examIds);
                questionVo.setTotalNum(vo.getTotalNum());
                questionVo.setRightNum(vo.getRightNum());
                questionVo.setRightRate(vo.getTotalNum() == 0 ? "-" : new BigDecimal(vo.getRightNum() * 100).divide(new BigDecimal(vo.getTotalNum()), 2, 1).toString());
            }
        }
        page.setContent(questionVoList);
        return page;
    }

    @Override
    public List<TrainingQuestionVo> selectUsingQuestionType(Integer isAll, Integer isNotType, String questionIds, Integer enterpriseId, Integer typeId) {
        List<Integer> questionIdss = new ArrayList<Integer>();
        if (isAll == null || isAll == 0) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionIds)) {
                for (String id : questionIds.split(",")) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)id.trim())) continue;
                    questionIdss.add(Integer.parseInt(id.trim()));
                }
            }
        } else {
            LambdaQueryWrapper wrapper1;
            List ques = new ArrayList();
            if (isNotType != null) {
                wrapper1 = new LambdaQueryWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                wrapper1.isNull(TrainingQuestion::getTypeId);
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            } else if (typeId != null) {
                wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(TrainingQuestion::getTypeId, (Object)typeId);
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            } else {
                wrapper1 = new LambdaQueryWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            }
            if (!CollectionUtils.isEmpty(ques)) {
                questionIdss = ques.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            }
        }
        ArrayList<TrainingQuestionVo> questionVoList = new ArrayList<TrainingQuestionVo>();
        if (!CollectionUtils.isEmpty(questionIdss)) {
            List queationTypeIds;
            List<TrainingQuestion> questionList = this.questionMapper.selectByQuestionId(questionIdss);
            if (!CollectionUtils.isEmpty(questionList) && !CollectionUtils.isEmpty(queationTypeIds = questionList.stream().map(TrainingQuestion::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                Map<Integer, List> typeMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getTypeId, e -> new ArrayList<TrainingQuestion>(Arrays.asList(e)), (oldList, newList) -> {
                    oldList.addAll(newList);
                    return oldList;
                }));
                for (Integer typesId : queationTypeIds) {
                    List questions;
                    List<TrainingExamVo> examList = this.examMapper.selectExamByType(typesId);
                    if (CollectionUtils.isEmpty(examList) || CollectionUtils.isEmpty((Collection)(questions = typeMap.get(typesId)))) continue;
                    for (TrainingQuestion ques : questions) {
                        TrainingQuestionVo vo = new TrainingQuestionVo();
                        BeanUtils.copyProperties((Object)ques, (Object)vo);
                        questionVoList.add(vo);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(questionVoList)) {
                BaseResult base;
                List userIds = questionVoList.stream().map(TrainingQuestion::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getSimpleUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    map = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
                }
                for (TrainingQuestionVo vo : questionVoList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getCreater())) continue;
                    vo.setCreateName(org.springframework.util.StringUtils.isEmpty(map.get(vo.getCreater())) ? "" : ((SimplePojo)map.get(vo.getCreater())).getName());
                }
            }
        }
        return questionVoList;
    }

    @Override
    public List<TrainingQuestionVo> selectUsingQuestionList(Integer isAll, Integer isNotType, String questionIds, Integer enterpriseId, Integer typeId) {
        List<Integer> questionIdss = new ArrayList<Integer>();
        if (isAll == null || isAll == 0) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)questionIds)) {
                for (String id : questionIds.split(",")) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)id.trim())) continue;
                    questionIdss.add(Integer.parseInt(id.trim()));
                }
            }
        } else {
            LambdaQueryWrapper wrapper1;
            List ques = new ArrayList();
            if (isNotType != null) {
                wrapper1 = new LambdaQueryWrapper();
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                ((LambdaQueryWrapper)wrapper1.isNull(TrainingQuestion::getTypeId)).isNull(TrainingQuestion::getIsDelete);
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            } else if (typeId != null) {
                wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(TrainingQuestion::getTypeId, (Object)typeId)).isNull(TrainingQuestion::getIsDelete);
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            } else {
                wrapper1 = new LambdaQueryWrapper();
                wrapper1.isNull(TrainingQuestion::getIsDelete);
                if (enterpriseId == null) {
                    wrapper1.isNull(TrainingQuestion::getEnterpriseId);
                } else {
                    wrapper1.eq(TrainingQuestion::getEnterpriseId, (Object)enterpriseId);
                }
                ques = this.questionMapper.selectList((Wrapper)wrapper1);
            }
            if (!CollectionUtils.isEmpty(ques)) {
                questionIdss = ques.stream().map(TrainingQuestion::getId).distinct().collect(Collectors.toList());
            }
        }
        ArrayList<TrainingQuestionVo> questionVoList = new ArrayList<TrainingQuestionVo>();
        ArrayList<Integer> questionVoIdList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(questionIdss)) {
            List<Integer> idList;
            List<TrainingQuestion> questiones;
            List<TrainingQuestion> questionList = this.questionMapper.selectByQuestionId(questionIdss);
            if (!CollectionUtils.isEmpty(questionList)) {
                List queationTypeIds = questionList.stream().map(TrainingQuestion::getTypeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(queationTypeIds)) {
                    Map<Integer, List> typeMap = questionList.stream().collect(Collectors.toMap(TrainingQuestion::getTypeId, e -> new ArrayList<TrainingQuestion>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                    for (Integer typesId : queationTypeIds) {
                        List questions;
                        List<TrainingExamVo> examList = this.examMapper.selectExamByType(typesId);
                        if (CollectionUtils.isEmpty(examList) || CollectionUtils.isEmpty((Collection)(questions = typeMap.get(typesId)))) continue;
                        for (TrainingQuestion ques : questions) {
                            questionVoIdList.add(ques.getId());
                        }
                    }
                }
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.in(TrainingExamQuestion::getQuestionId, questionIdss);
                List examQuestions = this.examQuestionMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtils.isEmpty((Collection)examQuestions)) {
                    Map<Integer, List> map = examQuestions.stream().collect(Collectors.toMap(TrainingExamQuestion::getQuestionId, e -> new ArrayList<TrainingExamQuestion>(Arrays.asList(e)), (oldList, newList) -> {
                        oldList.addAll(newList);
                        return oldList;
                    }));
                    for (Integer questionId : questionIdss) {
                        List list = map.get(questionId);
                        if (CollectionUtils.isEmpty((Collection)list)) continue;
                        questionVoIdList.add(questionId);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(questionVoIdList) && !CollectionUtils.isEmpty(questiones = this.questionMapper.selectByQuestionId(idList = questionVoIdList.stream().distinct().collect(Collectors.toList())))) {
                for (TrainingQuestion qu : questiones) {
                    TrainingQuestionVo vo = new TrainingQuestionVo();
                    BeanUtils.copyProperties((Object)qu, (Object)vo);
                    questionVoList.add(vo);
                }
            }
            if (!CollectionUtils.isEmpty(questionVoList)) {
                BaseResult base;
                List userIds = questionVoList.stream().map(TrainingQuestion::getCreater).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> map = new HashMap();
                if (!CollectionUtils.isEmpty(userIds) && (base = this.userApi.getSimpleUserByIdList(userIds)) != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    map = ((List)base.getData()).stream().collect(Collectors.toMap(SimplePojo::getId, Function.identity()));
                }
                for (TrainingQuestionVo vo : questionVoList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)vo.getCreater())) continue;
                    vo.setCreateName(org.springframework.util.StringUtils.isEmpty(map.get(vo.getCreater())) ? "" : ((SimplePojo)map.get(vo.getCreater())).getName());
                }
            }
        }
        return questionVoList;
    }

    @Override
    public void updateUserView(Date startTime, Date endTime) {
        List<TrainingUserViewTime> enterpriseIdList = this.viewTimeMapper.selectAllEnterpriseId(startTime, endTime);
        for (int i = 0; i < enterpriseIdList.size(); ++i) {
            TrainingUserViewTime viewTime = enterpriseIdList.get(i);
            List<TrainingUserViewTimeVo> userViewTimeVos = this.viewTimeMapper.selectTotalTimeByUser(viewTime.getEnterpriseId(), null, startTime, endTime);
            for (TrainingUserViewTimeVo userViewTime : userViewTimeVos) {
                TrainingUserView userView;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(TrainingUserView::getEnterpriseId, (Object)viewTime.getEnterpriseId());
                wrapper.eq(TrainingUserView::getUserId, (Object)userViewTime.getUserId());
                List list = this.trainingUserViewMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    userView = (TrainingUserView)list.get(0);
                    if (userView.getUpdateTime().compareTo(DateUtils.getStartTimeOfDay(new Date())) == 0) continue;
                    userView.setViewTimes(Integer.valueOf(userView.getViewTimes() + userViewTime.getViewTimes()));
                    userView.setUpdateTime(DateUtils.getStartTimeOfDay(new Date()));
                    this.trainingUserViewMapper.updateById(userView);
                    continue;
                }
                userView = new TrainingUserView();
                userView.setEnterpriseId(viewTime.getEnterpriseId());
                userView.setUserId(userViewTime.getUserId());
                userView.setViewTimes(userViewTime.getViewTimes());
                userView.setCreateTime(DateUtils.getStartTimeOfDay(new Date()));
                userView.setUpdateTime(DateUtils.getStartTimeOfDay(new Date()));
                this.trainingUserViewMapper.insert(userView);
            }
            log.info("updateUserView:total:" + enterpriseIdList.size() + ",now:" + (i + 1));
        }
    }

    @Override
    public String addPaperScreenNum(Integer userPaperId) {
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectById(userPaperId);
        PaperScreenNumVo vo = new PaperScreenNumVo();
        if (!ObjectUtils.isEmpty((Object)userPaper)) {
            userPaper.setScreenNum(Integer.valueOf(userPaper.getScreenNum() + 1));
            this.userPaperMapper.updateById(userPaper);
            TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(userPaper.getTrainingPaperId());
            vo.setIsScreen(Integer.valueOf(ObjectUtils.isEmpty((Object)paper) ? 0 : paper.getIsScreen()));
            vo.setScreenNum(Integer.valueOf(ObjectUtils.isEmpty((Object)paper) ? 0 : (paper.getScreenNum() != null ? paper.getScreenNum() : 0)));
            vo.setMyScreenNum(userPaper.getScreenNum());
        }
        return JsonResult.success((Object)vo);
    }

    @Override
    public void updateStudyStatus(int userPaperId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingUserPaper::getId, (Object)userPaperId);
        queryWrapper.eq(TrainingUserPaper::getSourceType, (Object)1);
        TrainingUserPaper userPaper = (TrainingUserPaper)this.userPaperMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(userPaper)) {
            int userId = userPaper.getUserId();
            int projectId = userPaper.getSourceProjectId();
            int groupId = userPaper.getEnterpriseId();
            List<Object> paperIdList = new ArrayList();
            List<TrainingUserViewTimeVo> trainingViewList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByTraining(Collections.singletonList(projectId), groupId);
            HashMap<Integer, List<TrainingUserViewTimeVo>> viewMap = new HashMap();
            if (!CollectionUtils.isEmpty(trainingViewList)) {
                viewMap = trainingViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getTrainingId));
            }
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingChapterAttach::getTrainingId, (Object)projectId)).eq(TrainingChapterAttach::getIsDel, (Object)0);
            List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
            HashMap<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = new HashMap();
            Map<Integer, Object> materialMap = new HashMap<Integer, TrainingMaterial>();
            Map<Integer, List<TrainingUserViewTimeVo>> viewMaterialMap = new HashMap<Integer, List<TrainingUserViewTimeVo>>();
            Map<Integer, List<TrainingUserPaper>> userPaperMap = new HashMap<Integer, List<TrainingUserPaper>>();
            if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
                List<Integer> materialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(materialIdList)) {
                    List mateList = this.materialMapper.selectBatchIds(materialIdList);
                    materialMap = mateList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                    List<TrainingUserViewTimeVo> materialViewList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByMaterials(materialIdList, groupId);
                    if (!CollectionUtils.isEmpty(materialViewList)) {
                        viewMaterialMap = materialViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                    }
                }
                if (!CollectionUtils.isEmpty(paperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                    LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime);
                    List trainingUserPaperList = this.userPaperMapper.selectList((Wrapper)wrapper4);
                    if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                        userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                    }
                }
            }
            Map<String, Object> map = this.commonService.selectIsFinishTraining(projectId, userId, viewMap, viewMaterialMap, trainingChapterAttachMap, materialMap, userPaperMap);
            int status = Integer.parseInt(map.get("status").toString());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.eq(TrainingStudyStatus::getTrainingId, (Object)projectId);
            queryWrapper1.eq(TrainingStudyStatus::getUserId, (Object)userId);
            queryWrapper1.orderByDesc(TrainingStudyStatus::getId);
            List statusList = this.trainingStudyStatusMapper.selectList((Wrapper)queryWrapper1);
            if (!CollectionUtils.isEmpty((Collection)statusList)) {
                TrainingStudyStatus trainingStudyStatus = (TrainingStudyStatus)statusList.get(0);
                if (trainingStudyStatus.getStatus() != null && trainingStudyStatus.getStatus() == 2) {
                    return;
                }
                trainingStudyStatus.setStatus(Integer.valueOf(status));
                if (status == 2 && trainingStudyStatus.getFinishTime() == null) {
                    trainingStudyStatus.setFinishTime(new Date());
                }
                this.trainingStudyStatusMapper.updateById(trainingStudyStatus);
            } else {
                TrainingStudyStatus trainingStudyStatus = this.getTrainingStudyStatus(status, projectId, userId);
                this.trainingStudyStatusMapper.insert(trainingStudyStatus);
                this.trainService.saveTrainingViewCount(projectId);
            }
        }
    }

    private TrainingStudyStatus getTrainingStudyStatus(int status, int projectId, int userId) {
        TrainingStudyStatus trainingStudyStatus = new TrainingStudyStatus();
        trainingStudyStatus.setStatus(Integer.valueOf(status));
        trainingStudyStatus.setTrainingId(Integer.valueOf(projectId));
        trainingStudyStatus.setUserId(Integer.valueOf(userId));
        trainingStudyStatus.setCreateTime(new Date());
        if (status == 2) {
            trainingStudyStatus.setFinishTime(new Date());
        }
        trainingStudyStatus.setFileType(Integer.valueOf(8));
        return trainingStudyStatus;
    }
}

