/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingOrderInfoMapper;
import com.ovopark.training.mapper.TrainingProcureCourseMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingFee;
import com.ovopark.training.model.TrainingOrderInfo;
import com.ovopark.training.model.TrainingProcureCourse;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingFeeService;
import com.ovopark.training.service.TrainingProcureCourseService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.OrderUtil;
import com.ovopark.training.vo.TrainingProcureCourseVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingProcureCourseServiceImpl
implements TrainingProcureCourseService {
    private static final Logger log = LoggerFactory.getLogger(TrainingProcureCourseServiceImpl.class);
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingProcureCourseMapper trainingProcureCourseMapper;
    @Autowired
    private TrainingOrderInfoMapper trainingOrderInfoMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingFeeService trainingFeeService;
    @Autowired
    private MessageSource messageSource;

    @Override
    public com.ovopark.training.bo.Page<TrainingProcureCourseVo> selectTrainingProcureCourseByPage(com.ovopark.training.bo.Page<TrainingProcureCourseVo> page, int type, String trainingName, Users users) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        IPage list = this.trainingProcureCourseMapper.selectJoinPage((IPage)new Page((long)page.getPageNumber(), (long)page.getPageSize().intValue()), TrainingProcureCourseVo.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAll(TrainingProcureCourse.class)).selectAs(TrainingFee::getTitle, TrainingProcureCourseVo::getTrainingName)).leftJoin(TrainingFee.class, TrainingFee::getId, TrainingProcureCourse::getTrainingFeeId)).like(!StringUtils.isEmpty((Object)trainingName), TrainingFee::getTitle, (Object)trainingName)).eq(type != 0, TrainingFee::getTrainingType, (Object)type)).eq(TrainingProcureCourse::getGroupId, (Object)users.getGroupId())).orderByDesc(TrainingProcureCourse::getId));
        if (!CollectionUtils.isEmpty((Collection)list.getRecords())) {
            for (TrainingProcureCourseVo vo : list.getRecords()) {
                int days = DateUtils.countDays(new Date(), vo.getDueTime());
                if (days > 0) {
                    vo.setDueSize("0");
                } else {
                    String all = this.messageSource.getMessage("training.course.all", null, locale);
                    vo.setDueSize(all);
                    vo.setEmpowerSize("0");
                }
                if (vo.getAgeing() != 2) continue;
                vo.setDueTime(DateUtils.getEndTimeOfDay(vo.getDueTime()));
            }
        }
        page.setContent(list.getRecords());
        page.setPageCount(Long.valueOf(list.getPages()));
        page.setPageNumber((int)list.getCurrent());
        page.setTotalCount(Long.valueOf(list.getTotal()));
        return page;
    }

    @Override
    public String saveTrainingProcureCourse(TrainingProcureCourseVo vo, Users user) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String result = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"training_fee_id", (Object)vo.getTrainingFeeId());
        queryWrapper.eq((Object)"group_id", (Object)user.getGroupId());
        List list = this.trainingProcureCourseMapper.selectList((Wrapper)queryWrapper);
        TrainingOrderInfo orderInfo = new TrainingOrderInfo();
        orderInfo.setOrderNo(OrderUtil.getOrderCode((Integer)user.getId()));
        orderInfo.setTrainingFeeId(vo.getTrainingFeeId());
        orderInfo.setBuyType(Integer.valueOf(1));
        orderInfo.setUserId(user.getId());
        orderInfo.setGroupId(user.getGroupId().intValue());
        orderInfo.setUserName(this.userUtilService.selectUser(user.getId()).getShowName());
        orderInfo.setBuyTime(new Date());
        orderInfo.setAgeing(vo.getAgeing());
        orderInfo.setBuySize(this.messageSource.getMessage("training.paper.time.null", null, locale));
        orderInfo.setWay(Integer.valueOf(1));
        if (vo.getAgeing() == 1) {
            orderInfo.setDueTime(DateUtils.addYear(new Date(), 100));
        } else {
            orderInfo.setDueTime(DateUtils.addYear(new Date(), 1));
        }
        int f = 0;
        if (list.size() > 0) {
            TrainingProcureCourse temp = (TrainingProcureCourse)list.get(0);
            if (temp.getAgeing() == 1) {
                result = this.messageSource.getMessage("training.training.exist", null, locale);
            } else {
                Date currentTime = new Date();
                Date createTime = temp.getCreateTime();
                Date dueTime = DateUtils.addYear(createTime, 1);
                int days = DateUtils.countDays(currentTime, dueTime);
                if (days > 30) {
                    result = this.messageSource.getMessage("training.training.exist.data", null, locale);
                } else {
                    if (days > 0) {
                        temp.setDueTime(DateUtils.addYear(dueTime, 1));
                    } else {
                        temp.setDueTime(DateUtils.addYear(new Date(), 1));
                    }
                    temp.setCreateTime(new Date());
                    f = this.trainingProcureCourseMapper.updateById(temp);
                    if (f > 0) {
                        this.trainingOrderInfoMapper.insert(orderInfo);
                    }
                    result = this.messageSource.getMessage("training.training.join.renewal", null, locale);
                }
            }
        } else {
            int trainingId = this.trainingFeeService.saveCopyTrainingFee(vo.getTrainingFeeId(), user);
            TrainingProcureCourse trainingProcureCourse = new TrainingProcureCourse();
            trainingProcureCourse.setTrainingId(trainingId);
            trainingProcureCourse.setTrainingFeeId(vo.getTrainingFeeId());
            trainingProcureCourse.setBuySize(this.messageSource.getMessage("training.paper.time.null", null, locale));
            trainingProcureCourse.setGroupId(user.getGroupId().intValue());
            trainingProcureCourse.setUserId(user.getId().intValue());
            trainingProcureCourse.setEmpowerSize(this.messageSource.getMessage("training.paper.time.null", null, locale));
            trainingProcureCourse.setCreateTime(new Date());
            trainingProcureCourse.setAgeing(vo.getAgeing());
            trainingProcureCourse.setIsStorage(0);
            trainingProcureCourse.setUpdateTime(new Date());
            if (vo.getAgeing() == 1) {
                trainingProcureCourse.setDueTime(DateUtils.addYear(new Date(), 100));
            } else {
                trainingProcureCourse.setDueTime(DateUtils.addYear(new Date(), 1));
            }
            f = this.trainingProcureCourseMapper.insert(trainingProcureCourse);
            if (f > 0) {
                this.trainingOrderInfoMapper.insert(orderInfo);
            }
            result = this.messageSource.getMessage("training.training.join", null, locale);
        }
        if (f > 0) {
            log.info("\u751f\u6210\u8ba2\u5355\u6210\u529f,\u8ba2\u5355\u53f7:{}", (Object)orderInfo.getOrderNo());
        }
        return result;
    }

    @Override
    public String addTrainingProcureCourse(int trainingFeeId, int trainingType, Users users) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"training_fee_id", (Object)trainingFeeId);
        queryWrapper.eq((Object)"group_id", (Object)users.getGroupId());
        TrainingProcureCourse course = (TrainingProcureCourse)this.trainingProcureCourseMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(course)) {
            course.setIsStorage(0);
            course.setUpdateTime(new Date());
            int flag = this.trainingProcureCourseMapper.updateById(course);
            if (flag > 0 && trainingType != 0) {
                Training training = new Training();
                training.setId(Integer.valueOf(course.getTrainingId()));
                training.setTrainingType(Integer.valueOf(trainingType));
                this.trainingMapper.updateById(training);
            }
            JsonResult.success();
        }
        return JsonResult.success();
    }

    @Override
    public String removeTrainingProcureCourse(List<Integer> trainingFeeIdIdList, Users users) {
        QueryWrapper queryWrapper = new QueryWrapper();
        for (int trainingId : trainingFeeIdIdList) {
            queryWrapper.eq((Object)"training_fee_id", (Object)trainingId);
            queryWrapper.eq((Object)"group_id", (Object)users.getGroupId());
            TrainingProcureCourse course = (TrainingProcureCourse)this.trainingProcureCourseMapper.selectOne((Wrapper)queryWrapper);
            if (Objects.nonNull(course)) {
                course.setIsStorage(1);
                JsonResult.success((Object)this.trainingProcureCourseMapper.updateById(course));
            }
            queryWrapper.clear();
        }
        return JsonResult.success();
    }

    @Override
    public String detachTrainingProcureCourse(List<Integer> trainingIdList, Users users) {
        this.removeTrainingProcureCourse(trainingIdList, users);
        return JsonResult.success();
    }
}

