/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.ovopark.api.GoldApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.MeaasgeAndWeixinMo;
import com.ovopark.organize.common.model.mo.MessageMo;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.MessageApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingAndLecturerMapper;
import com.ovopark.training.mapper.TrainingAndMaterialMapper;
import com.ovopark.training.mapper.TrainingAttachMapper;
import com.ovopark.training.mapper.TrainingAttachUserMapper;
import com.ovopark.training.mapper.TrainingCertificateMapper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingChapterAttachUserMapper;
import com.ovopark.training.mapper.TrainingChapterMapper;
import com.ovopark.training.mapper.TrainingChapterProgressMapper;
import com.ovopark.training.mapper.TrainingChapterUnlockMapper;
import com.ovopark.training.mapper.TrainingChapterVideoMapper;
import com.ovopark.training.mapper.TrainingCommentMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingHistoryMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLabelMapper;
import com.ovopark.training.mapper.TrainingLabelTrainingMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingNavCategoryMapper;
import com.ovopark.training.mapper.TrainingNavMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperQuestionMapper;
import com.ovopark.training.mapper.TrainingPaperTrainingMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingStudyStatusMapper;
import com.ovopark.training.mapper.TrainingTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingTaskUserMapper;
import com.ovopark.training.mapper.TrainingUserCollectionMapper;
import com.ovopark.training.mapper.TrainingUserLastViewMapper;
import com.ovopark.training.mapper.TrainingUserLookMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserProgressMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCheckMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeCourseMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeJobMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeLearnMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.mapper.TrainingVideoLookMapper;
import com.ovopark.training.mapper.TrainingVideoMapper;
import com.ovopark.training.mo.KaFKaWorkCircleArticleAddMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleDelMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleUpdSeeUsersMo;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.Organize;
import com.ovopark.training.model.StudyEvent;
import com.ovopark.training.model.TaskMessage;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingAttach;
import com.ovopark.training.model.TrainingAttachUser;
import com.ovopark.training.model.TrainingChapter;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingChapterAttachUser;
import com.ovopark.training.model.TrainingChapterProgress;
import com.ovopark.training.model.TrainingChapterUnlock;
import com.ovopark.training.model.TrainingChapterVideo;
import com.ovopark.training.model.TrainingComment;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingHistory;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLabel;
import com.ovopark.training.model.TrainingLabelTraining;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLecturer;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingNav;
import com.ovopark.training.model.TrainingNavCategory;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperQuestion;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingStudyStatus;
import com.ovopark.training.model.TrainingTask;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingTaskUser;
import com.ovopark.training.model.TrainingUserCollection;
import com.ovopark.training.model.TrainingUserLastView;
import com.ovopark.training.model.TrainingUserLook;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserProgress;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeCheck;
import com.ovopark.training.model.TrainingUserViewTimeCourse;
import com.ovopark.training.model.TrainingUserViewTimeJob;
import com.ovopark.training.model.TrainingUserViewTimeLearn;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.TrainingVideo;
import com.ovopark.training.model.TrainingVideoLook;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.KafkaProducerService;
import com.ovopark.training.service.OrganizeService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.QCloudUtils;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.util.TencentLiveUtils;
import com.ovopark.training.vo.HomeTrainingVo;
import com.ovopark.training.vo.QCloudFileResponseVo;
import com.ovopark.training.vo.QCloudResponseVo;
import com.ovopark.training.vo.TrainingAddVo;
import com.ovopark.training.vo.TrainingAttachVo;
import com.ovopark.training.vo.TrainingChapterAttachVo;
import com.ovopark.training.vo.TrainingChapterVo;
import com.ovopark.training.vo.TrainingCommentVo;
import com.ovopark.training.vo.TrainingLabelVo;
import com.ovopark.training.vo.TrainingLecturerVo;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.TrainingNavVo;
import com.ovopark.training.vo.TrainingPaperVo;
import com.ovopark.training.vo.TrainingTaskVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import com.ovopark.training.vo.TrainingVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.UserOrganizeVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class TrainingRemoteServiceImpl
implements TrainingRemoteService {
    private static final Logger log = LoggerFactory.getLogger(TrainingRemoteServiceImpl.class);
    @Autowired
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private TrainingNavMapper trainingNavMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingCertificateMapper trainingCertificateMapper;
    @Autowired
    private TrainingAttachMapper trainingAttachMapper;
    @Autowired
    private TrainingVideoMapper trainingVideoMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingLabelMapper trainingLabelMapper;
    @Autowired
    private TrainingLabelTrainingMapper tltMapper;
    @Autowired
    private TrainingNavCategoryMapper tncMapper;
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingUserProgressMapper trainingUserProgressMapper;
    @Autowired
    private TrainingUserCollectionMapper trainingUserCollectionMapper;
    @Autowired
    private TrainingHistoryMapper trainingHistoryMapper;
    @Autowired
    private TrainingPaperTrainingMapper trainingPaperTrainingMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private TrainingUserLookMapper trainingUserLookMapper;
    @Autowired
    private TrainingChapterMapper trainingChapterMapper;
    @Autowired
    private TrainingChapterUnlockMapper trainingChapterUnlockMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingChapterVideoMapper trainingChapterVideoMapper;
    @Autowired
    private KafkaProducerService kafkaProducerService;
    @Autowired
    private TrainingVideoLookMapper trainingVideoLookMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingChapterAttachUserMapper trainingChapterAttachUserMapper;
    @Autowired
    private TrainingChapterProgressMapper trainingChapterProgressMapper;
    @Autowired
    private TrainingAttachUserMapper trainingAttachUserMapper;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private TrainingTaskMapper trainingTaskMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private TrainingTaskUserMapper trainingTaskUserMapper;
    @Autowired
    private TrainingCommentMapper commentMapper;
    @Autowired
    private TrainingUserViewTimeMapper viewTimeMapper;
    @Autowired
    private TrainingPaperQuestionMapper trainingPaperQuestionMapper;
    @Autowired
    private TrainingAndLecturerMapper andLecturerMapper;
    @Autowired
    private TrainingAndMaterialMapper andMaterialMapper;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private GoldApi goldApi;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingLearnTaskUserMapper trainingLearnTaskUserMapper;
    @Autowired
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingUserLastViewMapper lastViewMapper;
    @Resource
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCommonService commonService;
    @Autowired
    private TrainService trainService;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Autowired
    private MessageApi messageApi;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private TrainingNavCategoryMapper trainingNavCategoryMapper;
    @Autowired
    private TrainingUserViewTimeCourseMapper trainingUserViewTimeCourseMapper;
    @Autowired
    private TrainingUserViewTimeCheckMapper trainingUserViewTimeCheckMapper;
    @Autowired
    private TrainingUserViewTimeJobMapper trainingUserViewTimeJobMapper;
    @Autowired
    private TrainingUserViewTimeLearnMapper trainingUserViewTimeLearnMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private TrainingStudyStatusMapper trainingStudyStatusMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafkaTrainingTopic}")
    private String kafkaTrainingTopic;
    ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    @Resource(name="updateStudyStatus")
    private Executor updateStudyStatusExecutor;
    public static final String KAFKA_SEND_SUCCESS_MES = "\u53d1\u9001\u6210\u529f";
    public static final String KAFKA_SEND_ERROR_MES = "\u53d1\u9001\u6d88\u606f\u8d85\u65f6";
    public static final String KAFKA_NO_RESULT_MES = "\u672a\u67e5\u8be2\u5230\u8fd4\u56de\u7ed3\u679c";
    public static final String KAFKA_NO_OFFSET_MES = "\u672a\u67e5\u5230\u8fd4\u56de\u6570\u636e\u7684offset";

    @Override
    public List<TrainingNav> getTrainingNavByGroupId(Integer userId, Integer groupId) {
        ArrayList<TrainingNav> result = new ArrayList();
        if (this.commonRemoteService.isRoot(userId).booleanValue()) {
            result = this.trainingNavMapper.selectAll(null, null, null);
        } else {
            List<TrainingNavCategory> tncList = this.tncMapper.selectByNavIdAndCategoryId(null, null);
            if (!CollectionUtils.isEmpty(tncList)) {
                for (TrainingNavCategory tnc : tncList) {
                    TrainingNav nav = (TrainingNav)this.trainingNavMapper.selectById(tnc.getTrainingNavId());
                    if (nav == null) continue;
                    result.add(nav);
                }
            }
            List simplePojoList = new ArrayList();
            BaseResult baseResult = this.enterpriseGroupsApi.getCategoriesByGroupId(groupId);
            if (!baseResult.getIsError().booleanValue()) {
                simplePojoList = (List)baseResult.getData();
            }
            List pidList = Collections.emptyList();
            if (!CollectionUtils.isEmpty(simplePojoList) && !CollectionUtils.isEmpty(pidList)) {
                result.addAll(Collections.emptyList());
            } else {
                EnterpriseGroupMo mo = (EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId).getData();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(TrainingNavCategory::getCategoryId, (Object)mo.getIndustryId());
                List trainingNavCategoryList = this.trainingNavCategoryMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtils.isEmpty((Collection)trainingNavCategoryList)) {
                    LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
                    queryWrapper1.in(TrainingNav::getId, (Collection)trainingNavCategoryList.stream().map(TrainingNavCategory::getTrainingNavId).filter(Objects::nonNull).collect(Collectors.toList()));
                    List list = this.trainingNavMapper.selectList((Wrapper)queryWrapper1);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        result.addAll(list);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<TrainingNav> getAllTrainingNav(Integer isPublic, Integer isAll) {
        ArrayList<Integer> ids = null;
        if (isAll != null && isAll != 1) {
            ids = new ArrayList<Integer>();
            ids.add(1000000257);
        }
        return this.trainingNavMapper.selectAll(ids, isPublic, null);
    }

    @Override
    public List<HomeTrainingVo> getHomeTraining(Integer userId, Integer groupId, Integer navId, String keyword) {
        List<TrainingNav> navIds = this.getTrainingNavByGroupId(userId, groupId);
        ArrayList<HomeTrainingVo> list = new ArrayList<HomeTrainingVo>();
        HomeTrainingVo home = new HomeTrainingVo();
        Page page = new Page();
        page.setPageNumber(1);
        if (navId != null && navId == -1) {
            home = new HomeTrainingVo();
            Page pages = new Page();
            pages.setPageSize(20);
            pages.setPageNumber(1);
            home.setType("COLLECTION");
            List<TrainingsVo> collect = this.trainingMapper.selectByCollectByPage((Page<TrainingsVo>)pages, userId);
            List<TrainingVo> voCollect = this.convertTraining(collect);
            if (!CollectionUtils.isEmpty(voCollect)) {
                home.setTrainingList(this.isLook(voCollect, userId));
                list.add(home);
            }
            return list;
        }
        page.setPageSize(10);
        home = new HomeTrainingVo();
        home.setType("RECOMMEND");
        List<TrainingVo> voRecommend = this.convertTraining(this.trainingMapper.selectRecommendByPage((Page<TrainingVo>)page, groupId, navId, keyword, navIds, userId));
        if (!CollectionUtils.isEmpty(voRecommend)) {
            home.setTrainingList(this.isLook(voRecommend, userId));
            list.add(home);
        }
        page.setPageSize(20);
        home = new HomeTrainingVo();
        home.setType("NEW");
        List<TrainingVo> voNew = this.convertTraining(this.trainingMapper.selectNewByPage((Page<TrainingVo>)page, groupId, navId, keyword, navIds, userId, null));
        if (!CollectionUtils.isEmpty(voNew)) {
            this.getTrainingVoIsPaper(voNew);
            home.setTrainingList(this.isLook(voNew, userId));
            list.add(home);
        }
        return list;
    }

    @Override
    public Page<TrainingVo> getTrainingDetailByPage(Page<TrainingVo> page, Integer userId, Integer groupId, String type, String keyWord, Integer labelId) {
        List ids;
        BaseResult usersPojos;
        List<TrainingNav> navIds = this.getTrainingNavByGroupId(userId, groupId);
        List<Object> result = new ArrayList();
        if ("LIVE".equals(type)) {
            result = this.convertTraining(this.trainingMapper.selectLiveByPage(page, groupId, null, keyWord, navIds, userId));
        } else if ("NEW".equals(type)) {
            result = this.convertTraining(this.trainingMapper.selectNewByPage(page, groupId, null, keyWord, navIds, userId, labelId));
        } else if ("RECOMMEND".equals(type)) {
            result = this.convertTraining(this.trainingMapper.selectRecommendByPage(page, groupId, null, keyWord, navIds, userId));
        } else if ("APPOINTMENT".equals(type)) {
            result = this.convertTraining(this.trainingMapper.selectAppointmentByPage(page, userId, groupId, null, keyWord, navIds));
        } else {
            List<String> timeList = this.trainingMapper.selectTimeList(null);
            for (int i = 0; i < timeList.size(); ++i) {
                if (!timeList.get(i).equals(type)) continue;
                result = this.convertTraining(this.trainingMapper.selectTimeByPage(page, groupId, timeList.get(i), null, keyWord, navIds, userId));
            }
        }
        if (!CollectionUtils.isEmpty(result) && !CollectionUtils.isEmpty((Collection)((Collection)(usersPojos = this.userApi.getUserByIdList(ids = result.stream().map(TrainingVo::getCreator).collect(Collectors.toList()))).getData()))) {
            Map trainingVoMap = ((List)usersPojos.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
            Iterator<Object> iterator = result.iterator();
            while (iterator.hasNext()) {
                TrainingVo trainingVo;
                trainingVo.setThumbUrl(trainingVoMap.get((trainingVo = (TrainingVo)iterator.next()).getCreator()) == null ? null : ((UsersPojo)trainingVoMap.get(trainingVo.getCreator())).getThumbUrl());
                trainingVo.setCreatorName(trainingVoMap.get(trainingVo.getCreator()) == null ? null : ((UsersPojo)trainingVoMap.get(trainingVo.getCreator())).getShowName());
            }
        }
        this.getTrainingVoIsPaper(result);
        page.setContent(this.isLook(result, userId));
        return page;
    }

    @Override
    public Page<TrainingVo> selectByNavIdByPage(Page<TrainingVo> page, Integer navId, Integer enterpriseId, Integer userId) {
        List<TrainingsVo> trainingList = this.trainingMapper.selectByNavIdUserIdByPage(page, navId, enterpriseId, userId);
        this.getTrainingIsPaper(trainingList);
        page.setContent(this.convertTraining(trainingList));
        return page;
    }

    @Override
    public TrainingAttachVo getAttachByTrainingId(Integer trainingId, Integer userId) {
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!StringUtils.isEmpty((Object)clientInfo)) {
            if (!StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        TrainingAttachVo vo = new TrainingAttachVo();
        if (training != null) {
            List<TrainingAttach> trainingAttaches = this.trainingAttachMapper.selectByTrainingId(trainingId);
            if (!"h5".equalsIgnoreCase(clientName) && version.compareTo("4.48.01") < 0 && !CollectionUtils.isEmpty(trainingAttaches)) {
                ArrayList<TrainingAttach> delList = new ArrayList<TrainingAttach>();
                for (TrainingAttach attVo : trainingAttaches) {
                    if (StringUtils.isEmpty((Object)attVo.getIsCommodity()) || attVo.getIsCommodity() != 1) continue;
                    delList.add(attVo);
                }
                if (!CollectionUtils.isEmpty(delList)) {
                    trainingAttaches.removeAll(delList);
                }
            }
            List<TrainingVideo> trainingVideos = this.trainingVideoMapper.selectByTrainingId(trainingId);
            this.setOldIsFinish(userId, trainingId, trainingAttaches, trainingVideos);
            vo.setAttachList(trainingAttaches);
            vo.setVideoList(trainingVideos);
            vo.setPaperId(training.getPaperId());
            QCloudResponseVo qCloud = (QCloudResponseVo)JSONObject.parseObject((String)QCloudUtils.getDescribeVodPlayInfo((String)(training.getAnnouncer() + training.getRoomId())), QCloudResponseVo.class);
            ArrayList<QCloudFileResponseVo> returnFile = new ArrayList<QCloudFileResponseVo>();
            if (!CollectionUtils.isEmpty((Collection)qCloud.getFileSet())) {
                for (int i = 0; i < qCloud.getFileSet().size(); ++i) {
                    QCloudFileResponseVo file = (QCloudFileResponseVo)qCloud.getFileSet().get(i);
                    if (file.getDuration() <= 10) continue;
                    returnFile.add(file);
                }
                qCloud.setFileSet(returnFile);
            }
            vo.setQCloud(qCloud);
            this.updateTrainingUserLook(trainingId, userId);
            this.trainingMapper.updateByPrimaryKeySelective(training);
            List<TrainingPaperVo> trainingPaperVos = this.getPaperByTrainingIdByPage(userId, trainingId, training.getEnterpriseId(), training.getEnterpriseId(), null);
            Map map = null;
            if (!CollectionUtils.isEmpty(trainingPaperVos)) {
                map = trainingPaperVos.stream().collect(Collectors.toMap(TrainingPaperVo::getId, Function.identity()));
            }
            if (vo != null) {
                if (map != null && vo.getPaperId() != null && map.get(vo.getPaperId()) != null) {
                    vo.setTrainingPaper((TrainingPaperVo)map.get(vo.getPaperId()));
                } else if (vo.getPaperId() != null) {
                    TrainingPaperVo trainingPaperVo = this.trainingPaperMapper.selectTrainingVoById(vo.getPaperId());
                    if (trainingPaperVo != null) {
                        trainingPaperVo.setIsLock(Integer.valueOf(1));
                    }
                    vo.setTrainingPaper(trainingPaperVo);
                }
            }
        }
        return vo;
    }

    @Override
    public List<TrainingLabelVo> getLabelByNameAndNavId(String name, Integer trainingNavId, Integer enterpriseId) {
        ArrayList<TrainingLabelVo> tlVoList = new ArrayList<TrainingLabelVo>();
        List<TrainingLabel> tlList = this.trainingLabelMapper.selectByNameAndNavIdAndEnpId(name, trainingNavId, enterpriseId);
        if (!CollectionUtils.isEmpty(tlList)) {
            for (TrainingLabel tl : tlList) {
                TrainingLabelVo tlVo = new TrainingLabelVo();
                BeanUtils.copyProperties((Object)tl, (Object)tlVo);
                List<TrainingLabelTraining> tltList = this.tltMapper.selectByLabelId(tl.getId());
                if (!CollectionUtils.isEmpty(tltList)) {
                    tlVo.setSize(tltList.size());
                }
                tlVoList.add(tlVo);
            }
        }
        return tlVoList;
    }

    @Override
    public List<TrainingLabelVo> getLearnLabelByNameAndNavId(String name, Integer trainingNavId, Integer enterpriseId, Integer projectShow) {
        ArrayList<TrainingLabelVo> tlVoList = new ArrayList<TrainingLabelVo>();
        List<TrainingLabel> tlList = this.trainingLabelMapper.selectByNameAndNavIdAndEnpId(name, trainingNavId, enterpriseId);
        if (!CollectionUtils.isEmpty(tlList)) {
            for (TrainingLabel tl : tlList) {
                TrainingLabelVo tlVo = new TrainingLabelVo();
                BeanUtils.copyProperties((Object)tl, (Object)tlVo);
                List<TrainingLabelTraining> tltList = this.tltMapper.selectLearnByLabelId(tl.getId(), projectShow);
                if (!CollectionUtils.isEmpty(tltList)) {
                    tlVo.setSize(tltList.size());
                }
                tlVoList.add(tlVo);
            }
        }
        return tlVoList;
    }

    @Override
    public List<TrainingNavVo> getTncVoByCategoryId(Integer categoryId) {
        ArrayList<TrainingNavVo> result = new ArrayList<TrainingNavVo>();
        List<TrainingNavCategory> tncList = this.tncMapper.selectByNavIdAndCategoryId(null, categoryId);
        if (!CollectionUtils.isEmpty(tncList)) {
            for (TrainingNavCategory tnc : tncList) {
                TrainingNavVo tncVo = new TrainingNavVo();
                TrainingNav tn = (TrainingNav)this.trainingNavMapper.selectById(tnc.getTrainingNavId());
                tncVo.setCategoryId(tnc.getCategoryId());
                tncVo.setNavId(tnc.getTrainingNavId());
                tncVo.setNavName(tn.getName());
                if (tnc.getSort() != null) {
                    tncVo.setSort(tnc.getSort());
                }
                tncVo.setId(tnc.getId());
                result.add(tncVo);
            }
        }
        return result;
    }

    @Override
    public Page<TrainingsVo> getTrainingByLabelIdByPage(Page<TrainingsVo> page, Integer labelId, Integer userId) {
        List<TrainingLabelTraining> tltList = this.tltMapper.selectByLabelId(labelId);
        if (!CollectionUtils.isEmpty(tltList)) {
            List<TrainingsVo> trainings = this.trainingMapper.selectByTltListByPage(page, tltList, userId);
            this.getTrainingIsPaper(trainings);
            page.setContent(trainings);
            return page;
        }
        return new Page();
    }

    @Override
    public void saveTrainingLabelOrder(Users user, List<TrainingLabel> order) {
        int num = 1;
        for (TrainingLabel label : order) {
            label.setSort(Integer.valueOf(num));
            this.trainingLabelMapper.updateByPrimaryKeySelective(label);
            ++num;
        }
    }

    private void sendAddKaFKaWorkCircleArticleAddMo(String title, String childModuleName, Integer circleId, Integer createBy, Integer groupId, Integer publicFlag, Integer sourceId, List<Integer> canSeeUserList) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleAddMo addMo = new KaFKaWorkCircleArticleAddMo();
        addMo.setTitle(title);
        addMo.setChildModuleName(childModuleName);
        addMo.setCircleId(circleId);
        addMo.setCreateAt(DateUtils.format(new Date(), DateUtils.FORMAT_LONG));
        addMo.setCreateBy(createBy);
        addMo.setGroupId(groupId);
        addMo.setPublicFlag(publicFlag);
        addMo.setSourceId(sourceId);
        addMo.setCanSeeUserList(canSeeUserList);
        kaFKaWorkCircleArticleMo.setAddMo(addMo);
        kaFKaWorkCircleArticleMo.setType("ADD");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("\u8bfe\u7a0bkafka\u63a8\u9001", (Throwable)e);
                }
            }
        });
    }

    private void delKaFKaWorkCircleArticleMo(String childModuleName, Integer circleId, Integer groupId, Integer sourceId) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleDelMo delMo = new KaFKaWorkCircleArticleDelMo();
        delMo.setChildModuleName(childModuleName);
        delMo.setCircleId(circleId);
        delMo.setGroupId(groupId);
        delMo.setSourceId(sourceId);
        kaFKaWorkCircleArticleMo.setDelMo(delMo);
        kaFKaWorkCircleArticleMo.setType("DEL");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    private void updateKaFKaWorkCircleArticleMo(String childModuleName, Integer circleId, Integer groupId, Integer sourceId, Integer publicFlag, List<Integer> canSeeUserList) {
        final KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleUpdSeeUsersMo updMo = new KaFKaWorkCircleArticleUpdSeeUsersMo();
        updMo.setChildModuleName(childModuleName);
        updMo.setCircleId(circleId);
        updMo.setGroupId(groupId);
        updMo.setSourceId(sourceId);
        updMo.setPublicFlag(publicFlag);
        updMo.setCanSeeUserList(canSeeUserList);
        kaFKaWorkCircleArticleMo.setUpdSeeUsersMo(updMo);
        kaFKaWorkCircleArticleMo.setType("UPD_SEE_USERS");
        this.cachedThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TrainingRemoteServiceImpl.this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    @Override
    public TrainingAddVo getTraining(Integer id) {
        List<Integer> userIds;
        Training training = (Training)this.trainingMapper.selectById(id);
        List<TrainingLabelTraining> trainingLabelTrainings = this.tltMapper.selectByTrainingId(id);
        List<TrainingVideo> trainingVideos = this.trainingVideoMapper.selectByTrainingId(id);
        List<TrainingAttach> trainingAttachs = this.trainingAttachMapper.selectByTrainingId(id);
        List<TrainingPaperVo> trainingPaperVo = this.trainingPaperMapper.selectVoByTrainingId(id);
        for (TrainingPaperVo trainingPaperVo1 : trainingPaperVo) {
            trainingPaperVo1.setEnterpriseName(((EnterpriseGroupMo)this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(trainingPaperVo1.getEnterpriseId()).getData()).getName());
        }
        List<TrainingLecturerVo> lecturerVos = this.andLecturerMapper.selectLecturerByTraining(id);
        if (!CollectionUtils.isEmpty(lecturerVos) && !CollectionUtils.isEmpty(userIds = lecturerVos.stream().map(TrainingLecturer::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
            for (TrainingLecturerVo vo : lecturerVos) {
                UsersPojo usersPojo;
                if (vo.getUserId() == null || ObjectUtils.isEmpty((Object)(usersPojo = userMap.get(vo.getUserId())))) continue;
                vo.setUserName(usersPojo.getShowName());
                vo.setThumbUrl(usersPojo.getThumbUrl());
            }
        }
        TrainingAddVo trainingAddVo = new TrainingAddVo();
        if (!StringUtils.isEmpty((Object)training)) {
            TrainingLabel trainingLabel;
            trainingAddVo.setEnterpriseId(training.getEnterpriseId());
            trainingAddVo.setDescription(training.getDescription());
            trainingAddVo.setHeadUrl(training.getHeadUrl());
            trainingAddVo.setPath(training.getPath());
            trainingAddVo.setSpeaker(training.getSpeaker());
            trainingAddVo.setLecturerVos(lecturerVos);
            trainingAddVo.setIsPrivate(training.getIsPrivate());
            trainingAddVo.setSpeakerDescription(training.getSpeakerDescription());
            trainingAddVo.setTitle(training.getTitle());
            trainingAddVo.setTrainingNavId(training.getTrainingNavId());
            trainingAddVo.setAttachUrls(trainingAttachs);
            trainingAddVo.setVideoUrls(trainingVideos);
            trainingAddVo.setIsChapter(training.getIsChapter());
            trainingAddVo.setIsLock(training.getIsLock());
            trainingAddVo.setIsShare(training.getIsShare());
            if (training.getPaperId() != null) {
                trainingAddVo.setPaperId(training.getPaperId());
                TrainingPaper cTraining = (TrainingPaper)this.trainingPaperMapper.selectById(training.getPaperId());
                trainingAddVo.setPaperName(cTraining == null ? "" : cTraining.getTitle());
            }
            List<Object> trainingMaterials = new ArrayList();
            ArrayList<TrainingChapterVo> chapterVos = new ArrayList<TrainingChapterVo>();
            if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(id);
                if (!CollectionUtils.isEmpty(trainingChapters)) {
                    for (TrainingChapter trainingChapter : trainingChapters) {
                        List<TrainingChapterAttachVo> trainingChapterAttachs = this.trainingChapterAttachMapper.selectByChapterId(trainingChapter.getId());
                        List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectByChapterId(trainingChapter.getId());
                        List<TrainingMaterialVo> trainingMaterialVos = this.andMaterialMapper.selectMaterialByTraining(id, trainingChapter.getId());
                        TrainingChapterVo chapterVo = new TrainingChapterVo();
                        chapterVo.setChapterSort(trainingChapter.getChapterSort());
                        chapterVo.setName(trainingChapter.getName());
                        chapterVo.setChapterAttachs(trainingChapterAttachs);
                        chapterVo.setChapterVideos(trainingChapterVideos);
                        chapterVo.setMaterialVos(trainingMaterialVos);
                        chapterVo.setId(trainingChapter.getId());
                        chapterVo.setTrainingId(id);
                        chapterVo.setPaperId(trainingChapter.getPaperId());
                        chapterVo.setScore(trainingChapter.getScore());
                        chapterVo.setStatus(trainingChapter.getStatus());
                        chapterVo.setIsLock(trainingChapter.getIsLock());
                        if (trainingChapter.getPaperId() != null) {
                            TrainingPaper cTraining = (TrainingPaper)this.trainingPaperMapper.selectById(trainingChapter.getPaperId());
                            chapterVo.setPaperName(cTraining == null ? "" : cTraining.getTitle());
                        }
                        chapterVos.add(chapterVo);
                    }
                }
            } else {
                trainingMaterials = this.andMaterialMapper.selectMaterialByTraining(id, null);
            }
            trainingAddVo.setMaterialVos(trainingMaterials);
            trainingAddVo.setChapterVos(chapterVos);
            trainingAddVo.setTrainingPaperVos(trainingPaperVo);
            if (!CollectionUtils.isEmpty(trainingLabelTrainings) && (trainingLabel = this.trainingLabelMapper.selectByPrimaryKey(trainingLabelTrainings.get(0).getTrainingLabelId())) != null) {
                trainingAddVo.setLabelIds(trainingLabel.getId().toString());
            }
        }
        return trainingAddVo;
    }

    @Override
    public List<TrainingChapterVo> getTrainingChapterVo(Integer trainingId, Integer userId) {
        ClientInfo clientInfo = Authenticator.getInstance().getCurrentClient();
        String version = "";
        String clientName = "";
        if (!StringUtils.isEmpty((Object)clientInfo)) {
            if (!StringUtils.isEmpty((Object)clientInfo.getVersion())) {
                String[] vers = clientInfo.getVersion().trim().split("_");
                version = vers[0];
            }
            if (!StringUtils.isEmpty((Object)clientInfo.getClient())) {
                clientName = clientInfo.getClient().trim();
            }
        }
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        ArrayList<TrainingChapterVo> chapterVos = new ArrayList<TrainingChapterVo>();
        if (!StringUtils.isEmpty((Object)training)) {
            List<TrainingChapter> trainingChapters;
            if (training.getIsChapter() != null && training.getIsChapter() == 1 && !CollectionUtils.isEmpty(trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId))) {
                this.updateTrainingChapterOpenTraining(userId, trainingId, trainingChapters.get(0).getId());
                for (int i = 0; i < trainingChapters.size(); ++i) {
                    TrainingChapterUnlock trainingChapterUnlock;
                    List<TrainingChapterAttachVo> trainingChapterAttachs = this.trainingChapterAttachMapper.selectByChapterId(trainingChapters.get(i).getId());
                    if (!"h5".equalsIgnoreCase(clientName) && version.compareTo("4.48.01") < 0 && !CollectionUtils.isEmpty(trainingChapterAttachs)) {
                        ArrayList<TrainingChapterAttachVo> delList = new ArrayList<TrainingChapterAttachVo>();
                        for (TrainingChapterAttachVo vo : trainingChapterAttachs) {
                            if (StringUtils.isEmpty((Object)vo.getIsCommodity()) || vo.getIsCommodity() != 1) continue;
                            delList.add(vo);
                        }
                        if (!CollectionUtils.isEmpty(delList)) {
                            trainingChapterAttachs.removeAll(delList);
                        }
                    }
                    List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectByChapterId(trainingChapters.get(i).getId());
                    Integer isLock = 0;
                    if (i != 0 && training.getIsChapter() == 1 && (trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(i).getId())) == null) {
                        isLock = 1;
                    }
                    this.setIsFinish(userId, trainingId, trainingChapterAttachs, trainingChapterVideos);
                    TrainingChapterVo chapterVo = new TrainingChapterVo();
                    chapterVo.setName(trainingChapters.get(i).getName());
                    chapterVo.setChapterAttachs(trainingChapterAttachs);
                    chapterVo.setChapterVideos(trainingChapterVideos);
                    chapterVo.setId(trainingChapters.get(i).getId());
                    chapterVo.setTrainingId(trainingId);
                    chapterVo.setIsLock(isLock);
                    chapterVo.setScore(trainingChapters.get(i).getScore());
                    chapterVo.setPaperId(trainingChapters.get(i).getPaperId());
                    chapterVos.add(chapterVo);
                }
            }
            List<TrainingPaperVo> trainingPaperVos = this.getPaperByTrainingIdByPage(userId, trainingId, training.getEnterpriseId(), training.getEnterpriseId(), null);
            Map map = null;
            if (!CollectionUtils.isEmpty(trainingPaperVos)) {
                map = trainingPaperVos.stream().collect(Collectors.toMap(TrainingPaperVo::getId, Function.identity()));
            }
            if (!CollectionUtils.isEmpty(chapterVos)) {
                for (TrainingChapterVo trainingChapterVo : chapterVos) {
                    if (map != null && trainingChapterVo.getPaperId() != null && map.get(trainingChapterVo.getPaperId()) != null) {
                        trainingChapterVo.setTrainingPaper((TrainingPaperVo)map.get(trainingChapterVo.getPaperId()));
                        continue;
                    }
                    if (trainingChapterVo.getPaperId() == null) continue;
                    TrainingPaperVo trainingPaperVo = this.trainingPaperMapper.selectTrainingVoById(trainingChapterVo.getPaperId());
                    if (!StringUtils.isEmpty((Object)trainingPaperVo)) {
                        trainingPaperVo.setIsLock(Integer.valueOf(1));
                    }
                    trainingChapterVo.setTrainingPaper(trainingPaperVo);
                }
            }
        }
        return chapterVos;
    }

    public List<TrainingPaperVo> getPaperByTrainingIdByPage(Integer userId, Integer trainingId, Integer userEnterpriseId, Integer enterpriseId, Integer showOptions) {
        List<TrainingChapter> trainingChapters;
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        ArrayList<Integer> paperIds = new ArrayList<Integer>();
        ArrayList<TrainingPaperVo> newPaperVoList = new ArrayList<TrainingPaperVo>();
        if (training.getIsChapter() != null && training.getIsChapter() != 1 && training.getPaperId() != null) {
            List<TrainingAttachUser> attachUserList = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, trainingId, null, null);
            for (TrainingAttachUser attachUser : attachUserList) {
                if (attachUser.getIsVideo() == 1) {
                    TrainingVideo trainingVideo = this.trainingVideoMapper.selectByPrimaryKey(attachUser.getAttachId());
                    if (trainingVideo == null || trainingVideo.getTrainingId().intValue() != trainingId.intValue()) {
                        this.trainingAttachUserMapper.deleteByPrimaryKey(attachUser.getId());
                        continue;
                    }
                    if (attachUser.getVideoSize() != null) continue;
                    TrainingAttachUser attachUsers = new TrainingAttachUser();
                    attachUsers.setId(attachUser.getId());
                    attachUsers.setIsVideo(Integer.valueOf(1));
                    attachUsers.setVideoSize(trainingVideo.getDuration());
                    this.trainingAttachUserMapper.updateByPrimaryKeySelective(attachUsers);
                    continue;
                }
                TrainingAttach trainingAttach = this.trainingAttachMapper.selectByPrimaryKey(attachUser.getAttachId());
                if (trainingAttach != null && trainingAttach.getTrainingId().intValue() == trainingId.intValue()) continue;
                this.trainingAttachUserMapper.deleteByPrimaryKey(attachUser.getId());
            }
            if (training.getIsLock() != null && training.getIsLock() == 1) {
                int attachSize = this.getTrainingOldAttachSize(trainingId);
                List<Integer> finishUser = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize, StringsUtils.StringToList(userId + "", ","));
                if (!CollectionUtils.isEmpty(finishUser)) {
                    paperIds.add(training.getPaperId());
                }
            } else {
                paperIds.add(training.getPaperId());
            }
        } else if (training.getIsChapter() != null && training.getIsChapter() == 1 && !CollectionUtils.isEmpty(trainingChapters = this.getChapterIsUnlock(trainingId, userId))) {
            for (TrainingChapter trainingChapter : trainingChapters) {
                if (trainingChapter.getPaperId() == null) continue;
                paperIds.add(trainingChapter.getPaperId());
            }
        }
        if (!CollectionUtils.isEmpty(paperIds)) {
            Page newPage = new Page();
            newPage.setPageNumber(1);
            newPage.setPageSize(1000);
            List<Object> paperVoList = new ArrayList();
            paperVoList = this.commonRemoteService.isRoot(userId) != false ? this.trainingPaperMapper.selectAllByPaperIdsByPage((Page<TrainingPaperVo>)newPage, userId, enterpriseId, new Date(), showOptions, paperIds) : this.trainingPaperMapper.selectAllByPaperIdsByPage((Page<TrainingPaperVo>)newPage, userId, userEnterpriseId, new Date(), showOptions, paperIds);
            if (!CollectionUtils.isEmpty(paperVoList)) {
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    List<TrainingPaperQuestion> list;
                    trainingPaperVo.setIsLock(Integer.valueOf(0));
                    TrainingUserPaper userPaper = this.trainingUserPaperMapper.selectByPrimaryKey(trainingPaperVo.getUserPaperId());
                    if (userPaper != null && trainingPaperVo.getUserPaperId() != null) {
                        trainingPaperVo.setScore(Double.valueOf(userPaper.getScore().doubleValue()));
                        if (0 == userPaper.getPaperStatus()) {
                            if (trainingPaperVo.getEndTime() != null && trainingPaperVo.getEndTime().getTime() < new Date().getTime()) {
                                trainingPaperVo.setUserStatus(Integer.valueOf(7));
                                continue;
                            }
                            trainingPaperVo.setUserStatus(Integer.valueOf(3));
                            continue;
                        }
                        if (userPaper.getScore() != null && userPaper.getScore().intValue() >= 60 && userPaper.getScore().intValue() != 100 && 1 != userPaper.getPaperStatus()) {
                            trainingPaperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (userPaper.getScore() != null && userPaper.getScore().intValue() == 100 && 1 != userPaper.getPaperStatus()) {
                            trainingPaperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (userPaper.getScore() != null && userPaper.getScore().intValue() < 60 && 1 != userPaper.getPaperStatus()) {
                            trainingPaperVo.setUserStatus(Integer.valueOf(4));
                            continue;
                        }
                        if (1 != userPaper.getPaperStatus()) continue;
                        trainingPaperVo.setUserStatus(Integer.valueOf(5));
                        continue;
                    }
                    if (trainingPaperVo.getEndTime() != null && trainingPaperVo.getEndTime().getTime() < new Date().getTime()) {
                        trainingPaperVo.setUserStatus(Integer.valueOf(7));
                    } else {
                        trainingPaperVo.setUserStatus(Integer.valueOf(3));
                    }
                    if (!CollectionUtils.isEmpty(list = this.trainingPaperQuestionMapper.selectByPaperId(trainingPaperVo.getId()))) continue;
                    trainingPaperVo.setHasQuestion(Integer.valueOf(0));
                }
            }
            if (!CollectionUtils.isEmpty(paperVoList)) {
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getEndTime() == null || trainingPaperVo.getUserStatus() != 3) continue;
                    newPaperVoList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getEndTime() != null || trainingPaperVo.getUserStatus() != 3) continue;
                    newPaperVoList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != 2 && trainingPaperVo.getUserStatus() != 6 && trainingPaperVo.getUserStatus() != 4 && trainingPaperVo.getUserStatus() != 5) continue;
                    newPaperVoList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != 7) continue;
                    newPaperVoList.add(trainingPaperVo);
                }
                for (TrainingPaperVo trainingPaperVo : paperVoList) {
                    if (trainingPaperVo.getUserStatus() != null) continue;
                    newPaperVoList.add(trainingPaperVo);
                }
            }
        }
        return newPaperVoList;
    }

    private List<TrainingChapter> getChapterIsUnlock(Integer trainingId, Integer userId) {
        TrainingChapterUnlock trainingChapterUnlock;
        ArrayList<TrainingChapter> newChapter = new ArrayList<TrainingChapter>();
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        for (int i = 0; i < trainingChapters.size() && (trainingChapters.get(i).getIsLock() != 1 || (trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(i).getId())) != null && trainingChapterUnlock.getIsUnlock() != 1); ++i) {
            newChapter.add(trainingChapters.get(i));
        }
        return newChapter;
    }

    private void setIsFinish(Integer userId, Integer trainingId, List<TrainingChapterAttachVo> trainingChapterAttachs, List<TrainingChapterVideo> trainingChapterVideos) {
        Integer isFinish;
        List<TrainingChapterAttachUser> trainingChapterAttachUsers;
        if (!CollectionUtils.isEmpty(trainingChapterAttachs)) {
            for (TrainingChapterAttachVo trainingChapterAttach : trainingChapterAttachs) {
                trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(null, userId, trainingId, trainingChapterAttach.getId(), null);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers)) {
                    isFinish = trainingChapterAttachUsers.get(0).getIsFinish();
                    trainingChapterAttach.setIsFinish(Integer.valueOf(isFinish == null ? 1 : isFinish));
                    continue;
                }
                trainingChapterAttach.setIsFinish(Integer.valueOf(0));
            }
        }
        if (!CollectionUtils.isEmpty(trainingChapterVideos)) {
            for (TrainingChapterVideo trainingChapterVideo : trainingChapterVideos) {
                trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(null, userId, trainingId, trainingChapterVideo.getId(), 1);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers)) {
                    isFinish = trainingChapterAttachUsers.get(0).getIsFinish();
                    trainingChapterVideo.setIsFinish(Integer.valueOf(isFinish == null ? 1 : isFinish));
                    continue;
                }
                trainingChapterVideo.setIsFinish(Integer.valueOf(0));
            }
        }
    }

    private void setOldIsFinish(Integer userId, Integer trainingId, List<TrainingAttach> trainingChapterAttachs, List<TrainingVideo> trainingChapterVideos) {
        Integer isFinish;
        List<TrainingAttachUser> trainingChapterAttachUsers;
        if (!CollectionUtils.isEmpty(trainingChapterAttachs)) {
            for (TrainingAttach trainingChapterAttach : trainingChapterAttachs) {
                trainingChapterAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, trainingId, trainingChapterAttach.getId(), 0);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers)) {
                    isFinish = trainingChapterAttachUsers.get(0).getIsFinish();
                    trainingChapterAttach.setIsFinish(Integer.valueOf(isFinish == null ? 1 : isFinish));
                    continue;
                }
                trainingChapterAttach.setIsFinish(Integer.valueOf(0));
            }
        }
        if (!CollectionUtils.isEmpty(trainingChapterVideos)) {
            for (TrainingVideo trainingChapterVideo : trainingChapterVideos) {
                trainingChapterAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(null, userId, trainingId, trainingChapterVideo.getId(), 1);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers)) {
                    isFinish = trainingChapterAttachUsers.get(0).getIsFinish();
                    trainingChapterVideo.setIsFinish(Integer.valueOf(isFinish == null ? 1 : isFinish));
                    continue;
                }
                trainingChapterVideo.setIsFinish(Integer.valueOf(0));
            }
        }
    }

    private void updateTrainingChapterOpenTraining(Integer userId, Integer trainingId, Integer chapterId) {
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        TrainingChapter trainingChapter = this.trainingChapterMapper.selectByPrimaryKey(chapterId);
        if (trainingChapter != null && trainingChapter.getIsLock() == 1 && trainingChapter.getStatus() == 1) {
            return;
        }
        block0: for (int i = 0; i < trainingChapters.size() && (trainingChapters.size() > 1 || trainingChapters.get(i).getIsLock() != 1); ++i) {
            if (trainingChapters.get(i).getId().intValue() != chapterId.intValue() || i == trainingChapters.size() - 1 || trainingChapters.get(i).getStatus() != 0) continue;
            for (int j = i + 1; j < trainingChapters.size(); ++j) {
                TrainingChapterUnlock trainingChapterUnlock1 = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(j).getId());
                if (trainingChapterUnlock1 != null) continue;
                trainingChapterUnlock1 = new TrainingChapterUnlock();
                trainingChapterUnlock1.setUserId(userId);
                trainingChapterUnlock1.setChapterId(trainingChapters.get(j).getId());
                trainingChapterUnlock1.setCreateTime(new Date());
                if (trainingChapters.get(j).getIsLock() != null && trainingChapters.get(j).getIsLock() == 0) {
                    trainingChapterUnlock1.setIsUnlock(Integer.valueOf(0));
                } else {
                    trainingChapterUnlock1.setIsUnlock(Integer.valueOf(1));
                }
                trainingChapterUnlock1.setTrainingId(trainingId);
                this.trainingChapterUnlockMapper.insert(trainingChapterUnlock1);
                if (trainingChapterUnlock1.getIsUnlock() == 1) continue block0;
            }
        }
    }

    @Override
    public void updateTrainingProgress(Integer trainingId, Integer chapterId, Integer attachId, Integer isVideo, Users user, Integer playSize) {
        List<TrainingChapterAttachUser> trainingChapterAttachUser = this.trainingChapterAttachUserMapper.selectByUserId(attachId, isVideo, user.getId(), null, trainingId, null, null);
        int attachSize = this.getTrainingAttachSize(trainingId);
        if (CollectionUtils.isEmpty(trainingChapterAttachUser)) {
            TrainingChapterAttachUser attachUser = new TrainingChapterAttachUser();
            attachUser.setAttachId(attachId);
            attachUser.setChapterId(chapterId);
            attachUser.setIsVideo(isVideo);
            attachUser.setTrainingId(trainingId);
            attachUser.setUserId(user.getId());
            attachUser.setCreateTime(new Date());
            TrainingChapterAttach chapterAttach = (TrainingChapterAttach)this.trainingChapterAttachMapper.selectById(attachId);
            Integer materialId = null;
            if (!StringUtils.isEmpty((Object)chapterAttach)) {
                materialId = chapterAttach.getMaterialId();
            }
            if (StringUtils.isEmpty(materialId)) {
                if (isVideo == 1 && !StringUtils.isEmpty((Object)playSize)) {
                    TrainingChapterVideo trainingVideo = this.trainingChapterVideoMapper.selectByPrimaryKey(attachId);
                    Integer duration = 0;
                    if (!StringUtils.isEmpty((Object)trainingVideo)) {
                        duration = trainingVideo.getDuration();
                    }
                    attachUser.setPlaySize(playSize >= duration ? duration : playSize);
                    attachUser.setVideoSize(duration);
                    attachUser.setIsFinish(Integer.valueOf(playSize >= duration ? 1 : 2));
                } else {
                    attachUser.setIsFinish(Integer.valueOf(1));
                }
            } else {
                TrainingMaterial material = (TrainingMaterial)this.materialMapper.selectById(materialId);
                if (!StringUtils.isEmpty((Object)material) && !StringUtils.isEmpty((Object)playSize)) {
                    Integer duration = 0;
                    duration = material.getIsVideo() == 1 ? Integer.valueOf(StringUtils.isEmpty((Object)material.getDuration()) ? 0 : material.getDuration()) : Integer.valueOf(StringUtils.isEmpty((Object)material.getFinishTime()) ? 0 : material.getFinishTime());
                    attachUser.setPlaySize(playSize >= duration ? duration : playSize);
                    attachUser.setVideoSize(duration);
                    attachUser.setIsFinish(Integer.valueOf(playSize >= duration ? 1 : 2));
                } else {
                    attachUser.setPlaySize(playSize);
                    attachUser.setVideoSize(Integer.valueOf(0));
                    attachUser.setIsFinish(Integer.valueOf(1));
                }
            }
            this.trainingChapterAttachUserMapper.insert(attachUser);
            if (attachUser.getIsFinish() == 1 && attachSize != 0) {
                this.updateProgress(user, attachSize, trainingId, chapterId);
            }
        } else {
            TrainingChapterAttachUser chapterAttachUser = trainingChapterAttachUser.get(0);
            if (trainingChapterAttachUser.size() > 1) {
                for (int i = 1; i < trainingChapterAttachUser.size(); ++i) {
                    this.trainingChapterAttachUserMapper.deleteById(trainingChapterAttachUser.get(i).getId());
                }
            }
            if (!ObjectUtils.isEmpty((Object)chapterAttachUser) && chapterAttachUser.getIsFinish() != null && chapterAttachUser.getIsFinish() != 1) {
                Integer oldPlaySize = chapterAttachUser.getPlaySize() != null ? chapterAttachUser.getPlaySize() : 0;
                Integer videoSize = chapterAttachUser.getVideoSize() != null ? chapterAttachUser.getVideoSize() : 0;
                playSize = playSize != null ? playSize : 0;
                chapterAttachUser.setPlaySize(Integer.valueOf(oldPlaySize + playSize >= videoSize ? videoSize : oldPlaySize + playSize));
                chapterAttachUser.setIsFinish(Integer.valueOf(chapterAttachUser.getPlaySize() >= chapterAttachUser.getVideoSize() ? 1 : 2));
                this.trainingChapterAttachUserMapper.updateByPrimaryKey(chapterAttachUser);
                if (chapterAttachUser.getIsFinish() == 1 && attachSize != 0) {
                    this.updateProgress(user, attachSize, trainingId, chapterId);
                }
            }
        }
        try {
            this.appTrainingLearnProjectService.updateRate(trainingId, user.getId());
        }
        catch (Exception e) {
            log.error("\u5b66\u4e60\u9879\u76ee-\u66f4\u65b0\u8bfe\u7a0b\u8fdb\u5ea6", (Throwable)e);
        }
        try {
            this.jobCertificationService.updateTrainingStatus(trainingId, user.getId());
        }
        catch (Exception e) {
            log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
        }
        if (!StringUtils.isEmpty((Object)user.getId()) && !StringUtils.isEmpty((Object)trainingId)) {
            try {
                this.jPushService.deleteMessages(trainingId, "TYPE_TRAINING_SYSTEM", user.getId(), null, 1);
                log.info(trainingId + " , " + user.getId());
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
    }

    private void updateProgress(Users user, Integer attachSize, Integer trainingId, Integer chapterId) {
        List<TrainingChapterProgress> trainingChapterProgresss = this.trainingChapterProgressMapper.selectByUserId(user.getId(), trainingId, null, null, null);
        TrainingChapterProgress chapterProgress = null;
        if (CollectionUtils.isEmpty(trainingChapterProgresss)) {
            chapterProgress = new TrainingChapterProgress();
            chapterProgress.setCreateTime(new Date());
            chapterProgress.setEnterpriseId(user.getGroupId());
            chapterProgress.setProgress(Integer.valueOf(100 / attachSize));
            chapterProgress.setReadSize(Integer.valueOf(1));
            chapterProgress.setTrainingId(trainingId);
            chapterProgress.setUserId(user.getId());
            chapterProgress.setUpdateTime(new Date());
            this.trainingChapterProgressMapper.insert(chapterProgress);
        } else {
            chapterProgress = trainingChapterProgresss.get(0);
            Integer readSize = chapterProgress.getReadSize();
            chapterProgress.setUpdateTime(new Date());
            chapterProgress.setReadSize(Integer.valueOf(readSize + 1));
            chapterProgress.setProgress(Integer.valueOf((readSize + 1) * 100 / attachSize));
            this.trainingChapterProgressMapper.updateByPrimaryKey(chapterProgress);
        }
        if (this.getChapterIsFinish(user.getId(), chapterId)) {
            this.updateTrainingChapter(user.getId(), trainingId, chapterId);
        }
    }

    @Override
    public void updateOldTrainingProgress(Integer trainingId, Integer attachId, Integer isVideo, Users user, Integer playSize) {
        List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectByUserId(attachId, isVideo, user.getId(), trainingId, null, null);
        if (CollectionUtils.isEmpty(trainingAttachUsers)) {
            Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
            TrainingAttachUser trainingAttachUser = new TrainingAttachUser();
            trainingAttachUser.setAttachId(attachId);
            trainingAttachUser.setCreateTime(new Date());
            trainingAttachUser.setIsVideo(isVideo);
            trainingAttachUser.setTrainingId(trainingId);
            trainingAttachUser.setUserId(user.getId());
            if (isVideo != null && isVideo == 1 && playSize != null) {
                TrainingVideo trainingVideo = this.trainingVideoMapper.selectByPrimaryKey(attachId);
                Integer duration = 0;
                if (!StringUtils.isEmpty((Object)trainingVideo)) {
                    duration = StringUtils.isEmpty((Object)trainingVideo.getDuration()) ? 0 : trainingVideo.getDuration();
                }
                trainingAttachUser.setPlaySize(playSize >= duration ? duration : playSize);
                trainingAttachUser.setVideoSize(duration);
                trainingAttachUser.setIsFinish(Integer.valueOf(playSize >= duration ? 1 : 2));
            } else {
                trainingAttachUser.setIsFinish(Integer.valueOf(1));
            }
            this.trainingAttachUserMapper.insert(trainingAttachUser);
            if (trainingAttachUser.getIsFinish() == 1) {
                this.updateTrainingAddGold(trainingId, user);
            }
        } else {
            TrainingAttachUser trainingAttachUser = trainingAttachUsers.get(0);
            if (trainingAttachUsers.size() > 1) {
                for (int i = 1; i < trainingAttachUsers.size(); ++i) {
                    this.trainingAttachUserMapper.deleteByPrimaryKey(trainingAttachUsers.get(i).getId());
                }
            }
            if (!StringUtils.isEmpty((Object)trainingAttachUser.getIsFinish()) && trainingAttachUser.getIsFinish() != 1) {
                Integer oldPlaySize = trainingAttachUser.getPlaySize();
                trainingAttachUser.setPlaySize(Integer.valueOf(oldPlaySize + playSize >= trainingAttachUser.getVideoSize() ? trainingAttachUser.getVideoSize() : oldPlaySize + playSize));
                trainingAttachUser.setIsFinish(Integer.valueOf(trainingAttachUser.getPlaySize() >= trainingAttachUser.getVideoSize() ? 1 : 2));
                this.trainingAttachUserMapper.updateByPrimaryKey(trainingAttachUser);
                if (trainingAttachUser.getIsFinish() == 1) {
                    this.updateTrainingAddGold(trainingId, user);
                }
            }
        }
        try {
            this.appTrainingLearnProjectService.updateRate(trainingId, user.getId());
        }
        catch (Exception e) {
            log.error("\u5b66\u4e60\u9879\u76ee", (Throwable)e);
        }
        try {
            this.jobCertificationService.updateTrainingStatus(trainingId, user.getId());
        }
        catch (Exception e) {
            log.error("\u5c97\u4f4d\u5b66\u4e60\u65b0\u52a0\u903b\u8f91", (Throwable)e);
        }
        if (!StringUtils.isEmpty((Object)user.getId()) && !StringUtils.isEmpty((Object)trainingId)) {
            try {
                this.jPushService.deleteMessages(trainingId, "TYPE_TRAINING_SYSTEM", user.getId(), null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
    }

    @Override
    public void updateTrainingAddGold(Integer trainingId, Users user) {
        try {
            if (this.trainingIsFinish(user.getId(), trainingId).booleanValue()) {
                log.info("training finish:{}" + trainingId);
                this.goldApi.updateGoldByType(trainingId, Integer.valueOf(24), user.getId(), null, null, null);
            }
        }
        catch (Exception e) {
            log.error("\u8bfe\u7a0b\u5b8c\u6210\u52a0\u91d1\u5e01", (Throwable)e);
        }
    }

    private int getTrainingAttachSize(Integer trainingId) {
        List<TrainingChapterAttach> trainingChapterAttachs = this.trainingChapterAttachMapper.selectAllByTrainingId(trainingId);
        List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectAllByTrainingId(trainingId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        return attachSize + videoSize;
    }

    private int getTrainingOldAttachSize(Integer trainingId) {
        List<TrainingAttach> trainingChapterAttachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
        List<TrainingVideo> trainingChapterVideos = this.trainingVideoMapper.selectByTrainingId(trainingId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        return attachSize + videoSize;
    }

    private boolean getChapterIsFinish(Integer userId, Integer chapterId) {
        List<TrainingChapterAttachVo> trainingChapterAttachs = this.trainingChapterAttachMapper.selectByChapterId(chapterId);
        List<TrainingChapterVideo> trainingChapterVideos = this.trainingChapterVideoMapper.selectByChapterId(chapterId);
        int attachSize = CollectionUtils.isEmpty(trainingChapterAttachs) ? 0 : trainingChapterAttachs.size();
        int videoSize = CollectionUtils.isEmpty(trainingChapterVideos) ? 0 : trainingChapterVideos.size();
        List<TrainingChapterAttachUser> trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectByUserId(null, null, userId, chapterId, null, null, null);
        int userSize = CollectionUtils.isEmpty(trainingChapterAttachUsers) ? 0 : trainingChapterAttachUsers.size();
        return userSize >= attachSize + videoSize;
    }

    @Override
    public void updateTrainingChapter(Integer userId, Integer trainingId, Integer chapterId) {
        TrainingChapterUnlock trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, chapterId);
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        TrainingChapter trainingChapter = this.trainingChapterMapper.selectByPrimaryKey(chapterId);
        if (trainingChapterUnlock == null) {
            trainingChapterUnlock = new TrainingChapterUnlock();
            trainingChapterUnlock.setUserId(userId);
            trainingChapterUnlock.setChapterId(chapterId);
            trainingChapterUnlock.setCreateTime(new Date());
            trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
            trainingChapterUnlock.setTrainingId(trainingId);
            this.trainingChapterUnlockMapper.insert(trainingChapterUnlock);
            if (trainingChapter != null && trainingChapter.getIsLock() == 1 && trainingChapter.getStatus() == 1) {
                return;
            }
        } else {
            trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
            this.trainingChapterUnlockMapper.updateByPrimaryKey(trainingChapterUnlock);
        }
        block0: for (int i = 0; i < trainingChapters.size() && (trainingChapters.size() > 1 || trainingChapters.get(i).getIsLock() != 1); ++i) {
            if (trainingChapters.get(i).getId().intValue() != chapterId.intValue() || i == trainingChapters.size() - 1 || trainingChapters.get(i).getStatus() != 0) continue;
            for (int j = i + 1; j < trainingChapters.size(); ++j) {
                TrainingChapterUnlock trainingChapterUnlock1 = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(j).getId());
                if (trainingChapterUnlock1 != null) continue;
                trainingChapterUnlock1 = new TrainingChapterUnlock();
                trainingChapterUnlock1.setUserId(userId);
                trainingChapterUnlock1.setChapterId(trainingChapters.get(j).getId());
                trainingChapterUnlock1.setCreateTime(new Date());
                if (trainingChapters.get(j).getIsLock() != null && trainingChapters.get(j).getIsLock() == 0) {
                    trainingChapterUnlock1.setIsUnlock(Integer.valueOf(0));
                } else {
                    trainingChapterUnlock1.setIsUnlock(Integer.valueOf(1));
                }
                trainingChapterUnlock1.setTrainingId(trainingId);
                this.trainingChapterUnlockMapper.insert(trainingChapterUnlock1);
                if (trainingChapterUnlock1.getIsUnlock() == 1) continue block0;
            }
        }
    }

    @Override
    public void updateUserChapterPaper(Integer userId, Integer trainingId, Integer paperId, Double score) {
        TrainingUserPaper trainingUserPaper;
        List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(trainingId);
        List<TrainingUserPaper> trainingUserPapers = this.trainingUserPaperMapper.selectByUserIdAndPaperIdById(userId, paperId);
        if (!CollectionUtils.isEmpty(trainingUserPapers) && (trainingUserPaper = trainingUserPapers.get(0)).getPaperStatus() == 1) {
            return;
        }
        if (!CollectionUtils.isEmpty(trainingChapters)) {
            block0: for (int i = 0; i < trainingChapters.size(); ++i) {
                if (trainingChapters.get(i).getPaperId() == null || paperId.compareTo(trainingChapters.get(i).getPaperId()) != 0 || trainingChapters.get(i).getScore() == null || !(Double.parseDouble(trainingChapters.get(i).getScore().toString()) <= score)) continue;
                if (i != trainingChapters.size() - 1) {
                    for (int j = i + 1; j < trainingChapters.size(); ++j) {
                        TrainingChapterUnlock trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(j).getId());
                        if (trainingChapterUnlock != null) continue;
                        trainingChapterUnlock = new TrainingChapterUnlock();
                        trainingChapterUnlock.setUserId(userId);
                        trainingChapterUnlock.setChapterId(trainingChapters.get(j).getId());
                        trainingChapterUnlock.setCreateTime(new Date());
                        if (trainingChapters.get(j).getIsLock() != null && trainingChapters.get(j).getIsLock() == 0) {
                            trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
                        } else {
                            trainingChapterUnlock.setIsUnlock(Integer.valueOf(1));
                        }
                        trainingChapterUnlock.setTrainingId(trainingId);
                        this.trainingChapterUnlockMapper.insert(trainingChapterUnlock);
                        if (trainingChapterUnlock.getIsUnlock() == 1) continue block0;
                    }
                    continue;
                }
                TrainingChapterUnlock trainingChapterUnlock = this.trainingChapterUnlockMapper.selectByUserIdChapterId(userId, trainingChapters.get(i).getId());
                if (trainingChapterUnlock != null) continue;
                trainingChapterUnlock = new TrainingChapterUnlock();
                trainingChapterUnlock.setUserId(userId);
                trainingChapterUnlock.setChapterId(trainingChapters.get(i).getId());
                trainingChapterUnlock.setCreateTime(new Date());
                if (trainingChapters.get(i).getIsLock() != null && trainingChapters.get(i).getIsLock() == 0) {
                    trainingChapterUnlock.setIsUnlock(Integer.valueOf(0));
                } else {
                    trainingChapterUnlock.setIsUnlock(Integer.valueOf(1));
                }
                trainingChapterUnlock.setTrainingId(trainingId);
                this.trainingChapterUnlockMapper.insert(trainingChapterUnlock);
            }
        }
    }

    private List<TrainingVo> convertTraining(List<TrainingsVo> trainingList) {
        ArrayList<TrainingVo> voList = new ArrayList<TrainingVo>();
        if (!CollectionUtils.isEmpty(trainingList)) {
            for (TrainingsVo training : trainingList) {
                List<TrainingLabel> labelList;
                TrainingVo vo = new TrainingVo();
                BeanUtils.copyProperties((Object)training, (Object)vo);
                if (training.getStartTime() != null) {
                    vo.setCreateTimeStr(DateUtils.format(training.getStartTime()));
                }
                if (training.getStartTime() != null) {
                    long txTime = 0L;
                    txTime = training.getDuration() == null || training.getDuration() == 0 ? training.getStartTime().getTime() / 1000L + 86400L : training.getStartTime().getTime() / 1000L + (long)(training.getDuration() * 60);
                    vo.setRtmpPush("rtmp://3682.livepush.myqcloud.com/live/3682_" + training.getId() + "?bizid=3682&" + TencentLiveUtils.getSafeUrl("d2f12deefdc9b314cb31b107315fc65c", "3682_" + training.getId().toString(), txTime));
                    vo.setRtmp("rtmp://3682.liveplay.myqcloud.com/live/3682_" + training.getId());
                    vo.setFlv("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".flv");
                    vo.setHls("http://3682.liveplay.myqcloud.com/live/3682_" + training.getId() + ".m3u8");
                }
                if (!CollectionUtils.isEmpty(labelList = this.trainingLabelMapper.selectByTrainingId(training.getId()))) {
                    vo.setLabelList(labelList);
                }
                voList.add(vo);
            }
        }
        return voList;
    }

    @Override
    public Training getTrainingById(Integer id) {
        return (Training)this.trainingMapper.selectById(id);
    }

    @Override
    public void saveTrainingVideoLook(Integer id, Integer userId, Integer trainingId, Integer enterpriseId) {
        this.trainingVideoLookMapper.deleteByVideoId(userId, id);
        TrainingVideoLook trainingVideoLook = new TrainingVideoLook();
        trainingVideoLook.setVideoId(id);
        trainingVideoLook.setUserId(userId);
        trainingVideoLook.setTrainingId(trainingId);
        trainingVideoLook.setEnterpriseId(enterpriseId);
        this.trainingVideoLookMapper.insert(trainingVideoLook);
    }

    @Override
    public Page<TrainingVo> getWebTrainingByPage(Page<TrainingVo> page, Integer enterpriseId, String trainingName, Integer navId, Integer isRoom) {
        List<TrainingVo> voList = this.trainingMapper.selectVoByPage(page, enterpriseId, trainingName, navId, isRoom);
        page.setContent(voList);
        return page;
    }

    @Override
    public Page<TrainingsVo> selectWebTrainingByPage(Page<TrainingsVo> page, Integer enterpriseId, String trainingName, Integer trainingLabelId, Integer projectShow) {
        List<TrainingsVo> voList = this.trainingMapper.selectWebTrainingByPage(page, enterpriseId, trainingName, trainingLabelId, projectShow);
        if (!CollectionUtils.isEmpty(voList)) {
            List<Integer> creatorIds = voList.stream().map(Training::getCreator).collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorIds);
            for (TrainingsVo vo : voList) {
                UsersPojo user = pojoMap.get(vo.getCreator());
                if (StringUtils.isEmpty((Object)user)) continue;
                vo.setUserName(user.getShowName());
                vo.setHeadUrl(user.getThumbUrl());
            }
        }
        page.setContent(voList);
        return page;
    }

    @Override
    public void updateCollect(Integer userId, Integer trainingId) {
        TrainingUserCollection collection = this.trainingUserCollectionMapper.selectByUserIdTrainingId(userId, trainingId);
        if (collection == null) {
            TrainingUserCollection trainingUserCollection = new TrainingUserCollection();
            trainingUserCollection.setUserId(userId);
            trainingUserCollection.setTrainingId(trainingId);
            this.trainingUserCollectionMapper.insert(trainingUserCollection);
        } else {
            this.trainingUserCollectionMapper.deleteByUserIdTrainingId(userId, trainingId);
        }
    }

    @Override
    public Page<TrainingsVo> getCollect(Page<TrainingsVo> page, Users user) {
        List<TrainingsVo> trainings = this.trainingMapper.selectByCollectByPage(page, user.getId());
        if (!CollectionUtils.isEmpty(trainings)) {
            Boolean isSuper = this.commonRemoteService.isSuper(user.getId());
            if (!isSuper.booleanValue()) {
                for (TrainingsVo vo : trainings) {
                    TrainingResource trainingResource = this.resourceService.getByTrainId(vo.getId());
                    if (ObjectUtils.isEmpty((Object)trainingResource)) continue;
                    boolean valid = this.resourceSinglePermissionService.valid(trainingResource.getId(), user, 1);
                    if (valid) {
                        vo.setIsReadPower(Integer.valueOf(1));
                        continue;
                    }
                    vo.setIsReadPower(Integer.valueOf(0));
                }
            } else {
                for (TrainingsVo vo : trainings) {
                    vo.setIsReadPower(Integer.valueOf(1));
                }
            }
        }
        page.setContent(trainings);
        return page;
    }

    private void getTrainingIsPaper(List<TrainingsVo> trainings) {
        if (!CollectionUtils.isEmpty(trainings)) {
            block0: for (TrainingsVo trainingVo : trainings) {
                List<TrainingChapter> chapters;
                trainingVo.setIsPaper(Integer.valueOf(0));
                if (trainingVo.getPaperId() != null) {
                    trainingVo.setIsPaper(Integer.valueOf(1));
                    continue;
                }
                if (trainingVo.getIsChapter() == null || trainingVo.getIsChapter() != 1 || CollectionUtils.isEmpty(chapters = this.trainingChapterMapper.selectByTrainingId(trainingVo.getId()))) continue;
                for (TrainingChapter trainingChapter : chapters) {
                    if (trainingChapter.getPaperId() == null) continue;
                    trainingVo.setIsPaper(Integer.valueOf(1));
                    continue block0;
                }
            }
        }
    }

    private void getTrainingVoIsPaper(List<TrainingVo> trainings) {
        if (!CollectionUtils.isEmpty(trainings)) {
            block0: for (TrainingVo trainingVo : trainings) {
                List<TrainingChapter> chapters;
                trainingVo.setIsPaper(Integer.valueOf(0));
                if (trainingVo.getPaperId() != null) {
                    trainingVo.setIsPaper(Integer.valueOf(1));
                    continue;
                }
                if (trainingVo.getIsChapter() == null || trainingVo.getIsChapter() != 1 || CollectionUtils.isEmpty(chapters = this.trainingChapterMapper.selectByTrainingId(trainingVo.getId()))) continue;
                for (TrainingChapter trainingChapter : chapters) {
                    if (trainingChapter.getPaperId() == null) continue;
                    trainingVo.setIsPaper(Integer.valueOf(1));
                    continue block0;
                }
            }
        }
    }

    @Override
    public boolean getTrainingCollectState(Integer userId, Integer trainingId) {
        TrainingUserCollection collection = this.trainingUserCollectionMapper.selectByUserIdTrainingId(userId, trainingId);
        boolean isCollect = false;
        if (collection != null) {
            isCollect = true;
        }
        return isCollect;
    }

    @Override
    public List<TrainingVo> getRecommend(Integer enterpriseId) {
        ArrayList<Object> newTrainings = new ArrayList<Object>();
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(Training::getEnterpriseId)).eq(Training::getIsDel, (Object)0)).isNull(Training::getProjectShow)).eq(Training::getIsRecommend, (Object)"RECOMMEND");
        List trainings = this.trainingMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainings)) {
            block0: for (int i = 0; i < trainings.size(); ++i) {
                for (Training training : trainings) {
                    if (training == null || training.getIsRecommendOrder() == null || !training.getIsRecommendOrder().equals(i + 1)) continue;
                    newTrainings.add(training);
                    continue block0;
                }
            }
            for (Training training : trainings) {
                if (training.getIsRecommendOrder() != null) continue;
                newTrainings.add(training);
            }
        }
        if (enterpriseId != null) {
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(Training::getEnterpriseId, (Object)enterpriseId)).isNull(Training::getProjectShow)).eq(Training::getIsDel, (Object)0)).eq(Training::getIsRecommend, (Object)"RECOMMEND");
            List trainings1 = this.trainingMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)trainings1)) {
                ArrayList<Training> arrayList = new ArrayList<Training>();
                block3: for (int i = 0; i < trainings1.size(); ++i) {
                    for (Training training : trainings1) {
                        if (training == null || training.getIsRecommendOrder() == null || !training.getIsRecommendOrder().equals(i + 1)) continue;
                        arrayList.add(training);
                        continue block3;
                    }
                }
                for (Training training : trainings1) {
                    if (training.getIsRecommendOrder() != null) continue;
                    arrayList.add(training);
                }
                newTrainings.addAll(arrayList);
            }
        }
        ArrayList<TrainingsVo> newTrains = new ArrayList<TrainingsVo>();
        if (!CollectionUtils.isEmpty(newTrainings)) {
            for (Training training : newTrainings) {
                TrainingsVo vo = new TrainingsVo();
                BeanUtils.copyProperties((Object)training, (Object)vo);
                newTrains.add(vo);
            }
        }
        return this.convertTraining(newTrains);
    }

    @Override
    public int updateRecommend(Integer trainingId, Integer enterpriseId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (enterpriseId == null) {
            wrapper1.isNull(Training::getEnterpriseId);
        } else {
            wrapper1.eq(Training::getEnterpriseId, (Object)enterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(Training::getProjectShow)).eq(Training::getIsDel, (Object)0)).eq(Training::getIsRecommend, (Object)"RECOMMEND");
        List trainingss = this.trainingMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingss) && trainingss.size() >= 5) {
            return 1;
        }
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (training != null) {
            training.setIsRecommend("RECOMMEND");
            this.trainingMapper.updateById(training);
        }
        return 0;
    }

    @Override
    public void updateRecommends(String ids, Integer enterpriseId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        if (enterpriseId == null) {
            wrapper1.isNull(Training::getEnterpriseId);
        } else {
            wrapper1.eq(Training::getEnterpriseId, (Object)enterpriseId);
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.isNull(Training::getProjectShow)).eq(Training::getIsDel, (Object)0)).eq(Training::getIsRecommend, (Object)"RECOMMEND");
        List trainingss = this.trainingMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingss)) {
            for (Training training : trainingss) {
                training.setIsRecommendOrder(null);
                training.setIsRecommend(null);
                this.trainingMapper.updateByPrimaryKey(training);
            }
        }
        if (!StringUtils.isEmpty((Object)ids)) {
            String[] idss = ids.split(",");
            for (int i = 0; i < idss.length; ++i) {
                Training training = new Training();
                training.setId(Integer.valueOf(Integer.parseInt(idss[i])));
                training.setIsRecommendOrder(Integer.valueOf(i + 1));
                training.setIsRecommend("RECOMMEND");
                this.trainingMapper.updateById(training);
            }
        }
    }

    @Override
    public void deleteTrainingByIds(String ids, Integer enterpriseId) {
        String[] idsStr = ids.split(",");
        for (int i = 0; i < idsStr.length; ++i) {
            Integer trainingId = Integer.parseInt(idsStr[i].trim());
            this.tltMapper.deleteByTrainingId(trainingId);
            this.trainingVideoMapper.deleteByTrainingId(trainingId);
            this.trainingAttachMapper.deleteByTrainingId(trainingId);
            this.trainingMapper.deleteById(trainingId);
            try {
                this.delKaFKaWorkCircleArticleMo("COURSE", KaFKaWorkCircleArticleAddMo.circle_training, enterpriseId, trainingId);
            }
            catch (Exception e) {
                log.info("deleteTrainingByIds==============delAddKaFKaWorkCircleArticleAddMo", (Throwable)e);
            }
            if (StringUtils.isEmpty((Object)trainingId)) continue;
            try {
                this.jPushService.deleteMessages(trainingId, "TYPE_TRAINING_SYSTEM", null, null, 1);
                continue;
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
    }

    @Override
    public void updateTraining(Training training) {
        this.trainingMapper.updateByPrimaryKey(training);
    }

    @Override
    public void updateHistory(Integer userId, Integer trainingId, Integer trainingFeeId) {
        if (trainingFeeId == null) {
            TrainingHistory trainingHistory = this.trainingHistoryMapper.selectByUserIdTrainingId(userId, trainingId);
            if (trainingHistory == null) {
                trainingHistory = new TrainingHistory();
                trainingHistory.setCreateTime(new Date());
                trainingHistory.setTrainingId(trainingId);
                trainingHistory.setUserId(userId);
                this.trainingHistoryMapper.insert(trainingHistory);
            } else {
                trainingHistory.setUpdateTime(new Date());
                this.trainingHistoryMapper.updateById(trainingHistory);
            }
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TrainingHistory::getTrainingFeeId, (Object)trainingFeeId);
            wrapper.eq(TrainingHistory::getUserId, (Object)userId);
            TrainingHistory trainingHistory = (TrainingHistory)this.trainingHistoryMapper.selectOne((Wrapper)wrapper);
            if (trainingHistory == null) {
                trainingHistory = new TrainingHistory();
                trainingHistory.setCreateTime(new Date());
                trainingHistory.setTrainingId(trainingId);
                trainingHistory.setTrainingFeeId(trainingFeeId);
                trainingHistory.setUserId(userId);
                this.trainingHistoryMapper.insert(trainingHistory);
            } else {
                trainingHistory.setUpdateTime(new Date());
                this.trainingHistoryMapper.updateById(trainingHistory);
            }
        }
    }

    @Override
    public Page<TrainingVo> getHistoryByPage(Page<TrainingVo> page, Users user) {
        List<TrainingsVo> trainingList = this.trainingMapper.selectByHistoryByPage(page, user.getId());
        if (!CollectionUtils.isEmpty(trainingList)) {
            Iterator<TrainingsVo> iterator = trainingList.iterator();
            while (iterator.hasNext()) {
                TrainingsVo vo;
                boolean valid = this.materialPermissionFacade.validTrain((vo = iterator.next()).getId(), user, 1);
                vo.setIsReadPower(Integer.valueOf(valid ? 1 : 0));
            }
        }
        this.getTrainingIsPaper(trainingList);
        page.setContent(this.convertTraining(trainingList));
        return page;
    }

    @Override
    public void updateProgressIsPaper(Integer trainingId, Integer userId) {
        TrainingUserProgress trainingUserProgress = this.trainingUserProgressMapper.selectByUserIdTrainingId(trainingId, userId);
        if (trainingUserProgress != null) {
            trainingUserProgress.setIsPaper(Integer.valueOf(1));
            this.trainingUserProgressMapper.updateByPrimaryKey(trainingUserProgress);
        }
    }

    @Override
    public void updateTrainingUserLook(Integer trainingId, Integer userId) {
        TrainingUserLook selectByUserId = this.trainingUserLookMapper.selectByUserId(userId, trainingId);
        if (selectByUserId == null) {
            TrainingUserLook trainingUserLook = new TrainingUserLook();
            trainingUserLook.setUserId(userId);
            trainingUserLook.setTrainingId(trainingId);
            trainingUserLook.setCreateTime(new Date());
            this.trainingUserLookMapper.insert(trainingUserLook);
        }
    }

    @Override
    public List<TrainingVo> getTrainingUserLook(Integer enterpriseId, String trainingIdsStr) {
        List<Integer> trainingIds = StringsUtils.StringToList(trainingIdsStr, ",");
        ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
        List<TrainingVo> trainingVideoVos = this.trainingVideoMapper.selectByTrainingIds(trainingIds);
        List<TrainingVo> chapterTrainingVo = this.trainingChapterVideoMapper.selectByTrainingId(trainingIds);
        trainingVos.addAll(trainingVideoVos);
        trainingVos.addAll(chapterTrainingVo);
        List<Integer> userIds = this.userUtilService.getUserListByGroupId(enterpriseId);
        if (!CollectionUtils.isEmpty(trainingVos)) {
            for (TrainingVo trainingVo : trainingVos) {
                List<Integer> userIdList = this.userUtilService.getUserListByGroupId(enterpriseId);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(Objects.nonNull(trainingVo.getId()), TrainingVideoLook::getVideoId, (Object)trainingVo.getId());
                queryWrapper.eq(Objects.nonNull(trainingVo.getEnterpriseId()), TrainingVideoLook::getEnterpriseId, (Object)trainingVo.getEnterpriseId());
                queryWrapper.in(!CollectionUtils.isEmpty(userIdList), TrainingVideoLook::getUserId, userIdList);
                List trainingVideoLooks = this.trainingVideoLookMapper.selectList((Wrapper)queryWrapper);
                trainingVo.setLookNumber(Integer.valueOf(trainingVideoLooks.size()));
                trainingVo.setNoLookNumber(Integer.valueOf(userIds.size() - trainingVideoLooks.size()));
            }
        }
        return trainingVos;
    }

    @Override
    public List<Users> getTrainingUserLookDetails(Integer pageSize, Integer pageNumber, Integer videoId, int type, Integer enterpriseId) {
        Map<Integer, UsersPojo> pojoMap;
        ArrayList<Integer> result = new ArrayList();
        List<Integer> trainingVos = this.trainingVideoLookMapper.selectUserIdsByVideoId(videoId);
        List<Integer> userIds = this.userUtilService.getUserListByGroupId(enterpriseId);
        if (type == 0) {
            if (!CollectionUtils.isEmpty(userIds) && !CollectionUtils.isEmpty(trainingVos)) {
                result = this.listrem(userIds, trainingVos);
            } else if (!CollectionUtils.isEmpty(userIds)) {
                result = userIds;
            }
        } else {
            result = trainingVos;
        }
        ArrayList<Users> users = new ArrayList<Users>();
        if (!CollectionUtils.isEmpty(result) && !ObjectUtils.isEmpty(pojoMap = this.userUtilService.selectUserMap(result = this.getListPage(pageNumber, pageSize, result)))) {
            for (UsersPojo pojo : pojoMap.values()) {
                Users user1 = new Users();
                BeanUtils.copyProperties((Object)pojo, (Object)user1);
                users.add(user1);
            }
        }
        return users;
    }

    @Override
    public Page<TrainingVo> getWebTrainingProgressByPage(Page<TrainingVo> page, Integer enterpriseId, String trainingName, Integer navId) {
        List<TrainingVo> voList = this.trainingMapper.selectVoByPage(page, enterpriseId, trainingName, navId, null);
        if (!CollectionUtils.isEmpty(voList)) {
            List<Integer> userIds = this.userUtilService.getUserListByGroupId(enterpriseId);
            for (TrainingVo trainingVo : voList) {
                int attachSize;
                int finishNumber = 0;
                List<Integer> finishIds = null;
                if (trainingVo.getIsChapter() != null && trainingVo.getIsChapter() == 0) {
                    attachSize = this.getTrainingOldAttachSize(trainingVo.getId());
                    finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingVo.getId(), attachSize, userIds);
                    finishNumber = CollectionUtils.isEmpty(finishIds) ? 0 : finishIds.size();
                } else {
                    attachSize = this.getTrainingAttachSize(trainingVo.getId());
                    finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingVo.getId(), attachSize, userIds);
                    finishNumber = CollectionUtils.isEmpty(finishIds) ? 0 : finishIds.size();
                }
                boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(enterpriseId, trainingVo.getId());
                if (!trainContainsAll) {
                    List<Integer> allUserId = this.materialPermissionFacade.getValidUserIdByTrainId(enterpriseId, trainingVo.getId());
                    int allNumber = CollectionUtils.isEmpty(allUserId) ? 0 : allUserId.size();
                    trainingVo.setAllNumber(Integer.valueOf(allNumber));
                    trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                    trainingVo.setFinishPercentage("0.0%");
                    if (allNumber <= 0) continue;
                    trainingVo.setFinishPercentage(String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber) + "%");
                    continue;
                }
                int allNumber = CollectionUtils.isEmpty(userIds) ? 0 : userIds.size();
                trainingVo.setAllNumber(Integer.valueOf(allNumber));
                trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                trainingVo.setFinishPercentage("0%");
                if (allNumber <= 0) continue;
                trainingVo.setFinishPercentage(String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber) + "%");
            }
        }
        page.setContent(voList);
        return page;
    }

    @Override
    public List<TrainingChapterVo> getAttachProgressByPage(Integer trainingId, Integer enterpriseId) {
        ArrayList<TrainingAttachVo> attachVos;
        Training training;
        block16: {
            TrainingAttachVo trainingAttachVo;
            int finishNumber;
            List<TrainingAttachUser> trainingAttachUsers;
            int allNumber;
            List<Integer> levelUserIds;
            block15: {
                TrainingAttachVo trainingAttachVo2;
                int finishNumber2;
                List<TrainingChapterAttachUser> trainingChapterAttachUsers;
                training = (Training)this.trainingMapper.selectById(trainingId);
                if (ObjectUtils.isEmpty((Object)training)) {
                    return Lists.newArrayList();
                }
                levelUserIds = null;
                boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(enterpriseId, trainingId);
                if (!trainContainsAll) {
                    levelUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(enterpriseId, trainingId);
                }
                attachVos = new ArrayList<TrainingAttachVo>();
                allNumber = 0;
                if (!trainContainsAll) {
                    allNumber = CollectionUtils.isEmpty(levelUserIds) ? 0 : levelUserIds.size();
                } else {
                    List<Integer> userIds = this.userUtilService.getUserListByGroupId(enterpriseId);
                    int n = allNumber = CollectionUtils.isEmpty(userIds) ? 0 : userIds.size();
                }
                if (training.getIsChapter() == null || training.getIsChapter() != 1) break block15;
                List<TrainingChapterAttach> allAttach = this.trainingChapterAttachMapper.selectAllByTrainingId(trainingId);
                List<TrainingChapterVideo> allVideo = this.trainingChapterVideoMapper.selectAllByTrainingId(trainingId);
                if (!CollectionUtils.isEmpty(allVideo)) {
                    for (TrainingChapterVideo trainingChapterVideo : allVideo) {
                        trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectByUserId(trainingChapterVideo.getId(), 1, null, null, trainingId, levelUserIds, 1);
                        finishNumber2 = CollectionUtils.isEmpty(trainingChapterAttachUsers) ? 0 : trainingChapterAttachUsers.size();
                        trainingAttachVo2 = new TrainingAttachVo();
                        trainingAttachVo2.setFileName(trainingChapterVideo.getFileName());
                        trainingAttachVo2.setAllNumber(Integer.valueOf(allNumber));
                        trainingAttachVo2.setFinishNumber(Integer.valueOf(finishNumber2));
                        trainingAttachVo2.setFinishPercentage("0%");
                        trainingAttachVo2.setChapterId(trainingChapterVideo.getChapterId());
                        trainingAttachVo2.setIsVideo(Integer.valueOf(1));
                        trainingAttachVo2.setId(trainingChapterVideo.getId());
                        trainingAttachVo2.setCreateTime(training.getUpdateTime());
                        if (allNumber > 0) {
                            trainingAttachVo2.setFinishPercentage(String.format("%.1f", (double)(finishNumber2 * 100) / (double)allNumber) + "%");
                        }
                        attachVos.add(trainingAttachVo2);
                    }
                }
                if (CollectionUtils.isEmpty(allAttach)) break block16;
                for (TrainingChapterAttach trainingChapterAttach : allAttach) {
                    trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectByUserId(trainingChapterAttach.getId(), 0, null, null, trainingId, levelUserIds, null);
                    finishNumber2 = CollectionUtils.isEmpty(trainingChapterAttachUsers) ? 0 : trainingChapterAttachUsers.size();
                    trainingAttachVo2 = new TrainingAttachVo();
                    trainingAttachVo2.setFileName(trainingChapterAttach.getFileName());
                    trainingAttachVo2.setAllNumber(Integer.valueOf(allNumber));
                    trainingAttachVo2.setFinishNumber(Integer.valueOf(finishNumber2));
                    trainingAttachVo2.setChapterId(trainingChapterAttach.getChapterId());
                    trainingAttachVo2.setFinishPercentage("0%");
                    trainingAttachVo2.setIsVideo(Integer.valueOf(0));
                    trainingAttachVo2.setId(trainingChapterAttach.getId());
                    trainingAttachVo2.setCreateTime(training.getUpdateTime());
                    if (allNumber > 0) {
                        trainingAttachVo2.setFinishPercentage(String.format("%.1f", (double)(finishNumber2 * 100) / (double)allNumber) + "%");
                    }
                    attachVos.add(trainingAttachVo2);
                }
                break block16;
            }
            List<TrainingAttach> attachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
            List<TrainingVideo> videos = this.trainingVideoMapper.selectByTrainingId(trainingId);
            if (!CollectionUtils.isEmpty(videos)) {
                for (TrainingVideo trainingVideo : videos) {
                    trainingAttachUsers = this.trainingAttachUserMapper.selectByUserId(trainingVideo.getId(), 1, null, trainingId, levelUserIds, 1);
                    finishNumber = CollectionUtils.isEmpty(trainingAttachUsers) ? 0 : trainingAttachUsers.size();
                    trainingAttachVo = new TrainingAttachVo();
                    trainingAttachVo.setFileName(trainingVideo.getFileName());
                    trainingAttachVo.setAllNumber(Integer.valueOf(allNumber));
                    trainingAttachVo.setFinishNumber(Integer.valueOf(finishNumber));
                    trainingAttachVo.setFinishPercentage("0%");
                    trainingAttachVo.setIsVideo(Integer.valueOf(1));
                    trainingAttachVo.setId(trainingVideo.getId());
                    trainingAttachVo.setCreateTime(training.getUpdateTime());
                    if (allNumber > 0) {
                        trainingAttachVo.setFinishPercentage(String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber) + "%");
                    }
                    attachVos.add(trainingAttachVo);
                }
            }
            if (!CollectionUtils.isEmpty(attachs)) {
                for (TrainingAttach trainingAttach : attachs) {
                    trainingAttachUsers = this.trainingAttachUserMapper.selectByUserId(trainingAttach.getId(), 0, null, trainingId, levelUserIds, null);
                    finishNumber = CollectionUtils.isEmpty(trainingAttachUsers) ? 0 : trainingAttachUsers.size();
                    trainingAttachVo = new TrainingAttachVo();
                    trainingAttachVo.setFileName(trainingAttach.getName());
                    trainingAttachVo.setAllNumber(Integer.valueOf(allNumber));
                    trainingAttachVo.setFinishNumber(Integer.valueOf(finishNumber));
                    trainingAttachVo.setFinishPercentage("0%");
                    trainingAttachVo.setIsVideo(Integer.valueOf(0));
                    trainingAttachVo.setId(trainingAttach.getId());
                    trainingAttachVo.setCreateTime(training.getUpdateTime());
                    if (allNumber > 0) {
                        trainingAttachVo.setFinishPercentage(String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber) + "%");
                    }
                    attachVos.add(trainingAttachVo);
                }
            }
        }
        return this.geTrainingChapterVos(attachVos, training);
    }

    @Override
    public List selectRateByTree(Users user, Integer organizeId, Integer trainingId, String userName, Integer roleId) {
        Map<String, Object> userMap;
        List<Integer> roleIds = null;
        List userNames = null;
        if (roleId != null) {
            roleIds = this.userUtilService.selectUsersByRoles(Arrays.asList(roleId), user.getGroupId());
        }
        if (!StringUtils.isEmpty((Object)userName) && (userMap = this.userUtilService.getCheckParameters(userName, null, null, user)).get("isEffect").toString().equals("1")) {
            userNames = (List)userMap.get("userList");
        }
        ArrayList list = new ArrayList();
        int allNumber = 0;
        int finishNumber = 0;
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        List organizeIdList = null;
        organizeIdList = organizeId != null ? (List)this.organizeApi.getChilldOrganizeByUserIdAndOrgId(user.getGroupId(), organizeId, user.getId()).getData() : (List)this.organizeApi.getChilldOrganizeByUserIdAndOrgId(user.getGroupId(), null, user.getId()).getData();
        Map<Integer, List> organMapList = null;
        Map<Integer, List> mapList = null;
        if (!CollectionUtils.isEmpty((Collection)organizeIdList)) {
            Object organize;
            ArrayList<Object> organList = new ArrayList<Object>();
            List organIds = (List)this.userOrganizeApi.getOrganizeIdByUserIdAndGroupId(user.getGroupId(), user.getId()).getData();
            Iterator iterator = organIds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                organize = new Organize();
                OrganizePojo organizePojo = (OrganizePojo)this.organizeApi.getOrganizeById(Integer.valueOf(i)).getData();
                if (!organizeIdList.contains(organizePojo.getId())) continue;
                BeanUtils.copyProperties((Object)organizePojo, (Object)organize);
                organList.add(organize);
            }
            organMapList = organList.stream().collect(Collectors.toMap(Organize::getId, e -> new ArrayList<Organize>(Collections.singletonList(new Organize(e.getId(), e.getName(), e.getPid(), e.getGroupId()))), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
            ArrayList<Organize> orList = new ArrayList<Organize>();
            List organizeIds = (List)this.userOrganizeApi.getOrganizeIdByUserIdAndGroupId(user.getGroupId(), user.getId()).getData();
            organize = organizeIds.iterator();
            while (organize.hasNext()) {
                int i = (Integer)organize.next();
                Organize organize2 = new Organize();
                OrganizePojo organizePojo = (OrganizePojo)this.organizeApi.getOrganizeById(Integer.valueOf(i)).getData();
                if (!organizeIdList.contains(organizePojo.getPid())) continue;
                BeanUtils.copyProperties((Object)organizePojo, (Object)organize2);
                orList.add(organize2);
            }
            mapList = orList.stream().collect(Collectors.toMap(Organize::getPid, e -> new ArrayList<Organize>(Collections.singletonList(new Organize(e.getId(), e.getName(), e.getPid(), e.getGroupId()))), (oldList, newList) -> {
                oldList.addAll(newList);
                return oldList;
            }));
        }
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        String notGroup = this.messageSource.getMessage("training.paper.not.group", null, locale);
        for (Integer organId : organizeIdList) {
            List userOrganizeByOrgIds = (List)this.userOrganizeApi.getUserOrganizeByOrgIds(user.getGroupId(), Arrays.asList(organId)).getData();
            List<Integer> lookUserIds = null;
            boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(user.getGroupId(), trainingId);
            if (!trainContainsAll) {
                lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(user.getGroupId(), trainingId);
            }
            if (CollectionUtils.isEmpty((Collection)userOrganizeByOrgIds)) continue;
            List<Integer> userIds = null;
            userIds = userOrganizeByOrgIds.stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(lookUserIds)) {
                userIds.retainAll(lookUserIds);
            }
            if (roleId != null && !CollectionUtils.isEmpty(userIds)) {
                userIds.retainAll(roleIds);
            }
            if (userName != null && !"".equals(userName) && !CollectionUtils.isEmpty(userIds)) {
                userIds.retainAll(userNames);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(userIds)) {
                int attachSize;
                List<Integer> finishIds = null;
                allNumber = userIds.size();
                finishNumber = training.getIsChapter() != null && training.getIsChapter() == 1 ? (CollectionUtils.isEmpty(finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingAttachSize(trainingId), userIds)) ? 0 : finishIds.size()) : (CollectionUtils.isEmpty(finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingOldAttachSize(trainingId), userIds)) ? 0 : finishIds.size());
                BigDecimal finishNumbers = new BigDecimal((double)finishNumber * 100.0);
                BigDecimal allNumbers = new BigDecimal(allNumber);
                List orgList = mapList.get(organId);
                map.put("organizeId", organId);
                map.put("organizeName", organId == -404 ? notGroup : (CollectionUtils.isEmpty((Collection)organMapList.get(organId)) ? "" : ((Organize)organMapList.get(organId).get(0)).getName()));
                map.put("rate", finishNumbers.divide(allNumbers, 2, 4) + "%");
                if (organId == -404) {
                    map.put("isChild", 1);
                } else {
                    map.put("isChild", CollectionUtils.isEmpty((Collection)orgList) ? 0 : 1);
                }
            } else {
                List orgList = mapList.get(organId);
                map.put("organizeId", organId);
                map.put("organizeName", organId == -404 ? notGroup : (CollectionUtils.isEmpty((Collection)organMapList.get(organId)) ? "" : ((Organize)organMapList.get(organId).get(0)).getName()));
                map.put("rate", "0.00%");
                if (organId == -404) {
                    map.put("isChild", 1);
                } else {
                    map.put("isChild", CollectionUtils.isEmpty((Collection)orgList) ? 0 : 1);
                }
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public TrainingVo getTrainingProgressRateByTreeNew(String organizeIds, Integer trainingId, Users user, String userName, Integer roleId) {
        Map<String, Object> userMap;
        List<Integer> roleIds = null;
        List userNames = null;
        if (roleId != null) {
            roleIds = this.userUtilService.selectUsersByRoles(Arrays.asList(roleId), user.getGroupId());
        }
        if (userName != null && !"".equals(userName) && (userMap = this.userUtilService.getCheckParameters(userName, null, null, user)).get("isEffect").toString().equals("1")) {
            userNames = (List)userMap.get("userList");
        }
        List organizeIdList = null;
        if (organizeIds != null && !"".equals(organizeIds)) {
            String[] organizeList = organizeIds.split(",");
            organizeIdList = Arrays.asList(organizeList).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        List userOrganizeByOrgIds = (List)this.userOrganizeApi.getUserOrganizeByOrgIds(user.getGroupId(), organizeIdList).getData();
        List<Integer> userIds = userOrganizeByOrgIds.stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
        if (roleId != null && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(roleIds);
        }
        if (userName != null && !"".equals(userName) && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(userNames);
        }
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(user.getGroupId(), trainingId);
        if (!CollectionUtils.isEmpty(userIds) && !trainContainsAll) {
            List<Integer> lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(user.getGroupId(), trainingId);
            userIds.retainAll(lookUserIds);
        }
        TrainingVo trainingVo = new TrainingVo();
        if (!CollectionUtils.isEmpty(userIds)) {
            int attachSize;
            List<Integer> finishIds = null;
            int finishNumber = 0;
            int allNumber = userIds.size();
            finishNumber = training.getIsChapter() != null && training.getIsChapter() == 1 ? (CollectionUtils.isEmpty(finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingAttachSize(trainingId), userIds)) ? 0 : finishIds.size()) : (CollectionUtils.isEmpty(finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingOldAttachSize(trainingId), userIds)) ? 0 : finishIds.size());
            String p = finishNumber == 0 ? "0.00" : String.format("%.2f", (double)(finishNumber * 100) / (double)allNumber);
            trainingVo.setAllNumber(Integer.valueOf(allNumber));
            trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
            trainingVo.setFinishPercentage(p + "%");
        } else {
            trainingVo.setFinishNumber(Integer.valueOf(0));
            trainingVo.setAllNumber(Integer.valueOf(0));
            trainingVo.setFinishPercentage("0.00%");
        }
        return trainingVo;
    }

    @Override
    public Page<TrainingVo> getTrainingProgressByTreeNew(Page<TrainingVo> page, String organizeIds, Integer trainingId, Users user, String userName, Integer roleId) {
        Map<String, Object> userMap;
        List<Integer> roleIds = null;
        List userNames = null;
        if (roleId != null) {
            roleIds = this.userUtilService.selectUsersByRoles(Arrays.asList(roleId), user.getGroupId());
        }
        if (userName != null && !"".equals(userName) && (userMap = this.userUtilService.getCheckParameters(userName, null, null, user)).get("isEffect").toString().equals("1")) {
            userNames = (List)userMap.get("userList");
        }
        List organizeIdList = null;
        if (organizeIds != null && !"".equals(organizeIds)) {
            String[] organizeList = organizeIds.split(",");
            organizeIdList = Arrays.asList(organizeList).stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        List userOrganizeByOrgIds = (List)this.userOrganizeApi.getUserOrganizeByOrgIds(user.getGroupId(), organizeIdList).getData();
        List<Integer> userIds = userOrganizeByOrgIds.stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
        Map<Integer, List> userOrganizeMap = userOrganizeByOrgIds.stream().collect(Collectors.toMap(UserAndParentNameMo::getUserId, e -> new ArrayList<UserAndParentNameMo>(Arrays.asList(new UserAndParentNameMo(e.getOrganizeId(), e.getOrganizeName(), e.getName(), e.getUserId(), e.getParentId()))), (oldList, newList) -> {
            oldList.addAll(newList);
            return oldList;
        }));
        if (roleId != null && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(roleIds);
        }
        if (userName != null && !"".equals(userName) && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(userNames);
        }
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(user.getGroupId(), trainingId);
        if (!CollectionUtils.isEmpty(userIds) && !trainContainsAll) {
            List<Integer> lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(user.getGroupId(), trainingId);
            userIds.retainAll(lookUserIds);
        }
        ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
        List<Integer> finishIds = null;
        if (!CollectionUtils.isEmpty(userIds)) {
            Map userMap2 = (Map)this.userOrganizeApi.getUserOrganizeFirstByUserIds(user.getGroupId(), userIds, null).getData();
            if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                int attachSize = this.getTrainingAttachSize(trainingId);
                finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingId, attachSize, userIds);
                List finishList = (List)org.apache.commons.collections.CollectionUtils.intersection(finishIds, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, finishIds);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(finishList);
                for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                    TrainingVo trainingVo = new TrainingVo();
                    trainingVo.setPercentageInt(Integer.valueOf(100));
                    trainingVo.setUserId(entry.getKey());
                    trainingVo.setUserName(entry.getValue().getShowName());
                    trainingVo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    trainingVo.setStatus(Integer.valueOf(1));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    trainingVo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(trainingVo);
                }
                Map<Integer, UsersPojo> unFinishMap = this.userUtilService.selectUserMap(unFinishList);
                for (Map.Entry<Integer, UsersPojo> entry : unFinishMap.entrySet()) {
                    TrainingVo vo = new TrainingVo();
                    vo.setPercentageInt(null);
                    vo.setUserId(entry.getKey());
                    vo.setUserName(entry.getValue().getShowName());
                    vo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(0));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    vo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(vo);
                }
                if (!CollectionUtils.isEmpty(trainingVos)) {
                    for (TrainingVo trainingVo : trainingVos) {
                        Integer leaderId;
                        UsersPojo usersPojo;
                        List leader;
                        List userStr = (List)userMap2.get(trainingVo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)userStr)) {
                            trainingVo.setOrganizeName(String.join((CharSequence)";", userStr));
                        }
                        if (CollectionUtils.isEmpty((Collection)(leader = userOrganizeMap.get(trainingVo.getUserId()))) || !Objects.nonNull(usersPojo = this.userUtilService.selectUser(leaderId = ((UserAndParentNameMo)leader.get(0)).getParentId()))) continue;
                        trainingVo.setLeaderName(usersPojo.getShowName());
                    }
                }
            } else {
                int attachSize = this.getTrainingOldAttachSize(trainingId);
                finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize, userIds);
                finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingId, attachSize, userIds);
                List finishList = (List)org.apache.commons.collections.CollectionUtils.intersection(finishIds, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, finishIds);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(finishList);
                for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                    TrainingVo trainingVo = new TrainingVo();
                    trainingVo.setPercentageInt(Integer.valueOf(100));
                    trainingVo.setUserId(entry.getKey());
                    trainingVo.setUserName(entry.getValue().getShowName());
                    trainingVo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    trainingVo.setStatus(Integer.valueOf(1));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    trainingVo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(trainingVo);
                }
                Map<Integer, UsersPojo> unFinishMap = this.userUtilService.selectUserMap(unFinishList);
                for (Map.Entry entry : unFinishMap.entrySet()) {
                    TrainingVo vo = new TrainingVo();
                    vo.setPercentageInt(null);
                    vo.setUserId((Integer)entry.getKey());
                    vo.setUserName(((UsersPojo)entry.getValue()).getShowName());
                    vo.setEmployeeNumber(((UsersPojo)entry.getValue()).getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(0));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    vo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(vo);
                }
                if (!CollectionUtils.isEmpty(trainingVos)) {
                    for (TrainingVo trainingVo : trainingVos) {
                        Integer leaderId;
                        UsersPojo usersPojo;
                        List leader;
                        List userStr = (List)userMap2.get(trainingVo.getUserId());
                        if (!CollectionUtils.isEmpty((Collection)userStr)) {
                            trainingVo.setOrganizeName(String.join((CharSequence)";", userStr));
                        }
                        if (CollectionUtils.isEmpty((Collection)(leader = userOrganizeMap.get(trainingVo.getUserId()))) || !Objects.nonNull(usersPojo = this.userUtilService.selectUser(leaderId = ((UserAndParentNameMo)leader.get(0)).getParentId()))) continue;
                        trainingVo.setLeaderName(usersPojo.getShowName());
                    }
                }
            }
        }
        page.setContent(trainingVos);
        return page;
    }

    @Override
    public Page<TrainingVo> getTrainingProgressByTree(Page<TrainingVo> page, String organizeIds, Integer trainingId, Users user, String userName, Integer enterpriseId, Integer taskId) {
        List<Integer> taskUserIds = null;
        if (taskId != null) {
            taskUserIds = this.trainingTaskUserMapper.selectUserIdByByTaskId(taskId);
        }
        List<Integer> userIds = this.organizeService.getUserListNew(user, organizeIds, StringsUtils.ListToString(taskUserIds, ","), userName, enterpriseId);
        if (!CollectionUtils.isEmpty(taskUserIds) && !CollectionUtils.isEmpty(userIds)) {
            userIds.retainAll(taskUserIds);
        }
        int allNumber = 0;
        int finishNumber = 0;
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(enterpriseId, trainingId);
        if (!CollectionUtils.isEmpty(userIds) && !trainContainsAll) {
            List<Integer> lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(enterpriseId, trainingId);
            userIds.retainAll(lookUserIds);
        }
        List<Integer> finishIds = null;
        if (!CollectionUtils.isEmpty(userIds)) {
            String p;
            int attachSize;
            allNumber = userIds.size();
            finishNumber = training.getIsChapter() != null && training.getIsChapter() == 1 ? (CollectionUtils.isEmpty(finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingAttachSize(trainingId), userIds)) ? 0 : finishIds.size()) : (CollectionUtils.isEmpty(finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingId, attachSize = this.getTrainingOldAttachSize(trainingId), userIds)) ? 0 : finishIds.size());
            String string = p = finishNumber == 0 ? "0.0" : String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber);
            if (training.getIsChapter() == 1) {
                ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
                List finishList = (List)org.apache.commons.collections.CollectionUtils.intersection(finishIds, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, finishIds);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(finishList);
                for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                    TrainingVo trainingVo = new TrainingVo();
                    trainingVo.setPercentageInt(Integer.valueOf(100));
                    trainingVo.setUserId(entry.getKey());
                    trainingVo.setUserName(entry.getValue().getShowName());
                    trainingVo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    trainingVo.setStatus(Integer.valueOf(1));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    trainingVo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(trainingVo);
                }
                Map<Integer, UsersPojo> unFinishMap = this.userUtilService.selectUserMap(unFinishList);
                for (Map.Entry<Integer, UsersPojo> entry : unFinishMap.entrySet()) {
                    TrainingVo vo = new TrainingVo();
                    vo.setPercentageInt(null);
                    vo.setUserId(entry.getKey());
                    vo.setUserName(entry.getValue().getShowName());
                    vo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(0));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    vo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(vo);
                }
                if (!CollectionUtils.isEmpty(trainingVos)) {
                    ArrayList<UserOrganizeVo> arrayList = new ArrayList<UserOrganizeVo>();
                    List list = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
                    Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
                    for (UserAndParentNameMo mo : list) {
                        UserOrganizeVo vo = new UserOrganizeVo();
                        vo.setOrganizeId(mo.getOrganizeId());
                        vo.setOtype(mo.getOtype());
                        vo.setOrganizeName(mo.getOrganizeName());
                        vo.setGroupId(user.getGroupId());
                        UsersPojo usersPojo = userMap.get(mo.getUserId());
                        vo.setUserName(usersPojo.getShowName());
                        vo.setUserId(mo.getUserId());
                        arrayList.add(vo);
                    }
                    for (TrainingVo trainingVo : trainingVos) {
                        trainingVo.setAllNumber(Integer.valueOf(allNumber));
                        trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                        trainingVo.setFinishPercentage(p + "%");
                        trainingVo.setOrganizeName(this.findDepNameByUserIdNew(trainingVo.getUserId(), arrayList));
                        trainingVo.setShopName(this.findShopNameByUserId(trainingVo.getUserId(), arrayList));
                    }
                }
                page = ListUtil.myPage(trainingVos, page.getPageNumber(), page.getPageSize());
            } else {
                ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
                List finishList = (List)org.apache.commons.collections.CollectionUtils.intersection(finishIds, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, finishIds);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(finishList);
                for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                    TrainingVo trainingVo = new TrainingVo();
                    trainingVo.setPercentageInt(Integer.valueOf(100));
                    trainingVo.setUserId(entry.getKey());
                    trainingVo.setUserName(entry.getValue().getShowName());
                    trainingVo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    trainingVo.setStatus(Integer.valueOf(1));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, (Object)entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    trainingVo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(trainingVo);
                }
                Map<Integer, UsersPojo> unFinishMap = this.userUtilService.selectUserMap(unFinishList);
                for (Map.Entry entry : unFinishMap.entrySet()) {
                    TrainingVo vo = new TrainingVo();
                    vo.setPercentageInt(null);
                    vo.setUserId((Integer)entry.getKey());
                    vo.setUserName(((UsersPojo)entry.getValue()).getShowName());
                    vo.setEmployeeNumber(((UsersPojo)entry.getValue()).getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(0));
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingAttachUser::getUserId, entry.getKey());
                    queryWrapper.eq(TrainingAttachUser::getTrainingId, (Object)trainingId);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    vo.setUpdateTime(CollectionUtils.isEmpty((Collection)trainingAttachUsers) ? null : ((TrainingAttachUser)trainingAttachUsers.get(0)).getCreateTime());
                    trainingVos.add(vo);
                }
                if (!CollectionUtils.isEmpty(trainingVos)) {
                    ArrayList<UserOrganizeVo> arrayList = new ArrayList<UserOrganizeVo>();
                    List list = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
                    Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
                    for (UserAndParentNameMo mo : list) {
                        UserOrganizeVo vo = new UserOrganizeVo();
                        vo.setOrganizeId(mo.getOrganizeId());
                        vo.setOtype(mo.getOtype());
                        vo.setOrganizeName(mo.getOrganizeName());
                        vo.setGroupId(user.getGroupId());
                        UsersPojo usersPojo = userMap.get(mo.getUserId());
                        vo.setUserName(usersPojo.getShowName());
                        vo.setUserId(mo.getUserId());
                        arrayList.add(vo);
                    }
                    for (TrainingVo trainingVo : trainingVos) {
                        trainingVo.setAllNumber(Integer.valueOf(allNumber));
                        trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                        trainingVo.setFinishPercentage(p + "%");
                        trainingVo.setOrganizeName(this.findDepNameByUserIdNew(trainingVo.getUserId(), arrayList));
                        trainingVo.setShopName(this.findShopNameByUserId(trainingVo.getUserId(), arrayList));
                    }
                }
                page = ListUtil.myPage(trainingVos, page.getPageNumber(), page.getPageSize());
            }
        } else {
            ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
            if (taskId == null) {
                TrainingVo attachVo = new TrainingVo();
                attachVo.setFinishNumber(Integer.valueOf(0));
                attachVo.setAllNumber(Integer.valueOf(0));
                attachVo.setFinishPercentage("0.0%");
                trainingVos.add(attachVo);
            }
            page.setContent(trainingVos);
        }
        return page;
    }

    @Override
    public Page<TrainingAttachVo> getAttachProgressByTree(Page<TrainingAttachVo> page, String organizeIds, Integer trainingId, Users user, String userName, Integer enterpriseId, Integer attachId, Integer isVideo) {
        List<Integer> userIds = this.organizeService.getUserListNew(user, organizeIds, null, userName, enterpriseId);
        int allNumber = 0;
        int finishNumber = 0;
        Training training = this.trainingMapper.selectByPrimaryKey(trainingId);
        boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(enterpriseId, trainingId);
        if (!CollectionUtils.isEmpty(userIds) && !trainContainsAll) {
            List<Integer> lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(enterpriseId, trainingId);
            userIds.retainAll(lookUserIds);
        }
        if (!CollectionUtils.isEmpty(userIds)) {
            String p;
            List<TrainingAttachUser> selectByUserIds;
            List<TrainingChapterAttachUser> selectByUserId;
            allNumber = userIds.size();
            finishNumber = training.getIsChapter() != null && training.getIsChapter() == 1 ? (CollectionUtils.isEmpty(selectByUserId = this.trainingChapterAttachUserMapper.selectByUserId(attachId, isVideo, null, null, trainingId, userIds, 1)) ? 0 : selectByUserId.size()) : (CollectionUtils.isEmpty(selectByUserIds = this.trainingAttachUserMapper.selectByUserId(attachId, isVideo, null, trainingId, userIds, 1)) ? 0 : selectByUserIds.size());
            String string = p = finishNumber == 0 ? "0.0" : String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber);
            if (training.getIsChapter() == 1) {
                TrainingAttachVo vo;
                List<Integer> selectUserIdsByUserId = this.trainingChapterAttachUserMapper.selectUserIdsByUserId(attachId, isVideo, null, null, trainingId, 1);
                List finishList = (List)org.apache.commons.collections.CollectionUtils.intersection(selectUserIdsByUserId, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, selectUserIdsByUserId);
                ArrayList<TrainingAttachVo> trainingAttachVos = new ArrayList<TrainingAttachVo>();
                List<Integer> finishUserList = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty((Collection)finishList)) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.in(TrainingChapterAttachUser::getUserId, (Collection)finishList);
                    queryWrapper.eq(Objects.nonNull(trainingId), TrainingChapterAttachUser::getTrainingId, (Object)trainingId);
                    queryWrapper.eq(Objects.nonNull(attachId), TrainingChapterAttachUser::getAttachId, (Object)attachId);
                    queryWrapper.eq(Objects.nonNull(isVideo), TrainingChapterAttachUser::getIsVideo, (Object)isVideo);
                    List trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectList((Wrapper)queryWrapper);
                    finishUserList = trainingChapterAttachUsers.stream().map(TrainingChapterAttachUser::getUserId).collect(Collectors.toList());
                }
                Map<Integer, UsersPojo> finishMap = this.userUtilService.selectUserMap(finishUserList);
                Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(unFinishList);
                for (Map.Entry<Integer, UsersPojo> entry : finishMap.entrySet()) {
                    vo = new TrainingAttachVo();
                    vo.setUserName(entry.getValue().getShowName());
                    vo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(1));
                    vo.setUpdateTime(entry.getValue().getCreateTime());
                    vo.setUserId(entry.getKey());
                    trainingAttachVos.add(vo);
                }
                for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                    vo = new TrainingAttachVo();
                    vo.setUserName(entry.getValue().getShowName());
                    vo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                    vo.setStatus(Integer.valueOf(0));
                    vo.setUpdateTime(entry.getValue().getCreateTime());
                    vo.setUserId(entry.getKey());
                    trainingAttachVos.add(vo);
                }
                if (!CollectionUtils.isEmpty(trainingAttachVos)) {
                    ArrayList<UserOrganizeVo> userOrganizeVos = new ArrayList<UserOrganizeVo>();
                    List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
                    Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
                    for (UserAndParentNameMo mo : userAndParentNameMos) {
                        UserOrganizeVo vo2 = new UserOrganizeVo();
                        vo2.setOrganizeId(mo.getOrganizeId());
                        vo2.setOtype(mo.getOtype());
                        vo2.setOrganizeName(mo.getOrganizeName());
                        vo2.setGroupId(user.getGroupId());
                        UsersPojo usersPojo = userMap.get(mo.getUserId());
                        vo2.setUserName(usersPojo.getShowName());
                        vo2.setUserId(mo.getUserId());
                        userOrganizeVos.add(vo2);
                    }
                    for (TrainingAttachVo trainingVo : trainingAttachVos) {
                        trainingVo.setAllNumber(Integer.valueOf(allNumber));
                        trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                        trainingVo.setFinishPercentage(p + "%");
                        trainingVo.setOrganizeName(this.findDepNameByUserIdNew(trainingVo.getUserId(), userOrganizeVos));
                        trainingVo.setShopName(this.findShopNameByUserId(trainingVo.getUserId(), userOrganizeVos));
                    }
                }
                page = ListUtil.myPage(trainingAttachVos, page.getPageNumber(), page.getPageSize());
            } else {
                UserOrganizeVo vo;
                List<Integer> selectUserIdsByUserId = this.trainingAttachUserMapper.selectUserIdsByUserId(attachId, isVideo, null, trainingId, 1);
                List<Integer> finishList = (List<Integer>)org.apache.commons.collections.CollectionUtils.intersection(selectUserIdsByUserId, userIds);
                List unFinishList = (List)org.apache.commons.collections.CollectionUtils.subtract(userIds, selectUserIdsByUserId);
                ArrayList<Object> trainingAttachVos = new ArrayList<Object>();
                List<Integer> finishUserIds = CollectionUtils.isEmpty((Collection)finishList) ? Collections.singletonList(0) : finishList;
                ArrayList trainingAttachVoList = new ArrayList();
                if (!CollectionUtils.isEmpty(finishList)) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.in(TrainingAttachUser::getUserId, finishList);
                    queryWrapper.eq(Objects.nonNull(trainingId), TrainingAttachUser::getTrainingId, (Object)trainingId);
                    queryWrapper.eq(Objects.nonNull(attachId), TrainingAttachUser::getAttachId, (Object)attachId);
                    queryWrapper.eq(Objects.nonNull(isVideo), TrainingAttachUser::getIsVideo, (Object)isVideo);
                    List trainingAttachUsers = this.trainingAttachUserMapper.selectList((Wrapper)queryWrapper);
                    Map<Integer, UsersPojo> finishMap = this.userUtilService.selectUserMap(trainingAttachUsers.stream().map(TrainingAttachUser::getUserId).collect(Collectors.toList()));
                    for (Map.Entry<Integer, UsersPojo> entry : finishMap.entrySet()) {
                        vo = new TrainingAttachVo();
                        vo.setUserName(entry.getValue().getShowName());
                        vo.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                        vo.setStatus(Integer.valueOf(1));
                        vo.setUpdateTime(entry.getValue().getCreateTime());
                        vo.setUserId(entry.getKey());
                        trainingAttachVos.add(vo);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)unFinishList)) {
                    Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(unFinishList);
                    for (Map.Entry<Integer, UsersPojo> entry : usersPojoMap.entrySet()) {
                        TrainingAttachVo vo3 = new TrainingAttachVo();
                        vo3.setUserName(entry.getValue().getShowName());
                        vo3.setEmployeeNumber(entry.getValue().getEmployeeNumber());
                        vo3.setStatus(Integer.valueOf(0));
                        vo3.setUpdateTime(entry.getValue().getCreateTime());
                        vo3.setUserId(entry.getKey());
                        trainingAttachVos.add(vo3);
                    }
                }
                if (!CollectionUtils.isEmpty(trainingAttachVos)) {
                    ArrayList<UserOrganizeVo> userOrganizeVos = new ArrayList<UserOrganizeVo>();
                    List userAndParentNameMos = (List)this.userOrganizeApi.getUserOrganizeByUserIds(user.getGroupId(), userIds).getData();
                    Map<Integer, UsersPojo> userMap = this.userUtilService.selectUserMap(userIds);
                    for (UserAndParentNameMo userAndParentNameMo : userAndParentNameMos) {
                        vo = new UserOrganizeVo();
                        vo.setOrganizeId(userAndParentNameMo.getOrganizeId());
                        vo.setOtype(userAndParentNameMo.getOtype());
                        vo.setOrganizeName(userAndParentNameMo.getOrganizeName());
                        vo.setGroupId(user.getGroupId());
                        UsersPojo usersPojo = userMap.get(userAndParentNameMo.getUserId());
                        vo.setUserName(usersPojo.getShowName());
                        vo.setUserId(userAndParentNameMo.getUserId());
                        userOrganizeVos.add(vo);
                    }
                    for (TrainingAttachVo trainingAttachVo : trainingAttachVos) {
                        trainingAttachVo.setAllNumber(Integer.valueOf(allNumber));
                        trainingAttachVo.setFinishNumber(Integer.valueOf(finishNumber));
                        trainingAttachVo.setFinishPercentage(p + "%");
                        trainingAttachVo.setOrganizeName(this.findDepNameByUserIdNew(trainingAttachVo.getUserId(), userOrganizeVos));
                        trainingAttachVo.setShopName(this.findShopNameByUserId(trainingAttachVo.getUserId(), userOrganizeVos));
                    }
                }
                page = ListUtil.myPage(trainingAttachVos, page.getPageNumber(), page.getPageSize());
            }
        } else {
            ArrayList<TrainingAttachVo> trainingAttachVos = new ArrayList<TrainingAttachVo>();
            TrainingAttachVo attachVo = new TrainingAttachVo();
            attachVo.setFinishNumber(Integer.valueOf(0));
            attachVo.setAllNumber(Integer.valueOf(0));
            attachVo.setFinishPercentage("0.0%");
            trainingAttachVos.add(attachVo);
            page.setContent(trainingAttachVos);
        }
        return page;
    }

    private List<TrainingChapterVo> geTrainingChapterVos(List<TrainingAttachVo> attachVos, Training training) {
        ArrayList<TrainingChapterVo> chapterVos = new ArrayList<TrainingChapterVo>();
        if (StringUtils.isEmpty((Object)training.getIsChapter()) || training.getIsChapter() == 0) {
            TrainingChapterVo chapterVo = new TrainingChapterVo();
            chapterVo.setAttachVos(attachVos);
            chapterVo.setTrainingName(training.getTitle());
            chapterVo.setIsPaper(Integer.valueOf(training.getPaperId() == null ? 0 : 1));
            chapterVos.add(chapterVo);
        } else {
            List<TrainingChapter> trainingChapters = this.trainingChapterMapper.selectByTrainingId(training.getId());
            if (!CollectionUtils.isEmpty(attachVos) && !CollectionUtils.isEmpty(trainingChapters)) {
                for (TrainingChapter trainingChapter : trainingChapters) {
                    TrainingChapterVo chapterVo = new TrainingChapterVo();
                    chapterVo.setTrainingName(training.getTitle());
                    chapterVo.setName(trainingChapter.getName());
                    chapterVo.setId(trainingChapter.getId());
                    chapterVo.setIsPaper(Integer.valueOf(trainingChapter.getPaperId() == null ? 0 : 1));
                    ArrayList<TrainingAttachVo> newAttachVos = new ArrayList<TrainingAttachVo>();
                    for (TrainingAttachVo attachVo : attachVos) {
                        if (attachVo.getChapterId().intValue() != trainingChapter.getId().intValue()) continue;
                        newAttachVos.add(attachVo);
                    }
                    chapterVo.setAttachVos(newAttachVos);
                    chapterVos.add(chapterVo);
                }
            }
        }
        return chapterVos;
    }

    private List<Integer> getList(List<Integer> sourceList, List<Integer> list) {
        block0: for (int i = 0; i < sourceList.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (sourceList.get(i).intValue() != list.get(j).intValue()) continue;
                sourceList.remove(i);
                continue block0;
            }
        }
        return sourceList;
    }

    private List<TrainingVo> isLook(List<TrainingVo> trainings, Integer userId) {
        if (!CollectionUtils.isEmpty(trainings)) {
            List<TrainingHistory> trainingHistorys = this.trainingHistoryMapper.selectByUserId(userId);
            block0: for (TrainingVo training : trainings) {
                training.setIsLook(Integer.valueOf(0));
                if (CollectionUtils.isEmpty(trainingHistorys)) continue;
                for (TrainingHistory trainingHistory : trainingHistorys) {
                    if (!training.getId().equals(trainingHistory.getTrainingId())) continue;
                    training.setIsLook(Integer.valueOf(1));
                    continue block0;
                }
            }
        }
        return trainings;
    }

    private List<Integer> listrem(List<Integer> listA, List<Integer> listB) {
        Iterator<Integer> itA = listA.iterator();
        while (itA.hasNext()) {
            Integer temp = itA.next();
            for (int i = 0; i < listB.size(); ++i) {
                if (!temp.equals(listB.get(i))) continue;
                itA.remove();
            }
        }
        return listA;
    }

    private List<Integer> getListPage(int pageNumber, int pageSize, List<Integer> list) {
        int fromIndex;
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        if (list == null || list.size() == 0) {
            throw new RuntimeException(this.messageSource.getMessage("training.material.null.page.data", null, locale));
        }
        int totalCount = list.size();
        if ((fromIndex = --pageNumber * pageSize) >= totalCount) {
            throw new RuntimeException(this.messageSource.getMessage("training.material.page.size.data", null, locale));
        }
        int toIndex = (pageNumber + 1) * pageSize;
        if (toIndex > totalCount) {
            toIndex = totalCount;
        }
        return list.subList(fromIndex, toIndex);
    }

    @Override
    public Page<TrainingVo> getTrainingVosByUserId(Page<TrainingVo> page, Integer userId, Integer enterpriseId) {
        ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
        List<Training> trainings = this.trainingMapper.selectByUserIdByPage(page, enterpriseId, userId);
        List<TrainingAttachVo> trainingAttachVos = this.trainingAttachUserMapper.selectUserTrainingFinish(userId);
        List<TrainingAttachVo> trainingAttachVos2 = this.trainingChapterAttachUserMapper.selectUserTrainingFinish(userId);
        Map<Integer, Integer> attachMap = trainingAttachVos.stream().collect(Collectors.toMap(TrainingAttach::getTrainingId, TrainingAttachVo::getFinishNumber));
        Map<Integer, Integer> attachChapterMap = trainingAttachVos2.stream().collect(Collectors.toMap(TrainingAttach::getTrainingId, TrainingAttachVo::getFinishNumber));
        if (!CollectionUtils.isEmpty(trainings)) {
            for (Training training : trainings) {
                TrainingVo target = new TrainingVo();
                BeanUtils.copyProperties((Object)training, (Object)target);
                if (target.getIsChapter() != null && target.getIsChapter() == 1) {
                    if (attachChapterMap.get(target.getId()) != null) {
                        target.setPercentage(String.format("%.1f", (double)(attachChapterMap.get(target.getId()) * 100) / (double)this.getTrainingAttachSize(target.getId())) + "%");
                    } else {
                        target.setPercentage("0%");
                    }
                } else if (attachMap.get(target.getId()) != null) {
                    target.setPercentage(String.format("%.1f", (double)(attachMap.get(target.getId()) * 100) / (double)this.getTrainingOldAttachSize(target.getId())) + "%");
                } else {
                    target.setPercentage("0%");
                }
                trainingVos.add(target);
            }
        }
        page.setContent(trainingVos);
        return page;
    }

    @Override
    public Page<TrainingVo> getTrainingUsers(Page<TrainingVo> page, String organizeIds, Users user, String userName) {
        List<Integer> userIds = this.organizeService.getUserListNew(user, organizeIds, null, userName, user.getGroupId());
        ArrayList<TrainingVo> trainingVos = new ArrayList<TrainingVo>();
        if (!CollectionUtils.isEmpty(userIds)) {
            Page<Integer> userIdPage = ListUtil.myPage(userIds, page.getPageNumber(), page.getPageSize());
            List userIdList = userIdPage.getContent();
            List<Training> trainings = this.trainingMapper.selectByEnterpriseIdPublic(user.getGroupId());
            List<Integer> privateUserIds = this.trainingMapper.selectUserIdsByEnterpriseIdPrivate(user.getGroupId());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(userIdList);
            page.setTotalCount(userIdPage.getTotalCount());
            for (Integer userId : userIdList) {
                List<TrainingAttachVo> trainingAttachVos2;
                int allNumber = 0;
                int finishNumber = 0;
                List<TrainingAttachVo> trainingAttachVos = this.trainingAttachUserMapper.selectUserTrainingFinish(userId);
                if (!CollectionUtils.isEmpty(trainingAttachVos)) {
                    for (TrainingAttachVo trainingAttachVo : trainingAttachVos) {
                        int size = this.getTrainingOldAttachSize(trainingAttachVo.getTrainingId());
                        if (size <= 0 || size != trainingAttachVo.getFinishNumber()) continue;
                        ++finishNumber;
                    }
                }
                if (!CollectionUtils.isEmpty(trainingAttachVos2 = this.trainingChapterAttachUserMapper.selectUserTrainingFinish(userId))) {
                    for (TrainingAttachVo trainingAttachVo2 : trainingAttachVos2) {
                        int size = this.getTrainingAttachSize(trainingAttachVo2.getTrainingId());
                        if (size <= 0 || size != trainingAttachVo2.getFinishNumber()) continue;
                        ++finishNumber;
                    }
                }
                UsersPojo usersPojo = pojoMap.get(userId);
                TrainingVo trainingVo = new TrainingVo();
                trainingVo.setId(userId);
                trainingVo.setUserName(usersPojo.getShowName());
                trainingVo.setEmployeeNumber(usersPojo.getEmployeeNumber());
                int n = allNumber = CollectionUtils.isEmpty(trainings) ? 0 : trainings.size();
                if (!CollectionUtils.isEmpty(privateUserIds)) {
                    for (Integer privateUserId : privateUserIds) {
                        if (privateUserId.intValue() != userId.intValue()) continue;
                        ++allNumber;
                    }
                }
                trainingVo.setAllNumber(Integer.valueOf(allNumber));
                trainingVo.setFinishNumber(Integer.valueOf(finishNumber));
                if (finishNumber > 0) {
                    trainingVo.setFinishPercentage(String.format("%.1f", (double)(finishNumber * 100) / (double)allNumber) + "%");
                } else {
                    trainingVo.setFinishPercentage("0.0%");
                }
                trainingVos.add(trainingVo);
            }
            page.setContent(trainingVos);
        } else {
            TrainingVo attachVo = new TrainingVo();
            attachVo.setFinishNumber(Integer.valueOf(0));
            attachVo.setAllNumber(Integer.valueOf(0));
            attachVo.setFinishPercentage("0.0%");
            trainingVos.add(attachVo);
            page.setContent(trainingVos);
        }
        return page;
    }

    @Override
    public List<TrainingChapterVo> getAttachVosByUserId(Integer trainingId, Integer userId, Integer enterpriseId) {
        ArrayList<TrainingAttachVo> attachVos;
        Training training;
        block8: {
            TrainingAttachVo trainingAttachVo;
            List<TrainingAttachUser> trainingAttachUsers;
            block7: {
                TrainingAttachVo trainingAttachVo2;
                List<TrainingChapterAttachUser> trainingChapterAttachUsers;
                training = this.trainingMapper.selectByPrimaryKey(trainingId);
                attachVos = new ArrayList<TrainingAttachVo>();
                if (training.getIsChapter() == null || training.getIsChapter() != 1) break block7;
                List<TrainingChapterAttach> allAttach = this.trainingChapterAttachMapper.selectAllByTrainingId(trainingId);
                List<TrainingChapterVideo> allVideo = this.trainingChapterVideoMapper.selectAllByTrainingId(trainingId);
                if (!CollectionUtils.isEmpty(allVideo)) {
                    for (TrainingChapterVideo trainingChapterVideo : allVideo) {
                        trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectByUserId(trainingChapterVideo.getId(), 1, userId, null, trainingId, null, 1);
                        trainingAttachVo2 = new TrainingAttachVo();
                        trainingAttachVo2.setUpdateTime(training.getUpdateTime());
                        trainingAttachVo2.setFileName(trainingChapterVideo.getFileName());
                        trainingAttachVo2.setChapterId(trainingChapterVideo.getChapterId());
                        trainingAttachVo2.setIsVideo(Integer.valueOf(1));
                        trainingAttachVo2.setId(trainingChapterVideo.getId());
                        trainingAttachVo2.setStatus(Integer.valueOf(CollectionUtils.isEmpty(trainingChapterAttachUsers) ? 0 : 1));
                        trainingAttachVo2.setCreateTime(CollectionUtils.isEmpty(trainingChapterAttachUsers) ? null : trainingChapterAttachUsers.get(0).getCreateTime());
                        attachVos.add(trainingAttachVo2);
                    }
                }
                if (CollectionUtils.isEmpty(allAttach)) break block8;
                for (TrainingChapterAttach trainingChapterAttach : allAttach) {
                    trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectByUserId(trainingChapterAttach.getId(), 0, userId, null, trainingId, null, null);
                    trainingAttachVo2 = new TrainingAttachVo();
                    trainingAttachVo2.setUpdateTime(training.getUpdateTime());
                    trainingAttachVo2.setFileName(trainingChapterAttach.getFileName());
                    trainingAttachVo2.setChapterId(trainingChapterAttach.getChapterId());
                    trainingAttachVo2.setIsVideo(Integer.valueOf(0));
                    trainingAttachVo2.setId(trainingChapterAttach.getId());
                    trainingAttachVo2.setStatus(Integer.valueOf(CollectionUtils.isEmpty(trainingChapterAttachUsers) ? 0 : 1));
                    trainingAttachVo2.setCreateTime(CollectionUtils.isEmpty(trainingChapterAttachUsers) ? null : trainingChapterAttachUsers.get(0).getCreateTime());
                    attachVos.add(trainingAttachVo2);
                }
                break block8;
            }
            List<TrainingAttach> attachs = this.trainingAttachMapper.selectByTrainingId(trainingId);
            List<TrainingVideo> videos = this.trainingVideoMapper.selectByTrainingId(trainingId);
            if (!CollectionUtils.isEmpty(videos)) {
                for (TrainingVideo trainingVideo : videos) {
                    trainingAttachUsers = this.trainingAttachUserMapper.selectByUserId(trainingVideo.getId(), 1, userId, trainingId, null, 1);
                    trainingAttachVo = new TrainingAttachVo();
                    trainingAttachVo.setUpdateTime(training.getUpdateTime());
                    trainingAttachVo.setFileName(trainingVideo.getFileName());
                    trainingAttachVo.setIsVideo(Integer.valueOf(1));
                    trainingAttachVo.setId(trainingVideo.getId());
                    trainingAttachVo.setStatus(Integer.valueOf(CollectionUtils.isEmpty(trainingAttachUsers) ? 0 : 1));
                    trainingAttachVo.setCreateTime(CollectionUtils.isEmpty(trainingAttachUsers) ? null : trainingAttachUsers.get(0).getCreateTime());
                    attachVos.add(trainingAttachVo);
                }
            }
            if (!CollectionUtils.isEmpty(attachs)) {
                for (TrainingAttach trainingAttach : attachs) {
                    trainingAttachUsers = this.trainingAttachUserMapper.selectByUserId(trainingAttach.getId(), 0, userId, trainingId, null, null);
                    trainingAttachVo = new TrainingAttachVo();
                    trainingAttachVo.setUpdateTime(training.getUpdateTime());
                    trainingAttachVo.setFileName(trainingAttach.getName());
                    trainingAttachVo.setIsVideo(Integer.valueOf(0));
                    trainingAttachVo.setId(trainingAttach.getId());
                    trainingAttachVo.setStatus(Integer.valueOf(CollectionUtils.isEmpty(trainingAttachUsers) ? 0 : 1));
                    trainingAttachVo.setCreateTime(CollectionUtils.isEmpty(trainingAttachUsers) ? null : trainingAttachUsers.get(0).getCreateTime());
                    attachVos.add(trainingAttachVo);
                }
            }
        }
        return this.geTrainingChapterVos(attachVos, training);
    }

    public String findDepNameByUserIdNew(Integer userId, List<UserOrganizeVo> userOrganizeVos) {
        String organizeName = "";
        if (!CollectionUtils.isEmpty(userOrganizeVos)) {
            for (UserOrganizeVo userOrganizeVo : userOrganizeVos) {
                if (userId == null || userOrganizeVo.getUserId() == null || userOrganizeVo.getOtype() == null || !userId.equals(userOrganizeVo.getUserId()) || userOrganizeVo.getOtype() != 0) continue;
                organizeName = organizeName + userOrganizeVo.getOrganizeName() + " ";
            }
        }
        return organizeName;
    }

    public String findShopNameByUserId(Integer userId, List<UserOrganizeVo> userOrganizeVos) {
        ArrayList<UserOrganizeVo> shops = new ArrayList<UserOrganizeVo>();
        if (!CollectionUtils.isEmpty(userOrganizeVos)) {
            for (UserOrganizeVo userOrganizeVo : userOrganizeVos) {
                if (userId.intValue() != userOrganizeVo.getUserId().intValue()) continue;
                shops.add(userOrganizeVo);
            }
        }
        if (!CollectionUtils.isEmpty(shops)) {
            for (int i = 0; i < shops.size(); ++i) {
                if (ObjectUtils.isEmpty(shops.get(i)) || ((UserOrganizeVo)shops.get(i)).getOtype() == null || ((UserOrganizeVo)shops.get(i)).getOtype() != 0) continue;
                shops.remove(i);
                --i;
            }
        }
        return CollectionUtils.isEmpty(shops) ? "" : ((UserOrganizeVo)shops.get(0)).getOrganizeName();
    }

    @Override
    public Boolean trainingIsFinish(Integer userId, Integer trainingId) {
        boolean isFinish = false;
        Training training = (Training)this.trainingMapper.selectById(trainingId);
        if (!StringUtils.isEmpty((Object)training)) {
            if (training.getIsChapter() == 1) {
                List<TrainingChapterAttachUser> trainingChapterAttachUsers = this.trainingChapterAttachUserMapper.selectAttachFinish(1, userId, trainingId, null, null);
                int attachSize = this.getTrainingAttachSize(trainingId);
                if (!CollectionUtils.isEmpty(trainingChapterAttachUsers) && trainingChapterAttachUsers.size() >= attachSize) {
                    isFinish = true;
                }
            } else {
                List<TrainingAttachUser> trainingAttachUsers = this.trainingAttachUserMapper.selectAttachIsFinish(1, userId, trainingId, null, null);
                int attachSize = this.getTrainingOldAttachSize(trainingId);
                if (!CollectionUtils.isEmpty(trainingAttachUsers) && trainingAttachUsers.size() >= attachSize) {
                    isFinish = true;
                }
            }
        }
        return isFinish;
    }

    @Override
    public List<TaskMessage> getUserMessageByTrainingPage(Integer userId, String objectType) {
        Map resultData;
        UsersPojo usersPojo = this.userUtilService.selectUser(userId);
        MeaasgeAndWeixinMo param = new MeaasgeAndWeixinMo();
        param.setTargetUserId(userId);
        String type = "TYPE_OFFLINETASK_SYSTEM,TYPE_TRAINING_SYSTEM";
        BaseResult result = this.messageApi.getUndoneMessageByClassify(userId, usersPojo.getGroupId(), null, objectType, type);
        ArrayList<TaskMessage> taskMessageList = new ArrayList<TaskMessage>();
        if (!result.getIsError().booleanValue() && result != null && !ObjectUtils.isEmpty((Object)(resultData = (Map)result.getData()))) {
            List datas = (List)resultData.get("data");
            List messageMos = JSON.parseArray((String)JSON.toJSONString((Object)datas), MessageMo.class);
            TaskMessage taskMessage = null;
            for (MessageMo mo : messageMos) {
                taskMessage = new TaskMessage();
                taskMessage.setId(mo.getId().longValue());
                taskMessage.setSrcUserId(mo.getSrcUserId());
                taskMessage.setTargetUserId(mo.getTargetUserId());
                taskMessage.setContent(mo.getContent());
                taskMessage.setDescription(mo.getDescription());
                taskMessage.setObjectType(mo.getObjectType());
                taskMessage.setStatus(mo.getStatus());
                String dateStr = "";
                if (!StringUtils.isEmpty((Object)mo.getCreateTime())) {
                    Date dateT = DateUtils.parse(mo.getCreateTime(), "yyyy-MM-dd'T'HH:mm:ss");
                    dateStr = DateUtils.format(dateT);
                }
                taskMessage.setCreateTime(dateStr);
                taskMessage.setIsAtAll(mo.getIsAtAll());
                taskMessage.setEnterpriseId(mo.getEnterpriseId());
                JSONObject description = JSONObject.parseObject((String)taskMessage.getDescription());
                taskMessage.setTaskName(description != null ? (description.get((Object)"title") == null ? "" : description.get((Object)"title").toString()) : "");
                taskMessage.setIsDeal(mo.getIsDeal());
                taskMessage.setObjectId(mo.getObjectId());
                taskMessageList.add(taskMessage);
            }
        }
        return taskMessageList;
    }

    @Override
    public void addTrainingTask(TrainingTask trainingTask, Integer userId) {
        if (trainingTask.getId() == null) {
            trainingTask.setCreateTime(new Date());
            trainingTask.setCreateId(userId);
            this.trainingTaskMapper.insert(trainingTask);
            if (trainingTask.getIsPublic() == 0 && !StringUtils.isEmpty((Object)trainingTask.getUserIds())) {
                List<Integer> userIds = StringsUtils.StringToList(trainingTask.getUserIds(), ",");
                TrainingTaskUser trainingTaskUser = new TrainingTaskUser();
                trainingTaskUser.setTaskId(trainingTask.getId());
                for (Integer id : userIds) {
                    trainingTaskUser.setUserId(id);
                    this.trainingTaskUserMapper.insert(trainingTaskUser);
                }
            }
        } else {
            trainingTask.setUpdateTime(new Date());
            this.trainingTaskMapper.updateByPrimaryKey(trainingTask);
        }
    }

    @Override
    public void deleteTrainingTask(Integer trainingTaskId) {
        this.trainingTaskMapper.deleteByPrimaryKey(trainingTaskId);
    }

    @Override
    public Page<TrainingTaskVo> getTrainingTask(Page<TrainingTaskVo> page, Integer enterpriseId, String name, Users user) {
        List<TrainingTaskVo> trainingTaskVos = this.trainingTaskMapper.selectTaskVoByPage(page, enterpriseId, name);
        List<Integer> userIds = this.organizeService.getUserListNew(user, null, null, null, enterpriseId);
        if (!CollectionUtils.isEmpty(trainingTaskVos)) {
            for (TrainingTaskVo trainingTaskVo : trainingTaskVos) {
                trainingTaskVo.setCreateName(this.userUtilService.selectUser(trainingTaskVo.getCreateId()).getShowName());
                if (trainingTaskVo.getTaskType() == 0) {
                    int allNumber = 0;
                    int finishNumber = 0;
                    Training training = this.trainingMapper.selectByPrimaryKey(trainingTaskVo.getTrainingId());
                    List<Object> lookUserIds = new ArrayList<Integer>();
                    if (!CollectionUtils.isEmpty(userIds)) {
                        boolean trainContainsAll = this.materialPermissionFacade.isTrainContainsAll(user.getGroupId(), training.getId());
                        if (!trainContainsAll) {
                            lookUserIds = this.materialPermissionFacade.getValidUserIdByTrainId(user.getGroupId(), training.getId());
                            lookUserIds.retainAll(userIds);
                        } else {
                            lookUserIds.addAll(userIds);
                        }
                    }
                    List<Integer> taskUserIds = this.trainingTaskUserMapper.selectUserIdByByTaskId(trainingTaskVo.getId());
                    if (trainingTaskVo.getIsPublic() == 0) {
                        taskUserIds.retainAll(lookUserIds);
                    } else {
                        taskUserIds.addAll(lookUserIds);
                    }
                    List<Integer> finishIds = null;
                    if (!CollectionUtils.isEmpty(taskUserIds)) {
                        allNumber = taskUserIds.size();
                        if (training.getIsChapter() != null && training.getIsChapter() == 1) {
                            int attachSize = this.getTrainingAttachSize(trainingTaskVo.getTrainingId());
                            finishIds = this.trainingChapterAttachUserMapper.selectUserIdsFinish(trainingTaskVo.getTrainingId(), attachSize, taskUserIds);
                            finishNumber = CollectionUtils.isEmpty(finishIds) ? 0 : finishIds.size();
                        } else {
                            int attachSize = this.getTrainingOldAttachSize(trainingTaskVo.getTrainingId());
                            finishIds = this.trainingAttachUserMapper.selectUserIdsFinish(trainingTaskVo.getTrainingId(), attachSize, taskUserIds);
                            finishNumber = CollectionUtils.isEmpty(finishIds) ? 0 : finishIds.size();
                        }
                    }
                    trainingTaskVo.setRealFinishNum(Integer.valueOf(finishNumber));
                    List<TrainingTaskUser> trainingTaskUsers = this.trainingTaskUserMapper.selectByByTaskId(trainingTaskVo.getId());
                    trainingTaskVo.setNeedFinishNum(Integer.valueOf(CollectionUtils.isEmpty(taskUserIds) ? 0 : taskUserIds.size()));
                    continue;
                }
                TrainingPaper paper = (TrainingPaper)this.trainingPaperMapper.selectById(trainingTaskVo.getTrainingId());
                List<Object> lookUserIds = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty(userIds)) {
                    if (paper != null && paper.getLookLevel() != null && paper.getLookLevel() == 1) {
                        lookUserIds = this.trainingPaperUserMapper.selectUserIdsByPaperId(trainingTaskVo.getTrainingId());
                        lookUserIds.retainAll(userIds);
                    } else {
                        lookUserIds.addAll(userIds);
                    }
                }
                if (trainingTaskVo.getIsPublic() == 0) {
                    List<Integer> trainingTaskUsers = this.trainingTaskUserMapper.selectUserIdByByTaskId(trainingTaskVo.getId());
                    lookUserIds.retainAll(trainingTaskUsers);
                    trainingTaskVo.setNeedFinishNum(Integer.valueOf(CollectionUtils.isEmpty(lookUserIds) ? 0 : lookUserIds.size()));
                    continue;
                }
                trainingTaskVo.setNeedFinishNum(Integer.valueOf(lookUserIds.size()));
            }
        }
        page.setContent(trainingTaskVos);
        return page;
    }

    @Override
    public Page<TrainingCommentVo> getTrainingCommentByPage(Page<TrainingCommentVo> page, Integer trainingId, Integer commentType) {
        List<TrainingCommentVo> lists = this.commentMapper.getTrainingCommentByPage(page, trainingId, commentType);
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(lists)) {
            for (TrainingCommentVo vo : lists) {
                userIdList.add(vo.getUserId());
                List<TrainingCommentVo> commentList = this.commentMapper.getNextCommentByTrain(vo.getId());
                vo.setCommentList(commentList);
                if (commentList == null || commentList.size() <= 0) continue;
                for (TrainingCommentVo comment : commentList) {
                    userIdList.add(comment.getUserId());
                    if (comment.getReplyId().intValue() == vo.getId().intValue()) continue;
                    Integer userId = ((TrainingComment)this.commentMapper.selectById(comment.getReplyId())).getUserId();
                    comment.setReplyUserId(userId);
                }
            }
            List base = (List)this.userApi.getUserByIdList(userIdList).getData();
            Map nameMap = base.stream().collect(Collectors.toMap(UsersPojo::getId, Function.identity()));
            for (TrainingCommentVo vo : lists) {
                UsersPojo pojo = (UsersPojo)nameMap.get(vo.getUserId());
                if (!StringUtils.isEmpty((Object)pojo)) {
                    vo.setUserName(pojo.getShowName());
                    vo.setUserImageUrl(!StringUtils.isEmpty((Object)pojo.getThumbUrl()) ? pojo.getThumbUrl() : "http://wx3.sinaimg.cn/mw690/0060lm7Tly1fspqpgp7ulj305k05kt8u.jpg");
                }
                if (CollectionUtils.isEmpty((Collection)vo.getCommentList())) continue;
                for (TrainingCommentVo comment : vo.getCommentList()) {
                    UsersPojo replyName;
                    UsersPojo comName = (UsersPojo)nameMap.get(comment.getUserId());
                    if (!StringUtils.isEmpty((Object)comName)) {
                        comment.setUserName(comName.getShowName());
                        comment.setUserImageUrl(!StringUtils.isEmpty((Object)comName.getThumbUrl()) ? comName.getThumbUrl() : "http://wx3.sinaimg.cn/mw690/0060lm7Tly1fspqpgp7ulj305k05kt8u.jpg");
                    }
                    if (StringUtils.isEmpty((Object)(replyName = (UsersPojo)nameMap.get(comment.getReplyUserId())))) continue;
                    comment.setReplyName(replyName.getShowName());
                    comment.setReplyUserImageUrl(!StringUtils.isEmpty((Object)comName.getThumbUrl()) ? comName.getThumbUrl() : "http://wx3.sinaimg.cn/mw690/0060lm7Tly1fspqpgp7ulj305k05kt8u.jpg");
                }
            }
        }
        page.setContent(lists);
        return page;
    }

    @Override
    public TrainingCommentVo addComment(TrainingComment comment) {
        comment.setCreateTime(new Date());
        this.commentMapper.insertSelective(comment);
        TrainingCommentVo commentVo = new TrainingCommentVo();
        BeanUtils.copyProperties((Object)comment, (Object)commentVo);
        BaseResult user = this.userApi.getUserById(comment.getUserId());
        if (user != null && user.getData() != null) {
            commentVo.setUserName(((UsersPojo)user.getData()).getShowName());
            commentVo.setUserImageUrl(!StringUtils.isEmpty((Object)((UsersPojo)user.getData()).getThumbUrl()) ? ((UsersPojo)user.getData()).getThumbUrl() : "http://wx3.sinaimg.cn/mw690/0060lm7Tly1fspqpgp7ulj305k05kt8u.jpg");
        }
        if (comment.getCommentId() != null) {
            commentVo.setCommentId(comment.getCommentId());
        }
        if (comment.getReplyId() != null) {
            commentVo.setReplyId(comment.getReplyId());
            Integer userId = ((TrainingComment)this.commentMapper.selectById(comment.getReplyId())).getUserId();
            commentVo.setReplyUserId(userId);
            BaseResult userRe = this.userApi.getUserById(userId);
            if (userRe != null && userRe.getData() != null && ((UsersPojo)userRe.getData()).getShowName() != null) {
                commentVo.setReplyName(((UsersPojo)userRe.getData()).getShowName());
                commentVo.setReplyUserImageUrl(!StringUtils.isEmpty((Object)((UsersPojo)userRe.getData()).getThumbUrl()) ? ((UsersPojo)user.getData()).getThumbUrl() : "http://wx3.sinaimg.cn/mw690/0060lm7Tly1fspqpgp7ulj305k05kt8u.jpg");
            }
        }
        return commentVo;
    }

    @Override
    public void deleteComment(TrainingComment comment) {
        if (comment.getId() != null) {
            List<TrainingComment> spc = this.commentMapper.getCommentByReply(comment.getId());
            if (spc != null && spc.size() > 0) {
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                comment.setContent(this.messageSource.getMessage("training.training.delete.comment", null, locale));
                comment.setCreateTime(new Date());
                this.commentMapper.updateByPrimaryKeySelective(comment);
            } else {
                this.commentMapper.deleteById(comment.getId());
            }
        }
    }

    public void updateUserViewData(TrainingUserViewTime viewTime) {
        this.viewTimeMapper.insert(viewTime);
    }

    public void sendStudyEvent(TrainingUserViewTime viewTime) {
        StudyEvent event = new StudyEvent();
        event.setDate(new Date());
        Integer userId = viewTime.getUserId();
        Integer groupId = viewTime.getEnterpriseId();
        event.setShop(this.findShopNameByUserId(userId, groupId));
        event.setEvent("\u57f9\u8bad\u4efb\u52a1\u5b66\u4e60");
        BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(groupId);
        if (!baseResult.getIsError().booleanValue() && Objects.nonNull(baseResult.getData())) {
            event.setCompanyName(((EnterpriseGroupMo)baseResult.getData()).getName());
        } else {
            event.setCompanyName("");
        }
        BaseResult baseResult2 = this.userDepPrivilegeApi.getPrivilegeDepBeanByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult2.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)baseResult2.getData()))) {
            event.setLatitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLatitude());
            event.setLongitude(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getLongitude());
            event.setAddress(((DepartmentPojo)((List)baseResult2.getData()).get(0)).getAddress());
        }
        if (!StringUtils.isEmpty((Object)event.getShop())) {
            this.kafkaTemplate.send(this.kafkaTrainingTopic, (Object)JSON.toJSONString((Object)event));
        }
    }

    public Map<String, Object> checkProRecord(ListenableFuture<SendResult<String, String>> res) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (res != null) {
            try {
                SendResult r = (SendResult)res.get();
                Long offsetIndex = r.getRecordMetadata().offset();
                if (offsetIndex != null && offsetIndex >= 0L) {
                    m.put("message", KAFKA_SEND_SUCCESS_MES);
                    return m;
                }
                m.put("message", KAFKA_NO_OFFSET_MES);
                return m;
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
            catch (ExecutionException e) {
                log.error("", (Throwable)e);
                m.put("message", KAFKA_SEND_ERROR_MES);
                return m;
            }
        }
        m.put("message", KAFKA_NO_RESULT_MES);
        return m;
    }

    private String findShopNameByUserId(Integer userId, Integer groupId) {
        Map shopMap = new HashMap();
        UsersAndOrgsMo mo = new UsersAndOrgsMo();
        mo.setGroupId(groupId);
        mo.setUserIdList(Collections.singletonList(userId));
        mo.setShowDepartment(Boolean.valueOf(true));
        BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
        if (base != null && Objects.nonNull(base.getData())) {
            shopMap = (Map)base.getData();
        }
        List pojoList = (List)shopMap.get(userId);
        String shopName = "";
        if (!CollectionUtils.isEmpty((Collection)pojoList)) {
            pojoList = pojoList.stream().distinct().collect(Collectors.toList());
            shopName = (String)pojoList.get(0);
        }
        return shopName;
    }

    public void updateUserViewDataByType(TrainingUserViewTime viewTime) {
        if (Objects.isNull(viewTime.getMaterialId())) {
            return;
        }
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(viewTime.getMaterialId());
        Integer tempLearnType = viewTime.getLearnType();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId());
        queryWrapper.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId());
        List list = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)queryWrapper);
        ModelMapper mapper = new ModelMapper();
        TrainingUserViewTimeMaterial material = new TrainingUserViewTimeMaterial();
        if (CollectionUtils.isEmpty((Collection)list)) {
            BigDecimal finishRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTime.getViewTime());
            viewTime.setLearnType(Integer.valueOf(0));
            mapper.map((Object)viewTime, (Object)material);
            material.setUpdateTime(new Date());
            if (finishRate.compareTo(BigDecimal.ONE) == 0) {
                material.setFinishTime(new Date());
            }
            this.trainingUserViewTimeMaterialMapper.insert(material);
            this.saveMaterialViewCount(viewTime);
        } else {
            BigDecimal finishRate;
            material = (TrainingUserViewTimeMaterial)list.get(0);
            Integer viewTimes = viewTime.getViewTime();
            if (list.size() > 1) {
                for (int i = 0; i < list.size(); ++i) {
                    TrainingUserViewTimeMaterial trainingUserViewTimeMaterial = (TrainingUserViewTimeMaterial)list.get(i);
                    viewTimes = viewTimes + trainingUserViewTimeMaterial.getViewTime();
                    if (i <= 0) continue;
                    this.trainingUserViewTimeMaterialMapper.deleteById(trainingUserViewTimeMaterial.getId());
                }
            } else {
                viewTimes = viewTimes + material.getViewTime();
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(TrainingUserViewTime::getId, (Object)material.getId());
            if (tempLearnType == 0) {
                ((LambdaUpdateWrapper)wrapper.set(TrainingUserViewTime::getTaskId, null)).set(TrainingUserViewTime::getTrainingId, null);
            }
            if (material.getFinishTime() == null && (finishRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTimes)).compareTo(BigDecimal.ONE) == 0) {
                wrapper.set(TrainingUserViewTimeMaterial::getFinishTime, (Object)new Date());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(TrainingUserViewTime::getViewTime, (Object)viewTimes)).set(TrainingUserViewTimeMaterial::getUpdateTime, (Object)new Date())).set(TrainingUserViewTime::getLastTime, (Object)viewTime.getLastTime());
            this.trainingUserViewTimeMaterialMapper.update(null, (Wrapper)wrapper);
        }
        this.saveLearnTypeViewTimes(viewTime, tempLearnType, mapper, trainingMaterial);
    }

    private void saveMaterialViewCount(TrainingUserViewTime viewTime) {
        TrainingMaterial trainingMaterial = (TrainingMaterial)this.trainingMaterialMapper.selectById(viewTime.getMaterialId());
        if (!ObjectUtils.isEmpty((Object)trainingMaterial)) {
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(TrainingMaterial::getId, (Object)viewTime.getMaterialId())).set(TrainingMaterial::getViewCount, (Object)((trainingMaterial.getViewCount() == null ? 0 : trainingMaterial.getViewCount()) + 1));
            this.trainingMaterialMapper.update(null, (Wrapper)wrapper1);
            this.resourceService.saveResourceAddViewCount(viewTime.getMaterialId(), trainingMaterial.getFileType());
        }
    }

    private void saveLearnTypeViewTimes(TrainingUserViewTime viewTime, Integer tempLearnType, ModelMapper mapper, TrainingMaterial trainingMaterial) {
        switch (tempLearnType) {
            case 1: {
                BigDecimal finishRate;
                LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId())).eq(TrainingUserViewTime::getTrainingId, (Object)viewTime.getTrainingId())).eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId())).eq(viewTime.getAttachId() != null, TrainingUserViewTime::getAttachId, (Object)viewTime.getAttachId());
                List list1 = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)queryWrapper1);
                if (CollectionUtils.isEmpty((Collection)list1)) {
                    viewTime.setLearnType(Integer.valueOf(1));
                    TrainingUserViewTimeTraining training = new TrainingUserViewTimeTraining();
                    mapper.map((Object)viewTime, (Object)training);
                    training.setUpdateTime(new Date());
                    BigDecimal finishRate2 = this.materialService.getMaterialFinishRate(trainingMaterial, viewTime.getViewTime());
                    if (finishRate2.compareTo(BigDecimal.ONE) == 0) {
                        training.setFinishTime(new Date());
                    }
                    this.trainingUserViewTimeTrainingMapper.insert(training);
                    break;
                }
                TrainingUserViewTimeTraining trainingUserViewTimeTraining = (TrainingUserViewTimeTraining)list1.get(0);
                Integer viewTimes = viewTime.getViewTime();
                if (list1.size() > 1) {
                    for (int i = 0; i < list1.size(); ++i) {
                        TrainingUserViewTimeTraining trainingUserViewTime = (TrainingUserViewTimeTraining)list1.get(i);
                        viewTimes = viewTimes + trainingUserViewTime.getViewTime();
                        if (i <= 0) continue;
                        this.trainingUserViewTimeTrainingMapper.deleteById(trainingUserViewTime.getId());
                    }
                } else {
                    viewTimes = viewTimes + trainingUserViewTimeTraining.getViewTime();
                }
                trainingUserViewTimeTraining.setAttachId(viewTime.getAttachId());
                trainingUserViewTimeTraining.setViewTime(viewTimes);
                trainingUserViewTimeTraining.setLearnType(Integer.valueOf(1));
                trainingUserViewTimeTraining.setUpdateTime(new Date());
                trainingUserViewTimeTraining.setLastTime(viewTime.getLastTime());
                trainingUserViewTimeTraining.setTurns(viewTime.getTurns());
                if (trainingUserViewTimeTraining.getFinishTime() == null && (finishRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTimes)).compareTo(BigDecimal.ONE) == 0) {
                    trainingUserViewTimeTraining.setFinishTime(new Date());
                }
                this.trainingUserViewTimeTrainingMapper.updateById(trainingUserViewTimeTraining);
                break;
            }
            case 2: {
                LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
                queryWrapper2.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId());
                queryWrapper2.eq(TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper2.eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId());
                List list2 = this.trainingUserViewTimeLearnMapper.selectList((Wrapper)queryWrapper2);
                if (CollectionUtils.isEmpty((Collection)list2)) {
                    viewTime.setLearnType(Integer.valueOf(2));
                    TrainingUserViewTimeLearn learn = new TrainingUserViewTimeLearn();
                    mapper.map((Object)viewTime, (Object)learn);
                    learn.setUpdateTime(new Date());
                    this.trainingUserViewTimeLearnMapper.insert(learn);
                    break;
                }
                TrainingUserViewTimeLearn trainingUserViewTimeLearn = (TrainingUserViewTimeLearn)list2.get(0);
                Integer viewTimes = viewTime.getViewTime();
                if (list2.size() > 1) {
                    for (int i = 0; i < list2.size(); ++i) {
                        TrainingUserViewTimeLearn trainingUserViewTime = (TrainingUserViewTimeLearn)list2.get(i);
                        viewTimes = viewTimes + trainingUserViewTime.getViewTime();
                        if (i <= 0) continue;
                        this.trainingUserViewTimeLearnMapper.deleteById(trainingUserViewTime.getId());
                    }
                } else {
                    viewTimes = viewTimes + trainingUserViewTimeLearn.getViewTime();
                }
                trainingUserViewTimeLearn.setViewTime(viewTimes);
                trainingUserViewTimeLearn.setLearnType(Integer.valueOf(2));
                trainingUserViewTimeLearn.setUpdateTime(new Date());
                trainingUserViewTimeLearn.setLastTime(viewTime.getLastTime());
                trainingUserViewTimeLearn.setTurns(viewTime.getTurns());
                this.trainingUserViewTimeLearnMapper.updateById(trainingUserViewTimeLearn);
                break;
            }
            case 3: {
                LambdaQueryWrapper queryWrapper3 = new LambdaQueryWrapper();
                queryWrapper3.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId());
                queryWrapper3.eq(TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper3.eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId());
                List list3 = this.trainingUserViewTimeJobMapper.selectList((Wrapper)queryWrapper3);
                if (CollectionUtils.isEmpty((Collection)list3)) {
                    TrainingUserViewTimeJob job = new TrainingUserViewTimeJob();
                    viewTime.setLearnType(Integer.valueOf(3));
                    mapper.map((Object)viewTime, (Object)job);
                    job.setUpdateTime(new Date());
                    this.trainingUserViewTimeJobMapper.insert(job);
                    break;
                }
                TrainingUserViewTimeJob trainingUserViewTimeJob = (TrainingUserViewTimeJob)list3.get(0);
                Integer viewTimes = viewTime.getViewTime();
                if (list3.size() > 1) {
                    for (int i = 0; i < list3.size(); ++i) {
                        TrainingUserViewTimeJob trainingUserViewTime = (TrainingUserViewTimeJob)list3.get(i);
                        viewTimes = viewTimes + trainingUserViewTime.getViewTime();
                        if (i <= 0) continue;
                        this.trainingUserViewTimeJobMapper.deleteById(trainingUserViewTime.getId());
                    }
                } else {
                    viewTimes = viewTimes + trainingUserViewTimeJob.getViewTime();
                }
                trainingUserViewTimeJob.setViewTime(viewTimes);
                trainingUserViewTimeJob.setLearnType(Integer.valueOf(3));
                trainingUserViewTimeJob.setUpdateTime(new Date());
                trainingUserViewTimeJob.setLastTime(viewTime.getLastTime());
                trainingUserViewTimeJob.setTurns(viewTime.getTurns());
                this.trainingUserViewTimeJobMapper.updateById(trainingUserViewTimeJob);
                break;
            }
            case 4: {
                LambdaQueryWrapper queryWrapper4 = new LambdaQueryWrapper();
                queryWrapper4.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId());
                queryWrapper4.eq(TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper4.eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId());
                queryWrapper4.eq(TrainingUserViewTime::getTurns, (Object)viewTime.getTurns());
                List list4 = this.trainingUserViewTimeCourseMapper.selectList((Wrapper)queryWrapper4);
                if (CollectionUtils.isEmpty((Collection)list4)) {
                    TrainingUserViewTimeCourse course = new TrainingUserViewTimeCourse();
                    viewTime.setLearnType(Integer.valueOf(4));
                    mapper.map((Object)viewTime, (Object)course);
                    course.setUpdateTime(new Date());
                    this.trainingUserViewTimeCourseMapper.insert(course);
                    break;
                }
                TrainingUserViewTimeCourse trainingUserViewTimeCourse = (TrainingUserViewTimeCourse)list4.get(0);
                Integer viewTimes = viewTime.getViewTime();
                if (list4.size() > 1) {
                    for (int i = 0; i < list4.size(); ++i) {
                        TrainingUserViewTimeCourse trainingUserViewTime = (TrainingUserViewTimeCourse)list4.get(i);
                        viewTimes = viewTimes + trainingUserViewTime.getViewTime();
                        if (i <= 0) continue;
                        this.trainingUserViewTimeCourseMapper.deleteById(trainingUserViewTime.getId());
                    }
                } else {
                    viewTimes = viewTimes + trainingUserViewTimeCourse.getViewTime();
                }
                trainingUserViewTimeCourse.setViewTime(viewTimes);
                trainingUserViewTimeCourse.setLearnType(Integer.valueOf(4));
                trainingUserViewTimeCourse.setUpdateTime(new Date());
                trainingUserViewTimeCourse.setLastTime(viewTime.getLastTime());
                trainingUserViewTimeCourse.setTurns(viewTime.getTurns());
                this.trainingUserViewTimeCourseMapper.updateById(trainingUserViewTimeCourse);
                break;
            }
            case 5: {
                LambdaQueryWrapper queryWrapper5 = new LambdaQueryWrapper();
                queryWrapper5.eq(TrainingUserViewTime::getUserId, (Object)viewTime.getUserId());
                queryWrapper5.eq(TrainingUserViewTime::getTaskId, (Object)viewTime.getTaskId());
                queryWrapper5.eq(TrainingUserViewTime::getMaterialId, (Object)viewTime.getMaterialId());
                List list5 = this.trainingUserViewTimeCheckMapper.selectList((Wrapper)queryWrapper5);
                if (CollectionUtils.isEmpty((Collection)list5)) {
                    TrainingUserViewTimeCheck trainingUserViewTimeCheck = new TrainingUserViewTimeCheck();
                    viewTime.setLearnType(Integer.valueOf(5));
                    mapper.map((Object)viewTime, (Object)trainingUserViewTimeCheck);
                    trainingUserViewTimeCheck.setUpdateTime(new Date());
                    this.trainingUserViewTimeCheckMapper.insert(trainingUserViewTimeCheck);
                    break;
                }
                TrainingUserViewTimeCheck trainingUserViewTimeCheck = (TrainingUserViewTimeCheck)list5.get(0);
                Integer viewTimes = viewTime.getViewTime();
                if (list5.size() > 1) {
                    for (int i = 0; i < list5.size(); ++i) {
                        TrainingUserViewTimeCheck trainingUserViewTime = (TrainingUserViewTimeCheck)list5.get(i);
                        viewTimes = viewTimes + trainingUserViewTime.getViewTime();
                        if (i <= 0) continue;
                        this.trainingUserViewTimeCheckMapper.deleteById(trainingUserViewTime.getId());
                    }
                } else {
                    viewTimes = viewTimes + trainingUserViewTimeCheck.getViewTime();
                }
                trainingUserViewTimeCheck.setViewTime(viewTimes);
                trainingUserViewTimeCheck.setLearnType(Integer.valueOf(5));
                trainingUserViewTimeCheck.setUpdateTime(new Date());
                trainingUserViewTimeCheck.setLastTime(viewTime.getLastTime());
                trainingUserViewTimeCheck.setTurns(viewTime.getTurns());
                this.trainingUserViewTimeCheckMapper.updateById(trainingUserViewTimeCheck);
                break;
            }
        }
    }

    private void updateStudyStatus(TrainingUserViewTime viewTime) {
        List<Object> paperIdList = new ArrayList();
        List<TrainingUserViewTimeVo> trainingViewList = this.trainingUserViewTimeTrainingMapper.selectViewTimeByTraining(Collections.singletonList(viewTime.getTrainingId()), viewTime.getEnterpriseId());
        HashMap<Integer, List<TrainingUserViewTimeVo>> viewMap = new HashMap();
        if (!CollectionUtils.isEmpty(trainingViewList)) {
            viewMap = trainingViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getTrainingId));
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingChapterAttach::getTrainingId, (Object)viewTime.getTrainingId())).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        HashMap<Integer, List<TrainingChapterAttach>> trainingChapterAttachMap = new HashMap();
        Map<Integer, Object> materialMap = new HashMap<Integer, TrainingMaterial>();
        Map<Integer, List<TrainingUserViewTimeVo>> viewMaterialMap = new HashMap<Integer, List<TrainingUserViewTimeVo>>();
        Map<Integer, List<TrainingUserPaper>> userPaperMap = new HashMap<Integer, List<TrainingUserPaper>>();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List<Integer> materialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialIdList)) {
                List mateList = this.materialMapper.selectBatchIds(materialIdList);
                materialMap = mateList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                List<TrainingUserViewTimeVo> materialViewList = this.trainingUserViewTimeMaterialMapper.selectViewTimeByMaterials(materialIdList, viewTime.getEnterpriseId());
                if (!CollectionUtils.isEmpty(materialViewList)) {
                    viewMaterialMap = materialViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                }
            }
        }
        if (!CollectionUtils.isEmpty(paperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime);
            List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
            if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
            }
        }
        Map<String, Object> map = this.commonService.selectIsFinishTraining(viewTime.getTrainingId(), viewTime.getUserId(), viewMap, viewMaterialMap, trainingChapterAttachMap, materialMap, userPaperMap);
        int status = Integer.parseInt(map.get("status").toString());
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.eq(TrainingStudyStatus::getTrainingId, (Object)viewTime.getTrainingId());
        queryWrapper1.eq(TrainingStudyStatus::getUserId, (Object)viewTime.getUserId());
        queryWrapper1.orderByDesc(TrainingStudyStatus::getId);
        List statusList = this.trainingStudyStatusMapper.selectList((Wrapper)queryWrapper1);
        if (!CollectionUtils.isEmpty((Collection)statusList)) {
            TrainingStudyStatus trainingStudyStatus = (TrainingStudyStatus)statusList.get(0);
            if (trainingStudyStatus.getStatus() != null && trainingStudyStatus.getStatus() == 2) {
                return;
            }
            trainingStudyStatus.setStatus(Integer.valueOf(status));
            if (status == 2 && trainingStudyStatus.getFinishTime() == null) {
                trainingStudyStatus.setFinishTime(new Date());
            }
            this.trainingStudyStatusMapper.updateById(trainingStudyStatus);
        } else {
            TrainingStudyStatus trainingStudyStatus = new TrainingStudyStatus();
            trainingStudyStatus.setStatus(Integer.valueOf(status));
            trainingStudyStatus.setTrainingId(viewTime.getTrainingId());
            trainingStudyStatus.setUserId(viewTime.getUserId());
            trainingStudyStatus.setCreateTime(new Date());
            if (status == 2) {
                trainingStudyStatus.setFinishTime(new Date());
            }
            trainingStudyStatus.setFileType(Integer.valueOf(8));
            this.trainingStudyStatusMapper.insert(trainingStudyStatus);
            this.trainService.saveTrainingViewCount(viewTime.getTrainingId());
        }
    }

    public void updateLearnUserData(TrainingLearnTaskUser taskUser) {
        this.trainingLearnTaskUserMapper.updateById(taskUser);
    }

    public void updateJobUserTaskData(TrainingJobUserTask userTask) {
        this.trainingJobUserTaskMapper.updateById(userTask);
    }

    public void saveViewTimeByLearn(TrainingUserViewTime viewTime) {
        Date now = new Date();
        TrainingTaskSchedule taskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(viewTime.getTaskId());
        if (ObjectUtils.isEmpty((Object)taskSchedule)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)viewTime.getTaskId());
        wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)viewTime.getUserId());
        List learnList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)learnList)) {
            return;
        }
        if (taskSchedule.getMaterialId() == null && taskSchedule.getTrainingId() == null) {
            return;
        }
        for (TrainingLearnTaskUser taskUser : learnList) {
            if (!StringUtils.isEmpty((Object)taskSchedule.getMaterialId())) {
                TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(viewTime.getMaterialId());
                if (ObjectUtils.isEmpty((Object)material)) continue;
                TrainingUserViewTimeVo userViewTimes = null;
                userViewTimes = taskSchedule.getIsSync() != null && taskSchedule.getIsSync() == 1 ? this.commonService.selectMaterialViewTime(taskUser.getUserId(), null, 0, material.getId(), null) : this.commonService.selectMaterialViewTime(taskUser.getUserId(), taskSchedule.getId(), 2, material.getId(), null);
                if (!ObjectUtils.isEmpty((Object)userViewTimes)) {
                    Integer viewTimes = userViewTimes.getViewTimes();
                    BigDecimal readRate = this.materialService.getMaterialFinishRate(material, viewTimes);
                    taskUser.setRate(Integer.valueOf(readRate.multiply(new BigDecimal(100)).intValue()));
                    taskUser.setUseTime(viewTimes);
                    if (readRate.compareTo(BigDecimal.ONE) >= 0) {
                        taskUser.setTaskStatus(Integer.valueOf(4));
                        if (StringUtils.isEmpty((Object)taskUser.getStartTime())) {
                            taskUser.setStartTime(now);
                        }
                        taskUser.setEndTime(now);
                        this.updateLearnUserData(taskUser);
                    } else {
                        taskUser.setTaskStatus(Integer.valueOf(1));
                        if (StringUtils.isEmpty((Object)taskUser.getStartTime())) {
                            taskUser.setStartTime(now);
                        }
                        this.updateLearnUserData(taskUser);
                    }
                } else {
                    taskUser.setTaskStatus(Integer.valueOf(1));
                    taskUser.setRate(Integer.valueOf(0));
                    taskUser.setStartTime(now);
                    this.updateLearnUserData(taskUser);
                }
            } else if (!StringUtils.isEmpty((Object)taskSchedule.getTrainingId())) {
                Integer learnType = 2;
                List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(taskSchedule.getTrainingId(), learnType, taskSchedule.getId(), viewTime.getUserId(), 1, taskSchedule.getIsSync());
                if (!CollectionUtils.isEmpty(timeList)) {
                    Integer is = 1;
                    Integer times = 0;
                    for (TrainingUserViewTimeVo vo : timeList) {
                        if (vo.getIsFinish() == 0) {
                            is = 0;
                        }
                        times = times + vo.getViewTimes();
                    }
                    if (is == 1) {
                        taskUser.setTaskStatus(Integer.valueOf(4));
                        if (StringUtils.isEmpty((Object)taskUser.getStartTime())) {
                            taskUser.setStartTime(now);
                        }
                        taskUser.setEndTime(now);
                        this.updateLearnUserData(taskUser);
                    } else {
                        taskUser.setTaskStatus(Integer.valueOf(1));
                        if (StringUtils.isEmpty((Object)taskUser.getStartTime())) {
                            taskUser.setStartTime(now);
                        }
                        taskUser.setEndTime(now);
                        this.updateLearnUserData(taskUser);
                    }
                } else {
                    taskUser.setTaskStatus(Integer.valueOf(1));
                    taskUser.setRate(Integer.valueOf(0));
                    taskUser.setStartTime(now);
                    this.updateLearnUserData(taskUser);
                }
            }
            if (ObjectUtils.isEmpty((Object)taskUser) || taskUser.getShiftId() == null) continue;
            this.appTrainingLearnProjectService.updateLearUserStatus(taskUser.getShiftId(), viewTime.getUserId());
        }
    }

    @Override
    public void saveTrainingViewTime(TrainingUserViewTime viewTime) {
        if (!ObjectUtils.isEmpty((Object)viewTime)) {
            Integer tempLearnType;
            if (viewTime.getTurns() == null || viewTime.getTurns() == 0) {
                viewTime.setTurns(Integer.valueOf(1));
            }
            if ((tempLearnType = viewTime.getLearnType()) == null) {
                tempLearnType = 1;
            }
            viewTime.setCreateTime(new Date());
            if (tempLearnType != 0) {
                viewTime.setId(null);
                viewTime.setLearnType(Integer.valueOf(0));
                this.updateUserViewData(viewTime);
            }
            viewTime.setId(null);
            viewTime.setLearnType(tempLearnType);
            this.updateUserViewData(viewTime);
            this.updateUserViewDataByType(viewTime);
            this.updateStudyStatusExecutor.execute(() -> {
                if (viewTime.getLearnType() == 1) {
                    this.trainingService.updateGoldByFinishTraining(viewTime);
                } else if (viewTime.getLearnType() == 2) {
                    this.saveViewTimeByLearn(viewTime);
                } else if (viewTime.getLearnType() == 3) {
                    this.saveViewTimeByJob(viewTime);
                } else if (viewTime.getLearnType() == 4) {
                    if (!StringUtils.isEmpty((Object)viewTime.getTrainingId()) && viewTime.getTrainingId() != 0) {
                        try {
                            this.trainingCourseService.saveCourseTaskEnd(viewTime.getTrainingId(), 1, viewTime.getUserId(), viewTime.getTaskId(), viewTime.getTurns());
                        }
                        catch (Exception e) {
                            log.error("\u57f9\u8bad\u8ba1\u5212\u8bfe\u7a0b\u7ed3\u675f", (Throwable)e);
                        }
                    } else {
                        try {
                            this.trainingCourseService.saveCourseTaskEnd(viewTime.getMaterialId(), 5, viewTime.getUserId(), viewTime.getTaskId(), viewTime.getTurns());
                        }
                        catch (Exception e) {
                            log.error("\u57f9\u8bad\u8ba1\u5212\u7d20\u6750\u7ed3\u675f", (Throwable)e);
                        }
                    }
                }
                this.saveTrainingLastView(viewTime);
                this.sendStudyEvent(viewTime);
            });
            this.updateStudyStatusExecutor.execute(() -> {
                if (viewTime.getTrainingId() != null) {
                    this.updateStudyStatus(viewTime);
                }
            });
        }
    }

    private void saveTrainingLastView(TrainingUserViewTime viewTime) {
        if (viewTime.getLearnType() == 0) {
            return;
        }
        TrainingUserLastView trainingUserLastView = new TrainingUserLastView();
        trainingUserLastView.setLearnType(viewTime.getLearnType());
        trainingUserLastView.setUserId(viewTime.getUserId());
        Users user = new Users();
        user.setId(viewTime.getUserId());
        user.setGroupId(viewTime.getEnterpriseId());
        if (viewTime.getLearnType() == 1) {
            if (viewTime.getTrainingId() == null || viewTime.getAttachId() == null) {
                return;
            }
            trainingUserLastView.setProjectId(viewTime.getTrainingId());
            trainingUserLastView.setTaskId(viewTime.getAttachId());
        } else if (viewTime.getLearnType() == 2) {
            if (viewTime.getTaskId() == null) {
                return;
            }
            TrainingTaskSchedule trainingTaskSchedule = (TrainingTaskSchedule)this.trainingTaskScheduleMapper.selectById(viewTime.getTaskId());
            if (ObjectUtils.isEmpty((Object)trainingTaskSchedule)) {
                return;
            }
            trainingUserLastView.setProjectId(trainingTaskSchedule.getProjectId());
            trainingUserLastView.setTaskId(viewTime.getTaskId());
        } else if (viewTime.getLearnType() == 3) {
            if (viewTime.getTaskId() == null) {
                return;
            }
            TrainingJobStageTask trainingJobStageTask = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectById(viewTime.getTaskId());
            if (ObjectUtils.isEmpty((Object)trainingJobStageTask)) {
                return;
            }
            trainingUserLastView.setProjectId(trainingJobStageTask.getJobId());
            trainingUserLastView.setTaskId(viewTime.getTaskId());
        } else if (viewTime.getLearnType() == 4) {
            if (viewTime.getTaskId() == null) {
                return;
            }
            TrainingCourseStageTask trainingCourseStageTask = (TrainingCourseStageTask)this.trainingCourseStageTaskMapper.selectById(viewTime.getTaskId());
            if (ObjectUtils.isEmpty((Object)trainingCourseStageTask)) {
                return;
            }
            trainingUserLastView.setProjectId(trainingCourseStageTask.getCourseId());
            trainingUserLastView.setTaskId(viewTime.getTaskId());
        }
        this.saveUserLastView(trainingUserLastView, user);
    }

    public void saveViewTimeByJob(TrainingUserViewTime viewTime) {
        TrainingJobStageTask jobTask = (TrainingJobStageTask)this.trainingJobStageTaskMapper.selectById(viewTime.getTaskId());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingJobUserTask::getStageTaskId, (Object)viewTime.getTaskId())).eq(TrainingJobUserTask::getUserId, (Object)viewTime.getUserId())).orderByDesc(TrainingJobUserTask::getId)).last(" limit 1 ");
        TrainingJobUserTask userTask = (TrainingJobUserTask)this.trainingJobUserTaskMapper.selectOne((Wrapper)wrapper);
        if (userTask == null) {
            userTask = new TrainingJobUserTask();
            userTask.setJobId(jobTask.getJobId());
            userTask.setStageTaskId(jobTask.getId());
            userTask.setTaskType(jobTask.getTaskType());
            userTask.setShiftTaskId(userTask.getShiftTaskId());
            userTask.setUserId(viewTime.getUserId());
            userTask.setTaskStatus(Integer.valueOf(1));
            userTask.setStartTime(new Date());
            userTask.setEnterpriseId(jobTask.getEnterpriseId());
            userTask.setCreaterId(viewTime.getUserId());
            userTask.setCreateTime(new Date());
            userTask.setTaskStatus(Integer.valueOf(1));
            userTask.setUseTime(viewTime.getViewTime());
            this.trainingJobUserTaskMapper.insert(userTask);
        }
        if (jobTask != null && (jobTask.getMaterialId() != null || jobTask.getTrainingId() != null)) {
            if (!StringUtils.isEmpty((Object)jobTask.getMaterialId())) {
                TrainingMaterial material = (TrainingMaterial)this.trainingMaterialMapper.selectById(jobTask.getMaterialId());
                BigDecimal finishTime = new BigDecimal(30);
                if (material.getIsVideo() == 1) {
                    finishTime = new BigDecimal(material.getDuration());
                    if (!StringUtils.isEmpty((Object)material.getFinishRate())) {
                        finishTime = finishTime.multiply(material.getFinishRate()).divide(new BigDecimal(100), 0, 4);
                    }
                } else if (material.getFinishTime() != null) {
                    finishTime = new BigDecimal(material.getFinishTime());
                }
                TrainingUserViewTimeVo userViewTimes = null;
                userViewTimes = jobTask.getIsSync() != null && jobTask.getIsSync() == 1 ? this.commonService.selectMaterialViewTime(userTask.getUserId(), null, 0, material.getId(), null) : this.commonService.selectMaterialViewTime(userTask.getUserId(), jobTask.getId(), 3, material.getId(), null);
                if (!ObjectUtils.isEmpty((Object)userViewTimes) && !StringUtils.isEmpty((Object)userViewTimes.getMaterialId())) {
                    BigDecimal viewTimes = new BigDecimal(userViewTimes.getViewTimes());
                    if (viewTimes.compareTo(finishTime) >= 0) {
                        userTask.setTaskStatus(Integer.valueOf(4));
                        userTask.setEndTime(new Date());
                        userTask.setUseTime(Integer.valueOf(viewTimes.intValue()));
                        this.updateJobUserTaskData(userTask);
                    } else {
                        userTask.setTaskStatus(Integer.valueOf(1));
                        userTask.setUseTime(Integer.valueOf(viewTimes.intValue()));
                        this.updateJobUserTaskData(userTask);
                    }
                } else {
                    userTask.setTaskStatus(Integer.valueOf(1));
                    this.updateJobUserTaskData(userTask);
                }
            } else if (!StringUtils.isEmpty((Object)jobTask.getTrainingId())) {
                Integer learnType = 3;
                List<TrainingUserViewTimeVo> timeList = this.commonService.selectlearnProgress(jobTask.getTrainingId(), learnType, jobTask.getId(), viewTime.getUserId(), 1, jobTask.getIsSync());
                if (!CollectionUtils.isEmpty(timeList)) {
                    Integer is = 1;
                    Integer times = 0;
                    for (TrainingUserViewTimeVo vo : timeList) {
                        if (vo.getIsFinish() == 0) {
                            is = 0;
                        }
                        times = times + vo.getViewTimes();
                    }
                    if (is == 1) {
                        userTask.setTaskStatus(Integer.valueOf(4));
                        userTask.setEndTime(new Date());
                        userTask.setUseTime(times);
                        this.updateJobUserTaskData(userTask);
                    } else {
                        userTask.setTaskStatus(Integer.valueOf(1));
                        userTask.setUseTime(times);
                        this.updateJobUserTaskData(userTask);
                    }
                } else {
                    userTask.setTaskStatus(Integer.valueOf(1));
                    this.updateJobUserTaskData(userTask);
                }
            }
            this.jobCertificationService.getIsFinishAllTask(userTask.getJobId(), userTask.getUserId());
        }
    }

    @Override
    public void saveUserLastView(TrainingUserLastView lastView, Users user) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingUserLastView::getLearnType, (Object)lastView.getLearnType())).eq(TrainingUserLastView::getProjectId, (Object)lastView.getProjectId())).eq(TrainingUserLastView::getUserId, (Object)lastView.getUserId())).orderByDesc(TrainingUserLastView::getId);
        List viewList = this.lastViewMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)viewList)) {
            lastView.setCreater(user.getId());
            lastView.setEnterpriseId(user.getGroupId());
            lastView.setCreateTime(new Date());
            this.lastViewMapper.insert(lastView);
        } else {
            TrainingUserLastView view1 = (TrainingUserLastView)viewList.get(0);
            view1.setTaskId(lastView.getTaskId());
            this.lastViewMapper.updateById(view1);
            if (viewList.size() > 1) {
                for (int i = 1; i < viewList.size(); ++i) {
                    this.lastViewMapper.deleteById(((TrainingUserLastView)viewList.get(i)).getId());
                }
            }
        }
    }

    @Override
    public Integer getReadAddGoldTimes(Integer userId) {
        int totalTime = this.viewTimeMapper.getReadTimeByUser(userId, null);
        int nowTime = this.viewTimeMapper.getReadTimeByUser(userId, 1);
        int lastTime = (totalTime - nowTime) % 1800;
        Integer times = (lastTime + nowTime) / 1800;
        return times;
    }

    @Override
    public Page<TrainingsVo> getTrainingByPage(Page<TrainingsVo> page, Users user) {
        List<TrainingsVo> list = this.trainingMapper.getTrainingByPage(page, user.getId());
        if (!CollectionUtils.isEmpty(list)) {
            for (TrainingsVo vo : list) {
                vo.setHeadUrl(StringUtils.isEmpty((Object)vo.getHeadUrl()) ? user.getThumbUrl() : vo.getHeadUrl());
                vo.setCreatName(user.getShowName());
                boolean valid = this.materialPermissionFacade.validTrain(vo.getId(), user, 1);
                vo.setIsReadPower(Integer.valueOf(valid ? 1 : 0));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public void insertTrainingUserViewTimeList(List<TrainingUserViewTime> list) {
        for (TrainingUserViewTime viewTime : list) {
            this.updateUserViewDataByType(viewTime);
        }
    }
}

