/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enums.ProjectShiftStatusEnum;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingShiftExeclService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.StudentReportRequestVo;
import com.ovopark.training.vo.StudentReportVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingShiftExeclServiceImpl
implements TrainingShiftExeclService {
    private static final Logger log = LoggerFactory.getLogger(TrainingShiftExeclServiceImpl.class);
    @Autowired
    private TrainingLearnProjectMapper learnMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private RoleApi roleApi;

    @Override
    public Page<TrainingLearnShiftVo> selectOpenShiftByPage(Page<TrainingLearnShiftVo> page, Users user, List<Integer> creater, String startTime, String endTime, Integer sourceId) {
        List<TrainingLearnShiftVo> list = this.learnMapper.selectOpenShiftByPage(page, user.getGroupId(), creater, startTime, endTime, sourceId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> creatorId = list.stream().map(TrainingLearnShift::getCreatorId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorId);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(creatorId, user.getGroupId());
            for (TrainingLearnShiftVo vo : list) {
                List<String> nameList;
                UsersPojo pojo = pojoMap.get(vo.getCreatorId());
                if (!StringUtils.isEmpty((Object)pojo)) {
                    vo.setCreatorName(pojo.getShowName());
                    vo.setUserName(pojo.getEmployeeNumber());
                }
                if (CollectionUtils.isEmpty(nameList = userOrganizeMap.get(vo.getCreatorId()))) continue;
                vo.setOrganizeName(String.join((CharSequence)";", nameList));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public List<TrainingLearnShiftVo> selectOpenShift(Users user, List<Integer> creater, String startTime, String endTime, Integer sourceId) {
        List<TrainingLearnShiftVo> list = this.learnMapper.selectOpenShift(user.getGroupId(), creater, startTime, endTime, sourceId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> creatorId = list.stream().map(TrainingLearnShift::getCreatorId).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorId);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(creatorId, user.getGroupId());
            for (TrainingLearnShiftVo vo : list) {
                List<String> nameList;
                UsersPojo pojo = pojoMap.get(vo.getCreatorId());
                if (!StringUtils.isEmpty((Object)pojo)) {
                    vo.setCreatorName(pojo.getShowName());
                    vo.setUserName(pojo.getEmployeeNumber());
                }
                if (CollectionUtils.isEmpty(nameList = userOrganizeMap.get(vo.getCreatorId()))) continue;
                vo.setOrganizeName(String.join((CharSequence)";", nameList));
            }
        }
        return list;
    }

    public StudentReportVo getCheckShiftStatus(StudentReportVo vo) {
        if (!StringUtils.isEmpty((Object)vo.getShiftStatus())) {
            if (vo.getShiftStatus() == ProjectShiftStatusEnum.NOT_ONLINE.getKey()) {
                vo.setShiftStatuses(Arrays.asList(0, 1));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.ONLINE.getKey()) {
                vo.setShiftStatuses(Arrays.asList(2, 3, 4, 5));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.DRAFT.getKey()) {
                vo.setShiftStatuses(Arrays.asList(0));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.WAIT_START.getKey()) {
                vo.setShiftStatuses(Arrays.asList(1));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.DOING.getKey()) {
                vo.setShiftStatuses(Arrays.asList(2));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.WAIT_END.getKey()) {
                vo.setShiftStatuses(Arrays.asList(3, 5));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.ENDED.getKey()) {
                vo.setShiftStatuses(Arrays.asList(4));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.NOT_START.getKey()) {
                vo.setShiftStatuses(Arrays.asList(1));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.ING.getKey()) {
                vo.setShiftStatuses(Arrays.asList(2));
            } else if (vo.getShiftStatus() == ProjectShiftStatusEnum.END.getKey()) {
                vo.setShiftStatuses(Arrays.asList(3, 4));
            }
        }
        return vo;
    }

    @Override
    public Page<StudentReportVo> selectStudentReportByPage(Page<StudentReportVo> page, StudentReportRequestVo vo, Users user) {
        ArrayList<Integer> userList = new ArrayList();
        Map<String, Object> userMap = this.userUtilService.getCheckParameters(vo.getKeyWord(), vo.getDutiesId(), vo.getOrganizeIds(), user);
        if (userMap.get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            return page;
        }
        this.getCheckShiftStatus((StudentReportVo)vo);
        List<StudentReportVo> list = this.learnMapper.selectStudentReportByPage(page, user.getGroupId(), userList, vo.getShiftName(), vo.getShiftStatuses(), vo.getCreatorIds(), vo.getShiftStartCreateTime(), vo.getShiftEndCreateTime(), vo.getShiftStartTime(), vo.getShiftEndTime(), vo.getLearnStatus(), vo.getSourceId());
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> creatorId = list.stream().map(StudentReportVo::getCreatorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> userIds = list.stream().map(StudentReportVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorId);
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(userIds, user.getGroupId());
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", org.apache.commons.lang.StringUtils.join(userIds, (String)","));
                parameter.put("groupId", user.getGroupId());
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            for (StudentReportVo reportVo : list) {
                reportVo.setCreatorName(pojoMap.get(reportVo.getCreatorId()) == null ? "" : pojoMap.get(reportVo.getCreatorId()).getShowName());
                UsersPojo pojo = usersMap.get(reportVo.getUserId());
                reportVo.setJobNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                reportVo.setUserName(pojo == null ? "" : pojo.getShowName());
                UserDutiesMo mo = dutiesMap.get(reportVo.getUserId());
                reportVo.setDutiesName(mo == null ? "" : mo.getDutieName());
                List<String> userStr = userOrganizeMap.get(reportVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    reportVo.setOrganizeName(String.join((CharSequence)";", String.join((CharSequence)";\n", userStr)));
                }
                reportVo.setParentName(parentMap.get(reportVo.getUserId()) == null ? "" : parentMap.get(reportVo.getUserId()));
                reportVo.setParentUserId(parentIdMap.get(reportVo.getUserId()) == null ? null : parentIdMap.get(reportVo.getUserId()));
                if (CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(reportVo.getUserId())))) continue;
                StringBuilder role = new StringBuilder();
                for (RolePojo rolePojo : (List)userRoleMap.get(reportVo.getUserId())) {
                    role.append(rolePojo.getRoleName()).append(";\n");
                }
                reportVo.setRole(role.substring(0, role.length() - 2));
            }
        }
        page.setContent(list);
        return page;
    }

    @Override
    public List<StudentReportVo> selectStudentReport(StudentReportVo vo, Users user) {
        List<StudentReportVo> list = new ArrayList<StudentReportVo>();
        ArrayList<Integer> userList = new ArrayList();
        Map<String, Object> userMap = this.userUtilService.getCheckParameters(vo.getKeyWord(), vo.getDutiesId(), vo.getOrganizeIds(), user);
        if (userMap.get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            return list;
        }
        this.getCheckShiftStatus(vo);
        list = this.learnMapper.selectStudentReport(user.getGroupId(), userList, vo.getShiftName(), vo.getShiftStatuses(), vo.getCreatorIds(), vo.getShiftStartCreateTime(), vo.getShiftEndCreateTime(), vo.getShiftStartTime(), vo.getShiftEndTime(), vo.getLearnStatus(), vo.getSourceId());
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> creatorId = list.stream().map(StudentReportVo::getCreatorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> userIds = list.stream().map(StudentReportVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(creatorId);
            Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIds);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(userIds, user.getGroupId());
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(userIds, user.getGroupId());
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(userIds, user.getGroupId());
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(userIds)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", org.apache.commons.lang.StringUtils.join(userIds, (String)","));
                parameter.put("groupId", user.getGroupId());
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            for (StudentReportVo reportVo : list) {
                reportVo.setCreatorName(pojoMap.get(reportVo.getCreatorId()) == null ? "" : pojoMap.get(reportVo.getCreatorId()).getShowName());
                UsersPojo pojo = usersMap.get(reportVo.getUserId());
                reportVo.setJobNumber(pojo == null ? "" : pojo.getEmployeeNumber());
                reportVo.setUserName(pojo == null ? "" : pojo.getShowName());
                reportVo.setUserAccount(pojo == null ? "" : pojo.getUserName());
                UserDutiesMo mo = dutiesMap.get(reportVo.getUserId());
                reportVo.setDutiesName(mo == null ? "" : mo.getDutieName());
                List<String> userStr = userOrganizeMap.get(reportVo.getUserId());
                if (!CollectionUtils.isEmpty(userStr)) {
                    reportVo.setOrganizeName(String.join((CharSequence)";\n", userStr));
                }
                reportVo.setParentName(parentMap.get(reportVo.getUserId()) == null ? "" : parentMap.get(reportVo.getUserId()));
                if (CollectionUtils.isEmpty((Collection)((Collection)userRoleMap.get(reportVo.getUserId())))) continue;
                StringBuilder role = new StringBuilder();
                for (RolePojo rolePojo : (List)userRoleMap.get(reportVo.getUserId())) {
                    role.append(rolePojo.getRoleName()).append(";\n");
                }
                reportVo.setRole(role.substring(0, role.length() - 1));
            }
        }
        return list;
    }
}

