/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingWorkDocumentMapper;
import com.ovopark.training.mapper.TrainingWorkMapper;
import com.ovopark.training.mapper.TrainingWorkReviewerMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerLogMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.TrainingWorkDocument;
import com.ovopark.training.model.TrainingWorkReviewer;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.TrainingWorkUserAnswerLog;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingWorkReviewerService;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.ReviewByPageReq;
import com.ovopark.training.vo.ReviewNumVo;
import com.ovopark.training.vo.TrainingWorkUserAnswerVo;
import com.ovopark.training.vo.UnReviewListVo;
import com.ovopark.training.vo.WorkNotifyVo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingWorkReviewerServiceImpl
implements TrainingWorkReviewerService {
    private static final Logger log = LoggerFactory.getLogger(TrainingWorkReviewerServiceImpl.class);
    @Autowired
    private TrainingWorkReviewerMapper trainingWorkReviewerMapper;
    @Autowired
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Autowired
    private UserApi userApi;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingWorkDocumentMapper trainingWorkDocumentMapper;
    @Autowired
    private TrainingWorkMapper trainingWorkMapper;
    @Autowired
    private TrainingWorkService trainingWorkService;
    @Autowired
    private TrainingWorkUserAnswerLogMapper trainingWorkUserAnswerLogMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private MessageSource messageSource;

    @Override
    public String getUnReviewByPage(Page<UnReviewListVo> page, ReviewByPageReq req, Users user) {
        Map<String, Object> userMap;
        ArrayList<Integer> workId = new ArrayList();
        List<Integer> userAnswerId = new ArrayList<Integer>();
        LambdaQueryWrapper reviewerWrapper = new LambdaQueryWrapper();
        reviewerWrapper.eq(TrainingWorkReviewer::getEnterpriseId, (Object)user.getGroupId());
        reviewerWrapper.eq(TrainingWorkReviewer::getUserId, (Object)user.getId());
        List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)reviewerWrapper);
        if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
            workId = reviewerList.stream().filter(e -> e.getUserAnswerId() == null).map(TrainingWorkReviewer::getWorkId).distinct().collect(Collectors.toList());
            userAnswerId = reviewerList.stream().map(TrainingWorkReviewer::getUserAnswerId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List<Integer> userList = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)req.getShowName()) && (userMap = this.userUtilService.getCheckParameters(req.getShowName(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            return JsonResult.success(page);
        }
        List<UnReviewListVo> list = this.trainingWorkUserAnswerMapper.getUnReviewByPage(page, req, workId, userList, userAnswerId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> userIdList = list.stream().map(UnReviewListVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap2 = this.userUtilService.selectUserMap(userIdList);
            for (UnReviewListVo unReviewListVo : list) {
                UsersPojo userPojo = userMap2.get(unReviewListVo.getUserId());
                if (ObjectUtils.isEmpty((Object)userPojo)) continue;
                unReviewListVo.setShowName(userPojo.getShowName());
            }
        }
        page.setContent(list);
        return JsonResult.success(page);
    }

    @Override
    public String getUserAnswer(Integer userId, Integer userAnswerId) {
        TrainingWorkUserAnswerVo userAnswerVo = new TrainingWorkUserAnswerVo();
        TrainingWorkUserAnswer userAnswer = (TrainingWorkUserAnswer)this.trainingWorkUserAnswerMapper.selectById(userAnswerId);
        BeanUtils.copyProperties((Object)userAnswer, (Object)userAnswerVo);
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.eq(TrainingWorkDocument::getAnswerId, (Object)userAnswerVo.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)2)).orderByAsc(TrainingWorkDocument::getId);
        List documentAnswerList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper4);
        userAnswerVo.setWorkDocumentList(documentAnswerList);
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(userAnswer.getWorkId());
        userAnswerVo.setWorkName(work.getWorkName());
        userAnswerVo.setPassType(work.getPassType());
        userAnswerVo.setFullScore(work.getFullScore());
        userAnswerVo.setPassScore(work.getPassScore());
        BaseResult myUserResult = this.userApi.getUserById(userAnswer.getUserId());
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo userPojo = (UsersPojo)myUserResult.getData();
            userAnswerVo.setShowName(userPojo.getShowName());
            userAnswerVo.setThumbUrl(userPojo.getThumbUrl());
            ArrayList<Integer> userIdList = new ArrayList<Integer>();
            userIdList.add(userPojo.getId());
            Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
            if (!CollectionUtils.isEmpty(organizeMap)) {
                List<String> list = organizeMap.get(userPojo.getId());
                userAnswerVo.setOrganizes(list.get(0));
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingWorkUserAnswerLog::getUserAnswerId, (Object)userAnswerId);
        wrapper.orderByDesc(TrainingWorkUserAnswerLog::getCreateTime);
        List list = this.trainingWorkUserAnswerLogMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            userAnswerVo.setLogList(list);
        }
        return JsonResult.success((Object)userAnswerVo);
    }

    @Override
    public String getUserAnswerNew(Integer userId, Integer userAnswerId, Integer turns) {
        ArrayList<TrainingWorkUserAnswerVo> userAnswerVoList = new ArrayList<TrainingWorkUserAnswerVo>();
        TrainingWorkUserAnswer userAnswer = (TrainingWorkUserAnswer)this.trainingWorkUserAnswerMapper.selectById(userAnswerId);
        if (!ObjectUtils.isEmpty((Object)userAnswer) && userAnswer.getUserId() != null && userAnswer.getWorkId() != null) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkUserAnswer::getWorkId, (Object)userAnswer.getWorkId())).eq(TrainingWorkUserAnswer::getUserId, (Object)userAnswer.getUserId())).eq(turns != null, TrainingWorkUserAnswer::getTurns, (Object)turns)).ne(TrainingWorkUserAnswer::getStatus, (Object)0)).orderByAsc(TrainingWorkUserAnswer::getId);
            List userAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
            List userAnswerIdList = userAnswerList.stream().map(TrainingWorkUserAnswer::getId).collect(Collectors.toList());
            TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(userAnswer.getWorkId());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingWorkDocument::getAnswerId, userAnswerIdList)).eq(TrainingWorkDocument::getDocumentType, (Object)2)).orderByAsc(TrainingWorkDocument::getId);
            List documentAnswerList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper2);
            Map<Object, Object> trainingWorkDocumentMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)documentAnswerList)) {
                trainingWorkDocumentMap = documentAnswerList.stream().collect(Collectors.groupingBy(TrainingWorkDocument::getAnswerId));
            }
            UsersPojo userPojo = new UsersPojo();
            String organizes = "";
            BaseResult myUserResult = this.userApi.getUserById(userAnswer.getUserId());
            if (!myUserResult.getIsError().booleanValue()) {
                userPojo = (UsersPojo)myUserResult.getData();
                ArrayList<Integer> userIdList = new ArrayList<Integer>();
                userIdList.add(userPojo.getId());
                Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, userPojo.getGroupId());
                if (!CollectionUtils.isEmpty(organizeMap)) {
                    List<String> list = organizeMap.get(userPojo.getId());
                    organizes = list.get(0);
                }
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.in(TrainingWorkUserAnswerLog::getUserAnswerId, userAnswerIdList)).orderByDesc(TrainingWorkUserAnswerLog::getCreateTime);
            List list = this.trainingWorkUserAnswerLogMapper.selectList((Wrapper)wrapper3);
            Map<Object, Object> trainingWorkUserAnswerLogMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                trainingWorkUserAnswerLogMap = list.stream().collect(Collectors.groupingBy(TrainingWorkUserAnswerLog::getUserAnswerId));
            }
            TrainingWorkUserAnswerVo userAnswerVo = null;
            for (TrainingWorkUserAnswer trainingWorkUserAnswer : userAnswerList) {
                userAnswerVo = new TrainingWorkUserAnswerVo();
                BeanUtils.copyProperties((Object)trainingWorkUserAnswer, (Object)userAnswerVo);
                userAnswerVo.setWorkName(work.getWorkName());
                userAnswerVo.setPassType(work.getPassType());
                userAnswerVo.setFullScore(work.getFullScore());
                userAnswerVo.setPassScore(work.getPassScore());
                userAnswerVo.setWorkDocumentList((List)trainingWorkDocumentMap.get(trainingWorkUserAnswer.getId()));
                userAnswerVo.setShowName(userPojo.getShowName());
                userAnswerVo.setThumbUrl(userPojo.getThumbUrl());
                userAnswerVo.setOrganizes(organizes);
                if (!CollectionUtils.isEmpty((Collection)((Collection)trainingWorkUserAnswerLogMap.get(trainingWorkUserAnswer.getId())))) {
                    userAnswerVo.setLogList((List)trainingWorkUserAnswerLogMap.get(trainingWorkUserAnswer.getId()));
                }
                userAnswerVoList.add(userAnswerVo);
            }
        }
        return JsonResult.success(userAnswerVoList);
    }

    @Override
    public String workReview(ReviewByPageReq req, Users user, Integer userAnswerId, Float score, String comment, Integer isPass) {
        List<UnReviewListVo> review;
        Map<String, Object> userMap;
        final TrainingWorkUserAnswer userAnswer = (TrainingWorkUserAnswer)this.trainingWorkUserAnswerMapper.selectById(userAnswerId);
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(userAnswer.getWorkId());
        userAnswer.setRemarker(user.getId());
        userAnswer.setRemarkTime(new Date());
        if (score != null) {
            userAnswer.setScore(new BigDecimal(score.floatValue()));
            if (score.floatValue() >= work.getPassScore().floatValue()) {
                userAnswer.setStatus(Integer.valueOf(3));
            } else {
                userAnswer.setStatus(Integer.valueOf(2));
            }
        }
        userAnswer.setComment(StringUtils.isEmpty((Object)comment) ? "" : comment);
        if (isPass != null) {
            if (isPass == 1) {
                userAnswer.setStatus(Integer.valueOf(3));
            } else if (isPass == 0) {
                userAnswer.setStatus(Integer.valueOf(2));
            }
        }
        this.trainingWorkUserAnswerMapper.updateById(userAnswer);
        TrainingWorkUserAnswerLog log = new TrainingWorkUserAnswerLog();
        log.setUserAnswerId(userAnswerId);
        log.setCreateTime(new Date());
        log.setComment(StringUtils.isEmpty((Object)userAnswer.getComment()) ? "" : userAnswer.getComment());
        BaseResult myUserResult = this.userApi.getUserById(user.getId());
        if (!myUserResult.getIsError().booleanValue()) {
            UsersPojo usersPojo = (UsersPojo)myUserResult.getData();
            log.setRemarkerName(usersPojo.getShowName());
        }
        log.setPassType(work.getPassType());
        log.setScore(userAnswer.getScore());
        log.setStatus(userAnswer.getStatus());
        this.trainingWorkUserAnswerLogMapper.insert(log);
        final TrainingWorkUserAnswerVo vo = new TrainingWorkUserAnswerVo();
        BeanUtils.copyProperties((Object)userAnswer, (Object)vo);
        this.trainingWorkService.updateTaskScheduleStatusByWork(vo);
        final Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    String passName = TrainingWorkReviewerServiceImpl.this.messageSource.getMessage("training.work.pass.detail", null, locale);
                    String notPassName = TrainingWorkReviewerServiceImpl.this.messageSource.getMessage("training.work.not.pass.detail", null, locale);
                    String warn = TrainingWorkReviewerServiceImpl.this.messageSource.getMessage("training.work.review.warn", null, locale);
                    String answerStatus = null;
                    if (userAnswer.getStatus().equals(2)) {
                        answerStatus = notPassName;
                    } else if (userAnswer.getStatus().equals(3)) {
                        answerStatus = passName;
                    }
                    TaskMessageBody body = new TaskMessageBody();
                    body.setTitleStr(answerStatus);
                    body.setType(112);
                    body.setTaskJson(JSONObject.toJSONString((Object)userAnswer));
                    vo.setTitle(warn);
                    try {
                        TrainingWorkReviewerServiceImpl.this.jPushService.sendWebSocket(answerStatus, answerStatus, userAnswer.getUserId(), userAnswer.getEnterpriseId(), userAnswer.getId(), "TYPE_TRAININ_WORK_AFTER", JSONObject.toJSONString((Object)vo), new Date(), 1, 0, null, null);
                        TrainingWorkReviewerServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAININ_WORK_AFTER", userAnswer.getUserId(), warn, answerStatus, body);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        LambdaQueryWrapper reviewerWrapper = new LambdaQueryWrapper();
        reviewerWrapper.eq(TrainingWorkReviewer::getEnterpriseId, (Object)user.getGroupId());
        reviewerWrapper.eq(TrainingWorkReviewer::getUserId, (Object)user.getId());
        List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)reviewerWrapper);
        if (CollectionUtils.isEmpty((Collection)reviewerList)) {
            return JsonResult.success();
        }
        ArrayList<Integer> userList = new ArrayList();
        if (!StringUtils.isEmpty((Object)req.getShowName()) && (userMap = this.userUtilService.getCheckParameters(req.getShowName(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            return JsonResult.success();
        }
        List<Integer> workIdList = new ArrayList<Integer>();
        List<Integer> userAnswerIdList = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
            workIdList = reviewerList.stream().filter(e -> e.getUserAnswerId() == null).map(TrainingWorkReviewer::getWorkId).distinct().collect(Collectors.toList());
            userAnswerIdList = reviewerList.stream().map(TrainingWorkReviewer::getUserAnswerId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (userAnswer.getSourceType() == 3) {
            this.appTrainingLearnProjectService.updateLearUserStatus(userAnswer.getSourceShiftId(), userAnswer.getUserId());
        }
        if (!CollectionUtils.isEmpty(review = this.trainingWorkUserAnswerMapper.getUnReview(req, userAnswerId, workIdList, userList, userAnswerIdList))) {
            UnReviewListVo result = review.get(0);
            result.setTotalNum(review.size());
            return JsonResult.success((Object)result);
        }
        return JsonResult.success();
    }

    @Override
    public String getReviewByPage(Page<UnReviewListVo> page, ReviewByPageReq req, Users user) {
        Map<String, Object> userMap;
        ArrayList<Integer> workId = new ArrayList();
        List<Integer> userAnswerId = new ArrayList<Integer>();
        LambdaQueryWrapper reviewerWrapper = new LambdaQueryWrapper();
        reviewerWrapper.eq(TrainingWorkReviewer::getEnterpriseId, (Object)user.getGroupId());
        reviewerWrapper.eq(TrainingWorkReviewer::getUserId, (Object)user.getId());
        List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)reviewerWrapper);
        if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
            workId = reviewerList.stream().filter(e -> e.getUserAnswerId() == null).map(TrainingWorkReviewer::getWorkId).distinct().collect(Collectors.toList());
            userAnswerId = reviewerList.stream().map(TrainingWorkReviewer::getUserAnswerId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List<Integer> userList = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)req.getShowName()) && (userMap = this.userUtilService.getCheckParameters(req.getShowName(), null, null, user)).get("isEffect").toString().equals("1") && CollectionUtils.isEmpty(userList = (List)userMap.get("userList"))) {
            return JsonResult.success(page);
        }
        List<UnReviewListVo> list = this.trainingWorkUserAnswerMapper.getReviewByPage(page, req, workId, userList, userAnswerId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Integer> userIdList = list.stream().map(UnReviewListVo::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> userMap2 = this.userUtilService.selectUserMap(userIdList);
            List<Integer> remarkerIdList = list.stream().map(UnReviewListVo::getRemarker).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Integer, UsersPojo> remarkerMap = this.userUtilService.selectUserMap(remarkerIdList);
            for (UnReviewListVo unReviewListVo : list) {
                TrainingCourse trainingCourse;
                UsersPojo pojo2;
                UsersPojo pojo1 = userMap2.get(unReviewListVo.getUserId());
                if (!ObjectUtils.isEmpty((Object)pojo1)) {
                    unReviewListVo.setShowName(pojo1.getShowName());
                }
                if (!ObjectUtils.isEmpty((Object)(pojo2 = remarkerMap.get(unReviewListVo.getRemarker())))) {
                    unReviewListVo.setRemarkerName(pojo2.getShowName());
                }
                if (unReviewListVo.getSourceType() == null) continue;
                if (unReviewListVo.getSourceType().equals(3) && unReviewListVo.getSourceShiftId() != null) {
                    TrainingLearnShift shift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(unReviewListVo.getSourceShiftId());
                    if (shift == null || !shift.getStatus().equals(4)) continue;
                    unReviewListVo.setCanReview(Integer.valueOf(0));
                    continue;
                }
                if (!unReviewListVo.getSourceType().equals(5) || unReviewListVo.getSourceProjectId() == null || ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(unReviewListVo.getSourceProjectId()))) || !trainingCourse.getStatus().equals(3)) continue;
                unReviewListVo.setCanReview(Integer.valueOf(0));
            }
        }
        page.setContent(list);
        return JsonResult.success(page);
    }

    @Override
    public String getReviewNum(Integer groupId, Integer userId) {
        ReviewNumVo vo = new ReviewNumVo();
        LambdaQueryWrapper reviewerWrapper = new LambdaQueryWrapper();
        reviewerWrapper.eq(TrainingWorkReviewer::getEnterpriseId, (Object)groupId);
        reviewerWrapper.eq(TrainingWorkReviewer::getUserId, (Object)userId);
        List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)reviewerWrapper);
        if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
            List userAnsweIdList;
            List workIds = reviewerList.stream().filter(e -> e.getUserAnswerId() == null).map(TrainingWorkReviewer::getWorkId).collect(Collectors.toList());
            List<Object> userAnswerIds = new ArrayList();
            if (!CollectionUtils.isEmpty(workIds)) {
                LambdaQueryWrapper unAnswerWrapper = new LambdaQueryWrapper();
                unAnswerWrapper.in(TrainingWorkUserAnswer::getWorkId, workIds);
                ((LambdaQueryWrapper)unAnswerWrapper.eq(TrainingWorkUserAnswer::getStatus, (Object)1)).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
                List unReviewNum = this.trainingWorkUserAnswerMapper.selectList((Wrapper)unAnswerWrapper);
                if (!CollectionUtils.isEmpty((Collection)unReviewNum)) {
                    userAnswerIds = unReviewNum.stream().map(TrainingWorkUserAnswer::getId).distinct().collect(Collectors.toList());
                    vo.setUnReviewNum(unReviewNum.size());
                }
            }
            if (!CollectionUtils.isEmpty(userAnsweIdList = reviewerList.stream().filter(e -> e.getUserAnswerId() != null).map(TrainingWorkReviewer::getUserAnswerId).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingWorkUserAnswer::getId, userAnsweIdList)).in(TrainingWorkUserAnswer::getStatus, new Object[]{1})).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
                List trainingWorkUserAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                    List userAnsweIdList2 = trainingWorkUserAnswerList.stream().map(TrainingWorkUserAnswer::getId).collect(Collectors.toList());
                    userAnsweIdList2.removeAll(userAnswerIds);
                    vo.setUnReviewNum(userAnsweIdList2.size() + vo.getUnReviewNum());
                }
            }
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            statusList.add(2);
            statusList.add(3);
            if (!CollectionUtils.isEmpty(workIds)) {
                LambdaQueryWrapper answerWrapper = new LambdaQueryWrapper();
                answerWrapper.in(TrainingWorkUserAnswer::getWorkId, workIds);
                ((LambdaQueryWrapper)answerWrapper.in(TrainingWorkUserAnswer::getStatus, statusList)).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
                List reviewNum = this.trainingWorkUserAnswerMapper.selectList((Wrapper)answerWrapper);
                if (!CollectionUtils.isEmpty((Collection)reviewNum)) {
                    vo.setReviewNum(reviewNum.size());
                }
            }
            if (!CollectionUtils.isEmpty(userAnsweIdList)) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingWorkUserAnswer::getId, userAnsweIdList)).in(TrainingWorkUserAnswer::getStatus, statusList)).eq(TrainingWorkUserAnswer::getIsLast, (Object)1);
                List trainingWorkUserAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper1);
                if (!CollectionUtils.isEmpty((Collection)trainingWorkUserAnswerList)) {
                    vo.setReviewNum(vo.getReviewNum() + trainingWorkUserAnswerList.size());
                }
            }
        }
        return JsonResult.success((Object)vo);
    }

    @Override
    public void workNotify() {
        final List<WorkNotifyVo> userList = this.trainingWorkUserAnswerMapper.selectGroupByUserId();
        if (!CollectionUtils.isEmpty(userList)) {
            CommonUtil.handleTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TaskMessageBody body = null;
                        String reviewDetail = "\u60a8\u5f53\u524d\u6709{0}\u4e2a\u4f5c\u4e1a\u5f85\u6279\u9605\uff0c\u8bf7\u81f3web\u7aef<\u57f9\u8bad-\u6279\u9605\u7ba1\u7406-\u4f5c\u4e1a\u6279\u9605>\u4e2d\u53ca\u65f6\u6279\u9605";
                        String warn = "\u4f5c\u4e1a\u6279\u9605\u63d0\u9192";
                        for (WorkNotifyVo workNotifyVo : userList) {
                            workNotifyVo.setTitle(warn);
                            body = new TaskMessageBody();
                            body.setType(111);
                            body.setTaskJson(JSONObject.toJSONString((Object)workNotifyVo));
                            TrainingWorkReviewerServiceImpl.this.jPushService.sendWebSocket(warn, MessageFormat.format(reviewDetail, workNotifyVo.getNum()), workNotifyVo.getUserId(), workNotifyVo.getEnterpriseId(), workNotifyVo.getUserId(), "TYPE_TRAININ_WORK", JSONObject.toJSONString((Object)workNotifyVo), new Date(), 1, 0, "training.job.course.review.detail", workNotifyVo.getNum().toString());
                            TrainingWorkReviewerServiceImpl.this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_TRAININ_WORK", workNotifyVo.getUserId(), warn, MessageFormat.format(reviewDetail, workNotifyVo.getNum()), body);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

