/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.training.mapper.TrainingCourseConfigMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingLearnManagerMapper;
import com.ovopark.training.mapper.TrainingLearnProjectMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingProjectTaskMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingWorkDocumentMapper;
import com.ovopark.training.mapper.TrainingWorkMapper;
import com.ovopark.training.mapper.TrainingWorkReviewerMapper;
import com.ovopark.training.mapper.TrainingWorkUserAnswerMapper;
import com.ovopark.training.mapper.TrainingWorkUsersMapper;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseConfig;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingLearnManager;
import com.ovopark.training.model.TrainingLearnProject;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingProjectTask;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingWork;
import com.ovopark.training.model.TrainingWorkDocument;
import com.ovopark.training.model.TrainingWorkReviewer;
import com.ovopark.training.model.TrainingWorkUserAnswer;
import com.ovopark.training.model.TrainingWorkUsers;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingWorkReviewerVo;
import com.ovopark.training.vo.TrainingWorkUserAnswerVo;
import com.ovopark.training.vo.TrainingWorkUsersVo;
import com.ovopark.training.vo.TrainingWorkVo;
import com.ovopark.training.vo.WorkStatusVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingWorkServiceImpl
implements TrainingWorkService {
    private static final Logger log = LoggerFactory.getLogger(TrainingWorkServiceImpl.class);
    @Resource
    private TrainingWorkMapper trainingWorkMapper;
    @Resource
    private TrainingWorkUserAnswerMapper trainingWorkUserAnswerMapper;
    @Resource
    private TrainingWorkUsersMapper trainingWorkUsersMapper;
    @Resource
    private TrainingWorkDocumentMapper trainingWorkDocumentMapper;
    @Resource
    private TrainingWorkReviewerMapper trainingWorkReviewerMapper;
    @Resource
    private TrainingLearnManagerMapper trainingLearnManagerMapper;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private TrainingLearnProjectService learnProjectService;
    @Resource
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Resource
    private TrainingLearnTaskUserMapper trainingLearnTaskUserMapper;
    @Resource
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Resource
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Resource
    private TrainingLearnProjectMapper trainingLearnProjectMapper;
    @Resource
    private TrainingProjectTaskMapper trainingProjectTaskMapper;
    @Resource
    private TrainingCourseService trainingCourseService;
    @Resource
    private TrainingCourseMapper trainingCourseMapper;
    @Resource
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingCourseConfigMapper trainingCourseConfigMapper;

    @Override
    public TrainingWorkVo selectTrainingWorkVo(TrainingWorkVo workVo, Users user) {
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(workVo.getId());
        if (!ObjectUtils.isEmpty((Object)work)) {
            BeanUtils.copyProperties((Object)work, (Object)workVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkDocument::getWorkId, (Object)workVo.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)1)).orderByAsc(TrainingWorkDocument::getId);
            List documentList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper1);
            workVo.setWorkDocumentList(documentList);
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingWorkUsers::getWorkId, (Object)workVo.getId())).eq(TrainingWorkUsers::getUserType, (Object)1)).orderByAsc(TrainingWorkUsers::getId);
            List userList = this.trainingWorkUsersMapper.selectList((Wrapper)wrapper2);
            ArrayList<TrainingWorkUsersVo> userVoList = new ArrayList<TrainingWorkUsersVo>();
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                List<Integer> userIdList = userList.stream().map(TrainingWorkUsers::getUserId).collect(Collectors.toList());
                Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(userIdList);
                for (TrainingWorkUsers vo : userList) {
                    TrainingWorkUsersVo usersVo = new TrainingWorkUsersVo();
                    BeanUtils.copyProperties((Object)vo, (Object)usersVo);
                    UsersPojo pojo = pojoMap.get(vo.getUserId());
                    if (!ObjectUtils.isEmpty((Object)pojo)) {
                        usersVo.setShowName(pojo.getShowName());
                    }
                    userVoList.add(usersVo);
                }
            }
            workVo.setWorkUsersVoList(userVoList);
        }
        return workVo;
    }

    @Override
    public Integer insertWork(TrainingWorkVo workVo, Users user) {
        ArrayList<TrainingWorkDocument> lists;
        TrainingWork work = new TrainingWork();
        BeanUtils.copyProperties((Object)workVo, (Object)work);
        Integer status = 1;
        if (!StringUtils.isEmpty((Object)work.getStartTime())) {
            if (work.getStartTime().before(new Date())) {
                status = 2;
            }
        } else {
            status = 2;
        }
        if (!StringUtils.isEmpty((Object)work.getEndTime()) && work.getEndTime().before(new Date())) {
            status = 3;
        }
        work.setStatus(status);
        work.setEnterpriseId(user.getGroupId());
        work.setCreater(user.getId());
        work.setCreateTime(new Date());
        work.setUpdater(user.getId());
        work.setUpdateTime(new Date());
        this.trainingWorkMapper.insert(work);
        if (!CollectionUtils.isEmpty((Collection)workVo.getWorkDocumentList())) {
            lists = new ArrayList<TrainingWorkDocument>();
            for (TrainingWorkDocument document : workVo.getWorkDocumentList()) {
                document.setId(null);
                document.setWorkId(work.getId());
                document.setCreater(user.getId());
                document.setCreateTime(new Date());
                lists.add(document);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkDocumentMapper.insertList(lists);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)workVo.getWorkUsersVoList())) {
            lists = new ArrayList();
            for (TrainingWorkUsersVo users : workVo.getWorkUsersVoList()) {
                users.setWorkId(work.getId());
                users.setCreater(user.getId());
                users.setCreateTime(new Date());
                lists.add((TrainingWorkDocument)users);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkUsersMapper.insertList(lists);
            }
        }
        return work.getId();
    }

    @Override
    public void updateWork(TrainingWorkVo workVo, Users user) {
        ArrayList<TrainingWorkDocument> lists;
        TrainingWork work = new TrainingWork();
        BeanUtils.copyProperties((Object)workVo, (Object)work);
        Integer status = 1;
        if (!StringUtils.isEmpty((Object)work.getStartTime())) {
            if (work.getStartTime().before(new Date())) {
                status = 2;
            }
        } else {
            status = 2;
        }
        if (!StringUtils.isEmpty((Object)work.getEndTime()) && work.getEndTime().before(new Date())) {
            status = 3;
        }
        if (work.getPassType() != 3) {
            work.setFullScore(null);
            work.setPassScore(null);
        }
        work.setStatus(status);
        work.setUpdater(user.getId());
        work.setUpdateTime(new Date());
        this.trainingWorkMapper.updateById(work);
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper1.eq(TrainingWorkDocument::getWorkId, (Object)work.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)1);
        this.trainingWorkDocumentMapper.delete((Wrapper)wrapper1);
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper2.eq(TrainingWorkUsers::getWorkId, (Object)work.getId())).eq(TrainingWorkUsers::getUserType, (Object)1);
        this.trainingWorkUsersMapper.delete((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)workVo.getWorkDocumentList())) {
            lists = new ArrayList<TrainingWorkDocument>();
            for (TrainingWorkDocument document : workVo.getWorkDocumentList()) {
                document.setWorkId(work.getId());
                document.setCreater(user.getId());
                document.setCreateTime(new Date());
                lists.add(document);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkDocumentMapper.insertList(lists);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)workVo.getWorkUsersVoList())) {
            lists = new ArrayList();
            for (TrainingWorkUsersVo users : workVo.getWorkUsersVoList()) {
                users.setWorkId(work.getId());
                users.setCreater(user.getId());
                users.setCreateTime(new Date());
                lists.add((TrainingWorkDocument)users);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkUsersMapper.insertList(lists);
            }
        }
        if (work.getSourceType() == 3) {
            this.updateTaskScheduleByWork(work);
        }
    }

    public void updateTaskScheduleByWork(TrainingWork work) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingTaskSchedule::getWorkId, (Object)work.getId());
        List scheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)scheduleList)) {
            List<Integer> scheduleIds = scheduleList.stream().map(TrainingTaskSchedule::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.trainingTaskScheduleMapper.updateScoreAndTimeById(scheduleIds);
            for (TrainingTaskSchedule schedule : scheduleList) {
                schedule.setStartTime(null);
                schedule.setEndTime(null);
                schedule.setFullScore(null);
                schedule.setQualifiedScore(null);
                schedule.setPassLine(null);
                schedule.setTaskName(work.getWorkName());
                schedule.setStartTime(work.getStartTime());
                schedule.setEndTime(work.getEndTime());
                if (work.getPassType() == 3) {
                    schedule.setFullScore(work.getFullScore());
                    schedule.setQualifiedScore(work.getPassScore());
                    if (!StringUtils.isEmpty((Object)work.getFullScore()) && !StringUtils.isEmpty((Object)work.getPassScore())) {
                        schedule.setPassLine(work.getPassScore().divide(work.getFullScore(), 2, 4).multiply(new BigDecimal(100)));
                    }
                }
                this.trainingTaskScheduleMapper.updateById(schedule);
                if (!StringUtils.isEmpty((Object)schedule.getShiftId())) continue;
                TrainingProjectTask trainingProjectTask = new TrainingProjectTask();
                trainingProjectTask.setId(schedule.getTaskId());
                trainingProjectTask.setTaskName(schedule.getTaskName());
                this.trainingProjectTaskMapper.updateById(trainingProjectTask);
            }
        }
    }

    @Override
    public TrainingWork insertSameWork(Integer id, Integer type) {
        Date now = new Date();
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(id);
        Integer status = 1;
        if (!StringUtils.isEmpty((Object)work.getStartTime())) {
            if (work.getStartTime().before(new Date())) {
                status = 2;
            }
        } else {
            status = 2;
        }
        if (!StringUtils.isEmpty((Object)work.getEndTime()) && work.getEndTime().before(new Date())) {
            status = 3;
        }
        work.setId(null);
        work.setStatus(status);
        work.setCreateTime(now);
        work.setUpdateTime(now);
        work.setSourceType(type);
        work.setSourceWorkId(id);
        this.trainingWorkMapper.insert(work);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingWorkDocument::getWorkId, (Object)id);
        List documentList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)documentList)) {
            ArrayList<TrainingWorkDocument> lists = new ArrayList<TrainingWorkDocument>();
            for (TrainingWorkDocument document : documentList) {
                document.setId(null);
                document.setWorkId(work.getId());
                document.setCreateTime(now);
                lists.add(document);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkDocumentMapper.insertList(lists);
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingWorkUsers::getWorkId, (Object)id);
        List usersList = this.trainingWorkUsersMapper.selectList((Wrapper)wrapper2);
        if (!CollectionUtils.isEmpty((Collection)usersList)) {
            ArrayList<TrainingWorkUsers> lists = new ArrayList<TrainingWorkUsers>();
            for (TrainingWorkUsers users : usersList) {
                users.setId(null);
                users.setWorkId(work.getId());
                users.setCreateTime(now);
                lists.add(users);
            }
            if (!CollectionUtils.isEmpty(lists)) {
                this.trainingWorkUsersMapper.insertList(lists);
            }
        }
        return work;
    }

    @Override
    public TrainingWorkVo selectTrainingWorkUserAnswerVo(TrainingWorkVo workVo, Users user) {
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(workVo.getId());
        if (!StringUtils.isEmpty((Object)work)) {
            Integer status = 1;
            if (!StringUtils.isEmpty((Object)work.getStartTime())) {
                if (work.getStartTime().before(new Date())) {
                    status = 2;
                }
            } else {
                status = 2;
            }
            if (!StringUtils.isEmpty((Object)work.getEndTime()) && work.getEndTime().before(new Date())) {
                status = 3;
            }
            work.setStatus(status);
            BeanUtils.copyProperties((Object)work, (Object)workVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkDocument::getWorkId, (Object)workVo.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)1)).orderByAsc(TrainingWorkDocument::getId);
            List documentList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper1);
            workVo.setWorkDocumentList(documentList);
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingWorkReviewer::getWorkId, (Object)workVo.getId())).orderByAsc(TrainingWorkReviewer::getId);
            List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
                List<Integer> userIdList = reviewerList.stream().map(TrainingWorkReviewer::getUserId).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(userIdList);
                ArrayList<TrainingWorkReviewerVo> workReviewerVos = new ArrayList<TrainingWorkReviewerVo>();
                for (TrainingWorkReviewer reviewer : reviewerList) {
                    TrainingWorkReviewerVo reviewerVo = new TrainingWorkReviewerVo();
                    BeanUtils.copyProperties((Object)reviewer, (Object)reviewerVo);
                    UsersPojo pojo = usersMap.get(reviewer.getUserId());
                    reviewerVo.setShowName(pojo == null ? "" : pojo.getShowName());
                    workReviewerVos.add(reviewerVo);
                }
                workVo.setWorkReviewerVoList(workReviewerVos);
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingWorkUserAnswer::getWorkId, (Object)workVo.getId())).eq(TrainingWorkUserAnswer::getUserId, (Object)user.getId())).eq(!StringUtils.isEmpty((Object)workVo.getSourceType()), TrainingWorkUserAnswer::getSourceType, (Object)workVo.getSourceType())).eq(!StringUtils.isEmpty((Object)workVo.getSourceProjectId()), TrainingWorkUserAnswer::getSourceProjectId, (Object)workVo.getSourceProjectId())).eq(!StringUtils.isEmpty((Object)workVo.getSourceTaskId()), TrainingWorkUserAnswer::getSourceTaskId, (Object)workVo.getSourceTaskId())).eq(!StringUtils.isEmpty((Object)workVo.getSourceShiftId()), TrainingWorkUserAnswer::getSourceShiftId, (Object)workVo.getSourceShiftId())).eq(!StringUtils.isEmpty((Object)workVo.getTurns()), TrainingWorkUserAnswer::getTurns, (Object)workVo.getTurns())).orderByAsc(TrainingWorkUserAnswer::getId);
            List userAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)userAnswerList)) {
                List userAnswerIdList = userAnswerList.stream().map(TrainingWorkUserAnswer::getId).collect(Collectors.toList());
                List<Integer> remarkerIds = userAnswerList.stream().map(TrainingWorkUserAnswer::getRemarker).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> remarkerMap = this.userUtilService.selectUserMap(remarkerIds);
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingWorkDocument::getAnswerId, userAnswerIdList)).eq(TrainingWorkDocument::getDocumentType, (Object)2)).orderByAsc(TrainingWorkDocument::getId);
                List documentAnswerList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper4);
                Map<Object, Object> trainingWorkDocumentMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)documentAnswerList)) {
                    trainingWorkDocumentMap = documentAnswerList.stream().collect(Collectors.groupingBy(TrainingWorkDocument::getAnswerId));
                }
                ArrayList<TrainingWorkUserAnswerVo> userAnswerVoList = new ArrayList<TrainingWorkUserAnswerVo>();
                TrainingWorkUserAnswerVo userAnswerVo = null;
                for (TrainingWorkUserAnswer userAnswer : userAnswerList) {
                    UsersPojo pojo;
                    userAnswerVo = new TrainingWorkUserAnswerVo();
                    BeanUtils.copyProperties((Object)userAnswer, (Object)userAnswerVo);
                    if (!StringUtils.isEmpty((Object)userAnswer.getRemarker()) && !ObjectUtils.isEmpty((Object)(pojo = remarkerMap.get(userAnswer.getRemarker())))) {
                        userAnswerVo.setRemarkerName(pojo.getShowName());
                    }
                    userAnswerVo.setWorkDocumentList((List)trainingWorkDocumentMap.get(userAnswer.getId()));
                    userAnswerVoList.add(userAnswerVo);
                }
                workVo.setWorkUserAnswerVoList(userAnswerVoList);
            }
        }
        return workVo;
    }

    @Override
    public TrainingWorkVo selectUserWorkAnswerVo(TrainingWorkUserAnswerVo workUserAnswerVo) {
        TrainingWorkVo workVo = new TrainingWorkVo();
        TrainingWork work = (TrainingWork)this.trainingWorkMapper.selectById(workUserAnswerVo.getWorkId());
        if (!StringUtils.isEmpty((Object)work)) {
            List leaderIds;
            List materialIds;
            Integer status = 1;
            if (!StringUtils.isEmpty((Object)work.getStartTime())) {
                if (work.getStartTime().before(new Date())) {
                    status = 2;
                }
            } else {
                status = 2;
            }
            if (!StringUtils.isEmpty((Object)work.getEndTime()) && work.getEndTime().before(new Date())) {
                status = 3;
            }
            work.setStatus(status);
            BeanUtils.copyProperties((Object)work, (Object)workVo);
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingWorkDocument::getWorkId, (Object)workVo.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)1)).orderByAsc(TrainingWorkDocument::getId);
            List documentList = this.trainingWorkDocumentMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtils.isEmpty((Collection)documentList) && !CollectionUtils.isEmpty(materialIds = documentList.stream().map(TrainingWorkDocument::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIds);
                Map materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                for (TrainingWorkDocument trainingWorkDocument : documentList) {
                    TrainingMaterial trainingMaterial;
                    if (trainingWorkDocument.getMaterialId() == null || ObjectUtils.isEmpty((Object)(trainingMaterial = (TrainingMaterial)materialMap.get(trainingWorkDocument.getMaterialId())))) continue;
                    trainingWorkDocument.setFileType(trainingMaterial.getFileType());
                }
            }
            workVo.setWorkDocumentList(documentList);
            List<Object> reviewIds = new ArrayList();
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.eq(TrainingWorkReviewer::getWorkId, (Object)workVo.getId())).orderByAsc(TrainingWorkReviewer::getId);
            List reviewerList = this.trainingWorkReviewerMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtils.isEmpty((Collection)reviewerList)) {
                List userIdList = reviewerList.stream().map(TrainingWorkReviewer::getUserId).distinct().collect(Collectors.toList());
                reviewIds.addAll(userIdList);
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingWorkUserAnswer::getWorkId, (Object)workUserAnswerVo.getWorkId())).eq(TrainingWorkUserAnswer::getUserId, (Object)workUserAnswerVo.getUserId())).eq(!StringUtils.isEmpty((Object)workUserAnswerVo.getSourceType()), TrainingWorkUserAnswer::getSourceType, (Object)workUserAnswerVo.getSourceType())).eq(!StringUtils.isEmpty((Object)workUserAnswerVo.getSourceProjectId()), TrainingWorkUserAnswer::getSourceProjectId, (Object)workUserAnswerVo.getSourceProjectId())).eq(!StringUtils.isEmpty((Object)workUserAnswerVo.getSourceTaskId()), TrainingWorkUserAnswer::getSourceTaskId, (Object)workUserAnswerVo.getSourceTaskId())).eq(!StringUtils.isEmpty((Object)workUserAnswerVo.getSourceShiftId()), TrainingWorkUserAnswer::getSourceShiftId, (Object)workUserAnswerVo.getSourceShiftId())).eq(!StringUtils.isEmpty((Object)workUserAnswerVo.getTurns()), TrainingWorkUserAnswer::getTurns, (Object)workUserAnswerVo.getTurns())).orderByDesc(TrainingWorkUserAnswer::getId);
            List userAnswerList = this.trainingWorkUserAnswerMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtils.isEmpty((Collection)userAnswerList) && !CollectionUtils.isEmpty(leaderIds = userAnswerList.stream().map(TrainingWorkUserAnswer::getLeaderId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                reviewIds.addAll(leaderIds);
            }
            ArrayList<TrainingWorkReviewerVo> workReviewerVos = new ArrayList<TrainingWorkReviewerVo>();
            if (!CollectionUtils.isEmpty(reviewIds)) {
                reviewIds = reviewIds.stream().distinct().collect(Collectors.toList());
                Map<Integer, UsersPojo> usersMap = this.userUtilService.selectUserMap(reviewIds);
                for (Integer n : reviewIds) {
                    TrainingWorkReviewerVo reviewerVo = new TrainingWorkReviewerVo();
                    UsersPojo pojo = usersMap.get(n);
                    reviewerVo.setUserId(n);
                    reviewerVo.setShowName(pojo == null ? "" : pojo.getShowName());
                    workReviewerVos.add(reviewerVo);
                }
            }
            workVo.setWorkReviewerVoList(workReviewerVos);
        }
        return workVo;
    }

    @Override
    public void saveUserAnswer(TrainingWorkUserAnswerVo userAnswerVo, Users user) {
        LambdaUpdateWrapper wrapper1;
        Date now = new Date();
        if (!StringUtils.isEmpty((Object)userAnswerVo.getStatus()) && userAnswerVo.getStatus() == 1) {
            userAnswerVo.setCommitTime(now);
        }
        userAnswerVo.setUserId(user.getId());
        if (StringUtils.isEmpty((Object)userAnswerVo.getId())) {
            wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(TrainingWorkUserAnswer::getUserId, (Object)user.getId())).eq(TrainingWorkUserAnswer::getWorkId, (Object)userAnswerVo.getWorkId());
            TrainingWorkUserAnswer trainingWorkUserAnswerUpdate = new TrainingWorkUserAnswer();
            trainingWorkUserAnswerUpdate.setIsLast(Integer.valueOf(0));
            this.trainingWorkUserAnswerMapper.update(trainingWorkUserAnswerUpdate, (Wrapper)wrapper1);
            if (!StringUtils.isEmpty((Object)userAnswerVo.getSourceType())) {
                TrainingCourse trainingCourse;
                if (userAnswerVo.getSourceType() == 3 && !StringUtils.isEmpty((Object)userAnswerVo.getSourceShiftId())) {
                    TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(userAnswerVo.getSourceShiftId());
                    if (!ObjectUtils.isEmpty((Object)trainingLearnShift)) {
                        userAnswerVo.setProjectShiftName(trainingLearnShift.getShiftName() + "-" + trainingLearnShift.getGroupName() + (!StringUtils.isEmpty((Object)trainingLearnShift.getSupplemenName()) ? "-" + trainingLearnShift.getSupplemenName() : ""));
                    }
                } else if (userAnswerVo.getSourceType() == 5 && !StringUtils.isEmpty((Object)userAnswerVo.getSourceProjectId()) && !ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(userAnswerVo.getSourceProjectId())))) {
                    userAnswerVo.setProjectShiftName(trainingCourse.getCourseName());
                }
            }
            userAnswerVo.setCreater(user.getId());
            userAnswerVo.setCreateTime(now);
            userAnswerVo.setEnterpriseId(user.getGroupId());
            this.trainingWorkUserAnswerMapper.insert(userAnswerVo);
        } else {
            this.trainingWorkUserAnswerMapper.updateById(userAnswerVo);
            userAnswerVo.setEnterpriseId(user.getGroupId());
            wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper1.eq(TrainingWorkDocument::getAnswerId, (Object)userAnswerVo.getId())).eq(TrainingWorkDocument::getDocumentType, (Object)2);
            this.trainingWorkDocumentMapper.delete((Wrapper)wrapper1);
        }
        if (!CollectionUtils.isEmpty((Collection)userAnswerVo.getWorkDocumentList())) {
            ArrayList<TrainingWorkDocument> documentList = new ArrayList<TrainingWorkDocument>();
            for (TrainingWorkDocument document : userAnswerVo.getWorkDocumentList()) {
                document.setAnswerId(userAnswerVo.getId());
                document.setCreateTime(now);
                document.setCreater(user.getId());
                documentList.add(document);
            }
            this.trainingWorkDocumentMapper.insertList(documentList);
        }
        if (!StringUtils.isEmpty((Object)userAnswerVo.getStatus()) && userAnswerVo.getStatus() == 1) {
            TrainingWork trainingWork = (TrainingWork)this.trainingWorkMapper.selectById(userAnswerVo.getWorkId());
            if (trainingWork.getPassType() == 1) {
                userAnswerVo.setStatus(Integer.valueOf(3));
                this.trainingWorkUserAnswerMapper.updateById(userAnswerVo);
                this.updateTaskScheduleStatusByWork(userAnswerVo);
            } else {
                List<Object> userIdList = new ArrayList();
                Boolean isLeader = false;
                if (trainingWork.getReviewType() == 2) {
                    Map<Integer, Integer> leaderMap = this.userUtilService.selectParentIdMap(Arrays.asList(user.getId()), user.getGroupId());
                    if (!StringUtils.isEmpty(leaderMap) && !CollectionUtils.isEmpty(userIdList = leaderMap.values().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                        isLeader = true;
                        userAnswerVo.setLeaderId((Integer)userIdList.get(0));
                        this.trainingWorkUserAnswerMapper.updateById(userAnswerVo);
                    }
                } else if (trainingWork.getReviewType() == 3) {
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper2.eq(TrainingWorkUsers::getWorkId, (Object)trainingWork.getId())).eq(TrainingWorkUsers::getUserType, (Object)1);
                    List workUsersList = this.trainingWorkUsersMapper.selectList((Wrapper)wrapper2);
                    if (!CollectionUtils.isEmpty((Collection)workUsersList)) {
                        userIdList = workUsersList.stream().map(TrainingWorkUsers::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    }
                } else if (trainingWork.getReviewType() == 4) {
                    ArrayList<String> orgIds = new ArrayList<String>();
                    UsersAndOrgsMo mo = new UsersAndOrgsMo();
                    mo.setGroupId(user.getGroupId());
                    mo.setUserId(user.getId());
                    mo.setRetainAll(Boolean.valueOf(false));
                    mo.setShowAllPath(Boolean.valueOf(true));
                    BaseResult orgResult = this.userOrganizeApi.getUserOrganizeByUserIdAndOrg(mo);
                    if (!orgResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Map)((Map)orgResult.getData()))) {
                        List list;
                        Map map = (Map)orgResult.getData();
                        if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("O_")))) {
                            list = (List)map.get("O_");
                            for (Object id : list) {
                                orgIds.add("O_" + id);
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)((Collection)map.get("S_")))) {
                            list = (List)map.get("S_");
                            for (Object id : list) {
                                orgIds.add("S_" + id);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        LambdaQueryWrapper wrapper12 = new LambdaQueryWrapper();
                        wrapper12.eq(TrainingCourseConfig::getEnterpriseId, (Object)user.getGroupId());
                        List trainingCourseConfigList = this.trainingCourseConfigMapper.selectList((Wrapper)wrapper12);
                        if (!CollectionUtils.isEmpty((Collection)trainingCourseConfigList)) {
                            ArrayList<String> courseDirector = new ArrayList<String>();
                            block3: for (TrainingCourseConfig trainingCourseConfig : trainingCourseConfigList) {
                                List<String> areaIdList;
                                if (StringUtils.isEmpty((Object)trainingCourseConfig.getCourseAreaId()) || CollectionUtils.isEmpty(areaIdList = Arrays.asList(trainingCourseConfig.getCourseAreaId().split(",")))) continue;
                                for (String areaId : areaIdList) {
                                    if (!orgIds.contains(areaId)) continue;
                                    courseDirector.add(trainingCourseConfig.getCourseDirectorId());
                                    continue block3;
                                }
                            }
                            ArrayList<String> userIds = new ArrayList<String>();
                            for (String s : courseDirector) {
                                userIds.addAll(Arrays.asList(s.split(",")));
                            }
                            userIdList = userIds.stream().map(Integer::parseInt).distinct().collect(Collectors.toList());
                        }
                    }
                }
                if ((trainingWork.getReviewType() == 1 || trainingWork.getReviewType() == 2 && !isLeader.booleanValue()) && userAnswerVo.getSourceType() != null) {
                    LambdaQueryWrapper wrapper3;
                    if (userAnswerVo.getSourceType() == 3) {
                        wrapper3 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper3.eq(TrainingLearnManager::getShiftId, (Object)userAnswerVo.getSourceShiftId())).eq(TrainingLearnManager::getManagerType, (Object)3);
                        List learnManagerList = this.trainingLearnManagerMapper.selectList((Wrapper)wrapper3);
                        if (!CollectionUtils.isEmpty((Collection)learnManagerList)) {
                            userIdList = learnManagerList.stream().map(TrainingLearnManager::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        }
                    } else if (userAnswerVo.getSourceType() == 5) {
                        wrapper3 = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)wrapper3.eq(TrainingCourseUser::getCourseId, (Object)userAnswerVo.getSourceProjectId())).eq(TrainingCourseUser::getCourseType, (Object)2);
                        List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper3);
                        if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
                            userIdList = courseUserList.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    ArrayList<TrainingWorkReviewer> reviewers = new ArrayList<TrainingWorkReviewer>();
                    for (Integer view : userIdList) {
                        TrainingWorkReviewer reviewer = new TrainingWorkReviewer();
                        reviewer.setUserId(view);
                        reviewer.setWorkId(userAnswerVo.getWorkId());
                        reviewer.setUserAnswerId(userAnswerVo.getId());
                        reviewer.setEnterpriseId(trainingWork.getEnterpriseId());
                        reviewers.add(reviewer);
                    }
                    this.trainingWorkReviewerMapper.insertList(reviewers);
                }
                this.updateTaskScheduleStatusByWork(userAnswerVo);
            }
        } else {
            this.updateTaskScheduleStatusByWork(userAnswerVo);
        }
    }

    @Override
    public void updateTaskScheduleStatusByWork(TrainingWorkUserAnswerVo userAnswerVo) {
        if (!ObjectUtils.isEmpty((Object)userAnswerVo) && userAnswerVo.getSourceType() != null) {
            if (userAnswerVo.getSourceType() == 3) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingLearnTaskUser::getUserId, (Object)userAnswerVo.getUserId())).eq(TrainingLearnTaskUser::getShiftId, (Object)userAnswerVo.getSourceShiftId())).eq(!StringUtils.isEmpty((Object)userAnswerVo.getSourceTaskId()), TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)userAnswerVo.getSourceTaskId());
                List learnList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper);
                if (!CollectionUtils.isEmpty((Collection)learnList)) {
                    for (TrainingLearnTaskUser learnTaskUser : learnList) {
                        if (StringUtils.isEmpty((Object)learnTaskUser.getStartTime())) {
                            learnTaskUser.setStartTime(new Date());
                        }
                        if (userAnswerVo.getStatus() == 3) {
                            learnTaskUser.setTaskStatus(Integer.valueOf(4));
                            learnTaskUser.setEndTime(new Date());
                            if (!StringUtils.isEmpty((Object)userAnswerVo.getScore())) {
                                learnTaskUser.setScore(userAnswerVo.getScore());
                            }
                        } else if (userAnswerVo.getStatus() == 2) {
                            learnTaskUser.setTaskStatus(Integer.valueOf(3));
                            learnTaskUser.setEndTime(new Date());
                            if (!StringUtils.isEmpty((Object)userAnswerVo.getScore())) {
                                learnTaskUser.setScore(userAnswerVo.getScore());
                            }
                        } else if (userAnswerVo.getStatus() == 1) {
                            learnTaskUser.setTaskStatus(Integer.valueOf(2));
                        } else if (userAnswerVo.getStatus() == 0) {
                            learnTaskUser.setTaskStatus(Integer.valueOf(1));
                        }
                        this.trainingLearnTaskUserMapper.updateById(learnTaskUser);
                    }
                }
                LambdaQueryWrapper learnUserWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)learnUserWrapper.eq(TrainingLearnUser::getUserId, (Object)userAnswerVo.getUserId())).eq(TrainingLearnUser::getShiftId, (Object)userAnswerVo.getSourceShiftId())).eq(TrainingLearnUser::getIsDelete, (Object)0)).orderByDesc(TrainingLearnUser::getId);
                List learnUserList = this.trainingLearnUserMapper.selectList((Wrapper)learnUserWrapper);
                if (!CollectionUtils.isEmpty((Collection)learnUserList)) {
                    TrainingLearnUser learnUser = (TrainingLearnUser)learnUserList.get(0);
                    learnUser.setLearnStatus(Integer.valueOf(2));
                    if (learnUser.getStartTime() == null) {
                        learnUser.setStartTime(new Date());
                    }
                    this.trainingLearnUserMapper.updateById(learnUser);
                }
                if (userAnswerVo.getStatus() == 3) {
                    this.appTrainingLearnProjectService.updateLearUserStatus(userAnswerVo.getSourceShiftId(), userAnswerVo.getUserId());
                }
            } else if (userAnswerVo.getSourceType() == 5) {
                if (userAnswerVo.getStatus() == 0) {
                    this.trainingCourseService.saveCourseTaskStart(userAnswerVo.getId(), 6, userAnswerVo.getUserId(), userAnswerVo.getSourceTaskId(), userAnswerVo.getTurns());
                } else {
                    this.trainingCourseService.saveCourseTaskEnd(userAnswerVo.getId(), 6, userAnswerVo.getUserId(), userAnswerVo.getSourceTaskId(), userAnswerVo.getTurns());
                }
            }
        }
    }

    @Override
    public void updateTrainingWorkUserAnswerStatus(TrainingWorkUserAnswerVo userAnswerVo, Users user) {
        userAnswerVo.setStatus(Integer.valueOf(0));
        this.trainingWorkUserAnswerMapper.updateById(userAnswerVo);
    }

    @Override
    public Integer selectWorkIsOverTime(TrainingWorkUserAnswerVo trainingWorkUserAnswerVo, Users user) {
        TrainingWork trainingWork;
        Integer isOverTime = 0;
        if (!ObjectUtils.isEmpty((Object)trainingWorkUserAnswerVo) && trainingWorkUserAnswerVo.getWorkId() != null && !ObjectUtils.isEmpty((Object)(trainingWork = (TrainingWork)this.trainingWorkMapper.selectById(trainingWorkUserAnswerVo.getWorkId()))) && trainingWork.getStatus() == 2) {
            if (trainingWorkUserAnswerVo.getSourceType() != null && trainingWorkUserAnswerVo.getSourceProjectId() != null) {
                TrainingCourse trainingCourse;
                if (trainingWorkUserAnswerVo.getSourceType() == 3 && trainingWorkUserAnswerVo.getSourceShiftId() != null) {
                    TrainingLearnProject trainingLearnProject;
                    TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(trainingWorkUserAnswerVo.getSourceShiftId());
                    if (!ObjectUtils.isEmpty((Object)trainingLearnShift) && trainingLearnShift.getStatus() != 4 && (trainingLearnShift.getEndTime() != null && trainingLearnShift.getEndTime().after(new Date()) || trainingLearnShift.getEndTime() == null) && !ObjectUtils.isEmpty((Object)(trainingLearnProject = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingWorkUserAnswerVo.getSourceProjectId()))) && trainingLearnProject.getStatus() == 1) {
                        isOverTime = 1;
                    }
                } else if (trainingWorkUserAnswerVo.getSourceType() == 5 && !ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(trainingWorkUserAnswerVo.getSourceProjectId()))) && (trainingCourse.getStatus() == 2 || trainingCourse.getStatus() == 3 && trainingCourse.getIsOverdue() == 1)) {
                    isOverTime = 1;
                }
            } else {
                isOverTime = 1;
            }
        }
        return isOverTime;
    }

    @Override
    public WorkStatusVo selectWorkStatus(TrainingWorkUserAnswerVo trainingWorkUserAnswerVo, Users user) {
        Integer workStatus = this.selectWorkIsOverTime(trainingWorkUserAnswerVo, user);
        Integer workStatusV1 = this.selectWorkIsOverTimeV1(trainingWorkUserAnswerVo, user);
        return WorkStatusVo.builder().data(workStatus).status(workStatusV1).build();
    }

    private Integer selectWorkIsOverTimeV1(TrainingWorkUserAnswerVo trainingWorkUserAnswerVo, Users user) {
        Integer isOverTime = 0;
        if (!ObjectUtils.isEmpty((Object)trainingWorkUserAnswerVo) && trainingWorkUserAnswerVo.getWorkId() != null) {
            if (trainingWorkUserAnswerVo.getSourceType() != null && trainingWorkUserAnswerVo.getSourceProjectId() != null) {
                TrainingCourse trainingCourse;
                isOverTime = 3;
                if (trainingWorkUserAnswerVo.getSourceType() == 3 && trainingWorkUserAnswerVo.getSourceShiftId() != null) {
                    TrainingLearnProject trainingLearnProject;
                    TrainingLearnShift trainingLearnShift = (TrainingLearnShift)this.trainingLearnShiftMapper.selectById(trainingWorkUserAnswerVo.getSourceShiftId());
                    if (!ObjectUtils.isEmpty((Object)trainingLearnShift) && trainingLearnShift.getStatus() != 4 && (trainingLearnShift.getEndTime() != null && trainingLearnShift.getEndTime().after(new Date()) || trainingLearnShift.getEndTime() == null) && !ObjectUtils.isEmpty((Object)(trainingLearnProject = (TrainingLearnProject)this.trainingLearnProjectMapper.selectById(trainingWorkUserAnswerVo.getSourceProjectId()))) && trainingLearnProject.getStatus() == 1) {
                        isOverTime = 1;
                    }
                } else if (trainingWorkUserAnswerVo.getSourceType() == 5 && !ObjectUtils.isEmpty((Object)(trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(trainingWorkUserAnswerVo.getSourceProjectId()))) && (trainingCourse.getStatus() == 2 || trainingCourse.getStatus() == 3 && trainingCourse.getIsOverdue() == 1)) {
                    isOverTime = 1;
                }
            } else {
                isOverTime = 1;
            }
            if (isOverTime == 1) {
                TrainingWork trainingWork = (TrainingWork)this.trainingWorkMapper.selectById(trainingWorkUserAnswerVo.getWorkId());
                if (!ObjectUtils.isEmpty((Object)trainingWork) && trainingWork.getStatus() == 1) {
                    isOverTime = 4;
                } else if (!ObjectUtils.isEmpty((Object)trainingWork) && trainingWork.getStatus() == 3) {
                    isOverTime = 2;
                }
            }
        }
        return isOverTime;
    }
}

