/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStage;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaperChannelJobCertification
implements PaperChannel {
    private static final Logger log = LoggerFactory.getLogger(PaperChannelJobCertification.class);
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingJobStageMapper trainingJobStageMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private PaperUtil paperUtil;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private UserUtilService userUtilService;

    @Override
    public Map<Integer, List<Integer>> handlePaperUserScope(List<PaperVo> allPaperList, Users user) {
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        allPaperList.forEach(paperVo -> {
            Integer paperId = paperVo.getId();
            Integer jobId = paperVo.getProjectId();
            List<Integer> jobUserList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
            result.put(paperId, jobUserList);
        });
        return result;
    }

    @Override
    public Map<Integer, PaperVo> handlePaperSituation(List<PaperVo> allPaperList, Users user) {
        List paperIds = allPaperList.stream().map(PaperVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.JOB_CERTIFICATION.getUserPaperTableValue());
        wrapper.in(TrainingUserPaper::getTrainingPaperId, paperIds);
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        Map<Integer, PaperVo> res = PaperUtil.getPaperSituationMap(allPaperList, trainingUserPapers, null);
        return res;
    }

    @Override
    public void handleOldData(Integer enterpriseId) {
        LambdaQueryWrapper jobCertificationLambdaQueryWrapper = new LambdaQueryWrapper();
        jobCertificationLambdaQueryWrapper.eq(enterpriseId != null, TrainingJobCertification::getEnterpriseId, (Object)enterpriseId);
        jobCertificationLambdaQueryWrapper.select(new SFunction[]{TrainingJobCertification::getId});
        List jobIdList = this.trainingJobCertificationMapper.selectList((Wrapper)jobCertificationLambdaQueryWrapper);
        Set jobIdSet = jobIdList.stream().map(TrainingJobCertification::getId).collect(Collectors.toSet());
        LambdaQueryWrapper jobStageLambdaQueryWrapper = new LambdaQueryWrapper();
        jobStageLambdaQueryWrapper.eq(enterpriseId != null, TrainingJobStage::getEnterpriseId, (Object)enterpriseId);
        jobStageLambdaQueryWrapper.select(new SFunction[]{TrainingJobStage::getId});
        List stageIdList = this.trainingJobStageMapper.selectList((Wrapper)jobStageLambdaQueryWrapper);
        Set stageIdSet = stageIdList.stream().map(TrainingJobStage::getId).collect(Collectors.toSet());
        LambdaQueryWrapper trainingPaperLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingPaperLambdaQueryWrapper.eq(TrainingPaper::getProjectShow, (Object)PaperSourceEnum.JOB_CERTIFICATION.getPaperTableValue());
        trainingPaperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        trainingPaperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List trainingPapers = this.trainingPaperMapper.selectList((Wrapper)trainingPaperLambdaQueryWrapper);
        List<Integer> trainingPaperIdList = trainingPapers.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        LambdaQueryWrapper jobStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
        jobStageTaskLambdaQueryWrapper.eq(enterpriseId != null, TrainingJobStageTask::getEnterpriseId, (Object)enterpriseId);
        jobStageTaskLambdaQueryWrapper.in(TrainingJobStageTask::getPaperId, trainingPaperIdList);
        jobStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingJobStageTask::getId, TrainingJobStageTask::getStageId, TrainingJobStageTask::getJobId, TrainingJobStageTask::getPaperId});
        List jobStageTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)jobStageTaskLambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)jobStageTaskList)) {
            Map<Integer, TrainingJobStageTask> trainingJobStageTaskMap = jobStageTaskList.stream().collect(Collectors.toMap(TrainingJobStageTask::getPaperId, jobStageTask -> jobStageTask));
            trainingPaperIdList.forEach(trainingPaperId -> {
                TrainingPaper trainingPaper = new TrainingPaper();
                trainingPaper.setId(trainingPaperId);
                if (trainingJobStageTaskMap.containsKey(trainingPaperId)) {
                    TrainingJobStageTask trainingJobStageTask = (TrainingJobStageTask)trainingJobStageTaskMap.get(trainingPaperId);
                    Integer jobId = trainingJobStageTask.getJobId();
                    Integer stageId = trainingJobStageTask.getStageId();
                    trainingPaper.setProjectId(jobId);
                    Integer isDel = 0;
                    if (!jobIdSet.contains(jobId)) {
                        isDel = 1;
                    } else if (!stageIdSet.contains(stageId)) {
                        isDel = 1;
                    }
                    trainingPaper.setIsDel(isDel);
                } else {
                    trainingPaper.setIsDel(Integer.valueOf(1));
                }
                this.trainingPaperMapper.updateById(trainingPaper);
            });
        }
        LambdaQueryWrapper paperLambdaQueryWrapper = new LambdaQueryWrapper();
        paperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        paperLambdaQueryWrapper.eq(TrainingPaper::getProjectShow, null);
        paperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List trainingPaperList = this.trainingPaperMapper.selectList((Wrapper)paperLambdaQueryWrapper);
        List paperIdList = trainingPaperList.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paperIdList)) {
            LambdaQueryWrapper trainingJobStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingJobStageTaskLambdaQueryWrapper.eq(enterpriseId != null, TrainingJobStageTask::getEnterpriseId, (Object)enterpriseId);
            trainingJobStageTaskLambdaQueryWrapper.in(TrainingJobStageTask::getPaperId, paperIdList);
            trainingJobStageTaskLambdaQueryWrapper.eq(TrainingJobStageTask::getTaskType, (Object)2);
            trainingJobStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingJobStageTask::getId, TrainingJobStageTask::getStageId, TrainingJobStageTask::getJobId, TrainingJobStageTask::getPaperId});
            List trainingJobStageTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)trainingJobStageTaskLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingJobStageTaskList)) {
                trainingJobStageTaskList.forEach(trainingJobStageTask -> {
                    Integer jobId = trainingJobStageTask.getJobId();
                    Integer stageId = trainingJobStageTask.getStageId();
                    Integer stageTaskId = trainingJobStageTask.getId();
                    Integer paperId = trainingJobStageTask.getPaperId();
                    Integer isDel = 0;
                    if (!jobIdSet.contains(jobId)) {
                        isDel = 1;
                    } else if (!stageIdSet.contains(stageId)) {
                        isDel = 1;
                    }
                    Integer newPaperId = this.paperUtil.copyPaper(paperId, PaperSourceEnum.JOB_CERTIFICATION.getPaperTableValue(), jobId, stageTaskId, null, isDel);
                    LambdaQueryWrapper trainingUserPaperLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)jobId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)stageTaskId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.JOB_CERTIFICATION.getUserPaperTableValue());
                    trainingUserPaperLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId, TrainingUserPaper::getSourceProjectId, TrainingUserPaper::getSourceTaskId});
                    List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperLambdaQueryWrapper);
                    ArrayList allUserPaperIdList = new ArrayList();
                    if (trainingUserPaperList != null && trainingUserPaperList.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPaperList.forEach(trainingUserPaper -> {
                            trainingUserPaper.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaper);
                        });
                    }
                    if (allUserPaperIdList.size() > 0) {
                        LambdaQueryWrapper trainingUserQuestionLambdaQueryWrapper = new LambdaQueryWrapper();
                        trainingUserQuestionLambdaQueryWrapper.eq(TrainingUserQuestion::getPaperId, (Object)paperId);
                        trainingUserQuestionLambdaQueryWrapper.in(TrainingUserQuestion::getUserPaperId, allUserPaperIdList);
                        trainingUserQuestionLambdaQueryWrapper.select(new SFunction[]{TrainingUserQuestion::getId, TrainingUserQuestion::getPaperId});
                        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)trainingUserQuestionLambdaQueryWrapper);
                        trainingUserQuestionList.forEach(trainingUserQuestion -> {
                            trainingUserQuestion.setPaperId(newPaperId);
                            this.trainingUserQuestionMapper.updateById(trainingUserQuestion);
                        });
                    }
                    log.info("\u5c97\u4f4d\u8ba4\u8bc1job_id:{},\u4efb\u52a1task_id:{},\u539f\u7ed1\u5b9a\u8003\u8bd5paper_id:{},\u590d\u5236\u65b0\u8003\u8bd5new_paper_id:{},\u8be5\u4efb\u52a1\u4ea7\u751f\u7684\u8003\u8bd5\u8bb0\u5f55\uff1a{}", new Object[]{jobId, stageTaskId, paperId, newPaperId, allUserPaperIdList});
                });
            }
        }
    }

    @Override
    public void handleOldDataTwo(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataThree(Integer enterpriseId) {
    }

    @Override
    public ProjectInfoDto getSourceProjectInfo(Integer jobId) {
        TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(jobId);
        ProjectInfoDto paperInfoDto = new ProjectInfoDto();
        paperInfoDto.setProjectName(trainingJobCertification.getCertificationName());
        return paperInfoDto;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, Users user) {
        List<TrainingUserPaper> trainingUserPapers = this.getUserPaperList(paperVo, null, null);
        List<PaperManagementExamineeDetailVo> res = this.paperUtil.getExamineeDetails(request, paperVo, trainingUserPapers, null, user);
        return res;
    }

    @Override
    public List<Integer> getPaperUserScopeByPaper(PaperVo paper, Users user) {
        Integer jobId = paper.getProjectId();
        List<Integer> jobUserList = this.trainingJobCertificationService.selectJobUserListByJobId(jobId);
        return jobUserList;
    }

    @Override
    public List<TrainingUserPaper> getUserPaperList(PaperVo paper, Integer userId, Integer userType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.JOB_CERTIFICATION.getUserPaperTableValue());
        wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        wrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)paper.getProjectId());
        if (userId != null) {
            if (userType == 0) {
                wrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            } else {
                wrapper.eq(TrainingUserPaper::getLoginUserId, (Object)userId);
            }
        }
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        return trainingUserPapers;
    }

    @Override
    public void updatePaperVoByShiftId(PaperVo paperVo, Integer shiftId) {
    }
}

