/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.dto.TrainingPlanDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperTurnsMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStage;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperTurns;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PaperChannelTrainingPlan
implements PaperChannel {
    private static final Logger log = LoggerFactory.getLogger(PaperChannelTrainingPlan.class);
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingCourseStageMapper trainingCourseStageMapper;
    @Autowired
    private PaperUtil paperUtil;
    @Autowired
    private TrainingPaperTurnsMapper trainingPaperTurnsMapper;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Resource
    private UserUtilService userUtilService;

    @Override
    public Map<Integer, List<Integer>> handlePaperUserScope(List<PaperVo> allPaperList, Users user) {
        List<Integer> courseIds = allPaperList.stream().map(PaperVo::getProjectId).collect(Collectors.toList());
        List<TrainingPlanDto> paperOfTrainingPlanInfoList = this.trainingCourseMapper.getTrainingPlanInfoByCourseId(courseIds);
        Map<Integer, TrainingPlanDto> paperOfTrainingPlanInfoMap = paperOfTrainingPlanInfoList.stream().collect(Collectors.toMap(TrainingPlanDto::getCourseId, trainingPlanDto -> trainingPlanDto, (existing, replacement) -> existing));
        List courseIdList = paperOfTrainingPlanInfoList.stream().map(TrainingPlanDto::getCourseId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.in(TrainingCourseUser::getCourseId, courseIdList)).eq(TrainingCourseUser::getCourseType, (Object)1);
        List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper);
        Map<Object, Object> courseUserMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)courseUserList)) {
            courseUserMap = courseUserList.stream().collect(Collectors.groupingBy(TrainingCourseUser::getCourseId));
        }
        List<Integer> allUserId = this.userUtilService.getUserListByGroupId(user.getGroupId());
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        for (PaperVo paperVo : allPaperList) {
            Integer paperId = paperVo.getId();
            Integer courseId = paperVo.getProjectId();
            if (paperOfTrainingPlanInfoMap.containsKey(courseId)) {
                List<Integer> reUserIds;
                List<Integer> myUserIds;
                List courseUsers;
                TrainingPlanDto paperOfTrainingPlanInfo = paperOfTrainingPlanInfoMap.get(courseId);
                ArrayList<Integer> initialUserIdList = new ArrayList<Integer>();
                initialUserIdList.addAll(allUserId);
                if (paperOfTrainingPlanInfo.getAppointType() == 1 && !CollectionUtils.isEmpty((Collection)(courseUsers = (List)courseUserMap.get(paperOfTrainingPlanInfo.getCourseId()))) && !CollectionUtils.isEmpty(myUserIds = this.getPaperUserScopeByPaper(courseUsers, user))) {
                    initialUserIdList.retainAll(myUserIds);
                }
                if (paperOfTrainingPlanInfo.getStatus() == 3 && !CollectionUtils.isEmpty(initialUserIdList) && !CollectionUtils.isEmpty(reUserIds = this.userUtilService.selectOverGroupTime(paperOfTrainingPlanInfo.getEnterpriseId(), paperOfTrainingPlanInfo.getEndTime()))) {
                    initialUserIdList.removeAll(reUserIds);
                }
                result.put(paperId, initialUserIdList.stream().distinct().collect(Collectors.toList()));
                continue;
            }
            result.put(paperId, null);
        }
        return result;
    }

    private List<Integer> getPaperUserScopeByPaper(List<TrainingCourseUser> courseUsers, Users user) {
        List<Integer> orgUserIds;
        List<Integer> tagUserIds;
        List<Integer> roleUserIds;
        ArrayList<Integer> myUserIds = new ArrayList<Integer>();
        List<Integer> roleIdList = courseUsers.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> organizeIdList = courseUsers.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Integer> tagIdList = courseUsers.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List userIdList = courseUsers.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        myUserIds.addAll(userIdList);
        if (!CollectionUtils.isEmpty(roleIdList) && !CollectionUtils.isEmpty(roleUserIds = this.userUtilService.selectUsersByRoles(roleIdList, user.getGroupId()))) {
            myUserIds.addAll(roleUserIds);
        }
        if (!CollectionUtils.isEmpty(tagIdList) && !CollectionUtils.isEmpty(tagUserIds = this.userUtilService.selectUserIdsByTagIds(tagIdList, user.getGroupId(), null))) {
            myUserIds.addAll(tagUserIds);
        }
        if (!CollectionUtils.isEmpty(organizeIdList) && !CollectionUtils.isEmpty(orgUserIds = this.userUtilService.selectUserIdsByOrganizeIds(organizeIdList, user.getGroupId()))) {
            myUserIds.addAll(orgUserIds);
        }
        return myUserIds;
    }

    @Override
    public Map<Integer, PaperVo> handlePaperSituation(List<PaperVo> allPaperList, Users user) {
        List paperIds = allPaperList.stream().map(PaperVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.TRAINING_PLAN.getUserPaperTableValue());
        wrapper.in(TrainingUserPaper::getTrainingPaperId, paperIds);
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        Map<Integer, PaperVo> res = PaperUtil.getPaperSituationMap(allPaperList, trainingUserPapers, null);
        return res;
    }

    @Override
    public void handleOldData(Integer enterpriseId) {
        LambdaQueryWrapper courseLambdaQueryWrapper = new LambdaQueryWrapper();
        courseLambdaQueryWrapper.eq(enterpriseId != null, TrainingCourse::getEnterpriseId, (Object)enterpriseId);
        courseLambdaQueryWrapper.select(new SFunction[]{TrainingCourse::getId});
        Set courseIdSet = this.trainingCourseMapper.selectList((Wrapper)courseLambdaQueryWrapper).stream().map(TrainingCourse::getId).collect(Collectors.toSet());
        LambdaQueryWrapper courseStageLambdaQueryWrapper = new LambdaQueryWrapper();
        courseStageLambdaQueryWrapper.eq(enterpriseId != null, TrainingCourseStage::getEnterpriseId, (Object)enterpriseId);
        courseStageLambdaQueryWrapper.select(new SFunction[]{TrainingCourseStage::getId});
        Set stageIdSet = this.trainingCourseStageMapper.selectList((Wrapper)courseStageLambdaQueryWrapper).stream().map(TrainingCourseStage::getId).collect(Collectors.toSet());
        LambdaQueryWrapper trainingCourseStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingCourseStageTaskLambdaQueryWrapper.eq(enterpriseId != null, TrainingCourseStageTask::getEnterpriseId, (Object)enterpriseId);
        trainingCourseStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingCourseStageTask::getId});
        Set courseStageTaskIdSet = this.trainingCourseStageTaskMapper.selectList((Wrapper)trainingCourseStageTaskLambdaQueryWrapper).stream().map(TrainingCourseStageTask::getId).collect(Collectors.toSet());
        LambdaQueryWrapper trainingPaperLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingPaperLambdaQueryWrapper.eq(TrainingPaper::getProjectShow, (Object)PaperSourceEnum.TRAINING_PLAN.getPaperTableValue());
        trainingPaperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        trainingPaperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List trainingPapers = this.trainingPaperMapper.selectList((Wrapper)trainingPaperLambdaQueryWrapper);
        List<Integer> trainingPaperIdList = trainingPapers.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        LambdaQueryWrapper taskLambdaQueryWrapper = new LambdaQueryWrapper();
        taskLambdaQueryWrapper.in(TrainingCourseStageTask::getPaperId, trainingPaperIdList);
        taskLambdaQueryWrapper.eq(enterpriseId != null, TrainingCourseStageTask::getEnterpriseId, (Object)enterpriseId);
        taskLambdaQueryWrapper.select(new SFunction[]{TrainingCourseStageTask::getId, TrainingCourseStageTask::getStageId, TrainingCourseStageTask::getCourseId, TrainingCourseStageTask::getPaperId});
        List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)taskLambdaQueryWrapper);
        LambdaQueryWrapper trainingPaperTurnsLambdaQueryWrapper = new LambdaQueryWrapper();
        trainingPaperTurnsLambdaQueryWrapper.eq(TrainingPaperTurns::getTurnType, (Object)4);
        trainingPaperTurnsLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaperTurns::getEnterpriseId, (Object)enterpriseId);
        trainingPaperTurnsLambdaQueryWrapper.in(TrainingPaperTurns::getPaperId, trainingPaperIdList);
        trainingPaperTurnsLambdaQueryWrapper.select(new SFunction[]{TrainingPaperTurns::getTaskId, TrainingPaperTurns::getProjectId, TrainingPaperTurns::getPaperId});
        List trainingPaperTurnsList = this.trainingPaperTurnsMapper.selectList((Wrapper)trainingPaperTurnsLambdaQueryWrapper);
        Map<Object, Object> courseStageTaskMap = !CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList) ? trainingCourseStageTaskList.stream().collect(Collectors.toMap(TrainingCourseStageTask::getPaperId, courseStageTask -> courseStageTask)) : new HashMap();
        Map<Object, Object> paperTurnsMap = !CollectionUtils.isEmpty((Collection)trainingPaperTurnsList) ? trainingPaperTurnsList.stream().collect(Collectors.toMap(TrainingPaperTurns::getPaperId, paperTurns -> paperTurns)) : new HashMap();
        if (!CollectionUtils.isEmpty(trainingPaperIdList)) {
            trainingPaperIdList.forEach(trainingPaperId -> {
                TrainingPaper trainingPaper = new TrainingPaper();
                trainingPaper.setId(trainingPaperId);
                if (courseStageTaskMap.containsKey(trainingPaperId)) {
                    TrainingCourseStageTask courseStageTask = (TrainingCourseStageTask)courseStageTaskMap.get(trainingPaperId);
                    Integer courseId = courseStageTask.getCourseId();
                    Integer stageId = courseStageTask.getStageId();
                    trainingPaper.setProjectId(courseId);
                    Integer isDel = 0;
                    if (!courseIdSet.contains(courseId)) {
                        isDel = 1;
                    } else if (!stageIdSet.contains(stageId)) {
                        isDel = 1;
                    }
                    trainingPaper.setIsDel(isDel);
                } else if (paperTurnsMap.containsKey(trainingPaperId)) {
                    TrainingPaperTurns paperTurns = (TrainingPaperTurns)paperTurnsMap.get(trainingPaperId);
                    Integer courseId = paperTurns.getProjectId();
                    Integer stageTaskId = paperTurns.getTaskId();
                    trainingPaper.setProjectId(courseId);
                    Integer isDel = 0;
                    if (!courseIdSet.contains(courseId)) {
                        isDel = 1;
                    } else if (!courseStageTaskIdSet.contains(stageTaskId)) {
                        isDel = 1;
                    }
                    trainingPaper.setIsDel(isDel);
                } else {
                    trainingPaper.setIsDel(Integer.valueOf(1));
                }
                this.trainingPaperMapper.updateById(trainingPaper);
            });
        }
        LambdaQueryWrapper paperLambdaQueryWrapper = new LambdaQueryWrapper();
        paperLambdaQueryWrapper.eq(TrainingPaper::getProjectShow, null);
        paperLambdaQueryWrapper.eq(enterpriseId != null, TrainingPaper::getEnterpriseId, (Object)enterpriseId);
        paperLambdaQueryWrapper.select(new SFunction[]{TrainingPaper::getId});
        List trainingPaperList = this.trainingPaperMapper.selectList((Wrapper)paperLambdaQueryWrapper);
        List paperIdList = trainingPaperList.stream().map(TrainingPaper::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paperIdList)) {
            LambdaQueryWrapper courseStageTaskLambdaQueryWrapper = new LambdaQueryWrapper();
            courseStageTaskLambdaQueryWrapper.in(TrainingCourseStageTask::getPaperId, paperIdList);
            courseStageTaskLambdaQueryWrapper.eq(TrainingCourseStageTask::getTaskType, (Object)2);
            courseStageTaskLambdaQueryWrapper.eq(enterpriseId != null, TrainingCourseStageTask::getEnterpriseId, (Object)enterpriseId);
            courseStageTaskLambdaQueryWrapper.select(new SFunction[]{TrainingCourseStageTask::getId, TrainingCourseStageTask::getStageId, TrainingCourseStageTask::getCourseId, TrainingCourseStageTask::getPaperId});
            List courseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)courseStageTaskLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)courseStageTaskList)) {
                courseStageTaskList.forEach(courseStageTask -> {
                    Integer courseId = courseStageTask.getCourseId();
                    Integer stageId = courseStageTask.getStageId();
                    Integer stageTaskId = courseStageTask.getId();
                    Integer paperId = courseStageTask.getPaperId();
                    Integer isDel = 0;
                    if (!courseIdSet.contains(courseId)) {
                        isDel = 1;
                    } else if (!stageIdSet.contains(stageId)) {
                        isDel = 1;
                    }
                    Integer newPaperId = this.paperUtil.copyPaper(paperId, PaperSourceEnum.TRAINING_PLAN.getPaperTableValue(), courseId, stageTaskId, null, isDel);
                    LambdaQueryWrapper trainingUserPaperLambdaQueryWrapper = new LambdaQueryWrapper();
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paperId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)courseId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceTaskId, (Object)stageTaskId);
                    trainingUserPaperLambdaQueryWrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.TRAINING_PLAN.getUserPaperTableValue());
                    trainingUserPaperLambdaQueryWrapper.select(new SFunction[]{TrainingUserPaper::getId, TrainingUserPaper::getSourceProjectId, TrainingUserPaper::getSourceTaskId});
                    List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)trainingUserPaperLambdaQueryWrapper);
                    ArrayList allUserPaperIdList = new ArrayList();
                    if (trainingUserPaperList != null && trainingUserPaperList.size() > 0) {
                        allUserPaperIdList.addAll(trainingUserPaperList.stream().map(TrainingUserPaper::getId).collect(Collectors.toList()));
                        trainingUserPaperList.forEach(trainingUserPaper -> {
                            trainingUserPaper.setTrainingPaperId(newPaperId);
                            this.trainingUserPaperMapper.updateById(trainingUserPaper);
                        });
                    }
                    if (allUserPaperIdList.size() > 0) {
                        LambdaQueryWrapper trainingUserQuestionLambdaQueryWrapper = new LambdaQueryWrapper();
                        trainingUserQuestionLambdaQueryWrapper.eq(TrainingUserQuestion::getPaperId, (Object)paperId);
                        trainingUserQuestionLambdaQueryWrapper.in(TrainingUserQuestion::getUserPaperId, allUserPaperIdList);
                        trainingUserQuestionLambdaQueryWrapper.select(new SFunction[]{TrainingUserQuestion::getId, TrainingUserQuestion::getPaperId});
                        List trainingUserQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)trainingUserQuestionLambdaQueryWrapper);
                        trainingUserQuestionList.forEach(trainingUserQuestion -> {
                            trainingUserQuestion.setPaperId(newPaperId);
                            this.trainingUserQuestionMapper.updateById(trainingUserQuestion);
                        });
                    }
                    log.info("\u57f9\u8bad\u8ba1\u5212job_id:{},\u4efb\u52a1task_id:{},\u539f\u7ed1\u5b9a\u8003\u8bd5paper_id:{},\u590d\u5236\u65b0\u8003\u8bd5new_paper_id:{},\u8be5\u4efb\u52a1\u4ea7\u751f\u7684\u8003\u8bd5\u8bb0\u5f55\uff1a{}", new Object[]{courseId, stageTaskId, paperId, newPaperId, allUserPaperIdList});
                });
            }
        }
    }

    @Override
    public void handleOldDataTwo(Integer enterpriseId) {
    }

    @Override
    public void handleOldDataThree(Integer enterpriseId) {
    }

    @Override
    public ProjectInfoDto getSourceProjectInfo(Integer courseId) {
        TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(courseId);
        ProjectInfoDto paperInfoDto = new ProjectInfoDto();
        paperInfoDto.setProjectName(trainingCourse.getCourseName());
        return paperInfoDto;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, Users user) {
        List<TrainingUserPaper> trainingUserPapers = this.getUserPaperList(paperVo, null, null);
        List<PaperManagementExamineeDetailVo> res = this.paperUtil.getExamineeDetails(request, paperVo, trainingUserPapers, null, user);
        return res;
    }

    @Override
    public List<Integer> getPaperUserScopeByPaper(PaperVo paper, Users user) {
        List<Integer> reUserIds;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingCourse::getId, (Object)paper.getProjectId());
        wrapper.select(new SFunction[]{TrainingCourse::getId, TrainingCourse::getAppointType, TrainingCourse::getStatus, TrainingCourse::getEndTime, TrainingCourse::getEnterpriseId});
        TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectOne((Wrapper)wrapper);
        List<Integer> allUserId = this.userUtilService.getUserListByGroupId(user.getGroupId());
        ArrayList<Integer> initialUserIdList = new ArrayList<Integer>();
        initialUserIdList.addAll(allUserId);
        if (trainingCourse.getAppointType() == 1) {
            List<Integer> myUserIds;
            LambdaQueryWrapper courseUserLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)courseUserLambdaQueryWrapper.eq(TrainingCourseUser::getCourseId, (Object)trainingCourse.getId())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUserList = this.trainingCourseUserMapper.selectList((Wrapper)courseUserLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)courseUserList) && !CollectionUtils.isEmpty(myUserIds = this.getPaperUserScopeByPaper(courseUserList, user))) {
                initialUserIdList.retainAll(myUserIds);
            }
        }
        if (trainingCourse.getStatus() == 3 && !CollectionUtils.isEmpty(initialUserIdList) && !CollectionUtils.isEmpty(reUserIds = this.userUtilService.selectOverGroupTime(trainingCourse.getEnterpriseId(), trainingCourse.getEndTime()))) {
            initialUserIdList.removeAll(reUserIds);
        }
        return initialUserIdList;
    }

    @Override
    public List<TrainingUserPaper> getUserPaperList(PaperVo paper, Integer userId, Integer userType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingUserPaper::getSourceType, (Object)PaperSourceEnum.TRAINING_PLAN.getUserPaperTableValue());
        wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId());
        wrapper.eq(TrainingUserPaper::getSourceProjectId, (Object)paper.getProjectId());
        if (userId != null) {
            if (userType == 0) {
                wrapper.eq(TrainingUserPaper::getUserId, (Object)userId);
            } else {
                wrapper.eq(TrainingUserPaper::getLoginUserId, (Object)userId);
            }
        }
        List trainingUserPapers = this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
        return trainingUserPapers;
    }

    @Override
    public void updatePaperVoByShiftId(PaperVo paperVo, Integer shiftId) {
    }
}

