/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.paperChannel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.model.mo.UserDutiesMo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.training.dto.SortCondition;
import com.ovopark.training.enums.UserPaperStateEnum;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingLoginUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class PaperUtil {
    public static final int COUNT_EFFECTIVE = 0;
    public static final int COUNT_ALL = 1;
    @Autowired
    private TrainingPaperMapper trainingPaperMapper;
    @Autowired
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private TrainingPaperService trainingPaperService;

    public static Map<Integer, TrainingUserPaper> getEffectiveUserPaper(List<TrainingUserPaper> userPaperList, Integer scoreSelect, Integer userType) {
        Map<Integer, List<TrainingUserPaper>> trainingUserPaperMapGroup;
        if (userType == 0) {
            trainingUserPaperMapGroup = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
        } else {
            userPaperList = userPaperList.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() == null && trainingUserPaper.getLoginUserId() != null).collect(Collectors.toList());
            trainingUserPaperMapGroup = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getLoginUserId));
        }
        HashMap<Integer, TrainingUserPaper> res = new HashMap<Integer, TrainingUserPaper>();
        for (Map.Entry<Integer, List<TrainingUserPaper>> entry : trainingUserPaperMapGroup.entrySet()) {
            Integer userId = entry.getKey();
            List<TrainingUserPaper> trainingUserPaperList = entry.getValue();
            TrainingUserPaper effectiveUserPaper = PaperUtil.getEffectiveUserPaper(trainingUserPaperList, scoreSelect);
            res.put(userId, effectiveUserPaper);
        }
        return res;
    }

    public static TrainingUserPaper getEffectiveUserPaper(List<TrainingUserPaper> trainingUserPaperList, Integer scoreSelect) {
        if (trainingUserPaperList.size() == 1) {
            return trainingUserPaperList.get(0);
        }
        List hasScoreUserPaperList = trainingUserPaperList.stream().filter(trainingUserPaper -> PaperUtil.isHasScore(trainingUserPaper)).collect(Collectors.toList());
        if (hasScoreUserPaperList.size() > 0) {
            if (scoreSelect.equals(0)) {
                return hasScoreUserPaperList.stream().max(Comparator.comparing(TrainingUserPaper::getScore)).get();
            }
            return hasScoreUserPaperList.stream().max(Comparator.comparing(TrainingUserPaper::getCreateTime)).get();
        }
        Optional<TrainingUserPaper> earliestRecord = trainingUserPaperList.stream().min(Comparator.comparing(TrainingUserPaper::getCreateTime));
        return earliestRecord.get();
    }

    public static List<Integer> getPaperPassingUserIdList(Map<Integer, TrainingUserPaper> userPaperMapByUserId) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        userPaperMapByUserId.forEach((userId, trainingUserPaper) -> {
            if (trainingUserPaper.getPassState().equals(1)) {
                res.add((Integer)userId);
            }
        });
        return res;
    }

    public static List<Integer> getPaperPassingUserIdList(Map<Integer, TrainingUserPaper> userPaperMapByUserId, Integer passLineType, Integer passRate, BigDecimal passLineFixScore, BigDecimal examScore) {
        BigDecimal finalPassScore = PaperUtil.getPassScore(passLineType, passRate, passLineFixScore, examScore);
        ArrayList<Integer> res = new ArrayList<Integer>();
        userPaperMapByUserId.forEach((userId, trainingUserPaper) -> {
            if (PaperUtil.isHasScore(trainingUserPaper).booleanValue() && trainingUserPaper.getScore().compareTo(finalPassScore) >= 0) {
                res.add((Integer)userId);
            }
        });
        return res;
    }

    public static Boolean isHasScore(TrainingUserPaper trainingUserPaper) {
        if (UserPaperStateEnum.PAPER_END.getDatabaseValue().equals(trainingUserPaper.getPaperStatus()) && trainingUserPaper.getSubmitTime() != null) {
            return true;
        }
        return false;
    }

    public static List<Integer> getPaperPassingUserPaperIdList(List<TrainingUserPaper> trainingUserPapers, Integer passLineType, Integer passRate, BigDecimal passLineFixScore, BigDecimal examScore) {
        BigDecimal finalPassScore = PaperUtil.getPassScore(passLineType, passRate, passLineFixScore, examScore);
        ArrayList<Integer> res = new ArrayList<Integer>();
        trainingUserPapers.forEach(trainingUserPaper -> {
            if (PaperUtil.isHasScore(trainingUserPaper).booleanValue() && trainingUserPaper.getScore().compareTo(finalPassScore) >= 0) {
                res.add(trainingUserPaper.getId());
            }
        });
        return res;
    }

    public static BigDecimal getPassScore(Integer passLineType, Integer passRate, BigDecimal passLineFixScore, BigDecimal examScore) {
        if (1 == passLineType && passLineFixScore != null) {
            return passLineFixScore;
        }
        BigDecimal passScore = examScore.multiply(new BigDecimal(org.springframework.util.StringUtils.isEmpty((Object)passRate) ? 60 : passRate)).divide(new BigDecimal(100), 2, 4);
        return passScore;
    }

    public static Map<Integer, PaperVo> getPaperSituationMap(List<PaperVo> allPaperList, List<TrainingUserPaper> trainingUserPapers, Map<Integer, List<Integer>> paperUserScopeMap) {
        Map<Integer, List<TrainingUserPaper>> trainingUserPaperMapGroupByPaperId = trainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
        HashMap<Integer, PaperVo> res = new HashMap<Integer, PaperVo>();
        allPaperList.forEach(paperVo -> {
            Integer id = paperVo.getId();
            PaperVo paperInfo = new PaperVo();
            paperInfo.setSubmittedParticipants(Integer.valueOf(0));
            paperInfo.setPassedParticipants(Integer.valueOf(0));
            paperInfo.setPassRate(new BigDecimal(0));
            List<Object> submittedUserIds = new ArrayList();
            List<Object> submittedLoginUserIds = new ArrayList();
            if (trainingUserPaperMapGroupByPaperId.containsKey(id)) {
                List trainingUserPaperList = (List)trainingUserPaperMapGroupByPaperId.get(id);
                submittedUserIds = trainingUserPaperList.stream().filter(trainingUserPaper -> trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                submittedLoginUserIds = trainingUserPaperList.stream().filter(trainingUserPaper -> trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getLoginUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Integer submitNum = submittedUserIds != null ? submittedUserIds.size() : 0;
                Integer submitLoginNum = submittedLoginUserIds != null ? submittedLoginUserIds.size() : 0;
                paperInfo.setSubmittedParticipants(Integer.valueOf(submitNum + submitLoginNum));
                List<Integer> passedUserIdList = null;
                List<TrainingUserPaper> userPaperList = trainingUserPaperList.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() != null).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(userPaperList)) {
                    Map<Integer, TrainingUserPaper> effectiveUserPaperByUserId = PaperUtil.getEffectiveUserPaper(userPaperList, paperVo.getScoreSelect(), 0);
                    passedUserIdList = PaperUtil.getPaperPassingUserIdList(effectiveUserPaperByUserId);
                }
                List<Integer> passedLoginUserIdList = null;
                List<TrainingUserPaper> loginUserPaperList = trainingUserPaperList.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() == null && trainingUserPaper.getLoginUserId() != null).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(loginUserPaperList)) {
                    Map<Integer, TrainingUserPaper> effectiveUserPaperByLoginUserId = PaperUtil.getEffectiveUserPaper(loginUserPaperList, paperVo.getScoreSelect(), 1);
                    passedLoginUserIdList = PaperUtil.getPaperPassingUserIdList(effectiveUserPaperByLoginUserId);
                }
                Integer passNum = passedUserIdList != null ? passedUserIdList.size() : 0;
                passNum = passedLoginUserIdList != null ? passNum + passedLoginUserIdList.size() : passNum;
                BigDecimal passRate = passNum.equals(0) ? BigDecimal.ZERO : BigDecimal.valueOf(passNum.intValue()).multiply(new BigDecimal(100)).divide(BigDecimal.valueOf(submitNum.intValue()), 2, 1);
                paperInfo.setPassedParticipants(passNum);
                paperInfo.setPassRate(passRate);
            }
            if (paperUserScopeMap != null) {
                List userScope = new ArrayList();
                if (paperUserScopeMap.containsKey(id)) {
                    userScope = (List)paperUserScopeMap.get(id);
                }
                List<Object> registeredUserIds = new ArrayList(submittedUserIds);
                registeredUserIds.addAll(userScope);
                registeredUserIds = registeredUserIds.stream().distinct().collect(Collectors.toList());
                registeredUserIds.addAll(submittedLoginUserIds);
                paperInfo.setRegisteredParticipants(Integer.valueOf(registeredUserIds != null ? registeredUserIds.size() : 0));
            }
            res.put(id, paperInfo);
        });
        return res;
    }

    public List<PaperManagementExamineeDetailVo> getExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, List<TrainingUserPaper> trainingUserPapers, List<Integer> paperScopeUserIdList, Users user) {
        ArrayList<PaperManagementExamineeDetailVo> res = new ArrayList();
        Integer enterpriseId = paperVo.getEnterpriseId();
        switch (request.getCountType()) {
            case 0: {
                res = this.getEffectivePaperExamineeDetails(request, paperVo, trainingUserPapers, paperScopeUserIdList, enterpriseId, user);
                break;
            }
            case 1: {
                res = this.getAllPaperExamineeDetails(request, paperVo, trainingUserPapers, paperScopeUserIdList, enterpriseId, user);
                break;
            }
            default: {
                res = this.getEffectivePaperExamineeDetails(request, paperVo, trainingUserPapers, paperScopeUserIdList, enterpriseId, user);
            }
        }
        res = res.stream().filter(vo -> request.getUserPaperState() == null || vo.getUserPaperState() != null && vo.getUserPaperState().equals(request.getUserPaperState())).filter(vo -> request.getUserPassState() == null || vo.getUserPassState() != null && vo.getUserPassState().equals(request.getUserPassState())).filter(vo -> request.getUserType() == null || vo.getUserType() != null && vo.getUserType().equals(request.getUserType())).collect(Collectors.toList());
        res = PaperUtil.sortExamineeDetailVoList(res, request.getSortConditions());
        return res;
    }

    public static List<PaperManagementExamineeDetailVo> sortExamineeDetailVoList(List<PaperManagementExamineeDetailVo> list, List<SortCondition> sortConditions) {
        if (sortConditions == null) {
            sortConditions = new ArrayList<SortCondition>();
            SortCondition sortCondition1 = new SortCondition();
            sortCondition1.setField("submitTime");
            sortCondition1.setOrder("desc");
            sortConditions.add(sortCondition1);
            SortCondition sortCondition2 = new SortCondition();
            sortCondition2.setField("joinPaperTime");
            sortCondition2.setOrder("desc");
            sortConditions.add(sortCondition2);
        }
        Comparator<PaperManagementExamineeDetailVo> comparator = null;
        for (SortCondition condition : sortConditions) {
            Comparator<PaperManagementExamineeDetailVo> currentComparator;
            switch (condition.getField()) {
                case "submitTime": {
                    currentComparator = Comparator.comparing(PaperManagementExamineeDetailVo::getSubmitTime, Comparator.nullsLast(Comparator.naturalOrder()));
                    break;
                }
                case "joinPaperTime": {
                    currentComparator = Comparator.comparing(PaperManagementExamineeDetailVo::getJoinPaperTime, Comparator.nullsLast(Comparator.naturalOrder()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown field: " + condition.getField());
                }
            }
            if ("desc".equalsIgnoreCase(condition.getOrder())) {
                currentComparator = currentComparator.reversed();
            }
            if (comparator == null) {
                comparator = currentComparator;
                continue;
            }
            comparator = comparator.thenComparing(currentComparator);
        }
        if (comparator == null) {
            return list;
        }
        return list.stream().sorted(comparator).collect(Collectors.toList());
    }

    private List<PaperManagementExamineeDetailVo> getAllPaperExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, List<TrainingUserPaper> trainingUserPapers, List<Integer> paperScopeUserIdList, Integer enterpriseId, Users user) {
        ArrayList<PaperManagementExamineeDetailVo> res = new ArrayList<PaperManagementExamineeDetailVo>();
        if (request.getUserType() == null || request.getUserType() == 0) {
            List submitUserIdList = trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() != null && trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getUserId).collect(Collectors.toList());
            ArrayList userIdList = new ArrayList(submitUserIdList);
            if (paperScopeUserIdList != null) {
                userIdList.addAll(paperScopeUserIdList);
            }
            List<Integer> allEnterpriseUserIdList = userIdList.stream().distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)request.getOrganizeIdList()) || !org.springframework.util.StringUtils.isEmpty((Object)request.getUserName())) {
                Map<String, Object> userMap = this.userUtilService.getCheckParameters(request.getUserName(), null, request.getOrganizeIdList(), user);
                List idList = (List)userMap.get("userList");
                allEnterpriseUserIdList.retainAll(idList);
            }
            List enterpriseUserTrainingUserPapers = trainingUserPapers.stream().filter(trainingUserPaper -> allEnterpriseUserIdList.contains(trainingUserPaper.getUserId())).collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> userPaperGroupByUserId = enterpriseUserTrainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            List paperPassingUserPaperIdList = enterpriseUserTrainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getPassState().equals(1)).map(TrainingUserPaper::getId).collect(Collectors.toList());
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(allEnterpriseUserIdList);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(allEnterpriseUserIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(allEnterpriseUserIdList, (String)","));
                parameter.put("groupId", enterpriseId);
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            HashMap finalUserRoleMap = userRoleMap;
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allEnterpriseUserIdList, enterpriseId);
            allEnterpriseUserIdList.forEach(userId -> {
                if (userPaperGroupByUserId.containsKey(userId)) {
                    List userPaperList = (List)userPaperGroupByUserId.get(userId);
                    int size = userPaperList.size();
                    userPaperList.forEach(trainingUserPaper -> {
                        PaperManagementExamineeDetailVo vo = new PaperManagementExamineeDetailVo();
                        vo.setUserId(userId);
                        vo.setUserType(Integer.valueOf(0));
                        Boolean isPass = paperPassingUserPaperIdList.contains(trainingUserPaper.getId());
                        PaperUtil.handleManagementExamineeDetail(vo, trainingUserPaper, paperVo, isPass, size);
                        PaperUtil.fillRolePostParentEntUser(userOrganizeMap, usersPojoMap, finalUserRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                        res.add(vo);
                    });
                } else {
                    PaperManagementExamineeDetailVo vo = new PaperManagementExamineeDetailVo();
                    vo.setUserId(userId);
                    vo.setUserType(Integer.valueOf(0));
                    vo.setUserPaperState(UserPaperStateEnum.NO_START.getFrontEndValuee());
                    vo.setTakePaperNum(Integer.valueOf(0));
                    PaperUtil.fillRolePostParentEntUser(userOrganizeMap, usersPojoMap, finalUserRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                    res.add(vo);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)request.getOrganizeIdList()) && (request.getUserType() == null || request.getUserType() == 1)) {
            List<Integer> submitVisitorIds = trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() == null && trainingUserPaper.getLoginUserId() != null && trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getLoginUserId).distinct().collect(Collectors.toList());
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getUserName())) {
                List<Integer> visitorByName = this.trainingPaperService.getVisitorByName(request.getUserName());
                submitVisitorIds.retainAll(visitorByName);
            }
            List visitorTrainingUserPapers = trainingUserPapers.stream().filter(trainingUserPaper -> submitVisitorIds.contains(trainingUserPaper.getLoginUserId())).collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> visitorPaperGroupByUserId = visitorTrainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getLoginUserId));
            List paperPassingUserPaperIdList = visitorTrainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getPassState().equals(1)).map(TrainingUserPaper::getId).collect(Collectors.toList());
            Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap = this.trainingPaperService.getTrainingLoginUserMap(submitVisitorIds);
            submitVisitorIds.forEach(visitorId -> {
                if (visitorPaperGroupByUserId.containsKey(visitorId)) {
                    List userPaperList = (List)visitorPaperGroupByUserId.get(visitorId);
                    int size = userPaperList.size();
                    userPaperList.forEach(trainingUserPaper -> {
                        PaperManagementExamineeDetailVo vo = new PaperManagementExamineeDetailVo();
                        vo.setUserId(visitorId);
                        vo.setUserType(Integer.valueOf(1));
                        Boolean isPass = paperPassingUserPaperIdList.contains(trainingUserPaper.getId());
                        PaperUtil.handleManagementExamineeDetail(vo, trainingUserPaper, paperVo, isPass, size);
                        PaperUtil.fillRolePostParentVisitor(trainingLoginUserMap, vo);
                        res.add(vo);
                    });
                }
            });
        }
        return res;
    }

    private List<PaperManagementExamineeDetailVo> getEffectivePaperExamineeDetails(ExamineeDetailRequest request, PaperVo paperVo, List<TrainingUserPaper> trainingUserPapers, List<Integer> paperScopeUserIdList, Integer enterpriseId, Users user) {
        ArrayList<PaperManagementExamineeDetailVo> res = new ArrayList<PaperManagementExamineeDetailVo>();
        if (request.getUserType() == null || request.getUserType() == 0) {
            List submitUserIdList = trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() != null && trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getUserId).collect(Collectors.toList());
            ArrayList userIdList = new ArrayList(submitUserIdList);
            if (paperScopeUserIdList != null) {
                userIdList.addAll(paperScopeUserIdList);
            }
            List<Integer> allEnterpriseUserIdList = userIdList.stream().distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)request.getOrganizeIdList()) || !org.springframework.util.StringUtils.isEmpty((Object)request.getUserName())) {
                Map<String, Object> userMap = this.userUtilService.getCheckParameters(request.getUserName(), null, request.getOrganizeIdList(), user);
                List idList = (List)userMap.get("userList");
                allEnterpriseUserIdList.retainAll(idList);
            }
            List<TrainingUserPaper> enterpriseUserTrainingUserPapers = trainingUserPapers.stream().filter(trainingUserPaper -> allEnterpriseUserIdList.contains(trainingUserPaper.getUserId())).collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> groupedUsers = enterpriseUserTrainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getUserId));
            Map<Integer, Integer> groupSizes = groupedUsers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
            Map<Integer, TrainingUserPaper> effectiveUserPaperMap = PaperUtil.getEffectiveUserPaper(enterpriseUserTrainingUserPapers, paperVo.getScoreSelect(), 0);
            List<Integer> paperPassingUserIdList = PaperUtil.getPaperPassingUserIdList(effectiveUserPaperMap);
            Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(allEnterpriseUserIdList);
            Map userRoleMap = new HashMap();
            if (!CollectionUtils.isEmpty(allEnterpriseUserIdList)) {
                HashMap<String, Object> parameter = new HashMap<String, Object>();
                parameter.put("userIds", StringUtils.join(allEnterpriseUserIdList, (String)","));
                parameter.put("groupId", enterpriseId);
                BaseResult base = this.roleApi.getUserRoleList(parameter);
                if (base != null) {
                    userRoleMap = (Map)base.getData();
                }
            }
            HashMap finalUserRoleMap = userRoleMap;
            Map<Integer, UserDutiesMo> dutiesMap = this.userUtilService.selectDutiesMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, String> parentMap = this.userUtilService.selectParentMap(allEnterpriseUserIdList, enterpriseId);
            Map<Integer, Integer> parentIdMap = this.userUtilService.selectParentIdMap(allEnterpriseUserIdList, enterpriseId);
            allEnterpriseUserIdList.forEach(userId -> {
                PaperManagementExamineeDetailVo vo = new PaperManagementExamineeDetailVo();
                vo.setUserId(userId);
                vo.setUserType(Integer.valueOf(0));
                if (effectiveUserPaperMap.containsKey(userId)) {
                    TrainingUserPaper effectiveUserPaper = (TrainingUserPaper)effectiveUserPaperMap.get(userId);
                    Boolean isPass = paperPassingUserIdList.contains(userId);
                    Integer size = (Integer)groupSizes.get(userId);
                    PaperUtil.handleManagementExamineeDetail(vo, effectiveUserPaper, paperVo, isPass, size);
                } else {
                    vo.setUserPaperState(UserPaperStateEnum.NO_START.getFrontEndValuee());
                    vo.setTakePaperNum(Integer.valueOf(0));
                }
                PaperUtil.fillRolePostParentEntUser(userOrganizeMap, usersPojoMap, finalUserRoleMap, dutiesMap, parentMap, parentIdMap, vo);
                res.add(vo);
            });
        }
        if (CollectionUtils.isEmpty((Collection)request.getOrganizeIdList()) && (request.getUserType() == null || request.getUserType() == 1)) {
            List<Integer> submitVisitorIds = trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() == null && trainingUserPaper.getLoginUserId() != null && trainingUserPaper.getSubmitTime() != null).map(TrainingUserPaper::getLoginUserId).distinct().collect(Collectors.toList());
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getUserName())) {
                List<Integer> visitorByName = this.trainingPaperService.getVisitorByName(request.getUserName());
                submitVisitorIds.retainAll(visitorByName);
            }
            List<TrainingUserPaper> visitorTrainingUserPapers = trainingUserPapers.stream().filter(trainingUserPaper -> submitVisitorIds.contains(trainingUserPaper.getLoginUserId())).collect(Collectors.toList());
            Map<Integer, List<TrainingUserPaper>> groupedUsers = visitorTrainingUserPapers.stream().collect(Collectors.groupingBy(TrainingUserPaper::getLoginUserId));
            Map<Integer, Integer> groupSizes = groupedUsers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
            Map<Integer, TrainingUserPaper> effectiveUserPaperMap = PaperUtil.getEffectiveUserPaper(visitorTrainingUserPapers, paperVo.getScoreSelect(), 1);
            List<Integer> paperPassingUserIdList = PaperUtil.getPaperPassingUserIdList(effectiveUserPaperMap);
            Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap = this.trainingPaperService.getTrainingLoginUserMap(submitVisitorIds);
            submitVisitorIds.forEach(visitorId -> {
                PaperManagementExamineeDetailVo vo = new PaperManagementExamineeDetailVo();
                vo.setUserId(visitorId);
                vo.setUserType(Integer.valueOf(1));
                if (effectiveUserPaperMap.containsKey(visitorId)) {
                    TrainingUserPaper effectiveUserPaper = (TrainingUserPaper)effectiveUserPaperMap.get(visitorId);
                    Boolean isPass = paperPassingUserIdList.contains(visitorId);
                    Integer size = (Integer)groupSizes.get(visitorId);
                    PaperUtil.handleManagementExamineeDetail(vo, effectiveUserPaper, paperVo, isPass, size);
                    PaperUtil.fillRolePostParentVisitor(trainingLoginUserMap, vo);
                }
                res.add(vo);
            });
        }
        return res;
    }

    private static void handleManagementExamineeDetail(PaperManagementExamineeDetailVo vo, TrainingUserPaper trainingUserPaper, PaperVo paperVo, Boolean isPass, Integer takePaperNum) {
        vo.setUserPaperState(UserPaperStateEnum.getFrontEndValueByDatabaseValue((Integer)trainingUserPaper.getPaperStatus()));
        vo.setStartTime(trainingUserPaper.getCreateTime());
        vo.setSubmitTime(trainingUserPaper.getSubmitTime());
        if (trainingUserPaper.getCreateTime() != null && trainingUserPaper.getSubmitTime() != null) {
            String dateDifferenceString = DateUtils.getDateDifferenceString(trainingUserPaper.getCreateTime(), trainingUserPaper.getSubmitTime());
            vo.setAnswerTime(dateDifferenceString);
        }
        vo.setScore(trainingUserPaper.getScore());
        vo.setCutScreenCount(trainingUserPaper.getScreenNum());
        vo.setUserPassState(Integer.valueOf(isPass != false ? 1 : 0));
        vo.setTakePaperNum(takePaperNum);
        vo.setShiftName(paperVo.getShiftName());
        vo.setShiftId(paperVo.getShiftId());
        vo.setUserPaperId(trainingUserPaper.getId());
    }

    private static void fillRolePostParentVisitor(Map<Integer, List<TrainingLoginUser>> trainingLoginUserMap, PaperManagementExamineeDetailVo vo) {
        if (!ObjectUtils.isEmpty(trainingLoginUserMap)) {
            List<TrainingLoginUser> trainingLoginUserList = trainingLoginUserMap.get(vo.getUserId());
            TrainingLoginUser trainingLoginUser = CollectionUtils.isEmpty(trainingLoginUserList) ? new TrainingLoginUser() : trainingLoginUserList.get(0);
            vo.setUserName(trainingLoginUser.getShowName());
            vo.setPost(trainingLoginUser.getPostName());
            vo.setUserNumber(trainingLoginUser.getEmployeeNumber());
            vo.setDeptName(trainingLoginUser.getDepartment());
        }
    }

    private static void fillRolePostParentEntUser(Map<Integer, List<String>> userOrganizeMap, Map<Integer, UsersPojo> usersPojoMap, Map<Integer, List<RolePojo>> userRoleMap, Map<Integer, UserDutiesMo> dutiesMap, Map<Integer, String> parentMap, Map<Integer, Integer> parentIdMap, PaperManagementExamineeDetailVo vo) {
        if (!ObjectUtils.isEmpty(usersPojoMap)) {
            UsersPojo usersPojo = usersPojoMap.get(vo.getUserId());
            vo.setUserName(usersPojo.getShowName());
            vo.setUserNumber(usersPojo.getEmployeeNumber());
            vo.setUserAccount(usersPojo.getUserName());
        }
        if (!ObjectUtils.isEmpty(userRoleMap) && !CollectionUtils.isEmpty((Collection)userRoleMap.get(vo.getUserId()))) {
            StringBuilder role = new StringBuilder();
            for (RolePojo rolePojo : userRoleMap.get(vo.getUserId())) {
                role.append(rolePojo.getRoleName()).append(";\n");
            }
            vo.setRole(role.substring(0, role.length() - 2));
        }
        if (!ObjectUtils.isEmpty(dutiesMap) && dutiesMap.get(vo.getUserId()) != null) {
            vo.setPost(dutiesMap.get(vo.getUserId()).getDutieName());
        }
        if (!ObjectUtils.isEmpty(userOrganizeMap)) {
            List<String> userStr = userOrganizeMap.get(vo.getUserId());
            vo.setDeptName(CollectionUtils.isEmpty(userStr) ? "" : userStr.get(0));
        }
        if (!ObjectUtils.isEmpty(parentMap)) {
            vo.setParentName(parentMap.get(vo.getUserId()));
        }
        if (!ObjectUtils.isEmpty(parentIdMap)) {
            vo.setParentUserId(parentIdMap.get(vo.getUserId()));
        }
    }

    public Integer copyPaper(Integer oldPaperId, Integer projectShow, Integer projectId, Integer taskId, Integer shiftId, Integer isDel) {
        TrainingPaper oldPaper = (TrainingPaper)this.trainingPaperMapper.selectById(oldPaperId);
        TrainingPaper newPaper = new TrainingPaper();
        BeanUtils.copyProperties((Object)oldPaper, (Object)newPaper);
        newPaper.setId(null);
        newPaper.setProjectShow(projectShow);
        newPaper.setProjectId(projectId);
        newPaper.setShiftId(shiftId);
        newPaper.setIsDel(isDel);
        this.trainingPaperMapper.insert(newPaper);
        Integer newPaperId = newPaper.getId();
        if (oldPaper.getReviewerType() == 4) {
            LambdaQueryWrapper trainingExaminerLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingExaminerLambdaQueryWrapper.eq(TrainingExaminer::getTrainingPaperId, (Object)oldPaperId);
            trainingExaminerLambdaQueryWrapper.eq(TrainingExaminer::getEnterpriseId, (Object)oldPaper.getEnterpriseId());
            List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)trainingExaminerLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                ArrayList<TrainingExaminer> examList = new ArrayList<TrainingExaminer>();
                for (TrainingExaminer trainingExaminer : trainingExaminerList) {
                    TrainingExaminer exam = new TrainingExaminer();
                    exam.setTrainingPaperId(newPaperId);
                    exam.setUserId(trainingExaminer.getUserId());
                    exam.setEnterpriseId(newPaper.getEnterpriseId());
                    examList.add(exam);
                }
                this.trainingExaminerMapper.insertList(examList);
            }
        }
        LambdaQueryWrapper paperUserWrapper = new LambdaQueryWrapper();
        paperUserWrapper.eq(TrainingPaperUser::getPaperId, (Object)oldPaperId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)paperUserWrapper);
        if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
            ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
            for (TrainingPaperUser paperUser : paperUserList) {
                paperUser.setId(null);
                paperUser.setEnterpriseId(paperUser.getEnterpriseId());
                paperUser.setPaperId(newPaperId);
                paperUsers.add(paperUser);
            }
            this.trainingPaperUserMapper.insertList(paperUsers);
        }
        return newPaperId;
    }
}

