/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.mapper.permission.UnitMapper;
import com.ovopark.training.model.TrainingMaterialPowerUser;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.material.UnitGroup;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.util.EnterpriseUtils;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnitServiceImpl
implements UnitService {
    private static final Logger log = LoggerFactory.getLogger(UnitServiceImpl.class);
    @Autowired
    private UnitMapper unitMapper;
    @Autowired
    private UserUtilService userUtilService;

    @Override
    public List<UnitDO> insertByUnitGroup(Integer enterpriseId, UnitGroup unitGroup) {
        if (unitGroup == null) {
            return Collections.emptyList();
        }
        EnterpriseUtils.assertIdValid(enterpriseId);
        ArrayList resultList = Lists.newArrayList();
        this.processList(unitGroup.getUserIds(), resultList, 1);
        this.processList(unitGroup.getTagIds(), resultList, 2);
        this.processList(unitGroup.getRoleIds(), resultList, 3);
        this.processList(unitGroup.getOrganizeIds(), resultList, 4);
        this.processList(unitGroup.getConstantIds(), resultList, 9);
        for (UnitDO unitDO : resultList) {
            unitDO.setEnterpriseId(enterpriseId);
            this.insert(unitDO);
        }
        return resultList;
    }

    @Override
    public UnitDO insertByPowerUser(TrainingMaterialPowerUser powerUser) {
        UnitDO unitDO = new UnitDO();
        unitDO.setBizId(powerUser.getUserId());
        Integer type = powerUser.getType();
        if (type == 5) {
            type = 1;
        } else if (type == 3) {
            type = 2;
        } else if (type == 2) {
            type = 3;
        }
        unitDO.setBizType(type);
        Integer enterpriseId = powerUser.getEnterpriseId();
        unitDO.setEnterpriseId(enterpriseId);
        this.insert(unitDO);
        return unitDO;
    }

    @Override
    public Long getIdByBizIdAndType(String bizId, int type, Integer groupId) {
        UnitDO unitDO = new UnitDO();
        unitDO.setBizId(bizId);
        unitDO.setBizType(Integer.valueOf(type));
        unitDO.setEnterpriseId(groupId);
        this.insertByUnit(unitDO);
        return unitDO.getId();
    }

    private long insert(UnitDO unitDO) {
        if (unitDO.getBizId() == null) {
            throw new IllegalArgumentException("bizId can not be null");
        }
        if (unitDO.getBizType() == null) {
            throw new IllegalArgumentException("bizType can not be null");
        }
        EnterpriseUtils.assertIdValid(unitDO.getEnterpriseId());
        LambdaQueryWrapper unitQuery = new LambdaQueryWrapper();
        unitQuery.eq(UnitDO::getBizType, (Object)unitDO.getBizType());
        unitQuery.eq(UnitDO::getEnterpriseId, (Object)unitDO.getEnterpriseId());
        unitQuery.eq(UnitDO::getBizId, (Object)unitDO.getBizId());
        UnitDO queryUnitDO = (UnitDO)this.unitMapper.selectOne((Wrapper)unitQuery);
        if (queryUnitDO != null) {
            unitDO.setId(queryUnitDO.getId());
            return queryUnitDO.getId();
        }
        log.info("insert unitDO:{}", (Object)unitDO);
        this.unitMapper.insertIgnore(unitDO);
        if (unitDO.getId() != null) {
            return unitDO.getId();
        }
        queryUnitDO = (UnitDO)this.unitMapper.selectOne((Wrapper)unitQuery);
        unitDO.setId(queryUnitDO.getId());
        return queryUnitDO.getId();
    }

    @Override
    public List<Long> getIdListByUserId(int userId) {
        return this.getListByUserId(userId).stream().map(UnitDO::getId).collect(Collectors.toList());
    }

    private List<UnitDO> getListByUserId(int userId) {
        List<String> organizeList;
        List<Integer> tagList;
        ArrayList resultList = Lists.newArrayList();
        UsersPojo usersPojo = this.userUtilService.selectUser(userId);
        Users user = new Users();
        user.setId(Integer.valueOf(userId));
        user.setGroupId(usersPojo.getGroupId());
        Integer groupId = user.getGroupId();
        if (groupId == null) {
            log.warn("groupId is null");
            return Lists.newArrayList();
        }
        LambdaQueryWrapper userQuery = new LambdaQueryWrapper();
        userQuery.eq(UnitDO::getBizId, (Object)String.valueOf(userId));
        userQuery.eq(UnitDO::getBizType, (Object)1);
        userQuery.eq(UnitDO::getEnterpriseId, (Object)groupId);
        UnitDO unitDO = (UnitDO)this.unitMapper.selectOne((Wrapper)userQuery);
        if (unitDO == null) {
            unitDO = UnitServiceImpl.createUnit(1, String.valueOf(userId), groupId);
            this.insert(unitDO);
        }
        resultList.add(unitDO);
        resultList.add(this.getConstAllUnit(groupId));
        List<Integer> roleList = this.userUtilService.selectUserRoleList(user);
        if (CollectionUtils.isNotEmpty(roleList)) {
            resultList.addAll(this.getUnitListByBizList(3, roleList.stream().map(String::valueOf).collect(Collectors.toList()), groupId));
        }
        if (CollectionUtils.isNotEmpty(tagList = this.userUtilService.selectUserTagList(user))) {
            resultList.addAll(this.getUnitListByBizList(2, tagList.stream().map(String::valueOf).collect(Collectors.toList()), groupId));
        }
        if (CollectionUtils.isNotEmpty(organizeList = this.userUtilService.selectUserOrganizeList(user))) {
            resultList.addAll(this.getUnitListByBizList(4, organizeList, groupId));
        }
        return resultList;
    }

    private UnitDO getConstAllUnit(Integer groupId) {
        UnitDO unitDO = new UnitDO();
        unitDO.setBizId("1");
        unitDO.setBizType(Integer.valueOf(9));
        unitDO.setEnterpriseId(groupId);
        this.insert(unitDO);
        return unitDO;
    }

    @Override
    public List<UnitDO> getListById(List<Long> unitIdList) {
        if (CollectionUtils.isEmpty(unitIdList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper tagQuery = new LambdaQueryWrapper();
        tagQuery.in(UnitDO::getId, unitIdList);
        return this.unitMapper.selectList((Wrapper)tagQuery);
    }

    @Override
    public List<UnitShowVo> getShowListByUnitList(List<UnitDO> unitList) {
        if (CollectionUtils.isEmpty(unitList)) {
            return Lists.newArrayList();
        }
        ArrayList userIdList = Lists.newArrayList();
        ArrayList role = Lists.newArrayList();
        ArrayList tag = Lists.newArrayList();
        ArrayList org = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        HashMap bizUnitIdMap = Maps.newHashMap();
        for (UnitDO unitDO : unitList) {
            Integer bizType = unitDO.getBizType();
            if (bizType == 1) {
                userIdList.add(unitDO.getBizId());
            } else if (bizType == 3) {
                role.add(unitDO.getBizId());
            } else if (bizType == 2) {
                tag.add(unitDO.getBizId());
            } else if (bizType == 4) {
                org.add(unitDO.getBizId());
            } else if (bizType == 9) {
                UnitShowVo view;
                if (StringUtils.equals((CharSequence)unitDO.getBizId(), (CharSequence)"1")) {
                    view = this.buildConstantUnitShowView("1", 6, unitDO.getId());
                    result.add(view);
                } else {
                    view = this.buildConstantUnitShowView("1", 6, unitDO.getId());
                    result.add(view);
                }
            }
            bizUnitIdMap.put(bizType + "-" + unitDO.getBizId(), unitDO.getId());
        }
        List<UnitShowVo> showList = this.userUtilService.getAllUserTypeData(userIdList, role, tag, org, ContextUtil.getEnterpriseId());
        for (UnitShowVo unitShowVo : showList) {
            String key = unitShowVo.getUnitType() + "-" + unitShowVo.getId();
            unitShowVo.setUnitId(bizUnitIdMap.getOrDefault(key, 0L).longValue());
        }
        result.addAll(showList);
        return result;
    }

    private UnitShowVo buildConstantUnitShowView(String bizId, int type, long unitId) {
        UnitShowVo view = new UnitShowVo();
        view.setId(bizId);
        view.setUnitType(9);
        view.setType(type);
        view.setName("");
        view.setUnitId(unitId);
        return view;
    }

    @Override
    public UnitDO insertByUnit(UnitDO unitDO) {
        this.insert(unitDO);
        return unitDO;
    }

    private UnitDO insertByUserId(Integer userId, Integer enterpriseId) {
        EnterpriseUtils.assertIdValid(enterpriseId);
        UnitDO unitDO = new UnitDO();
        unitDO.setBizId(String.valueOf(userId));
        unitDO.setBizType(Integer.valueOf(1));
        unitDO.setEnterpriseId(enterpriseId);
        return this.insertByUnit(unitDO);
    }

    @Override
    public Long getUnitIdByUserId(Integer userId, Integer enterpriseId) {
        return this.insertByUserId(userId, enterpriseId).getId();
    }

    @Override
    public Map<Long, UnitShowVo> getShowMap(List<Long> unitIdList) {
        List<UnitDO> list = this.getListById(unitIdList);
        List<UnitShowVo> showList = this.getShowListByUnitList(list);
        return showList.stream().collect(Collectors.toMap(UnitShowVo::getUnitId, v -> v, (v1, v2) -> v1));
    }

    @Override
    public List<Integer> getAllUserIdByUnitIdList(List<Long> unitIdList, Integer groupId) {
        if (CollectionUtils.isEmpty(unitIdList)) {
            return Lists.newArrayList();
        }
        List<UnitDO> unitDOList = this.getListById(unitIdList);
        ArrayList userIdList = Lists.newArrayList();
        ArrayList role = Lists.newArrayList();
        ArrayList tag = Lists.newArrayList();
        ArrayList org = Lists.newArrayList();
        for (UnitDO unitDO : unitDOList) {
            Integer bizType = unitDO.getBizType();
            if (bizType == 1) {
                userIdList.add(unitDO.getBizId());
                continue;
            }
            if (bizType == 3) {
                role.add(unitDO.getBizId());
                continue;
            }
            if (bizType == 2) {
                tag.add(unitDO.getBizId());
                continue;
            }
            if (bizType == 4) {
                org.add(unitDO.getBizId());
                continue;
            }
            if (bizType != 9 || !StringUtils.equals((CharSequence)unitDO.getBizId(), (CharSequence)"1")) continue;
            return this.userUtilService.getUserListByGroupIdWithCache(unitDO.getEnterpriseId());
        }
        return this.userUtilService.getAllUserId(userIdList, role, tag, org, groupId);
    }

    @Override
    public long getUnitIdByConstantBiz(String constantBiz, Integer enterpriseId) {
        return this.getIdByBizIdAndType(constantBiz, 9, enterpriseId);
    }

    private int batchInsert(List<UnitDO> unitList) {
        if (CollectionUtils.isEmpty(unitList)) {
            return 0;
        }
        return this.unitMapper.batchInsert(unitList);
    }

    private List<UnitDO> getUnitListByBizList(int bizType, List<String> bizList, Integer groupId) {
        LambdaQueryWrapper tagQuery = new LambdaQueryWrapper();
        tagQuery.eq(UnitDO::getBizType, (Object)bizType);
        tagQuery.in(UnitDO::getBizId, bizList);
        tagQuery.eq(UnitDO::getEnterpriseId, (Object)groupId);
        List existList = this.unitMapper.selectList((Wrapper)tagQuery);
        if (existList.size() == bizList.size()) {
            return existList;
        }
        Set existBizIdSet = existList.stream().map(UnitDO::getBizId).collect(Collectors.toSet());
        List<UnitDO> noExistList = bizList.stream().filter(v -> !existBizIdSet.contains(v)).distinct().map(v -> UnitServiceImpl.createUnit(bizType, v, groupId)).collect(Collectors.toList());
        this.batchInsert(noExistList);
        existList.addAll(noExistList);
        return existList;
    }

    private static UnitDO createUnit(int bizType, String bizId, Integer groupId) {
        UnitDO unitDO = new UnitDO();
        unitDO.setBizId(bizId);
        unitDO.setBizType(Integer.valueOf(bizType));
        unitDO.setEnterpriseId(groupId);
        return unitDO;
    }

    private List<UnitDO> processList(List<String> bizIdList, List<UnitDO> resultList, int bizType) {
        if (CollectionUtils.isEmpty(bizIdList)) {
            return resultList;
        }
        for (String bizId : bizIdList) {
            UnitDO unitDO = new UnitDO();
            unitDO.setBizId(bizId);
            unitDO.setBizType(Integer.valueOf(bizType));
            resultList.add(unitDO);
        }
        return resultList;
    }
}

